/*
 * Decompiled with CFR 0.152.
 */
package FrameWorks.Support;

import FrameWorks.Support.Frame;
import FrameWorks.Support.Joint;
import FrameWorks.Support.Member;
import java.io.Serializable;
import java.util.Vector;

public class FrameVector
implements Serializable {
    private Vector frameV = new Vector(0);
    private String fileName = "untitled.frame";
    public static final int METERS = 0;
    public static final int CM = 1;
    public static final int FEET = 2;
    public static final int INCHES = 3;
    public static final int NEWTONS = 4;
    public static final int KILONEWTONS = 5;
    public static final int LBS = 6;
    public static final int KIPS = 7;
    private int lengthUnits = 0;
    private int forceUnits = 4;

    public void add(Joint joint, Joint joint2) {
        this.frameV.addElement(new Frame(this.frameV.size(), joint, joint2));
    }

    public void add(Frame frame) {
        this.frameV.addElement(frame);
    }

    public int size() {
        return this.frameV.size();
    }

    public Frame elementAt(int n) {
        return (Frame)this.frameV.elementAt(n);
    }

    public void removeElementAt(int n) {
        this.frameV.removeElementAt(n);
    }

    public void removeAllElements() {
        this.frameV.removeAllElements();
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String toString() {
        return this.fileName;
    }

    public Joint getJStart(int n) {
        return ((Member)this.frameV.elementAt(n)).getJStart();
    }

    public Joint getJEnd(int n) {
        return ((Member)this.frameV.elementAt(n)).getJEnd();
    }

    public void setLengthUnits(int n) {
        this.lengthUnits = n;
    }

    public int getLengthUnits() {
        return this.lengthUnits;
    }

    public String getLengthUnitsString() {
        switch (this.lengthUnits) {
            case 0: {
                return "meters";
            }
            case 1: {
                return "centimeters";
            }
            case 2: {
                return "feet";
            }
            case 3: {
                return "inches";
            }
        }
        return null;
    }

    public void setForceUnits(int n) {
        this.forceUnits = n;
    }

    public int getForceUnits() {
        return this.forceUnits;
    }

    public String getForceUnitsString() {
        switch (this.forceUnits) {
            case 4: {
                return "newtons";
            }
            case 5: {
                return "kiloNewtons";
            }
            case 6: {
                return "pounds";
            }
            case 7: {
                return "kips";
            }
        }
        return null;
    }

    public void reset() {
        this.frameV.removeAllElements();
        this.fileName = "untitled";
        this.lengthUnits = 0;
        this.forceUnits = 4;
        Frame.reset();
    }
}

