/*
 * Decompiled with CFR 0.152.
 */
package FrameWorks.Support;

import FrameWorks.Support.Joint;
import java.io.Serializable;

public abstract class Member
implements Serializable {
    private int memberID;
    protected Joint jStart;
    protected Joint jEnd;
    private double L;
    protected double sFx = 0.0;
    protected double eFx = 0.0;
    private boolean sMR = false;
    private boolean eMR = false;
    protected static int numberOfMembers = 0;

    public Member() {
        ++numberOfMembers;
    }

    public Member(int n) {
        this();
        this.memberID = n;
    }

    public Member(int n, Joint joint, Joint joint2) {
        this(n);
        this.jStart = joint;
        this.jEnd = joint2;
    }

    public Member(Member member) {
        this(member.memberID, member.jStart, member.jEnd);
    }

    public void setMemberID(int n) {
        this.memberID = n;
    }

    public void setJStart(Joint joint) {
        this.jStart = joint;
    }

    public void setJEnd(Joint joint) {
        this.jEnd = joint;
    }

    public double getL() {
        return Math.sqrt(Math.pow(this.jEnd.getX() - this.jStart.getX(), 2.0) + Math.pow(this.jEnd.getY() - this.jStart.getY(), 2.0) + Math.pow(this.jEnd.getZ() - this.jStart.getZ(), 2.0));
    }

    public void setSFx(double d) {
        this.sFx = d;
    }

    public void setEFx(double d) {
        this.eFx = d;
    }

    public void setSMR(boolean bl) {
        this.sMR = bl;
    }

    public void setEMR(boolean bl) {
        this.eMR = bl;
    }

    public int getMemberID() {
        return this.memberID;
    }

    public Joint getJStart() {
        return this.jStart;
    }

    public Joint getJEnd() {
        return this.jEnd;
    }

    public double getSFx() {
        return this.sFx;
    }

    public double getEFx() {
        return this.eFx;
    }

    public boolean getSMR() {
        return this.sMR;
    }

    public boolean getEMR() {
        return this.eMR;
    }

    public static int getNumberOfMembers() {
        return numberOfMembers;
    }

    public static void reset() {
        numberOfMembers = 0;
        Joint.reset();
    }

    public String toString() {
        return "Member";
    }
}

