/*
 * Decompiled with CFR 0.152.
 */
public class RandomR {
    private double d = this.default_d;
    private int joints = this.default_joints;
    private double[] load = new double[this.joints + 1];
    private int default_d = 10;
    private int default_joints = 5;
    private double min_load = 20.0;
    private double range = 100.0;
    private double chance = 0.5;

    public RandomR() {
        this.computeLoads();
    }

    public RandomR(int n) {
        this();
        this.d = n;
    }

    public RandomR(int n, int n2) {
        this(n);
        this.joints = n2;
        this.load = new double[n2 + 1];
    }

    public double[] getLoads() {
        return this.load;
    }

    public void computeLoads() {
        boolean bl = true;
        int n = 1;
        while (n <= this.joints) {
            if (Math.random() < this.chance) {
                this.load[n] = Math.random() * this.range;
                if (this.load[n] < this.min_load) {
                    this.load[n] = this.min_load;
                }
                bl = false;
            } else {
                this.load[n] = 0.0;
            }
            ++n;
        }
        if (bl) {
            int n2 = (int)(Math.random() * (double)this.joints);
            if (n2 == 0) {
                n2 = 1;
            }
            this.load[n2] = this.min_load;
        }
    }

    public double getReactionA() {
        double d = 0.0;
        double d2 = 0.0;
        int n = 1;
        while (n <= this.joints) {
            d2 += this.load[n] * (double)(this.joints - n + 1) * this.d;
            ++n;
        }
        d = d2 / ((double)(this.joints + 1) * this.d);
        return d;
    }

    public double getReactionB() {
        double d = 0.0;
        double d2 = 0.0;
        int n = 1;
        while (n <= this.joints) {
            d2 += this.load[n] * (double)n * this.d;
            ++n;
        }
        d = d2 / ((double)(this.joints + 1) * this.d);
        return d;
    }

    public double getD() {
        return this.d;
    }

    public double getJoints() {
        return this.joints;
    }
}

