/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;

public class ReactionFrame
extends Frame
implements ActionListener,
ItemListener {
    private CheckboxGroup toleranceG = new CheckboxGroup();
    private Checkbox t10X = new Checkbox("10%", this.toleranceG, false);
    private Checkbox t20X = new Checkbox("20%", this.toleranceG, true);
    private Checkbox t40X = new Checkbox("40%", this.toleranceG, false);
    private Checkbox gridX = new Checkbox("Grid", null, true);
    private Checkbox textX = new Checkbox("Text", null, false);
    private Button resetB = new Button("Reset");
    private Button checkB = new Button("Check Answer");
    private Label leftL = new Label("Ly = 0");
    private Label rightL = new Label("Ry = 0");
    DecimalFormat df = new DecimalFormat("0.00");
    private RandomR randomR;
    double[] loads;
    double fRA;
    double fRB;
    VHead2 head;
    private int radius = 15;
    public static final int CHECK = 0;
    public static final int TRYAGAIN = 1;
    private int mode = 0;
    private int score = 0;
    private int trials = 0;
    private DrawPanel drawPanel = new DrawPanel();
    private BottomPanel bottomPanel = new BottomPanel(this.resetB, this.t10X, this.t20X, this.t40X, this.gridX, this.textX);
    private RightPanel rightPanel = new RightPanel(this.checkB);
    private Button startButton;

    public ReactionFrame(Button button) {
        this.startButton = button;
        this.t10X.addItemListener(this);
        this.t20X.addItemListener(this);
        this.t40X.addItemListener(this);
        this.gridX.addItemListener(this);
        this.textX.addItemListener(this);
        this.checkB.addActionListener(this);
        this.resetB.addActionListener(this);
        this.leftL.setVisible(false);
        this.rightL.setVisible(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.drawPanel, "Center");
        this.add((Component)this.bottomPanel, "South");
        this.add((Component)this.rightPanel, "East");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ReactionFrame.this.dispose();
                System.exit(0);
            }
        });
        ((Component)this).setSize(600, 450);
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.checkB) {
            if (this.mode == 0) {
                this.checkB.setLabel("Try Again");
                this.mode = 1;
                ++this.trials;
                this.drawPanel.checkAnswer();
                this.rightPanel.repaint();
            } else {
                this.drawPanel.tryAgain();
                this.checkB.setLabel("Check Answer");
                this.mode = 0;
            }
        } else if (actionEvent.getSource() == this.resetB) {
            this.drawPanel.tryAgain();
            this.checkB.setLabel("Check Answer");
            this.mode = 0;
            this.trials = 0;
            this.score = 0;
            this.rightPanel.repaint();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.gridX) {
            this.drawPanel.repaint();
        } else if (itemEvent.getSource() == this.textX) {
            if (this.textX.getState()) {
                this.leftL.setVisible(true);
                this.rightL.setVisible(true);
            } else {
                this.leftL.setVisible(false);
                this.rightL.setVisible(false);
            }
            this.drawPanel.repaint();
        } else if (itemEvent.getSource() == this.t10X) {
            this.radius = 7;
            this.drawPanel.repaint();
        } else if (itemEvent.getSource() == this.t20X) {
            this.radius = 15;
            this.drawPanel.repaint();
        } else if (itemEvent.getSource() == this.t40X) {
            this.radius = 30;
            this.drawPanel.repaint();
        }
    }

    public void dispose() {
        super.dispose();
        this.startButton.setEnabled(true);
    }

    public static void main(String[] stringArray) {
        ReactionFrame reactionFrame = new ReactionFrame(new Button("dummyButton"));
    }

    public class RightPanel
    extends Panel {
        TopPanel topPanel;
        BottomPanel bottomPanel;

        public void repaint() {
            this.topPanel.repaint();
        }

        public RightPanel(Button button) {
            this.setBackground(Color.white);
            this.topPanel = new TopPanel();
            this.bottomPanel = new BottomPanel(button);
            this.setLayout(new BorderLayout());
            this.add((Component)this.topPanel, "Center");
            this.add((Component)this.bottomPanel, "South");
        }

        public class BottomPanel
        extends Panel {
            public BottomPanel(Button button) {
                this.add(button);
            }

            public void paint(Graphics graphics) {
                graphics.drawRect(1, 1, this.getSize().width - 2, this.getSize().height - 2);
            }
        }

        public class TopPanel
        extends Panel {
            private Font f2 = new Font("Arial,Helvetica", 0, 9);
            private Font f3 = new Font("Arial,Helvetica", 1, 12);
            private int xo = 37;
            private int yo = 70;
            private int width = 30;

            public void paint(Graphics graphics) {
                graphics.drawRect(1, 1, this.getSize().width - 2, this.getSize().height - 2);
                graphics.drawString("Total", this.xo - 5, this.yo - 30);
                graphics.drawString("Points", this.xo - 5, this.yo - 15);
                graphics.setColor(Color.orange);
                if (ReactionFrame.this.score > 20) {
                    graphics.setColor(Color.yellow);
                }
                if (ReactionFrame.this.score > 50) {
                    graphics.setColor(Color.red);
                }
                graphics.fillRect(this.xo, this.yo + 200 - ReactionFrame.this.score * 2, this.width, ReactionFrame.this.score * 2);
                graphics.setColor(Color.black);
                int n = 0;
                while (n < 200) {
                    graphics.drawRect(this.xo, this.yo + n, this.width, 20);
                    n += 20;
                }
                graphics.setFont(this.f2);
                int n2 = 0;
                while (n2 <= 100) {
                    graphics.drawString("" + (100 - n2), this.xo - 20, this.yo + n2 * 2 + 2);
                    n2 += 10;
                }
                int n3 = 35;
                int n4 = this.getSize().height - 30;
                graphics.setFont(this.f3);
                graphics.drawString("Trials", n3, n4);
                graphics.drawString("" + ReactionFrame.this.trials, n3 + 15, n4 + 15);
            }
        }
    }

    public class BottomPanel
    extends Panel {
        public BottomPanel(Button button, Checkbox checkbox, Checkbox checkbox2, Checkbox checkbox3, Checkbox checkbox4, Checkbox checkbox5) {
            this.setBackground(Color.lightGray);
            this.add(button);
            this.add(new Label("         Tolerance"));
            this.add(checkbox);
            this.add(checkbox2);
            this.add(checkbox3);
            this.add(new Label("    "));
            this.add(checkbox4);
            this.add(checkbox5);
        }

        public void paint(Graphics graphics) {
            graphics.drawRect(1, 1, this.getSize().width - 2, this.getSize().height - 2);
        }
    }

    public class DrawPanel
    extends Panel
    implements MouseListener,
    MouseMotionListener {
        private Point[] joint;
        double[] loads;
        private boolean leftCircle = false;
        private boolean rightCircle = false;
        private int oldLy = 0;
        private int oldRy = 0;

        public DrawPanel() {
            this.setBackground(Color.white);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            ReactionFrame.this.randomR = new RandomR();
            this.loads = ReactionFrame.this.randomR.getLoads();
            ReactionFrame.this.fRA = ReactionFrame.this.randomR.getReactionA();
            ReactionFrame.this.fRB = ReactionFrame.this.randomR.getReactionB();
            this.setLayout(null);
            this.add(ReactionFrame.this.leftL);
            ReactionFrame.this.leftL.setBounds(this.VX(0) - 35, 280, 60, 20);
            this.add(ReactionFrame.this.rightL);
            ReactionFrame.this.rightL.setBounds(this.VX(300) - 25, 280, 60, 20);
        }

        public void paint(Graphics graphics) {
            int n;
            int n2;
            graphics.drawRect(1, 1, this.getSize().width - 2, this.getSize().height - 2);
            if (ReactionFrame.this.gridX.getState()) {
                graphics.setColor(Color.orange);
                n2 = -50;
                while (n2 <= 350) {
                    graphics.drawLine(this.VX(n2), this.VY(-100), this.VX(n2), this.VY(200));
                    n2 += 10;
                }
                n = -100;
                while (n <= 200) {
                    graphics.drawLine(this.VX(-50), this.VY(n), this.VX(350), this.VY(n));
                    n += 10;
                }
            }
            this.createJointCoord();
            graphics.setColor(Color.black);
            n2 = 1;
            n = 2;
            graphics.drawLine(this.VX(this.joint[n2].getX()), this.VY(this.joint[n2].getY()), this.VX(this.joint[n].getX()), this.VY(this.joint[n].getY()));
            n2 = 2;
            n = 3;
            graphics.drawLine(this.VX(this.joint[n2].getX()), this.VY(this.joint[n2].getY()), this.VX(this.joint[n].getX()), this.VY(this.joint[n].getY()));
            n2 = 3;
            n = 4;
            graphics.drawLine(this.VX(this.joint[n2].getX()), this.VY(this.joint[n2].getY()), this.VX(this.joint[n].getX()), this.VY(this.joint[n].getY()));
            n2 = 4;
            n = 5;
            graphics.drawLine(this.VX(this.joint[n2].getX()), this.VY(this.joint[n2].getY()), this.VX(this.joint[n].getX()), this.VY(this.joint[n].getY()));
            n2 = 5;
            n = 6;
            graphics.drawLine(this.VX(this.joint[n2].getX()), this.VY(this.joint[n2].getY()), this.VX(this.joint[n].getX()), this.VY(this.joint[n].getY()));
            n2 = 6;
            n = 7;
            graphics.drawLine(this.VX(this.joint[n2].getX()), this.VY(this.joint[n2].getY()), this.VX(this.joint[n].getX()), this.VY(this.joint[n].getY()));
            n2 = 7;
            n = 8;
            graphics.drawLine(this.VX(this.joint[n2].getX()), this.VY(this.joint[n2].getY()), this.VX(this.joint[n].getX()), this.VY(this.joint[n].getY()));
            n2 = 8;
            n = 9;
            graphics.drawLine(this.VX(this.joint[n2].getX()), this.VY(this.joint[n2].getY()), this.VX(this.joint[n].getX()), this.VY(this.joint[n].getY()));
            n2 = 9;
            n = 10;
            graphics.drawLine(this.VX(this.joint[n2].getX()), this.VY(this.joint[n2].getY()), this.VX(this.joint[n].getX()), this.VY(this.joint[n].getY()));
            n2 = 10;
            n = 11;
            graphics.drawLine(this.VX(this.joint[n2].getX()), this.VY(this.joint[n2].getY()), this.VX(this.joint[n].getX()), this.VY(this.joint[n].getY()));
            n2 = 11;
            n = 12;
            graphics.drawLine(this.VX(this.joint[n2].getX()), this.VY(this.joint[n2].getY()), this.VX(this.joint[n].getX()), this.VY(this.joint[n].getY()));
            n2 = 12;
            n = 1;
            graphics.drawLine(this.VX(this.joint[n2].getX()), this.VY(this.joint[n2].getY()), this.VX(this.joint[n].getX()), this.VY(this.joint[n].getY()));
            n2 = 2;
            n = 12;
            graphics.drawLine(this.VX(this.joint[n2].getX()), this.VY(this.joint[n2].getY()), this.VX(this.joint[n].getX()), this.VY(this.joint[n].getY()));
            n2 = 12;
            n = 3;
            graphics.drawLine(this.VX(this.joint[n2].getX()), this.VY(this.joint[n2].getY()), this.VX(this.joint[n].getX()), this.VY(this.joint[n].getY()));
            n2 = 11;
            n = 3;
            graphics.drawLine(this.VX(this.joint[n2].getX()), this.VY(this.joint[n2].getY()), this.VX(this.joint[n].getX()), this.VY(this.joint[n].getY()));
            n2 = 3;
            n = 10;
            graphics.drawLine(this.VX(this.joint[n2].getX()), this.VY(this.joint[n2].getY()), this.VX(this.joint[n].getX()), this.VY(this.joint[n].getY()));
            n2 = 10;
            n = 4;
            graphics.drawLine(this.VX(this.joint[n2].getX()), this.VY(this.joint[n2].getY()), this.VX(this.joint[n].getX()), this.VY(this.joint[n].getY()));
            n2 = 10;
            n = 5;
            graphics.drawLine(this.VX(this.joint[n2].getX()), this.VY(this.joint[n2].getY()), this.VX(this.joint[n].getX()), this.VY(this.joint[n].getY()));
            n2 = 9;
            n = 5;
            graphics.drawLine(this.VX(this.joint[n2].getX()), this.VY(this.joint[n2].getY()), this.VX(this.joint[n].getX()), this.VY(this.joint[n].getY()));
            n2 = 5;
            n = 8;
            graphics.drawLine(this.VX(this.joint[n2].getX()), this.VY(this.joint[n2].getY()), this.VX(this.joint[n].getX()), this.VY(this.joint[n].getY()));
            n2 = 8;
            n = 6;
            graphics.drawLine(this.VX(this.joint[n2].getX()), this.VY(this.joint[n2].getY()), this.VX(this.joint[n].getX()), this.VY(this.joint[n].getY()));
            int n3 = 1;
            while (n3 <= 12) {
                graphics.fillOval(this.VX(this.joint[n3].getX()) - 3, this.VY(this.joint[n3].getY()) - 3, 6, 6);
                ++n3;
            }
            graphics.drawLine(this.VX(0), this.VY(0), this.VX(0) - 5, this.VY(0) + 15);
            graphics.drawLine(this.VX(0) - 5, this.VY(0) + 15, this.VX(0) + 5, this.VY(0) + 15);
            graphics.drawLine(this.VX(0) + 5, this.VY(0) + 15, this.VX(0), this.VY(0));
            graphics.fillRect(this.VX(0) - 15, this.VY(0) + 15, 30, 5);
            graphics.drawOval(this.VX(0) + 300 - 7, this.VY(0), 15, 15);
            graphics.fillRect(this.VX(0) - 15 + 300, this.VY(0) + 15, 30, 5);
            int n4 = 1;
            int n5 = 50;
            while (n5 <= 250) {
                if (this.loads[n4] != 0.0) {
                    graphics.drawLine(this.VX(n5), this.VY(0), this.VX(n5), this.VY(0) + (int)this.loads[n4]);
                    ReactionFrame.this.head = new VHead2(1.0, this.VX(n5), this.VY(0), this.VX(n5), this.VY(0) + (int)this.loads[n4]);
                    graphics.fillPolygon(ReactionFrame.this.head.xpoints(), ReactionFrame.this.head.ypoints(), ReactionFrame.this.head.npoints());
                    if (ReactionFrame.this.textX.getState()) {
                        graphics.drawString("" + ReactionFrame.this.df.format(this.loads[n4]), this.VX(n5) - 20, this.VY(0) + (int)this.loads[n4] + 15);
                    }
                }
                ++n4;
                n5 += 50;
            }
            graphics.setXORMode(Color.white);
            graphics.drawLine(this.VX(0), this.VY(0), this.VX(0), this.VY(this.oldLy));
            ReactionFrame.this.head = new VHead2(1.0, this.VX(0), this.VY(0), this.VX(0), this.VY(this.oldLy));
            graphics.fillPolygon(ReactionFrame.this.head.xpoints(), ReactionFrame.this.head.ypoints(), ReactionFrame.this.head.npoints());
            graphics.drawLine(this.VX(300), this.VY(0), this.VX(300), this.VY(this.oldRy));
            ReactionFrame.this.head = new VHead2(1.0, this.VX(300), this.VY(0), this.VX(300), this.VY(this.oldRy));
            graphics.fillPolygon(ReactionFrame.this.head.xpoints(), ReactionFrame.this.head.ypoints(), ReactionFrame.this.head.npoints());
            graphics.drawOval(this.VX(0) - ReactionFrame.this.radius, this.VY(this.oldLy) - ReactionFrame.this.radius, ReactionFrame.this.radius * 2, ReactionFrame.this.radius * 2);
            graphics.drawOval(this.VX(300) - ReactionFrame.this.radius, this.VY(this.oldRy) - ReactionFrame.this.radius, ReactionFrame.this.radius * 2, ReactionFrame.this.radius * 2);
            if (ReactionFrame.this.mode == 1) {
                graphics = this.getGraphics();
                graphics.setColor(Color.red);
                graphics.drawLine(this.VX(0), this.VY(0), this.VX(0), this.VY((int)ReactionFrame.this.fRA));
                ReactionFrame.this.head = new VHead2(1.0, this.VX(0), this.VY(0), this.VX(0), this.VY((int)ReactionFrame.this.fRA));
                graphics.fillPolygon(ReactionFrame.this.head.xpoints(), ReactionFrame.this.head.ypoints(), ReactionFrame.this.head.npoints());
                graphics.drawLine(this.VX(300), this.VY(0), this.VX(300), this.VY((int)ReactionFrame.this.fRB));
                ReactionFrame.this.head = new VHead2(1.0, this.VX(300), this.VY(0), this.VX(300), this.VY((int)ReactionFrame.this.fRB));
                graphics.fillPolygon(ReactionFrame.this.head.xpoints(), ReactionFrame.this.head.ypoints(), ReactionFrame.this.head.npoints());
                if (ReactionFrame.this.textX.getState()) {
                    graphics.setFont(new Font("Arial,Helvetica", 1, 13));
                    graphics.drawString("Correct Reaction on  Left Support, Ly  = " + ReactionFrame.this.df.format(ReactionFrame.this.fRA), this.VX(25), this.VY(150));
                    graphics.drawString("Correct Reaction on Right Support, Ry  = " + ReactionFrame.this.df.format(ReactionFrame.this.fRB), this.VX(25), this.VY(130));
                }
            }
        }

        public int VX(int n) {
            return n + 100;
        }

        public int VY(int n) {
            return this.getSize().height - n - 125;
        }

        public int Y(int n) {
            return this.getSize().height - n - 125;
        }

        public void createJointCoord() {
            this.joint = new Point[13];
            this.joint[1] = new Point(0, 0);
            this.joint[2] = new Point(50, 0);
            this.joint[3] = new Point(100, 0);
            this.joint[4] = new Point(150, 0);
            this.joint[5] = new Point(200, 0);
            this.joint[6] = new Point(250, 0);
            this.joint[7] = new Point(300, 0);
            this.joint[8] = new Point(250, 50);
            this.joint[9] = new Point(200, 50);
            this.joint[10] = new Point(150, 50);
            this.joint[11] = new Point(100, 50);
            this.joint[12] = new Point(50, 50);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.leftCircle = false;
            this.rightCircle = false;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (Math.sqrt((this.VX(0) - mouseEvent.getX()) * (this.VX(0) - mouseEvent.getX()) + (this.VY(this.oldLy) - mouseEvent.getY()) * (this.VY(this.oldLy) - mouseEvent.getY())) < (double)ReactionFrame.this.radius) {
                this.leftCircle = true;
            }
            if (Math.sqrt((this.VX(300) - mouseEvent.getX()) * (this.VX(300) - mouseEvent.getX()) + (this.VY(this.oldRy) - mouseEvent.getY()) * (this.VY(this.oldRy) - mouseEvent.getY())) < (double)ReactionFrame.this.radius) {
                this.rightCircle = true;
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Graphics graphics = this.getGraphics();
            graphics.setXORMode(Color.white);
            if (this.leftCircle) {
                graphics.drawLine(this.VX(0), this.VY(0), this.VX(0), this.VY(this.oldLy));
                ReactionFrame.this.head = new VHead2(1.0, this.VX(0), this.VY(0), this.VX(0), this.VY(this.oldLy));
                graphics.fillPolygon(ReactionFrame.this.head.xpoints(), ReactionFrame.this.head.ypoints(), ReactionFrame.this.head.npoints());
                graphics.drawOval(this.VX(0) - ReactionFrame.this.radius, this.VY(this.oldLy) - ReactionFrame.this.radius, ReactionFrame.this.radius * 2, ReactionFrame.this.radius * 2);
                graphics.drawLine(this.VX(0), this.VY(0), this.VX(0), mouseEvent.getY());
                ReactionFrame.this.head = new VHead2(1.0, this.VX(0), this.VY(0), this.VX(0), mouseEvent.getY());
                graphics.fillPolygon(ReactionFrame.this.head.xpoints(), ReactionFrame.this.head.ypoints(), ReactionFrame.this.head.npoints());
                graphics.drawOval(this.VX(0) - ReactionFrame.this.radius, mouseEvent.getY() - ReactionFrame.this.radius, ReactionFrame.this.radius * 2, ReactionFrame.this.radius * 2);
                this.oldLy = this.Y(mouseEvent.getY());
                ReactionFrame.this.leftL.setText("Ly = " + this.oldLy);
            }
            if (this.rightCircle) {
                graphics.drawLine(this.VX(300), this.VY(0), this.VX(300), this.VY(this.oldRy));
                ReactionFrame.this.head = new VHead2(1.0, this.VX(300), this.VY(0), this.VX(300), this.VY(this.oldRy));
                graphics.fillPolygon(ReactionFrame.this.head.xpoints(), ReactionFrame.this.head.ypoints(), ReactionFrame.this.head.npoints());
                graphics.drawOval(this.VX(300) - ReactionFrame.this.radius, this.VY(this.oldRy) - ReactionFrame.this.radius, ReactionFrame.this.radius * 2, ReactionFrame.this.radius * 2);
                graphics.drawLine(this.VX(300), this.VY(0), this.VX(300), mouseEvent.getY());
                ReactionFrame.this.head = new VHead2(1.0, this.VX(300), this.VY(0), this.VX(300), mouseEvent.getY());
                graphics.fillPolygon(ReactionFrame.this.head.xpoints(), ReactionFrame.this.head.ypoints(), ReactionFrame.this.head.npoints());
                graphics.drawOval(this.VX(300) - ReactionFrame.this.radius, mouseEvent.getY() - ReactionFrame.this.radius, ReactionFrame.this.radius * 2, ReactionFrame.this.radius * 2);
                this.oldRy = this.Y(mouseEvent.getY());
                ReactionFrame.this.rightL.setText("Ry = " + this.oldRy);
            }
        }

        public void checkAnswer() {
            if (Math.abs(ReactionFrame.this.fRA - (double)this.oldLy) < (double)ReactionFrame.this.radius) {
                if (ReactionFrame.this.t10X.getState()) {
                    ReactionFrame.this.score = ReactionFrame.this.score + 20;
                } else if (ReactionFrame.this.t20X.getState()) {
                    ReactionFrame.this.score = ReactionFrame.this.score + 10;
                } else if (ReactionFrame.this.t40X.getState()) {
                    ReactionFrame.this.score = ReactionFrame.this.score + 5;
                }
            }
            if (Math.abs(ReactionFrame.this.fRB - (double)this.oldRy) < (double)ReactionFrame.this.radius) {
                if (ReactionFrame.this.t10X.getState()) {
                    ReactionFrame.this.score = ReactionFrame.this.score + 20;
                } else if (ReactionFrame.this.t20X.getState()) {
                    ReactionFrame.this.score = ReactionFrame.this.score + 10;
                } else if (ReactionFrame.this.t40X.getState()) {
                    ReactionFrame.this.score = ReactionFrame.this.score + 5;
                }
            }
            if (ReactionFrame.this.score >= 100) {
                ReactionFrame.this.score = 0;
                ReactionFrame.this.trials = 0;
            }
            this.repaint();
        }

        public void tryAgain() {
            ReactionFrame.this.randomR = new RandomR();
            this.loads = ReactionFrame.this.randomR.getLoads();
            ReactionFrame.this.fRA = ReactionFrame.this.randomR.getReactionA();
            ReactionFrame.this.fRB = ReactionFrame.this.randomR.getReactionB();
            this.oldLy = 0;
            this.oldRy = 0;
            ReactionFrame.this.leftL.setText("Ly = " + this.oldLy);
            ReactionFrame.this.rightL.setText("Ry = " + this.oldRy);
            this.repaint();
        }
    }
}

