#!/bin/sh
# This script will relax the oxygen and titanium atoms of BaTiO3
# to find the stablest tetragonal phase 
rm -rf BaTiO3.distortTiO.pot BaTiO3.distortTiO.rho BaTiO3.distortTiO.save BaTiO3.distortTiO.wfc BaTiO3.distortTiO.igk
cat > BaTiO3.distortTiO.in << EOF
 &control
    calculation = 'relax',
    restart_mode = 'from_scratch',
    prefix = 'BaTiO3.distortTiO',
    tstress = .true.,
    tprnfor = .true.,
    pseudo_dir = '/home/brandonw/LAB3/',
    outdir='/home/brandonw/LAB3/'
 /
 &system
    ibrav =  1, 
    celldm(1) = 7.52, 
    nat =  5, 
    ntyp = 3,
    ecutwfc = 30.0,
    ecutrho = 240.0
 /
 &electrons
    diagonalization='cg',
    mixing_mode = 'plain',
    mixing_beta = 0.7,
    conv_thr =  1.0d-8
 /
 &ions
    ion_dynamics='bfgs'
 /

ATOMIC_SPECIES
 Ba 137.327 Ba.UPF
 Ti 47.88   Ti.UPF
 O  15.9994 O.UPF

ATOMIC_POSITIONS
 Ba 0.0 0.0 0.0 0 0 0
 Ti 0.5 0.5 0.515 
 O 0.5 0.5 0
 O 0.5 0.0 0.5
 O 0.0 0.5 0.5

K_POINTS automatic
  4 4 4 1 1 1
EOF

./pw.x < BaTiO3.distortTiO.in > BaTiO3_distortTiO.out
