#!/bin/sh
# This script will sweep through the lattice parameter of BaTiO3
# to find the equilibrium lattice parameter

for lattice in 7.40 7.42 7.44 7.46 7.48 7.50 7.52 7.54 7.56 7.58 7.60 7.62 \
7.64 7.66 7.68 7.70
do
rm -rf *.pot *.rho *.save *.wfc *.igk
cat > BaTiO3.in << EOF
 &control
    calculation = 'scf',
    restart_mode = 'from_scratch',
    prefix = 'BaTiO3',
    tstress = .true.,
    tprnfor = .true.,
    pseudo_dir = '/home/brandonw/LAB3/',
    outdir = '/home/brandonw/LAB3/'
 /
 &system
    ibrav =  1, 
    celldm(1) = $lattice, 
    nat =  5, 
    ntyp = 3,
    ecutwfc = 30.0,
    ecutrho = 240.0
 /
 &electrons
    diagonalization = 'cg',
    mixing_mode = 'plain',
    mixing_beta = 0.7,
    conv_thr = 1.0d-8
 /

ATOMIC_SPECIES
 Ba 137.327 Ba.UPF
 Ti 47.88   Ti.UPF
 O  15.9994 O.UPF

ATOMIC_POSITIONS
 Ba 0.0 0.0 0.0
 Ti 0.5 0.5 0.5
 O 0.5 0.5 0
 O 0.5 0.0 0.5
 O 0.0 0.5 0.5

K_POINTS automatic
  4 4 4 1 1 1
EOF

./pw.x < BaTiO3.in > BaTiO3.$lattice.out
done
