#!/bin/bash
#
# if you have 10 points starting from 6.4 with interval 0.01

ecutwfc='30'
ecutrho='250'
k='12'
nump=1
ain='6.40'
interval='0.01'

SUMFIFE="esum.$ecutwfc.$ecutrho.$k"

rm -f $SUMFILE
touch $SUMFILE

PREFIX="Co.FCC"

n=0

while [ $n -lt $nump ]
do

a=`awk "BEGIN {printf \"%4.2f\",$ain+$n*$interval}" `
OUTFILE="$PREFIX.scf.$a.$ecutwfc.$ecutrho.$k.out"

etot=`grep ! $OUTFILE | gawk '{print $5}'`

cat >> esum.$ecutwfc.$ecutrho.$k << EOF
$a    $etot
EOF

let "n += 1"

done

