#!/bin/bash -f
#############################################################################
#$ -N C.scf
#$ -cwd
#$ -o $HOME/3.320/LAB2/err.out
#$ -j y
#$ -S /bin/sh

########################################################
# This is a script to run PWSCF 2.1.2 calculations in
# the hpcbeo2 cluster.
# N. Mounet and B. Kozinsky, 03-07-2005
########################################################
# set the needed variables

MYDIR="3.320/LAB2/PROBLEM1/"

LISTA='6.6'
LISTECUT='30 35 40 45 50 60'
LISTK='4'


USER=`whoami`

OUTDIR="/state/partition1/$USER"
PSEUDO_DIR="/state/partition1/$USER"
OUTPUT="/home/$USER/$MYDIR"

if [ ! -d $OUTDIR ]; then
	mkdir $OUTDIR
fi

if [ ! -d $PSEUDO_DIR ]; then
	mkdir $PSEUDO_DIR
fi

if [ ! -d $OUTPUT ]; then
        echo $MYDIR does not exist, please create it first
	exit
fi

cp /home/mounet/LAB2/C.pz-vbc.UPF $PSEUDO_DIR
rm -f $OUTDIR/diamond.*
#########################################################
# calculations

for ecut in $LISTECUT
do
for k in $LISTK
do
for a in $LISTA
do

rm -f $OUTPUT/C.scf.$a.$ecut.$k.in
cat > $OUTPUT/C.scf.$a.$ecut.$k.in << EOF
 &control
    calculation = 'scf'
    restart_mode='from_scratch'
    prefix='diamond'
    tstress = .true.
    tprnfor = .true.
    outdir = '$OUTDIR'
    pseudo_dir = '$PSEUDO_DIR'
 /        
 &system    
    ibrav=  2, celldm(1) =$a, nat=  2, ntyp= 1
    ecutwfc =$ecut 
 /
 &electrons
    diagonalization='david'
    mixing_mode = 'plain'
    mixing_beta = 0.7 
    conv_thr =  1.0d-8
 /
 ATOMIC_SPECIES
  C  12.011  C.pz-vbc.UPF
 ATOMIC_POSITIONS
  C 0.00 0.00 0.00 
  C 0.25 0.25 0.25                  
 K_POINTS {automatic}
    $k $k $k 0 0 0 
EOF

rm -f $OUTPUT/C.scf.$a.$ecut.$k.out
/home/mounet/LAB2/pw.x < $OUTPUT/C.scf.$a.$ecut.$k.in > $OUTPUT/C.scf.$a.$ecut.$k.out

done
done
done

rm -f $OUTDIR/diamond.*  $PSEUDO_DIR/C.pz-vbc.UPF
