/*
 * 
 * Created on Apr 19, 2005
 * by ccfisch
 * Class to test the performance of MersenneTwister and the native Random function in java...
 */
import cern.jet.random.engine.*;
import java.util.*;

public class RandTest {

    static int SIZE;
    /**
     * @param args
     */
    public static void main(String[] args) {
        // TODO Auto-generated method stub
        if(args==null){
            System.out.println("usage: RandTest <size>");
        }
        SIZE = (new Integer(args[0])).intValue();
        System.out.println("RandTest size: "+SIZE);
        runTest();
    }

    public static void runTest(){
        MersenneTwister mersenne = new MersenneTwister(new Date());
        Random rand = new Random();
        double nd = 0.0;
        float nf =0.0f;
        
        System.out.println("RandTest: testing "+mersenne.getClass().getName()+"; "+SIZE+" calls to nextDouble()");
        long beg = System.currentTimeMillis();
        for(int i=0; i<SIZE; i++){
            nd = mersenne.nextDouble();
        }
        long end = System.currentTimeMillis();
        System.out.println("Test took "+(end-beg)+" ms or "+(double)(end-beg)/SIZE+" ms/call");
        System.out.println("RandTest: testing "+mersenne.getClass().getName()+"; "+SIZE+" calls to nextFloat()");
        beg = System.currentTimeMillis();
        for(int i=0; i<SIZE; i++){
            nf = mersenne.nextFloat();
        }
        end = System.currentTimeMillis();
        System.out.println("Test took "+(end-beg)+" ms or "+(double)(end-beg)/SIZE+" ms/call");
        
        System.out.println("RandTest: testing "+rand.getClass().getName()+"; "+SIZE+" calls to nextDouble()");
        beg = System.currentTimeMillis();
        for(int i=0; i<SIZE; i++){
            nd = rand.nextDouble();
        }
        end = System.currentTimeMillis();
        System.out.println("Test took "+(end-beg)+" ms or "+(double)(end-beg)/SIZE+" ms/call");
        System.out.println("RandTest: testing "+rand.getClass().getName()+"; "+SIZE+" calls to nextFloat()");
        beg = System.currentTimeMillis();
        for(int i=0; i<SIZE; i++){
            nf = rand.nextFloat();
        }
        end = System.currentTimeMillis();
        System.out.println("Test took "+(end-beg)+" ms or "+(double)(end-beg)/SIZE+" ms/call");
        
        
        double sum = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        System.out.println("RandTest: testing properties of "+mersenne.getClass().getName());
        for(int i=0; i<SIZE; i++){
            nd = mersenne.nextDouble();
            sum+=nd;
            sum2+=nd*nd;
            sum3+=nd*nd*nd;
        }
        sum/=SIZE;
        sum2/=SIZE;
        sum3/=SIZE;
        System.out.println("RandTest: avg="+sum+" (<x^2>-<x>^2)="+(sum2-sum*sum)+
                " 3rd-cumulant="+(sum3-3.0*sum*sum2+2.0*sum*sum*sum));

        sum = 0.0;
        sum2 = 0.0;
        sum3 = 0.0;
        System.out.println("RandTest: testing properties of "+rand.getClass().getName());
        for(int i=0; i<SIZE; i++){
            nd = rand.nextDouble();
            sum+=nd;
            sum2+=nd*nd;
            sum3+=nd*nd*nd;
        }
        sum/=SIZE;
        sum2/=SIZE;
        sum3/=SIZE;
        System.out.println("RandTest: avg="+sum+" (<x^2>-<x>^2)="+(sum2-sum*sum)+
                " 3rd-cumulant="+(sum3-3.0*sum*sum2+2.0*sum*sum*sum));

    }
}
