package monte;
/*
 * 
 * Created on Apr 17, 2005
 * by ccfisch
 */
import java.io.*;
import java.util.regex.*;

/**
 * reads and stores input parameters for a MC run according to an input file
 * @author ccfisch
 * Date: Apr 24, 2005
 *
 */
public class InputReader {
    protected final String m_filename;
    protected final LineNumberReader m_reader;
    
    //all input parameters...
    public int m_SIZE;
    public int m_NUM_PASS;
    public int m_NUM_EQ;
    public boolean m_print_config;
    public boolean m_print_allD;
    public double m_V1;
    public double m_V2;
    public double m_T_START;
    public double m_T_FINAL;
    public double m_T_INC;
    public double m_MU_START;
    public double m_MU_FINAL;
    public double m_MU_INC;
    public boolean m_T_INSIDE;
    public int m_INIT_CONFIG;
    
    /**
     * 
     * @param filename
     * @throws IOException
     */
    public InputReader(String filename) throws IOException{
        m_filename=filename;
        m_reader = new LineNumberReader(new FileReader(m_filename));
        m_T_INSIDE=false;
        m_print_config=false;
        m_print_allD=false;
        m_INIT_CONFIG=4;
        this.readData();
    }
    
    public InputReader() {
        m_reader=null;
        m_filename=null;        
        this.printHelp();
    }
    
    private void readData() throws IOException{
       String linein = m_reader.readLine();
       while(linein!=null){
           this.processLine(linein);
           linein=m_reader.readLine();
       }
       if(m_NUM_PASS<=m_NUM_EQ){
           throw new RuntimeException("invalid num_pass parameter");
       }
    }
    
    private void processLine(String line){
        Pattern whitespace = Pattern.compile("\\s+");
        if(Pattern.matches("^#.*",line)){return;}
        String[] splitline = whitespace.split(line);
        if(splitline.length==0){return;}
        //for(int i=0; i<splitline.length;i++){System.out.print("token "+i+" value "+splitline[i]+" ");}
        //System.out.println();
        if(splitline[0].equals("SIZE")){this.m_SIZE=(new Integer(splitline[1])).intValue();}
        if(splitline[0].equals("V1")){this.m_V1=(new Double(splitline[1])).doubleValue();}
        if(splitline[0].equals("V2")){this.m_V2=(new Double(splitline[1])).doubleValue();}
        if(splitline[0].equals("NUM_EQ")){this.m_NUM_EQ=(new Integer(splitline[1])).intValue();}
        if(splitline[0].equals("NUM_PASS")){this.m_NUM_PASS=(new Integer(splitline[1])).intValue();}
        if(splitline[0].equals("T_START")){this.m_T_START=(new Double(splitline[1])).doubleValue();}
        if(splitline[0].equals("T_FINAL")){this.m_T_FINAL=(new Double(splitline[1])).doubleValue();}
        if(splitline[0].equals("T_INC")){this.m_T_INC=(new Double(splitline[1])).doubleValue();}
        if(splitline[0].equals("MU_START")){this.m_MU_START=(new Double(splitline[1])).doubleValue();}
        if(splitline[0].equals("MU_FINAL")){this.m_MU_FINAL=(new Double(splitline[1])).doubleValue();}
        if(splitline[0].equals("MU_INC")){this.m_MU_INC=(new Double(splitline[1])).doubleValue();}
        if(splitline[0].equals("PRINT_LAST_CONFIG")){this.m_print_config=true;}
        if(splitline[0].equals("PRINT_ALL_DATA")){this.m_print_allD=true;}
        if(splitline[0].equals("T_INSIDE_LOOP")){this.m_T_INSIDE=true;}    
        if(splitline[0].equals("INIT_CONFIG")){this.m_INIT_CONFIG=(new Integer(splitline[1])).intValue();}
    }
    
    private void printHelp(){
        char nl = DataPrinter.nl;
        System.out.println("The format of an input file is as follows: ");
        System.out.println("BEGIN---------------------------------------");
        System.out.println("#  any lines beginning with '#' are ignored");
        System.out.println("<token>  <value> # all others should have <token> <value> pairs");
        System.out.println("END-----------------------------------------"+nl+nl);
        System.out.println("where <token> is one of:");
        System.out.println("--------Description-------");
        System.out.println("SIZE             : length of lattice "+nl+
                           "V1,V2            : interaction parameters"+nl+
                           "NUM_EQ           : number of equilibration passes < NUM_PASS"+nl+
                           "NUM_PASS         : number of passes over lattice"+nl+
                           "{T,MU}_START     : starting {temperature,chemical potential}"+nl+
                           "{T,MU}_FINAL     : final {temp,chem_pot}"+nl+
                           "{T,MU}_INC       : increment on {temp,chem_pot}"+nl+
                           "PRINT_LAST_CONFIG: print last configuration to file last_config"+nl+
                           "PRINT_ALL_DATA   : print all E and <spin> sample values"+nl+
                           "T_INSIDE_LOOP    : run temperature loop inside chem_pot"+nl+
                           "INIT_CONFIG      : initial configuration 1=(all -1), 2=(all +1), 3=(root2 x root2), 4=random(default)"+
                           nl+nl);
    }
    
}
