(declare (usual-integrations write write-line pp eval))

(define write
  (make-generic-operator 1
    (access write user-initial-environment)))

(define write-line
  (make-generic-operator 1
    (access write-line user-initial-environment)))

(define pp
  (make-generic-operator 1
    (access pp user-initial-environment)))

(define (procedure-printable-representation procedure)
  `(compound-procedure
    ,(procedure-parameters procedure)
    ,(procedure-body procedure)
    <procedure-environment>))

(defhandler write
  (compose write procedure-printable-representation)
  compound-procedure?)

(defhandler write-line
  (compose write-line procedure-printable-representation)
  compound-procedure?)

(defhandler pp
  (compose pp procedure-printable-representation)
  compound-procedure?)

 
(define (read) (prompt-for-command-expression "eval> "))

(define the-global-environment)

(define (init)
  (set! the-global-environment
	(extend-environment '() '() the-empty-environment))
  (repl))

(define (repl)
  (let ((input (read)))
    (write-line (eval input the-global-environment))
    (repl)))

(define go repl)
