import lpsolve.*;

public class Demo2 {

  public static void main(String[] args) {
    try {
      // Create a problem with 4 variables and 0 constraints
      LpSolve solver = LpSolve.makeLp(0, 4);

      // add constraints
      solver.strAddConstraint("1 1 0 0", LpSolve.GE, 8);
			solver.strAddConstraint("1 0 -15 0", LpSolve.LE, 0);
			solver.strAddConstraint("0 1 0 -10", LpSolve.LE, 0);
      solver.strAddConstraint("0 0 1 1", LpSolve.LE, 1);

      // set objective function
      solver.strSetObjFn("8 3 18 20");

      // solve the problem
      solver.solve();

      // print solution
      System.out.println("Value of objective function: " + solver.getObjective());
      double[] var = solver.getPtrVariables();
      for (int i = 0; i < var.length; i++) {
        System.out.println("Value of var[" + i + "] = " + var[i]);
      }

      // delete the problem and free memory
      solver.deleteLp();
    }
    catch (LpSolveException e) {
       e.printStackTrace();
    }
  }

}
