package src.lp;
import org.gnu.glpk.*;
public class LP {
	public static void main(String[] args) {
		int[] ia= new int[1+1000];
		int[] ja= new int[1+1000];
		double[] ar= new double[1+1000];
		double z, x1, x2, x3;
		
		GlpkSolver solver = new GlpkSolver();
		solver.setProbName("sample");
		solver.setObjDir(GlpkSolver.LPX_MAX);	// Maximization, not minimization, problem
		solver.addRows(3);
		solver.setRowName(1, "p");
		solver.setRowBnds(1, GlpkSolver.LPX_UP, 0.0, 100.0);
		solver.setRowName(2, "q");
		solver.setRowBnds(2, GlpkSolver.LPX_UP, 0.0, 600.0);
		solver.setRowName(3, "r");
		solver.setRowBnds(3, GlpkSolver.LPX_UP, 0.0, 300.0);
		solver.addCols(3);
		solver.setColName(1, "x1");
		solver.setColBnds(1, GlpkSolver.LPX_LO, 0.0, 0.0);
		solver.setObjCoef(1, 10.0);
		solver.setColName(2, "x2");
		solver.setColBnds(2, GlpkSolver.LPX_LO, 0.0, 0.0);
		solver.setObjCoef(2, 6.0);
		solver.setColName(3, "x3");
		solver.setColBnds(3, GlpkSolver.LPX_LO, 0.0, 0.0);
		solver.setObjCoef(3, 4.0);
		ia[1] = 1; ja[1] = 1; ar[1] = 1.0; /* a[1,1] = 1 */
		ia[2] = 1; ja[2] = 2; ar[2] = 1.0; /* a[1,2] = 1 */
		ia[3] = 1; ja[3] = 3; ar[3] = 1.0; /* a[1,3] = 1 */
		ia[4] = 2; ja[4] = 1; ar[4] = 10.0; /* a[2,1] = 10 */
		ia[5] = 2; ja[5] = 2; ar[5] = 4.0; /* a[2,2] = 4 */
		ia[6] = 2; ja[6] = 3; ar[6] = 5.0; /* a[2,3] = 5 */
		ia[7] = 3; ja[7] = 1; ar[7] = 2.0; /* a[3,1] = 2 */
		ia[8] = 3; ja[8] = 2; ar[8] = 2.0; /* a[3,2] = 2 */
		ia[9] = 3; ja[9] = 3; ar[9] = 6.0; /* a[3,3] = 6 */
		solver.loadMatrix(9, ia, ja, ar);
		solver.simplex();
		z = solver.getObjVal();
		x1 = solver.getColPrim(1);
		x2 = solver.getColPrim(2);
		x3 = solver.getColPrim(3);
		System.out.printf("\nz = %g; x1 = %g; x2 = %g; x3 = %g\n", z, x1, x2, x3);
	}
}