clear
close all

% List the csv files to import **** SPECIFY THE FOLDER NAME HERE ****
folder_name = 'FOLDER_NAME';
dat_fol = dir([folder_name filesep '*.csv']);

% Initialize imported variables
time = [];
ssa = [];
ssb = [];
ccna = [];
ccnb = [];

% Loop over all csv files in the specified location
for i = 1:length(dat_fol)
    % Import data from a given file
    [Time,CurrentSSA,CCNNumberConcA,CurrentSSB,CCNNumberConcB] = ...
        import_CCN_class([folder_name filesep dat_fol(i).name]);
    
    % Initialize datenum variable for given file
    Time_dnum = zeros(size(Time));
    
    % Populate the datenum variable
    for j = 1:length(Time)
        y = 2014;
        m = 11;
        d = str2double(dat_fol(i).name(18:19));
        h = str2double(Time{j}(1:2));
        mn = str2double(Time{j}(4:5));
        s = str2double(Time{j}(7:8));
        
        Tim_dnum(j) = datenum(y,m,d,h,mn,s);
    end
    
    % Concatenate current file's data to existing data
    time = vertcat(time,Time_dnum);
    ssa = vertcat(ssa,CurrentSSA);
    ssb = vertcat(ssb,CurrentSSB);
    ccna = vertcat(ccna,CCNNumberConcA);
    ccnb = vertcat(ccnb,CCNNumberConcB);
end


%%% VERY IMPORTANT %%%
% There are often a few seconds at the beginning of the first file where
% there is garbage data collected. Before trimming the data, make sure that
% you're actually starting at a 6 minute interval.
%%%%%%%%%%%%%%%%%%%%%%

% Trim the first 3 minutes of each time series
for i = ##:360:length(time)
    time(i:i+179) = NaN;
    ssa(i:i+179) = NaN;
    ssb(i:i+179) = NaN;
    ccna(i:i+179) = NaN;
    ccnb(i:i+179) = NaN;
end

% Remove all the NaN's
time = time(~isnan(time));
ssa = ssa(~isnan(ssa));
ssb = ssb(~isnan(ssb));
ccna = ccna(~isnan(ccna));
ccnb = ccnb(~isnan(ccnb));