function [Time,CurrentSSA,CCNNumberConcA,CurrentSSB,CCNNumberConcB] = import_CCN_class(filename, startRow, endRow)
%IMPORTFILE Import numeric data from a text file as column vectors.
%   [TIME,CURRENTSSA,TEMPSSTABILIZEDA,DELTATA,T1SETA,T1READA,T2SETA,T2READA,T3SETA,T3READA,NAFIONSETA,TNAFIONA,INLETSETA,TINLETA,OPCSETA,TOPCA,TSAMPLEA,SAMPLEFLOWA,SHEATHFLOWA,SAMPLEPRESSUREA,LASERCURRENTA,OVERFLOWA,BASELINEMONA,VARNAME24,BINA,BIN1A,BIN2A,BIN3A,BIN4A,BIN5A,BIN6A,BIN7A,BIN8A,BIN9A,BIN10A,BIN11A,BIN12A,BIN13A,BIN14A,BIN15A,BIN16A,BIN17A,BIN18A,BIN19A,BIN20A,CCNNUMBERCONCA,VALVESETA,CURRENTSSB,TEMPSSTABILIZEDB,DELTATB,T1SETB,T1READB,T2SETB,T2READB,T3SETB,T3READB,NAFIONSETB,NAFIONREADB,INLETSETB,TINLETB,OPCSETB,TOPCB,TSAMPLEB,SAMPLEFLOWB,SHEATHFLOWB,SAMPLEPRESSUREB,LASERCURRENTB,OVERFLOWB,BASELINEMONB,VARNAME70,BINB,BIN1B,BIN2B,BIN3B,BIN4B,BIN5B,BIN6B,BIN7B,BIN8B,BIN9B,BIN10B,BIN11B,BIN12B,BIN13B,BIN14B,BIN15B,BIN16B,BIN17B,BIN18B,BIN19B,BIN20B,CCNNUMBERCONCB,VALVESETB,ALARMSUM,VARNAME95]
%   = IMPORTFILE(FILENAME) Reads data from text file FILENAME for the
%   default selection.
%
%   [TIME,CURRENTSSA,TEMPSSTABILIZEDA,DELTATA,T1SETA,T1READA,T2SETA,T2READA,T3SETA,T3READA,NAFIONSETA,TNAFIONA,INLETSETA,TINLETA,OPCSETA,TOPCA,TSAMPLEA,SAMPLEFLOWA,SHEATHFLOWA,SAMPLEPRESSUREA,LASERCURRENTA,OVERFLOWA,BASELINEMONA,VARNAME24,BINA,BIN1A,BIN2A,BIN3A,BIN4A,BIN5A,BIN6A,BIN7A,BIN8A,BIN9A,BIN10A,BIN11A,BIN12A,BIN13A,BIN14A,BIN15A,BIN16A,BIN17A,BIN18A,BIN19A,BIN20A,CCNNUMBERCONCA,VALVESETA,CURRENTSSB,TEMPSSTABILIZEDB,DELTATB,T1SETB,T1READB,T2SETB,T2READB,T3SETB,T3READB,NAFIONSETB,NAFIONREADB,INLETSETB,TINLETB,OPCSETB,TOPCB,TSAMPLEB,SAMPLEFLOWB,SHEATHFLOWB,SAMPLEPRESSUREB,LASERCURRENTB,OVERFLOWB,BASELINEMONB,VARNAME70,BINB,BIN1B,BIN2B,BIN3B,BIN4B,BIN5B,BIN6B,BIN7B,BIN8B,BIN9B,BIN10B,BIN11B,BIN12B,BIN13B,BIN14B,BIN15B,BIN16B,BIN17B,BIN18B,BIN19B,BIN20B,CCNNUMBERCONCB,VALVESETB,ALARMSUM,VARNAME95]
%   = IMPORTFILE(FILENAME, STARTROW, ENDROW) Reads data from rows STARTROW
%   through ENDROW of text file FILENAME.
%
% Example:
%   [Time,CurrentSSA,TempsStabilizedA,DeltaTA,T1SetA,T1ReadA,T2SetA,T2ReadA,T3SetA,T3ReadA,NafionSetA,TNafionA,InletSetA,TInletA,OPCSetA,TOPCA,TSampleA,SampleFlowA,SheathFlowA,SamplePressureA,LaserCurrentA,OverflowA,BaselineMonA,VarName24,BinA,Bin1A,Bin2A,Bin3A,Bin4A,Bin5A,Bin6A,Bin7A,Bin8A,Bin9A,Bin10A,Bin11A,Bin12A,Bin13A,Bin14A,Bin15A,Bin16A,Bin17A,Bin18A,Bin19A,Bin20A,CCNNumberConcA,ValveSetA,CurrentSSB,TempsStabilizedB,DeltaTB,T1SetB,T1ReadB,T2SetB,T2ReadB,T3SetB,T3ReadB,NafionSetB,NafionReadB,InletSetB,TInletB,OPCSetB,TOPCB,TSampleB,SampleFlowB,SheathFlowB,SamplePressureB,LaserCurrentB,OverflowB,BaselineMonB,VarName70,BinB,Bin1B,Bin2B,Bin3B,Bin4B,Bin5B,Bin6B,Bin7B,Bin8B,Bin9B,Bin10B,Bin11B,Bin12B,Bin13B,Bin14B,Bin15B,Bin16B,Bin17B,Bin18B,Bin19B,Bin20B,CCNNumberConcB,ValveSetB,AlarmSum,VarName95]
%   = importfile('CCN-200 data 141120140000.csv',5, 3604);
%
%    See also TEXTSCAN.

% Auto-generated by MATLAB on 2014/11/25 13:34:50

%% Initialize variables.
delimiter = ',';
if nargin<=2
    startRow = 5;
    endRow = inf;
end

%% Format string for each line of text:
%   column1: text (%s)
%	column2: double (%f)
%   column3: double (%f)
%	column4: double (%f)
%   column5: double (%f)
%	column6: double (%f)
%   column7: double (%f)
%	column8: double (%f)
%   column9: double (%f)
%	column10: double (%f)
%   column11: double (%f)
%	column12: double (%f)
%   column13: double (%f)
%	column14: double (%f)
%   column15: double (%f)
%	column16: double (%f)
%   column17: double (%f)
%	column18: double (%f)
%   column19: double (%f)
%	column20: double (%f)
%   column21: double (%f)
%	column22: double (%f)
%   column23: double (%f)
%	column24: double (%f)
%   column25: double (%f)
%	column26: double (%f)
%   column27: double (%f)
%	column28: double (%f)
%   column29: double (%f)
%	column30: double (%f)
%   column31: double (%f)
%	column32: double (%f)
%   column33: double (%f)
%	column34: double (%f)
%   column35: double (%f)
%	column36: double (%f)
%   column37: double (%f)
%	column38: double (%f)
%   column39: double (%f)
%	column40: double (%f)
%   column41: double (%f)
%	column42: double (%f)
%   column43: double (%f)
%	column44: double (%f)
%   column45: double (%f)
%	column46: double (%f)
%   column47: double (%f)
%	column48: double (%f)
%   column49: double (%f)
%	column50: double (%f)
%   column51: double (%f)
%	column52: double (%f)
%   column53: double (%f)
%	column54: double (%f)
%   column55: double (%f)
%	column56: double (%f)
%   column57: double (%f)
%	column58: double (%f)
%   column59: double (%f)
%	column60: double (%f)
%   column61: double (%f)
%	column62: double (%f)
%   column63: double (%f)
%	column64: double (%f)
%   column65: double (%f)
%	column66: double (%f)
%   column67: double (%f)
%	column68: double (%f)
%   column69: double (%f)
%	column70: double (%f)
%   column71: double (%f)
%	column72: double (%f)
%   column73: double (%f)
%	column74: double (%f)
%   column75: double (%f)
%	column76: double (%f)
%   column77: double (%f)
%	column78: double (%f)
%   column79: double (%f)
%	column80: double (%f)
%   column81: double (%f)
%	column82: double (%f)
%   column83: double (%f)
%	column84: double (%f)
%   column85: double (%f)
%	column86: double (%f)
%   column87: double (%f)
%	column88: double (%f)
%   column89: double (%f)
%	column90: double (%f)
%   column91: double (%f)
%	column92: double (%f)
%   column93: double (%f)
%	column94: double (%f)
%   column95: double (%f)
% For more information, see the TEXTSCAN documentation.
formatSpec = '%s%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%[^\n\r]';

%% Open the text file.
fileID = fopen(filename,'r');

%% Read columns of data according to format string.
% This call is based on the structure of the file used to generate this
% code. If an error occurs for a different file, try regenerating the code
% from the Import Tool.
textscan(fileID, '%[^\n\r]', startRow(1)-1, 'ReturnOnError', false);
dataArray = textscan(fileID, formatSpec, endRow(1)-startRow(1)+1, 'Delimiter', delimiter, 'EmptyValue' ,NaN,'ReturnOnError', false);
for block=2:length(startRow)
    frewind(fileID);
    textscan(fileID, '%[^\n\r]', startRow(block)-1, 'ReturnOnError', false);
    dataArrayBlock = textscan(fileID, formatSpec, endRow(block)-startRow(block)+1, 'Delimiter', delimiter, 'EmptyValue' ,NaN,'ReturnOnError', false);
    for col=1:length(dataArray)
        dataArray{col} = [dataArray{col};dataArrayBlock{col}];
    end
end

%% Close the text file.
fclose(fileID);

%% Post processing for unimportable data.
% No unimportable data rules were applied during the import, so no post
% processing code is included. To generate code which works for
% unimportable data, select unimportable cells in a file and regenerate the
% script.

%% Allocate imported array to column variable names
Time = dataArray{:, 1};
CurrentSSA = dataArray{:, 2};
CCNNumberConcA = dataArray{:, 46};
CurrentSSB = dataArray{:, 48};
CCNNumberConcB = dataArray{:, 92};


