% matlab file to calculate and plot cross section for CO2 and water

% load data

load CO2_400uL.CSV
load H2O10mL.CSV

ww = H2O10mL(:,1);
xw = H2O10mL(:,2);

w = CO2_400uL(:,1); % wavelength cm-1
x = CO2_400uL(:,2)/100; % this is transmission I/I0
x(x>1) = 1.0; % replace >1 with 1

iCO2 = (w>550).*(w<750)+(w>2280).*(w<2400); % extract wavenumber between 550-750 and 2280-2400 for CO2
iCO2 = logical(iCO2);
ielse = ~iCO2;
xCO2 = x;  xCO2(ielse) = 1;  % set transmission outside of CO2 window to 1;

subplot(3,1,1)
plot(w,x,'b', w, xCO2, 'r')
legend('total', 'CO_2')
xlabel('wavenumber (cm^{-1})')
ylabel('transmission')

% calculate cross section
mCO2 = 0.15*400e-6/70e-3*2.5e+19; % Number density for CO2 in cm-3
csCO2 = -1./mCO2/10*log(xCO2); 

subplot(3,1,2)
plot(w, csCO2)
xlabel('wavenumber (cm^{-1})')
ylabel('cross section cm^2')

% calculate transmission for the whole atmosphere applying Beer-Lambert Law

Xwa_10m = exp(-csCO2*400e-6*2.5e+19*0.01e+5); % transmission for 10m of air
Xwa_7km = exp(-csCO2*400e-6*2.5e+19*7e+5); % transmission for 7km of air

subplot(3,1,3)
plot(w, Xwa_10m, w, Xwa_7km)
legend('10m air', '7km air')
xlabel('wavenumber (cm^{-1})')
ylabel('transmission')

