load csCO2.mat

h = 6.626e-34; % planck's constant m2/kg/s
kb = 1.38065e-23; % Boltzmann Constant, m2 kg s-2 K-1
c = 299792458; % speed of light in m/s
L = 8000;
n0 = 9.91e+21;

T0 = 288; % temperature in K
Tz1 = 217;

v = w*c*100; % frequency in s-1; w is wavenumber in cm-1

N = csCO2*n0*L;

B0 = 2*pi*h*v.^3*c^-2.*(exp((h.*v)/(kb*T0))-1).^-1*c*100;
Bz1 = 2*pi*h*v.^3*c^-2.*(exp((h.*v)/(kb*Tz1))-1).^-1*c*100;

z1 = 1-exp(-1100/8000);
az = 1+(z1/2);

I = B0.*exp(-N.*az)+(1-exp(-N.*az)).*Bz1;

plot(v,I)