%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  this is a simple radiation transfer model based on 
% Wilson and Gea-Banacloche
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

load csCO2.mat % load cross section data, w is in cm-1, and csCO2 is in cm2

w_low = [10:10:520]'; w = [w_low; w];
csCO2 = [zeros(length(w_low),1); csCO2];


h = 6.626e-34; % planck's constant m2/kg/s
kb = 1.38065e-23; % Boltzmann Constant, m2 kg s-2 K-1
c = 299792458; % speed of light in m/s

T = 288; % temperature in K

v = w*c*100; % frequency in s-1; w is wavenumber in cm-1

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% blackbody radiation as a function of wavelength, unit is in W/m2/cm-1
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

B0 = 2*pi*h*v.^3*c^-2.*(exp((h.*v)/(kb*T))-1).^-1*c*100; 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% for non-radiating atmosphere
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Ls = 7.5e+5; % scale height of the atmosphere in cm
Xwa = exp(-csCO2*400e-6*2.5e+19*Ls); % transmission for 7km of air

Bnr = Xwa.*B0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% for non-radiating atmosphere
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Ls = 7.5e+5; % scale height of the atmosphere in cm
Xwa = exp(-csCO2*400e-6*2.5e+19*Ls); % transmission for 7km of air

Bnr = Xwa.*B0;

figure(1)
subplot(3,1,1)
plot(w, B0,'r', w, Bnr,'b')
legend('BlackBody', 'non-radiating atmosphere')
ylabel('W/m^2 cm^{-1}'); 
xlabel('wavenumber in cm^{-1}')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% for radiating atmosphere
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

lasp = 6.49; % laps rate, 6.49K/km

z = 0:1:21;
Tz = 217*ones(1,21);
Tz(1:11) = 288-z(1:11)*lasp; 

for n=1:21; 
    T = Tz(n); 
    Bz(n,:) = 2*pi*h*v.^3*c^-2.*(exp((h.*v)/(kb*T))-1).^-1*c*100; 
end

subplot(3,1,2)
plot(w, Bz(1,:), w, Bz(6,:), w, Bz(11,:), w, Bz(21,:))
legend('z=0km', 'z= 5km', 'z=10km', 'z=20km')

    nd = 400e-6*2.5e+19*exp(-z/7.5); % number density in cm-3 for each grid altitude, surface is at 2.5e+19

