!Filename: critical.f
!
!This shows use of the CRITICAL directive.
!

PROGRAM CRITICAL 
        IMPLICIT NONE
        INTEGER:: L,I
        INTEGER:: nthreads, OMP_GET_NUM_THREADS

        L=10

!$OMP PARALLEL SHARED(L) PRIVATE(nthreads,I)

!$OMP MASTER
nthreads = OMP_GET_NUM_THREADS()
        PRINT *, "Number of threads:",nthreads
!$OMP END MASTER

!*** The following is going to cause problems without a
!*** CRITICAL directive

CALL ADD_ONE(L)

!$OMP END PARALLEL

PRINT *, "The final value of L is", L


END PROGRAM CRITICAL 

SUBROUTINE ADD_ONE(I)
        IMPLICIT NONE
        INTEGER, INTENT(INOUT):: I
	INTEGER:: J

	J = I

!$OMP MASTER
OPEN(UNIT=26,FORM='FORMATTED',FILE='junk')
        DO I=1,40000
                WRITE(26,*) "Hi Mom!"
        END DO
        CLOSE(26)
!$OMP END MASTER


J = J + 1
!$OMP ATOMIC
	I = J

END SUBROUTINE ADD_ONE
