
!Filename: pardo.f
!

PROGRAM PARDO 
        IMPLICIT NONE
        INTEGER I,J
        INTEGER, PARAMETER:: DIM1=10000, DIM2=200
        REAL A(DIM1),B(DIM2,DIM1),C(DIM2,DIM1)
        REAL before, after, elapsed,TIMEF,S
        INTEGER nthreads,OMP_GET_NUM_THREADS

        CALL RANDOM_NUMBER(A)

        before = TIMEF()

!$OMP PARALLEL DO SCHEDULE(RUNTIME) PRIVATE(I,J) SHARED (A,B,C,nthreads)
DO J=1,DIM2
                nthreads = OMP_GET_NUM_THREADS()
          DO I=2, DIM1
                B(J,I) = ( (A(I)+A(I-1))/2.0 ) / SQRT(A(I))
                C(J,I) = SQRT( A(I)*2 ) / ( A(I)-(A(I)/2.0) )
                B(J,I) = C(J,I) * ( B(J,I)**2 ) * SIN(A(I))
          END DO
        END DO

!$OMP END PARALLEL DO

after = TIMEF()
        !Find elapsed time; convert to seconds from ms
        elapsed = (after-before)/1000. 

        S=MAXVAL(B)

        WRITE(6,'("Maximum of B=",1pe8.2," found in ",1pe8.2," seconds using",&
             &I2," threads")') S,elapsed,nthreads


END PROGRAM PARDO 

