!Filename: reduction.f
!
!This program shows the use of the REDUCTION clause.

PROGRAM REDUCTION 
        IMPLICIT NONE
        INTEGER tnumber, OMP_GET_THREAD_NUM
        INTEGER I,J,K
        I=1
        J=10
        K=100
        PRINT *, "Before Parallel Region: I=",I," J=", J," K=",K
        PRINT *, ""

!$OMP PARALLEL DEFAULT(PRIVATE) REDUCTION(+:I) REDUCTION(*:J) REDUCTION(MAX:K)

tnumber=OMP_GET_THREAD_NUM()

        PRINT *, "Thread ",tnumber, "              I=",I," J=", J," K=",K

        I = I + tnumber
        J = J * tnumber
        K = MAX(K,tnumber)

        PRINT *, "Thread ",tnumber, "              I=",I," J=", J," K=",K

!$OMP END PARALLEL

PRINT *, ""
        print *, "Operator                 +     *    MAX"
        PRINT *, "After Parallel Region:  I=",I," J=", J," K=",K

END PROGRAM REDUCTION 
