package photo;


import java.io.File;

/**
 * Photo is an immutable class representing a digital
 * photo file on disk.
 * @author jbaek, rcm
 */
public class Photo {

	private final File file;
	
	/**
	 * Make a Photo for a file.
	 * Requires file != null.
	 */
	public Photo(File file) {
		assert file != null;
		this.file = file;
	}
	
	/**
	 * @return the file containing this photo.
	 */
	public File getFile() {
		return file;
	}
	
	@Override
	public boolean equals(Object obj) {
		return 
			obj instanceof Photo
			&& ((Photo)obj).file.equals(file);
	}
	
	@Override
	public int hashCode() {
		return file.hashCode();
	}
}
