{-# LANGUAGE ScopedTypeVariables #-}
module Main(main) where
import System.Environment hiding (getEnv)
import Control.Exception
import Control.Monad
import Data
import Tests
import TypeCheck

evaluateFully :: Type -> Maybe Type
evaluateFully (TBase b) = Just (TBase b)
evaluateFully (TVar v) = Just (TVar v)
evaluateFully (TArrow t1 t2) =
  case evaluateFully t1 of
    Just t1 ->
      case evaluateFully t2 of
        Just t2 -> Just (TArrow t1 t2)
        Nothing -> Nothing
    Nothing -> Nothing

main :: IO ()
main = do
  checks <- foldM checkType True testExps
  if checks
    then putStrLn "Type checked!"
    else putStrLn "Failed."
  where
  initialState = ([], [])
  checkType :: Bool -> (Exp, Maybe Type) -> IO Bool
  checkType goodSoFar (e, t) = do
    ty <- Control.Exception.catch
          (case evaluateFully (typeCheck idSubst e) of
              Just x -> return (Just x)
              Nothing -> return Nothing)
          (\(e :: TCError) -> return Nothing)
    case (t, ty) of
      (Just refty, Just somety) -> return $ goodSoFar && (somety == refty)
      (Nothing, Nothing) -> return goodSoFar
      (_, _) -> return False
