(* Typing context, a partial map from variables to types *)
Definition tcontext := var -> option type.

(* Empty typing context *)
Definition tcontext0 : tcontext := fun _ => None.

(* Operation to add a binding to a typing context *)
Definition bind (E : tcontext) (x : var) (t : type) : tcontext :=
  fun y => if string_dec x y then Some t else E y.

(* Erase local references from a typing context (used in Fork rule ) *)
Definition forgetLocal (E : tcontext) : tcontext :=
  fun x => match E x with
             | Some v => None
             | to => to
           end.


Definition updateTypes (E : tcontext) : tcontext := 
  fun x => match E x with 
            | Some (Local cid) => Some (Local (cid+1))
            | to => to
           end.
           
Inductive isSameType: field -> Prop :=
| IsSameTypeByName : forall x,
(if string_dec x "st" then True else False)->
isSameType x.


Inductive typeCheck: tcontext -> nat -> exp -> type -> Prop := 
| TVar : forall E x t cid,
(* Your code here *)
  -> typeCheck E cid (Var x) t
| TNew : forall E cid,
  typeCheck E cid (New) Global
| TNewL: forall E cid,
  typeCheck E cid (NewL) (Local 0)
| TSeq : forall E cid t e1 e2 t',
(* Your code here *)
typeCheck E cid (Seq e1 e2) t
| TLet: forall E x e e' t t' cid,
(* Your code here *)
  -> typeCheck E cid (Let x t e e') t'
| TReadField: forall E e f t cid,
(*Your code here *)
  -> typeCheck E cid (ReadField e f) t
| TWriteField: forall E f t e e' cid,
(*Your code here *)
   -> typeCheck E cid (WriteField e f e') t
| TContext: forall E e cid,
(*Your code here *)
   -> typeCheck E cid (Context e) Global
| TInside: forall E e cid,
(*Your code here *)
   -> typeCheck E cid (Inside e) Global
| TPtr1 : forall E n cid,
   typeCheck E cid (Ptr (G n)) Global
| TPtr2 : forall E n c t,
   typeCheck E (t+c) (Ptr (L n c)) (Local t)
.




Inductive envtConsistent: heap->nat->nat->Prop:=
| EmptyHeap: forall cid oid,
envtConsistent [] cid oid 
| SomeHeap1: forall h cid oid cid' o n,
envtConsistent h cid oid -> n<oid -> cid' <= cid ->
(forall f, exists n', o f = L n' cid') ->
envtConsistent ((Cell (L n cid') o)::h) cid oid
| SomeHeap2: forall h cid oid o n,
envtConsistent h cid oid -> n<oid ->
(forall f, exists n', o f = G n') ->
envtConsistent ((Cell (G n) o)::h) cid oid
.

(* What it means for an expression [e] to be a well-formed intermediate state of
   computation with a certain number of open contexts.  Essentially, there must
   exist an [evcontext] whose [EvInside]s describe all the [Inside]s in [e].

   [wellFormed] has constructors that mirror the [evcontext] constructors, and we
   use them to drill down as far as possible rather than switching to a separate
   [noInsides] predicate after the last [Inside], because the latter would just
   introduce more cases in the preservation proof.  Also, we use [wellFormed e 0]
   as a way to state that a subexpression contains no [Inside]s.  That seems a
   little strange, but if we used a separate predicate, we'd have to prove anyway
   that it implies [wellFormed e 0] when evaluation reaches one of those
   subexpressions. *)
Inductive wellFormed: exp -> nat -> Prop :=
| WFSeq :
    forall e1 n e2,
      wellFormed e1 n -> wellFormed e2 0 ->
      wellFormed (Seq e1 e2) n
| WFLet :
    forall x t e n e',
      wellFormed e n -> wellFormed e' 0 ->
      wellFormed (Let x t e e') n
| WFReadField :
    forall e n f,
      wellFormed e n ->
      wellFormed (ReadField e f) n
| WFWriteField1 :
    forall e n f e',
      wellFormed e n -> wellFormed e' 0 ->
      wellFormed (WriteField e f e') n
| WFWriteField2 :
    forall p f e' n,
      wellFormed e' n ->
      wellFormed (WriteField (Ptr p) f e') n
| WFInside :
    forall e n,
      wellFormed e n ->
      wellFormed (Inside e) (n + 1)
| WFVar : forall x, wellFormed (Var x) 0
| WFNew : wellFormed New 0
| WFNewL : wellFormed NewL 0
| WFContext : forall e, wellFormed e 0 -> wellFormed (Context e) 0
| WFPtr : forall p, wellFormed (Ptr p) 0
.



Ltac descend :=
  repeat match goal with
           | [ |- exists x, _ ] => eexists
         end.




