/*
 * RPC spec for blockdbd
 * rpcc -c block_proto.x ; rpcc -h block_proto.x
 */

struct put_args {
  opaque key<>;
  opaque value<>;
};
struct get_args {
  opaque key<>;
};
struct get_result {
  bool ok;
  opaque value<>;
};
struct remove_args {
  opaque key<>;
};

program BLOCK_PROG {
  version BLOCK_VERS {
    bool BLOCK_PUT(put_args) = 1;
    get_result BLOCK_GET(get_args) = 2;
    bool BLOCK_REMOVE(remove_args) = 3;
  } = 1;
} = 400002;
