//
// key/value database
// this version is purely in-core
//

#ifndef BLOCKDB_H
#define BLOCKDB_H

#include "str.h"
#include "ihash.h"

class blockdb {
 public:
  static const size_t max_block_size;
  blockdb();
  void put(str key, str value, callback<void, bool>::ref cb);
  void get(str key, callback<void, bool, str>::ref cb);
  void remove(str key, callback<void, bool>::ref cb);
  void test();

 private:
  class block {
  public:
    block(str k, str v) { key = k; value = v; }
    block() { }
    str key;
    str value;
    ihash_entry<block> lnk;
  };
  ihash<const str, block, &block::key, &block::lnk> tab;

  void put_done(callback<void, bool>::ref cb, bool ok);
  void get_done(callback<void, bool, str>::ref cb, bool ok, str value);
  void remove_done(callback<void, bool>::ref cb, bool ok);
  void testcb(bool wantok, str wantv, bool ok, str v);
  void testcb1(bool ok);
  str hex(str s);
};

#endif
