/*
 * Client interface to RPC stubs for blockdbd.
 */

#ifndef blockdbc_h
#define blockdbc_h 1

#include "amisc.h"
#include "async.h"
#include "arpc.h"
#include "block_proto.h"

// #define BLOCKCACHE

class blockdbc {
public:
  blockdbc(struct sockaddr_in sin);
  void put(str key, str value, callback<void, bool>::ref cb);
  void get(str key, callback<void, bool, str>::ref cb);
  void remove(str key, callback<void, bool>::ref cb);
  void flush(str key, callback<void>::ref cb);
  void flush_prefix(str key_prefix, callback<void>::ref cb);
  void test();

private:
  int fd;
  ptr<axprt> x;
  ptr<aclnt> c;
  struct sockaddr_in server;


  void real_put(str key, str value, callback<void, bool>::ref cb);
  void real_get(str key, callback<void, bool, str>::ref cb);
  void put_done(callback<void, bool>::ref cb,
                bool *res, clnt_stat err);
  void get_done(callback<void, bool, str>::ref cb, str key,
                get_result *r, clnt_stat err);
  void get_xcb(callback<void, bool, str>::ref cb, str v);
  void remove_done(callback<void, bool>::ref cb,
                   bool *res, clnt_stat err);
  void test_cb1(bool ok);
  void test_cb2(str wanted, bool ok, str value);
  str hex(str s);
};

#endif /* blockdbc_h */
