% This program converts an adjacency matrix representation to an incidence
% matrix representation for an arbitrary network

function [incidence] = adj2inc(adjacency)

% INPUT
% adjacency matrix, NxN, N - number of nodes

% OUTPUT
% incidence matrix: N x number of edges

N = length(adjacency);

incidence = zeros(N,sum(sum(adjacency))/2);
cnt = 0; % counting edges for the loop

while not(isempty(find(adjacency>0)))
  new = find(adjacency>0); % find edges
  % get indeces of first edge
  x = mod(new(1),N);  
  if x==0
    x=N;
  end
  y = ceil(new(1)/N);
  cnt = cnt + 1;
  incidence(x,cnt) = 1; % assign new edge
  incidence(y,cnt) = 1; 
  adjacency(x,y) = adjacency(x,y) - 1;
  adjacency(y,x) = adjacency(y,x) - 1;
end

