% Betweenness centrality measure: number of shortest paths running though a
% vertex. Output for all vertices.
% Gergana Bounova, December 19, 2005

function [betw,betw_x,community] = betweenness(adj,x)

% inputs: adjacency (distances) matrix and (optional) vertex index
% outputs: betweeness measures vector for all vertices + optional vertex

% use shortest path DP algorithm
  % for every 2 verteces, estimate shortest path and record +1 for
  % betweenness measure on all nodes on the route
  
N = size(adj,2);
betw = zeros(1,N);  
%for i=1:N
%  community(i).pts1 = [];
%  community(i).pts2 = [];
%end

for i=1:N
  for j=i+1:N
    [J_st,route_st]=shortest_pathDP(adj,i,j,N);
    betw(route_st(2:length(route_st)-1)) = betw(route_st(2:length(route_st)-1)) + 1;
    %for k=1:length(2:length(route_st)-1)
    %  community(route_st(k)).pts1 = [community(route_st(k)).pts1 i];
    %  community(route_st(k)).pts2 = [community(route_st(k)).pts2 j];
    %end
  end
end

betw_x = betw(x);
