% Calculates and plots the degree distributions of an arbitrary graph
% Gergana Bounova, October 8, 2005
function [deg,vrtx] = degree_dist(adj)
% INPUT: adjacency matrix representation of a graph
% OUTPUT: vector containing degree per vertex, in decreasing order
%         corresponding vertex index vector
deg = -sum(adj(:,:));
[deg,vrtx] = sort(deg);
deg = -deg;
subplot(2,2,1) % =========
plot([1:length(deg)],deg,'rd','LineWidth',3);
for i=1:length(deg)
  text(i,deg(i)-1,num2str(vrtx(i)),'FontWeight','bold','FontName','times');
end
%axis([0 length(deg)+1 0 max(deg)+1])
xlabel('vertex ordered index','FontSize',10,'FontWeight','bold','FontName','times');
ylabel('vertex degree','FontSize',10,'FontWeight','bold','FontName','times');
title('degree distribution','FontSize',10,'FontWeight','bold','FontName','times');
subplot(2,2,2) % ==========
for i=1:length(deg)
  loglog(deg(i),length(find(deg==deg(i))),'rd','LineWidth',3);
  hold off; hold on;
end
xlabel('degree','FontSize',10,'FontWeight','bold','FontName','times');
ylabel('frequency','FontSize',10,'FontWeight','bold','FontName', ...
       'times');
subplot(2,2,3) % ==========
hist(deg)
ylabel('histogram','FontSize',10,'FontWeight','bold','FontName', ...
       'times');
% cumulative degree distribution: for a given number k, how many
% vertices have degree higher than that?
subplot(2,2,4) % ==========
for i=1:length(deg)
  loglog(deg(i),length(find(deg>deg(i))),'rd','LineWidth',3);
  hold off; hold on;
end
xlabel('degree','FontSize',10,'FontWeight','bold','FontName','times');
ylabel('cumulative degree distribution','FontSize',10,'FontWeight','bold','FontName', ...
       'times');
