% Return the degrees of all nodes, based on the adjacency matrix
% Gergana Bounova, February 20, 2006

function [degs] = degrees(adj)

% INPUTs: adj - nxn adjacency matrix
% OUTPUTs: degs - a vector (1xn) of degrees for every node

% The convention is that the adjacency matrix where an entry of 1
% in the ij position means that i is connected to j. 
% This code is valid only for undirected graphs

n = size(adj,2); % number of nodes

if issimple(adj) % simple graph
  degs = sum(adj);
else             % not a simple graph
  degs = sum(adj); 
  % add self-loop twice
  for i=1:n
    if adj(i,i)>0
      degs(i) = degs(i) + adj(i,i);
    end
  end
end
  
 