function [J_st,route_st]=shortest_pathDP(L,initial,final,stages)

% INPUTS
% L - cost/path lengths matrix
% initial - start/source node
% final - end/destination node

% OUTPUTS
% route - sequence of nodes on optimal path
% Jo - optimal cost function (path length)

s=initial;
t=final;


% stages = size(L,3);
nodes = size(L,2);

for i=1:nodes
  for j=i:nodes
    if L(i,j)==0
      L(i,j)=inf; L(j,i)=inf;
    end
  end
end


for i=1:nodes
  J(stages,i) = L(i,t); 
  route(stages,i).path = [t];      % UPDATE
end
% find min for every i: Jk(i)=min_j(L(i,j)+Jk+1(j))
for p=1:stages-1
  k=stages-p; % recurse backwards
  for i=1:nodes
    [J(k,i),ind_j] =  min(L(i,:)+J(k+1,:));
    route(k,i).path = [ind_j, route(k+1,ind_j).path];
  end
  
end

[J_st,stage_ind] = min(J(:,s));
route_st = [s, route(stage_ind,s).path];


