% MatLab tutorial script
% Gergana Bounova, February 22, 2006

clear all

% Load bike data
load bike_data
who

size(adj_bike)
size(deg_bike)

% Graph Representations *************************************
inc = adj2inc(adj_bike);
size(inc)
sum(inc)   % should give a vector of 2s

% num_edges = sum(sum(adj_bike))/2 for an undirected graph
% should be same as second dimension of incidence matrix
numedges = num_edges(adj_bike) 

% Lists
str = adj2str(adj_bike);
% number of children and number of degrees should be the same
str(1).child
degrees(1)

% Graph Diagnostics *****************************************
issymmetric(adj_bike)
issimple(adj_bike)
isdirected(adj_bike)
isconnected(adj_bike)

% Global metrics
degree_dist(adj_bike)
clust_coeff(adj_bike)
diameter(adj_bike)
ave_path_length(adj_bike)
betweenness(adj_bike)
harmonic_path_length(adj_bike)

% Graph construction
random_graph(10)
random_graph(10,0.1,20)
random_graph(10,0,0,'normal')
random_graph(10,0,0,'custom',@mypdf)
degs = [3 1 1 1];
random_graph(10,0,0,'custom',@mypdf,degs)
adj_bike1 = graph_from_degrees(degs);

% Graph visualization
adj2pajek(adj_bike,'bike.net');


