(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   3844814,      96544]*)
(*NotebookOutlinePosition[   3854618,      96776]*)
(*  CellTagsIndexPosition[   3852324,      96730]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Graphics and Plotting", "Title"],

Cell["\<\
Mathematica has a large number of built-in graphics programs for \
plotting and exploring mathematics graphically and for plotting and \
visualizing data.  Graphs and plots are effective ways of conveying complex \
information.  It is important to learn how to create and manipulate plots and \
graphics.  Mathematica is very rich in its graphical functions\[LongDash]we \
will explore just a small subset of all its capabilities.  We can get an idea \
of how many plotting routines are available byusing a wildcard:\
\>", "Text"],

Cell[BoxData[
    \(\(?*Plot*\)\)], "Input"],

Cell["\<\
This is much less than are available in the standard packages; \
these will be discussed later, but here's what becomes available after \
loading the Graphics Packages:\
\>", "Text"],

Cell[BoxData[
    \(<< Graphics`\)], "Input",
  CellTags->"mmtag:05:graphics_package"],

Cell[TextData[{
  "While Mathematica has a large number of plotting routines, no one program \
does everything we need.  It can be useful to export numbers and graphics \
from Mathematica and operate on them individually or with other specialized \
programs.  The number of different creative graphical solutions available \
grows geometrically with the number of different graphical tools that are \
mastered.\nHere, we will just produce a number of examples of plots and \
graphics... (Note, I use a file \"init.m\" to set some options.  Your plots \
may look different from what we see in lecture. If you want to use my init.m \
you can download it from ",
  ButtonBox["here",
    ButtonData:>{
      URL[ "http://pruffle.mit.edu/3.016/init.m"], None},
    ButtonStyle->"Hyperlink"],
  ". Where to locate your init.m file depends on the operating system you are \
using, check out init.m in the Master Index in the Help Browser."
}], "Text",
  CellTags->"mmtag:05:init.m__example_of_using_to_change_default_graphics"],

Cell[CellGroupData[{

Cell["Two-Dimensional Graphics", "Section"],

Cell[CellGroupData[{

Cell["Plot, ParametricPlot, LogPlot, etc", "Subsection"],

Cell[BoxData[
    \(Plot[Sin[x]/x, {x, \(-5\)\ Pi, 5  Pi}]\)], "Input",
  CellTags->{"mmtag:05:plot__examples_with_options", "mmtag:05:Plot[]"}],

Cell[BoxData[
    \(Options[Plot]\)], "Input"],

Cell[BoxData[
    \(Plot[Sin[x]/x, {x, \(-5\) Pi, 5  Pi}, 
      PlotRange \[Rule] {\(-0.25\), 1.25}]\)], "Input"],

Cell[BoxData[
    \(Plot[Sin[x]/x, {x, \(-5\) Pi, 5  Pi}, 
      PlotRange \[Rule] {\(-0.25\), 1.25}, 
      AxesLabel \[Rule] {"\<x\>", \*"\"\<\!\(\(Sin \((x)\)\)\/x\)\>\""}]\)], \
"Input",
  CellTags->"mmtag:05:labels_on_plots"],

Cell[BoxData[
    \(Plot[{Sin[x]/x, Tan[x]/x}, {x, \(-5\) Pi, 5  Pi}, 
      PlotRange \[Rule] {\(-0.25\), 1.25}]\)], "Input"],

Cell[BoxData[
    \(Plot[{Sin[x]/x, Tan[x]/x}, {x, \(-5\) Pi, 5  Pi}, 
      PlotRange \[Rule] {\(-0.25\), 
          1.25}, \[IndentingNewLine]PlotStyle \[Rule] {{Thickness[0.01], 
            Hue[1]}, {Thickness[0.005], Hue[2/3]}}]\)], "Input"],

Cell[CellGroupData[{

Cell[TextData[{
  "ParametricPlot produces a 2-D graph as a function of a single parameter, \
e.g. ",
  StyleBox["t",
    FontSlant->"Italic"],
  ". The cartesian coordinates, e.g. ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  StyleBox["y",
    FontSlant->"Italic"],
  ", are specified as functions ",
  StyleBox["x",
    FontSlant->"Italic"],
  "(",
  StyleBox["t",
    FontSlant->"Italic"],
  ") and ",
  StyleBox["y",
    FontSlant->"Italic"],
  "(",
  StyleBox["t",
    FontSlant->"Italic"],
  "). Thus, a continuous variation of the single parameter ",
  StyleBox["t",
    FontSlant->"Italic"],
  " will trace out a trajectory in the ",
  StyleBox["x-y\:02c6plane.",
    FontSlant->"Italic"]
}], "Subsubsection"],

Cell[BoxData[
    \(\(?ParametricPlot\)\)], "Input",
  CellTags->{
  "mmtag:05:parametric_plots", "mmtag:05:plots__2D parametric_example"}],

Cell[BoxData[
    \(LuckyClover[t_\ \ , \ 
        n_]\  := \ \((1/\((n + 1)\))\) {Cos[\((n + 1)\)\ t\  - \ 
                Pi/4]\  - \ \((n + 1)\)\ Cos[t\  - \ Pi/4], \ 
          Sin[\((n + 1)\)\ t\  - \ Pi/4]\  - \ \((n + 1)\) 
              Sin[t\  - \ Pi/4]}\)], "Input"],

Cell[BoxData[
    \(ParametricPlot[LuckyClover[t, 4], {t, 0, \ 2\ Pi}]\)], "Input",
  CellTags->"mmtag:05:ParametricPlot[]"],

Cell[BoxData[
    \(ParametricPlot[LuckyClover[t, 4], {t, 0, \ 2\ Pi}, \ 
      AspectRatio \[Rule] 1]\)], "Input",
  CellTags->"mmtag:05:plots__2D parametric_example_of_superposed"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The next statement attempts to use the Table function to produce a \
list of six LuckyClover functions and then make one parametric plot of all of \
them.\
\>", "Subsubsection"],

Cell["\<\
It is necessary to use the Evaluate command to get this to \
work.\
\>", "Text",
  CellTags->{
  "mmtag:05:Evaluate[]_and_Plot[]", 
    "mmtag:05:plot_does_not_appear__Evaluate[]"}],

Cell[BoxData[
    \(\(?Evaluate\)\)], "Input"],

Cell[BoxData[
    \(ParametricPlot[
      Evaluate[Table[LuckyClover[t, i], {i, 2, 7}]], {t, 0, \ 2\ Pi}, \ 
      AspectRatio \[Rule] 1]\)], "Input"],

Cell[BoxData[
    \(ParametricPlot[
      Evaluate[Table[LuckyClover[t, i], {i, 2, 7}]], {t, 0, \ 2\ Pi}, \ 
      AspectRatio \[Rule] 1, 
      PlotStyle \[Rule] 
        Table[{Thickness[0.005], Hue[\((2/3)\)*\((i - 2)\)/5]}, {i, 2, 
            7}]]\)], "Input",
  CellTags->{
  "mmtag:05:colors__examples_in_plotting", "mmtag:05:Hue[]__use_in_graphics"}],

Cell[BoxData[
    \(<< Miscellaneous`PhysicalConstants`\)], "Input",
  CellTags->{
  "mmtag:05:Packages__PhysicalConstants", 
    "mmtag:05:physical_constants_package"}],

Cell[BoxData[{
    \(BoltzmannConstant\), "\[IndentingNewLine]", 
    \(ElectronCharge\), "\[IndentingNewLine]", 
    \(SpeedOfLight\)}], "Input"],

Cell[BoxData[
    \(Kelvin[TempCelcius_\ ]\  := \ 273.15\  + \ TempCelcius\)], "Input"],

Cell[BoxData[
    \(Arrhenius[EnergyEV_, \ TempCelcius_\ ]\  := \ 
      Exp[\(-\((EnergyEV*Joule*ElectronCharge)\)\)/\((Kelvin[TempCelcius]*
              BoltzmannConstant*Kelvin*Coulomb)\)]\)], "Input",
  CellTags->"mmtag:05:Arrhenius_function"],

Cell[BoxData[
    \(Arrhenius[e, t]\)], "Input"],

Cell[BoxData[
    \(ParametricPlot[{1/Kelvin[T], Log[Arrhenius[1.0, T]]}, {T, 0, 
        1000}]\)], "Input",
  CellTags->"mmtag:05:Arrhenius_plot_example"],

Cell[BoxData[
    \(arrhenplot\  = 
      ParametricPlot[
        Evaluate[
          Table[{1/Kelvin[T], Log[Arrhenius[ev, T]]}, {ev, 1, 5, 
              1}]], {T, \(-200\), 1000}, 
        PlotStyle \[Rule] 
          Table[{Thickness[0.005], Hue[\((2/3)\)*\((5 - i)\)/4]}, {i, 1, 5, 
              1}]]\)], "Input"],

Cell[BoxData[
    \(Show[arrhenplot, 
      Ticks \[Rule] {Table[{1/Kelvin[T], 
              StringJoin["\<1/\>", ToString[T]]}, {T, \(-200\), 500, 
              100\[IndentingNewLine]}], Automatic}]\)], "Input"],

Cell[BoxData[
    \(BankAccount[InitialInvestment_\ , \ AnnualInterest_, \ 
        NYears_\ ]\  := \ 
      InitialInvestment*\((1\  + \ AnnualInterest/100)\)^NYears\)], "Input"],

Cell[BoxData[
    \(Plot[BankAccount[100, 8.5, t], {t, 0, 50}]\)], "Input"],

Cell[BoxData[
    \(<< Graphics`\)], "Input"],

Cell[BoxData[
    \(LogPlot[BankAccount[100, 8.5, t], {t, 0, 50}]\)], "Input",
  CellTags->"mmtag:05:LogPlot[]"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plotting Data", "Section"],

Cell[CellGroupData[{

Cell["ListPlot, PieChart, Histogram, Barchart, etc", "Subsection"],

Cell[BoxData[
    \(<< Miscellaneous`ChemicalElements`\)], "Input",
  CellTags->{
  "mmtag:05:Packages__ChemicalElements", "mmtag:05:chemical_elements_package"}
    ],

Cell[BoxData[
    \(Elements\)], "Input"],

Cell[BoxData[
    \(e190\  = \ Elements[\([Table[i, {i, 1, 90}]]\)]\)], "Input"],

Cell[BoxData[
    \(mps\  = \ Map[MeltingPoint[#] &, e190] /. Kelvin \[Rule] 1\)], "Input"],

Cell["\<\
The next plot illustrates the variation of melting temperature as a \
function of atomic number\[Ellipsis]\
\>", "Text"],

Cell[BoxData[
    \(ListPlot[mps]\)], "Input"],

Cell[BoxData[
    \(ListPlot[mps, PlotJoined \[Rule] True]\)], "Input"],

Cell[BoxData[
    \(Dens\  = \ 
      Map[Density[#] &, e190] /. {Kilogram \[Rule] 1, \ 
          Meter \[Rule] 1}\)], "Input",
  CellTags->"mmtag:05:Map[]_example"],

Cell["\<\
The next line matches up values of density with melting temperature\
\[Ellipsis]\
\>", "Text"],

Cell[BoxData[
    \(dmdata\  = \ Transpose[{Dens, mps}]\)], "Input"],

Cell[BoxData[
    \(ListPlot[dmdata]\)], "Input",
  CellTags->"mmtag:05:ListPlot[]_example_with_chemical_elements"],

Cell[BoxData[
    \(ListPlot[dmdata, PlotJoined \[Rule] True]\)], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Three-Dimensional Graphics", "Section"],

Cell[CellGroupData[{

Cell["Plot3D, ContourPlot, DensityPlot, etc", "Subsection"],

Cell[BoxData[
    \(EPot[x_, \ y_\ , \ z_\ , \ xo_\ , \ yo_]\  := \ 
      1\/\@\(\((x - xo)\)^2\  + \ \((y - yo)\)^2\  + \ z^2\)\)], "Input",
  CellTags->"mmtag:05:electical_potential_above_lattice_of_charges"],

Cell[BoxData[
    \(SheetOLatticeCharge[x_, \ y_\ , \ z_]\  := \ 
      Sum[EPot[x, y, z, xo, yo], {xo, \(-5\), 5}, {yo, \(-5\), 5}]\)], "Input"],

Cell[TextData[{
  StyleBox["SheetOLatticeCharge",
    FontWeight->"Bold"],
  " represents the electric field produced by an 11 by 11 array of point \
charges arranged on the ",
  StyleBox["x-y",
    FontSlant->"Italic"],
  " plane at ",
  StyleBox["z",
    FontSlant->"Italic"],
  " = 0. The following command evaluates and plots the field variation in the \
plane ",
  StyleBox["z",
    FontSlant->"Italic"],
  " = 0.25:"
}], "Text"],

Cell[BoxData[
    \(Plot3D[
      Evaluate[SheetOLatticeCharge[x, y, 0.25]], {x, \(-6\), 6}, {y, \(-6\), 
        6}]\)], "Input",
  CellTags->{
  "mmtag:05:Graphics__example_of_electical_potential_above_lattice_of_\
charges", "mmtag:05:Plot3D[]"}],

Cell[TextData[{
  "Note below how ",
  StyleBox["theplot",
    FontWeight->"Bold"],
  " is set to contain the output of the Plot3D command."
}], "Text"],

Cell[BoxData[
    \(theplot\  = 
      Plot3D[Evaluate[SheetOLatticeCharge[x, y, 0.25]], {x, \(-6\), 
          6}, {y, \(-6\), 6}, PlotPoints \[Rule] 120]\)], "Input"],

Cell[TextData[{
  "Now we can adjust the viewpoint of ",
  StyleBox["theplot",
    FontWeight->"Bold"],
  ", without recalculating the entire plot, using the ",
  StyleBox["Show",
    FontWeight->"Bold"],
  " command:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Show\)\)], "Input"],

Cell[BoxData[
    RowBox[{"\<\"Show[graphics, options] displays two- and three-dimensional \
graphics, using the options specified. Show[g1, g2, ... ] shows several plots \
combined.\"\>", " ", 
      ButtonBox[
        StyleBox["More\[Ellipsis]",
          "SR"],
        ButtonData:>"Show",
        Active->True,
        ButtonStyle->"RefGuideLink"]}]], "Print",
  CellTags->"Info3335784966-5618393"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Show\)\)], "Input"],

Cell[BoxData[
    RowBox[{"\<\"Show[graphics, options] displays two- and three-dimensional \
graphics, using the options specified. Show[g1, g2, ... ] shows several plots \
combined.\"\>", " ", 
      ButtonBox[
        StyleBox["More\[Ellipsis]",
          "SR"],
        ButtonData:>"Show",
        Active->True,
        ButtonStyle->"RefGuideLink"]}]], "Print",
  CellTags->"Info3335784967-3850736"]
}, Open  ]],

Cell[BoxData[
    \(Show[theplot, ViewPoint \[Rule] {0, \(-5\), 2}]\)], "Input"],

Cell[BoxData[
    \(theconplot\  = 
      ContourPlot[
        Evaluate[SheetOLatticeCharge[x, y, 0.25]], {x, \(-6\), 
          6}, {y, \(-6\), 6}, PlotPoints \[Rule] 120]\)], "Input"],

Cell[BoxData[
    \(theconplot\  = 
      ContourPlot[
        Evaluate[SheetOLatticeCharge[x, y, 0.25]], {x, \(-4\), 
          4}, {y, \(-4\), 4}, PlotPoints \[Rule] 120, 
        ColorFunction \[Rule] Hue, Contours \[Rule] 24]\)], "Input"],

Cell[BoxData[
    \(thedenplot\  = 
      DensityPlot[
        Evaluate[SheetOLatticeCharge[x, y, 0.25]], {x, \(-4\), 
          4}, {y, \(-4\), 4}, PlotPoints \[Rule] 120, 
        ColorFunction \[Rule] \((Hue[1 - #*0.66] &)\)]\)], "Input"],

Cell[BoxData[
    \(Show[thedenplot, Mesh \[Rule] False]\)], "Input",
  CellTags->{"mmtag:05:Show[]", "mmtag:05:Graphics__superposing_with_Show[]"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics Primitives", "Section"],

Cell[TextData[{
  "It can be useful to be able to build up arbitrary graphics objects \
piece-by-piece using simple \"graphics primitives\" like ",
  StyleBox["Circle",
    FontWeight->"Bold"],
  ":"
}], "Text"],

Cell[BoxData[
    \(Show[Graphics[Circle[{2, 2}, 1.5]]]\)], "Input",
  CellTags->{
  "mmtag:05:drawing_with_graphics_primitives", "mmtag:05:graphics_primitives"}
    ],

Cell[BoxData[
    \(Show[Graphics[Circle[{2, 2}, 1.5]], Axes -> True]\)], "Input"],

Cell[BoxData[
    \(Show[Graphics[Circle[{2, 2}, 1.5]], Axes -> True, 
      AxesOrigin \[Rule] {0, 0}, AspectRatio \[Rule] 1]\)], "Input"],

Cell["Now we take a simple plot\[Ellipsis]", "Text"],

Cell[BoxData[
    \(cosplot\  = \ Plot[Cos[x], {x, 0, 4  Pi}]\)], "Input"],

Cell["\<\
and overlay some text in places of our own \
choosing\[Ellipsis]\
\>", "Text"],

Cell[BoxData[
    \(Show[cosplot, Graphics[Text["\<One Wavelength\>", {2\ Pi, 1.1}]], 
      Graphics[Text["\<Two Wavelengths\>", {4\ Pi, 1.1}]], 
      PlotRange \[Rule] All]\)], "Input",
  CellTags->{
  "mmtag:05:plots__annotating__example", "mmtag:05:Text[]__in_graphics"}],

Cell[TextData[{
  "Many processes in the natural world can be modelled by ",
  StyleBox["random walks",
    FontSlant->"Italic"],
  ". An example is the trajectory of a particular  molecule in a gas at low \
pressure.  The next few lines of code produce random walks and display them \
graphically: "
}], "Text"],

Cell[BoxData[
    \(randomwalk[0]\  = \ {0, {0, 0}}\)], "Input",
  CellTags->{
  "mmtag:05:simulation_of_2D_random_walk", 
    "mmtag:05:random_walk__illustration"}],

Cell[BoxData[
    \(\(randomwalk[0]\)[\([2]\)]\)], "Input"],

Cell[BoxData[
    \(randomwalk[
        nstep_Integer?Positive]\  := \ \(randomwalk[
          nstep] = {nstep, \(randomwalk[
                nstep - 1]\)[\([2]\)]\  + \ \[IndentingNewLine]Random[
                Real, {0, 0.5}]*{Cos[theta\  = 2\ Pi\ Random[]], 
                Sin[theta]}}\)\)], "Input"],

Cell[BoxData[
    \(randomwalk[4]\)], "Input"],

Cell[BoxData[
    \(Show[
      Table[Graphics[
          Text[ToString[\(randomwalk[i]\)[\([1]\)]], \(randomwalk[
                i]\)[\([2]\)]]], {i, 0, 100}], PlotRange \[Rule] All, 
      AspectRatio \[Rule] 1, AxesOrigin \[Rule] {0, 0}]\)], "Input"],

Cell[BoxData[
    \(Show[\[IndentingNewLine]Table[
        Graphics[
          Text[ToString[\(randomwalk[i]\)[\([1]\)]], \(randomwalk[
                i]\)[\([2]\)]]], {i, 0, 50}], \[IndentingNewLine]Table[
        Graphics[
          Line[{\(randomwalk[j - 1]\)[\([2]\)], \(randomwalk[
                  j]\)[\([2]\)]}]], {j, 1, 
          50}], \[IndentingNewLine]PlotRange \[Rule] All, 
      AspectRatio \[Rule] 1, AxesOrigin \[Rule] {0, 0}]\)], "Input"],

Cell[BoxData[
    \(<< Graphics`Animation`\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ShowAnimation[\[IndentingNewLine]Table[\[IndentingNewLine]Graphics[\
\[IndentingNewLine]{Text[\[IndentingNewLine]ToString[\(randomwalk[
                    i]\)[\([1]\)]], \(randomwalk[
                  i]\)[\([2]\)]], \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\[IndentingNewLine]Line[{\(randomwalk[i]\)[\([2]\)], \(randomwalk[
                    i + 1]\)[\([2]\)]}]}\[IndentingNewLine]], \
\[IndentingNewLine]{i, 0, 
          49}\[IndentingNewLine]], \[IndentingNewLine]PlotRange \[Rule] \
{{\(-3\), 3}, {\(-3\), 3}}, AspectRatio \[Rule] 1, 
      AxesOrigin \[Rule] {0, 0}\[IndentingNewLine]]\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.5 .5 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(0) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.5 .5 m
.52155 .52756 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z7OoonfX5o`00Oooooo]Z8?oonfX00?oooo]Z7?oonfX7
o`00Oooooo]Z7ooonfX00?oooo]Z7?oonfX3o`00O`04oookJ_l007oo001oo`00Oooooo]Z7ooonfX0
0?oooo]Z6ooonfX3o`00O`?ooo]Z0ol007oooookJQkooo]Z003ooookJQ_ooo]Z0ol007l2oookJP04
o`000?l007oo001oo`00Oooooo]Z7_oonfX00?oooo]Z6ooonfX3o`00O`;ooo]Z00Co0000o`00Ool0
07oo001ooooonfXNoookJP00oooonfXKoookJP?o001o0ooonfX00ol0003o001oo`00O`3ooookJQko
oo]Z003ooookJQ_ooo]Z0ol007l3oookJP03o`00Ool0003o001o0?oooo]Z7_oonfX00?oooo]Z6ooo
nfX3o`00O`?ooo]Z0_l007l00ol0003ooo]ZoookJP3ooookJQcooo]Z003ooookJQ_ooo]Z0ol007l3
oookJP;o001o00?o0000oookJ_oonfX0oooonfXLoookJP00oooonfXLoookJP?o001o00Kooo]Zo`00
Ool007oo001ooookJ_l0003ooookJQgooo]Z003ooookJQcooo]Z1ol007l2oookJP03o`000?oonf[o
oo]Z0?oooo]Z6_oonfX00?oooo]Z7OoonfX5o`00O`Cooo]Z00?o0000oookJ_oonfX0oooonfXIoook
JP00oooonfXVoookJP03o`000?oonf[ooo]Z0?oooo]Z6OoonfX00?oooo]Z9ooonfX00ol0003ooo]Z
oookJP3ooookJQSooo]Z003ooookJRSooo]Z00?o0000oookJ_oonfX0oooonfXGoookJP00oooonfXY
oookJP03o`000?oonf[ooo]Z0?oooo]Z5_oonfX00?oooo]Z:OoonfX00ol0003ooo]ZoookJP3ooook
JQKooo]Z003ooookJR[ooo]Z00?o0000oookJ_oonfX0oooonfXEoookJP00oooonfX[oookJP03o`00
0?oonf[ooo]Z0?oooo]Z5?oonfX00?oooo]Z;?oonfX00ol0003ooo]ZoookJP3ooookJQ?ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00001\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.52155 .52756 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.52155 .52756 m
.58348 .5338 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonfX[
oookJP?o001ooooonfXDoookJP00oooonfX[oookJP?o001ooooonfXDoookJP00oooonfX[oookJP?o
001ooooonfXDoookJP00oooonfX[oookJP?o001ooooonfXDoookJP00oooonfX[oookJP03o`00Ool0
003o000000Go0000oooonfX?oookJP00oooonfX[oookJP?o001o1OoonfX<o`000?oooo]Z0ooonfX0
0?oooo]Z:ooonfX3o`00Oa7ooo]Z3?l0003foookJP00oooonfX[oookJP?o001o7OoonfX6o`000?3o
oo]Z003ooookJR_ooo]Z0ol007oooookJQCooo]Z003ooookJRSooo]Z1_l007oooookJQCooo]Z003o
oookJRSooo]Z1_l007oooookJQCooo]Z003ooookJR[ooo]Z1?l007oooookJQCooo]Z003ooookJR_o
oo]Z0ol007oooookJQCooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.58348 .5338 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(2) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.58348 .5338 m
.59595 .49892 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZEooonfX00ol0003ooo]ZoookJP3WoookJP00oooonfYGoookJP03o`00
0?oonf[ooo]Z0>Oooo]Z003ooookJUKooo]Z00?o0000oookJ_oonfX0j?oonfX00?oooo]ZE_oonfX0
0ol0003ooo]ZoookJP3XoookJP00oooonfYFoookJP03o`000?oonf[ooo]Z0>Sooo]Z003ooookJUGo
oo]Z00?o0000oookJ_oonfX0jOoonfX00?oooo]ZEOoonfX00ol0003ooo]ZoookJP3YoookJP00oooo
nfYEoookJP03o`000?oonf[ooo]Z0>Wooo]Z003ooookJUCooo]Z00?o0000oookJ_oonfX0j_oonfX0
0?oooo]ZE?oonfX00ol0003ooo]ZoookJP3ZoookJP00oooonfYDoookJP03o`000?oonf[ooo]Z0>[o
oo]Z003ooookJU?ooo]Z00?o0000oookJ_oonfX0jooonfX00?oooo]ZDooonfX00ol0003ooo]Zoook
JP3[oookJP00oooonfYCoookJP03o`000?oonf[ooo]Z0>_ooo]Z003ooookJU;ooo]Z00?o0000oook
J_oonfX0k?oonfX00?oooo]ZD_oonfX00ol0003ooo]ZoookJP3/oookJP00oooonfY;oookJPOo001o
00?o0000o`00OooonfX0k?oonfX00?oooo]ZBooonfX6o`00O`03o`000?l007oo001o0>gooo]Z003o
oookJT_ooo]Z1?l007l2oookJP03o`000?oonf[ooo]Z0>gooo]Z003ooookJTcooo]Z1?l007l00ooo
nf[o0000oookJP3^oookJP00oooonfY=oookJP?o001o00?o0000o`00OooonfX0k_oonfX00?oooo]Z
CooonfX4o`00Onkooo]Z003ooookJU3ooo]Z0ol007o^oookJP00oooonfYAoookJP?o001okOoonfX0
0?oooo]ZBooonfX3o`00O`?ooo]Z0ol007o]oookJP00oooonfY;oookJP?o001o0ooonfX3o`00Ongo
oo]Z003ooookJT_ooo]Z1?l007l2oookJP?o001okOoonfX00?oooo]ZC?oonfX7o`00Onkooo]Z003o
oookJTgooo]Z1Ol007o_oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0001\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.59595 .49892 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(3) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.59595 .49892 m
.59989 .53221 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJUCooo]Z1Ol007oXoookJP00oooonfYCoookJPOo001oiooonfX00?oooo]ZD_oonfX3
o`00O`?ooo]Z0ol007oVoookJP00oooonfYBoookJP?o001o0ooonfX3o`00OnKooo]Z003ooookJUOo
oo]Z00Co0000o`00Ool007oo001oi_oonfX00?oooo]ZEooonfX01?l0003o001oo`00Ool007oVoook
JP00oooonfYFoookJP04o`00Ool0003o001oo`00OnOooo]Z003ooookJUKooo]Z00?o001oo`000?l0
07l0j?oonfX00?oooo]ZEooonfX00ol0003o001oo`00O`3WoookJP00oooonfYBoookJP?o001o0_oo
nfX01?l0003o001oo`00Ool007oVoookJP00oooonfYBoookJP?o001o0ooonfX00ol0003o001oo`00
O`3VoookJP00oooonfYCoookJPGo001o00?o0000o`00OooonfX0i_oonfX00?oooo]ZE?oonfX4o`00
O`03o`000?oonf[ooo]Z0>Kooo]Z003ooookJUSooo]Z00?o0000oookJ_oonfX0i_oonfX00?oooo]Z
F?oonfX00ol0003ooo]ZoookJP3VoookJP00oooonfYHoookJP03o`000?oonf[ooo]Z0>Kooo]Z003o
oookJUSooo]Z00?o0000oookJ_oonfX0i_oonfX00?oooo]ZF?oonfX00ol0003ooo]ZoookJP3Voook
JP00oooonfYHoookJP03o`000?oonf[ooo]Z0>Kooo]Z003ooookJUSooo]Z00?o0000oookJ_oonfX0
i_oonfX00?oooo]ZFOoonfX00ol0003ooo]ZoookJP3UoookJP00oooonfYIoookJP03o`000?oonf[o
oo]Z0>Gooo]Z003ooookJUWooo]Z00?o0000oookJ_oonfX0iOoonfX00?oooo]ZFOoonfX00ol0003o
oo]ZoookJP3UoookJP00oooonfYIoookJP03o`000?oonf[ooo]Z0>Gooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00001\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.59989 .53221 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(4) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.59989 .53221 m
.63048 .51816 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJV[ooo]Z0_l0003EoookJP00oooonfYXoookJP;o0000eooo
nfX00?oooo]ZI_oonfX2o`000=Wooo]Z003ooookJVCooo]Z0_l0003KoookJP00oooonfYRoookJP;o
0000gOoonfX00?oooo]ZFOoonfX3o`00O`Cooo]Z0_l0003OoookJP00oooonfYIoookJP?o001o0_oo
nfX2o`000>7ooo]Z003ooookJUWooo]Z0ol007l2o`000>?ooo]Z003ooookJUCooo]Z1_l007l2o`00
0003o`00Oooonf[ooo]Z0>;ooo]Z003ooookJUCooo]Z1Ol007l01?l0003o001oo`00Ool007oToook
JP00oooonfYDoookJP;o001o0ooonfX3o`00OnGooo]Z003ooookJUGooo]Z0_l007l2oookJP?o001o
iOoonfX00?oooo]ZEOoonfX3o`00O`04oookJ_l007oo001oo`00OnGooo]Z003ooookJUKooo]Z0_l0
07l01?oonf[o001oo`00Ool007oUoookJP00oooonfYGoookJPGo001oiOoonfX00?oooo]ZEooonfX5
o`00OnGooo]Z003ooookJUSooo]Z1?l007oUoookJP00oooonfYIoookJP?o001oiOoonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z0000\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.63048 .51816 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(5) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.63048 .51816 m
.66899 .52098 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonfYXoookJPGo001oe?oonfX00?oooo]ZIooonfX7o`00Om?ooo]Z003ooook
JVKooo]Z1?l007l01?oonf[o001oo`00Ool007oCoookJP00oooonfYVoookJP?o001o0ooonfX3o`00
Om;ooo]Z003ooookJV_ooo]Z1ol0003?oookJP00oooonfY/oookJP?o001o0ooonfX;o`000<Cooo]Z
003ooookJVOooo]Z0_l007l2oookJPCo001o3_oonfX5o`000;oooo]Z003ooookJVOooo]Z1ol007oC
oookJP00oooonfYWoookJPKo001oe?oonfX00?oooo]ZIooonfX2o`00OmSooo]Z003ooookJVOooo]Z
0_l007oHoookJP00oooonfYXoookJPOo001od_oonfX00?oooo]ZJ?oonfX7o`00Om;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.66899 .52098 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(6) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.66899 .52098 m
.6713 .52256 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZO_oonfX5o`00
Okkooo]Z003ooookJWgooo]Z1ol007nmoookJP00oooonfYmoookJP?o001o0_oonfX3o`00Okcooo]Z
003ooookJWcooo]Z0ol007l3oookJP?o001o_?oonfX00?oooo]ZO?oonfX3o`00O`;ooo]Z00Co0000
o`00Ool007oo001o_?oonfX00?oooo]ZO?oonfX4o`00O`;ooo]Z00?o0000o`00Ool007l0_?oonfX0
0?oooo]ZO?oonfX8o`00Okgooo]Z003ooookJWcooo]Z0ol007l01?oonf[o001oo`00Ool007nnoook
JP00oooonfYloookJP?o001o`_oonfX00?oooo]ZO?oonfX3o`00Ol;ooo]Z003ooookJWgooo]Z0ol0
07l2oookJP?o001o_?oonfX00?oooo]ZOOoonfX7o`00Okgooo]Z003ooookJWoooo]Z1?l007nnoook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.6713 .52256 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(7) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.6713 .52256 m
.67959 .51202 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJXOooo]Z00?o0000oookJ_oonfX0]ooonfX0
0?oooo]ZQooonfX00ol0003ooo]ZoookJP2goookJP00oooonfYooookJP?o001o1?oonfX00ol0003o
oo]ZoookJP2hoookJP00oooonfYooookJP?o001o0ooonfX00ol0003ooo]ZoookJP2ioookJP00oooo
nfYooookJP?o001o0_oonfX00ol0003ooo]ZoookJP2joookJP00oooonfZ0oookJP;o001o00?ooo]Z
o`000?oonfX0_?oonfX00?oooo]ZP?oonfX2o`00O`03o`000?oonf[ooo]Z0;cooo]Z003ooookJX3o
oo]Z0ol007nnoookJP00oooonfZ1oookJP;o001o__oonfX00?oooo]ZPOoonfX3o`00Okgooo]Z003o
oookJX;ooo]Z0_l007nmoookJP00oooonfZ3oookJP;o001o_?oonfX00?oooo]ZPooonfX2o`00Okco
oo]Z003ooookJWgooo]Z2Ol007nkoookJP00oooonfYmoookJPWo001o^ooonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z0000\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.67959 .51202 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(8) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.67959 .51202 m
.69125 .5674 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonfZ4oookJPGo001o^?oonfX00?oooo]ZPooonfX7o`00OkOo
oo]Z003ooookJX;ooo]Z0ol007l3oookJP?o001o]_oonfX00?oooo]ZP_oonfX3o`00O`?ooo]Z0ol0
07nfoookJP00oooonfZ2oookJP?o001o0_oonfX01?l0003o001oo`00Ool007nfoookJP00oooonfZ2
oookJP?o001o0_oonfX01?l0003o001oo`00Ool007nfoookJP00oooonfZ3oookJPCo001o00?o0000
o`00Ool007l0]ooonfX00?oooo]ZPooonfX5o`00O`03o`000?l007oooo]Z0;Kooo]Z003ooookJX;o
oo]Z0ol007l3oookJP03o`000?l007oo001o0;Kooo]Z003ooookJX;ooo]Z0ol007l3oookJP03o`00
0?l007oo001o0;Kooo]Z003ooookJX;ooo]Z0ol007l3oookJP03o`000?l007oo001o0;Kooo]Z003o
oookJX?ooo]Z1Ol007l00ol0003o001ooookJP2foookJP00oooonfZ4oookJPGo001o00?o0000oook
J_oonfX0]OoonfX00?oooo]ZROoonfX00ol0003ooo]ZoookJP2eoookJP00oooonfZ9oookJP03o`00
0?oonf[ooo]Z0;Gooo]Z003ooookJXWooo]Z00?o0000oookJ_oonfX0]OoonfX00?oooo]ZR_oonfX0
0ol0003ooo]ZoookJP2doookJP00oooonfZ:oookJP03o`000?oonf[ooo]Z0;Cooo]Z003ooookJX[o
oo]Z00?o0000oookJ_oonfX0]?oonfX00?oooo]ZR_oonfX00ol0003ooo]ZoookJP2doookJP00oooo
nfZ:oookJP03o`000?oonf[ooo]Z0;Cooo]Z003ooookJX_ooo]Z00?o0000oookJ_oonfX0/ooonfX0
0?oooo]ZRooonfX00ol0003ooo]ZoookJP2coookJP00oooonfZ;oookJP03o`000?oonf[ooo]Z0;?o
oo]Z003ooookJX_ooo]Z00?o0000oookJ_oonfX0/ooonfX00?oooo]ZRooonfX00ol0003ooo]Zoook
JP2coookJP00oooonfZ<oookJP03o`000?oonf[ooo]Z0;;ooo]Z003ooookJXcooo]Z00?o0000oook
J_oonfX0/_oonfX00?oooo]ZS?oonfX00ol0003ooo]ZoookJP2boookJP00oooonfZ<oookJP03o`00
0?oonf[ooo]Z0;;ooo]Z003ooookJXgooo]Z00?o0000oookJ_oonfX0/OoonfX00?oooo]ZSOoonfX0
0ol0003ooo]ZoookJP2aoookJP00oooonfZ=oookJP03o`000?oonf[ooo]Z0;7ooo]Z003ooookJXgo
oo]Z00?o0000oookJ_oonfX0/OoonfX00?oooo]ZSOoonfX00ol0003ooo]ZoookJP2aoookJP00oooo
nfZ>oookJP03o`000?oonf[ooo]Z0;3ooo]Z003ooookJXkooo]Z00?o0000oookJ_oonfX0/?oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z0000\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.69125 .5674 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(9) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.69125 .5674 m
.68692 .55808 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonfZ;oook
JP03o`000?oonf[ooo]Z0;?ooo]Z003ooookJX_ooo]Z00?o0000oookJ_oonfX0/ooonfX00?oooo]Z
RooonfX01?l007oo0000o`00Ool007nboookJP00oooonfZ:oookJP;o001o00?o0000o`00Ool007l0
0_l007n`oookJP00oooonfZ9oookJP?o001o00?ooo]Zo`000?l007l00_l007n`oookJP00oooonfZ=
oookJP03o`000?oonf[o001o00;o001o[ooonfX00?oooo]ZRooonfX3o`00O`04o`000?l007oo001o
o`00Ojoooo]Z003ooookJX[ooo]Z2?l007n_oookJP00oooonfZ9oookJP?o001o0_oonfX4o`00Ojoo
oo]Z003ooookJXWooo]Z0ol007l3oookJP?o001o[ooonfX00?oooo]ZROoonfX3o`00O`?ooo]Z0ol0
07n_oookJP00oooonfZ9oookJP?o001o0ooonfX3o`00Ojoooo]Z003ooookJXWooo]Z1?l007l01?oo
nf[o001oo`00Ool007n`oookJP00oooonfZ:oookJPOo001o/?oonfX00?oooo]ZRooonfX5o`00Ok7o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z0000\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.68692 .55808 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(10) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.68692 .55808 m
.68678 .54185 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonfZ;oookJP03o`000?oonf[ooo]Z0;?ooo]Z003ooookJX_ooo]Z
00?o0000oookJ_oonfX0/ooonfX00?oooo]ZRooonfX00ol0003ooo]ZoookJP2coookJP00oooonfZ;
oookJP03o`000?oonf[ooo]Z0;?ooo]Z003ooookJX_ooo]Z00?o0000oookJ_oonfX0/ooonfX00?oo
oo]ZQOoonfX3o`00O`?ooo]Z00?o0000oookJ_l007l01?l007n_oookJP00oooonfZ5oookJP?o001o
0ooonfX00ol0003o001oo`00O`05o`00Ojkooo]Z003ooookJXGooo]Z0ol007l3oookJP05o`000?l0
07oo001oo`00OooonfX00ol007n^oookJP00oooonfZ5oookJP?o001o0ooonfX00ol0003o001oo`00
O`03oookJP?o001o[OoonfX00?oooo]ZQOoonfX3o`00O`?ooo]Z00?o0000o`00Ool007l00ooonfX3
o`00Ojgooo]Z003ooookJXGooo]Z0ol007l3oookJP?o001o0ooonfX3o`00Ojgooo]Z003ooookJXGo
oo]Z0ol007l3oookJP?o001o0ooonfX3o`00Ojgooo]Z003ooookJXGooo]Z0ol007l3oookJP?o001o
0ooonfX3o`00Ojgooo]Z003ooookJXGooo]Z0ol007l3oookJP?o001o0ooonfX3o`00Ojgooo]Z003o
oookJX;ooo]Z1_l007l3oookJP?o001o0ooonfX3o`00Ojgooo]Z003ooookJX;ooo]Z1_l007l4oook
JP?o001o00Cooo]Zo`00Ool007oo001o[_oonfX00?oooo]ZQ?oonfX4o`00O`Cooo]Z1ol007n^oook
JP00oooonfZ5oookJP?o001o1OoonfX5o`00Ojoooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z0000\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.68678 .54185 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(11) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.68678 .54185 m
.69007 .56722 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZQOoonfX3o`00O`Oooo]Z0ol007n_oookJP00oooonfZ5oookJP?o001o1ooo
nfX3o`00Ojoooo]Z003ooookJXGooo]Z0ol007l7oookJP?o001o[ooonfX00?oooo]ZQOoonfX3o`00
O`Oooo]Z0ol007n_oookJP00oooonfZ5oookJP?o001o0ooonfX01?l0003ooo]ZoookJ_oonfX3o`00
Ojoooo]Z003ooookJXGooo]Z0ol007l3oookJP04o`000?oonf[ooo]ZoookJP?o001o[ooonfX00?oo
oo]ZQOoonfX3o`00O`?ooo]Z00Co0000oookJ_oonf[ooo]Z0ol007n_oookJP00oooonfZ5oookJP?o
001o0ooonfX01?l0003ooo]ZoookJ_oonfX3o`00Ojoooo]Z003ooookJXGooo]Z0ol007l3oookJP04
o`000?oonf[ooo]ZoookJP?o001o[ooonfX00?oooo]ZP_oonfX6o`00O`Cooo]Z00?o0000o`00Ool0
07l00ol007n_oookJP00oooonfZ2oookJPKo001o1?oonfX00ol0003o001oo`00O`03o`00Ojoooo]Z
003ooookJXCooo]Z1?l007l4oookJP03o`000?oonf[o001o00?o001o[ooonfX00?oooo]ZQOoonfX3
o`00O`Cooo]Z00?o0000oookJ_oonfX00ol007n_oookJP00oooonfZ<oookJP03o`000?oonf[ooo]Z
0;;ooo]Z003ooookJXcooo]Z00?o0000oookJ_oonfX0/_oonfX00?oooo]ZS?oonfX00ol0003ooo]Z
oookJP2boookJP00oooonfZ=oookJP03o`000?oonf[ooo]Z0;7ooo]Z003ooookJXgooo]Z00?o0000
oookJ_oonfX0/OoonfX00?oooo]ZSOoonfX00ol0003ooo]ZoookJP2aoookJP00oooonfZ=oookJP03
o`000?oonf[ooo]Z0;7ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.69007 .56722 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(12) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.69007 .56722 m
.63886 .52788 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJW3ooo]Z0_l0003?oookJP00oooonfYboookJP03o`000?oonf[ooo]Z0<cooo]Z003ooook
JW?ooo]Z00?o0000oookJ_oonfX0booonfX00?oooo]ZM?oonfX00ol0003ooo]ZoookJP3:oookJP00
oooonfYeoookJP;o0000b_oonfX00?oooo]ZMooonfX00ol0003ooo]ZoookJP37oookJP00oooonfYh
oookJP03o`000?oonf[ooo]Z0<Kooo]Z003ooookJWWooo]Z00?o0000oookJ_oonfX0aOoonfX00?oo
oo]ZN_oonfX2o`000<Gooo]Z003ooookJWcooo]Z00?o0000oookJ_oonfX0`_oonfX00?oooo]ZOOoo
nfX00ol0003ooo]ZoookJP31oookJP00oooonfYnoookJP;o0000`OoonfX00?oooo]ZP?oonfX00ol0
003ooo]ZoookJP2noookJP00oooonfZ1oookJP03o`000?oonf[ooo]Z0;gooo]Z003ooookJX;ooo]Z
00?o0000oookJ_oonfX0_?oonfX00?oooo]ZPooonfX2o`000;cooo]Z003ooookJXGooo]Z00?o0000
oookJ_oonfX0^OoonfX00?oooo]ZQ_oonfX00ol0003ooo]ZoookJP2hoookJP00oooonfZ7oookJP03
o`000?oonf[ooo]Z0;Oooo]Z003ooookJXOooo]Z00?o001oo`000?l000000ooonfX9o`00Oj_ooo]Z
003ooookJXOooo]Z0ol007l00ol0003ooo]ZoookJP09o`00Oj_ooo]Z003ooookJXOooo]Z0ol007l0
0ooonf[o0000oookJP04o`00Ok3ooo]Z003ooookJXOooo]Z0ol007l2oookJP03o`000?oonf[o001o
00?o001o[ooonfX00?oooo]ZQooonfX3o`00O`?ooo]Z00?o0000oookJ_l007l01?l007n]oookJP00
oooonfZ7oookJP?o001o1ooonfX4o`00Ojcooo]Z003ooookJXOooo]Z0ol007l8oookJP?o001o[?oo
nfX00?oooo]ZQooonfX3o`00O`Wooo]Z0ol007n[oookJP00oooonfZ7oookJP?o001o0ooonfX3o`00
O`?ooo]Z0ol007n[oookJP00oooonfZ4oookJPKo001o0ooonfX3o`00O`?ooo]Z0ol007n[oookJP00
oooonfZ4oookJPKo001o0ooonfX4o`00O`;ooo]Z0ol007n[oookJP00oooonfZ6oookJPCo001o1?oo
nfX7o`00Ojcooo]Z003ooookJXOooo]Z0ol007l5oookJPGo001o[OoonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00001\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.63886 .52788 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(13) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.63886 .52788 m
.64947 .57333 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonfYZ
oookJP?o001o1OoonfX5o`00Ol[ooo]Z003ooookJV[ooo]Z0ol007l4oookJPOo001obOoonfX00?oo
oo]ZJ_oonfX3o`00O`?ooo]Z0ol007l3oookJP?o001ob?oonfX00?oooo]ZJ_oonfX3o`00O`?ooo]Z
0ol007l3oookJP?o001ob?oonfX00?oooo]ZJ_oonfX3o`00O`?ooo]Z00?o0000oookJ_oonfX00ooo
nfX3o`00OlSooo]Z003ooookJV[ooo]Z0ol007l3oookJP03o`000?oonf[ooo]Z00?ooo]Z0ol007o8
oookJP00oooonfYZoookJP?o001o0ooonfX01?l0003ooo]ZoookJ_oonfX4o`00OlWooo]Z003ooook
JV[ooo]Z0ol007l4oookJP03o`000?oonf[ooo]Z00?o001ob_oonfX00?oooo]ZJ_oonfX3o`00O`Co
oo]Z00?o0000oookJ_oonfX00_oonfX2o`00OlWooo]Z003ooookJVOooo]Z1_l007l3oookJP03o`00
Ool0003o001o00?ooo]Z0ol007o8oookJP00oooonfYWoookJPKo001o0ooonfX00ol007oo0000o`00
O`03oookJP?o001ob?oonfX00?oooo]ZJOoonfX4o`00O`Cooo]Z00?o001oo`000?l007l01?l007o9
oookJP00oooonfYZoookJP?o001o1OoonfX00ol0003o001oo`00O`02o`00Ol[ooo]Z003ooookJW;o
oo]Z00?o0000oookJ_oonfX0c?oonfX00?oooo]ZL_oonfX00ol0003ooo]ZoookJP3<oookJP00oooo
nfYboookJP03o`000?oonf[ooo]Z0<cooo]Z003ooookJW?ooo]Z00?o0000oookJ_oonfX0booonfX0
0?oooo]ZLooonfX00ol0003ooo]ZoookJP3;oookJP00oooonfYcoookJP03o`000?oonf[ooo]Z0<_o
oo]Z003ooookJW?ooo]Z00?o0000oookJ_oonfX0booonfX00?oooo]ZM?oonfX00ol0003ooo]Zoook
JP3:oookJP00oooonfYdoookJP03o`000?oonf[ooo]Z0<[ooo]Z003ooookJWCooo]Z00?o0000oook
J_oonfX0b_oonfX00?oooo]ZM?oonfX00ol0003ooo]ZoookJP3:oookJP00oooonfYeoookJP03o`00
0?oonf[ooo]Z0<Wooo]Z003ooookJWGooo]Z00?o0000oookJ_oonfX0bOoonfX00?oooo]ZMOoonfX0
0ol0003ooo]ZoookJP39oookJP00oooonfYeoookJP03o`000?oonf[ooo]Z0<Wooo]Z003ooookJWGo
oo]Z00?o0000oookJ_oonfX0bOoonfX00?oooo]ZM_oonfX00ol0003ooo]ZoookJP38oookJP00oooo
nfYfoookJP03o`000?oonf[ooo]Z0<Sooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.64947 .57333 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(14) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.64947 .57333 m
.65791 .54712 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonfYkoookJP03o`000?oonf[ooo]Z0<?ooo]Z003ooookJW_ooo]Z00?o0000oook
J_oonfX0`ooonfX00?oooo]ZN_oonfX00ol0003ooo]ZoookJP34oookJP00oooonfYjoookJP03o`00
0?oonf[ooo]Z0<Cooo]Z003ooookJW[ooo]Z00?o0000oookJ_oonfX0a?oonfX00?oooo]ZNOoonfX0
0ol0003ooo]ZoookJP35oookJP00oooonfYioookJP03o`000?oonf[ooo]Z0<Gooo]Z003ooookJWWo
oo]Z00?o0000oookJ_oonfX0aOoonfX00?oooo]ZN?oonfX00ol0003ooo]ZoookJP36oookJP00oooo
nfYhoookJP03o`000?oonf[ooo]Z0<Kooo]Z003ooookJWSooo]Z00?o0000oookJ_oonfX0a_oonfX0
0?oooo]ZL?oonfX3o`00O`Cooo]Z00Co0000oookJ_oonf[ooo]Z0ol007o3oookJP00oooonfY`oook
JP?o001o1?oonfX01?l0003ooo]ZoookJ_oonfX3o`00Ol?ooo]Z003ooookJW3ooo]Z0ol007l4oook
JP04o`000?oonf[ooo]ZoookJP?o001o`ooonfX00?oooo]ZL?oonfX3o`00O`?ooo]Z00?o0000o`00
Ool007l01_l007o2oookJP00oooonfY`oookJP?o001o0ooonfX00ol0003o001oo`00O`06o`00Ol;o
oo]Z003ooookJW3ooo]Z0ol007l3oookJP;o001o0ooonfX3o`00Ol?ooo]Z003ooookJW3ooo]Z0ol0
07l4oookJP;o001o0_oonfX3o`00Ol?ooo]Z003ooookJW3ooo]Z0ol007l4oookJP?o001o00Cooo]Z
o`00Ool007oo001o`ooonfX00?oooo]ZL?oonfX3o`00O`Gooo]Z0_l007l01?oonf[o001oo`00Ool0
07o3oookJP00oooonfY]oookJPKo001o1_oonfX5o`00Ol?ooo]Z003ooookJVgooo]Z1_l007l6oook
JPGo001o`ooonfX00?oooo]ZKooonfX4o`00O`Oooo]Z1?l007o3oookJP00oooonfY`oookJP?o001o
2?oonfX3o`00Ol?ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z0000\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.65791 .54712 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(15) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.65791 .54712 m
.67098 .54566 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZMOoonfX3o`00O`Gooo]Z1Ol007nooookJP00oooonfYeoookJP?o001o1?oonfX7o`00Okko
oo]Z003ooookJWGooo]Z0ol007l3oookJPCo001o00Cooo]Zo`00Ool007oo001o__oonfX00?oooo]Z
MOoonfX3o`00O`?ooo]Z0ol007l00ooonf[o0000o`000002o`000003o`00Oooonf[ooo]Z0;_ooo]Z
003ooookJWGooo]Z0ol007l3oookJPCo00000_oonfX3o`00Okgooo]Z003ooookJWGooo]Z0ol007l9
oookJP?o001o_OoonfX00?oooo]ZMOoonfX3o`00O`Cooo]Z0_l007l2oookJPCo001o_OoonfX00?oo
oo]ZMOoonfX3o`00O`Cooo]Z1ol007nnoookJP00oooonfYeoookJP?o001o1?oonfX6o`00Okoooo]Z
003ooookJW;ooo]Z1_l007l4oookJP;o001o`ooonfX00?oooo]ZL_oonfX6o`00O`Cooo]Z0_l007o3
oookJP00oooonfYdoookJPCo001o1OoonfX7o`00Okgooo]Z003ooookJWGooo]Z0ol007l5oookJPOo
001o_OoonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00001\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.67098 .54566 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(16) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.67098 .54566 m
.72316 .48875 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonfZPoookJP03
o`000?oonf[ooo]Z09kooo]Z003ooookJZ3ooo]Z00?o0000oookJ_oonfX0W_oonfX00?oooo]ZWooo
nfX00ol0003ooo]ZoookJP2OoookJP00oooonfZNoookJP03o`000?oonf[ooo]Z0:3ooo]Z003ooook
JYgooo]Z00?o0000oookJ_oonfX0XOoonfX00?oooo]ZW?oonfX00ol0003ooo]ZoookJP2RoookJP00
oooonfZKoookJP03o`000?oonf[ooo]Z0:?ooo]Z003ooookJY[ooo]Z00?o0000oookJ_oonfX0Y?oo
nfX00?oooo]ZVOoonfX00ol0003ooo]ZoookJP2UoookJP00oooonfZHoookJP03o`000?oonf[ooo]Z
0:Kooo]Z003ooookJYOooo]Z00?o0000oookJ_oonfX0YooonfX00?oooo]ZU_oonfX00ol0003ooo]Z
oookJP2XoookJP00oooonfZEoookJP03o`000?oonf[ooo]Z0:Wooo]Z003ooookJYCooo]Z00?o0000
oookJ_oonfX0Z_oonfX00?oooo]ZTooonfX00ol0003ooo]ZoookJP2[oookJP00oooonfZBoookJP03
o`000?oonf[ooo]Z0:cooo]Z003ooookJY7ooo]Z00?o0000oookJ_oonfX0[OoonfX00?oooo]ZTOoo
nfX00ol0003ooo]ZoookJP2]oookJP00oooonfZ@oookJP03o`000?oonf[ooo]Z0:kooo]Z003ooook
JXoooo]Z00?o0000oookJ_oonfX0[ooonfX00?oooo]ZS_oonfX00ol0003ooo]ZoookJP2`oookJP00
oooonfZ=oookJP03o`000?oonf[ooo]Z0;7ooo]Z003ooookJXcooo]Z00?o0000oookJ_oonfX0/_oo
nfX00?oooo]ZRooonfX00ol0003ooo]ZoookJP2coookJP00oooonfZ:oookJP03o`000?oonf[ooo]Z
0;Cooo]Z003ooookJXWooo]Z00?o0000oookJ_oonfX0]OoonfX00?oooo]ZR?oonfX00ol0003ooo]Z
oookJP2foookJP00oooonfZ7oookJP03o`000?oonf[ooo]Z0;Oooo]Z003ooookJWcooo]Z0ol007l5
oookJP;o001o00?o0000o`00Ool007l0^?oonfX00?oooo]ZO?oonfX3o`00O`Cooo]Z0_l007l00ol0
003o001oo`00O`02o`00OkOooo]Z003ooookJWcooo]Z0ol007l4oookJP03o`00Ool0003o001o00;o
oo]Z0ol007nfoookJP00oooonfYloookJP?o001o0ooonfX00ol007oo0000o`00O`03oookJP?o001o
]_oonfX00?oooo]ZO?oonfX3o`00O`?ooo]Z00?o0000o`00Ool007l00ooonfX3o`00OkKooo]Z003o
oookJWcooo]Z0ol007l3oookJPCo001o0_oonfX3o`00OkKooo]Z003ooookJWcooo]Z0ol007l3oook
JPSo001o]ooonfX00?oooo]ZO?oonfX3o`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007nhoook
JP00oooonfYloookJP?o001o0ooonfX3o`00Okcooo]Z003ooookJWWooo]Z1_l007l3oookJP?o001o
_?oonfX00?oooo]ZNOoonfX6o`00O`Cooo]Z0ol007l2oookJP?o001o]_oonfX00?oooo]ZNooonfX4
o`00O`Cooo]Z1ol007ngoookJP00oooonfYloookJP?o001o1_oonfX4o`00OkSooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00001\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.72316 .48875 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(17) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.72316 .48875 m
.78005 .47813 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z_ooonfX3
o`0007oooo]Z003ooookJ[[ooo]Z1Ol00022oookJP00oooonfZeoookJPGo0000QooonfX00?oooo]Z
V_oonfX3o`00O`Gooo]Z0ol007l;oookJPGo0000S?oonfX00?oooo]ZV_oonfX3o`00O`Gooo]Z0ol0
07l7oookJPCo0000TOoonfX00?oooo]ZV_oonfX3o`00O`Gooo]Z0ol007l2oookJPGo0000UOoonfX0
0?oooo]ZV_oonfX3o`00O`Gooo]Z1Ol0002JoookJP00oooonfZJoookJP?o001o0ooonfX2o`000004
oookJ_l007oo001oo`00Oi_ooo]Z003ooookJY[ooo]Z0ol007l6oookJP?o001oVooonfX00?oooo]Z
V_oonfX3o`00O`Oooo]Z0_l007nKoookJP00oooonfZJoookJP?o001o1ooonfX3o`00Oi[ooo]Z003o
oookJY[ooo]Z0ol007l8oookJP;o001oV_oonfX00?oooo]ZUooonfX6o`00O`Wooo]Z0_l007nIoook
JP00oooonfZGoookJPKo001o2OoonfX2o`00OiWooo]Z003ooookJYWooo]Z1?l007l3oookJPWo001o
V?oonfX00?oooo]ZV_oonfX3o`00O`?ooo]Z2Ol007nHoookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.78005 .47813 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(18) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.78005 .47813 m
.79058 .40447 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
aooonfX00ol0003ooo]ZoookJP1goookJP00oooonf[7oookJP03o`000?oonf[ooo]Z07Oooo]Z003o
oookJ/Oooo]Z00?o0000oookJ_oonfX0MooonfX00?oooo]ZaooonfX00ol0003ooo]ZoookJP1goook
JP00oooonf[6oookJP03o`000?oonf[ooo]Z07Sooo]Z003ooookJ/Kooo]Z00?o0000oookJ_oonfX0
N?oonfX00?oooo]Za_oonfX00ol0003ooo]ZoookJP1hoookJP00oooonf[6oookJP03o`000?oonf[o
oo]Z07Sooo]Z003ooookJ/Kooo]Z00?o0000oookJ_oonfX0N?oonfX00?oooo]Za_oonfX00ol0003o
oo]ZoookJP1hoookJP00oooonf[6oookJP03o`000?oonf[ooo]Z07Sooo]Z003ooookJ/Gooo]Z00?o
0000oookJ_oonfX0NOoonfX00?oooo]ZaOoonfX00ol0003ooo]ZoookJP1ioookJP00oooonf[5oook
JP03o`000?oonf[ooo]Z07Wooo]Z003ooookJ/Gooo]Z00?o0000oookJ_oonfX0NOoonfX00?oooo]Z
aOoonfX00ol0003ooo]ZoookJP1ioookJP00oooonf[5oookJP03o`000?oonf[ooo]Z07Wooo]Z003o
oookJ/Gooo]Z00?o0000oookJ_oonfX0NOoonfX00?oooo]Za?oonfX00ol0003ooo]ZoookJP1joook
JP00oooonf[4oookJP03o`000?oonf[ooo]Z07[ooo]Z003ooookJ/Cooo]Z00?o0000oookJ_oonfX0
N_oonfX00?oooo]Za?oonfX00ol0003ooo]ZoookJP1joookJP00oooonf[4oookJP03o`000?oonf[o
oo]Z07[ooo]Z003ooookJ/Cooo]Z00?o0000oookJ_oonfX0N_oonfX00?oooo]Za?oonfX00ol0003o
oo]ZoookJP1joookJP00oooonf[3oookJP03o`000?oonf[ooo]Z07_ooo]Z003ooookJ/?ooo]Z00?o
0000oookJ_oonfX0NooonfX00?oooo]Z`ooonfX00ol0003ooo]ZoookJP1koookJP00oooonf[3oook
JP03o`000?oonf[ooo]Z07_ooo]Z003ooookJ/?ooo]Z00?o0000oookJ_oonfX0NooonfX00?oooo]Z
`ooonfX00ol0003ooo]ZoookJP1koookJP00oooonf[3oookJP03o`000?oonf[ooo]Z07_ooo]Z003o
oookJ/;ooo]Z00?o0000oookJ_oonfX0O?oonfX00?oooo]Z`_oonfX00ol0003ooo]ZoookJP1loook
JP00oooonf[2oookJP03o`000?oonf[ooo]Z07cooo]Z003ooookJ/;ooo]Z00?o0000oookJ_oonfX0
O?oonfX00?oooo]Z`_oonfX00ol0003ooo]ZoookJP1loookJP00oooonf[2oookJP03o`000?oonf[o
oo]Z07cooo]Z003ooookJ[_ooo]Z0ol007l4oookJP03o`000?l007oo001o00?o001oNOoonfX00?oo
oo]Z^ooonfX3o`00O`?ooo]Z00?o0000o`00Ool007l01Ol007mhoookJP00oooonfZkoookJP?o001o
0ooonfX00ol0003o001oo`00O`03oookJP?o001oMooonfX00?oooo]Z^ooonfX3o`00O`?ooo]Z00?o
0000o`00Ool007l00ooonfX3o`00OgOooo]Z003ooookJ[_ooo]Z0ol007l3oookJP03o`000?l007oo
001o00?ooo]Z0ol007mgoookJP00oooonfZkoookJP?o001o0ooonfX3o`00O`?ooo]Z0ol007mgoook
JP00oooonfZkoookJP?o001o1?oonfX7o`00OgSooo]Z003ooookJ[_ooo]Z0ol007l4oookJPOo001o
N?oonfX00?oooo]Z^ooonfX3o`00O`?ooo]Z0ol007l3oookJP?o001oMooonfX00?oooo]Z^?oonfX6
o`00O`?ooo]Z0ol007l3oookJP?o001oMooonfX00?oooo]Z^?oonfX6o`00O`?ooo]Z0ol007l3oook
JP?o001oMooonfX00?oooo]Z^_oonfX4o`00O`Cooo]Z1ol007mhoookJP00oooonfZkoookJP?o001o
1OoonfX5o`00OgWooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0001\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.79058 .40447 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(19) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.79058 .40447 m
.824 .43378 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ/7ooo]Z0ol0
07l5oookJPCo001oM?oonfX00?oooo]Z`OoonfX3o`00O`Cooo]Z1ol007mboookJP00oooonf[1oook
JP?o001o0ooonfX3o`00O`;ooo]Z0ol007mboookJP00oooonf[1oookJP?o001o2OoonfX3o`00Og7o
oo]Z003ooookJ/7ooo]Z0ol007l3oookJP;o00000ol007l01?oonf[o001oo`00Ool007maoookJP00
oooonf[1oookJP?o001o1?oonfX00ol007oo0000o`00O`05o`00Og7ooo]Z003ooookJ/7ooo]Z0ol0
07l3oookJP?o001o00?o0000oookJ_l007l00ol007maoookJP00oooonf[1oookJP?o001o0ooonfX3
o`00O`03oookJ_l0003ooo]Z00?o001oLOoonfX00?oooo]Z`OoonfX3o`00O`?ooo]Z0ol007l2oook
JP04o`000?l007oo001oo`00Og7ooo]Z003ooookJ[kooo]Z1_l007l3oookJP?o001o0ooonfX00ol0
003o001oo`00O`1aoookJP00oooonfZnoookJPKo001o0ooonfX4o`00O`04oookJ_l007oo001oo`00
07;ooo]Z003ooookJ/3ooo]Z1?l007l4oookJPOo001o00?o0000oookJ_oonfX0KooonfX00?oooo]Z
`OoonfX3o`00O`Gooo]Z1Ol007l2oookJP;o0000KooonfX00?oooo]Zd_oonfX00ol0003ooo]Zoook
JP1/oookJP00oooonf[CoookJP03o`000?oonf[ooo]Z06_ooo]Z003ooookJ]Cooo]Z00?o0000oook
J_oonfX0J_oonfX00?oooo]ZeOoonfX00ol0003ooo]ZoookJP1YoookJP00oooonf[FoookJP03o`00
0?oonf[ooo]Z06Sooo]Z003ooookJ]Oooo]Z00?o0000oookJ_oonfX0IooonfX00?oooo]Zf?oonfX0
0ol0003ooo]ZoookJP1VoookJP00oooonf[IoookJP03o`000?oonf[ooo]Z06Gooo]Z003ooookJ][o
oo]Z00?o0000oookJ_oonfX0I?oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.824 .43378 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(20) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.824 .43378 m
.80728 .42768 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[@oookJP03o`00Ool0003o0000
00Ko001o0ooonfX5o`00Of3ooo]Z003ooookJ]3ooo]Z0ol007l2o`0000Co001o0_oonfX7o`00Oeoo
oo]Z003ooookJ]3ooo]Z1?l007l01?oonf[o0000o`000?l00003oookJP?o001o00Cooo]Zo`00Ool0
07oo001oGooonfX00?oooo]ZdOoonfX4o`00O`?ooo]Z0_l00003o`00O`?ooo]Z0ol007mNoookJP00
oooonf[BoookJPGo001o0ooonfX00ol0003o001oo`00O`03oookJP?o001oG_oonfX00?oooo]Ze?oo
nfX4o`00O`;ooo]Z0ol007l3oookJP?o001oG_oonfX00?oooo]ZeOoonfX3o`00O`;ooo]Z0ol007l3
oookJP?o001oG_oonfX00?oooo]Ze_oonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007mN
oookJP00oooonf[@oookJP?o001o0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007mN
oookJP00oooonf[@oookJP?o001o0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007mN
oookJP00oooonf[@oookJPCo001o0_oonfX3o`00O`;ooo]Z0ol007l01?oonf[o001oo`00Ool007mO
oookJP00oooonf[AoookJPOo001o0ooonfX7o`00Oeoooo]Z003ooookJ];ooo]Z1Ol007l5oookJPGo
001oH?oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z0000
\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.80728 .42768 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(21) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.80728 .42768 m
.77602 .4415 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZaooonfX9o`00O`Gooo]Z0ol007mYoookJP00
oooonf[7oookJPWo001o1OoonfX3o`00OfWooo]Z003ooookJ/Oooo]Z1?l007l:oookJP?o001oJOoo
nfX00?oooo]Zb?oonfX4o`00O`Wooo]Z0ol007mYoookJP00oooonf[9oookJPGo001o0_oonfX2o`00
00?ooo]Z0ol007mYoookJP00oooonf[;oookJP?o001o0_l00005oookJP?o001oJOoonfX00?oooo]Z
booonfX3o`000003o`00Oooonf[ooo]Z00Cooo]Z0ol007mYoookJP00oooonf[9oookJP;o00000_oo
nfX3o`00O`Gooo]Z0ol007mYoookJP00oooonf[7oookJP;o000000Co001ooookJ_oonf[ooo]Z0ol0
07l5oookJP?o001oJOoonfX00?oooo]ZaOoonfX2o`0000?o001o0ooonfX3o`00O`;ooo]Z1_l007mY
oookJP00oooonf[2oookJP?o00000_oonfX4o`00O`;ooo]Z0ol007l2oookJPKo001oJOoonfX00?oo
oo]Z`?oonfX2o`0000Kooo]Z1ol007l5oookJPCo001oJOoonfX00?oooo]Z_ooonfX00ol0003ooo]Z
oookJP07oookJPGo001o1ooonfX3o`00OfWooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z0000\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.77602 .4415 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(22) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.77602 .4415 m
.77657 .44003 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ[Gooo]Z2Ol007l0
0ooonf[o001oo`00O`07o`00OgWooo]Z003ooookJ[Gooo]Z2Ol007l00ooonf[o001oo`00O`07o`00
OgWooo]Z003ooookJ[Gooo]Z1?l007l6oookJPCo001oO_oonfX00?oooo]Z]_oonfX4o`00O`Kooo]Z
1?l007mmoookJP00oooonfZgoookJPGo001o0ooonfX00ol0003ooo]Zo`00O`04o`00Og_ooo]Z003o
oookJ[Wooo]Z1?l007l6oookJPCo001oN_oonfX00?oooo]Z^_oonfX3o`00O`Oooo]Z0ol007mjoook
JP00oooonfZkoookJP?o001o1ooonfX3o`00OgWooo]Z003ooookJ[Gooo]Z0ol007l3oookJP?o001o
00Cooo]Zo`00Ool007oo001o0ooonfX3o`00OgWooo]Z003ooookJ[Gooo]Z0ol007l3oookJP?o001o
00Cooo]Zo`00Ool007oo001o0ooonfX3o`00OgWooo]Z003ooookJ[Gooo]Z1?l007l2oookJP?o001o
00?ooo]Zo`00Ool007l00_l007l2oookJP?o001oNOoonfX00?oooo]Z]_oonfX7o`00O`?ooo]Z1ol0
07mjoookJP00oooonfZgoookJPGo001o1OoonfX5o`00Og_ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00001\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.77657 .44003 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(23) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.77657 .44003 m
.77901 .44826 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ[Gooo]Z2Ol007l3
oookJPGo001oNooonfX00?oooo]Z]OoonfX9o`00O`;ooo]Z1ol007mjoookJP00oooonfZeoookJPCo
001o1_oonfX3o`00O`?ooo]Z0ol007mioookJP00oooonfZfoookJPCo001o1OoonfX3o`00O`?ooo]Z
0ol007mioookJP00oooonfZgoookJPGo001o0ooonfX00ol0003ooo]ZoookJP03oookJP?o001oNOoo
nfX00?oooo]Z^OoonfX4o`00O`;ooo]Z00?o0000oookJ_oonfX00ooonfX3o`00OgWooo]Z003ooook
J[[ooo]Z0ol007l2oookJP04o`000?oonf[ooo]ZoookJPCo001oN_oonfX00?oooo]Z^ooonfX3o`00
O`;ooo]Z00?o0000oookJ_oonfX00ol007mkoookJP00oooonfZeoookJP?o001o0ooonfX3o`00O`;o
oo]Z00?o0000oookJ_oonfX00_oonfX2o`00Og[ooo]Z003ooookJ[Gooo]Z0ol007l3oookJP?o001o
00Cooo]Zo`00Ool007oo001o0ooonfX3o`00OgWooo]Z003ooookJ[Gooo]Z1?l007l2oookJP?o001o
00Cooo]Zo`00Ool007oo001o0ooonfX3o`00OgWooo]Z003ooookJ[Kooo]Z1ol007l3oookJPOo001o
N_oonfX00?oooo]Z]ooonfX5o`00O`Gooo]Z1Ol007mkoookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z0000\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.77901 .44826 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(24) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.77901 .44826 m
.78496 .4677 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z]_oo
nfX9o`00O`Kooo]Z0ol007mioookJP00oooonfZfoookJPWo001o1_oonfX3o`00OgWooo]Z003ooook
J[Kooo]Z1?l007l;oookJP?o001oNOoonfX00?oooo]Z]ooonfX4o`00O`Gooo]Z2Ol007mhoookJP00
oooonfZhoookJPGo001o0ooonfX00ol0003o001oo`00O`06o`00OgSooo]Z003ooookJ[[ooo]Z1?l0
07l2oookJP03o`000?l007oooo]Z00;ooo]Z0ol007mioookJP00oooonfZkoookJP?o001o0ooonfX0
1?l0003o001ooookJ_oonfX3o`00OgWooo]Z003ooookJ[cooo]Z0ol007l2oookJP04o`000?l007oo
001ooookJP?o001oNOoonfX00?oooo]Z]_oonfX3o`00O`?ooo]Z0ol007l2oookJP04o`000?l007oo
001ooookJP?o001oNOoonfX00?oooo]Z]_oonfX3o`00O`?ooo]Z0ol007l3oookJP03o`000?l007oo
001o00?o001oNOoonfX00?oooo]Z]_oonfX4o`00O`;ooo]Z0ol007l3oookJP03o`000?l007oo001o
00?o001oNOoonfX00?oooo]Z]ooonfX7o`00O`Cooo]Z00?o0000oookJ_l007l00ol007mioookJP00
oooonfZhoookJPGo001o1_oonfX00ol0003ooo]Zo`00O`02o`00OgWooo]Z003ooookJ/?ooo]Z00?o
0000oookJ_oonfX0NooonfX00?oooo]Z`ooonfX00ol0003ooo]ZoookJP1koookJP00oooonf[4oook
JP03o`000?oonf[ooo]Z07[ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z0000\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.78496 .4677 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(25) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.78496 .4677 m
.83013 .46507 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ[[ooo]Z2Ol007l3oookJPGo001oM_oonfX00?oooo]Z^_oonfX9o`00O`;ooo]Z1ol007meoook
JP00oooonfZjoookJPCo001o1_oonfX4o`00O`04oookJ_l007oo001oo`00OgGooo]Z003ooookJ[_o
oo]Z1?l007l5oookJP?o001o0ooonfX3o`00O`Cooo]Z3_l0001RoookJP00oooonfZloookJPGo001o
0ooonfX=o`00073ooo]Z003ooookJ[kooo]Z1?l007l8oookJP?o001oM?oonfX00?oooo]Z_ooonfX3
o`00O`?ooo]Z0_l007l2oookJPCo001oM?oonfX00?oooo]Z`?oonfX3o`00O`;ooo]Z1ol007meoook
JP00oooonfZjoookJP?o001o0ooonfX3o`00O`;ooo]Z1_l007mfoookJP00oooonfZjoookJP?o001o
0ooonfX3o`00O`;ooo]Z0_l007mjoookJP00oooonfZjoookJPCo001o0_oonfX3o`00O`;ooo]Z0_l0
07mjoookJP00oooonfZkoookJPOo001o1?oonfX7o`00OgCooo]Z003ooookJ[cooo]Z1Ol007l5oook
JPOo001oM?oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.83013 .46507 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(26) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.83013 .46507 m
.76768 .5086 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[DoookJPWo001o0ooo
nfX5o`00Oecooo]Z003ooookJ]Cooo]Z2Ol007l2oookJPOo001oFooonfX00?oooo]Ze?oonfX4o`00
O`Oooo]Z0ol007l2oookJP?o001oF_oonfX00?oooo]ZeOoonfX4o`00O`Gooo]Z0ol007l3oookJP?o
001oF_oonfX00?oooo]Ze_oonfX5o`00O`;ooo]Z0_l00002o`00O`?ooo]Z0ol007mJoookJP00oooo
nf[HoookJPCo001o00?o0000oookJ_l007l00ol007l2oookJP?o001oF_oonfX00?oooo]ZfOoonfX0
0ol007oo0000o`000002oookJPSo001oFooonfX00?oooo]ZfOoonfX01Ol0003o001oo`00Ool007oo
oo]Z00?o001o00Cooo]Zo`00Ool007oo001oG?oonfX00?oooo]Ze?oonfX3o`00O`03oookJ_l0003o
oo]Z00?o001o00Cooo]Zo`00Ool007oo001oH?oonfX00?oooo]Ze?oonfX2o`00O`;o00000_oonfX3
o`00O`04oookJ_l007oo001oo`00Of3ooo]Z003ooookJ]Cooo]Z00Co001oo`000?l007oo001o0_oo
nfX3o`00O`;ooo]Z0ol007l2oookJP?o001oF_oonfX00?oooo]ZdooonfX2o`0000Oo001o0ooonfX7
o`00Oe_ooo]Z003ooookJ];ooo]Z00Co0000oookJ_oonf[ooo]Z1Ol007l6oookJPCo001oG?oonfX0
0?oooo]Zd?oonfX2o`0006oooo]Z003ooookJ/oooo]Z00?o0000oookJ_oonfX0KooonfX00?oooo]Z
cOoonfX2o`0007;ooo]Z003ooookJ/cooo]Z00?o0000oookJ_oonfX0L_oonfX00?oooo]ZbooonfX0
0ol0003ooo]ZoookJP1coookJP00oooonf[9oookJP;o0000M_oonfX00?oooo]Zb?oonfX00ol0003o
oo]ZoookJP1foookJP00oooonf[6oookJP;o0000NOoonfX00?oooo]ZaOoonfX00ol0003ooo]Zoook
JP1ioookJP00oooonf[3oookJP;o0000O?oonfX00?oooo]Z`_oonfX00ol0003ooo]ZoookJP1loook
JP00oooonf[0oookJP;o0000OooonfX00?oooo]Z_ooonfX00ol0003ooo]ZoookJP1ooookJP00oooo
nfZnoookJP03o`000?oonf[ooo]Z083ooo]Z003ooookJ[cooo]Z0_l00023oookJP00oooonfZkoook
JP03o`000?oonf[ooo]Z08?ooo]Z003ooookJ[[ooo]Z00?o0000oookJ_oonfX0Q?oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00001\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.76768 .5086 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(27) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.76768 .5086 m
.79973 .51032 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ[3ooo]Z2Ol0
07l3oookJP?o001oP_oonfX00?oooo]Z/?oonfX9o`00O`?ooo]Z0ol007n2oookJP00oooonfZ`oook
JPCo001o2?oonfX3o`00Oh;ooo]Z003ooookJ[7ooo]Z1?l007l8oookJP;o001oP_oonfX00?oooo]Z
/_oonfX5o`00O`?ooo]Z2_l0001moookJP00oooonfZdoookJPCo001o1OoonfX3o`00O`Cooo]Z2Ol0
001doookJP00oooonfZeoookJP?o001o1_oonfX2o`00Oh7ooo]Z003ooookJ[Kooo]Z0ol007l5oook
JP?o001oP?oonfX00?oooo]Z/?oonfX3o`00O`?ooo]Z0ol007l6oookJP;o001oP?oonfX00?oooo]Z
/?oonfX3o`00O`?ooo]Z0ol007l7oookJP;o001oOooonfX00?oooo]Z/?oonfX4o`00O`;ooo]Z0ol0
07l7oookJP;o001oOooonfX00?oooo]Z/OoonfX7o`00O`;ooo]Z2Ol007mnoookJP00oooonfZboook
JPGo001o0ooonfX9o`00Ogkooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0001\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.79973 .51032 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(28) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.79973 .51032 m
.71946 .49238 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZW_oonfX3o`000:3ooo]Z003ooookJZ7ooo]Z1Ol0002K
oookJP00oooonfZVoookJPGo0000U_oonfX00?oooo]ZZooonfX4o`0009;ooo]Z003ooookJZoooo]Z
1Ol0002=oookJP00oooonfZdoookJPCo0000ROoonfX00?oooo]Z^?oonfX5o`0000Gooo]Z2Ol007l3
oookJPGo001oK_oonfX00?oooo]Z_OoonfX5o`0000Wo001o0_oonfX7o`00Ofgooo]Z003ooookJ/;o
oo]Z1?l00006oookJP?o001o0ooonfX3o`00Ofcooo]Z003ooookJ/?ooo]Z0ol007l5o`000004oook
J_l007oo001oo`00O`?ooo]Z0ol007m/oookJP00oooonf[4oookJPGo001o0_oonfX2o`0000;o001o
0ooonfX3o`00Ofcooo]Z003ooookJ/Kooo]Z1?l007l2oookJP?o001o0ooonfX3o`00Ofcooo]Z003o
oookJ/Oooo]Z0ol007l3oookJPOo001oKOoonfX00?oooo]Zb?oonfX3o`00O`;ooo]Z1ol007m]oook
JP00oooonf[2oookJP?o001o0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007m/oook
JP00oooonf[2oookJP?o001o0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007m/oook
JP00oooonf[2oookJPCo001o0_oonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007m/oook
JP00oooonf[3oookJPOo001o0ooonfX7o`00Ofgooo]Z003ooookJ/Cooo]Z1Ol007l5oookJPGo001o
K_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00001\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.71946 .49238 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(29) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.71946 .49238 m
.7754 .50597 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJYCooo]Z2Ol007l3oookJPCo001oWOoonfX00?oooo]ZU?oonfX9o`00
O`;ooo]Z1ol007nKoookJP00oooonfZDoookJPCo001o1_oonfX3o`00O`;ooo]Z0ol007nKoookJP00
oooonfZEoookJPCo001o2ooonfX3o`00Oi[ooo]Z003ooookJYKooo]Z1Ol007l3oookJP?o00000_l0
07l01?oonf[o001oo`00Ool007nJoookJP00oooonfZHoookJPCo001o0ooonfX2o`00O`Go000000?o
001ooookJ_oonfX0V?oonfX00?oooo]ZVOoonfX3o`00O`;ooo]Z0ol007l2oookJP?o001o1?l0002G
oookJP00oooonfZJoookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00O`?ooo]Z1Ol0002B
oookJP00oooonfZDoookJP?o001o0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l8
oookJPGo0000SOoonfX00?oooo]ZU?oonfX3o`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007l3
oookJP?o001o3OoonfX4o`0008Wooo]Z003ooookJYCooo]Z1?l007l2oookJP?o001o00?ooo]Zo`00
Ool007l00_l007l01?oonf[o001oo`00Ool007lBoookJPGo0000Q?oonfX00?oooo]ZUOoonfX7o`00
O`?ooo]Z1ol007lGoookJP;o0000P_oonfX00?oooo]ZU_oonfX5o`00O`Gooo]Z1Ol007nLoookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z0000\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.7754 .50597 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(30) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.7754 .50597 m
.77601 .49814 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]Z]_oonfX5o`00O`Cooo]Z00?o0000o`00Ool007l00ol007mloookJP00
oooonfZeoookJPOo001o0ooonfX00ol0003o001oo`00O`04o`00Og_ooo]Z003ooookJ[Cooo]Z0ol0
07l3oookJP?o001o0_oonfX01?l0003o001oo`00OooonfX3o`00Og_ooo]Z003ooookJ[Cooo]Z0ol0
07l3oookJP?o001o00Cooo]Zo`000?l007oo001o0ooonfX3o`00Og[ooo]Z003ooookJ[[ooo]Z0ol0
07l01?oonf[o0000o`00Ool007l3oookJP?o001oN_oonfX00?oooo]Z^_oonfX3o`00O`04oookJ_l0
07oo001oo`00O`?ooo]Z0ol007mjoookJP00oooonfZhoookJPCo001o0_oonfX3o`00O`?ooo]Z0ol0
07mjoookJP00oooonfZhoookJP?o001o0ooonfX3o`00O`?ooo]Z0ol007mjoookJP00oooonfZjoook
JP;o001o0_oonfX3o`00O`?ooo]Z0ol007mjoookJP00oooonfZdoookJP?o001o0ooonfX3o`00O`04
oookJ_l007oo001oo`00O`?ooo]Z0ol007mjoookJP00oooonfZdoookJP?o001o0ooonfX3o`00O`;o
oo]Z0ol007l01?oonf[o001oo`00Ool007mkoookJP00oooonfZeoookJPOo001o0ooonfX7o`00Og_o
oo]Z003ooookJ[Kooo]Z1Ol007l5oookJPGo001oO?oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00001\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.77601 .49814 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(31) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.77601 .49814 m
.78762 .49207 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ[Oooo]Z1Ol007l7oookJP03o`00Ool0003o000007_ooo]Z003ooookJ[Kooo]Z1ol0
07l6oookJP03o`000?l007oo001o07_ooo]Z003ooookJ[Gooo]Z0ol007l3oookJP?o001o0ooonfX2
o`0000?o001oNooonfX00?oooo]Z]OoonfX3o`00O`?ooo]Z0ol007l2oookJP03o`000?oonf[ooo]Z
00?o001oNooonfX00?oooo]Z^ooonfX3o`00O`03oookJ_l0003ooo]Z00;ooo]Z0ol007mkoookJP00
oooonfZkoookJP?o001o1OoonfX3o`00Og_ooo]Z003ooookJ[Wooo]Z1?l007l6oookJP?o001oNooo
nfX00?oooo]Z^OoonfX3o`00O`Oooo]Z0ol007mkoookJP00oooonfZkoookJP;o001o1_oonfX3o`00
Og_ooo]Z003ooookJ[Gooo]Z0ol007l3oookJP?o001o0_oonfX6o`00Og_ooo]Z003ooookJ[Gooo]Z
0ol007l3oookJP?o001o0_oonfX6o`00Og_ooo]Z003ooookJ[Kooo]Z1ol007l5oookJPCo001oNooo
nfX00?oooo]Z]ooonfX5o`00O`Oooo]Z0ol007mkoookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z0000\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.78762 .49207 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(32) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.78762 .49207 m
.80731 .56276 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nfZmoookJPGo001o0ooonfX9o`00Og?ooo]Z003ooookJ[cooo]Z1ol007l2oookJPWo001oLooonfX0
0?oooo]Z^ooonfX3o`00O`?ooo]Z0ol007l00ooonf[o001oo`00O`02o`00OgSooo]Z003ooookJ[_o
oo]Z0ol007l3oookJP?o001o0_oonfX4o`00OgOooo]Z003ooookJ/7ooo]Z0ol007l00ooonf[o0000
oookJP05o`00OgGooo]Z003ooookJ/7ooo]Z0ol007l00ooonf[o0000oookJP02oookJPCo001oM?oo
nfX00?oooo]Z_ooonfX4o`00O`;ooo]Z00?o0000oookJ_oonfX00_oonfX3o`00OgCooo]Z003ooook
J[oooo]Z0ol007l4oookJP03o`000?oonf[ooo]Z00;ooo]Z0ol007mcoookJP00oooonf[1oookJP;o
001o0_oonfX00ol007oo0000o`00O`03oookJP?o001oLooonfX00?oooo]Z^ooonfX3o`00O`?ooo]Z
0ol007l01?oonf[o001oo`000?l007l3oookJP?o001oLooonfX00?oooo]Z^ooonfX3o`00O`?ooo]Z
0ol007l01Ooonf[o001oo`00Ool0003o001o00;ooo]Z0ol007mcoookJP00oooonfZloookJPOo001o
0ooonfX00ol007oo0000o`00O`04o`00OgCooo]Z003ooookJ[gooo]Z1Ol007l5oookJP03o`000?l0
07oo001o00;o001oMOoonfX00?oooo]ZaooonfX00ol0003ooo]ZoookJP1goookJP00oooonf[8oook
JP03o`000?oonf[ooo]Z07Kooo]Z003ooookJ/Sooo]Z00?o0000oookJ_oonfX0M_oonfX00?oooo]Z
b?oonfX00ol0003ooo]ZoookJP1foookJP00oooonf[9oookJP03o`000?oonf[ooo]Z07Gooo]Z003o
oookJ/Wooo]Z00?o0000oookJ_oonfX0MOoonfX00?oooo]ZbOoonfX00ol0003ooo]ZoookJP1eoook
JP00oooonf[:oookJP03o`000?oonf[ooo]Z07Cooo]Z003ooookJ/[ooo]Z00?o0000oookJ_oonfX0
M?oonfX00?oooo]Zb_oonfX00ol0003ooo]ZoookJP1doookJP00oooonf[:oookJP03o`000?oonf[o
oo]Z07Cooo]Z003ooookJ/_ooo]Z00?o0000oookJ_oonfX0LooonfX00?oooo]ZbooonfX00ol0003o
oo]ZoookJP1coookJP00oooonf[;oookJP03o`000?oonf[ooo]Z07?ooo]Z003ooookJ/cooo]Z00?o
0000oookJ_oonfX0L_oonfX00?oooo]Zc?oonfX00ol0003ooo]ZoookJP1boookJP00oooonf[<oook
JP03o`000?oonf[ooo]Z07;ooo]Z003ooookJ/cooo]Z00?o0000oookJ_oonfX0L_oonfX00?oooo]Z
cOoonfX00ol0003ooo]ZoookJP1aoookJP00oooonf[=oookJP03o`000?oonf[ooo]Z077ooo]Z003o
oookJ/gooo]Z00?o0000oookJ_oonfX0LOoonfX00?oooo]Zc_oonfX00ol0003ooo]ZoookJP1`oook
JP00oooonf[>oookJP03o`000?oonf[ooo]Z073ooo]Z003ooookJ/kooo]Z00?o0000oookJ_oonfX0
L?oonfX00?oooo]ZcooonfX00ol0003ooo]ZoookJP1_oookJP00oooonf[?oookJP03o`000?oonf[o
oo]Z06oooo]Z003ooookJ/oooo]Z00?o0000oookJ_oonfX0KooonfX00?oooo]ZcooonfX00ol0003o
oo]ZoookJP1_oookJP00oooonf[@oookJP03o`000?oonf[ooo]Z06kooo]Z003ooookJ]3ooo]Z00?o
0000oookJ_oonfX0K_oonfX00?oooo]Zd?oonfX00ol0003ooo]ZoookJP1^oookJP00oooonf[Aoook
JP03o`000?oonf[ooo]Z06gooo]Z003ooookJ]7ooo]Z00?o0000oookJ_oonfX0KOoonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
0000\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.80731 .56276 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(33) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.80731 .56276 m
.74518 .56683 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZbOoonfX5o`00O`Gooo]Z1Ol007mY
oookJP00oooonf[8oookJPOo001o0ooonfX7o`00OfSooo]Z003ooookJ/Oooo]Z0ol007l3oookJP?o
001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00OfOooo]Z003ooookJ/Oooo]Z0ol007l3oookJP?o
001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00OfOooo]Z003ooookJ/Sooo]Z2_l00005oookJP?o
001oIooonfX00?oooo]Z]_oonfXBo`0000Gooo]Z0ol007l7oookJP?o001oIooonfX00?oooo]Z[Ooo
nfX9o`0001Gooo]Z1?l007l6oookJPCo001oJ?oonfX00?oooo]ZbooonfX3o`00O`Oooo]Z0ol007mY
oookJP00oooonf[=oookJP;o001o2?oonfX2o`00OfSooo]Z003ooookJ/Oooo]Z0ol007l3oookJP?o
001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00OfOooo]Z003ooookJ/Oooo]Z0ol007l3oookJP?o
001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00OfOooo]Z003ooookJ/Sooo]Z1ol007l3oookJPOo
001oJ?oonfX00?oooo]ZbOoonfX5o`00O`Gooo]Z1Ol007mYoookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.74518 .56683 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(34) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.74518 .56683 m
.68714 .60912 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJZGooo]Z1Ol007l8oookJP?o001oS?oonfX00?oooo]ZY?oonfX7o`00O`Oooo]Z
0ol007n<oookJP00oooonfZSoookJP?o001o0ooonfX3o`00O`Kooo]Z0ol007n<oookJP00oooonfZS
oookJP?o001o0ooonfX3o`00O`03oookJ_l007oo001o00Oo001oRooonfX00?oooo]ZZOoonfX3o`00
O`;o00002?l007n;oookJP00oooonfZYoookJP;o001o00Co0000oookJ_l007oo001o0ooonfX3o`00
Ohcooo]Z003ooookJZOooo]Z0ol007l01?l0003ooo]ZoookJ_oonfX2o`00O`;ooo]Z0ol007n<oook
JP00oooonfZWoookJP03o`00Ool0003o000000Cooo]Z0ol007l01?oonf[o001oo`00Ool007n<oook
JP00oooonfZWoookJP04o`000?oonf[o001oo`00O`Cooo]Z0_l007l01?oonf[o001oo`00Ool007n<
oookJP00oooonfZSoookJP?o001o00?o0000oookJ_oonfX00ol007l4oookJPGo001oS?oonfX00?oo
oo]ZXooonfX00ol007oo0000o`000003oookJP?o001o1?oonfX5o`00Ohcooo]Z003ooookJZ?ooo]Z
00?o0000o`00Ool007l01Ol007l6oookJPCo001oS?oonfX00?oooo]ZX_oonfX00ol0003ooo]Zoook
JP05o`00O`Sooo]Z0ol007n<oookJP00oooonfZPoookJP;o0000WooonfX00?oooo]ZWooonfX00ol0
003ooo]ZoookJP2OoookJP00oooonfZNoookJP03o`000?oonf[ooo]Z0:3ooo]Z003ooookJYcooo]Z
0_l0002SoookJP00oooonfZKoookJP03o`000?oonf[ooo]Z0:?ooo]Z003ooookJY[ooo]Z00?o0000
oookJ_oonfX0Y?oonfX00?oooo]ZVOoonfX00ol0003ooo]ZoookJP2UoookJP00oooonfZGoookJP;o
0000Z?oonfX00?oooo]ZU_oonfX00ol0003ooo]ZoookJP2XoookJP00oooonfZEoookJP03o`000?oo
nf[ooo]Z0:Wooo]Z003ooookJY?ooo]Z0_l0002/oookJP00oooonfZBoookJP03o`000?oonf[ooo]Z
0:cooo]Z003ooookJY7ooo]Z00?o0000oookJ_oonfX0[OoonfX00?oooo]ZSooonfX2o`000;3ooo]Z
003ooookJXkooo]Z00?o0000oookJ_oonfX0/?oonfX00?oooo]ZSOoonfX00ol0003ooo]ZoookJP2a
oookJP00oooonfZ<oookJP03o`000?oonf[ooo]Z0;;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.68714 .60912 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(35) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.68714 .60912 m
.67532 .66148 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZQ?oonfX5o`00O`Gooo]Z1Ol007n^oookJP00oooonfZ3oookJPOo001o
0ooonfX7o`00Ojgooo]Z003ooookJX;ooo]Z0ol007l3oookJP?o001o00?ooo]Zo`00Ool007l00_l0
07l01?oonf[o001oo`00Ool007n]oookJP00oooonfZ2oookJP?o001o0ooonfX3o`00O`04oookJ_l0
07oo001oo`00O`?ooo]Z0ol007n/oookJP00oooonfZ8oookJP?o001o00?ooo]Zo`000?oonfX01?oo
nfX3o`00Ojcooo]Z003ooookJXSooo]Z0ol007l00ooonf[o0000oookJP04oookJP?o001o[?oonfX0
0?oooo]ZQ_oonfX4o`00O`;ooo]Z00?o0000o`00Ool007l00_oonfX4o`00Ojcooo]Z003ooookJXKo
oo]Z0ol007l2oookJP03o`000?oonf[o001o00Ko001o[OoonfX00?oooo]ZR?oonfX2o`00O`03oook
J_l0003ooo]Z00Ko001o[_oonfX00?oooo]ZP_oonfX3o`00O`?ooo]Z0ol007l01?l0003ooo]Zo`00
Ool007nboookJP00oooonfZ2oookJP?o001o0ooonfX3o`00O`04o`000?oonf[o001oo`00Ok;ooo]Z
003ooookJX?ooo]Z1ol007l01?l0003ooo]ZoookJ_oonfX7o`00Ojcooo]Z003ooookJXCooo]Z1Ol0
07l00ooonf[o0000oookJP02oookJPOo001o[?oonfX00?oooo]ZR_oonfX00ol0003ooo]ZoookJP2d
oookJP00oooonfZ:oookJP03o`000?oonf[ooo]Z0;Cooo]Z003ooookJX[ooo]Z00?o0000oookJ_oo
nfX0]?oonfX00?oooo]ZROoonfX00ol0003ooo]ZoookJP2eoookJP00oooonfZ9oookJP03o`000?oo
nf[ooo]Z0;Gooo]Z003ooookJXWooo]Z00?o0000oookJ_oonfX0]OoonfX00?oooo]ZROoonfX00ol0
003ooo]ZoookJP2eoookJP00oooonfZ8oookJP03o`000?oonf[ooo]Z0;Kooo]Z003ooookJXSooo]Z
00?o0000oookJ_oonfX0]_oonfX00?oooo]ZR?oonfX00ol0003ooo]ZoookJP2foookJP00oooonfZ8
oookJP03o`000?oonf[ooo]Z0;Kooo]Z003ooookJXOooo]Z00?o0000oookJ_oonfX0]ooonfX00?oo
oo]ZQooonfX00ol0003ooo]ZoookJP2goookJP00oooonfZ7oookJP03o`000?oonf[ooo]Z0;Oooo]Z
003ooookJXOooo]Z00?o0000oookJ_oonfX0]ooonfX00?oooo]ZQooonfX00ol0003ooo]ZoookJP2g
oookJP00oooonfZ6oookJP03o`000?oonf[ooo]Z0;Sooo]Z003ooookJXKooo]Z00?o0000oookJ_oo
nfX0^?oonfX00?oooo]ZQ_oonfX00ol0003ooo]ZoookJP2hoookJP00oooonfZ6oookJP03o`000?oo
nf[ooo]Z0;Sooo]Z003ooookJXGooo]Z00?o0000oookJ_oonfX0^OoonfX00?oooo]ZQOoonfX00ol0
003ooo]ZoookJP2ioookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00001\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.67532 .66148 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(36) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.67532 .66148 m
.69214 .71014 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZOOoonfX5o`00O`Go
oo]Z1Ol007neoookJP00oooonfYloookJPOo001o0ooonfX7o`00OkCooo]Z003ooookJW_ooo]Z0ol0
07l3oookJP?o001o0_oonfX3o`00O`;ooo]Z0ol007ncoookJP00oooonfYkoookJP?o001o0ooonfX3
o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007ncoookJP00oooonfZ1oookJP?o001o00Cooo]Z
o`000?l007oo001o0ooonfX3o`00Ok?ooo]Z003ooookJX7ooo]Z0ol007l00ooonf[o0000o`00O`02
o`00O`;ooo]Z0ol007ncoookJP00oooonfYooookJPCo001o0_oonfX00ol0003o001oo`00O`05o`00
OkCooo]Z003ooookJWoooo]Z0ol007l3oookJP04o`00Ool0003o001ooookJP?o001o]OoonfX00?oo
oo]ZPOoonfX2o`00O`;ooo]Z00?o001oo`000?l007l0^OoonfX00?oooo]ZNooonfX3o`00O`?ooo]Z
0ol007l01?oonf[o001oo`000?l007nioookJP00oooonfYkoookJP?o001o0ooonfX3o`00O`;ooo]Z
00?o001oo`000?l007l00_oonfX3o`00Ok?ooo]Z003ooookJWcooo]Z1ol007l3oookJP03o`00Ool0
003o001o00Co001o]?oonfX00?oooo]ZOOoonfX5o`00O`Gooo]Z00?o0000o`00Ool007l00_l007ne
oookJP00oooonfZ8oookJP03o`000?oonf[ooo]Z0;Kooo]Z003ooookJXSooo]Z00?o0000oookJ_oo
nfX0]_oonfX00?oooo]ZR?oonfX00ol0003ooo]ZoookJP2foookJP00oooonfZ9oookJP03o`000?oo
nf[ooo]Z0;Gooo]Z003ooookJXWooo]Z00?o0000oookJ_oonfX0]OoonfX00?oooo]ZROoonfX00ol0
003ooo]ZoookJP2eoookJP00oooonfZ:oookJP03o`000?oonf[ooo]Z0;Cooo]Z003ooookJX[ooo]Z
00?o0000oookJ_oonfX0]?oonfX00?oooo]ZR_oonfX00ol0003ooo]ZoookJP2doookJP00oooonfZ;
oookJP03o`000?oonf[ooo]Z0;?ooo]Z003ooookJX_ooo]Z00?o0000oookJ_oonfX0/ooonfX00?oo
oo]ZRooonfX00ol0003ooo]ZoookJP2coookJP00oooonfZ<oookJP03o`000?oonf[ooo]Z0;;ooo]Z
003ooookJXcooo]Z00?o0000oookJ_oonfX0/_oonfX00?oooo]ZS?oonfX00ol0003ooo]ZoookJP2b
oookJP00oooonfZ=oookJP03o`000?oonf[ooo]Z0;7ooo]Z003ooookJXgooo]Z00?o0000oookJ_oo
nfX0/OoonfX00?oooo]ZSOoonfX00ol0003ooo]ZoookJP2aoookJP00oooonfZ>oookJP03o`000?oo
nf[ooo]Z0;3ooo]Z003ooookJXkooo]Z00?o0000oookJ_oonfX0/?oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.69214 .71014 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(37) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.69214 .71014 m
.68981 .71824 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonfZ6oookJPGo001o1OoonfX3
o`00Ojkooo]Z003ooookJXGooo]Z1ol007l4oookJP?o001o[_oonfX00?oooo]ZQ?oonfX3o`00O`?o
oo]Z0ol007l3oookJP?o001o[_oonfX00?oooo]ZQ?oonfX3o`00O`?ooo]Z0ol007l4oookJP;o001o
[_oonfX00?oooo]ZR_oonfX3o`00O`04oookJ_l0003ooo]ZoookJP?o001o[OoonfX00?oooo]ZR_oo
nfX3o`00O`04oookJ_l0003ooo]ZoookJP?o001o[OoonfX00?oooo]ZR?oonfX4o`00O`;ooo]Z00Co
0000oookJ_oonf[ooo]Z0_l007n]oookJP00oooonfZ8oookJP?o001o0_oonfX00ol0003ooo]Zoook
JP02oookJP?o001o[?oonfX00?oooo]ZR_oonfX2o`00O`03oookJ_l0003ooo]Z00Cooo]Z0_l007n/
oookJP00oooonfZ4oookJP?o001o0ooonfX3o`00O`Oooo]Z0_l007n[oookJP00oooonfZ4oookJP?o
001o0ooonfX3o`00O`Oooo]Z0_l007n[oookJP00oooonfZ5oookJPOo001o0_oonfX9o`00Oj[ooo]Z
003ooookJXKooo]Z1Ol007l3oookJPWo001oZ_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z0000\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.68981 .71824 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(38) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.68981 .71824 m
.7058 .66177 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonfZFoook
JP03o`000?oonf[ooo]Z0:Sooo]Z003ooookJYKooo]Z00?o0000oookJ_oonfX0Z?oonfX00?oooo]Z
U_oonfX00ol0003ooo]ZoookJP2XoookJP00oooonfZEoookJP03o`000?oonf[ooo]Z0:Wooo]Z003o
oookJYGooo]Z00?o0000oookJ_oonfX0ZOoonfX00?oooo]ZUOoonfX00ol0003ooo]ZoookJP2Yoook
JP00oooonfZDoookJP03o`000?oonf[ooo]Z0:[ooo]Z003ooookJYCooo]Z00?o0000oookJ_oonfX0
Z_oonfX00?oooo]ZU?oonfX00ol0003ooo]ZoookJP2ZoookJP00oooonfZDoookJP03o`000?oonf[o
oo]Z0:[ooo]Z003ooookJY?ooo]Z00?o0000oookJ_oonfX0ZooonfX00?oooo]ZTooonfX00ol0003o
oo]ZoookJP2[oookJP00oooonfZCoookJP03o`000?oonf[ooo]Z0:_ooo]Z003ooookJY;ooo]Z00?o
0000oookJ_oonfX0[?oonfX00?oooo]ZT_oonfX00ol0003ooo]ZoookJP2/oookJP00oooonfZBoook
JP03o`000?oonf[ooo]Z0:cooo]Z003ooookJY;ooo]Z00?o0000oookJ_oonfX0[?oonfX00?oooo]Z
TOoonfX00ol0003ooo]ZoookJP2]oookJP00oooonfZAoookJP03o`000?oonf[ooo]Z0:gooo]Z003o
oookJY7ooo]Z00?o0000oookJ_oonfX0[OoonfX00?oooo]ZTOoonfX00ol0003ooo]ZoookJP2]oook
JP00oooonfZ@oookJP03o`000?oonf[ooo]Z0:kooo]Z003ooookJY3ooo]Z00?o0000oookJ_oonfX0
[_oonfX00?oooo]ZT?oonfX00ol0003ooo]ZoookJP2^oookJP00oooonfZ?oookJP03o`000?oonf[o
oo]Z0:oooo]Z003ooookJXoooo]Z00?o0000oookJ_oonfX0[ooonfX00?oooo]ZSooonfX00ol0003o
oo]ZoookJP2_oookJP00oooonfZ?oookJP03o`000?oonf[ooo]Z0:oooo]Z003ooookJXGooo]Z1Ol0
07l4oookJP03o`000?l007oo001o00?o001o[OoonfX00?oooo]ZQ?oonfX7o`00O`?ooo]Z00?o0000
o`00Ool007l01?l007n/oookJP00oooonfZ3oookJP?o001o0ooonfX3o`00O`04oookJ_l007oo0000
o`00O`?ooo]Z0ol007n[oookJP00oooonfZ3oookJP?o001o0ooonfX3o`00O`04oookJ_l0003o001o
o`00O`?ooo]Z0ol007n[oookJP00oooonfZ9oookJP?o001o00Cooo]Zo`000?l007oo001o0ooonfX3
o`00Oj_ooo]Z003ooookJXWooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001oZooonfX0
0?oooo]ZQooonfX4o`00O`?ooo]Z1ol007n/oookJP00oooonfZ7oookJP?o001o1?oonfX7o`00Ojco
oo]Z003ooookJXWooo]Z0_l007l2oookJP?o001o0ooonfX3o`00Oj_ooo]Z003ooookJX?ooo]Z0ol0
07l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00Oj_ooo]Z003ooookJX?ooo]Z0ol0
07l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00Oj_ooo]Z003ooookJXCooo]Z1ol0
07l3oookJPOo001o[?oonfX00?oooo]ZQOoonfX5o`00O`Gooo]Z1Ol007n]oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z0000\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.7058 .66177 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(39) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.7058 .66177 m
.69241 .71991 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZS_oonfX5o`00O`Go
oo]Z1?l007nUoookJP00oooonfZ=oookJPOo001o0ooonfX7o`00Oj?ooo]Z003ooookJXcooo]Z0ol0
07l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0_oonfX3o`00Oj?ooo]Z003ooookJXcooo]Z0ol0
07l3oookJP?o001o1ooonfX3o`00Oj;ooo]Z003ooookJY;ooo]Z0ol007l00ooonf[o0000oookJP03
o`00O`04oookJ_l007oo001oo`00Oj;ooo]Z003ooookJY;ooo]Z0ol007l00ooonf[o0000o`00O`07
o`00Oj;ooo]Z003ooookJY3ooo]Z1?l007l2oookJP03o`000?l007oo001o00;ooo]Z1?l007nRoook
JP00oooonfZ@oookJP?o001o0_oonfX01?l0003o001oo`00Ool007l3oookJP?o001oX_oonfX00?oo
oo]ZT_oonfX2o`00O`03oookJ_l0003o001o00;o001o0ooonfX3o`00Oj;ooo]Z003ooookJXcooo]Z
0ol007l3oookJP?o001o00Co0000o`00Ool007oo001o0ooonfX3o`00Oj;ooo]Z003ooookJXcooo]Z
0ol007l3oookJP?o001o00?o0000o`00Ool007l00_l007l01?oonf[o001oo`00Ool007nSoookJP00
oooonfZ=oookJPOo001o00?ooo]Zo`000?oonfX01ol007nSoookJP00oooonfZ>oookJPGo001o00?o
oo]Zo`000?oonfX00_oonfX5o`00OjCooo]Z003ooookJYCooo]Z00?o0000oookJ_oonfX0Z_oonfX0
0?oooo]ZU?oonfX00ol0003ooo]ZoookJP2ZoookJP00oooonfZDoookJP03o`000?oonf[ooo]Z0:[o
oo]Z003ooookJYCooo]Z00?o0000oookJ_oonfX0Z_oonfX00?oooo]ZTooonfX00ol0003ooo]Zoook
JP2[oookJP00oooonfZCoookJP03o`000?oonf[ooo]Z0:_ooo]Z003ooookJY?ooo]Z00?o0000oook
J_oonfX0ZooonfX00?oooo]ZTooonfX00ol0003ooo]ZoookJP2[oookJP00oooonfZBoookJP03o`00
0?oonf[ooo]Z0:cooo]Z003ooookJY;ooo]Z00?o0000oookJ_oonfX0[?oonfX00?oooo]ZT_oonfX0
0ol0003ooo]ZoookJP2/oookJP00oooonfZBoookJP03o`000?oonf[ooo]Z0:cooo]Z003ooookJY;o
oo]Z00?o0000oookJ_oonfX0[?oonfX00?oooo]ZTOoonfX00ol0003ooo]ZoookJP2]oookJP00oooo
nfZAoookJP03o`000?oonf[ooo]Z0:gooo]Z003ooookJY7ooo]Z00?o0000oookJ_oonfX0[OoonfX0
0?oooo]ZTOoonfX00ol0003ooo]ZoookJP2]oookJP00oooonfZAoookJP03o`000?oonf[ooo]Z0:go
oo]Z003ooookJY3ooo]Z00?o0000oookJ_oonfX0[_oonfX00?oooo]ZT?oonfX00ol0003ooo]Zoook
JP2^oookJP00oooonfZ@oookJP03o`000?oonf[ooo]Z0:kooo]Z003ooookJY3ooo]Z00?o0000oook
J_oonfX0[_oonfX00?oooo]ZT?oonfX00ol0003ooo]ZoookJP2^oookJP00oooonfZ?oookJP03o`00
0?oonf[ooo]Z0:oooo]Z003ooookJXoooo]Z00?o0000oookJ_oonfX0[ooonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z0000\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.69241 .71991 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(40) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.69241 .71991 m
.68905 .77959 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZR_oonfX3o`00O`Cooo]Z1Ol007n[oookJP00oooonfZ:oookJP?o001o0ooonfX7o`00
Oj[ooo]Z003ooookJX[ooo]Z0ol007l3oookJP?o001o00Cooo]Zo`00Ool007oo001oZ_oonfX00?oo
oo]ZQOoonfX9o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007nYoookJP00oooonfZ5oookJPWo
001o00Cooo]Zo`000?l007oo001o0ooonfX3o`00OjWooo]Z003ooookJXGooo]Z0_l007l3oookJP?o
001o0_oonfX00ol0003o001oo`00O`03oookJP?o001oZOoonfX00?oooo]ZQ_oonfX2o`00O`;ooo]Z
0ol007l2oookJP03o`000?l007oo001o00?ooo]Z0ol007nYoookJP00oooonfZ6oookJP?o001o00Co
oo]Zo`00Ool007oo001o0_oonfX00ol0003o001oo`00O`03oookJP?o001oZOoonfX00?oooo]ZQooo
nfX2o`00O`04oookJ_l007oo001oo`00O`;ooo]Z00?o0000o`00Ool007l00ooonfX3o`00OjWooo]Z
003ooookJXSooo]Z1Ol007l2oookJP03o`000?l007oo001o00?ooo]Z0ol007nYoookJP00oooonfZ8
oookJPGo001o0_oonfX01Ol0003o001oo`00Ool007oooo]Z00?o001oZ_oonfX00?oooo]ZROoonfX4
o`00O`;ooo]Z00?o0000o`00Ool007l01Ol007nZoookJP00oooonfZ:oookJP?o001o0_oonfX00ol0
003ooo]Zo`00O`04o`00Oj_ooo]Z003ooookJXoooo]Z00?o0000oookJ_oonfX0[ooonfX00?oooo]Z
S_oonfX00ol0003ooo]ZoookJP2`oookJP00oooonfZ>oookJP03o`000?oonf[ooo]Z0;3ooo]Z003o
oookJXkooo]Z00?o0000oookJ_oonfX0/?oonfX00?oooo]ZS_oonfX00ol0003ooo]ZoookJP2`oook
JP00oooonfZ>oookJP03o`000?oonf[ooo]Z0;3ooo]Z003ooookJXkooo]Z00?o0000oookJ_oonfX0
/?oonfX00?oooo]ZS_oonfX00ol0003ooo]ZoookJP2`oookJP00oooonfZ>oookJP03o`000?oonf[o
oo]Z0;3ooo]Z003ooookJXkooo]Z00?o0000oookJ_oonfX0/?oonfX00?oooo]ZS_oonfX00ol0003o
oo]ZoookJP2`oookJP00oooonfZ>oookJP03o`000?oonf[ooo]Z0;3ooo]Z003ooookJXkooo]Z00?o
0000oookJ_oonfX0/?oonfX00?oooo]ZS_oonfX00ol0003ooo]ZoookJP2`oookJP00oooonfZ>oook
JP03o`000?oonf[ooo]Z0;3ooo]Z003ooookJXkooo]Z00?o0000oookJ_oonfX0/?oonfX00?oooo]Z
S_oonfX00ol0003ooo]ZoookJP2`oookJP00oooonfZ>oookJP03o`000?oonf[ooo]Z0;3ooo]Z003o
oookJXgooo]Z00?o0000oookJ_oonfX0/OoonfX00?oooo]ZSOoonfX00ol0003ooo]ZoookJP2aoook
JP00oooonfZ=oookJP03o`000?oonf[ooo]Z0;7ooo]Z003ooookJXgooo]Z00?o0000oookJ_oonfX0
/OoonfX00?oooo]ZSOoonfX00ol0003ooo]ZoookJP2aoookJP00oooonfZ=oookJP03o`000?oonf[o
oo]Z0;7ooo]Z003ooookJXgooo]Z00?o0000oookJ_oonfX0/OoonfX00?oooo]ZSOoonfX00ol0003o
oo]ZoookJP2aoookJP00oooonfZ=oookJP03o`000?oonf[ooo]Z0;7ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z0000\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.68905 .77959 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(41) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.68905 .77959 m
.68908 .7817 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJXSooo]Z0ol007l6oookJP?o001o[OoonfX00?oooo]ZR?oonfX3o`00O`Kooo]Z0ol007n]oook
JP00oooonfZ8oookJP?o001o1_oonfX3o`00Ojgooo]Z003ooookJX?ooo]Z2Ol007l5oookJP?o001o
[OoonfX00?oooo]ZPooonfX9o`00O`03oookJ_l0003ooo]Z00;ooo]Z0ol007n]oookJP00oooonfZ3
oookJP;o001o0ooonfX3o`00O`;ooo]Z00Co0000oookJ_oonf[ooo]Z0ol007n]oookJP00oooonfZ4
oookJP;o001o0_oonfX3o`00O`Kooo]Z0ol007n]oookJP00oooonfZ4oookJP?o001o00Cooo]Zo`00
Ool007oo001o1_oonfX3o`00Ojgooo]Z003ooookJXGooo]Z0_l007l01?oonf[o001oo`00Ool007l6
oookJP?o001o[OoonfX00?oooo]ZQ_oonfX5o`00O`?ooo]Z1_l007n]oookJP00oooonfZ6oookJPGo
001o0ooonfX6o`00Ojgooo]Z003ooookJXOooo]Z1?l007l5oookJPCo001o[OoonfX00?oooo]ZR?oo
nfX3o`00O`Kooo]Z0ol007n]oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z0000\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.68908 .7817 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(42) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.68908 .7817 m
.63717 .78282 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZR?oonfX3o`00O`;ooo]Z2Ol007n[oookJP00oooonfZ8oookJP?o
001o0_oonfX9o`00Oj_ooo]Z003ooookJXSooo]Z0ol007l2oookJPCo001o/?oonfX00?oooo]ZPooo
nfX9o`00O`;ooo]Z1?l007n_oookJP00oooonfYnoookJQ3o000000?ooo]Zo`00Ool007l00ol007n]
oookJP00oooonfY_oookJPoo00001OoonfX2o`00O`?ooo]Z0ol007l6oookJPCo001o[?oonfX00?oo
oo]ZQ?oonfX2o`00O`;ooo]Z0ol007l7oookJP?o001o[?oonfX00?oooo]ZQ?oonfX3o`00O`04oook
J_l007oo001oo`00O`Sooo]Z0ol007n[oookJP00oooonfZ5oookJP;o001o00Cooo]Zo`00Ool007oo
001o0_oonfX3o`00O`?ooo]Z0ol007n[oookJP00oooonfZ6oookJPGo001o0_oonfX3o`00O`?ooo]Z
0ol007n[oookJP00oooonfZ6oookJPGo001o0_oonfX4o`00O`;ooo]Z0ol007n[oookJP00oooonfZ7
oookJPCo001o0ooonfX7o`00Ojcooo]Z003ooookJXSooo]Z0ol007l4oookJPGo001o[OoonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00001\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.63717 .78282 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(43) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.63717 .78282 m
.60443 .84732 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonfYZoookJP?o001o1?oonfX5o`00Ol_o
oo]Z003ooookJV[ooo]Z0ol007l3oookJPOo001ob_oonfX00?oooo]ZJ_oonfX3o`00O`;ooo]Z0ol0
07l3oookJP?o001obOoonfX00?oooo]ZIOoonfX9o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol0
07o9oookJP00oooonfYUoookJPWo001o00?ooo]Zo`000?oonfX01?oonfX3o`00OlWooo]Z003ooook
JVGooo]Z0_l007l3oookJP?o001o0_oonfX00ol0003ooo]ZoookJP03oookJP?o001obOoonfX00?oo
oo]ZI_oonfX2o`00O`;ooo]Z0ol007l00ooonf[o0000oookJP03oookJPCo001ob_oonfX00?oooo]Z
I_oonfX3o`00O`06oookJ_l007oo001oo`00Oooonf[o00001?oonfX3o`00Ol_ooo]Z003ooookJVOo
oo]Z0_l007l01Ooonf[o001oo`00Ool007oo000000Oooo]Z0_l007o:oookJP00oooonfYXoookJPGo
001o00?o0000oookJ_l007l00_l007l3oookJP?o001obOoonfX00?oooo]ZJ?oonfX4o`00O`03o`00
0?oonf[ooo]Z00?o001o0ooonfX3o`00OlWooo]Z003ooookJVWooo]Z0ol007l01?l0003ooo]Zoook
J_oonfX7o`00Ol[ooo]Z003ooookJV[ooo]Z00?o001oo`000?l007l01?oonfX5o`00Ol_ooo]Z003o
oookJV_ooo]Z00?o0000oookJ_oonfX0dooonfX00?oooo]ZJ_oonfX00ol0003ooo]ZoookJP3Doook
JP00oooonfYZoookJP03o`000?oonf[ooo]Z0=Cooo]Z003ooookJVWooo]Z00?o0000oookJ_oonfX0
eOoonfX00?oooo]ZJOoonfX00ol0003ooo]ZoookJP3EoookJP00oooonfYXoookJP03o`000?oonf[o
oo]Z0=Kooo]Z003ooookJVSooo]Z00?o0000oookJ_oonfX0e_oonfX00?oooo]ZIooonfX00ol0003o
oo]ZoookJP3GoookJP00oooonfYWoookJP03o`000?oonf[ooo]Z0=Oooo]Z003ooookJVKooo]Z00?o
0000oookJ_oonfX0f?oonfX00?oooo]ZIOoonfX00ol0003ooo]ZoookJP3IoookJP00oooonfYUoook
JP03o`000?oonf[ooo]Z0=Wooo]Z003ooookJVCooo]Z00?o0000oookJ_oonfX0f_oonfX00?oooo]Z
I?oonfX00ol0003ooo]ZoookJP3JoookJP00oooonfYSoookJP03o`000?oonf[ooo]Z0=_ooo]Z003o
oookJV?ooo]Z00?o0000oookJ_oonfX0fooonfX00?oooo]ZH_oonfX00ol0003ooo]ZoookJP3Loook
JP00oooonfYRoookJP03o`000?oonf[ooo]Z0=cooo]Z003ooookJV7ooo]Z00?o0000oookJ_oonfX0
gOoonfX00?oooo]ZHOoonfX00ol0003ooo]ZoookJP3MoookJP00oooonfYPoookJP03o`000?oonf[o
oo]Z0=kooo]Z003ooookJV3ooo]Z00?o0000oookJ_oonfX0g_oonfX00?oooo]ZGooonfX00ol0003o
oo]ZoookJP3OoookJP00oooonfYOoookJP03o`000?oonf[ooo]Z0=oooo]Z003ooookJUkooo]Z00?o
0000oookJ_oonfX0h?oonfX00?oooo]ZG_oonfX00ol0003ooo]ZoookJP3PoookJP00oooonfYMoook
JP03o`000?oonf[ooo]Z0>7ooo]Z003ooookJUgooo]Z00?o0000oookJ_oonfX0hOoonfX00?oooo]Z
G?oonfX00ol0003ooo]ZoookJP3RoookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.60443 .84732 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(44) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.60443 .84732 m
.58913 .90728 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJUOooo]Z0ol007l7oookJP?o001ogOoonfX00?oooo]ZEooonfX3o`00O`Oooo]Z0ol007oM
oookJP00oooonfYGoookJP?o001o1ooonfX3o`00Omgooo]Z003ooookJU;ooo]Z2Ol007l00ooonf[o
001oo`00O`07o`00Omcooo]Z003ooookJU;ooo]Z2Ol007l00ooonf[o0000o`00O`07o`00Omcooo]Z
003ooookJU;ooo]Z0_l007l3oookJP?o001o0_oonfX00ol0003o001ooookJP02oookJP?o001ogOoo
nfX00?oooo]ZDooonfX2o`00O`;ooo]Z0ol007l2oookJP03o`000?l007oo001o00;ooo]Z0ol007oM
oookJP00oooonfYCoookJP?o001o00Oooo]Zo`00Ool007oo001ooookJ_l0003ooo]Z00?o001o00Co
oo]Zo`00Ool007oo001ogOoonfX00?oooo]ZE?oonfX2o`00O`06oookJ_l007oo001oo`00Oooonf[o
00000_oonfX2o`00O`04oookJ_l007oo001oo`00Omgooo]Z003ooookJUGooo]Z1Ol007l00ooonf[o
0000oookJP02oookJPGo001ogOoonfX00?oooo]ZEOoonfX5o`00O`03oookJ_l0003ooo]Z00;ooo]Z
1Ol007oMoookJP00oooonfYFoookJPCo001o00?o0000oookJ_oonfX00ooonfX4o`00Omgooo]Z003o
oookJUOooo]Z0ol007l00ol0003ooo]ZoookJP04oookJP?o001ogOoonfX00?oooo]ZF_oonfX00ol0
003ooo]ZoookJP3ToookJP00oooonfYIoookJP03o`000?oonf[ooo]Z0>Gooo]Z003ooookJUWooo]Z
00?o0000oookJ_oonfX0iOoonfX00?oooo]ZFOoonfX00ol0003ooo]ZoookJP3UoookJP00oooonfYI
oookJP03o`000?oonf[ooo]Z0>Gooo]Z003ooookJUSooo]Z00?o0000oookJ_oonfX0i_oonfX00?oo
oo]ZF?oonfX00ol0003ooo]ZoookJP3VoookJP00oooonfYHoookJP03o`000?oonf[ooo]Z0>Kooo]Z
003ooookJUSooo]Z00?o0000oookJ_oonfX0i_oonfX00?oooo]ZEooonfX00ol0003ooo]ZoookJP3W
oookJP00oooonfYGoookJP03o`000?oonf[ooo]Z0>Oooo]Z003ooookJUOooo]Z00?o0000oookJ_oo
nfX0iooonfX00?oooo]ZEooonfX00ol0003ooo]ZoookJP3WoookJP00oooonfYFoookJP03o`000?oo
nf[ooo]Z0>Sooo]Z003ooookJUKooo]Z00?o0000oookJ_oonfX0j?oonfX00?oooo]ZE_oonfX00ol0
003ooo]ZoookJP3XoookJP00oooonfYFoookJP03o`000?oonf[ooo]Z0>Sooo]Z003ooookJUGooo]Z
00?o0000oookJ_oonfX0jOoonfX00?oooo]ZEOoonfX00ol0003ooo]ZoookJP3YoookJP00oooonfYE
oookJP03o`000?oonf[ooo]Z0>Wooo]Z003ooookJUCooo]Z00?o0000oookJ_oonfX0j_oonfX00?oo
oo]ZE?oonfX00ol0003ooo]ZoookJP3ZoookJP00oooonfYDoookJP03o`000?oonf[ooo]Z0>[ooo]Z
003ooookJUCooo]Z00?o0000oookJ_oonfX0j_oonfX00?oooo]ZDooonfX00ol0003ooo]ZoookJP3[
oookJP00oooonfYCoookJP03o`000?oonf[ooo]Z0>_ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.58913 .90728 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(45) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.58913 .90728 m
.59426 .89862 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJUKooo]Z00?o0000oookJ_oonfX0j?oonfX00?oooo]Z
C_oonfX3o`00O`Cooo]Z00?o001oo`000?l007l00_l007oWoookJP00oooonfY>oookJP?o001o0ooo
nfX00ol007oo0000o`00O`04o`00OnKooo]Z003ooookJTkooo]Z0ol007l2oookJP05o`00Ool0003o
001oo`00OooonfX00ol007oVoookJP00oooonfY9oookJPWo001o00Cooo]Zo`00Ool0003o001o0ooo
nfX3o`00OnGooo]Z003ooookJTWooo]Z2Ol007l00ooonf[o0000oookJP04oookJP?o001oiOoonfX0
0?oooo]ZBOoonfX2o`00O`?ooo]Z0ol007l8oookJP?o001oiOoonfX00?oooo]ZB_oonfX2o`00O`;o
oo]Z0ol007l3oookJP;o001o0_oonfX4o`00OnGooo]Z003ooookJT[ooo]Z0ol007l01?oonf[o001o
o`00Ool007l3oookJPOo001oi_oonfX00?oooo]ZBooonfX2o`00O`04oookJ_l007oo001oo`00O`?o
oo]Z1_l007oWoookJP00oooonfY<oookJPGo001o0ooonfX2o`00On_ooo]Z003ooookJTcooo]Z1Ol0
07l3oookJP;o001ojooonfX00?oooo]ZCOoonfX4o`00O`Cooo]Z1ol007oUoookJP00oooonfY>oook
JP?o001o1?oonfX7o`00OnGooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z0000\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.59426 .89862 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(46) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.59426 .89862 m
.65082 .85183 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJWKooo]Z0_l00039
oookJP00oooonfYeoookJP03o`000?oonf[ooo]Z0<Wooo]Z003ooookJWCooo]Z00?o0000oookJ_oo
nfX0b_oonfX00?oooo]ZLooonfX00ol0003ooo]ZoookJP3;oookJP00oooonfYaoookJP;o0000c_oo
nfX00?oooo]ZL?oonfX00ol0003ooo]ZoookJP3>oookJP00oooonfY_oookJP03o`000?oonf[ooo]Z
0<oooo]Z003ooookJVkooo]Z00?o0000oookJ_oonfX0d?oonfX00?oooo]ZKOoonfX00ol0003ooo]Z
oookJP3AoookJP00oooonfY[oookJP;o0000e?oonfX00?oooo]ZJ_oonfX00ol0003ooo]ZoookJP3D
oookJP00oooonfYYoookJP03o`000?oonf[ooo]Z0=Gooo]Z003ooookJVSooo]Z00?o0000oookJ_oo
nfX0e_oonfX00?oooo]ZI_oonfX2o`000=Wooo]Z003ooookJVGooo]Z00?o0000oookJ_oonfX0fOoo
nfX00?oooo]ZI?oonfX00ol0003ooo]ZoookJP3JoookJP00oooonfYSoookJP03o`000?oonf[ooo]Z
0=_ooo]Z003ooookJV;ooo]Z00?o0000oookJ_oonfX0g?oonfX00?oooo]ZH?oonfX2o`000=oooo]Z
003ooookJUoooo]Z00?o0000oookJ_oonfX0gooonfX00?oooo]ZG_oonfX00ol0003ooo]ZoookJP3P
oookJP00oooonfYMoookJP03o`000?oonf[ooo]Z0>7ooo]Z003ooookJU_ooo]Z0_l0003ToookJP00
oooonfYAoookJP?o001o1?oonfX2o`00O`03o`000?l007oo001o0>Cooo]Z003ooookJU7ooo]Z0ol0
07l3oookJP;o001o00?o0000o`00Ool007l00_l007oSoookJP00oooonfYAoookJP?o001o0ooonfX0
0ol007oo0000o`00O`02oookJP?o001oh_oonfX00?oooo]ZC?oonfX9o`00O`04oookJ_l007oo0000
o`00O`?ooo]Z0ol007oRoookJP00oooonfY<oookJPWo001o00Cooo]Zo`000?l007oo001o0ooonfX3
o`00On;ooo]Z003ooookJTcooo]Z0_l007l3oookJP?o001o0_oonfX4o`00O`;ooo]Z0ol007oRoook
JP00oooonfY=oookJP;o001o0_oonfX3o`00O`;ooo]Z2?l007oSoookJP00oooonfY=oookJP?o001o
00Cooo]Zo`00Ool007oo001o0_oonfX3o`00O`04oookJ_l007oo001oo`00OnCooo]Z003ooookJTko
oo]Z0_l007l01?oonf[o001oo`00Ool007l2oookJP?o001oj?oonfX00?oooo]ZCooonfX5o`00O`;o
oo]Z0ol007oXoookJP00oooonfY?oookJPGo001o0ooonfX3o`00O`;ooo]Z0ol007oRoookJP00oooo
nfY@oookJPCo001o0ooonfX7o`00On?ooo]Z003ooookJU7ooo]Z0ol007l5oookJPCo001oi?oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z0000\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.65082 .85183 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(47) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.65082 .85183 m
.61303 .8396 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonfYQoookJP?o0000
gOoonfX00?oooo]ZI?oonfX3o`000=[ooo]Z003ooookJVOooo]Z0ol0003GoookJP00oooonfYZoook
JP?o00001OoonfX3o`00O`Cooo]Z0ol007o5oookJP00oooonfY]oookJP?o00000_oonfX3o`00O`Co
oo]Z0ol007o5oookJP00oooonfY`oookJP?o00000_l007l4oookJP?o001oaOoonfX00?oooo]ZKOoo
nfX6o`00O`?o00001?oonfX2o`00OlGooo]Z003ooookJVgooo]Z2Ol007l2o`0000;ooo]Z0ol007o4
oookJP00oooonfY]oookJP;o001o0ooonfX3o`00O`Gooo]Z0ol007o4oookJP00oooonfY^oookJP;o
001o0_oonfX3o`00O`Kooo]Z0_l007o4oookJP00oooonfY^oookJP?o001o00Cooo]Zo`00Ool007oo
001o1_oonfX3o`00Ol?ooo]Z003ooookJVoooo]Z0_l007l01?oonf[o001oo`00Ool007l7oookJP;o
001o`ooonfX00?oooo]ZL?oonfX5o`00O`Sooo]Z0_l007o2oookJP00oooonfY`oookJPGo001o2?oo
nfX2o`00Ol;ooo]Z003ooookJW7ooo]Z1?l007l2oookJPWo001o`OoonfX00?oooo]ZL_oonfX3o`00
O`;ooo]Z2Ol007o1oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00001\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.61303 .8396 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(48) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.61303 .8396 m
.60534 .81908 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonfYMoookJP03o`000?oonf[ooo]Z0>7ooo]Z003ooookJUgo
oo]Z00?o0000oookJ_oonfX0hOoonfX00?oooo]ZG_oonfX00ol0003ooo]ZoookJP3PoookJP00oooo
nfYNoookJP03o`000?oonf[ooo]Z0>3ooo]Z003ooookJUkooo]Z00?o0000oookJ_oonfX0h?oonfX0
0?oooo]ZGooonfX00ol0003ooo]ZoookJP3OoookJP00oooonfYOoookJP03o`000?oonf[ooo]Z0=oo
oo]Z003ooookJUoooo]Z00?o0000oookJ_oonfX0gooonfX00?oooo]ZG?oonfX3o`00O`04oookJ_l0
003ooo]ZoookJPGo001ofOoonfX00?oooo]ZG?oonfX3o`00O`03oookJ_l0003ooo]Z00Oo001of?oo
nfX00?oooo]ZG?oonfX3o`00O`03oookJ_l0003o001o00;o001o0ooonfX3o`00OmOooo]Z003ooook
JUOooo]Z2Ol007l01?oonf[o0000o`00Ool007l3oookJP?o001oeooonfX00?oooo]ZEooonfX9o`00
O`04oookJ_l0003o001oo`00O`?ooo]Z0ol007oGoookJP00oooonfYGoookJP;o001o0ooonfX3o`00
O`;ooo]Z0ol007l3oookJP?o001oeooonfX00?oooo]ZF?oonfX2o`00O`;ooo]Z0ol007l3oookJPOo
001of?oonfX00?oooo]ZF?oonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z1ol007oHoookJP00
oooonfYIoookJP;o001o00Cooo]Zo`00Ool007oo001o0_oonfX3o`00O`?ooo]Z0ol007oGoookJP00
oooonfYJoookJPGo001o0_oonfX3o`00O`?ooo]Z0ol007oGoookJP00oooonfYJoookJPGo001o0_oo
nfX3o`00O`?ooo]Z0ol007oGoookJP00oooonfYKoookJPCo001o0ooonfX7o`00OmSooo]Z003ooook
JUcooo]Z0ol007l4oookJPGo001ofOoonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00001\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.60534 .81908 -73 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(49) show
83.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.60534 .81908 m
.60431 .85034 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZF?oonfX3o`00O`Cooo]Z1?l007oNoookJP00oooonfYHoookJP?o001o
0ooonfX7o`00Omcooo]Z003ooookJUSooo]Z0ol007l2oookJP?o001o0_oonfX3o`00Omcooo]Z003o
oookJU?ooo]Z2Ol007l7oookJP?o001ofooonfX00?oooo]ZDooonfX9o`00O`03oookJ_l0003ooo]Z
00?o001o00Cooo]Zo`00Ool007oo001ofooonfX00?oooo]ZDooonfX2o`00O`?ooo]Z0ol007l2oook
JP03o`000?l007oo001o00Ko001ofooonfX00?oooo]ZE?oonfX2o`00O`;ooo]Z0ol007l2oookJP03
o`000?l007oo001o00;ooo]Z1?l007oKoookJP00oooonfYDoookJP?o001o00Cooo]Zo`00Ool007oo
001o0_oonfX00ol0003o001oo`00O`03oookJP?o001ofooonfX00?oooo]ZEOoonfX2o`00O`04oook
J_l007oo001oo`00O`;ooo]Z00?o0000o`00Ool007l00ooonfX3o`00Om_ooo]Z003ooookJUKooo]Z
1Ol007l2oookJP03o`000?l007oo001o00?ooo]Z0ol007oKoookJP00oooonfYFoookJPGo001o0_oo
nfX01Ol0003o001oo`00Ool007oooo]Z00?o001og?oonfX00?oooo]ZEooonfX4o`00O`;ooo]Z00?o
0000o`00Ool007l01Ol007oLoookJP00oooonfYHoookJP?o001o0_oonfX00ol0003ooo]Zo`00O`04
o`00Omgooo]Z003ooookJUgooo]Z00?o0000oookJ_oonfX0hOoonfX00?oooo]ZG?oonfX00ol0003o
oo]ZoookJP3RoookJP00oooonfYLoookJP03o`000?oonf[ooo]Z0>;ooo]Z003ooookJUcooo]Z00?o
0000oookJ_oonfX0h_oonfX00?oooo]ZG?oonfX00ol0003ooo]ZoookJP3RoookJP00oooonfYLoook
JP03o`000?oonf[ooo]Z0>;ooo]Z003ooookJUcooo]Z00?o0000oookJ_oonfX0h_oonfX00?oooo]Z
G?oonfX00ol0003ooo]ZoookJP3RoookJP00oooonfYLoookJP03o`000?oonf[ooo]Z0>;ooo]Z003o
oookJUcooo]Z00?o0000oookJ_oonfX0h_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z0000\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ShowAnimation[\[IndentingNewLine]Table[\[IndentingNewLine]Graphics[\
\[IndentingNewLine]Table[\[IndentingNewLine]{Text[\[IndentingNewLine]ToString[\
\(randomwalk[j]\)[\([1]\)]], \(randomwalk[
                    j]\)[\([2]\)]], \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\[IndentingNewLine]Line[{\(randomwalk[j]\)[\([2]\)], \(randomwalk[
                      j + 1]\)[\([2]\)]}]\[IndentingNewLine]}, \
\[IndentingNewLine]{j, 0, 
              i}\[IndentingNewLine]]\[IndentingNewLine]], \
\[IndentingNewLine]{i, 0, 
          49}\[IndentingNewLine]], \[IndentingNewLine]PlotRange \[Rule] \
{{\(-3\), 3}, {\(-3\), 3}}, AspectRatio \[Rule] 1, 
      AxesOrigin \[Rule] {0, 0}\[IndentingNewLine]]\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.5 .5 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(0) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.5 .5 m
.52155 .52756 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z7OoonfX5o`00Oooooo]Z8?oonfX00?oooo]Z7?oonfX7
o`00Oooooo]Z7ooonfX00?oooo]Z7?oonfX3o`00O`04oookJ_l007oo001oo`00Oooooo]Z7ooonfX0
0?oooo]Z6ooonfX3o`00O`?ooo]Z0ol007oooookJQkooo]Z003ooookJQ_ooo]Z0ol007l2oookJP04
o`000?l007oo001oo`00Oooooo]Z7_oonfX00?oooo]Z6ooonfX3o`00O`;ooo]Z00Co0000o`00Ool0
07oo001ooooonfXNoookJP00oooonfXKoookJP?o001o0ooonfX00ol0003o001oo`00O`3ooookJQko
oo]Z003ooookJQ_ooo]Z0ol007l3oookJP03o`00Ool0003o001o0?oooo]Z7_oonfX00?oooo]Z6ooo
nfX3o`00O`?ooo]Z0_l007l00ol0003ooo]ZoookJP3ooookJQcooo]Z003ooookJQ_ooo]Z0ol007l3
oookJP;o001o00?o0000oookJ_oonfX0oooonfXLoookJP00oooonfXLoookJP?o001o00Kooo]Zo`00
Ool007oo001ooookJ_l0003ooookJQgooo]Z003ooookJQcooo]Z1ol007l2oookJP03o`000?oonf[o
oo]Z0?oooo]Z6_oonfX00?oooo]Z7OoonfX5o`00O`Cooo]Z00?o0000oookJ_oonfX0oooonfXIoook
JP00oooonfXVoookJP03o`000?oonf[ooo]Z0?oooo]Z6OoonfX00?oooo]Z9ooonfX00ol0003ooo]Z
oookJP3ooookJQSooo]Z003ooookJRSooo]Z00?o0000oookJ_oonfX0oooonfXGoookJP00oooonfXY
oookJP03o`000?oonf[ooo]Z0?oooo]Z5_oonfX00?oooo]Z:OoonfX00ol0003ooo]ZoookJP3ooook
JQKooo]Z003ooookJR[ooo]Z00?o0000oookJ_oonfX0oooonfXEoookJP00oooonfX[oookJP03o`00
0?oonf[ooo]Z0?oooo]Z5?oonfX00?oooo]Z;?oonfX00ol0003ooo]ZoookJP3ooookJQ?ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00001\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.5 .5 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(0) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.5 .5 m
.52155 .52756 L
s
gsave
.52155 .52756 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.52155 .52756 m
.58348 .5338 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z7OoonfX5o`00Oooooo]Z8?oonfX00?oooo]Z7?oonfX7
o`00Oooooo]Z7ooonfX00?oooo]Z7?oonfX3o`00O`04oookJ_l007oo001oo`00Oooooo]Z7ooonfX0
0?oooo]Z6ooonfX3o`00O`?ooo]Z0ol007oooookJQkooo]Z003ooookJQ_ooo]Z0ol007l2oookJP04
o`000?l007oo001oo`00Oooooo]Z7_oonfX00?oooo]Z6ooonfX3o`00O`;ooo]Z00Co0000o`00Ool0
07oo001ooooonfXNoookJP00oooonfXKoookJP?o001o0ooonfX00ol0003o001oo`00O`3ooookJQko
oo]Z003ooookJQ_ooo]Z0ol007l3oookJP03o`00Ool0003o001o0?oooo]Z7_oonfX00?oooo]Z6ooo
nfX3o`00O`?ooo]Z0_l007l00ol0003ooo]ZoookJP3ooookJQcooo]Z003ooookJQ_ooo]Z0ol007l3
oookJP;o001o00?o0000oookJ_oonfX0oooonfXLoookJP00oooonfXLoookJP?o001o00Kooo]Zo`00
Ool007oo001ooookJ_l0003ooookJQgooo]Z003ooookJQcooo]Z1ol007l2oookJP03o`000?oonf[o
oo]Z0?oooo]Z6_oonfX00?oooo]Z7OoonfX5o`00O`Cooo]Z00?o0000oookJ_oonfX0oooonfXIoook
JP00oooonfXVoookJP03o`000?oonf[ooo]Z0?oooo]Z6OoonfX00?oooo]Z9ooonfX00ol0003ooo]Z
oookJP3ooookJQSooo]Z003ooookJRSooo]Z00?o0000oookJ_oonfX0oooonfXGoookJP00oooonfXY
oookJP03o`000?oonf[o001o00;o001ooooonfXDoookJP00oooonfXYoookJP03o`000?oonf[o001o
00;o001ooooonfXDoookJP00oooonfXZoookJP04o`000?l007oo001oo`00Oooooo]Z5?oonfX00?oo
oo]Z:ooonfX3o`00Oooooo]Z5?oonfX00?oooo]Z:ooonfX00ol007oo0000o`000005o`000?oooo]Z
3ooonfX00?oooo]Z:ooonfX3o`00O`Gooo]Z3?l0003ooookJP?ooo]Z003ooookJR_ooo]Z0ol007lA
oookJPco0000m_oonfX00?oooo]Z:ooonfX3o`00Oagooo]Z1_l0003`oookJP00oooonfX[oookJP?o
001ooooonfXDoookJP00oooonfXXoookJPKo001ooooonfXDoookJP00oooonfXXoookJPKo001ooooo
nfXDoookJP00oooonfXZoookJPCo001ooooonfXDoookJP00oooonfX[oookJP?o001ooooonfXDoook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00001\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.5 .5 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(0) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.5 .5 m
.52155 .52756 L
s
gsave
.52155 .52756 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.52155 .52756 m
.58348 .5338 L
s
gsave
.58348 .5338 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(2) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.58348 .5338 m
.59595 .49892 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z7OoonfX5o`00Oooooo]Z8?oonfX00?oooo]Z7?oonfX7
o`00Oooooo]Z7ooonfX00?oooo]Z7?oonfX3o`00O`04oookJ_l007oo001oo`00Oooooo]Z7ooonfX0
0?oooo]Z6ooonfX3o`00O`?ooo]Z0ol007lcoookJP03o`000?oonf[ooo]Z0>Oooo]Z003ooookJQ_o
oo]Z0ol007l2oookJP04o`000?l007oo001oo`00Oc?ooo]Z00?o0000oookJ_oonfX0iooonfX00?oo
oo]Z6ooonfX3o`00O`;ooo]Z00Co0000o`00Ool007oo001o<_oonfX00ol0003ooo]ZoookJP3Xoook
JP00oooonfXKoookJP?o001o0ooonfX00ol0003o001oo`00O`0boookJP03o`000?oonf[ooo]Z0>So
oo]Z003ooookJQ_ooo]Z0ol007l3oookJP03o`00Ool0003o001o03;ooo]Z00?o0000oookJ_oonfX0
j?oonfX00?oooo]Z6ooonfX3o`00O`?ooo]Z0_l007l00ol0003ooo]ZoookJP0_oookJP03o`000?oo
nf[ooo]Z0>Wooo]Z003ooookJQ_ooo]Z0ol007l3oookJP;o001o00?o0000oookJ_oonfX0;ooonfX0
0ol0003ooo]ZoookJP3YoookJP00oooonfXLoookJP?o001o00Kooo]Zo`00Ool007oo001ooookJ_l0
000`oookJP03o`000?oonf[ooo]Z0>Wooo]Z003ooookJQcooo]Z1ol007l2oookJP03o`000?oonf[o
oo]Z02cooo]Z00?o0000oookJ_oonfX0j_oonfX00?oooo]Z7OoonfX5o`00O`Cooo]Z00?o0000oook
J_oonfX0:ooonfX00ol0003ooo]ZoookJP3ZoookJP00oooonfXVoookJP03o`000?oonf[ooo]Z02_o
oo]Z00?o0000oookJ_oonfX0j_oonfX00?oooo]Z9ooonfX00ol0003ooo]ZoookJP0YoookJP03o`00
0?oonf[ooo]Z0>_ooo]Z003ooookJRSooo]Z00?o0000oookJ_oonfX0:?oonfX00ol0003ooo]Zoook
JP3[oookJP00oooonfXYoookJP03o`000?oonf[o001o00;o001o9OoonfX00ol0003ooo]ZoookJP3[
oookJP00oooonfXYoookJP03o`000?oonf[o001o00;o001o9?oonfX00ol0003ooo]ZoookJP3/oook
JP00oooonfXZoookJP04o`000?l007oo001oo`00ObCooo]Z00?o0000oookJ_oonfX0k?oonfX00?oo
oo]Z:ooonfX3o`00Oagooo]Z1ol007l00ol0003o001ooookJP3/oookJP00oooonfX[oookJP03o`00
Ool0003o000000Go00006?oonfX6o`00O`03o`000?l007oo001o0>gooo]Z003ooookJR_ooo]Z0ol0
07l5oookJPco00003?oonfX4o`00O`;ooo]Z00?o0000oookJ_oonfX0kOoonfX00?oooo]Z:ooonfX3
o`00Oa7ooo]Z3?l000000ooonf[o001oo`00O`02o`00O`03oookJ_l0003ooo]Z0>kooo]Z003ooook
JR_ooo]Z0ol007lMoookJP;o00000ol007l00ol0003o001ooookJP3^oookJP00oooonfX[oookJP?o
001o8OoonfX4o`00Onkooo]Z003ooookJRSooo]Z1_l007lRoookJP?o001ok_oonfX00?oooo]Z:?oo
nfX6o`00Ob?ooo]Z0ol007o]oookJP00oooonfXZoookJPCo001o7OoonfX3o`00O`?ooo]Z0ol007o]
oookJP00oooonfX[oookJP?o001o7OoonfX3o`00O`?ooo]Z0ol007o]oookJP00oooonfY;oookJPCo
001o0_oonfX3o`00Ongooo]Z003ooookJTcooo]Z1ol007o^oookJP00oooonfY=oookJPGo001okooo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z0000\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.5 .5 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(0) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.5 .5 m
.52155 .52756 L
s
gsave
.52155 .52756 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.52155 .52756 m
.58348 .5338 L
s
gsave
.58348 .5338 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(2) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.58348 .5338 m
.59595 .49892 L
s
gsave
.59595 .49892 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(3) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.59595 .49892 m
.59989 .53221 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJUCooo]Z1Ol007oXoookJP00oooonfXMoookJPGo001o<OoonfX7o`00OnOooo]Z003o
oookJQcooo]Z1ol007l_oookJP?o001o0ooonfX3o`00OnKooo]Z003ooookJQcooo]Z0ol007l01?oo
nf[o001oo`00Ool007l_oookJP?o001o0ooonfX3o`00OnKooo]Z003ooookJQ_ooo]Z0ol007l3oook
JP?o001o<ooonfX01?l0003o001oo`00Ool007oVoookJP00oooonfXKoookJP?o001o0_oonfX01?l0
003o001oo`00Ool007lcoookJP04o`000?l007oo001oo`00OnKooo]Z003ooookJQ_ooo]Z0ol007l2
oookJP04o`000?l007oo001oo`00Oc;ooo]Z00Co001oo`000?l007oo001oiooonfX00?oooo]Z6ooo
nfX3o`00O`?ooo]Z00?o0000o`00Ool007l0<_oonfX00ol007oo0000o`00O`3XoookJP00oooonfXK
oookJP?o001o0ooonfX00ol007oo0000o`00O`0boookJP;o00000_l007oWoookJP00oooonfXKoook
JP?o001o0ooonfX2o`00O`03o`000?oonf[ooo]Z02cooo]Z0ol007l00ol0003ooo]Zo`000003o`00
OnKooo]Z003ooookJQ_ooo]Z0ol007l3oookJP;o001o00?o0000oookJ_oonfX0;?oonfX3o`00O`04
o`000?oonf[ooo]Zo`0000;o001oi_oonfX00?oooo]Z7?oonfX3o`00O`06oookJ_l007oo001oo`00
Oooonf[o0000;_oonfX5o`00O`03o`000?l007oooo]Z0>Kooo]Z003ooookJQcooo]Z1ol007l2oook
JP03o`000?oonf[ooo]Z02cooo]Z1?l007l00ol0003ooo]ZoookJP3VoookJP00oooonfXMoookJPGo
001o1?oonfX00ol0003ooo]ZoookJP0[oookJP05o`000?oonf[ooo]ZoookJ_l00000j?oonfX00?oo
oo]Z9_oonfX00ol0003ooo]ZoookJP0[oookJP05o`000?oonf[ooo]ZoookJ_l00000j?oonfX00?oo
oo]Z9ooonfX00ol0003ooo]ZoookJP0YoookJP03o`000?oonf[ooo]Z00;ooo]Z00?o0000oookJ_oo
nfX0i_oonfX00?oooo]Z:?oonfX00ol0003ooo]ZoookJP0XoookJP03o`000?oonf[ooo]Z00;ooo]Z
00?o0000oookJ_oonfX0i_oonfX00?oooo]Z:OoonfX00ol0003ooo]Zo`00O`02o`00ObGooo]Z00?o
0000oookJ_oonfX00_oonfX00ol0003ooo]ZoookJP3VoookJP00oooonfXYoookJP03o`000?oonf[o
001o00;o001o9?oonfX00ol0003ooo]ZoookJP03oookJP03o`000?oonf[ooo]Z0>Kooo]Z003ooook
JR[ooo]Z00Co0000o`00Ool007oo001o9?oonfX00ol0003ooo]ZoookJP03oookJP03o`000?oonf[o
oo]Z0>Kooo]Z003ooookJR_ooo]Z0ol007lMoookJPOo001o00?o0000o`00OooonfX01?oonfX00ol0
003ooo]ZoookJP3UoookJP00oooonfX[oookJP03o`00Ool0003o000000Go00006?oonfX6o`00O`03
o`000?l007oo001o00Gooo]Z00?o0000oookJ_oonfX0iOoonfX00?oooo]Z:ooonfX3o`00O`Gooo]Z
3?l0000<oookJPCo001o0_oonfX00ol0003ooo]ZoookJP05oookJP03o`000?oonf[ooo]Z0>Gooo]Z
003ooookJR_ooo]Z0ol007lAoookJPco000000?ooo]Zo`00Ool007l00_l007l00ooonf[o0000oook
JP06oookJP03o`000?oonf[ooo]Z0>Gooo]Z003ooookJR_ooo]Z0ol007lMoookJP;o00000ol007l0
0ol0003o001ooookJP06oookJP03o`000?oonf[ooo]Z0>Gooo]Z003ooookJR_ooo]Z0ol007lQoook
JPCo001ok_oonfX00?oooo]Z:?oonfX6o`00Ob;ooo]Z0ol007o^oookJP00oooonfXXoookJPKo001o
8ooonfX3o`00Ongooo]Z003ooookJR[ooo]Z1?l007lMoookJP?o001o0ooonfX3o`00Ongooo]Z003o
oookJR_ooo]Z0ol007lMoookJP?o001o0ooonfX3o`00Ongooo]Z003ooookJT_ooo]Z1?l007l2oook
JP?o001okOoonfX00?oooo]ZC?oonfX7o`00Onkooo]Z003ooookJTgooo]Z1Ol007o_oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00001\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.5 .5 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(0) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.5 .5 m
.52155 .52756 L
s
gsave
.52155 .52756 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.52155 .52756 m
.58348 .5338 L
s
gsave
.58348 .5338 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(2) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.58348 .5338 m
.59595 .49892 L
s
gsave
.59595 .49892 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(3) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.59595 .49892 m
.59989 .53221 L
s
gsave
.59989 .53221 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(4) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.59989 .53221 m
.63048 .51816 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJUCooo]Z1Ol007oXoookJP00oooonfXMoookJPGo001o<OoonfX7o`00OnOooo]Z003o
oookJQcooo]Z1ol007l_oookJP?o001o0ooonfX3o`00OnKooo]Z003ooookJQcooo]Z0ol007l01?oo
nf[o001oo`00Ool007l_oookJP?o001o0ooonfX3o`00OnKooo]Z003ooookJQ_ooo]Z0ol007l3oook
JP?o001o<ooonfX01?l0003o001oo`00Ool007oVoookJP00oooonfXKoookJP?o001o0_oonfX01?l0
003o001oo`00Ool007lcoookJP04o`000?l007oo001oo`00OnKooo]Z003ooookJQ_ooo]Z0ol007l2
oookJP04o`000?l007oo001oo`00Oc;ooo]Z00Co001oo`000?l007oo001oiooonfX00?oooo]Z6ooo
nfX3o`00O`?ooo]Z00?o0000o`00Ool007l0<_oonfX00ol007oo0000o`00O`3XoookJP00oooonfXK
oookJP?o001o0ooonfX00ol007oo0000o`00O`0boookJP;o00000_l007oWoookJP00oooonfXKoook
JP?o001o0ooonfX2o`00O`03o`000?oonf[ooo]Z02cooo]Z0ol007l00ol0003ooo]Zo`000003o`00
OnKooo]Z003ooookJQ_ooo]Z0ol007l3oookJP;o001o00?o0000oookJ_oonfX0;?oonfX3o`00O`04
o`000?oonf[ooo]Zo`0000;o001oi_oonfX00?oooo]Z7?oonfX3o`00O`06oookJ_l007oo001oo`00
Oooonf[o0000;_oonfX5o`00O`03o`000?l007oooo]Z0>Kooo]Z003ooookJQcooo]Z1ol007l2oook
JP03o`000?oonf[ooo]Z02cooo]Z1?l007l00ol0003ooo]ZoookJP3VoookJP00oooonfXMoookJPGo
001o1?oonfX00ol0003ooo]ZoookJP0[oookJP05o`000?oonf[ooo]ZoookJ_l00000j?oonfX00?oo
oo]Z9_oonfX00ol0003ooo]ZoookJP0[oookJP05o`000?oonf[ooo]ZoookJ_l00000j?oonfX00?oo
oo]Z9ooonfX00ol0003ooo]ZoookJP0YoookJP03o`000?oonf[ooo]Z00;ooo]Z00?o0000oookJ_oo
nfX03ooonfX2o`000=Gooo]Z003ooookJRSooo]Z00?o0000oookJ_oonfX0:?oonfX00ol0003ooo]Z
oookJP02oookJP03o`000?oonf[ooo]Z00gooo]Z0_l0003GoookJP00oooonfXYoookJP03o`000?oo
nf[o001o00;o001o9OoonfX00ol0003ooo]ZoookJP02oookJP03o`000?oonf[ooo]Z00_ooo]Z0_l0
003IoookJP00oooonfXYoookJP03o`000?oonf[o001o00;o001o9?oonfX00ol0003ooo]ZoookJP03
oookJP03o`000?oonf[ooo]Z00Wooo]Z0_l0003KoookJP00oooonfXZoookJP04o`000?l007oo001o
o`00ObCooo]Z00?o0000oookJ_oonfX00ooonfX00ol0003ooo]ZoookJP07oookJP;o0000gOoonfX0
0?oooo]Z:ooonfX3o`00Oagooo]Z1ol007l00ol0003o001ooookJP04oookJP?o001o1?oonfX2o`00
0=oooo]Z003ooookJR_ooo]Z00?o001oo`000?l000001Ol0000HoookJPKo001o00?o0000o`00Ool0
07l01OoonfX3o`00O`;ooo]Z0_l0003QoookJP00oooonfX[oookJP?o001o1OoonfX<o`0000cooo]Z
1?l007l2oookJP03o`000?oonf[ooo]Z00Gooo]Z0ol007l2o`000>?ooo]Z003ooookJR_ooo]Z0ol0
07lAoookJPco000000?ooo]Zo`00Ool007l00_l007l01?oonf[o0000oookJ_oonfX6o`00O`;o0000
00?o001ooookJ_oonfX0h_oonfX00?oooo]Z:ooonfX3o`00Oagooo]Z0_l00003o`00O`04o`000?l0
07oooo]ZoookJPGo001o00Co0000o`00Ool007oo001oi?oonfX00?oooo]Z:ooonfX3o`00Ob7ooo]Z
1?l007l00ooonf[o001oo`00O`03oookJP?o001oiOoonfX00?oooo]Z:?oonfX6o`00Ob;ooo]Z0ol0
07l2oookJP;o001o0_oonfX3o`00OnGooo]Z003ooookJRSooo]Z1_l007lSoookJP?o001o00Gooo]Z
o`00Ool007oo001ooookJP03o`00OnGooo]Z003ooookJR[ooo]Z1?l007lMoookJP?o001o0ooonfX3
o`00O`;ooo]Z0_l007l01?oonf[o001oo`00Ool007oUoookJP00oooonfX[oookJP?o001o7OoonfX3
o`00O`?ooo]Z0ol007l3oookJPGo001oiOoonfX00?oooo]ZBooonfX4o`00O`;ooo]Z0ol007l3oook
JPGo001oiOoonfX00?oooo]ZC?oonfX7o`00O`Gooo]Z1?l007oUoookJP00oooonfY=oookJPGo001o
1ooonfX3o`00OnGooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.5 .5 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(0) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.5 .5 m
.52155 .52756 L
s
gsave
.52155 .52756 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.52155 .52756 m
.58348 .5338 L
s
gsave
.58348 .5338 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(2) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.58348 .5338 m
.59595 .49892 L
s
gsave
.59595 .49892 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(3) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.59595 .49892 m
.59989 .53221 L
s
gsave
.59989 .53221 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(4) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.59989 .53221 m
.63048 .51816 L
s
gsave
.63048 .51816 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(5) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.63048 .51816 m
.66899 .52098 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJUCooo]Z1Ol007oXoookJP00oooonfXMoookJPGo001o<OoonfX7o`00OnOooo]Z003o
oookJQcooo]Z1ol007l_oookJP?o001o0ooonfX3o`00OnKooo]Z003ooookJQcooo]Z0ol007l01?oo
nf[o001oo`00Ool007l_oookJP?o001o0ooonfX3o`00OnKooo]Z003ooookJQ_ooo]Z0ol007l3oook
JP?o001o<ooonfX01?l0003o001oo`00Ool007oVoookJP00oooonfXKoookJP?o001o0_oonfX01?l0
003o001oo`00Ool007lcoookJP04o`000?l007oo001oo`00OnKooo]Z003ooookJQ_ooo]Z0ol007l2
oookJP04o`000?l007oo001oo`00Oc;ooo]Z00Co001oo`000?l007oo001oiooonfX00?oooo]Z6ooo
nfX3o`00O`?ooo]Z00?o0000o`00Ool007l0<_oonfX00ol007oo0000o`00O`3XoookJP00oooonfXK
oookJP?o001o0ooonfX00ol007oo0000o`00O`0boookJP;o00000_l007oWoookJP00oooonfXKoook
JP?o001o0ooonfX2o`00O`03o`000?oonf[ooo]Z02cooo]Z0ol007l00ol0003ooo]Zo`000003o`00
OnKooo]Z003ooookJQ_ooo]Z0ol007l3oookJP;o001o00?o0000oookJ_oonfX0;?oonfX3o`00O`04
o`000?oonf[ooo]Zo`0000;o001oi_oonfX00?oooo]Z7?oonfX3o`00O`06oookJ_l007oo001oo`00
Oooonf[o0000;_oonfX5o`00O`03o`000?l007oooo]Z00gooo]Z1Ol007oDoookJP00oooonfXLoook
JPOo001o0_oonfX00ol0003ooo]ZoookJP0/oookJPCo001o00?o0000oookJ_oonfX03?oonfX7o`00
Om?ooo]Z003ooookJQgooo]Z1Ol007l4oookJP03o`000?oonf[ooo]Z02_ooo]Z00Go0000oookJ_oo
nf[ooo]Zo`00000=oookJPCo001o00Cooo]Zo`00Ool007oo001odooonfX00?oooo]Z9_oonfX00ol0
003ooo]ZoookJP0[oookJP05o`000?oonf[ooo]ZoookJ_l000003OoonfX3o`00O`?ooo]Z0ol007oB
oookJP00oooonfXWoookJP03o`000?oonf[ooo]Z02Wooo]Z00?o0000oookJ_oonfX00_oonfX00ol0
003ooo]ZoookJP0?oookJPSo0000cooonfX00?oooo]Z:?oonfX00ol0003ooo]ZoookJP0XoookJP03
o`000?oonf[ooo]Z00;ooo]Z00?o0000oookJ_oonfX03OoonfX2o`0000;ooo]Z0ol007l3oookJP_o
0000a?oonfX00?oooo]Z:OoonfX00ol0003ooo]Zo`00O`02o`00ObGooo]Z00?o0000oookJ_oonfX0
0_oonfX00ol0003ooo]ZoookJP0;oookJP03o`000?l007oo001o00;ooo]Z1?l007l>oookJPGo0000
_ooonfX00?oooo]Z:OoonfX00ol0003ooo]Zo`00O`02o`00ObCooo]Z00?o0000oookJ_oonfX00ooo
nfX00ol0003ooo]ZoookJP09oookJP;o000000?ooo]Zo`00Ool007l01Ol007oCoookJP00oooonfXZ
oookJP04o`000?l007oo001oo`00ObCooo]Z00?o0000oookJ_oonfX00ooonfX00ol0003ooo]Zoook
JP07oookJP;o00000ooonfX6o`00OmCooo]Z003ooookJR_ooo]Z0ol007lMoookJPOo001o00?o0000
o`00OooonfX01?oonfX3o`00O`Cooo]Z0_l00005oookJP;o001of?oonfX00?oooo]Z:ooonfX00ol0
07oo0000o`000005o`0001Sooo]Z1_l007l00ol0003o001oo`00O`05oookJP?o001o0_oonfX2o`00
00Oooo]Z0_l007oHoookJP00oooonfX[oookJP?o001o1OoonfX<o`0000cooo]Z1?l007l2oookJP03
o`000?oonf[ooo]Z00Gooo]Z0ol007l2o`0000[ooo]Z1ol007oBoookJP00oooonfX[oookJP?o001o
4OoonfX<o`000003oookJ_l007oo001o00;o001o00Cooo]Zo`000?oonf[ooo]Z1_l007l2o`000003
o`00Oooonf[ooo]Z00Wooo]Z1ol007oBoookJP00oooonfX[oookJP?o001o7OoonfX2o`0000?o001o
00Co0000o`00Oooonf[ooo]Z1Ol007l01?l0003o001oo`00Ool007oToookJP00oooonfX[oookJP?o
001o8OoonfX4o`00O`03oookJ_l007oo001o00?ooo]Z0ol007oUoookJP00oooonfXXoookJPKo001o
8_oonfX3o`00O`;ooo]Z0_l007l2oookJP?o001oiOoonfX00?oooo]Z:?oonfX6o`00Ob?ooo]Z0ol0
07l01Ooonf[o001oo`00Ool007oooo]Z00?o001oiOoonfX00?oooo]Z:_oonfX4o`00Oagooo]Z0ol0
07l3oookJP?o001o0_oonfX2o`00O`04oookJ_l007oo001oo`00OnGooo]Z003ooookJR_ooo]Z0ol0
07lMoookJP?o001o0ooonfX3o`00O`?ooo]Z1Ol007oUoookJP00oooonfY;oookJPCo001o0_oonfX3
o`00O`?ooo]Z1Ol007oUoookJP00oooonfY<oookJPOo001o1OoonfX4o`00OnGooo]Z003ooookJTgo
oo]Z1Ol007l7oookJP?o001oiOoonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z0000\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.5 .5 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(0) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.5 .5 m
.52155 .52756 L
s
gsave
.52155 .52756 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.52155 .52756 m
.58348 .5338 L
s
gsave
.58348 .5338 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(2) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.58348 .5338 m
.59595 .49892 L
s
gsave
.59595 .49892 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(3) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.59595 .49892 m
.59989 .53221 L
s
gsave
.59989 .53221 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(4) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.59989 .53221 m
.63048 .51816 L
s
gsave
.63048 .51816 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(5) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.63048 .51816 m
.66899 .52098 L
s
gsave
.66899 .52098 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(6) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.66899 .52098 m
.6713 .52256 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJUCooo]Z1Ol007oXoookJP00oooonfXMoookJPGo001o<OoonfX7o`00OnOooo]Z003o
oookJQcooo]Z1ol007l_oookJP?o001o0ooonfX3o`00OnKooo]Z003ooookJQcooo]Z0ol007l01?oo
nf[o001oo`00Ool007l_oookJP?o001o0ooonfX3o`00OnKooo]Z003ooookJQ_ooo]Z0ol007l3oook
JP?o001o<ooonfX01?l0003o001oo`00Ool007oVoookJP00oooonfXKoookJP?o001o0_oonfX01?l0
003o001oo`00Ool007lcoookJP04o`000?l007oo001oo`00OnKooo]Z003ooookJQ_ooo]Z0ol007l2
oookJP04o`000?l007oo001oo`00Oc;ooo]Z00Co001oo`000?l007oo001oiooonfX00?oooo]Z6ooo
nfX3o`00O`?ooo]Z00?o0000o`00Ool007l0<_oonfX00ol007oo0000o`00O`3XoookJP00oooonfXK
oookJP?o001o0ooonfX00ol007oo0000o`00O`0boookJP;o00000_l007oWoookJP00oooonfXKoook
JP?o001o0ooonfX2o`00O`03o`000?oonf[ooo]Z02cooo]Z0ol007l00ol0003ooo]Zo`000003o`00
OnKooo]Z003ooookJQ_ooo]Z0ol007l3oookJP;o001o00?o0000oookJ_oonfX0;?oonfX3o`00O`04
o`000?oonf[ooo]Zo`0000;o001oi_oonfX00?oooo]Z7?oonfX3o`00O`06oookJ_l007oo001oo`00
Oooonf[o0000;_oonfX5o`00O`03o`000?l007oooo]Z00gooo]Z1Ol007oDoookJP00oooonfXLoook
JPOo001o0_oonfX00ol0003ooo]ZoookJP0/oookJPCo001o00?o0000oookJ_oonfX03?oonfX7o`00
Om?ooo]Z003ooookJQgooo]Z1Ol007l4oookJP03o`000?oonf[ooo]Z02_ooo]Z00Go0000oookJ_oo
nf[ooo]Zo`00000=oookJPCo001o00Cooo]Zo`00Ool007oo001o4?oonfX5o`00Okkooo]Z003ooook
JRKooo]Z00?o0000oookJ_oonfX0:ooonfX01Ol0003ooo]ZoookJ_oonf[o000000gooo]Z0ol007l3
oookJP?o001o3_oonfX7o`00Okgooo]Z003ooookJROooo]Z00?o0000oookJ_oonfX0:OoonfX00ol0
003ooo]ZoookJP02oookJP03o`000?oonf[ooo]Z00oooo]Z2?l0000;oookJP?o001o0_oonfX3o`00
Okcooo]Z003ooookJRSooo]Z00?o0000oookJ_oonfX0:?oonfX00ol0003ooo]ZoookJP02oookJP03
o`000?oonf[ooo]Z00gooo]Z0_l00002oookJP?o001o0ooonfX:o`0000?o001o0ooonfX3o`00Okco
oo]Z003ooookJRWooo]Z00?o0000oookJ_l007l00_l007lUoookJP03o`000?oonf[ooo]Z00;ooo]Z
00?o0000oookJ_oonfX02ooonfX00ol0003o001oo`00O`02oookJPCo001o3OoonfX3o`00O`?o0000
0ol007nloookJP00oooonfXYoookJP03o`000?oonf[o001o00;o001o9?oonfX00ol0003ooo]Zoook
JP03oookJP03o`000?oonf[ooo]Z00Wooo]Z0_l000000ooonf[o001oo`00O`05o`00O`kooo]Z1?l0
07l2oookJP03o`000?l007oo001o0;cooo]Z003ooookJR[ooo]Z00Co0000o`00Ool007oo001o9?oo
nfX00ol0003ooo]ZoookJP03oookJP03o`000?oonf[ooo]Z00Oooo]Z0_l00003oookJPKo001o3ooo
nfX8o`00Okgooo]Z003ooookJR_ooo]Z0ol007lMoookJPOo001o00?o0000o`00OooonfX01?oonfX3
o`00O`Cooo]Z0_l00005oookJP;o001o4ooonfX3o`00O`04oookJ_l007oo001oo`00Okkooo]Z003o
oookJR_ooo]Z00?o001oo`000?l000001Ol0000HoookJPKo001o00?o0000o`00Ool007l01OoonfX3
o`00O`;ooo]Z0_l00007oookJP;o001o4ooonfX3o`00Ol;ooo]Z003ooookJR_ooo]Z0ol007l5oook
JPco00003?oonfX4o`00O`;ooo]Z00?o0000oookJ_oonfX01OoonfX3o`00O`;o00002_oonfX7o`00
O`gooo]Z0ol007o2oookJP00oooonfX[oookJP?o001o4OoonfX<o`000003oookJ_l007oo001o00;o
001o00Cooo]Zo`000?oonf[ooo]Z1_l007l2o`000003o`00Oooonf[ooo]Z00Wooo]Z1ol007l>oook
JP?o001o0_oonfX3o`00Okcooo]Z003ooookJR_ooo]Z0ol007lMoookJP;o00000ol007l01?l0003o
001ooookJ_oonfX5o`00O`04o`000?l007oo001oo`00Ob3ooo]Z1ol007nmoookJP00oooonfX[oook
JP?o001o8OoonfX4o`00O`03oookJ_l007oo001o00?ooo]Z0ol007lSoookJPCo001o__oonfX00?oo
oo]Z:?oonfX6o`00Ob;ooo]Z0ol007l2oookJP;o001o0_oonfX3o`00OnGooo]Z003ooookJRSooo]Z
1_l007lSoookJP?o001o00Gooo]Zo`00Ool007oo001ooookJP03o`00OnGooo]Z003ooookJR[ooo]Z
1?l007lMoookJP?o001o0ooonfX3o`00O`;ooo]Z0_l007l01?oonf[o001oo`00Ool007oUoookJP00
oooonfX[oookJP?o001o7OoonfX3o`00O`?ooo]Z0ol007l3oookJPGo001oiOoonfX00?oooo]ZBooo
nfX4o`00O`;ooo]Z0ol007l3oookJPGo001oiOoonfX00?oooo]ZC?oonfX7o`00O`Gooo]Z1?l007oU
oookJP00oooonfY=oookJPGo001o1ooonfX3o`00OnGooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00\
\>"],
  ImageRangeCache->{{{0, 575}, {575, 0}} -> {-3.00002, -3.00002, 0.0104349, \
0.0104349}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.166667 0.5 0.166667 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
gsave
.5 .5 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(0) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
[ ] 0 setdash
.5 .5 m
.52155 .52756 L
s
gsave
.52155 .52756 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.52155 .52756 m
.58348 .5338 L
s
gsave
.58348 .5338 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(2) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.58348 .5338 m
.59595 .49892 L
s
gsave
.59595 .49892 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(3) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.59595 .49892 m
.59989 .53221 L
s
gsave
.59989 .53221 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(4) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.59989 .53221 m
.63048 .51816 L
s
gsave
.63048 .51816 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(5) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.63048 .51816 m
.66899 .52098 L
s
gsave
.66899 .52098 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(6) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.66899 .52098 m
.6713 .52256 L
s
gsave
.6713 .52256 -68 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(7) show
73.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.6713 .52256 m
.67959 .51202 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 576},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900002@2000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJUCooo]Z1Ol007oXoookJP00oooonfXMoookJPGo001o<OoonfX7o`00OnOooo]Z003o
oookJQcooo]Z1ol007l_oookJP?o001o0ooonfX3o`00OnKooo]Z003ooookJQcooo]Z0ol007l01?oo
nf[o001oo`00Ool007l_oookJP?o001o0ooonfX3o`00OnKooo]Z003ooookJQ_ooo]Z0ol007l3oook
JP?o001o<ooonfX01?l0003o001oo`00Ool007oVoookJP00oooonfXKoookJP?o001o0_oonfX01?l0
003o001oo`00Ool007lcoookJP04o`000?l007oo001oo`00OnKooo]Z003ooookJQ_ooo]Z0ol007l2
oookJP04o`000?l007oo001oo`00Oc;ooo]Z00Co001oo`000?l007oo001oiooonfX00?oooo]Z6ooo
nfX3o`00O`?ooo]Z00?o0000o`00Ool007l0<_oonfX00ol007oo0000o`00O`3XoookJP00oooonfXK
oookJP?o001o0ooonfX00ol007oo0000o`00O`0boookJP;o00000_l007oWoookJP00oooonfXKoook
JP?o001o0ooonfX2o`00O`03o`000?oonf[ooo]Z02cooo]Z0ol007l00ol0003ooo]Zo`000003o`00
OnKooo]Z003ooookJQ_ooo]Z0ol007l3oookJP;o001o00?o0000oookJ_oonfX0;?oonfX3o`00O`04
o`000?oonf[ooo]Zo`0000;o001oi_oonfX00?oooo]Z7?oonfX3o`00O`06oookJ_l007oo001oo`00
Oooonf[o0000;_oonfX5o`00O`03o`000?l007oooo]Z00gooo]Z1Ol007oDoookJP00oooonfXLoook
JPOo001o0_oonfX00ol0003ooo]ZoookJP0/oookJPCo001o00?o0000oookJ_oonfX03?oonfX7o`00
OaWooo]Z00?o0000oookJ_oonfX0]ooonfX00?oooo]Z7OoonfX5o`00O`Cooo]Z00?o0000oookJ_oo
nfX0:ooonfX01Ol0003ooo]ZoookJ_oonf[o000000gooo]Z1?l007l01?oonf[o001oo`00Ool007l@
oookJPGo001o1?oonfX00ol0003ooo]ZoookJP2goookJP00oooonfXVoookJP03o`000?oonf[ooo]Z
02_ooo]Z00Go0000oookJ_oonf[ooo]Zo`00000=oookJP?o001o0ooonfX3o`00O`kooo]Z1ol007l2
oookJP03o`000?oonf[ooo]Z0;Sooo]Z003ooookJROooo]Z00?o0000oookJ_oonfX0:OoonfX00ol0
003ooo]ZoookJP02oookJP03o`000?oonf[ooo]Z00oooo]Z2?l0000;oookJPSo001o00?o0000oook
J_oonfX0^OoonfX00?oooo]Z:?oonfX00ol0003ooo]ZoookJP0XoookJP03o`000?oonf[ooo]Z00;o
oo]Z00?o0000oookJ_oonfX03OoonfX2o`0000;ooo]Z0ol007l3oookJP[o00002?l007l00ol0003o
oo]ZoookJP2joookJP00oooonfXYoookJP03o`000?oonf[o001o00;o001o9OoonfX00ol0003ooo]Z
oookJP02oookJP03o`000?oonf[ooo]Z00_ooo]Z00?o0000o`00Ool007l00_oonfX4o`00O`gooo]Z
0ol007l01_l0003o001oo`00Ool007oo0000o`00Okcooo]Z003ooookJRWooo]Z00?o0000oookJ_l0
07l00_l007lToookJP03o`000?oonf[ooo]Z00?ooo]Z00?o0000oookJ_oonfX02OoonfX2o`000003
oookJ_l007oo001o00Go001o3_oonfX6o`00O`03o`000?l007oo001o0;cooo]Z003ooookJR[ooo]Z
00Co0000o`00Ool007oo001o9?oonfX00ol0003ooo]ZoookJP03oookJP03o`000?oonf[ooo]Z00Oo
oo]Z0_l00003oookJPKo001o3ooonfX8o`00Okgooo]Z003ooookJR_ooo]Z0ol007lMoookJPOo001o
00?o0000o`00OooonfX01?oonfX3o`00O`Cooo]Z0_l00005oookJP;o001o4ooonfX3o`00O`04oook
J_l007oo001oo`00Okkooo]Z003ooookJR_ooo]Z00?o001oo`000?l000001Ol0000HoookJPKo001o
00?o0000o`00Ool007l01OoonfX3o`00O`;ooo]Z0_l00007oookJP;o001o4ooonfX3o`00O`;ooo]Z
0ol007nmoookJP00oooonfX[oookJP?o001o1OoonfX<o`0000cooo]Z1?l007l2oookJP03o`000?oo
nf[ooo]Z00Gooo]Z0ol007l2o`0000[ooo]Z1ol007l=oookJP?o001o0ooonfX2o`00Okgooo]Z003o
oookJR_ooo]Z0ol007lAoookJPco000000?ooo]Zo`00Ool007l00_l007l01?oonf[o0000oookJ_oo
nfX6o`00O`;o000000?o001ooookJ_oonfX02OoonfX7o`00O`kooo]Z0ol007l2oookJP?o001o_?oo
nfX00?oooo]Z:ooonfX3o`00Oagooo]Z0_l00003o`00O`04o`000?l007oooo]ZoookJPGo001o00Co
0000o`00Ool007oo001o8?oonfX8o`00Okcooo]Z003ooookJR_ooo]Z0ol007lQoookJPCo001o00?o
oo]Zo`00Ool007l00ooonfX3o`00Ob7ooo]Z2Ol007nkoookJP00oooonfXXoookJPKo001o8_oonfX3
o`00O`;ooo]Z0_l007l2oookJP?o001o8OoonfX9o`00Ok_ooo]Z003ooookJRSooo]Z1_l007lSoook
JP?o001o00Gooo]Zo`00Ool007oo001ooookJP03o`00OnGooo]Z003ooookJR[ooo]Z1?l007lMoook
JP?o001o0ooonfX3o`00O`;ooo]Z0_l007l01?oonf[o001oo`00Ool007oUoookJP00oooonfX[oook
JP?o001o7OoonfX3o`00O`?ooo]Z0ol007l3oookJPGo001oiOoonfX00?oooo]ZBooonfX4o`00O`;o
oo]Z0ol007l3oookJPGo001oiOoonfX00?oooo]ZC?oonfX7o`00O`Gooo]Z1?l007oUoookJP00oooo
nfY=oookJPGo001o1ooonfX3o`00OnGooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Zoooo
nfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00
oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oo
oo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2
oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oo
nfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[o
oookJT;ooo]Z003ooo