(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   2049252,      56330]*)
(*NotebookOutlinePosition[   2053095,      56424]*)
(*  CellTagsIndexPosition[   2052226,      56403]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["First-Order Ordinary Differential Equations", "Title"],

Cell["Background--simple iteration", "Subtitle",
  CellTags->"mmtag:19:simple_forward_time_interation"],

Cell["\<\
Suppose a function,  F[i], changes proportional to its current \
size, i.e.,  F[i+1] = F[i] + \[Alpha]F[i],\
\>", "Text"],

Cell[BoxData[
    \(ExampleFunction[i_, \ alpha_]\  := \ 
      ExampleFunction[i - 1, alpha]\  + \ 
        alpha*ExampleFunction[i - 1, alpha]\)], "Input"],

Cell["\<\
What would happen if the following functions were evaluated? (Note: \
if you execute the next step you may have to abort the calculation.)\
\>", \
"Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(ExampleFunction[25, 0.25]\ \[IndentingNewLine]
    ExampleFunction[25, \(-0.125\)]\)\(\ \)\)\)], "Input"],

Cell["\<\
It is clear that the function needs some value at some time (an \
initial condition) from which it obtains all its other values:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExampleFunction[0, 0.25]\  = \ \[Pi]/4\)], "Input"],

Cell[BoxData[
    \(\[Pi]\/4\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExampleFunction[18, 0.25]\)], "Input"],

Cell[BoxData[
    \(43.598356225107906`\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell["\<\
This function is fairly inefficient, it calculates the first value \
about 18 times before it returns the answer, the following function sets the \
initial value and remembers what \"trajectory\" it is on--i,e., the \
trajectory is determined from the start\
\>", "Text"],

Cell[BoxData[
    \(GrowsPropToSize[i_\ , \ alpha_\ , \ F0_]\  := \ 
      If[i \[Equal] 0, GrowsPropToSize[0, alpha, F0] = F0, 
        GrowsPropToSize[i, alpha, F0]\  = \ 
          GrowsPropToSize[i - 1, alpha, F0]\  + \ 
            alpha*GrowsPropToSize[i - 1, alpha, F0]\ \ ]\)], "Input"],

Cell["For example:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[GrowsPropToSize[i,  .01, 1], {i, 18}]\)], "Input"],

Cell[BoxData[
    \({1.01`, 1.0201`, 1.030301`, 1.0406040099999998`, 1.0510100500999997`, 
      1.0615201506009997`, 1.0721353521070096`, 1.0828567056280798`, 
      1.0936852726843607`, 1.1046221254112043`, 1.1156683466653163`, 
      1.1268250301319696`, 1.1380932804332893`, 1.1494742132376221`, 
      1.1609689553699982`, 1.1725786449236981`, 1.1843044313729352`, 
      1.1961474756866646`}\)], "Output"]
}, Open  ]],

Cell["\<\
Might as well write a function to calculate a vector representing \
trajectory, here is an implementation to compute a trajectory vector of \
length 300\
\>", "Text"],

Cell[BoxData[
    \(Trajectory[alpha_, \ F0_]\  := \ 
      Table[GrowsPropToSize[i, alpha, F0], {i, 300}]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListPlot[Trajectory[0.01, 1], PlotJoined \[Rule] True]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0031746 0.0147151 0.0297448 [
[.18254 .00222 -12 -20 ]
[.18254 .00222 12 0 ]
[.34127 .00222 -17 -20 ]
[.34127 .00222 17 0 ]
[.5 .00222 -17 -20 ]
[.5 .00222 17 0 ]
[.65873 .00222 -17 -20 ]
[.65873 .00222 17 0 ]
[.81746 .00222 -17 -20 ]
[.81746 .00222 17 0 ]
[.97619 .00222 -17 -20 ]
[.97619 .00222 17 0 ]
[.01131 .16344 -14 -10 ]
[.01131 .16344 0 10 ]
[.01131 .31216 -24 -10 ]
[.01131 .31216 0 10 ]
[.01131 .46089 -24 -10 ]
[.01131 .46089 0 10 ]
[.01131 .60961 -24 -10 ]
[.01131 .60961 0 10 ]
[ -0.005 -0.005 0 0 ]
[ 1.005 .62303 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .01472 m
.18254 .02097 L
s
gsave
.18254 .00222 -73 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(50) show
1.000 setlinewidth
grestore
.34127 .01472 m
.34127 .02097 L
s
gsave
.34127 .00222 -78 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(100) show
1.000 setlinewidth
grestore
.5 .01472 m
.5 .02097 L
s
gsave
.5 .00222 -78 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(150) show
1.000 setlinewidth
grestore
.65873 .01472 m
.65873 .02097 L
s
gsave
.65873 .00222 -78 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(200) show
1.000 setlinewidth
grestore
.81746 .01472 m
.81746 .02097 L
s
gsave
.81746 .00222 -78 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(250) show
1.000 setlinewidth
grestore
.97619 .01472 m
.97619 .02097 L
s
gsave
.97619 .00222 -78 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(300) show
1.000 setlinewidth
grestore
.125 Mabswid
.05556 .01472 m
.05556 .01847 L
s
.0873 .01472 m
.0873 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.15079 .01472 m
.15079 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.24603 .01472 m
.24603 .01847 L
s
.27778 .01472 m
.27778 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.37302 .01472 m
.37302 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.43651 .01472 m
.43651 .01847 L
s
.46825 .01472 m
.46825 .01847 L
s
.53175 .01472 m
.53175 .01847 L
s
.56349 .01472 m
.56349 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.62698 .01472 m
.62698 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.72222 .01472 m
.72222 .01847 L
s
.75397 .01472 m
.75397 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.84921 .01472 m
.84921 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.9127 .01472 m
.9127 .01847 L
s
.94444 .01472 m
.94444 .01847 L
s
.01 w
0 .01472 m
1 .01472 L
s
.25 Mabswid
.02381 .16344 m
.03006 .16344 L
s
gsave
.01131 .16344 -75 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(5) show
1.000 setlinewidth
grestore
.02381 .31216 m
.03006 .31216 L
s
gsave
.01131 .31216 -85 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(10) show
1.000 setlinewidth
grestore
.02381 .46089 m
.03006 .46089 L
s
gsave
.01131 .46089 -85 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(15) show
1.000 setlinewidth
grestore
.02381 .60961 m
.03006 .60961 L
s
gsave
.01131 .60961 -85 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(20) show
1.000 setlinewidth
grestore
.125 Mabswid
.02381 .04446 m
.02756 .04446 L
s
.02381 .0742 m
.02756 .0742 L
s
.02381 .10395 m
.02756 .10395 L
s
.02381 .13369 m
.02756 .13369 L
s
.02381 .19318 m
.02756 .19318 L
s
.02381 .22293 m
.02756 .22293 L
s
.02381 .25267 m
.02756 .25267 L
s
.02381 .28242 m
.02756 .28242 L
s
.02381 .34191 m
.02756 .34191 L
s
.02381 .37165 m
.02756 .37165 L
s
.02381 .4014 m
.02756 .4014 L
s
.02381 .43114 m
.02756 .43114 L
s
.02381 .49063 m
.02756 .49063 L
s
.02381 .52038 m
.02756 .52038 L
s
.02381 .55012 m
.02756 .55012 L
s
.02381 .57987 m
.02756 .57987 L
s
.01 w
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02698 .04476 m
.03016 .04506 L
.03333 .04536 L
.03651 .04567 L
.03968 .04598 L
.04286 .04629 L
.04603 .04661 L
.04921 .04692 L
.05238 .04725 L
.05556 .04757 L
.05873 .0479 L
.0619 .04823 L
.06508 .04857 L
.06825 .04891 L
.07143 .04925 L
.0746 .04959 L
.07778 .04994 L
.08095 .05029 L
.08413 .05065 L
.0873 .05101 L
.09048 .05137 L
.09365 .05174 L
.09683 .05211 L
.1 .05248 L
.10317 .05286 L
.10635 .05324 L
.10952 .05363 L
.1127 .05402 L
.11587 .05441 L
.11905 .05481 L
.12222 .05521 L
.1254 .05561 L
.12857 .05602 L
.13175 .05643 L
.13492 .05685 L
.1381 .05727 L
.14127 .0577 L
.14444 .05813 L
.14762 .05856 L
.15079 .059 L
.15397 .05944 L
.15714 .05989 L
.16032 .06034 L
.16349 .0608 L
.16667 .06126 L
.16984 .06173 L
.17302 .0622 L
.17619 .06267 L
.17937 .06315 L
.18254 .06363 L
Mistroke
.18571 .06412 L
.18889 .06462 L
.19206 .06512 L
.19524 .06562 L
.19841 .06613 L
.20159 .06664 L
.20476 .06716 L
.20794 .06769 L
.21111 .06822 L
.21429 .06875 L
.21746 .06929 L
.22063 .06984 L
.22381 .07039 L
.22698 .07095 L
.23016 .07151 L
.23333 .07208 L
.23651 .07265 L
.23968 .07323 L
.24286 .07381 L
.24603 .07441 L
.24921 .075 L
.25238 .07561 L
.25556 .07621 L
.25873 .07683 L
.2619 .07745 L
.26508 .07808 L
.26825 .07871 L
.27143 .07935 L
.2746 .08 L
.27778 .08065 L
.28095 .08131 L
.28413 .08198 L
.2873 .08265 L
.29048 .08333 L
.29365 .08401 L
.29683 .08471 L
.3 .08541 L
.30317 .08611 L
.30635 .08683 L
.30952 .08755 L
.3127 .08828 L
.31587 .08901 L
.31905 .08976 L
.32222 .09051 L
.3254 .09126 L
.32857 .09203 L
.33175 .0928 L
.33492 .09358 L
.3381 .09437 L
.34127 .09517 L
Mistroke
.34444 .09597 L
.34762 .09679 L
.35079 .09761 L
.35397 .09844 L
.35714 .09927 L
.36032 .10012 L
.36349 .10097 L
.36667 .10184 L
.36984 .10271 L
.37302 .10359 L
.37619 .10448 L
.37937 .10537 L
.38254 .10628 L
.38571 .1072 L
.38889 .10812 L
.39206 .10905 L
.39524 .11 L
.39841 .11095 L
.40159 .11191 L
.40476 .11288 L
.40794 .11387 L
.41111 .11486 L
.41429 .11586 L
.41746 .11687 L
.42063 .11789 L
.42381 .11892 L
.42698 .11997 L
.43016 .12102 L
.43333 .12208 L
.43651 .12316 L
.43968 .12424 L
.44286 .12533 L
.44603 .12644 L
.44921 .12756 L
.45238 .12869 L
.45556 .12983 L
.45873 .13098 L
.4619 .13214 L
.46508 .13331 L
.46825 .1345 L
.47143 .1357 L
.4746 .13691 L
.47778 .13813 L
.48095 .13936 L
.48413 .14061 L
.4873 .14187 L
.49048 .14314 L
.49365 .14443 L
.49683 .14572 L
.5 .14703 L
Mistroke
.50317 .14836 L
.50635 .14969 L
.50952 .15104 L
.5127 .15241 L
.51587 .15378 L
.51905 .15517 L
.52222 .15658 L
.5254 .158 L
.52857 .15943 L
.53175 .16088 L
.53492 .16234 L
.5381 .16381 L
.54127 .1653 L
.54444 .16681 L
.54762 .16833 L
.55079 .16987 L
.55397 .17142 L
.55714 .17299 L
.56032 .17457 L
.56349 .17617 L
.56667 .17778 L
.56984 .17941 L
.57302 .18106 L
.57619 .18272 L
.57937 .1844 L
.58254 .1861 L
.58571 .18781 L
.58889 .18954 L
.59206 .19129 L
.59524 .19306 L
.59841 .19484 L
.60159 .19664 L
.60476 .19846 L
.60794 .2003 L
.61111 .20216 L
.61429 .20403 L
.61746 .20592 L
.62063 .20784 L
.62381 .20977 L
.62698 .21172 L
.63016 .21369 L
.63333 .21568 L
.63651 .21769 L
.63968 .21972 L
.64286 .22177 L
.64603 .22384 L
.64921 .22593 L
.65238 .22804 L
.65556 .23017 L
.65873 .23233 L
Mistroke
.6619 .2345 L
.66508 .2367 L
.66825 .23892 L
.67143 .24116 L
.6746 .24343 L
.67778 .24572 L
.68095 .24803 L
.68413 .25036 L
.6873 .25272 L
.69048 .2551 L
.69365 .2575 L
.69683 .25993 L
.7 .26238 L
.70317 .26486 L
.70635 .26736 L
.70952 .26988 L
.7127 .27244 L
.71587 .27501 L
.71905 .27762 L
.72222 .28024 L
.7254 .2829 L
.72857 .28558 L
.73175 .28829 L
.73492 .29103 L
.7381 .29379 L
.74127 .29658 L
.74444 .2994 L
.74762 .30225 L
.75079 .30512 L
.75397 .30803 L
.75714 .31096 L
.76032 .31392 L
.76349 .31691 L
.76667 .31993 L
.76984 .32299 L
.77302 .32607 L
.77619 .32918 L
.77937 .33233 L
.78254 .3355 L
.78571 .33871 L
.78889 .34195 L
.79206 .34522 L
.79524 .34853 L
.79841 .35187 L
.80159 .35524 L
.80476 .35864 L
.80794 .36208 L
.81111 .36556 L
.81429 .36907 L
.81746 .37261 L
Mistroke
.82063 .37619 L
.82381 .3798 L
.82698 .38345 L
.83016 .38714 L
.83333 .39087 L
.83651 .39463 L
.83968 .39843 L
.84286 .40226 L
.84603 .40614 L
.84921 .41005 L
.85238 .41401 L
.85556 .418 L
.85873 .42203 L
.8619 .4261 L
.86508 .43022 L
.86825 .43437 L
.87143 .43857 L
.8746 .44281 L
.87778 .44709 L
.88095 .45141 L
.88413 .45578 L
.8873 .46019 L
.89048 .46465 L
.89365 .46915 L
.89683 .47369 L
.9 .47828 L
.90317 .48292 L
.90635 .4876 L
.90952 .49233 L
.9127 .4971 L
.91587 .50193 L
.91905 .5068 L
.92222 .51172 L
.9254 .51669 L
.92857 .52171 L
.93175 .52678 L
.93492 .5319 L
.9381 .53707 L
.94127 .54229 L
.94444 .54757 L
.94762 .5529 L
.95079 .55828 L
.95397 .56372 L
.95714 .56921 L
.96032 .57475 L
.96349 .58035 L
.96667 .58601 L
.96984 .59172 L
.97302 .59749 L
.97619 .60332 L
Mistroke
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 355.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900001Hb000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00M?oonfX5o`00O`Gooo]Z1Ol007m3oook
JP?o001o1OoonfX5o`00O`Gooo]Z1Ol007lnoookJP?o001o1OoonfX5o`00O`Gooo]Z1Ol007ljoook
JPWo001o0ooonfX5o`00O`Gooo]Z1Ol007ljoookJPWo001o0ooonfX5o`00O`Gooo]Z1Ol007lloook
JPGo001o1OoonfX5o`00O`Gooo]Z1Ol007l?oookJP00LooonfX7o`00O`?ooo]Z1ol007m2oookJP?o
001o1?oonfX7o`00O`?ooo]Z1ol007lmoookJP?o001o1?oonfX7o`00O`?ooo]Z1ol007lioookJPWo
001o0_oonfX7o`00O`?ooo]Z1ol007lioookJPWo001o0_oonfX7o`00O`?ooo]Z1ol007ljoookJPOo
001o0ooonfX7o`00O`?ooo]Z1ol007l>oookJP00L_oonfX4o`00O`04oookJ_l007oo001oo`00O`?o
oo]Z0ol007l01?oonf[o001oo`00Ool007m2oookJP?o001o1?oonfX3o`00O`04oookJ_l007oo001o
o`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007lmoookJP?o001o0ooonfX4o`00O`04oookJ_l0
07oo001oo`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007lioookJPCo001o1ooonfX3o`00O`04
oookJ_l007oo001oo`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007lioookJPCo001o1_oonfX4
o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007lioookJP?o001o
0ooonfX3o`00O`;ooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o00Cooo]Zo`00Ool0
07oo001o3_oonfX007;ooo]Z0ol007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00
Od7ooo]Z0ol007l3oookJP?o001o0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007ll
oookJP?o001o0ooonfX3o`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o>Ooo
nfX4o`00O`Gooo]Z0ol007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00OcWooo]Z
1?l007l5oookJP?o001o0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007lhoookJP?o
001o0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007l3
oookJP?o001o3OoonfX007Sooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o@OoonfX3
o`00O`?ooo]Z0ol007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00Occooo]Z0ol0
07l9oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00Oc[ooo]Z1Ol007l3oookJP?o001o
0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007ljoookJPGo001o2OoonfX3o`00O`04
oookJ_l007oo001oo`00O`?ooo]Z0ol007lnoookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3
o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l=oookJP00N?oonfX3o`00O`04oookJ_l007oo
001oo`00O`?ooo]Z0ol007m1oookJP?o001o0ooonfX3o`00O`?ooo]Z0ol007l01?oonf[o001oo`00
Ool007l3oookJP?o001o??oonfX3o`00O`Wooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o
001o??oonfX4o`00O`;ooo]Z0ol007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00
Occooo]Z1?l007l8oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00Ockooo]Z0ol007l0
1?oonf[o001oo`00Ool007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00O`gooo]Z
001coookJP;o001o0_oonfX4o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007m1oookJP?o001o
0ooonfX3o`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o??oonfX3o`00O`Co
oo]Z0_l007l2oookJPCo001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00Ocgooo]Z0ol007l2oook
JP?o001o0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007lmoookJP?o001o0ooonfX2
o`00O`;ooo]Z1?l007l01?oonf[o001oo`00Ool007l3oookJP?o001o??oonfX4o`00O`;ooo]Z0ol0
07l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00O`gooo]Z001coookJPOo001o0_oo
nfX3o`00O`?ooo]Z0ol007m1oookJP?o001o0ooonfX3o`00O`?ooo]Z0ol007l01?oonf[o001oo`00
Ool007l3oookJP?o001o??oonfX3o`00O`Cooo]Z1ol007l2oookJP?o001o0ooonfX3o`00Ockooo]Z
0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00
Ockooo]Z0ol007l2oookJPOo001o0_oonfX3o`00O`?ooo]Z0ol007lloookJP?o001o0ooonfX3o`00
O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o3OoonfX007?ooo]Z1_l007l3oook
JP?o001o0ooonfX3o`00Od7ooo]Z0ol007l3oookJP?o001o0ooonfX3o`00O`04oookJ_l007oo001o
o`00O`?ooo]Z0ol007lloookJP?o001o1?oonfX6o`00O`?ooo]Z0ol007l3oookJP?o001o>?oonfX3
o`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o
0ooonfX3o`00OcSooo]Z0ol007l3oookJP?o001o0_oonfX6o`00O`?ooo]Z0ol007l3oookJP?o001o
?_oonfX2o`00O`;ooo]Z0ol007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00O`go
oo]Z001coookJP;o001o1ooonfX3o`00O`?ooo]Z0ol007lnoookJPKo001o0ooonfX3o`00O`?ooo]Z
0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o>OoonfX6o`00O`Cooo]Z0_l007l7oookJP?o
001o0ooonfX3o`00OcSooo]Z0ol007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00
O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007lhoookJP?o001o0ooonfX3o`00O`;ooo]Z0_l007l7
oookJP?o001o0ooonfX3o`00OcSooo]Z0ol007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooo
nfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l=oookJP009OoonfX5o`0004Wooo]Z0_l0
07l8oookJP?o001o00Cooo]Zo`00Ool007oo001o?ooonfX6o`00O`Cooo]Z0ol007l01?oonf[o001o
o`00Ool007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o>_oonfX6o`00O`Cooo]Z0_l007l8oook
JP?o001o00Cooo]Zo`00Ool007oo001o>OoonfX4o`00O`;ooo]Z0ol007l2oookJP?o001o00Cooo]Z
o`00Ool007oo001o0ooonfX3o`00O`04oookJ_l007oo001oo`00OcWooo]Z1?l007l2oookJP?o001o
0_oonfX2o`00O`Sooo]Z0ol007l01?oonf[o001oo`00Ool007lioookJP?o001o0ooonfX3o`00O`;o
oo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o3_oonfX0
02Gooo]Z1Ol0001:oookJPOo001o0_oonfX7o`00Od7ooo]Z1?l007l4oookJPOo001o0ooonfX7o`00
Occooo]Z1?l007l5oookJPOo001o0_oonfX7o`00Oc[ooo]Z1ol007l3oookJPOo001o0ooonfX7o`00
Oc[ooo]Z1ol007l4oookJPOo001o0_oonfX7o`00Oc[ooo]Z1ol007l3oookJPOo001o0ooonfX7o`00
O`kooo]Z000UoookJPGo0000B_oonfX7o`00O`?ooo]Z1Ol007m3oookJP?o001o1OoonfX5o`00O`Go
oo]Z1Ol007lnoookJP?o001o1OoonfX7o`00O`?ooo]Z1Ol007lloookJPGo001o1OoonfX5o`00O`Go
oo]Z1Ol007lloookJPGo001o1OoonfX7o`00O`?ooo]Z1Ol007lloookJPGo001o1OoonfX5o`00O`Go
oo]Z1Ol007l?oookJP009OoonfX5o`000?oooo]ZoooonfXHoookJP009OoonfX5o`000?oooo]Zoooo
nfXHoookJP009OoonfX5o`000?oooo]ZoooonfXHoookJP009OoonfX5o`000?oooo]ZoooonfXHoook
JP009OoonfX5o`000?oooo]ZoooonfXHoookJP006?oonf[oo`000?oo00007_l0000<oookJP006?oo
nf[oo`000?oo00007_l0000<oookJP006?oonf[oo`000?oo00007_l0000<oookJP006?oonf[oo`00
0?oo00007_l0000<oookJP006?oonf[oo`000?oo00007_l0000<oookJP009OoonfX5o`0005;ooo]Z
00?o0000oookJ_oonfX0D_oonfX00ol0003ooo]ZoookJP1BoookJP03o`000?oonf[ooo]Z05;ooo]Z
00?o0000oookJ_oonfX0D_oonfX00ol0003ooo]ZoookJP1BoookJP03o`000?oonf[ooo]Z01Sooo]Z
000UoookJPGo0000D_oonfX00ol0003ooo]ZoookJP1BoookJP03o`000?oonf[ooo]Z05;ooo]Z00?o
0000oookJ_oonfX0D_oonfX00ol0003ooo]ZoookJP1BoookJP03o`000?oonf[ooo]Z05;ooo]Z00?o
0000oookJ_oonfX06?oonfX002Gooo]Z1Ol0003ooookJ_oooo]Z6?oonfX002Gooo]Z1Ol0003ooook
J_oooo]Z6?oonfX002Gooo]Z1Ol0003ooookJ_oooo]Z6?oonfX002Gooo]Z1Ol0003ooookJ_oooo]Z
6?oonfX002Gooo]Z1Ol0003ooookJ_oooo]Z6?oonfX002Gooo]Z1Ol0003ooookJ_oooo]Z6?oonfX0
02Gooo]Z1Ol0003ooookJ_oooo]Z6?oonfX002Gooo]Z1Ol0003ooookJ_oooo]Z6?oonfX002Gooo]Z
1Ol0003ooookJ_oooo]Z6?oonfX002Gooo]Z1Ol0003ooookJ_oooo]Z6?oonfX002Gooo]Z1Ol0003o
oookJ_oooo]Z6?oonfX002Gooo]Z1ol0003ooookJ_oooo]Z5_oonfX002Gooo]Z1Ol00002oookJP[o
0000oooonf[ooookJPcooo]Z000UoookJPGo00003?oonfX9o`000?oooo]ZoooonfX3oookJP009Ooo
nfX5o`0001Gooo]Z2_l0003ooookJ_Sooo]Z000UoookJPGo00007ooonfX9o`000?oooo]ZkooonfX0
02Gooo]Z1Ol0000XoookJPSo0000oooonf[WoookJP009OoonfX5o`00033ooo]Z1ol0003ooookJ^3o
oo]Z000UoookJPGo0000=ooonfX8o`000?oooo]Zf?oonfX002Gooo]Z1Ol0000ooookJPOo0000oooo
nf[AoookJP009OoonfX5o`0004Kooo]Z1ol0003ooookJ/[ooo]Z000UoookJPGo0000COoonfX7o`00
0?oooo]Z`ooonfX002Gooo]Z1Ol0001DoookJPOo0000oooonfZloookJP009OoonfX5o`0005_ooo]Z
1Ol0003ooookJ[Oooo]Z000UoookJPGo0000H?oonfX6o`000?oooo]Z/OoonfX002Gooo]Z1Ol0001V
oookJPGo0000oooonfZ/oookJP009OoonfX5o`0006_ooo]Z1_l0003ooookJZKooo]Z000UoookJPGo
0000LOoonfX6o`000?oooo]ZX?oonfX002Gooo]Z1Ol0001goookJPGo0000oooonfZKoookJP009Ooo
nfX5o`0007cooo]Z1_l0003ooookJYGooo]Z000UoookJPGo0000P_oonfX3o`000?oooo]ZT_oonfX0
02Gooo]Z1Ol00025oookJPGo0000oooonfZ=oookJP009OoonfX5o`0008[ooo]Z1Ol0003ooookJXSo
oo]Z000UoookJPGo0000SooonfX5o`000?oooo]ZPooonfX002Gooo]Z1Ol0002DoookJPCo0000oooo
nfYooookJP009OoonfX5o`0009Sooo]Z1Ol0003ooookJW[ooo]Z000UoookJPGo0000WOoonfX3o`00
0?oooo]ZMooonfX002Gooo]Z1Ol0002PoookJPGo0000oooonfYboookJP009OoonfX5o`000:Gooo]Z
1?l0003ooookJVkooo]Z000UoookJPGo0000ZOoonfX3o`000?oooo]ZJooonfX002Gooo]Z1Ol0002/
oookJPGo0000oooonfYVoookJP009OoonfX5o`000;7ooo]Z1?l0003ooookJV;ooo]Z000UoookJPGo
0000]OoonfX3o`000?oooo]ZGooonfX002Gooo]Z1Ol0002hoookJP?o0000oooonfYLoookJP009Ooo
nfX5o`000;_ooo]Z1?l0003ooookJUSooo]Z000UoookJPGo0000_ooonfX3o`000?oooo]ZEOoonfX0
02Gooo]Z1Ol00032oookJP?o0000oooonfYBoookJP009OoonfX5o`000<Gooo]Z1?l0003ooookJTko
oo]Z000UoookJPGo0000bOoonfX3o`000?oooo]ZBooonfX002Gooo]Z1Ol0003<oookJPCo0000oooo
nfY7oookJP009OoonfX5o`000=3ooo]Z0ol0003ooookJTCooo]Z000UoookJPGo0000dooonfX2o`00
0?oooo]Z@_oonfX002Gooo]Z1Ol0003EoookJP?o0000oooonfXooookJP009OoonfX5o`000=Sooo]Z
1?l0003ooookJS_ooo]Z000UoookJPGo0000g?oonfX3o`000?oooo]Z>?oonfX002Gooo]Z1Ol0003O
oookJP;o0000oooonfXfoookJP009OoonfX5o`000>7ooo]Z0ol0003ooookJS?ooo]Z000UoookJPGo
0000i?oonfX3o`000?oooo]Z<?oonfX002Gooo]Z1Ol0003WoookJP;o0000oooonfX^oookJP009Ooo
nfX5o`000>Wooo]Z1?l0003ooookJR[ooo]Z000UoookJPGo0000kOoonfX00ol0003ooo]ZoookJP3o
oookJROooo]Z000UoookJPGo0000k_oonfX4o`000?oooo]Z9OoonfX002Gooo]Z1Ol0003boookJP03
o`000?oonf[ooo]Z0?oooo]Z8_oonfX002Gooo]Z1Ol0003coookJPCo0000oooonfXPoookJP009Ooo
nfX5o`000?Oooo]Z00?o0000oookJ_oonfX0oooonfXMoookJP009OoonfX5o`000?Sooo]Z1?l0003o
oookJQ_ooo]Z000UoookJPGo0000o?oonfX2o`000?oooo]Z6OoonfX002Gooo]Z1Ol0003noookJP?o
0000oooonfXFoookJP009OoonfX5o`000?oooo]Z0_oonfX2o`000?oooo]Z5?oonfX002Gooo]Z1Ol0
003ooookJPCooo]Z00?o0000oookJ_oonfX0oooonfXAoookJP009OoonfX5o`000?oooo]Z1OoonfX4
o`000?oooo]Z3ooonfX001Kooo]Z1Ol007l:oookJPGo0000oooonfX9oookJP03o`000?oonf[ooo]Z
0?oooo]Z3?oonfX001Gooo]Z1ol007l9oookJPGo0000oooonfX:oookJP;o0000oooonfX<oookJP00
5?oonfX4o`00O`04oookJ_l007oo001oo`00O`Wooo]Z1Ol0003ooookJPcooo]Z1?l0003ooookJPSo
oo]Z000DoookJP?o001o0ooonfX3o`00O`Sooo]Z1Ol0003ooookJQ3ooo]Z00?o0000oookJ_oonfX0
oooonfX5oookJP006_oonfX3o`00O`Sooo]Z1_l0003ooookJQ3ooo]Z0_l0003ooookJPGooo]Z000J
oookJP?o001o2?oonfX5o`000?oooo]Z4ooonfX2o`000?oooo]Z0ooonfX001Gooo]Z0_l007l2oook
JPCo001o2?oonfX5o`000?oooo]Z5OoonfX3o`000?oooo]Z000EoookJPOo001o2OoonfX5o`000?oo
oo]Z6?oonfX2o`000?gooo]Z000EoookJPKo001o2_oonfX5o`000?oooo]Z6_oonfX00ol0003ooo]Z
oookJP3joookJP005OoonfX2o`00O`kooo]Z1Ol0003ooookJQ_ooo]Z0_l0003joookJP005OoonfX2
o`00O`kooo]Z1Ol0003ooookJQgooo]Z0_l0003hoookJP005_oonfX7o`00O`Sooo]Z1Ol0003ooook
JQoooo]Z0ol0003eoookJP005_oonfX7o`00O`Sooo]Z1Ol0003ooookJR;ooo]Z0_l0003coookJP00
9OoonfX5o`000?oooo]Z9?oonfX2o`000?7ooo]Z000UoookJPGo0000oooonfXVoookJP03o`000?oo
nf[ooo]Z0>kooo]Z000UoookJPGo0000oooonfXWoookJP;o0000k_oonfX002Gooo]Z1Ol0003ooook
JRWooo]Z0_l0003/oookJP009OoonfX5o`000?oooo]Z:ooonfX00ol0003ooo]ZoookJP3YoookJP00
9OoonfX5o`000?oooo]Z;?oonfX2o`000>Wooo]Z000UoookJPGo0000oooonfX^oookJP;o0000iooo
nfX002Gooo]Z1Ol0003ooookJS3ooo]Z00?o0000oookJ_oonfX0i?oonfX002Gooo]Z1Ol0003ooook
JS7ooo]Z0_l0003ToookJP009OoonfX5o`000?oooo]Z<ooonfX2o`000>;ooo]Z000UoookJPGo0000
oooonfXeoookJP;o0000h?oonfX002Gooo]Z1Ol0003ooookJSOooo]Z00?o0000oookJ_oonfX0gOoo
nfX002Gooo]Z1Ol0003ooookJSSooo]Z0_l0003MoookJP009OoonfX5o`000?oooo]Z>_oonfX2o`00
0=_ooo]Z000UoookJPGo0000oooonfXloookJP03o`000?oonf[ooo]Z0=Sooo]Z000UoookJPGo0000
oooonfXmoookJP;o0000f?oonfX002Gooo]Z1Ol0003ooookJSoooo]Z0_l0003FoookJP009OoonfX5
o`000?oooo]Z@OoonfX00ol0003ooo]ZoookJP3CoookJP009OoonfX5o`000?oooo]Z@_oonfX2o`00
0=?ooo]Z000UoookJPGo0000oooonfY4oookJP;o0000dOoonfX002Gooo]Z1Ol0003ooookJTKooo]Z
0_l0003?oookJP009OoonfX5o`000?oooo]ZB?oonfX00ol0003ooo]ZoookJP3<oookJP009OoonfX5
o`000?oooo]ZBOoonfX2o`000<cooo]Z000UoookJPGo0000oooonfY;oookJP;o0000b_oonfX002Go
oo]Z1Ol0003ooookJTgooo]Z00?o0000oookJ_oonfX0aooonfX002Gooo]Z1Ol0003ooookJTkooo]Z
00?o0000oookJ_oonfX0a_oonfX002Gooo]Z1Ol0003ooookJToooo]Z00?o0000oookJ_oonfX0aOoo
nfX002Gooo]Z1Ol0003ooookJU3ooo]Z0_l00035oookJP009OoonfX5o`000?oooo]ZD_oonfX00ol0
003ooo]ZoookJP32oookJP009OoonfX5o`000?oooo]ZDooonfX2o`000<;ooo]Z000UoookJPGo0000
oooonfYEoookJP;o0000`?oonfX002Gooo]Z1Ol0003ooookJUOooo]Z0_l0002noookJP009OoonfX5
o`000?oooo]ZFOoonfX00ol0003ooo]ZoookJP2koookJP009OoonfX5o`000?oooo]ZFOoonfX00ol0
003ooo]ZoookJP2koookJP009OoonfX5o`000?oooo]ZF_oonfX2o`000;_ooo]Z000UoookJPGo0000
oooonfYLoookJP;o0000^OoonfX002Gooo]Z1Ol0003ooookJUkooo]Z00?o0000oookJ_oonfX0]_oo
nfX002Gooo]Z1Ol0003ooookJUoooo]Z00?o0000oookJ_oonfX0]OoonfX002Gooo]Z1Ol0003ooook
JV3ooo]Z00?o0000oookJ_oonfX0]?oonfX002Gooo]Z1Ol0003ooookJV7ooo]Z0_l0002doookJP00
9OoonfX5o`000?oooo]ZHooonfX00ol0003ooo]ZoookJP2aoookJP009OoonfX5o`000?oooo]ZI?oo
nfX2o`000;7ooo]Z000UoookJPGo0000oooonfYVoookJP03o`000?oonf[ooo]Z0:kooo]Z000Uoook
JPGo0000oooonfYWoookJP03o`000?oonf[ooo]Z0:gooo]Z000UoookJPGo0000oooonfYXoookJP;o
0000[OoonfX002Gooo]Z1Ol0003ooookJV[ooo]Z00?o0000oookJ_oonfX0Z_oonfX002Gooo]Z1Ol0
003ooookJV_ooo]Z00?o0000oookJ_oonfX0ZOoonfX002Gooo]Z1Ol0003ooookJVcooo]Z00?o0000
oookJ_oonfX0Z?oonfX002Gooo]Z1Ol0003ooookJVgooo]Z0_l0002XoookJP009OoonfX5o`000?oo
oo]ZKooonfX00ol0003ooo]ZoookJP2UoookJP009OoonfX5o`000?oooo]ZL?oonfX00ol0003ooo]Z
oookJP2ToookJP009OoonfX5o`000?oooo]ZLOoonfX00ol0003ooo]ZoookJP2SoookJP009OoonfX5
o`000?oooo]ZL_oonfX2o`000:?ooo]Z000UoookJPGo0000oooonfYdoookJP03o`000?oonf[ooo]Z
0:3ooo]Z000UoookJPGo0000oooonfYdoookJP03o`000?oonf[ooo]Z0:3ooo]Z000UoookJPGo0000
oooonfYeoookJP;o0000X?oonfX002Gooo]Z1Ol0003ooookJWOooo]Z00?o0000oookJ_oonfX0WOoo
nfX002Gooo]Z1Ol0003ooookJWSooo]Z00?o0000oookJ_oonfX0W?oonfX002Gooo]Z1Ol0003ooook
JWWooo]Z0_l0002LoookJP009OoonfX5o`000?oooo]ZNooonfX00ol0003ooo]ZoookJP2IoookJP00
9OoonfX5o`000?oooo]ZNooonfX00ol0003ooo]ZoookJP2IoookJP009OoonfX5o`000?oooo]ZO?oo
nfX2o`0009Wooo]Z000UoookJPGo0000oooonfYnoookJP03o`000?oonf[ooo]Z09Kooo]Z000Uoook
JPGo0000oooonfYooookJP03o`000?oonf[ooo]Z09Gooo]Z000UoookJPGo0000oooonfZ0oookJP03
o`000?oonf[ooo]Z09Cooo]Z000UoookJPGo0000oooonfZ1oookJP03o`000?oonf[ooo]Z09?ooo]Z
000>oookJP?o001o1OoonfX5o`00O`[ooo]Z1Ol0003ooookJX;ooo]Z00?o0000oookJ_oonfX0T_oo
nfX000kooo]Z0ol007l4oookJPOo001o2OoonfX5o`000?oooo]ZPooonfX2o`0009;ooo]Z000>oook
JP?o001o1?oonfX3o`00O`04oookJ_l007oo001oo`00O`Wooo]Z1Ol0003ooookJXGooo]Z00?o0000
oookJ_oonfX0SooonfX000kooo]Z0ol007l3oookJP?o001o0ooonfX3o`00O`Sooo]Z1Ol0003ooook
JXGooo]Z00?o0000oookJ_oonfX0SooonfX000kooo]Z0ol007l3oookJP?o001o0ooonfX3o`00O`So
oo]Z1_l0003ooookJXGooo]Z0_l0002?oookJP003_oonfX3o`00O`?ooo]Z0ol007l3oookJP?o001o
2?oonfX5o`000?oooo]ZR?oonfX00ol0003ooo]ZoookJP2<oookJP003_oonfX3o`00O`?ooo]Z0ol0
07l3oookJP?o001o2?oonfX5o`000?oooo]ZROoonfX00ol0003ooo]ZoookJP2;oookJP003_oonfX3
o`00O`?ooo]Z0ol007l3oookJP?o001o2?oonfX5o`000?oooo]ZR_oonfX00ol0003ooo]ZoookJP2:
oookJP003_oonfX3o`00O`?ooo]Z0ol007l3oookJP?o001o2?oonfX5o`000?oooo]ZRooonfX00ol0
003ooo]ZoookJP29oookJP002ooonfX6o`00O`?ooo]Z0ol007l3oookJP?o001o2?oonfX5o`000?oo
oo]ZS?oonfX00ol0003ooo]ZoookJP28oookJP002ooonfX6o`00O`Cooo]Z0ol007l01?oonf[o001o
o`00Ool007l9oookJPGo0000oooonfZ=oookJP03o`000?oonf[ooo]Z08Oooo]Z000=oookJPCo001o
1?oonfX7o`00O`Wooo]Z1Ol0003ooookJXkooo]Z00?o0000oookJ_oonfX0Q_oonfX000kooo]Z0ol0
07l5oookJPGo001o2_oonfX5o`000?oooo]ZSooonfX2o`0008Kooo]Z000UoookJPGo0000oooonfZA
oookJP03o`000?oonf[ooo]Z08?ooo]Z000UoookJPGo0000oooonfZAoookJP03o`000?oonf[ooo]Z
08?ooo]Z000UoookJPGo0000oooonfZBoookJP03o`000?oonf[ooo]Z08;ooo]Z000UoookJPGo0000
oooonfZCoookJP03o`000?oonf[ooo]Z087ooo]Z000UoookJPGo0000oooonfZDoookJP03o`000?oo
nf[ooo]Z083ooo]Z000UoookJPGo0000oooonfZEoookJP03o`000?oonf[ooo]Z07oooo]Z000Uoook
JPGo0000oooonfZFoookJP03o`000?oonf[ooo]Z07kooo]Z000UoookJPGo0000oooonfZGoookJP03
o`000?oonf[ooo]Z07gooo]Z000UoookJPGo0000oooonfZHoookJP03o`000?oonf[ooo]Z07cooo]Z
000UoookJPGo0000oooonfZIoookJP03o`000?oonf[ooo]Z07_ooo]Z000UoookJPGo0000oooonfZJ
oookJP03o`000?oonf[ooo]Z07[ooo]Z000UoookJPGo0000oooonfZKoookJP03o`000?oonf[ooo]Z
07Wooo]Z000UoookJPGo0000oooonfZKoookJP03o`000?oonf[ooo]Z07Wooo]Z000UoookJPGo0000
oooonfZLoookJP;o0000NOoonfX002Gooo]Z1Ol0003ooookJYkooo]Z00?o0000oookJ_oonfX0M_oo
nfX002Gooo]Z1Ol0003ooookJYoooo]Z00?o0000oookJ_oonfX0MOoonfX002Gooo]Z1Ol0003ooook
JZ3ooo]Z00?o0000oookJ_oonfX0M?oonfX002Gooo]Z1Ol0003ooookJZ7ooo]Z00?o0000oookJ_oo
nfX0LooonfX002Gooo]Z1Ol0003ooookJZ;ooo]Z00?o0000oookJ_oonfX0L_oonfX002Gooo]Z1Ol0
003ooookJZ;ooo]Z00?o0000oookJ_oonfX0L_oonfX002Gooo]Z1Ol0003ooookJZ?ooo]Z00?o0000
oookJ_oonfX0LOoonfX002Gooo]Z1Ol0003ooookJZCooo]Z00?o0000oookJ_oonfX0L?oonfX002Go
oo]Z1Ol0003ooookJZGooo]Z00?o0000oookJ_oonfX0KooonfX002Gooo]Z1Ol0003ooookJZKooo]Z
00?o0000oookJ_oonfX0K_oonfX002Gooo]Z1Ol0003ooookJZOooo]Z00?o0000oookJ_oonfX0KOoo
nfX002Gooo]Z1Ol0003ooookJZOooo]Z00?o0000oookJ_oonfX0KOoonfX002Gooo]Z1Ol0003ooook
JZSooo]Z00?o0000oookJ_oonfX0K?oonfX002Gooo]Z1Ol0003ooookJZWooo]Z00?o0000oookJ_oo
nfX0JooonfX002Gooo]Z1Ol0003ooookJZ[ooo]Z00?o0000oookJ_oonfX0J_oonfX002Gooo]Z1Ol0
003ooookJZ_ooo]Z00?o0000oookJ_oonfX0JOoonfX002Gooo]Z1Ol0003ooookJZcooo]Z00?o0000
oookJ_oonfX0J?oonfX002Gooo]Z1Ol0003ooookJZgooo]Z00?o0000oookJ_oonfX0IooonfX002Go
oo]Z1Ol0003ooookJZkooo]Z00?o0000oookJ_oonfX0I_oonfX002Gooo]Z1Ol0003ooookJZoooo]Z
00?o0000oookJ_oonfX0IOoonfX002Gooo]Z1Ol0003ooookJ[3ooo]Z00?o0000oookJ_oonfX0I?oo
nfX002Gooo]Z1Ol0003ooookJ[7ooo]Z00?o0000oookJ_oonfX0HooonfX002Gooo]Z1Ol0003ooook
J[7ooo]Z00?o0000oookJ_oonfX0HooonfX002Gooo]Z1Ol0003ooookJ[;ooo]Z00?o0000oookJ_oo
nfX0H_oonfX002Gooo]Z1Ol0003ooookJ[?ooo]Z00?o0000oookJ_oonfX0HOoonfX002Gooo]Z1Ol0
003ooookJ[?ooo]Z00?o0000oookJ_oonfX0HOoonfX002Gooo]Z1Ol0003ooookJ[Cooo]Z00?o0000
oookJ_oonfX0H?oonfX002Gooo]Z1Ol0003ooookJ[Gooo]Z00?o0000oookJ_oonfX0GooonfX002Go
oo]Z1Ol0003ooookJ[Kooo]Z00?o0000oookJ_oonfX0G_oonfX002Gooo]Z1Ol0003ooookJ[Oooo]Z
00?o0000oookJ_oonfX0GOoonfX002Gooo]Z1Ol0003ooookJ[Sooo]Z00?o0000oookJ_oonfX0G?oo
nfX002Gooo]Z1Ol0003ooookJ[Sooo]Z00?o0000oookJ_oonfX0G?oonfX002Gooo]Z1Ol0003ooook
J[Wooo]Z00?o0000oookJ_oonfX0FooonfX002Gooo]Z1Ol0003ooookJ[[ooo]Z00?o0000oookJ_oo
nfX0F_oonfX002Gooo]Z1Ol0003ooookJ[_ooo]Z00?o0000oookJ_oonfX0FOoonfX002Gooo]Z1Ol0
003ooookJ[cooo]Z00?o0000oookJ_oonfX0F?oonfX002Gooo]Z1Ol0003ooookJ[gooo]Z00?o0000
oookJ_oonfX0EooonfX002Gooo]Z1Ol0003ooookJ[gooo]Z00?o0000oookJ_oonfX0EooonfX002Go
oo]Z1Ol0003ooookJ[kooo]Z00?o0000oookJ_oonfX0E_oonfX002Gooo]Z1Ol0003ooookJ[kooo]Z
00?o0000oookJ_oonfX0E_oonfX002Gooo]Z1Ol0003ooookJ[oooo]Z00?o0000oookJ_oonfX0EOoo
nfX002Gooo]Z1Ol0003ooookJ/3ooo]Z00?o0000oookJ_oonfX0E?oonfX002Gooo]Z1Ol0003ooook
J/7ooo]Z00?o0000oookJ_oonfX0DooonfX002Gooo]Z1Ol0003ooookJ/;ooo]Z00?o0000oookJ_oo
nfX0D_oonfX002Gooo]Z1Ol0003ooookJ/?ooo]Z00?o0000oookJ_oonfX0DOoonfX002Gooo]Z1Ol0
003ooookJ/Cooo]Z00?o0000oookJ_oonfX0D?oonfX002Gooo]Z1Ol0003ooookJ/Cooo]Z00?o0000
oookJ_oonfX0D?oonfX002Gooo]Z1Ol0003ooookJ/Gooo]Z00?o0000oookJ_oonfX0CooonfX002Go
oo]Z1Ol0003ooookJ/Gooo]Z00?o0000oookJ_oonfX0CooonfX002Gooo]Z1Ol0003ooookJ/Kooo]Z
00?o0000oookJ_oonfX0C_oonfX002Gooo]Z1Ol0003ooookJ/Oooo]Z00?o0000oookJ_oonfX0COoo
nfX002Gooo]Z1Ol0003ooookJ/Sooo]Z00?o0000oookJ_oonfX0C?oonfX002Gooo]Z1Ol0003ooook
J/Wooo]Z00?o0000oookJ_oonfX0BooonfX000kooo]Z0ol007l5oookJPGo001o2_oonfX5o`000?oo
oo]ZbOoonfX00ol0003ooo]ZoookJP1;oookJP003_oonfX3o`00O`Cooo]Z1ol007l9oookJPGo0000
oooonf[:oookJP03o`000?oonf[ooo]Z04[ooo]Z000>oookJP?o001o0ooonfX4o`00O`04oookJ_l0
07oo001oo`00O`Wooo]Z1Ol0003ooookJ/[ooo]Z00?o0000oookJ_oonfX0B_oonfX000kooo]Z0ol0
07l3oookJP?o001o0ooonfX3o`00O`Sooo]Z1Ol0003ooookJ/_ooo]Z00?o0000oookJ_oonfX0BOoo
nfX000kooo]Z0ol007l9oookJP?o001o2?oonfX6o`000?oooo]ZbooonfX00ol0003ooo]ZoookJP18
oookJP003_oonfX3o`00O`Wooo]Z0ol007l8oookJPGo0000oooonf[=oookJP03o`000?oonf[ooo]Z
04Oooo]Z000>oookJP?o001o1?oonfX2o`00O`;ooo]Z1?l007l8oookJPGo0000oooonf[>oookJP03
o`000?oonf[ooo]Z04Kooo]Z000>oookJP?o001o1?oonfX7o`00O`Wooo]Z1Ol0003ooookJ/kooo]Z
00?o0000oookJ_oonfX0A_oonfX000kooo]Z0ol007l4oookJPKo001o2_oonfX5o`000?oooo]Zcooo
nfX00ol0003ooo]ZoookJP15oookJP002ooonfX6o`00O`Cooo]Z0_l007l>oookJPGo0000oooonf[?
oookJP03o`000?oonf[ooo]Z04Gooo]Z000;oookJPKo001o1?oonfX2o`00O`kooo]Z1Ol0003ooook
J]3ooo]Z00?o0000oookJ_oonfX0A?oonfX000gooo]Z1?l007l5oookJPOo001o2?oonfX5o`000?oo
oo]ZdOoonfX00ol0003ooo]ZoookJP13oookJP003_oonfX3o`00O`Gooo]Z1ol007l8oookJPGo0000
oooonf[BoookJP03o`000?oonf[ooo]Z04;ooo]Z000UoookJPGo0000oooonf[CoookJP03o`000?oo
nf[ooo]Z047ooo]Z000UoookJPGo0000oooonf[CoookJP03o`000?oonf[ooo]Z047ooo]Z000Uoook
JPGo0000oooonf[DoookJP03o`000?oonf[ooo]Z043ooo]Z000UoookJPGo0000oooonf[EoookJP03
o`000?oonf[ooo]Z03oooo]Z000UoookJPGo0000oooonf[EoookJP03o`000?oonf[ooo]Z03oooo]Z
000UoookJPGo0000oooonf[FoookJP03o`000?oonf[ooo]Z03kooo]Z000UoookJPGo0000oooonf[F
oookJP03o`000?oonf[ooo]Z03kooo]Z000UoookJPGo0000oooonf[GoookJP03o`000?oonf[ooo]Z
03gooo]Z000UoookJPGo0000oooonf[HoookJP03o`000?oonf[ooo]Z03cooo]Z000UoookJPGo0000
oooonf[IoookJP03o`000?oonf[ooo]Z03_ooo]Z000UoookJPGo0000oooonf[JoookJP03o`000?oo
nf[ooo]Z03[ooo]Z000UoookJPGo0000oooonf[JoookJP03o`000?oonf[ooo]Z03[ooo]Z000Uoook
JPGo0000oooonf[KoookJP03o`000?oonf[ooo]Z03Wooo]Z000UoookJPGo0000oooonf[KoookJP03
o`000?oonf[ooo]Z03Wooo]Z000UoookJPGo0000oooonf[LoookJP03o`000?oonf[ooo]Z03Sooo]Z
000UoookJPGo0000oooonf[MoookJP03o`000?oonf[ooo]Z03Oooo]Z000UoookJPGo0000oooonf[M
oookJP03o`000?oonf[ooo]Z03Oooo]Z000UoookJPGo0000oooonf[NoookJP03o`000?oonf[ooo]Z
03Kooo]Z000UoookJPGo0000oooonf[OoookJP03o`000?oonf[ooo]Z03Gooo]Z000UoookJPGo0000
oooonf[OoookJP03o`000?oonf[ooo]Z03Gooo]Z000UoookJPGo0000oooonf[PoookJP03o`000?oo
nf[ooo]Z03Cooo]Z000UoookJPGo0000oooonf[PoookJP03o`000?oonf[ooo]Z03Cooo]Z000Uoook
JPGo0000oooonf[QoookJP03o`000?oonf[ooo]Z03?ooo]Z000UoookJPGo0000oooonf[RoookJP03
o`000?oonf[ooo]Z03;ooo]Z000UoookJPGo0000oooonf[RoookJP03o`000?oonf[ooo]Z03;ooo]Z
000UoookJPGo0000oooonf[SoookJP03o`000?oonf[ooo]Z037ooo]Z000UoookJPGo0000oooonf[T
oookJP03o`000?oonf[ooo]Z033ooo]Z000UoookJPGo0000oooonf[ToookJP03o`000?oonf[ooo]Z
033ooo]Z000UoookJPGo0000oooonf[UoookJP03o`000?oonf[ooo]Z02oooo]Z000UoookJPGo0000
oooonf[VoookJP03o`000?oonf[ooo]Z02kooo]Z000UoookJPGo0000oooonf[VoookJP03o`000?oo
nf[ooo]Z02kooo]Z000UoookJPGo0000oooonf[WoookJP03o`000?oonf[ooo]Z02gooo]Z000Uoook
JPGo0000oooonf[WoookJP03o`000?oonf[ooo]Z02gooo]Z000UoookJPGo0000oooonf[XoookJP03
o`000?oonf[ooo]Z02cooo]Z000UoookJPGo0000oooonf[YoookJP03o`000?oonf[ooo]Z02_ooo]Z
000UoookJPGo0000oooonf[YoookJP03o`000?oonf[ooo]Z02_ooo]Z000UoookJPGo0000oooonf[Z
oookJP03o`000?oonf[ooo]Z02[ooo]Z000UoookJPGo0000oooonf[[oookJP03o`000?oonf[ooo]Z
02Wooo]Z000UoookJPGo0000oooonf[[oookJP03o`000?oonf[ooo]Z02Wooo]Z000UoookJPGo0000
oooonf[/oookJP03o`000?oonf[ooo]Z02Sooo]Z000UoookJPGo0000oooonf[/oookJP03o`000?oo
nf[ooo]Z02Sooo]Z000UoookJPGo0000oooonf[/oookJP03o`000?oonf[ooo]Z02Sooo]Z000Uoook
JPGo0000oooonf[]oookJP03o`000?oonf[ooo]Z02Oooo]Z000UoookJPGo0000oooonf[^oookJP03
o`000?oonf[ooo]Z02Kooo]Z000UoookJPGo0000oooonf[^oookJP03o`000?oonf[ooo]Z02Kooo]Z
000UoookJPGo0000oooonf[_oookJP03o`000?oonf[ooo]Z02Gooo]Z000UoookJPGo0000oooonf[`
oookJP03o`000?oonf[ooo]Z02Cooo]Z000UoookJPGo0000oooonf[`oookJP03o`000?oonf[ooo]Z
02Cooo]Z000UoookJPGo0000oooonf[aoookJP03o`000?oonf[ooo]Z02?ooo]Z000UoookJPGo0000
oooonf[aoookJP03o`000?oonf[ooo]Z02?ooo]Z000UoookJPGo0000oooonf[aoookJP03o`000?oo
nf[ooo]Z02?ooo]Z000UoookJPGo0000oooonf[boookJP03o`000?oonf[ooo]Z02;ooo]Z000Uoook
JPGo0000oooonf[coookJP03o`000?oonf[ooo]Z027ooo]Z000UoookJPGo0000oooonf[coookJP03
o`000?oonf[ooo]Z027ooo]Z000UoookJPGo0000oooonf[doookJP03o`000?oonf[ooo]Z023ooo]Z
000UoookJPGo0000oooonf[eoookJP03o`000?oonf[ooo]Z01oooo]Z000UoookJPGo0000oooonf[e
oookJP03o`000?oonf[ooo]Z01oooo]Z000UoookJPGo0000oooonf[foookJP03o`000?oonf[ooo]Z
01kooo]Z000UoookJPGo0000oooonf[foookJP03o`000?oonf[ooo]Z01kooo]Z000UoookJPGo0000
oooonf[foookJP03o`000?oonf[ooo]Z01kooo]Z000UoookJPGo0000oooonf[goookJP03o`000?oo
nf[ooo]Z01gooo]Z000UoookJPGo0000oooonf[hoookJP03o`000?oonf[ooo]Z01cooo]Z000Uoook
JPGo0000oooonf[hoookJP03o`000?oonf[ooo]Z01cooo]Z000UoookJPGo0000oooonf[ioookJP03
o`000?oonf[ooo]Z01_ooo]Z000UoookJPGo0000oooonf[joookJP03o`000?oonf[ooo]Z01[ooo]Z
000UoookJPGo0000oooonf[joookJP03o`000?oonf[ooo]Z01[ooo]Z000:oookJPWo001o0ooonfX5
o`00O`[ooo]Z1Ol0003ooookJ__ooo]Z00?o0000oookJ_oonfX06OoonfX000[ooo]Z2Ol007l2oook
JPOo001o2OoonfX5o`000?oooo]Zo?oonfX00ol0003ooo]ZoookJP0HoookJP002_oonfX4o`00O`Oo
oo]Z0ol007l01?oonf[o001oo`00Ool007l9oookJPGo0000oooonf[ooookJQSooo]Z000;oookJPCo
001o1OoonfX3o`00O`?ooo]Z0ol007l8oookJPGo0000oooonf[ooookJQSooo]Z000<oookJPGo001o
0ooonfX3o`00O`?ooo]Z0ol007l8oookJPKo0000oooonf[ooookJQOooo]Z000>oookJPCo001o0_oo
nfX3o`00O`?ooo]Z0ol007l8oookJPGo0000oooonf[ooookJQSooo]Z000?oookJP?o001o0_oonfX3
o`00O`?ooo]Z0ol007l8oookJPGo0000oooonf[ooookJQSooo]Z000@oookJP?o001o00Cooo]Zo`00
Ool007oo001o0ooonfX3o`00O`Sooo]Z1Ol0003ooookJ_oooo]Z6?oonfX000[ooo]Z0ol007l3oook
JP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00O`Sooo]Z1Ol0003ooookJ_oooo]Z6?oonfX0
00[ooo]Z0ol007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00O`Sooo]Z1Ol0003o
oookJ_oooo]Z6?oonfX000[ooo]Z1?l007l2oookJP?o001o0_oonfX3o`00O`04oookJ_l007oo001o
o`00O`Wooo]Z1Ol0003ooookJ_oooo]Z6?oonfX000_ooo]Z1ol007l3oookJPOo001o2OoonfX5o`00
0?oooo]ZoooonfXHoookJP003?oonfX5o`00O`Gooo]Z1Ol007oooookJ_oooo]Z9ooonfX00?oooo]Z
oooonfY2oookJP00oooonf[ooookJT;ooo]Z0000\
\>"],
  ImageRangeCache->{{{0, 575}, {354.938, 0}} -> {-23.3154, -1.67705, \
0.588821, 0.0628436}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(<< Graphics`MultipleListPlot`\)], "Input",
  CellTags->"mmtag:19:Graphics_Package__MultipleListPlot[]"],

Cell[BoxData[
    \(Trajectory[alpha_, \ F0_]\  := \ 
      Table[GrowsPropToSize[i, alpha, F0], {i, 300}]\)], "Input"],

Cell["\<\
Plotting a bunch of curves for the same \[Alpha] value, but each \
corresponding to a different initial value, demonstrates that a point in \
space \"belongs\" to a curve.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MultipleListPlot[Trajectory[ .01, \(- .5\)], Trajectory[ .01,  .5], 
      Trajectory[ .01, 1], Trajectory[ .01, 1.5], 
      PlotJoined \[Rule] True]\)], "Input",
  CellTags->"mmtag:19:MultipleListPlot[]"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0031746 0.204713 0.0192028 [
[.18254 .19221 -12 -20 ]
[.18254 .19221 12 0 ]
[.34127 .19221 -17 -20 ]
[.34127 .19221 17 0 ]
[.5 .19221 -17 -20 ]
[.5 .19221 17 0 ]
[.65873 .19221 -17 -20 ]
[.65873 .19221 17 0 ]
[.81746 .19221 -17 -20 ]
[.81746 .19221 17 0 ]
[.97619 .19221 -17 -20 ]
[.97619 .19221 17 0 ]
[.01131 .01268 -36.9375 -10 ]
[.01131 .01268 0 10 ]
[.01131 .1087 -26.9375 -10 ]
[.01131 .1087 0 10 ]
[.01131 .30073 -14 -10 ]
[.01131 .30073 0 10 ]
[.01131 .39674 -24 -10 ]
[.01131 .39674 0 10 ]
[.01131 .49276 -24 -10 ]
[.01131 .49276 0 10 ]
[.01131 .58877 -24 -10 ]
[.01131 .58877 0 10 ]
[ -0.005 -0.005 0 0 ]
[ 1.005 .62303 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .20471 m
.18254 .21096 L
s
gsave
.18254 .19221 -73 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(50) show
1.000 setlinewidth
grestore
.34127 .20471 m
.34127 .21096 L
s
gsave
.34127 .19221 -78 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(100) show
1.000 setlinewidth
grestore
.5 .20471 m
.5 .21096 L
s
gsave
.5 .19221 -78 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(150) show
1.000 setlinewidth
grestore
.65873 .20471 m
.65873 .21096 L
s
gsave
.65873 .19221 -78 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(200) show
1.000 setlinewidth
grestore
.81746 .20471 m
.81746 .21096 L
s
gsave
.81746 .19221 -78 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(250) show
1.000 setlinewidth
grestore
.97619 .20471 m
.97619 .21096 L
s
gsave
.97619 .19221 -78 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(300) show
1.000 setlinewidth
grestore
.125 Mabswid
.05556 .20471 m
.05556 .20846 L
s
.0873 .20471 m
.0873 .20846 L
s
.11905 .20471 m
.11905 .20846 L
s
.15079 .20471 m
.15079 .20846 L
s
.21429 .20471 m
.21429 .20846 L
s
.24603 .20471 m
.24603 .20846 L
s
.27778 .20471 m
.27778 .20846 L
s
.30952 .20471 m
.30952 .20846 L
s
.37302 .20471 m
.37302 .20846 L
s
.40476 .20471 m
.40476 .20846 L
s
.43651 .20471 m
.43651 .20846 L
s
.46825 .20471 m
.46825 .20846 L
s
.53175 .20471 m
.53175 .20846 L
s
.56349 .20471 m
.56349 .20846 L
s
.59524 .20471 m
.59524 .20846 L
s
.62698 .20471 m
.62698 .20846 L
s
.69048 .20471 m
.69048 .20846 L
s
.72222 .20471 m
.72222 .20846 L
s
.75397 .20471 m
.75397 .20846 L
s
.78571 .20471 m
.78571 .20846 L
s
.84921 .20471 m
.84921 .20846 L
s
.88095 .20471 m
.88095 .20846 L
s
.9127 .20471 m
.9127 .20846 L
s
.94444 .20471 m
.94444 .20846 L
s
.01 w
0 .20471 m
1 .20471 L
s
.25 Mabswid
.02381 .01268 m
.03006 .01268 L
s
gsave
.01131 .01268 -97.9375 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Mathematica1-Bold
%%IncludeFont: Mathematica1-Bold
/Mathematica1-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(-) show
75.938 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(10) show
1.000 setlinewidth
grestore
.02381 .1087 m
.03006 .1087 L
s
gsave
.01131 .1087 -87.9375 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Mathematica1-Bold
%%IncludeFont: Mathematica1-Bold
/Mathematica1-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(-) show
75.938 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(5) show
1.000 setlinewidth
grestore
.02381 .30073 m
.03006 .30073 L
s
gsave
.01131 .30073 -75 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(5) show
1.000 setlinewidth
grestore
.02381 .39674 m
.03006 .39674 L
s
gsave
.01131 .39674 -85 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(10) show
1.000 setlinewidth
grestore
.02381 .49276 m
.03006 .49276 L
s
gsave
.01131 .49276 -85 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(15) show
1.000 setlinewidth
grestore
.02381 .58877 m
.03006 .58877 L
s
gsave
.01131 .58877 -85 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(20) show
1.000 setlinewidth
grestore
.125 Mabswid
.02381 .03189 m
.02756 .03189 L
s
.02381 .05109 m
.02756 .05109 L
s
.02381 .07029 m
.02756 .07029 L
s
.02381 .0895 m
.02756 .0895 L
s
.02381 .1279 m
.02756 .1279 L
s
.02381 .1471 m
.02756 .1471 L
s
.02381 .16631 m
.02756 .16631 L
s
.02381 .18551 m
.02756 .18551 L
s
.02381 .22392 m
.02756 .22392 L
s
.02381 .24312 m
.02756 .24312 L
s
.02381 .26232 m
.02756 .26232 L
s
.02381 .28152 m
.02756 .28152 L
s
.02381 .31993 m
.02756 .31993 L
s
.02381 .33913 m
.02756 .33913 L
s
.02381 .35834 m
.02756 .35834 L
s
.02381 .37754 m
.02756 .37754 L
s
.02381 .41594 m
.02756 .41594 L
s
.02381 .43515 m
.02756 .43515 L
s
.02381 .45435 m
.02756 .45435 L
s
.02381 .47355 m
.02756 .47355 L
s
.02381 .51196 m
.02756 .51196 L
s
.02381 .53116 m
.02756 .53116 L
s
.02381 .55036 m
.02756 .55036 L
s
.02381 .56957 m
.02756 .56957 L
s
.02381 .60797 m
.02756 .60797 L
s
.01 w
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.0075 w
.02698 .19502 m
.03016 .19492 L
.03333 .19482 L
.03651 .19472 L
.03968 .19462 L
.04286 .19452 L
.04603 .19442 L
.04921 .19432 L
.05238 .19421 L
.05556 .19411 L
.05873 .194 L
.0619 .19389 L
.06508 .19379 L
.06825 .19368 L
.07143 .19357 L
.0746 .19345 L
.07778 .19334 L
.08095 .19323 L
.08413 .19311 L
.0873 .193 L
.09048 .19288 L
.09365 .19276 L
.09683 .19264 L
.1 .19252 L
.10317 .1924 L
.10635 .19228 L
.10952 .19215 L
.1127 .19203 L
.11587 .1919 L
.11905 .19177 L
.12222 .19164 L
.1254 .19151 L
.12857 .19138 L
.13175 .19125 L
.13492 .19111 L
.1381 .19098 L
.14127 .19084 L
.14444 .1907 L
.14762 .19056 L
.15079 .19042 L
.15397 .19027 L
.15714 .19013 L
.16032 .18998 L
.16349 .18984 L
.16667 .18969 L
.16984 .18954 L
.17302 .18939 L
.17619 .18923 L
.17937 .18908 L
.18254 .18892 L
Mistroke
.18571 .18876 L
.18889 .1886 L
.19206 .18844 L
.19524 .18828 L
.19841 .18812 L
.20159 .18795 L
.20476 .18778 L
.20794 .18761 L
.21111 .18744 L
.21429 .18727 L
.21746 .1871 L
.22063 .18692 L
.22381 .18674 L
.22698 .18656 L
.23016 .18638 L
.23333 .1862 L
.23651 .18601 L
.23968 .18582 L
.24286 .18564 L
.24603 .18544 L
.24921 .18525 L
.25238 .18506 L
.25556 .18486 L
.25873 .18466 L
.2619 .18446 L
.26508 .18426 L
.26825 .18405 L
.27143 .18385 L
.2746 .18364 L
.27778 .18343 L
.28095 .18322 L
.28413 .183 L
.2873 .18278 L
.29048 .18256 L
.29365 .18234 L
.29683 .18212 L
.3 .18189 L
.30317 .18167 L
.30635 .18143 L
.30952 .1812 L
.3127 .18097 L
.31587 .18073 L
.31905 .18049 L
.32222 .18025 L
.3254 .18 L
.32857 .17976 L
.33175 .17951 L
.33492 .17925 L
.3381 .179 L
.34127 .17874 L
Mistroke
.34444 .17848 L
.34762 .17822 L
.35079 .17796 L
.35397 .17769 L
.35714 .17742 L
.36032 .17714 L
.36349 .17687 L
.36667 .17659 L
.36984 .17631 L
.37302 .17603 L
.37619 .17574 L
.37937 .17545 L
.38254 .17516 L
.38571 .17486 L
.38889 .17456 L
.39206 .17426 L
.39524 .17396 L
.39841 .17365 L
.40159 .17334 L
.40476 .17302 L
.40794 .17271 L
.41111 .17239 L
.41429 .17206 L
.41746 .17174 L
.42063 .17141 L
.42381 .17107 L
.42698 .17074 L
.43016 .1704 L
.43333 .17006 L
.43651 .16971 L
.43968 .16936 L
.44286 .16901 L
.44603 .16865 L
.44921 .16829 L
.45238 .16792 L
.45556 .16756 L
.45873 .16718 L
.4619 .16681 L
.46508 .16643 L
.46825 .16605 L
.47143 .16566 L
.4746 .16527 L
.47778 .16488 L
.48095 .16448 L
.48413 .16407 L
.4873 .16367 L
.49048 .16326 L
.49365 .16284 L
.49683 .16242 L
.5 .162 L
Mistroke
.50317 .16157 L
.50635 .16114 L
.50952 .16071 L
.5127 .16027 L
.51587 .15982 L
.51905 .15937 L
.52222 .15892 L
.5254 .15846 L
.52857 .158 L
.53175 .15753 L
.53492 .15706 L
.5381 .15658 L
.54127 .1561 L
.54444 .15562 L
.54762 .15513 L
.55079 .15463 L
.55397 .15413 L
.55714 .15362 L
.56032 .15311 L
.56349 .1526 L
.56667 .15208 L
.56984 .15155 L
.57302 .15102 L
.57619 .15048 L
.57937 .14994 L
.58254 .14939 L
.58571 .14884 L
.58889 .14828 L
.59206 .14771 L
.59524 .14714 L
.59841 .14657 L
.60159 .14599 L
.60476 .1454 L
.60794 .14481 L
.61111 .14421 L
.61429 .1436 L
.61746 .14299 L
.62063 .14237 L
.62381 .14175 L
.62698 .14112 L
.63016 .14049 L
.63333 .13984 L
.63651 .13919 L
.63968 .13854 L
.64286 .13788 L
.64603 .13721 L
.64921 .13653 L
.65238 .13585 L
.65556 .13516 L
.65873 .13447 L
Mistroke
.6619 .13377 L
.66508 .13306 L
.66825 .13234 L
.67143 .13162 L
.6746 .13089 L
.67778 .13015 L
.68095 .1294 L
.68413 .12865 L
.6873 .12789 L
.69048 .12712 L
.69365 .12634 L
.69683 .12556 L
.7 .12477 L
.70317 .12397 L
.70635 .12316 L
.70952 .12235 L
.7127 .12152 L
.71587 .12069 L
.71905 .11985 L
.72222 .119 L
.7254 .11814 L
.72857 .11728 L
.73175 .1164 L
.73492 .11552 L
.7381 .11463 L
.74127 .11373 L
.74444 .11282 L
.74762 .1119 L
.75079 .11097 L
.75397 .11003 L
.75714 .10909 L
.76032 .10813 L
.76349 .10717 L
.76667 .10619 L
.76984 .1052 L
.77302 .10421 L
.77619 .1032 L
.77937 .10219 L
.78254 .10116 L
.78571 .10013 L
.78889 .09908 L
.79206 .09803 L
.79524 .09696 L
.79841 .09588 L
.80159 .09479 L
.80476 .09369 L
.80794 .09258 L
.81111 .09146 L
.81429 .09033 L
.81746 .08919 L
Mistroke
.82063 .08803 L
.82381 .08686 L
.82698 .08569 L
.83016 .0845 L
.83333 .08329 L
.83651 .08208 L
.83968 .08085 L
.84286 .07961 L
.84603 .07836 L
.84921 .0771 L
.85238 .07582 L
.85556 .07454 L
.85873 .07323 L
.8619 .07192 L
.86508 .07059 L
.86825 .06925 L
.87143 .06789 L
.8746 .06653 L
.87778 .06514 L
.88095 .06375 L
.88413 .06234 L
.8873 .06092 L
.89048 .05948 L
.89365 .05803 L
.89683 .05656 L
.9 .05508 L
.90317 .05358 L
.90635 .05207 L
.90952 .05054 L
.9127 .049 L
.91587 .04744 L
.91905 .04587 L
.92222 .04428 L
.9254 .04268 L
.92857 .04106 L
.93175 .03942 L
.93492 .03777 L
.9381 .0361 L
.94127 .03441 L
.94444 .03271 L
.94762 .03099 L
.95079 .02925 L
.95397 .0275 L
.95714 .02573 L
.96032 .02394 L
.96349 .02213 L
.96667 .0203 L
.96984 .01846 L
.97302 .0166 L
.97619 .01472 L
Mistroke
Mfstroke
.0001 w
.02698 .19502 -1.875 0 Mabsadd m
.02698 .19502 0 2.5 Mabsadd L
.02698 .19502 1.875 0 Mabsadd L
.02698 .19502 0 -2.5 Mabsadd L
.02698 .19502 -1.875 0 Mabsadd L closepath F
.03016 .19492 -1.875 0 Mabsadd m
.03016 .19492 0 2.5 Mabsadd L
.03016 .19492 1.875 0 Mabsadd L
.03016 .19492 0 -2.5 Mabsadd L
.03016 .19492 -1.875 0 Mabsadd L closepath F
.03333 .19482 -1.875 0 Mabsadd m
.03333 .19482 0 2.5 Mabsadd L
.03333 .19482 1.875 0 Mabsadd L
.03333 .19482 0 -2.5 Mabsadd L
.03333 .19482 -1.875 0 Mabsadd L closepath F
.03651 .19472 -1.875 0 Mabsadd m
.03651 .19472 0 2.5 Mabsadd L
.03651 .19472 1.875 0 Mabsadd L
.03651 .19472 0 -2.5 Mabsadd L
.03651 .19472 -1.875 0 Mabsadd L closepath F
.03968 .19462 -1.875 0 Mabsadd m
.03968 .19462 0 2.5 Mabsadd L
.03968 .19462 1.875 0 Mabsadd L
.03968 .19462 0 -2.5 Mabsadd L
.03968 .19462 -1.875 0 Mabsadd L closepath F
.04286 .19452 -1.875 0 Mabsadd m
.04286 .19452 0 2.5 Mabsadd L
.04286 .19452 1.875 0 Mabsadd L
.04286 .19452 0 -2.5 Mabsadd L
.04286 .19452 -1.875 0 Mabsadd L closepath F
.04603 .19442 -1.875 0 Mabsadd m
.04603 .19442 0 2.5 Mabsadd L
.04603 .19442 1.875 0 Mabsadd L
.04603 .19442 0 -2.5 Mabsadd L
.04603 .19442 -1.875 0 Mabsadd L closepath F
.04921 .19432 -1.875 0 Mabsadd m
.04921 .19432 0 2.5 Mabsadd L
.04921 .19432 1.875 0 Mabsadd L
.04921 .19432 0 -2.5 Mabsadd L
.04921 .19432 -1.875 0 Mabsadd L closepath F
.05238 .19421 -1.875 0 Mabsadd m
.05238 .19421 0 2.5 Mabsadd L
.05238 .19421 1.875 0 Mabsadd L
.05238 .19421 0 -2.5 Mabsadd L
.05238 .19421 -1.875 0 Mabsadd L closepath F
.05556 .19411 -1.875 0 Mabsadd m
.05556 .19411 0 2.5 Mabsadd L
.05556 .19411 1.875 0 Mabsadd L
.05556 .19411 0 -2.5 Mabsadd L
.05556 .19411 -1.875 0 Mabsadd L closepath F
.05873 .194 -1.875 0 Mabsadd m
.05873 .194 0 2.5 Mabsadd L
.05873 .194 1.875 0 Mabsadd L
.05873 .194 0 -2.5 Mabsadd L
.05873 .194 -1.875 0 Mabsadd L closepath F
.0619 .19389 -1.875 0 Mabsadd m
.0619 .19389 0 2.5 Mabsadd L
.0619 .19389 1.875 0 Mabsadd L
.0619 .19389 0 -2.5 Mabsadd L
.0619 .19389 -1.875 0 Mabsadd L closepath F
.06508 .19379 -1.875 0 Mabsadd m
.06508 .19379 0 2.5 Mabsadd L
.06508 .19379 1.875 0 Mabsadd L
.06508 .19379 0 -2.5 Mabsadd L
.06508 .19379 -1.875 0 Mabsadd L closepath F
.06825 .19368 -1.875 0 Mabsadd m
.06825 .19368 0 2.5 Mabsadd L
.06825 .19368 1.875 0 Mabsadd L
.06825 .19368 0 -2.5 Mabsadd L
.06825 .19368 -1.875 0 Mabsadd L closepath F
.07143 .19357 -1.875 0 Mabsadd m
.07143 .19357 0 2.5 Mabsadd L
.07143 .19357 1.875 0 Mabsadd L
.07143 .19357 0 -2.5 Mabsadd L
.07143 .19357 -1.875 0 Mabsadd L closepath F
.0746 .19345 -1.875 0 Mabsadd m
.0746 .19345 0 2.5 Mabsadd L
.0746 .19345 1.875 0 Mabsadd L
.0746 .19345 0 -2.5 Mabsadd L
.0746 .19345 -1.875 0 Mabsadd L closepath F
.07778 .19334 -1.875 0 Mabsadd m
.07778 .19334 0 2.5 Mabsadd L
.07778 .19334 1.875 0 Mabsadd L
.07778 .19334 0 -2.5 Mabsadd L
.07778 .19334 -1.875 0 Mabsadd L closepath F
.08095 .19323 -1.875 0 Mabsadd m
.08095 .19323 0 2.5 Mabsadd L
.08095 .19323 1.875 0 Mabsadd L
.08095 .19323 0 -2.5 Mabsadd L
.08095 .19323 -1.875 0 Mabsadd L closepath F
.08413 .19311 -1.875 0 Mabsadd m
.08413 .19311 0 2.5 Mabsadd L
.08413 .19311 1.875 0 Mabsadd L
.08413 .19311 0 -2.5 Mabsadd L
.08413 .19311 -1.875 0 Mabsadd L closepath F
.0873 .193 -1.875 0 Mabsadd m
.0873 .193 0 2.5 Mabsadd L
.0873 .193 1.875 0 Mabsadd L
.0873 .193 0 -2.5 Mabsadd L
.0873 .193 -1.875 0 Mabsadd L closepath F
.09048 .19288 -1.875 0 Mabsadd m
.09048 .19288 0 2.5 Mabsadd L
.09048 .19288 1.875 0 Mabsadd L
.09048 .19288 0 -2.5 Mabsadd L
.09048 .19288 -1.875 0 Mabsadd L closepath F
.09365 .19276 -1.875 0 Mabsadd m
.09365 .19276 0 2.5 Mabsadd L
.09365 .19276 1.875 0 Mabsadd L
.09365 .19276 0 -2.5 Mabsadd L
.09365 .19276 -1.875 0 Mabsadd L closepath F
.09683 .19264 -1.875 0 Mabsadd m
.09683 .19264 0 2.5 Mabsadd L
.09683 .19264 1.875 0 Mabsadd L
.09683 .19264 0 -2.5 Mabsadd L
.09683 .19264 -1.875 0 Mabsadd L closepath F
.1 .19252 -1.875 0 Mabsadd m
.1 .19252 0 2.5 Mabsadd L
.1 .19252 1.875 0 Mabsadd L
.1 .19252 0 -2.5 Mabsadd L
.1 .19252 -1.875 0 Mabsadd L closepath F
.10317 .1924 -1.875 0 Mabsadd m
.10317 .1924 0 2.5 Mabsadd L
.10317 .1924 1.875 0 Mabsadd L
.10317 .1924 0 -2.5 Mabsadd L
.10317 .1924 -1.875 0 Mabsadd L closepath F
.10635 .19228 -1.875 0 Mabsadd m
.10635 .19228 0 2.5 Mabsadd L
.10635 .19228 1.875 0 Mabsadd L
.10635 .19228 0 -2.5 Mabsadd L
.10635 .19228 -1.875 0 Mabsadd L closepath F
.10952 .19215 -1.875 0 Mabsadd m
.10952 .19215 0 2.5 Mabsadd L
.10952 .19215 1.875 0 Mabsadd L
.10952 .19215 0 -2.5 Mabsadd L
.10952 .19215 -1.875 0 Mabsadd L closepath F
.1127 .19203 -1.875 0 Mabsadd m
.1127 .19203 0 2.5 Mabsadd L
.1127 .19203 1.875 0 Mabsadd L
.1127 .19203 0 -2.5 Mabsadd L
.1127 .19203 -1.875 0 Mabsadd L closepath F
.11587 .1919 -1.875 0 Mabsadd m
.11587 .1919 0 2.5 Mabsadd L
.11587 .1919 1.875 0 Mabsadd L
.11587 .1919 0 -2.5 Mabsadd L
.11587 .1919 -1.875 0 Mabsadd L closepath F
.11905 .19177 -1.875 0 Mabsadd m
.11905 .19177 0 2.5 Mabsadd L
.11905 .19177 1.875 0 Mabsadd L
.11905 .19177 0 -2.5 Mabsadd L
.11905 .19177 -1.875 0 Mabsadd L closepath F
.12222 .19164 -1.875 0 Mabsadd m
.12222 .19164 0 2.5 Mabsadd L
.12222 .19164 1.875 0 Mabsadd L
.12222 .19164 0 -2.5 Mabsadd L
.12222 .19164 -1.875 0 Mabsadd L closepath F
.1254 .19151 -1.875 0 Mabsadd m
.1254 .19151 0 2.5 Mabsadd L
.1254 .19151 1.875 0 Mabsadd L
.1254 .19151 0 -2.5 Mabsadd L
.1254 .19151 -1.875 0 Mabsadd L closepath F
.12857 .19138 -1.875 0 Mabsadd m
.12857 .19138 0 2.5 Mabsadd L
.12857 .19138 1.875 0 Mabsadd L
.12857 .19138 0 -2.5 Mabsadd L
.12857 .19138 -1.875 0 Mabsadd L closepath F
.13175 .19125 -1.875 0 Mabsadd m
.13175 .19125 0 2.5 Mabsadd L
.13175 .19125 1.875 0 Mabsadd L
.13175 .19125 0 -2.5 Mabsadd L
.13175 .19125 -1.875 0 Mabsadd L closepath F
.13492 .19111 -1.875 0 Mabsadd m
.13492 .19111 0 2.5 Mabsadd L
.13492 .19111 1.875 0 Mabsadd L
.13492 .19111 0 -2.5 Mabsadd L
.13492 .19111 -1.875 0 Mabsadd L closepath F
.1381 .19098 -1.875 0 Mabsadd m
.1381 .19098 0 2.5 Mabsadd L
.1381 .19098 1.875 0 Mabsadd L
.1381 .19098 0 -2.5 Mabsadd L
.1381 .19098 -1.875 0 Mabsadd L closepath F
.14127 .19084 -1.875 0 Mabsadd m
.14127 .19084 0 2.5 Mabsadd L
.14127 .19084 1.875 0 Mabsadd L
.14127 .19084 0 -2.5 Mabsadd L
.14127 .19084 -1.875 0 Mabsadd L closepath F
.14444 .1907 -1.875 0 Mabsadd m
.14444 .1907 0 2.5 Mabsadd L
.14444 .1907 1.875 0 Mabsadd L
.14444 .1907 0 -2.5 Mabsadd L
.14444 .1907 -1.875 0 Mabsadd L closepath F
.14762 .19056 -1.875 0 Mabsadd m
.14762 .19056 0 2.5 Mabsadd L
.14762 .19056 1.875 0 Mabsadd L
.14762 .19056 0 -2.5 Mabsadd L
.14762 .19056 -1.875 0 Mabsadd L closepath F
.15079 .19042 -1.875 0 Mabsadd m
.15079 .19042 0 2.5 Mabsadd L
.15079 .19042 1.875 0 Mabsadd L
.15079 .19042 0 -2.5 Mabsadd L
.15079 .19042 -1.875 0 Mabsadd L closepath F
.15397 .19027 -1.875 0 Mabsadd m
.15397 .19027 0 2.5 Mabsadd L
.15397 .19027 1.875 0 Mabsadd L
.15397 .19027 0 -2.5 Mabsadd L
.15397 .19027 -1.875 0 Mabsadd L closepath F
.15714 .19013 -1.875 0 Mabsadd m
.15714 .19013 0 2.5 Mabsadd L
.15714 .19013 1.875 0 Mabsadd L
.15714 .19013 0 -2.5 Mabsadd L
.15714 .19013 -1.875 0 Mabsadd L closepath F
.16032 .18998 -1.875 0 Mabsadd m
.16032 .18998 0 2.5 Mabsadd L
.16032 .18998 1.875 0 Mabsadd L
.16032 .18998 0 -2.5 Mabsadd L
.16032 .18998 -1.875 0 Mabsadd L closepath F
.16349 .18984 -1.875 0 Mabsadd m
.16349 .18984 0 2.5 Mabsadd L
.16349 .18984 1.875 0 Mabsadd L
.16349 .18984 0 -2.5 Mabsadd L
.16349 .18984 -1.875 0 Mabsadd L closepath F
.16667 .18969 -1.875 0 Mabsadd m
.16667 .18969 0 2.5 Mabsadd L
.16667 .18969 1.875 0 Mabsadd L
.16667 .18969 0 -2.5 Mabsadd L
.16667 .18969 -1.875 0 Mabsadd L closepath F
.16984 .18954 -1.875 0 Mabsadd m
.16984 .18954 0 2.5 Mabsadd L
.16984 .18954 1.875 0 Mabsadd L
.16984 .18954 0 -2.5 Mabsadd L
.16984 .18954 -1.875 0 Mabsadd L closepath F
.17302 .18939 -1.875 0 Mabsadd m
.17302 .18939 0 2.5 Mabsadd L
.17302 .18939 1.875 0 Mabsadd L
.17302 .18939 0 -2.5 Mabsadd L
.17302 .18939 -1.875 0 Mabsadd L closepath F
.17619 .18923 -1.875 0 Mabsadd m
.17619 .18923 0 2.5 Mabsadd L
.17619 .18923 1.875 0 Mabsadd L
.17619 .18923 0 -2.5 Mabsadd L
.17619 .18923 -1.875 0 Mabsadd L closepath F
.17937 .18908 -1.875 0 Mabsadd m
.17937 .18908 0 2.5 Mabsadd L
.17937 .18908 1.875 0 Mabsadd L
.17937 .18908 0 -2.5 Mabsadd L
.17937 .18908 -1.875 0 Mabsadd L closepath F
.18254 .18892 -1.875 0 Mabsadd m
.18254 .18892 0 2.5 Mabsadd L
.18254 .18892 1.875 0 Mabsadd L
.18254 .18892 0 -2.5 Mabsadd L
.18254 .18892 -1.875 0 Mabsadd L closepath F
.18571 .18876 -1.875 0 Mabsadd m
.18571 .18876 0 2.5 Mabsadd L
.18571 .18876 1.875 0 Mabsadd L
.18571 .18876 0 -2.5 Mabsadd L
.18571 .18876 -1.875 0 Mabsadd L closepath F
.18889 .1886 -1.875 0 Mabsadd m
.18889 .1886 0 2.5 Mabsadd L
.18889 .1886 1.875 0 Mabsadd L
.18889 .1886 0 -2.5 Mabsadd L
.18889 .1886 -1.875 0 Mabsadd L closepath F
.19206 .18844 -1.875 0 Mabsadd m
.19206 .18844 0 2.5 Mabsadd L
.19206 .18844 1.875 0 Mabsadd L
.19206 .18844 0 -2.5 Mabsadd L
.19206 .18844 -1.875 0 Mabsadd L closepath F
.19524 .18828 -1.875 0 Mabsadd m
.19524 .18828 0 2.5 Mabsadd L
.19524 .18828 1.875 0 Mabsadd L
.19524 .18828 0 -2.5 Mabsadd L
.19524 .18828 -1.875 0 Mabsadd L closepath F
.19841 .18812 -1.875 0 Mabsadd m
.19841 .18812 0 2.5 Mabsadd L
.19841 .18812 1.875 0 Mabsadd L
.19841 .18812 0 -2.5 Mabsadd L
.19841 .18812 -1.875 0 Mabsadd L closepath F
.20159 .18795 -1.875 0 Mabsadd m
.20159 .18795 0 2.5 Mabsadd L
.20159 .18795 1.875 0 Mabsadd L
.20159 .18795 0 -2.5 Mabsadd L
.20159 .18795 -1.875 0 Mabsadd L closepath F
.20476 .18778 -1.875 0 Mabsadd m
.20476 .18778 0 2.5 Mabsadd L
.20476 .18778 1.875 0 Mabsadd L
.20476 .18778 0 -2.5 Mabsadd L
.20476 .18778 -1.875 0 Mabsadd L closepath F
.20794 .18761 -1.875 0 Mabsadd m
.20794 .18761 0 2.5 Mabsadd L
.20794 .18761 1.875 0 Mabsadd L
.20794 .18761 0 -2.5 Mabsadd L
.20794 .18761 -1.875 0 Mabsadd L closepath F
.21111 .18744 -1.875 0 Mabsadd m
.21111 .18744 0 2.5 Mabsadd L
.21111 .18744 1.875 0 Mabsadd L
.21111 .18744 0 -2.5 Mabsadd L
.21111 .18744 -1.875 0 Mabsadd L closepath F
.21429 .18727 -1.875 0 Mabsadd m
.21429 .18727 0 2.5 Mabsadd L
.21429 .18727 1.875 0 Mabsadd L
.21429 .18727 0 -2.5 Mabsadd L
.21429 .18727 -1.875 0 Mabsadd L closepath F
.21746 .1871 -1.875 0 Mabsadd m
.21746 .1871 0 2.5 Mabsadd L
.21746 .1871 1.875 0 Mabsadd L
.21746 .1871 0 -2.5 Mabsadd L
.21746 .1871 -1.875 0 Mabsadd L closepath F
.22063 .18692 -1.875 0 Mabsadd m
.22063 .18692 0 2.5 Mabsadd L
.22063 .18692 1.875 0 Mabsadd L
.22063 .18692 0 -2.5 Mabsadd L
.22063 .18692 -1.875 0 Mabsadd L closepath F
.22381 .18674 -1.875 0 Mabsadd m
.22381 .18674 0 2.5 Mabsadd L
.22381 .18674 1.875 0 Mabsadd L
.22381 .18674 0 -2.5 Mabsadd L
.22381 .18674 -1.875 0 Mabsadd L closepath F
.22698 .18656 -1.875 0 Mabsadd m
.22698 .18656 0 2.5 Mabsadd L
.22698 .18656 1.875 0 Mabsadd L
.22698 .18656 0 -2.5 Mabsadd L
.22698 .18656 -1.875 0 Mabsadd L closepath F
.23016 .18638 -1.875 0 Mabsadd m
.23016 .18638 0 2.5 Mabsadd L
.23016 .18638 1.875 0 Mabsadd L
.23016 .18638 0 -2.5 Mabsadd L
.23016 .18638 -1.875 0 Mabsadd L closepath F
.23333 .1862 -1.875 0 Mabsadd m
.23333 .1862 0 2.5 Mabsadd L
.23333 .1862 1.875 0 Mabsadd L
.23333 .1862 0 -2.5 Mabsadd L
.23333 .1862 -1.875 0 Mabsadd L closepath F
.23651 .18601 -1.875 0 Mabsadd m
.23651 .18601 0 2.5 Mabsadd L
.23651 .18601 1.875 0 Mabsadd L
.23651 .18601 0 -2.5 Mabsadd L
.23651 .18601 -1.875 0 Mabsadd L closepath F
.23968 .18582 -1.875 0 Mabsadd m
.23968 .18582 0 2.5 Mabsadd L
.23968 .18582 1.875 0 Mabsadd L
.23968 .18582 0 -2.5 Mabsadd L
.23968 .18582 -1.875 0 Mabsadd L closepath F
.24286 .18564 -1.875 0 Mabsadd m
.24286 .18564 0 2.5 Mabsadd L
.24286 .18564 1.875 0 Mabsadd L
.24286 .18564 0 -2.5 Mabsadd L
.24286 .18564 -1.875 0 Mabsadd L closepath F
.24603 .18544 -1.875 0 Mabsadd m
.24603 .18544 0 2.5 Mabsadd L
.24603 .18544 1.875 0 Mabsadd L
.24603 .18544 0 -2.5 Mabsadd L
.24603 .18544 -1.875 0 Mabsadd L closepath F
.24921 .18525 -1.875 0 Mabsadd m
.24921 .18525 0 2.5 Mabsadd L
.24921 .18525 1.875 0 Mabsadd L
.24921 .18525 0 -2.5 Mabsadd L
.24921 .18525 -1.875 0 Mabsadd L closepath F
.25238 .18506 -1.875 0 Mabsadd m
.25238 .18506 0 2.5 Mabsadd L
.25238 .18506 1.875 0 Mabsadd L
.25238 .18506 0 -2.5 Mabsadd L
.25238 .18506 -1.875 0 Mabsadd L closepath F
.25556 .18486 -1.875 0 Mabsadd m
.25556 .18486 0 2.5 Mabsadd L
.25556 .18486 1.875 0 Mabsadd L
.25556 .18486 0 -2.5 Mabsadd L
.25556 .18486 -1.875 0 Mabsadd L closepath F
.25873 .18466 -1.875 0 Mabsadd m
.25873 .18466 0 2.5 Mabsadd L
.25873 .18466 1.875 0 Mabsadd L
.25873 .18466 0 -2.5 Mabsadd L
.25873 .18466 -1.875 0 Mabsadd L closepath F
.2619 .18446 -1.875 0 Mabsadd m
.2619 .18446 0 2.5 Mabsadd L
.2619 .18446 1.875 0 Mabsadd L
.2619 .18446 0 -2.5 Mabsadd L
.2619 .18446 -1.875 0 Mabsadd L closepath F
.26508 .18426 -1.875 0 Mabsadd m
.26508 .18426 0 2.5 Mabsadd L
.26508 .18426 1.875 0 Mabsadd L
.26508 .18426 0 -2.5 Mabsadd L
.26508 .18426 -1.875 0 Mabsadd L closepath F
.26825 .18405 -1.875 0 Mabsadd m
.26825 .18405 0 2.5 Mabsadd L
.26825 .18405 1.875 0 Mabsadd L
.26825 .18405 0 -2.5 Mabsadd L
.26825 .18405 -1.875 0 Mabsadd L closepath F
.27143 .18385 -1.875 0 Mabsadd m
.27143 .18385 0 2.5 Mabsadd L
.27143 .18385 1.875 0 Mabsadd L
.27143 .18385 0 -2.5 Mabsadd L
.27143 .18385 -1.875 0 Mabsadd L closepath F
.2746 .18364 -1.875 0 Mabsadd m
.2746 .18364 0 2.5 Mabsadd L
.2746 .18364 1.875 0 Mabsadd L
.2746 .18364 0 -2.5 Mabsadd L
.2746 .18364 -1.875 0 Mabsadd L closepath F
.27778 .18343 -1.875 0 Mabsadd m
.27778 .18343 0 2.5 Mabsadd L
.27778 .18343 1.875 0 Mabsadd L
.27778 .18343 0 -2.5 Mabsadd L
.27778 .18343 -1.875 0 Mabsadd L closepath F
.28095 .18322 -1.875 0 Mabsadd m
.28095 .18322 0 2.5 Mabsadd L
.28095 .18322 1.875 0 Mabsadd L
.28095 .18322 0 -2.5 Mabsadd L
.28095 .18322 -1.875 0 Mabsadd L closepath F
.28413 .183 -1.875 0 Mabsadd m
.28413 .183 0 2.5 Mabsadd L
.28413 .183 1.875 0 Mabsadd L
.28413 .183 0 -2.5 Mabsadd L
.28413 .183 -1.875 0 Mabsadd L closepath F
.2873 .18278 -1.875 0 Mabsadd m
.2873 .18278 0 2.5 Mabsadd L
.2873 .18278 1.875 0 Mabsadd L
.2873 .18278 0 -2.5 Mabsadd L
.2873 .18278 -1.875 0 Mabsadd L closepath F
.29048 .18256 -1.875 0 Mabsadd m
.29048 .18256 0 2.5 Mabsadd L
.29048 .18256 1.875 0 Mabsadd L
.29048 .18256 0 -2.5 Mabsadd L
.29048 .18256 -1.875 0 Mabsadd L closepath F
.29365 .18234 -1.875 0 Mabsadd m
.29365 .18234 0 2.5 Mabsadd L
.29365 .18234 1.875 0 Mabsadd L
.29365 .18234 0 -2.5 Mabsadd L
.29365 .18234 -1.875 0 Mabsadd L closepath F
.29683 .18212 -1.875 0 Mabsadd m
.29683 .18212 0 2.5 Mabsadd L
.29683 .18212 1.875 0 Mabsadd L
.29683 .18212 0 -2.5 Mabsadd L
.29683 .18212 -1.875 0 Mabsadd L closepath F
.3 .18189 -1.875 0 Mabsadd m
.3 .18189 0 2.5 Mabsadd L
.3 .18189 1.875 0 Mabsadd L
.3 .18189 0 -2.5 Mabsadd L
.3 .18189 -1.875 0 Mabsadd L closepath F
.30317 .18167 -1.875 0 Mabsadd m
.30317 .18167 0 2.5 Mabsadd L
.30317 .18167 1.875 0 Mabsadd L
.30317 .18167 0 -2.5 Mabsadd L
.30317 .18167 -1.875 0 Mabsadd L closepath F
.30635 .18143 -1.875 0 Mabsadd m
.30635 .18143 0 2.5 Mabsadd L
.30635 .18143 1.875 0 Mabsadd L
.30635 .18143 0 -2.5 Mabsadd L
.30635 .18143 -1.875 0 Mabsadd L closepath F
.30952 .1812 -1.875 0 Mabsadd m
.30952 .1812 0 2.5 Mabsadd L
.30952 .1812 1.875 0 Mabsadd L
.30952 .1812 0 -2.5 Mabsadd L
.30952 .1812 -1.875 0 Mabsadd L closepath F
.3127 .18097 -1.875 0 Mabsadd m
.3127 .18097 0 2.5 Mabsadd L
.3127 .18097 1.875 0 Mabsadd L
.3127 .18097 0 -2.5 Mabsadd L
.3127 .18097 -1.875 0 Mabsadd L closepath F
.31587 .18073 -1.875 0 Mabsadd m
.31587 .18073 0 2.5 Mabsadd L
.31587 .18073 1.875 0 Mabsadd L
.31587 .18073 0 -2.5 Mabsadd L
.31587 .18073 -1.875 0 Mabsadd L closepath F
.31905 .18049 -1.875 0 Mabsadd m
.31905 .18049 0 2.5 Mabsadd L
.31905 .18049 1.875 0 Mabsadd L
.31905 .18049 0 -2.5 Mabsadd L
.31905 .18049 -1.875 0 Mabsadd L closepath F
.32222 .18025 -1.875 0 Mabsadd m
.32222 .18025 0 2.5 Mabsadd L
.32222 .18025 1.875 0 Mabsadd L
.32222 .18025 0 -2.5 Mabsadd L
.32222 .18025 -1.875 0 Mabsadd L closepath F
.3254 .18 -1.875 0 Mabsadd m
.3254 .18 0 2.5 Mabsadd L
.3254 .18 1.875 0 Mabsadd L
.3254 .18 0 -2.5 Mabsadd L
.3254 .18 -1.875 0 Mabsadd L closepath F
.32857 .17976 -1.875 0 Mabsadd m
.32857 .17976 0 2.5 Mabsadd L
.32857 .17976 1.875 0 Mabsadd L
.32857 .17976 0 -2.5 Mabsadd L
.32857 .17976 -1.875 0 Mabsadd L closepath F
.33175 .17951 -1.875 0 Mabsadd m
.33175 .17951 0 2.5 Mabsadd L
.33175 .17951 1.875 0 Mabsadd L
.33175 .17951 0 -2.5 Mabsadd L
.33175 .17951 -1.875 0 Mabsadd L closepath F
.33492 .17925 -1.875 0 Mabsadd m
.33492 .17925 0 2.5 Mabsadd L
.33492 .17925 1.875 0 Mabsadd L
.33492 .17925 0 -2.5 Mabsadd L
.33492 .17925 -1.875 0 Mabsadd L closepath F
.3381 .179 -1.875 0 Mabsadd m
.3381 .179 0 2.5 Mabsadd L
.3381 .179 1.875 0 Mabsadd L
.3381 .179 0 -2.5 Mabsadd L
.3381 .179 -1.875 0 Mabsadd L closepath F
.34127 .17874 -1.875 0 Mabsadd m
.34127 .17874 0 2.5 Mabsadd L
.34127 .17874 1.875 0 Mabsadd L
.34127 .17874 0 -2.5 Mabsadd L
.34127 .17874 -1.875 0 Mabsadd L closepath F
.34444 .17848 -1.875 0 Mabsadd m
.34444 .17848 0 2.5 Mabsadd L
.34444 .17848 1.875 0 Mabsadd L
.34444 .17848 0 -2.5 Mabsadd L
.34444 .17848 -1.875 0 Mabsadd L closepath F
.34762 .17822 -1.875 0 Mabsadd m
.34762 .17822 0 2.5 Mabsadd L
.34762 .17822 1.875 0 Mabsadd L
.34762 .17822 0 -2.5 Mabsadd L
.34762 .17822 -1.875 0 Mabsadd L closepath F
.35079 .17796 -1.875 0 Mabsadd m
.35079 .17796 0 2.5 Mabsadd L
.35079 .17796 1.875 0 Mabsadd L
.35079 .17796 0 -2.5 Mabsadd L
.35079 .17796 -1.875 0 Mabsadd L closepath F
.35397 .17769 -1.875 0 Mabsadd m
.35397 .17769 0 2.5 Mabsadd L
.35397 .17769 1.875 0 Mabsadd L
.35397 .17769 0 -2.5 Mabsadd L
.35397 .17769 -1.875 0 Mabsadd L closepath F
.35714 .17742 -1.875 0 Mabsadd m
.35714 .17742 0 2.5 Mabsadd L
.35714 .17742 1.875 0 Mabsadd L
.35714 .17742 0 -2.5 Mabsadd L
.35714 .17742 -1.875 0 Mabsadd L closepath F
.36032 .17714 -1.875 0 Mabsadd m
.36032 .17714 0 2.5 Mabsadd L
.36032 .17714 1.875 0 Mabsadd L
.36032 .17714 0 -2.5 Mabsadd L
.36032 .17714 -1.875 0 Mabsadd L closepath F
.36349 .17687 -1.875 0 Mabsadd m
.36349 .17687 0 2.5 Mabsadd L
.36349 .17687 1.875 0 Mabsadd L
.36349 .17687 0 -2.5 Mabsadd L
.36349 .17687 -1.875 0 Mabsadd L closepath F
.36667 .17659 -1.875 0 Mabsadd m
.36667 .17659 0 2.5 Mabsadd L
.36667 .17659 1.875 0 Mabsadd L
.36667 .17659 0 -2.5 Mabsadd L
.36667 .17659 -1.875 0 Mabsadd L closepath F
.36984 .17631 -1.875 0 Mabsadd m
.36984 .17631 0 2.5 Mabsadd L
.36984 .17631 1.875 0 Mabsadd L
.36984 .17631 0 -2.5 Mabsadd L
.36984 .17631 -1.875 0 Mabsadd L closepath F
.37302 .17603 -1.875 0 Mabsadd m
.37302 .17603 0 2.5 Mabsadd L
.37302 .17603 1.875 0 Mabsadd L
.37302 .17603 0 -2.5 Mabsadd L
.37302 .17603 -1.875 0 Mabsadd L closepath F
.37619 .17574 -1.875 0 Mabsadd m
.37619 .17574 0 2.5 Mabsadd L
.37619 .17574 1.875 0 Mabsadd L
.37619 .17574 0 -2.5 Mabsadd L
.37619 .17574 -1.875 0 Mabsadd L closepath F
.37937 .17545 -1.875 0 Mabsadd m
.37937 .17545 0 2.5 Mabsadd L
.37937 .17545 1.875 0 Mabsadd L
.37937 .17545 0 -2.5 Mabsadd L
.37937 .17545 -1.875 0 Mabsadd L closepath F
.38254 .17516 -1.875 0 Mabsadd m
.38254 .17516 0 2.5 Mabsadd L
.38254 .17516 1.875 0 Mabsadd L
.38254 .17516 0 -2.5 Mabsadd L
.38254 .17516 -1.875 0 Mabsadd L closepath F
.38571 .17486 -1.875 0 Mabsadd m
.38571 .17486 0 2.5 Mabsadd L
.38571 .17486 1.875 0 Mabsadd L
.38571 .17486 0 -2.5 Mabsadd L
.38571 .17486 -1.875 0 Mabsadd L closepath F
.38889 .17456 -1.875 0 Mabsadd m
.38889 .17456 0 2.5 Mabsadd L
.38889 .17456 1.875 0 Mabsadd L
.38889 .17456 0 -2.5 Mabsadd L
.38889 .17456 -1.875 0 Mabsadd L closepath F
.39206 .17426 -1.875 0 Mabsadd m
.39206 .17426 0 2.5 Mabsadd L
.39206 .17426 1.875 0 Mabsadd L
.39206 .17426 0 -2.5 Mabsadd L
.39206 .17426 -1.875 0 Mabsadd L closepath F
.39524 .17396 -1.875 0 Mabsadd m
.39524 .17396 0 2.5 Mabsadd L
.39524 .17396 1.875 0 Mabsadd L
.39524 .17396 0 -2.5 Mabsadd L
.39524 .17396 -1.875 0 Mabsadd L closepath F
.39841 .17365 -1.875 0 Mabsadd m
.39841 .17365 0 2.5 Mabsadd L
.39841 .17365 1.875 0 Mabsadd L
.39841 .17365 0 -2.5 Mabsadd L
.39841 .17365 -1.875 0 Mabsadd L closepath F
.40159 .17334 -1.875 0 Mabsadd m
.40159 .17334 0 2.5 Mabsadd L
.40159 .17334 1.875 0 Mabsadd L
.40159 .17334 0 -2.5 Mabsadd L
.40159 .17334 -1.875 0 Mabsadd L closepath F
.40476 .17302 -1.875 0 Mabsadd m
.40476 .17302 0 2.5 Mabsadd L
.40476 .17302 1.875 0 Mabsadd L
.40476 .17302 0 -2.5 Mabsadd L
.40476 .17302 -1.875 0 Mabsadd L closepath F
.40794 .17271 -1.875 0 Mabsadd m
.40794 .17271 0 2.5 Mabsadd L
.40794 .17271 1.875 0 Mabsadd L
.40794 .17271 0 -2.5 Mabsadd L
.40794 .17271 -1.875 0 Mabsadd L closepath F
.41111 .17239 -1.875 0 Mabsadd m
.41111 .17239 0 2.5 Mabsadd L
.41111 .17239 1.875 0 Mabsadd L
.41111 .17239 0 -2.5 Mabsadd L
.41111 .17239 -1.875 0 Mabsadd L closepath F
.41429 .17206 -1.875 0 Mabsadd m
.41429 .17206 0 2.5 Mabsadd L
.41429 .17206 1.875 0 Mabsadd L
.41429 .17206 0 -2.5 Mabsadd L
.41429 .17206 -1.875 0 Mabsadd L closepath F
.41746 .17174 -1.875 0 Mabsadd m
.41746 .17174 0 2.5 Mabsadd L
.41746 .17174 1.875 0 Mabsadd L
.41746 .17174 0 -2.5 Mabsadd L
.41746 .17174 -1.875 0 Mabsadd L closepath F
.42063 .17141 -1.875 0 Mabsadd m
.42063 .17141 0 2.5 Mabsadd L
.42063 .17141 1.875 0 Mabsadd L
.42063 .17141 0 -2.5 Mabsadd L
.42063 .17141 -1.875 0 Mabsadd L closepath F
.42381 .17107 -1.875 0 Mabsadd m
.42381 .17107 0 2.5 Mabsadd L
.42381 .17107 1.875 0 Mabsadd L
.42381 .17107 0 -2.5 Mabsadd L
.42381 .17107 -1.875 0 Mabsadd L closepath F
.42698 .17074 -1.875 0 Mabsadd m
.42698 .17074 0 2.5 Mabsadd L
.42698 .17074 1.875 0 Mabsadd L
.42698 .17074 0 -2.5 Mabsadd L
.42698 .17074 -1.875 0 Mabsadd L closepath F
.43016 .1704 -1.875 0 Mabsadd m
.43016 .1704 0 2.5 Mabsadd L
.43016 .1704 1.875 0 Mabsadd L
.43016 .1704 0 -2.5 Mabsadd L
.43016 .1704 -1.875 0 Mabsadd L closepath F
.43333 .17006 -1.875 0 Mabsadd m
.43333 .17006 0 2.5 Mabsadd L
.43333 .17006 1.875 0 Mabsadd L
.43333 .17006 0 -2.5 Mabsadd L
.43333 .17006 -1.875 0 Mabsadd L closepath F
.43651 .16971 -1.875 0 Mabsadd m
.43651 .16971 0 2.5 Mabsadd L
.43651 .16971 1.875 0 Mabsadd L
.43651 .16971 0 -2.5 Mabsadd L
.43651 .16971 -1.875 0 Mabsadd L closepath F
.43968 .16936 -1.875 0 Mabsadd m
.43968 .16936 0 2.5 Mabsadd L
.43968 .16936 1.875 0 Mabsadd L
.43968 .16936 0 -2.5 Mabsadd L
.43968 .16936 -1.875 0 Mabsadd L closepath F
.44286 .16901 -1.875 0 Mabsadd m
.44286 .16901 0 2.5 Mabsadd L
.44286 .16901 1.875 0 Mabsadd L
.44286 .16901 0 -2.5 Mabsadd L
.44286 .16901 -1.875 0 Mabsadd L closepath F
.44603 .16865 -1.875 0 Mabsadd m
.44603 .16865 0 2.5 Mabsadd L
.44603 .16865 1.875 0 Mabsadd L
.44603 .16865 0 -2.5 Mabsadd L
.44603 .16865 -1.875 0 Mabsadd L closepath F
.44921 .16829 -1.875 0 Mabsadd m
.44921 .16829 0 2.5 Mabsadd L
.44921 .16829 1.875 0 Mabsadd L
.44921 .16829 0 -2.5 Mabsadd L
.44921 .16829 -1.875 0 Mabsadd L closepath F
.45238 .16792 -1.875 0 Mabsadd m
.45238 .16792 0 2.5 Mabsadd L
.45238 .16792 1.875 0 Mabsadd L
.45238 .16792 0 -2.5 Mabsadd L
.45238 .16792 -1.875 0 Mabsadd L closepath F
.45556 .16756 -1.875 0 Mabsadd m
.45556 .16756 0 2.5 Mabsadd L
.45556 .16756 1.875 0 Mabsadd L
.45556 .16756 0 -2.5 Mabsadd L
.45556 .16756 -1.875 0 Mabsadd L closepath F
.45873 .16718 -1.875 0 Mabsadd m
.45873 .16718 0 2.5 Mabsadd L
.45873 .16718 1.875 0 Mabsadd L
.45873 .16718 0 -2.5 Mabsadd L
.45873 .16718 -1.875 0 Mabsadd L closepath F
.4619 .16681 -1.875 0 Mabsadd m
.4619 .16681 0 2.5 Mabsadd L
.4619 .16681 1.875 0 Mabsadd L
.4619 .16681 0 -2.5 Mabsadd L
.4619 .16681 -1.875 0 Mabsadd L closepath F
.46508 .16643 -1.875 0 Mabsadd m
.46508 .16643 0 2.5 Mabsadd L
.46508 .16643 1.875 0 Mabsadd L
.46508 .16643 0 -2.5 Mabsadd L
.46508 .16643 -1.875 0 Mabsadd L closepath F
.46825 .16605 -1.875 0 Mabsadd m
.46825 .16605 0 2.5 Mabsadd L
.46825 .16605 1.875 0 Mabsadd L
.46825 .16605 0 -2.5 Mabsadd L
.46825 .16605 -1.875 0 Mabsadd L closepath F
.47143 .16566 -1.875 0 Mabsadd m
.47143 .16566 0 2.5 Mabsadd L
.47143 .16566 1.875 0 Mabsadd L
.47143 .16566 0 -2.5 Mabsadd L
.47143 .16566 -1.875 0 Mabsadd L closepath F
.4746 .16527 -1.875 0 Mabsadd m
.4746 .16527 0 2.5 Mabsadd L
.4746 .16527 1.875 0 Mabsadd L
.4746 .16527 0 -2.5 Mabsadd L
.4746 .16527 -1.875 0 Mabsadd L closepath F
.47778 .16488 -1.875 0 Mabsadd m
.47778 .16488 0 2.5 Mabsadd L
.47778 .16488 1.875 0 Mabsadd L
.47778 .16488 0 -2.5 Mabsadd L
.47778 .16488 -1.875 0 Mabsadd L closepath F
.48095 .16448 -1.875 0 Mabsadd m
.48095 .16448 0 2.5 Mabsadd L
.48095 .16448 1.875 0 Mabsadd L
.48095 .16448 0 -2.5 Mabsadd L
.48095 .16448 -1.875 0 Mabsadd L closepath F
.48413 .16407 -1.875 0 Mabsadd m
.48413 .16407 0 2.5 Mabsadd L
.48413 .16407 1.875 0 Mabsadd L
.48413 .16407 0 -2.5 Mabsadd L
.48413 .16407 -1.875 0 Mabsadd L closepath F
.4873 .16367 -1.875 0 Mabsadd m
.4873 .16367 0 2.5 Mabsadd L
.4873 .16367 1.875 0 Mabsadd L
.4873 .16367 0 -2.5 Mabsadd L
.4873 .16367 -1.875 0 Mabsadd L closepath F
.49048 .16326 -1.875 0 Mabsadd m
.49048 .16326 0 2.5 Mabsadd L
.49048 .16326 1.875 0 Mabsadd L
.49048 .16326 0 -2.5 Mabsadd L
.49048 .16326 -1.875 0 Mabsadd L closepath F
.49365 .16284 -1.875 0 Mabsadd m
.49365 .16284 0 2.5 Mabsadd L
.49365 .16284 1.875 0 Mabsadd L
.49365 .16284 0 -2.5 Mabsadd L
.49365 .16284 -1.875 0 Mabsadd L closepath F
.49683 .16242 -1.875 0 Mabsadd m
.49683 .16242 0 2.5 Mabsadd L
.49683 .16242 1.875 0 Mabsadd L
.49683 .16242 0 -2.5 Mabsadd L
.49683 .16242 -1.875 0 Mabsadd L closepath F
.5 .162 -1.875 0 Mabsadd m
.5 .162 0 2.5 Mabsadd L
.5 .162 1.875 0 Mabsadd L
.5 .162 0 -2.5 Mabsadd L
.5 .162 -1.875 0 Mabsadd L closepath F
.50317 .16157 -1.875 0 Mabsadd m
.50317 .16157 0 2.5 Mabsadd L
.50317 .16157 1.875 0 Mabsadd L
.50317 .16157 0 -2.5 Mabsadd L
.50317 .16157 -1.875 0 Mabsadd L closepath F
.50635 .16114 -1.875 0 Mabsadd m
.50635 .16114 0 2.5 Mabsadd L
.50635 .16114 1.875 0 Mabsadd L
.50635 .16114 0 -2.5 Mabsadd L
.50635 .16114 -1.875 0 Mabsadd L closepath F
.50952 .16071 -1.875 0 Mabsadd m
.50952 .16071 0 2.5 Mabsadd L
.50952 .16071 1.875 0 Mabsadd L
.50952 .16071 0 -2.5 Mabsadd L
.50952 .16071 -1.875 0 Mabsadd L closepath F
.5127 .16027 -1.875 0 Mabsadd m
.5127 .16027 0 2.5 Mabsadd L
.5127 .16027 1.875 0 Mabsadd L
.5127 .16027 0 -2.5 Mabsadd L
.5127 .16027 -1.875 0 Mabsadd L closepath F
.51587 .15982 -1.875 0 Mabsadd m
.51587 .15982 0 2.5 Mabsadd L
.51587 .15982 1.875 0 Mabsadd L
.51587 .15982 0 -2.5 Mabsadd L
.51587 .15982 -1.875 0 Mabsadd L closepath F
.51905 .15937 -1.875 0 Mabsadd m
.51905 .15937 0 2.5 Mabsadd L
.51905 .15937 1.875 0 Mabsadd L
.51905 .15937 0 -2.5 Mabsadd L
.51905 .15937 -1.875 0 Mabsadd L closepath F
.52222 .15892 -1.875 0 Mabsadd m
.52222 .15892 0 2.5 Mabsadd L
.52222 .15892 1.875 0 Mabsadd L
.52222 .15892 0 -2.5 Mabsadd L
.52222 .15892 -1.875 0 Mabsadd L closepath F
.5254 .15846 -1.875 0 Mabsadd m
.5254 .15846 0 2.5 Mabsadd L
.5254 .15846 1.875 0 Mabsadd L
.5254 .15846 0 -2.5 Mabsadd L
.5254 .15846 -1.875 0 Mabsadd L closepath F
.52857 .158 -1.875 0 Mabsadd m
.52857 .158 0 2.5 Mabsadd L
.52857 .158 1.875 0 Mabsadd L
.52857 .158 0 -2.5 Mabsadd L
.52857 .158 -1.875 0 Mabsadd L closepath F
.53175 .15753 -1.875 0 Mabsadd m
.53175 .15753 0 2.5 Mabsadd L
.53175 .15753 1.875 0 Mabsadd L
.53175 .15753 0 -2.5 Mabsadd L
.53175 .15753 -1.875 0 Mabsadd L closepath F
.53492 .15706 -1.875 0 Mabsadd m
.53492 .15706 0 2.5 Mabsadd L
.53492 .15706 1.875 0 Mabsadd L
.53492 .15706 0 -2.5 Mabsadd L
.53492 .15706 -1.875 0 Mabsadd L closepath F
.5381 .15658 -1.875 0 Mabsadd m
.5381 .15658 0 2.5 Mabsadd L
.5381 .15658 1.875 0 Mabsadd L
.5381 .15658 0 -2.5 Mabsadd L
.5381 .15658 -1.875 0 Mabsadd L closepath F
.54127 .1561 -1.875 0 Mabsadd m
.54127 .1561 0 2.5 Mabsadd L
.54127 .1561 1.875 0 Mabsadd L
.54127 .1561 0 -2.5 Mabsadd L
.54127 .1561 -1.875 0 Mabsadd L closepath F
.54444 .15562 -1.875 0 Mabsadd m
.54444 .15562 0 2.5 Mabsadd L
.54444 .15562 1.875 0 Mabsadd L
.54444 .15562 0 -2.5 Mabsadd L
.54444 .15562 -1.875 0 Mabsadd L closepath F
.54762 .15513 -1.875 0 Mabsadd m
.54762 .15513 0 2.5 Mabsadd L
.54762 .15513 1.875 0 Mabsadd L
.54762 .15513 0 -2.5 Mabsadd L
.54762 .15513 -1.875 0 Mabsadd L closepath F
.55079 .15463 -1.875 0 Mabsadd m
.55079 .15463 0 2.5 Mabsadd L
.55079 .15463 1.875 0 Mabsadd L
.55079 .15463 0 -2.5 Mabsadd L
.55079 .15463 -1.875 0 Mabsadd L closepath F
.55397 .15413 -1.875 0 Mabsadd m
.55397 .15413 0 2.5 Mabsadd L
.55397 .15413 1.875 0 Mabsadd L
.55397 .15413 0 -2.5 Mabsadd L
.55397 .15413 -1.875 0 Mabsadd L closepath F
.55714 .15362 -1.875 0 Mabsadd m
.55714 .15362 0 2.5 Mabsadd L
.55714 .15362 1.875 0 Mabsadd L
.55714 .15362 0 -2.5 Mabsadd L
.55714 .15362 -1.875 0 Mabsadd L closepath F
.56032 .15311 -1.875 0 Mabsadd m
.56032 .15311 0 2.5 Mabsadd L
.56032 .15311 1.875 0 Mabsadd L
.56032 .15311 0 -2.5 Mabsadd L
.56032 .15311 -1.875 0 Mabsadd L closepath F
.56349 .1526 -1.875 0 Mabsadd m
.56349 .1526 0 2.5 Mabsadd L
.56349 .1526 1.875 0 Mabsadd L
.56349 .1526 0 -2.5 Mabsadd L
.56349 .1526 -1.875 0 Mabsadd L closepath F
.56667 .15208 -1.875 0 Mabsadd m
.56667 .15208 0 2.5 Mabsadd L
.56667 .15208 1.875 0 Mabsadd L
.56667 .15208 0 -2.5 Mabsadd L
.56667 .15208 -1.875 0 Mabsadd L closepath F
.56984 .15155 -1.875 0 Mabsadd m
.56984 .15155 0 2.5 Mabsadd L
.56984 .15155 1.875 0 Mabsadd L
.56984 .15155 0 -2.5 Mabsadd L
.56984 .15155 -1.875 0 Mabsadd L closepath F
.57302 .15102 -1.875 0 Mabsadd m
.57302 .15102 0 2.5 Mabsadd L
.57302 .15102 1.875 0 Mabsadd L
.57302 .15102 0 -2.5 Mabsadd L
.57302 .15102 -1.875 0 Mabsadd L closepath F
.57619 .15048 -1.875 0 Mabsadd m
.57619 .15048 0 2.5 Mabsadd L
.57619 .15048 1.875 0 Mabsadd L
.57619 .15048 0 -2.5 Mabsadd L
.57619 .15048 -1.875 0 Mabsadd L closepath F
.57937 .14994 -1.875 0 Mabsadd m
.57937 .14994 0 2.5 Mabsadd L
.57937 .14994 1.875 0 Mabsadd L
.57937 .14994 0 -2.5 Mabsadd L
.57937 .14994 -1.875 0 Mabsadd L closepath F
.58254 .14939 -1.875 0 Mabsadd m
.58254 .14939 0 2.5 Mabsadd L
.58254 .14939 1.875 0 Mabsadd L
.58254 .14939 0 -2.5 Mabsadd L
.58254 .14939 -1.875 0 Mabsadd L closepath F
.58571 .14884 -1.875 0 Mabsadd m
.58571 .14884 0 2.5 Mabsadd L
.58571 .14884 1.875 0 Mabsadd L
.58571 .14884 0 -2.5 Mabsadd L
.58571 .14884 -1.875 0 Mabsadd L closepath F
.58889 .14828 -1.875 0 Mabsadd m
.58889 .14828 0 2.5 Mabsadd L
.58889 .14828 1.875 0 Mabsadd L
.58889 .14828 0 -2.5 Mabsadd L
.58889 .14828 -1.875 0 Mabsadd L closepath F
.59206 .14771 -1.875 0 Mabsadd m
.59206 .14771 0 2.5 Mabsadd L
.59206 .14771 1.875 0 Mabsadd L
.59206 .14771 0 -2.5 Mabsadd L
.59206 .14771 -1.875 0 Mabsadd L closepath F
.59524 .14714 -1.875 0 Mabsadd m
.59524 .14714 0 2.5 Mabsadd L
.59524 .14714 1.875 0 Mabsadd L
.59524 .14714 0 -2.5 Mabsadd L
.59524 .14714 -1.875 0 Mabsadd L closepath F
.59841 .14657 -1.875 0 Mabsadd m
.59841 .14657 0 2.5 Mabsadd L
.59841 .14657 1.875 0 Mabsadd L
.59841 .14657 0 -2.5 Mabsadd L
.59841 .14657 -1.875 0 Mabsadd L closepath F
.60159 .14599 -1.875 0 Mabsadd m
.60159 .14599 0 2.5 Mabsadd L
.60159 .14599 1.875 0 Mabsadd L
.60159 .14599 0 -2.5 Mabsadd L
.60159 .14599 -1.875 0 Mabsadd L closepath F
.60476 .1454 -1.875 0 Mabsadd m
.60476 .1454 0 2.5 Mabsadd L
.60476 .1454 1.875 0 Mabsadd L
.60476 .1454 0 -2.5 Mabsadd L
.60476 .1454 -1.875 0 Mabsadd L closepath F
.60794 .14481 -1.875 0 Mabsadd m
.60794 .14481 0 2.5 Mabsadd L
.60794 .14481 1.875 0 Mabsadd L
.60794 .14481 0 -2.5 Mabsadd L
.60794 .14481 -1.875 0 Mabsadd L closepath F
.61111 .14421 -1.875 0 Mabsadd m
.61111 .14421 0 2.5 Mabsadd L
.61111 .14421 1.875 0 Mabsadd L
.61111 .14421 0 -2.5 Mabsadd L
.61111 .14421 -1.875 0 Mabsadd L closepath F
.61429 .1436 -1.875 0 Mabsadd m
.61429 .1436 0 2.5 Mabsadd L
.61429 .1436 1.875 0 Mabsadd L
.61429 .1436 0 -2.5 Mabsadd L
.61429 .1436 -1.875 0 Mabsadd L closepath F
.61746 .14299 -1.875 0 Mabsadd m
.61746 .14299 0 2.5 Mabsadd L
.61746 .14299 1.875 0 Mabsadd L
.61746 .14299 0 -2.5 Mabsadd L
.61746 .14299 -1.875 0 Mabsadd L closepath F
.62063 .14237 -1.875 0 Mabsadd m
.62063 .14237 0 2.5 Mabsadd L
.62063 .14237 1.875 0 Mabsadd L
.62063 .14237 0 -2.5 Mabsadd L
.62063 .14237 -1.875 0 Mabsadd L closepath F
.62381 .14175 -1.875 0 Mabsadd m
.62381 .14175 0 2.5 Mabsadd L
.62381 .14175 1.875 0 Mabsadd L
.62381 .14175 0 -2.5 Mabsadd L
.62381 .14175 -1.875 0 Mabsadd L closepath F
.62698 .14112 -1.875 0 Mabsadd m
.62698 .14112 0 2.5 Mabsadd L
.62698 .14112 1.875 0 Mabsadd L
.62698 .14112 0 -2.5 Mabsadd L
.62698 .14112 -1.875 0 Mabsadd L closepath F
.63016 .14049 -1.875 0 Mabsadd m
.63016 .14049 0 2.5 Mabsadd L
.63016 .14049 1.875 0 Mabsadd L
.63016 .14049 0 -2.5 Mabsadd L
.63016 .14049 -1.875 0 Mabsadd L closepath F
.63333 .13984 -1.875 0 Mabsadd m
.63333 .13984 0 2.5 Mabsadd L
.63333 .13984 1.875 0 Mabsadd L
.63333 .13984 0 -2.5 Mabsadd L
.63333 .13984 -1.875 0 Mabsadd L closepath F
.63651 .13919 -1.875 0 Mabsadd m
.63651 .13919 0 2.5 Mabsadd L
.63651 .13919 1.875 0 Mabsadd L
.63651 .13919 0 -2.5 Mabsadd L
.63651 .13919 -1.875 0 Mabsadd L closepath F
.63968 .13854 -1.875 0 Mabsadd m
.63968 .13854 0 2.5 Mabsadd L
.63968 .13854 1.875 0 Mabsadd L
.63968 .13854 0 -2.5 Mabsadd L
.63968 .13854 -1.875 0 Mabsadd L closepath F
.64286 .13788 -1.875 0 Mabsadd m
.64286 .13788 0 2.5 Mabsadd L
.64286 .13788 1.875 0 Mabsadd L
.64286 .13788 0 -2.5 Mabsadd L
.64286 .13788 -1.875 0 Mabsadd L closepath F
.64603 .13721 -1.875 0 Mabsadd m
.64603 .13721 0 2.5 Mabsadd L
.64603 .13721 1.875 0 Mabsadd L
.64603 .13721 0 -2.5 Mabsadd L
.64603 .13721 -1.875 0 Mabsadd L closepath F
.64921 .13653 -1.875 0 Mabsadd m
.64921 .13653 0 2.5 Mabsadd L
.64921 .13653 1.875 0 Mabsadd L
.64921 .13653 0 -2.5 Mabsadd L
.64921 .13653 -1.875 0 Mabsadd L closepath F
.65238 .13585 -1.875 0 Mabsadd m
.65238 .13585 0 2.5 Mabsadd L
.65238 .13585 1.875 0 Mabsadd L
.65238 .13585 0 -2.5 Mabsadd L
.65238 .13585 -1.875 0 Mabsadd L closepath F
.65556 .13516 -1.875 0 Mabsadd m
.65556 .13516 0 2.5 Mabsadd L
.65556 .13516 1.875 0 Mabsadd L
.65556 .13516 0 -2.5 Mabsadd L
.65556 .13516 -1.875 0 Mabsadd L closepath F
.65873 .13447 -1.875 0 Mabsadd m
.65873 .13447 0 2.5 Mabsadd L
.65873 .13447 1.875 0 Mabsadd L
.65873 .13447 0 -2.5 Mabsadd L
.65873 .13447 -1.875 0 Mabsadd L closepath F
.6619 .13377 -1.875 0 Mabsadd m
.6619 .13377 0 2.5 Mabsadd L
.6619 .13377 1.875 0 Mabsadd L
.6619 .13377 0 -2.5 Mabsadd L
.6619 .13377 -1.875 0 Mabsadd L closepath F
.66508 .13306 -1.875 0 Mabsadd m
.66508 .13306 0 2.5 Mabsadd L
.66508 .13306 1.875 0 Mabsadd L
.66508 .13306 0 -2.5 Mabsadd L
.66508 .13306 -1.875 0 Mabsadd L closepath F
.66825 .13234 -1.875 0 Mabsadd m
.66825 .13234 0 2.5 Mabsadd L
.66825 .13234 1.875 0 Mabsadd L
.66825 .13234 0 -2.5 Mabsadd L
.66825 .13234 -1.875 0 Mabsadd L closepath F
.67143 .13162 -1.875 0 Mabsadd m
.67143 .13162 0 2.5 Mabsadd L
.67143 .13162 1.875 0 Mabsadd L
.67143 .13162 0 -2.5 Mabsadd L
.67143 .13162 -1.875 0 Mabsadd L closepath F
.6746 .13089 -1.875 0 Mabsadd m
.6746 .13089 0 2.5 Mabsadd L
.6746 .13089 1.875 0 Mabsadd L
.6746 .13089 0 -2.5 Mabsadd L
.6746 .13089 -1.875 0 Mabsadd L closepath F
.67778 .13015 -1.875 0 Mabsadd m
.67778 .13015 0 2.5 Mabsadd L
.67778 .13015 1.875 0 Mabsadd L
.67778 .13015 0 -2.5 Mabsadd L
.67778 .13015 -1.875 0 Mabsadd L closepath F
.68095 .1294 -1.875 0 Mabsadd m
.68095 .1294 0 2.5 Mabsadd L
.68095 .1294 1.875 0 Mabsadd L
.68095 .1294 0 -2.5 Mabsadd L
.68095 .1294 -1.875 0 Mabsadd L closepath F
.68413 .12865 -1.875 0 Mabsadd m
.68413 .12865 0 2.5 Mabsadd L
.68413 .12865 1.875 0 Mabsadd L
.68413 .12865 0 -2.5 Mabsadd L
.68413 .12865 -1.875 0 Mabsadd L closepath F
.6873 .12789 -1.875 0 Mabsadd m
.6873 .12789 0 2.5 Mabsadd L
.6873 .12789 1.875 0 Mabsadd L
.6873 .12789 0 -2.5 Mabsadd L
.6873 .12789 -1.875 0 Mabsadd L closepath F
.69048 .12712 -1.875 0 Mabsadd m
.69048 .12712 0 2.5 Mabsadd L
.69048 .12712 1.875 0 Mabsadd L
.69048 .12712 0 -2.5 Mabsadd L
.69048 .12712 -1.875 0 Mabsadd L closepath F
.69365 .12634 -1.875 0 Mabsadd m
.69365 .12634 0 2.5 Mabsadd L
.69365 .12634 1.875 0 Mabsadd L
.69365 .12634 0 -2.5 Mabsadd L
.69365 .12634 -1.875 0 Mabsadd L closepath F
.69683 .12556 -1.875 0 Mabsadd m
.69683 .12556 0 2.5 Mabsadd L
.69683 .12556 1.875 0 Mabsadd L
.69683 .12556 0 -2.5 Mabsadd L
.69683 .12556 -1.875 0 Mabsadd L closepath F
.7 .12477 -1.875 0 Mabsadd m
.7 .12477 0 2.5 Mabsadd L
.7 .12477 1.875 0 Mabsadd L
.7 .12477 0 -2.5 Mabsadd L
.7 .12477 -1.875 0 Mabsadd L closepath F
.70317 .12397 -1.875 0 Mabsadd m
.70317 .12397 0 2.5 Mabsadd L
.70317 .12397 1.875 0 Mabsadd L
.70317 .12397 0 -2.5 Mabsadd L
.70317 .12397 -1.875 0 Mabsadd L closepath F
.70635 .12316 -1.875 0 Mabsadd m
.70635 .12316 0 2.5 Mabsadd L
.70635 .12316 1.875 0 Mabsadd L
.70635 .12316 0 -2.5 Mabsadd L
.70635 .12316 -1.875 0 Mabsadd L closepath F
.70952 .12235 -1.875 0 Mabsadd m
.70952 .12235 0 2.5 Mabsadd L
.70952 .12235 1.875 0 Mabsadd L
.70952 .12235 0 -2.5 Mabsadd L
.70952 .12235 -1.875 0 Mabsadd L closepath F
.7127 .12152 -1.875 0 Mabsadd m
.7127 .12152 0 2.5 Mabsadd L
.7127 .12152 1.875 0 Mabsadd L
.7127 .12152 0 -2.5 Mabsadd L
.7127 .12152 -1.875 0 Mabsadd L closepath F
.71587 .12069 -1.875 0 Mabsadd m
.71587 .12069 0 2.5 Mabsadd L
.71587 .12069 1.875 0 Mabsadd L
.71587 .12069 0 -2.5 Mabsadd L
.71587 .12069 -1.875 0 Mabsadd L closepath F
.71905 .11985 -1.875 0 Mabsadd m
.71905 .11985 0 2.5 Mabsadd L
.71905 .11985 1.875 0 Mabsadd L
.71905 .11985 0 -2.5 Mabsadd L
.71905 .11985 -1.875 0 Mabsadd L closepath F
.72222 .119 -1.875 0 Mabsadd m
.72222 .119 0 2.5 Mabsadd L
.72222 .119 1.875 0 Mabsadd L
.72222 .119 0 -2.5 Mabsadd L
.72222 .119 -1.875 0 Mabsadd L closepath F
.7254 .11814 -1.875 0 Mabsadd m
.7254 .11814 0 2.5 Mabsadd L
.7254 .11814 1.875 0 Mabsadd L
.7254 .11814 0 -2.5 Mabsadd L
.7254 .11814 -1.875 0 Mabsadd L closepath F
.72857 .11728 -1.875 0 Mabsadd m
.72857 .11728 0 2.5 Mabsadd L
.72857 .11728 1.875 0 Mabsadd L
.72857 .11728 0 -2.5 Mabsadd L
.72857 .11728 -1.875 0 Mabsadd L closepath F
.73175 .1164 -1.875 0 Mabsadd m
.73175 .1164 0 2.5 Mabsadd L
.73175 .1164 1.875 0 Mabsadd L
.73175 .1164 0 -2.5 Mabsadd L
.73175 .1164 -1.875 0 Mabsadd L closepath F
.73492 .11552 -1.875 0 Mabsadd m
.73492 .11552 0 2.5 Mabsadd L
.73492 .11552 1.875 0 Mabsadd L
.73492 .11552 0 -2.5 Mabsadd L
.73492 .11552 -1.875 0 Mabsadd L closepath F
.7381 .11463 -1.875 0 Mabsadd m
.7381 .11463 0 2.5 Mabsadd L
.7381 .11463 1.875 0 Mabsadd L
.7381 .11463 0 -2.5 Mabsadd L
.7381 .11463 -1.875 0 Mabsadd L closepath F
.74127 .11373 -1.875 0 Mabsadd m
.74127 .11373 0 2.5 Mabsadd L
.74127 .11373 1.875 0 Mabsadd L
.74127 .11373 0 -2.5 Mabsadd L
.74127 .11373 -1.875 0 Mabsadd L closepath F
.74444 .11282 -1.875 0 Mabsadd m
.74444 .11282 0 2.5 Mabsadd L
.74444 .11282 1.875 0 Mabsadd L
.74444 .11282 0 -2.5 Mabsadd L
.74444 .11282 -1.875 0 Mabsadd L closepath F
.74762 .1119 -1.875 0 Mabsadd m
.74762 .1119 0 2.5 Mabsadd L
.74762 .1119 1.875 0 Mabsadd L
.74762 .1119 0 -2.5 Mabsadd L
.74762 .1119 -1.875 0 Mabsadd L closepath F
.75079 .11097 -1.875 0 Mabsadd m
.75079 .11097 0 2.5 Mabsadd L
.75079 .11097 1.875 0 Mabsadd L
.75079 .11097 0 -2.5 Mabsadd L
.75079 .11097 -1.875 0 Mabsadd L closepath F
.75397 .11003 -1.875 0 Mabsadd m
.75397 .11003 0 2.5 Mabsadd L
.75397 .11003 1.875 0 Mabsadd L
.75397 .11003 0 -2.5 Mabsadd L
.75397 .11003 -1.875 0 Mabsadd L closepath F
.75714 .10909 -1.875 0 Mabsadd m
.75714 .10909 0 2.5 Mabsadd L
.75714 .10909 1.875 0 Mabsadd L
.75714 .10909 0 -2.5 Mabsadd L
.75714 .10909 -1.875 0 Mabsadd L closepath F
.76032 .10813 -1.875 0 Mabsadd m
.76032 .10813 0 2.5 Mabsadd L
.76032 .10813 1.875 0 Mabsadd L
.76032 .10813 0 -2.5 Mabsadd L
.76032 .10813 -1.875 0 Mabsadd L closepath F
.76349 .10717 -1.875 0 Mabsadd m
.76349 .10717 0 2.5 Mabsadd L
.76349 .10717 1.875 0 Mabsadd L
.76349 .10717 0 -2.5 Mabsadd L
.76349 .10717 -1.875 0 Mabsadd L closepath F
.76667 .10619 -1.875 0 Mabsadd m
.76667 .10619 0 2.5 Mabsadd L
.76667 .10619 1.875 0 Mabsadd L
.76667 .10619 0 -2.5 Mabsadd L
.76667 .10619 -1.875 0 Mabsadd L closepath F
.76984 .1052 -1.875 0 Mabsadd m
.76984 .1052 0 2.5 Mabsadd L
.76984 .1052 1.875 0 Mabsadd L
.76984 .1052 0 -2.5 Mabsadd L
.76984 .1052 -1.875 0 Mabsadd L closepath F
.77302 .10421 -1.875 0 Mabsadd m
.77302 .10421 0 2.5 Mabsadd L
.77302 .10421 1.875 0 Mabsadd L
.77302 .10421 0 -2.5 Mabsadd L
.77302 .10421 -1.875 0 Mabsadd L closepath F
.77619 .1032 -1.875 0 Mabsadd m
.77619 .1032 0 2.5 Mabsadd L
.77619 .1032 1.875 0 Mabsadd L
.77619 .1032 0 -2.5 Mabsadd L
.77619 .1032 -1.875 0 Mabsadd L closepath F
.77937 .10219 -1.875 0 Mabsadd m
.77937 .10219 0 2.5 Mabsadd L
.77937 .10219 1.875 0 Mabsadd L
.77937 .10219 0 -2.5 Mabsadd L
.77937 .10219 -1.875 0 Mabsadd L closepath F
.78254 .10116 -1.875 0 Mabsadd m
.78254 .10116 0 2.5 Mabsadd L
.78254 .10116 1.875 0 Mabsadd L
.78254 .10116 0 -2.5 Mabsadd L
.78254 .10116 -1.875 0 Mabsadd L closepath F
.78571 .10013 -1.875 0 Mabsadd m
.78571 .10013 0 2.5 Mabsadd L
.78571 .10013 1.875 0 Mabsadd L
.78571 .10013 0 -2.5 Mabsadd L
.78571 .10013 -1.875 0 Mabsadd L closepath F
.78889 .09908 -1.875 0 Mabsadd m
.78889 .09908 0 2.5 Mabsadd L
.78889 .09908 1.875 0 Mabsadd L
.78889 .09908 0 -2.5 Mabsadd L
.78889 .09908 -1.875 0 Mabsadd L closepath F
.79206 .09803 -1.875 0 Mabsadd m
.79206 .09803 0 2.5 Mabsadd L
.79206 .09803 1.875 0 Mabsadd L
.79206 .09803 0 -2.5 Mabsadd L
.79206 .09803 -1.875 0 Mabsadd L closepath F
.79524 .09696 -1.875 0 Mabsadd m
.79524 .09696 0 2.5 Mabsadd L
.79524 .09696 1.875 0 Mabsadd L
.79524 .09696 0 -2.5 Mabsadd L
.79524 .09696 -1.875 0 Mabsadd L closepath F
.79841 .09588 -1.875 0 Mabsadd m
.79841 .09588 0 2.5 Mabsadd L
.79841 .09588 1.875 0 Mabsadd L
.79841 .09588 0 -2.5 Mabsadd L
.79841 .09588 -1.875 0 Mabsadd L closepath F
.80159 .09479 -1.875 0 Mabsadd m
.80159 .09479 0 2.5 Mabsadd L
.80159 .09479 1.875 0 Mabsadd L
.80159 .09479 0 -2.5 Mabsadd L
.80159 .09479 -1.875 0 Mabsadd L closepath F
.80476 .09369 -1.875 0 Mabsadd m
.80476 .09369 0 2.5 Mabsadd L
.80476 .09369 1.875 0 Mabsadd L
.80476 .09369 0 -2.5 Mabsadd L
.80476 .09369 -1.875 0 Mabsadd L closepath F
.80794 .09258 -1.875 0 Mabsadd m
.80794 .09258 0 2.5 Mabsadd L
.80794 .09258 1.875 0 Mabsadd L
.80794 .09258 0 -2.5 Mabsadd L
.80794 .09258 -1.875 0 Mabsadd L closepath F
.81111 .09146 -1.875 0 Mabsadd m
.81111 .09146 0 2.5 Mabsadd L
.81111 .09146 1.875 0 Mabsadd L
.81111 .09146 0 -2.5 Mabsadd L
.81111 .09146 -1.875 0 Mabsadd L closepath F
.81429 .09033 -1.875 0 Mabsadd m
.81429 .09033 0 2.5 Mabsadd L
.81429 .09033 1.875 0 Mabsadd L
.81429 .09033 0 -2.5 Mabsadd L
.81429 .09033 -1.875 0 Mabsadd L closepath F
.81746 .08919 -1.875 0 Mabsadd m
.81746 .08919 0 2.5 Mabsadd L
.81746 .08919 1.875 0 Mabsadd L
.81746 .08919 0 -2.5 Mabsadd L
.81746 .08919 -1.875 0 Mabsadd L closepath F
.82063 .08803 -1.875 0 Mabsadd m
.82063 .08803 0 2.5 Mabsadd L
.82063 .08803 1.875 0 Mabsadd L
.82063 .08803 0 -2.5 Mabsadd L
.82063 .08803 -1.875 0 Mabsadd L closepath F
.82381 .08686 -1.875 0 Mabsadd m
.82381 .08686 0 2.5 Mabsadd L
.82381 .08686 1.875 0 Mabsadd L
.82381 .08686 0 -2.5 Mabsadd L
.82381 .08686 -1.875 0 Mabsadd L closepath F
.82698 .08569 -1.875 0 Mabsadd m
.82698 .08569 0 2.5 Mabsadd L
.82698 .08569 1.875 0 Mabsadd L
.82698 .08569 0 -2.5 Mabsadd L
.82698 .08569 -1.875 0 Mabsadd L closepath F
.83016 .0845 -1.875 0 Mabsadd m
.83016 .0845 0 2.5 Mabsadd L
.83016 .0845 1.875 0 Mabsadd L
.83016 .0845 0 -2.5 Mabsadd L
.83016 .0845 -1.875 0 Mabsadd L closepath F
.83333 .08329 -1.875 0 Mabsadd m
.83333 .08329 0 2.5 Mabsadd L
.83333 .08329 1.875 0 Mabsadd L
.83333 .08329 0 -2.5 Mabsadd L
.83333 .08329 -1.875 0 Mabsadd L closepath F
.83651 .08208 -1.875 0 Mabsadd m
.83651 .08208 0 2.5 Mabsadd L
.83651 .08208 1.875 0 Mabsadd L
.83651 .08208 0 -2.5 Mabsadd L
.83651 .08208 -1.875 0 Mabsadd L closepath F
.83968 .08085 -1.875 0 Mabsadd m
.83968 .08085 0 2.5 Mabsadd L
.83968 .08085 1.875 0 Mabsadd L
.83968 .08085 0 -2.5 Mabsadd L
.83968 .08085 -1.875 0 Mabsadd L closepath F
.84286 .07961 -1.875 0 Mabsadd m
.84286 .07961 0 2.5 Mabsadd L
.84286 .07961 1.875 0 Mabsadd L
.84286 .07961 0 -2.5 Mabsadd L
.84286 .07961 -1.875 0 Mabsadd L closepath F
.84603 .07836 -1.875 0 Mabsadd m
.84603 .07836 0 2.5 Mabsadd L
.84603 .07836 1.875 0 Mabsadd L
.84603 .07836 0 -2.5 Mabsadd L
.84603 .07836 -1.875 0 Mabsadd L closepath F
.84921 .0771 -1.875 0 Mabsadd m
.84921 .0771 0 2.5 Mabsadd L
.84921 .0771 1.875 0 Mabsadd L
.84921 .0771 0 -2.5 Mabsadd L
.84921 .0771 -1.875 0 Mabsadd L closepath F
.85238 .07582 -1.875 0 Mabsadd m
.85238 .07582 0 2.5 Mabsadd L
.85238 .07582 1.875 0 Mabsadd L
.85238 .07582 0 -2.5 Mabsadd L
.85238 .07582 -1.875 0 Mabsadd L closepath F
.85556 .07454 -1.875 0 Mabsadd m
.85556 .07454 0 2.5 Mabsadd L
.85556 .07454 1.875 0 Mabsadd L
.85556 .07454 0 -2.5 Mabsadd L
.85556 .07454 -1.875 0 Mabsadd L closepath F
.85873 .07323 -1.875 0 Mabsadd m
.85873 .07323 0 2.5 Mabsadd L
.85873 .07323 1.875 0 Mabsadd L
.85873 .07323 0 -2.5 Mabsadd L
.85873 .07323 -1.875 0 Mabsadd L closepath F
.8619 .07192 -1.875 0 Mabsadd m
.8619 .07192 0 2.5 Mabsadd L
.8619 .07192 1.875 0 Mabsadd L
.8619 .07192 0 -2.5 Mabsadd L
.8619 .07192 -1.875 0 Mabsadd L closepath F
.86508 .07059 -1.875 0 Mabsadd m
.86508 .07059 0 2.5 Mabsadd L
.86508 .07059 1.875 0 Mabsadd L
.86508 .07059 0 -2.5 Mabsadd L
.86508 .07059 -1.875 0 Mabsadd L closepath F
.86825 .06925 -1.875 0 Mabsadd m
.86825 .06925 0 2.5 Mabsadd L
.86825 .06925 1.875 0 Mabsadd L
.86825 .06925 0 -2.5 Mabsadd L
.86825 .06925 -1.875 0 Mabsadd L closepath F
.87143 .06789 -1.875 0 Mabsadd m
.87143 .06789 0 2.5 Mabsadd L
.87143 .06789 1.875 0 Mabsadd L
.87143 .06789 0 -2.5 Mabsadd L
.87143 .06789 -1.875 0 Mabsadd L closepath F
.8746 .06653 -1.875 0 Mabsadd m
.8746 .06653 0 2.5 Mabsadd L
.8746 .06653 1.875 0 Mabsadd L
.8746 .06653 0 -2.5 Mabsadd L
.8746 .06653 -1.875 0 Mabsadd L closepath F
.87778 .06514 -1.875 0 Mabsadd m
.87778 .06514 0 2.5 Mabsadd L
.87778 .06514 1.875 0 Mabsadd L
.87778 .06514 0 -2.5 Mabsadd L
.87778 .06514 -1.875 0 Mabsadd L closepath F
.88095 .06375 -1.875 0 Mabsadd m
.88095 .06375 0 2.5 Mabsadd L
.88095 .06375 1.875 0 Mabsadd L
.88095 .06375 0 -2.5 Mabsadd L
.88095 .06375 -1.875 0 Mabsadd L closepath F
.88413 .06234 -1.875 0 Mabsadd m
.88413 .06234 0 2.5 Mabsadd L
.88413 .06234 1.875 0 Mabsadd L
.88413 .06234 0 -2.5 Mabsadd L
.88413 .06234 -1.875 0 Mabsadd L closepath F
.8873 .06092 -1.875 0 Mabsadd m
.8873 .06092 0 2.5 Mabsadd L
.8873 .06092 1.875 0 Mabsadd L
.8873 .06092 0 -2.5 Mabsadd L
.8873 .06092 -1.875 0 Mabsadd L closepath F
.89048 .05948 -1.875 0 Mabsadd m
.89048 .05948 0 2.5 Mabsadd L
.89048 .05948 1.875 0 Mabsadd L
.89048 .05948 0 -2.5 Mabsadd L
.89048 .05948 -1.875 0 Mabsadd L closepath F
.89365 .05803 -1.875 0 Mabsadd m
.89365 .05803 0 2.5 Mabsadd L
.89365 .05803 1.875 0 Mabsadd L
.89365 .05803 0 -2.5 Mabsadd L
.89365 .05803 -1.875 0 Mabsadd L closepath F
.89683 .05656 -1.875 0 Mabsadd m
.89683 .05656 0 2.5 Mabsadd L
.89683 .05656 1.875 0 Mabsadd L
.89683 .05656 0 -2.5 Mabsadd L
.89683 .05656 -1.875 0 Mabsadd L closepath F
.9 .05508 -1.875 0 Mabsadd m
.9 .05508 0 2.5 Mabsadd L
.9 .05508 1.875 0 Mabsadd L
.9 .05508 0 -2.5 Mabsadd L
.9 .05508 -1.875 0 Mabsadd L closepath F
.90317 .05358 -1.875 0 Mabsadd m
.90317 .05358 0 2.5 Mabsadd L
.90317 .05358 1.875 0 Mabsadd L
.90317 .05358 0 -2.5 Mabsadd L
.90317 .05358 -1.875 0 Mabsadd L closepath F
.90635 .05207 -1.875 0 Mabsadd m
.90635 .05207 0 2.5 Mabsadd L
.90635 .05207 1.875 0 Mabsadd L
.90635 .05207 0 -2.5 Mabsadd L
.90635 .05207 -1.875 0 Mabsadd L closepath F
.90952 .05054 -1.875 0 Mabsadd m
.90952 .05054 0 2.5 Mabsadd L
.90952 .05054 1.875 0 Mabsadd L
.90952 .05054 0 -2.5 Mabsadd L
.90952 .05054 -1.875 0 Mabsadd L closepath F
.9127 .049 -1.875 0 Mabsadd m
.9127 .049 0 2.5 Mabsadd L
.9127 .049 1.875 0 Mabsadd L
.9127 .049 0 -2.5 Mabsadd L
.9127 .049 -1.875 0 Mabsadd L closepath F
.91587 .04744 -1.875 0 Mabsadd m
.91587 .04744 0 2.5 Mabsadd L
.91587 .04744 1.875 0 Mabsadd L
.91587 .04744 0 -2.5 Mabsadd L
.91587 .04744 -1.875 0 Mabsadd L closepath F
.91905 .04587 -1.875 0 Mabsadd m
.91905 .04587 0 2.5 Mabsadd L
.91905 .04587 1.875 0 Mabsadd L
.91905 .04587 0 -2.5 Mabsadd L
.91905 .04587 -1.875 0 Mabsadd L closepath F
.92222 .04428 -1.875 0 Mabsadd m
.92222 .04428 0 2.5 Mabsadd L
.92222 .04428 1.875 0 Mabsadd L
.92222 .04428 0 -2.5 Mabsadd L
.92222 .04428 -1.875 0 Mabsadd L closepath F
.9254 .04268 -1.875 0 Mabsadd m
.9254 .04268 0 2.5 Mabsadd L
.9254 .04268 1.875 0 Mabsadd L
.9254 .04268 0 -2.5 Mabsadd L
.9254 .04268 -1.875 0 Mabsadd L closepath F
.92857 .04106 -1.875 0 Mabsadd m
.92857 .04106 0 2.5 Mabsadd L
.92857 .04106 1.875 0 Mabsadd L
.92857 .04106 0 -2.5 Mabsadd L
.92857 .04106 -1.875 0 Mabsadd L closepath F
.93175 .03942 -1.875 0 Mabsadd m
.93175 .03942 0 2.5 Mabsadd L
.93175 .03942 1.875 0 Mabsadd L
.93175 .03942 0 -2.5 Mabsadd L
.93175 .03942 -1.875 0 Mabsadd L closepath F
.93492 .03777 -1.875 0 Mabsadd m
.93492 .03777 0 2.5 Mabsadd L
.93492 .03777 1.875 0 Mabsadd L
.93492 .03777 0 -2.5 Mabsadd L
.93492 .03777 -1.875 0 Mabsadd L closepath F
.9381 .0361 -1.875 0 Mabsadd m
.9381 .0361 0 2.5 Mabsadd L
.9381 .0361 1.875 0 Mabsadd L
.9381 .0361 0 -2.5 Mabsadd L
.9381 .0361 -1.875 0 Mabsadd L closepath F
.94127 .03441 -1.875 0 Mabsadd m
.94127 .03441 0 2.5 Mabsadd L
.94127 .03441 1.875 0 Mabsadd L
.94127 .03441 0 -2.5 Mabsadd L
.94127 .03441 -1.875 0 Mabsadd L closepath F
.94444 .03271 -1.875 0 Mabsadd m
.94444 .03271 0 2.5 Mabsadd L
.94444 .03271 1.875 0 Mabsadd L
.94444 .03271 0 -2.5 Mabsadd L
.94444 .03271 -1.875 0 Mabsadd L closepath F
.94762 .03099 -1.875 0 Mabsadd m
.94762 .03099 0 2.5 Mabsadd L
.94762 .03099 1.875 0 Mabsadd L
.94762 .03099 0 -2.5 Mabsadd L
.94762 .03099 -1.875 0 Mabsadd L closepath F
.95079 .02925 -1.875 0 Mabsadd m
.95079 .02925 0 2.5 Mabsadd L
.95079 .02925 1.875 0 Mabsadd L
.95079 .02925 0 -2.5 Mabsadd L
.95079 .02925 -1.875 0 Mabsadd L closepath F
.95397 .0275 -1.875 0 Mabsadd m
.95397 .0275 0 2.5 Mabsadd L
.95397 .0275 1.875 0 Mabsadd L
.95397 .0275 0 -2.5 Mabsadd L
.95397 .0275 -1.875 0 Mabsadd L closepath F
.95714 .02573 -1.875 0 Mabsadd m
.95714 .02573 0 2.5 Mabsadd L
.95714 .02573 1.875 0 Mabsadd L
.95714 .02573 0 -2.5 Mabsadd L
.95714 .02573 -1.875 0 Mabsadd L closepath F
.96032 .02394 -1.875 0 Mabsadd m
.96032 .02394 0 2.5 Mabsadd L
.96032 .02394 1.875 0 Mabsadd L
.96032 .02394 0 -2.5 Mabsadd L
.96032 .02394 -1.875 0 Mabsadd L closepath F
.96349 .02213 -1.875 0 Mabsadd m
.96349 .02213 0 2.5 Mabsadd L
.96349 .02213 1.875 0 Mabsadd L
.96349 .02213 0 -2.5 Mabsadd L
.96349 .02213 -1.875 0 Mabsadd L closepath F
.96667 .0203 -1.875 0 Mabsadd m
.96667 .0203 0 2.5 Mabsadd L
.96667 .0203 1.875 0 Mabsadd L
.96667 .0203 0 -2.5 Mabsadd L
.96667 .0203 -1.875 0 Mabsadd L closepath F
.96984 .01846 -1.875 0 Mabsadd m
.96984 .01846 0 2.5 Mabsadd L
.96984 .01846 1.875 0 Mabsadd L
.96984 .01846 0 -2.5 Mabsadd L
.96984 .01846 -1.875 0 Mabsadd L closepath F
.97302 .0166 -1.875 0 Mabsadd m
.97302 .0166 0 2.5 Mabsadd L
.97302 .0166 1.875 0 Mabsadd L
.97302 .0166 0 -2.5 Mabsadd L
.97302 .0166 -1.875 0 Mabsadd L closepath F
.97619 .01472 -1.875 0 Mabsadd m
.97619 .01472 0 2.5 Mabsadd L
.97619 .01472 1.875 0 Mabsadd L
.97619 .01472 0 -2.5 Mabsadd L
.97619 .01472 -1.875 0 Mabsadd L closepath F
.0075 w
.02698 .21441 m
.03016 .21451 L
.03333 .2146 L
.03651 .2147 L
.03968 .2148 L
.04286 .2149 L
.04603 .21501 L
.04921 .21511 L
.05238 .21521 L
.05556 .21532 L
.05873 .21542 L
.0619 .21553 L
.06508 .21564 L
.06825 .21575 L
.07143 .21586 L
.0746 .21597 L
.07778 .21608 L
.08095 .2162 L
.08413 .21631 L
.0873 .21643 L
.09048 .21655 L
.09365 .21666 L
.09683 .21678 L
.1 .2169 L
.10317 .21703 L
.10635 .21715 L
.10952 .21727 L
.1127 .2174 L
.11587 .21753 L
.11905 .21765 L
.12222 .21778 L
.1254 .21791 L
.12857 .21805 L
.13175 .21818 L
.13492 .21831 L
.1381 .21845 L
.14127 .21859 L
.14444 .21873 L
.14762 .21887 L
.15079 .21901 L
.15397 .21915 L
.15714 .2193 L
.16032 .21944 L
.16349 .21959 L
.16667 .21974 L
.16984 .21989 L
.17302 .22004 L
.17619 .22019 L
.17937 .22035 L
.18254 .2205 L
Mistroke
.18571 .22066 L
.18889 .22082 L
.19206 .22098 L
.19524 .22114 L
.19841 .22131 L
.20159 .22147 L
.20476 .22164 L
.20794 .22181 L
.21111 .22198 L
.21429 .22216 L
.21746 .22233 L
.22063 .22251 L
.22381 .22268 L
.22698 .22286 L
.23016 .22305 L
.23333 .22323 L
.23651 .22341 L
.23968 .2236 L
.24286 .22379 L
.24603 .22398 L
.24921 .22417 L
.25238 .22437 L
.25556 .22456 L
.25873 .22476 L
.2619 .22496 L
.26508 .22517 L
.26825 .22537 L
.27143 .22558 L
.2746 .22579 L
.27778 .226 L
.28095 .22621 L
.28413 .22642 L
.2873 .22664 L
.29048 .22686 L
.29365 .22708 L
.29683 .22731 L
.3 .22753 L
.30317 .22776 L
.30635 .22799 L
.30952 .22822 L
.3127 .22846 L
.31587 .2287 L
.31905 .22894 L
.32222 .22918 L
.3254 .22942 L
.32857 .22967 L
.33175 .22992 L
.33492 .23017 L
.3381 .23043 L
.34127 .23068 L
Mistroke
.34444 .23094 L
.34762 .2312 L
.35079 .23147 L
.35397 .23174 L
.35714 .23201 L
.36032 .23228 L
.36349 .23256 L
.36667 .23283 L
.36984 .23312 L
.37302 .2334 L
.37619 .23369 L
.37937 .23398 L
.38254 .23427 L
.38571 .23456 L
.38889 .23486 L
.39206 .23516 L
.39524 .23547 L
.39841 .23578 L
.40159 .23609 L
.40476 .2364 L
.40794 .23672 L
.41111 .23704 L
.41429 .23736 L
.41746 .23769 L
.42063 .23802 L
.42381 .23835 L
.42698 .23869 L
.43016 .23903 L
.43333 .23937 L
.43651 .23972 L
.43968 .24007 L
.44286 .24042 L
.44603 .24078 L
.44921 .24114 L
.45238 .2415 L
.45556 .24187 L
.45873 .24224 L
.4619 .24262 L
.46508 .243 L
.46825 .24338 L
.47143 .24377 L
.4746 .24416 L
.47778 .24455 L
.48095 .24495 L
.48413 .24535 L
.4873 .24576 L
.49048 .24617 L
.49365 .24658 L
.49683 .247 L
.5 .24742 L
Mistroke
.50317 .24785 L
.50635 .24828 L
.50952 .24872 L
.5127 .24916 L
.51587 .2496 L
.51905 .25005 L
.52222 .2505 L
.5254 .25096 L
.52857 .25143 L
.53175 .25189 L
.53492 .25236 L
.5381 .25284 L
.54127 .25332 L
.54444 .25381 L
.54762 .2543 L
.55079 .25479 L
.55397 .2553 L
.55714 .2558 L
.56032 .25631 L
.56349 .25683 L
.56667 .25735 L
.56984 .25788 L
.57302 .25841 L
.57619 .25894 L
.57937 .25949 L
.58254 .26003 L
.58571 .26059 L
.58889 .26115 L
.59206 .26171 L
.59524 .26228 L
.59841 .26286 L
.60159 .26344 L
.60476 .26403 L
.60794 .26462 L
.61111 .26522 L
.61429 .26582 L
.61746 .26643 L
.62063 .26705 L
.62381 .26767 L
.62698 .2683 L
.63016 .26894 L
.63333 .26958 L
.63651 .27023 L
.63968 .27089 L
.64286 .27155 L
.64603 .27222 L
.64921 .27289 L
.65238 .27357 L
.65556 .27426 L
.65873 .27496 L
Mistroke
.6619 .27566 L
.66508 .27637 L
.66825 .27709 L
.67143 .27781 L
.6746 .27854 L
.67778 .27928 L
.68095 .28002 L
.68413 .28078 L
.6873 .28154 L
.69048 .28231 L
.69365 .28308 L
.69683 .28387 L
.7 .28466 L
.70317 .28546 L
.70635 .28626 L
.70952 .28708 L
.7127 .2879 L
.71587 .28873 L
.71905 .28958 L
.72222 .29042 L
.7254 .29128 L
.72857 .29215 L
.73175 .29302 L
.73492 .2939 L
.7381 .2948 L
.74127 .2957 L
.74444 .29661 L
.74762 .29753 L
.75079 .29845 L
.75397 .29939 L
.75714 .30034 L
.76032 .30129 L
.76349 .30226 L
.76667 .30324 L
.76984 .30422 L
.77302 .30522 L
.77619 .30622 L
.77937 .30724 L
.78254 .30826 L
.78571 .3093 L
.78889 .31034 L
.79206 .3114 L
.79524 .31247 L
.79841 .31354 L
.80159 .31463 L
.80476 .31573 L
.80794 .31684 L
.81111 .31796 L
.81429 .31909 L
.81746 .32024 L
Mistroke
.82063 .32139 L
.82381 .32256 L
.82698 .32374 L
.83016 .32493 L
.83333 .32613 L
.83651 .32735 L
.83968 .32857 L
.84286 .32981 L
.84603 .33106 L
.84921 .33232 L
.85238 .3336 L
.85556 .33489 L
.85873 .33619 L
.8619 .33751 L
.86508 .33883 L
.86825 .34018 L
.87143 .34153 L
.8746 .3429 L
.87778 .34428 L
.88095 .34568 L
.88413 .34709 L
.8873 .34851 L
.89048 .34995 L
.89365 .3514 L
.89683 .35287 L
.9 .35435 L
.90317 .35584 L
.90635 .35736 L
.90952 .35888 L
.9127 .36042 L
.91587 .36198 L
.91905 .36355 L
.92222 .36514 L
.9254 .36675 L
.92857 .36837 L
.93175 .37 L
.93492 .37166 L
.9381 .37333 L
.94127 .37501 L
.94444 .37671 L
.94762 .37843 L
.95079 .38017 L
.95397 .38193 L
.95714 .3837 L
.96032 .38549 L
.96349 .3873 L
.96667 .38912 L
.96984 .39097 L
.97302 .39283 L
.97619 .39471 L
Mistroke
Mfstroke
.0001 w
.02698 .21441 0 2.5 Mabsadd m
.02698 .21441 -0.56518 .7779 Mabsadd L
.02698 .21441 -2.37764 .77254 Mabsadd L
.02698 .21441 -0.91448 -0.29713 Mabsadd L
.02698 .21441 -1.46946 -2.02254 Mabsadd L
.02698 .21441 0 -0.96154 Mabsadd L
.02698 .21441 1.46946 -2.02254 Mabsadd L
.02698 .21441 .91448 -0.29713 Mabsadd L
.02698 .21441 2.37764 .77254 Mabsadd L
.02698 .21441 .56518 .7779 Mabsadd L
.02698 .21441 0 2.5 Mabsadd L closepath F
.03016 .21451 0 2.5 Mabsadd m
.03016 .21451 -0.56518 .7779 Mabsadd L
.03016 .21451 -2.37764 .77254 Mabsadd L
.03016 .21451 -0.91448 -0.29713 Mabsadd L
.03016 .21451 -1.46946 -2.02254 Mabsadd L
.03016 .21451 0 -0.96154 Mabsadd L
.03016 .21451 1.46946 -2.02254 Mabsadd L
.03016 .21451 .91448 -0.29713 Mabsadd L
.03016 .21451 2.37764 .77254 Mabsadd L
.03016 .21451 .56518 .7779 Mabsadd L
.03016 .21451 0 2.5 Mabsadd L closepath F
.03333 .2146 0 2.5 Mabsadd m
.03333 .2146 -0.56518 .7779 Mabsadd L
.03333 .2146 -2.37764 .77254 Mabsadd L
.03333 .2146 -0.91448 -0.29713 Mabsadd L
.03333 .2146 -1.46946 -2.02254 Mabsadd L
.03333 .2146 0 -0.96154 Mabsadd L
.03333 .2146 1.46946 -2.02254 Mabsadd L
.03333 .2146 .91448 -0.29713 Mabsadd L
.03333 .2146 2.37764 .77254 Mabsadd L
.03333 .2146 .56518 .7779 Mabsadd L
.03333 .2146 0 2.5 Mabsadd L closepath F
.03651 .2147 0 2.5 Mabsadd m
.03651 .2147 -0.56518 .7779 Mabsadd L
.03651 .2147 -2.37764 .77254 Mabsadd L
.03651 .2147 -0.91448 -0.29713 Mabsadd L
.03651 .2147 -1.46946 -2.02254 Mabsadd L
.03651 .2147 0 -0.96154 Mabsadd L
.03651 .2147 1.46946 -2.02254 Mabsadd L
.03651 .2147 .91448 -0.29713 Mabsadd L
.03651 .2147 2.37764 .77254 Mabsadd L
.03651 .2147 .56518 .7779 Mabsadd L
.03651 .2147 0 2.5 Mabsadd L closepath F
.03968 .2148 0 2.5 Mabsadd m
.03968 .2148 -0.56518 .7779 Mabsadd L
.03968 .2148 -2.37764 .77254 Mabsadd L
.03968 .2148 -0.91448 -0.29713 Mabsadd L
.03968 .2148 -1.46946 -2.02254 Mabsadd L
.03968 .2148 0 -0.96154 Mabsadd L
.03968 .2148 1.46946 -2.02254 Mabsadd L
.03968 .2148 .91448 -0.29713 Mabsadd L
.03968 .2148 2.37764 .77254 Mabsadd L
.03968 .2148 .56518 .7779 Mabsadd L
.03968 .2148 0 2.5 Mabsadd L closepath F
.04286 .2149 0 2.5 Mabsadd m
.04286 .2149 -0.56518 .7779 Mabsadd L
.04286 .2149 -2.37764 .77254 Mabsadd L
.04286 .2149 -0.91448 -0.29713 Mabsadd L
.04286 .2149 -1.46946 -2.02254 Mabsadd L
.04286 .2149 0 -0.96154 Mabsadd L
.04286 .2149 1.46946 -2.02254 Mabsadd L
.04286 .2149 .91448 -0.29713 Mabsadd L
.04286 .2149 2.37764 .77254 Mabsadd L
.04286 .2149 .56518 .7779 Mabsadd L
.04286 .2149 0 2.5 Mabsadd L closepath F
.04603 .21501 0 2.5 Mabsadd m
.04603 .21501 -0.56518 .7779 Mabsadd L
.04603 .21501 -2.37764 .77254 Mabsadd L
.04603 .21501 -0.91448 -0.29713 Mabsadd L
.04603 .21501 -1.46946 -2.02254 Mabsadd L
.04603 .21501 0 -0.96154 Mabsadd L
.04603 .21501 1.46946 -2.02254 Mabsadd L
.04603 .21501 .91448 -0.29713 Mabsadd L
.04603 .21501 2.37764 .77254 Mabsadd L
.04603 .21501 .56518 .7779 Mabsadd L
.04603 .21501 0 2.5 Mabsadd L closepath F
.04921 .21511 0 2.5 Mabsadd m
.04921 .21511 -0.56518 .7779 Mabsadd L
.04921 .21511 -2.37764 .77254 Mabsadd L
.04921 .21511 -0.91448 -0.29713 Mabsadd L
.04921 .21511 -1.46946 -2.02254 Mabsadd L
.04921 .21511 0 -0.96154 Mabsadd L
.04921 .21511 1.46946 -2.02254 Mabsadd L
.04921 .21511 .91448 -0.29713 Mabsadd L
.04921 .21511 2.37764 .77254 Mabsadd L
.04921 .21511 .56518 .7779 Mabsadd L
.04921 .21511 0 2.5 Mabsadd L closepath F
.05238 .21521 0 2.5 Mabsadd m
.05238 .21521 -0.56518 .7779 Mabsadd L
.05238 .21521 -2.37764 .77254 Mabsadd L
.05238 .21521 -0.91448 -0.29713 Mabsadd L
.05238 .21521 -1.46946 -2.02254 Mabsadd L
.05238 .21521 0 -0.96154 Mabsadd L
.05238 .21521 1.46946 -2.02254 Mabsadd L
.05238 .21521 .91448 -0.29713 Mabsadd L
.05238 .21521 2.37764 .77254 Mabsadd L
.05238 .21521 .56518 .7779 Mabsadd L
.05238 .21521 0 2.5 Mabsadd L closepath F
.05556 .21532 0 2.5 Mabsadd m
.05556 .21532 -0.56518 .7779 Mabsadd L
.05556 .21532 -2.37764 .77254 Mabsadd L
.05556 .21532 -0.91448 -0.29713 Mabsadd L
.05556 .21532 -1.46946 -2.02254 Mabsadd L
.05556 .21532 0 -0.96154 Mabsadd L
.05556 .21532 1.46946 -2.02254 Mabsadd L
.05556 .21532 .91448 -0.29713 Mabsadd L
.05556 .21532 2.37764 .77254 Mabsadd L
.05556 .21532 .56518 .7779 Mabsadd L
.05556 .21532 0 2.5 Mabsadd L closepath F
.05873 .21542 0 2.5 Mabsadd m
.05873 .21542 -0.56518 .7779 Mabsadd L
.05873 .21542 -2.37764 .77254 Mabsadd L
.05873 .21542 -0.91448 -0.29713 Mabsadd L
.05873 .21542 -1.46946 -2.02254 Mabsadd L
.05873 .21542 0 -0.96154 Mabsadd L
.05873 .21542 1.46946 -2.02254 Mabsadd L
.05873 .21542 .91448 -0.29713 Mabsadd L
.05873 .21542 2.37764 .77254 Mabsadd L
.05873 .21542 .56518 .7779 Mabsadd L
.05873 .21542 0 2.5 Mabsadd L closepath F
.0619 .21553 0 2.5 Mabsadd m
.0619 .21553 -0.56518 .7779 Mabsadd L
.0619 .21553 -2.37764 .77254 Mabsadd L
.0619 .21553 -0.91448 -0.29713 Mabsadd L
.0619 .21553 -1.46946 -2.02254 Mabsadd L
.0619 .21553 0 -0.96154 Mabsadd L
.0619 .21553 1.46946 -2.02254 Mabsadd L
.0619 .21553 .91448 -0.29713 Mabsadd L
.0619 .21553 2.37764 .77254 Mabsadd L
.0619 .21553 .56518 .7779 Mabsadd L
.0619 .21553 0 2.5 Mabsadd L closepath F
.06508 .21564 0 2.5 Mabsadd m
.06508 .21564 -0.56518 .7779 Mabsadd L
.06508 .21564 -2.37764 .77254 Mabsadd L
.06508 .21564 -0.91448 -0.29713 Mabsadd L
.06508 .21564 -1.46946 -2.02254 Mabsadd L
.06508 .21564 0 -0.96154 Mabsadd L
.06508 .21564 1.46946 -2.02254 Mabsadd L
.06508 .21564 .91448 -0.29713 Mabsadd L
.06508 .21564 2.37764 .77254 Mabsadd L
.06508 .21564 .56518 .7779 Mabsadd L
.06508 .21564 0 2.5 Mabsadd L closepath F
.06825 .21575 0 2.5 Mabsadd m
.06825 .21575 -0.56518 .7779 Mabsadd L
.06825 .21575 -2.37764 .77254 Mabsadd L
.06825 .21575 -0.91448 -0.29713 Mabsadd L
.06825 .21575 -1.46946 -2.02254 Mabsadd L
.06825 .21575 0 -0.96154 Mabsadd L
.06825 .21575 1.46946 -2.02254 Mabsadd L
.06825 .21575 .91448 -0.29713 Mabsadd L
.06825 .21575 2.37764 .77254 Mabsadd L
.06825 .21575 .56518 .7779 Mabsadd L
.06825 .21575 0 2.5 Mabsadd L closepath F
.07143 .21586 0 2.5 Mabsadd m
.07143 .21586 -0.56518 .7779 Mabsadd L
.07143 .21586 -2.37764 .77254 Mabsadd L
.07143 .21586 -0.91448 -0.29713 Mabsadd L
.07143 .21586 -1.46946 -2.02254 Mabsadd L
.07143 .21586 0 -0.96154 Mabsadd L
.07143 .21586 1.46946 -2.02254 Mabsadd L
.07143 .21586 .91448 -0.29713 Mabsadd L
.07143 .21586 2.37764 .77254 Mabsadd L
.07143 .21586 .56518 .7779 Mabsadd L
.07143 .21586 0 2.5 Mabsadd L closepath F
.0746 .21597 0 2.5 Mabsadd m
.0746 .21597 -0.56518 .7779 Mabsadd L
.0746 .21597 -2.37764 .77254 Mabsadd L
.0746 .21597 -0.91448 -0.29713 Mabsadd L
.0746 .21597 -1.46946 -2.02254 Mabsadd L
.0746 .21597 0 -0.96154 Mabsadd L
.0746 .21597 1.46946 -2.02254 Mabsadd L
.0746 .21597 .91448 -0.29713 Mabsadd L
.0746 .21597 2.37764 .77254 Mabsadd L
.0746 .21597 .56518 .7779 Mabsadd L
.0746 .21597 0 2.5 Mabsadd L closepath F
.07778 .21608 0 2.5 Mabsadd m
.07778 .21608 -0.56518 .7779 Mabsadd L
.07778 .21608 -2.37764 .77254 Mabsadd L
.07778 .21608 -0.91448 -0.29713 Mabsadd L
.07778 .21608 -1.46946 -2.02254 Mabsadd L
.07778 .21608 0 -0.96154 Mabsadd L
.07778 .21608 1.46946 -2.02254 Mabsadd L
.07778 .21608 .91448 -0.29713 Mabsadd L
.07778 .21608 2.37764 .77254 Mabsadd L
.07778 .21608 .56518 .7779 Mabsadd L
.07778 .21608 0 2.5 Mabsadd L closepath F
.08095 .2162 0 2.5 Mabsadd m
.08095 .2162 -0.56518 .7779 Mabsadd L
.08095 .2162 -2.37764 .77254 Mabsadd L
.08095 .2162 -0.91448 -0.29713 Mabsadd L
.08095 .2162 -1.46946 -2.02254 Mabsadd L
.08095 .2162 0 -0.96154 Mabsadd L
.08095 .2162 1.46946 -2.02254 Mabsadd L
.08095 .2162 .91448 -0.29713 Mabsadd L
.08095 .2162 2.37764 .77254 Mabsadd L
.08095 .2162 .56518 .7779 Mabsadd L
.08095 .2162 0 2.5 Mabsadd L closepath F
.08413 .21631 0 2.5 Mabsadd m
.08413 .21631 -0.56518 .7779 Mabsadd L
.08413 .21631 -2.37764 .77254 Mabsadd L
.08413 .21631 -0.91448 -0.29713 Mabsadd L
.08413 .21631 -1.46946 -2.02254 Mabsadd L
.08413 .21631 0 -0.96154 Mabsadd L
.08413 .21631 1.46946 -2.02254 Mabsadd L
.08413 .21631 .91448 -0.29713 Mabsadd L
.08413 .21631 2.37764 .77254 Mabsadd L
.08413 .21631 .56518 .7779 Mabsadd L
.08413 .21631 0 2.5 Mabsadd L closepath F
.0873 .21643 0 2.5 Mabsadd m
.0873 .21643 -0.56518 .7779 Mabsadd L
.0873 .21643 -2.37764 .77254 Mabsadd L
.0873 .21643 -0.91448 -0.29713 Mabsadd L
.0873 .21643 -1.46946 -2.02254 Mabsadd L
.0873 .21643 0 -0.96154 Mabsadd L
.0873 .21643 1.46946 -2.02254 Mabsadd L
.0873 .21643 .91448 -0.29713 Mabsadd L
.0873 .21643 2.37764 .77254 Mabsadd L
.0873 .21643 .56518 .7779 Mabsadd L
.0873 .21643 0 2.5 Mabsadd L closepath F
.09048 .21655 0 2.5 Mabsadd m
.09048 .21655 -0.56518 .7779 Mabsadd L
.09048 .21655 -2.37764 .77254 Mabsadd L
.09048 .21655 -0.91448 -0.29713 Mabsadd L
.09048 .21655 -1.46946 -2.02254 Mabsadd L
.09048 .21655 0 -0.96154 Mabsadd L
.09048 .21655 1.46946 -2.02254 Mabsadd L
.09048 .21655 .91448 -0.29713 Mabsadd L
.09048 .21655 2.37764 .77254 Mabsadd L
.09048 .21655 .56518 .7779 Mabsadd L
.09048 .21655 0 2.5 Mabsadd L closepath F
.09365 .21666 0 2.5 Mabsadd m
.09365 .21666 -0.56518 .7779 Mabsadd L
.09365 .21666 -2.37764 .77254 Mabsadd L
.09365 .21666 -0.91448 -0.29713 Mabsadd L
.09365 .21666 -1.46946 -2.02254 Mabsadd L
.09365 .21666 0 -0.96154 Mabsadd L
.09365 .21666 1.46946 -2.02254 Mabsadd L
.09365 .21666 .91448 -0.29713 Mabsadd L
.09365 .21666 2.37764 .77254 Mabsadd L
.09365 .21666 .56518 .7779 Mabsadd L
.09365 .21666 0 2.5 Mabsadd L closepath F
.09683 .21678 0 2.5 Mabsadd m
.09683 .21678 -0.56518 .7779 Mabsadd L
.09683 .21678 -2.37764 .77254 Mabsadd L
.09683 .21678 -0.91448 -0.29713 Mabsadd L
.09683 .21678 -1.46946 -2.02254 Mabsadd L
.09683 .21678 0 -0.96154 Mabsadd L
.09683 .21678 1.46946 -2.02254 Mabsadd L
.09683 .21678 .91448 -0.29713 Mabsadd L
.09683 .21678 2.37764 .77254 Mabsadd L
.09683 .21678 .56518 .7779 Mabsadd L
.09683 .21678 0 2.5 Mabsadd L closepath F
.1 .2169 0 2.5 Mabsadd m
.1 .2169 -0.56518 .7779 Mabsadd L
.1 .2169 -2.37764 .77254 Mabsadd L
.1 .2169 -0.91448 -0.29713 Mabsadd L
.1 .2169 -1.46946 -2.02254 Mabsadd L
.1 .2169 0 -0.96154 Mabsadd L
.1 .2169 1.46946 -2.02254 Mabsadd L
.1 .2169 .91448 -0.29713 Mabsadd L
.1 .2169 2.37764 .77254 Mabsadd L
.1 .2169 .56518 .7779 Mabsadd L
.1 .2169 0 2.5 Mabsadd L closepath F
.10317 .21703 0 2.5 Mabsadd m
.10317 .21703 -0.56518 .7779 Mabsadd L
.10317 .21703 -2.37764 .77254 Mabsadd L
.10317 .21703 -0.91448 -0.29713 Mabsadd L
.10317 .21703 -1.46946 -2.02254 Mabsadd L
.10317 .21703 0 -0.96154 Mabsadd L
.10317 .21703 1.46946 -2.02254 Mabsadd L
.10317 .21703 .91448 -0.29713 Mabsadd L
.10317 .21703 2.37764 .77254 Mabsadd L
.10317 .21703 .56518 .7779 Mabsadd L
.10317 .21703 0 2.5 Mabsadd L closepath F
.10635 .21715 0 2.5 Mabsadd m
.10635 .21715 -0.56518 .7779 Mabsadd L
.10635 .21715 -2.37764 .77254 Mabsadd L
.10635 .21715 -0.91448 -0.29713 Mabsadd L
.10635 .21715 -1.46946 -2.02254 Mabsadd L
.10635 .21715 0 -0.96154 Mabsadd L
.10635 .21715 1.46946 -2.02254 Mabsadd L
.10635 .21715 .91448 -0.29713 Mabsadd L
.10635 .21715 2.37764 .77254 Mabsadd L
.10635 .21715 .56518 .7779 Mabsadd L
.10635 .21715 0 2.5 Mabsadd L closepath F
.10952 .21727 0 2.5 Mabsadd m
.10952 .21727 -0.56518 .7779 Mabsadd L
.10952 .21727 -2.37764 .77254 Mabsadd L
.10952 .21727 -0.91448 -0.29713 Mabsadd L
.10952 .21727 -1.46946 -2.02254 Mabsadd L
.10952 .21727 0 -0.96154 Mabsadd L
.10952 .21727 1.46946 -2.02254 Mabsadd L
.10952 .21727 .91448 -0.29713 Mabsadd L
.10952 .21727 2.37764 .77254 Mabsadd L
.10952 .21727 .56518 .7779 Mabsadd L
.10952 .21727 0 2.5 Mabsadd L closepath F
.1127 .2174 0 2.5 Mabsadd m
.1127 .2174 -0.56518 .7779 Mabsadd L
.1127 .2174 -2.37764 .77254 Mabsadd L
.1127 .2174 -0.91448 -0.29713 Mabsadd L
.1127 .2174 -1.46946 -2.02254 Mabsadd L
.1127 .2174 0 -0.96154 Mabsadd L
.1127 .2174 1.46946 -2.02254 Mabsadd L
.1127 .2174 .91448 -0.29713 Mabsadd L
.1127 .2174 2.37764 .77254 Mabsadd L
.1127 .2174 .56518 .7779 Mabsadd L
.1127 .2174 0 2.5 Mabsadd L closepath F
.11587 .21753 0 2.5 Mabsadd m
.11587 .21753 -0.56518 .7779 Mabsadd L
.11587 .21753 -2.37764 .77254 Mabsadd L
.11587 .21753 -0.91448 -0.29713 Mabsadd L
.11587 .21753 -1.46946 -2.02254 Mabsadd L
.11587 .21753 0 -0.96154 Mabsadd L
.11587 .21753 1.46946 -2.02254 Mabsadd L
.11587 .21753 .91448 -0.29713 Mabsadd L
.11587 .21753 2.37764 .77254 Mabsadd L
.11587 .21753 .56518 .7779 Mabsadd L
.11587 .21753 0 2.5 Mabsadd L closepath F
.11905 .21765 0 2.5 Mabsadd m
.11905 .21765 -0.56518 .7779 Mabsadd L
.11905 .21765 -2.37764 .77254 Mabsadd L
.11905 .21765 -0.91448 -0.29713 Mabsadd L
.11905 .21765 -1.46946 -2.02254 Mabsadd L
.11905 .21765 0 -0.96154 Mabsadd L
.11905 .21765 1.46946 -2.02254 Mabsadd L
.11905 .21765 .91448 -0.29713 Mabsadd L
.11905 .21765 2.37764 .77254 Mabsadd L
.11905 .21765 .56518 .7779 Mabsadd L
.11905 .21765 0 2.5 Mabsadd L closepath F
.12222 .21778 0 2.5 Mabsadd m
.12222 .21778 -0.56518 .7779 Mabsadd L
.12222 .21778 -2.37764 .77254 Mabsadd L
.12222 .21778 -0.91448 -0.29713 Mabsadd L
.12222 .21778 -1.46946 -2.02254 Mabsadd L
.12222 .21778 0 -0.96154 Mabsadd L
.12222 .21778 1.46946 -2.02254 Mabsadd L
.12222 .21778 .91448 -0.29713 Mabsadd L
.12222 .21778 2.37764 .77254 Mabsadd L
.12222 .21778 .56518 .7779 Mabsadd L
.12222 .21778 0 2.5 Mabsadd L closepath F
.1254 .21791 0 2.5 Mabsadd m
.1254 .21791 -0.56518 .7779 Mabsadd L
.1254 .21791 -2.37764 .77254 Mabsadd L
.1254 .21791 -0.91448 -0.29713 Mabsadd L
.1254 .21791 -1.46946 -2.02254 Mabsadd L
.1254 .21791 0 -0.96154 Mabsadd L
.1254 .21791 1.46946 -2.02254 Mabsadd L
.1254 .21791 .91448 -0.29713 Mabsadd L
.1254 .21791 2.37764 .77254 Mabsadd L
.1254 .21791 .56518 .7779 Mabsadd L
.1254 .21791 0 2.5 Mabsadd L closepath F
.12857 .21805 0 2.5 Mabsadd m
.12857 .21805 -0.56518 .7779 Mabsadd L
.12857 .21805 -2.37764 .77254 Mabsadd L
.12857 .21805 -0.91448 -0.29713 Mabsadd L
.12857 .21805 -1.46946 -2.02254 Mabsadd L
.12857 .21805 0 -0.96154 Mabsadd L
.12857 .21805 1.46946 -2.02254 Mabsadd L
.12857 .21805 .91448 -0.29713 Mabsadd L
.12857 .21805 2.37764 .77254 Mabsadd L
.12857 .21805 .56518 .7779 Mabsadd L
.12857 .21805 0 2.5 Mabsadd L closepath F
.13175 .21818 0 2.5 Mabsadd m
.13175 .21818 -0.56518 .7779 Mabsadd L
.13175 .21818 -2.37764 .77254 Mabsadd L
.13175 .21818 -0.91448 -0.29713 Mabsadd L
.13175 .21818 -1.46946 -2.02254 Mabsadd L
.13175 .21818 0 -0.96154 Mabsadd L
.13175 .21818 1.46946 -2.02254 Mabsadd L
.13175 .21818 .91448 -0.29713 Mabsadd L
.13175 .21818 2.37764 .77254 Mabsadd L
.13175 .21818 .56518 .7779 Mabsadd L
.13175 .21818 0 2.5 Mabsadd L closepath F
.13492 .21831 0 2.5 Mabsadd m
.13492 .21831 -0.56518 .7779 Mabsadd L
.13492 .21831 -2.37764 .77254 Mabsadd L
.13492 .21831 -0.91448 -0.29713 Mabsadd L
.13492 .21831 -1.46946 -2.02254 Mabsadd L
.13492 .21831 0 -0.96154 Mabsadd L
.13492 .21831 1.46946 -2.02254 Mabsadd L
.13492 .21831 .91448 -0.29713 Mabsadd L
.13492 .21831 2.37764 .77254 Mabsadd L
.13492 .21831 .56518 .7779 Mabsadd L
.13492 .21831 0 2.5 Mabsadd L closepath F
.1381 .21845 0 2.5 Mabsadd m
.1381 .21845 -0.56518 .7779 Mabsadd L
.1381 .21845 -2.37764 .77254 Mabsadd L
.1381 .21845 -0.91448 -0.29713 Mabsadd L
.1381 .21845 -1.46946 -2.02254 Mabsadd L
.1381 .21845 0 -0.96154 Mabsadd L
.1381 .21845 1.46946 -2.02254 Mabsadd L
.1381 .21845 .91448 -0.29713 Mabsadd L
.1381 .21845 2.37764 .77254 Mabsadd L
.1381 .21845 .56518 .7779 Mabsadd L
.1381 .21845 0 2.5 Mabsadd L closepath F
.14127 .21859 0 2.5 Mabsadd m
.14127 .21859 -0.56518 .7779 Mabsadd L
.14127 .21859 -2.37764 .77254 Mabsadd L
.14127 .21859 -0.91448 -0.29713 Mabsadd L
.14127 .21859 -1.46946 -2.02254 Mabsadd L
.14127 .21859 0 -0.96154 Mabsadd L
.14127 .21859 1.46946 -2.02254 Mabsadd L
.14127 .21859 .91448 -0.29713 Mabsadd L
.14127 .21859 2.37764 .77254 Mabsadd L
.14127 .21859 .56518 .7779 Mabsadd L
.14127 .21859 0 2.5 Mabsadd L closepath F
.14444 .21873 0 2.5 Mabsadd m
.14444 .21873 -0.56518 .7779 Mabsadd L
.14444 .21873 -2.37764 .77254 Mabsadd L
.14444 .21873 -0.91448 -0.29713 Mabsadd L
.14444 .21873 -1.46946 -2.02254 Mabsadd L
.14444 .21873 0 -0.96154 Mabsadd L
.14444 .21873 1.46946 -2.02254 Mabsadd L
.14444 .21873 .91448 -0.29713 Mabsadd L
.14444 .21873 2.37764 .77254 Mabsadd L
.14444 .21873 .56518 .7779 Mabsadd L
.14444 .21873 0 2.5 Mabsadd L closepath F
.14762 .21887 0 2.5 Mabsadd m
.14762 .21887 -0.56518 .7779 Mabsadd L
.14762 .21887 -2.37764 .77254 Mabsadd L
.14762 .21887 -0.91448 -0.29713 Mabsadd L
.14762 .21887 -1.46946 -2.02254 Mabsadd L
.14762 .21887 0 -0.96154 Mabsadd L
.14762 .21887 1.46946 -2.02254 Mabsadd L
.14762 .21887 .91448 -0.29713 Mabsadd L
.14762 .21887 2.37764 .77254 Mabsadd L
.14762 .21887 .56518 .7779 Mabsadd L
.14762 .21887 0 2.5 Mabsadd L closepath F
.15079 .21901 0 2.5 Mabsadd m
.15079 .21901 -0.56518 .7779 Mabsadd L
.15079 .21901 -2.37764 .77254 Mabsadd L
.15079 .21901 -0.91448 -0.29713 Mabsadd L
.15079 .21901 -1.46946 -2.02254 Mabsadd L
.15079 .21901 0 -0.96154 Mabsadd L
.15079 .21901 1.46946 -2.02254 Mabsadd L
.15079 .21901 .91448 -0.29713 Mabsadd L
.15079 .21901 2.37764 .77254 Mabsadd L
.15079 .21901 .56518 .7779 Mabsadd L
.15079 .21901 0 2.5 Mabsadd L closepath F
.15397 .21915 0 2.5 Mabsadd m
.15397 .21915 -0.56518 .7779 Mabsadd L
.15397 .21915 -2.37764 .77254 Mabsadd L
.15397 .21915 -0.91448 -0.29713 Mabsadd L
.15397 .21915 -1.46946 -2.02254 Mabsadd L
.15397 .21915 0 -0.96154 Mabsadd L
.15397 .21915 1.46946 -2.02254 Mabsadd L
.15397 .21915 .91448 -0.29713 Mabsadd L
.15397 .21915 2.37764 .77254 Mabsadd L
.15397 .21915 .56518 .7779 Mabsadd L
.15397 .21915 0 2.5 Mabsadd L closepath F
.15714 .2193 0 2.5 Mabsadd m
.15714 .2193 -0.56518 .7779 Mabsadd L
.15714 .2193 -2.37764 .77254 Mabsadd L
.15714 .2193 -0.91448 -0.29713 Mabsadd L
.15714 .2193 -1.46946 -2.02254 Mabsadd L
.15714 .2193 0 -0.96154 Mabsadd L
.15714 .2193 1.46946 -2.02254 Mabsadd L
.15714 .2193 .91448 -0.29713 Mabsadd L
.15714 .2193 2.37764 .77254 Mabsadd L
.15714 .2193 .56518 .7779 Mabsadd L
.15714 .2193 0 2.5 Mabsadd L closepath F
.16032 .21944 0 2.5 Mabsadd m
.16032 .21944 -0.56518 .7779 Mabsadd L
.16032 .21944 -2.37764 .77254 Mabsadd L
.16032 .21944 -0.91448 -0.29713 Mabsadd L
.16032 .21944 -1.46946 -2.02254 Mabsadd L
.16032 .21944 0 -0.96154 Mabsadd L
.16032 .21944 1.46946 -2.02254 Mabsadd L
.16032 .21944 .91448 -0.29713 Mabsadd L
.16032 .21944 2.37764 .77254 Mabsadd L
.16032 .21944 .56518 .7779 Mabsadd L
.16032 .21944 0 2.5 Mabsadd L closepath F
.16349 .21959 0 2.5 Mabsadd m
.16349 .21959 -0.56518 .7779 Mabsadd L
.16349 .21959 -2.37764 .77254 Mabsadd L
.16349 .21959 -0.91448 -0.29713 Mabsadd L
.16349 .21959 -1.46946 -2.02254 Mabsadd L
.16349 .21959 0 -0.96154 Mabsadd L
.16349 .21959 1.46946 -2.02254 Mabsadd L
.16349 .21959 .91448 -0.29713 Mabsadd L
.16349 .21959 2.37764 .77254 Mabsadd L
.16349 .21959 .56518 .7779 Mabsadd L
.16349 .21959 0 2.5 Mabsadd L closepath F
.16667 .21974 0 2.5 Mabsadd m
.16667 .21974 -0.56518 .7779 Mabsadd L
.16667 .21974 -2.37764 .77254 Mabsadd L
.16667 .21974 -0.91448 -0.29713 Mabsadd L
.16667 .21974 -1.46946 -2.02254 Mabsadd L
.16667 .21974 0 -0.96154 Mabsadd L
.16667 .21974 1.46946 -2.02254 Mabsadd L
.16667 .21974 .91448 -0.29713 Mabsadd L
.16667 .21974 2.37764 .77254 Mabsadd L
.16667 .21974 .56518 .7779 Mabsadd L
.16667 .21974 0 2.5 Mabsadd L closepath F
.16984 .21989 0 2.5 Mabsadd m
.16984 .21989 -0.56518 .7779 Mabsadd L
.16984 .21989 -2.37764 .77254 Mabsadd L
.16984 .21989 -0.91448 -0.29713 Mabsadd L
.16984 .21989 -1.46946 -2.02254 Mabsadd L
.16984 .21989 0 -0.96154 Mabsadd L
.16984 .21989 1.46946 -2.02254 Mabsadd L
.16984 .21989 .91448 -0.29713 Mabsadd L
.16984 .21989 2.37764 .77254 Mabsadd L
.16984 .21989 .56518 .7779 Mabsadd L
.16984 .21989 0 2.5 Mabsadd L closepath F
.17302 .22004 0 2.5 Mabsadd m
.17302 .22004 -0.56518 .7779 Mabsadd L
.17302 .22004 -2.37764 .77254 Mabsadd L
.17302 .22004 -0.91448 -0.29713 Mabsadd L
.17302 .22004 -1.46946 -2.02254 Mabsadd L
.17302 .22004 0 -0.96154 Mabsadd L
.17302 .22004 1.46946 -2.02254 Mabsadd L
.17302 .22004 .91448 -0.29713 Mabsadd L
.17302 .22004 2.37764 .77254 Mabsadd L
.17302 .22004 .56518 .7779 Mabsadd L
.17302 .22004 0 2.5 Mabsadd L closepath F
.17619 .22019 0 2.5 Mabsadd m
.17619 .22019 -0.56518 .7779 Mabsadd L
.17619 .22019 -2.37764 .77254 Mabsadd L
.17619 .22019 -0.91448 -0.29713 Mabsadd L
.17619 .22019 -1.46946 -2.02254 Mabsadd L
.17619 .22019 0 -0.96154 Mabsadd L
.17619 .22019 1.46946 -2.02254 Mabsadd L
.17619 .22019 .91448 -0.29713 Mabsadd L
.17619 .22019 2.37764 .77254 Mabsadd L
.17619 .22019 .56518 .7779 Mabsadd L
.17619 .22019 0 2.5 Mabsadd L closepath F
.17937 .22035 0 2.5 Mabsadd m
.17937 .22035 -0.56518 .7779 Mabsadd L
.17937 .22035 -2.37764 .77254 Mabsadd L
.17937 .22035 -0.91448 -0.29713 Mabsadd L
.17937 .22035 -1.46946 -2.02254 Mabsadd L
.17937 .22035 0 -0.96154 Mabsadd L
.17937 .22035 1.46946 -2.02254 Mabsadd L
.17937 .22035 .91448 -0.29713 Mabsadd L
.17937 .22035 2.37764 .77254 Mabsadd L
.17937 .22035 .56518 .7779 Mabsadd L
.17937 .22035 0 2.5 Mabsadd L closepath F
.18254 .2205 0 2.5 Mabsadd m
.18254 .2205 -0.56518 .7779 Mabsadd L
.18254 .2205 -2.37764 .77254 Mabsadd L
.18254 .2205 -0.91448 -0.29713 Mabsadd L
.18254 .2205 -1.46946 -2.02254 Mabsadd L
.18254 .2205 0 -0.96154 Mabsadd L
.18254 .2205 1.46946 -2.02254 Mabsadd L
.18254 .2205 .91448 -0.29713 Mabsadd L
.18254 .2205 2.37764 .77254 Mabsadd L
.18254 .2205 .56518 .7779 Mabsadd L
.18254 .2205 0 2.5 Mabsadd L closepath F
.18571 .22066 0 2.5 Mabsadd m
.18571 .22066 -0.56518 .7779 Mabsadd L
.18571 .22066 -2.37764 .77254 Mabsadd L
.18571 .22066 -0.91448 -0.29713 Mabsadd L
.18571 .22066 -1.46946 -2.02254 Mabsadd L
.18571 .22066 0 -0.96154 Mabsadd L
.18571 .22066 1.46946 -2.02254 Mabsadd L
.18571 .22066 .91448 -0.29713 Mabsadd L
.18571 .22066 2.37764 .77254 Mabsadd L
.18571 .22066 .56518 .7779 Mabsadd L
.18571 .22066 0 2.5 Mabsadd L closepath F
.18889 .22082 0 2.5 Mabsadd m
.18889 .22082 -0.56518 .7779 Mabsadd L
.18889 .22082 -2.37764 .77254 Mabsadd L
.18889 .22082 -0.91448 -0.29713 Mabsadd L
.18889 .22082 -1.46946 -2.02254 Mabsadd L
.18889 .22082 0 -0.96154 Mabsadd L
.18889 .22082 1.46946 -2.02254 Mabsadd L
.18889 .22082 .91448 -0.29713 Mabsadd L
.18889 .22082 2.37764 .77254 Mabsadd L
.18889 .22082 .56518 .7779 Mabsadd L
.18889 .22082 0 2.5 Mabsadd L closepath F
.19206 .22098 0 2.5 Mabsadd m
.19206 .22098 -0.56518 .7779 Mabsadd L
.19206 .22098 -2.37764 .77254 Mabsadd L
.19206 .22098 -0.91448 -0.29713 Mabsadd L
.19206 .22098 -1.46946 -2.02254 Mabsadd L
.19206 .22098 0 -0.96154 Mabsadd L
.19206 .22098 1.46946 -2.02254 Mabsadd L
.19206 .22098 .91448 -0.29713 Mabsadd L
.19206 .22098 2.37764 .77254 Mabsadd L
.19206 .22098 .56518 .7779 Mabsadd L
.19206 .22098 0 2.5 Mabsadd L closepath F
.19524 .22114 0 2.5 Mabsadd m
.19524 .22114 -0.56518 .7779 Mabsadd L
.19524 .22114 -2.37764 .77254 Mabsadd L
.19524 .22114 -0.91448 -0.29713 Mabsadd L
.19524 .22114 -1.46946 -2.02254 Mabsadd L
.19524 .22114 0 -0.96154 Mabsadd L
.19524 .22114 1.46946 -2.02254 Mabsadd L
.19524 .22114 .91448 -0.29713 Mabsadd L
.19524 .22114 2.37764 .77254 Mabsadd L
.19524 .22114 .56518 .7779 Mabsadd L
.19524 .22114 0 2.5 Mabsadd L closepath F
.19841 .22131 0 2.5 Mabsadd m
.19841 .22131 -0.56518 .7779 Mabsadd L
.19841 .22131 -2.37764 .77254 Mabsadd L
.19841 .22131 -0.91448 -0.29713 Mabsadd L
.19841 .22131 -1.46946 -2.02254 Mabsadd L
.19841 .22131 0 -0.96154 Mabsadd L
.19841 .22131 1.46946 -2.02254 Mabsadd L
.19841 .22131 .91448 -0.29713 Mabsadd L
.19841 .22131 2.37764 .77254 Mabsadd L
.19841 .22131 .56518 .7779 Mabsadd L
.19841 .22131 0 2.5 Mabsadd L closepath F
.20159 .22147 0 2.5 Mabsadd m
.20159 .22147 -0.56518 .7779 Mabsadd L
.20159 .22147 -2.37764 .77254 Mabsadd L
.20159 .22147 -0.91448 -0.29713 Mabsadd L
.20159 .22147 -1.46946 -2.02254 Mabsadd L
.20159 .22147 0 -0.96154 Mabsadd L
.20159 .22147 1.46946 -2.02254 Mabsadd L
.20159 .22147 .91448 -0.29713 Mabsadd L
.20159 .22147 2.37764 .77254 Mabsadd L
.20159 .22147 .56518 .7779 Mabsadd L
.20159 .22147 0 2.5 Mabsadd L closepath F
.20476 .22164 0 2.5 Mabsadd m
.20476 .22164 -0.56518 .7779 Mabsadd L
.20476 .22164 -2.37764 .77254 Mabsadd L
.20476 .22164 -0.91448 -0.29713 Mabsadd L
.20476 .22164 -1.46946 -2.02254 Mabsadd L
.20476 .22164 0 -0.96154 Mabsadd L
.20476 .22164 1.46946 -2.02254 Mabsadd L
.20476 .22164 .91448 -0.29713 Mabsadd L
.20476 .22164 2.37764 .77254 Mabsadd L
.20476 .22164 .56518 .7779 Mabsadd L
.20476 .22164 0 2.5 Mabsadd L closepath F
.20794 .22181 0 2.5 Mabsadd m
.20794 .22181 -0.56518 .7779 Mabsadd L
.20794 .22181 -2.37764 .77254 Mabsadd L
.20794 .22181 -0.91448 -0.29713 Mabsadd L
.20794 .22181 -1.46946 -2.02254 Mabsadd L
.20794 .22181 0 -0.96154 Mabsadd L
.20794 .22181 1.46946 -2.02254 Mabsadd L
.20794 .22181 .91448 -0.29713 Mabsadd L
.20794 .22181 2.37764 .77254 Mabsadd L
.20794 .22181 .56518 .7779 Mabsadd L
.20794 .22181 0 2.5 Mabsadd L closepath F
.21111 .22198 0 2.5 Mabsadd m
.21111 .22198 -0.56518 .7779 Mabsadd L
.21111 .22198 -2.37764 .77254 Mabsadd L
.21111 .22198 -0.91448 -0.29713 Mabsadd L
.21111 .22198 -1.46946 -2.02254 Mabsadd L
.21111 .22198 0 -0.96154 Mabsadd L
.21111 .22198 1.46946 -2.02254 Mabsadd L
.21111 .22198 .91448 -0.29713 Mabsadd L
.21111 .22198 2.37764 .77254 Mabsadd L
.21111 .22198 .56518 .7779 Mabsadd L
.21111 .22198 0 2.5 Mabsadd L closepath F
.21429 .22216 0 2.5 Mabsadd m
.21429 .22216 -0.56518 .7779 Mabsadd L
.21429 .22216 -2.37764 .77254 Mabsadd L
.21429 .22216 -0.91448 -0.29713 Mabsadd L
.21429 .22216 -1.46946 -2.02254 Mabsadd L
.21429 .22216 0 -0.96154 Mabsadd L
.21429 .22216 1.46946 -2.02254 Mabsadd L
.21429 .22216 .91448 -0.29713 Mabsadd L
.21429 .22216 2.37764 .77254 Mabsadd L
.21429 .22216 .56518 .7779 Mabsadd L
.21429 .22216 0 2.5 Mabsadd L closepath F
.21746 .22233 0 2.5 Mabsadd m
.21746 .22233 -0.56518 .7779 Mabsadd L
.21746 .22233 -2.37764 .77254 Mabsadd L
.21746 .22233 -0.91448 -0.29713 Mabsadd L
.21746 .22233 -1.46946 -2.02254 Mabsadd L
.21746 .22233 0 -0.96154 Mabsadd L
.21746 .22233 1.46946 -2.02254 Mabsadd L
.21746 .22233 .91448 -0.29713 Mabsadd L
.21746 .22233 2.37764 .77254 Mabsadd L
.21746 .22233 .56518 .7779 Mabsadd L
.21746 .22233 0 2.5 Mabsadd L closepath F
.22063 .22251 0 2.5 Mabsadd m
.22063 .22251 -0.56518 .7779 Mabsadd L
.22063 .22251 -2.37764 .77254 Mabsadd L
.22063 .22251 -0.91448 -0.29713 Mabsadd L
.22063 .22251 -1.46946 -2.02254 Mabsadd L
.22063 .22251 0 -0.96154 Mabsadd L
.22063 .22251 1.46946 -2.02254 Mabsadd L
.22063 .22251 .91448 -0.29713 Mabsadd L
.22063 .22251 2.37764 .77254 Mabsadd L
.22063 .22251 .56518 .7779 Mabsadd L
.22063 .22251 0 2.5 Mabsadd L closepath F
.22381 .22268 0 2.5 Mabsadd m
.22381 .22268 -0.56518 .7779 Mabsadd L
.22381 .22268 -2.37764 .77254 Mabsadd L
.22381 .22268 -0.91448 -0.29713 Mabsadd L
.22381 .22268 -1.46946 -2.02254 Mabsadd L
.22381 .22268 0 -0.96154 Mabsadd L
.22381 .22268 1.46946 -2.02254 Mabsadd L
.22381 .22268 .91448 -0.29713 Mabsadd L
.22381 .22268 2.37764 .77254 Mabsadd L
.22381 .22268 .56518 .7779 Mabsadd L
.22381 .22268 0 2.5 Mabsadd L closepath F
.22698 .22286 0 2.5 Mabsadd m
.22698 .22286 -0.56518 .7779 Mabsadd L
.22698 .22286 -2.37764 .77254 Mabsadd L
.22698 .22286 -0.91448 -0.29713 Mabsadd L
.22698 .22286 -1.46946 -2.02254 Mabsadd L
.22698 .22286 0 -0.96154 Mabsadd L
.22698 .22286 1.46946 -2.02254 Mabsadd L
.22698 .22286 .91448 -0.29713 Mabsadd L
.22698 .22286 2.37764 .77254 Mabsadd L
.22698 .22286 .56518 .7779 Mabsadd L
.22698 .22286 0 2.5 Mabsadd L closepath F
.23016 .22305 0 2.5 Mabsadd m
.23016 .22305 -0.56518 .7779 Mabsadd L
.23016 .22305 -2.37764 .77254 Mabsadd L
.23016 .22305 -0.91448 -0.29713 Mabsadd L
.23016 .22305 -1.46946 -2.02254 Mabsadd L
.23016 .22305 0 -0.96154 Mabsadd L
.23016 .22305 1.46946 -2.02254 Mabsadd L
.23016 .22305 .91448 -0.29713 Mabsadd L
.23016 .22305 2.37764 .77254 Mabsadd L
.23016 .22305 .56518 .7779 Mabsadd L
.23016 .22305 0 2.5 Mabsadd L closepath F
.23333 .22323 0 2.5 Mabsadd m
.23333 .22323 -0.56518 .7779 Mabsadd L
.23333 .22323 -2.37764 .77254 Mabsadd L
.23333 .22323 -0.91448 -0.29713 Mabsadd L
.23333 .22323 -1.46946 -2.02254 Mabsadd L
.23333 .22323 0 -0.96154 Mabsadd L
.23333 .22323 1.46946 -2.02254 Mabsadd L
.23333 .22323 .91448 -0.29713 Mabsadd L
.23333 .22323 2.37764 .77254 Mabsadd L
.23333 .22323 .56518 .7779 Mabsadd L
.23333 .22323 0 2.5 Mabsadd L closepath F
.23651 .22341 0 2.5 Mabsadd m
.23651 .22341 -0.56518 .7779 Mabsadd L
.23651 .22341 -2.37764 .77254 Mabsadd L
.23651 .22341 -0.91448 -0.29713 Mabsadd L
.23651 .22341 -1.46946 -2.02254 Mabsadd L
.23651 .22341 0 -0.96154 Mabsadd L
.23651 .22341 1.46946 -2.02254 Mabsadd L
.23651 .22341 .91448 -0.29713 Mabsadd L
.23651 .22341 2.37764 .77254 Mabsadd L
.23651 .22341 .56518 .7779 Mabsadd L
.23651 .22341 0 2.5 Mabsadd L closepath F
.23968 .2236 0 2.5 Mabsadd m
.23968 .2236 -0.56518 .7779 Mabsadd L
.23968 .2236 -2.37764 .77254 Mabsadd L
.23968 .2236 -0.91448 -0.29713 Mabsadd L
.23968 .2236 -1.46946 -2.02254 Mabsadd L
.23968 .2236 0 -0.96154 Mabsadd L
.23968 .2236 1.46946 -2.02254 Mabsadd L
.23968 .2236 .91448 -0.29713 Mabsadd L
.23968 .2236 2.37764 .77254 Mabsadd L
.23968 .2236 .56518 .7779 Mabsadd L
.23968 .2236 0 2.5 Mabsadd L closepath F
.24286 .22379 0 2.5 Mabsadd m
.24286 .22379 -0.56518 .7779 Mabsadd L
.24286 .22379 -2.37764 .77254 Mabsadd L
.24286 .22379 -0.91448 -0.29713 Mabsadd L
.24286 .22379 -1.46946 -2.02254 Mabsadd L
.24286 .22379 0 -0.96154 Mabsadd L
.24286 .22379 1.46946 -2.02254 Mabsadd L
.24286 .22379 .91448 -0.29713 Mabsadd L
.24286 .22379 2.37764 .77254 Mabsadd L
.24286 .22379 .56518 .7779 Mabsadd L
.24286 .22379 0 2.5 Mabsadd L closepath F
.24603 .22398 0 2.5 Mabsadd m
.24603 .22398 -0.56518 .7779 Mabsadd L
.24603 .22398 -2.37764 .77254 Mabsadd L
.24603 .22398 -0.91448 -0.29713 Mabsadd L
.24603 .22398 -1.46946 -2.02254 Mabsadd L
.24603 .22398 0 -0.96154 Mabsadd L
.24603 .22398 1.46946 -2.02254 Mabsadd L
.24603 .22398 .91448 -0.29713 Mabsadd L
.24603 .22398 2.37764 .77254 Mabsadd L
.24603 .22398 .56518 .7779 Mabsadd L
.24603 .22398 0 2.5 Mabsadd L closepath F
.24921 .22417 0 2.5 Mabsadd m
.24921 .22417 -0.56518 .7779 Mabsadd L
.24921 .22417 -2.37764 .77254 Mabsadd L
.24921 .22417 -0.91448 -0.29713 Mabsadd L
.24921 .22417 -1.46946 -2.02254 Mabsadd L
.24921 .22417 0 -0.96154 Mabsadd L
.24921 .22417 1.46946 -2.02254 Mabsadd L
.24921 .22417 .91448 -0.29713 Mabsadd L
.24921 .22417 2.37764 .77254 Mabsadd L
.24921 .22417 .56518 .7779 Mabsadd L
.24921 .22417 0 2.5 Mabsadd L closepath F
.25238 .22437 0 2.5 Mabsadd m
.25238 .22437 -0.56518 .7779 Mabsadd L
.25238 .22437 -2.37764 .77254 Mabsadd L
.25238 .22437 -0.91448 -0.29713 Mabsadd L
.25238 .22437 -1.46946 -2.02254 Mabsadd L
.25238 .22437 0 -0.96154 Mabsadd L
.25238 .22437 1.46946 -2.02254 Mabsadd L
.25238 .22437 .91448 -0.29713 Mabsadd L
.25238 .22437 2.37764 .77254 Mabsadd L
.25238 .22437 .56518 .7779 Mabsadd L
.25238 .22437 0 2.5 Mabsadd L closepath F
.25556 .22456 0 2.5 Mabsadd m
.25556 .22456 -0.56518 .7779 Mabsadd L
.25556 .22456 -2.37764 .77254 Mabsadd L
.25556 .22456 -0.91448 -0.29713 Mabsadd L
.25556 .22456 -1.46946 -2.02254 Mabsadd L
.25556 .22456 0 -0.96154 Mabsadd L
.25556 .22456 1.46946 -2.02254 Mabsadd L
.25556 .22456 .91448 -0.29713 Mabsadd L
.25556 .22456 2.37764 .77254 Mabsadd L
.25556 .22456 .56518 .7779 Mabsadd L
.25556 .22456 0 2.5 Mabsadd L closepath F
.25873 .22476 0 2.5 Mabsadd m
.25873 .22476 -0.56518 .7779 Mabsadd L
.25873 .22476 -2.37764 .77254 Mabsadd L
.25873 .22476 -0.91448 -0.29713 Mabsadd L
.25873 .22476 -1.46946 -2.02254 Mabsadd L
.25873 .22476 0 -0.96154 Mabsadd L
.25873 .22476 1.46946 -2.02254 Mabsadd L
.25873 .22476 .91448 -0.29713 Mabsadd L
.25873 .22476 2.37764 .77254 Mabsadd L
.25873 .22476 .56518 .7779 Mabsadd L
.25873 .22476 0 2.5 Mabsadd L closepath F
.2619 .22496 0 2.5 Mabsadd m
.2619 .22496 -0.56518 .7779 Mabsadd L
.2619 .22496 -2.37764 .77254 Mabsadd L
.2619 .22496 -0.91448 -0.29713 Mabsadd L
.2619 .22496 -1.46946 -2.02254 Mabsadd L
.2619 .22496 0 -0.96154 Mabsadd L
.2619 .22496 1.46946 -2.02254 Mabsadd L
.2619 .22496 .91448 -0.29713 Mabsadd L
.2619 .22496 2.37764 .77254 Mabsadd L
.2619 .22496 .56518 .7779 Mabsadd L
.2619 .22496 0 2.5 Mabsadd L closepath F
.26508 .22517 0 2.5 Mabsadd m
.26508 .22517 -0.56518 .7779 Mabsadd L
.26508 .22517 -2.37764 .77254 Mabsadd L
.26508 .22517 -0.91448 -0.29713 Mabsadd L
.26508 .22517 -1.46946 -2.02254 Mabsadd L
.26508 .22517 0 -0.96154 Mabsadd L
.26508 .22517 1.46946 -2.02254 Mabsadd L
.26508 .22517 .91448 -0.29713 Mabsadd L
.26508 .22517 2.37764 .77254 Mabsadd L
.26508 .22517 .56518 .7779 Mabsadd L
.26508 .22517 0 2.5 Mabsadd L closepath F
.26825 .22537 0 2.5 Mabsadd m
.26825 .22537 -0.56518 .7779 Mabsadd L
.26825 .22537 -2.37764 .77254 Mabsadd L
.26825 .22537 -0.91448 -0.29713 Mabsadd L
.26825 .22537 -1.46946 -2.02254 Mabsadd L
.26825 .22537 0 -0.96154 Mabsadd L
.26825 .22537 1.46946 -2.02254 Mabsadd L
.26825 .22537 .91448 -0.29713 Mabsadd L
.26825 .22537 2.37764 .77254 Mabsadd L
.26825 .22537 .56518 .7779 Mabsadd L
.26825 .22537 0 2.5 Mabsadd L closepath F
.27143 .22558 0 2.5 Mabsadd m
.27143 .22558 -0.56518 .7779 Mabsadd L
.27143 .22558 -2.37764 .77254 Mabsadd L
.27143 .22558 -0.91448 -0.29713 Mabsadd L
.27143 .22558 -1.46946 -2.02254 Mabsadd L
.27143 .22558 0 -0.96154 Mabsadd L
.27143 .22558 1.46946 -2.02254 Mabsadd L
.27143 .22558 .91448 -0.29713 Mabsadd L
.27143 .22558 2.37764 .77254 Mabsadd L
.27143 .22558 .56518 .7779 Mabsadd L
.27143 .22558 0 2.5 Mabsadd L closepath F
.2746 .22579 0 2.5 Mabsadd m
.2746 .22579 -0.56518 .7779 Mabsadd L
.2746 .22579 -2.37764 .77254 Mabsadd L
.2746 .22579 -0.91448 -0.29713 Mabsadd L
.2746 .22579 -1.46946 -2.02254 Mabsadd L
.2746 .22579 0 -0.96154 Mabsadd L
.2746 .22579 1.46946 -2.02254 Mabsadd L
.2746 .22579 .91448 -0.29713 Mabsadd L
.2746 .22579 2.37764 .77254 Mabsadd L
.2746 .22579 .56518 .7779 Mabsadd L
.2746 .22579 0 2.5 Mabsadd L closepath F
.27778 .226 0 2.5 Mabsadd m
.27778 .226 -0.56518 .7779 Mabsadd L
.27778 .226 -2.37764 .77254 Mabsadd L
.27778 .226 -0.91448 -0.29713 Mabsadd L
.27778 .226 -1.46946 -2.02254 Mabsadd L
.27778 .226 0 -0.96154 Mabsadd L
.27778 .226 1.46946 -2.02254 Mabsadd L
.27778 .226 .91448 -0.29713 Mabsadd L
.27778 .226 2.37764 .77254 Mabsadd L
.27778 .226 .56518 .7779 Mabsadd L
.27778 .226 0 2.5 Mabsadd L closepath F
.28095 .22621 0 2.5 Mabsadd m
.28095 .22621 -0.56518 .7779 Mabsadd L
.28095 .22621 -2.37764 .77254 Mabsadd L
.28095 .22621 -0.91448 -0.29713 Mabsadd L
.28095 .22621 -1.46946 -2.02254 Mabsadd L
.28095 .22621 0 -0.96154 Mabsadd L
.28095 .22621 1.46946 -2.02254 Mabsadd L
.28095 .22621 .91448 -0.29713 Mabsadd L
.28095 .22621 2.37764 .77254 Mabsadd L
.28095 .22621 .56518 .7779 Mabsadd L
.28095 .22621 0 2.5 Mabsadd L closepath F
.28413 .22642 0 2.5 Mabsadd m
.28413 .22642 -0.56518 .7779 Mabsadd L
.28413 .22642 -2.37764 .77254 Mabsadd L
.28413 .22642 -0.91448 -0.29713 Mabsadd L
.28413 .22642 -1.46946 -2.02254 Mabsadd L
.28413 .22642 0 -0.96154 Mabsadd L
.28413 .22642 1.46946 -2.02254 Mabsadd L
.28413 .22642 .91448 -0.29713 Mabsadd L
.28413 .22642 2.37764 .77254 Mabsadd L
.28413 .22642 .56518 .7779 Mabsadd L
.28413 .22642 0 2.5 Mabsadd L closepath F
.2873 .22664 0 2.5 Mabsadd m
.2873 .22664 -0.56518 .7779 Mabsadd L
.2873 .22664 -2.37764 .77254 Mabsadd L
.2873 .22664 -0.91448 -0.29713 Mabsadd L
.2873 .22664 -1.46946 -2.02254 Mabsadd L
.2873 .22664 0 -0.96154 Mabsadd L
.2873 .22664 1.46946 -2.02254 Mabsadd L
.2873 .22664 .91448 -0.29713 Mabsadd L
.2873 .22664 2.37764 .77254 Mabsadd L
.2873 .22664 .56518 .7779 Mabsadd L
.2873 .22664 0 2.5 Mabsadd L closepath F
.29048 .22686 0 2.5 Mabsadd m
.29048 .22686 -0.56518 .7779 Mabsadd L
.29048 .22686 -2.37764 .77254 Mabsadd L
.29048 .22686 -0.91448 -0.29713 Mabsadd L
.29048 .22686 -1.46946 -2.02254 Mabsadd L
.29048 .22686 0 -0.96154 Mabsadd L
.29048 .22686 1.46946 -2.02254 Mabsadd L
.29048 .22686 .91448 -0.29713 Mabsadd L
.29048 .22686 2.37764 .77254 Mabsadd L
.29048 .22686 .56518 .7779 Mabsadd L
.29048 .22686 0 2.5 Mabsadd L closepath F
.29365 .22708 0 2.5 Mabsadd m
.29365 .22708 -0.56518 .7779 Mabsadd L
.29365 .22708 -2.37764 .77254 Mabsadd L
.29365 .22708 -0.91448 -0.29713 Mabsadd L
.29365 .22708 -1.46946 -2.02254 Mabsadd L
.29365 .22708 0 -0.96154 Mabsadd L
.29365 .22708 1.46946 -2.02254 Mabsadd L
.29365 .22708 .91448 -0.29713 Mabsadd L
.29365 .22708 2.37764 .77254 Mabsadd L
.29365 .22708 .56518 .7779 Mabsadd L
.29365 .22708 0 2.5 Mabsadd L closepath F
.29683 .22731 0 2.5 Mabsadd m
.29683 .22731 -0.56518 .7779 Mabsadd L
.29683 .22731 -2.37764 .77254 Mabsadd L
.29683 .22731 -0.91448 -0.29713 Mabsadd L
.29683 .22731 -1.46946 -2.02254 Mabsadd L
.29683 .22731 0 -0.96154 Mabsadd L
.29683 .22731 1.46946 -2.02254 Mabsadd L
.29683 .22731 .91448 -0.29713 Mabsadd L
.29683 .22731 2.37764 .77254 Mabsadd L
.29683 .22731 .56518 .7779 Mabsadd L
.29683 .22731 0 2.5 Mabsadd L closepath F
.3 .22753 0 2.5 Mabsadd m
.3 .22753 -0.56518 .7779 Mabsadd L
.3 .22753 -2.37764 .77254 Mabsadd L
.3 .22753 -0.91448 -0.29713 Mabsadd L
.3 .22753 -1.46946 -2.02254 Mabsadd L
.3 .22753 0 -0.96154 Mabsadd L
.3 .22753 1.46946 -2.02254 Mabsadd L
.3 .22753 .91448 -0.29713 Mabsadd L
.3 .22753 2.37764 .77254 Mabsadd L
.3 .22753 .56518 .7779 Mabsadd L
.3 .22753 0 2.5 Mabsadd L closepath F
.30317 .22776 0 2.5 Mabsadd m
.30317 .22776 -0.56518 .7779 Mabsadd L
.30317 .22776 -2.37764 .77254 Mabsadd L
.30317 .22776 -0.91448 -0.29713 Mabsadd L
.30317 .22776 -1.46946 -2.02254 Mabsadd L
.30317 .22776 0 -0.96154 Mabsadd L
.30317 .22776 1.46946 -2.02254 Mabsadd L
.30317 .22776 .91448 -0.29713 Mabsadd L
.30317 .22776 2.37764 .77254 Mabsadd L
.30317 .22776 .56518 .7779 Mabsadd L
.30317 .22776 0 2.5 Mabsadd L closepath F
.30635 .22799 0 2.5 Mabsadd m
.30635 .22799 -0.56518 .7779 Mabsadd L
.30635 .22799 -2.37764 .77254 Mabsadd L
.30635 .22799 -0.91448 -0.29713 Mabsadd L
.30635 .22799 -1.46946 -2.02254 Mabsadd L
.30635 .22799 0 -0.96154 Mabsadd L
.30635 .22799 1.46946 -2.02254 Mabsadd L
.30635 .22799 .91448 -0.29713 Mabsadd L
.30635 .22799 2.37764 .77254 Mabsadd L
.30635 .22799 .56518 .7779 Mabsadd L
.30635 .22799 0 2.5 Mabsadd L closepath F
.30952 .22822 0 2.5 Mabsadd m
.30952 .22822 -0.56518 .7779 Mabsadd L
.30952 .22822 -2.37764 .77254 Mabsadd L
.30952 .22822 -0.91448 -0.29713 Mabsadd L
.30952 .22822 -1.46946 -2.02254 Mabsadd L
.30952 .22822 0 -0.96154 Mabsadd L
.30952 .22822 1.46946 -2.02254 Mabsadd L
.30952 .22822 .91448 -0.29713 Mabsadd L
.30952 .22822 2.37764 .77254 Mabsadd L
.30952 .22822 .56518 .7779 Mabsadd L
.30952 .22822 0 2.5 Mabsadd L closepath F
.3127 .22846 0 2.5 Mabsadd m
.3127 .22846 -0.56518 .7779 Mabsadd L
.3127 .22846 -2.37764 .77254 Mabsadd L
.3127 .22846 -0.91448 -0.29713 Mabsadd L
.3127 .22846 -1.46946 -2.02254 Mabsadd L
.3127 .22846 0 -0.96154 Mabsadd L
.3127 .22846 1.46946 -2.02254 Mabsadd L
.3127 .22846 .91448 -0.29713 Mabsadd L
.3127 .22846 2.37764 .77254 Mabsadd L
.3127 .22846 .56518 .7779 Mabsadd L
.3127 .22846 0 2.5 Mabsadd L closepath F
.31587 .2287 0 2.5 Mabsadd m
.31587 .2287 -0.56518 .7779 Mabsadd L
.31587 .2287 -2.37764 .77254 Mabsadd L
.31587 .2287 -0.91448 -0.29713 Mabsadd L
.31587 .2287 -1.46946 -2.02254 Mabsadd L
.31587 .2287 0 -0.96154 Mabsadd L
.31587 .2287 1.46946 -2.02254 Mabsadd L
.31587 .2287 .91448 -0.29713 Mabsadd L
.31587 .2287 2.37764 .77254 Mabsadd L
.31587 .2287 .56518 .7779 Mabsadd L
.31587 .2287 0 2.5 Mabsadd L closepath F
.31905 .22894 0 2.5 Mabsadd m
.31905 .22894 -0.56518 .7779 Mabsadd L
.31905 .22894 -2.37764 .77254 Mabsadd L
.31905 .22894 -0.91448 -0.29713 Mabsadd L
.31905 .22894 -1.46946 -2.02254 Mabsadd L
.31905 .22894 0 -0.96154 Mabsadd L
.31905 .22894 1.46946 -2.02254 Mabsadd L
.31905 .22894 .91448 -0.29713 Mabsadd L
.31905 .22894 2.37764 .77254 Mabsadd L
.31905 .22894 .56518 .7779 Mabsadd L
.31905 .22894 0 2.5 Mabsadd L closepath F
.32222 .22918 0 2.5 Mabsadd m
.32222 .22918 -0.56518 .7779 Mabsadd L
.32222 .22918 -2.37764 .77254 Mabsadd L
.32222 .22918 -0.91448 -0.29713 Mabsadd L
.32222 .22918 -1.46946 -2.02254 Mabsadd L
.32222 .22918 0 -0.96154 Mabsadd L
.32222 .22918 1.46946 -2.02254 Mabsadd L
.32222 .22918 .91448 -0.29713 Mabsadd L
.32222 .22918 2.37764 .77254 Mabsadd L
.32222 .22918 .56518 .7779 Mabsadd L
.32222 .22918 0 2.5 Mabsadd L closepath F
.3254 .22942 0 2.5 Mabsadd m
.3254 .22942 -0.56518 .7779 Mabsadd L
.3254 .22942 -2.37764 .77254 Mabsadd L
.3254 .22942 -0.91448 -0.29713 Mabsadd L
.3254 .22942 -1.46946 -2.02254 Mabsadd L
.3254 .22942 0 -0.96154 Mabsadd L
.3254 .22942 1.46946 -2.02254 Mabsadd L
.3254 .22942 .91448 -0.29713 Mabsadd L
.3254 .22942 2.37764 .77254 Mabsadd L
.3254 .22942 .56518 .7779 Mabsadd L
.3254 .22942 0 2.5 Mabsadd L closepath F
.32857 .22967 0 2.5 Mabsadd m
.32857 .22967 -0.56518 .7779 Mabsadd L
.32857 .22967 -2.37764 .77254 Mabsadd L
.32857 .22967 -0.91448 -0.29713 Mabsadd L
.32857 .22967 -1.46946 -2.02254 Mabsadd L
.32857 .22967 0 -0.96154 Mabsadd L
.32857 .22967 1.46946 -2.02254 Mabsadd L
.32857 .22967 .91448 -0.29713 Mabsadd L
.32857 .22967 2.37764 .77254 Mabsadd L
.32857 .22967 .56518 .7779 Mabsadd L
.32857 .22967 0 2.5 Mabsadd L closepath F
.33175 .22992 0 2.5 Mabsadd m
.33175 .22992 -0.56518 .7779 Mabsadd L
.33175 .22992 -2.37764 .77254 Mabsadd L
.33175 .22992 -0.91448 -0.29713 Mabsadd L
.33175 .22992 -1.46946 -2.02254 Mabsadd L
.33175 .22992 0 -0.96154 Mabsadd L
.33175 .22992 1.46946 -2.02254 Mabsadd L
.33175 .22992 .91448 -0.29713 Mabsadd L
.33175 .22992 2.37764 .77254 Mabsadd L
.33175 .22992 .56518 .7779 Mabsadd L
.33175 .22992 0 2.5 Mabsadd L closepath F
.33492 .23017 0 2.5 Mabsadd m
.33492 .23017 -0.56518 .7779 Mabsadd L
.33492 .23017 -2.37764 .77254 Mabsadd L
.33492 .23017 -0.91448 -0.29713 Mabsadd L
.33492 .23017 -1.46946 -2.02254 Mabsadd L
.33492 .23017 0 -0.96154 Mabsadd L
.33492 .23017 1.46946 -2.02254 Mabsadd L
.33492 .23017 .91448 -0.29713 Mabsadd L
.33492 .23017 2.37764 .77254 Mabsadd L
.33492 .23017 .56518 .7779 Mabsadd L
.33492 .23017 0 2.5 Mabsadd L closepath F
.3381 .23043 0 2.5 Mabsadd m
.3381 .23043 -0.56518 .7779 Mabsadd L
.3381 .23043 -2.37764 .77254 Mabsadd L
.3381 .23043 -0.91448 -0.29713 Mabsadd L
.3381 .23043 -1.46946 -2.02254 Mabsadd L
.3381 .23043 0 -0.96154 Mabsadd L
.3381 .23043 1.46946 -2.02254 Mabsadd L
.3381 .23043 .91448 -0.29713 Mabsadd L
.3381 .23043 2.37764 .77254 Mabsadd L
.3381 .23043 .56518 .7779 Mabsadd L
.3381 .23043 0 2.5 Mabsadd L closepath F
.34127 .23068 0 2.5 Mabsadd m
.34127 .23068 -0.56518 .7779 Mabsadd L
.34127 .23068 -2.37764 .77254 Mabsadd L
.34127 .23068 -0.91448 -0.29713 Mabsadd L
.34127 .23068 -1.46946 -2.02254 Mabsadd L
.34127 .23068 0 -0.96154 Mabsadd L
.34127 .23068 1.46946 -2.02254 Mabsadd L
.34127 .23068 .91448 -0.29713 Mabsadd L
.34127 .23068 2.37764 .77254 Mabsadd L
.34127 .23068 .56518 .7779 Mabsadd L
.34127 .23068 0 2.5 Mabsadd L closepath F
.34444 .23094 0 2.5 Mabsadd m
.34444 .23094 -0.56518 .7779 Mabsadd L
.34444 .23094 -2.37764 .77254 Mabsadd L
.34444 .23094 -0.91448 -0.29713 Mabsadd L
.34444 .23094 -1.46946 -2.02254 Mabsadd L
.34444 .23094 0 -0.96154 Mabsadd L
.34444 .23094 1.46946 -2.02254 Mabsadd L
.34444 .23094 .91448 -0.29713 Mabsadd L
.34444 .23094 2.37764 .77254 Mabsadd L
.34444 .23094 .56518 .7779 Mabsadd L
.34444 .23094 0 2.5 Mabsadd L closepath F
.34762 .2312 0 2.5 Mabsadd m
.34762 .2312 -0.56518 .7779 Mabsadd L
.34762 .2312 -2.37764 .77254 Mabsadd L
.34762 .2312 -0.91448 -0.29713 Mabsadd L
.34762 .2312 -1.46946 -2.02254 Mabsadd L
.34762 .2312 0 -0.96154 Mabsadd L
.34762 .2312 1.46946 -2.02254 Mabsadd L
.34762 .2312 .91448 -0.29713 Mabsadd L
.34762 .2312 2.37764 .77254 Mabsadd L
.34762 .2312 .56518 .7779 Mabsadd L
.34762 .2312 0 2.5 Mabsadd L closepath F
.35079 .23147 0 2.5 Mabsadd m
.35079 .23147 -0.56518 .7779 Mabsadd L
.35079 .23147 -2.37764 .77254 Mabsadd L
.35079 .23147 -0.91448 -0.29713 Mabsadd L
.35079 .23147 -1.46946 -2.02254 Mabsadd L
.35079 .23147 0 -0.96154 Mabsadd L
.35079 .23147 1.46946 -2.02254 Mabsadd L
.35079 .23147 .91448 -0.29713 Mabsadd L
.35079 .23147 2.37764 .77254 Mabsadd L
.35079 .23147 .56518 .7779 Mabsadd L
.35079 .23147 0 2.5 Mabsadd L closepath F
.35397 .23174 0 2.5 Mabsadd m
.35397 .23174 -0.56518 .7779 Mabsadd L
.35397 .23174 -2.37764 .77254 Mabsadd L
.35397 .23174 -0.91448 -0.29713 Mabsadd L
.35397 .23174 -1.46946 -2.02254 Mabsadd L
.35397 .23174 0 -0.96154 Mabsadd L
.35397 .23174 1.46946 -2.02254 Mabsadd L
.35397 .23174 .91448 -0.29713 Mabsadd L
.35397 .23174 2.37764 .77254 Mabsadd L
.35397 .23174 .56518 .7779 Mabsadd L
.35397 .23174 0 2.5 Mabsadd L closepath F
.35714 .23201 0 2.5 Mabsadd m
.35714 .23201 -0.56518 .7779 Mabsadd L
.35714 .23201 -2.37764 .77254 Mabsadd L
.35714 .23201 -0.91448 -0.29713 Mabsadd L
.35714 .23201 -1.46946 -2.02254 Mabsadd L
.35714 .23201 0 -0.96154 Mabsadd L
.35714 .23201 1.46946 -2.02254 Mabsadd L
.35714 .23201 .91448 -0.29713 Mabsadd L
.35714 .23201 2.37764 .77254 Mabsadd L
.35714 .23201 .56518 .7779 Mabsadd L
.35714 .23201 0 2.5 Mabsadd L closepath F
.36032 .23228 0 2.5 Mabsadd m
.36032 .23228 -0.56518 .7779 Mabsadd L
.36032 .23228 -2.37764 .77254 Mabsadd L
.36032 .23228 -0.91448 -0.29713 Mabsadd L
.36032 .23228 -1.46946 -2.02254 Mabsadd L
.36032 .23228 0 -0.96154 Mabsadd L
.36032 .23228 1.46946 -2.02254 Mabsadd L
.36032 .23228 .91448 -0.29713 Mabsadd L
.36032 .23228 2.37764 .77254 Mabsadd L
.36032 .23228 .56518 .7779 Mabsadd L
.36032 .23228 0 2.5 Mabsadd L closepath F
.36349 .23256 0 2.5 Mabsadd m
.36349 .23256 -0.56518 .7779 Mabsadd L
.36349 .23256 -2.37764 .77254 Mabsadd L
.36349 .23256 -0.91448 -0.29713 Mabsadd L
.36349 .23256 -1.46946 -2.02254 Mabsadd L
.36349 .23256 0 -0.96154 Mabsadd L
.36349 .23256 1.46946 -2.02254 Mabsadd L
.36349 .23256 .91448 -0.29713 Mabsadd L
.36349 .23256 2.37764 .77254 Mabsadd L
.36349 .23256 .56518 .7779 Mabsadd L
.36349 .23256 0 2.5 Mabsadd L closepath F
.36667 .23283 0 2.5 Mabsadd m
.36667 .23283 -0.56518 .7779 Mabsadd L
.36667 .23283 -2.37764 .77254 Mabsadd L
.36667 .23283 -0.91448 -0.29713 Mabsadd L
.36667 .23283 -1.46946 -2.02254 Mabsadd L
.36667 .23283 0 -0.96154 Mabsadd L
.36667 .23283 1.46946 -2.02254 Mabsadd L
.36667 .23283 .91448 -0.29713 Mabsadd L
.36667 .23283 2.37764 .77254 Mabsadd L
.36667 .23283 .56518 .7779 Mabsadd L
.36667 .23283 0 2.5 Mabsadd L closepath F
.36984 .23312 0 2.5 Mabsadd m
.36984 .23312 -0.56518 .7779 Mabsadd L
.36984 .23312 -2.37764 .77254 Mabsadd L
.36984 .23312 -0.91448 -0.29713 Mabsadd L
.36984 .23312 -1.46946 -2.02254 Mabsadd L
.36984 .23312 0 -0.96154 Mabsadd L
.36984 .23312 1.46946 -2.02254 Mabsadd L
.36984 .23312 .91448 -0.29713 Mabsadd L
.36984 .23312 2.37764 .77254 Mabsadd L
.36984 .23312 .56518 .7779 Mabsadd L
.36984 .23312 0 2.5 Mabsadd L closepath F
.37302 .2334 0 2.5 Mabsadd m
.37302 .2334 -0.56518 .7779 Mabsadd L
.37302 .2334 -2.37764 .77254 Mabsadd L
.37302 .2334 -0.91448 -0.29713 Mabsadd L
.37302 .2334 -1.46946 -2.02254 Mabsadd L
.37302 .2334 0 -0.96154 Mabsadd L
.37302 .2334 1.46946 -2.02254 Mabsadd L
.37302 .2334 .91448 -0.29713 Mabsadd L
.37302 .2334 2.37764 .77254 Mabsadd L
.37302 .2334 .56518 .7779 Mabsadd L
.37302 .2334 0 2.5 Mabsadd L closepath F
.37619 .23369 0 2.5 Mabsadd m
.37619 .23369 -0.56518 .7779 Mabsadd L
.37619 .23369 -2.37764 .77254 Mabsadd L
.37619 .23369 -0.91448 -0.29713 Mabsadd L
.37619 .23369 -1.46946 -2.02254 Mabsadd L
.37619 .23369 0 -0.96154 Mabsadd L
.37619 .23369 1.46946 -2.02254 Mabsadd L
.37619 .23369 .91448 -0.29713 Mabsadd L
.37619 .23369 2.37764 .77254 Mabsadd L
.37619 .23369 .56518 .7779 Mabsadd L
.37619 .23369 0 2.5 Mabsadd L closepath F
.37937 .23398 0 2.5 Mabsadd m
.37937 .23398 -0.56518 .7779 Mabsadd L
.37937 .23398 -2.37764 .77254 Mabsadd L
.37937 .23398 -0.91448 -0.29713 Mabsadd L
.37937 .23398 -1.46946 -2.02254 Mabsadd L
.37937 .23398 0 -0.96154 Mabsadd L
.37937 .23398 1.46946 -2.02254 Mabsadd L
.37937 .23398 .91448 -0.29713 Mabsadd L
.37937 .23398 2.37764 .77254 Mabsadd L
.37937 .23398 .56518 .7779 Mabsadd L
.37937 .23398 0 2.5 Mabsadd L closepath F
.38254 .23427 0 2.5 Mabsadd m
.38254 .23427 -0.56518 .7779 Mabsadd L
.38254 .23427 -2.37764 .77254 Mabsadd L
.38254 .23427 -0.91448 -0.29713 Mabsadd L
.38254 .23427 -1.46946 -2.02254 Mabsadd L
.38254 .23427 0 -0.96154 Mabsadd L
.38254 .23427 1.46946 -2.02254 Mabsadd L
.38254 .23427 .91448 -0.29713 Mabsadd L
.38254 .23427 2.37764 .77254 Mabsadd L
.38254 .23427 .56518 .7779 Mabsadd L
.38254 .23427 0 2.5 Mabsadd L closepath F
.38571 .23456 0 2.5 Mabsadd m
.38571 .23456 -0.56518 .7779 Mabsadd L
.38571 .23456 -2.37764 .77254 Mabsadd L
.38571 .23456 -0.91448 -0.29713 Mabsadd L
.38571 .23456 -1.46946 -2.02254 Mabsadd L
.38571 .23456 0 -0.96154 Mabsadd L
.38571 .23456 1.46946 -2.02254 Mabsadd L
.38571 .23456 .91448 -0.29713 Mabsadd L
.38571 .23456 2.37764 .77254 Mabsadd L
.38571 .23456 .56518 .7779 Mabsadd L
.38571 .23456 0 2.5 Mabsadd L closepath F
.38889 .23486 0 2.5 Mabsadd m
.38889 .23486 -0.56518 .7779 Mabsadd L
.38889 .23486 -2.37764 .77254 Mabsadd L
.38889 .23486 -0.91448 -0.29713 Mabsadd L
.38889 .23486 -1.46946 -2.02254 Mabsadd L
.38889 .23486 0 -0.96154 Mabsadd L
.38889 .23486 1.46946 -2.02254 Mabsadd L
.38889 .23486 .91448 -0.29713 Mabsadd L
.38889 .23486 2.37764 .77254 Mabsadd L
.38889 .23486 .56518 .7779 Mabsadd L
.38889 .23486 0 2.5 Mabsadd L closepath F
.39206 .23516 0 2.5 Mabsadd m
.39206 .23516 -0.56518 .7779 Mabsadd L
.39206 .23516 -2.37764 .77254 Mabsadd L
.39206 .23516 -0.91448 -0.29713 Mabsadd L
.39206 .23516 -1.46946 -2.02254 Mabsadd L
.39206 .23516 0 -0.96154 Mabsadd L
.39206 .23516 1.46946 -2.02254 Mabsadd L
.39206 .23516 .91448 -0.29713 Mabsadd L
.39206 .23516 2.37764 .77254 Mabsadd L
.39206 .23516 .56518 .7779 Mabsadd L
.39206 .23516 0 2.5 Mabsadd L closepath F
.39524 .23547 0 2.5 Mabsadd m
.39524 .23547 -0.56518 .7779 Mabsadd L
.39524 .23547 -2.37764 .77254 Mabsadd L
.39524 .23547 -0.91448 -0.29713 Mabsadd L
.39524 .23547 -1.46946 -2.02254 Mabsadd L
.39524 .23547 0 -0.96154 Mabsadd L
.39524 .23547 1.46946 -2.02254 Mabsadd L
.39524 .23547 .91448 -0.29713 Mabsadd L
.39524 .23547 2.37764 .77254 Mabsadd L
.39524 .23547 .56518 .7779 Mabsadd L
.39524 .23547 0 2.5 Mabsadd L closepath F
.39841 .23578 0 2.5 Mabsadd m
.39841 .23578 -0.56518 .7779 Mabsadd L
.39841 .23578 -2.37764 .77254 Mabsadd L
.39841 .23578 -0.91448 -0.29713 Mabsadd L
.39841 .23578 -1.46946 -2.02254 Mabsadd L
.39841 .23578 0 -0.96154 Mabsadd L
.39841 .23578 1.46946 -2.02254 Mabsadd L
.39841 .23578 .91448 -0.29713 Mabsadd L
.39841 .23578 2.37764 .77254 Mabsadd L
.39841 .23578 .56518 .7779 Mabsadd L
.39841 .23578 0 2.5 Mabsadd L closepath F
.40159 .23609 0 2.5 Mabsadd m
.40159 .23609 -0.56518 .7779 Mabsadd L
.40159 .23609 -2.37764 .77254 Mabsadd L
.40159 .23609 -0.91448 -0.29713 Mabsadd L
.40159 .23609 -1.46946 -2.02254 Mabsadd L
.40159 .23609 0 -0.96154 Mabsadd L
.40159 .23609 1.46946 -2.02254 Mabsadd L
.40159 .23609 .91448 -0.29713 Mabsadd L
.40159 .23609 2.37764 .77254 Mabsadd L
.40159 .23609 .56518 .7779 Mabsadd L
.40159 .23609 0 2.5 Mabsadd L closepath F
.40476 .2364 0 2.5 Mabsadd m
.40476 .2364 -0.56518 .7779 Mabsadd L
.40476 .2364 -2.37764 .77254 Mabsadd L
.40476 .2364 -0.91448 -0.29713 Mabsadd L
.40476 .2364 -1.46946 -2.02254 Mabsadd L
.40476 .2364 0 -0.96154 Mabsadd L
.40476 .2364 1.46946 -2.02254 Mabsadd L
.40476 .2364 .91448 -0.29713 Mabsadd L
.40476 .2364 2.37764 .77254 Mabsadd L
.40476 .2364 .56518 .7779 Mabsadd L
.40476 .2364 0 2.5 Mabsadd L closepath F
.40794 .23672 0 2.5 Mabsadd m
.40794 .23672 -0.56518 .7779 Mabsadd L
.40794 .23672 -2.37764 .77254 Mabsadd L
.40794 .23672 -0.91448 -0.29713 Mabsadd L
.40794 .23672 -1.46946 -2.02254 Mabsadd L
.40794 .23672 0 -0.96154 Mabsadd L
.40794 .23672 1.46946 -2.02254 Mabsadd L
.40794 .23672 .91448 -0.29713 Mabsadd L
.40794 .23672 2.37764 .77254 Mabsadd L
.40794 .23672 .56518 .7779 Mabsadd L
.40794 .23672 0 2.5 Mabsadd L closepath F
.41111 .23704 0 2.5 Mabsadd m
.41111 .23704 -0.56518 .7779 Mabsadd L
.41111 .23704 -2.37764 .77254 Mabsadd L
.41111 .23704 -0.91448 -0.29713 Mabsadd L
.41111 .23704 -1.46946 -2.02254 Mabsadd L
.41111 .23704 0 -0.96154 Mabsadd L
.41111 .23704 1.46946 -2.02254 Mabsadd L
.41111 .23704 .91448 -0.29713 Mabsadd L
.41111 .23704 2.37764 .77254 Mabsadd L
.41111 .23704 .56518 .7779 Mabsadd L
.41111 .23704 0 2.5 Mabsadd L closepath F
.41429 .23736 0 2.5 Mabsadd m
.41429 .23736 -0.56518 .7779 Mabsadd L
.41429 .23736 -2.37764 .77254 Mabsadd L
.41429 .23736 -0.91448 -0.29713 Mabsadd L
.41429 .23736 -1.46946 -2.02254 Mabsadd L
.41429 .23736 0 -0.96154 Mabsadd L
.41429 .23736 1.46946 -2.02254 Mabsadd L
.41429 .23736 .91448 -0.29713 Mabsadd L
.41429 .23736 2.37764 .77254 Mabsadd L
.41429 .23736 .56518 .7779 Mabsadd L
.41429 .23736 0 2.5 Mabsadd L closepath F
.41746 .23769 0 2.5 Mabsadd m
.41746 .23769 -0.56518 .7779 Mabsadd L
.41746 .23769 -2.37764 .77254 Mabsadd L
.41746 .23769 -0.91448 -0.29713 Mabsadd L
.41746 .23769 -1.46946 -2.02254 Mabsadd L
.41746 .23769 0 -0.96154 Mabsadd L
.41746 .23769 1.46946 -2.02254 Mabsadd L
.41746 .23769 .91448 -0.29713 Mabsadd L
.41746 .23769 2.37764 .77254 Mabsadd L
.41746 .23769 .56518 .7779 Mabsadd L
.41746 .23769 0 2.5 Mabsadd L closepath F
.42063 .23802 0 2.5 Mabsadd m
.42063 .23802 -0.56518 .7779 Mabsadd L
.42063 .23802 -2.37764 .77254 Mabsadd L
.42063 .23802 -0.91448 -0.29713 Mabsadd L
.42063 .23802 -1.46946 -2.02254 Mabsadd L
.42063 .23802 0 -0.96154 Mabsadd L
.42063 .23802 1.46946 -2.02254 Mabsadd L
.42063 .23802 .91448 -0.29713 Mabsadd L
.42063 .23802 2.37764 .77254 Mabsadd L
.42063 .23802 .56518 .7779 Mabsadd L
.42063 .23802 0 2.5 Mabsadd L closepath F
.42381 .23835 0 2.5 Mabsadd m
.42381 .23835 -0.56518 .7779 Mabsadd L
.42381 .23835 -2.37764 .77254 Mabsadd L
.42381 .23835 -0.91448 -0.29713 Mabsadd L
.42381 .23835 -1.46946 -2.02254 Mabsadd L
.42381 .23835 0 -0.96154 Mabsadd L
.42381 .23835 1.46946 -2.02254 Mabsadd L
.42381 .23835 .91448 -0.29713 Mabsadd L
.42381 .23835 2.37764 .77254 Mabsadd L
.42381 .23835 .56518 .7779 Mabsadd L
.42381 .23835 0 2.5 Mabsadd L closepath F
.42698 .23869 0 2.5 Mabsadd m
.42698 .23869 -0.56518 .7779 Mabsadd L
.42698 .23869 -2.37764 .77254 Mabsadd L
.42698 .23869 -0.91448 -0.29713 Mabsadd L
.42698 .23869 -1.46946 -2.02254 Mabsadd L
.42698 .23869 0 -0.96154 Mabsadd L
.42698 .23869 1.46946 -2.02254 Mabsadd L
.42698 .23869 .91448 -0.29713 Mabsadd L
.42698 .23869 2.37764 .77254 Mabsadd L
.42698 .23869 .56518 .7779 Mabsadd L
.42698 .23869 0 2.5 Mabsadd L closepath F
.43016 .23903 0 2.5 Mabsadd m
.43016 .23903 -0.56518 .7779 Mabsadd L
.43016 .23903 -2.37764 .77254 Mabsadd L
.43016 .23903 -0.91448 -0.29713 Mabsadd L
.43016 .23903 -1.46946 -2.02254 Mabsadd L
.43016 .23903 0 -0.96154 Mabsadd L
.43016 .23903 1.46946 -2.02254 Mabsadd L
.43016 .23903 .91448 -0.29713 Mabsadd L
.43016 .23903 2.37764 .77254 Mabsadd L
.43016 .23903 .56518 .7779 Mabsadd L
.43016 .23903 0 2.5 Mabsadd L closepath F
.43333 .23937 0 2.5 Mabsadd m
.43333 .23937 -0.56518 .7779 Mabsadd L
.43333 .23937 -2.37764 .77254 Mabsadd L
.43333 .23937 -0.91448 -0.29713 Mabsadd L
.43333 .23937 -1.46946 -2.02254 Mabsadd L
.43333 .23937 0 -0.96154 Mabsadd L
.43333 .23937 1.46946 -2.02254 Mabsadd L
.43333 .23937 .91448 -0.29713 Mabsadd L
.43333 .23937 2.37764 .77254 Mabsadd L
.43333 .23937 .56518 .7779 Mabsadd L
.43333 .23937 0 2.5 Mabsadd L closepath F
.43651 .23972 0 2.5 Mabsadd m
.43651 .23972 -0.56518 .7779 Mabsadd L
.43651 .23972 -2.37764 .77254 Mabsadd L
.43651 .23972 -0.91448 -0.29713 Mabsadd L
.43651 .23972 -1.46946 -2.02254 Mabsadd L
.43651 .23972 0 -0.96154 Mabsadd L
.43651 .23972 1.46946 -2.02254 Mabsadd L
.43651 .23972 .91448 -0.29713 Mabsadd L
.43651 .23972 2.37764 .77254 Mabsadd L
.43651 .23972 .56518 .7779 Mabsadd L
.43651 .23972 0 2.5 Mabsadd L closepath F
.43968 .24007 0 2.5 Mabsadd m
.43968 .24007 -0.56518 .7779 Mabsadd L
.43968 .24007 -2.37764 .77254 Mabsadd L
.43968 .24007 -0.91448 -0.29713 Mabsadd L
.43968 .24007 -1.46946 -2.02254 Mabsadd L
.43968 .24007 0 -0.96154 Mabsadd L
.43968 .24007 1.46946 -2.02254 Mabsadd L
.43968 .24007 .91448 -0.29713 Mabsadd L
.43968 .24007 2.37764 .77254 Mabsadd L
.43968 .24007 .56518 .7779 Mabsadd L
.43968 .24007 0 2.5 Mabsadd L closepath F
.44286 .24042 0 2.5 Mabsadd m
.44286 .24042 -0.56518 .7779 Mabsadd L
.44286 .24042 -2.37764 .77254 Mabsadd L
.44286 .24042 -0.91448 -0.29713 Mabsadd L
.44286 .24042 -1.46946 -2.02254 Mabsadd L
.44286 .24042 0 -0.96154 Mabsadd L
.44286 .24042 1.46946 -2.02254 Mabsadd L
.44286 .24042 .91448 -0.29713 Mabsadd L
.44286 .24042 2.37764 .77254 Mabsadd L
.44286 .24042 .56518 .7779 Mabsadd L
.44286 .24042 0 2.5 Mabsadd L closepath F
.44603 .24078 0 2.5 Mabsadd m
.44603 .24078 -0.56518 .7779 Mabsadd L
.44603 .24078 -2.37764 .77254 Mabsadd L
.44603 .24078 -0.91448 -0.29713 Mabsadd L
.44603 .24078 -1.46946 -2.02254 Mabsadd L
.44603 .24078 0 -0.96154 Mabsadd L
.44603 .24078 1.46946 -2.02254 Mabsadd L
.44603 .24078 .91448 -0.29713 Mabsadd L
.44603 .24078 2.37764 .77254 Mabsadd L
.44603 .24078 .56518 .7779 Mabsadd L
.44603 .24078 0 2.5 Mabsadd L closepath F
.44921 .24114 0 2.5 Mabsadd m
.44921 .24114 -0.56518 .7779 Mabsadd L
.44921 .24114 -2.37764 .77254 Mabsadd L
.44921 .24114 -0.91448 -0.29713 Mabsadd L
.44921 .24114 -1.46946 -2.02254 Mabsadd L
.44921 .24114 0 -0.96154 Mabsadd L
.44921 .24114 1.46946 -2.02254 Mabsadd L
.44921 .24114 .91448 -0.29713 Mabsadd L
.44921 .24114 2.37764 .77254 Mabsadd L
.44921 .24114 .56518 .7779 Mabsadd L
.44921 .24114 0 2.5 Mabsadd L closepath F
.45238 .2415 0 2.5 Mabsadd m
.45238 .2415 -0.56518 .7779 Mabsadd L
.45238 .2415 -2.37764 .77254 Mabsadd L
.45238 .2415 -0.91448 -0.29713 Mabsadd L
.45238 .2415 -1.46946 -2.02254 Mabsadd L
.45238 .2415 0 -0.96154 Mabsadd L
.45238 .2415 1.46946 -2.02254 Mabsadd L
.45238 .2415 .91448 -0.29713 Mabsadd L
.45238 .2415 2.37764 .77254 Mabsadd L
.45238 .2415 .56518 .7779 Mabsadd L
.45238 .2415 0 2.5 Mabsadd L closepath F
.45556 .24187 0 2.5 Mabsadd m
.45556 .24187 -0.56518 .7779 Mabsadd L
.45556 .24187 -2.37764 .77254 Mabsadd L
.45556 .24187 -0.91448 -0.29713 Mabsadd L
.45556 .24187 -1.46946 -2.02254 Mabsadd L
.45556 .24187 0 -0.96154 Mabsadd L
.45556 .24187 1.46946 -2.02254 Mabsadd L
.45556 .24187 .91448 -0.29713 Mabsadd L
.45556 .24187 2.37764 .77254 Mabsadd L
.45556 .24187 .56518 .7779 Mabsadd L
.45556 .24187 0 2.5 Mabsadd L closepath F
.45873 .24224 0 2.5 Mabsadd m
.45873 .24224 -0.56518 .7779 Mabsadd L
.45873 .24224 -2.37764 .77254 Mabsadd L
.45873 .24224 -0.91448 -0.29713 Mabsadd L
.45873 .24224 -1.46946 -2.02254 Mabsadd L
.45873 .24224 0 -0.96154 Mabsadd L
.45873 .24224 1.46946 -2.02254 Mabsadd L
.45873 .24224 .91448 -0.29713 Mabsadd L
.45873 .24224 2.37764 .77254 Mabsadd L
.45873 .24224 .56518 .7779 Mabsadd L
.45873 .24224 0 2.5 Mabsadd L closepath F
.4619 .24262 0 2.5 Mabsadd m
.4619 .24262 -0.56518 .7779 Mabsadd L
.4619 .24262 -2.37764 .77254 Mabsadd L
.4619 .24262 -0.91448 -0.29713 Mabsadd L
.4619 .24262 -1.46946 -2.02254 Mabsadd L
.4619 .24262 0 -0.96154 Mabsadd L
.4619 .24262 1.46946 -2.02254 Mabsadd L
.4619 .24262 .91448 -0.29713 Mabsadd L
.4619 .24262 2.37764 .77254 Mabsadd L
.4619 .24262 .56518 .7779 Mabsadd L
.4619 .24262 0 2.5 Mabsadd L closepath F
.46508 .243 0 2.5 Mabsadd m
.46508 .243 -0.56518 .7779 Mabsadd L
.46508 .243 -2.37764 .77254 Mabsadd L
.46508 .243 -0.91448 -0.29713 Mabsadd L
.46508 .243 -1.46946 -2.02254 Mabsadd L
.46508 .243 0 -0.96154 Mabsadd L
.46508 .243 1.46946 -2.02254 Mabsadd L
.46508 .243 .91448 -0.29713 Mabsadd L
.46508 .243 2.37764 .77254 Mabsadd L
.46508 .243 .56518 .7779 Mabsadd L
.46508 .243 0 2.5 Mabsadd L closepath F
.46825 .24338 0 2.5 Mabsadd m
.46825 .24338 -0.56518 .7779 Mabsadd L
.46825 .24338 -2.37764 .77254 Mabsadd L
.46825 .24338 -0.91448 -0.29713 Mabsadd L
.46825 .24338 -1.46946 -2.02254 Mabsadd L
.46825 .24338 0 -0.96154 Mabsadd L
.46825 .24338 1.46946 -2.02254 Mabsadd L
.46825 .24338 .91448 -0.29713 Mabsadd L
.46825 .24338 2.37764 .77254 Mabsadd L
.46825 .24338 .56518 .7779 Mabsadd L
.46825 .24338 0 2.5 Mabsadd L closepath F
.47143 .24377 0 2.5 Mabsadd m
.47143 .24377 -0.56518 .7779 Mabsadd L
.47143 .24377 -2.37764 .77254 Mabsadd L
.47143 .24377 -0.91448 -0.29713 Mabsadd L
.47143 .24377 -1.46946 -2.02254 Mabsadd L
.47143 .24377 0 -0.96154 Mabsadd L
.47143 .24377 1.46946 -2.02254 Mabsadd L
.47143 .24377 .91448 -0.29713 Mabsadd L
.47143 .24377 2.37764 .77254 Mabsadd L
.47143 .24377 .56518 .7779 Mabsadd L
.47143 .24377 0 2.5 Mabsadd L closepath F
.4746 .24416 0 2.5 Mabsadd m
.4746 .24416 -0.56518 .7779 Mabsadd L
.4746 .24416 -2.37764 .77254 Mabsadd L
.4746 .24416 -0.91448 -0.29713 Mabsadd L
.4746 .24416 -1.46946 -2.02254 Mabsadd L
.4746 .24416 0 -0.96154 Mabsadd L
.4746 .24416 1.46946 -2.02254 Mabsadd L
.4746 .24416 .91448 -0.29713 Mabsadd L
.4746 .24416 2.37764 .77254 Mabsadd L
.4746 .24416 .56518 .7779 Mabsadd L
.4746 .24416 0 2.5 Mabsadd L closepath F
.47778 .24455 0 2.5 Mabsadd m
.47778 .24455 -0.56518 .7779 Mabsadd L
.47778 .24455 -2.37764 .77254 Mabsadd L
.47778 .24455 -0.91448 -0.29713 Mabsadd L
.47778 .24455 -1.46946 -2.02254 Mabsadd L
.47778 .24455 0 -0.96154 Mabsadd L
.47778 .24455 1.46946 -2.02254 Mabsadd L
.47778 .24455 .91448 -0.29713 Mabsadd L
.47778 .24455 2.37764 .77254 Mabsadd L
.47778 .24455 .56518 .7779 Mabsadd L
.47778 .24455 0 2.5 Mabsadd L closepath F
.48095 .24495 0 2.5 Mabsadd m
.48095 .24495 -0.56518 .7779 Mabsadd L
.48095 .24495 -2.37764 .77254 Mabsadd L
.48095 .24495 -0.91448 -0.29713 Mabsadd L
.48095 .24495 -1.46946 -2.02254 Mabsadd L
.48095 .24495 0 -0.96154 Mabsadd L
.48095 .24495 1.46946 -2.02254 Mabsadd L
.48095 .24495 .91448 -0.29713 Mabsadd L
.48095 .24495 2.37764 .77254 Mabsadd L
.48095 .24495 .56518 .7779 Mabsadd L
.48095 .24495 0 2.5 Mabsadd L closepath F
.48413 .24535 0 2.5 Mabsadd m
.48413 .24535 -0.56518 .7779 Mabsadd L
.48413 .24535 -2.37764 .77254 Mabsadd L
.48413 .24535 -0.91448 -0.29713 Mabsadd L
.48413 .24535 -1.46946 -2.02254 Mabsadd L
.48413 .24535 0 -0.96154 Mabsadd L
.48413 .24535 1.46946 -2.02254 Mabsadd L
.48413 .24535 .91448 -0.29713 Mabsadd L
.48413 .24535 2.37764 .77254 Mabsadd L
.48413 .24535 .56518 .7779 Mabsadd L
.48413 .24535 0 2.5 Mabsadd L closepath F
.4873 .24576 0 2.5 Mabsadd m
.4873 .24576 -0.56518 .7779 Mabsadd L
.4873 .24576 -2.37764 .77254 Mabsadd L
.4873 .24576 -0.91448 -0.29713 Mabsadd L
.4873 .24576 -1.46946 -2.02254 Mabsadd L
.4873 .24576 0 -0.96154 Mabsadd L
.4873 .24576 1.46946 -2.02254 Mabsadd L
.4873 .24576 .91448 -0.29713 Mabsadd L
.4873 .24576 2.37764 .77254 Mabsadd L
.4873 .24576 .56518 .7779 Mabsadd L
.4873 .24576 0 2.5 Mabsadd L closepath F
.49048 .24617 0 2.5 Mabsadd m
.49048 .24617 -0.56518 .7779 Mabsadd L
.49048 .24617 -2.37764 .77254 Mabsadd L
.49048 .24617 -0.91448 -0.29713 Mabsadd L
.49048 .24617 -1.46946 -2.02254 Mabsadd L
.49048 .24617 0 -0.96154 Mabsadd L
.49048 .24617 1.46946 -2.02254 Mabsadd L
.49048 .24617 .91448 -0.29713 Mabsadd L
.49048 .24617 2.37764 .77254 Mabsadd L
.49048 .24617 .56518 .7779 Mabsadd L
.49048 .24617 0 2.5 Mabsadd L closepath F
.49365 .24658 0 2.5 Mabsadd m
.49365 .24658 -0.56518 .7779 Mabsadd L
.49365 .24658 -2.37764 .77254 Mabsadd L
.49365 .24658 -0.91448 -0.29713 Mabsadd L
.49365 .24658 -1.46946 -2.02254 Mabsadd L
.49365 .24658 0 -0.96154 Mabsadd L
.49365 .24658 1.46946 -2.02254 Mabsadd L
.49365 .24658 .91448 -0.29713 Mabsadd L
.49365 .24658 2.37764 .77254 Mabsadd L
.49365 .24658 .56518 .7779 Mabsadd L
.49365 .24658 0 2.5 Mabsadd L closepath F
.49683 .247 0 2.5 Mabsadd m
.49683 .247 -0.56518 .7779 Mabsadd L
.49683 .247 -2.37764 .77254 Mabsadd L
.49683 .247 -0.91448 -0.29713 Mabsadd L
.49683 .247 -1.46946 -2.02254 Mabsadd L
.49683 .247 0 -0.96154 Mabsadd L
.49683 .247 1.46946 -2.02254 Mabsadd L
.49683 .247 .91448 -0.29713 Mabsadd L
.49683 .247 2.37764 .77254 Mabsadd L
.49683 .247 .56518 .7779 Mabsadd L
.49683 .247 0 2.5 Mabsadd L closepath F
.5 .24742 0 2.5 Mabsadd m
.5 .24742 -0.56518 .7779 Mabsadd L
.5 .24742 -2.37764 .77254 Mabsadd L
.5 .24742 -0.91448 -0.29713 Mabsadd L
.5 .24742 -1.46946 -2.02254 Mabsadd L
.5 .24742 0 -0.96154 Mabsadd L
.5 .24742 1.46946 -2.02254 Mabsadd L
.5 .24742 .91448 -0.29713 Mabsadd L
.5 .24742 2.37764 .77254 Mabsadd L
.5 .24742 .56518 .7779 Mabsadd L
.5 .24742 0 2.5 Mabsadd L closepath F
.50317 .24785 0 2.5 Mabsadd m
.50317 .24785 -0.56518 .7779 Mabsadd L
.50317 .24785 -2.37764 .77254 Mabsadd L
.50317 .24785 -0.91448 -0.29713 Mabsadd L
.50317 .24785 -1.46946 -2.02254 Mabsadd L
.50317 .24785 0 -0.96154 Mabsadd L
.50317 .24785 1.46946 -2.02254 Mabsadd L
.50317 .24785 .91448 -0.29713 Mabsadd L
.50317 .24785 2.37764 .77254 Mabsadd L
.50317 .24785 .56518 .7779 Mabsadd L
.50317 .24785 0 2.5 Mabsadd L closepath F
.50635 .24828 0 2.5 Mabsadd m
.50635 .24828 -0.56518 .7779 Mabsadd L
.50635 .24828 -2.37764 .77254 Mabsadd L
.50635 .24828 -0.91448 -0.29713 Mabsadd L
.50635 .24828 -1.46946 -2.02254 Mabsadd L
.50635 .24828 0 -0.96154 Mabsadd L
.50635 .24828 1.46946 -2.02254 Mabsadd L
.50635 .24828 .91448 -0.29713 Mabsadd L
.50635 .24828 2.37764 .77254 Mabsadd L
.50635 .24828 .56518 .7779 Mabsadd L
.50635 .24828 0 2.5 Mabsadd L closepath F
.50952 .24872 0 2.5 Mabsadd m
.50952 .24872 -0.56518 .7779 Mabsadd L
.50952 .24872 -2.37764 .77254 Mabsadd L
.50952 .24872 -0.91448 -0.29713 Mabsadd L
.50952 .24872 -1.46946 -2.02254 Mabsadd L
.50952 .24872 0 -0.96154 Mabsadd L
.50952 .24872 1.46946 -2.02254 Mabsadd L
.50952 .24872 .91448 -0.29713 Mabsadd L
.50952 .24872 2.37764 .77254 Mabsadd L
.50952 .24872 .56518 .7779 Mabsadd L
.50952 .24872 0 2.5 Mabsadd L closepath F
.5127 .24916 0 2.5 Mabsadd m
.5127 .24916 -0.56518 .7779 Mabsadd L
.5127 .24916 -2.37764 .77254 Mabsadd L
.5127 .24916 -0.91448 -0.29713 Mabsadd L
.5127 .24916 -1.46946 -2.02254 Mabsadd L
.5127 .24916 0 -0.96154 Mabsadd L
.5127 .24916 1.46946 -2.02254 Mabsadd L
.5127 .24916 .91448 -0.29713 Mabsadd L
.5127 .24916 2.37764 .77254 Mabsadd L
.5127 .24916 .56518 .7779 Mabsadd L
.5127 .24916 0 2.5 Mabsadd L closepath F
.51587 .2496 0 2.5 Mabsadd m
.51587 .2496 -0.56518 .7779 Mabsadd L
.51587 .2496 -2.37764 .77254 Mabsadd L
.51587 .2496 -0.91448 -0.29713 Mabsadd L
.51587 .2496 -1.46946 -2.02254 Mabsadd L
.51587 .2496 0 -0.96154 Mabsadd L
.51587 .2496 1.46946 -2.02254 Mabsadd L
.51587 .2496 .91448 -0.29713 Mabsadd L
.51587 .2496 2.37764 .77254 Mabsadd L
.51587 .2496 .56518 .7779 Mabsadd L
.51587 .2496 0 2.5 Mabsadd L closepath F
.51905 .25005 0 2.5 Mabsadd m
.51905 .25005 -0.56518 .7779 Mabsadd L
.51905 .25005 -2.37764 .77254 Mabsadd L
.51905 .25005 -0.91448 -0.29713 Mabsadd L
.51905 .25005 -1.46946 -2.02254 Mabsadd L
.51905 .25005 0 -0.96154 Mabsadd L
.51905 .25005 1.46946 -2.02254 Mabsadd L
.51905 .25005 .91448 -0.29713 Mabsadd L
.51905 .25005 2.37764 .77254 Mabsadd L
.51905 .25005 .56518 .7779 Mabsadd L
.51905 .25005 0 2.5 Mabsadd L closepath F
.52222 .2505 0 2.5 Mabsadd m
.52222 .2505 -0.56518 .7779 Mabsadd L
.52222 .2505 -2.37764 .77254 Mabsadd L
.52222 .2505 -0.91448 -0.29713 Mabsadd L
.52222 .2505 -1.46946 -2.02254 Mabsadd L
.52222 .2505 0 -0.96154 Mabsadd L
.52222 .2505 1.46946 -2.02254 Mabsadd L
.52222 .2505 .91448 -0.29713 Mabsadd L
.52222 .2505 2.37764 .77254 Mabsadd L
.52222 .2505 .56518 .7779 Mabsadd L
.52222 .2505 0 2.5 Mabsadd L closepath F
.5254 .25096 0 2.5 Mabsadd m
.5254 .25096 -0.56518 .7779 Mabsadd L
.5254 .25096 -2.37764 .77254 Mabsadd L
.5254 .25096 -0.91448 -0.29713 Mabsadd L
.5254 .25096 -1.46946 -2.02254 Mabsadd L
.5254 .25096 0 -0.96154 Mabsadd L
.5254 .25096 1.46946 -2.02254 Mabsadd L
.5254 .25096 .91448 -0.29713 Mabsadd L
.5254 .25096 2.37764 .77254 Mabsadd L
.5254 .25096 .56518 .7779 Mabsadd L
.5254 .25096 0 2.5 Mabsadd L closepath F
.52857 .25143 0 2.5 Mabsadd m
.52857 .25143 -0.56518 .7779 Mabsadd L
.52857 .25143 -2.37764 .77254 Mabsadd L
.52857 .25143 -0.91448 -0.29713 Mabsadd L
.52857 .25143 -1.46946 -2.02254 Mabsadd L
.52857 .25143 0 -0.96154 Mabsadd L
.52857 .25143 1.46946 -2.02254 Mabsadd L
.52857 .25143 .91448 -0.29713 Mabsadd L
.52857 .25143 2.37764 .77254 Mabsadd L
.52857 .25143 .56518 .7779 Mabsadd L
.52857 .25143 0 2.5 Mabsadd L closepath F
.53175 .25189 0 2.5 Mabsadd m
.53175 .25189 -0.56518 .7779 Mabsadd L
.53175 .25189 -2.37764 .77254 Mabsadd L
.53175 .25189 -0.91448 -0.29713 Mabsadd L
.53175 .25189 -1.46946 -2.02254 Mabsadd L
.53175 .25189 0 -0.96154 Mabsadd L
.53175 .25189 1.46946 -2.02254 Mabsadd L
.53175 .25189 .91448 -0.29713 Mabsadd L
.53175 .25189 2.37764 .77254 Mabsadd L
.53175 .25189 .56518 .7779 Mabsadd L
.53175 .25189 0 2.5 Mabsadd L closepath F
.53492 .25236 0 2.5 Mabsadd m
.53492 .25236 -0.56518 .7779 Mabsadd L
.53492 .25236 -2.37764 .77254 Mabsadd L
.53492 .25236 -0.91448 -0.29713 Mabsadd L
.53492 .25236 -1.46946 -2.02254 Mabsadd L
.53492 .25236 0 -0.96154 Mabsadd L
.53492 .25236 1.46946 -2.02254 Mabsadd L
.53492 .25236 .91448 -0.29713 Mabsadd L
.53492 .25236 2.37764 .77254 Mabsadd L
.53492 .25236 .56518 .7779 Mabsadd L
.53492 .25236 0 2.5 Mabsadd L closepath F
.5381 .25284 0 2.5 Mabsadd m
.5381 .25284 -0.56518 .7779 Mabsadd L
.5381 .25284 -2.37764 .77254 Mabsadd L
.5381 .25284 -0.91448 -0.29713 Mabsadd L
.5381 .25284 -1.46946 -2.02254 Mabsadd L
.5381 .25284 0 -0.96154 Mabsadd L
.5381 .25284 1.46946 -2.02254 Mabsadd L
.5381 .25284 .91448 -0.29713 Mabsadd L
.5381 .25284 2.37764 .77254 Mabsadd L
.5381 .25284 .56518 .7779 Mabsadd L
.5381 .25284 0 2.5 Mabsadd L closepath F
.54127 .25332 0 2.5 Mabsadd m
.54127 .25332 -0.56518 .7779 Mabsadd L
.54127 .25332 -2.37764 .77254 Mabsadd L
.54127 .25332 -0.91448 -0.29713 Mabsadd L
.54127 .25332 -1.46946 -2.02254 Mabsadd L
.54127 .25332 0 -0.96154 Mabsadd L
.54127 .25332 1.46946 -2.02254 Mabsadd L
.54127 .25332 .91448 -0.29713 Mabsadd L
.54127 .25332 2.37764 .77254 Mabsadd L
.54127 .25332 .56518 .7779 Mabsadd L
.54127 .25332 0 2.5 Mabsadd L closepath F
.54444 .25381 0 2.5 Mabsadd m
.54444 .25381 -0.56518 .7779 Mabsadd L
.54444 .25381 -2.37764 .77254 Mabsadd L
.54444 .25381 -0.91448 -0.29713 Mabsadd L
.54444 .25381 -1.46946 -2.02254 Mabsadd L
.54444 .25381 0 -0.96154 Mabsadd L
.54444 .25381 1.46946 -2.02254 Mabsadd L
.54444 .25381 .91448 -0.29713 Mabsadd L
.54444 .25381 2.37764 .77254 Mabsadd L
.54444 .25381 .56518 .7779 Mabsadd L
.54444 .25381 0 2.5 Mabsadd L closepath F
.54762 .2543 0 2.5 Mabsadd m
.54762 .2543 -0.56518 .7779 Mabsadd L
.54762 .2543 -2.37764 .77254 Mabsadd L
.54762 .2543 -0.91448 -0.29713 Mabsadd L
.54762 .2543 -1.46946 -2.02254 Mabsadd L
.54762 .2543 0 -0.96154 Mabsadd L
.54762 .2543 1.46946 -2.02254 Mabsadd L
.54762 .2543 .91448 -0.29713 Mabsadd L
.54762 .2543 2.37764 .77254 Mabsadd L
.54762 .2543 .56518 .7779 Mabsadd L
.54762 .2543 0 2.5 Mabsadd L closepath F
.55079 .25479 0 2.5 Mabsadd m
.55079 .25479 -0.56518 .7779 Mabsadd L
.55079 .25479 -2.37764 .77254 Mabsadd L
.55079 .25479 -0.91448 -0.29713 Mabsadd L
.55079 .25479 -1.46946 -2.02254 Mabsadd L
.55079 .25479 0 -0.96154 Mabsadd L
.55079 .25479 1.46946 -2.02254 Mabsadd L
.55079 .25479 .91448 -0.29713 Mabsadd L
.55079 .25479 2.37764 .77254 Mabsadd L
.55079 .25479 .56518 .7779 Mabsadd L
.55079 .25479 0 2.5 Mabsadd L closepath F
.55397 .2553 0 2.5 Mabsadd m
.55397 .2553 -0.56518 .7779 Mabsadd L
.55397 .2553 -2.37764 .77254 Mabsadd L
.55397 .2553 -0.91448 -0.29713 Mabsadd L
.55397 .2553 -1.46946 -2.02254 Mabsadd L
.55397 .2553 0 -0.96154 Mabsadd L
.55397 .2553 1.46946 -2.02254 Mabsadd L
.55397 .2553 .91448 -0.29713 Mabsadd L
.55397 .2553 2.37764 .77254 Mabsadd L
.55397 .2553 .56518 .7779 Mabsadd L
.55397 .2553 0 2.5 Mabsadd L closepath F
.55714 .2558 0 2.5 Mabsadd m
.55714 .2558 -0.56518 .7779 Mabsadd L
.55714 .2558 -2.37764 .77254 Mabsadd L
.55714 .2558 -0.91448 -0.29713 Mabsadd L
.55714 .2558 -1.46946 -2.02254 Mabsadd L
.55714 .2558 0 -0.96154 Mabsadd L
.55714 .2558 1.46946 -2.02254 Mabsadd L
.55714 .2558 .91448 -0.29713 Mabsadd L
.55714 .2558 2.37764 .77254 Mabsadd L
.55714 .2558 .56518 .7779 Mabsadd L
.55714 .2558 0 2.5 Mabsadd L closepath F
.56032 .25631 0 2.5 Mabsadd m
.56032 .25631 -0.56518 .7779 Mabsadd L
.56032 .25631 -2.37764 .77254 Mabsadd L
.56032 .25631 -0.91448 -0.29713 Mabsadd L
.56032 .25631 -1.46946 -2.02254 Mabsadd L
.56032 .25631 0 -0.96154 Mabsadd L
.56032 .25631 1.46946 -2.02254 Mabsadd L
.56032 .25631 .91448 -0.29713 Mabsadd L
.56032 .25631 2.37764 .77254 Mabsadd L
.56032 .25631 .56518 .7779 Mabsadd L
.56032 .25631 0 2.5 Mabsadd L closepath F
.56349 .25683 0 2.5 Mabsadd m
.56349 .25683 -0.56518 .7779 Mabsadd L
.56349 .25683 -2.37764 .77254 Mabsadd L
.56349 .25683 -0.91448 -0.29713 Mabsadd L
.56349 .25683 -1.46946 -2.02254 Mabsadd L
.56349 .25683 0 -0.96154 Mabsadd L
.56349 .25683 1.46946 -2.02254 Mabsadd L
.56349 .25683 .91448 -0.29713 Mabsadd L
.56349 .25683 2.37764 .77254 Mabsadd L
.56349 .25683 .56518 .7779 Mabsadd L
.56349 .25683 0 2.5 Mabsadd L closepath F
.56667 .25735 0 2.5 Mabsadd m
.56667 .25735 -0.56518 .7779 Mabsadd L
.56667 .25735 -2.37764 .77254 Mabsadd L
.56667 .25735 -0.91448 -0.29713 Mabsadd L
.56667 .25735 -1.46946 -2.02254 Mabsadd L
.56667 .25735 0 -0.96154 Mabsadd L
.56667 .25735 1.46946 -2.02254 Mabsadd L
.56667 .25735 .91448 -0.29713 Mabsadd L
.56667 .25735 2.37764 .77254 Mabsadd L
.56667 .25735 .56518 .7779 Mabsadd L
.56667 .25735 0 2.5 Mabsadd L closepath F
.56984 .25788 0 2.5 Mabsadd m
.56984 .25788 -0.56518 .7779 Mabsadd L
.56984 .25788 -2.37764 .77254 Mabsadd L
.56984 .25788 -0.91448 -0.29713 Mabsadd L
.56984 .25788 -1.46946 -2.02254 Mabsadd L
.56984 .25788 0 -0.96154 Mabsadd L
.56984 .25788 1.46946 -2.02254 Mabsadd L
.56984 .25788 .91448 -0.29713 Mabsadd L
.56984 .25788 2.37764 .77254 Mabsadd L
.56984 .25788 .56518 .7779 Mabsadd L
.56984 .25788 0 2.5 Mabsadd L closepath F
.57302 .25841 0 2.5 Mabsadd m
.57302 .25841 -0.56518 .7779 Mabsadd L
.57302 .25841 -2.37764 .77254 Mabsadd L
.57302 .25841 -0.91448 -0.29713 Mabsadd L
.57302 .25841 -1.46946 -2.02254 Mabsadd L
.57302 .25841 0 -0.96154 Mabsadd L
.57302 .25841 1.46946 -2.02254 Mabsadd L
.57302 .25841 .91448 -0.29713 Mabsadd L
.57302 .25841 2.37764 .77254 Mabsadd L
.57302 .25841 .56518 .7779 Mabsadd L
.57302 .25841 0 2.5 Mabsadd L closepath F
.57619 .25894 0 2.5 Mabsadd m
.57619 .25894 -0.56518 .7779 Mabsadd L
.57619 .25894 -2.37764 .77254 Mabsadd L
.57619 .25894 -0.91448 -0.29713 Mabsadd L
.57619 .25894 -1.46946 -2.02254 Mabsadd L
.57619 .25894 0 -0.96154 Mabsadd L
.57619 .25894 1.46946 -2.02254 Mabsadd L
.57619 .25894 .91448 -0.29713 Mabsadd L
.57619 .25894 2.37764 .77254 Mabsadd L
.57619 .25894 .56518 .7779 Mabsadd L
.57619 .25894 0 2.5 Mabsadd L closepath F
.57937 .25949 0 2.5 Mabsadd m
.57937 .25949 -0.56518 .7779 Mabsadd L
.57937 .25949 -2.37764 .77254 Mabsadd L
.57937 .25949 -0.91448 -0.29713 Mabsadd L
.57937 .25949 -1.46946 -2.02254 Mabsadd L
.57937 .25949 0 -0.96154 Mabsadd L
.57937 .25949 1.46946 -2.02254 Mabsadd L
.57937 .25949 .91448 -0.29713 Mabsadd L
.57937 .25949 2.37764 .77254 Mabsadd L
.57937 .25949 .56518 .7779 Mabsadd L
.57937 .25949 0 2.5 Mabsadd L closepath F
.58254 .26003 0 2.5 Mabsadd m
.58254 .26003 -0.56518 .7779 Mabsadd L
.58254 .26003 -2.37764 .77254 Mabsadd L
.58254 .26003 -0.91448 -0.29713 Mabsadd L
.58254 .26003 -1.46946 -2.02254 Mabsadd L
.58254 .26003 0 -0.96154 Mabsadd L
.58254 .26003 1.46946 -2.02254 Mabsadd L
.58254 .26003 .91448 -0.29713 Mabsadd L
.58254 .26003 2.37764 .77254 Mabsadd L
.58254 .26003 .56518 .7779 Mabsadd L
.58254 .26003 0 2.5 Mabsadd L closepath F
.58571 .26059 0 2.5 Mabsadd m
.58571 .26059 -0.56518 .7779 Mabsadd L
.58571 .26059 -2.37764 .77254 Mabsadd L
.58571 .26059 -0.91448 -0.29713 Mabsadd L
.58571 .26059 -1.46946 -2.02254 Mabsadd L
.58571 .26059 0 -0.96154 Mabsadd L
.58571 .26059 1.46946 -2.02254 Mabsadd L
.58571 .26059 .91448 -0.29713 Mabsadd L
.58571 .26059 2.37764 .77254 Mabsadd L
.58571 .26059 .56518 .7779 Mabsadd L
.58571 .26059 0 2.5 Mabsadd L closepath F
.58889 .26115 0 2.5 Mabsadd m
.58889 .26115 -0.56518 .7779 Mabsadd L
.58889 .26115 -2.37764 .77254 Mabsadd L
.58889 .26115 -0.91448 -0.29713 Mabsadd L
.58889 .26115 -1.46946 -2.02254 Mabsadd L
.58889 .26115 0 -0.96154 Mabsadd L
.58889 .26115 1.46946 -2.02254 Mabsadd L
.58889 .26115 .91448 -0.29713 Mabsadd L
.58889 .26115 2.37764 .77254 Mabsadd L
.58889 .26115 .56518 .7779 Mabsadd L
.58889 .26115 0 2.5 Mabsadd L closepath F
.59206 .26171 0 2.5 Mabsadd m
.59206 .26171 -0.56518 .7779 Mabsadd L
.59206 .26171 -2.37764 .77254 Mabsadd L
.59206 .26171 -0.91448 -0.29713 Mabsadd L
.59206 .26171 -1.46946 -2.02254 Mabsadd L
.59206 .26171 0 -0.96154 Mabsadd L
.59206 .26171 1.46946 -2.02254 Mabsadd L
.59206 .26171 .91448 -0.29713 Mabsadd L
.59206 .26171 2.37764 .77254 Mabsadd L
.59206 .26171 .56518 .7779 Mabsadd L
.59206 .26171 0 2.5 Mabsadd L closepath F
.59524 .26228 0 2.5 Mabsadd m
.59524 .26228 -0.56518 .7779 Mabsadd L
.59524 .26228 -2.37764 .77254 Mabsadd L
.59524 .26228 -0.91448 -0.29713 Mabsadd L
.59524 .26228 -1.46946 -2.02254 Mabsadd L
.59524 .26228 0 -0.96154 Mabsadd L
.59524 .26228 1.46946 -2.02254 Mabsadd L
.59524 .26228 .91448 -0.29713 Mabsadd L
.59524 .26228 2.37764 .77254 Mabsadd L
.59524 .26228 .56518 .7779 Mabsadd L
.59524 .26228 0 2.5 Mabsadd L closepath F
.59841 .26286 0 2.5 Mabsadd m
.59841 .26286 -0.56518 .7779 Mabsadd L
.59841 .26286 -2.37764 .77254 Mabsadd L
.59841 .26286 -0.91448 -0.29713 Mabsadd L
.59841 .26286 -1.46946 -2.02254 Mabsadd L
.59841 .26286 0 -0.96154 Mabsadd L
.59841 .26286 1.46946 -2.02254 Mabsadd L
.59841 .26286 .91448 -0.29713 Mabsadd L
.59841 .26286 2.37764 .77254 Mabsadd L
.59841 .26286 .56518 .7779 Mabsadd L
.59841 .26286 0 2.5 Mabsadd L closepath F
.60159 .26344 0 2.5 Mabsadd m
.60159 .26344 -0.56518 .7779 Mabsadd L
.60159 .26344 -2.37764 .77254 Mabsadd L
.60159 .26344 -0.91448 -0.29713 Mabsadd L
.60159 .26344 -1.46946 -2.02254 Mabsadd L
.60159 .26344 0 -0.96154 Mabsadd L
.60159 .26344 1.46946 -2.02254 Mabsadd L
.60159 .26344 .91448 -0.29713 Mabsadd L
.60159 .26344 2.37764 .77254 Mabsadd L
.60159 .26344 .56518 .7779 Mabsadd L
.60159 .26344 0 2.5 Mabsadd L closepath F
.60476 .26403 0 2.5 Mabsadd m
.60476 .26403 -0.56518 .7779 Mabsadd L
.60476 .26403 -2.37764 .77254 Mabsadd L
.60476 .26403 -0.91448 -0.29713 Mabsadd L
.60476 .26403 -1.46946 -2.02254 Mabsadd L
.60476 .26403 0 -0.96154 Mabsadd L
.60476 .26403 1.46946 -2.02254 Mabsadd L
.60476 .26403 .91448 -0.29713 Mabsadd L
.60476 .26403 2.37764 .77254 Mabsadd L
.60476 .26403 .56518 .7779 Mabsadd L
.60476 .26403 0 2.5 Mabsadd L closepath F
.60794 .26462 0 2.5 Mabsadd m
.60794 .26462 -0.56518 .7779 Mabsadd L
.60794 .26462 -2.37764 .77254 Mabsadd L
.60794 .26462 -0.91448 -0.29713 Mabsadd L
.60794 .26462 -1.46946 -2.02254 Mabsadd L
.60794 .26462 0 -0.96154 Mabsadd L
.60794 .26462 1.46946 -2.02254 Mabsadd L
.60794 .26462 .91448 -0.29713 Mabsadd L
.60794 .26462 2.37764 .77254 Mabsadd L
.60794 .26462 .56518 .7779 Mabsadd L
.60794 .26462 0 2.5 Mabsadd L closepath F
.61111 .26522 0 2.5 Mabsadd m
.61111 .26522 -0.56518 .7779 Mabsadd L
.61111 .26522 -2.37764 .77254 Mabsadd L
.61111 .26522 -0.91448 -0.29713 Mabsadd L
.61111 .26522 -1.46946 -2.02254 Mabsadd L
.61111 .26522 0 -0.96154 Mabsadd L
.61111 .26522 1.46946 -2.02254 Mabsadd L
.61111 .26522 .91448 -0.29713 Mabsadd L
.61111 .26522 2.37764 .77254 Mabsadd L
.61111 .26522 .56518 .7779 Mabsadd L
.61111 .26522 0 2.5 Mabsadd L closepath F
.61429 .26582 0 2.5 Mabsadd m
.61429 .26582 -0.56518 .7779 Mabsadd L
.61429 .26582 -2.37764 .77254 Mabsadd L
.61429 .26582 -0.91448 -0.29713 Mabsadd L
.61429 .26582 -1.46946 -2.02254 Mabsadd L
.61429 .26582 0 -0.96154 Mabsadd L
.61429 .26582 1.46946 -2.02254 Mabsadd L
.61429 .26582 .91448 -0.29713 Mabsadd L
.61429 .26582 2.37764 .77254 Mabsadd L
.61429 .26582 .56518 .7779 Mabsadd L
.61429 .26582 0 2.5 Mabsadd L closepath F
.61746 .26643 0 2.5 Mabsadd m
.61746 .26643 -0.56518 .7779 Mabsadd L
.61746 .26643 -2.37764 .77254 Mabsadd L
.61746 .26643 -0.91448 -0.29713 Mabsadd L
.61746 .26643 -1.46946 -2.02254 Mabsadd L
.61746 .26643 0 -0.96154 Mabsadd L
.61746 .26643 1.46946 -2.02254 Mabsadd L
.61746 .26643 .91448 -0.29713 Mabsadd L
.61746 .26643 2.37764 .77254 Mabsadd L
.61746 .26643 .56518 .7779 Mabsadd L
.61746 .26643 0 2.5 Mabsadd L closepath F
.62063 .26705 0 2.5 Mabsadd m
.62063 .26705 -0.56518 .7779 Mabsadd L
.62063 .26705 -2.37764 .77254 Mabsadd L
.62063 .26705 -0.91448 -0.29713 Mabsadd L
.62063 .26705 -1.46946 -2.02254 Mabsadd L
.62063 .26705 0 -0.96154 Mabsadd L
.62063 .26705 1.46946 -2.02254 Mabsadd L
.62063 .26705 .91448 -0.29713 Mabsadd L
.62063 .26705 2.37764 .77254 Mabsadd L
.62063 .26705 .56518 .7779 Mabsadd L
.62063 .26705 0 2.5 Mabsadd L closepath F
.62381 .26767 0 2.5 Mabsadd m
.62381 .26767 -0.56518 .7779 Mabsadd L
.62381 .26767 -2.37764 .77254 Mabsadd L
.62381 .26767 -0.91448 -0.29713 Mabsadd L
.62381 .26767 -1.46946 -2.02254 Mabsadd L
.62381 .26767 0 -0.96154 Mabsadd L
.62381 .26767 1.46946 -2.02254 Mabsadd L
.62381 .26767 .91448 -0.29713 Mabsadd L
.62381 .26767 2.37764 .77254 Mabsadd L
.62381 .26767 .56518 .7779 Mabsadd L
.62381 .26767 0 2.5 Mabsadd L closepath F
.62698 .2683 0 2.5 Mabsadd m
.62698 .2683 -0.56518 .7779 Mabsadd L
.62698 .2683 -2.37764 .77254 Mabsadd L
.62698 .2683 -0.91448 -0.29713 Mabsadd L
.62698 .2683 -1.46946 -2.02254 Mabsadd L
.62698 .2683 0 -0.96154 Mabsadd L
.62698 .2683 1.46946 -2.02254 Mabsadd L
.62698 .2683 .91448 -0.29713 Mabsadd L
.62698 .2683 2.37764 .77254 Mabsadd L
.62698 .2683 .56518 .7779 Mabsadd L
.62698 .2683 0 2.5 Mabsadd L closepath F
.63016 .26894 0 2.5 Mabsadd m
.63016 .26894 -0.56518 .7779 Mabsadd L
.63016 .26894 -2.37764 .77254 Mabsadd L
.63016 .26894 -0.91448 -0.29713 Mabsadd L
.63016 .26894 -1.46946 -2.02254 Mabsadd L
.63016 .26894 0 -0.96154 Mabsadd L
.63016 .26894 1.46946 -2.02254 Mabsadd L
.63016 .26894 .91448 -0.29713 Mabsadd L
.63016 .26894 2.37764 .77254 Mabsadd L
.63016 .26894 .56518 .7779 Mabsadd L
.63016 .26894 0 2.5 Mabsadd L closepath F
.63333 .26958 0 2.5 Mabsadd m
.63333 .26958 -0.56518 .7779 Mabsadd L
.63333 .26958 -2.37764 .77254 Mabsadd L
.63333 .26958 -0.91448 -0.29713 Mabsadd L
.63333 .26958 -1.46946 -2.02254 Mabsadd L
.63333 .26958 0 -0.96154 Mabsadd L
.63333 .26958 1.46946 -2.02254 Mabsadd L
.63333 .26958 .91448 -0.29713 Mabsadd L
.63333 .26958 2.37764 .77254 Mabsadd L
.63333 .26958 .56518 .7779 Mabsadd L
.63333 .26958 0 2.5 Mabsadd L closepath F
.63651 .27023 0 2.5 Mabsadd m
.63651 .27023 -0.56518 .7779 Mabsadd L
.63651 .27023 -2.37764 .77254 Mabsadd L
.63651 .27023 -0.91448 -0.29713 Mabsadd L
.63651 .27023 -1.46946 -2.02254 Mabsadd L
.63651 .27023 0 -0.96154 Mabsadd L
.63651 .27023 1.46946 -2.02254 Mabsadd L
.63651 .27023 .91448 -0.29713 Mabsadd L
.63651 .27023 2.37764 .77254 Mabsadd L
.63651 .27023 .56518 .7779 Mabsadd L
.63651 .27023 0 2.5 Mabsadd L closepath F
.63968 .27089 0 2.5 Mabsadd m
.63968 .27089 -0.56518 .7779 Mabsadd L
.63968 .27089 -2.37764 .77254 Mabsadd L
.63968 .27089 -0.91448 -0.29713 Mabsadd L
.63968 .27089 -1.46946 -2.02254 Mabsadd L
.63968 .27089 0 -0.96154 Mabsadd L
.63968 .27089 1.46946 -2.02254 Mabsadd L
.63968 .27089 .91448 -0.29713 Mabsadd L
.63968 .27089 2.37764 .77254 Mabsadd L
.63968 .27089 .56518 .7779 Mabsadd L
.63968 .27089 0 2.5 Mabsadd L closepath F
.64286 .27155 0 2.5 Mabsadd m
.64286 .27155 -0.56518 .7779 Mabsadd L
.64286 .27155 -2.37764 .77254 Mabsadd L
.64286 .27155 -0.91448 -0.29713 Mabsadd L
.64286 .27155 -1.46946 -2.02254 Mabsadd L
.64286 .27155 0 -0.96154 Mabsadd L
.64286 .27155 1.46946 -2.02254 Mabsadd L
.64286 .27155 .91448 -0.29713 Mabsadd L
.64286 .27155 2.37764 .77254 Mabsadd L
.64286 .27155 .56518 .7779 Mabsadd L
.64286 .27155 0 2.5 Mabsadd L closepath F
.64603 .27222 0 2.5 Mabsadd m
.64603 .27222 -0.56518 .7779 Mabsadd L
.64603 .27222 -2.37764 .77254 Mabsadd L
.64603 .27222 -0.91448 -0.29713 Mabsadd L
.64603 .27222 -1.46946 -2.02254 Mabsadd L
.64603 .27222 0 -0.96154 Mabsadd L
.64603 .27222 1.46946 -2.02254 Mabsadd L
.64603 .27222 .91448 -0.29713 Mabsadd L
.64603 .27222 2.37764 .77254 Mabsadd L
.64603 .27222 .56518 .7779 Mabsadd L
.64603 .27222 0 2.5 Mabsadd L closepath F
.64921 .27289 0 2.5 Mabsadd m
.64921 .27289 -0.56518 .7779 Mabsadd L
.64921 .27289 -2.37764 .77254 Mabsadd L
.64921 .27289 -0.91448 -0.29713 Mabsadd L
.64921 .27289 -1.46946 -2.02254 Mabsadd L
.64921 .27289 0 -0.96154 Mabsadd L
.64921 .27289 1.46946 -2.02254 Mabsadd L
.64921 .27289 .91448 -0.29713 Mabsadd L
.64921 .27289 2.37764 .77254 Mabsadd L
.64921 .27289 .56518 .7779 Mabsadd L
.64921 .27289 0 2.5 Mabsadd L closepath F
.65238 .27357 0 2.5 Mabsadd m
.65238 .27357 -0.56518 .7779 Mabsadd L
.65238 .27357 -2.37764 .77254 Mabsadd L
.65238 .27357 -0.91448 -0.29713 Mabsadd L
.65238 .27357 -1.46946 -2.02254 Mabsadd L
.65238 .27357 0 -0.96154 Mabsadd L
.65238 .27357 1.46946 -2.02254 Mabsadd L
.65238 .27357 .91448 -0.29713 Mabsadd L
.65238 .27357 2.37764 .77254 Mabsadd L
.65238 .27357 .56518 .7779 Mabsadd L
.65238 .27357 0 2.5 Mabsadd L closepath F
.65556 .27426 0 2.5 Mabsadd m
.65556 .27426 -0.56518 .7779 Mabsadd L
.65556 .27426 -2.37764 .77254 Mabsadd L
.65556 .27426 -0.91448 -0.29713 Mabsadd L
.65556 .27426 -1.46946 -2.02254 Mabsadd L
.65556 .27426 0 -0.96154 Mabsadd L
.65556 .27426 1.46946 -2.02254 Mabsadd L
.65556 .27426 .91448 -0.29713 Mabsadd L
.65556 .27426 2.37764 .77254 Mabsadd L
.65556 .27426 .56518 .7779 Mabsadd L
.65556 .27426 0 2.5 Mabsadd L closepath F
.65873 .27496 0 2.5 Mabsadd m
.65873 .27496 -0.56518 .7779 Mabsadd L
.65873 .27496 -2.37764 .77254 Mabsadd L
.65873 .27496 -0.91448 -0.29713 Mabsadd L
.65873 .27496 -1.46946 -2.02254 Mabsadd L
.65873 .27496 0 -0.96154 Mabsadd L
.65873 .27496 1.46946 -2.02254 Mabsadd L
.65873 .27496 .91448 -0.29713 Mabsadd L
.65873 .27496 2.37764 .77254 Mabsadd L
.65873 .27496 .56518 .7779 Mabsadd L
.65873 .27496 0 2.5 Mabsadd L closepath F
.6619 .27566 0 2.5 Mabsadd m
.6619 .27566 -0.56518 .7779 Mabsadd L
.6619 .27566 -2.37764 .77254 Mabsadd L
.6619 .27566 -0.91448 -0.29713 Mabsadd L
.6619 .27566 -1.46946 -2.02254 Mabsadd L
.6619 .27566 0 -0.96154 Mabsadd L
.6619 .27566 1.46946 -2.02254 Mabsadd L
.6619 .27566 .91448 -0.29713 Mabsadd L
.6619 .27566 2.37764 .77254 Mabsadd L
.6619 .27566 .56518 .7779 Mabsadd L
.6619 .27566 0 2.5 Mabsadd L closepath F
.66508 .27637 0 2.5 Mabsadd m
.66508 .27637 -0.56518 .7779 Mabsadd L
.66508 .27637 -2.37764 .77254 Mabsadd L
.66508 .27637 -0.91448 -0.29713 Mabsadd L
.66508 .27637 -1.46946 -2.02254 Mabsadd L
.66508 .27637 0 -0.96154 Mabsadd L
.66508 .27637 1.46946 -2.02254 Mabsadd L
.66508 .27637 .91448 -0.29713 Mabsadd L
.66508 .27637 2.37764 .77254 Mabsadd L
.66508 .27637 .56518 .7779 Mabsadd L
.66508 .27637 0 2.5 Mabsadd L closepath F
.66825 .27709 0 2.5 Mabsadd m
.66825 .27709 -0.56518 .7779 Mabsadd L
.66825 .27709 -2.37764 .77254 Mabsadd L
.66825 .27709 -0.91448 -0.29713 Mabsadd L
.66825 .27709 -1.46946 -2.02254 Mabsadd L
.66825 .27709 0 -0.96154 Mabsadd L
.66825 .27709 1.46946 -2.02254 Mabsadd L
.66825 .27709 .91448 -0.29713 Mabsadd L
.66825 .27709 2.37764 .77254 Mabsadd L
.66825 .27709 .56518 .7779 Mabsadd L
.66825 .27709 0 2.5 Mabsadd L closepath F
.67143 .27781 0 2.5 Mabsadd m
.67143 .27781 -0.56518 .7779 Mabsadd L
.67143 .27781 -2.37764 .77254 Mabsadd L
.67143 .27781 -0.91448 -0.29713 Mabsadd L
.67143 .27781 -1.46946 -2.02254 Mabsadd L
.67143 .27781 0 -0.96154 Mabsadd L
.67143 .27781 1.46946 -2.02254 Mabsadd L
.67143 .27781 .91448 -0.29713 Mabsadd L
.67143 .27781 2.37764 .77254 Mabsadd L
.67143 .27781 .56518 .7779 Mabsadd L
.67143 .27781 0 2.5 Mabsadd L closepath F
.6746 .27854 0 2.5 Mabsadd m
.6746 .27854 -0.56518 .7779 Mabsadd L
.6746 .27854 -2.37764 .77254 Mabsadd L
.6746 .27854 -0.91448 -0.29713 Mabsadd L
.6746 .27854 -1.46946 -2.02254 Mabsadd L
.6746 .27854 0 -0.96154 Mabsadd L
.6746 .27854 1.46946 -2.02254 Mabsadd L
.6746 .27854 .91448 -0.29713 Mabsadd L
.6746 .27854 2.37764 .77254 Mabsadd L
.6746 .27854 .56518 .7779 Mabsadd L
.6746 .27854 0 2.5 Mabsadd L closepath F
.67778 .27928 0 2.5 Mabsadd m
.67778 .27928 -0.56518 .7779 Mabsadd L
.67778 .27928 -2.37764 .77254 Mabsadd L
.67778 .27928 -0.91448 -0.29713 Mabsadd L
.67778 .27928 -1.46946 -2.02254 Mabsadd L
.67778 .27928 0 -0.96154 Mabsadd L
.67778 .27928 1.46946 -2.02254 Mabsadd L
.67778 .27928 .91448 -0.29713 Mabsadd L
.67778 .27928 2.37764 .77254 Mabsadd L
.67778 .27928 .56518 .7779 Mabsadd L
.67778 .27928 0 2.5 Mabsadd L closepath F
.68095 .28002 0 2.5 Mabsadd m
.68095 .28002 -0.56518 .7779 Mabsadd L
.68095 .28002 -2.37764 .77254 Mabsadd L
.68095 .28002 -0.91448 -0.29713 Mabsadd L
.68095 .28002 -1.46946 -2.02254 Mabsadd L
.68095 .28002 0 -0.96154 Mabsadd L
.68095 .28002 1.46946 -2.02254 Mabsadd L
.68095 .28002 .91448 -0.29713 Mabsadd L
.68095 .28002 2.37764 .77254 Mabsadd L
.68095 .28002 .56518 .7779 Mabsadd L
.68095 .28002 0 2.5 Mabsadd L closepath F
.68413 .28078 0 2.5 Mabsadd m
.68413 .28078 -0.56518 .7779 Mabsadd L
.68413 .28078 -2.37764 .77254 Mabsadd L
.68413 .28078 -0.91448 -0.29713 Mabsadd L
.68413 .28078 -1.46946 -2.02254 Mabsadd L
.68413 .28078 0 -0.96154 Mabsadd L
.68413 .28078 1.46946 -2.02254 Mabsadd L
.68413 .28078 .91448 -0.29713 Mabsadd L
.68413 .28078 2.37764 .77254 Mabsadd L
.68413 .28078 .56518 .7779 Mabsadd L
.68413 .28078 0 2.5 Mabsadd L closepath F
.6873 .28154 0 2.5 Mabsadd m
.6873 .28154 -0.56518 .7779 Mabsadd L
.6873 .28154 -2.37764 .77254 Mabsadd L
.6873 .28154 -0.91448 -0.29713 Mabsadd L
.6873 .28154 -1.46946 -2.02254 Mabsadd L
.6873 .28154 0 -0.96154 Mabsadd L
.6873 .28154 1.46946 -2.02254 Mabsadd L
.6873 .28154 .91448 -0.29713 Mabsadd L
.6873 .28154 2.37764 .77254 Mabsadd L
.6873 .28154 .56518 .7779 Mabsadd L
.6873 .28154 0 2.5 Mabsadd L closepath F
.69048 .28231 0 2.5 Mabsadd m
.69048 .28231 -0.56518 .7779 Mabsadd L
.69048 .28231 -2.37764 .77254 Mabsadd L
.69048 .28231 -0.91448 -0.29713 Mabsadd L
.69048 .28231 -1.46946 -2.02254 Mabsadd L
.69048 .28231 0 -0.96154 Mabsadd L
.69048 .28231 1.46946 -2.02254 Mabsadd L
.69048 .28231 .91448 -0.29713 Mabsadd L
.69048 .28231 2.37764 .77254 Mabsadd L
.69048 .28231 .56518 .7779 Mabsadd L
.69048 .28231 0 2.5 Mabsadd L closepath F
.69365 .28308 0 2.5 Mabsadd m
.69365 .28308 -0.56518 .7779 Mabsadd L
.69365 .28308 -2.37764 .77254 Mabsadd L
.69365 .28308 -0.91448 -0.29713 Mabsadd L
.69365 .28308 -1.46946 -2.02254 Mabsadd L
.69365 .28308 0 -0.96154 Mabsadd L
.69365 .28308 1.46946 -2.02254 Mabsadd L
.69365 .28308 .91448 -0.29713 Mabsadd L
.69365 .28308 2.37764 .77254 Mabsadd L
.69365 .28308 .56518 .7779 Mabsadd L
.69365 .28308 0 2.5 Mabsadd L closepath F
.69683 .28387 0 2.5 Mabsadd m
.69683 .28387 -0.56518 .7779 Mabsadd L
.69683 .28387 -2.37764 .77254 Mabsadd L
.69683 .28387 -0.91448 -0.29713 Mabsadd L
.69683 .28387 -1.46946 -2.02254 Mabsadd L
.69683 .28387 0 -0.96154 Mabsadd L
.69683 .28387 1.46946 -2.02254 Mabsadd L
.69683 .28387 .91448 -0.29713 Mabsadd L
.69683 .28387 2.37764 .77254 Mabsadd L
.69683 .28387 .56518 .7779 Mabsadd L
.69683 .28387 0 2.5 Mabsadd L closepath F
.7 .28466 0 2.5 Mabsadd m
.7 .28466 -0.56518 .7779 Mabsadd L
.7 .28466 -2.37764 .77254 Mabsadd L
.7 .28466 -0.91448 -0.29713 Mabsadd L
.7 .28466 -1.46946 -2.02254 Mabsadd L
.7 .28466 0 -0.96154 Mabsadd L
.7 .28466 1.46946 -2.02254 Mabsadd L
.7 .28466 .91448 -0.29713 Mabsadd L
.7 .28466 2.37764 .77254 Mabsadd L
.7 .28466 .56518 .7779 Mabsadd L
.7 .28466 0 2.5 Mabsadd L closepath F
.70317 .28546 0 2.5 Mabsadd m
.70317 .28546 -0.56518 .7779 Mabsadd L
.70317 .28546 -2.37764 .77254 Mabsadd L
.70317 .28546 -0.91448 -0.29713 Mabsadd L
.70317 .28546 -1.46946 -2.02254 Mabsadd L
.70317 .28546 0 -0.96154 Mabsadd L
.70317 .28546 1.46946 -2.02254 Mabsadd L
.70317 .28546 .91448 -0.29713 Mabsadd L
.70317 .28546 2.37764 .77254 Mabsadd L
.70317 .28546 .56518 .7779 Mabsadd L
.70317 .28546 0 2.5 Mabsadd L closepath F
.70635 .28626 0 2.5 Mabsadd m
.70635 .28626 -0.56518 .7779 Mabsadd L
.70635 .28626 -2.37764 .77254 Mabsadd L
.70635 .28626 -0.91448 -0.29713 Mabsadd L
.70635 .28626 -1.46946 -2.02254 Mabsadd L
.70635 .28626 0 -0.96154 Mabsadd L
.70635 .28626 1.46946 -2.02254 Mabsadd L
.70635 .28626 .91448 -0.29713 Mabsadd L
.70635 .28626 2.37764 .77254 Mabsadd L
.70635 .28626 .56518 .7779 Mabsadd L
.70635 .28626 0 2.5 Mabsadd L closepath F
.70952 .28708 0 2.5 Mabsadd m
.70952 .28708 -0.56518 .7779 Mabsadd L
.70952 .28708 -2.37764 .77254 Mabsadd L
.70952 .28708 -0.91448 -0.29713 Mabsadd L
.70952 .28708 -1.46946 -2.02254 Mabsadd L
.70952 .28708 0 -0.96154 Mabsadd L
.70952 .28708 1.46946 -2.02254 Mabsadd L
.70952 .28708 .91448 -0.29713 Mabsadd L
.70952 .28708 2.37764 .77254 Mabsadd L
.70952 .28708 .56518 .7779 Mabsadd L
.70952 .28708 0 2.5 Mabsadd L closepath F
.7127 .2879 0 2.5 Mabsadd m
.7127 .2879 -0.56518 .7779 Mabsadd L
.7127 .2879 -2.37764 .77254 Mabsadd L
.7127 .2879 -0.91448 -0.29713 Mabsadd L
.7127 .2879 -1.46946 -2.02254 Mabsadd L
.7127 .2879 0 -0.96154 Mabsadd L
.7127 .2879 1.46946 -2.02254 Mabsadd L
.7127 .2879 .91448 -0.29713 Mabsadd L
.7127 .2879 2.37764 .77254 Mabsadd L
.7127 .2879 .56518 .7779 Mabsadd L
.7127 .2879 0 2.5 Mabsadd L closepath F
.71587 .28873 0 2.5 Mabsadd m
.71587 .28873 -0.56518 .7779 Mabsadd L
.71587 .28873 -2.37764 .77254 Mabsadd L
.71587 .28873 -0.91448 -0.29713 Mabsadd L
.71587 .28873 -1.46946 -2.02254 Mabsadd L
.71587 .28873 0 -0.96154 Mabsadd L
.71587 .28873 1.46946 -2.02254 Mabsadd L
.71587 .28873 .91448 -0.29713 Mabsadd L
.71587 .28873 2.37764 .77254 Mabsadd L
.71587 .28873 .56518 .7779 Mabsadd L
.71587 .28873 0 2.5 Mabsadd L closepath F
.71905 .28958 0 2.5 Mabsadd m
.71905 .28958 -0.56518 .7779 Mabsadd L
.71905 .28958 -2.37764 .77254 Mabsadd L
.71905 .28958 -0.91448 -0.29713 Mabsadd L
.71905 .28958 -1.46946 -2.02254 Mabsadd L
.71905 .28958 0 -0.96154 Mabsadd L
.71905 .28958 1.46946 -2.02254 Mabsadd L
.71905 .28958 .91448 -0.29713 Mabsadd L
.71905 .28958 2.37764 .77254 Mabsadd L
.71905 .28958 .56518 .7779 Mabsadd L
.71905 .28958 0 2.5 Mabsadd L closepath F
.72222 .29042 0 2.5 Mabsadd m
.72222 .29042 -0.56518 .7779 Mabsadd L
.72222 .29042 -2.37764 .77254 Mabsadd L
.72222 .29042 -0.91448 -0.29713 Mabsadd L
.72222 .29042 -1.46946 -2.02254 Mabsadd L
.72222 .29042 0 -0.96154 Mabsadd L
.72222 .29042 1.46946 -2.02254 Mabsadd L
.72222 .29042 .91448 -0.29713 Mabsadd L
.72222 .29042 2.37764 .77254 Mabsadd L
.72222 .29042 .56518 .7779 Mabsadd L
.72222 .29042 0 2.5 Mabsadd L closepath F
.7254 .29128 0 2.5 Mabsadd m
.7254 .29128 -0.56518 .7779 Mabsadd L
.7254 .29128 -2.37764 .77254 Mabsadd L
.7254 .29128 -0.91448 -0.29713 Mabsadd L
.7254 .29128 -1.46946 -2.02254 Mabsadd L
.7254 .29128 0 -0.96154 Mabsadd L
.7254 .29128 1.46946 -2.02254 Mabsadd L
.7254 .29128 .91448 -0.29713 Mabsadd L
.7254 .29128 2.37764 .77254 Mabsadd L
.7254 .29128 .56518 .7779 Mabsadd L
.7254 .29128 0 2.5 Mabsadd L closepath F
.72857 .29215 0 2.5 Mabsadd m
.72857 .29215 -0.56518 .7779 Mabsadd L
.72857 .29215 -2.37764 .77254 Mabsadd L
.72857 .29215 -0.91448 -0.29713 Mabsadd L
.72857 .29215 -1.46946 -2.02254 Mabsadd L
.72857 .29215 0 -0.96154 Mabsadd L
.72857 .29215 1.46946 -2.02254 Mabsadd L
.72857 .29215 .91448 -0.29713 Mabsadd L
.72857 .29215 2.37764 .77254 Mabsadd L
.72857 .29215 .56518 .7779 Mabsadd L
.72857 .29215 0 2.5 Mabsadd L closepath F
.73175 .29302 0 2.5 Mabsadd m
.73175 .29302 -0.56518 .7779 Mabsadd L
.73175 .29302 -2.37764 .77254 Mabsadd L
.73175 .29302 -0.91448 -0.29713 Mabsadd L
.73175 .29302 -1.46946 -2.02254 Mabsadd L
.73175 .29302 0 -0.96154 Mabsadd L
.73175 .29302 1.46946 -2.02254 Mabsadd L
.73175 .29302 .91448 -0.29713 Mabsadd L
.73175 .29302 2.37764 .77254 Mabsadd L
.73175 .29302 .56518 .7779 Mabsadd L
.73175 .29302 0 2.5 Mabsadd L closepath F
.73492 .2939 0 2.5 Mabsadd m
.73492 .2939 -0.56518 .7779 Mabsadd L
.73492 .2939 -2.37764 .77254 Mabsadd L
.73492 .2939 -0.91448 -0.29713 Mabsadd L
.73492 .2939 -1.46946 -2.02254 Mabsadd L
.73492 .2939 0 -0.96154 Mabsadd L
.73492 .2939 1.46946 -2.02254 Mabsadd L
.73492 .2939 .91448 -0.29713 Mabsadd L
.73492 .2939 2.37764 .77254 Mabsadd L
.73492 .2939 .56518 .7779 Mabsadd L
.73492 .2939 0 2.5 Mabsadd L closepath F
.7381 .2948 0 2.5 Mabsadd m
.7381 .2948 -0.56518 .7779 Mabsadd L
.7381 .2948 -2.37764 .77254 Mabsadd L
.7381 .2948 -0.91448 -0.29713 Mabsadd L
.7381 .2948 -1.46946 -2.02254 Mabsadd L
.7381 .2948 0 -0.96154 Mabsadd L
.7381 .2948 1.46946 -2.02254 Mabsadd L
.7381 .2948 .91448 -0.29713 Mabsadd L
.7381 .2948 2.37764 .77254 Mabsadd L
.7381 .2948 .56518 .7779 Mabsadd L
.7381 .2948 0 2.5 Mabsadd L closepath F
.74127 .2957 0 2.5 Mabsadd m
.74127 .2957 -0.56518 .7779 Mabsadd L
.74127 .2957 -2.37764 .77254 Mabsadd L
.74127 .2957 -0.91448 -0.29713 Mabsadd L
.74127 .2957 -1.46946 -2.02254 Mabsadd L
.74127 .2957 0 -0.96154 Mabsadd L
.74127 .2957 1.46946 -2.02254 Mabsadd L
.74127 .2957 .91448 -0.29713 Mabsadd L
.74127 .2957 2.37764 .77254 Mabsadd L
.74127 .2957 .56518 .7779 Mabsadd L
.74127 .2957 0 2.5 Mabsadd L closepath F
.74444 .29661 0 2.5 Mabsadd m
.74444 .29661 -0.56518 .7779 Mabsadd L
.74444 .29661 -2.37764 .77254 Mabsadd L
.74444 .29661 -0.91448 -0.29713 Mabsadd L
.74444 .29661 -1.46946 -2.02254 Mabsadd L
.74444 .29661 0 -0.96154 Mabsadd L
.74444 .29661 1.46946 -2.02254 Mabsadd L
.74444 .29661 .91448 -0.29713 Mabsadd L
.74444 .29661 2.37764 .77254 Mabsadd L
.74444 .29661 .56518 .7779 Mabsadd L
.74444 .29661 0 2.5 Mabsadd L closepath F
.74762 .29753 0 2.5 Mabsadd m
.74762 .29753 -0.56518 .7779 Mabsadd L
.74762 .29753 -2.37764 .77254 Mabsadd L
.74762 .29753 -0.91448 -0.29713 Mabsadd L
.74762 .29753 -1.46946 -2.02254 Mabsadd L
.74762 .29753 0 -0.96154 Mabsadd L
.74762 .29753 1.46946 -2.02254 Mabsadd L
.74762 .29753 .91448 -0.29713 Mabsadd L
.74762 .29753 2.37764 .77254 Mabsadd L
.74762 .29753 .56518 .7779 Mabsadd L
.74762 .29753 0 2.5 Mabsadd L closepath F
.75079 .29845 0 2.5 Mabsadd m
.75079 .29845 -0.56518 .7779 Mabsadd L
.75079 .29845 -2.37764 .77254 Mabsadd L
.75079 .29845 -0.91448 -0.29713 Mabsadd L
.75079 .29845 -1.46946 -2.02254 Mabsadd L
.75079 .29845 0 -0.96154 Mabsadd L
.75079 .29845 1.46946 -2.02254 Mabsadd L
.75079 .29845 .91448 -0.29713 Mabsadd L
.75079 .29845 2.37764 .77254 Mabsadd L
.75079 .29845 .56518 .7779 Mabsadd L
.75079 .29845 0 2.5 Mabsadd L closepath F
.75397 .29939 0 2.5 Mabsadd m
.75397 .29939 -0.56518 .7779 Mabsadd L
.75397 .29939 -2.37764 .77254 Mabsadd L
.75397 .29939 -0.91448 -0.29713 Mabsadd L
.75397 .29939 -1.46946 -2.02254 Mabsadd L
.75397 .29939 0 -0.96154 Mabsadd L
.75397 .29939 1.46946 -2.02254 Mabsadd L
.75397 .29939 .91448 -0.29713 Mabsadd L
.75397 .29939 2.37764 .77254 Mabsadd L
.75397 .29939 .56518 .7779 Mabsadd L
.75397 .29939 0 2.5 Mabsadd L closepath F
.75714 .30034 0 2.5 Mabsadd m
.75714 .30034 -0.56518 .7779 Mabsadd L
.75714 .30034 -2.37764 .77254 Mabsadd L
.75714 .30034 -0.91448 -0.29713 Mabsadd L
.75714 .30034 -1.46946 -2.02254 Mabsadd L
.75714 .30034 0 -0.96154 Mabsadd L
.75714 .30034 1.46946 -2.02254 Mabsadd L
.75714 .30034 .91448 -0.29713 Mabsadd L
.75714 .30034 2.37764 .77254 Mabsadd L
.75714 .30034 .56518 .7779 Mabsadd L
.75714 .30034 0 2.5 Mabsadd L closepath F
.76032 .30129 0 2.5 Mabsadd m
.76032 .30129 -0.56518 .7779 Mabsadd L
.76032 .30129 -2.37764 .77254 Mabsadd L
.76032 .30129 -0.91448 -0.29713 Mabsadd L
.76032 .30129 -1.46946 -2.02254 Mabsadd L
.76032 .30129 0 -0.96154 Mabsadd L
.76032 .30129 1.46946 -2.02254 Mabsadd L
.76032 .30129 .91448 -0.29713 Mabsadd L
.76032 .30129 2.37764 .77254 Mabsadd L
.76032 .30129 .56518 .7779 Mabsadd L
.76032 .30129 0 2.5 Mabsadd L closepath F
.76349 .30226 0 2.5 Mabsadd m
.76349 .30226 -0.56518 .7779 Mabsadd L
.76349 .30226 -2.37764 .77254 Mabsadd L
.76349 .30226 -0.91448 -0.29713 Mabsadd L
.76349 .30226 -1.46946 -2.02254 Mabsadd L
.76349 .30226 0 -0.96154 Mabsadd L
.76349 .30226 1.46946 -2.02254 Mabsadd L
.76349 .30226 .91448 -0.29713 Mabsadd L
.76349 .30226 2.37764 .77254 Mabsadd L
.76349 .30226 .56518 .7779 Mabsadd L
.76349 .30226 0 2.5 Mabsadd L closepath F
.76667 .30324 0 2.5 Mabsadd m
.76667 .30324 -0.56518 .7779 Mabsadd L
.76667 .30324 -2.37764 .77254 Mabsadd L
.76667 .30324 -0.91448 -0.29713 Mabsadd L
.76667 .30324 -1.46946 -2.02254 Mabsadd L
.76667 .30324 0 -0.96154 Mabsadd L
.76667 .30324 1.46946 -2.02254 Mabsadd L
.76667 .30324 .91448 -0.29713 Mabsadd L
.76667 .30324 2.37764 .77254 Mabsadd L
.76667 .30324 .56518 .7779 Mabsadd L
.76667 .30324 0 2.5 Mabsadd L closepath F
.76984 .30422 0 2.5 Mabsadd m
.76984 .30422 -0.56518 .7779 Mabsadd L
.76984 .30422 -2.37764 .77254 Mabsadd L
.76984 .30422 -0.91448 -0.29713 Mabsadd L
.76984 .30422 -1.46946 -2.02254 Mabsadd L
.76984 .30422 0 -0.96154 Mabsadd L
.76984 .30422 1.46946 -2.02254 Mabsadd L
.76984 .30422 .91448 -0.29713 Mabsadd L
.76984 .30422 2.37764 .77254 Mabsadd L
.76984 .30422 .56518 .7779 Mabsadd L
.76984 .30422 0 2.5 Mabsadd L closepath F
.77302 .30522 0 2.5 Mabsadd m
.77302 .30522 -0.56518 .7779 Mabsadd L
.77302 .30522 -2.37764 .77254 Mabsadd L
.77302 .30522 -0.91448 -0.29713 Mabsadd L
.77302 .30522 -1.46946 -2.02254 Mabsadd L
.77302 .30522 0 -0.96154 Mabsadd L
.77302 .30522 1.46946 -2.02254 Mabsadd L
.77302 .30522 .91448 -0.29713 Mabsadd L
.77302 .30522 2.37764 .77254 Mabsadd L
.77302 .30522 .56518 .7779 Mabsadd L
.77302 .30522 0 2.5 Mabsadd L closepath F
.77619 .30622 0 2.5 Mabsadd m
.77619 .30622 -0.56518 .7779 Mabsadd L
.77619 .30622 -2.37764 .77254 Mabsadd L
.77619 .30622 -0.91448 -0.29713 Mabsadd L
.77619 .30622 -1.46946 -2.02254 Mabsadd L
.77619 .30622 0 -0.96154 Mabsadd L
.77619 .30622 1.46946 -2.02254 Mabsadd L
.77619 .30622 .91448 -0.29713 Mabsadd L
.77619 .30622 2.37764 .77254 Mabsadd L
.77619 .30622 .56518 .7779 Mabsadd L
.77619 .30622 0 2.5 Mabsadd L closepath F
.77937 .30724 0 2.5 Mabsadd m
.77937 .30724 -0.56518 .7779 Mabsadd L
.77937 .30724 -2.37764 .77254 Mabsadd L
.77937 .30724 -0.91448 -0.29713 Mabsadd L
.77937 .30724 -1.46946 -2.02254 Mabsadd L
.77937 .30724 0 -0.96154 Mabsadd L
.77937 .30724 1.46946 -2.02254 Mabsadd L
.77937 .30724 .91448 -0.29713 Mabsadd L
.77937 .30724 2.37764 .77254 Mabsadd L
.77937 .30724 .56518 .7779 Mabsadd L
.77937 .30724 0 2.5 Mabsadd L closepath F
.78254 .30826 0 2.5 Mabsadd m
.78254 .30826 -0.56518 .7779 Mabsadd L
.78254 .30826 -2.37764 .77254 Mabsadd L
.78254 .30826 -0.91448 -0.29713 Mabsadd L
.78254 .30826 -1.46946 -2.02254 Mabsadd L
.78254 .30826 0 -0.96154 Mabsadd L
.78254 .30826 1.46946 -2.02254 Mabsadd L
.78254 .30826 .91448 -0.29713 Mabsadd L
.78254 .30826 2.37764 .77254 Mabsadd L
.78254 .30826 .56518 .7779 Mabsadd L
.78254 .30826 0 2.5 Mabsadd L closepath F
.78571 .3093 0 2.5 Mabsadd m
.78571 .3093 -0.56518 .7779 Mabsadd L
.78571 .3093 -2.37764 .77254 Mabsadd L
.78571 .3093 -0.91448 -0.29713 Mabsadd L
.78571 .3093 -1.46946 -2.02254 Mabsadd L
.78571 .3093 0 -0.96154 Mabsadd L
.78571 .3093 1.46946 -2.02254 Mabsadd L
.78571 .3093 .91448 -0.29713 Mabsadd L
.78571 .3093 2.37764 .77254 Mabsadd L
.78571 .3093 .56518 .7779 Mabsadd L
.78571 .3093 0 2.5 Mabsadd L closepath F
.78889 .31034 0 2.5 Mabsadd m
.78889 .31034 -0.56518 .7779 Mabsadd L
.78889 .31034 -2.37764 .77254 Mabsadd L
.78889 .31034 -0.91448 -0.29713 Mabsadd L
.78889 .31034 -1.46946 -2.02254 Mabsadd L
.78889 .31034 0 -0.96154 Mabsadd L
.78889 .31034 1.46946 -2.02254 Mabsadd L
.78889 .31034 .91448 -0.29713 Mabsadd L
.78889 .31034 2.37764 .77254 Mabsadd L
.78889 .31034 .56518 .7779 Mabsadd L
.78889 .31034 0 2.5 Mabsadd L closepath F
.79206 .3114 0 2.5 Mabsadd m
.79206 .3114 -0.56518 .7779 Mabsadd L
.79206 .3114 -2.37764 .77254 Mabsadd L
.79206 .3114 -0.91448 -0.29713 Mabsadd L
.79206 .3114 -1.46946 -2.02254 Mabsadd L
.79206 .3114 0 -0.96154 Mabsadd L
.79206 .3114 1.46946 -2.02254 Mabsadd L
.79206 .3114 .91448 -0.29713 Mabsadd L
.79206 .3114 2.37764 .77254 Mabsadd L
.79206 .3114 .56518 .7779 Mabsadd L
.79206 .3114 0 2.5 Mabsadd L closepath F
.79524 .31247 0 2.5 Mabsadd m
.79524 .31247 -0.56518 .7779 Mabsadd L
.79524 .31247 -2.37764 .77254 Mabsadd L
.79524 .31247 -0.91448 -0.29713 Mabsadd L
.79524 .31247 -1.46946 -2.02254 Mabsadd L
.79524 .31247 0 -0.96154 Mabsadd L
.79524 .31247 1.46946 -2.02254 Mabsadd L
.79524 .31247 .91448 -0.29713 Mabsadd L
.79524 .31247 2.37764 .77254 Mabsadd L
.79524 .31247 .56518 .7779 Mabsadd L
.79524 .31247 0 2.5 Mabsadd L closepath F
.79841 .31354 0 2.5 Mabsadd m
.79841 .31354 -0.56518 .7779 Mabsadd L
.79841 .31354 -2.37764 .77254 Mabsadd L
.79841 .31354 -0.91448 -0.29713 Mabsadd L
.79841 .31354 -1.46946 -2.02254 Mabsadd L
.79841 .31354 0 -0.96154 Mabsadd L
.79841 .31354 1.46946 -2.02254 Mabsadd L
.79841 .31354 .91448 -0.29713 Mabsadd L
.79841 .31354 2.37764 .77254 Mabsadd L
.79841 .31354 .56518 .7779 Mabsadd L
.79841 .31354 0 2.5 Mabsadd L closepath F
.80159 .31463 0 2.5 Mabsadd m
.80159 .31463 -0.56518 .7779 Mabsadd L
.80159 .31463 -2.37764 .77254 Mabsadd L
.80159 .31463 -0.91448 -0.29713 Mabsadd L
.80159 .31463 -1.46946 -2.02254 Mabsadd L
.80159 .31463 0 -0.96154 Mabsadd L
.80159 .31463 1.46946 -2.02254 Mabsadd L
.80159 .31463 .91448 -0.29713 Mabsadd L
.80159 .31463 2.37764 .77254 Mabsadd L
.80159 .31463 .56518 .7779 Mabsadd L
.80159 .31463 0 2.5 Mabsadd L closepath F
.80476 .31573 0 2.5 Mabsadd m
.80476 .31573 -0.56518 .7779 Mabsadd L
.80476 .31573 -2.37764 .77254 Mabsadd L
.80476 .31573 -0.91448 -0.29713 Mabsadd L
.80476 .31573 -1.46946 -2.02254 Mabsadd L
.80476 .31573 0 -0.96154 Mabsadd L
.80476 .31573 1.46946 -2.02254 Mabsadd L
.80476 .31573 .91448 -0.29713 Mabsadd L
.80476 .31573 2.37764 .77254 Mabsadd L
.80476 .31573 .56518 .7779 Mabsadd L
.80476 .31573 0 2.5 Mabsadd L closepath F
.80794 .31684 0 2.5 Mabsadd m
.80794 .31684 -0.56518 .7779 Mabsadd L
.80794 .31684 -2.37764 .77254 Mabsadd L
.80794 .31684 -0.91448 -0.29713 Mabsadd L
.80794 .31684 -1.46946 -2.02254 Mabsadd L
.80794 .31684 0 -0.96154 Mabsadd L
.80794 .31684 1.46946 -2.02254 Mabsadd L
.80794 .31684 .91448 -0.29713 Mabsadd L
.80794 .31684 2.37764 .77254 Mabsadd L
.80794 .31684 .56518 .7779 Mabsadd L
.80794 .31684 0 2.5 Mabsadd L closepath F
.81111 .31796 0 2.5 Mabsadd m
.81111 .31796 -0.56518 .7779 Mabsadd L
.81111 .31796 -2.37764 .77254 Mabsadd L
.81111 .31796 -0.91448 -0.29713 Mabsadd L
.81111 .31796 -1.46946 -2.02254 Mabsadd L
.81111 .31796 0 -0.96154 Mabsadd L
.81111 .31796 1.46946 -2.02254 Mabsadd L
.81111 .31796 .91448 -0.29713 Mabsadd L
.81111 .31796 2.37764 .77254 Mabsadd L
.81111 .31796 .56518 .7779 Mabsadd L
.81111 .31796 0 2.5 Mabsadd L closepath F
.81429 .31909 0 2.5 Mabsadd m
.81429 .31909 -0.56518 .7779 Mabsadd L
.81429 .31909 -2.37764 .77254 Mabsadd L
.81429 .31909 -0.91448 -0.29713 Mabsadd L
.81429 .31909 -1.46946 -2.02254 Mabsadd L
.81429 .31909 0 -0.96154 Mabsadd L
.81429 .31909 1.46946 -2.02254 Mabsadd L
.81429 .31909 .91448 -0.29713 Mabsadd L
.81429 .31909 2.37764 .77254 Mabsadd L
.81429 .31909 .56518 .7779 Mabsadd L
.81429 .31909 0 2.5 Mabsadd L closepath F
.81746 .32024 0 2.5 Mabsadd m
.81746 .32024 -0.56518 .7779 Mabsadd L
.81746 .32024 -2.37764 .77254 Mabsadd L
.81746 .32024 -0.91448 -0.29713 Mabsadd L
.81746 .32024 -1.46946 -2.02254 Mabsadd L
.81746 .32024 0 -0.96154 Mabsadd L
.81746 .32024 1.46946 -2.02254 Mabsadd L
.81746 .32024 .91448 -0.29713 Mabsadd L
.81746 .32024 2.37764 .77254 Mabsadd L
.81746 .32024 .56518 .7779 Mabsadd L
.81746 .32024 0 2.5 Mabsadd L closepath F
.82063 .32139 0 2.5 Mabsadd m
.82063 .32139 -0.56518 .7779 Mabsadd L
.82063 .32139 -2.37764 .77254 Mabsadd L
.82063 .32139 -0.91448 -0.29713 Mabsadd L
.82063 .32139 -1.46946 -2.02254 Mabsadd L
.82063 .32139 0 -0.96154 Mabsadd L
.82063 .32139 1.46946 -2.02254 Mabsadd L
.82063 .32139 .91448 -0.29713 Mabsadd L
.82063 .32139 2.37764 .77254 Mabsadd L
.82063 .32139 .56518 .7779 Mabsadd L
.82063 .32139 0 2.5 Mabsadd L closepath F
.82381 .32256 0 2.5 Mabsadd m
.82381 .32256 -0.56518 .7779 Mabsadd L
.82381 .32256 -2.37764 .77254 Mabsadd L
.82381 .32256 -0.91448 -0.29713 Mabsadd L
.82381 .32256 -1.46946 -2.02254 Mabsadd L
.82381 .32256 0 -0.96154 Mabsadd L
.82381 .32256 1.46946 -2.02254 Mabsadd L
.82381 .32256 .91448 -0.29713 Mabsadd L
.82381 .32256 2.37764 .77254 Mabsadd L
.82381 .32256 .56518 .7779 Mabsadd L
.82381 .32256 0 2.5 Mabsadd L closepath F
.82698 .32374 0 2.5 Mabsadd m
.82698 .32374 -0.56518 .7779 Mabsadd L
.82698 .32374 -2.37764 .77254 Mabsadd L
.82698 .32374 -0.91448 -0.29713 Mabsadd L
.82698 .32374 -1.46946 -2.02254 Mabsadd L
.82698 .32374 0 -0.96154 Mabsadd L
.82698 .32374 1.46946 -2.02254 Mabsadd L
.82698 .32374 .91448 -0.29713 Mabsadd L
.82698 .32374 2.37764 .77254 Mabsadd L
.82698 .32374 .56518 .7779 Mabsadd L
.82698 .32374 0 2.5 Mabsadd L closepath F
.83016 .32493 0 2.5 Mabsadd m
.83016 .32493 -0.56518 .7779 Mabsadd L
.83016 .32493 -2.37764 .77254 Mabsadd L
.83016 .32493 -0.91448 -0.29713 Mabsadd L
.83016 .32493 -1.46946 -2.02254 Mabsadd L
.83016 .32493 0 -0.96154 Mabsadd L
.83016 .32493 1.46946 -2.02254 Mabsadd L
.83016 .32493 .91448 -0.29713 Mabsadd L
.83016 .32493 2.37764 .77254 Mabsadd L
.83016 .32493 .56518 .7779 Mabsadd L
.83016 .32493 0 2.5 Mabsadd L closepath F
.83333 .32613 0 2.5 Mabsadd m
.83333 .32613 -0.56518 .7779 Mabsadd L
.83333 .32613 -2.37764 .77254 Mabsadd L
.83333 .32613 -0.91448 -0.29713 Mabsadd L
.83333 .32613 -1.46946 -2.02254 Mabsadd L
.83333 .32613 0 -0.96154 Mabsadd L
.83333 .32613 1.46946 -2.02254 Mabsadd L
.83333 .32613 .91448 -0.29713 Mabsadd L
.83333 .32613 2.37764 .77254 Mabsadd L
.83333 .32613 .56518 .7779 Mabsadd L
.83333 .32613 0 2.5 Mabsadd L closepath F
.83651 .32735 0 2.5 Mabsadd m
.83651 .32735 -0.56518 .7779 Mabsadd L
.83651 .32735 -2.37764 .77254 Mabsadd L
.83651 .32735 -0.91448 -0.29713 Mabsadd L
.83651 .32735 -1.46946 -2.02254 Mabsadd L
.83651 .32735 0 -0.96154 Mabsadd L
.83651 .32735 1.46946 -2.02254 Mabsadd L
.83651 .32735 .91448 -0.29713 Mabsadd L
.83651 .32735 2.37764 .77254 Mabsadd L
.83651 .32735 .56518 .7779 Mabsadd L
.83651 .32735 0 2.5 Mabsadd L closepath F
.83968 .32857 0 2.5 Mabsadd m
.83968 .32857 -0.56518 .7779 Mabsadd L
.83968 .32857 -2.37764 .77254 Mabsadd L
.83968 .32857 -0.91448 -0.29713 Mabsadd L
.83968 .32857 -1.46946 -2.02254 Mabsadd L
.83968 .32857 0 -0.96154 Mabsadd L
.83968 .32857 1.46946 -2.02254 Mabsadd L
.83968 .32857 .91448 -0.29713 Mabsadd L
.83968 .32857 2.37764 .77254 Mabsadd L
.83968 .32857 .56518 .7779 Mabsadd L
.83968 .32857 0 2.5 Mabsadd L closepath F
.84286 .32981 0 2.5 Mabsadd m
.84286 .32981 -0.56518 .7779 Mabsadd L
.84286 .32981 -2.37764 .77254 Mabsadd L
.84286 .32981 -0.91448 -0.29713 Mabsadd L
.84286 .32981 -1.46946 -2.02254 Mabsadd L
.84286 .32981 0 -0.96154 Mabsadd L
.84286 .32981 1.46946 -2.02254 Mabsadd L
.84286 .32981 .91448 -0.29713 Mabsadd L
.84286 .32981 2.37764 .77254 Mabsadd L
.84286 .32981 .56518 .7779 Mabsadd L
.84286 .32981 0 2.5 Mabsadd L closepath F
.84603 .33106 0 2.5 Mabsadd m
.84603 .33106 -0.56518 .7779 Mabsadd L
.84603 .33106 -2.37764 .77254 Mabsadd L
.84603 .33106 -0.91448 -0.29713 Mabsadd L
.84603 .33106 -1.46946 -2.02254 Mabsadd L
.84603 .33106 0 -0.96154 Mabsadd L
.84603 .33106 1.46946 -2.02254 Mabsadd L
.84603 .33106 .91448 -0.29713 Mabsadd L
.84603 .33106 2.37764 .77254 Mabsadd L
.84603 .33106 .56518 .7779 Mabsadd L
.84603 .33106 0 2.5 Mabsadd L closepath F
.84921 .33232 0 2.5 Mabsadd m
.84921 .33232 -0.56518 .7779 Mabsadd L
.84921 .33232 -2.37764 .77254 Mabsadd L
.84921 .33232 -0.91448 -0.29713 Mabsadd L
.84921 .33232 -1.46946 -2.02254 Mabsadd L
.84921 .33232 0 -0.96154 Mabsadd L
.84921 .33232 1.46946 -2.02254 Mabsadd L
.84921 .33232 .91448 -0.29713 Mabsadd L
.84921 .33232 2.37764 .77254 Mabsadd L
.84921 .33232 .56518 .7779 Mabsadd L
.84921 .33232 0 2.5 Mabsadd L closepath F
.85238 .3336 0 2.5 Mabsadd m
.85238 .3336 -0.56518 .7779 Mabsadd L
.85238 .3336 -2.37764 .77254 Mabsadd L
.85238 .3336 -0.91448 -0.29713 Mabsadd L
.85238 .3336 -1.46946 -2.02254 Mabsadd L
.85238 .3336 0 -0.96154 Mabsadd L
.85238 .3336 1.46946 -2.02254 Mabsadd L
.85238 .3336 .91448 -0.29713 Mabsadd L
.85238 .3336 2.37764 .77254 Mabsadd L
.85238 .3336 .56518 .7779 Mabsadd L
.85238 .3336 0 2.5 Mabsadd L closepath F
.85556 .33489 0 2.5 Mabsadd m
.85556 .33489 -0.56518 .7779 Mabsadd L
.85556 .33489 -2.37764 .77254 Mabsadd L
.85556 .33489 -0.91448 -0.29713 Mabsadd L
.85556 .33489 -1.46946 -2.02254 Mabsadd L
.85556 .33489 0 -0.96154 Mabsadd L
.85556 .33489 1.46946 -2.02254 Mabsadd L
.85556 .33489 .91448 -0.29713 Mabsadd L
.85556 .33489 2.37764 .77254 Mabsadd L
.85556 .33489 .56518 .7779 Mabsadd L
.85556 .33489 0 2.5 Mabsadd L closepath F
.85873 .33619 0 2.5 Mabsadd m
.85873 .33619 -0.56518 .7779 Mabsadd L
.85873 .33619 -2.37764 .77254 Mabsadd L
.85873 .33619 -0.91448 -0.29713 Mabsadd L
.85873 .33619 -1.46946 -2.02254 Mabsadd L
.85873 .33619 0 -0.96154 Mabsadd L
.85873 .33619 1.46946 -2.02254 Mabsadd L
.85873 .33619 .91448 -0.29713 Mabsadd L
.85873 .33619 2.37764 .77254 Mabsadd L
.85873 .33619 .56518 .7779 Mabsadd L
.85873 .33619 0 2.5 Mabsadd L closepath F
.8619 .33751 0 2.5 Mabsadd m
.8619 .33751 -0.56518 .7779 Mabsadd L
.8619 .33751 -2.37764 .77254 Mabsadd L
.8619 .33751 -0.91448 -0.29713 Mabsadd L
.8619 .33751 -1.46946 -2.02254 Mabsadd L
.8619 .33751 0 -0.96154 Mabsadd L
.8619 .33751 1.46946 -2.02254 Mabsadd L
.8619 .33751 .91448 -0.29713 Mabsadd L
.8619 .33751 2.37764 .77254 Mabsadd L
.8619 .33751 .56518 .7779 Mabsadd L
.8619 .33751 0 2.5 Mabsadd L closepath F
.86508 .33883 0 2.5 Mabsadd m
.86508 .33883 -0.56518 .7779 Mabsadd L
.86508 .33883 -2.37764 .77254 Mabsadd L
.86508 .33883 -0.91448 -0.29713 Mabsadd L
.86508 .33883 -1.46946 -2.02254 Mabsadd L
.86508 .33883 0 -0.96154 Mabsadd L
.86508 .33883 1.46946 -2.02254 Mabsadd L
.86508 .33883 .91448 -0.29713 Mabsadd L
.86508 .33883 2.37764 .77254 Mabsadd L
.86508 .33883 .56518 .7779 Mabsadd L
.86508 .33883 0 2.5 Mabsadd L closepath F
.86825 .34018 0 2.5 Mabsadd m
.86825 .34018 -0.56518 .7779 Mabsadd L
.86825 .34018 -2.37764 .77254 Mabsadd L
.86825 .34018 -0.91448 -0.29713 Mabsadd L
.86825 .34018 -1.46946 -2.02254 Mabsadd L
.86825 .34018 0 -0.96154 Mabsadd L
.86825 .34018 1.46946 -2.02254 Mabsadd L
.86825 .34018 .91448 -0.29713 Mabsadd L
.86825 .34018 2.37764 .77254 Mabsadd L
.86825 .34018 .56518 .7779 Mabsadd L
.86825 .34018 0 2.5 Mabsadd L closepath F
.87143 .34153 0 2.5 Mabsadd m
.87143 .34153 -0.56518 .7779 Mabsadd L
.87143 .34153 -2.37764 .77254 Mabsadd L
.87143 .34153 -0.91448 -0.29713 Mabsadd L
.87143 .34153 -1.46946 -2.02254 Mabsadd L
.87143 .34153 0 -0.96154 Mabsadd L
.87143 .34153 1.46946 -2.02254 Mabsadd L
.87143 .34153 .91448 -0.29713 Mabsadd L
.87143 .34153 2.37764 .77254 Mabsadd L
.87143 .34153 .56518 .7779 Mabsadd L
.87143 .34153 0 2.5 Mabsadd L closepath F
.8746 .3429 0 2.5 Mabsadd m
.8746 .3429 -0.56518 .7779 Mabsadd L
.8746 .3429 -2.37764 .77254 Mabsadd L
.8746 .3429 -0.91448 -0.29713 Mabsadd L
.8746 .3429 -1.46946 -2.02254 Mabsadd L
.8746 .3429 0 -0.96154 Mabsadd L
.8746 .3429 1.46946 -2.02254 Mabsadd L
.8746 .3429 .91448 -0.29713 Mabsadd L
.8746 .3429 2.37764 .77254 Mabsadd L
.8746 .3429 .56518 .7779 Mabsadd L
.8746 .3429 0 2.5 Mabsadd L closepath F
.87778 .34428 0 2.5 Mabsadd m
.87778 .34428 -0.56518 .7779 Mabsadd L
.87778 .34428 -2.37764 .77254 Mabsadd L
.87778 .34428 -0.91448 -0.29713 Mabsadd L
.87778 .34428 -1.46946 -2.02254 Mabsadd L
.87778 .34428 0 -0.96154 Mabsadd L
.87778 .34428 1.46946 -2.02254 Mabsadd L
.87778 .34428 .91448 -0.29713 Mabsadd L
.87778 .34428 2.37764 .77254 Mabsadd L
.87778 .34428 .56518 .7779 Mabsadd L
.87778 .34428 0 2.5 Mabsadd L closepath F
.88095 .34568 0 2.5 Mabsadd m
.88095 .34568 -0.56518 .7779 Mabsadd L
.88095 .34568 -2.37764 .77254 Mabsadd L
.88095 .34568 -0.91448 -0.29713 Mabsadd L
.88095 .34568 -1.46946 -2.02254 Mabsadd L
.88095 .34568 0 -0.96154 Mabsadd L
.88095 .34568 1.46946 -2.02254 Mabsadd L
.88095 .34568 .91448 -0.29713 Mabsadd L
.88095 .34568 2.37764 .77254 Mabsadd L
.88095 .34568 .56518 .7779 Mabsadd L
.88095 .34568 0 2.5 Mabsadd L closepath F
.88413 .34709 0 2.5 Mabsadd m
.88413 .34709 -0.56518 .7779 Mabsadd L
.88413 .34709 -2.37764 .77254 Mabsadd L
.88413 .34709 -0.91448 -0.29713 Mabsadd L
.88413 .34709 -1.46946 -2.02254 Mabsadd L
.88413 .34709 0 -0.96154 Mabsadd L
.88413 .34709 1.46946 -2.02254 Mabsadd L
.88413 .34709 .91448 -0.29713 Mabsadd L
.88413 .34709 2.37764 .77254 Mabsadd L
.88413 .34709 .56518 .7779 Mabsadd L
.88413 .34709 0 2.5 Mabsadd L closepath F
.8873 .34851 0 2.5 Mabsadd m
.8873 .34851 -0.56518 .7779 Mabsadd L
.8873 .34851 -2.37764 .77254 Mabsadd L
.8873 .34851 -0.91448 -0.29713 Mabsadd L
.8873 .34851 -1.46946 -2.02254 Mabsadd L
.8873 .34851 0 -0.96154 Mabsadd L
.8873 .34851 1.46946 -2.02254 Mabsadd L
.8873 .34851 .91448 -0.29713 Mabsadd L
.8873 .34851 2.37764 .77254 Mabsadd L
.8873 .34851 .56518 .7779 Mabsadd L
.8873 .34851 0 2.5 Mabsadd L closepath F
.89048 .34995 0 2.5 Mabsadd m
.89048 .34995 -0.56518 .7779 Mabsadd L
.89048 .34995 -2.37764 .77254 Mabsadd L
.89048 .34995 -0.91448 -0.29713 Mabsadd L
.89048 .34995 -1.46946 -2.02254 Mabsadd L
.89048 .34995 0 -0.96154 Mabsadd L
.89048 .34995 1.46946 -2.02254 Mabsadd L
.89048 .34995 .91448 -0.29713 Mabsadd L
.89048 .34995 2.37764 .77254 Mabsadd L
.89048 .34995 .56518 .7779 Mabsadd L
.89048 .34995 0 2.5 Mabsadd L closepath F
.89365 .3514 0 2.5 Mabsadd m
.89365 .3514 -0.56518 .7779 Mabsadd L
.89365 .3514 -2.37764 .77254 Mabsadd L
.89365 .3514 -0.91448 -0.29713 Mabsadd L
.89365 .3514 -1.46946 -2.02254 Mabsadd L
.89365 .3514 0 -0.96154 Mabsadd L
.89365 .3514 1.46946 -2.02254 Mabsadd L
.89365 .3514 .91448 -0.29713 Mabsadd L
.89365 .3514 2.37764 .77254 Mabsadd L
.89365 .3514 .56518 .7779 Mabsadd L
.89365 .3514 0 2.5 Mabsadd L closepath F
.89683 .35287 0 2.5 Mabsadd m
.89683 .35287 -0.56518 .7779 Mabsadd L
.89683 .35287 -2.37764 .77254 Mabsadd L
.89683 .35287 -0.91448 -0.29713 Mabsadd L
.89683 .35287 -1.46946 -2.02254 Mabsadd L
.89683 .35287 0 -0.96154 Mabsadd L
.89683 .35287 1.46946 -2.02254 Mabsadd L
.89683 .35287 .91448 -0.29713 Mabsadd L
.89683 .35287 2.37764 .77254 Mabsadd L
.89683 .35287 .56518 .7779 Mabsadd L
.89683 .35287 0 2.5 Mabsadd L closepath F
.9 .35435 0 2.5 Mabsadd m
.9 .35435 -0.56518 .7779 Mabsadd L
.9 .35435 -2.37764 .77254 Mabsadd L
.9 .35435 -0.91448 -0.29713 Mabsadd L
.9 .35435 -1.46946 -2.02254 Mabsadd L
.9 .35435 0 -0.96154 Mabsadd L
.9 .35435 1.46946 -2.02254 Mabsadd L
.9 .35435 .91448 -0.29713 Mabsadd L
.9 .35435 2.37764 .77254 Mabsadd L
.9 .35435 .56518 .7779 Mabsadd L
.9 .35435 0 2.5 Mabsadd L closepath F
.90317 .35584 0 2.5 Mabsadd m
.90317 .35584 -0.56518 .7779 Mabsadd L
.90317 .35584 -2.37764 .77254 Mabsadd L
.90317 .35584 -0.91448 -0.29713 Mabsadd L
.90317 .35584 -1.46946 -2.02254 Mabsadd L
.90317 .35584 0 -0.96154 Mabsadd L
.90317 .35584 1.46946 -2.02254 Mabsadd L
.90317 .35584 .91448 -0.29713 Mabsadd L
.90317 .35584 2.37764 .77254 Mabsadd L
.90317 .35584 .56518 .7779 Mabsadd L
.90317 .35584 0 2.5 Mabsadd L closepath F
.90635 .35736 0 2.5 Mabsadd m
.90635 .35736 -0.56518 .7779 Mabsadd L
.90635 .35736 -2.37764 .77254 Mabsadd L
.90635 .35736 -0.91448 -0.29713 Mabsadd L
.90635 .35736 -1.46946 -2.02254 Mabsadd L
.90635 .35736 0 -0.96154 Mabsadd L
.90635 .35736 1.46946 -2.02254 Mabsadd L
.90635 .35736 .91448 -0.29713 Mabsadd L
.90635 .35736 2.37764 .77254 Mabsadd L
.90635 .35736 .56518 .7779 Mabsadd L
.90635 .35736 0 2.5 Mabsadd L closepath F
.90952 .35888 0 2.5 Mabsadd m
.90952 .35888 -0.56518 .7779 Mabsadd L
.90952 .35888 -2.37764 .77254 Mabsadd L
.90952 .35888 -0.91448 -0.29713 Mabsadd L
.90952 .35888 -1.46946 -2.02254 Mabsadd L
.90952 .35888 0 -0.96154 Mabsadd L
.90952 .35888 1.46946 -2.02254 Mabsadd L
.90952 .35888 .91448 -0.29713 Mabsadd L
.90952 .35888 2.37764 .77254 Mabsadd L
.90952 .35888 .56518 .7779 Mabsadd L
.90952 .35888 0 2.5 Mabsadd L closepath F
.9127 .36042 0 2.5 Mabsadd m
.9127 .36042 -0.56518 .7779 Mabsadd L
.9127 .36042 -2.37764 .77254 Mabsadd L
.9127 .36042 -0.91448 -0.29713 Mabsadd L
.9127 .36042 -1.46946 -2.02254 Mabsadd L
.9127 .36042 0 -0.96154 Mabsadd L
.9127 .36042 1.46946 -2.02254 Mabsadd L
.9127 .36042 .91448 -0.29713 Mabsadd L
.9127 .36042 2.37764 .77254 Mabsadd L
.9127 .36042 .56518 .7779 Mabsadd L
.9127 .36042 0 2.5 Mabsadd L closepath F
.91587 .36198 0 2.5 Mabsadd m
.91587 .36198 -0.56518 .7779 Mabsadd L
.91587 .36198 -2.37764 .77254 Mabsadd L
.91587 .36198 -0.91448 -0.29713 Mabsadd L
.91587 .36198 -1.46946 -2.02254 Mabsadd L
.91587 .36198 0 -0.96154 Mabsadd L
.91587 .36198 1.46946 -2.02254 Mabsadd L
.91587 .36198 .91448 -0.29713 Mabsadd L
.91587 .36198 2.37764 .77254 Mabsadd L
.91587 .36198 .56518 .7779 Mabsadd L
.91587 .36198 0 2.5 Mabsadd L closepath F
.91905 .36355 0 2.5 Mabsadd m
.91905 .36355 -0.56518 .7779 Mabsadd L
.91905 .36355 -2.37764 .77254 Mabsadd L
.91905 .36355 -0.91448 -0.29713 Mabsadd L
.91905 .36355 -1.46946 -2.02254 Mabsadd L
.91905 .36355 0 -0.96154 Mabsadd L
.91905 .36355 1.46946 -2.02254 Mabsadd L
.91905 .36355 .91448 -0.29713 Mabsadd L
.91905 .36355 2.37764 .77254 Mabsadd L
.91905 .36355 .56518 .7779 Mabsadd L
.91905 .36355 0 2.5 Mabsadd L closepath F
.92222 .36514 0 2.5 Mabsadd m
.92222 .36514 -0.56518 .7779 Mabsadd L
.92222 .36514 -2.37764 .77254 Mabsadd L
.92222 .36514 -0.91448 -0.29713 Mabsadd L
.92222 .36514 -1.46946 -2.02254 Mabsadd L
.92222 .36514 0 -0.96154 Mabsadd L
.92222 .36514 1.46946 -2.02254 Mabsadd L
.92222 .36514 .91448 -0.29713 Mabsadd L
.92222 .36514 2.37764 .77254 Mabsadd L
.92222 .36514 .56518 .7779 Mabsadd L
.92222 .36514 0 2.5 Mabsadd L closepath F
.9254 .36675 0 2.5 Mabsadd m
.9254 .36675 -0.56518 .7779 Mabsadd L
.9254 .36675 -2.37764 .77254 Mabsadd L
.9254 .36675 -0.91448 -0.29713 Mabsadd L
.9254 .36675 -1.46946 -2.02254 Mabsadd L
.9254 .36675 0 -0.96154 Mabsadd L
.9254 .36675 1.46946 -2.02254 Mabsadd L
.9254 .36675 .91448 -0.29713 Mabsadd L
.9254 .36675 2.37764 .77254 Mabsadd L
.9254 .36675 .56518 .7779 Mabsadd L
.9254 .36675 0 2.5 Mabsadd L closepath F
.92857 .36837 0 2.5 Mabsadd m
.92857 .36837 -0.56518 .7779 Mabsadd L
.92857 .36837 -2.37764 .77254 Mabsadd L
.92857 .36837 -0.91448 -0.29713 Mabsadd L
.92857 .36837 -1.46946 -2.02254 Mabsadd L
.92857 .36837 0 -0.96154 Mabsadd L
.92857 .36837 1.46946 -2.02254 Mabsadd L
.92857 .36837 .91448 -0.29713 Mabsadd L
.92857 .36837 2.37764 .77254 Mabsadd L
.92857 .36837 .56518 .7779 Mabsadd L
.92857 .36837 0 2.5 Mabsadd L closepath F
.93175 .37 0 2.5 Mabsadd m
.93175 .37 -0.56518 .7779 Mabsadd L
.93175 .37 -2.37764 .77254 Mabsadd L
.93175 .37 -0.91448 -0.29713 Mabsadd L
.93175 .37 -1.46946 -2.02254 Mabsadd L
.93175 .37 0 -0.96154 Mabsadd L
.93175 .37 1.46946 -2.02254 Mabsadd L
.93175 .37 .91448 -0.29713 Mabsadd L
.93175 .37 2.37764 .77254 Mabsadd L
.93175 .37 .56518 .7779 Mabsadd L
.93175 .37 0 2.5 Mabsadd L closepath F
.93492 .37166 0 2.5 Mabsadd m
.93492 .37166 -0.56518 .7779 Mabsadd L
.93492 .37166 -2.37764 .77254 Mabsadd L
.93492 .37166 -0.91448 -0.29713 Mabsadd L
.93492 .37166 -1.46946 -2.02254 Mabsadd L
.93492 .37166 0 -0.96154 Mabsadd L
.93492 .37166 1.46946 -2.02254 Mabsadd L
.93492 .37166 .91448 -0.29713 Mabsadd L
.93492 .37166 2.37764 .77254 Mabsadd L
.93492 .37166 .56518 .7779 Mabsadd L
.93492 .37166 0 2.5 Mabsadd L closepath F
.9381 .37333 0 2.5 Mabsadd m
.9381 .37333 -0.56518 .7779 Mabsadd L
.9381 .37333 -2.37764 .77254 Mabsadd L
.9381 .37333 -0.91448 -0.29713 Mabsadd L
.9381 .37333 -1.46946 -2.02254 Mabsadd L
.9381 .37333 0 -0.96154 Mabsadd L
.9381 .37333 1.46946 -2.02254 Mabsadd L
.9381 .37333 .91448 -0.29713 Mabsadd L
.9381 .37333 2.37764 .77254 Mabsadd L
.9381 .37333 .56518 .7779 Mabsadd L
.9381 .37333 0 2.5 Mabsadd L closepath F
.94127 .37501 0 2.5 Mabsadd m
.94127 .37501 -0.56518 .7779 Mabsadd L
.94127 .37501 -2.37764 .77254 Mabsadd L
.94127 .37501 -0.91448 -0.29713 Mabsadd L
.94127 .37501 -1.46946 -2.02254 Mabsadd L
.94127 .37501 0 -0.96154 Mabsadd L
.94127 .37501 1.46946 -2.02254 Mabsadd L
.94127 .37501 .91448 -0.29713 Mabsadd L
.94127 .37501 2.37764 .77254 Mabsadd L
.94127 .37501 .56518 .7779 Mabsadd L
.94127 .37501 0 2.5 Mabsadd L closepath F
.94444 .37671 0 2.5 Mabsadd m
.94444 .37671 -0.56518 .7779 Mabsadd L
.94444 .37671 -2.37764 .77254 Mabsadd L
.94444 .37671 -0.91448 -0.29713 Mabsadd L
.94444 .37671 -1.46946 -2.02254 Mabsadd L
.94444 .37671 0 -0.96154 Mabsadd L
.94444 .37671 1.46946 -2.02254 Mabsadd L
.94444 .37671 .91448 -0.29713 Mabsadd L
.94444 .37671 2.37764 .77254 Mabsadd L
.94444 .37671 .56518 .7779 Mabsadd L
.94444 .37671 0 2.5 Mabsadd L closepath F
.94762 .37843 0 2.5 Mabsadd m
.94762 .37843 -0.56518 .7779 Mabsadd L
.94762 .37843 -2.37764 .77254 Mabsadd L
.94762 .37843 -0.91448 -0.29713 Mabsadd L
.94762 .37843 -1.46946 -2.02254 Mabsadd L
.94762 .37843 0 -0.96154 Mabsadd L
.94762 .37843 1.46946 -2.02254 Mabsadd L
.94762 .37843 .91448 -0.29713 Mabsadd L
.94762 .37843 2.37764 .77254 Mabsadd L
.94762 .37843 .56518 .7779 Mabsadd L
.94762 .37843 0 2.5 Mabsadd L closepath F
.95079 .38017 0 2.5 Mabsadd m
.95079 .38017 -0.56518 .7779 Mabsadd L
.95079 .38017 -2.37764 .77254 Mabsadd L
.95079 .38017 -0.91448 -0.29713 Mabsadd L
.95079 .38017 -1.46946 -2.02254 Mabsadd L
.95079 .38017 0 -0.96154 Mabsadd L
.95079 .38017 1.46946 -2.02254 Mabsadd L
.95079 .38017 .91448 -0.29713 Mabsadd L
.95079 .38017 2.37764 .77254 Mabsadd L
.95079 .38017 .56518 .7779 Mabsadd L
.95079 .38017 0 2.5 Mabsadd L closepath F
.95397 .38193 0 2.5 Mabsadd m
.95397 .38193 -0.56518 .7779 Mabsadd L
.95397 .38193 -2.37764 .77254 Mabsadd L
.95397 .38193 -0.91448 -0.29713 Mabsadd L
.95397 .38193 -1.46946 -2.02254 Mabsadd L
.95397 .38193 0 -0.96154 Mabsadd L
.95397 .38193 1.46946 -2.02254 Mabsadd L
.95397 .38193 .91448 -0.29713 Mabsadd L
.95397 .38193 2.37764 .77254 Mabsadd L
.95397 .38193 .56518 .7779 Mabsadd L
.95397 .38193 0 2.5 Mabsadd L closepath F
.95714 .3837 0 2.5 Mabsadd m
.95714 .3837 -0.56518 .7779 Mabsadd L
.95714 .3837 -2.37764 .77254 Mabsadd L
.95714 .3837 -0.91448 -0.29713 Mabsadd L
.95714 .3837 -1.46946 -2.02254 Mabsadd L
.95714 .3837 0 -0.96154 Mabsadd L
.95714 .3837 1.46946 -2.02254 Mabsadd L
.95714 .3837 .91448 -0.29713 Mabsadd L
.95714 .3837 2.37764 .77254 Mabsadd L
.95714 .3837 .56518 .7779 Mabsadd L
.95714 .3837 0 2.5 Mabsadd L closepath F
.96032 .38549 0 2.5 Mabsadd m
.96032 .38549 -0.56518 .7779 Mabsadd L
.96032 .38549 -2.37764 .77254 Mabsadd L
.96032 .38549 -0.91448 -0.29713 Mabsadd L
.96032 .38549 -1.46946 -2.02254 Mabsadd L
.96032 .38549 0 -0.96154 Mabsadd L
.96032 .38549 1.46946 -2.02254 Mabsadd L
.96032 .38549 .91448 -0.29713 Mabsadd L
.96032 .38549 2.37764 .77254 Mabsadd L
.96032 .38549 .56518 .7779 Mabsadd L
.96032 .38549 0 2.5 Mabsadd L closepath F
.96349 .3873 0 2.5 Mabsadd m
.96349 .3873 -0.56518 .7779 Mabsadd L
.96349 .3873 -2.37764 .77254 Mabsadd L
.96349 .3873 -0.91448 -0.29713 Mabsadd L
.96349 .3873 -1.46946 -2.02254 Mabsadd L
.96349 .3873 0 -0.96154 Mabsadd L
.96349 .3873 1.46946 -2.02254 Mabsadd L
.96349 .3873 .91448 -0.29713 Mabsadd L
.96349 .3873 2.37764 .77254 Mabsadd L
.96349 .3873 .56518 .7779 Mabsadd L
.96349 .3873 0 2.5 Mabsadd L closepath F
.96667 .38912 0 2.5 Mabsadd m
.96667 .38912 -0.56518 .7779 Mabsadd L
.96667 .38912 -2.37764 .77254 Mabsadd L
.96667 .38912 -0.91448 -0.29713 Mabsadd L
.96667 .38912 -1.46946 -2.02254 Mabsadd L
.96667 .38912 0 -0.96154 Mabsadd L
.96667 .38912 1.46946 -2.02254 Mabsadd L
.96667 .38912 .91448 -0.29713 Mabsadd L
.96667 .38912 2.37764 .77254 Mabsadd L
.96667 .38912 .56518 .7779 Mabsadd L
.96667 .38912 0 2.5 Mabsadd L closepath F
.96984 .39097 0 2.5 Mabsadd m
.96984 .39097 -0.56518 .7779 Mabsadd L
.96984 .39097 -2.37764 .77254 Mabsadd L
.96984 .39097 -0.91448 -0.29713 Mabsadd L
.96984 .39097 -1.46946 -2.02254 Mabsadd L
.96984 .39097 0 -0.96154 Mabsadd L
.96984 .39097 1.46946 -2.02254 Mabsadd L
.96984 .39097 .91448 -0.29713 Mabsadd L
.96984 .39097 2.37764 .77254 Mabsadd L
.96984 .39097 .56518 .7779 Mabsadd L
.96984 .39097 0 2.5 Mabsadd L closepath F
.97302 .39283 0 2.5 Mabsadd m
.97302 .39283 -0.56518 .7779 Mabsadd L
.97302 .39283 -2.37764 .77254 Mabsadd L
.97302 .39283 -0.91448 -0.29713 Mabsadd L
.97302 .39283 -1.46946 -2.02254 Mabsadd L
.97302 .39283 0 -0.96154 Mabsadd L
.97302 .39283 1.46946 -2.02254 Mabsadd L
.97302 .39283 .91448 -0.29713 Mabsadd L
.97302 .39283 2.37764 .77254 Mabsadd L
.97302 .39283 .56518 .7779 Mabsadd L
.97302 .39283 0 2.5 Mabsadd L closepath F
.97619 .39471 0 2.5 Mabsadd m
.97619 .39471 -0.56518 .7779 Mabsadd L
.97619 .39471 -2.37764 .77254 Mabsadd L
.97619 .39471 -0.91448 -0.29713 Mabsadd L
.97619 .39471 -1.46946 -2.02254 Mabsadd L
.97619 .39471 0 -0.96154 Mabsadd L
.97619 .39471 1.46946 -2.02254 Mabsadd L
.97619 .39471 .91448 -0.29713 Mabsadd L
.97619 .39471 2.37764 .77254 Mabsadd L
.97619 .39471 .56518 .7779 Mabsadd L
.97619 .39471 0 2.5 Mabsadd L closepath F
.0075 w
.02698 .22411 m
.03016 .2243 L
.03333 .2245 L
.03651 .2247 L
.03968 .22489 L
.04286 .2251 L
.04603 .2253 L
.04921 .22551 L
.05238 .22571 L
.05556 .22592 L
.05873 .22614 L
.0619 .22635 L
.06508 .22657 L
.06825 .22679 L
.07143 .22701 L
.0746 .22723 L
.07778 .22745 L
.08095 .22768 L
.08413 .22791 L
.0873 .22814 L
.09048 .22838 L
.09365 .22861 L
.09683 .22885 L
.1 .2291 L
.10317 .22934 L
.10635 .22959 L
.10952 .22983 L
.1127 .23009 L
.11587 .23034 L
.11905 .2306 L
.12222 .23085 L
.1254 .23112 L
.12857 .23138 L
.13175 .23165 L
.13492 .23192 L
.1381 .23219 L
.14127 .23246 L
.14444 .23274 L
.14762 .23302 L
.15079 .2333 L
.15397 .23359 L
.15714 .23388 L
.16032 .23417 L
.16349 .23446 L
.16667 .23476 L
.16984 .23506 L
.17302 .23537 L
.17619 .23567 L
.17937 .23598 L
.18254 .23629 L
Mistroke
.18571 .23661 L
.18889 .23693 L
.19206 .23725 L
.19524 .23758 L
.19841 .23791 L
.20159 .23824 L
.20476 .23857 L
.20794 .23891 L
.21111 .23925 L
.21429 .2396 L
.21746 .23995 L
.22063 .2403 L
.22381 .24066 L
.22698 .24101 L
.23016 .24138 L
.23333 .24174 L
.23651 .24211 L
.23968 .24249 L
.24286 .24287 L
.24603 .24325 L
.24921 .24363 L
.25238 .24402 L
.25556 .24442 L
.25873 .24481 L
.2619 .24521 L
.26508 .24562 L
.26825 .24603 L
.27143 .24644 L
.2746 .24686 L
.27778 .24728 L
.28095 .24771 L
.28413 .24814 L
.2873 .24857 L
.29048 .24901 L
.29365 .24945 L
.29683 .2499 L
.3 .25035 L
.30317 .25081 L
.30635 .25127 L
.30952 .25173 L
.3127 .2522 L
.31587 .25268 L
.31905 .25316 L
.32222 .25364 L
.3254 .25413 L
.32857 .25463 L
.33175 .25513 L
.33492 .25563 L
.3381 .25614 L
.34127 .25665 L
Mistroke
.34444 .25717 L
.34762 .2577 L
.35079 .25823 L
.35397 .25876 L
.35714 .2593 L
.36032 .25985 L
.36349 .2604 L
.36667 .26096 L
.36984 .26152 L
.37302 .26209 L
.37619 .26266 L
.37937 .26324 L
.38254 .26383 L
.38571 .26442 L
.38889 .26501 L
.39206 .26562 L
.39524 .26623 L
.39841 .26684 L
.40159 .26746 L
.40476 .26809 L
.40794 .26872 L
.41111 .26936 L
.41429 .27001 L
.41746 .27066 L
.42063 .27132 L
.42381 .27199 L
.42698 .27266 L
.43016 .27334 L
.43333 .27403 L
.43651 .27472 L
.43968 .27542 L
.44286 .27613 L
.44603 .27684 L
.44921 .27756 L
.45238 .27829 L
.45556 .27903 L
.45873 .27977 L
.4619 .28052 L
.46508 .28128 L
.46825 .28204 L
.47143 .28282 L
.4746 .2836 L
.47778 .28439 L
.48095 .28518 L
.48413 .28599 L
.4873 .2868 L
.49048 .28762 L
.49365 .28845 L
.49683 .28929 L
.5 .29013 L
Mistroke
.50317 .29099 L
.50635 .29185 L
.50952 .29272 L
.5127 .2936 L
.51587 .29449 L
.51905 .29539 L
.52222 .2963 L
.5254 .29721 L
.52857 .29814 L
.53175 .29907 L
.53492 .30002 L
.5381 .30097 L
.54127 .30193 L
.54444 .3029 L
.54762 .30389 L
.55079 .30488 L
.55397 .30588 L
.55714 .30689 L
.56032 .30791 L
.56349 .30894 L
.56667 .30999 L
.56984 .31104 L
.57302 .3121 L
.57619 .31318 L
.57937 .31426 L
.58254 .31536 L
.58571 .31646 L
.58889 .31758 L
.59206 .31871 L
.59524 .31985 L
.59841 .321 L
.60159 .32216 L
.60476 .32334 L
.60794 .32452 L
.61111 .32572 L
.61429 .32693 L
.61746 .32815 L
.62063 .32939 L
.62381 .33064 L
.62698 .33189 L
.63016 .33317 L
.63333 .33445 L
.63651 .33575 L
.63968 .33706 L
.64286 .33838 L
.64603 .33972 L
.64921 .34107 L
.65238 .34243 L
.65556 .34381 L
.65873 .3452 L
Mistroke
.6619 .34661 L
.66508 .34802 L
.66825 .34946 L
.67143 .35091 L
.6746 .35237 L
.67778 .35384 L
.68095 .35534 L
.68413 .35684 L
.6873 .35836 L
.69048 .3599 L
.69365 .36145 L
.69683 .36302 L
.7 .3646 L
.70317 .3662 L
.70635 .36782 L
.70952 .36945 L
.7127 .37109 L
.71587 .37276 L
.71905 .37444 L
.72222 .37614 L
.7254 .37785 L
.72857 .37958 L
.73175 .38133 L
.73492 .3831 L
.7381 .38488 L
.74127 .38668 L
.74444 .3885 L
.74762 .39034 L
.75079 .39219 L
.75397 .39407 L
.75714 .39596 L
.76032 .39788 L
.76349 .39981 L
.76667 .40176 L
.76984 .40373 L
.77302 .40572 L
.77619 .40773 L
.77937 .40976 L
.78254 .41181 L
.78571 .41388 L
.78889 .41597 L
.79206 .41808 L
.79524 .42022 L
.79841 .42237 L
.80159 .42455 L
.80476 .42675 L
.80794 .42897 L
.81111 .43121 L
.81429 .43348 L
.81746 .43576 L
Mistroke
.82063 .43807 L
.82381 .44041 L
.82698 .44277 L
.83016 .44515 L
.83333 .44755 L
.83651 .44998 L
.83968 .45243 L
.84286 .45491 L
.84603 .45741 L
.84921 .45994 L
.85238 .46249 L
.85556 .46507 L
.85873 .46767 L
.8619 .4703 L
.86508 .47296 L
.86825 .47564 L
.87143 .47835 L
.8746 .48108 L
.87778 .48385 L
.88095 .48664 L
.88413 .48946 L
.8873 .49231 L
.89048 .49518 L
.89365 .49809 L
.89683 .50102 L
.9 .50398 L
.90317 .50698 L
.90635 .51 L
.90952 .51305 L
.9127 .51614 L
.91587 .51925 L
.91905 .52239 L
.92222 .52557 L
.9254 .52878 L
.92857 .53202 L
.93175 .53529 L
.93492 .5386 L
.9381 .54194 L
.94127 .54531 L
.94444 .54872 L
.94762 .55216 L
.95079 .55563 L
.95397 .55914 L
.95714 .56268 L
.96032 .56626 L
.96349 .56988 L
.96667 .57353 L
.96984 .57722 L
.97302 .58095 L
.97619 .58471 L
Mistroke
Mfstroke
.0001 w
.02698 .22411 -2.5 2.5 Mabsadd m
.02698 .22411 2.5 2.5 Mabsadd L
.02698 .22411 2.5 -2.5 Mabsadd L
.02698 .22411 -2.5 -2.5 Mabsadd L
.02698 .22411 -2.5 2.5 Mabsadd L closepath F
.03016 .2243 -2.5 2.5 Mabsadd m
.03016 .2243 2.5 2.5 Mabsadd L
.03016 .2243 2.5 -2.5 Mabsadd L
.03016 .2243 -2.5 -2.5 Mabsadd L
.03016 .2243 -2.5 2.5 Mabsadd L closepath F
.03333 .2245 -2.5 2.5 Mabsadd m
.03333 .2245 2.5 2.5 Mabsadd L
.03333 .2245 2.5 -2.5 Mabsadd L
.03333 .2245 -2.5 -2.5 Mabsadd L
.03333 .2245 -2.5 2.5 Mabsadd L closepath F
.03651 .2247 -2.5 2.5 Mabsadd m
.03651 .2247 2.5 2.5 Mabsadd L
.03651 .2247 2.5 -2.5 Mabsadd L
.03651 .2247 -2.5 -2.5 Mabsadd L
.03651 .2247 -2.5 2.5 Mabsadd L closepath F
.03968 .22489 -2.5 2.5 Mabsadd m
.03968 .22489 2.5 2.5 Mabsadd L
.03968 .22489 2.5 -2.5 Mabsadd L
.03968 .22489 -2.5 -2.5 Mabsadd L
.03968 .22489 -2.5 2.5 Mabsadd L closepath F
.04286 .2251 -2.5 2.5 Mabsadd m
.04286 .2251 2.5 2.5 Mabsadd L
.04286 .2251 2.5 -2.5 Mabsadd L
.04286 .2251 -2.5 -2.5 Mabsadd L
.04286 .2251 -2.5 2.5 Mabsadd L closepath F
.04603 .2253 -2.5 2.5 Mabsadd m
.04603 .2253 2.5 2.5 Mabsadd L
.04603 .2253 2.5 -2.5 Mabsadd L
.04603 .2253 -2.5 -2.5 Mabsadd L
.04603 .2253 -2.5 2.5 Mabsadd L closepath F
.04921 .22551 -2.5 2.5 Mabsadd m
.04921 .22551 2.5 2.5 Mabsadd L
.04921 .22551 2.5 -2.5 Mabsadd L
.04921 .22551 -2.5 -2.5 Mabsadd L
.04921 .22551 -2.5 2.5 Mabsadd L closepath F
.05238 .22571 -2.5 2.5 Mabsadd m
.05238 .22571 2.5 2.5 Mabsadd L
.05238 .22571 2.5 -2.5 Mabsadd L
.05238 .22571 -2.5 -2.5 Mabsadd L
.05238 .22571 -2.5 2.5 Mabsadd L closepath F
.05556 .22592 -2.5 2.5 Mabsadd m
.05556 .22592 2.5 2.5 Mabsadd L
.05556 .22592 2.5 -2.5 Mabsadd L
.05556 .22592 -2.5 -2.5 Mabsadd L
.05556 .22592 -2.5 2.5 Mabsadd L closepath F
.05873 .22614 -2.5 2.5 Mabsadd m
.05873 .22614 2.5 2.5 Mabsadd L
.05873 .22614 2.5 -2.5 Mabsadd L
.05873 .22614 -2.5 -2.5 Mabsadd L
.05873 .22614 -2.5 2.5 Mabsadd L closepath F
.0619 .22635 -2.5 2.5 Mabsadd m
.0619 .22635 2.5 2.5 Mabsadd L
.0619 .22635 2.5 -2.5 Mabsadd L
.0619 .22635 -2.5 -2.5 Mabsadd L
.0619 .22635 -2.5 2.5 Mabsadd L closepath F
.06508 .22657 -2.5 2.5 Mabsadd m
.06508 .22657 2.5 2.5 Mabsadd L
.06508 .22657 2.5 -2.5 Mabsadd L
.06508 .22657 -2.5 -2.5 Mabsadd L
.06508 .22657 -2.5 2.5 Mabsadd L closepath F
.06825 .22679 -2.5 2.5 Mabsadd m
.06825 .22679 2.5 2.5 Mabsadd L
.06825 .22679 2.5 -2.5 Mabsadd L
.06825 .22679 -2.5 -2.5 Mabsadd L
.06825 .22679 -2.5 2.5 Mabsadd L closepath F
.07143 .22701 -2.5 2.5 Mabsadd m
.07143 .22701 2.5 2.5 Mabsadd L
.07143 .22701 2.5 -2.5 Mabsadd L
.07143 .22701 -2.5 -2.5 Mabsadd L
.07143 .22701 -2.5 2.5 Mabsadd L closepath F
.0746 .22723 -2.5 2.5 Mabsadd m
.0746 .22723 2.5 2.5 Mabsadd L
.0746 .22723 2.5 -2.5 Mabsadd L
.0746 .22723 -2.5 -2.5 Mabsadd L
.0746 .22723 -2.5 2.5 Mabsadd L closepath F
.07778 .22745 -2.5 2.5 Mabsadd m
.07778 .22745 2.5 2.5 Mabsadd L
.07778 .22745 2.5 -2.5 Mabsadd L
.07778 .22745 -2.5 -2.5 Mabsadd L
.07778 .22745 -2.5 2.5 Mabsadd L closepath F
.08095 .22768 -2.5 2.5 Mabsadd m
.08095 .22768 2.5 2.5 Mabsadd L
.08095 .22768 2.5 -2.5 Mabsadd L
.08095 .22768 -2.5 -2.5 Mabsadd L
.08095 .22768 -2.5 2.5 Mabsadd L closepath F
.08413 .22791 -2.5 2.5 Mabsadd m
.08413 .22791 2.5 2.5 Mabsadd L
.08413 .22791 2.5 -2.5 Mabsadd L
.08413 .22791 -2.5 -2.5 Mabsadd L
.08413 .22791 -2.5 2.5 Mabsadd L closepath F
.0873 .22814 -2.5 2.5 Mabsadd m
.0873 .22814 2.5 2.5 Mabsadd L
.0873 .22814 2.5 -2.5 Mabsadd L
.0873 .22814 -2.5 -2.5 Mabsadd L
.0873 .22814 -2.5 2.5 Mabsadd L closepath F
.09048 .22838 -2.5 2.5 Mabsadd m
.09048 .22838 2.5 2.5 Mabsadd L
.09048 .22838 2.5 -2.5 Mabsadd L
.09048 .22838 -2.5 -2.5 Mabsadd L
.09048 .22838 -2.5 2.5 Mabsadd L closepath F
.09365 .22861 -2.5 2.5 Mabsadd m
.09365 .22861 2.5 2.5 Mabsadd L
.09365 .22861 2.5 -2.5 Mabsadd L
.09365 .22861 -2.5 -2.5 Mabsadd L
.09365 .22861 -2.5 2.5 Mabsadd L closepath F
.09683 .22885 -2.5 2.5 Mabsadd m
.09683 .22885 2.5 2.5 Mabsadd L
.09683 .22885 2.5 -2.5 Mabsadd L
.09683 .22885 -2.5 -2.5 Mabsadd L
.09683 .22885 -2.5 2.5 Mabsadd L closepath F
.1 .2291 -2.5 2.5 Mabsadd m
.1 .2291 2.5 2.5 Mabsadd L
.1 .2291 2.5 -2.5 Mabsadd L
.1 .2291 -2.5 -2.5 Mabsadd L
.1 .2291 -2.5 2.5 Mabsadd L closepath F
.10317 .22934 -2.5 2.5 Mabsadd m
.10317 .22934 2.5 2.5 Mabsadd L
.10317 .22934 2.5 -2.5 Mabsadd L
.10317 .22934 -2.5 -2.5 Mabsadd L
.10317 .22934 -2.5 2.5 Mabsadd L closepath F
.10635 .22959 -2.5 2.5 Mabsadd m
.10635 .22959 2.5 2.5 Mabsadd L
.10635 .22959 2.5 -2.5 Mabsadd L
.10635 .22959 -2.5 -2.5 Mabsadd L
.10635 .22959 -2.5 2.5 Mabsadd L closepath F
.10952 .22983 -2.5 2.5 Mabsadd m
.10952 .22983 2.5 2.5 Mabsadd L
.10952 .22983 2.5 -2.5 Mabsadd L
.10952 .22983 -2.5 -2.5 Mabsadd L
.10952 .22983 -2.5 2.5 Mabsadd L closepath F
.1127 .23009 -2.5 2.5 Mabsadd m
.1127 .23009 2.5 2.5 Mabsadd L
.1127 .23009 2.5 -2.5 Mabsadd L
.1127 .23009 -2.5 -2.5 Mabsadd L
.1127 .23009 -2.5 2.5 Mabsadd L closepath F
.11587 .23034 -2.5 2.5 Mabsadd m
.11587 .23034 2.5 2.5 Mabsadd L
.11587 .23034 2.5 -2.5 Mabsadd L
.11587 .23034 -2.5 -2.5 Mabsadd L
.11587 .23034 -2.5 2.5 Mabsadd L closepath F
.11905 .2306 -2.5 2.5 Mabsadd m
.11905 .2306 2.5 2.5 Mabsadd L
.11905 .2306 2.5 -2.5 Mabsadd L
.11905 .2306 -2.5 -2.5 Mabsadd L
.11905 .2306 -2.5 2.5 Mabsadd L closepath F
.12222 .23085 -2.5 2.5 Mabsadd m
.12222 .23085 2.5 2.5 Mabsadd L
.12222 .23085 2.5 -2.5 Mabsadd L
.12222 .23085 -2.5 -2.5 Mabsadd L
.12222 .23085 -2.5 2.5 Mabsadd L closepath F
.1254 .23112 -2.5 2.5 Mabsadd m
.1254 .23112 2.5 2.5 Mabsadd L
.1254 .23112 2.5 -2.5 Mabsadd L
.1254 .23112 -2.5 -2.5 Mabsadd L
.1254 .23112 -2.5 2.5 Mabsadd L closepath F
.12857 .23138 -2.5 2.5 Mabsadd m
.12857 .23138 2.5 2.5 Mabsadd L
.12857 .23138 2.5 -2.5 Mabsadd L
.12857 .23138 -2.5 -2.5 Mabsadd L
.12857 .23138 -2.5 2.5 Mabsadd L closepath F
.13175 .23165 -2.5 2.5 Mabsadd m
.13175 .23165 2.5 2.5 Mabsadd L
.13175 .23165 2.5 -2.5 Mabsadd L
.13175 .23165 -2.5 -2.5 Mabsadd L
.13175 .23165 -2.5 2.5 Mabsadd L closepath F
.13492 .23192 -2.5 2.5 Mabsadd m
.13492 .23192 2.5 2.5 Mabsadd L
.13492 .23192 2.5 -2.5 Mabsadd L
.13492 .23192 -2.5 -2.5 Mabsadd L
.13492 .23192 -2.5 2.5 Mabsadd L closepath F
.1381 .23219 -2.5 2.5 Mabsadd m
.1381 .23219 2.5 2.5 Mabsadd L
.1381 .23219 2.5 -2.5 Mabsadd L
.1381 .23219 -2.5 -2.5 Mabsadd L
.1381 .23219 -2.5 2.5 Mabsadd L closepath F
.14127 .23246 -2.5 2.5 Mabsadd m
.14127 .23246 2.5 2.5 Mabsadd L
.14127 .23246 2.5 -2.5 Mabsadd L
.14127 .23246 -2.5 -2.5 Mabsadd L
.14127 .23246 -2.5 2.5 Mabsadd L closepath F
.14444 .23274 -2.5 2.5 Mabsadd m
.14444 .23274 2.5 2.5 Mabsadd L
.14444 .23274 2.5 -2.5 Mabsadd L
.14444 .23274 -2.5 -2.5 Mabsadd L
.14444 .23274 -2.5 2.5 Mabsadd L closepath F
.14762 .23302 -2.5 2.5 Mabsadd m
.14762 .23302 2.5 2.5 Mabsadd L
.14762 .23302 2.5 -2.5 Mabsadd L
.14762 .23302 -2.5 -2.5 Mabsadd L
.14762 .23302 -2.5 2.5 Mabsadd L closepath F
.15079 .2333 -2.5 2.5 Mabsadd m
.15079 .2333 2.5 2.5 Mabsadd L
.15079 .2333 2.5 -2.5 Mabsadd L
.15079 .2333 -2.5 -2.5 Mabsadd L
.15079 .2333 -2.5 2.5 Mabsadd L closepath F
.15397 .23359 -2.5 2.5 Mabsadd m
.15397 .23359 2.5 2.5 Mabsadd L
.15397 .23359 2.5 -2.5 Mabsadd L
.15397 .23359 -2.5 -2.5 Mabsadd L
.15397 .23359 -2.5 2.5 Mabsadd L closepath F
.15714 .23388 -2.5 2.5 Mabsadd m
.15714 .23388 2.5 2.5 Mabsadd L
.15714 .23388 2.5 -2.5 Mabsadd L
.15714 .23388 -2.5 -2.5 Mabsadd L
.15714 .23388 -2.5 2.5 Mabsadd L closepath F
.16032 .23417 -2.5 2.5 Mabsadd m
.16032 .23417 2.5 2.5 Mabsadd L
.16032 .23417 2.5 -2.5 Mabsadd L
.16032 .23417 -2.5 -2.5 Mabsadd L
.16032 .23417 -2.5 2.5 Mabsadd L closepath F
.16349 .23446 -2.5 2.5 Mabsadd m
.16349 .23446 2.5 2.5 Mabsadd L
.16349 .23446 2.5 -2.5 Mabsadd L
.16349 .23446 -2.5 -2.5 Mabsadd L
.16349 .23446 -2.5 2.5 Mabsadd L closepath F
.16667 .23476 -2.5 2.5 Mabsadd m
.16667 .23476 2.5 2.5 Mabsadd L
.16667 .23476 2.5 -2.5 Mabsadd L
.16667 .23476 -2.5 -2.5 Mabsadd L
.16667 .23476 -2.5 2.5 Mabsadd L closepath F
.16984 .23506 -2.5 2.5 Mabsadd m
.16984 .23506 2.5 2.5 Mabsadd L
.16984 .23506 2.5 -2.5 Mabsadd L
.16984 .23506 -2.5 -2.5 Mabsadd L
.16984 .23506 -2.5 2.5 Mabsadd L closepath F
.17302 .23537 -2.5 2.5 Mabsadd m
.17302 .23537 2.5 2.5 Mabsadd L
.17302 .23537 2.5 -2.5 Mabsadd L
.17302 .23537 -2.5 -2.5 Mabsadd L
.17302 .23537 -2.5 2.5 Mabsadd L closepath F
.17619 .23567 -2.5 2.5 Mabsadd m
.17619 .23567 2.5 2.5 Mabsadd L
.17619 .23567 2.5 -2.5 Mabsadd L
.17619 .23567 -2.5 -2.5 Mabsadd L
.17619 .23567 -2.5 2.5 Mabsadd L closepath F
.17937 .23598 -2.5 2.5 Mabsadd m
.17937 .23598 2.5 2.5 Mabsadd L
.17937 .23598 2.5 -2.5 Mabsadd L
.17937 .23598 -2.5 -2.5 Mabsadd L
.17937 .23598 -2.5 2.5 Mabsadd L closepath F
.18254 .23629 -2.5 2.5 Mabsadd m
.18254 .23629 2.5 2.5 Mabsadd L
.18254 .23629 2.5 -2.5 Mabsadd L
.18254 .23629 -2.5 -2.5 Mabsadd L
.18254 .23629 -2.5 2.5 Mabsadd L closepath F
.18571 .23661 -2.5 2.5 Mabsadd m
.18571 .23661 2.5 2.5 Mabsadd L
.18571 .23661 2.5 -2.5 Mabsadd L
.18571 .23661 -2.5 -2.5 Mabsadd L
.18571 .23661 -2.5 2.5 Mabsadd L closepath F
.18889 .23693 -2.5 2.5 Mabsadd m
.18889 .23693 2.5 2.5 Mabsadd L
.18889 .23693 2.5 -2.5 Mabsadd L
.18889 .23693 -2.5 -2.5 Mabsadd L
.18889 .23693 -2.5 2.5 Mabsadd L closepath F
.19206 .23725 -2.5 2.5 Mabsadd m
.19206 .23725 2.5 2.5 Mabsadd L
.19206 .23725 2.5 -2.5 Mabsadd L
.19206 .23725 -2.5 -2.5 Mabsadd L
.19206 .23725 -2.5 2.5 Mabsadd L closepath F
.19524 .23758 -2.5 2.5 Mabsadd m
.19524 .23758 2.5 2.5 Mabsadd L
.19524 .23758 2.5 -2.5 Mabsadd L
.19524 .23758 -2.5 -2.5 Mabsadd L
.19524 .23758 -2.5 2.5 Mabsadd L closepath F
.19841 .23791 -2.5 2.5 Mabsadd m
.19841 .23791 2.5 2.5 Mabsadd L
.19841 .23791 2.5 -2.5 Mabsadd L
.19841 .23791 -2.5 -2.5 Mabsadd L
.19841 .23791 -2.5 2.5 Mabsadd L closepath F
.20159 .23824 -2.5 2.5 Mabsadd m
.20159 .23824 2.5 2.5 Mabsadd L
.20159 .23824 2.5 -2.5 Mabsadd L
.20159 .23824 -2.5 -2.5 Mabsadd L
.20159 .23824 -2.5 2.5 Mabsadd L closepath F
.20476 .23857 -2.5 2.5 Mabsadd m
.20476 .23857 2.5 2.5 Mabsadd L
.20476 .23857 2.5 -2.5 Mabsadd L
.20476 .23857 -2.5 -2.5 Mabsadd L
.20476 .23857 -2.5 2.5 Mabsadd L closepath F
.20794 .23891 -2.5 2.5 Mabsadd m
.20794 .23891 2.5 2.5 Mabsadd L
.20794 .23891 2.5 -2.5 Mabsadd L
.20794 .23891 -2.5 -2.5 Mabsadd L
.20794 .23891 -2.5 2.5 Mabsadd L closepath F
.21111 .23925 -2.5 2.5 Mabsadd m
.21111 .23925 2.5 2.5 Mabsadd L
.21111 .23925 2.5 -2.5 Mabsadd L
.21111 .23925 -2.5 -2.5 Mabsadd L
.21111 .23925 -2.5 2.5 Mabsadd L closepath F
.21429 .2396 -2.5 2.5 Mabsadd m
.21429 .2396 2.5 2.5 Mabsadd L
.21429 .2396 2.5 -2.5 Mabsadd L
.21429 .2396 -2.5 -2.5 Mabsadd L
.21429 .2396 -2.5 2.5 Mabsadd L closepath F
.21746 .23995 -2.5 2.5 Mabsadd m
.21746 .23995 2.5 2.5 Mabsadd L
.21746 .23995 2.5 -2.5 Mabsadd L
.21746 .23995 -2.5 -2.5 Mabsadd L
.21746 .23995 -2.5 2.5 Mabsadd L closepath F
.22063 .2403 -2.5 2.5 Mabsadd m
.22063 .2403 2.5 2.5 Mabsadd L
.22063 .2403 2.5 -2.5 Mabsadd L
.22063 .2403 -2.5 -2.5 Mabsadd L
.22063 .2403 -2.5 2.5 Mabsadd L closepath F
.22381 .24066 -2.5 2.5 Mabsadd m
.22381 .24066 2.5 2.5 Mabsadd L
.22381 .24066 2.5 -2.5 Mabsadd L
.22381 .24066 -2.5 -2.5 Mabsadd L
.22381 .24066 -2.5 2.5 Mabsadd L closepath F
.22698 .24101 -2.5 2.5 Mabsadd m
.22698 .24101 2.5 2.5 Mabsadd L
.22698 .24101 2.5 -2.5 Mabsadd L
.22698 .24101 -2.5 -2.5 Mabsadd L
.22698 .24101 -2.5 2.5 Mabsadd L closepath F
.23016 .24138 -2.5 2.5 Mabsadd m
.23016 .24138 2.5 2.5 Mabsadd L
.23016 .24138 2.5 -2.5 Mabsadd L
.23016 .24138 -2.5 -2.5 Mabsadd L
.23016 .24138 -2.5 2.5 Mabsadd L closepath F
.23333 .24174 -2.5 2.5 Mabsadd m
.23333 .24174 2.5 2.5 Mabsadd L
.23333 .24174 2.5 -2.5 Mabsadd L
.23333 .24174 -2.5 -2.5 Mabsadd L
.23333 .24174 -2.5 2.5 Mabsadd L closepath F
.23651 .24211 -2.5 2.5 Mabsadd m
.23651 .24211 2.5 2.5 Mabsadd L
.23651 .24211 2.5 -2.5 Mabsadd L
.23651 .24211 -2.5 -2.5 Mabsadd L
.23651 .24211 -2.5 2.5 Mabsadd L closepath F
.23968 .24249 -2.5 2.5 Mabsadd m
.23968 .24249 2.5 2.5 Mabsadd L
.23968 .24249 2.5 -2.5 Mabsadd L
.23968 .24249 -2.5 -2.5 Mabsadd L
.23968 .24249 -2.5 2.5 Mabsadd L closepath F
.24286 .24287 -2.5 2.5 Mabsadd m
.24286 .24287 2.5 2.5 Mabsadd L
.24286 .24287 2.5 -2.5 Mabsadd L
.24286 .24287 -2.5 -2.5 Mabsadd L
.24286 .24287 -2.5 2.5 Mabsadd L closepath F
.24603 .24325 -2.5 2.5 Mabsadd m
.24603 .24325 2.5 2.5 Mabsadd L
.24603 .24325 2.5 -2.5 Mabsadd L
.24603 .24325 -2.5 -2.5 Mabsadd L
.24603 .24325 -2.5 2.5 Mabsadd L closepath F
.24921 .24363 -2.5 2.5 Mabsadd m
.24921 .24363 2.5 2.5 Mabsadd L
.24921 .24363 2.5 -2.5 Mabsadd L
.24921 .24363 -2.5 -2.5 Mabsadd L
.24921 .24363 -2.5 2.5 Mabsadd L closepath F
.25238 .24402 -2.5 2.5 Mabsadd m
.25238 .24402 2.5 2.5 Mabsadd L
.25238 .24402 2.5 -2.5 Mabsadd L
.25238 .24402 -2.5 -2.5 Mabsadd L
.25238 .24402 -2.5 2.5 Mabsadd L closepath F
.25556 .24442 -2.5 2.5 Mabsadd m
.25556 .24442 2.5 2.5 Mabsadd L
.25556 .24442 2.5 -2.5 Mabsadd L
.25556 .24442 -2.5 -2.5 Mabsadd L
.25556 .24442 -2.5 2.5 Mabsadd L closepath F
.25873 .24481 -2.5 2.5 Mabsadd m
.25873 .24481 2.5 2.5 Mabsadd L
.25873 .24481 2.5 -2.5 Mabsadd L
.25873 .24481 -2.5 -2.5 Mabsadd L
.25873 .24481 -2.5 2.5 Mabsadd L closepath F
.2619 .24521 -2.5 2.5 Mabsadd m
.2619 .24521 2.5 2.5 Mabsadd L
.2619 .24521 2.5 -2.5 Mabsadd L
.2619 .24521 -2.5 -2.5 Mabsadd L
.2619 .24521 -2.5 2.5 Mabsadd L closepath F
.26508 .24562 -2.5 2.5 Mabsadd m
.26508 .24562 2.5 2.5 Mabsadd L
.26508 .24562 2.5 -2.5 Mabsadd L
.26508 .24562 -2.5 -2.5 Mabsadd L
.26508 .24562 -2.5 2.5 Mabsadd L closepath F
.26825 .24603 -2.5 2.5 Mabsadd m
.26825 .24603 2.5 2.5 Mabsadd L
.26825 .24603 2.5 -2.5 Mabsadd L
.26825 .24603 -2.5 -2.5 Mabsadd L
.26825 .24603 -2.5 2.5 Mabsadd L closepath F
.27143 .24644 -2.5 2.5 Mabsadd m
.27143 .24644 2.5 2.5 Mabsadd L
.27143 .24644 2.5 -2.5 Mabsadd L
.27143 .24644 -2.5 -2.5 Mabsadd L
.27143 .24644 -2.5 2.5 Mabsadd L closepath F
.2746 .24686 -2.5 2.5 Mabsadd m
.2746 .24686 2.5 2.5 Mabsadd L
.2746 .24686 2.5 -2.5 Mabsadd L
.2746 .24686 -2.5 -2.5 Mabsadd L
.2746 .24686 -2.5 2.5 Mabsadd L closepath F
.27778 .24728 -2.5 2.5 Mabsadd m
.27778 .24728 2.5 2.5 Mabsadd L
.27778 .24728 2.5 -2.5 Mabsadd L
.27778 .24728 -2.5 -2.5 Mabsadd L
.27778 .24728 -2.5 2.5 Mabsadd L closepath F
.28095 .24771 -2.5 2.5 Mabsadd m
.28095 .24771 2.5 2.5 Mabsadd L
.28095 .24771 2.5 -2.5 Mabsadd L
.28095 .24771 -2.5 -2.5 Mabsadd L
.28095 .24771 -2.5 2.5 Mabsadd L closepath F
.28413 .24814 -2.5 2.5 Mabsadd m
.28413 .24814 2.5 2.5 Mabsadd L
.28413 .24814 2.5 -2.5 Mabsadd L
.28413 .24814 -2.5 -2.5 Mabsadd L
.28413 .24814 -2.5 2.5 Mabsadd L closepath F
.2873 .24857 -2.5 2.5 Mabsadd m
.2873 .24857 2.5 2.5 Mabsadd L
.2873 .24857 2.5 -2.5 Mabsadd L
.2873 .24857 -2.5 -2.5 Mabsadd L
.2873 .24857 -2.5 2.5 Mabsadd L closepath F
.29048 .24901 -2.5 2.5 Mabsadd m
.29048 .24901 2.5 2.5 Mabsadd L
.29048 .24901 2.5 -2.5 Mabsadd L
.29048 .24901 -2.5 -2.5 Mabsadd L
.29048 .24901 -2.5 2.5 Mabsadd L closepath F
.29365 .24945 -2.5 2.5 Mabsadd m
.29365 .24945 2.5 2.5 Mabsadd L
.29365 .24945 2.5 -2.5 Mabsadd L
.29365 .24945 -2.5 -2.5 Mabsadd L
.29365 .24945 -2.5 2.5 Mabsadd L closepath F
.29683 .2499 -2.5 2.5 Mabsadd m
.29683 .2499 2.5 2.5 Mabsadd L
.29683 .2499 2.5 -2.5 Mabsadd L
.29683 .2499 -2.5 -2.5 Mabsadd L
.29683 .2499 -2.5 2.5 Mabsadd L closepath F
.3 .25035 -2.5 2.5 Mabsadd m
.3 .25035 2.5 2.5 Mabsadd L
.3 .25035 2.5 -2.5 Mabsadd L
.3 .25035 -2.5 -2.5 Mabsadd L
.3 .25035 -2.5 2.5 Mabsadd L closepath F
.30317 .25081 -2.5 2.5 Mabsadd m
.30317 .25081 2.5 2.5 Mabsadd L
.30317 .25081 2.5 -2.5 Mabsadd L
.30317 .25081 -2.5 -2.5 Mabsadd L
.30317 .25081 -2.5 2.5 Mabsadd L closepath F
.30635 .25127 -2.5 2.5 Mabsadd m
.30635 .25127 2.5 2.5 Mabsadd L
.30635 .25127 2.5 -2.5 Mabsadd L
.30635 .25127 -2.5 -2.5 Mabsadd L
.30635 .25127 -2.5 2.5 Mabsadd L closepath F
.30952 .25173 -2.5 2.5 Mabsadd m
.30952 .25173 2.5 2.5 Mabsadd L
.30952 .25173 2.5 -2.5 Mabsadd L
.30952 .25173 -2.5 -2.5 Mabsadd L
.30952 .25173 -2.5 2.5 Mabsadd L closepath F
.3127 .2522 -2.5 2.5 Mabsadd m
.3127 .2522 2.5 2.5 Mabsadd L
.3127 .2522 2.5 -2.5 Mabsadd L
.3127 .2522 -2.5 -2.5 Mabsadd L
.3127 .2522 -2.5 2.5 Mabsadd L closepath F
.31587 .25268 -2.5 2.5 Mabsadd m
.31587 .25268 2.5 2.5 Mabsadd L
.31587 .25268 2.5 -2.5 Mabsadd L
.31587 .25268 -2.5 -2.5 Mabsadd L
.31587 .25268 -2.5 2.5 Mabsadd L closepath F
.31905 .25316 -2.5 2.5 Mabsadd m
.31905 .25316 2.5 2.5 Mabsadd L
.31905 .25316 2.5 -2.5 Mabsadd L
.31905 .25316 -2.5 -2.5 Mabsadd L
.31905 .25316 -2.5 2.5 Mabsadd L closepath F
.32222 .25364 -2.5 2.5 Mabsadd m
.32222 .25364 2.5 2.5 Mabsadd L
.32222 .25364 2.5 -2.5 Mabsadd L
.32222 .25364 -2.5 -2.5 Mabsadd L
.32222 .25364 -2.5 2.5 Mabsadd L closepath F
.3254 .25413 -2.5 2.5 Mabsadd m
.3254 .25413 2.5 2.5 Mabsadd L
.3254 .25413 2.5 -2.5 Mabsadd L
.3254 .25413 -2.5 -2.5 Mabsadd L
.3254 .25413 -2.5 2.5 Mabsadd L closepath F
.32857 .25463 -2.5 2.5 Mabsadd m
.32857 .25463 2.5 2.5 Mabsadd L
.32857 .25463 2.5 -2.5 Mabsadd L
.32857 .25463 -2.5 -2.5 Mabsadd L
.32857 .25463 -2.5 2.5 Mabsadd L closepath F
.33175 .25513 -2.5 2.5 Mabsadd m
.33175 .25513 2.5 2.5 Mabsadd L
.33175 .25513 2.5 -2.5 Mabsadd L
.33175 .25513 -2.5 -2.5 Mabsadd L
.33175 .25513 -2.5 2.5 Mabsadd L closepath F
.33492 .25563 -2.5 2.5 Mabsadd m
.33492 .25563 2.5 2.5 Mabsadd L
.33492 .25563 2.5 -2.5 Mabsadd L
.33492 .25563 -2.5 -2.5 Mabsadd L
.33492 .25563 -2.5 2.5 Mabsadd L closepath F
.3381 .25614 -2.5 2.5 Mabsadd m
.3381 .25614 2.5 2.5 Mabsadd L
.3381 .25614 2.5 -2.5 Mabsadd L
.3381 .25614 -2.5 -2.5 Mabsadd L
.3381 .25614 -2.5 2.5 Mabsadd L closepath F
.34127 .25665 -2.5 2.5 Mabsadd m
.34127 .25665 2.5 2.5 Mabsadd L
.34127 .25665 2.5 -2.5 Mabsadd L
.34127 .25665 -2.5 -2.5 Mabsadd L
.34127 .25665 -2.5 2.5 Mabsadd L closepath F
.34444 .25717 -2.5 2.5 Mabsadd m
.34444 .25717 2.5 2.5 Mabsadd L
.34444 .25717 2.5 -2.5 Mabsadd L
.34444 .25717 -2.5 -2.5 Mabsadd L
.34444 .25717 -2.5 2.5 Mabsadd L closepath F
.34762 .2577 -2.5 2.5 Mabsadd m
.34762 .2577 2.5 2.5 Mabsadd L
.34762 .2577 2.5 -2.5 Mabsadd L
.34762 .2577 -2.5 -2.5 Mabsadd L
.34762 .2577 -2.5 2.5 Mabsadd L closepath F
.35079 .25823 -2.5 2.5 Mabsadd m
.35079 .25823 2.5 2.5 Mabsadd L
.35079 .25823 2.5 -2.5 Mabsadd L
.35079 .25823 -2.5 -2.5 Mabsadd L
.35079 .25823 -2.5 2.5 Mabsadd L closepath F
.35397 .25876 -2.5 2.5 Mabsadd m
.35397 .25876 2.5 2.5 Mabsadd L
.35397 .25876 2.5 -2.5 Mabsadd L
.35397 .25876 -2.5 -2.5 Mabsadd L
.35397 .25876 -2.5 2.5 Mabsadd L closepath F
.35714 .2593 -2.5 2.5 Mabsadd m
.35714 .2593 2.5 2.5 Mabsadd L
.35714 .2593 2.5 -2.5 Mabsadd L
.35714 .2593 -2.5 -2.5 Mabsadd L
.35714 .2593 -2.5 2.5 Mabsadd L closepath F
.36032 .25985 -2.5 2.5 Mabsadd m
.36032 .25985 2.5 2.5 Mabsadd L
.36032 .25985 2.5 -2.5 Mabsadd L
.36032 .25985 -2.5 -2.5 Mabsadd L
.36032 .25985 -2.5 2.5 Mabsadd L closepath F
.36349 .2604 -2.5 2.5 Mabsadd m
.36349 .2604 2.5 2.5 Mabsadd L
.36349 .2604 2.5 -2.5 Mabsadd L
.36349 .2604 -2.5 -2.5 Mabsadd L
.36349 .2604 -2.5 2.5 Mabsadd L closepath F
.36667 .26096 -2.5 2.5 Mabsadd m
.36667 .26096 2.5 2.5 Mabsadd L
.36667 .26096 2.5 -2.5 Mabsadd L
.36667 .26096 -2.5 -2.5 Mabsadd L
.36667 .26096 -2.5 2.5 Mabsadd L closepath F
.36984 .26152 -2.5 2.5 Mabsadd m
.36984 .26152 2.5 2.5 Mabsadd L
.36984 .26152 2.5 -2.5 Mabsadd L
.36984 .26152 -2.5 -2.5 Mabsadd L
.36984 .26152 -2.5 2.5 Mabsadd L closepath F
.37302 .26209 -2.5 2.5 Mabsadd m
.37302 .26209 2.5 2.5 Mabsadd L
.37302 .26209 2.5 -2.5 Mabsadd L
.37302 .26209 -2.5 -2.5 Mabsadd L
.37302 .26209 -2.5 2.5 Mabsadd L closepath F
.37619 .26266 -2.5 2.5 Mabsadd m
.37619 .26266 2.5 2.5 Mabsadd L
.37619 .26266 2.5 -2.5 Mabsadd L
.37619 .26266 -2.5 -2.5 Mabsadd L
.37619 .26266 -2.5 2.5 Mabsadd L closepath F
.37937 .26324 -2.5 2.5 Mabsadd m
.37937 .26324 2.5 2.5 Mabsadd L
.37937 .26324 2.5 -2.5 Mabsadd L
.37937 .26324 -2.5 -2.5 Mabsadd L
.37937 .26324 -2.5 2.5 Mabsadd L closepath F
.38254 .26383 -2.5 2.5 Mabsadd m
.38254 .26383 2.5 2.5 Mabsadd L
.38254 .26383 2.5 -2.5 Mabsadd L
.38254 .26383 -2.5 -2.5 Mabsadd L
.38254 .26383 -2.5 2.5 Mabsadd L closepath F
.38571 .26442 -2.5 2.5 Mabsadd m
.38571 .26442 2.5 2.5 Mabsadd L
.38571 .26442 2.5 -2.5 Mabsadd L
.38571 .26442 -2.5 -2.5 Mabsadd L
.38571 .26442 -2.5 2.5 Mabsadd L closepath F
.38889 .26501 -2.5 2.5 Mabsadd m
.38889 .26501 2.5 2.5 Mabsadd L
.38889 .26501 2.5 -2.5 Mabsadd L
.38889 .26501 -2.5 -2.5 Mabsadd L
.38889 .26501 -2.5 2.5 Mabsadd L closepath F
.39206 .26562 -2.5 2.5 Mabsadd m
.39206 .26562 2.5 2.5 Mabsadd L
.39206 .26562 2.5 -2.5 Mabsadd L
.39206 .26562 -2.5 -2.5 Mabsadd L
.39206 .26562 -2.5 2.5 Mabsadd L closepath F
.39524 .26623 -2.5 2.5 Mabsadd m
.39524 .26623 2.5 2.5 Mabsadd L
.39524 .26623 2.5 -2.5 Mabsadd L
.39524 .26623 -2.5 -2.5 Mabsadd L
.39524 .26623 -2.5 2.5 Mabsadd L closepath F
.39841 .26684 -2.5 2.5 Mabsadd m
.39841 .26684 2.5 2.5 Mabsadd L
.39841 .26684 2.5 -2.5 Mabsadd L
.39841 .26684 -2.5 -2.5 Mabsadd L
.39841 .26684 -2.5 2.5 Mabsadd L closepath F
.40159 .26746 -2.5 2.5 Mabsadd m
.40159 .26746 2.5 2.5 Mabsadd L
.40159 .26746 2.5 -2.5 Mabsadd L
.40159 .26746 -2.5 -2.5 Mabsadd L
.40159 .26746 -2.5 2.5 Mabsadd L closepath F
.40476 .26809 -2.5 2.5 Mabsadd m
.40476 .26809 2.5 2.5 Mabsadd L
.40476 .26809 2.5 -2.5 Mabsadd L
.40476 .26809 -2.5 -2.5 Mabsadd L
.40476 .26809 -2.5 2.5 Mabsadd L closepath F
.40794 .26872 -2.5 2.5 Mabsadd m
.40794 .26872 2.5 2.5 Mabsadd L
.40794 .26872 2.5 -2.5 Mabsadd L
.40794 .26872 -2.5 -2.5 Mabsadd L
.40794 .26872 -2.5 2.5 Mabsadd L closepath F
.41111 .26936 -2.5 2.5 Mabsadd m
.41111 .26936 2.5 2.5 Mabsadd L
.41111 .26936 2.5 -2.5 Mabsadd L
.41111 .26936 -2.5 -2.5 Mabsadd L
.41111 .26936 -2.5 2.5 Mabsadd L closepath F
.41429 .27001 -2.5 2.5 Mabsadd m
.41429 .27001 2.5 2.5 Mabsadd L
.41429 .27001 2.5 -2.5 Mabsadd L
.41429 .27001 -2.5 -2.5 Mabsadd L
.41429 .27001 -2.5 2.5 Mabsadd L closepath F
.41746 .27066 -2.5 2.5 Mabsadd m
.41746 .27066 2.5 2.5 Mabsadd L
.41746 .27066 2.5 -2.5 Mabsadd L
.41746 .27066 -2.5 -2.5 Mabsadd L
.41746 .27066 -2.5 2.5 Mabsadd L closepath F
.42063 .27132 -2.5 2.5 Mabsadd m
.42063 .27132 2.5 2.5 Mabsadd L
.42063 .27132 2.5 -2.5 Mabsadd L
.42063 .27132 -2.5 -2.5 Mabsadd L
.42063 .27132 -2.5 2.5 Mabsadd L closepath F
.42381 .27199 -2.5 2.5 Mabsadd m
.42381 .27199 2.5 2.5 Mabsadd L
.42381 .27199 2.5 -2.5 Mabsadd L
.42381 .27199 -2.5 -2.5 Mabsadd L
.42381 .27199 -2.5 2.5 Mabsadd L closepath F
.42698 .27266 -2.5 2.5 Mabsadd m
.42698 .27266 2.5 2.5 Mabsadd L
.42698 .27266 2.5 -2.5 Mabsadd L
.42698 .27266 -2.5 -2.5 Mabsadd L
.42698 .27266 -2.5 2.5 Mabsadd L closepath F
.43016 .27334 -2.5 2.5 Mabsadd m
.43016 .27334 2.5 2.5 Mabsadd L
.43016 .27334 2.5 -2.5 Mabsadd L
.43016 .27334 -2.5 -2.5 Mabsadd L
.43016 .27334 -2.5 2.5 Mabsadd L closepath F
.43333 .27403 -2.5 2.5 Mabsadd m
.43333 .27403 2.5 2.5 Mabsadd L
.43333 .27403 2.5 -2.5 Mabsadd L
.43333 .27403 -2.5 -2.5 Mabsadd L
.43333 .27403 -2.5 2.5 Mabsadd L closepath F
.43651 .27472 -2.5 2.5 Mabsadd m
.43651 .27472 2.5 2.5 Mabsadd L
.43651 .27472 2.5 -2.5 Mabsadd L
.43651 .27472 -2.5 -2.5 Mabsadd L
.43651 .27472 -2.5 2.5 Mabsadd L closepath F
.43968 .27542 -2.5 2.5 Mabsadd m
.43968 .27542 2.5 2.5 Mabsadd L
.43968 .27542 2.5 -2.5 Mabsadd L
.43968 .27542 -2.5 -2.5 Mabsadd L
.43968 .27542 -2.5 2.5 Mabsadd L closepath F
.44286 .27613 -2.5 2.5 Mabsadd m
.44286 .27613 2.5 2.5 Mabsadd L
.44286 .27613 2.5 -2.5 Mabsadd L
.44286 .27613 -2.5 -2.5 Mabsadd L
.44286 .27613 -2.5 2.5 Mabsadd L closepath F
.44603 .27684 -2.5 2.5 Mabsadd m
.44603 .27684 2.5 2.5 Mabsadd L
.44603 .27684 2.5 -2.5 Mabsadd L
.44603 .27684 -2.5 -2.5 Mabsadd L
.44603 .27684 -2.5 2.5 Mabsadd L closepath F
.44921 .27756 -2.5 2.5 Mabsadd m
.44921 .27756 2.5 2.5 Mabsadd L
.44921 .27756 2.5 -2.5 Mabsadd L
.44921 .27756 -2.5 -2.5 Mabsadd L
.44921 .27756 -2.5 2.5 Mabsadd L closepath F
.45238 .27829 -2.5 2.5 Mabsadd m
.45238 .27829 2.5 2.5 Mabsadd L
.45238 .27829 2.5 -2.5 Mabsadd L
.45238 .27829 -2.5 -2.5 Mabsadd L
.45238 .27829 -2.5 2.5 Mabsadd L closepath F
.45556 .27903 -2.5 2.5 Mabsadd m
.45556 .27903 2.5 2.5 Mabsadd L
.45556 .27903 2.5 -2.5 Mabsadd L
.45556 .27903 -2.5 -2.5 Mabsadd L
.45556 .27903 -2.5 2.5 Mabsadd L closepath F
.45873 .27977 -2.5 2.5 Mabsadd m
.45873 .27977 2.5 2.5 Mabsadd L
.45873 .27977 2.5 -2.5 Mabsadd L
.45873 .27977 -2.5 -2.5 Mabsadd L
.45873 .27977 -2.5 2.5 Mabsadd L closepath F
.4619 .28052 -2.5 2.5 Mabsadd m
.4619 .28052 2.5 2.5 Mabsadd L
.4619 .28052 2.5 -2.5 Mabsadd L
.4619 .28052 -2.5 -2.5 Mabsadd L
.4619 .28052 -2.5 2.5 Mabsadd L closepath F
.46508 .28128 -2.5 2.5 Mabsadd m
.46508 .28128 2.5 2.5 Mabsadd L
.46508 .28128 2.5 -2.5 Mabsadd L
.46508 .28128 -2.5 -2.5 Mabsadd L
.46508 .28128 -2.5 2.5 Mabsadd L closepath F
.46825 .28204 -2.5 2.5 Mabsadd m
.46825 .28204 2.5 2.5 Mabsadd L
.46825 .28204 2.5 -2.5 Mabsadd L
.46825 .28204 -2.5 -2.5 Mabsadd L
.46825 .28204 -2.5 2.5 Mabsadd L closepath F
.47143 .28282 -2.5 2.5 Mabsadd m
.47143 .28282 2.5 2.5 Mabsadd L
.47143 .28282 2.5 -2.5 Mabsadd L
.47143 .28282 -2.5 -2.5 Mabsadd L
.47143 .28282 -2.5 2.5 Mabsadd L closepath F
.4746 .2836 -2.5 2.5 Mabsadd m
.4746 .2836 2.5 2.5 Mabsadd L
.4746 .2836 2.5 -2.5 Mabsadd L
.4746 .2836 -2.5 -2.5 Mabsadd L
.4746 .2836 -2.5 2.5 Mabsadd L closepath F
.47778 .28439 -2.5 2.5 Mabsadd m
.47778 .28439 2.5 2.5 Mabsadd L
.47778 .28439 2.5 -2.5 Mabsadd L
.47778 .28439 -2.5 -2.5 Mabsadd L
.47778 .28439 -2.5 2.5 Mabsadd L closepath F
.48095 .28518 -2.5 2.5 Mabsadd m
.48095 .28518 2.5 2.5 Mabsadd L
.48095 .28518 2.5 -2.5 Mabsadd L
.48095 .28518 -2.5 -2.5 Mabsadd L
.48095 .28518 -2.5 2.5 Mabsadd L closepath F
.48413 .28599 -2.5 2.5 Mabsadd m
.48413 .28599 2.5 2.5 Mabsadd L
.48413 .28599 2.5 -2.5 Mabsadd L
.48413 .28599 -2.5 -2.5 Mabsadd L
.48413 .28599 -2.5 2.5 Mabsadd L closepath F
.4873 .2868 -2.5 2.5 Mabsadd m
.4873 .2868 2.5 2.5 Mabsadd L
.4873 .2868 2.5 -2.5 Mabsadd L
.4873 .2868 -2.5 -2.5 Mabsadd L
.4873 .2868 -2.5 2.5 Mabsadd L closepath F
.49048 .28762 -2.5 2.5 Mabsadd m
.49048 .28762 2.5 2.5 Mabsadd L
.49048 .28762 2.5 -2.5 Mabsadd L
.49048 .28762 -2.5 -2.5 Mabsadd L
.49048 .28762 -2.5 2.5 Mabsadd L closepath F
.49365 .28845 -2.5 2.5 Mabsadd m
.49365 .28845 2.5 2.5 Mabsadd L
.49365 .28845 2.5 -2.5 Mabsadd L
.49365 .28845 -2.5 -2.5 Mabsadd L
.49365 .28845 -2.5 2.5 Mabsadd L closepath F
.49683 .28929 -2.5 2.5 Mabsadd m
.49683 .28929 2.5 2.5 Mabsadd L
.49683 .28929 2.5 -2.5 Mabsadd L
.49683 .28929 -2.5 -2.5 Mabsadd L
.49683 .28929 -2.5 2.5 Mabsadd L closepath F
.5 .29013 -2.5 2.5 Mabsadd m
.5 .29013 2.5 2.5 Mabsadd L
.5 .29013 2.5 -2.5 Mabsadd L
.5 .29013 -2.5 -2.5 Mabsadd L
.5 .29013 -2.5 2.5 Mabsadd L closepath F
.50317 .29099 -2.5 2.5 Mabsadd m
.50317 .29099 2.5 2.5 Mabsadd L
.50317 .29099 2.5 -2.5 Mabsadd L
.50317 .29099 -2.5 -2.5 Mabsadd L
.50317 .29099 -2.5 2.5 Mabsadd L closepath F
.50635 .29185 -2.5 2.5 Mabsadd m
.50635 .29185 2.5 2.5 Mabsadd L
.50635 .29185 2.5 -2.5 Mabsadd L
.50635 .29185 -2.5 -2.5 Mabsadd L
.50635 .29185 -2.5 2.5 Mabsadd L closepath F
.50952 .29272 -2.5 2.5 Mabsadd m
.50952 .29272 2.5 2.5 Mabsadd L
.50952 .29272 2.5 -2.5 Mabsadd L
.50952 .29272 -2.5 -2.5 Mabsadd L
.50952 .29272 -2.5 2.5 Mabsadd L closepath F
.5127 .2936 -2.5 2.5 Mabsadd m
.5127 .2936 2.5 2.5 Mabsadd L
.5127 .2936 2.5 -2.5 Mabsadd L
.5127 .2936 -2.5 -2.5 Mabsadd L
.5127 .2936 -2.5 2.5 Mabsadd L closepath F
.51587 .29449 -2.5 2.5 Mabsadd m
.51587 .29449 2.5 2.5 Mabsadd L
.51587 .29449 2.5 -2.5 Mabsadd L
.51587 .29449 -2.5 -2.5 Mabsadd L
.51587 .29449 -2.5 2.5 Mabsadd L closepath F
.51905 .29539 -2.5 2.5 Mabsadd m
.51905 .29539 2.5 2.5 Mabsadd L
.51905 .29539 2.5 -2.5 Mabsadd L
.51905 .29539 -2.5 -2.5 Mabsadd L
.51905 .29539 -2.5 2.5 Mabsadd L closepath F
.52222 .2963 -2.5 2.5 Mabsadd m
.52222 .2963 2.5 2.5 Mabsadd L
.52222 .2963 2.5 -2.5 Mabsadd L
.52222 .2963 -2.5 -2.5 Mabsadd L
.52222 .2963 -2.5 2.5 Mabsadd L closepath F
.5254 .29721 -2.5 2.5 Mabsadd m
.5254 .29721 2.5 2.5 Mabsadd L
.5254 .29721 2.5 -2.5 Mabsadd L
.5254 .29721 -2.5 -2.5 Mabsadd L
.5254 .29721 -2.5 2.5 Mabsadd L closepath F
.52857 .29814 -2.5 2.5 Mabsadd m
.52857 .29814 2.5 2.5 Mabsadd L
.52857 .29814 2.5 -2.5 Mabsadd L
.52857 .29814 -2.5 -2.5 Mabsadd L
.52857 .29814 -2.5 2.5 Mabsadd L closepath F
.53175 .29907 -2.5 2.5 Mabsadd m
.53175 .29907 2.5 2.5 Mabsadd L
.53175 .29907 2.5 -2.5 Mabsadd L
.53175 .29907 -2.5 -2.5 Mabsadd L
.53175 .29907 -2.5 2.5 Mabsadd L closepath F
.53492 .30002 -2.5 2.5 Mabsadd m
.53492 .30002 2.5 2.5 Mabsadd L
.53492 .30002 2.5 -2.5 Mabsadd L
.53492 .30002 -2.5 -2.5 Mabsadd L
.53492 .30002 -2.5 2.5 Mabsadd L closepath F
.5381 .30097 -2.5 2.5 Mabsadd m
.5381 .30097 2.5 2.5 Mabsadd L
.5381 .30097 2.5 -2.5 Mabsadd L
.5381 .30097 -2.5 -2.5 Mabsadd L
.5381 .30097 -2.5 2.5 Mabsadd L closepath F
.54127 .30193 -2.5 2.5 Mabsadd m
.54127 .30193 2.5 2.5 Mabsadd L
.54127 .30193 2.5 -2.5 Mabsadd L
.54127 .30193 -2.5 -2.5 Mabsadd L
.54127 .30193 -2.5 2.5 Mabsadd L closepath F
.54444 .3029 -2.5 2.5 Mabsadd m
.54444 .3029 2.5 2.5 Mabsadd L
.54444 .3029 2.5 -2.5 Mabsadd L
.54444 .3029 -2.5 -2.5 Mabsadd L
.54444 .3029 -2.5 2.5 Mabsadd L closepath F
.54762 .30389 -2.5 2.5 Mabsadd m
.54762 .30389 2.5 2.5 Mabsadd L
.54762 .30389 2.5 -2.5 Mabsadd L
.54762 .30389 -2.5 -2.5 Mabsadd L
.54762 .30389 -2.5 2.5 Mabsadd L closepath F
.55079 .30488 -2.5 2.5 Mabsadd m
.55079 .30488 2.5 2.5 Mabsadd L
.55079 .30488 2.5 -2.5 Mabsadd L
.55079 .30488 -2.5 -2.5 Mabsadd L
.55079 .30488 -2.5 2.5 Mabsadd L closepath F
.55397 .30588 -2.5 2.5 Mabsadd m
.55397 .30588 2.5 2.5 Mabsadd L
.55397 .30588 2.5 -2.5 Mabsadd L
.55397 .30588 -2.5 -2.5 Mabsadd L
.55397 .30588 -2.5 2.5 Mabsadd L closepath F
.55714 .30689 -2.5 2.5 Mabsadd m
.55714 .30689 2.5 2.5 Mabsadd L
.55714 .30689 2.5 -2.5 Mabsadd L
.55714 .30689 -2.5 -2.5 Mabsadd L
.55714 .30689 -2.5 2.5 Mabsadd L closepath F
.56032 .30791 -2.5 2.5 Mabsadd m
.56032 .30791 2.5 2.5 Mabsadd L
.56032 .30791 2.5 -2.5 Mabsadd L
.56032 .30791 -2.5 -2.5 Mabsadd L
.56032 .30791 -2.5 2.5 Mabsadd L closepath F
.56349 .30894 -2.5 2.5 Mabsadd m
.56349 .30894 2.5 2.5 Mabsadd L
.56349 .30894 2.5 -2.5 Mabsadd L
.56349 .30894 -2.5 -2.5 Mabsadd L
.56349 .30894 -2.5 2.5 Mabsadd L closepath F
.56667 .30999 -2.5 2.5 Mabsadd m
.56667 .30999 2.5 2.5 Mabsadd L
.56667 .30999 2.5 -2.5 Mabsadd L
.56667 .30999 -2.5 -2.5 Mabsadd L
.56667 .30999 -2.5 2.5 Mabsadd L closepath F
.56984 .31104 -2.5 2.5 Mabsadd m
.56984 .31104 2.5 2.5 Mabsadd L
.56984 .31104 2.5 -2.5 Mabsadd L
.56984 .31104 -2.5 -2.5 Mabsadd L
.56984 .31104 -2.5 2.5 Mabsadd L closepath F
.57302 .3121 -2.5 2.5 Mabsadd m
.57302 .3121 2.5 2.5 Mabsadd L
.57302 .3121 2.5 -2.5 Mabsadd L
.57302 .3121 -2.5 -2.5 Mabsadd L
.57302 .3121 -2.5 2.5 Mabsadd L closepath F
.57619 .31318 -2.5 2.5 Mabsadd m
.57619 .31318 2.5 2.5 Mabsadd L
.57619 .31318 2.5 -2.5 Mabsadd L
.57619 .31318 -2.5 -2.5 Mabsadd L
.57619 .31318 -2.5 2.5 Mabsadd L closepath F
.57937 .31426 -2.5 2.5 Mabsadd m
.57937 .31426 2.5 2.5 Mabsadd L
.57937 .31426 2.5 -2.5 Mabsadd L
.57937 .31426 -2.5 -2.5 Mabsadd L
.57937 .31426 -2.5 2.5 Mabsadd L closepath F
.58254 .31536 -2.5 2.5 Mabsadd m
.58254 .31536 2.5 2.5 Mabsadd L
.58254 .31536 2.5 -2.5 Mabsadd L
.58254 .31536 -2.5 -2.5 Mabsadd L
.58254 .31536 -2.5 2.5 Mabsadd L closepath F
.58571 .31646 -2.5 2.5 Mabsadd m
.58571 .31646 2.5 2.5 Mabsadd L
.58571 .31646 2.5 -2.5 Mabsadd L
.58571 .31646 -2.5 -2.5 Mabsadd L
.58571 .31646 -2.5 2.5 Mabsadd L closepath F
.58889 .31758 -2.5 2.5 Mabsadd m
.58889 .31758 2.5 2.5 Mabsadd L
.58889 .31758 2.5 -2.5 Mabsadd L
.58889 .31758 -2.5 -2.5 Mabsadd L
.58889 .31758 -2.5 2.5 Mabsadd L closepath F
.59206 .31871 -2.5 2.5 Mabsadd m
.59206 .31871 2.5 2.5 Mabsadd L
.59206 .31871 2.5 -2.5 Mabsadd L
.59206 .31871 -2.5 -2.5 Mabsadd L
.59206 .31871 -2.5 2.5 Mabsadd L closepath F
.59524 .31985 -2.5 2.5 Mabsadd m
.59524 .31985 2.5 2.5 Mabsadd L
.59524 .31985 2.5 -2.5 Mabsadd L
.59524 .31985 -2.5 -2.5 Mabsadd L
.59524 .31985 -2.5 2.5 Mabsadd L closepath F
.59841 .321 -2.5 2.5 Mabsadd m
.59841 .321 2.5 2.5 Mabsadd L
.59841 .321 2.5 -2.5 Mabsadd L
.59841 .321 -2.5 -2.5 Mabsadd L
.59841 .321 -2.5 2.5 Mabsadd L closepath F
.60159 .32216 -2.5 2.5 Mabsadd m
.60159 .32216 2.5 2.5 Mabsadd L
.60159 .32216 2.5 -2.5 Mabsadd L
.60159 .32216 -2.5 -2.5 Mabsadd L
.60159 .32216 -2.5 2.5 Mabsadd L closepath F
.60476 .32334 -2.5 2.5 Mabsadd m
.60476 .32334 2.5 2.5 Mabsadd L
.60476 .32334 2.5 -2.5 Mabsadd L
.60476 .32334 -2.5 -2.5 Mabsadd L
.60476 .32334 -2.5 2.5 Mabsadd L closepath F
.60794 .32452 -2.5 2.5 Mabsadd m
.60794 .32452 2.5 2.5 Mabsadd L
.60794 .32452 2.5 -2.5 Mabsadd L
.60794 .32452 -2.5 -2.5 Mabsadd L
.60794 .32452 -2.5 2.5 Mabsadd L closepath F
.61111 .32572 -2.5 2.5 Mabsadd m
.61111 .32572 2.5 2.5 Mabsadd L
.61111 .32572 2.5 -2.5 Mabsadd L
.61111 .32572 -2.5 -2.5 Mabsadd L
.61111 .32572 -2.5 2.5 Mabsadd L closepath F
.61429 .32693 -2.5 2.5 Mabsadd m
.61429 .32693 2.5 2.5 Mabsadd L
.61429 .32693 2.5 -2.5 Mabsadd L
.61429 .32693 -2.5 -2.5 Mabsadd L
.61429 .32693 -2.5 2.5 Mabsadd L closepath F
.61746 .32815 -2.5 2.5 Mabsadd m
.61746 .32815 2.5 2.5 Mabsadd L
.61746 .32815 2.5 -2.5 Mabsadd L
.61746 .32815 -2.5 -2.5 Mabsadd L
.61746 .32815 -2.5 2.5 Mabsadd L closepath F
.62063 .32939 -2.5 2.5 Mabsadd m
.62063 .32939 2.5 2.5 Mabsadd L
.62063 .32939 2.5 -2.5 Mabsadd L
.62063 .32939 -2.5 -2.5 Mabsadd L
.62063 .32939 -2.5 2.5 Mabsadd L closepath F
.62381 .33064 -2.5 2.5 Mabsadd m
.62381 .33064 2.5 2.5 Mabsadd L
.62381 .33064 2.5 -2.5 Mabsadd L
.62381 .33064 -2.5 -2.5 Mabsadd L
.62381 .33064 -2.5 2.5 Mabsadd L closepath F
.62698 .33189 -2.5 2.5 Mabsadd m
.62698 .33189 2.5 2.5 Mabsadd L
.62698 .33189 2.5 -2.5 Mabsadd L
.62698 .33189 -2.5 -2.5 Mabsadd L
.62698 .33189 -2.5 2.5 Mabsadd L closepath F
.63016 .33317 -2.5 2.5 Mabsadd m
.63016 .33317 2.5 2.5 Mabsadd L
.63016 .33317 2.5 -2.5 Mabsadd L
.63016 .33317 -2.5 -2.5 Mabsadd L
.63016 .33317 -2.5 2.5 Mabsadd L closepath F
.63333 .33445 -2.5 2.5 Mabsadd m
.63333 .33445 2.5 2.5 Mabsadd L
.63333 .33445 2.5 -2.5 Mabsadd L
.63333 .33445 -2.5 -2.5 Mabsadd L
.63333 .33445 -2.5 2.5 Mabsadd L closepath F
.63651 .33575 -2.5 2.5 Mabsadd m
.63651 .33575 2.5 2.5 Mabsadd L
.63651 .33575 2.5 -2.5 Mabsadd L
.63651 .33575 -2.5 -2.5 Mabsadd L
.63651 .33575 -2.5 2.5 Mabsadd L closepath F
.63968 .33706 -2.5 2.5 Mabsadd m
.63968 .33706 2.5 2.5 Mabsadd L
.63968 .33706 2.5 -2.5 Mabsadd L
.63968 .33706 -2.5 -2.5 Mabsadd L
.63968 .33706 -2.5 2.5 Mabsadd L closepath F
.64286 .33838 -2.5 2.5 Mabsadd m
.64286 .33838 2.5 2.5 Mabsadd L
.64286 .33838 2.5 -2.5 Mabsadd L
.64286 .33838 -2.5 -2.5 Mabsadd L
.64286 .33838 -2.5 2.5 Mabsadd L closepath F
.64603 .33972 -2.5 2.5 Mabsadd m
.64603 .33972 2.5 2.5 Mabsadd L
.64603 .33972 2.5 -2.5 Mabsadd L
.64603 .33972 -2.5 -2.5 Mabsadd L
.64603 .33972 -2.5 2.5 Mabsadd L closepath F
.64921 .34107 -2.5 2.5 Mabsadd m
.64921 .34107 2.5 2.5 Mabsadd L
.64921 .34107 2.5 -2.5 Mabsadd L
.64921 .34107 -2.5 -2.5 Mabsadd L
.64921 .34107 -2.5 2.5 Mabsadd L closepath F
.65238 .34243 -2.5 2.5 Mabsadd m
.65238 .34243 2.5 2.5 Mabsadd L
.65238 .34243 2.5 -2.5 Mabsadd L
.65238 .34243 -2.5 -2.5 Mabsadd L
.65238 .34243 -2.5 2.5 Mabsadd L closepath F
.65556 .34381 -2.5 2.5 Mabsadd m
.65556 .34381 2.5 2.5 Mabsadd L
.65556 .34381 2.5 -2.5 Mabsadd L
.65556 .34381 -2.5 -2.5 Mabsadd L
.65556 .34381 -2.5 2.5 Mabsadd L closepath F
.65873 .3452 -2.5 2.5 Mabsadd m
.65873 .3452 2.5 2.5 Mabsadd L
.65873 .3452 2.5 -2.5 Mabsadd L
.65873 .3452 -2.5 -2.5 Mabsadd L
.65873 .3452 -2.5 2.5 Mabsadd L closepath F
.6619 .34661 -2.5 2.5 Mabsadd m
.6619 .34661 2.5 2.5 Mabsadd L
.6619 .34661 2.5 -2.5 Mabsadd L
.6619 .34661 -2.5 -2.5 Mabsadd L
.6619 .34661 -2.5 2.5 Mabsadd L closepath F
.66508 .34802 -2.5 2.5 Mabsadd m
.66508 .34802 2.5 2.5 Mabsadd L
.66508 .34802 2.5 -2.5 Mabsadd L
.66508 .34802 -2.5 -2.5 Mabsadd L
.66508 .34802 -2.5 2.5 Mabsadd L closepath F
.66825 .34946 -2.5 2.5 Mabsadd m
.66825 .34946 2.5 2.5 Mabsadd L
.66825 .34946 2.5 -2.5 Mabsadd L
.66825 .34946 -2.5 -2.5 Mabsadd L
.66825 .34946 -2.5 2.5 Mabsadd L closepath F
.67143 .35091 -2.5 2.5 Mabsadd m
.67143 .35091 2.5 2.5 Mabsadd L
.67143 .35091 2.5 -2.5 Mabsadd L
.67143 .35091 -2.5 -2.5 Mabsadd L
.67143 .35091 -2.5 2.5 Mabsadd L closepath F
.6746 .35237 -2.5 2.5 Mabsadd m
.6746 .35237 2.5 2.5 Mabsadd L
.6746 .35237 2.5 -2.5 Mabsadd L
.6746 .35237 -2.5 -2.5 Mabsadd L
.6746 .35237 -2.5 2.5 Mabsadd L closepath F
.67778 .35384 -2.5 2.5 Mabsadd m
.67778 .35384 2.5 2.5 Mabsadd L
.67778 .35384 2.5 -2.5 Mabsadd L
.67778 .35384 -2.5 -2.5 Mabsadd L
.67778 .35384 -2.5 2.5 Mabsadd L closepath F
.68095 .35534 -2.5 2.5 Mabsadd m
.68095 .35534 2.5 2.5 Mabsadd L
.68095 .35534 2.5 -2.5 Mabsadd L
.68095 .35534 -2.5 -2.5 Mabsadd L
.68095 .35534 -2.5 2.5 Mabsadd L closepath F
.68413 .35684 -2.5 2.5 Mabsadd m
.68413 .35684 2.5 2.5 Mabsadd L
.68413 .35684 2.5 -2.5 Mabsadd L
.68413 .35684 -2.5 -2.5 Mabsadd L
.68413 .35684 -2.5 2.5 Mabsadd L closepath F
.6873 .35836 -2.5 2.5 Mabsadd m
.6873 .35836 2.5 2.5 Mabsadd L
.6873 .35836 2.5 -2.5 Mabsadd L
.6873 .35836 -2.5 -2.5 Mabsadd L
.6873 .35836 -2.5 2.5 Mabsadd L closepath F
.69048 .3599 -2.5 2.5 Mabsadd m
.69048 .3599 2.5 2.5 Mabsadd L
.69048 .3599 2.5 -2.5 Mabsadd L
.69048 .3599 -2.5 -2.5 Mabsadd L
.69048 .3599 -2.5 2.5 Mabsadd L closepath F
.69365 .36145 -2.5 2.5 Mabsadd m
.69365 .36145 2.5 2.5 Mabsadd L
.69365 .36145 2.5 -2.5 Mabsadd L
.69365 .36145 -2.5 -2.5 Mabsadd L
.69365 .36145 -2.5 2.5 Mabsadd L closepath F
.69683 .36302 -2.5 2.5 Mabsadd m
.69683 .36302 2.5 2.5 Mabsadd L
.69683 .36302 2.5 -2.5 Mabsadd L
.69683 .36302 -2.5 -2.5 Mabsadd L
.69683 .36302 -2.5 2.5 Mabsadd L closepath F
.7 .3646 -2.5 2.5 Mabsadd m
.7 .3646 2.5 2.5 Mabsadd L
.7 .3646 2.5 -2.5 Mabsadd L
.7 .3646 -2.5 -2.5 Mabsadd L
.7 .3646 -2.5 2.5 Mabsadd L closepath F
.70317 .3662 -2.5 2.5 Mabsadd m
.70317 .3662 2.5 2.5 Mabsadd L
.70317 .3662 2.5 -2.5 Mabsadd L
.70317 .3662 -2.5 -2.5 Mabsadd L
.70317 .3662 -2.5 2.5 Mabsadd L closepath F
.70635 .36782 -2.5 2.5 Mabsadd m
.70635 .36782 2.5 2.5 Mabsadd L
.70635 .36782 2.5 -2.5 Mabsadd L
.70635 .36782 -2.5 -2.5 Mabsadd L
.70635 .36782 -2.5 2.5 Mabsadd L closepath F
.70952 .36945 -2.5 2.5 Mabsadd m
.70952 .36945 2.5 2.5 Mabsadd L
.70952 .36945 2.5 -2.5 Mabsadd L
.70952 .36945 -2.5 -2.5 Mabsadd L
.70952 .36945 -2.5 2.5 Mabsadd L closepath F
.7127 .37109 -2.5 2.5 Mabsadd m
.7127 .37109 2.5 2.5 Mabsadd L
.7127 .37109 2.5 -2.5 Mabsadd L
.7127 .37109 -2.5 -2.5 Mabsadd L
.7127 .37109 -2.5 2.5 Mabsadd L closepath F
.71587 .37276 -2.5 2.5 Mabsadd m
.71587 .37276 2.5 2.5 Mabsadd L
.71587 .37276 2.5 -2.5 Mabsadd L
.71587 .37276 -2.5 -2.5 Mabsadd L
.71587 .37276 -2.5 2.5 Mabsadd L closepath F
.71905 .37444 -2.5 2.5 Mabsadd m
.71905 .37444 2.5 2.5 Mabsadd L
.71905 .37444 2.5 -2.5 Mabsadd L
.71905 .37444 -2.5 -2.5 Mabsadd L
.71905 .37444 -2.5 2.5 Mabsadd L closepath F
.72222 .37614 -2.5 2.5 Mabsadd m
.72222 .37614 2.5 2.5 Mabsadd L
.72222 .37614 2.5 -2.5 Mabsadd L
.72222 .37614 -2.5 -2.5 Mabsadd L
.72222 .37614 -2.5 2.5 Mabsadd L closepath F
.7254 .37785 -2.5 2.5 Mabsadd m
.7254 .37785 2.5 2.5 Mabsadd L
.7254 .37785 2.5 -2.5 Mabsadd L
.7254 .37785 -2.5 -2.5 Mabsadd L
.7254 .37785 -2.5 2.5 Mabsadd L closepath F
.72857 .37958 -2.5 2.5 Mabsadd m
.72857 .37958 2.5 2.5 Mabsadd L
.72857 .37958 2.5 -2.5 Mabsadd L
.72857 .37958 -2.5 -2.5 Mabsadd L
.72857 .37958 -2.5 2.5 Mabsadd L closepath F
.73175 .38133 -2.5 2.5 Mabsadd m
.73175 .38133 2.5 2.5 Mabsadd L
.73175 .38133 2.5 -2.5 Mabsadd L
.73175 .38133 -2.5 -2.5 Mabsadd L
.73175 .38133 -2.5 2.5 Mabsadd L closepath F
.73492 .3831 -2.5 2.5 Mabsadd m
.73492 .3831 2.5 2.5 Mabsadd L
.73492 .3831 2.5 -2.5 Mabsadd L
.73492 .3831 -2.5 -2.5 Mabsadd L
.73492 .3831 -2.5 2.5 Mabsadd L closepath F
.7381 .38488 -2.5 2.5 Mabsadd m
.7381 .38488 2.5 2.5 Mabsadd L
.7381 .38488 2.5 -2.5 Mabsadd L
.7381 .38488 -2.5 -2.5 Mabsadd L
.7381 .38488 -2.5 2.5 Mabsadd L closepath F
.74127 .38668 -2.5 2.5 Mabsadd m
.74127 .38668 2.5 2.5 Mabsadd L
.74127 .38668 2.5 -2.5 Mabsadd L
.74127 .38668 -2.5 -2.5 Mabsadd L
.74127 .38668 -2.5 2.5 Mabsadd L closepath F
.74444 .3885 -2.5 2.5 Mabsadd m
.74444 .3885 2.5 2.5 Mabsadd L
.74444 .3885 2.5 -2.5 Mabsadd L
.74444 .3885 -2.5 -2.5 Mabsadd L
.74444 .3885 -2.5 2.5 Mabsadd L closepath F
.74762 .39034 -2.5 2.5 Mabsadd m
.74762 .39034 2.5 2.5 Mabsadd L
.74762 .39034 2.5 -2.5 Mabsadd L
.74762 .39034 -2.5 -2.5 Mabsadd L
.74762 .39034 -2.5 2.5 Mabsadd L closepath F
.75079 .39219 -2.5 2.5 Mabsadd m
.75079 .39219 2.5 2.5 Mabsadd L
.75079 .39219 2.5 -2.5 Mabsadd L
.75079 .39219 -2.5 -2.5 Mabsadd L
.75079 .39219 -2.5 2.5 Mabsadd L closepath F
.75397 .39407 -2.5 2.5 Mabsadd m
.75397 .39407 2.5 2.5 Mabsadd L
.75397 .39407 2.5 -2.5 Mabsadd L
.75397 .39407 -2.5 -2.5 Mabsadd L
.75397 .39407 -2.5 2.5 Mabsadd L closepath F
.75714 .39596 -2.5 2.5 Mabsadd m
.75714 .39596 2.5 2.5 Mabsadd L
.75714 .39596 2.5 -2.5 Mabsadd L
.75714 .39596 -2.5 -2.5 Mabsadd L
.75714 .39596 -2.5 2.5 Mabsadd L closepath F
.76032 .39788 -2.5 2.5 Mabsadd m
.76032 .39788 2.5 2.5 Mabsadd L
.76032 .39788 2.5 -2.5 Mabsadd L
.76032 .39788 -2.5 -2.5 Mabsadd L
.76032 .39788 -2.5 2.5 Mabsadd L closepath F
.76349 .39981 -2.5 2.5 Mabsadd m
.76349 .39981 2.5 2.5 Mabsadd L
.76349 .39981 2.5 -2.5 Mabsadd L
.76349 .39981 -2.5 -2.5 Mabsadd L
.76349 .39981 -2.5 2.5 Mabsadd L closepath F
.76667 .40176 -2.5 2.5 Mabsadd m
.76667 .40176 2.5 2.5 Mabsadd L
.76667 .40176 2.5 -2.5 Mabsadd L
.76667 .40176 -2.5 -2.5 Mabsadd L
.76667 .40176 -2.5 2.5 Mabsadd L closepath F
.76984 .40373 -2.5 2.5 Mabsadd m
.76984 .40373 2.5 2.5 Mabsadd L
.76984 .40373 2.5 -2.5 Mabsadd L
.76984 .40373 -2.5 -2.5 Mabsadd L
.76984 .40373 -2.5 2.5 Mabsadd L closepath F
.77302 .40572 -2.5 2.5 Mabsadd m
.77302 .40572 2.5 2.5 Mabsadd L
.77302 .40572 2.5 -2.5 Mabsadd L
.77302 .40572 -2.5 -2.5 Mabsadd L
.77302 .40572 -2.5 2.5 Mabsadd L closepath F
.77619 .40773 -2.5 2.5 Mabsadd m
.77619 .40773 2.5 2.5 Mabsadd L
.77619 .40773 2.5 -2.5 Mabsadd L
.77619 .40773 -2.5 -2.5 Mabsadd L
.77619 .40773 -2.5 2.5 Mabsadd L closepath F
.77937 .40976 -2.5 2.5 Mabsadd m
.77937 .40976 2.5 2.5 Mabsadd L
.77937 .40976 2.5 -2.5 Mabsadd L
.77937 .40976 -2.5 -2.5 Mabsadd L
.77937 .40976 -2.5 2.5 Mabsadd L closepath F
.78254 .41181 -2.5 2.5 Mabsadd m
.78254 .41181 2.5 2.5 Mabsadd L
.78254 .41181 2.5 -2.5 Mabsadd L
.78254 .41181 -2.5 -2.5 Mabsadd L
.78254 .41181 -2.5 2.5 Mabsadd L closepath F
.78571 .41388 -2.5 2.5 Mabsadd m
.78571 .41388 2.5 2.5 Mabsadd L
.78571 .41388 2.5 -2.5 Mabsadd L
.78571 .41388 -2.5 -2.5 Mabsadd L
.78571 .41388 -2.5 2.5 Mabsadd L closepath F
.78889 .41597 -2.5 2.5 Mabsadd m
.78889 .41597 2.5 2.5 Mabsadd L
.78889 .41597 2.5 -2.5 Mabsadd L
.78889 .41597 -2.5 -2.5 Mabsadd L
.78889 .41597 -2.5 2.5 Mabsadd L closepath F
.79206 .41808 -2.5 2.5 Mabsadd m
.79206 .41808 2.5 2.5 Mabsadd L
.79206 .41808 2.5 -2.5 Mabsadd L
.79206 .41808 -2.5 -2.5 Mabsadd L
.79206 .41808 -2.5 2.5 Mabsadd L closepath F
.79524 .42022 -2.5 2.5 Mabsadd m
.79524 .42022 2.5 2.5 Mabsadd L
.79524 .42022 2.5 -2.5 Mabsadd L
.79524 .42022 -2.5 -2.5 Mabsadd L
.79524 .42022 -2.5 2.5 Mabsadd L closepath F
.79841 .42237 -2.5 2.5 Mabsadd m
.79841 .42237 2.5 2.5 Mabsadd L
.79841 .42237 2.5 -2.5 Mabsadd L
.79841 .42237 -2.5 -2.5 Mabsadd L
.79841 .42237 -2.5 2.5 Mabsadd L closepath F
.80159 .42455 -2.5 2.5 Mabsadd m
.80159 .42455 2.5 2.5 Mabsadd L
.80159 .42455 2.5 -2.5 Mabsadd L
.80159 .42455 -2.5 -2.5 Mabsadd L
.80159 .42455 -2.5 2.5 Mabsadd L closepath F
.80476 .42675 -2.5 2.5 Mabsadd m
.80476 .42675 2.5 2.5 Mabsadd L
.80476 .42675 2.5 -2.5 Mabsadd L
.80476 .42675 -2.5 -2.5 Mabsadd L
.80476 .42675 -2.5 2.5 Mabsadd L closepath F
.80794 .42897 -2.5 2.5 Mabsadd m
.80794 .42897 2.5 2.5 Mabsadd L
.80794 .42897 2.5 -2.5 Mabsadd L
.80794 .42897 -2.5 -2.5 Mabsadd L
.80794 .42897 -2.5 2.5 Mabsadd L closepath F
.81111 .43121 -2.5 2.5 Mabsadd m
.81111 .43121 2.5 2.5 Mabsadd L
.81111 .43121 2.5 -2.5 Mabsadd L
.81111 .43121 -2.5 -2.5 Mabsadd L
.81111 .43121 -2.5 2.5 Mabsadd L closepath F
.81429 .43348 -2.5 2.5 Mabsadd m
.81429 .43348 2.5 2.5 Mabsadd L
.81429 .43348 2.5 -2.5 Mabsadd L
.81429 .43348 -2.5 -2.5 Mabsadd L
.81429 .43348 -2.5 2.5 Mabsadd L closepath F
.81746 .43576 -2.5 2.5 Mabsadd m
.81746 .43576 2.5 2.5 Mabsadd L
.81746 .43576 2.5 -2.5 Mabsadd L
.81746 .43576 -2.5 -2.5 Mabsadd L
.81746 .43576 -2.5 2.5 Mabsadd L closepath F
.82063 .43807 -2.5 2.5 Mabsadd m
.82063 .43807 2.5 2.5 Mabsadd L
.82063 .43807 2.5 -2.5 Mabsadd L
.82063 .43807 -2.5 -2.5 Mabsadd L
.82063 .43807 -2.5 2.5 Mabsadd L closepath F
.82381 .44041 -2.5 2.5 Mabsadd m
.82381 .44041 2.5 2.5 Mabsadd L
.82381 .44041 2.5 -2.5 Mabsadd L
.82381 .44041 -2.5 -2.5 Mabsadd L
.82381 .44041 -2.5 2.5 Mabsadd L closepath F
.82698 .44277 -2.5 2.5 Mabsadd m
.82698 .44277 2.5 2.5 Mabsadd L
.82698 .44277 2.5 -2.5 Mabsadd L
.82698 .44277 -2.5 -2.5 Mabsadd L
.82698 .44277 -2.5 2.5 Mabsadd L closepath F
.83016 .44515 -2.5 2.5 Mabsadd m
.83016 .44515 2.5 2.5 Mabsadd L
.83016 .44515 2.5 -2.5 Mabsadd L
.83016 .44515 -2.5 -2.5 Mabsadd L
.83016 .44515 -2.5 2.5 Mabsadd L closepath F
.83333 .44755 -2.5 2.5 Mabsadd m
.83333 .44755 2.5 2.5 Mabsadd L
.83333 .44755 2.5 -2.5 Mabsadd L
.83333 .44755 -2.5 -2.5 Mabsadd L
.83333 .44755 -2.5 2.5 Mabsadd L closepath F
.83651 .44998 -2.5 2.5 Mabsadd m
.83651 .44998 2.5 2.5 Mabsadd L
.83651 .44998 2.5 -2.5 Mabsadd L
.83651 .44998 -2.5 -2.5 Mabsadd L
.83651 .44998 -2.5 2.5 Mabsadd L closepath F
.83968 .45243 -2.5 2.5 Mabsadd m
.83968 .45243 2.5 2.5 Mabsadd L
.83968 .45243 2.5 -2.5 Mabsadd L
.83968 .45243 -2.5 -2.5 Mabsadd L
.83968 .45243 -2.5 2.5 Mabsadd L closepath F
.84286 .45491 -2.5 2.5 Mabsadd m
.84286 .45491 2.5 2.5 Mabsadd L
.84286 .45491 2.5 -2.5 Mabsadd L
.84286 .45491 -2.5 -2.5 Mabsadd L
.84286 .45491 -2.5 2.5 Mabsadd L closepath F
.84603 .45741 -2.5 2.5 Mabsadd m
.84603 .45741 2.5 2.5 Mabsadd L
.84603 .45741 2.5 -2.5 Mabsadd L
.84603 .45741 -2.5 -2.5 Mabsadd L
.84603 .45741 -2.5 2.5 Mabsadd L closepath F
.84921 .45994 -2.5 2.5 Mabsadd m
.84921 .45994 2.5 2.5 Mabsadd L
.84921 .45994 2.5 -2.5 Mabsadd L
.84921 .45994 -2.5 -2.5 Mabsadd L
.84921 .45994 -2.5 2.5 Mabsadd L closepath F
.85238 .46249 -2.5 2.5 Mabsadd m
.85238 .46249 2.5 2.5 Mabsadd L
.85238 .46249 2.5 -2.5 Mabsadd L
.85238 .46249 -2.5 -2.5 Mabsadd L
.85238 .46249 -2.5 2.5 Mabsadd L closepath F
.85556 .46507 -2.5 2.5 Mabsadd m
.85556 .46507 2.5 2.5 Mabsadd L
.85556 .46507 2.5 -2.5 Mabsadd L
.85556 .46507 -2.5 -2.5 Mabsadd L
.85556 .46507 -2.5 2.5 Mabsadd L closepath F
.85873 .46767 -2.5 2.5 Mabsadd m
.85873 .46767 2.5 2.5 Mabsadd L
.85873 .46767 2.5 -2.5 Mabsadd L
.85873 .46767 -2.5 -2.5 Mabsadd L
.85873 .46767 -2.5 2.5 Mabsadd L closepath F
.8619 .4703 -2.5 2.5 Mabsadd m
.8619 .4703 2.5 2.5 Mabsadd L
.8619 .4703 2.5 -2.5 Mabsadd L
.8619 .4703 -2.5 -2.5 Mabsadd L
.8619 .4703 -2.5 2.5 Mabsadd L closepath F
.86508 .47296 -2.5 2.5 Mabsadd m
.86508 .47296 2.5 2.5 Mabsadd L
.86508 .47296 2.5 -2.5 Mabsadd L
.86508 .47296 -2.5 -2.5 Mabsadd L
.86508 .47296 -2.5 2.5 Mabsadd L closepath F
.86825 .47564 -2.5 2.5 Mabsadd m
.86825 .47564 2.5 2.5 Mabsadd L
.86825 .47564 2.5 -2.5 Mabsadd L
.86825 .47564 -2.5 -2.5 Mabsadd L
.86825 .47564 -2.5 2.5 Mabsadd L closepath F
.87143 .47835 -2.5 2.5 Mabsadd m
.87143 .47835 2.5 2.5 Mabsadd L
.87143 .47835 2.5 -2.5 Mabsadd L
.87143 .47835 -2.5 -2.5 Mabsadd L
.87143 .47835 -2.5 2.5 Mabsadd L closepath F
.8746 .48108 -2.5 2.5 Mabsadd m
.8746 .48108 2.5 2.5 Mabsadd L
.8746 .48108 2.5 -2.5 Mabsadd L
.8746 .48108 -2.5 -2.5 Mabsadd L
.8746 .48108 -2.5 2.5 Mabsadd L closepath F
.87778 .48385 -2.5 2.5 Mabsadd m
.87778 .48385 2.5 2.5 Mabsadd L
.87778 .48385 2.5 -2.5 Mabsadd L
.87778 .48385 -2.5 -2.5 Mabsadd L
.87778 .48385 -2.5 2.5 Mabsadd L closepath F
.88095 .48664 -2.5 2.5 Mabsadd m
.88095 .48664 2.5 2.5 Mabsadd L
.88095 .48664 2.5 -2.5 Mabsadd L
.88095 .48664 -2.5 -2.5 Mabsadd L
.88095 .48664 -2.5 2.5 Mabsadd L closepath F
.88413 .48946 -2.5 2.5 Mabsadd m
.88413 .48946 2.5 2.5 Mabsadd L
.88413 .48946 2.5 -2.5 Mabsadd L
.88413 .48946 -2.5 -2.5 Mabsadd L
.88413 .48946 -2.5 2.5 Mabsadd L closepath F
.8873 .49231 -2.5 2.5 Mabsadd m
.8873 .49231 2.5 2.5 Mabsadd L
.8873 .49231 2.5 -2.5 Mabsadd L
.8873 .49231 -2.5 -2.5 Mabsadd L
.8873 .49231 -2.5 2.5 Mabsadd L closepath F
.89048 .49518 -2.5 2.5 Mabsadd m
.89048 .49518 2.5 2.5 Mabsadd L
.89048 .49518 2.5 -2.5 Mabsadd L
.89048 .49518 -2.5 -2.5 Mabsadd L
.89048 .49518 -2.5 2.5 Mabsadd L closepath F
.89365 .49809 -2.5 2.5 Mabsadd m
.89365 .49809 2.5 2.5 Mabsadd L
.89365 .49809 2.5 -2.5 Mabsadd L
.89365 .49809 -2.5 -2.5 Mabsadd L
.89365 .49809 -2.5 2.5 Mabsadd L closepath F
.89683 .50102 -2.5 2.5 Mabsadd m
.89683 .50102 2.5 2.5 Mabsadd L
.89683 .50102 2.5 -2.5 Mabsadd L
.89683 .50102 -2.5 -2.5 Mabsadd L
.89683 .50102 -2.5 2.5 Mabsadd L closepath F
.9 .50398 -2.5 2.5 Mabsadd m
.9 .50398 2.5 2.5 Mabsadd L
.9 .50398 2.5 -2.5 Mabsadd L
.9 .50398 -2.5 -2.5 Mabsadd L
.9 .50398 -2.5 2.5 Mabsadd L closepath F
.90317 .50698 -2.5 2.5 Mabsadd m
.90317 .50698 2.5 2.5 Mabsadd L
.90317 .50698 2.5 -2.5 Mabsadd L
.90317 .50698 -2.5 -2.5 Mabsadd L
.90317 .50698 -2.5 2.5 Mabsadd L closepath F
.90635 .51 -2.5 2.5 Mabsadd m
.90635 .51 2.5 2.5 Mabsadd L
.90635 .51 2.5 -2.5 Mabsadd L
.90635 .51 -2.5 -2.5 Mabsadd L
.90635 .51 -2.5 2.5 Mabsadd L closepath F
.90952 .51305 -2.5 2.5 Mabsadd m
.90952 .51305 2.5 2.5 Mabsadd L
.90952 .51305 2.5 -2.5 Mabsadd L
.90952 .51305 -2.5 -2.5 Mabsadd L
.90952 .51305 -2.5 2.5 Mabsadd L closepath F
.9127 .51614 -2.5 2.5 Mabsadd m
.9127 .51614 2.5 2.5 Mabsadd L
.9127 .51614 2.5 -2.5 Mabsadd L
.9127 .51614 -2.5 -2.5 Mabsadd L
.9127 .51614 -2.5 2.5 Mabsadd L closepath F
.91587 .51925 -2.5 2.5 Mabsadd m
.91587 .51925 2.5 2.5 Mabsadd L
.91587 .51925 2.5 -2.5 Mabsadd L
.91587 .51925 -2.5 -2.5 Mabsadd L
.91587 .51925 -2.5 2.5 Mabsadd L closepath F
.91905 .52239 -2.5 2.5 Mabsadd m
.91905 .52239 2.5 2.5 Mabsadd L
.91905 .52239 2.5 -2.5 Mabsadd L
.91905 .52239 -2.5 -2.5 Mabsadd L
.91905 .52239 -2.5 2.5 Mabsadd L closepath F
.92222 .52557 -2.5 2.5 Mabsadd m
.92222 .52557 2.5 2.5 Mabsadd L
.92222 .52557 2.5 -2.5 Mabsadd L
.92222 .52557 -2.5 -2.5 Mabsadd L
.92222 .52557 -2.5 2.5 Mabsadd L closepath F
.9254 .52878 -2.5 2.5 Mabsadd m
.9254 .52878 2.5 2.5 Mabsadd L
.9254 .52878 2.5 -2.5 Mabsadd L
.9254 .52878 -2.5 -2.5 Mabsadd L
.9254 .52878 -2.5 2.5 Mabsadd L closepath F
.92857 .53202 -2.5 2.5 Mabsadd m
.92857 .53202 2.5 2.5 Mabsadd L
.92857 .53202 2.5 -2.5 Mabsadd L
.92857 .53202 -2.5 -2.5 Mabsadd L
.92857 .53202 -2.5 2.5 Mabsadd L closepath F
.93175 .53529 -2.5 2.5 Mabsadd m
.93175 .53529 2.5 2.5 Mabsadd L
.93175 .53529 2.5 -2.5 Mabsadd L
.93175 .53529 -2.5 -2.5 Mabsadd L
.93175 .53529 -2.5 2.5 Mabsadd L closepath F
.93492 .5386 -2.5 2.5 Mabsadd m
.93492 .5386 2.5 2.5 Mabsadd L
.93492 .5386 2.5 -2.5 Mabsadd L
.93492 .5386 -2.5 -2.5 Mabsadd L
.93492 .5386 -2.5 2.5 Mabsadd L closepath F
.9381 .54194 -2.5 2.5 Mabsadd m
.9381 .54194 2.5 2.5 Mabsadd L
.9381 .54194 2.5 -2.5 Mabsadd L
.9381 .54194 -2.5 -2.5 Mabsadd L
.9381 .54194 -2.5 2.5 Mabsadd L closepath F
.94127 .54531 -2.5 2.5 Mabsadd m
.94127 .54531 2.5 2.5 Mabsadd L
.94127 .54531 2.5 -2.5 Mabsadd L
.94127 .54531 -2.5 -2.5 Mabsadd L
.94127 .54531 -2.5 2.5 Mabsadd L closepath F
.94444 .54872 -2.5 2.5 Mabsadd m
.94444 .54872 2.5 2.5 Mabsadd L
.94444 .54872 2.5 -2.5 Mabsadd L
.94444 .54872 -2.5 -2.5 Mabsadd L
.94444 .54872 -2.5 2.5 Mabsadd L closepath F
.94762 .55216 -2.5 2.5 Mabsadd m
.94762 .55216 2.5 2.5 Mabsadd L
.94762 .55216 2.5 -2.5 Mabsadd L
.94762 .55216 -2.5 -2.5 Mabsadd L
.94762 .55216 -2.5 2.5 Mabsadd L closepath F
.95079 .55563 -2.5 2.5 Mabsadd m
.95079 .55563 2.5 2.5 Mabsadd L
.95079 .55563 2.5 -2.5 Mabsadd L
.95079 .55563 -2.5 -2.5 Mabsadd L
.95079 .55563 -2.5 2.5 Mabsadd L closepath F
.95397 .55914 -2.5 2.5 Mabsadd m
.95397 .55914 2.5 2.5 Mabsadd L
.95397 .55914 2.5 -2.5 Mabsadd L
.95397 .55914 -2.5 -2.5 Mabsadd L
.95397 .55914 -2.5 2.5 Mabsadd L closepath F
.95714 .56268 -2.5 2.5 Mabsadd m
.95714 .56268 2.5 2.5 Mabsadd L
.95714 .56268 2.5 -2.5 Mabsadd L
.95714 .56268 -2.5 -2.5 Mabsadd L
.95714 .56268 -2.5 2.5 Mabsadd L closepath F
.96032 .56626 -2.5 2.5 Mabsadd m
.96032 .56626 2.5 2.5 Mabsadd L
.96032 .56626 2.5 -2.5 Mabsadd L
.96032 .56626 -2.5 -2.5 Mabsadd L
.96032 .56626 -2.5 2.5 Mabsadd L closepath F
.96349 .56988 -2.5 2.5 Mabsadd m
.96349 .56988 2.5 2.5 Mabsadd L
.96349 .56988 2.5 -2.5 Mabsadd L
.96349 .56988 -2.5 -2.5 Mabsadd L
.96349 .56988 -2.5 2.5 Mabsadd L closepath F
.96667 .57353 -2.5 2.5 Mabsadd m
.96667 .57353 2.5 2.5 Mabsadd L
.96667 .57353 2.5 -2.5 Mabsadd L
.96667 .57353 -2.5 -2.5 Mabsadd L
.96667 .57353 -2.5 2.5 Mabsadd L closepath F
.96984 .57722 -2.5 2.5 Mabsadd m
.96984 .57722 2.5 2.5 Mabsadd L
.96984 .57722 2.5 -2.5 Mabsadd L
.96984 .57722 -2.5 -2.5 Mabsadd L
.96984 .57722 -2.5 2.5 Mabsadd L closepath F
.97302 .58095 -2.5 2.5 Mabsadd m
.97302 .58095 2.5 2.5 Mabsadd L
.97302 .58095 2.5 -2.5 Mabsadd L
.97302 .58095 -2.5 -2.5 Mabsadd L
.97302 .58095 -2.5 2.5 Mabsadd L closepath F
.97619 .58471 -2.5 2.5 Mabsadd m
.97619 .58471 2.5 2.5 Mabsadd L
.97619 .58471 2.5 -2.5 Mabsadd L
.97619 .58471 -2.5 -2.5 Mabsadd L
.97619 .58471 -2.5 2.5 Mabsadd L closepath F
.0075 w
.02698 .2338 m
.03016 .2341 L
.03333 .23439 L
.03651 .23469 L
.03968 .23499 L
.04286 .23529 L
.04603 .23559 L
.04921 .2359 L
.05238 .23622 L
.05556 .23653 L
.05873 .23685 L
.0619 .23717 L
.06508 .23749 L
.06825 .23782 L
.07143 .23815 L
.0746 .23849 L
.07778 .23883 L
.08095 .23917 L
.08413 .23951 L
.0873 .23986 L
.09048 .24021 L
.09365 .24057 L
.09683 .24092 L
.1 .24129 L
.10317 .24165 L
.10635 .24202 L
.10952 .24239 L
.1127 .24277 L
.11587 .24315 L
.11905 .24354 L
.12222 .24392 L
.1254 .24432 L
.12857 .24471 L
.13175 .24511 L
.13492 .24552 L
.1381 .24592 L
.14127 .24634 L
.14444 .24675 L
.14762 .24717 L
.15079 .2476 L
.15397 .24803 L
.15714 .24846 L
.16032 .2489 L
.16349 .24934 L
.16667 .24979 L
.16984 .25024 L
.17302 .25069 L
.17619 .25115 L
.17937 .25162 L
.18254 .25208 L
Mistroke
.18571 .25256 L
.18889 .25304 L
.19206 .25352 L
.19524 .25401 L
.19841 .2545 L
.20159 .255 L
.20476 .2555 L
.20794 .25601 L
.21111 .25652 L
.21429 .25704 L
.21746 .25756 L
.22063 .25809 L
.22381 .25863 L
.22698 .25917 L
.23016 .25971 L
.23333 .26026 L
.23651 .26082 L
.23968 .26138 L
.24286 .26194 L
.24603 .26252 L
.24921 .26309 L
.25238 .26368 L
.25556 .26427 L
.25873 .26486 L
.2619 .26546 L
.26508 .26607 L
.26825 .26669 L
.27143 .26731 L
.2746 .26793 L
.27778 .26856 L
.28095 .2692 L
.28413 .26985 L
.2873 .2705 L
.29048 .27116 L
.29365 .27182 L
.29683 .27249 L
.3 .27317 L
.30317 .27385 L
.30635 .27455 L
.30952 .27524 L
.3127 .27595 L
.31587 .27666 L
.31905 .27738 L
.32222 .27811 L
.3254 .27884 L
.32857 .27958 L
.33175 .28033 L
.33492 .28109 L
.3381 .28185 L
.34127 .28262 L
Mistroke
.34444 .2834 L
.34762 .28419 L
.35079 .28498 L
.35397 .28579 L
.35714 .2866 L
.36032 .28742 L
.36349 .28824 L
.36667 .28908 L
.36984 .28992 L
.37302 .29077 L
.37619 .29163 L
.37937 .2925 L
.38254 .29338 L
.38571 .29427 L
.38889 .29516 L
.39206 .29607 L
.39524 .29698 L
.39841 .2979 L
.40159 .29884 L
.40476 .29978 L
.40794 .30073 L
.41111 .30169 L
.41429 .30266 L
.41746 .30364 L
.42063 .30463 L
.42381 .30563 L
.42698 .30664 L
.43016 .30765 L
.43333 .30868 L
.43651 .30972 L
.43968 .31077 L
.44286 .31183 L
.44603 .31291 L
.44921 .31399 L
.45238 .31508 L
.45556 .31618 L
.45873 .3173 L
.4619 .31842 L
.46508 .31956 L
.46825 .32071 L
.47143 .32187 L
.4746 .32304 L
.47778 .32423 L
.48095 .32542 L
.48413 .32663 L
.4873 .32785 L
.49048 .32908 L
.49365 .33032 L
.49683 .33158 L
.5 .33285 L
Mistroke
.50317 .33413 L
.50635 .33542 L
.50952 .33673 L
.5127 .33805 L
.51587 .33938 L
.51905 .34073 L
.52222 .34209 L
.5254 .34346 L
.52857 .34485 L
.53175 .34625 L
.53492 .34767 L
.5381 .3491 L
.54127 .35054 L
.54444 .352 L
.54762 .35347 L
.55079 .35496 L
.55397 .35646 L
.55714 .35798 L
.56032 .35951 L
.56349 .36106 L
.56667 .36262 L
.56984 .3642 L
.57302 .3658 L
.57619 .36741 L
.57937 .36904 L
.58254 .37068 L
.58571 .37234 L
.58889 .37401 L
.59206 .37571 L
.59524 .37742 L
.59841 .37914 L
.60159 .38089 L
.60476 .38265 L
.60794 .38443 L
.61111 .38623 L
.61429 .38804 L
.61746 .38988 L
.62063 .39173 L
.62381 .3936 L
.62698 .39549 L
.63016 .39739 L
.63333 .39932 L
.63651 .40127 L
.63968 .40323 L
.64286 .40522 L
.64603 .40722 L
.64921 .40925 L
.65238 .41129 L
.65556 .41336 L
.65873 .41545 L
Mistroke
.6619 .41755 L
.66508 .41968 L
.66825 .42183 L
.67143 .424 L
.6746 .42619 L
.67778 .42841 L
.68095 .43065 L
.68413 .43291 L
.6873 .43519 L
.69048 .43749 L
.69365 .43982 L
.69683 .44217 L
.7 .44455 L
.70317 .44694 L
.70635 .44937 L
.70952 .45181 L
.7127 .45428 L
.71587 .45678 L
.71905 .4593 L
.72222 .46185 L
.7254 .46442 L
.72857 .46701 L
.73175 .46964 L
.73492 .47229 L
.7381 .47496 L
.74127 .47767 L
.74444 .48039 L
.74762 .48315 L
.75079 .48594 L
.75397 .48875 L
.75714 .49159 L
.76032 .49446 L
.76349 .49735 L
.76667 .50028 L
.76984 .50324 L
.77302 .50622 L
.77619 .50924 L
.77937 .51228 L
.78254 .51536 L
.78571 .51846 L
.78889 .5216 L
.79206 .52477 L
.79524 .52797 L
.79841 .5312 L
.80159 .53447 L
.80476 .53777 L
.80794 .5411 L
.81111 .54446 L
.81429 .54786 L
.81746 .55129 L
Mistroke
.82063 .55476 L
.82381 .55826 L
.82698 .56179 L
.83016 .56536 L
.83333 .56897 L
.83651 .57261 L
.83968 .57629 L
.84286 .58001 L
.84603 .58376 L
.84921 .58755 L
.85238 .59138 L
.85556 .59524 L
.85873 .59915 L
.8619 .60309 L
.86508 .60708 L
.86825 .6111 L
.87143 .61517 L
Mfstroke
.87143 .61517 m
.87365 .61803 L
s
.0001 w
.02698 .2338 0 2.5 Mabsadd m
.02698 .2338 -2.165 -1.25 Mabsadd L
.02698 .2338 2.165 -1.25 Mabsadd L
.02698 .2338 0 2.5 Mabsadd L closepath F
.03016 .2341 0 2.5 Mabsadd m
.03016 .2341 -2.165 -1.25 Mabsadd L
.03016 .2341 2.165 -1.25 Mabsadd L
.03016 .2341 0 2.5 Mabsadd L closepath F
.03333 .23439 0 2.5 Mabsadd m
.03333 .23439 -2.165 -1.25 Mabsadd L
.03333 .23439 2.165 -1.25 Mabsadd L
.03333 .23439 0 2.5 Mabsadd L closepath F
.03651 .23469 0 2.5 Mabsadd m
.03651 .23469 -2.165 -1.25 Mabsadd L
.03651 .23469 2.165 -1.25 Mabsadd L
.03651 .23469 0 2.5 Mabsadd L closepath F
.03968 .23499 0 2.5 Mabsadd m
.03968 .23499 -2.165 -1.25 Mabsadd L
.03968 .23499 2.165 -1.25 Mabsadd L
.03968 .23499 0 2.5 Mabsadd L closepath F
.04286 .23529 0 2.5 Mabsadd m
.04286 .23529 -2.165 -1.25 Mabsadd L
.04286 .23529 2.165 -1.25 Mabsadd L
.04286 .23529 0 2.5 Mabsadd L closepath F
.04603 .23559 0 2.5 Mabsadd m
.04603 .23559 -2.165 -1.25 Mabsadd L
.04603 .23559 2.165 -1.25 Mabsadd L
.04603 .23559 0 2.5 Mabsadd L closepath F
.04921 .2359 0 2.5 Mabsadd m
.04921 .2359 -2.165 -1.25 Mabsadd L
.04921 .2359 2.165 -1.25 Mabsadd L
.04921 .2359 0 2.5 Mabsadd L closepath F
.05238 .23622 0 2.5 Mabsadd m
.05238 .23622 -2.165 -1.25 Mabsadd L
.05238 .23622 2.165 -1.25 Mabsadd L
.05238 .23622 0 2.5 Mabsadd L closepath F
.05556 .23653 0 2.5 Mabsadd m
.05556 .23653 -2.165 -1.25 Mabsadd L
.05556 .23653 2.165 -1.25 Mabsadd L
.05556 .23653 0 2.5 Mabsadd L closepath F
.05873 .23685 0 2.5 Mabsadd m
.05873 .23685 -2.165 -1.25 Mabsadd L
.05873 .23685 2.165 -1.25 Mabsadd L
.05873 .23685 0 2.5 Mabsadd L closepath F
.0619 .23717 0 2.5 Mabsadd m
.0619 .23717 -2.165 -1.25 Mabsadd L
.0619 .23717 2.165 -1.25 Mabsadd L
.0619 .23717 0 2.5 Mabsadd L closepath F
.06508 .23749 0 2.5 Mabsadd m
.06508 .23749 -2.165 -1.25 Mabsadd L
.06508 .23749 2.165 -1.25 Mabsadd L
.06508 .23749 0 2.5 Mabsadd L closepath F
.06825 .23782 0 2.5 Mabsadd m
.06825 .23782 -2.165 -1.25 Mabsadd L
.06825 .23782 2.165 -1.25 Mabsadd L
.06825 .23782 0 2.5 Mabsadd L closepath F
.07143 .23815 0 2.5 Mabsadd m
.07143 .23815 -2.165 -1.25 Mabsadd L
.07143 .23815 2.165 -1.25 Mabsadd L
.07143 .23815 0 2.5 Mabsadd L closepath F
.0746 .23849 0 2.5 Mabsadd m
.0746 .23849 -2.165 -1.25 Mabsadd L
.0746 .23849 2.165 -1.25 Mabsadd L
.0746 .23849 0 2.5 Mabsadd L closepath F
.07778 .23883 0 2.5 Mabsadd m
.07778 .23883 -2.165 -1.25 Mabsadd L
.07778 .23883 2.165 -1.25 Mabsadd L
.07778 .23883 0 2.5 Mabsadd L closepath F
.08095 .23917 0 2.5 Mabsadd m
.08095 .23917 -2.165 -1.25 Mabsadd L
.08095 .23917 2.165 -1.25 Mabsadd L
.08095 .23917 0 2.5 Mabsadd L closepath F
.08413 .23951 0 2.5 Mabsadd m
.08413 .23951 -2.165 -1.25 Mabsadd L
.08413 .23951 2.165 -1.25 Mabsadd L
.08413 .23951 0 2.5 Mabsadd L closepath F
.0873 .23986 0 2.5 Mabsadd m
.0873 .23986 -2.165 -1.25 Mabsadd L
.0873 .23986 2.165 -1.25 Mabsadd L
.0873 .23986 0 2.5 Mabsadd L closepath F
.09048 .24021 0 2.5 Mabsadd m
.09048 .24021 -2.165 -1.25 Mabsadd L
.09048 .24021 2.165 -1.25 Mabsadd L
.09048 .24021 0 2.5 Mabsadd L closepath F
.09365 .24057 0 2.5 Mabsadd m
.09365 .24057 -2.165 -1.25 Mabsadd L
.09365 .24057 2.165 -1.25 Mabsadd L
.09365 .24057 0 2.5 Mabsadd L closepath F
.09683 .24092 0 2.5 Mabsadd m
.09683 .24092 -2.165 -1.25 Mabsadd L
.09683 .24092 2.165 -1.25 Mabsadd L
.09683 .24092 0 2.5 Mabsadd L closepath F
.1 .24129 0 2.5 Mabsadd m
.1 .24129 -2.165 -1.25 Mabsadd L
.1 .24129 2.165 -1.25 Mabsadd L
.1 .24129 0 2.5 Mabsadd L closepath F
.10317 .24165 0 2.5 Mabsadd m
.10317 .24165 -2.165 -1.25 Mabsadd L
.10317 .24165 2.165 -1.25 Mabsadd L
.10317 .24165 0 2.5 Mabsadd L closepath F
.10635 .24202 0 2.5 Mabsadd m
.10635 .24202 -2.165 -1.25 Mabsadd L
.10635 .24202 2.165 -1.25 Mabsadd L
.10635 .24202 0 2.5 Mabsadd L closepath F
.10952 .24239 0 2.5 Mabsadd m
.10952 .24239 -2.165 -1.25 Mabsadd L
.10952 .24239 2.165 -1.25 Mabsadd L
.10952 .24239 0 2.5 Mabsadd L closepath F
.1127 .24277 0 2.5 Mabsadd m
.1127 .24277 -2.165 -1.25 Mabsadd L
.1127 .24277 2.165 -1.25 Mabsadd L
.1127 .24277 0 2.5 Mabsadd L closepath F
.11587 .24315 0 2.5 Mabsadd m
.11587 .24315 -2.165 -1.25 Mabsadd L
.11587 .24315 2.165 -1.25 Mabsadd L
.11587 .24315 0 2.5 Mabsadd L closepath F
.11905 .24354 0 2.5 Mabsadd m
.11905 .24354 -2.165 -1.25 Mabsadd L
.11905 .24354 2.165 -1.25 Mabsadd L
.11905 .24354 0 2.5 Mabsadd L closepath F
.12222 .24392 0 2.5 Mabsadd m
.12222 .24392 -2.165 -1.25 Mabsadd L
.12222 .24392 2.165 -1.25 Mabsadd L
.12222 .24392 0 2.5 Mabsadd L closepath F
.1254 .24432 0 2.5 Mabsadd m
.1254 .24432 -2.165 -1.25 Mabsadd L
.1254 .24432 2.165 -1.25 Mabsadd L
.1254 .24432 0 2.5 Mabsadd L closepath F
.12857 .24471 0 2.5 Mabsadd m
.12857 .24471 -2.165 -1.25 Mabsadd L
.12857 .24471 2.165 -1.25 Mabsadd L
.12857 .24471 0 2.5 Mabsadd L closepath F
.13175 .24511 0 2.5 Mabsadd m
.13175 .24511 -2.165 -1.25 Mabsadd L
.13175 .24511 2.165 -1.25 Mabsadd L
.13175 .24511 0 2.5 Mabsadd L closepath F
.13492 .24552 0 2.5 Mabsadd m
.13492 .24552 -2.165 -1.25 Mabsadd L
.13492 .24552 2.165 -1.25 Mabsadd L
.13492 .24552 0 2.5 Mabsadd L closepath F
.1381 .24592 0 2.5 Mabsadd m
.1381 .24592 -2.165 -1.25 Mabsadd L
.1381 .24592 2.165 -1.25 Mabsadd L
.1381 .24592 0 2.5 Mabsadd L closepath F
.14127 .24634 0 2.5 Mabsadd m
.14127 .24634 -2.165 -1.25 Mabsadd L
.14127 .24634 2.165 -1.25 Mabsadd L
.14127 .24634 0 2.5 Mabsadd L closepath F
.14444 .24675 0 2.5 Mabsadd m
.14444 .24675 -2.165 -1.25 Mabsadd L
.14444 .24675 2.165 -1.25 Mabsadd L
.14444 .24675 0 2.5 Mabsadd L closepath F
.14762 .24717 0 2.5 Mabsadd m
.14762 .24717 -2.165 -1.25 Mabsadd L
.14762 .24717 2.165 -1.25 Mabsadd L
.14762 .24717 0 2.5 Mabsadd L closepath F
.15079 .2476 0 2.5 Mabsadd m
.15079 .2476 -2.165 -1.25 Mabsadd L
.15079 .2476 2.165 -1.25 Mabsadd L
.15079 .2476 0 2.5 Mabsadd L closepath F
.15397 .24803 0 2.5 Mabsadd m
.15397 .24803 -2.165 -1.25 Mabsadd L
.15397 .24803 2.165 -1.25 Mabsadd L
.15397 .24803 0 2.5 Mabsadd L closepath F
.15714 .24846 0 2.5 Mabsadd m
.15714 .24846 -2.165 -1.25 Mabsadd L
.15714 .24846 2.165 -1.25 Mabsadd L
.15714 .24846 0 2.5 Mabsadd L closepath F
.16032 .2489 0 2.5 Mabsadd m
.16032 .2489 -2.165 -1.25 Mabsadd L
.16032 .2489 2.165 -1.25 Mabsadd L
.16032 .2489 0 2.5 Mabsadd L closepath F
.16349 .24934 0 2.5 Mabsadd m
.16349 .24934 -2.165 -1.25 Mabsadd L
.16349 .24934 2.165 -1.25 Mabsadd L
.16349 .24934 0 2.5 Mabsadd L closepath F
.16667 .24979 0 2.5 Mabsadd m
.16667 .24979 -2.165 -1.25 Mabsadd L
.16667 .24979 2.165 -1.25 Mabsadd L
.16667 .24979 0 2.5 Mabsadd L closepath F
.16984 .25024 0 2.5 Mabsadd m
.16984 .25024 -2.165 -1.25 Mabsadd L
.16984 .25024 2.165 -1.25 Mabsadd L
.16984 .25024 0 2.5 Mabsadd L closepath F
.17302 .25069 0 2.5 Mabsadd m
.17302 .25069 -2.165 -1.25 Mabsadd L
.17302 .25069 2.165 -1.25 Mabsadd L
.17302 .25069 0 2.5 Mabsadd L closepath F
.17619 .25115 0 2.5 Mabsadd m
.17619 .25115 -2.165 -1.25 Mabsadd L
.17619 .25115 2.165 -1.25 Mabsadd L
.17619 .25115 0 2.5 Mabsadd L closepath F
.17937 .25162 0 2.5 Mabsadd m
.17937 .25162 -2.165 -1.25 Mabsadd L
.17937 .25162 2.165 -1.25 Mabsadd L
.17937 .25162 0 2.5 Mabsadd L closepath F
.18254 .25208 0 2.5 Mabsadd m
.18254 .25208 -2.165 -1.25 Mabsadd L
.18254 .25208 2.165 -1.25 Mabsadd L
.18254 .25208 0 2.5 Mabsadd L closepath F
.18571 .25256 0 2.5 Mabsadd m
.18571 .25256 -2.165 -1.25 Mabsadd L
.18571 .25256 2.165 -1.25 Mabsadd L
.18571 .25256 0 2.5 Mabsadd L closepath F
.18889 .25304 0 2.5 Mabsadd m
.18889 .25304 -2.165 -1.25 Mabsadd L
.18889 .25304 2.165 -1.25 Mabsadd L
.18889 .25304 0 2.5 Mabsadd L closepath F
.19206 .25352 0 2.5 Mabsadd m
.19206 .25352 -2.165 -1.25 Mabsadd L
.19206 .25352 2.165 -1.25 Mabsadd L
.19206 .25352 0 2.5 Mabsadd L closepath F
.19524 .25401 0 2.5 Mabsadd m
.19524 .25401 -2.165 -1.25 Mabsadd L
.19524 .25401 2.165 -1.25 Mabsadd L
.19524 .25401 0 2.5 Mabsadd L closepath F
.19841 .2545 0 2.5 Mabsadd m
.19841 .2545 -2.165 -1.25 Mabsadd L
.19841 .2545 2.165 -1.25 Mabsadd L
.19841 .2545 0 2.5 Mabsadd L closepath F
.20159 .255 0 2.5 Mabsadd m
.20159 .255 -2.165 -1.25 Mabsadd L
.20159 .255 2.165 -1.25 Mabsadd L
.20159 .255 0 2.5 Mabsadd L closepath F
.20476 .2555 0 2.5 Mabsadd m
.20476 .2555 -2.165 -1.25 Mabsadd L
.20476 .2555 2.165 -1.25 Mabsadd L
.20476 .2555 0 2.5 Mabsadd L closepath F
.20794 .25601 0 2.5 Mabsadd m
.20794 .25601 -2.165 -1.25 Mabsadd L
.20794 .25601 2.165 -1.25 Mabsadd L
.20794 .25601 0 2.5 Mabsadd L closepath F
.21111 .25652 0 2.5 Mabsadd m
.21111 .25652 -2.165 -1.25 Mabsadd L
.21111 .25652 2.165 -1.25 Mabsadd L
.21111 .25652 0 2.5 Mabsadd L closepath F
.21429 .25704 0 2.5 Mabsadd m
.21429 .25704 -2.165 -1.25 Mabsadd L
.21429 .25704 2.165 -1.25 Mabsadd L
.21429 .25704 0 2.5 Mabsadd L closepath F
.21746 .25756 0 2.5 Mabsadd m
.21746 .25756 -2.165 -1.25 Mabsadd L
.21746 .25756 2.165 -1.25 Mabsadd L
.21746 .25756 0 2.5 Mabsadd L closepath F
.22063 .25809 0 2.5 Mabsadd m
.22063 .25809 -2.165 -1.25 Mabsadd L
.22063 .25809 2.165 -1.25 Mabsadd L
.22063 .25809 0 2.5 Mabsadd L closepath F
.22381 .25863 0 2.5 Mabsadd m
.22381 .25863 -2.165 -1.25 Mabsadd L
.22381 .25863 2.165 -1.25 Mabsadd L
.22381 .25863 0 2.5 Mabsadd L closepath F
.22698 .25917 0 2.5 Mabsadd m
.22698 .25917 -2.165 -1.25 Mabsadd L
.22698 .25917 2.165 -1.25 Mabsadd L
.22698 .25917 0 2.5 Mabsadd L closepath F
.23016 .25971 0 2.5 Mabsadd m
.23016 .25971 -2.165 -1.25 Mabsadd L
.23016 .25971 2.165 -1.25 Mabsadd L
.23016 .25971 0 2.5 Mabsadd L closepath F
.23333 .26026 0 2.5 Mabsadd m
.23333 .26026 -2.165 -1.25 Mabsadd L
.23333 .26026 2.165 -1.25 Mabsadd L
.23333 .26026 0 2.5 Mabsadd L closepath F
.23651 .26082 0 2.5 Mabsadd m
.23651 .26082 -2.165 -1.25 Mabsadd L
.23651 .26082 2.165 -1.25 Mabsadd L
.23651 .26082 0 2.5 Mabsadd L closepath F
.23968 .26138 0 2.5 Mabsadd m
.23968 .26138 -2.165 -1.25 Mabsadd L
.23968 .26138 2.165 -1.25 Mabsadd L
.23968 .26138 0 2.5 Mabsadd L closepath F
.24286 .26194 0 2.5 Mabsadd m
.24286 .26194 -2.165 -1.25 Mabsadd L
.24286 .26194 2.165 -1.25 Mabsadd L
.24286 .26194 0 2.5 Mabsadd L closepath F
.24603 .26252 0 2.5 Mabsadd m
.24603 .26252 -2.165 -1.25 Mabsadd L
.24603 .26252 2.165 -1.25 Mabsadd L
.24603 .26252 0 2.5 Mabsadd L closepath F
.24921 .26309 0 2.5 Mabsadd m
.24921 .26309 -2.165 -1.25 Mabsadd L
.24921 .26309 2.165 -1.25 Mabsadd L
.24921 .26309 0 2.5 Mabsadd L closepath F
.25238 .26368 0 2.5 Mabsadd m
.25238 .26368 -2.165 -1.25 Mabsadd L
.25238 .26368 2.165 -1.25 Mabsadd L
.25238 .26368 0 2.5 Mabsadd L closepath F
.25556 .26427 0 2.5 Mabsadd m
.25556 .26427 -2.165 -1.25 Mabsadd L
.25556 .26427 2.165 -1.25 Mabsadd L
.25556 .26427 0 2.5 Mabsadd L closepath F
.25873 .26486 0 2.5 Mabsadd m
.25873 .26486 -2.165 -1.25 Mabsadd L
.25873 .26486 2.165 -1.25 Mabsadd L
.25873 .26486 0 2.5 Mabsadd L closepath F
.2619 .26546 0 2.5 Mabsadd m
.2619 .26546 -2.165 -1.25 Mabsadd L
.2619 .26546 2.165 -1.25 Mabsadd L
.2619 .26546 0 2.5 Mabsadd L closepath F
.26508 .26607 0 2.5 Mabsadd m
.26508 .26607 -2.165 -1.25 Mabsadd L
.26508 .26607 2.165 -1.25 Mabsadd L
.26508 .26607 0 2.5 Mabsadd L closepath F
.26825 .26669 0 2.5 Mabsadd m
.26825 .26669 -2.165 -1.25 Mabsadd L
.26825 .26669 2.165 -1.25 Mabsadd L
.26825 .26669 0 2.5 Mabsadd L closepath F
.27143 .26731 0 2.5 Mabsadd m
.27143 .26731 -2.165 -1.25 Mabsadd L
.27143 .26731 2.165 -1.25 Mabsadd L
.27143 .26731 0 2.5 Mabsadd L closepath F
.2746 .26793 0 2.5 Mabsadd m
.2746 .26793 -2.165 -1.25 Mabsadd L
.2746 .26793 2.165 -1.25 Mabsadd L
.2746 .26793 0 2.5 Mabsadd L closepath F
.27778 .26856 0 2.5 Mabsadd m
.27778 .26856 -2.165 -1.25 Mabsadd L
.27778 .26856 2.165 -1.25 Mabsadd L
.27778 .26856 0 2.5 Mabsadd L closepath F
.28095 .2692 0 2.5 Mabsadd m
.28095 .2692 -2.165 -1.25 Mabsadd L
.28095 .2692 2.165 -1.25 Mabsadd L
.28095 .2692 0 2.5 Mabsadd L closepath F
.28413 .26985 0 2.5 Mabsadd m
.28413 .26985 -2.165 -1.25 Mabsadd L
.28413 .26985 2.165 -1.25 Mabsadd L
.28413 .26985 0 2.5 Mabsadd L closepath F
.2873 .2705 0 2.5 Mabsadd m
.2873 .2705 -2.165 -1.25 Mabsadd L
.2873 .2705 2.165 -1.25 Mabsadd L
.2873 .2705 0 2.5 Mabsadd L closepath F
.29048 .27116 0 2.5 Mabsadd m
.29048 .27116 -2.165 -1.25 Mabsadd L
.29048 .27116 2.165 -1.25 Mabsadd L
.29048 .27116 0 2.5 Mabsadd L closepath F
.29365 .27182 0 2.5 Mabsadd m
.29365 .27182 -2.165 -1.25 Mabsadd L
.29365 .27182 2.165 -1.25 Mabsadd L
.29365 .27182 0 2.5 Mabsadd L closepath F
.29683 .27249 0 2.5 Mabsadd m
.29683 .27249 -2.165 -1.25 Mabsadd L
.29683 .27249 2.165 -1.25 Mabsadd L
.29683 .27249 0 2.5 Mabsadd L closepath F
.3 .27317 0 2.5 Mabsadd m
.3 .27317 -2.165 -1.25 Mabsadd L
.3 .27317 2.165 -1.25 Mabsadd L
.3 .27317 0 2.5 Mabsadd L closepath F
.30317 .27385 0 2.5 Mabsadd m
.30317 .27385 -2.165 -1.25 Mabsadd L
.30317 .27385 2.165 -1.25 Mabsadd L
.30317 .27385 0 2.5 Mabsadd L closepath F
.30635 .27455 0 2.5 Mabsadd m
.30635 .27455 -2.165 -1.25 Mabsadd L
.30635 .27455 2.165 -1.25 Mabsadd L
.30635 .27455 0 2.5 Mabsadd L closepath F
.30952 .27524 0 2.5 Mabsadd m
.30952 .27524 -2.165 -1.25 Mabsadd L
.30952 .27524 2.165 -1.25 Mabsadd L
.30952 .27524 0 2.5 Mabsadd L closepath F
.3127 .27595 0 2.5 Mabsadd m
.3127 .27595 -2.165 -1.25 Mabsadd L
.3127 .27595 2.165 -1.25 Mabsadd L
.3127 .27595 0 2.5 Mabsadd L closepath F
.31587 .27666 0 2.5 Mabsadd m
.31587 .27666 -2.165 -1.25 Mabsadd L
.31587 .27666 2.165 -1.25 Mabsadd L
.31587 .27666 0 2.5 Mabsadd L closepath F
.31905 .27738 0 2.5 Mabsadd m
.31905 .27738 -2.165 -1.25 Mabsadd L
.31905 .27738 2.165 -1.25 Mabsadd L
.31905 .27738 0 2.5 Mabsadd L closepath F
.32222 .27811 0 2.5 Mabsadd m
.32222 .27811 -2.165 -1.25 Mabsadd L
.32222 .27811 2.165 -1.25 Mabsadd L
.32222 .27811 0 2.5 Mabsadd L closepath F
.3254 .27884 0 2.5 Mabsadd m
.3254 .27884 -2.165 -1.25 Mabsadd L
.3254 .27884 2.165 -1.25 Mabsadd L
.3254 .27884 0 2.5 Mabsadd L closepath F
.32857 .27958 0 2.5 Mabsadd m
.32857 .27958 -2.165 -1.25 Mabsadd L
.32857 .27958 2.165 -1.25 Mabsadd L
.32857 .27958 0 2.5 Mabsadd L closepath F
.33175 .28033 0 2.5 Mabsadd m
.33175 .28033 -2.165 -1.25 Mabsadd L
.33175 .28033 2.165 -1.25 Mabsadd L
.33175 .28033 0 2.5 Mabsadd L closepath F
.33492 .28109 0 2.5 Mabsadd m
.33492 .28109 -2.165 -1.25 Mabsadd L
.33492 .28109 2.165 -1.25 Mabsadd L
.33492 .28109 0 2.5 Mabsadd L closepath F
.3381 .28185 0 2.5 Mabsadd m
.3381 .28185 -2.165 -1.25 Mabsadd L
.3381 .28185 2.165 -1.25 Mabsadd L
.3381 .28185 0 2.5 Mabsadd L closepath F
.34127 .28262 0 2.5 Mabsadd m
.34127 .28262 -2.165 -1.25 Mabsadd L
.34127 .28262 2.165 -1.25 Mabsadd L
.34127 .28262 0 2.5 Mabsadd L closepath F
.34444 .2834 0 2.5 Mabsadd m
.34444 .2834 -2.165 -1.25 Mabsadd L
.34444 .2834 2.165 -1.25 Mabsadd L
.34444 .2834 0 2.5 Mabsadd L closepath F
.34762 .28419 0 2.5 Mabsadd m
.34762 .28419 -2.165 -1.25 Mabsadd L
.34762 .28419 2.165 -1.25 Mabsadd L
.34762 .28419 0 2.5 Mabsadd L closepath F
.35079 .28498 0 2.5 Mabsadd m
.35079 .28498 -2.165 -1.25 Mabsadd L
.35079 .28498 2.165 -1.25 Mabsadd L
.35079 .28498 0 2.5 Mabsadd L closepath F
.35397 .28579 0 2.5 Mabsadd m
.35397 .28579 -2.165 -1.25 Mabsadd L
.35397 .28579 2.165 -1.25 Mabsadd L
.35397 .28579 0 2.5 Mabsadd L closepath F
.35714 .2866 0 2.5 Mabsadd m
.35714 .2866 -2.165 -1.25 Mabsadd L
.35714 .2866 2.165 -1.25 Mabsadd L
.35714 .2866 0 2.5 Mabsadd L closepath F
.36032 .28742 0 2.5 Mabsadd m
.36032 .28742 -2.165 -1.25 Mabsadd L
.36032 .28742 2.165 -1.25 Mabsadd L
.36032 .28742 0 2.5 Mabsadd L closepath F
.36349 .28824 0 2.5 Mabsadd m
.36349 .28824 -2.165 -1.25 Mabsadd L
.36349 .28824 2.165 -1.25 Mabsadd L
.36349 .28824 0 2.5 Mabsadd L closepath F
.36667 .28908 0 2.5 Mabsadd m
.36667 .28908 -2.165 -1.25 Mabsadd L
.36667 .28908 2.165 -1.25 Mabsadd L
.36667 .28908 0 2.5 Mabsadd L closepath F
.36984 .28992 0 2.5 Mabsadd m
.36984 .28992 -2.165 -1.25 Mabsadd L
.36984 .28992 2.165 -1.25 Mabsadd L
.36984 .28992 0 2.5 Mabsadd L closepath F
.37302 .29077 0 2.5 Mabsadd m
.37302 .29077 -2.165 -1.25 Mabsadd L
.37302 .29077 2.165 -1.25 Mabsadd L
.37302 .29077 0 2.5 Mabsadd L closepath F
.37619 .29163 0 2.5 Mabsadd m
.37619 .29163 -2.165 -1.25 Mabsadd L
.37619 .29163 2.165 -1.25 Mabsadd L
.37619 .29163 0 2.5 Mabsadd L closepath F
.37937 .2925 0 2.5 Mabsadd m
.37937 .2925 -2.165 -1.25 Mabsadd L
.37937 .2925 2.165 -1.25 Mabsadd L
.37937 .2925 0 2.5 Mabsadd L closepath F
.38254 .29338 0 2.5 Mabsadd m
.38254 .29338 -2.165 -1.25 Mabsadd L
.38254 .29338 2.165 -1.25 Mabsadd L
.38254 .29338 0 2.5 Mabsadd L closepath F
.38571 .29427 0 2.5 Mabsadd m
.38571 .29427 -2.165 -1.25 Mabsadd L
.38571 .29427 2.165 -1.25 Mabsadd L
.38571 .29427 0 2.5 Mabsadd L closepath F
.38889 .29516 0 2.5 Mabsadd m
.38889 .29516 -2.165 -1.25 Mabsadd L
.38889 .29516 2.165 -1.25 Mabsadd L
.38889 .29516 0 2.5 Mabsadd L closepath F
.39206 .29607 0 2.5 Mabsadd m
.39206 .29607 -2.165 -1.25 Mabsadd L
.39206 .29607 2.165 -1.25 Mabsadd L
.39206 .29607 0 2.5 Mabsadd L closepath F
.39524 .29698 0 2.5 Mabsadd m
.39524 .29698 -2.165 -1.25 Mabsadd L
.39524 .29698 2.165 -1.25 Mabsadd L
.39524 .29698 0 2.5 Mabsadd L closepath F
.39841 .2979 0 2.5 Mabsadd m
.39841 .2979 -2.165 -1.25 Mabsadd L
.39841 .2979 2.165 -1.25 Mabsadd L
.39841 .2979 0 2.5 Mabsadd L closepath F
.40159 .29884 0 2.5 Mabsadd m
.40159 .29884 -2.165 -1.25 Mabsadd L
.40159 .29884 2.165 -1.25 Mabsadd L
.40159 .29884 0 2.5 Mabsadd L closepath F
.40476 .29978 0 2.5 Mabsadd m
.40476 .29978 -2.165 -1.25 Mabsadd L
.40476 .29978 2.165 -1.25 Mabsadd L
.40476 .29978 0 2.5 Mabsadd L closepath F
.40794 .30073 0 2.5 Mabsadd m
.40794 .30073 -2.165 -1.25 Mabsadd L
.40794 .30073 2.165 -1.25 Mabsadd L
.40794 .30073 0 2.5 Mabsadd L closepath F
.41111 .30169 0 2.5 Mabsadd m
.41111 .30169 -2.165 -1.25 Mabsadd L
.41111 .30169 2.165 -1.25 Mabsadd L
.41111 .30169 0 2.5 Mabsadd L closepath F
.41429 .30266 0 2.5 Mabsadd m
.41429 .30266 -2.165 -1.25 Mabsadd L
.41429 .30266 2.165 -1.25 Mabsadd L
.41429 .30266 0 2.5 Mabsadd L closepath F
.41746 .30364 0 2.5 Mabsadd m
.41746 .30364 -2.165 -1.25 Mabsadd L
.41746 .30364 2.165 -1.25 Mabsadd L
.41746 .30364 0 2.5 Mabsadd L closepath F
.42063 .30463 0 2.5 Mabsadd m
.42063 .30463 -2.165 -1.25 Mabsadd L
.42063 .30463 2.165 -1.25 Mabsadd L
.42063 .30463 0 2.5 Mabsadd L closepath F
.42381 .30563 0 2.5 Mabsadd m
.42381 .30563 -2.165 -1.25 Mabsadd L
.42381 .30563 2.165 -1.25 Mabsadd L
.42381 .30563 0 2.5 Mabsadd L closepath F
.42698 .30664 0 2.5 Mabsadd m
.42698 .30664 -2.165 -1.25 Mabsadd L
.42698 .30664 2.165 -1.25 Mabsadd L
.42698 .30664 0 2.5 Mabsadd L closepath F
.43016 .30765 0 2.5 Mabsadd m
.43016 .30765 -2.165 -1.25 Mabsadd L
.43016 .30765 2.165 -1.25 Mabsadd L
.43016 .30765 0 2.5 Mabsadd L closepath F
.43333 .30868 0 2.5 Mabsadd m
.43333 .30868 -2.165 -1.25 Mabsadd L
.43333 .30868 2.165 -1.25 Mabsadd L
.43333 .30868 0 2.5 Mabsadd L closepath F
.43651 .30972 0 2.5 Mabsadd m
.43651 .30972 -2.165 -1.25 Mabsadd L
.43651 .30972 2.165 -1.25 Mabsadd L
.43651 .30972 0 2.5 Mabsadd L closepath F
.43968 .31077 0 2.5 Mabsadd m
.43968 .31077 -2.165 -1.25 Mabsadd L
.43968 .31077 2.165 -1.25 Mabsadd L
.43968 .31077 0 2.5 Mabsadd L closepath F
.44286 .31183 0 2.5 Mabsadd m
.44286 .31183 -2.165 -1.25 Mabsadd L
.44286 .31183 2.165 -1.25 Mabsadd L
.44286 .31183 0 2.5 Mabsadd L closepath F
.44603 .31291 0 2.5 Mabsadd m
.44603 .31291 -2.165 -1.25 Mabsadd L
.44603 .31291 2.165 -1.25 Mabsadd L
.44603 .31291 0 2.5 Mabsadd L closepath F
.44921 .31399 0 2.5 Mabsadd m
.44921 .31399 -2.165 -1.25 Mabsadd L
.44921 .31399 2.165 -1.25 Mabsadd L
.44921 .31399 0 2.5 Mabsadd L closepath F
.45238 .31508 0 2.5 Mabsadd m
.45238 .31508 -2.165 -1.25 Mabsadd L
.45238 .31508 2.165 -1.25 Mabsadd L
.45238 .31508 0 2.5 Mabsadd L closepath F
.45556 .31618 0 2.5 Mabsadd m
.45556 .31618 -2.165 -1.25 Mabsadd L
.45556 .31618 2.165 -1.25 Mabsadd L
.45556 .31618 0 2.5 Mabsadd L closepath F
.45873 .3173 0 2.5 Mabsadd m
.45873 .3173 -2.165 -1.25 Mabsadd L
.45873 .3173 2.165 -1.25 Mabsadd L
.45873 .3173 0 2.5 Mabsadd L closepath F
.4619 .31842 0 2.5 Mabsadd m
.4619 .31842 -2.165 -1.25 Mabsadd L
.4619 .31842 2.165 -1.25 Mabsadd L
.4619 .31842 0 2.5 Mabsadd L closepath F
.46508 .31956 0 2.5 Mabsadd m
.46508 .31956 -2.165 -1.25 Mabsadd L
.46508 .31956 2.165 -1.25 Mabsadd L
.46508 .31956 0 2.5 Mabsadd L closepath F
.46825 .32071 0 2.5 Mabsadd m
.46825 .32071 -2.165 -1.25 Mabsadd L
.46825 .32071 2.165 -1.25 Mabsadd L
.46825 .32071 0 2.5 Mabsadd L closepath F
.47143 .32187 0 2.5 Mabsadd m
.47143 .32187 -2.165 -1.25 Mabsadd L
.47143 .32187 2.165 -1.25 Mabsadd L
.47143 .32187 0 2.5 Mabsadd L closepath F
.4746 .32304 0 2.5 Mabsadd m
.4746 .32304 -2.165 -1.25 Mabsadd L
.4746 .32304 2.165 -1.25 Mabsadd L
.4746 .32304 0 2.5 Mabsadd L closepath F
.47778 .32423 0 2.5 Mabsadd m
.47778 .32423 -2.165 -1.25 Mabsadd L
.47778 .32423 2.165 -1.25 Mabsadd L
.47778 .32423 0 2.5 Mabsadd L closepath F
.48095 .32542 0 2.5 Mabsadd m
.48095 .32542 -2.165 -1.25 Mabsadd L
.48095 .32542 2.165 -1.25 Mabsadd L
.48095 .32542 0 2.5 Mabsadd L closepath F
.48413 .32663 0 2.5 Mabsadd m
.48413 .32663 -2.165 -1.25 Mabsadd L
.48413 .32663 2.165 -1.25 Mabsadd L
.48413 .32663 0 2.5 Mabsadd L closepath F
.4873 .32785 0 2.5 Mabsadd m
.4873 .32785 -2.165 -1.25 Mabsadd L
.4873 .32785 2.165 -1.25 Mabsadd L
.4873 .32785 0 2.5 Mabsadd L closepath F
.49048 .32908 0 2.5 Mabsadd m
.49048 .32908 -2.165 -1.25 Mabsadd L
.49048 .32908 2.165 -1.25 Mabsadd L
.49048 .32908 0 2.5 Mabsadd L closepath F
.49365 .33032 0 2.5 Mabsadd m
.49365 .33032 -2.165 -1.25 Mabsadd L
.49365 .33032 2.165 -1.25 Mabsadd L
.49365 .33032 0 2.5 Mabsadd L closepath F
.49683 .33158 0 2.5 Mabsadd m
.49683 .33158 -2.165 -1.25 Mabsadd L
.49683 .33158 2.165 -1.25 Mabsadd L
.49683 .33158 0 2.5 Mabsadd L closepath F
.5 .33285 0 2.5 Mabsadd m
.5 .33285 -2.165 -1.25 Mabsadd L
.5 .33285 2.165 -1.25 Mabsadd L
.5 .33285 0 2.5 Mabsadd L closepath F
.50317 .33413 0 2.5 Mabsadd m
.50317 .33413 -2.165 -1.25 Mabsadd L
.50317 .33413 2.165 -1.25 Mabsadd L
.50317 .33413 0 2.5 Mabsadd L closepath F
.50635 .33542 0 2.5 Mabsadd m
.50635 .33542 -2.165 -1.25 Mabsadd L
.50635 .33542 2.165 -1.25 Mabsadd L
.50635 .33542 0 2.5 Mabsadd L closepath F
.50952 .33673 0 2.5 Mabsadd m
.50952 .33673 -2.165 -1.25 Mabsadd L
.50952 .33673 2.165 -1.25 Mabsadd L
.50952 .33673 0 2.5 Mabsadd L closepath F
.5127 .33805 0 2.5 Mabsadd m
.5127 .33805 -2.165 -1.25 Mabsadd L
.5127 .33805 2.165 -1.25 Mabsadd L
.5127 .33805 0 2.5 Mabsadd L closepath F
.51587 .33938 0 2.5 Mabsadd m
.51587 .33938 -2.165 -1.25 Mabsadd L
.51587 .33938 2.165 -1.25 Mabsadd L
.51587 .33938 0 2.5 Mabsadd L closepath F
.51905 .34073 0 2.5 Mabsadd m
.51905 .34073 -2.165 -1.25 Mabsadd L
.51905 .34073 2.165 -1.25 Mabsadd L
.51905 .34073 0 2.5 Mabsadd L closepath F
.52222 .34209 0 2.5 Mabsadd m
.52222 .34209 -2.165 -1.25 Mabsadd L
.52222 .34209 2.165 -1.25 Mabsadd L
.52222 .34209 0 2.5 Mabsadd L closepath F
.5254 .34346 0 2.5 Mabsadd m
.5254 .34346 -2.165 -1.25 Mabsadd L
.5254 .34346 2.165 -1.25 Mabsadd L
.5254 .34346 0 2.5 Mabsadd L closepath F
.52857 .34485 0 2.5 Mabsadd m
.52857 .34485 -2.165 -1.25 Mabsadd L
.52857 .34485 2.165 -1.25 Mabsadd L
.52857 .34485 0 2.5 Mabsadd L closepath F
.53175 .34625 0 2.5 Mabsadd m
.53175 .34625 -2.165 -1.25 Mabsadd L
.53175 .34625 2.165 -1.25 Mabsadd L
.53175 .34625 0 2.5 Mabsadd L closepath F
.53492 .34767 0 2.5 Mabsadd m
.53492 .34767 -2.165 -1.25 Mabsadd L
.53492 .34767 2.165 -1.25 Mabsadd L
.53492 .34767 0 2.5 Mabsadd L closepath F
.5381 .3491 0 2.5 Mabsadd m
.5381 .3491 -2.165 -1.25 Mabsadd L
.5381 .3491 2.165 -1.25 Mabsadd L
.5381 .3491 0 2.5 Mabsadd L closepath F
.54127 .35054 0 2.5 Mabsadd m
.54127 .35054 -2.165 -1.25 Mabsadd L
.54127 .35054 2.165 -1.25 Mabsadd L
.54127 .35054 0 2.5 Mabsadd L closepath F
.54444 .352 0 2.5 Mabsadd m
.54444 .352 -2.165 -1.25 Mabsadd L
.54444 .352 2.165 -1.25 Mabsadd L
.54444 .352 0 2.5 Mabsadd L closepath F
.54762 .35347 0 2.5 Mabsadd m
.54762 .35347 -2.165 -1.25 Mabsadd L
.54762 .35347 2.165 -1.25 Mabsadd L
.54762 .35347 0 2.5 Mabsadd L closepath F
.55079 .35496 0 2.5 Mabsadd m
.55079 .35496 -2.165 -1.25 Mabsadd L
.55079 .35496 2.165 -1.25 Mabsadd L
.55079 .35496 0 2.5 Mabsadd L closepath F
.55397 .35646 0 2.5 Mabsadd m
.55397 .35646 -2.165 -1.25 Mabsadd L
.55397 .35646 2.165 -1.25 Mabsadd L
.55397 .35646 0 2.5 Mabsadd L closepath F
.55714 .35798 0 2.5 Mabsadd m
.55714 .35798 -2.165 -1.25 Mabsadd L
.55714 .35798 2.165 -1.25 Mabsadd L
.55714 .35798 0 2.5 Mabsadd L closepath F
.56032 .35951 0 2.5 Mabsadd m
.56032 .35951 -2.165 -1.25 Mabsadd L
.56032 .35951 2.165 -1.25 Mabsadd L
.56032 .35951 0 2.5 Mabsadd L closepath F
.56349 .36106 0 2.5 Mabsadd m
.56349 .36106 -2.165 -1.25 Mabsadd L
.56349 .36106 2.165 -1.25 Mabsadd L
.56349 .36106 0 2.5 Mabsadd L closepath F
.56667 .36262 0 2.5 Mabsadd m
.56667 .36262 -2.165 -1.25 Mabsadd L
.56667 .36262 2.165 -1.25 Mabsadd L
.56667 .36262 0 2.5 Mabsadd L closepath F
.56984 .3642 0 2.5 Mabsadd m
.56984 .3642 -2.165 -1.25 Mabsadd L
.56984 .3642 2.165 -1.25 Mabsadd L
.56984 .3642 0 2.5 Mabsadd L closepath F
.57302 .3658 0 2.5 Mabsadd m
.57302 .3658 -2.165 -1.25 Mabsadd L
.57302 .3658 2.165 -1.25 Mabsadd L
.57302 .3658 0 2.5 Mabsadd L closepath F
.57619 .36741 0 2.5 Mabsadd m
.57619 .36741 -2.165 -1.25 Mabsadd L
.57619 .36741 2.165 -1.25 Mabsadd L
.57619 .36741 0 2.5 Mabsadd L closepath F
.57937 .36904 0 2.5 Mabsadd m
.57937 .36904 -2.165 -1.25 Mabsadd L
.57937 .36904 2.165 -1.25 Mabsadd L
.57937 .36904 0 2.5 Mabsadd L closepath F
.58254 .37068 0 2.5 Mabsadd m
.58254 .37068 -2.165 -1.25 Mabsadd L
.58254 .37068 2.165 -1.25 Mabsadd L
.58254 .37068 0 2.5 Mabsadd L closepath F
.58571 .37234 0 2.5 Mabsadd m
.58571 .37234 -2.165 -1.25 Mabsadd L
.58571 .37234 2.165 -1.25 Mabsadd L
.58571 .37234 0 2.5 Mabsadd L closepath F
.58889 .37401 0 2.5 Mabsadd m
.58889 .37401 -2.165 -1.25 Mabsadd L
.58889 .37401 2.165 -1.25 Mabsadd L
.58889 .37401 0 2.5 Mabsadd L closepath F
.59206 .37571 0 2.5 Mabsadd m
.59206 .37571 -2.165 -1.25 Mabsadd L
.59206 .37571 2.165 -1.25 Mabsadd L
.59206 .37571 0 2.5 Mabsadd L closepath F
.59524 .37742 0 2.5 Mabsadd m
.59524 .37742 -2.165 -1.25 Mabsadd L
.59524 .37742 2.165 -1.25 Mabsadd L
.59524 .37742 0 2.5 Mabsadd L closepath F
.59841 .37914 0 2.5 Mabsadd m
.59841 .37914 -2.165 -1.25 Mabsadd L
.59841 .37914 2.165 -1.25 Mabsadd L
.59841 .37914 0 2.5 Mabsadd L closepath F
.60159 .38089 0 2.5 Mabsadd m
.60159 .38089 -2.165 -1.25 Mabsadd L
.60159 .38089 2.165 -1.25 Mabsadd L
.60159 .38089 0 2.5 Mabsadd L closepath F
.60476 .38265 0 2.5 Mabsadd m
.60476 .38265 -2.165 -1.25 Mabsadd L
.60476 .38265 2.165 -1.25 Mabsadd L
.60476 .38265 0 2.5 Mabsadd L closepath F
.60794 .38443 0 2.5 Mabsadd m
.60794 .38443 -2.165 -1.25 Mabsadd L
.60794 .38443 2.165 -1.25 Mabsadd L
.60794 .38443 0 2.5 Mabsadd L closepath F
.61111 .38623 0 2.5 Mabsadd m
.61111 .38623 -2.165 -1.25 Mabsadd L
.61111 .38623 2.165 -1.25 Mabsadd L
.61111 .38623 0 2.5 Mabsadd L closepath F
.61429 .38804 0 2.5 Mabsadd m
.61429 .38804 -2.165 -1.25 Mabsadd L
.61429 .38804 2.165 -1.25 Mabsadd L
.61429 .38804 0 2.5 Mabsadd L closepath F
.61746 .38988 0 2.5 Mabsadd m
.61746 .38988 -2.165 -1.25 Mabsadd L
.61746 .38988 2.165 -1.25 Mabsadd L
.61746 .38988 0 2.5 Mabsadd L closepath F
.62063 .39173 0 2.5 Mabsadd m
.62063 .39173 -2.165 -1.25 Mabsadd L
.62063 .39173 2.165 -1.25 Mabsadd L
.62063 .39173 0 2.5 Mabsadd L closepath F
.62381 .3936 0 2.5 Mabsadd m
.62381 .3936 -2.165 -1.25 Mabsadd L
.62381 .3936 2.165 -1.25 Mabsadd L
.62381 .3936 0 2.5 Mabsadd L closepath F
.62698 .39549 0 2.5 Mabsadd m
.62698 .39549 -2.165 -1.25 Mabsadd L
.62698 .39549 2.165 -1.25 Mabsadd L
.62698 .39549 0 2.5 Mabsadd L closepath F
.63016 .39739 0 2.5 Mabsadd m
.63016 .39739 -2.165 -1.25 Mabsadd L
.63016 .39739 2.165 -1.25 Mabsadd L
.63016 .39739 0 2.5 Mabsadd L closepath F
.63333 .39932 0 2.5 Mabsadd m
.63333 .39932 -2.165 -1.25 Mabsadd L
.63333 .39932 2.165 -1.25 Mabsadd L
.63333 .39932 0 2.5 Mabsadd L closepath F
.63651 .40127 0 2.5 Mabsadd m
.63651 .40127 -2.165 -1.25 Mabsadd L
.63651 .40127 2.165 -1.25 Mabsadd L
.63651 .40127 0 2.5 Mabsadd L closepath F
.63968 .40323 0 2.5 Mabsadd m
.63968 .40323 -2.165 -1.25 Mabsadd L
.63968 .40323 2.165 -1.25 Mabsadd L
.63968 .40323 0 2.5 Mabsadd L closepath F
.64286 .40522 0 2.5 Mabsadd m
.64286 .40522 -2.165 -1.25 Mabsadd L
.64286 .40522 2.165 -1.25 Mabsadd L
.64286 .40522 0 2.5 Mabsadd L closepath F
.64603 .40722 0 2.5 Mabsadd m
.64603 .40722 -2.165 -1.25 Mabsadd L
.64603 .40722 2.165 -1.25 Mabsadd L
.64603 .40722 0 2.5 Mabsadd L closepath F
.64921 .40925 0 2.5 Mabsadd m
.64921 .40925 -2.165 -1.25 Mabsadd L
.64921 .40925 2.165 -1.25 Mabsadd L
.64921 .40925 0 2.5 Mabsadd L closepath F
.65238 .41129 0 2.5 Mabsadd m
.65238 .41129 -2.165 -1.25 Mabsadd L
.65238 .41129 2.165 -1.25 Mabsadd L
.65238 .41129 0 2.5 Mabsadd L closepath F
.65556 .41336 0 2.5 Mabsadd m
.65556 .41336 -2.165 -1.25 Mabsadd L
.65556 .41336 2.165 -1.25 Mabsadd L
.65556 .41336 0 2.5 Mabsadd L closepath F
.65873 .41545 0 2.5 Mabsadd m
.65873 .41545 -2.165 -1.25 Mabsadd L
.65873 .41545 2.165 -1.25 Mabsadd L
.65873 .41545 0 2.5 Mabsadd L closepath F
.6619 .41755 0 2.5 Mabsadd m
.6619 .41755 -2.165 -1.25 Mabsadd L
.6619 .41755 2.165 -1.25 Mabsadd L
.6619 .41755 0 2.5 Mabsadd L closepath F
.66508 .41968 0 2.5 Mabsadd m
.66508 .41968 -2.165 -1.25 Mabsadd L
.66508 .41968 2.165 -1.25 Mabsadd L
.66508 .41968 0 2.5 Mabsadd L closepath F
.66825 .42183 0 2.5 Mabsadd m
.66825 .42183 -2.165 -1.25 Mabsadd L
.66825 .42183 2.165 -1.25 Mabsadd L
.66825 .42183 0 2.5 Mabsadd L closepath F
.67143 .424 0 2.5 Mabsadd m
.67143 .424 -2.165 -1.25 Mabsadd L
.67143 .424 2.165 -1.25 Mabsadd L
.67143 .424 0 2.5 Mabsadd L closepath F
.6746 .42619 0 2.5 Mabsadd m
.6746 .42619 -2.165 -1.25 Mabsadd L
.6746 .42619 2.165 -1.25 Mabsadd L
.6746 .42619 0 2.5 Mabsadd L closepath F
.67778 .42841 0 2.5 Mabsadd m
.67778 .42841 -2.165 -1.25 Mabsadd L
.67778 .42841 2.165 -1.25 Mabsadd L
.67778 .42841 0 2.5 Mabsadd L closepath F
.68095 .43065 0 2.5 Mabsadd m
.68095 .43065 -2.165 -1.25 Mabsadd L
.68095 .43065 2.165 -1.25 Mabsadd L
.68095 .43065 0 2.5 Mabsadd L closepath F
.68413 .43291 0 2.5 Mabsadd m
.68413 .43291 -2.165 -1.25 Mabsadd L
.68413 .43291 2.165 -1.25 Mabsadd L
.68413 .43291 0 2.5 Mabsadd L closepath F
.6873 .43519 0 2.5 Mabsadd m
.6873 .43519 -2.165 -1.25 Mabsadd L
.6873 .43519 2.165 -1.25 Mabsadd L
.6873 .43519 0 2.5 Mabsadd L closepath F
.69048 .43749 0 2.5 Mabsadd m
.69048 .43749 -2.165 -1.25 Mabsadd L
.69048 .43749 2.165 -1.25 Mabsadd L
.69048 .43749 0 2.5 Mabsadd L closepath F
.69365 .43982 0 2.5 Mabsadd m
.69365 .43982 -2.165 -1.25 Mabsadd L
.69365 .43982 2.165 -1.25 Mabsadd L
.69365 .43982 0 2.5 Mabsadd L closepath F
.69683 .44217 0 2.5 Mabsadd m
.69683 .44217 -2.165 -1.25 Mabsadd L
.69683 .44217 2.165 -1.25 Mabsadd L
.69683 .44217 0 2.5 Mabsadd L closepath F
.7 .44455 0 2.5 Mabsadd m
.7 .44455 -2.165 -1.25 Mabsadd L
.7 .44455 2.165 -1.25 Mabsadd L
.7 .44455 0 2.5 Mabsadd L closepath F
.70317 .44694 0 2.5 Mabsadd m
.70317 .44694 -2.165 -1.25 Mabsadd L
.70317 .44694 2.165 -1.25 Mabsadd L
.70317 .44694 0 2.5 Mabsadd L closepath F
.70635 .44937 0 2.5 Mabsadd m
.70635 .44937 -2.165 -1.25 Mabsadd L
.70635 .44937 2.165 -1.25 Mabsadd L
.70635 .44937 0 2.5 Mabsadd L closepath F
.70952 .45181 0 2.5 Mabsadd m
.70952 .45181 -2.165 -1.25 Mabsadd L
.70952 .45181 2.165 -1.25 Mabsadd L
.70952 .45181 0 2.5 Mabsadd L closepath F
.7127 .45428 0 2.5 Mabsadd m
.7127 .45428 -2.165 -1.25 Mabsadd L
.7127 .45428 2.165 -1.25 Mabsadd L
.7127 .45428 0 2.5 Mabsadd L closepath F
.71587 .45678 0 2.5 Mabsadd m
.71587 .45678 -2.165 -1.25 Mabsadd L
.71587 .45678 2.165 -1.25 Mabsadd L
.71587 .45678 0 2.5 Mabsadd L closepath F
.71905 .4593 0 2.5 Mabsadd m
.71905 .4593 -2.165 -1.25 Mabsadd L
.71905 .4593 2.165 -1.25 Mabsadd L
.71905 .4593 0 2.5 Mabsadd L closepath F
.72222 .46185 0 2.5 Mabsadd m
.72222 .46185 -2.165 -1.25 Mabsadd L
.72222 .46185 2.165 -1.25 Mabsadd L
.72222 .46185 0 2.5 Mabsadd L closepath F
.7254 .46442 0 2.5 Mabsadd m
.7254 .46442 -2.165 -1.25 Mabsadd L
.7254 .46442 2.165 -1.25 Mabsadd L
.7254 .46442 0 2.5 Mabsadd L closepath F
.72857 .46701 0 2.5 Mabsadd m
.72857 .46701 -2.165 -1.25 Mabsadd L
.72857 .46701 2.165 -1.25 Mabsadd L
.72857 .46701 0 2.5 Mabsadd L closepath F
.73175 .46964 0 2.5 Mabsadd m
.73175 .46964 -2.165 -1.25 Mabsadd L
.73175 .46964 2.165 -1.25 Mabsadd L
.73175 .46964 0 2.5 Mabsadd L closepath F
.73492 .47229 0 2.5 Mabsadd m
.73492 .47229 -2.165 -1.25 Mabsadd L
.73492 .47229 2.165 -1.25 Mabsadd L
.73492 .47229 0 2.5 Mabsadd L closepath F
.7381 .47496 0 2.5 Mabsadd m
.7381 .47496 -2.165 -1.25 Mabsadd L
.7381 .47496 2.165 -1.25 Mabsadd L
.7381 .47496 0 2.5 Mabsadd L closepath F
.74127 .47767 0 2.5 Mabsadd m
.74127 .47767 -2.165 -1.25 Mabsadd L
.74127 .47767 2.165 -1.25 Mabsadd L
.74127 .47767 0 2.5 Mabsadd L closepath F
.74444 .48039 0 2.5 Mabsadd m
.74444 .48039 -2.165 -1.25 Mabsadd L
.74444 .48039 2.165 -1.25 Mabsadd L
.74444 .48039 0 2.5 Mabsadd L closepath F
.74762 .48315 0 2.5 Mabsadd m
.74762 .48315 -2.165 -1.25 Mabsadd L
.74762 .48315 2.165 -1.25 Mabsadd L
.74762 .48315 0 2.5 Mabsadd L closepath F
.75079 .48594 0 2.5 Mabsadd m
.75079 .48594 -2.165 -1.25 Mabsadd L
.75079 .48594 2.165 -1.25 Mabsadd L
.75079 .48594 0 2.5 Mabsadd L closepath F
.75397 .48875 0 2.5 Mabsadd m
.75397 .48875 -2.165 -1.25 Mabsadd L
.75397 .48875 2.165 -1.25 Mabsadd L
.75397 .48875 0 2.5 Mabsadd L closepath F
.75714 .49159 0 2.5 Mabsadd m
.75714 .49159 -2.165 -1.25 Mabsadd L
.75714 .49159 2.165 -1.25 Mabsadd L
.75714 .49159 0 2.5 Mabsadd L closepath F
.76032 .49446 0 2.5 Mabsadd m
.76032 .49446 -2.165 -1.25 Mabsadd L
.76032 .49446 2.165 -1.25 Mabsadd L
.76032 .49446 0 2.5 Mabsadd L closepath F
.76349 .49735 0 2.5 Mabsadd m
.76349 .49735 -2.165 -1.25 Mabsadd L
.76349 .49735 2.165 -1.25 Mabsadd L
.76349 .49735 0 2.5 Mabsadd L closepath F
.76667 .50028 0 2.5 Mabsadd m
.76667 .50028 -2.165 -1.25 Mabsadd L
.76667 .50028 2.165 -1.25 Mabsadd L
.76667 .50028 0 2.5 Mabsadd L closepath F
.76984 .50324 0 2.5 Mabsadd m
.76984 .50324 -2.165 -1.25 Mabsadd L
.76984 .50324 2.165 -1.25 Mabsadd L
.76984 .50324 0 2.5 Mabsadd L closepath F
.77302 .50622 0 2.5 Mabsadd m
.77302 .50622 -2.165 -1.25 Mabsadd L
.77302 .50622 2.165 -1.25 Mabsadd L
.77302 .50622 0 2.5 Mabsadd L closepath F
.77619 .50924 0 2.5 Mabsadd m
.77619 .50924 -2.165 -1.25 Mabsadd L
.77619 .50924 2.165 -1.25 Mabsadd L
.77619 .50924 0 2.5 Mabsadd L closepath F
.77937 .51228 0 2.5 Mabsadd m
.77937 .51228 -2.165 -1.25 Mabsadd L
.77937 .51228 2.165 -1.25 Mabsadd L
.77937 .51228 0 2.5 Mabsadd L closepath F
.78254 .51536 0 2.5 Mabsadd m
.78254 .51536 -2.165 -1.25 Mabsadd L
.78254 .51536 2.165 -1.25 Mabsadd L
.78254 .51536 0 2.5 Mabsadd L closepath F
.78571 .51846 0 2.5 Mabsadd m
.78571 .51846 -2.165 -1.25 Mabsadd L
.78571 .51846 2.165 -1.25 Mabsadd L
.78571 .51846 0 2.5 Mabsadd L closepath F
.78889 .5216 0 2.5 Mabsadd m
.78889 .5216 -2.165 -1.25 Mabsadd L
.78889 .5216 2.165 -1.25 Mabsadd L
.78889 .5216 0 2.5 Mabsadd L closepath F
.79206 .52477 0 2.5 Mabsadd m
.79206 .52477 -2.165 -1.25 Mabsadd L
.79206 .52477 2.165 -1.25 Mabsadd L
.79206 .52477 0 2.5 Mabsadd L closepath F
.79524 .52797 0 2.5 Mabsadd m
.79524 .52797 -2.165 -1.25 Mabsadd L
.79524 .52797 2.165 -1.25 Mabsadd L
.79524 .52797 0 2.5 Mabsadd L closepath F
.79841 .5312 0 2.5 Mabsadd m
.79841 .5312 -2.165 -1.25 Mabsadd L
.79841 .5312 2.165 -1.25 Mabsadd L
.79841 .5312 0 2.5 Mabsadd L closepath F
.80159 .53447 0 2.5 Mabsadd m
.80159 .53447 -2.165 -1.25 Mabsadd L
.80159 .53447 2.165 -1.25 Mabsadd L
.80159 .53447 0 2.5 Mabsadd L closepath F
.80476 .53777 0 2.5 Mabsadd m
.80476 .53777 -2.165 -1.25 Mabsadd L
.80476 .53777 2.165 -1.25 Mabsadd L
.80476 .53777 0 2.5 Mabsadd L closepath F
.80794 .5411 0 2.5 Mabsadd m
.80794 .5411 -2.165 -1.25 Mabsadd L
.80794 .5411 2.165 -1.25 Mabsadd L
.80794 .5411 0 2.5 Mabsadd L closepath F
.81111 .54446 0 2.5 Mabsadd m
.81111 .54446 -2.165 -1.25 Mabsadd L
.81111 .54446 2.165 -1.25 Mabsadd L
.81111 .54446 0 2.5 Mabsadd L closepath F
.81429 .54786 0 2.5 Mabsadd m
.81429 .54786 -2.165 -1.25 Mabsadd L
.81429 .54786 2.165 -1.25 Mabsadd L
.81429 .54786 0 2.5 Mabsadd L closepath F
.81746 .55129 0 2.5 Mabsadd m
.81746 .55129 -2.165 -1.25 Mabsadd L
.81746 .55129 2.165 -1.25 Mabsadd L
.81746 .55129 0 2.5 Mabsadd L closepath F
.82063 .55476 0 2.5 Mabsadd m
.82063 .55476 -2.165 -1.25 Mabsadd L
.82063 .55476 2.165 -1.25 Mabsadd L
.82063 .55476 0 2.5 Mabsadd L closepath F
.82381 .55826 0 2.5 Mabsadd m
.82381 .55826 -2.165 -1.25 Mabsadd L
.82381 .55826 2.165 -1.25 Mabsadd L
.82381 .55826 0 2.5 Mabsadd L closepath F
.82698 .56179 0 2.5 Mabsadd m
.82698 .56179 -2.165 -1.25 Mabsadd L
.82698 .56179 2.165 -1.25 Mabsadd L
.82698 .56179 0 2.5 Mabsadd L closepath F
.83016 .56536 0 2.5 Mabsadd m
.83016 .56536 -2.165 -1.25 Mabsadd L
.83016 .56536 2.165 -1.25 Mabsadd L
.83016 .56536 0 2.5 Mabsadd L closepath F
.83333 .56897 0 2.5 Mabsadd m
.83333 .56897 -2.165 -1.25 Mabsadd L
.83333 .56897 2.165 -1.25 Mabsadd L
.83333 .56897 0 2.5 Mabsadd L closepath F
.83651 .57261 0 2.5 Mabsadd m
.83651 .57261 -2.165 -1.25 Mabsadd L
.83651 .57261 2.165 -1.25 Mabsadd L
.83651 .57261 0 2.5 Mabsadd L closepath F
.83968 .57629 0 2.5 Mabsadd m
.83968 .57629 -2.165 -1.25 Mabsadd L
.83968 .57629 2.165 -1.25 Mabsadd L
.83968 .57629 0 2.5 Mabsadd L closepath F
.84286 .58001 0 2.5 Mabsadd m
.84286 .58001 -2.165 -1.25 Mabsadd L
.84286 .58001 2.165 -1.25 Mabsadd L
.84286 .58001 0 2.5 Mabsadd L closepath F
.84603 .58376 0 2.5 Mabsadd m
.84603 .58376 -2.165 -1.25 Mabsadd L
.84603 .58376 2.165 -1.25 Mabsadd L
.84603 .58376 0 2.5 Mabsadd L closepath F
.84921 .58755 0 2.5 Mabsadd m
.84921 .58755 -2.165 -1.25 Mabsadd L
.84921 .58755 2.165 -1.25 Mabsadd L
.84921 .58755 0 2.5 Mabsadd L closepath F
.85238 .59138 0 2.5 Mabsadd m
.85238 .59138 -2.165 -1.25 Mabsadd L
.85238 .59138 2.165 -1.25 Mabsadd L
.85238 .59138 0 2.5 Mabsadd L closepath F
.85556 .59524 0 2.5 Mabsadd m
.85556 .59524 -2.165 -1.25 Mabsadd L
.85556 .59524 2.165 -1.25 Mabsadd L
.85556 .59524 0 2.5 Mabsadd L closepath F
.85873 .59915 0 2.5 Mabsadd m
.85873 .59915 -2.165 -1.25 Mabsadd L
.85873 .59915 2.165 -1.25 Mabsadd L
.85873 .59915 0 2.5 Mabsadd L closepath F
.8619 .60309 0 2.5 Mabsadd m
.8619 .60309 -2.165 -1.25 Mabsadd L
.8619 .60309 2.165 -1.25 Mabsadd L
.8619 .60309 0 2.5 Mabsadd L closepath F
.86508 .60708 0 2.5 Mabsadd m
.86508 .60708 -2.165 -1.25 Mabsadd L
.86508 .60708 2.165 -1.25 Mabsadd L
.86508 .60708 0 2.5 Mabsadd L closepath F
.86825 .6111 0 2.5 Mabsadd m
.86825 .6111 -2.165 -1.25 Mabsadd L
.86825 .6111 2.165 -1.25 Mabsadd L
.86825 .6111 0 2.5 Mabsadd L closepath F
.87143 .61517 0 2.5 Mabsadd m
.87143 .61517 -2.165 -1.25 Mabsadd L
.87143 .61517 2.165 -1.25 Mabsadd L
.87143 .61517 0 2.5 Mabsadd L closepath F
.8746 .61927 0 2.5 Mabsadd m
.8746 .61927 -2.165 -1.25 Mabsadd L
.8746 .61927 2.165 -1.25 Mabsadd L
.8746 .61927 0 2.5 Mabsadd L closepath F
.87778 .62342 0 2.5 Mabsadd m
.87778 .62342 -2.165 -1.25 Mabsadd L
.87778 .62342 2.165 -1.25 Mabsadd L
.87778 .62342 0 2.5 Mabsadd L closepath F
.88095 .6276 0 2.5 Mabsadd m
.88095 .6276 -2.165 -1.25 Mabsadd L
.88095 .6276 2.165 -1.25 Mabsadd L
.88095 .6276 0 2.5 Mabsadd L closepath F
.88413 .63183 0 2.5 Mabsadd m
.88413 .63183 -2.165 -1.25 Mabsadd L
.88413 .63183 2.165 -1.25 Mabsadd L
.88413 .63183 0 2.5 Mabsadd L closepath F
.8873 .6361 0 2.5 Mabsadd m
.8873 .6361 -2.165 -1.25 Mabsadd L
.8873 .6361 2.165 -1.25 Mabsadd L
.8873 .6361 0 2.5 Mabsadd L closepath F
.89048 .64042 0 2.5 Mabsadd m
.89048 .64042 -2.165 -1.25 Mabsadd L
.89048 .64042 2.165 -1.25 Mabsadd L
.89048 .64042 0 2.5 Mabsadd L closepath F
.89365 .64477 0 2.5 Mabsadd m
.89365 .64477 -2.165 -1.25 Mabsadd L
.89365 .64477 2.165 -1.25 Mabsadd L
.89365 .64477 0 2.5 Mabsadd L closepath F
.89683 .64917 0 2.5 Mabsadd m
.89683 .64917 -2.165 -1.25 Mabsadd L
.89683 .64917 2.165 -1.25 Mabsadd L
.89683 .64917 0 2.5 Mabsadd L closepath F
.9 .65362 0 2.5 Mabsadd m
.9 .65362 -2.165 -1.25 Mabsadd L
.9 .65362 2.165 -1.25 Mabsadd L
.9 .65362 0 2.5 Mabsadd L closepath F
.90317 .65811 0 2.5 Mabsadd m
.90317 .65811 -2.165 -1.25 Mabsadd L
.90317 .65811 2.165 -1.25 Mabsadd L
.90317 .65811 0 2.5 Mabsadd L closepath F
.90635 .66264 0 2.5 Mabsadd m
.90635 .66264 -2.165 -1.25 Mabsadd L
.90635 .66264 2.165 -1.25 Mabsadd L
.90635 .66264 0 2.5 Mabsadd L closepath F
.90952 .66722 0 2.5 Mabsadd m
.90952 .66722 -2.165 -1.25 Mabsadd L
.90952 .66722 2.165 -1.25 Mabsadd L
.90952 .66722 0 2.5 Mabsadd L closepath F
.9127 .67185 0 2.5 Mabsadd m
.9127 .67185 -2.165 -1.25 Mabsadd L
.9127 .67185 2.165 -1.25 Mabsadd L
.9127 .67185 0 2.5 Mabsadd L closepath F
.91587 .67652 0 2.5 Mabsadd m
.91587 .67652 -2.165 -1.25 Mabsadd L
.91587 .67652 2.165 -1.25 Mabsadd L
.91587 .67652 0 2.5 Mabsadd L closepath F
.91905 .68124 0 2.5 Mabsadd m
.91905 .68124 -2.165 -1.25 Mabsadd L
.91905 .68124 2.165 -1.25 Mabsadd L
.91905 .68124 0 2.5 Mabsadd L closepath F
.92222 .686 0 2.5 Mabsadd m
.92222 .686 -2.165 -1.25 Mabsadd L
.92222 .686 2.165 -1.25 Mabsadd L
.92222 .686 0 2.5 Mabsadd L closepath F
.9254 .69081 0 2.5 Mabsadd m
.9254 .69081 -2.165 -1.25 Mabsadd L
.9254 .69081 2.165 -1.25 Mabsadd L
.9254 .69081 0 2.5 Mabsadd L closepath F
.92857 .69568 0 2.5 Mabsadd m
.92857 .69568 -2.165 -1.25 Mabsadd L
.92857 .69568 2.165 -1.25 Mabsadd L
.92857 .69568 0 2.5 Mabsadd L closepath F
.93175 .70058 0 2.5 Mabsadd m
.93175 .70058 -2.165 -1.25 Mabsadd L
.93175 .70058 2.165 -1.25 Mabsadd L
.93175 .70058 0 2.5 Mabsadd L closepath F
.93492 .70554 0 2.5 Mabsadd m
.93492 .70554 -2.165 -1.25 Mabsadd L
.93492 .70554 2.165 -1.25 Mabsadd L
.93492 .70554 0 2.5 Mabsadd L closepath F
.9381 .71055 0 2.5 Mabsadd m
.9381 .71055 -2.165 -1.25 Mabsadd L
.9381 .71055 2.165 -1.25 Mabsadd L
.9381 .71055 0 2.5 Mabsadd L closepath F
.94127 .71561 0 2.5 Mabsadd m
.94127 .71561 -2.165 -1.25 Mabsadd L
.94127 .71561 2.165 -1.25 Mabsadd L
.94127 .71561 0 2.5 Mabsadd L closepath F
.94444 .72072 0 2.5 Mabsadd m
.94444 .72072 -2.165 -1.25 Mabsadd L
.94444 .72072 2.165 -1.25 Mabsadd L
.94444 .72072 0 2.5 Mabsadd L closepath F
.94762 .72588 0 2.5 Mabsadd m
.94762 .72588 -2.165 -1.25 Mabsadd L
.94762 .72588 2.165 -1.25 Mabsadd L
.94762 .72588 0 2.5 Mabsadd L closepath F
.95079 .73109 0 2.5 Mabsadd m
.95079 .73109 -2.165 -1.25 Mabsadd L
.95079 .73109 2.165 -1.25 Mabsadd L
.95079 .73109 0 2.5 Mabsadd L closepath F
.95397 .73635 0 2.5 Mabsadd m
.95397 .73635 -2.165 -1.25 Mabsadd L
.95397 .73635 2.165 -1.25 Mabsadd L
.95397 .73635 0 2.5 Mabsadd L closepath F
.95714 .74167 0 2.5 Mabsadd m
.95714 .74167 -2.165 -1.25 Mabsadd L
.95714 .74167 2.165 -1.25 Mabsadd L
.95714 .74167 0 2.5 Mabsadd L closepath F
.96032 .74704 0 2.5 Mabsadd m
.96032 .74704 -2.165 -1.25 Mabsadd L
.96032 .74704 2.165 -1.25 Mabsadd L
.96032 .74704 0 2.5 Mabsadd L closepath F
.96349 .75246 0 2.5 Mabsadd m
.96349 .75246 -2.165 -1.25 Mabsadd L
.96349 .75246 2.165 -1.25 Mabsadd L
.96349 .75246 0 2.5 Mabsadd L closepath F
.96667 .75794 0 2.5 Mabsadd m
.96667 .75794 -2.165 -1.25 Mabsadd L
.96667 .75794 2.165 -1.25 Mabsadd L
.96667 .75794 0 2.5 Mabsadd L closepath F
.96984 .76347 0 2.5 Mabsadd m
.96984 .76347 -2.165 -1.25 Mabsadd L
.96984 .76347 2.165 -1.25 Mabsadd L
.96984 .76347 0 2.5 Mabsadd L closepath F
.97302 .76906 0 2.5 Mabsadd m
.97302 .76906 -2.165 -1.25 Mabsadd L
.97302 .76906 2.165 -1.25 Mabsadd L
.97302 .76906 0 2.5 Mabsadd L closepath F
.97619 .7747 0 2.5 Mabsadd m
.97619 .7747 -2.165 -1.25 Mabsadd L
.97619 .7747 2.165 -1.25 Mabsadd L
.97619 .7747 0 2.5 Mabsadd L closepath F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 355.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900001Hb000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX002Wooo]Z1Ol0003ooookJ_oooo]Z5?oonfX002Wooo]Z1Ol0003ooookJ_oooo]Z5?oo
nfX002Wooo]Z1Ol0003ooookJ_oooo]Z5?oonfX002Wooo]Z1Ol0003ooookJ_oooo]Z5?oonfX002Wo
oo]Z1Ol0003ooookJ_oooo]Z5?oonfX001?ooo]Z0ol007l5oookJPGo001o2OoonfX5o`000?oooo]Z
oooonfXDoookJP004ooonfX3o`00O`Cooo]Z1ol007l8oookJPGo0000oooonf[ooookJQCooo]Z000C
oookJP?o001o1?oonfX3o`00O`04oookJ_l007oo001oo`00O`Sooo]Z1Ol0003ooookJ_oooo]Z5?oo
nfX000?ooo]Z2_l007l6oookJP?o001o0ooonfX3o`00O`?ooo]Z0ol007l7oookJPGo0000oooonf[o
oookJQCooo]Z0003oookJP[o001o1_oonfX3o`00O`?ooo]Z0ol007l3oookJP?o001o1ooonfX7o`00
0?oooo]Zo?oonfX4o`00017ooo]Z000CoookJP?o001o0ooonfX3o`00O`?ooo]Z0ol007l7oookJPGo
0000oooonf[loookJPKo00004OoonfX001?ooo]Z0ol007l3oookJP?o001o0ooonfX3o`00O`Oooo]Z
1Ol0003ooookJ_[ooo]Z2?l0000AoookJP004ooonfX3o`00O`?ooo]Z0ol007l3oookJP?o001o1ooo
nfX5o`000?oooo]ZnOoonfX9o`00017ooo]Z000CoookJP?o001o0ooonfX3o`00O`?ooo]Z0ol007l7
oookJPGo0000oooonf[goookJP[o00004_oonfX0013ooo]Z1_l007l3oookJP?o001o0ooonfX3o`00
O`Oooo]Z1Ol0003ooookJ_Gooo]Z2ol0000CoookJP004?oonfX6o`00O`Cooo]Z0ol007l01?oonf[o
001oo`00Ool007l8oookJPGo0000oooonf[doookJP[o00005OoonfX001;ooo]Z1?l007l4oookJPOo
001o2?oonfX5o`000?oooo]Zl_oonfX:o`0001Oooo]Z000CoookJP?o001o1OoonfX5o`00O`Wooo]Z
1Ol0003ooookJ_3ooo]Z2ol0000HoookJP00:OoonfX5o`000?oooo]Zk_oonfX;o`0001[ooo]Z000Y
oookJPGo0000oooonf[]oookJP[o00007?oonfX002Wooo]Z1Ol0003ooookJ^_ooo]Z2_l0000Noook
JP00:OoonfX5o`000?oooo]ZjOoonfX;o`0001oooo]Z000YoookJPGo0000oooonf[XoookJP[o0000
8OoonfX002Wooo]Z1Ol0003ooookJ^Kooo]Z2_l0000SoookJP00:OoonfX5o`000?oooo]Zh_oonfX<
o`0002Gooo]Z000YoookJPGo0000oooonf[QoookJP_o00009ooonfX002Wooo]Z1Ol0003ooookJ]oo
oo]Z3?l0000XoookJP00:OoonfX5o`000?oooo]ZgOoonfX<o`0002[ooo]Z000YoookJPGo0000oooo
nf[KoookJP_o0000;OoonfX002Wooo]Z1Ol0003ooookJ]Sooo]Z3?l0000_oookJP00:OoonfX5o`00
0?oooo]Ze_oonfX=o`00033ooo]Z000YoookJPGo0000oooonf[EoookJP_o0000<ooonfX002Wooo]Z
1Ol0003ooookJ]?ooo]Z2ol0000eoookJP00:OoonfX5o`000?oooo]ZdOoonfX;o`0003Oooo]Z000Y
oookJPGo0000oooonf[>oookJPco0000>OoonfX002Wooo]Z1Ol0003ooookJ/cooo]Z3?l0000koook
JP00:OoonfX5o`000?oooo]Zb_oonfX<o`0003gooo]Z000YoookJPGo0000oooonf[7oookJPgo0000
?ooonfX002Wooo]Z1Ol0003ooookJ/Gooo]Z3?l00012oookJP00:OoonfX5o`000?oooo]Z`ooonfX=
o`0004?ooo]Z000YoookJPGo0000oooonf[0oookJPgo0000A_oonfX002Wooo]Z1Ol0003ooookJ[ko
oo]Z3Ol00018oookJP00:OoonfX5o`000?oooo]Z^ooonfX>o`0004[ooo]Z000YoookJPGo0000oooo
nfZioookJPgo0000COoonfX002Wooo]Z1Ol0003ooookJ[Kooo]Z3_l0001?oookJP00:OoonfX5o`00
0?oooo]Z]?oonfX=o`0005;ooo]Z000YoookJPGo0000oooonfZaoookJPko0000E?oonfX002Wooo]Z
1Ol0003ooookJZoooo]Z3_l0001FoookJP00:OoonfX5o`000?oooo]ZZooonfX>o`0005[ooo]Z000Y
oookJPGo0000oooonfZZoookJPko0000FooonfX002Wooo]Z1Ol0003ooookJZKooo]Z3_l0001Ooook
JP00:OoonfX5o`000?oooo]ZXooonfX@o`00063ooo]Z000YoookJPGo0000oooonfZQoookJPko0000
I?oonfX002Wooo]Z1Ol0003ooookJYkooo]Z3ol0001VoookJP00:OoonfX5o`000?oooo]ZV_oonfX@
o`0006Wooo]Z000YoookJPGo0000oooonfZGoookJQ3o0000K?oonfX002Wooo]Z1Ol0003ooookJYGo
oo]Z3ol0001_oookJP006ooonfX5o`00O`Wooo]Z1Ol0003ooookJY;ooo]Z3ol0001boookJP006_oo
nfX7o`00O`Sooo]Z1Ol0003ooookJXkooo]Z4?l0001eoookJP006OoonfX4o`00O`04oookJ_l007oo
001oo`00O`Sooo]Z1Ol0003ooookJX_ooo]Z4?l0001hoookJP003OoonfX:o`00O`;ooo]Z0ol007l3
oookJP?o001o1ooonfX5o`000?oooo]ZQooonfXBo`0007[ooo]Z000=oookJP[o001o2?oonfX3o`00
O`Oooo]Z1ol0003ooookJX;ooo]Z4Ol0001noookJP007ooonfX3o`00O`Oooo]Z1Ol0003ooookJX7o
oo]Z4Ol00021oookJP006_oonfX2o`00O`;ooo]Z1?l007l7oookJPGo0000oooonfYmoookJQ;o0000
Q?oonfX001[ooo]Z1ol007l8oookJPGo0000oooonfYjoookJQ7o0000R?oonfX001[ooo]Z1_l007l9
oookJPGo0000oooonfYfoookJQ;o0000RooonfX001[ooo]Z0_l007l=oookJPGo0000oooonfYcoook
JQ7o0000SooonfX001[ooo]Z0_l007l=oookJPGo0000oooonfY^oookJQ?o0000T_oonfX001_ooo]Z
1ol007l7oookJPGo0000oooonfYZoookJQ?o0000U_oonfX001_ooo]Z1ol007l7oookJPGo0000oooo
nfYWoookJQ?o0000VOoonfX002Wooo]Z1Ol0003ooookJV;ooo]Z5Ol0002LoookJP00:OoonfX5o`00
0?oooo]ZG_oonfXCo`000003oookJ_l0003ooo]Z09oooo]Z000YoookJPGo0000oooonfYIoookJQGo
0000YOoonfX002Wooo]Z1Ol0003ooookJUKooo]Z5Ol0002XoookJP00:OoonfX5o`000?oooo]ZDOoo
nfXDo`000003oookJ_l0003ooo]Z0:_ooo]Z000YoookJPGo0000oooonfY;oookJQOo0000/OoonfX0
02Wooo]Z1Ol0003ooookJTSooo]Z5Ol000000ooonf[o0000oookJP2coookJP00:OoonfX5o`000?oo
oo]Z@ooonfXFo`000;[ooo]Z000YoookJPGo0000oooonfXnoookJQKo0000_ooonfX002Wooo]Z1Ol0
003ooookJSWooo]Z5_l000000ooonf[o0000oookJP31oookJP00:OoonfX5o`000?oooo]Z<ooonfXI
o`000<Oooo]Z000YoookJPGo0000oooonfX]oookJQ[o0000c?oonfX002Wooo]Z1Ol0003ooookJROo
oo]Z6_l0003BoookJP00:OoonfX5o`000?oooo]Z8_oonfXJo`000=Oooo]Z000YoookJPGo0000oooo
nfXKoookJQco0000g?oonfX002Wooo]Z1Ol0003ooookJQGooo]Z6ol000000ooonf[o0000oookJP3P
oookJP00:OoonfX5o`000?oooo]Z3_oonfXMo`000003oookJ_l0003ooo]Z0>Gooo]Z000YoookJPGo
0000oooonfX7oookJQoo0000kOoonfX002Wooo]Z1Ol0003ooookJQoo000000?ooo]Zo`000?oonfX0
lOoonfX002Wooo]Z1Ol0003hoookJQoo000000?ooo]Zo`000?oonfX0n?oonfX002Wooo]Z1Ol0003`
oookJR3o000000?ooo]Zo`000?oonfX0oooonfX002Wooo]Z1Ol0003WoookJRCo0000oooonfX8oook
JP00:OoonfX5o`0004_ooo]Z1Ol007l5oookJPGo001oA?oonfX3o`00O`Gooo]Z1Ol007l5oookJPGo
001o:OoonfXVo`000003oookJ_l007oo001o00?o001o>ooonfX9o`00O`?ooo]Z1Ol007l5oookJPGo
001o>ooonfX9o`00O`?ooo]Z1Ol007l5oookJPGo001o??oonfX5o`00O`Gooo]Z1Ol007l5oookJPGo
001o1ooonfX002Wooo]Z1Ol0001:oookJPOo001o0ooonfX7o`00Od?ooo]Z0ol007l4oookJPOo001o
0ooonfX7o`00Ob3ooo]Z9_l000000ol007oo0000o`00O`02o`00O`?ooo]Z1ol007ljoookJPWo001o
0_oonfX7o`00O`?ooo]Z1ol007ljoookJPWo001o0_oonfX7o`00O`?ooo]Z1ol007ljoookJPOo001o
0ooonfX7o`00O`?ooo]Z1ol007l6oookJP00:OoonfX5o`0004Wooo]Z1?l007l01?oonf[o001oo`00
Ool007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o@ooonfX3o`00O`Cooo]Z0ol007l01?oonf[o
001oo`00Ool007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o5_oonfXWo`000003o`00Ool0003o
001o00?ooo]Z1?l007l01?oonf[o001oo`00Ool007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o
>_oonfX4o`00O`Oooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o00Cooo]Zo`00Ool0
07oo001o>_oonfX4o`00O`Kooo]Z1?l007l01?oonf[o001oo`00Ool007l3oookJP?o001o00Cooo]Z
o`00Ool007oo001o>OoonfX3o`00O`?ooo]Z0ol007l2oookJP?o001o00Cooo]Zo`00Ool007oo001o
0ooonfX3o`00O`04oookJ_l007oo001oo`00O`Kooo]Z000YoookJPGo0000BOoonfX3o`00O`?ooo]Z
0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o@_oonfX3o`00O`?ooo]Z0ol007l3oookJP?o
001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00O`[ooo]Z:ol000000ooonf[o0000oookJP04oook
JP?o001o0ooonfX3o`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o>_oonfX4
o`00O`Gooo]Z0ol007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00Oc[ooo]Z1?l0
07l5oookJP?o001o0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007lhoookJP?o001o
0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007l3oook
JP?o001o1OoonfX002Wooo]Z1Ol0001?oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00
Od;ooo]Z0ol007l3oookJP?o001o0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l[
o`000004oookJ_l0003ooo]Zo`0000gooo]Z0ol007l9oookJP?o001o00Cooo]Zo`00Ool007oo001o
0ooonfX3o`00Oc_ooo]Z1Ol007l3oookJP?o001o0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?o
oo]Z0ol007lkoookJPGo001o2OoonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007lnoook
JP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol0
07l5oookJP00:OoonfX5o`0004oooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o@_oo
nfX3o`00O`?ooo]Z0ol007l3oookJP03o`00Ool0003o000002ko000000?ooo]Zo`000?oonfX05Ooo
nfX3o`00O`Wooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o?OoonfX4o`00O`;ooo]Z
0ol007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00Ocgooo]Z1?l007l8oookJP?o
001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00Ockooo]Z0ol007l01?oonf[o001oo`00Ool007l3
oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00O`Gooo]Z000YoookJPGo0000B_oonfX2
o`00O`;ooo]Z1?l007l01?oonf[o001oo`00Ool007l3oookJP?o001o@_oonfX00ol007oo0000o`00
000^o`000004oookJ_l0003ooo]Zo`00023ooo]Z0ol007l4oookJP;o001o0_oonfX4o`00O`04oook
J_l007oo001oo`00O`?ooo]Z0ol007lnoookJP?o001o0_oonfX3o`00O`?ooo]Z0ol007l01?oonf[o
001oo`00Ool007l3oookJP?o001o?_oonfX3o`00O`?ooo]Z0_l007l2oookJPCo001o00Cooo]Zo`00
Ool007oo001o0ooonfX3o`00Occooo]Z1?l007l2oookJP?o001o0ooonfX3o`00O`04oookJ_l007oo
001oo`00O`?ooo]Z0ol007l5oookJP00:OoonfX5o`0004[ooo]Z1ol007l2oookJP?o001o0ooonfX3
o`00OcGooo]Z=?l000000ooonf[o0000o`00000[oookJP?o001o1?oonfX7o`00O`;ooo]Z0ol007l3
oookJP?o001o?ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l01?oonf[o001oo`00
Ool007l3oookJP?o001o?ooonfX3o`00O`;ooo]Z1ol007l2oookJP?o001o0ooonfX3o`00Occooo]Z
0ol007l3oookJP?o001o0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l5oookJP00
:OoonfX5o`0004[ooo]Z1_l007l3oookJP?o001o0ooonfX3o`00ObSooo]Z>?l000000ooonf[o0000
oookJP0doookJP?o001o1?oonfX6o`00O`?ooo]Z0ol007l3oookJP?o001o>OoonfX3o`00O`?ooo]Z
0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00
OcWooo]Z0ol007l3oookJP?o001o0_oonfX6o`00O`?ooo]Z0ol007l3oookJP?o001o?_oonfX2o`00
O`;ooo]Z0ol007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00O`Gooo]Z000Yoook
JPGo0000B_oonfX2o`00O`Oooo]Z0ol007l3oookJP?o001o6?oonfXlo`000004o`00Ool0003ooo]Z
o`0000?o001o>OoonfX6o`00O`Cooo]Z0_l007l7oookJP?o001o0ooonfX3o`00OcWooo]Z0ol007l3
oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z
0ol007lioookJP?o001o0ooonfX3o`00O`;ooo]Z0_l007l7oookJP?o001o0ooonfX3o`00OcSooo]Z
0ol007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00O`04oookJ_l007oo001oo`00
O`?ooo]Z0ol007l5oookJP00:OoonfX5o`0004[ooo]Z0_l007l8oookJP?o001o00Cooo]Zo`00Ool0
07oo001o2?oonfY1o`000005oookJ_l0003o001oo`000?oonfX00ol007l3oookJP?o001o00Cooo]Z
o`00Ool007oo001o>_oonfX6o`00O`Cooo]Z0_l007l8oookJP?o001o00Cooo]Zo`00Ool007oo001o
>_oonfX4o`00O`;ooo]Z0ol007l2oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00O`04
oookJ_l007oo001oo`00Oc[ooo]Z1?l007l2oookJP?o001o0_oonfX2o`00O`Sooo]Z0ol007l01?oo
nf[o001oo`00Ool007lioookJP?o001o0ooonfX3o`00O`;ooo]Z0ol007l01?oonf[o001oo`00Ool0
07l3oookJP?o001o00Cooo]Zo`00Ool007oo001o1_oonfX002Wooo]Z1Ol0001;oookJP?o001oAol0
00001Ooonf[o0000o`000?oonf[o000000?ooo]Z1?l007l4oookJPOo001o0ooonfX7o`00Occooo]Z
1?l007l5oookJPOo001o0_oonfX7o`00Oc_ooo]Z1ol007l3oookJPOo001o0ooonfX7o`00Oc_ooo]Z
1ol007l4oookJPOo001o0_oonfX7o`00Oc[ooo]Z1ol007l3oookJPOo001o0ooonfX7o`00O`Kooo]Z
000YoookJPGo0000>_oonfY=o`000003oookJ_l0003ooo]Z00;o00004_oonfX3o`00O`Gooo]Z1Ol0
07l5oookJPGo001o?_oonfX3o`00O`Gooo]Z1ol007l3oookJPGo001o?OoonfX5o`00O`Gooo]Z1Ol0
07l5oookJPGo001o?OoonfX5o`00O`Gooo]Z1ol007l3oookJPGo001o??oonfX5o`00O`Gooo]Z1Ol0
07l5oookJPGo001o1ooonfX002Wooo]Z1Ol0000PoookJUSo000000Gooo]Zo`000?l0003ooo]Zo`00
003ooookJYKooo]Z000YoookJPGo00000ooonfYUo`000006oookJ_l0003ooo]Zo`000?oonf[o0000
oooonfZUoookJP00:OoonfYGo`000009oookJ_l0003ooo]ZoookJ_l0003ooo]Zo`000?oonf[o0000
0?oooo]Z^?oonfX002Wooo]Z@_l000001Ooonf[o0000oookJ_l0003ooo]Z00;o000000?ooo]Zo`00
0?oonfX0oooonf[<oookJP00:OoonfXYo`0000;ooo]Z00Co0000oookJ_l0003ooo]Z0_l000001?oo
nf[o0000oookJ_l0003ooookJ^?ooo]Z000YoookJPgo000000Cooo]Zo`000?oonf[o00000_oonfX0
1?l0003ooo]Zo`000?oonfX2o`000?oooo]ZoooonfX001cooo]Zool0003oo`0002?o00000ooonfX0
01cooo]Zool0003oo`0002?o00000ooonfX001cooo]Zool0003oo`0002?o00000ooonfX001cooo]Z
ool0003oo`0002?o00000ooonfX001cooo]Zool0003oo`0002?o00000ooonfX002Wooo]Z1Ol0001C
oookJP03o`000?oonf[ooo]Z05?ooo]Z00?o0000oookJ_oonfX0D_oonfX00ol0003ooo]ZoookJP1C
oookJP03o`000?oonf[ooo]Z05?ooo]Z00?o0000oookJ_oonfX0D_oonfX00ol0003ooo]ZoookJP0@
oookJP00:OoonfXAo`000?oooo]ZoooonfX8oookJP00:OoonfX/o`000?oooo]Zk?oonfX002Wooo]Z
A_l0003ooookJ];ooo]Z000YoookJU_o0000oooonfZmoookJP00:OoonfX5o`0000;ooo]Z00?o0000
oookJ_l000000_oonfX00ol0003ooo]Zo`00001No`000?oooo]ZZooonfX002Wooo]Z3ol0000@oook
JP03o`000?oonf[o000000;ooo]Z00?o0000oookJ_l000000_oonfYFo`000?oooo]ZVOoonfX002Wo
oo]Z7_l0000KoookJP06o`000?oonf[ooo]Zo`000?oonf[o00001?oonfY;o`000?oooo]ZR_oonfX0
02Wooo]Z;?l0000SoookJP03o`000?oonf[o000000;ooo]Z00Co0000oookJ_l0003ooo]ZA?l0003o
oookJWcooo]Z000YoookJSSo0000;ooonfX00ol0003ooo]Zo`00000oo`000?oooo]ZKooonfX002Wo
oo]ZA?l0000aoookJP07o`000?oonf[ooo]Zo`000?oonf[o0000oookJP0io`000?oooo]ZHooonfX0
02Wooo]Z1Ol00007oookJTCo0000=_oonfX00ol0003ooo]ZoookJP02oookJSKo0000oooonfYGoook
JP00:OoonfX?o`0000cooo]Z?ol0000moookJP03o`000?oonf[o000003;o0000oooonfY<oookJP00
:OoonfXIo`00013ooo]Z>_l00010oookJP03o`000?oonf[o0000033o0000oooonfY2oookJP00:Ooo
nfXRo`0001?ooo]Z>?l00012oookJP03o`000?oonf[o000002ko0000oooonfXhoookJP00:OoonfX/
o`0001Gooo]Z=Ol00015oookJP03o`000?oonf[o000002_o0000oooonfX_oookJP00:OoonfX5o`00
00Cooo]Z00?o0000oookJ_l00000:Ol0000HoookJS7o0000BOoonfX00ol0003ooo]Zo`00000Wo`00
0?oooo]Z9ooonfX002Wooo]Z1Ol0000>oookJP03o`000?oonf[o000002Ko00006ooonfX^o`0004ko
oo]Z9ol0003ooookJQkooo]Z000YoookJPGo00006OoonfXVo`0001cooo]Z;_l0001<oookJP03o`00
0?oonf[ooo]Z02Co0000oooonfXGoookJP00:OoonfX5o`00027ooo]Z00?o0000oookJ_l000008_l0
000OoookJR_o0000CooonfX00ol0003ooo]Zo`00000Ro`000?oooo]Z3ooonfX002Wooo]Z1Ol0000Z
oookJP;o000000?ooo]Zo`000?l000007_l0000QoookJRWo0000DOoonfXSo`000?oooo]Z2?oonfX0
02Wooo]Z1Ol0000boookJP03o`000?oonf[o000001oo00008_oonfXWo`0005Gooo]Z8?l0003ooook
JP7ooo]Z000YoookJPGo0000>ooonfXPo`0002;ooo]Z9ol0001CoookJP03o`000?oonf[o000001oo
0000nOoonfX002Wooo]Z1Ol00012oookJR3o00009?oonfXUo`0005Gooo]Z7_l0003doookJP00:Ooo
nfX5o`0004Wooo]Z7ol0000ToookJRCo0000F?oonfXMo`000>gooo]Z000YoookJPGo0000CooonfX0
0ol0003ooo]Zo`00000Lo`0002Gooo]Z8_l0001JoookJQ_o0000j?oonfX002Wooo]Z1Ol0001Foook
JP03o`000?oonf[o000001[o00009ooonfXRo`0005[ooo]Z6ol0003QoookJP00:OoonfX5o`0005go
oo]Z00?o0000oookJ_l000006_l0000WoookJR3o0000F_oonfXKo`000=cooo]Z000YoookJPGo0000
I?oonfXKo`0002Wooo]Z7ol0001KoookJQWo0000eooonfX002Wooo]Z1Ol0001YoookJP03o`000?oo
nf[o000001So0000:OoonfXOo`0005_ooo]Z6Ol0003BoookJP00:OoonfX5o`00073ooo]Z6Ol0000Y
oookJQoo0000GOoonfXHo`000<cooo]Z000YoookJPGo0000MOoonfX00ol0003ooo]Zo`00000Fo`00
02_ooo]Z7Ol0001MoookJQSo0000aooonfX002Wooo]Z1Ol0001joookJP03o`000?oonf[o000001Go
0000;?oonfXMo`0005gooo]Z6?l00032oookJP00:OoonfX5o`0007oooo]Z00?o0000oookJ_l00000
5Ol0000/oookJQco0000G_oonfXHo`000;gooo]Z000YoookJPGo0000QOoonfXGo`0002cooo]Z7?l0
001OoookJQGo0000^_oonfX002Wooo]Z1Ol0002:oookJQGo0000;ooonfXIo`00067ooo]Z5_l0002d
oookJP00:OoonfX5o`0008oooo]Z5Ol0000_oookJQWo0000GooonfX00ol0003ooo]Zo`00000Co`00
0;7ooo]Z000YoookJPGo0000U?oonfXDo`00033ooo]Z6?l0001RoookJQCo0000[?oonfX002Wooo]Z
1Ol0002GoookJP03o`000?oonf[o000001?o0000;_oonfXJo`00063ooo]Z5Ol0002XoookJP00:Ooo
nfX5o`0009cooo]Z5?l0000`oookJQSo0000HOoonfX00ol0003ooo]Zo`00000Ao`000:Gooo]Z000Y
oookJPGo0000XOoonfXCo`00033ooo]Z6?l0001RoookJQCo0000X?oonfX002Wooo]Z1Ol0002Uoook
JQCo0000<?oonfXFo`0006Cooo]Z4ol0002LoookJP00:OoonfX5o`000:Wooo]Z4ol0000`oookJQSo
0000HooonfXBo`0009Wooo]Z000YoookJPGo0000[OoonfXCo`0003;ooo]Z5_l0001RoookJQ;o0000
U_oonfX002Wooo]Z1Ol0002aoookJQ;o0000<_oonfXFo`0006Cooo]Z4Ol0002BoookJP006ooonfX5
o`00O`Wooo]Z1Ol0002eoookJQ;o0000<OoonfXGo`0006Cooo]Z4?l0002?oookJP006_oonfX7o`00
O`Sooo]Z1Ol0002ioookJQ7o0000<_oonfXFo`0006Cooo]Z4Ol0002;oookJP006OoonfX4o`00O`04
oookJ_l007oo001oo`00O`Sooo]Z1Ol0002moookJQ7o0000<ooonfXDo`0006Cooo]Z4Ol00028oook
JP006OoonfX3o`00O`?ooo]Z0ol007l7oookJPGo0000`?oonfXAo`0003?ooo]Z5Ol0001ToookJQ7o
0000Q?oonfX001oooo]Z0ol007l7oookJPOo0000`_oonfX@o`0003Cooo]Z4ol0001UoookJQ7o0000
POoonfX001oooo]Z0ol007l7oookJPGo0000aooonfXAo`0003?ooo]Z4ol0001VoookJQ3o0000O_oo
nfX001[ooo]Z0_l007l2oookJPCo001o1ooonfX5o`000<_ooo]Z3ol0000eoookJQ;o0000I_oonfXA
o`0007[ooo]Z000JoookJPOo001o2?oonfX5o`000<kooo]Z3ol0000eoookJQ?o0000I_oonfX@o`00
07Oooo]Z000JoookJPKo001o2OoonfX5o`000=7ooo]Z3ol0000foookJQ;o0000I_oonfX?o`0007Go
oo]Z000JoookJP;o001o3OoonfX5o`000=Gooo]Z3ol0000coookJQ?o0000IooonfX?o`0007;ooo]Z
000JoookJP;o001o3OoonfX5o`000=Oooo]Z3ol0000eoookJQ;o0000J?oonfX?o`0006kooo]Z000K
oookJPOo001o1ooonfX5o`000=[ooo]Z3ol0000eoookJQ?o0000IooonfX?o`0006_ooo]Z000Koook
JPOo001o1ooonfX5o`000=gooo]Z3ol0000foookJQ7o0000IooonfX?o`0006Wooo]Z000YoookJPGo
0000hOoonfX=o`0003Oooo]Z4Ol0001WoookJPoo0000I_oonfX002Wooo]Z1Ol0003SoookJPoo0000
=OoonfXBo`0006Sooo]Z3Ol0001ToookJP00:OoonfX5o`000>Kooo]Z3ol0000eoookJQ7o0000JOoo
nfX>o`00063ooo]Z000YoookJPGo0000jOoonfX>o`0003Oooo]Z4Ol0001WoookJPoo0000GOoonfX0
02Wooo]Z1Ol0003[oookJPoo0000=OoonfXAo`0006Wooo]Z3_l0001KoookJP00:OoonfX5o`000>oo
oo]Z3Ol0000goookJQ7o0000IooonfX?o`0005Sooo]Z000YoookJPGo0000l_oonfX=o`0003Oooo]Z
3ol0001ZoookJPgo0000E_oonfX002Wooo]Z1Ol0003doookJPgo0000=ooonfXAo`0006Wooo]Z3?l0
001DoookJP00:OoonfX5o`000?Oooo]Z3?l0000hoookJQ3o0000JOoonfX=o`00057ooo]Z000Yoook
JPGo0000nOoonfX=o`0003Oooo]Z3ol0001[oookJPco0000CooonfX002Wooo]Z1Ol0003loookJPco
0000>?oonfX@o`0006Wooo]Z3Ol0001<oookJP00:OoonfX5o`000?kooo]Z3Ol0000goookJPoo0000
J_oonfX=o`0004[ooo]Z000YoookJPGo0000oooonfX1oookJPgo0000>OoonfX=o`0006_ooo]Z3?l0
0018oookJP00:OoonfX5o`000?oooo]Z1?oonfX<o`0003Sooo]Z4?l0001YoookJPgo0000AOoonfX0
02Wooo]Z1Ol0003ooookJPKooo]Z3Ol0000goookJPoo0000JooonfX<o`0004?ooo]Z000YoookJPGo
0000oooonfX9oookJPco0000>?oonfX>o`0006_ooo]Z2ol00012oookJP00:OoonfX5o`000?oooo]Z
2ooonfX<o`0003Sooo]Z3ol0001ZoookJPgo0000?_oonfX002Wooo]Z1Ol0003ooookJPgooo]Z3Ol0
000goookJPoo0000JooonfX<o`0003cooo]Z000YoookJPGo0000oooonfX@oookJPco0000>?oonfX>
o`0006_ooo]Z2ol0000koookJP00:OoonfX5o`000?oooo]Z4_oonfX;o`0003Wooo]Z3_l0001Zoook
JPco0000>OoonfX002Wooo]Z1Ol0003ooookJQCooo]Z2ol0000ioookJPoo0000JooonfX;o`0003Ko
oo]Z000YoookJPGo0000oooonfXGoookJP[o0000>_oonfX>o`0006_ooo]Z2ol0000doookJP00:Ooo
nfX5o`000?oooo]Z6OoonfX;o`0003Wooo]Z3Ol0001[oookJPco0000<_oonfX002Wooo]Z1Ol0003o
oookJQ[ooo]Z3?l0000ioookJPgo0000JooonfX<o`00033ooo]Z000YoookJPGo0000oooonfXLoook
JPco0000>?oonfX>o`0006cooo]Z2_l0000_oookJP00:OoonfX5o`000?oooo]Z7_oonfX;o`0003_o
oo]Z3?l0001/oookJPco0000:ooonfX002Wooo]Z1Ol0003ooookJR7ooo]Z2_l0000joookJPko0000
JooonfX<o`0002Wooo]Z000YoookJPGo0000oooonfXSoookJP[o0000>_oonfX>o`0006_ooo]Z2ol0
000XoookJP00:OoonfX5o`000?oooo]Z9OoonfX;o`0003Wooo]Z3Ol0001[oookJPco00009_oonfX0
02Wooo]Z1Ol0003ooookJRKooo]Z3?l0000ioookJPgo0000KOoonfX:o`0002Cooo]Z000YoookJPGo
0000oooonfXXoookJPco0000>?oonfX>o`0006gooo]Z2Ol0000SoookJP00:OoonfX5o`000?oooo]Z
:_oonfX;o`0003_ooo]Z3?l0001/oookJP[o00008OoonfX002Wooo]Z1Ol0003ooookJRgooo]Z2_l0
000joookJPco0000KOoonfX:o`0001oooo]Z000YoookJPGo0000oooonfX_oookJP[o0000>_oonfX<
o`0006gooo]Z2_l0000MoookJP00:OoonfX5o`000?oooo]Z<OoonfX:o`0003[ooo]Z3?l0001/oook
JP[o00007?oonfX002Wooo]Z1Ol0003ooookJS;ooo]Z2_l0000koookJPco0000K?oonfX:o`0001[o
oo]Z000YoookJPGo0000oooonfXdoookJP[o0000>_oonfX<o`0006gooo]Z2_l0000HoookJP00:Ooo
nfX5o`000?oooo]Z=_oonfX:o`0003[ooo]Z3?l0001]oookJPWo00005ooonfX002Wooo]Z1Ol0003o
oookJSSooo]Z2Ol0000koookJPco0000K?oonfX:o`0001Gooo]Z000CoookJP?o001o1OoonfX5o`00
O`Wooo]Z1Ol0003ooookJSWooo]Z2_l0000joookJPco0000KOoonfX:o`0001?ooo]Z000CoookJP?o
001o1?oonfX7o`00O`Sooo]Z1Ol0003ooookJS_ooo]Z2_l0000joookJPco0000KOoonfX9o`0001;o
oo]Z000CoookJP?o001o1?oonfX3o`00O`04oookJ_l007oo001oo`00O`Sooo]Z1Ol0003ooookJSgo
oo]Z2_l0000joookJPco0000K?oonfX9o`00017ooo]Z000CoookJP?o001o0ooonfX3o`00O`?ooo]Z
0ol007l7oookJPGo0000oooonfXnoookJP[o0000>ooonfX<o`0006cooo]Z2?l0000@oookJP004ooo
nfX3o`00O`?ooo]Z0ol007l3oookJP?o001o1ooonfX7o`000?oooo]Z?_oonfX:o`0003[ooo]Z3?l0
001]oookJPGo00004OoonfX001?ooo]Z0ol007l3oookJP?o001o0ooonfX3o`00O`Oooo]Z1Ol0003o
oookJT;ooo]Z2_l0000joookJPco0000K?oonfX4o`00017ooo]Z000CoookJP?o001o0ooonfX3o`00
O`?ooo]Z0ol007l7oookJPGo0000oooonfY4oookJPWo0000>ooonfX<o`0007oooo]Z000CoookJP?o
001o0ooonfX3o`00O`?ooo]Z0ol007l7oookJPGo0000oooonfY5oookJP[o0000>_oonfX<o`0007ko
oo]Z000CoookJP?o001o0ooonfX3o`00O`?ooo]Z0ol007l7oookJPGo0000oooonfY7oookJP[o0000
>_oonfX<o`0007cooo]Z000@oookJPKo001o0ooonfX3o`00O`?ooo]Z0ol007l7oookJPGo0000oooo
nfY9oookJP[o0000>_oonfX<o`0007[ooo]Z000@oookJPKo001o1?oonfX3o`00O`04oookJ_l007oo
001oo`00O`Sooo]Z1Ol0003ooookJT[ooo]Z2_l0000koookJP_o0000NOoonfX001;ooo]Z1?l007l4
oookJPOo001o2?oonfX5o`000?oooo]ZC?oonfX8o`0003cooo]Z3?l0001goookJP004ooonfX3o`00
O`Gooo]Z1Ol007l9oookJPGo0000oooonfY>oookJPSo0000??oonfX:o`0007Oooo]Z000YoookJPGo
0000oooonfY@oookJPSo0000??oonfX:o`0007Gooo]Z000YoookJPGo0000oooonfY@oookJPWo0000
??oonfX;o`0007?ooo]Z000YoookJPGo0000oooonfYAoookJP[o0000??oonfX:o`0007;ooo]Z000Y
oookJPGo0000oooonfYCoookJP[o0000??oonfX:o`00073ooo]Z000YoookJPGo0000oooonfYEoook
JPWo0000>ooonfX<o`0006kooo]Z000YoookJPGo0000oooonfYFoookJPWo0000??oonfX;o`0006go
oo]Z000YoookJPGo0000oooonfYHoookJPSo0000??oonfX;o`0006cooo]Z000YoookJPGo0000oooo
nfYJoookJPSo0000??oonfX:o`0006_ooo]Z000YoookJPGo0000oooonfYKoookJPWo0000??oonfX:
o`0006Wooo]Z000YoookJPGo0000oooonfYLoookJPWo0000??oonfX;o`0006Oooo]Z000YoookJPGo
0000oooonfYMoookJPWo0000?OoonfX:o`0006Kooo]Z000YoookJPGo0000oooonfYOoookJPSo0000
??oonfX<o`0006Cooo]Z000YoookJPGo0000oooonfYQoookJPSo0000??oonfX:o`0006Cooo]Z000Y
oookJPGo0000oooonfYRoookJPWo0000??oonfX:o`0006;ooo]Z000YoookJPGo0000oooonfYSoook
JPWo0000??oonfX:o`00067ooo]Z000YoookJPGo0000oooonfYToookJPWo0000?OoonfX:o`0005oo
oo]Z000YoookJPGo0000oooonfYVoookJPSo0000?_oonfX8o`0005oooo]Z000YoookJPGo0000oooo
nfYXoookJPSo0000??oonfX:o`0005gooo]Z000YoookJPGo0000oooonfYYoookJPSo0000??oonfX;
o`0005_ooo]Z000YoookJPGo0000oooonfYZoookJPSo0000?OoonfX:o`0005[ooo]Z000YoookJPGo
0000oooonfY[oookJPSo0000?_oonfX8o`0005[ooo]Z000YoookJPGo0000oooonfY]oookJPSo0000
??oonfX:o`0005Sooo]Z000YoookJPGo0000oooonfY^oookJPWo0000??oonfX:o`0005Kooo]Z000Y
oookJPGo0000oooonfY_oookJPWo0000??oonfX:o`0005Gooo]Z000YoookJPGo0000oooonfY`oook
JPSo0000?_oonfX9o`0005Cooo]Z000YoookJPGo0000oooonfYboookJPSo0000??oonfX:o`0005?o
oo]Z000YoookJPGo0000oooonfYdoookJPOo0000?OoonfX:o`00057ooo]Z000YoookJPGo0000oooo
nfYdoookJPSo0000?OoonfX;o`0004oooo]Z000YoookJPGo0000oooonfYeoookJPSo0000?_oonfX9
o`0004oooo]Z000YoookJPGo0000oooonfYgoookJPSo0000??oonfX:o`0004kooo]Z000YoookJPGo
0000oooonfYhoookJPSo0000?OoonfX:o`0004cooo]Z000YoookJPGo0000oooonfYioookJPSo0000
?_oonfX8o`0004cooo]Z000YoookJPGo0000oooonfYjoookJPWo0000?OoonfX9o`0004[ooo]Z000Y
oookJPGo0000oooonfYloookJPSo0000??oonfX:o`0004Wooo]Z000YoookJPGo0000oooonfYmoook
JPOo0000?_oonfX9o`0004Sooo]Z000YoookJPGo0000oooonfYnoookJPSo0000?_oonfX8o`0004Oo
oo]Z000YoookJPGo0000oooonfZ0oookJPOo0000?OoonfX:o`0004Gooo]Z000YoookJPGo0000oooo
nfZ0oookJPSo0000?OoonfX9o`0004Gooo]Z000CoookJP?o001o1OoonfX5o`00O`Wooo]Z1Ol0003o
oookJX7ooo]Z2?l0000noookJPWo0000@ooonfX001?ooo]Z0ol007l4oookJPOo001o2?oonfX5o`00
0?oooo]ZPooonfX7o`0003gooo]Z2_l00012oookJP004ooonfX3o`00O`?ooo]Z1?l007l01?oonf[o
001oo`00Ool007l8oookJPGo0000oooonfZ4oookJPOo0000?_oonfX8o`0004;ooo]Z000CoookJP?o
001o0ooonfX3o`00O`?ooo]Z0ol007l7oookJPGo0000oooonfZ5oookJPSo0000?_oonfX8o`00043o
oo]Z000CoookJP?o001o2OoonfX3o`00O`Oooo]Z1ol0003ooookJXCooo]Z2?l0000moookJP[o0000
?_oonfX001?ooo]Z0ol007l9oookJP?o001o1ooonfX5o`000?oooo]ZQooonfX8o`0003gooo]Z2Ol0
000noookJP004ooonfX3o`00O`Cooo]Z0_l007l2oookJPCo001o1ooonfX5o`000?oooo]ZR?oonfX8
o`0003kooo]Z2?l0000moookJP004ooonfX3o`00O`Cooo]Z1ol007l8oookJPGo0000oooonfZ:oook
JPKo0000?_oonfX:o`0003_ooo]Z000CoookJP?o001o1?oonfX6o`00O`Wooo]Z1Ol0003ooookJX_o
oo]Z1ol0000noookJPSo0000>ooonfX0013ooo]Z1_l007l4oookJP;o001o3OoonfX5o`000?oooo]Z
S?oonfX7o`0003kooo]Z2Ol0000ioookJP004?oonfX6o`00O`Cooo]Z0_l007l=oookJPGo0000oooo
nfZ<oookJPSo0000?OoonfX9o`0003Wooo]Z000BoookJPCo001o1OoonfX7o`00O`Oooo]Z1Ol0003o
oookJXgooo]Z2?l0000noookJPWo0000=ooonfX001?ooo]Z0ol007l5oookJPOo001o1ooonfX5o`00
0?oooo]ZSooonfX7o`0003kooo]Z2Ol0000foookJP00:OoonfX5o`000?oooo]ZT?oonfX7o`0003ko
oo]Z2?l0000foookJP00:OoonfX5o`000?oooo]ZTOoonfX7o`0003oooo]Z2?l0000doookJP00:Ooo
nfX5o`000?oooo]ZT_oonfX7o`0003kooo]Z2?l0000doookJP00:OoonfX5o`000?oooo]ZTooonfX8
o`0003gooo]Z2Ol0000boookJP00:OoonfX5o`000?oooo]ZU?oonfX8o`0003kooo]Z2?l0000aoook
JP00:OoonfX5o`000?oooo]ZUOoonfX7o`0003kooo]Z2Ol0000`oookJP00:OoonfX5o`000?oooo]Z
U_oonfX7o`0003oooo]Z2?l0000_oookJP00:OoonfX5o`000?oooo]ZV?oonfX6o`0003kooo]Z2?l0
000_oookJP00:OoonfX5o`000?oooo]ZV?oonfX8o`0003gooo]Z2Ol0000]oookJP00:OoonfX5o`00
0?oooo]ZVOoonfX8o`0003kooo]Z2Ol0000[oookJP00:OoonfX5o`000?oooo]ZV_oonfX7o`0003ko
oo]Z2Ol0000[oookJP00:OoonfX5o`000?oooo]ZVooonfX7o`0003oooo]Z2?l0000ZoookJP00:Ooo
nfX5o`000?oooo]ZWOoonfX6o`0003kooo]Z2Ol0000YoookJP00:OoonfX5o`000?oooo]ZWOoonfX7
o`0003oooo]Z2?l0000XoookJP00:OoonfX5o`000?oooo]ZW_oonfX7o`0003oooo]Z1ol0000Xoook
JP00:OoonfX5o`000?oooo]ZWooonfX7o`0003kooo]Z2Ol0000VoookJP00:OoonfX5o`000?oooo]Z
X?oonfX7o`0003oooo]Z1ol0000VoookJP00:OoonfX5o`000?oooo]ZXOoonfX7o`0003kooo]Z2?l0
000UoookJP00:OoonfX5o`000?oooo]ZX_oonfX7o`0003oooo]Z2?l0000SoookJP00:OoonfX5o`00
0?oooo]ZXooonfX7o`0003kooo]Z2?l0000SoookJP00:OoonfX5o`000?oooo]ZY?oonfX7o`0003ko
oo]Z2Ol0000QoookJP00:OoonfX5o`000?oooo]ZYOoonfX7o`0003gooo]Z2Ol0000QoookJP00:Ooo
nfX5o`000?oooo]ZY_oonfX7o`0003kooo]Z2Ol0000OoookJP00:OoonfX5o`000?oooo]ZYooonfX6
o`0003oooo]Z2?l0000OoookJP00:OoonfX5o`000?oooo]ZZ?oonfX6o`0003oooo]Z2?l0000Noook
JP00:OoonfX5o`000?oooo]ZZOoonfX6o`0003oooo]Z2?l0000MoookJP00:OoonfX5o`000?oooo]Z
ZOoonfX7o`0003oooo]Z2?l0000LoookJP00:OoonfX5o`000?oooo]ZZ_oonfX7o`0003oooo]Z1ol0
000LoookJP00:OoonfX5o`000?oooo]ZZooonfX7o`0003kooo]Z2Ol0000JoookJP00:OoonfX5o`00
0?oooo]Z[?oonfX7o`0003oooo]Z1ol0000JoookJP00:OoonfX5o`000?oooo]Z[OoonfX7o`0003ko
oo]Z2?l0000IoookJP00:OoonfX5o`000?oooo]Z[_oonfX6o`00043ooo]Z1ol0000HoookJP00:Ooo
nfX5o`000?oooo]Z[ooonfX7o`0003kooo]Z2?l0000GoookJP00:OoonfX5o`000?oooo]Z/?oonfX6
o`0003oooo]Z1ol0000GoookJP00:OoonfX5o`000?oooo]Z/?oonfX7o`0003kooo]Z2Ol0000Eoook
JP00:OoonfX5o`000?oooo]Z/OoonfX7o`0003oooo]Z1ol0000EoookJP00:OoonfX5o`000?oooo]Z
/_oonfX7o`0003kooo]Z2Ol0000CoookJP00:OoonfX5o`000?oooo]Z/ooonfX6o`00043ooo]Z1ol0
000CoookJP00:OoonfX5o`000?oooo]Z]?oonfX7o`0003kooo]Z2?l0000BoookJP003ooonfX9o`00
O`?ooo]Z1Ol007l9oookJPGo0000oooonfZeoookJPKo0000@?oonfX6o`0001;ooo]Z000?oookJPWo
001o0_oonfX7o`00O`Sooo]Z1Ol0003ooookJ[Gooo]Z1ol0000ooookJPSo00004?oonfX000oooo]Z
1?l007l7oookJP?o001o00Cooo]Zo`00Ool007oo001o2?oonfX5o`000?oooo]Z]_oonfX7o`0003oo
oo]Z1ol0000@oookJP004?oonfX4o`00O`Gooo]Z0ol007l3oookJP?o001o1ooonfX5o`000?oooo]Z
]ooonfX7o`0003kooo]Z1ol0000@oookJP004OoonfX5o`00O`?ooo]Z0ol007l3oookJP?o001o1ooo
nfX7o`000?oooo]Z]_oonfX7o`0003oooo]Z1Ol0000@oookJP004ooonfX4o`00O`;ooo]Z0ol007l3
oookJP?o001o1ooonfX5o`000?oooo]Z^OoonfX7o`0003kooo]Z1Ol0000@oookJP005?oonfX3o`00
O`;ooo]Z0ol007l3oookJP?o001o1ooonfX5o`000?oooo]Z^_oonfX6o`0005?ooo]Z000EoookJP?o
001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00O`Oooo]Z1Ol0003ooookJ[_ooo]Z1_l0001Boook
JP003ooonfX3o`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o1ooonfX5o`00
0?oooo]Z_?oonfX6o`00057ooo]Z000?oookJP?o001o0ooonfX3o`00O`04oookJ_l007oo001oo`00
O`?ooo]Z0ol007l7oookJPGo0000oooonfZloookJPOo0000D?oonfX000oooo]Z1?l007l2oookJP?o
001o0_oonfX3o`00O`04oookJ_l007oo001oo`00O`Sooo]Z1Ol0003ooookJ[gooo]Z1ol0001?oook
JP004?oonfX7o`00O`?ooo]Z1ol007l8oookJPGo0000oooonfZnoookJPOo0000C_oonfX0017ooo]Z
1Ol007l5oookJPGo001o2OoonfX5o`000?oooo]Z_ooonfX6o`0004kooo]Z000YoookJPGo0000oooo
nf[0oookJPKo0000COoonfX002Wooo]Z1Ol0003ooookJ/7ooo]Z1_l0001<oookJP00:OoonfX5o`00
0?oooo]Z`OoonfX7o`0004_ooo]Z000YoookJPGo0000oooonf[2oookJPKo0000BooonfX002Wooo]Z
1Ol0003ooookJ/?ooo]Z1_l0001:oookJP00:OoonfX5o`000?oooo]Za?oonfX6o`0004Wooo]Z000Y
oookJPGo0000oooonf[4oookJPOo0000B?oonfX002Wooo]Z1Ol0003ooookJ/Gooo]Z1_l00018oook
JP00:OoonfX5o`000?oooo]ZoooonfXDoookJP00:OoonfX5o`000?oooo]ZoooonfXDoookJP00oooo
nf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;o
oo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooook
J_oooo]Z@_oonfX00001\
\>"],
  ImageRangeCache->{{{0, 575}, {354.938, 0}} -> {-25.4848, -11.704, 0.583309, \
0.0964325}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell["\<\
Making a similar plot for a family of curves corresponding to a \
negative \[Alpha] value gives\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MultipleListPlot[Trajectory[\(- .01\), \(- .5\)], 
      Trajectory[\(- .01\),  .5], Trajectory[\(- .01\), 1], 
      Trajectory[\(- .01\), 1.5], PlotJoined \[Rule] True]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0031746 0.205686 0.385799 [
[.18254 .19319 -12 -20 ]
[.18254 .19319 12 0 ]
[.34127 .19319 -17 -20 ]
[.34127 .19319 17 0 ]
[.5 .19319 -17 -20 ]
[.5 .19319 17 0 ]
[.65873 .19319 -17 -20 ]
[.65873 .19319 17 0 ]
[.81746 .19319 -17 -20 ]
[.81746 .19319 17 0 ]
[.97619 .19319 -17 -20 ]
[.97619 .19319 17 0 ]
[.01131 .01279 -41.9375 -10 ]
[.01131 .01279 0 10 ]
[.01131 .10924 -51.9375 -10 ]
[.01131 .10924 0 10 ]
[.01131 .30214 -39 -10 ]
[.01131 .30214 0 10 ]
[.01131 .39859 -29 -10 ]
[.01131 .39859 0 10 ]
[.01131 .49503 -39 -10 ]
[.01131 .49503 0 10 ]
[.01131 .59148 -14 -10 ]
[.01131 .59148 0 10 ]
[ -0.005 -0.005 0 0 ]
[ 1.005 .62303 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .20569 m
.18254 .21194 L
s
gsave
.18254 .19319 -73 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(50) show
1.000 setlinewidth
grestore
.34127 .20569 m
.34127 .21194 L
s
gsave
.34127 .19319 -78 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(100) show
1.000 setlinewidth
grestore
.5 .20569 m
.5 .21194 L
s
gsave
.5 .19319 -78 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(150) show
1.000 setlinewidth
grestore
.65873 .20569 m
.65873 .21194 L
s
gsave
.65873 .19319 -78 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(200) show
1.000 setlinewidth
grestore
.81746 .20569 m
.81746 .21194 L
s
gsave
.81746 .19319 -78 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(250) show
1.000 setlinewidth
grestore
.97619 .20569 m
.97619 .21194 L
s
gsave
.97619 .19319 -78 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(300) show
1.000 setlinewidth
grestore
.125 Mabswid
.05556 .20569 m
.05556 .20944 L
s
.0873 .20569 m
.0873 .20944 L
s
.11905 .20569 m
.11905 .20944 L
s
.15079 .20569 m
.15079 .20944 L
s
.21429 .20569 m
.21429 .20944 L
s
.24603 .20569 m
.24603 .20944 L
s
.27778 .20569 m
.27778 .20944 L
s
.30952 .20569 m
.30952 .20944 L
s
.37302 .20569 m
.37302 .20944 L
s
.40476 .20569 m
.40476 .20944 L
s
.43651 .20569 m
.43651 .20944 L
s
.46825 .20569 m
.46825 .20944 L
s
.53175 .20569 m
.53175 .20944 L
s
.56349 .20569 m
.56349 .20944 L
s
.59524 .20569 m
.59524 .20944 L
s
.62698 .20569 m
.62698 .20944 L
s
.69048 .20569 m
.69048 .20944 L
s
.72222 .20569 m
.72222 .20944 L
s
.75397 .20569 m
.75397 .20944 L
s
.78571 .20569 m
.78571 .20944 L
s
.84921 .20569 m
.84921 .20944 L
s
.88095 .20569 m
.88095 .20944 L
s
.9127 .20569 m
.9127 .20944 L
s
.94444 .20569 m
.94444 .20944 L
s
.01 w
0 .20569 m
1 .20569 L
s
.25 Mabswid
.02381 .01279 m
.03006 .01279 L
s
gsave
.01131 .01279 -102.938 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Mathematica1-Bold
%%IncludeFont: Mathematica1-Bold
/Mathematica1-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(-) show
75.938 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.02381 .10924 m
.03006 .10924 L
s
gsave
.01131 .10924 -112.938 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Mathematica1-Bold
%%IncludeFont: Mathematica1-Bold
/Mathematica1-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(-) show
75.938 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(0.25) show
1.000 setlinewidth
grestore
.02381 .30214 m
.03006 .30214 L
s
gsave
.01131 .30214 -100 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(0.25) show
1.000 setlinewidth
grestore
.02381 .39859 m
.03006 .39859 L
s
gsave
.01131 .39859 -90 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.02381 .49503 m
.03006 .49503 L
s
gsave
.01131 .49503 -100 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(0.75) show
1.000 setlinewidth
grestore
.02381 .59148 m
.03006 .59148 L
s
gsave
.01131 .59148 -75 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.02381 .03208 m
.02756 .03208 L
s
.02381 .05137 m
.02756 .05137 L
s
.02381 .07066 m
.02756 .07066 L
s
.02381 .08995 m
.02756 .08995 L
s
.02381 .12853 m
.02756 .12853 L
s
.02381 .14782 m
.02756 .14782 L
s
.02381 .16711 m
.02756 .16711 L
s
.02381 .1864 m
.02756 .1864 L
s
.02381 .22498 m
.02756 .22498 L
s
.02381 .24427 m
.02756 .24427 L
s
.02381 .26356 m
.02756 .26356 L
s
.02381 .28285 m
.02756 .28285 L
s
.02381 .32143 m
.02756 .32143 L
s
.02381 .34072 m
.02756 .34072 L
s
.02381 .36001 m
.02756 .36001 L
s
.02381 .3793 m
.02756 .3793 L
s
.02381 .41787 m
.02756 .41787 L
s
.02381 .43716 m
.02756 .43716 L
s
.02381 .45645 m
.02756 .45645 L
s
.02381 .47574 m
.02756 .47574 L
s
.02381 .51432 m
.02756 .51432 L
s
.02381 .53361 m
.02756 .53361 L
s
.02381 .5529 m
.02756 .5529 L
s
.02381 .57219 m
.02756 .57219 L
s
.02381 .61077 m
.02756 .61077 L
s
.01 w
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.0075 w
.02698 .01472 m
.03016 .01662 L
.03333 .01852 L
.03651 .02039 L
.03968 .02224 L
.04286 .02407 L
.04603 .02589 L
.04921 .02769 L
.05238 .02947 L
.05556 .03123 L
.05873 .03298 L
.0619 .0347 L
.06508 .03641 L
.06825 .0381 L
.07143 .03978 L
.0746 .04144 L
.07778 .04308 L
.08095 .04471 L
.08413 .04632 L
.0873 .04791 L
.09048 .04949 L
.09365 .05105 L
.09683 .0526 L
.1 .05413 L
.10317 .05564 L
.10635 .05714 L
.10952 .05863 L
.1127 .0601 L
.11587 .06156 L
.11905 .063 L
.12222 .06442 L
.1254 .06584 L
.12857 .06724 L
.13175 .06862 L
.13492 .06999 L
.1381 .07135 L
.14127 .07269 L
.14444 .07402 L
.14762 .07534 L
.15079 .07664 L
.15397 .07793 L
.15714 .07921 L
.16032 .08047 L
.16349 .08173 L
.16667 .08297 L
.16984 .08419 L
.17302 .08541 L
.17619 .08661 L
.17937 .0878 L
.18254 .08898 L
Mistroke
.18571 .09015 L
.18889 .0913 L
.19206 .09245 L
.19524 .09358 L
.19841 .0947 L
.20159 .09581 L
.20476 .09691 L
.20794 .098 L
.21111 .09907 L
.21429 .10014 L
.21746 .10119 L
.22063 .10224 L
.22381 .10327 L
.22698 .1043 L
.23016 .10531 L
.23333 .10632 L
.23651 .10731 L
.23968 .10829 L
.24286 .10927 L
.24603 .11023 L
.24921 .11119 L
.25238 .11213 L
.25556 .11307 L
.25873 .11399 L
.2619 .11491 L
.26508 .11582 L
.26825 .11672 L
.27143 .11761 L
.2746 .11849 L
.27778 .11936 L
.28095 .12022 L
.28413 .12108 L
.2873 .12192 L
.29048 .12276 L
.29365 .12359 L
.29683 .12441 L
.3 .12522 L
.30317 .12603 L
.30635 .12682 L
.30952 .12761 L
.3127 .12839 L
.31587 .12917 L
.31905 .12993 L
.32222 .13069 L
.3254 .13144 L
.32857 .13218 L
.33175 .13292 L
.33492 .13364 L
.3381 .13436 L
.34127 .13508 L
Mistroke
.34444 .13578 L
.34762 .13648 L
.35079 .13718 L
.35397 .13786 L
.35714 .13854 L
.36032 .13921 L
.36349 .13987 L
.36667 .14053 L
.36984 .14118 L
.37302 .14183 L
.37619 .14247 L
.37937 .1431 L
.38254 .14373 L
.38571 .14435 L
.38889 .14496 L
.39206 .14557 L
.39524 .14617 L
.39841 .14676 L
.40159 .14735 L
.40476 .14794 L
.40794 .14851 L
.41111 .14908 L
.41429 .14965 L
.41746 .15021 L
.42063 .15077 L
.42381 .15131 L
.42698 .15186 L
.43016 .1524 L
.43333 .15293 L
.43651 .15346 L
.43968 .15398 L
.44286 .1545 L
.44603 .15501 L
.44921 .15552 L
.45238 .15602 L
.45556 .15651 L
.45873 .15701 L
.4619 .15749 L
.46508 .15797 L
.46825 .15845 L
.47143 .15892 L
.4746 .15939 L
.47778 .15985 L
.48095 .16031 L
.48413 .16077 L
.4873 .16122 L
.49048 .16166 L
.49365 .1621 L
.49683 .16254 L
.5 .16297 L
Mistroke
.50317 .16339 L
.50635 .16382 L
.50952 .16424 L
.5127 .16465 L
.51587 .16506 L
.51905 .16547 L
.52222 .16587 L
.5254 .16627 L
.52857 .16666 L
.53175 .16705 L
.53492 .16744 L
.5381 .16782 L
.54127 .1682 L
.54444 .16857 L
.54762 .16895 L
.55079 .16931 L
.55397 .16968 L
.55714 .17004 L
.56032 .17039 L
.56349 .17075 L
.56667 .1711 L
.56984 .17144 L
.57302 .17178 L
.57619 .17212 L
.57937 .17246 L
.58254 .17279 L
.58571 .17312 L
.58889 .17345 L
.59206 .17377 L
.59524 .17409 L
.59841 .1744 L
.60159 .17472 L
.60476 .17503 L
.60794 .17533 L
.61111 .17564 L
.61429 .17594 L
.61746 .17623 L
.62063 .17653 L
.62381 .17682 L
.62698 .17711 L
.63016 .17739 L
.63333 .17768 L
.63651 .17796 L
.63968 .17823 L
.64286 .17851 L
.64603 .17878 L
.64921 .17905 L
.65238 .17932 L
.65556 .17958 L
.65873 .17984 L
Mistroke
.6619 .1801 L
.66508 .18036 L
.66825 .18061 L
.67143 .18086 L
.6746 .18111 L
.67778 .18135 L
.68095 .1816 L
.68413 .18184 L
.6873 .18208 L
.69048 .18231 L
.69365 .18255 L
.69683 .18278 L
.7 .18301 L
.70317 .18323 L
.70635 .18346 L
.70952 .18368 L
.7127 .1839 L
.71587 .18412 L
.71905 .18433 L
.72222 .18455 L
.7254 .18476 L
.72857 .18497 L
.73175 .18517 L
.73492 .18538 L
.7381 .18558 L
.74127 .18578 L
.74444 .18598 L
.74762 .18618 L
.75079 .18638 L
.75397 .18657 L
.75714 .18676 L
.76032 .18695 L
.76349 .18714 L
.76667 .18732 L
.76984 .18751 L
.77302 .18769 L
.77619 .18787 L
.77937 .18805 L
.78254 .18822 L
.78571 .1884 L
.78889 .18857 L
.79206 .18874 L
.79524 .18891 L
.79841 .18908 L
.80159 .18924 L
.80476 .18941 L
.80794 .18957 L
.81111 .18973 L
.81429 .18989 L
.81746 .19005 L
Mistroke
.82063 .19021 L
.82381 .19036 L
.82698 .19051 L
.83016 .19067 L
.83333 .19082 L
.83651 .19096 L
.83968 .19111 L
.84286 .19126 L
.84603 .1914 L
.84921 .19154 L
.85238 .19169 L
.85556 .19183 L
.85873 .19196 L
.8619 .1921 L
.86508 .19224 L
.86825 .19237 L
.87143 .19251 L
.8746 .19264 L
.87778 .19277 L
.88095 .1929 L
.88413 .19302 L
.8873 .19315 L
.89048 .19328 L
.89365 .1934 L
.89683 .19352 L
.9 .19365 L
.90317 .19377 L
.90635 .19388 L
.90952 .194 L
.9127 .19412 L
.91587 .19424 L
.91905 .19435 L
.92222 .19446 L
.9254 .19458 L
.92857 .19469 L
.93175 .1948 L
.93492 .19491 L
.9381 .19501 L
.94127 .19512 L
.94444 .19523 L
.94762 .19533 L
.95079 .19543 L
.95397 .19554 L
.95714 .19564 L
.96032 .19574 L
.96349 .19584 L
.96667 .19594 L
.96984 .19603 L
.97302 .19613 L
.97619 .19623 L
Mistroke
Mfstroke
.0001 w
.02698 .01472 -1.875 0 Mabsadd m
.02698 .01472 0 2.5 Mabsadd L
.02698 .01472 1.875 0 Mabsadd L
.02698 .01472 0 -2.5 Mabsadd L
.02698 .01472 -1.875 0 Mabsadd L closepath F
.03016 .01662 -1.875 0 Mabsadd m
.03016 .01662 0 2.5 Mabsadd L
.03016 .01662 1.875 0 Mabsadd L
.03016 .01662 0 -2.5 Mabsadd L
.03016 .01662 -1.875 0 Mabsadd L closepath F
.03333 .01852 -1.875 0 Mabsadd m
.03333 .01852 0 2.5 Mabsadd L
.03333 .01852 1.875 0 Mabsadd L
.03333 .01852 0 -2.5 Mabsadd L
.03333 .01852 -1.875 0 Mabsadd L closepath F
.03651 .02039 -1.875 0 Mabsadd m
.03651 .02039 0 2.5 Mabsadd L
.03651 .02039 1.875 0 Mabsadd L
.03651 .02039 0 -2.5 Mabsadd L
.03651 .02039 -1.875 0 Mabsadd L closepath F
.03968 .02224 -1.875 0 Mabsadd m
.03968 .02224 0 2.5 Mabsadd L
.03968 .02224 1.875 0 Mabsadd L
.03968 .02224 0 -2.5 Mabsadd L
.03968 .02224 -1.875 0 Mabsadd L closepath F
.04286 .02407 -1.875 0 Mabsadd m
.04286 .02407 0 2.5 Mabsadd L
.04286 .02407 1.875 0 Mabsadd L
.04286 .02407 0 -2.5 Mabsadd L
.04286 .02407 -1.875 0 Mabsadd L closepath F
.04603 .02589 -1.875 0 Mabsadd m
.04603 .02589 0 2.5 Mabsadd L
.04603 .02589 1.875 0 Mabsadd L
.04603 .02589 0 -2.5 Mabsadd L
.04603 .02589 -1.875 0 Mabsadd L closepath F
.04921 .02769 -1.875 0 Mabsadd m
.04921 .02769 0 2.5 Mabsadd L
.04921 .02769 1.875 0 Mabsadd L
.04921 .02769 0 -2.5 Mabsadd L
.04921 .02769 -1.875 0 Mabsadd L closepath F
.05238 .02947 -1.875 0 Mabsadd m
.05238 .02947 0 2.5 Mabsadd L
.05238 .02947 1.875 0 Mabsadd L
.05238 .02947 0 -2.5 Mabsadd L
.05238 .02947 -1.875 0 Mabsadd L closepath F
.05556 .03123 -1.875 0 Mabsadd m
.05556 .03123 0 2.5 Mabsadd L
.05556 .03123 1.875 0 Mabsadd L
.05556 .03123 0 -2.5 Mabsadd L
.05556 .03123 -1.875 0 Mabsadd L closepath F
.05873 .03298 -1.875 0 Mabsadd m
.05873 .03298 0 2.5 Mabsadd L
.05873 .03298 1.875 0 Mabsadd L
.05873 .03298 0 -2.5 Mabsadd L
.05873 .03298 -1.875 0 Mabsadd L closepath F
.0619 .0347 -1.875 0 Mabsadd m
.0619 .0347 0 2.5 Mabsadd L
.0619 .0347 1.875 0 Mabsadd L
.0619 .0347 0 -2.5 Mabsadd L
.0619 .0347 -1.875 0 Mabsadd L closepath F
.06508 .03641 -1.875 0 Mabsadd m
.06508 .03641 0 2.5 Mabsadd L
.06508 .03641 1.875 0 Mabsadd L
.06508 .03641 0 -2.5 Mabsadd L
.06508 .03641 -1.875 0 Mabsadd L closepath F
.06825 .0381 -1.875 0 Mabsadd m
.06825 .0381 0 2.5 Mabsadd L
.06825 .0381 1.875 0 Mabsadd L
.06825 .0381 0 -2.5 Mabsadd L
.06825 .0381 -1.875 0 Mabsadd L closepath F
.07143 .03978 -1.875 0 Mabsadd m
.07143 .03978 0 2.5 Mabsadd L
.07143 .03978 1.875 0 Mabsadd L
.07143 .03978 0 -2.5 Mabsadd L
.07143 .03978 -1.875 0 Mabsadd L closepath F
.0746 .04144 -1.875 0 Mabsadd m
.0746 .04144 0 2.5 Mabsadd L
.0746 .04144 1.875 0 Mabsadd L
.0746 .04144 0 -2.5 Mabsadd L
.0746 .04144 -1.875 0 Mabsadd L closepath F
.07778 .04308 -1.875 0 Mabsadd m
.07778 .04308 0 2.5 Mabsadd L
.07778 .04308 1.875 0 Mabsadd L
.07778 .04308 0 -2.5 Mabsadd L
.07778 .04308 -1.875 0 Mabsadd L closepath F
.08095 .04471 -1.875 0 Mabsadd m
.08095 .04471 0 2.5 Mabsadd L
.08095 .04471 1.875 0 Mabsadd L
.08095 .04471 0 -2.5 Mabsadd L
.08095 .04471 -1.875 0 Mabsadd L closepath F
.08413 .04632 -1.875 0 Mabsadd m
.08413 .04632 0 2.5 Mabsadd L
.08413 .04632 1.875 0 Mabsadd L
.08413 .04632 0 -2.5 Mabsadd L
.08413 .04632 -1.875 0 Mabsadd L closepath F
.0873 .04791 -1.875 0 Mabsadd m
.0873 .04791 0 2.5 Mabsadd L
.0873 .04791 1.875 0 Mabsadd L
.0873 .04791 0 -2.5 Mabsadd L
.0873 .04791 -1.875 0 Mabsadd L closepath F
.09048 .04949 -1.875 0 Mabsadd m
.09048 .04949 0 2.5 Mabsadd L
.09048 .04949 1.875 0 Mabsadd L
.09048 .04949 0 -2.5 Mabsadd L
.09048 .04949 -1.875 0 Mabsadd L closepath F
.09365 .05105 -1.875 0 Mabsadd m
.09365 .05105 0 2.5 Mabsadd L
.09365 .05105 1.875 0 Mabsadd L
.09365 .05105 0 -2.5 Mabsadd L
.09365 .05105 -1.875 0 Mabsadd L closepath F
.09683 .0526 -1.875 0 Mabsadd m
.09683 .0526 0 2.5 Mabsadd L
.09683 .0526 1.875 0 Mabsadd L
.09683 .0526 0 -2.5 Mabsadd L
.09683 .0526 -1.875 0 Mabsadd L closepath F
.1 .05413 -1.875 0 Mabsadd m
.1 .05413 0 2.5 Mabsadd L
.1 .05413 1.875 0 Mabsadd L
.1 .05413 0 -2.5 Mabsadd L
.1 .05413 -1.875 0 Mabsadd L closepath F
.10317 .05564 -1.875 0 Mabsadd m
.10317 .05564 0 2.5 Mabsadd L
.10317 .05564 1.875 0 Mabsadd L
.10317 .05564 0 -2.5 Mabsadd L
.10317 .05564 -1.875 0 Mabsadd L closepath F
.10635 .05714 -1.875 0 Mabsadd m
.10635 .05714 0 2.5 Mabsadd L
.10635 .05714 1.875 0 Mabsadd L
.10635 .05714 0 -2.5 Mabsadd L
.10635 .05714 -1.875 0 Mabsadd L closepath F
.10952 .05863 -1.875 0 Mabsadd m
.10952 .05863 0 2.5 Mabsadd L
.10952 .05863 1.875 0 Mabsadd L
.10952 .05863 0 -2.5 Mabsadd L
.10952 .05863 -1.875 0 Mabsadd L closepath F
.1127 .0601 -1.875 0 Mabsadd m
.1127 .0601 0 2.5 Mabsadd L
.1127 .0601 1.875 0 Mabsadd L
.1127 .0601 0 -2.5 Mabsadd L
.1127 .0601 -1.875 0 Mabsadd L closepath F
.11587 .06156 -1.875 0 Mabsadd m
.11587 .06156 0 2.5 Mabsadd L
.11587 .06156 1.875 0 Mabsadd L
.11587 .06156 0 -2.5 Mabsadd L
.11587 .06156 -1.875 0 Mabsadd L closepath F
.11905 .063 -1.875 0 Mabsadd m
.11905 .063 0 2.5 Mabsadd L
.11905 .063 1.875 0 Mabsadd L
.11905 .063 0 -2.5 Mabsadd L
.11905 .063 -1.875 0 Mabsadd L closepath F
.12222 .06442 -1.875 0 Mabsadd m
.12222 .06442 0 2.5 Mabsadd L
.12222 .06442 1.875 0 Mabsadd L
.12222 .06442 0 -2.5 Mabsadd L
.12222 .06442 -1.875 0 Mabsadd L closepath F
.1254 .06584 -1.875 0 Mabsadd m
.1254 .06584 0 2.5 Mabsadd L
.1254 .06584 1.875 0 Mabsadd L
.1254 .06584 0 -2.5 Mabsadd L
.1254 .06584 -1.875 0 Mabsadd L closepath F
.12857 .06724 -1.875 0 Mabsadd m
.12857 .06724 0 2.5 Mabsadd L
.12857 .06724 1.875 0 Mabsadd L
.12857 .06724 0 -2.5 Mabsadd L
.12857 .06724 -1.875 0 Mabsadd L closepath F
.13175 .06862 -1.875 0 Mabsadd m
.13175 .06862 0 2.5 Mabsadd L
.13175 .06862 1.875 0 Mabsadd L
.13175 .06862 0 -2.5 Mabsadd L
.13175 .06862 -1.875 0 Mabsadd L closepath F
.13492 .06999 -1.875 0 Mabsadd m
.13492 .06999 0 2.5 Mabsadd L
.13492 .06999 1.875 0 Mabsadd L
.13492 .06999 0 -2.5 Mabsadd L
.13492 .06999 -1.875 0 Mabsadd L closepath F
.1381 .07135 -1.875 0 Mabsadd m
.1381 .07135 0 2.5 Mabsadd L
.1381 .07135 1.875 0 Mabsadd L
.1381 .07135 0 -2.5 Mabsadd L
.1381 .07135 -1.875 0 Mabsadd L closepath F
.14127 .07269 -1.875 0 Mabsadd m
.14127 .07269 0 2.5 Mabsadd L
.14127 .07269 1.875 0 Mabsadd L
.14127 .07269 0 -2.5 Mabsadd L
.14127 .07269 -1.875 0 Mabsadd L closepath F
.14444 .07402 -1.875 0 Mabsadd m
.14444 .07402 0 2.5 Mabsadd L
.14444 .07402 1.875 0 Mabsadd L
.14444 .07402 0 -2.5 Mabsadd L
.14444 .07402 -1.875 0 Mabsadd L closepath F
.14762 .07534 -1.875 0 Mabsadd m
.14762 .07534 0 2.5 Mabsadd L
.14762 .07534 1.875 0 Mabsadd L
.14762 .07534 0 -2.5 Mabsadd L
.14762 .07534 -1.875 0 Mabsadd L closepath F
.15079 .07664 -1.875 0 Mabsadd m
.15079 .07664 0 2.5 Mabsadd L
.15079 .07664 1.875 0 Mabsadd L
.15079 .07664 0 -2.5 Mabsadd L
.15079 .07664 -1.875 0 Mabsadd L closepath F
.15397 .07793 -1.875 0 Mabsadd m
.15397 .07793 0 2.5 Mabsadd L
.15397 .07793 1.875 0 Mabsadd L
.15397 .07793 0 -2.5 Mabsadd L
.15397 .07793 -1.875 0 Mabsadd L closepath F
.15714 .07921 -1.875 0 Mabsadd m
.15714 .07921 0 2.5 Mabsadd L
.15714 .07921 1.875 0 Mabsadd L
.15714 .07921 0 -2.5 Mabsadd L
.15714 .07921 -1.875 0 Mabsadd L closepath F
.16032 .08047 -1.875 0 Mabsadd m
.16032 .08047 0 2.5 Mabsadd L
.16032 .08047 1.875 0 Mabsadd L
.16032 .08047 0 -2.5 Mabsadd L
.16032 .08047 -1.875 0 Mabsadd L closepath F
.16349 .08173 -1.875 0 Mabsadd m
.16349 .08173 0 2.5 Mabsadd L
.16349 .08173 1.875 0 Mabsadd L
.16349 .08173 0 -2.5 Mabsadd L
.16349 .08173 -1.875 0 Mabsadd L closepath F
.16667 .08297 -1.875 0 Mabsadd m
.16667 .08297 0 2.5 Mabsadd L
.16667 .08297 1.875 0 Mabsadd L
.16667 .08297 0 -2.5 Mabsadd L
.16667 .08297 -1.875 0 Mabsadd L closepath F
.16984 .08419 -1.875 0 Mabsadd m
.16984 .08419 0 2.5 Mabsadd L
.16984 .08419 1.875 0 Mabsadd L
.16984 .08419 0 -2.5 Mabsadd L
.16984 .08419 -1.875 0 Mabsadd L closepath F
.17302 .08541 -1.875 0 Mabsadd m
.17302 .08541 0 2.5 Mabsadd L
.17302 .08541 1.875 0 Mabsadd L
.17302 .08541 0 -2.5 Mabsadd L
.17302 .08541 -1.875 0 Mabsadd L closepath F
.17619 .08661 -1.875 0 Mabsadd m
.17619 .08661 0 2.5 Mabsadd L
.17619 .08661 1.875 0 Mabsadd L
.17619 .08661 0 -2.5 Mabsadd L
.17619 .08661 -1.875 0 Mabsadd L closepath F
.17937 .0878 -1.875 0 Mabsadd m
.17937 .0878 0 2.5 Mabsadd L
.17937 .0878 1.875 0 Mabsadd L
.17937 .0878 0 -2.5 Mabsadd L
.17937 .0878 -1.875 0 Mabsadd L closepath F
.18254 .08898 -1.875 0 Mabsadd m
.18254 .08898 0 2.5 Mabsadd L
.18254 .08898 1.875 0 Mabsadd L
.18254 .08898 0 -2.5 Mabsadd L
.18254 .08898 -1.875 0 Mabsadd L closepath F
.18571 .09015 -1.875 0 Mabsadd m
.18571 .09015 0 2.5 Mabsadd L
.18571 .09015 1.875 0 Mabsadd L
.18571 .09015 0 -2.5 Mabsadd L
.18571 .09015 -1.875 0 Mabsadd L closepath F
.18889 .0913 -1.875 0 Mabsadd m
.18889 .0913 0 2.5 Mabsadd L
.18889 .0913 1.875 0 Mabsadd L
.18889 .0913 0 -2.5 Mabsadd L
.18889 .0913 -1.875 0 Mabsadd L closepath F
.19206 .09245 -1.875 0 Mabsadd m
.19206 .09245 0 2.5 Mabsadd L
.19206 .09245 1.875 0 Mabsadd L
.19206 .09245 0 -2.5 Mabsadd L
.19206 .09245 -1.875 0 Mabsadd L closepath F
.19524 .09358 -1.875 0 Mabsadd m
.19524 .09358 0 2.5 Mabsadd L
.19524 .09358 1.875 0 Mabsadd L
.19524 .09358 0 -2.5 Mabsadd L
.19524 .09358 -1.875 0 Mabsadd L closepath F
.19841 .0947 -1.875 0 Mabsadd m
.19841 .0947 0 2.5 Mabsadd L
.19841 .0947 1.875 0 Mabsadd L
.19841 .0947 0 -2.5 Mabsadd L
.19841 .0947 -1.875 0 Mabsadd L closepath F
.20159 .09581 -1.875 0 Mabsadd m
.20159 .09581 0 2.5 Mabsadd L
.20159 .09581 1.875 0 Mabsadd L
.20159 .09581 0 -2.5 Mabsadd L
.20159 .09581 -1.875 0 Mabsadd L closepath F
.20476 .09691 -1.875 0 Mabsadd m
.20476 .09691 0 2.5 Mabsadd L
.20476 .09691 1.875 0 Mabsadd L
.20476 .09691 0 -2.5 Mabsadd L
.20476 .09691 -1.875 0 Mabsadd L closepath F
.20794 .098 -1.875 0 Mabsadd m
.20794 .098 0 2.5 Mabsadd L
.20794 .098 1.875 0 Mabsadd L
.20794 .098 0 -2.5 Mabsadd L
.20794 .098 -1.875 0 Mabsadd L closepath F
.21111 .09907 -1.875 0 Mabsadd m
.21111 .09907 0 2.5 Mabsadd L
.21111 .09907 1.875 0 Mabsadd L
.21111 .09907 0 -2.5 Mabsadd L
.21111 .09907 -1.875 0 Mabsadd L closepath F
.21429 .10014 -1.875 0 Mabsadd m
.21429 .10014 0 2.5 Mabsadd L
.21429 .10014 1.875 0 Mabsadd L
.21429 .10014 0 -2.5 Mabsadd L
.21429 .10014 -1.875 0 Mabsadd L closepath F
.21746 .10119 -1.875 0 Mabsadd m
.21746 .10119 0 2.5 Mabsadd L
.21746 .10119 1.875 0 Mabsadd L
.21746 .10119 0 -2.5 Mabsadd L
.21746 .10119 -1.875 0 Mabsadd L closepath F
.22063 .10224 -1.875 0 Mabsadd m
.22063 .10224 0 2.5 Mabsadd L
.22063 .10224 1.875 0 Mabsadd L
.22063 .10224 0 -2.5 Mabsadd L
.22063 .10224 -1.875 0 Mabsadd L closepath F
.22381 .10327 -1.875 0 Mabsadd m
.22381 .10327 0 2.5 Mabsadd L
.22381 .10327 1.875 0 Mabsadd L
.22381 .10327 0 -2.5 Mabsadd L
.22381 .10327 -1.875 0 Mabsadd L closepath F
.22698 .1043 -1.875 0 Mabsadd m
.22698 .1043 0 2.5 Mabsadd L
.22698 .1043 1.875 0 Mabsadd L
.22698 .1043 0 -2.5 Mabsadd L
.22698 .1043 -1.875 0 Mabsadd L closepath F
.23016 .10531 -1.875 0 Mabsadd m
.23016 .10531 0 2.5 Mabsadd L
.23016 .10531 1.875 0 Mabsadd L
.23016 .10531 0 -2.5 Mabsadd L
.23016 .10531 -1.875 0 Mabsadd L closepath F
.23333 .10632 -1.875 0 Mabsadd m
.23333 .10632 0 2.5 Mabsadd L
.23333 .10632 1.875 0 Mabsadd L
.23333 .10632 0 -2.5 Mabsadd L
.23333 .10632 -1.875 0 Mabsadd L closepath F
.23651 .10731 -1.875 0 Mabsadd m
.23651 .10731 0 2.5 Mabsadd L
.23651 .10731 1.875 0 Mabsadd L
.23651 .10731 0 -2.5 Mabsadd L
.23651 .10731 -1.875 0 Mabsadd L closepath F
.23968 .10829 -1.875 0 Mabsadd m
.23968 .10829 0 2.5 Mabsadd L
.23968 .10829 1.875 0 Mabsadd L
.23968 .10829 0 -2.5 Mabsadd L
.23968 .10829 -1.875 0 Mabsadd L closepath F
.24286 .10927 -1.875 0 Mabsadd m
.24286 .10927 0 2.5 Mabsadd L
.24286 .10927 1.875 0 Mabsadd L
.24286 .10927 0 -2.5 Mabsadd L
.24286 .10927 -1.875 0 Mabsadd L closepath F
.24603 .11023 -1.875 0 Mabsadd m
.24603 .11023 0 2.5 Mabsadd L
.24603 .11023 1.875 0 Mabsadd L
.24603 .11023 0 -2.5 Mabsadd L
.24603 .11023 -1.875 0 Mabsadd L closepath F
.24921 .11119 -1.875 0 Mabsadd m
.24921 .11119 0 2.5 Mabsadd L
.24921 .11119 1.875 0 Mabsadd L
.24921 .11119 0 -2.5 Mabsadd L
.24921 .11119 -1.875 0 Mabsadd L closepath F
.25238 .11213 -1.875 0 Mabsadd m
.25238 .11213 0 2.5 Mabsadd L
.25238 .11213 1.875 0 Mabsadd L
.25238 .11213 0 -2.5 Mabsadd L
.25238 .11213 -1.875 0 Mabsadd L closepath F
.25556 .11307 -1.875 0 Mabsadd m
.25556 .11307 0 2.5 Mabsadd L
.25556 .11307 1.875 0 Mabsadd L
.25556 .11307 0 -2.5 Mabsadd L
.25556 .11307 -1.875 0 Mabsadd L closepath F
.25873 .11399 -1.875 0 Mabsadd m
.25873 .11399 0 2.5 Mabsadd L
.25873 .11399 1.875 0 Mabsadd L
.25873 .11399 0 -2.5 Mabsadd L
.25873 .11399 -1.875 0 Mabsadd L closepath F
.2619 .11491 -1.875 0 Mabsadd m
.2619 .11491 0 2.5 Mabsadd L
.2619 .11491 1.875 0 Mabsadd L
.2619 .11491 0 -2.5 Mabsadd L
.2619 .11491 -1.875 0 Mabsadd L closepath F
.26508 .11582 -1.875 0 Mabsadd m
.26508 .11582 0 2.5 Mabsadd L
.26508 .11582 1.875 0 Mabsadd L
.26508 .11582 0 -2.5 Mabsadd L
.26508 .11582 -1.875 0 Mabsadd L closepath F
.26825 .11672 -1.875 0 Mabsadd m
.26825 .11672 0 2.5 Mabsadd L
.26825 .11672 1.875 0 Mabsadd L
.26825 .11672 0 -2.5 Mabsadd L
.26825 .11672 -1.875 0 Mabsadd L closepath F
.27143 .11761 -1.875 0 Mabsadd m
.27143 .11761 0 2.5 Mabsadd L
.27143 .11761 1.875 0 Mabsadd L
.27143 .11761 0 -2.5 Mabsadd L
.27143 .11761 -1.875 0 Mabsadd L closepath F
.2746 .11849 -1.875 0 Mabsadd m
.2746 .11849 0 2.5 Mabsadd L
.2746 .11849 1.875 0 Mabsadd L
.2746 .11849 0 -2.5 Mabsadd L
.2746 .11849 -1.875 0 Mabsadd L closepath F
.27778 .11936 -1.875 0 Mabsadd m
.27778 .11936 0 2.5 Mabsadd L
.27778 .11936 1.875 0 Mabsadd L
.27778 .11936 0 -2.5 Mabsadd L
.27778 .11936 -1.875 0 Mabsadd L closepath F
.28095 .12022 -1.875 0 Mabsadd m
.28095 .12022 0 2.5 Mabsadd L
.28095 .12022 1.875 0 Mabsadd L
.28095 .12022 0 -2.5 Mabsadd L
.28095 .12022 -1.875 0 Mabsadd L closepath F
.28413 .12108 -1.875 0 Mabsadd m
.28413 .12108 0 2.5 Mabsadd L
.28413 .12108 1.875 0 Mabsadd L
.28413 .12108 0 -2.5 Mabsadd L
.28413 .12108 -1.875 0 Mabsadd L closepath F
.2873 .12192 -1.875 0 Mabsadd m
.2873 .12192 0 2.5 Mabsadd L
.2873 .12192 1.875 0 Mabsadd L
.2873 .12192 0 -2.5 Mabsadd L
.2873 .12192 -1.875 0 Mabsadd L closepath F
.29048 .12276 -1.875 0 Mabsadd m
.29048 .12276 0 2.5 Mabsadd L
.29048 .12276 1.875 0 Mabsadd L
.29048 .12276 0 -2.5 Mabsadd L
.29048 .12276 -1.875 0 Mabsadd L closepath F
.29365 .12359 -1.875 0 Mabsadd m
.29365 .12359 0 2.5 Mabsadd L
.29365 .12359 1.875 0 Mabsadd L
.29365 .12359 0 -2.5 Mabsadd L
.29365 .12359 -1.875 0 Mabsadd L closepath F
.29683 .12441 -1.875 0 Mabsadd m
.29683 .12441 0 2.5 Mabsadd L
.29683 .12441 1.875 0 Mabsadd L
.29683 .12441 0 -2.5 Mabsadd L
.29683 .12441 -1.875 0 Mabsadd L closepath F
.3 .12522 -1.875 0 Mabsadd m
.3 .12522 0 2.5 Mabsadd L
.3 .12522 1.875 0 Mabsadd L
.3 .12522 0 -2.5 Mabsadd L
.3 .12522 -1.875 0 Mabsadd L closepath F
.30317 .12603 -1.875 0 Mabsadd m
.30317 .12603 0 2.5 Mabsadd L
.30317 .12603 1.875 0 Mabsadd L
.30317 .12603 0 -2.5 Mabsadd L
.30317 .12603 -1.875 0 Mabsadd L closepath F
.30635 .12682 -1.875 0 Mabsadd m
.30635 .12682 0 2.5 Mabsadd L
.30635 .12682 1.875 0 Mabsadd L
.30635 .12682 0 -2.5 Mabsadd L
.30635 .12682 -1.875 0 Mabsadd L closepath F
.30952 .12761 -1.875 0 Mabsadd m
.30952 .12761 0 2.5 Mabsadd L
.30952 .12761 1.875 0 Mabsadd L
.30952 .12761 0 -2.5 Mabsadd L
.30952 .12761 -1.875 0 Mabsadd L closepath F
.3127 .12839 -1.875 0 Mabsadd m
.3127 .12839 0 2.5 Mabsadd L
.3127 .12839 1.875 0 Mabsadd L
.3127 .12839 0 -2.5 Mabsadd L
.3127 .12839 -1.875 0 Mabsadd L closepath F
.31587 .12917 -1.875 0 Mabsadd m
.31587 .12917 0 2.5 Mabsadd L
.31587 .12917 1.875 0 Mabsadd L
.31587 .12917 0 -2.5 Mabsadd L
.31587 .12917 -1.875 0 Mabsadd L closepath F
.31905 .12993 -1.875 0 Mabsadd m
.31905 .12993 0 2.5 Mabsadd L
.31905 .12993 1.875 0 Mabsadd L
.31905 .12993 0 -2.5 Mabsadd L
.31905 .12993 -1.875 0 Mabsadd L closepath F
.32222 .13069 -1.875 0 Mabsadd m
.32222 .13069 0 2.5 Mabsadd L
.32222 .13069 1.875 0 Mabsadd L
.32222 .13069 0 -2.5 Mabsadd L
.32222 .13069 -1.875 0 Mabsadd L closepath F
.3254 .13144 -1.875 0 Mabsadd m
.3254 .13144 0 2.5 Mabsadd L
.3254 .13144 1.875 0 Mabsadd L
.3254 .13144 0 -2.5 Mabsadd L
.3254 .13144 -1.875 0 Mabsadd L closepath F
.32857 .13218 -1.875 0 Mabsadd m
.32857 .13218 0 2.5 Mabsadd L
.32857 .13218 1.875 0 Mabsadd L
.32857 .13218 0 -2.5 Mabsadd L
.32857 .13218 -1.875 0 Mabsadd L closepath F
.33175 .13292 -1.875 0 Mabsadd m
.33175 .13292 0 2.5 Mabsadd L
.33175 .13292 1.875 0 Mabsadd L
.33175 .13292 0 -2.5 Mabsadd L
.33175 .13292 -1.875 0 Mabsadd L closepath F
.33492 .13364 -1.875 0 Mabsadd m
.33492 .13364 0 2.5 Mabsadd L
.33492 .13364 1.875 0 Mabsadd L
.33492 .13364 0 -2.5 Mabsadd L
.33492 .13364 -1.875 0 Mabsadd L closepath F
.3381 .13436 -1.875 0 Mabsadd m
.3381 .13436 0 2.5 Mabsadd L
.3381 .13436 1.875 0 Mabsadd L
.3381 .13436 0 -2.5 Mabsadd L
.3381 .13436 -1.875 0 Mabsadd L closepath F
.34127 .13508 -1.875 0 Mabsadd m
.34127 .13508 0 2.5 Mabsadd L
.34127 .13508 1.875 0 Mabsadd L
.34127 .13508 0 -2.5 Mabsadd L
.34127 .13508 -1.875 0 Mabsadd L closepath F
.34444 .13578 -1.875 0 Mabsadd m
.34444 .13578 0 2.5 Mabsadd L
.34444 .13578 1.875 0 Mabsadd L
.34444 .13578 0 -2.5 Mabsadd L
.34444 .13578 -1.875 0 Mabsadd L closepath F
.34762 .13648 -1.875 0 Mabsadd m
.34762 .13648 0 2.5 Mabsadd L
.34762 .13648 1.875 0 Mabsadd L
.34762 .13648 0 -2.5 Mabsadd L
.34762 .13648 -1.875 0 Mabsadd L closepath F
.35079 .13718 -1.875 0 Mabsadd m
.35079 .13718 0 2.5 Mabsadd L
.35079 .13718 1.875 0 Mabsadd L
.35079 .13718 0 -2.5 Mabsadd L
.35079 .13718 -1.875 0 Mabsadd L closepath F
.35397 .13786 -1.875 0 Mabsadd m
.35397 .13786 0 2.5 Mabsadd L
.35397 .13786 1.875 0 Mabsadd L
.35397 .13786 0 -2.5 Mabsadd L
.35397 .13786 -1.875 0 Mabsadd L closepath F
.35714 .13854 -1.875 0 Mabsadd m
.35714 .13854 0 2.5 Mabsadd L
.35714 .13854 1.875 0 Mabsadd L
.35714 .13854 0 -2.5 Mabsadd L
.35714 .13854 -1.875 0 Mabsadd L closepath F
.36032 .13921 -1.875 0 Mabsadd m
.36032 .13921 0 2.5 Mabsadd L
.36032 .13921 1.875 0 Mabsadd L
.36032 .13921 0 -2.5 Mabsadd L
.36032 .13921 -1.875 0 Mabsadd L closepath F
.36349 .13987 -1.875 0 Mabsadd m
.36349 .13987 0 2.5 Mabsadd L
.36349 .13987 1.875 0 Mabsadd L
.36349 .13987 0 -2.5 Mabsadd L
.36349 .13987 -1.875 0 Mabsadd L closepath F
.36667 .14053 -1.875 0 Mabsadd m
.36667 .14053 0 2.5 Mabsadd L
.36667 .14053 1.875 0 Mabsadd L
.36667 .14053 0 -2.5 Mabsadd L
.36667 .14053 -1.875 0 Mabsadd L closepath F
.36984 .14118 -1.875 0 Mabsadd m
.36984 .14118 0 2.5 Mabsadd L
.36984 .14118 1.875 0 Mabsadd L
.36984 .14118 0 -2.5 Mabsadd L
.36984 .14118 -1.875 0 Mabsadd L closepath F
.37302 .14183 -1.875 0 Mabsadd m
.37302 .14183 0 2.5 Mabsadd L
.37302 .14183 1.875 0 Mabsadd L
.37302 .14183 0 -2.5 Mabsadd L
.37302 .14183 -1.875 0 Mabsadd L closepath F
.37619 .14247 -1.875 0 Mabsadd m
.37619 .14247 0 2.5 Mabsadd L
.37619 .14247 1.875 0 Mabsadd L
.37619 .14247 0 -2.5 Mabsadd L
.37619 .14247 -1.875 0 Mabsadd L closepath F
.37937 .1431 -1.875 0 Mabsadd m
.37937 .1431 0 2.5 Mabsadd L
.37937 .1431 1.875 0 Mabsadd L
.37937 .1431 0 -2.5 Mabsadd L
.37937 .1431 -1.875 0 Mabsadd L closepath F
.38254 .14373 -1.875 0 Mabsadd m
.38254 .14373 0 2.5 Mabsadd L
.38254 .14373 1.875 0 Mabsadd L
.38254 .14373 0 -2.5 Mabsadd L
.38254 .14373 -1.875 0 Mabsadd L closepath F
.38571 .14435 -1.875 0 Mabsadd m
.38571 .14435 0 2.5 Mabsadd L
.38571 .14435 1.875 0 Mabsadd L
.38571 .14435 0 -2.5 Mabsadd L
.38571 .14435 -1.875 0 Mabsadd L closepath F
.38889 .14496 -1.875 0 Mabsadd m
.38889 .14496 0 2.5 Mabsadd L
.38889 .14496 1.875 0 Mabsadd L
.38889 .14496 0 -2.5 Mabsadd L
.38889 .14496 -1.875 0 Mabsadd L closepath F
.39206 .14557 -1.875 0 Mabsadd m
.39206 .14557 0 2.5 Mabsadd L
.39206 .14557 1.875 0 Mabsadd L
.39206 .14557 0 -2.5 Mabsadd L
.39206 .14557 -1.875 0 Mabsadd L closepath F
.39524 .14617 -1.875 0 Mabsadd m
.39524 .14617 0 2.5 Mabsadd L
.39524 .14617 1.875 0 Mabsadd L
.39524 .14617 0 -2.5 Mabsadd L
.39524 .14617 -1.875 0 Mabsadd L closepath F
.39841 .14676 -1.875 0 Mabsadd m
.39841 .14676 0 2.5 Mabsadd L
.39841 .14676 1.875 0 Mabsadd L
.39841 .14676 0 -2.5 Mabsadd L
.39841 .14676 -1.875 0 Mabsadd L closepath F
.40159 .14735 -1.875 0 Mabsadd m
.40159 .14735 0 2.5 Mabsadd L
.40159 .14735 1.875 0 Mabsadd L
.40159 .14735 0 -2.5 Mabsadd L
.40159 .14735 -1.875 0 Mabsadd L closepath F
.40476 .14794 -1.875 0 Mabsadd m
.40476 .14794 0 2.5 Mabsadd L
.40476 .14794 1.875 0 Mabsadd L
.40476 .14794 0 -2.5 Mabsadd L
.40476 .14794 -1.875 0 Mabsadd L closepath F
.40794 .14851 -1.875 0 Mabsadd m
.40794 .14851 0 2.5 Mabsadd L
.40794 .14851 1.875 0 Mabsadd L
.40794 .14851 0 -2.5 Mabsadd L
.40794 .14851 -1.875 0 Mabsadd L closepath F
.41111 .14908 -1.875 0 Mabsadd m
.41111 .14908 0 2.5 Mabsadd L
.41111 .14908 1.875 0 Mabsadd L
.41111 .14908 0 -2.5 Mabsadd L
.41111 .14908 -1.875 0 Mabsadd L closepath F
.41429 .14965 -1.875 0 Mabsadd m
.41429 .14965 0 2.5 Mabsadd L
.41429 .14965 1.875 0 Mabsadd L
.41429 .14965 0 -2.5 Mabsadd L
.41429 .14965 -1.875 0 Mabsadd L closepath F
.41746 .15021 -1.875 0 Mabsadd m
.41746 .15021 0 2.5 Mabsadd L
.41746 .15021 1.875 0 Mabsadd L
.41746 .15021 0 -2.5 Mabsadd L
.41746 .15021 -1.875 0 Mabsadd L closepath F
.42063 .15077 -1.875 0 Mabsadd m
.42063 .15077 0 2.5 Mabsadd L
.42063 .15077 1.875 0 Mabsadd L
.42063 .15077 0 -2.5 Mabsadd L
.42063 .15077 -1.875 0 Mabsadd L closepath F
.42381 .15131 -1.875 0 Mabsadd m
.42381 .15131 0 2.5 Mabsadd L
.42381 .15131 1.875 0 Mabsadd L
.42381 .15131 0 -2.5 Mabsadd L
.42381 .15131 -1.875 0 Mabsadd L closepath F
.42698 .15186 -1.875 0 Mabsadd m
.42698 .15186 0 2.5 Mabsadd L
.42698 .15186 1.875 0 Mabsadd L
.42698 .15186 0 -2.5 Mabsadd L
.42698 .15186 -1.875 0 Mabsadd L closepath F
.43016 .1524 -1.875 0 Mabsadd m
.43016 .1524 0 2.5 Mabsadd L
.43016 .1524 1.875 0 Mabsadd L
.43016 .1524 0 -2.5 Mabsadd L
.43016 .1524 -1.875 0 Mabsadd L closepath F
.43333 .15293 -1.875 0 Mabsadd m
.43333 .15293 0 2.5 Mabsadd L
.43333 .15293 1.875 0 Mabsadd L
.43333 .15293 0 -2.5 Mabsadd L
.43333 .15293 -1.875 0 Mabsadd L closepath F
.43651 .15346 -1.875 0 Mabsadd m
.43651 .15346 0 2.5 Mabsadd L
.43651 .15346 1.875 0 Mabsadd L
.43651 .15346 0 -2.5 Mabsadd L
.43651 .15346 -1.875 0 Mabsadd L closepath F
.43968 .15398 -1.875 0 Mabsadd m
.43968 .15398 0 2.5 Mabsadd L
.43968 .15398 1.875 0 Mabsadd L
.43968 .15398 0 -2.5 Mabsadd L
.43968 .15398 -1.875 0 Mabsadd L closepath F
.44286 .1545 -1.875 0 Mabsadd m
.44286 .1545 0 2.5 Mabsadd L
.44286 .1545 1.875 0 Mabsadd L
.44286 .1545 0 -2.5 Mabsadd L
.44286 .1545 -1.875 0 Mabsadd L closepath F
.44603 .15501 -1.875 0 Mabsadd m
.44603 .15501 0 2.5 Mabsadd L
.44603 .15501 1.875 0 Mabsadd L
.44603 .15501 0 -2.5 Mabsadd L
.44603 .15501 -1.875 0 Mabsadd L closepath F
.44921 .15552 -1.875 0 Mabsadd m
.44921 .15552 0 2.5 Mabsadd L
.44921 .15552 1.875 0 Mabsadd L
.44921 .15552 0 -2.5 Mabsadd L
.44921 .15552 -1.875 0 Mabsadd L closepath F
.45238 .15602 -1.875 0 Mabsadd m
.45238 .15602 0 2.5 Mabsadd L
.45238 .15602 1.875 0 Mabsadd L
.45238 .15602 0 -2.5 Mabsadd L
.45238 .15602 -1.875 0 Mabsadd L closepath F
.45556 .15651 -1.875 0 Mabsadd m
.45556 .15651 0 2.5 Mabsadd L
.45556 .15651 1.875 0 Mabsadd L
.45556 .15651 0 -2.5 Mabsadd L
.45556 .15651 -1.875 0 Mabsadd L closepath F
.45873 .15701 -1.875 0 Mabsadd m
.45873 .15701 0 2.5 Mabsadd L
.45873 .15701 1.875 0 Mabsadd L
.45873 .15701 0 -2.5 Mabsadd L
.45873 .15701 -1.875 0 Mabsadd L closepath F
.4619 .15749 -1.875 0 Mabsadd m
.4619 .15749 0 2.5 Mabsadd L
.4619 .15749 1.875 0 Mabsadd L
.4619 .15749 0 -2.5 Mabsadd L
.4619 .15749 -1.875 0 Mabsadd L closepath F
.46508 .15797 -1.875 0 Mabsadd m
.46508 .15797 0 2.5 Mabsadd L
.46508 .15797 1.875 0 Mabsadd L
.46508 .15797 0 -2.5 Mabsadd L
.46508 .15797 -1.875 0 Mabsadd L closepath F
.46825 .15845 -1.875 0 Mabsadd m
.46825 .15845 0 2.5 Mabsadd L
.46825 .15845 1.875 0 Mabsadd L
.46825 .15845 0 -2.5 Mabsadd L
.46825 .15845 -1.875 0 Mabsadd L closepath F
.47143 .15892 -1.875 0 Mabsadd m
.47143 .15892 0 2.5 Mabsadd L
.47143 .15892 1.875 0 Mabsadd L
.47143 .15892 0 -2.5 Mabsadd L
.47143 .15892 -1.875 0 Mabsadd L closepath F
.4746 .15939 -1.875 0 Mabsadd m
.4746 .15939 0 2.5 Mabsadd L
.4746 .15939 1.875 0 Mabsadd L
.4746 .15939 0 -2.5 Mabsadd L
.4746 .15939 -1.875 0 Mabsadd L closepath F
.47778 .15985 -1.875 0 Mabsadd m
.47778 .15985 0 2.5 Mabsadd L
.47778 .15985 1.875 0 Mabsadd L
.47778 .15985 0 -2.5 Mabsadd L
.47778 .15985 -1.875 0 Mabsadd L closepath F
.48095 .16031 -1.875 0 Mabsadd m
.48095 .16031 0 2.5 Mabsadd L
.48095 .16031 1.875 0 Mabsadd L
.48095 .16031 0 -2.5 Mabsadd L
.48095 .16031 -1.875 0 Mabsadd L closepath F
.48413 .16077 -1.875 0 Mabsadd m
.48413 .16077 0 2.5 Mabsadd L
.48413 .16077 1.875 0 Mabsadd L
.48413 .16077 0 -2.5 Mabsadd L
.48413 .16077 -1.875 0 Mabsadd L closepath F
.4873 .16122 -1.875 0 Mabsadd m
.4873 .16122 0 2.5 Mabsadd L
.4873 .16122 1.875 0 Mabsadd L
.4873 .16122 0 -2.5 Mabsadd L
.4873 .16122 -1.875 0 Mabsadd L closepath F
.49048 .16166 -1.875 0 Mabsadd m
.49048 .16166 0 2.5 Mabsadd L
.49048 .16166 1.875 0 Mabsadd L
.49048 .16166 0 -2.5 Mabsadd L
.49048 .16166 -1.875 0 Mabsadd L closepath F
.49365 .1621 -1.875 0 Mabsadd m
.49365 .1621 0 2.5 Mabsadd L
.49365 .1621 1.875 0 Mabsadd L
.49365 .1621 0 -2.5 Mabsadd L
.49365 .1621 -1.875 0 Mabsadd L closepath F
.49683 .16254 -1.875 0 Mabsadd m
.49683 .16254 0 2.5 Mabsadd L
.49683 .16254 1.875 0 Mabsadd L
.49683 .16254 0 -2.5 Mabsadd L
.49683 .16254 -1.875 0 Mabsadd L closepath F
.5 .16297 -1.875 0 Mabsadd m
.5 .16297 0 2.5 Mabsadd L
.5 .16297 1.875 0 Mabsadd L
.5 .16297 0 -2.5 Mabsadd L
.5 .16297 -1.875 0 Mabsadd L closepath F
.50317 .16339 -1.875 0 Mabsadd m
.50317 .16339 0 2.5 Mabsadd L
.50317 .16339 1.875 0 Mabsadd L
.50317 .16339 0 -2.5 Mabsadd L
.50317 .16339 -1.875 0 Mabsadd L closepath F
.50635 .16382 -1.875 0 Mabsadd m
.50635 .16382 0 2.5 Mabsadd L
.50635 .16382 1.875 0 Mabsadd L
.50635 .16382 0 -2.5 Mabsadd L
.50635 .16382 -1.875 0 Mabsadd L closepath F
.50952 .16424 -1.875 0 Mabsadd m
.50952 .16424 0 2.5 Mabsadd L
.50952 .16424 1.875 0 Mabsadd L
.50952 .16424 0 -2.5 Mabsadd L
.50952 .16424 -1.875 0 Mabsadd L closepath F
.5127 .16465 -1.875 0 Mabsadd m
.5127 .16465 0 2.5 Mabsadd L
.5127 .16465 1.875 0 Mabsadd L
.5127 .16465 0 -2.5 Mabsadd L
.5127 .16465 -1.875 0 Mabsadd L closepath F
.51587 .16506 -1.875 0 Mabsadd m
.51587 .16506 0 2.5 Mabsadd L
.51587 .16506 1.875 0 Mabsadd L
.51587 .16506 0 -2.5 Mabsadd L
.51587 .16506 -1.875 0 Mabsadd L closepath F
.51905 .16547 -1.875 0 Mabsadd m
.51905 .16547 0 2.5 Mabsadd L
.51905 .16547 1.875 0 Mabsadd L
.51905 .16547 0 -2.5 Mabsadd L
.51905 .16547 -1.875 0 Mabsadd L closepath F
.52222 .16587 -1.875 0 Mabsadd m
.52222 .16587 0 2.5 Mabsadd L
.52222 .16587 1.875 0 Mabsadd L
.52222 .16587 0 -2.5 Mabsadd L
.52222 .16587 -1.875 0 Mabsadd L closepath F
.5254 .16627 -1.875 0 Mabsadd m
.5254 .16627 0 2.5 Mabsadd L
.5254 .16627 1.875 0 Mabsadd L
.5254 .16627 0 -2.5 Mabsadd L
.5254 .16627 -1.875 0 Mabsadd L closepath F
.52857 .16666 -1.875 0 Mabsadd m
.52857 .16666 0 2.5 Mabsadd L
.52857 .16666 1.875 0 Mabsadd L
.52857 .16666 0 -2.5 Mabsadd L
.52857 .16666 -1.875 0 Mabsadd L closepath F
.53175 .16705 -1.875 0 Mabsadd m
.53175 .16705 0 2.5 Mabsadd L
.53175 .16705 1.875 0 Mabsadd L
.53175 .16705 0 -2.5 Mabsadd L
.53175 .16705 -1.875 0 Mabsadd L closepath F
.53492 .16744 -1.875 0 Mabsadd m
.53492 .16744 0 2.5 Mabsadd L
.53492 .16744 1.875 0 Mabsadd L
.53492 .16744 0 -2.5 Mabsadd L
.53492 .16744 -1.875 0 Mabsadd L closepath F
.5381 .16782 -1.875 0 Mabsadd m
.5381 .16782 0 2.5 Mabsadd L
.5381 .16782 1.875 0 Mabsadd L
.5381 .16782 0 -2.5 Mabsadd L
.5381 .16782 -1.875 0 Mabsadd L closepath F
.54127 .1682 -1.875 0 Mabsadd m
.54127 .1682 0 2.5 Mabsadd L
.54127 .1682 1.875 0 Mabsadd L
.54127 .1682 0 -2.5 Mabsadd L
.54127 .1682 -1.875 0 Mabsadd L closepath F
.54444 .16857 -1.875 0 Mabsadd m
.54444 .16857 0 2.5 Mabsadd L
.54444 .16857 1.875 0 Mabsadd L
.54444 .16857 0 -2.5 Mabsadd L
.54444 .16857 -1.875 0 Mabsadd L closepath F
.54762 .16895 -1.875 0 Mabsadd m
.54762 .16895 0 2.5 Mabsadd L
.54762 .16895 1.875 0 Mabsadd L
.54762 .16895 0 -2.5 Mabsadd L
.54762 .16895 -1.875 0 Mabsadd L closepath F
.55079 .16931 -1.875 0 Mabsadd m
.55079 .16931 0 2.5 Mabsadd L
.55079 .16931 1.875 0 Mabsadd L
.55079 .16931 0 -2.5 Mabsadd L
.55079 .16931 -1.875 0 Mabsadd L closepath F
.55397 .16968 -1.875 0 Mabsadd m
.55397 .16968 0 2.5 Mabsadd L
.55397 .16968 1.875 0 Mabsadd L
.55397 .16968 0 -2.5 Mabsadd L
.55397 .16968 -1.875 0 Mabsadd L closepath F
.55714 .17004 -1.875 0 Mabsadd m
.55714 .17004 0 2.5 Mabsadd L
.55714 .17004 1.875 0 Mabsadd L
.55714 .17004 0 -2.5 Mabsadd L
.55714 .17004 -1.875 0 Mabsadd L closepath F
.56032 .17039 -1.875 0 Mabsadd m
.56032 .17039 0 2.5 Mabsadd L
.56032 .17039 1.875 0 Mabsadd L
.56032 .17039 0 -2.5 Mabsadd L
.56032 .17039 -1.875 0 Mabsadd L closepath F
.56349 .17075 -1.875 0 Mabsadd m
.56349 .17075 0 2.5 Mabsadd L
.56349 .17075 1.875 0 Mabsadd L
.56349 .17075 0 -2.5 Mabsadd L
.56349 .17075 -1.875 0 Mabsadd L closepath F
.56667 .1711 -1.875 0 Mabsadd m
.56667 .1711 0 2.5 Mabsadd L
.56667 .1711 1.875 0 Mabsadd L
.56667 .1711 0 -2.5 Mabsadd L
.56667 .1711 -1.875 0 Mabsadd L closepath F
.56984 .17144 -1.875 0 Mabsadd m
.56984 .17144 0 2.5 Mabsadd L
.56984 .17144 1.875 0 Mabsadd L
.56984 .17144 0 -2.5 Mabsadd L
.56984 .17144 -1.875 0 Mabsadd L closepath F
.57302 .17178 -1.875 0 Mabsadd m
.57302 .17178 0 2.5 Mabsadd L
.57302 .17178 1.875 0 Mabsadd L
.57302 .17178 0 -2.5 Mabsadd L
.57302 .17178 -1.875 0 Mabsadd L closepath F
.57619 .17212 -1.875 0 Mabsadd m
.57619 .17212 0 2.5 Mabsadd L
.57619 .17212 1.875 0 Mabsadd L
.57619 .17212 0 -2.5 Mabsadd L
.57619 .17212 -1.875 0 Mabsadd L closepath F
.57937 .17246 -1.875 0 Mabsadd m
.57937 .17246 0 2.5 Mabsadd L
.57937 .17246 1.875 0 Mabsadd L
.57937 .17246 0 -2.5 Mabsadd L
.57937 .17246 -1.875 0 Mabsadd L closepath F
.58254 .17279 -1.875 0 Mabsadd m
.58254 .17279 0 2.5 Mabsadd L
.58254 .17279 1.875 0 Mabsadd L
.58254 .17279 0 -2.5 Mabsadd L
.58254 .17279 -1.875 0 Mabsadd L closepath F
.58571 .17312 -1.875 0 Mabsadd m
.58571 .17312 0 2.5 Mabsadd L
.58571 .17312 1.875 0 Mabsadd L
.58571 .17312 0 -2.5 Mabsadd L
.58571 .17312 -1.875 0 Mabsadd L closepath F
.58889 .17345 -1.875 0 Mabsadd m
.58889 .17345 0 2.5 Mabsadd L
.58889 .17345 1.875 0 Mabsadd L
.58889 .17345 0 -2.5 Mabsadd L
.58889 .17345 -1.875 0 Mabsadd L closepath F
.59206 .17377 -1.875 0 Mabsadd m
.59206 .17377 0 2.5 Mabsadd L
.59206 .17377 1.875 0 Mabsadd L
.59206 .17377 0 -2.5 Mabsadd L
.59206 .17377 -1.875 0 Mabsadd L closepath F
.59524 .17409 -1.875 0 Mabsadd m
.59524 .17409 0 2.5 Mabsadd L
.59524 .17409 1.875 0 Mabsadd L
.59524 .17409 0 -2.5 Mabsadd L
.59524 .17409 -1.875 0 Mabsadd L closepath F
.59841 .1744 -1.875 0 Mabsadd m
.59841 .1744 0 2.5 Mabsadd L
.59841 .1744 1.875 0 Mabsadd L
.59841 .1744 0 -2.5 Mabsadd L
.59841 .1744 -1.875 0 Mabsadd L closepath F
.60159 .17472 -1.875 0 Mabsadd m
.60159 .17472 0 2.5 Mabsadd L
.60159 .17472 1.875 0 Mabsadd L
.60159 .17472 0 -2.5 Mabsadd L
.60159 .17472 -1.875 0 Mabsadd L closepath F
.60476 .17503 -1.875 0 Mabsadd m
.60476 .17503 0 2.5 Mabsadd L
.60476 .17503 1.875 0 Mabsadd L
.60476 .17503 0 -2.5 Mabsadd L
.60476 .17503 -1.875 0 Mabsadd L closepath F
.60794 .17533 -1.875 0 Mabsadd m
.60794 .17533 0 2.5 Mabsadd L
.60794 .17533 1.875 0 Mabsadd L
.60794 .17533 0 -2.5 Mabsadd L
.60794 .17533 -1.875 0 Mabsadd L closepath F
.61111 .17564 -1.875 0 Mabsadd m
.61111 .17564 0 2.5 Mabsadd L
.61111 .17564 1.875 0 Mabsadd L
.61111 .17564 0 -2.5 Mabsadd L
.61111 .17564 -1.875 0 Mabsadd L closepath F
.61429 .17594 -1.875 0 Mabsadd m
.61429 .17594 0 2.5 Mabsadd L
.61429 .17594 1.875 0 Mabsadd L
.61429 .17594 0 -2.5 Mabsadd L
.61429 .17594 -1.875 0 Mabsadd L closepath F
.61746 .17623 -1.875 0 Mabsadd m
.61746 .17623 0 2.5 Mabsadd L
.61746 .17623 1.875 0 Mabsadd L
.61746 .17623 0 -2.5 Mabsadd L
.61746 .17623 -1.875 0 Mabsadd L closepath F
.62063 .17653 -1.875 0 Mabsadd m
.62063 .17653 0 2.5 Mabsadd L
.62063 .17653 1.875 0 Mabsadd L
.62063 .17653 0 -2.5 Mabsadd L
.62063 .17653 -1.875 0 Mabsadd L closepath F
.62381 .17682 -1.875 0 Mabsadd m
.62381 .17682 0 2.5 Mabsadd L
.62381 .17682 1.875 0 Mabsadd L
.62381 .17682 0 -2.5 Mabsadd L
.62381 .17682 -1.875 0 Mabsadd L closepath F
.62698 .17711 -1.875 0 Mabsadd m
.62698 .17711 0 2.5 Mabsadd L
.62698 .17711 1.875 0 Mabsadd L
.62698 .17711 0 -2.5 Mabsadd L
.62698 .17711 -1.875 0 Mabsadd L closepath F
.63016 .17739 -1.875 0 Mabsadd m
.63016 .17739 0 2.5 Mabsadd L
.63016 .17739 1.875 0 Mabsadd L
.63016 .17739 0 -2.5 Mabsadd L
.63016 .17739 -1.875 0 Mabsadd L closepath F
.63333 .17768 -1.875 0 Mabsadd m
.63333 .17768 0 2.5 Mabsadd L
.63333 .17768 1.875 0 Mabsadd L
.63333 .17768 0 -2.5 Mabsadd L
.63333 .17768 -1.875 0 Mabsadd L closepath F
.63651 .17796 -1.875 0 Mabsadd m
.63651 .17796 0 2.5 Mabsadd L
.63651 .17796 1.875 0 Mabsadd L
.63651 .17796 0 -2.5 Mabsadd L
.63651 .17796 -1.875 0 Mabsadd L closepath F
.63968 .17823 -1.875 0 Mabsadd m
.63968 .17823 0 2.5 Mabsadd L
.63968 .17823 1.875 0 Mabsadd L
.63968 .17823 0 -2.5 Mabsadd L
.63968 .17823 -1.875 0 Mabsadd L closepath F
.64286 .17851 -1.875 0 Mabsadd m
.64286 .17851 0 2.5 Mabsadd L
.64286 .17851 1.875 0 Mabsadd L
.64286 .17851 0 -2.5 Mabsadd L
.64286 .17851 -1.875 0 Mabsadd L closepath F
.64603 .17878 -1.875 0 Mabsadd m
.64603 .17878 0 2.5 Mabsadd L
.64603 .17878 1.875 0 Mabsadd L
.64603 .17878 0 -2.5 Mabsadd L
.64603 .17878 -1.875 0 Mabsadd L closepath F
.64921 .17905 -1.875 0 Mabsadd m
.64921 .17905 0 2.5 Mabsadd L
.64921 .17905 1.875 0 Mabsadd L
.64921 .17905 0 -2.5 Mabsadd L
.64921 .17905 -1.875 0 Mabsadd L closepath F
.65238 .17932 -1.875 0 Mabsadd m
.65238 .17932 0 2.5 Mabsadd L
.65238 .17932 1.875 0 Mabsadd L
.65238 .17932 0 -2.5 Mabsadd L
.65238 .17932 -1.875 0 Mabsadd L closepath F
.65556 .17958 -1.875 0 Mabsadd m
.65556 .17958 0 2.5 Mabsadd L
.65556 .17958 1.875 0 Mabsadd L
.65556 .17958 0 -2.5 Mabsadd L
.65556 .17958 -1.875 0 Mabsadd L closepath F
.65873 .17984 -1.875 0 Mabsadd m
.65873 .17984 0 2.5 Mabsadd L
.65873 .17984 1.875 0 Mabsadd L
.65873 .17984 0 -2.5 Mabsadd L
.65873 .17984 -1.875 0 Mabsadd L closepath F
.6619 .1801 -1.875 0 Mabsadd m
.6619 .1801 0 2.5 Mabsadd L
.6619 .1801 1.875 0 Mabsadd L
.6619 .1801 0 -2.5 Mabsadd L
.6619 .1801 -1.875 0 Mabsadd L closepath F
.66508 .18036 -1.875 0 Mabsadd m
.66508 .18036 0 2.5 Mabsadd L
.66508 .18036 1.875 0 Mabsadd L
.66508 .18036 0 -2.5 Mabsadd L
.66508 .18036 -1.875 0 Mabsadd L closepath F
.66825 .18061 -1.875 0 Mabsadd m
.66825 .18061 0 2.5 Mabsadd L
.66825 .18061 1.875 0 Mabsadd L
.66825 .18061 0 -2.5 Mabsadd L
.66825 .18061 -1.875 0 Mabsadd L closepath F
.67143 .18086 -1.875 0 Mabsadd m
.67143 .18086 0 2.5 Mabsadd L
.67143 .18086 1.875 0 Mabsadd L
.67143 .18086 0 -2.5 Mabsadd L
.67143 .18086 -1.875 0 Mabsadd L closepath F
.6746 .18111 -1.875 0 Mabsadd m
.6746 .18111 0 2.5 Mabsadd L
.6746 .18111 1.875 0 Mabsadd L
.6746 .18111 0 -2.5 Mabsadd L
.6746 .18111 -1.875 0 Mabsadd L closepath F
.67778 .18135 -1.875 0 Mabsadd m
.67778 .18135 0 2.5 Mabsadd L
.67778 .18135 1.875 0 Mabsadd L
.67778 .18135 0 -2.5 Mabsadd L
.67778 .18135 -1.875 0 Mabsadd L closepath F
.68095 .1816 -1.875 0 Mabsadd m
.68095 .1816 0 2.5 Mabsadd L
.68095 .1816 1.875 0 Mabsadd L
.68095 .1816 0 -2.5 Mabsadd L
.68095 .1816 -1.875 0 Mabsadd L closepath F
.68413 .18184 -1.875 0 Mabsadd m
.68413 .18184 0 2.5 Mabsadd L
.68413 .18184 1.875 0 Mabsadd L
.68413 .18184 0 -2.5 Mabsadd L
.68413 .18184 -1.875 0 Mabsadd L closepath F
.6873 .18208 -1.875 0 Mabsadd m
.6873 .18208 0 2.5 Mabsadd L
.6873 .18208 1.875 0 Mabsadd L
.6873 .18208 0 -2.5 Mabsadd L
.6873 .18208 -1.875 0 Mabsadd L closepath F
.69048 .18231 -1.875 0 Mabsadd m
.69048 .18231 0 2.5 Mabsadd L
.69048 .18231 1.875 0 Mabsadd L
.69048 .18231 0 -2.5 Mabsadd L
.69048 .18231 -1.875 0 Mabsadd L closepath F
.69365 .18255 -1.875 0 Mabsadd m
.69365 .18255 0 2.5 Mabsadd L
.69365 .18255 1.875 0 Mabsadd L
.69365 .18255 0 -2.5 Mabsadd L
.69365 .18255 -1.875 0 Mabsadd L closepath F
.69683 .18278 -1.875 0 Mabsadd m
.69683 .18278 0 2.5 Mabsadd L
.69683 .18278 1.875 0 Mabsadd L
.69683 .18278 0 -2.5 Mabsadd L
.69683 .18278 -1.875 0 Mabsadd L closepath F
.7 .18301 -1.875 0 Mabsadd m
.7 .18301 0 2.5 Mabsadd L
.7 .18301 1.875 0 Mabsadd L
.7 .18301 0 -2.5 Mabsadd L
.7 .18301 -1.875 0 Mabsadd L closepath F
.70317 .18323 -1.875 0 Mabsadd m
.70317 .18323 0 2.5 Mabsadd L
.70317 .18323 1.875 0 Mabsadd L
.70317 .18323 0 -2.5 Mabsadd L
.70317 .18323 -1.875 0 Mabsadd L closepath F
.70635 .18346 -1.875 0 Mabsadd m
.70635 .18346 0 2.5 Mabsadd L
.70635 .18346 1.875 0 Mabsadd L
.70635 .18346 0 -2.5 Mabsadd L
.70635 .18346 -1.875 0 Mabsadd L closepath F
.70952 .18368 -1.875 0 Mabsadd m
.70952 .18368 0 2.5 Mabsadd L
.70952 .18368 1.875 0 Mabsadd L
.70952 .18368 0 -2.5 Mabsadd L
.70952 .18368 -1.875 0 Mabsadd L closepath F
.7127 .1839 -1.875 0 Mabsadd m
.7127 .1839 0 2.5 Mabsadd L
.7127 .1839 1.875 0 Mabsadd L
.7127 .1839 0 -2.5 Mabsadd L
.7127 .1839 -1.875 0 Mabsadd L closepath F
.71587 .18412 -1.875 0 Mabsadd m
.71587 .18412 0 2.5 Mabsadd L
.71587 .18412 1.875 0 Mabsadd L
.71587 .18412 0 -2.5 Mabsadd L
.71587 .18412 -1.875 0 Mabsadd L closepath F
.71905 .18433 -1.875 0 Mabsadd m
.71905 .18433 0 2.5 Mabsadd L
.71905 .18433 1.875 0 Mabsadd L
.71905 .18433 0 -2.5 Mabsadd L
.71905 .18433 -1.875 0 Mabsadd L closepath F
.72222 .18455 -1.875 0 Mabsadd m
.72222 .18455 0 2.5 Mabsadd L
.72222 .18455 1.875 0 Mabsadd L
.72222 .18455 0 -2.5 Mabsadd L
.72222 .18455 -1.875 0 Mabsadd L closepath F
.7254 .18476 -1.875 0 Mabsadd m
.7254 .18476 0 2.5 Mabsadd L
.7254 .18476 1.875 0 Mabsadd L
.7254 .18476 0 -2.5 Mabsadd L
.7254 .18476 -1.875 0 Mabsadd L closepath F
.72857 .18497 -1.875 0 Mabsadd m
.72857 .18497 0 2.5 Mabsadd L
.72857 .18497 1.875 0 Mabsadd L
.72857 .18497 0 -2.5 Mabsadd L
.72857 .18497 -1.875 0 Mabsadd L closepath F
.73175 .18517 -1.875 0 Mabsadd m
.73175 .18517 0 2.5 Mabsadd L
.73175 .18517 1.875 0 Mabsadd L
.73175 .18517 0 -2.5 Mabsadd L
.73175 .18517 -1.875 0 Mabsadd L closepath F
.73492 .18538 -1.875 0 Mabsadd m
.73492 .18538 0 2.5 Mabsadd L
.73492 .18538 1.875 0 Mabsadd L
.73492 .18538 0 -2.5 Mabsadd L
.73492 .18538 -1.875 0 Mabsadd L closepath F
.7381 .18558 -1.875 0 Mabsadd m
.7381 .18558 0 2.5 Mabsadd L
.7381 .18558 1.875 0 Mabsadd L
.7381 .18558 0 -2.5 Mabsadd L
.7381 .18558 -1.875 0 Mabsadd L closepath F
.74127 .18578 -1.875 0 Mabsadd m
.74127 .18578 0 2.5 Mabsadd L
.74127 .18578 1.875 0 Mabsadd L
.74127 .18578 0 -2.5 Mabsadd L
.74127 .18578 -1.875 0 Mabsadd L closepath F
.74444 .18598 -1.875 0 Mabsadd m
.74444 .18598 0 2.5 Mabsadd L
.74444 .18598 1.875 0 Mabsadd L
.74444 .18598 0 -2.5 Mabsadd L
.74444 .18598 -1.875 0 Mabsadd L closepath F
.74762 .18618 -1.875 0 Mabsadd m
.74762 .18618 0 2.5 Mabsadd L
.74762 .18618 1.875 0 Mabsadd L
.74762 .18618 0 -2.5 Mabsadd L
.74762 .18618 -1.875 0 Mabsadd L closepath F
.75079 .18638 -1.875 0 Mabsadd m
.75079 .18638 0 2.5 Mabsadd L
.75079 .18638 1.875 0 Mabsadd L
.75079 .18638 0 -2.5 Mabsadd L
.75079 .18638 -1.875 0 Mabsadd L closepath F
.75397 .18657 -1.875 0 Mabsadd m
.75397 .18657 0 2.5 Mabsadd L
.75397 .18657 1.875 0 Mabsadd L
.75397 .18657 0 -2.5 Mabsadd L
.75397 .18657 -1.875 0 Mabsadd L closepath F
.75714 .18676 -1.875 0 Mabsadd m
.75714 .18676 0 2.5 Mabsadd L
.75714 .18676 1.875 0 Mabsadd L
.75714 .18676 0 -2.5 Mabsadd L
.75714 .18676 -1.875 0 Mabsadd L closepath F
.76032 .18695 -1.875 0 Mabsadd m
.76032 .18695 0 2.5 Mabsadd L
.76032 .18695 1.875 0 Mabsadd L
.76032 .18695 0 -2.5 Mabsadd L
.76032 .18695 -1.875 0 Mabsadd L closepath F
.76349 .18714 -1.875 0 Mabsadd m
.76349 .18714 0 2.5 Mabsadd L
.76349 .18714 1.875 0 Mabsadd L
.76349 .18714 0 -2.5 Mabsadd L
.76349 .18714 -1.875 0 Mabsadd L closepath F
.76667 .18732 -1.875 0 Mabsadd m
.76667 .18732 0 2.5 Mabsadd L
.76667 .18732 1.875 0 Mabsadd L
.76667 .18732 0 -2.5 Mabsadd L
.76667 .18732 -1.875 0 Mabsadd L closepath F
.76984 .18751 -1.875 0 Mabsadd m
.76984 .18751 0 2.5 Mabsadd L
.76984 .18751 1.875 0 Mabsadd L
.76984 .18751 0 -2.5 Mabsadd L
.76984 .18751 -1.875 0 Mabsadd L closepath F
.77302 .18769 -1.875 0 Mabsadd m
.77302 .18769 0 2.5 Mabsadd L
.77302 .18769 1.875 0 Mabsadd L
.77302 .18769 0 -2.5 Mabsadd L
.77302 .18769 -1.875 0 Mabsadd L closepath F
.77619 .18787 -1.875 0 Mabsadd m
.77619 .18787 0 2.5 Mabsadd L
.77619 .18787 1.875 0 Mabsadd L
.77619 .18787 0 -2.5 Mabsadd L
.77619 .18787 -1.875 0 Mabsadd L closepath F
.77937 .18805 -1.875 0 Mabsadd m
.77937 .18805 0 2.5 Mabsadd L
.77937 .18805 1.875 0 Mabsadd L
.77937 .18805 0 -2.5 Mabsadd L
.77937 .18805 -1.875 0 Mabsadd L closepath F
.78254 .18822 -1.875 0 Mabsadd m
.78254 .18822 0 2.5 Mabsadd L
.78254 .18822 1.875 0 Mabsadd L
.78254 .18822 0 -2.5 Mabsadd L
.78254 .18822 -1.875 0 Mabsadd L closepath F
.78571 .1884 -1.875 0 Mabsadd m
.78571 .1884 0 2.5 Mabsadd L
.78571 .1884 1.875 0 Mabsadd L
.78571 .1884 0 -2.5 Mabsadd L
.78571 .1884 -1.875 0 Mabsadd L closepath F
.78889 .18857 -1.875 0 Mabsadd m
.78889 .18857 0 2.5 Mabsadd L
.78889 .18857 1.875 0 Mabsadd L
.78889 .18857 0 -2.5 Mabsadd L
.78889 .18857 -1.875 0 Mabsadd L closepath F
.79206 .18874 -1.875 0 Mabsadd m
.79206 .18874 0 2.5 Mabsadd L
.79206 .18874 1.875 0 Mabsadd L
.79206 .18874 0 -2.5 Mabsadd L
.79206 .18874 -1.875 0 Mabsadd L closepath F
.79524 .18891 -1.875 0 Mabsadd m
.79524 .18891 0 2.5 Mabsadd L
.79524 .18891 1.875 0 Mabsadd L
.79524 .18891 0 -2.5 Mabsadd L
.79524 .18891 -1.875 0 Mabsadd L closepath F
.79841 .18908 -1.875 0 Mabsadd m
.79841 .18908 0 2.5 Mabsadd L
.79841 .18908 1.875 0 Mabsadd L
.79841 .18908 0 -2.5 Mabsadd L
.79841 .18908 -1.875 0 Mabsadd L closepath F
.80159 .18924 -1.875 0 Mabsadd m
.80159 .18924 0 2.5 Mabsadd L
.80159 .18924 1.875 0 Mabsadd L
.80159 .18924 0 -2.5 Mabsadd L
.80159 .18924 -1.875 0 Mabsadd L closepath F
.80476 .18941 -1.875 0 Mabsadd m
.80476 .18941 0 2.5 Mabsadd L
.80476 .18941 1.875 0 Mabsadd L
.80476 .18941 0 -2.5 Mabsadd L
.80476 .18941 -1.875 0 Mabsadd L closepath F
.80794 .18957 -1.875 0 Mabsadd m
.80794 .18957 0 2.5 Mabsadd L
.80794 .18957 1.875 0 Mabsadd L
.80794 .18957 0 -2.5 Mabsadd L
.80794 .18957 -1.875 0 Mabsadd L closepath F
.81111 .18973 -1.875 0 Mabsadd m
.81111 .18973 0 2.5 Mabsadd L
.81111 .18973 1.875 0 Mabsadd L
.81111 .18973 0 -2.5 Mabsadd L
.81111 .18973 -1.875 0 Mabsadd L closepath F
.81429 .18989 -1.875 0 Mabsadd m
.81429 .18989 0 2.5 Mabsadd L
.81429 .18989 1.875 0 Mabsadd L
.81429 .18989 0 -2.5 Mabsadd L
.81429 .18989 -1.875 0 Mabsadd L closepath F
.81746 .19005 -1.875 0 Mabsadd m
.81746 .19005 0 2.5 Mabsadd L
.81746 .19005 1.875 0 Mabsadd L
.81746 .19005 0 -2.5 Mabsadd L
.81746 .19005 -1.875 0 Mabsadd L closepath F
.82063 .19021 -1.875 0 Mabsadd m
.82063 .19021 0 2.5 Mabsadd L
.82063 .19021 1.875 0 Mabsadd L
.82063 .19021 0 -2.5 Mabsadd L
.82063 .19021 -1.875 0 Mabsadd L closepath F
.82381 .19036 -1.875 0 Mabsadd m
.82381 .19036 0 2.5 Mabsadd L
.82381 .19036 1.875 0 Mabsadd L
.82381 .19036 0 -2.5 Mabsadd L
.82381 .19036 -1.875 0 Mabsadd L closepath F
.82698 .19051 -1.875 0 Mabsadd m
.82698 .19051 0 2.5 Mabsadd L
.82698 .19051 1.875 0 Mabsadd L
.82698 .19051 0 -2.5 Mabsadd L
.82698 .19051 -1.875 0 Mabsadd L closepath F
.83016 .19067 -1.875 0 Mabsadd m
.83016 .19067 0 2.5 Mabsadd L
.83016 .19067 1.875 0 Mabsadd L
.83016 .19067 0 -2.5 Mabsadd L
.83016 .19067 -1.875 0 Mabsadd L closepath F
.83333 .19082 -1.875 0 Mabsadd m
.83333 .19082 0 2.5 Mabsadd L
.83333 .19082 1.875 0 Mabsadd L
.83333 .19082 0 -2.5 Mabsadd L
.83333 .19082 -1.875 0 Mabsadd L closepath F
.83651 .19096 -1.875 0 Mabsadd m
.83651 .19096 0 2.5 Mabsadd L
.83651 .19096 1.875 0 Mabsadd L
.83651 .19096 0 -2.5 Mabsadd L
.83651 .19096 -1.875 0 Mabsadd L closepath F
.83968 .19111 -1.875 0 Mabsadd m
.83968 .19111 0 2.5 Mabsadd L
.83968 .19111 1.875 0 Mabsadd L
.83968 .19111 0 -2.5 Mabsadd L
.83968 .19111 -1.875 0 Mabsadd L closepath F
.84286 .19126 -1.875 0 Mabsadd m
.84286 .19126 0 2.5 Mabsadd L
.84286 .19126 1.875 0 Mabsadd L
.84286 .19126 0 -2.5 Mabsadd L
.84286 .19126 -1.875 0 Mabsadd L closepath F
.84603 .1914 -1.875 0 Mabsadd m
.84603 .1914 0 2.5 Mabsadd L
.84603 .1914 1.875 0 Mabsadd L
.84603 .1914 0 -2.5 Mabsadd L
.84603 .1914 -1.875 0 Mabsadd L closepath F
.84921 .19154 -1.875 0 Mabsadd m
.84921 .19154 0 2.5 Mabsadd L
.84921 .19154 1.875 0 Mabsadd L
.84921 .19154 0 -2.5 Mabsadd L
.84921 .19154 -1.875 0 Mabsadd L closepath F
.85238 .19169 -1.875 0 Mabsadd m
.85238 .19169 0 2.5 Mabsadd L
.85238 .19169 1.875 0 Mabsadd L
.85238 .19169 0 -2.5 Mabsadd L
.85238 .19169 -1.875 0 Mabsadd L closepath F
.85556 .19183 -1.875 0 Mabsadd m
.85556 .19183 0 2.5 Mabsadd L
.85556 .19183 1.875 0 Mabsadd L
.85556 .19183 0 -2.5 Mabsadd L
.85556 .19183 -1.875 0 Mabsadd L closepath F
.85873 .19196 -1.875 0 Mabsadd m
.85873 .19196 0 2.5 Mabsadd L
.85873 .19196 1.875 0 Mabsadd L
.85873 .19196 0 -2.5 Mabsadd L
.85873 .19196 -1.875 0 Mabsadd L closepath F
.8619 .1921 -1.875 0 Mabsadd m
.8619 .1921 0 2.5 Mabsadd L
.8619 .1921 1.875 0 Mabsadd L
.8619 .1921 0 -2.5 Mabsadd L
.8619 .1921 -1.875 0 Mabsadd L closepath F
.86508 .19224 -1.875 0 Mabsadd m
.86508 .19224 0 2.5 Mabsadd L
.86508 .19224 1.875 0 Mabsadd L
.86508 .19224 0 -2.5 Mabsadd L
.86508 .19224 -1.875 0 Mabsadd L closepath F
.86825 .19237 -1.875 0 Mabsadd m
.86825 .19237 0 2.5 Mabsadd L
.86825 .19237 1.875 0 Mabsadd L
.86825 .19237 0 -2.5 Mabsadd L
.86825 .19237 -1.875 0 Mabsadd L closepath F
.87143 .19251 -1.875 0 Mabsadd m
.87143 .19251 0 2.5 Mabsadd L
.87143 .19251 1.875 0 Mabsadd L
.87143 .19251 0 -2.5 Mabsadd L
.87143 .19251 -1.875 0 Mabsadd L closepath F
.8746 .19264 -1.875 0 Mabsadd m
.8746 .19264 0 2.5 Mabsadd L
.8746 .19264 1.875 0 Mabsadd L
.8746 .19264 0 -2.5 Mabsadd L
.8746 .19264 -1.875 0 Mabsadd L closepath F
.87778 .19277 -1.875 0 Mabsadd m
.87778 .19277 0 2.5 Mabsadd L
.87778 .19277 1.875 0 Mabsadd L
.87778 .19277 0 -2.5 Mabsadd L
.87778 .19277 -1.875 0 Mabsadd L closepath F
.88095 .1929 -1.875 0 Mabsadd m
.88095 .1929 0 2.5 Mabsadd L
.88095 .1929 1.875 0 Mabsadd L
.88095 .1929 0 -2.5 Mabsadd L
.88095 .1929 -1.875 0 Mabsadd L closepath F
.88413 .19302 -1.875 0 Mabsadd m
.88413 .19302 0 2.5 Mabsadd L
.88413 .19302 1.875 0 Mabsadd L
.88413 .19302 0 -2.5 Mabsadd L
.88413 .19302 -1.875 0 Mabsadd L closepath F
.8873 .19315 -1.875 0 Mabsadd m
.8873 .19315 0 2.5 Mabsadd L
.8873 .19315 1.875 0 Mabsadd L
.8873 .19315 0 -2.5 Mabsadd L
.8873 .19315 -1.875 0 Mabsadd L closepath F
.89048 .19328 -1.875 0 Mabsadd m
.89048 .19328 0 2.5 Mabsadd L
.89048 .19328 1.875 0 Mabsadd L
.89048 .19328 0 -2.5 Mabsadd L
.89048 .19328 -1.875 0 Mabsadd L closepath F
.89365 .1934 -1.875 0 Mabsadd m
.89365 .1934 0 2.5 Mabsadd L
.89365 .1934 1.875 0 Mabsadd L
.89365 .1934 0 -2.5 Mabsadd L
.89365 .1934 -1.875 0 Mabsadd L closepath F
.89683 .19352 -1.875 0 Mabsadd m
.89683 .19352 0 2.5 Mabsadd L
.89683 .19352 1.875 0 Mabsadd L
.89683 .19352 0 -2.5 Mabsadd L
.89683 .19352 -1.875 0 Mabsadd L closepath F
.9 .19365 -1.875 0 Mabsadd m
.9 .19365 0 2.5 Mabsadd L
.9 .19365 1.875 0 Mabsadd L
.9 .19365 0 -2.5 Mabsadd L
.9 .19365 -1.875 0 Mabsadd L closepath F
.90317 .19377 -1.875 0 Mabsadd m
.90317 .19377 0 2.5 Mabsadd L
.90317 .19377 1.875 0 Mabsadd L
.90317 .19377 0 -2.5 Mabsadd L
.90317 .19377 -1.875 0 Mabsadd L closepath F
.90635 .19388 -1.875 0 Mabsadd m
.90635 .19388 0 2.5 Mabsadd L
.90635 .19388 1.875 0 Mabsadd L
.90635 .19388 0 -2.5 Mabsadd L
.90635 .19388 -1.875 0 Mabsadd L closepath F
.90952 .194 -1.875 0 Mabsadd m
.90952 .194 0 2.5 Mabsadd L
.90952 .194 1.875 0 Mabsadd L
.90952 .194 0 -2.5 Mabsadd L
.90952 .194 -1.875 0 Mabsadd L closepath F
.9127 .19412 -1.875 0 Mabsadd m
.9127 .19412 0 2.5 Mabsadd L
.9127 .19412 1.875 0 Mabsadd L
.9127 .19412 0 -2.5 Mabsadd L
.9127 .19412 -1.875 0 Mabsadd L closepath F
.91587 .19424 -1.875 0 Mabsadd m
.91587 .19424 0 2.5 Mabsadd L
.91587 .19424 1.875 0 Mabsadd L
.91587 .19424 0 -2.5 Mabsadd L
.91587 .19424 -1.875 0 Mabsadd L closepath F
.91905 .19435 -1.875 0 Mabsadd m
.91905 .19435 0 2.5 Mabsadd L
.91905 .19435 1.875 0 Mabsadd L
.91905 .19435 0 -2.5 Mabsadd L
.91905 .19435 -1.875 0 Mabsadd L closepath F
.92222 .19446 -1.875 0 Mabsadd m
.92222 .19446 0 2.5 Mabsadd L
.92222 .19446 1.875 0 Mabsadd L
.92222 .19446 0 -2.5 Mabsadd L
.92222 .19446 -1.875 0 Mabsadd L closepath F
.9254 .19458 -1.875 0 Mabsadd m
.9254 .19458 0 2.5 Mabsadd L
.9254 .19458 1.875 0 Mabsadd L
.9254 .19458 0 -2.5 Mabsadd L
.9254 .19458 -1.875 0 Mabsadd L closepath F
.92857 .19469 -1.875 0 Mabsadd m
.92857 .19469 0 2.5 Mabsadd L
.92857 .19469 1.875 0 Mabsadd L
.92857 .19469 0 -2.5 Mabsadd L
.92857 .19469 -1.875 0 Mabsadd L closepath F
.93175 .1948 -1.875 0 Mabsadd m
.93175 .1948 0 2.5 Mabsadd L
.93175 .1948 1.875 0 Mabsadd L
.93175 .1948 0 -2.5 Mabsadd L
.93175 .1948 -1.875 0 Mabsadd L closepath F
.93492 .19491 -1.875 0 Mabsadd m
.93492 .19491 0 2.5 Mabsadd L
.93492 .19491 1.875 0 Mabsadd L
.93492 .19491 0 -2.5 Mabsadd L
.93492 .19491 -1.875 0 Mabsadd L closepath F
.9381 .19501 -1.875 0 Mabsadd m
.9381 .19501 0 2.5 Mabsadd L
.9381 .19501 1.875 0 Mabsadd L
.9381 .19501 0 -2.5 Mabsadd L
.9381 .19501 -1.875 0 Mabsadd L closepath F
.94127 .19512 -1.875 0 Mabsadd m
.94127 .19512 0 2.5 Mabsadd L
.94127 .19512 1.875 0 Mabsadd L
.94127 .19512 0 -2.5 Mabsadd L
.94127 .19512 -1.875 0 Mabsadd L closepath F
.94444 .19523 -1.875 0 Mabsadd m
.94444 .19523 0 2.5 Mabsadd L
.94444 .19523 1.875 0 Mabsadd L
.94444 .19523 0 -2.5 Mabsadd L
.94444 .19523 -1.875 0 Mabsadd L closepath F
.94762 .19533 -1.875 0 Mabsadd m
.94762 .19533 0 2.5 Mabsadd L
.94762 .19533 1.875 0 Mabsadd L
.94762 .19533 0 -2.5 Mabsadd L
.94762 .19533 -1.875 0 Mabsadd L closepath F
.95079 .19543 -1.875 0 Mabsadd m
.95079 .19543 0 2.5 Mabsadd L
.95079 .19543 1.875 0 Mabsadd L
.95079 .19543 0 -2.5 Mabsadd L
.95079 .19543 -1.875 0 Mabsadd L closepath F
.95397 .19554 -1.875 0 Mabsadd m
.95397 .19554 0 2.5 Mabsadd L
.95397 .19554 1.875 0 Mabsadd L
.95397 .19554 0 -2.5 Mabsadd L
.95397 .19554 -1.875 0 Mabsadd L closepath F
.95714 .19564 -1.875 0 Mabsadd m
.95714 .19564 0 2.5 Mabsadd L
.95714 .19564 1.875 0 Mabsadd L
.95714 .19564 0 -2.5 Mabsadd L
.95714 .19564 -1.875 0 Mabsadd L closepath F
.96032 .19574 -1.875 0 Mabsadd m
.96032 .19574 0 2.5 Mabsadd L
.96032 .19574 1.875 0 Mabsadd L
.96032 .19574 0 -2.5 Mabsadd L
.96032 .19574 -1.875 0 Mabsadd L closepath F
.96349 .19584 -1.875 0 Mabsadd m
.96349 .19584 0 2.5 Mabsadd L
.96349 .19584 1.875 0 Mabsadd L
.96349 .19584 0 -2.5 Mabsadd L
.96349 .19584 -1.875 0 Mabsadd L closepath F
.96667 .19594 -1.875 0 Mabsadd m
.96667 .19594 0 2.5 Mabsadd L
.96667 .19594 1.875 0 Mabsadd L
.96667 .19594 0 -2.5 Mabsadd L
.96667 .19594 -1.875 0 Mabsadd L closepath F
.96984 .19603 -1.875 0 Mabsadd m
.96984 .19603 0 2.5 Mabsadd L
.96984 .19603 1.875 0 Mabsadd L
.96984 .19603 0 -2.5 Mabsadd L
.96984 .19603 -1.875 0 Mabsadd L closepath F
.97302 .19613 -1.875 0 Mabsadd m
.97302 .19613 0 2.5 Mabsadd L
.97302 .19613 1.875 0 Mabsadd L
.97302 .19613 0 -2.5 Mabsadd L
.97302 .19613 -1.875 0 Mabsadd L closepath F
.97619 .19623 -1.875 0 Mabsadd m
.97619 .19623 0 2.5 Mabsadd L
.97619 .19623 1.875 0 Mabsadd L
.97619 .19623 0 -2.5 Mabsadd L
.97619 .19623 -1.875 0 Mabsadd L closepath F
.0075 w
.02698 .39666 m
.03016 .39475 L
.03333 .39286 L
.03651 .39098 L
.03968 .38913 L
.04286 .3873 L
.04603 .38548 L
.04921 .38368 L
.05238 .3819 L
.05556 .38014 L
.05873 .3784 L
.0619 .37667 L
.06508 .37496 L
.06825 .37327 L
.07143 .37159 L
.0746 .36993 L
.07778 .36829 L
.08095 .36666 L
.08413 .36505 L
.0873 .36346 L
.09048 .36188 L
.09365 .36032 L
.09683 .35877 L
.1 .35724 L
.10317 .35573 L
.10635 .35423 L
.10952 .35274 L
.1127 .35127 L
.11587 .34981 L
.11905 .34837 L
.12222 .34695 L
.1254 .34553 L
.12857 .34414 L
.13175 .34275 L
.13492 .34138 L
.1381 .34002 L
.14127 .33868 L
.14444 .33735 L
.14762 .33603 L
.15079 .33473 L
.15397 .33344 L
.15714 .33216 L
.16032 .3309 L
.16349 .32964 L
.16667 .32841 L
.16984 .32718 L
.17302 .32596 L
.17619 .32476 L
.17937 .32357 L
.18254 .32239 L
Mistroke
.18571 .32122 L
.18889 .32007 L
.19206 .31892 L
.19524 .31779 L
.19841 .31667 L
.20159 .31556 L
.20476 .31446 L
.20794 .31337 L
.21111 .3123 L
.21429 .31123 L
.21746 .31018 L
.22063 .30913 L
.22381 .3081 L
.22698 .30707 L
.23016 .30606 L
.23333 .30506 L
.23651 .30406 L
.23968 .30308 L
.24286 .3021 L
.24603 .30114 L
.24921 .30019 L
.25238 .29924 L
.25556 .2983 L
.25873 .29738 L
.2619 .29646 L
.26508 .29555 L
.26825 .29466 L
.27143 .29377 L
.2746 .29288 L
.27778 .29201 L
.28095 .29115 L
.28413 .29029 L
.2873 .28945 L
.29048 .28861 L
.29365 .28778 L
.29683 .28696 L
.3 .28615 L
.30317 .28534 L
.30635 .28455 L
.30952 .28376 L
.3127 .28298 L
.31587 .2822 L
.31905 .28144 L
.32222 .28068 L
.3254 .27993 L
.32857 .27919 L
.33175 .27845 L
.33492 .27773 L
.3381 .27701 L
.34127 .27629 L
Mistroke
.34444 .27559 L
.34762 .27489 L
.35079 .2742 L
.35397 .27351 L
.35714 .27283 L
.36032 .27216 L
.36349 .2715 L
.36667 .27084 L
.36984 .27019 L
.37302 .26954 L
.37619 .2689 L
.37937 .26827 L
.38254 .26765 L
.38571 .26703 L
.38889 .26641 L
.39206 .2658 L
.39524 .2652 L
.39841 .26461 L
.40159 .26402 L
.40476 .26344 L
.40794 .26286 L
.41111 .26229 L
.41429 .26172 L
.41746 .26116 L
.42063 .26061 L
.42381 .26006 L
.42698 .25951 L
.43016 .25897 L
.43333 .25844 L
.43651 .25791 L
.43968 .25739 L
.44286 .25687 L
.44603 .25636 L
.44921 .25586 L
.45238 .25535 L
.45556 .25486 L
.45873 .25437 L
.4619 .25388 L
.46508 .2534 L
.46825 .25292 L
.47143 .25245 L
.4746 .25198 L
.47778 .25152 L
.48095 .25106 L
.48413 .2506 L
.4873 .25016 L
.49048 .24971 L
.49365 .24927 L
.49683 .24883 L
.5 .2484 L
Mistroke
.50317 .24798 L
.50635 .24755 L
.50952 .24713 L
.5127 .24672 L
.51587 .24631 L
.51905 .2459 L
.52222 .2455 L
.5254 .2451 L
.52857 .24471 L
.53175 .24432 L
.53492 .24393 L
.5381 .24355 L
.54127 .24317 L
.54444 .2428 L
.54762 .24243 L
.55079 .24206 L
.55397 .24169 L
.55714 .24133 L
.56032 .24098 L
.56349 .24062 L
.56667 .24028 L
.56984 .23993 L
.57302 .23959 L
.57619 .23925 L
.57937 .23891 L
.58254 .23858 L
.58571 .23825 L
.58889 .23793 L
.59206 .2376 L
.59524 .23728 L
.59841 .23697 L
.60159 .23666 L
.60476 .23635 L
.60794 .23604 L
.61111 .23574 L
.61429 .23543 L
.61746 .23514 L
.62063 .23484 L
.62381 .23455 L
.62698 .23426 L
.63016 .23398 L
.63333 .23369 L
.63651 .23341 L
.63968 .23314 L
.64286 .23286 L
.64603 .23259 L
.64921 .23232 L
.65238 .23205 L
.65556 .23179 L
.65873 .23153 L
Mistroke
.6619 .23127 L
.66508 .23102 L
.66825 .23076 L
.67143 .23051 L
.6746 .23026 L
.67778 .23002 L
.68095 .22977 L
.68413 .22953 L
.6873 .2293 L
.69048 .22906 L
.69365 .22883 L
.69683 .22859 L
.7 .22836 L
.70317 .22814 L
.70635 .22791 L
.70952 .22769 L
.7127 .22747 L
.71587 .22725 L
.71905 .22704 L
.72222 .22682 L
.7254 .22661 L
.72857 .2264 L
.73175 .2262 L
.73492 .22599 L
.7381 .22579 L
.74127 .22559 L
.74444 .22539 L
.74762 .22519 L
.75079 .225 L
.75397 .2248 L
.75714 .22461 L
.76032 .22442 L
.76349 .22424 L
.76667 .22405 L
.76984 .22387 L
.77302 .22368 L
.77619 .2235 L
.77937 .22333 L
.78254 .22315 L
.78571 .22297 L
.78889 .2228 L
.79206 .22263 L
.79524 .22246 L
.79841 .22229 L
.80159 .22213 L
.80476 .22196 L
.80794 .2218 L
.81111 .22164 L
.81429 .22148 L
.81746 .22132 L
Mistroke
.82063 .22117 L
.82381 .22101 L
.82698 .22086 L
.83016 .22071 L
.83333 .22056 L
.83651 .22041 L
.83968 .22026 L
.84286 .22011 L
.84603 .21997 L
.84921 .21983 L
.85238 .21969 L
.85556 .21955 L
.85873 .21941 L
.8619 .21927 L
.86508 .21913 L
.86825 .219 L
.87143 .21887 L
.8746 .21873 L
.87778 .2186 L
.88095 .21847 L
.88413 .21835 L
.8873 .21822 L
.89048 .21809 L
.89365 .21797 L
.89683 .21785 L
.9 .21773 L
.90317 .21761 L
.90635 .21749 L
.90952 .21737 L
.9127 .21725 L
.91587 .21714 L
.91905 .21702 L
.92222 .21691 L
.9254 .2168 L
.92857 .21668 L
.93175 .21657 L
.93492 .21647 L
.9381 .21636 L
.94127 .21625 L
.94444 .21615 L
.94762 .21604 L
.95079 .21594 L
.95397 .21584 L
.95714 .21573 L
.96032 .21563 L
.96349 .21553 L
.96667 .21544 L
.96984 .21534 L
.97302 .21524 L
.97619 .21515 L
Mistroke
Mfstroke
.0001 w
.02698 .39666 0 2.5 Mabsadd m
.02698 .39666 -0.56518 .7779 Mabsadd L
.02698 .39666 -2.37764 .77254 Mabsadd L
.02698 .39666 -0.91448 -0.29713 Mabsadd L
.02698 .39666 -1.46946 -2.02254 Mabsadd L
.02698 .39666 0 -0.96154 Mabsadd L
.02698 .39666 1.46946 -2.02254 Mabsadd L
.02698 .39666 .91448 -0.29713 Mabsadd L
.02698 .39666 2.37764 .77254 Mabsadd L
.02698 .39666 .56518 .7779 Mabsadd L
.02698 .39666 0 2.5 Mabsadd L closepath F
.03016 .39475 0 2.5 Mabsadd m
.03016 .39475 -0.56518 .7779 Mabsadd L
.03016 .39475 -2.37764 .77254 Mabsadd L
.03016 .39475 -0.91448 -0.29713 Mabsadd L
.03016 .39475 -1.46946 -2.02254 Mabsadd L
.03016 .39475 0 -0.96154 Mabsadd L
.03016 .39475 1.46946 -2.02254 Mabsadd L
.03016 .39475 .91448 -0.29713 Mabsadd L
.03016 .39475 2.37764 .77254 Mabsadd L
.03016 .39475 .56518 .7779 Mabsadd L
.03016 .39475 0 2.5 Mabsadd L closepath F
.03333 .39286 0 2.5 Mabsadd m
.03333 .39286 -0.56518 .7779 Mabsadd L
.03333 .39286 -2.37764 .77254 Mabsadd L
.03333 .39286 -0.91448 -0.29713 Mabsadd L
.03333 .39286 -1.46946 -2.02254 Mabsadd L
.03333 .39286 0 -0.96154 Mabsadd L
.03333 .39286 1.46946 -2.02254 Mabsadd L
.03333 .39286 .91448 -0.29713 Mabsadd L
.03333 .39286 2.37764 .77254 Mabsadd L
.03333 .39286 .56518 .7779 Mabsadd L
.03333 .39286 0 2.5 Mabsadd L closepath F
.03651 .39098 0 2.5 Mabsadd m
.03651 .39098 -0.56518 .7779 Mabsadd L
.03651 .39098 -2.37764 .77254 Mabsadd L
.03651 .39098 -0.91448 -0.29713 Mabsadd L
.03651 .39098 -1.46946 -2.02254 Mabsadd L
.03651 .39098 0 -0.96154 Mabsadd L
.03651 .39098 1.46946 -2.02254 Mabsadd L
.03651 .39098 .91448 -0.29713 Mabsadd L
.03651 .39098 2.37764 .77254 Mabsadd L
.03651 .39098 .56518 .7779 Mabsadd L
.03651 .39098 0 2.5 Mabsadd L closepath F
.03968 .38913 0 2.5 Mabsadd m
.03968 .38913 -0.56518 .7779 Mabsadd L
.03968 .38913 -2.37764 .77254 Mabsadd L
.03968 .38913 -0.91448 -0.29713 Mabsadd L
.03968 .38913 -1.46946 -2.02254 Mabsadd L
.03968 .38913 0 -0.96154 Mabsadd L
.03968 .38913 1.46946 -2.02254 Mabsadd L
.03968 .38913 .91448 -0.29713 Mabsadd L
.03968 .38913 2.37764 .77254 Mabsadd L
.03968 .38913 .56518 .7779 Mabsadd L
.03968 .38913 0 2.5 Mabsadd L closepath F
.04286 .3873 0 2.5 Mabsadd m
.04286 .3873 -0.56518 .7779 Mabsadd L
.04286 .3873 -2.37764 .77254 Mabsadd L
.04286 .3873 -0.91448 -0.29713 Mabsadd L
.04286 .3873 -1.46946 -2.02254 Mabsadd L
.04286 .3873 0 -0.96154 Mabsadd L
.04286 .3873 1.46946 -2.02254 Mabsadd L
.04286 .3873 .91448 -0.29713 Mabsadd L
.04286 .3873 2.37764 .77254 Mabsadd L
.04286 .3873 .56518 .7779 Mabsadd L
.04286 .3873 0 2.5 Mabsadd L closepath F
.04603 .38548 0 2.5 Mabsadd m
.04603 .38548 -0.56518 .7779 Mabsadd L
.04603 .38548 -2.37764 .77254 Mabsadd L
.04603 .38548 -0.91448 -0.29713 Mabsadd L
.04603 .38548 -1.46946 -2.02254 Mabsadd L
.04603 .38548 0 -0.96154 Mabsadd L
.04603 .38548 1.46946 -2.02254 Mabsadd L
.04603 .38548 .91448 -0.29713 Mabsadd L
.04603 .38548 2.37764 .77254 Mabsadd L
.04603 .38548 .56518 .7779 Mabsadd L
.04603 .38548 0 2.5 Mabsadd L closepath F
.04921 .38368 0 2.5 Mabsadd m
.04921 .38368 -0.56518 .7779 Mabsadd L
.04921 .38368 -2.37764 .77254 Mabsadd L
.04921 .38368 -0.91448 -0.29713 Mabsadd L
.04921 .38368 -1.46946 -2.02254 Mabsadd L
.04921 .38368 0 -0.96154 Mabsadd L
.04921 .38368 1.46946 -2.02254 Mabsadd L
.04921 .38368 .91448 -0.29713 Mabsadd L
.04921 .38368 2.37764 .77254 Mabsadd L
.04921 .38368 .56518 .7779 Mabsadd L
.04921 .38368 0 2.5 Mabsadd L closepath F
.05238 .3819 0 2.5 Mabsadd m
.05238 .3819 -0.56518 .7779 Mabsadd L
.05238 .3819 -2.37764 .77254 Mabsadd L
.05238 .3819 -0.91448 -0.29713 Mabsadd L
.05238 .3819 -1.46946 -2.02254 Mabsadd L
.05238 .3819 0 -0.96154 Mabsadd L
.05238 .3819 1.46946 -2.02254 Mabsadd L
.05238 .3819 .91448 -0.29713 Mabsadd L
.05238 .3819 2.37764 .77254 Mabsadd L
.05238 .3819 .56518 .7779 Mabsadd L
.05238 .3819 0 2.5 Mabsadd L closepath F
.05556 .38014 0 2.5 Mabsadd m
.05556 .38014 -0.56518 .7779 Mabsadd L
.05556 .38014 -2.37764 .77254 Mabsadd L
.05556 .38014 -0.91448 -0.29713 Mabsadd L
.05556 .38014 -1.46946 -2.02254 Mabsadd L
.05556 .38014 0 -0.96154 Mabsadd L
.05556 .38014 1.46946 -2.02254 Mabsadd L
.05556 .38014 .91448 -0.29713 Mabsadd L
.05556 .38014 2.37764 .77254 Mabsadd L
.05556 .38014 .56518 .7779 Mabsadd L
.05556 .38014 0 2.5 Mabsadd L closepath F
.05873 .3784 0 2.5 Mabsadd m
.05873 .3784 -0.56518 .7779 Mabsadd L
.05873 .3784 -2.37764 .77254 Mabsadd L
.05873 .3784 -0.91448 -0.29713 Mabsadd L
.05873 .3784 -1.46946 -2.02254 Mabsadd L
.05873 .3784 0 -0.96154 Mabsadd L
.05873 .3784 1.46946 -2.02254 Mabsadd L
.05873 .3784 .91448 -0.29713 Mabsadd L
.05873 .3784 2.37764 .77254 Mabsadd L
.05873 .3784 .56518 .7779 Mabsadd L
.05873 .3784 0 2.5 Mabsadd L closepath F
.0619 .37667 0 2.5 Mabsadd m
.0619 .37667 -0.56518 .7779 Mabsadd L
.0619 .37667 -2.37764 .77254 Mabsadd L
.0619 .37667 -0.91448 -0.29713 Mabsadd L
.0619 .37667 -1.46946 -2.02254 Mabsadd L
.0619 .37667 0 -0.96154 Mabsadd L
.0619 .37667 1.46946 -2.02254 Mabsadd L
.0619 .37667 .91448 -0.29713 Mabsadd L
.0619 .37667 2.37764 .77254 Mabsadd L
.0619 .37667 .56518 .7779 Mabsadd L
.0619 .37667 0 2.5 Mabsadd L closepath F
.06508 .37496 0 2.5 Mabsadd m
.06508 .37496 -0.56518 .7779 Mabsadd L
.06508 .37496 -2.37764 .77254 Mabsadd L
.06508 .37496 -0.91448 -0.29713 Mabsadd L
.06508 .37496 -1.46946 -2.02254 Mabsadd L
.06508 .37496 0 -0.96154 Mabsadd L
.06508 .37496 1.46946 -2.02254 Mabsadd L
.06508 .37496 .91448 -0.29713 Mabsadd L
.06508 .37496 2.37764 .77254 Mabsadd L
.06508 .37496 .56518 .7779 Mabsadd L
.06508 .37496 0 2.5 Mabsadd L closepath F
.06825 .37327 0 2.5 Mabsadd m
.06825 .37327 -0.56518 .7779 Mabsadd L
.06825 .37327 -2.37764 .77254 Mabsadd L
.06825 .37327 -0.91448 -0.29713 Mabsadd L
.06825 .37327 -1.46946 -2.02254 Mabsadd L
.06825 .37327 0 -0.96154 Mabsadd L
.06825 .37327 1.46946 -2.02254 Mabsadd L
.06825 .37327 .91448 -0.29713 Mabsadd L
.06825 .37327 2.37764 .77254 Mabsadd L
.06825 .37327 .56518 .7779 Mabsadd L
.06825 .37327 0 2.5 Mabsadd L closepath F
.07143 .37159 0 2.5 Mabsadd m
.07143 .37159 -0.56518 .7779 Mabsadd L
.07143 .37159 -2.37764 .77254 Mabsadd L
.07143 .37159 -0.91448 -0.29713 Mabsadd L
.07143 .37159 -1.46946 -2.02254 Mabsadd L
.07143 .37159 0 -0.96154 Mabsadd L
.07143 .37159 1.46946 -2.02254 Mabsadd L
.07143 .37159 .91448 -0.29713 Mabsadd L
.07143 .37159 2.37764 .77254 Mabsadd L
.07143 .37159 .56518 .7779 Mabsadd L
.07143 .37159 0 2.5 Mabsadd L closepath F
.0746 .36993 0 2.5 Mabsadd m
.0746 .36993 -0.56518 .7779 Mabsadd L
.0746 .36993 -2.37764 .77254 Mabsadd L
.0746 .36993 -0.91448 -0.29713 Mabsadd L
.0746 .36993 -1.46946 -2.02254 Mabsadd L
.0746 .36993 0 -0.96154 Mabsadd L
.0746 .36993 1.46946 -2.02254 Mabsadd L
.0746 .36993 .91448 -0.29713 Mabsadd L
.0746 .36993 2.37764 .77254 Mabsadd L
.0746 .36993 .56518 .7779 Mabsadd L
.0746 .36993 0 2.5 Mabsadd L closepath F
.07778 .36829 0 2.5 Mabsadd m
.07778 .36829 -0.56518 .7779 Mabsadd L
.07778 .36829 -2.37764 .77254 Mabsadd L
.07778 .36829 -0.91448 -0.29713 Mabsadd L
.07778 .36829 -1.46946 -2.02254 Mabsadd L
.07778 .36829 0 -0.96154 Mabsadd L
.07778 .36829 1.46946 -2.02254 Mabsadd L
.07778 .36829 .91448 -0.29713 Mabsadd L
.07778 .36829 2.37764 .77254 Mabsadd L
.07778 .36829 .56518 .7779 Mabsadd L
.07778 .36829 0 2.5 Mabsadd L closepath F
.08095 .36666 0 2.5 Mabsadd m
.08095 .36666 -0.56518 .7779 Mabsadd L
.08095 .36666 -2.37764 .77254 Mabsadd L
.08095 .36666 -0.91448 -0.29713 Mabsadd L
.08095 .36666 -1.46946 -2.02254 Mabsadd L
.08095 .36666 0 -0.96154 Mabsadd L
.08095 .36666 1.46946 -2.02254 Mabsadd L
.08095 .36666 .91448 -0.29713 Mabsadd L
.08095 .36666 2.37764 .77254 Mabsadd L
.08095 .36666 .56518 .7779 Mabsadd L
.08095 .36666 0 2.5 Mabsadd L closepath F
.08413 .36505 0 2.5 Mabsadd m
.08413 .36505 -0.56518 .7779 Mabsadd L
.08413 .36505 -2.37764 .77254 Mabsadd L
.08413 .36505 -0.91448 -0.29713 Mabsadd L
.08413 .36505 -1.46946 -2.02254 Mabsadd L
.08413 .36505 0 -0.96154 Mabsadd L
.08413 .36505 1.46946 -2.02254 Mabsadd L
.08413 .36505 .91448 -0.29713 Mabsadd L
.08413 .36505 2.37764 .77254 Mabsadd L
.08413 .36505 .56518 .7779 Mabsadd L
.08413 .36505 0 2.5 Mabsadd L closepath F
.0873 .36346 0 2.5 Mabsadd m
.0873 .36346 -0.56518 .7779 Mabsadd L
.0873 .36346 -2.37764 .77254 Mabsadd L
.0873 .36346 -0.91448 -0.29713 Mabsadd L
.0873 .36346 -1.46946 -2.02254 Mabsadd L
.0873 .36346 0 -0.96154 Mabsadd L
.0873 .36346 1.46946 -2.02254 Mabsadd L
.0873 .36346 .91448 -0.29713 Mabsadd L
.0873 .36346 2.37764 .77254 Mabsadd L
.0873 .36346 .56518 .7779 Mabsadd L
.0873 .36346 0 2.5 Mabsadd L closepath F
.09048 .36188 0 2.5 Mabsadd m
.09048 .36188 -0.56518 .7779 Mabsadd L
.09048 .36188 -2.37764 .77254 Mabsadd L
.09048 .36188 -0.91448 -0.29713 Mabsadd L
.09048 .36188 -1.46946 -2.02254 Mabsadd L
.09048 .36188 0 -0.96154 Mabsadd L
.09048 .36188 1.46946 -2.02254 Mabsadd L
.09048 .36188 .91448 -0.29713 Mabsadd L
.09048 .36188 2.37764 .77254 Mabsadd L
.09048 .36188 .56518 .7779 Mabsadd L
.09048 .36188 0 2.5 Mabsadd L closepath F
.09365 .36032 0 2.5 Mabsadd m
.09365 .36032 -0.56518 .7779 Mabsadd L
.09365 .36032 -2.37764 .77254 Mabsadd L
.09365 .36032 -0.91448 -0.29713 Mabsadd L
.09365 .36032 -1.46946 -2.02254 Mabsadd L
.09365 .36032 0 -0.96154 Mabsadd L
.09365 .36032 1.46946 -2.02254 Mabsadd L
.09365 .36032 .91448 -0.29713 Mabsadd L
.09365 .36032 2.37764 .77254 Mabsadd L
.09365 .36032 .56518 .7779 Mabsadd L
.09365 .36032 0 2.5 Mabsadd L closepath F
.09683 .35877 0 2.5 Mabsadd m
.09683 .35877 -0.56518 .7779 Mabsadd L
.09683 .35877 -2.37764 .77254 Mabsadd L
.09683 .35877 -0.91448 -0.29713 Mabsadd L
.09683 .35877 -1.46946 -2.02254 Mabsadd L
.09683 .35877 0 -0.96154 Mabsadd L
.09683 .35877 1.46946 -2.02254 Mabsadd L
.09683 .35877 .91448 -0.29713 Mabsadd L
.09683 .35877 2.37764 .77254 Mabsadd L
.09683 .35877 .56518 .7779 Mabsadd L
.09683 .35877 0 2.5 Mabsadd L closepath F
.1 .35724 0 2.5 Mabsadd m
.1 .35724 -0.56518 .7779 Mabsadd L
.1 .35724 -2.37764 .77254 Mabsadd L
.1 .35724 -0.91448 -0.29713 Mabsadd L
.1 .35724 -1.46946 -2.02254 Mabsadd L
.1 .35724 0 -0.96154 Mabsadd L
.1 .35724 1.46946 -2.02254 Mabsadd L
.1 .35724 .91448 -0.29713 Mabsadd L
.1 .35724 2.37764 .77254 Mabsadd L
.1 .35724 .56518 .7779 Mabsadd L
.1 .35724 0 2.5 Mabsadd L closepath F
.10317 .35573 0 2.5 Mabsadd m
.10317 .35573 -0.56518 .7779 Mabsadd L
.10317 .35573 -2.37764 .77254 Mabsadd L
.10317 .35573 -0.91448 -0.29713 Mabsadd L
.10317 .35573 -1.46946 -2.02254 Mabsadd L
.10317 .35573 0 -0.96154 Mabsadd L
.10317 .35573 1.46946 -2.02254 Mabsadd L
.10317 .35573 .91448 -0.29713 Mabsadd L
.10317 .35573 2.37764 .77254 Mabsadd L
.10317 .35573 .56518 .7779 Mabsadd L
.10317 .35573 0 2.5 Mabsadd L closepath F
.10635 .35423 0 2.5 Mabsadd m
.10635 .35423 -0.56518 .7779 Mabsadd L
.10635 .35423 -2.37764 .77254 Mabsadd L
.10635 .35423 -0.91448 -0.29713 Mabsadd L
.10635 .35423 -1.46946 -2.02254 Mabsadd L
.10635 .35423 0 -0.96154 Mabsadd L
.10635 .35423 1.46946 -2.02254 Mabsadd L
.10635 .35423 .91448 -0.29713 Mabsadd L
.10635 .35423 2.37764 .77254 Mabsadd L
.10635 .35423 .56518 .7779 Mabsadd L
.10635 .35423 0 2.5 Mabsadd L closepath F
.10952 .35274 0 2.5 Mabsadd m
.10952 .35274 -0.56518 .7779 Mabsadd L
.10952 .35274 -2.37764 .77254 Mabsadd L
.10952 .35274 -0.91448 -0.29713 Mabsadd L
.10952 .35274 -1.46946 -2.02254 Mabsadd L
.10952 .35274 0 -0.96154 Mabsadd L
.10952 .35274 1.46946 -2.02254 Mabsadd L
.10952 .35274 .91448 -0.29713 Mabsadd L
.10952 .35274 2.37764 .77254 Mabsadd L
.10952 .35274 .56518 .7779 Mabsadd L
.10952 .35274 0 2.5 Mabsadd L closepath F
.1127 .35127 0 2.5 Mabsadd m
.1127 .35127 -0.56518 .7779 Mabsadd L
.1127 .35127 -2.37764 .77254 Mabsadd L
.1127 .35127 -0.91448 -0.29713 Mabsadd L
.1127 .35127 -1.46946 -2.02254 Mabsadd L
.1127 .35127 0 -0.96154 Mabsadd L
.1127 .35127 1.46946 -2.02254 Mabsadd L
.1127 .35127 .91448 -0.29713 Mabsadd L
.1127 .35127 2.37764 .77254 Mabsadd L
.1127 .35127 .56518 .7779 Mabsadd L
.1127 .35127 0 2.5 Mabsadd L closepath F
.11587 .34981 0 2.5 Mabsadd m
.11587 .34981 -0.56518 .7779 Mabsadd L
.11587 .34981 -2.37764 .77254 Mabsadd L
.11587 .34981 -0.91448 -0.29713 Mabsadd L
.11587 .34981 -1.46946 -2.02254 Mabsadd L
.11587 .34981 0 -0.96154 Mabsadd L
.11587 .34981 1.46946 -2.02254 Mabsadd L
.11587 .34981 .91448 -0.29713 Mabsadd L
.11587 .34981 2.37764 .77254 Mabsadd L
.11587 .34981 .56518 .7779 Mabsadd L
.11587 .34981 0 2.5 Mabsadd L closepath F
.11905 .34837 0 2.5 Mabsadd m
.11905 .34837 -0.56518 .7779 Mabsadd L
.11905 .34837 -2.37764 .77254 Mabsadd L
.11905 .34837 -0.91448 -0.29713 Mabsadd L
.11905 .34837 -1.46946 -2.02254 Mabsadd L
.11905 .34837 0 -0.96154 Mabsadd L
.11905 .34837 1.46946 -2.02254 Mabsadd L
.11905 .34837 .91448 -0.29713 Mabsadd L
.11905 .34837 2.37764 .77254 Mabsadd L
.11905 .34837 .56518 .7779 Mabsadd L
.11905 .34837 0 2.5 Mabsadd L closepath F
.12222 .34695 0 2.5 Mabsadd m
.12222 .34695 -0.56518 .7779 Mabsadd L
.12222 .34695 -2.37764 .77254 Mabsadd L
.12222 .34695 -0.91448 -0.29713 Mabsadd L
.12222 .34695 -1.46946 -2.02254 Mabsadd L
.12222 .34695 0 -0.96154 Mabsadd L
.12222 .34695 1.46946 -2.02254 Mabsadd L
.12222 .34695 .91448 -0.29713 Mabsadd L
.12222 .34695 2.37764 .77254 Mabsadd L
.12222 .34695 .56518 .7779 Mabsadd L
.12222 .34695 0 2.5 Mabsadd L closepath F
.1254 .34553 0 2.5 Mabsadd m
.1254 .34553 -0.56518 .7779 Mabsadd L
.1254 .34553 -2.37764 .77254 Mabsadd L
.1254 .34553 -0.91448 -0.29713 Mabsadd L
.1254 .34553 -1.46946 -2.02254 Mabsadd L
.1254 .34553 0 -0.96154 Mabsadd L
.1254 .34553 1.46946 -2.02254 Mabsadd L
.1254 .34553 .91448 -0.29713 Mabsadd L
.1254 .34553 2.37764 .77254 Mabsadd L
.1254 .34553 .56518 .7779 Mabsadd L
.1254 .34553 0 2.5 Mabsadd L closepath F
.12857 .34414 0 2.5 Mabsadd m
.12857 .34414 -0.56518 .7779 Mabsadd L
.12857 .34414 -2.37764 .77254 Mabsadd L
.12857 .34414 -0.91448 -0.29713 Mabsadd L
.12857 .34414 -1.46946 -2.02254 Mabsadd L
.12857 .34414 0 -0.96154 Mabsadd L
.12857 .34414 1.46946 -2.02254 Mabsadd L
.12857 .34414 .91448 -0.29713 Mabsadd L
.12857 .34414 2.37764 .77254 Mabsadd L
.12857 .34414 .56518 .7779 Mabsadd L
.12857 .34414 0 2.5 Mabsadd L closepath F
.13175 .34275 0 2.5 Mabsadd m
.13175 .34275 -0.56518 .7779 Mabsadd L
.13175 .34275 -2.37764 .77254 Mabsadd L
.13175 .34275 -0.91448 -0.29713 Mabsadd L
.13175 .34275 -1.46946 -2.02254 Mabsadd L
.13175 .34275 0 -0.96154 Mabsadd L
.13175 .34275 1.46946 -2.02254 Mabsadd L
.13175 .34275 .91448 -0.29713 Mabsadd L
.13175 .34275 2.37764 .77254 Mabsadd L
.13175 .34275 .56518 .7779 Mabsadd L
.13175 .34275 0 2.5 Mabsadd L closepath F
.13492 .34138 0 2.5 Mabsadd m
.13492 .34138 -0.56518 .7779 Mabsadd L
.13492 .34138 -2.37764 .77254 Mabsadd L
.13492 .34138 -0.91448 -0.29713 Mabsadd L
.13492 .34138 -1.46946 -2.02254 Mabsadd L
.13492 .34138 0 -0.96154 Mabsadd L
.13492 .34138 1.46946 -2.02254 Mabsadd L
.13492 .34138 .91448 -0.29713 Mabsadd L
.13492 .34138 2.37764 .77254 Mabsadd L
.13492 .34138 .56518 .7779 Mabsadd L
.13492 .34138 0 2.5 Mabsadd L closepath F
.1381 .34002 0 2.5 Mabsadd m
.1381 .34002 -0.56518 .7779 Mabsadd L
.1381 .34002 -2.37764 .77254 Mabsadd L
.1381 .34002 -0.91448 -0.29713 Mabsadd L
.1381 .34002 -1.46946 -2.02254 Mabsadd L
.1381 .34002 0 -0.96154 Mabsadd L
.1381 .34002 1.46946 -2.02254 Mabsadd L
.1381 .34002 .91448 -0.29713 Mabsadd L
.1381 .34002 2.37764 .77254 Mabsadd L
.1381 .34002 .56518 .7779 Mabsadd L
.1381 .34002 0 2.5 Mabsadd L closepath F
.14127 .33868 0 2.5 Mabsadd m
.14127 .33868 -0.56518 .7779 Mabsadd L
.14127 .33868 -2.37764 .77254 Mabsadd L
.14127 .33868 -0.91448 -0.29713 Mabsadd L
.14127 .33868 -1.46946 -2.02254 Mabsadd L
.14127 .33868 0 -0.96154 Mabsadd L
.14127 .33868 1.46946 -2.02254 Mabsadd L
.14127 .33868 .91448 -0.29713 Mabsadd L
.14127 .33868 2.37764 .77254 Mabsadd L
.14127 .33868 .56518 .7779 Mabsadd L
.14127 .33868 0 2.5 Mabsadd L closepath F
.14444 .33735 0 2.5 Mabsadd m
.14444 .33735 -0.56518 .7779 Mabsadd L
.14444 .33735 -2.37764 .77254 Mabsadd L
.14444 .33735 -0.91448 -0.29713 Mabsadd L
.14444 .33735 -1.46946 -2.02254 Mabsadd L
.14444 .33735 0 -0.96154 Mabsadd L
.14444 .33735 1.46946 -2.02254 Mabsadd L
.14444 .33735 .91448 -0.29713 Mabsadd L
.14444 .33735 2.37764 .77254 Mabsadd L
.14444 .33735 .56518 .7779 Mabsadd L
.14444 .33735 0 2.5 Mabsadd L closepath F
.14762 .33603 0 2.5 Mabsadd m
.14762 .33603 -0.56518 .7779 Mabsadd L
.14762 .33603 -2.37764 .77254 Mabsadd L
.14762 .33603 -0.91448 -0.29713 Mabsadd L
.14762 .33603 -1.46946 -2.02254 Mabsadd L
.14762 .33603 0 -0.96154 Mabsadd L
.14762 .33603 1.46946 -2.02254 Mabsadd L
.14762 .33603 .91448 -0.29713 Mabsadd L
.14762 .33603 2.37764 .77254 Mabsadd L
.14762 .33603 .56518 .7779 Mabsadd L
.14762 .33603 0 2.5 Mabsadd L closepath F
.15079 .33473 0 2.5 Mabsadd m
.15079 .33473 -0.56518 .7779 Mabsadd L
.15079 .33473 -2.37764 .77254 Mabsadd L
.15079 .33473 -0.91448 -0.29713 Mabsadd L
.15079 .33473 -1.46946 -2.02254 Mabsadd L
.15079 .33473 0 -0.96154 Mabsadd L
.15079 .33473 1.46946 -2.02254 Mabsadd L
.15079 .33473 .91448 -0.29713 Mabsadd L
.15079 .33473 2.37764 .77254 Mabsadd L
.15079 .33473 .56518 .7779 Mabsadd L
.15079 .33473 0 2.5 Mabsadd L closepath F
.15397 .33344 0 2.5 Mabsadd m
.15397 .33344 -0.56518 .7779 Mabsadd L
.15397 .33344 -2.37764 .77254 Mabsadd L
.15397 .33344 -0.91448 -0.29713 Mabsadd L
.15397 .33344 -1.46946 -2.02254 Mabsadd L
.15397 .33344 0 -0.96154 Mabsadd L
.15397 .33344 1.46946 -2.02254 Mabsadd L
.15397 .33344 .91448 -0.29713 Mabsadd L
.15397 .33344 2.37764 .77254 Mabsadd L
.15397 .33344 .56518 .7779 Mabsadd L
.15397 .33344 0 2.5 Mabsadd L closepath F
.15714 .33216 0 2.5 Mabsadd m
.15714 .33216 -0.56518 .7779 Mabsadd L
.15714 .33216 -2.37764 .77254 Mabsadd L
.15714 .33216 -0.91448 -0.29713 Mabsadd L
.15714 .33216 -1.46946 -2.02254 Mabsadd L
.15714 .33216 0 -0.96154 Mabsadd L
.15714 .33216 1.46946 -2.02254 Mabsadd L
.15714 .33216 .91448 -0.29713 Mabsadd L
.15714 .33216 2.37764 .77254 Mabsadd L
.15714 .33216 .56518 .7779 Mabsadd L
.15714 .33216 0 2.5 Mabsadd L closepath F
.16032 .3309 0 2.5 Mabsadd m
.16032 .3309 -0.56518 .7779 Mabsadd L
.16032 .3309 -2.37764 .77254 Mabsadd L
.16032 .3309 -0.91448 -0.29713 Mabsadd L
.16032 .3309 -1.46946 -2.02254 Mabsadd L
.16032 .3309 0 -0.96154 Mabsadd L
.16032 .3309 1.46946 -2.02254 Mabsadd L
.16032 .3309 .91448 -0.29713 Mabsadd L
.16032 .3309 2.37764 .77254 Mabsadd L
.16032 .3309 .56518 .7779 Mabsadd L
.16032 .3309 0 2.5 Mabsadd L closepath F
.16349 .32964 0 2.5 Mabsadd m
.16349 .32964 -0.56518 .7779 Mabsadd L
.16349 .32964 -2.37764 .77254 Mabsadd L
.16349 .32964 -0.91448 -0.29713 Mabsadd L
.16349 .32964 -1.46946 -2.02254 Mabsadd L
.16349 .32964 0 -0.96154 Mabsadd L
.16349 .32964 1.46946 -2.02254 Mabsadd L
.16349 .32964 .91448 -0.29713 Mabsadd L
.16349 .32964 2.37764 .77254 Mabsadd L
.16349 .32964 .56518 .7779 Mabsadd L
.16349 .32964 0 2.5 Mabsadd L closepath F
.16667 .32841 0 2.5 Mabsadd m
.16667 .32841 -0.56518 .7779 Mabsadd L
.16667 .32841 -2.37764 .77254 Mabsadd L
.16667 .32841 -0.91448 -0.29713 Mabsadd L
.16667 .32841 -1.46946 -2.02254 Mabsadd L
.16667 .32841 0 -0.96154 Mabsadd L
.16667 .32841 1.46946 -2.02254 Mabsadd L
.16667 .32841 .91448 -0.29713 Mabsadd L
.16667 .32841 2.37764 .77254 Mabsadd L
.16667 .32841 .56518 .7779 Mabsadd L
.16667 .32841 0 2.5 Mabsadd L closepath F
.16984 .32718 0 2.5 Mabsadd m
.16984 .32718 -0.56518 .7779 Mabsadd L
.16984 .32718 -2.37764 .77254 Mabsadd L
.16984 .32718 -0.91448 -0.29713 Mabsadd L
.16984 .32718 -1.46946 -2.02254 Mabsadd L
.16984 .32718 0 -0.96154 Mabsadd L
.16984 .32718 1.46946 -2.02254 Mabsadd L
.16984 .32718 .91448 -0.29713 Mabsadd L
.16984 .32718 2.37764 .77254 Mabsadd L
.16984 .32718 .56518 .7779 Mabsadd L
.16984 .32718 0 2.5 Mabsadd L closepath F
.17302 .32596 0 2.5 Mabsadd m
.17302 .32596 -0.56518 .7779 Mabsadd L
.17302 .32596 -2.37764 .77254 Mabsadd L
.17302 .32596 -0.91448 -0.29713 Mabsadd L
.17302 .32596 -1.46946 -2.02254 Mabsadd L
.17302 .32596 0 -0.96154 Mabsadd L
.17302 .32596 1.46946 -2.02254 Mabsadd L
.17302 .32596 .91448 -0.29713 Mabsadd L
.17302 .32596 2.37764 .77254 Mabsadd L
.17302 .32596 .56518 .7779 Mabsadd L
.17302 .32596 0 2.5 Mabsadd L closepath F
.17619 .32476 0 2.5 Mabsadd m
.17619 .32476 -0.56518 .7779 Mabsadd L
.17619 .32476 -2.37764 .77254 Mabsadd L
.17619 .32476 -0.91448 -0.29713 Mabsadd L
.17619 .32476 -1.46946 -2.02254 Mabsadd L
.17619 .32476 0 -0.96154 Mabsadd L
.17619 .32476 1.46946 -2.02254 Mabsadd L
.17619 .32476 .91448 -0.29713 Mabsadd L
.17619 .32476 2.37764 .77254 Mabsadd L
.17619 .32476 .56518 .7779 Mabsadd L
.17619 .32476 0 2.5 Mabsadd L closepath F
.17937 .32357 0 2.5 Mabsadd m
.17937 .32357 -0.56518 .7779 Mabsadd L
.17937 .32357 -2.37764 .77254 Mabsadd L
.17937 .32357 -0.91448 -0.29713 Mabsadd L
.17937 .32357 -1.46946 -2.02254 Mabsadd L
.17937 .32357 0 -0.96154 Mabsadd L
.17937 .32357 1.46946 -2.02254 Mabsadd L
.17937 .32357 .91448 -0.29713 Mabsadd L
.17937 .32357 2.37764 .77254 Mabsadd L
.17937 .32357 .56518 .7779 Mabsadd L
.17937 .32357 0 2.5 Mabsadd L closepath F
.18254 .32239 0 2.5 Mabsadd m
.18254 .32239 -0.56518 .7779 Mabsadd L
.18254 .32239 -2.37764 .77254 Mabsadd L
.18254 .32239 -0.91448 -0.29713 Mabsadd L
.18254 .32239 -1.46946 -2.02254 Mabsadd L
.18254 .32239 0 -0.96154 Mabsadd L
.18254 .32239 1.46946 -2.02254 Mabsadd L
.18254 .32239 .91448 -0.29713 Mabsadd L
.18254 .32239 2.37764 .77254 Mabsadd L
.18254 .32239 .56518 .7779 Mabsadd L
.18254 .32239 0 2.5 Mabsadd L closepath F
.18571 .32122 0 2.5 Mabsadd m
.18571 .32122 -0.56518 .7779 Mabsadd L
.18571 .32122 -2.37764 .77254 Mabsadd L
.18571 .32122 -0.91448 -0.29713 Mabsadd L
.18571 .32122 -1.46946 -2.02254 Mabsadd L
.18571 .32122 0 -0.96154 Mabsadd L
.18571 .32122 1.46946 -2.02254 Mabsadd L
.18571 .32122 .91448 -0.29713 Mabsadd L
.18571 .32122 2.37764 .77254 Mabsadd L
.18571 .32122 .56518 .7779 Mabsadd L
.18571 .32122 0 2.5 Mabsadd L closepath F
.18889 .32007 0 2.5 Mabsadd m
.18889 .32007 -0.56518 .7779 Mabsadd L
.18889 .32007 -2.37764 .77254 Mabsadd L
.18889 .32007 -0.91448 -0.29713 Mabsadd L
.18889 .32007 -1.46946 -2.02254 Mabsadd L
.18889 .32007 0 -0.96154 Mabsadd L
.18889 .32007 1.46946 -2.02254 Mabsadd L
.18889 .32007 .91448 -0.29713 Mabsadd L
.18889 .32007 2.37764 .77254 Mabsadd L
.18889 .32007 .56518 .7779 Mabsadd L
.18889 .32007 0 2.5 Mabsadd L closepath F
.19206 .31892 0 2.5 Mabsadd m
.19206 .31892 -0.56518 .7779 Mabsadd L
.19206 .31892 -2.37764 .77254 Mabsadd L
.19206 .31892 -0.91448 -0.29713 Mabsadd L
.19206 .31892 -1.46946 -2.02254 Mabsadd L
.19206 .31892 0 -0.96154 Mabsadd L
.19206 .31892 1.46946 -2.02254 Mabsadd L
.19206 .31892 .91448 -0.29713 Mabsadd L
.19206 .31892 2.37764 .77254 Mabsadd L
.19206 .31892 .56518 .7779 Mabsadd L
.19206 .31892 0 2.5 Mabsadd L closepath F
.19524 .31779 0 2.5 Mabsadd m
.19524 .31779 -0.56518 .7779 Mabsadd L
.19524 .31779 -2.37764 .77254 Mabsadd L
.19524 .31779 -0.91448 -0.29713 Mabsadd L
.19524 .31779 -1.46946 -2.02254 Mabsadd L
.19524 .31779 0 -0.96154 Mabsadd L
.19524 .31779 1.46946 -2.02254 Mabsadd L
.19524 .31779 .91448 -0.29713 Mabsadd L
.19524 .31779 2.37764 .77254 Mabsadd L
.19524 .31779 .56518 .7779 Mabsadd L
.19524 .31779 0 2.5 Mabsadd L closepath F
.19841 .31667 0 2.5 Mabsadd m
.19841 .31667 -0.56518 .7779 Mabsadd L
.19841 .31667 -2.37764 .77254 Mabsadd L
.19841 .31667 -0.91448 -0.29713 Mabsadd L
.19841 .31667 -1.46946 -2.02254 Mabsadd L
.19841 .31667 0 -0.96154 Mabsadd L
.19841 .31667 1.46946 -2.02254 Mabsadd L
.19841 .31667 .91448 -0.29713 Mabsadd L
.19841 .31667 2.37764 .77254 Mabsadd L
.19841 .31667 .56518 .7779 Mabsadd L
.19841 .31667 0 2.5 Mabsadd L closepath F
.20159 .31556 0 2.5 Mabsadd m
.20159 .31556 -0.56518 .7779 Mabsadd L
.20159 .31556 -2.37764 .77254 Mabsadd L
.20159 .31556 -0.91448 -0.29713 Mabsadd L
.20159 .31556 -1.46946 -2.02254 Mabsadd L
.20159 .31556 0 -0.96154 Mabsadd L
.20159 .31556 1.46946 -2.02254 Mabsadd L
.20159 .31556 .91448 -0.29713 Mabsadd L
.20159 .31556 2.37764 .77254 Mabsadd L
.20159 .31556 .56518 .7779 Mabsadd L
.20159 .31556 0 2.5 Mabsadd L closepath F
.20476 .31446 0 2.5 Mabsadd m
.20476 .31446 -0.56518 .7779 Mabsadd L
.20476 .31446 -2.37764 .77254 Mabsadd L
.20476 .31446 -0.91448 -0.29713 Mabsadd L
.20476 .31446 -1.46946 -2.02254 Mabsadd L
.20476 .31446 0 -0.96154 Mabsadd L
.20476 .31446 1.46946 -2.02254 Mabsadd L
.20476 .31446 .91448 -0.29713 Mabsadd L
.20476 .31446 2.37764 .77254 Mabsadd L
.20476 .31446 .56518 .7779 Mabsadd L
.20476 .31446 0 2.5 Mabsadd L closepath F
.20794 .31337 0 2.5 Mabsadd m
.20794 .31337 -0.56518 .7779 Mabsadd L
.20794 .31337 -2.37764 .77254 Mabsadd L
.20794 .31337 -0.91448 -0.29713 Mabsadd L
.20794 .31337 -1.46946 -2.02254 Mabsadd L
.20794 .31337 0 -0.96154 Mabsadd L
.20794 .31337 1.46946 -2.02254 Mabsadd L
.20794 .31337 .91448 -0.29713 Mabsadd L
.20794 .31337 2.37764 .77254 Mabsadd L
.20794 .31337 .56518 .7779 Mabsadd L
.20794 .31337 0 2.5 Mabsadd L closepath F
.21111 .3123 0 2.5 Mabsadd m
.21111 .3123 -0.56518 .7779 Mabsadd L
.21111 .3123 -2.37764 .77254 Mabsadd L
.21111 .3123 -0.91448 -0.29713 Mabsadd L
.21111 .3123 -1.46946 -2.02254 Mabsadd L
.21111 .3123 0 -0.96154 Mabsadd L
.21111 .3123 1.46946 -2.02254 Mabsadd L
.21111 .3123 .91448 -0.29713 Mabsadd L
.21111 .3123 2.37764 .77254 Mabsadd L
.21111 .3123 .56518 .7779 Mabsadd L
.21111 .3123 0 2.5 Mabsadd L closepath F
.21429 .31123 0 2.5 Mabsadd m
.21429 .31123 -0.56518 .7779 Mabsadd L
.21429 .31123 -2.37764 .77254 Mabsadd L
.21429 .31123 -0.91448 -0.29713 Mabsadd L
.21429 .31123 -1.46946 -2.02254 Mabsadd L
.21429 .31123 0 -0.96154 Mabsadd L
.21429 .31123 1.46946 -2.02254 Mabsadd L
.21429 .31123 .91448 -0.29713 Mabsadd L
.21429 .31123 2.37764 .77254 Mabsadd L
.21429 .31123 .56518 .7779 Mabsadd L
.21429 .31123 0 2.5 Mabsadd L closepath F
.21746 .31018 0 2.5 Mabsadd m
.21746 .31018 -0.56518 .7779 Mabsadd L
.21746 .31018 -2.37764 .77254 Mabsadd L
.21746 .31018 -0.91448 -0.29713 Mabsadd L
.21746 .31018 -1.46946 -2.02254 Mabsadd L
.21746 .31018 0 -0.96154 Mabsadd L
.21746 .31018 1.46946 -2.02254 Mabsadd L
.21746 .31018 .91448 -0.29713 Mabsadd L
.21746 .31018 2.37764 .77254 Mabsadd L
.21746 .31018 .56518 .7779 Mabsadd L
.21746 .31018 0 2.5 Mabsadd L closepath F
.22063 .30913 0 2.5 Mabsadd m
.22063 .30913 -0.56518 .7779 Mabsadd L
.22063 .30913 -2.37764 .77254 Mabsadd L
.22063 .30913 -0.91448 -0.29713 Mabsadd L
.22063 .30913 -1.46946 -2.02254 Mabsadd L
.22063 .30913 0 -0.96154 Mabsadd L
.22063 .30913 1.46946 -2.02254 Mabsadd L
.22063 .30913 .91448 -0.29713 Mabsadd L
.22063 .30913 2.37764 .77254 Mabsadd L
.22063 .30913 .56518 .7779 Mabsadd L
.22063 .30913 0 2.5 Mabsadd L closepath F
.22381 .3081 0 2.5 Mabsadd m
.22381 .3081 -0.56518 .7779 Mabsadd L
.22381 .3081 -2.37764 .77254 Mabsadd L
.22381 .3081 -0.91448 -0.29713 Mabsadd L
.22381 .3081 -1.46946 -2.02254 Mabsadd L
.22381 .3081 0 -0.96154 Mabsadd L
.22381 .3081 1.46946 -2.02254 Mabsadd L
.22381 .3081 .91448 -0.29713 Mabsadd L
.22381 .3081 2.37764 .77254 Mabsadd L
.22381 .3081 .56518 .7779 Mabsadd L
.22381 .3081 0 2.5 Mabsadd L closepath F
.22698 .30707 0 2.5 Mabsadd m
.22698 .30707 -0.56518 .7779 Mabsadd L
.22698 .30707 -2.37764 .77254 Mabsadd L
.22698 .30707 -0.91448 -0.29713 Mabsadd L
.22698 .30707 -1.46946 -2.02254 Mabsadd L
.22698 .30707 0 -0.96154 Mabsadd L
.22698 .30707 1.46946 -2.02254 Mabsadd L
.22698 .30707 .91448 -0.29713 Mabsadd L
.22698 .30707 2.37764 .77254 Mabsadd L
.22698 .30707 .56518 .7779 Mabsadd L
.22698 .30707 0 2.5 Mabsadd L closepath F
.23016 .30606 0 2.5 Mabsadd m
.23016 .30606 -0.56518 .7779 Mabsadd L
.23016 .30606 -2.37764 .77254 Mabsadd L
.23016 .30606 -0.91448 -0.29713 Mabsadd L
.23016 .30606 -1.46946 -2.02254 Mabsadd L
.23016 .30606 0 -0.96154 Mabsadd L
.23016 .30606 1.46946 -2.02254 Mabsadd L
.23016 .30606 .91448 -0.29713 Mabsadd L
.23016 .30606 2.37764 .77254 Mabsadd L
.23016 .30606 .56518 .7779 Mabsadd L
.23016 .30606 0 2.5 Mabsadd L closepath F
.23333 .30506 0 2.5 Mabsadd m
.23333 .30506 -0.56518 .7779 Mabsadd L
.23333 .30506 -2.37764 .77254 Mabsadd L
.23333 .30506 -0.91448 -0.29713 Mabsadd L
.23333 .30506 -1.46946 -2.02254 Mabsadd L
.23333 .30506 0 -0.96154 Mabsadd L
.23333 .30506 1.46946 -2.02254 Mabsadd L
.23333 .30506 .91448 -0.29713 Mabsadd L
.23333 .30506 2.37764 .77254 Mabsadd L
.23333 .30506 .56518 .7779 Mabsadd L
.23333 .30506 0 2.5 Mabsadd L closepath F
.23651 .30406 0 2.5 Mabsadd m
.23651 .30406 -0.56518 .7779 Mabsadd L
.23651 .30406 -2.37764 .77254 Mabsadd L
.23651 .30406 -0.91448 -0.29713 Mabsadd L
.23651 .30406 -1.46946 -2.02254 Mabsadd L
.23651 .30406 0 -0.96154 Mabsadd L
.23651 .30406 1.46946 -2.02254 Mabsadd L
.23651 .30406 .91448 -0.29713 Mabsadd L
.23651 .30406 2.37764 .77254 Mabsadd L
.23651 .30406 .56518 .7779 Mabsadd L
.23651 .30406 0 2.5 Mabsadd L closepath F
.23968 .30308 0 2.5 Mabsadd m
.23968 .30308 -0.56518 .7779 Mabsadd L
.23968 .30308 -2.37764 .77254 Mabsadd L
.23968 .30308 -0.91448 -0.29713 Mabsadd L
.23968 .30308 -1.46946 -2.02254 Mabsadd L
.23968 .30308 0 -0.96154 Mabsadd L
.23968 .30308 1.46946 -2.02254 Mabsadd L
.23968 .30308 .91448 -0.29713 Mabsadd L
.23968 .30308 2.37764 .77254 Mabsadd L
.23968 .30308 .56518 .7779 Mabsadd L
.23968 .30308 0 2.5 Mabsadd L closepath F
.24286 .3021 0 2.5 Mabsadd m
.24286 .3021 -0.56518 .7779 Mabsadd L
.24286 .3021 -2.37764 .77254 Mabsadd L
.24286 .3021 -0.91448 -0.29713 Mabsadd L
.24286 .3021 -1.46946 -2.02254 Mabsadd L
.24286 .3021 0 -0.96154 Mabsadd L
.24286 .3021 1.46946 -2.02254 Mabsadd L
.24286 .3021 .91448 -0.29713 Mabsadd L
.24286 .3021 2.37764 .77254 Mabsadd L
.24286 .3021 .56518 .7779 Mabsadd L
.24286 .3021 0 2.5 Mabsadd L closepath F
.24603 .30114 0 2.5 Mabsadd m
.24603 .30114 -0.56518 .7779 Mabsadd L
.24603 .30114 -2.37764 .77254 Mabsadd L
.24603 .30114 -0.91448 -0.29713 Mabsadd L
.24603 .30114 -1.46946 -2.02254 Mabsadd L
.24603 .30114 0 -0.96154 Mabsadd L
.24603 .30114 1.46946 -2.02254 Mabsadd L
.24603 .30114 .91448 -0.29713 Mabsadd L
.24603 .30114 2.37764 .77254 Mabsadd L
.24603 .30114 .56518 .7779 Mabsadd L
.24603 .30114 0 2.5 Mabsadd L closepath F
.24921 .30019 0 2.5 Mabsadd m
.24921 .30019 -0.56518 .7779 Mabsadd L
.24921 .30019 -2.37764 .77254 Mabsadd L
.24921 .30019 -0.91448 -0.29713 Mabsadd L
.24921 .30019 -1.46946 -2.02254 Mabsadd L
.24921 .30019 0 -0.96154 Mabsadd L
.24921 .30019 1.46946 -2.02254 Mabsadd L
.24921 .30019 .91448 -0.29713 Mabsadd L
.24921 .30019 2.37764 .77254 Mabsadd L
.24921 .30019 .56518 .7779 Mabsadd L
.24921 .30019 0 2.5 Mabsadd L closepath F
.25238 .29924 0 2.5 Mabsadd m
.25238 .29924 -0.56518 .7779 Mabsadd L
.25238 .29924 -2.37764 .77254 Mabsadd L
.25238 .29924 -0.91448 -0.29713 Mabsadd L
.25238 .29924 -1.46946 -2.02254 Mabsadd L
.25238 .29924 0 -0.96154 Mabsadd L
.25238 .29924 1.46946 -2.02254 Mabsadd L
.25238 .29924 .91448 -0.29713 Mabsadd L
.25238 .29924 2.37764 .77254 Mabsadd L
.25238 .29924 .56518 .7779 Mabsadd L
.25238 .29924 0 2.5 Mabsadd L closepath F
.25556 .2983 0 2.5 Mabsadd m
.25556 .2983 -0.56518 .7779 Mabsadd L
.25556 .2983 -2.37764 .77254 Mabsadd L
.25556 .2983 -0.91448 -0.29713 Mabsadd L
.25556 .2983 -1.46946 -2.02254 Mabsadd L
.25556 .2983 0 -0.96154 Mabsadd L
.25556 .2983 1.46946 -2.02254 Mabsadd L
.25556 .2983 .91448 -0.29713 Mabsadd L
.25556 .2983 2.37764 .77254 Mabsadd L
.25556 .2983 .56518 .7779 Mabsadd L
.25556 .2983 0 2.5 Mabsadd L closepath F
.25873 .29738 0 2.5 Mabsadd m
.25873 .29738 -0.56518 .7779 Mabsadd L
.25873 .29738 -2.37764 .77254 Mabsadd L
.25873 .29738 -0.91448 -0.29713 Mabsadd L
.25873 .29738 -1.46946 -2.02254 Mabsadd L
.25873 .29738 0 -0.96154 Mabsadd L
.25873 .29738 1.46946 -2.02254 Mabsadd L
.25873 .29738 .91448 -0.29713 Mabsadd L
.25873 .29738 2.37764 .77254 Mabsadd L
.25873 .29738 .56518 .7779 Mabsadd L
.25873 .29738 0 2.5 Mabsadd L closepath F
.2619 .29646 0 2.5 Mabsadd m
.2619 .29646 -0.56518 .7779 Mabsadd L
.2619 .29646 -2.37764 .77254 Mabsadd L
.2619 .29646 -0.91448 -0.29713 Mabsadd L
.2619 .29646 -1.46946 -2.02254 Mabsadd L
.2619 .29646 0 -0.96154 Mabsadd L
.2619 .29646 1.46946 -2.02254 Mabsadd L
.2619 .29646 .91448 -0.29713 Mabsadd L
.2619 .29646 2.37764 .77254 Mabsadd L
.2619 .29646 .56518 .7779 Mabsadd L
.2619 .29646 0 2.5 Mabsadd L closepath F
.26508 .29555 0 2.5 Mabsadd m
.26508 .29555 -0.56518 .7779 Mabsadd L
.26508 .29555 -2.37764 .77254 Mabsadd L
.26508 .29555 -0.91448 -0.29713 Mabsadd L
.26508 .29555 -1.46946 -2.02254 Mabsadd L
.26508 .29555 0 -0.96154 Mabsadd L
.26508 .29555 1.46946 -2.02254 Mabsadd L
.26508 .29555 .91448 -0.29713 Mabsadd L
.26508 .29555 2.37764 .77254 Mabsadd L
.26508 .29555 .56518 .7779 Mabsadd L
.26508 .29555 0 2.5 Mabsadd L closepath F
.26825 .29466 0 2.5 Mabsadd m
.26825 .29466 -0.56518 .7779 Mabsadd L
.26825 .29466 -2.37764 .77254 Mabsadd L
.26825 .29466 -0.91448 -0.29713 Mabsadd L
.26825 .29466 -1.46946 -2.02254 Mabsadd L
.26825 .29466 0 -0.96154 Mabsadd L
.26825 .29466 1.46946 -2.02254 Mabsadd L
.26825 .29466 .91448 -0.29713 Mabsadd L
.26825 .29466 2.37764 .77254 Mabsadd L
.26825 .29466 .56518 .7779 Mabsadd L
.26825 .29466 0 2.5 Mabsadd L closepath F
.27143 .29377 0 2.5 Mabsadd m
.27143 .29377 -0.56518 .7779 Mabsadd L
.27143 .29377 -2.37764 .77254 Mabsadd L
.27143 .29377 -0.91448 -0.29713 Mabsadd L
.27143 .29377 -1.46946 -2.02254 Mabsadd L
.27143 .29377 0 -0.96154 Mabsadd L
.27143 .29377 1.46946 -2.02254 Mabsadd L
.27143 .29377 .91448 -0.29713 Mabsadd L
.27143 .29377 2.37764 .77254 Mabsadd L
.27143 .29377 .56518 .7779 Mabsadd L
.27143 .29377 0 2.5 Mabsadd L closepath F
.2746 .29288 0 2.5 Mabsadd m
.2746 .29288 -0.56518 .7779 Mabsadd L
.2746 .29288 -2.37764 .77254 Mabsadd L
.2746 .29288 -0.91448 -0.29713 Mabsadd L
.2746 .29288 -1.46946 -2.02254 Mabsadd L
.2746 .29288 0 -0.96154 Mabsadd L
.2746 .29288 1.46946 -2.02254 Mabsadd L
.2746 .29288 .91448 -0.29713 Mabsadd L
.2746 .29288 2.37764 .77254 Mabsadd L
.2746 .29288 .56518 .7779 Mabsadd L
.2746 .29288 0 2.5 Mabsadd L closepath F
.27778 .29201 0 2.5 Mabsadd m
.27778 .29201 -0.56518 .7779 Mabsadd L
.27778 .29201 -2.37764 .77254 Mabsadd L
.27778 .29201 -0.91448 -0.29713 Mabsadd L
.27778 .29201 -1.46946 -2.02254 Mabsadd L
.27778 .29201 0 -0.96154 Mabsadd L
.27778 .29201 1.46946 -2.02254 Mabsadd L
.27778 .29201 .91448 -0.29713 Mabsadd L
.27778 .29201 2.37764 .77254 Mabsadd L
.27778 .29201 .56518 .7779 Mabsadd L
.27778 .29201 0 2.5 Mabsadd L closepath F
.28095 .29115 0 2.5 Mabsadd m
.28095 .29115 -0.56518 .7779 Mabsadd L
.28095 .29115 -2.37764 .77254 Mabsadd L
.28095 .29115 -0.91448 -0.29713 Mabsadd L
.28095 .29115 -1.46946 -2.02254 Mabsadd L
.28095 .29115 0 -0.96154 Mabsadd L
.28095 .29115 1.46946 -2.02254 Mabsadd L
.28095 .29115 .91448 -0.29713 Mabsadd L
.28095 .29115 2.37764 .77254 Mabsadd L
.28095 .29115 .56518 .7779 Mabsadd L
.28095 .29115 0 2.5 Mabsadd L closepath F
.28413 .29029 0 2.5 Mabsadd m
.28413 .29029 -0.56518 .7779 Mabsadd L
.28413 .29029 -2.37764 .77254 Mabsadd L
.28413 .29029 -0.91448 -0.29713 Mabsadd L
.28413 .29029 -1.46946 -2.02254 Mabsadd L
.28413 .29029 0 -0.96154 Mabsadd L
.28413 .29029 1.46946 -2.02254 Mabsadd L
.28413 .29029 .91448 -0.29713 Mabsadd L
.28413 .29029 2.37764 .77254 Mabsadd L
.28413 .29029 .56518 .7779 Mabsadd L
.28413 .29029 0 2.5 Mabsadd L closepath F
.2873 .28945 0 2.5 Mabsadd m
.2873 .28945 -0.56518 .7779 Mabsadd L
.2873 .28945 -2.37764 .77254 Mabsadd L
.2873 .28945 -0.91448 -0.29713 Mabsadd L
.2873 .28945 -1.46946 -2.02254 Mabsadd L
.2873 .28945 0 -0.96154 Mabsadd L
.2873 .28945 1.46946 -2.02254 Mabsadd L
.2873 .28945 .91448 -0.29713 Mabsadd L
.2873 .28945 2.37764 .77254 Mabsadd L
.2873 .28945 .56518 .7779 Mabsadd L
.2873 .28945 0 2.5 Mabsadd L closepath F
.29048 .28861 0 2.5 Mabsadd m
.29048 .28861 -0.56518 .7779 Mabsadd L
.29048 .28861 -2.37764 .77254 Mabsadd L
.29048 .28861 -0.91448 -0.29713 Mabsadd L
.29048 .28861 -1.46946 -2.02254 Mabsadd L
.29048 .28861 0 -0.96154 Mabsadd L
.29048 .28861 1.46946 -2.02254 Mabsadd L
.29048 .28861 .91448 -0.29713 Mabsadd L
.29048 .28861 2.37764 .77254 Mabsadd L
.29048 .28861 .56518 .7779 Mabsadd L
.29048 .28861 0 2.5 Mabsadd L closepath F
.29365 .28778 0 2.5 Mabsadd m
.29365 .28778 -0.56518 .7779 Mabsadd L
.29365 .28778 -2.37764 .77254 Mabsadd L
.29365 .28778 -0.91448 -0.29713 Mabsadd L
.29365 .28778 -1.46946 -2.02254 Mabsadd L
.29365 .28778 0 -0.96154 Mabsadd L
.29365 .28778 1.46946 -2.02254 Mabsadd L
.29365 .28778 .91448 -0.29713 Mabsadd L
.29365 .28778 2.37764 .77254 Mabsadd L
.29365 .28778 .56518 .7779 Mabsadd L
.29365 .28778 0 2.5 Mabsadd L closepath F
.29683 .28696 0 2.5 Mabsadd m
.29683 .28696 -0.56518 .7779 Mabsadd L
.29683 .28696 -2.37764 .77254 Mabsadd L
.29683 .28696 -0.91448 -0.29713 Mabsadd L
.29683 .28696 -1.46946 -2.02254 Mabsadd L
.29683 .28696 0 -0.96154 Mabsadd L
.29683 .28696 1.46946 -2.02254 Mabsadd L
.29683 .28696 .91448 -0.29713 Mabsadd L
.29683 .28696 2.37764 .77254 Mabsadd L
.29683 .28696 .56518 .7779 Mabsadd L
.29683 .28696 0 2.5 Mabsadd L closepath F
.3 .28615 0 2.5 Mabsadd m
.3 .28615 -0.56518 .7779 Mabsadd L
.3 .28615 -2.37764 .77254 Mabsadd L
.3 .28615 -0.91448 -0.29713 Mabsadd L
.3 .28615 -1.46946 -2.02254 Mabsadd L
.3 .28615 0 -0.96154 Mabsadd L
.3 .28615 1.46946 -2.02254 Mabsadd L
.3 .28615 .91448 -0.29713 Mabsadd L
.3 .28615 2.37764 .77254 Mabsadd L
.3 .28615 .56518 .7779 Mabsadd L
.3 .28615 0 2.5 Mabsadd L closepath F
.30317 .28534 0 2.5 Mabsadd m
.30317 .28534 -0.56518 .7779 Mabsadd L
.30317 .28534 -2.37764 .77254 Mabsadd L
.30317 .28534 -0.91448 -0.29713 Mabsadd L
.30317 .28534 -1.46946 -2.02254 Mabsadd L
.30317 .28534 0 -0.96154 Mabsadd L
.30317 .28534 1.46946 -2.02254 Mabsadd L
.30317 .28534 .91448 -0.29713 Mabsadd L
.30317 .28534 2.37764 .77254 Mabsadd L
.30317 .28534 .56518 .7779 Mabsadd L
.30317 .28534 0 2.5 Mabsadd L closepath F
.30635 .28455 0 2.5 Mabsadd m
.30635 .28455 -0.56518 .7779 Mabsadd L
.30635 .28455 -2.37764 .77254 Mabsadd L
.30635 .28455 -0.91448 -0.29713 Mabsadd L
.30635 .28455 -1.46946 -2.02254 Mabsadd L
.30635 .28455 0 -0.96154 Mabsadd L
.30635 .28455 1.46946 -2.02254 Mabsadd L
.30635 .28455 .91448 -0.29713 Mabsadd L
.30635 .28455 2.37764 .77254 Mabsadd L
.30635 .28455 .56518 .7779 Mabsadd L
.30635 .28455 0 2.5 Mabsadd L closepath F
.30952 .28376 0 2.5 Mabsadd m
.30952 .28376 -0.56518 .7779 Mabsadd L
.30952 .28376 -2.37764 .77254 Mabsadd L
.30952 .28376 -0.91448 -0.29713 Mabsadd L
.30952 .28376 -1.46946 -2.02254 Mabsadd L
.30952 .28376 0 -0.96154 Mabsadd L
.30952 .28376 1.46946 -2.02254 Mabsadd L
.30952 .28376 .91448 -0.29713 Mabsadd L
.30952 .28376 2.37764 .77254 Mabsadd L
.30952 .28376 .56518 .7779 Mabsadd L
.30952 .28376 0 2.5 Mabsadd L closepath F
.3127 .28298 0 2.5 Mabsadd m
.3127 .28298 -0.56518 .7779 Mabsadd L
.3127 .28298 -2.37764 .77254 Mabsadd L
.3127 .28298 -0.91448 -0.29713 Mabsadd L
.3127 .28298 -1.46946 -2.02254 Mabsadd L
.3127 .28298 0 -0.96154 Mabsadd L
.3127 .28298 1.46946 -2.02254 Mabsadd L
.3127 .28298 .91448 -0.29713 Mabsadd L
.3127 .28298 2.37764 .77254 Mabsadd L
.3127 .28298 .56518 .7779 Mabsadd L
.3127 .28298 0 2.5 Mabsadd L closepath F
.31587 .2822 0 2.5 Mabsadd m
.31587 .2822 -0.56518 .7779 Mabsadd L
.31587 .2822 -2.37764 .77254 Mabsadd L
.31587 .2822 -0.91448 -0.29713 Mabsadd L
.31587 .2822 -1.46946 -2.02254 Mabsadd L
.31587 .2822 0 -0.96154 Mabsadd L
.31587 .2822 1.46946 -2.02254 Mabsadd L
.31587 .2822 .91448 -0.29713 Mabsadd L
.31587 .2822 2.37764 .77254 Mabsadd L
.31587 .2822 .56518 .7779 Mabsadd L
.31587 .2822 0 2.5 Mabsadd L closepath F
.31905 .28144 0 2.5 Mabsadd m
.31905 .28144 -0.56518 .7779 Mabsadd L
.31905 .28144 -2.37764 .77254 Mabsadd L
.31905 .28144 -0.91448 -0.29713 Mabsadd L
.31905 .28144 -1.46946 -2.02254 Mabsadd L
.31905 .28144 0 -0.96154 Mabsadd L
.31905 .28144 1.46946 -2.02254 Mabsadd L
.31905 .28144 .91448 -0.29713 Mabsadd L
.31905 .28144 2.37764 .77254 Mabsadd L
.31905 .28144 .56518 .7779 Mabsadd L
.31905 .28144 0 2.5 Mabsadd L closepath F
.32222 .28068 0 2.5 Mabsadd m
.32222 .28068 -0.56518 .7779 Mabsadd L
.32222 .28068 -2.37764 .77254 Mabsadd L
.32222 .28068 -0.91448 -0.29713 Mabsadd L
.32222 .28068 -1.46946 -2.02254 Mabsadd L
.32222 .28068 0 -0.96154 Mabsadd L
.32222 .28068 1.46946 -2.02254 Mabsadd L
.32222 .28068 .91448 -0.29713 Mabsadd L
.32222 .28068 2.37764 .77254 Mabsadd L
.32222 .28068 .56518 .7779 Mabsadd L
.32222 .28068 0 2.5 Mabsadd L closepath F
.3254 .27993 0 2.5 Mabsadd m
.3254 .27993 -0.56518 .7779 Mabsadd L
.3254 .27993 -2.37764 .77254 Mabsadd L
.3254 .27993 -0.91448 -0.29713 Mabsadd L
.3254 .27993 -1.46946 -2.02254 Mabsadd L
.3254 .27993 0 -0.96154 Mabsadd L
.3254 .27993 1.46946 -2.02254 Mabsadd L
.3254 .27993 .91448 -0.29713 Mabsadd L
.3254 .27993 2.37764 .77254 Mabsadd L
.3254 .27993 .56518 .7779 Mabsadd L
.3254 .27993 0 2.5 Mabsadd L closepath F
.32857 .27919 0 2.5 Mabsadd m
.32857 .27919 -0.56518 .7779 Mabsadd L
.32857 .27919 -2.37764 .77254 Mabsadd L
.32857 .27919 -0.91448 -0.29713 Mabsadd L
.32857 .27919 -1.46946 -2.02254 Mabsadd L
.32857 .27919 0 -0.96154 Mabsadd L
.32857 .27919 1.46946 -2.02254 Mabsadd L
.32857 .27919 .91448 -0.29713 Mabsadd L
.32857 .27919 2.37764 .77254 Mabsadd L
.32857 .27919 .56518 .7779 Mabsadd L
.32857 .27919 0 2.5 Mabsadd L closepath F
.33175 .27845 0 2.5 Mabsadd m
.33175 .27845 -0.56518 .7779 Mabsadd L
.33175 .27845 -2.37764 .77254 Mabsadd L
.33175 .27845 -0.91448 -0.29713 Mabsadd L
.33175 .27845 -1.46946 -2.02254 Mabsadd L
.33175 .27845 0 -0.96154 Mabsadd L
.33175 .27845 1.46946 -2.02254 Mabsadd L
.33175 .27845 .91448 -0.29713 Mabsadd L
.33175 .27845 2.37764 .77254 Mabsadd L
.33175 .27845 .56518 .7779 Mabsadd L
.33175 .27845 0 2.5 Mabsadd L closepath F
.33492 .27773 0 2.5 Mabsadd m
.33492 .27773 -0.56518 .7779 Mabsadd L
.33492 .27773 -2.37764 .77254 Mabsadd L
.33492 .27773 -0.91448 -0.29713 Mabsadd L
.33492 .27773 -1.46946 -2.02254 Mabsadd L
.33492 .27773 0 -0.96154 Mabsadd L
.33492 .27773 1.46946 -2.02254 Mabsadd L
.33492 .27773 .91448 -0.29713 Mabsadd L
.33492 .27773 2.37764 .77254 Mabsadd L
.33492 .27773 .56518 .7779 Mabsadd L
.33492 .27773 0 2.5 Mabsadd L closepath F
.3381 .27701 0 2.5 Mabsadd m
.3381 .27701 -0.56518 .7779 Mabsadd L
.3381 .27701 -2.37764 .77254 Mabsadd L
.3381 .27701 -0.91448 -0.29713 Mabsadd L
.3381 .27701 -1.46946 -2.02254 Mabsadd L
.3381 .27701 0 -0.96154 Mabsadd L
.3381 .27701 1.46946 -2.02254 Mabsadd L
.3381 .27701 .91448 -0.29713 Mabsadd L
.3381 .27701 2.37764 .77254 Mabsadd L
.3381 .27701 .56518 .7779 Mabsadd L
.3381 .27701 0 2.5 Mabsadd L closepath F
.34127 .27629 0 2.5 Mabsadd m
.34127 .27629 -0.56518 .7779 Mabsadd L
.34127 .27629 -2.37764 .77254 Mabsadd L
.34127 .27629 -0.91448 -0.29713 Mabsadd L
.34127 .27629 -1.46946 -2.02254 Mabsadd L
.34127 .27629 0 -0.96154 Mabsadd L
.34127 .27629 1.46946 -2.02254 Mabsadd L
.34127 .27629 .91448 -0.29713 Mabsadd L
.34127 .27629 2.37764 .77254 Mabsadd L
.34127 .27629 .56518 .7779 Mabsadd L
.34127 .27629 0 2.5 Mabsadd L closepath F
.34444 .27559 0 2.5 Mabsadd m
.34444 .27559 -0.56518 .7779 Mabsadd L
.34444 .27559 -2.37764 .77254 Mabsadd L
.34444 .27559 -0.91448 -0.29713 Mabsadd L
.34444 .27559 -1.46946 -2.02254 Mabsadd L
.34444 .27559 0 -0.96154 Mabsadd L
.34444 .27559 1.46946 -2.02254 Mabsadd L
.34444 .27559 .91448 -0.29713 Mabsadd L
.34444 .27559 2.37764 .77254 Mabsadd L
.34444 .27559 .56518 .7779 Mabsadd L
.34444 .27559 0 2.5 Mabsadd L closepath F
.34762 .27489 0 2.5 Mabsadd m
.34762 .27489 -0.56518 .7779 Mabsadd L
.34762 .27489 -2.37764 .77254 Mabsadd L
.34762 .27489 -0.91448 -0.29713 Mabsadd L
.34762 .27489 -1.46946 -2.02254 Mabsadd L
.34762 .27489 0 -0.96154 Mabsadd L
.34762 .27489 1.46946 -2.02254 Mabsadd L
.34762 .27489 .91448 -0.29713 Mabsadd L
.34762 .27489 2.37764 .77254 Mabsadd L
.34762 .27489 .56518 .7779 Mabsadd L
.34762 .27489 0 2.5 Mabsadd L closepath F
.35079 .2742 0 2.5 Mabsadd m
.35079 .2742 -0.56518 .7779 Mabsadd L
.35079 .2742 -2.37764 .77254 Mabsadd L
.35079 .2742 -0.91448 -0.29713 Mabsadd L
.35079 .2742 -1.46946 -2.02254 Mabsadd L
.35079 .2742 0 -0.96154 Mabsadd L
.35079 .2742 1.46946 -2.02254 Mabsadd L
.35079 .2742 .91448 -0.29713 Mabsadd L
.35079 .2742 2.37764 .77254 Mabsadd L
.35079 .2742 .56518 .7779 Mabsadd L
.35079 .2742 0 2.5 Mabsadd L closepath F
.35397 .27351 0 2.5 Mabsadd m
.35397 .27351 -0.56518 .7779 Mabsadd L
.35397 .27351 -2.37764 .77254 Mabsadd L
.35397 .27351 -0.91448 -0.29713 Mabsadd L
.35397 .27351 -1.46946 -2.02254 Mabsadd L
.35397 .27351 0 -0.96154 Mabsadd L
.35397 .27351 1.46946 -2.02254 Mabsadd L
.35397 .27351 .91448 -0.29713 Mabsadd L
.35397 .27351 2.37764 .77254 Mabsadd L
.35397 .27351 .56518 .7779 Mabsadd L
.35397 .27351 0 2.5 Mabsadd L closepath F
.35714 .27283 0 2.5 Mabsadd m
.35714 .27283 -0.56518 .7779 Mabsadd L
.35714 .27283 -2.37764 .77254 Mabsadd L
.35714 .27283 -0.91448 -0.29713 Mabsadd L
.35714 .27283 -1.46946 -2.02254 Mabsadd L
.35714 .27283 0 -0.96154 Mabsadd L
.35714 .27283 1.46946 -2.02254 Mabsadd L
.35714 .27283 .91448 -0.29713 Mabsadd L
.35714 .27283 2.37764 .77254 Mabsadd L
.35714 .27283 .56518 .7779 Mabsadd L
.35714 .27283 0 2.5 Mabsadd L closepath F
.36032 .27216 0 2.5 Mabsadd m
.36032 .27216 -0.56518 .7779 Mabsadd L
.36032 .27216 -2.37764 .77254 Mabsadd L
.36032 .27216 -0.91448 -0.29713 Mabsadd L
.36032 .27216 -1.46946 -2.02254 Mabsadd L
.36032 .27216 0 -0.96154 Mabsadd L
.36032 .27216 1.46946 -2.02254 Mabsadd L
.36032 .27216 .91448 -0.29713 Mabsadd L
.36032 .27216 2.37764 .77254 Mabsadd L
.36032 .27216 .56518 .7779 Mabsadd L
.36032 .27216 0 2.5 Mabsadd L closepath F
.36349 .2715 0 2.5 Mabsadd m
.36349 .2715 -0.56518 .7779 Mabsadd L
.36349 .2715 -2.37764 .77254 Mabsadd L
.36349 .2715 -0.91448 -0.29713 Mabsadd L
.36349 .2715 -1.46946 -2.02254 Mabsadd L
.36349 .2715 0 -0.96154 Mabsadd L
.36349 .2715 1.46946 -2.02254 Mabsadd L
.36349 .2715 .91448 -0.29713 Mabsadd L
.36349 .2715 2.37764 .77254 Mabsadd L
.36349 .2715 .56518 .7779 Mabsadd L
.36349 .2715 0 2.5 Mabsadd L closepath F
.36667 .27084 0 2.5 Mabsadd m
.36667 .27084 -0.56518 .7779 Mabsadd L
.36667 .27084 -2.37764 .77254 Mabsadd L
.36667 .27084 -0.91448 -0.29713 Mabsadd L
.36667 .27084 -1.46946 -2.02254 Mabsadd L
.36667 .27084 0 -0.96154 Mabsadd L
.36667 .27084 1.46946 -2.02254 Mabsadd L
.36667 .27084 .91448 -0.29713 Mabsadd L
.36667 .27084 2.37764 .77254 Mabsadd L
.36667 .27084 .56518 .7779 Mabsadd L
.36667 .27084 0 2.5 Mabsadd L closepath F
.36984 .27019 0 2.5 Mabsadd m
.36984 .27019 -0.56518 .7779 Mabsadd L
.36984 .27019 -2.37764 .77254 Mabsadd L
.36984 .27019 -0.91448 -0.29713 Mabsadd L
.36984 .27019 -1.46946 -2.02254 Mabsadd L
.36984 .27019 0 -0.96154 Mabsadd L
.36984 .27019 1.46946 -2.02254 Mabsadd L
.36984 .27019 .91448 -0.29713 Mabsadd L
.36984 .27019 2.37764 .77254 Mabsadd L
.36984 .27019 .56518 .7779 Mabsadd L
.36984 .27019 0 2.5 Mabsadd L closepath F
.37302 .26954 0 2.5 Mabsadd m
.37302 .26954 -0.56518 .7779 Mabsadd L
.37302 .26954 -2.37764 .77254 Mabsadd L
.37302 .26954 -0.91448 -0.29713 Mabsadd L
.37302 .26954 -1.46946 -2.02254 Mabsadd L
.37302 .26954 0 -0.96154 Mabsadd L
.37302 .26954 1.46946 -2.02254 Mabsadd L
.37302 .26954 .91448 -0.29713 Mabsadd L
.37302 .26954 2.37764 .77254 Mabsadd L
.37302 .26954 .56518 .7779 Mabsadd L
.37302 .26954 0 2.5 Mabsadd L closepath F
.37619 .2689 0 2.5 Mabsadd m
.37619 .2689 -0.56518 .7779 Mabsadd L
.37619 .2689 -2.37764 .77254 Mabsadd L
.37619 .2689 -0.91448 -0.29713 Mabsadd L
.37619 .2689 -1.46946 -2.02254 Mabsadd L
.37619 .2689 0 -0.96154 Mabsadd L
.37619 .2689 1.46946 -2.02254 Mabsadd L
.37619 .2689 .91448 -0.29713 Mabsadd L
.37619 .2689 2.37764 .77254 Mabsadd L
.37619 .2689 .56518 .7779 Mabsadd L
.37619 .2689 0 2.5 Mabsadd L closepath F
.37937 .26827 0 2.5 Mabsadd m
.37937 .26827 -0.56518 .7779 Mabsadd L
.37937 .26827 -2.37764 .77254 Mabsadd L
.37937 .26827 -0.91448 -0.29713 Mabsadd L
.37937 .26827 -1.46946 -2.02254 Mabsadd L
.37937 .26827 0 -0.96154 Mabsadd L
.37937 .26827 1.46946 -2.02254 Mabsadd L
.37937 .26827 .91448 -0.29713 Mabsadd L
.37937 .26827 2.37764 .77254 Mabsadd L
.37937 .26827 .56518 .7779 Mabsadd L
.37937 .26827 0 2.5 Mabsadd L closepath F
.38254 .26765 0 2.5 Mabsadd m
.38254 .26765 -0.56518 .7779 Mabsadd L
.38254 .26765 -2.37764 .77254 Mabsadd L
.38254 .26765 -0.91448 -0.29713 Mabsadd L
.38254 .26765 -1.46946 -2.02254 Mabsadd L
.38254 .26765 0 -0.96154 Mabsadd L
.38254 .26765 1.46946 -2.02254 Mabsadd L
.38254 .26765 .91448 -0.29713 Mabsadd L
.38254 .26765 2.37764 .77254 Mabsadd L
.38254 .26765 .56518 .7779 Mabsadd L
.38254 .26765 0 2.5 Mabsadd L closepath F
.38571 .26703 0 2.5 Mabsadd m
.38571 .26703 -0.56518 .7779 Mabsadd L
.38571 .26703 -2.37764 .77254 Mabsadd L
.38571 .26703 -0.91448 -0.29713 Mabsadd L
.38571 .26703 -1.46946 -2.02254 Mabsadd L
.38571 .26703 0 -0.96154 Mabsadd L
.38571 .26703 1.46946 -2.02254 Mabsadd L
.38571 .26703 .91448 -0.29713 Mabsadd L
.38571 .26703 2.37764 .77254 Mabsadd L
.38571 .26703 .56518 .7779 Mabsadd L
.38571 .26703 0 2.5 Mabsadd L closepath F
.38889 .26641 0 2.5 Mabsadd m
.38889 .26641 -0.56518 .7779 Mabsadd L
.38889 .26641 -2.37764 .77254 Mabsadd L
.38889 .26641 -0.91448 -0.29713 Mabsadd L
.38889 .26641 -1.46946 -2.02254 Mabsadd L
.38889 .26641 0 -0.96154 Mabsadd L
.38889 .26641 1.46946 -2.02254 Mabsadd L
.38889 .26641 .91448 -0.29713 Mabsadd L
.38889 .26641 2.37764 .77254 Mabsadd L
.38889 .26641 .56518 .7779 Mabsadd L
.38889 .26641 0 2.5 Mabsadd L closepath F
.39206 .2658 0 2.5 Mabsadd m
.39206 .2658 -0.56518 .7779 Mabsadd L
.39206 .2658 -2.37764 .77254 Mabsadd L
.39206 .2658 -0.91448 -0.29713 Mabsadd L
.39206 .2658 -1.46946 -2.02254 Mabsadd L
.39206 .2658 0 -0.96154 Mabsadd L
.39206 .2658 1.46946 -2.02254 Mabsadd L
.39206 .2658 .91448 -0.29713 Mabsadd L
.39206 .2658 2.37764 .77254 Mabsadd L
.39206 .2658 .56518 .7779 Mabsadd L
.39206 .2658 0 2.5 Mabsadd L closepath F
.39524 .2652 0 2.5 Mabsadd m
.39524 .2652 -0.56518 .7779 Mabsadd L
.39524 .2652 -2.37764 .77254 Mabsadd L
.39524 .2652 -0.91448 -0.29713 Mabsadd L
.39524 .2652 -1.46946 -2.02254 Mabsadd L
.39524 .2652 0 -0.96154 Mabsadd L
.39524 .2652 1.46946 -2.02254 Mabsadd L
.39524 .2652 .91448 -0.29713 Mabsadd L
.39524 .2652 2.37764 .77254 Mabsadd L
.39524 .2652 .56518 .7779 Mabsadd L
.39524 .2652 0 2.5 Mabsadd L closepath F
.39841 .26461 0 2.5 Mabsadd m
.39841 .26461 -0.56518 .7779 Mabsadd L
.39841 .26461 -2.37764 .77254 Mabsadd L
.39841 .26461 -0.91448 -0.29713 Mabsadd L
.39841 .26461 -1.46946 -2.02254 Mabsadd L
.39841 .26461 0 -0.96154 Mabsadd L
.39841 .26461 1.46946 -2.02254 Mabsadd L
.39841 .26461 .91448 -0.29713 Mabsadd L
.39841 .26461 2.37764 .77254 Mabsadd L
.39841 .26461 .56518 .7779 Mabsadd L
.39841 .26461 0 2.5 Mabsadd L closepath F
.40159 .26402 0 2.5 Mabsadd m
.40159 .26402 -0.56518 .7779 Mabsadd L
.40159 .26402 -2.37764 .77254 Mabsadd L
.40159 .26402 -0.91448 -0.29713 Mabsadd L
.40159 .26402 -1.46946 -2.02254 Mabsadd L
.40159 .26402 0 -0.96154 Mabsadd L
.40159 .26402 1.46946 -2.02254 Mabsadd L
.40159 .26402 .91448 -0.29713 Mabsadd L
.40159 .26402 2.37764 .77254 Mabsadd L
.40159 .26402 .56518 .7779 Mabsadd L
.40159 .26402 0 2.5 Mabsadd L closepath F
.40476 .26344 0 2.5 Mabsadd m
.40476 .26344 -0.56518 .7779 Mabsadd L
.40476 .26344 -2.37764 .77254 Mabsadd L
.40476 .26344 -0.91448 -0.29713 Mabsadd L
.40476 .26344 -1.46946 -2.02254 Mabsadd L
.40476 .26344 0 -0.96154 Mabsadd L
.40476 .26344 1.46946 -2.02254 Mabsadd L
.40476 .26344 .91448 -0.29713 Mabsadd L
.40476 .26344 2.37764 .77254 Mabsadd L
.40476 .26344 .56518 .7779 Mabsadd L
.40476 .26344 0 2.5 Mabsadd L closepath F
.40794 .26286 0 2.5 Mabsadd m
.40794 .26286 -0.56518 .7779 Mabsadd L
.40794 .26286 -2.37764 .77254 Mabsadd L
.40794 .26286 -0.91448 -0.29713 Mabsadd L
.40794 .26286 -1.46946 -2.02254 Mabsadd L
.40794 .26286 0 -0.96154 Mabsadd L
.40794 .26286 1.46946 -2.02254 Mabsadd L
.40794 .26286 .91448 -0.29713 Mabsadd L
.40794 .26286 2.37764 .77254 Mabsadd L
.40794 .26286 .56518 .7779 Mabsadd L
.40794 .26286 0 2.5 Mabsadd L closepath F
.41111 .26229 0 2.5 Mabsadd m
.41111 .26229 -0.56518 .7779 Mabsadd L
.41111 .26229 -2.37764 .77254 Mabsadd L
.41111 .26229 -0.91448 -0.29713 Mabsadd L
.41111 .26229 -1.46946 -2.02254 Mabsadd L
.41111 .26229 0 -0.96154 Mabsadd L
.41111 .26229 1.46946 -2.02254 Mabsadd L
.41111 .26229 .91448 -0.29713 Mabsadd L
.41111 .26229 2.37764 .77254 Mabsadd L
.41111 .26229 .56518 .7779 Mabsadd L
.41111 .26229 0 2.5 Mabsadd L closepath F
.41429 .26172 0 2.5 Mabsadd m
.41429 .26172 -0.56518 .7779 Mabsadd L
.41429 .26172 -2.37764 .77254 Mabsadd L
.41429 .26172 -0.91448 -0.29713 Mabsadd L
.41429 .26172 -1.46946 -2.02254 Mabsadd L
.41429 .26172 0 -0.96154 Mabsadd L
.41429 .26172 1.46946 -2.02254 Mabsadd L
.41429 .26172 .91448 -0.29713 Mabsadd L
.41429 .26172 2.37764 .77254 Mabsadd L
.41429 .26172 .56518 .7779 Mabsadd L
.41429 .26172 0 2.5 Mabsadd L closepath F
.41746 .26116 0 2.5 Mabsadd m
.41746 .26116 -0.56518 .7779 Mabsadd L
.41746 .26116 -2.37764 .77254 Mabsadd L
.41746 .26116 -0.91448 -0.29713 Mabsadd L
.41746 .26116 -1.46946 -2.02254 Mabsadd L
.41746 .26116 0 -0.96154 Mabsadd L
.41746 .26116 1.46946 -2.02254 Mabsadd L
.41746 .26116 .91448 -0.29713 Mabsadd L
.41746 .26116 2.37764 .77254 Mabsadd L
.41746 .26116 .56518 .7779 Mabsadd L
.41746 .26116 0 2.5 Mabsadd L closepath F
.42063 .26061 0 2.5 Mabsadd m
.42063 .26061 -0.56518 .7779 Mabsadd L
.42063 .26061 -2.37764 .77254 Mabsadd L
.42063 .26061 -0.91448 -0.29713 Mabsadd L
.42063 .26061 -1.46946 -2.02254 Mabsadd L
.42063 .26061 0 -0.96154 Mabsadd L
.42063 .26061 1.46946 -2.02254 Mabsadd L
.42063 .26061 .91448 -0.29713 Mabsadd L
.42063 .26061 2.37764 .77254 Mabsadd L
.42063 .26061 .56518 .7779 Mabsadd L
.42063 .26061 0 2.5 Mabsadd L closepath F
.42381 .26006 0 2.5 Mabsadd m
.42381 .26006 -0.56518 .7779 Mabsadd L
.42381 .26006 -2.37764 .77254 Mabsadd L
.42381 .26006 -0.91448 -0.29713 Mabsadd L
.42381 .26006 -1.46946 -2.02254 Mabsadd L
.42381 .26006 0 -0.96154 Mabsadd L
.42381 .26006 1.46946 -2.02254 Mabsadd L
.42381 .26006 .91448 -0.29713 Mabsadd L
.42381 .26006 2.37764 .77254 Mabsadd L
.42381 .26006 .56518 .7779 Mabsadd L
.42381 .26006 0 2.5 Mabsadd L closepath F
.42698 .25951 0 2.5 Mabsadd m
.42698 .25951 -0.56518 .7779 Mabsadd L
.42698 .25951 -2.37764 .77254 Mabsadd L
.42698 .25951 -0.91448 -0.29713 Mabsadd L
.42698 .25951 -1.46946 -2.02254 Mabsadd L
.42698 .25951 0 -0.96154 Mabsadd L
.42698 .25951 1.46946 -2.02254 Mabsadd L
.42698 .25951 .91448 -0.29713 Mabsadd L
.42698 .25951 2.37764 .77254 Mabsadd L
.42698 .25951 .56518 .7779 Mabsadd L
.42698 .25951 0 2.5 Mabsadd L closepath F
.43016 .25897 0 2.5 Mabsadd m
.43016 .25897 -0.56518 .7779 Mabsadd L
.43016 .25897 -2.37764 .77254 Mabsadd L
.43016 .25897 -0.91448 -0.29713 Mabsadd L
.43016 .25897 -1.46946 -2.02254 Mabsadd L
.43016 .25897 0 -0.96154 Mabsadd L
.43016 .25897 1.46946 -2.02254 Mabsadd L
.43016 .25897 .91448 -0.29713 Mabsadd L
.43016 .25897 2.37764 .77254 Mabsadd L
.43016 .25897 .56518 .7779 Mabsadd L
.43016 .25897 0 2.5 Mabsadd L closepath F
.43333 .25844 0 2.5 Mabsadd m
.43333 .25844 -0.56518 .7779 Mabsadd L
.43333 .25844 -2.37764 .77254 Mabsadd L
.43333 .25844 -0.91448 -0.29713 Mabsadd L
.43333 .25844 -1.46946 -2.02254 Mabsadd L
.43333 .25844 0 -0.96154 Mabsadd L
.43333 .25844 1.46946 -2.02254 Mabsadd L
.43333 .25844 .91448 -0.29713 Mabsadd L
.43333 .25844 2.37764 .77254 Mabsadd L
.43333 .25844 .56518 .7779 Mabsadd L
.43333 .25844 0 2.5 Mabsadd L closepath F
.43651 .25791 0 2.5 Mabsadd m
.43651 .25791 -0.56518 .7779 Mabsadd L
.43651 .25791 -2.37764 .77254 Mabsadd L
.43651 .25791 -0.91448 -0.29713 Mabsadd L
.43651 .25791 -1.46946 -2.02254 Mabsadd L
.43651 .25791 0 -0.96154 Mabsadd L
.43651 .25791 1.46946 -2.02254 Mabsadd L
.43651 .25791 .91448 -0.29713 Mabsadd L
.43651 .25791 2.37764 .77254 Mabsadd L
.43651 .25791 .56518 .7779 Mabsadd L
.43651 .25791 0 2.5 Mabsadd L closepath F
.43968 .25739 0 2.5 Mabsadd m
.43968 .25739 -0.56518 .7779 Mabsadd L
.43968 .25739 -2.37764 .77254 Mabsadd L
.43968 .25739 -0.91448 -0.29713 Mabsadd L
.43968 .25739 -1.46946 -2.02254 Mabsadd L
.43968 .25739 0 -0.96154 Mabsadd L
.43968 .25739 1.46946 -2.02254 Mabsadd L
.43968 .25739 .91448 -0.29713 Mabsadd L
.43968 .25739 2.37764 .77254 Mabsadd L
.43968 .25739 .56518 .7779 Mabsadd L
.43968 .25739 0 2.5 Mabsadd L closepath F
.44286 .25687 0 2.5 Mabsadd m
.44286 .25687 -0.56518 .7779 Mabsadd L
.44286 .25687 -2.37764 .77254 Mabsadd L
.44286 .25687 -0.91448 -0.29713 Mabsadd L
.44286 .25687 -1.46946 -2.02254 Mabsadd L
.44286 .25687 0 -0.96154 Mabsadd L
.44286 .25687 1.46946 -2.02254 Mabsadd L
.44286 .25687 .91448 -0.29713 Mabsadd L
.44286 .25687 2.37764 .77254 Mabsadd L
.44286 .25687 .56518 .7779 Mabsadd L
.44286 .25687 0 2.5 Mabsadd L closepath F
.44603 .25636 0 2.5 Mabsadd m
.44603 .25636 -0.56518 .7779 Mabsadd L
.44603 .25636 -2.37764 .77254 Mabsadd L
.44603 .25636 -0.91448 -0.29713 Mabsadd L
.44603 .25636 -1.46946 -2.02254 Mabsadd L
.44603 .25636 0 -0.96154 Mabsadd L
.44603 .25636 1.46946 -2.02254 Mabsadd L
.44603 .25636 .91448 -0.29713 Mabsadd L
.44603 .25636 2.37764 .77254 Mabsadd L
.44603 .25636 .56518 .7779 Mabsadd L
.44603 .25636 0 2.5 Mabsadd L closepath F
.44921 .25586 0 2.5 Mabsadd m
.44921 .25586 -0.56518 .7779 Mabsadd L
.44921 .25586 -2.37764 .77254 Mabsadd L
.44921 .25586 -0.91448 -0.29713 Mabsadd L
.44921 .25586 -1.46946 -2.02254 Mabsadd L
.44921 .25586 0 -0.96154 Mabsadd L
.44921 .25586 1.46946 -2.02254 Mabsadd L
.44921 .25586 .91448 -0.29713 Mabsadd L
.44921 .25586 2.37764 .77254 Mabsadd L
.44921 .25586 .56518 .7779 Mabsadd L
.44921 .25586 0 2.5 Mabsadd L closepath F
.45238 .25535 0 2.5 Mabsadd m
.45238 .25535 -0.56518 .7779 Mabsadd L
.45238 .25535 -2.37764 .77254 Mabsadd L
.45238 .25535 -0.91448 -0.29713 Mabsadd L
.45238 .25535 -1.46946 -2.02254 Mabsadd L
.45238 .25535 0 -0.96154 Mabsadd L
.45238 .25535 1.46946 -2.02254 Mabsadd L
.45238 .25535 .91448 -0.29713 Mabsadd L
.45238 .25535 2.37764 .77254 Mabsadd L
.45238 .25535 .56518 .7779 Mabsadd L
.45238 .25535 0 2.5 Mabsadd L closepath F
.45556 .25486 0 2.5 Mabsadd m
.45556 .25486 -0.56518 .7779 Mabsadd L
.45556 .25486 -2.37764 .77254 Mabsadd L
.45556 .25486 -0.91448 -0.29713 Mabsadd L
.45556 .25486 -1.46946 -2.02254 Mabsadd L
.45556 .25486 0 -0.96154 Mabsadd L
.45556 .25486 1.46946 -2.02254 Mabsadd L
.45556 .25486 .91448 -0.29713 Mabsadd L
.45556 .25486 2.37764 .77254 Mabsadd L
.45556 .25486 .56518 .7779 Mabsadd L
.45556 .25486 0 2.5 Mabsadd L closepath F
.45873 .25437 0 2.5 Mabsadd m
.45873 .25437 -0.56518 .7779 Mabsadd L
.45873 .25437 -2.37764 .77254 Mabsadd L
.45873 .25437 -0.91448 -0.29713 Mabsadd L
.45873 .25437 -1.46946 -2.02254 Mabsadd L
.45873 .25437 0 -0.96154 Mabsadd L
.45873 .25437 1.46946 -2.02254 Mabsadd L
.45873 .25437 .91448 -0.29713 Mabsadd L
.45873 .25437 2.37764 .77254 Mabsadd L
.45873 .25437 .56518 .7779 Mabsadd L
.45873 .25437 0 2.5 Mabsadd L closepath F
.4619 .25388 0 2.5 Mabsadd m
.4619 .25388 -0.56518 .7779 Mabsadd L
.4619 .25388 -2.37764 .77254 Mabsadd L
.4619 .25388 -0.91448 -0.29713 Mabsadd L
.4619 .25388 -1.46946 -2.02254 Mabsadd L
.4619 .25388 0 -0.96154 Mabsadd L
.4619 .25388 1.46946 -2.02254 Mabsadd L
.4619 .25388 .91448 -0.29713 Mabsadd L
.4619 .25388 2.37764 .77254 Mabsadd L
.4619 .25388 .56518 .7779 Mabsadd L
.4619 .25388 0 2.5 Mabsadd L closepath F
.46508 .2534 0 2.5 Mabsadd m
.46508 .2534 -0.56518 .7779 Mabsadd L
.46508 .2534 -2.37764 .77254 Mabsadd L
.46508 .2534 -0.91448 -0.29713 Mabsadd L
.46508 .2534 -1.46946 -2.02254 Mabsadd L
.46508 .2534 0 -0.96154 Mabsadd L
.46508 .2534 1.46946 -2.02254 Mabsadd L
.46508 .2534 .91448 -0.29713 Mabsadd L
.46508 .2534 2.37764 .77254 Mabsadd L
.46508 .2534 .56518 .7779 Mabsadd L
.46508 .2534 0 2.5 Mabsadd L closepath F
.46825 .25292 0 2.5 Mabsadd m
.46825 .25292 -0.56518 .7779 Mabsadd L
.46825 .25292 -2.37764 .77254 Mabsadd L
.46825 .25292 -0.91448 -0.29713 Mabsadd L
.46825 .25292 -1.46946 -2.02254 Mabsadd L
.46825 .25292 0 -0.96154 Mabsadd L
.46825 .25292 1.46946 -2.02254 Mabsadd L
.46825 .25292 .91448 -0.29713 Mabsadd L
.46825 .25292 2.37764 .77254 Mabsadd L
.46825 .25292 .56518 .7779 Mabsadd L
.46825 .25292 0 2.5 Mabsadd L closepath F
.47143 .25245 0 2.5 Mabsadd m
.47143 .25245 -0.56518 .7779 Mabsadd L
.47143 .25245 -2.37764 .77254 Mabsadd L
.47143 .25245 -0.91448 -0.29713 Mabsadd L
.47143 .25245 -1.46946 -2.02254 Mabsadd L
.47143 .25245 0 -0.96154 Mabsadd L
.47143 .25245 1.46946 -2.02254 Mabsadd L
.47143 .25245 .91448 -0.29713 Mabsadd L
.47143 .25245 2.37764 .77254 Mabsadd L
.47143 .25245 .56518 .7779 Mabsadd L
.47143 .25245 0 2.5 Mabsadd L closepath F
.4746 .25198 0 2.5 Mabsadd m
.4746 .25198 -0.56518 .7779 Mabsadd L
.4746 .25198 -2.37764 .77254 Mabsadd L
.4746 .25198 -0.91448 -0.29713 Mabsadd L
.4746 .25198 -1.46946 -2.02254 Mabsadd L
.4746 .25198 0 -0.96154 Mabsadd L
.4746 .25198 1.46946 -2.02254 Mabsadd L
.4746 .25198 .91448 -0.29713 Mabsadd L
.4746 .25198 2.37764 .77254 Mabsadd L
.4746 .25198 .56518 .7779 Mabsadd L
.4746 .25198 0 2.5 Mabsadd L closepath F
.47778 .25152 0 2.5 Mabsadd m
.47778 .25152 -0.56518 .7779 Mabsadd L
.47778 .25152 -2.37764 .77254 Mabsadd L
.47778 .25152 -0.91448 -0.29713 Mabsadd L
.47778 .25152 -1.46946 -2.02254 Mabsadd L
.47778 .25152 0 -0.96154 Mabsadd L
.47778 .25152 1.46946 -2.02254 Mabsadd L
.47778 .25152 .91448 -0.29713 Mabsadd L
.47778 .25152 2.37764 .77254 Mabsadd L
.47778 .25152 .56518 .7779 Mabsadd L
.47778 .25152 0 2.5 Mabsadd L closepath F
.48095 .25106 0 2.5 Mabsadd m
.48095 .25106 -0.56518 .7779 Mabsadd L
.48095 .25106 -2.37764 .77254 Mabsadd L
.48095 .25106 -0.91448 -0.29713 Mabsadd L
.48095 .25106 -1.46946 -2.02254 Mabsadd L
.48095 .25106 0 -0.96154 Mabsadd L
.48095 .25106 1.46946 -2.02254 Mabsadd L
.48095 .25106 .91448 -0.29713 Mabsadd L
.48095 .25106 2.37764 .77254 Mabsadd L
.48095 .25106 .56518 .7779 Mabsadd L
.48095 .25106 0 2.5 Mabsadd L closepath F
.48413 .2506 0 2.5 Mabsadd m
.48413 .2506 -0.56518 .7779 Mabsadd L
.48413 .2506 -2.37764 .77254 Mabsadd L
.48413 .2506 -0.91448 -0.29713 Mabsadd L
.48413 .2506 -1.46946 -2.02254 Mabsadd L
.48413 .2506 0 -0.96154 Mabsadd L
.48413 .2506 1.46946 -2.02254 Mabsadd L
.48413 .2506 .91448 -0.29713 Mabsadd L
.48413 .2506 2.37764 .77254 Mabsadd L
.48413 .2506 .56518 .7779 Mabsadd L
.48413 .2506 0 2.5 Mabsadd L closepath F
.4873 .25016 0 2.5 Mabsadd m
.4873 .25016 -0.56518 .7779 Mabsadd L
.4873 .25016 -2.37764 .77254 Mabsadd L
.4873 .25016 -0.91448 -0.29713 Mabsadd L
.4873 .25016 -1.46946 -2.02254 Mabsadd L
.4873 .25016 0 -0.96154 Mabsadd L
.4873 .25016 1.46946 -2.02254 Mabsadd L
.4873 .25016 .91448 -0.29713 Mabsadd L
.4873 .25016 2.37764 .77254 Mabsadd L
.4873 .25016 .56518 .7779 Mabsadd L
.4873 .25016 0 2.5 Mabsadd L closepath F
.49048 .24971 0 2.5 Mabsadd m
.49048 .24971 -0.56518 .7779 Mabsadd L
.49048 .24971 -2.37764 .77254 Mabsadd L
.49048 .24971 -0.91448 -0.29713 Mabsadd L
.49048 .24971 -1.46946 -2.02254 Mabsadd L
.49048 .24971 0 -0.96154 Mabsadd L
.49048 .24971 1.46946 -2.02254 Mabsadd L
.49048 .24971 .91448 -0.29713 Mabsadd L
.49048 .24971 2.37764 .77254 Mabsadd L
.49048 .24971 .56518 .7779 Mabsadd L
.49048 .24971 0 2.5 Mabsadd L closepath F
.49365 .24927 0 2.5 Mabsadd m
.49365 .24927 -0.56518 .7779 Mabsadd L
.49365 .24927 -2.37764 .77254 Mabsadd L
.49365 .24927 -0.91448 -0.29713 Mabsadd L
.49365 .24927 -1.46946 -2.02254 Mabsadd L
.49365 .24927 0 -0.96154 Mabsadd L
.49365 .24927 1.46946 -2.02254 Mabsadd L
.49365 .24927 .91448 -0.29713 Mabsadd L
.49365 .24927 2.37764 .77254 Mabsadd L
.49365 .24927 .56518 .7779 Mabsadd L
.49365 .24927 0 2.5 Mabsadd L closepath F
.49683 .24883 0 2.5 Mabsadd m
.49683 .24883 -0.56518 .7779 Mabsadd L
.49683 .24883 -2.37764 .77254 Mabsadd L
.49683 .24883 -0.91448 -0.29713 Mabsadd L
.49683 .24883 -1.46946 -2.02254 Mabsadd L
.49683 .24883 0 -0.96154 Mabsadd L
.49683 .24883 1.46946 -2.02254 Mabsadd L
.49683 .24883 .91448 -0.29713 Mabsadd L
.49683 .24883 2.37764 .77254 Mabsadd L
.49683 .24883 .56518 .7779 Mabsadd L
.49683 .24883 0 2.5 Mabsadd L closepath F
.5 .2484 0 2.5 Mabsadd m
.5 .2484 -0.56518 .7779 Mabsadd L
.5 .2484 -2.37764 .77254 Mabsadd L
.5 .2484 -0.91448 -0.29713 Mabsadd L
.5 .2484 -1.46946 -2.02254 Mabsadd L
.5 .2484 0 -0.96154 Mabsadd L
.5 .2484 1.46946 -2.02254 Mabsadd L
.5 .2484 .91448 -0.29713 Mabsadd L
.5 .2484 2.37764 .77254 Mabsadd L
.5 .2484 .56518 .7779 Mabsadd L
.5 .2484 0 2.5 Mabsadd L closepath F
.50317 .24798 0 2.5 Mabsadd m
.50317 .24798 -0.56518 .7779 Mabsadd L
.50317 .24798 -2.37764 .77254 Mabsadd L
.50317 .24798 -0.91448 -0.29713 Mabsadd L
.50317 .24798 -1.46946 -2.02254 Mabsadd L
.50317 .24798 0 -0.96154 Mabsadd L
.50317 .24798 1.46946 -2.02254 Mabsadd L
.50317 .24798 .91448 -0.29713 Mabsadd L
.50317 .24798 2.37764 .77254 Mabsadd L
.50317 .24798 .56518 .7779 Mabsadd L
.50317 .24798 0 2.5 Mabsadd L closepath F
.50635 .24755 0 2.5 Mabsadd m
.50635 .24755 -0.56518 .7779 Mabsadd L
.50635 .24755 -2.37764 .77254 Mabsadd L
.50635 .24755 -0.91448 -0.29713 Mabsadd L
.50635 .24755 -1.46946 -2.02254 Mabsadd L
.50635 .24755 0 -0.96154 Mabsadd L
.50635 .24755 1.46946 -2.02254 Mabsadd L
.50635 .24755 .91448 -0.29713 Mabsadd L
.50635 .24755 2.37764 .77254 Mabsadd L
.50635 .24755 .56518 .7779 Mabsadd L
.50635 .24755 0 2.5 Mabsadd L closepath F
.50952 .24713 0 2.5 Mabsadd m
.50952 .24713 -0.56518 .7779 Mabsadd L
.50952 .24713 -2.37764 .77254 Mabsadd L
.50952 .24713 -0.91448 -0.29713 Mabsadd L
.50952 .24713 -1.46946 -2.02254 Mabsadd L
.50952 .24713 0 -0.96154 Mabsadd L
.50952 .24713 1.46946 -2.02254 Mabsadd L
.50952 .24713 .91448 -0.29713 Mabsadd L
.50952 .24713 2.37764 .77254 Mabsadd L
.50952 .24713 .56518 .7779 Mabsadd L
.50952 .24713 0 2.5 Mabsadd L closepath F
.5127 .24672 0 2.5 Mabsadd m
.5127 .24672 -0.56518 .7779 Mabsadd L
.5127 .24672 -2.37764 .77254 Mabsadd L
.5127 .24672 -0.91448 -0.29713 Mabsadd L
.5127 .24672 -1.46946 -2.02254 Mabsadd L
.5127 .24672 0 -0.96154 Mabsadd L
.5127 .24672 1.46946 -2.02254 Mabsadd L
.5127 .24672 .91448 -0.29713 Mabsadd L
.5127 .24672 2.37764 .77254 Mabsadd L
.5127 .24672 .56518 .7779 Mabsadd L
.5127 .24672 0 2.5 Mabsadd L closepath F
.51587 .24631 0 2.5 Mabsadd m
.51587 .24631 -0.56518 .7779 Mabsadd L
.51587 .24631 -2.37764 .77254 Mabsadd L
.51587 .24631 -0.91448 -0.29713 Mabsadd L
.51587 .24631 -1.46946 -2.02254 Mabsadd L
.51587 .24631 0 -0.96154 Mabsadd L
.51587 .24631 1.46946 -2.02254 Mabsadd L
.51587 .24631 .91448 -0.29713 Mabsadd L
.51587 .24631 2.37764 .77254 Mabsadd L
.51587 .24631 .56518 .7779 Mabsadd L
.51587 .24631 0 2.5 Mabsadd L closepath F
.51905 .2459 0 2.5 Mabsadd m
.51905 .2459 -0.56518 .7779 Mabsadd L
.51905 .2459 -2.37764 .77254 Mabsadd L
.51905 .2459 -0.91448 -0.29713 Mabsadd L
.51905 .2459 -1.46946 -2.02254 Mabsadd L
.51905 .2459 0 -0.96154 Mabsadd L
.51905 .2459 1.46946 -2.02254 Mabsadd L
.51905 .2459 .91448 -0.29713 Mabsadd L
.51905 .2459 2.37764 .77254 Mabsadd L
.51905 .2459 .56518 .7779 Mabsadd L
.51905 .2459 0 2.5 Mabsadd L closepath F
.52222 .2455 0 2.5 Mabsadd m
.52222 .2455 -0.56518 .7779 Mabsadd L
.52222 .2455 -2.37764 .77254 Mabsadd L
.52222 .2455 -0.91448 -0.29713 Mabsadd L
.52222 .2455 -1.46946 -2.02254 Mabsadd L
.52222 .2455 0 -0.96154 Mabsadd L
.52222 .2455 1.46946 -2.02254 Mabsadd L
.52222 .2455 .91448 -0.29713 Mabsadd L
.52222 .2455 2.37764 .77254 Mabsadd L
.52222 .2455 .56518 .7779 Mabsadd L
.52222 .2455 0 2.5 Mabsadd L closepath F
.5254 .2451 0 2.5 Mabsadd m
.5254 .2451 -0.56518 .7779 Mabsadd L
.5254 .2451 -2.37764 .77254 Mabsadd L
.5254 .2451 -0.91448 -0.29713 Mabsadd L
.5254 .2451 -1.46946 -2.02254 Mabsadd L
.5254 .2451 0 -0.96154 Mabsadd L
.5254 .2451 1.46946 -2.02254 Mabsadd L
.5254 .2451 .91448 -0.29713 Mabsadd L
.5254 .2451 2.37764 .77254 Mabsadd L
.5254 .2451 .56518 .7779 Mabsadd L
.5254 .2451 0 2.5 Mabsadd L closepath F
.52857 .24471 0 2.5 Mabsadd m
.52857 .24471 -0.56518 .7779 Mabsadd L
.52857 .24471 -2.37764 .77254 Mabsadd L
.52857 .24471 -0.91448 -0.29713 Mabsadd L
.52857 .24471 -1.46946 -2.02254 Mabsadd L
.52857 .24471 0 -0.96154 Mabsadd L
.52857 .24471 1.46946 -2.02254 Mabsadd L
.52857 .24471 .91448 -0.29713 Mabsadd L
.52857 .24471 2.37764 .77254 Mabsadd L
.52857 .24471 .56518 .7779 Mabsadd L
.52857 .24471 0 2.5 Mabsadd L closepath F
.53175 .24432 0 2.5 Mabsadd m
.53175 .24432 -0.56518 .7779 Mabsadd L
.53175 .24432 -2.37764 .77254 Mabsadd L
.53175 .24432 -0.91448 -0.29713 Mabsadd L
.53175 .24432 -1.46946 -2.02254 Mabsadd L
.53175 .24432 0 -0.96154 Mabsadd L
.53175 .24432 1.46946 -2.02254 Mabsadd L
.53175 .24432 .91448 -0.29713 Mabsadd L
.53175 .24432 2.37764 .77254 Mabsadd L
.53175 .24432 .56518 .7779 Mabsadd L
.53175 .24432 0 2.5 Mabsadd L closepath F
.53492 .24393 0 2.5 Mabsadd m
.53492 .24393 -0.56518 .7779 Mabsadd L
.53492 .24393 -2.37764 .77254 Mabsadd L
.53492 .24393 -0.91448 -0.29713 Mabsadd L
.53492 .24393 -1.46946 -2.02254 Mabsadd L
.53492 .24393 0 -0.96154 Mabsadd L
.53492 .24393 1.46946 -2.02254 Mabsadd L
.53492 .24393 .91448 -0.29713 Mabsadd L
.53492 .24393 2.37764 .77254 Mabsadd L
.53492 .24393 .56518 .7779 Mabsadd L
.53492 .24393 0 2.5 Mabsadd L closepath F
.5381 .24355 0 2.5 Mabsadd m
.5381 .24355 -0.56518 .7779 Mabsadd L
.5381 .24355 -2.37764 .77254 Mabsadd L
.5381 .24355 -0.91448 -0.29713 Mabsadd L
.5381 .24355 -1.46946 -2.02254 Mabsadd L
.5381 .24355 0 -0.96154 Mabsadd L
.5381 .24355 1.46946 -2.02254 Mabsadd L
.5381 .24355 .91448 -0.29713 Mabsadd L
.5381 .24355 2.37764 .77254 Mabsadd L
.5381 .24355 .56518 .7779 Mabsadd L
.5381 .24355 0 2.5 Mabsadd L closepath F
.54127 .24317 0 2.5 Mabsadd m
.54127 .24317 -0.56518 .7779 Mabsadd L
.54127 .24317 -2.37764 .77254 Mabsadd L
.54127 .24317 -0.91448 -0.29713 Mabsadd L
.54127 .24317 -1.46946 -2.02254 Mabsadd L
.54127 .24317 0 -0.96154 Mabsadd L
.54127 .24317 1.46946 -2.02254 Mabsadd L
.54127 .24317 .91448 -0.29713 Mabsadd L
.54127 .24317 2.37764 .77254 Mabsadd L
.54127 .24317 .56518 .7779 Mabsadd L
.54127 .24317 0 2.5 Mabsadd L closepath F
.54444 .2428 0 2.5 Mabsadd m
.54444 .2428 -0.56518 .7779 Mabsadd L
.54444 .2428 -2.37764 .77254 Mabsadd L
.54444 .2428 -0.91448 -0.29713 Mabsadd L
.54444 .2428 -1.46946 -2.02254 Mabsadd L
.54444 .2428 0 -0.96154 Mabsadd L
.54444 .2428 1.46946 -2.02254 Mabsadd L
.54444 .2428 .91448 -0.29713 Mabsadd L
.54444 .2428 2.37764 .77254 Mabsadd L
.54444 .2428 .56518 .7779 Mabsadd L
.54444 .2428 0 2.5 Mabsadd L closepath F
.54762 .24243 0 2.5 Mabsadd m
.54762 .24243 -0.56518 .7779 Mabsadd L
.54762 .24243 -2.37764 .77254 Mabsadd L
.54762 .24243 -0.91448 -0.29713 Mabsadd L
.54762 .24243 -1.46946 -2.02254 Mabsadd L
.54762 .24243 0 -0.96154 Mabsadd L
.54762 .24243 1.46946 -2.02254 Mabsadd L
.54762 .24243 .91448 -0.29713 Mabsadd L
.54762 .24243 2.37764 .77254 Mabsadd L
.54762 .24243 .56518 .7779 Mabsadd L
.54762 .24243 0 2.5 Mabsadd L closepath F
.55079 .24206 0 2.5 Mabsadd m
.55079 .24206 -0.56518 .7779 Mabsadd L
.55079 .24206 -2.37764 .77254 Mabsadd L
.55079 .24206 -0.91448 -0.29713 Mabsadd L
.55079 .24206 -1.46946 -2.02254 Mabsadd L
.55079 .24206 0 -0.96154 Mabsadd L
.55079 .24206 1.46946 -2.02254 Mabsadd L
.55079 .24206 .91448 -0.29713 Mabsadd L
.55079 .24206 2.37764 .77254 Mabsadd L
.55079 .24206 .56518 .7779 Mabsadd L
.55079 .24206 0 2.5 Mabsadd L closepath F
.55397 .24169 0 2.5 Mabsadd m
.55397 .24169 -0.56518 .7779 Mabsadd L
.55397 .24169 -2.37764 .77254 Mabsadd L
.55397 .24169 -0.91448 -0.29713 Mabsadd L
.55397 .24169 -1.46946 -2.02254 Mabsadd L
.55397 .24169 0 -0.96154 Mabsadd L
.55397 .24169 1.46946 -2.02254 Mabsadd L
.55397 .24169 .91448 -0.29713 Mabsadd L
.55397 .24169 2.37764 .77254 Mabsadd L
.55397 .24169 .56518 .7779 Mabsadd L
.55397 .24169 0 2.5 Mabsadd L closepath F
.55714 .24133 0 2.5 Mabsadd m
.55714 .24133 -0.56518 .7779 Mabsadd L
.55714 .24133 -2.37764 .77254 Mabsadd L
.55714 .24133 -0.91448 -0.29713 Mabsadd L
.55714 .24133 -1.46946 -2.02254 Mabsadd L
.55714 .24133 0 -0.96154 Mabsadd L
.55714 .24133 1.46946 -2.02254 Mabsadd L
.55714 .24133 .91448 -0.29713 Mabsadd L
.55714 .24133 2.37764 .77254 Mabsadd L
.55714 .24133 .56518 .7779 Mabsadd L
.55714 .24133 0 2.5 Mabsadd L closepath F
.56032 .24098 0 2.5 Mabsadd m
.56032 .24098 -0.56518 .7779 Mabsadd L
.56032 .24098 -2.37764 .77254 Mabsadd L
.56032 .24098 -0.91448 -0.29713 Mabsadd L
.56032 .24098 -1.46946 -2.02254 Mabsadd L
.56032 .24098 0 -0.96154 Mabsadd L
.56032 .24098 1.46946 -2.02254 Mabsadd L
.56032 .24098 .91448 -0.29713 Mabsadd L
.56032 .24098 2.37764 .77254 Mabsadd L
.56032 .24098 .56518 .7779 Mabsadd L
.56032 .24098 0 2.5 Mabsadd L closepath F
.56349 .24062 0 2.5 Mabsadd m
.56349 .24062 -0.56518 .7779 Mabsadd L
.56349 .24062 -2.37764 .77254 Mabsadd L
.56349 .24062 -0.91448 -0.29713 Mabsadd L
.56349 .24062 -1.46946 -2.02254 Mabsadd L
.56349 .24062 0 -0.96154 Mabsadd L
.56349 .24062 1.46946 -2.02254 Mabsadd L
.56349 .24062 .91448 -0.29713 Mabsadd L
.56349 .24062 2.37764 .77254 Mabsadd L
.56349 .24062 .56518 .7779 Mabsadd L
.56349 .24062 0 2.5 Mabsadd L closepath F
.56667 .24028 0 2.5 Mabsadd m
.56667 .24028 -0.56518 .7779 Mabsadd L
.56667 .24028 -2.37764 .77254 Mabsadd L
.56667 .24028 -0.91448 -0.29713 Mabsadd L
.56667 .24028 -1.46946 -2.02254 Mabsadd L
.56667 .24028 0 -0.96154 Mabsadd L
.56667 .24028 1.46946 -2.02254 Mabsadd L
.56667 .24028 .91448 -0.29713 Mabsadd L
.56667 .24028 2.37764 .77254 Mabsadd L
.56667 .24028 .56518 .7779 Mabsadd L
.56667 .24028 0 2.5 Mabsadd L closepath F
.56984 .23993 0 2.5 Mabsadd m
.56984 .23993 -0.56518 .7779 Mabsadd L
.56984 .23993 -2.37764 .77254 Mabsadd L
.56984 .23993 -0.91448 -0.29713 Mabsadd L
.56984 .23993 -1.46946 -2.02254 Mabsadd L
.56984 .23993 0 -0.96154 Mabsadd L
.56984 .23993 1.46946 -2.02254 Mabsadd L
.56984 .23993 .91448 -0.29713 Mabsadd L
.56984 .23993 2.37764 .77254 Mabsadd L
.56984 .23993 .56518 .7779 Mabsadd L
.56984 .23993 0 2.5 Mabsadd L closepath F
.57302 .23959 0 2.5 Mabsadd m
.57302 .23959 -0.56518 .7779 Mabsadd L
.57302 .23959 -2.37764 .77254 Mabsadd L
.57302 .23959 -0.91448 -0.29713 Mabsadd L
.57302 .23959 -1.46946 -2.02254 Mabsadd L
.57302 .23959 0 -0.96154 Mabsadd L
.57302 .23959 1.46946 -2.02254 Mabsadd L
.57302 .23959 .91448 -0.29713 Mabsadd L
.57302 .23959 2.37764 .77254 Mabsadd L
.57302 .23959 .56518 .7779 Mabsadd L
.57302 .23959 0 2.5 Mabsadd L closepath F
.57619 .23925 0 2.5 Mabsadd m
.57619 .23925 -0.56518 .7779 Mabsadd L
.57619 .23925 -2.37764 .77254 Mabsadd L
.57619 .23925 -0.91448 -0.29713 Mabsadd L
.57619 .23925 -1.46946 -2.02254 Mabsadd L
.57619 .23925 0 -0.96154 Mabsadd L
.57619 .23925 1.46946 -2.02254 Mabsadd L
.57619 .23925 .91448 -0.29713 Mabsadd L
.57619 .23925 2.37764 .77254 Mabsadd L
.57619 .23925 .56518 .7779 Mabsadd L
.57619 .23925 0 2.5 Mabsadd L closepath F
.57937 .23891 0 2.5 Mabsadd m
.57937 .23891 -0.56518 .7779 Mabsadd L
.57937 .23891 -2.37764 .77254 Mabsadd L
.57937 .23891 -0.91448 -0.29713 Mabsadd L
.57937 .23891 -1.46946 -2.02254 Mabsadd L
.57937 .23891 0 -0.96154 Mabsadd L
.57937 .23891 1.46946 -2.02254 Mabsadd L
.57937 .23891 .91448 -0.29713 Mabsadd L
.57937 .23891 2.37764 .77254 Mabsadd L
.57937 .23891 .56518 .7779 Mabsadd L
.57937 .23891 0 2.5 Mabsadd L closepath F
.58254 .23858 0 2.5 Mabsadd m
.58254 .23858 -0.56518 .7779 Mabsadd L
.58254 .23858 -2.37764 .77254 Mabsadd L
.58254 .23858 -0.91448 -0.29713 Mabsadd L
.58254 .23858 -1.46946 -2.02254 Mabsadd L
.58254 .23858 0 -0.96154 Mabsadd L
.58254 .23858 1.46946 -2.02254 Mabsadd L
.58254 .23858 .91448 -0.29713 Mabsadd L
.58254 .23858 2.37764 .77254 Mabsadd L
.58254 .23858 .56518 .7779 Mabsadd L
.58254 .23858 0 2.5 Mabsadd L closepath F
.58571 .23825 0 2.5 Mabsadd m
.58571 .23825 -0.56518 .7779 Mabsadd L
.58571 .23825 -2.37764 .77254 Mabsadd L
.58571 .23825 -0.91448 -0.29713 Mabsadd L
.58571 .23825 -1.46946 -2.02254 Mabsadd L
.58571 .23825 0 -0.96154 Mabsadd L
.58571 .23825 1.46946 -2.02254 Mabsadd L
.58571 .23825 .91448 -0.29713 Mabsadd L
.58571 .23825 2.37764 .77254 Mabsadd L
.58571 .23825 .56518 .7779 Mabsadd L
.58571 .23825 0 2.5 Mabsadd L closepath F
.58889 .23793 0 2.5 Mabsadd m
.58889 .23793 -0.56518 .7779 Mabsadd L
.58889 .23793 -2.37764 .77254 Mabsadd L
.58889 .23793 -0.91448 -0.29713 Mabsadd L
.58889 .23793 -1.46946 -2.02254 Mabsadd L
.58889 .23793 0 -0.96154 Mabsadd L
.58889 .23793 1.46946 -2.02254 Mabsadd L
.58889 .23793 .91448 -0.29713 Mabsadd L
.58889 .23793 2.37764 .77254 Mabsadd L
.58889 .23793 .56518 .7779 Mabsadd L
.58889 .23793 0 2.5 Mabsadd L closepath F
.59206 .2376 0 2.5 Mabsadd m
.59206 .2376 -0.56518 .7779 Mabsadd L
.59206 .2376 -2.37764 .77254 Mabsadd L
.59206 .2376 -0.91448 -0.29713 Mabsadd L
.59206 .2376 -1.46946 -2.02254 Mabsadd L
.59206 .2376 0 -0.96154 Mabsadd L
.59206 .2376 1.46946 -2.02254 Mabsadd L
.59206 .2376 .91448 -0.29713 Mabsadd L
.59206 .2376 2.37764 .77254 Mabsadd L
.59206 .2376 .56518 .7779 Mabsadd L
.59206 .2376 0 2.5 Mabsadd L closepath F
.59524 .23728 0 2.5 Mabsadd m
.59524 .23728 -0.56518 .7779 Mabsadd L
.59524 .23728 -2.37764 .77254 Mabsadd L
.59524 .23728 -0.91448 -0.29713 Mabsadd L
.59524 .23728 -1.46946 -2.02254 Mabsadd L
.59524 .23728 0 -0.96154 Mabsadd L
.59524 .23728 1.46946 -2.02254 Mabsadd L
.59524 .23728 .91448 -0.29713 Mabsadd L
.59524 .23728 2.37764 .77254 Mabsadd L
.59524 .23728 .56518 .7779 Mabsadd L
.59524 .23728 0 2.5 Mabsadd L closepath F
.59841 .23697 0 2.5 Mabsadd m
.59841 .23697 -0.56518 .7779 Mabsadd L
.59841 .23697 -2.37764 .77254 Mabsadd L
.59841 .23697 -0.91448 -0.29713 Mabsadd L
.59841 .23697 -1.46946 -2.02254 Mabsadd L
.59841 .23697 0 -0.96154 Mabsadd L
.59841 .23697 1.46946 -2.02254 Mabsadd L
.59841 .23697 .91448 -0.29713 Mabsadd L
.59841 .23697 2.37764 .77254 Mabsadd L
.59841 .23697 .56518 .7779 Mabsadd L
.59841 .23697 0 2.5 Mabsadd L closepath F
.60159 .23666 0 2.5 Mabsadd m
.60159 .23666 -0.56518 .7779 Mabsadd L
.60159 .23666 -2.37764 .77254 Mabsadd L
.60159 .23666 -0.91448 -0.29713 Mabsadd L
.60159 .23666 -1.46946 -2.02254 Mabsadd L
.60159 .23666 0 -0.96154 Mabsadd L
.60159 .23666 1.46946 -2.02254 Mabsadd L
.60159 .23666 .91448 -0.29713 Mabsadd L
.60159 .23666 2.37764 .77254 Mabsadd L
.60159 .23666 .56518 .7779 Mabsadd L
.60159 .23666 0 2.5 Mabsadd L closepath F
.60476 .23635 0 2.5 Mabsadd m
.60476 .23635 -0.56518 .7779 Mabsadd L
.60476 .23635 -2.37764 .77254 Mabsadd L
.60476 .23635 -0.91448 -0.29713 Mabsadd L
.60476 .23635 -1.46946 -2.02254 Mabsadd L
.60476 .23635 0 -0.96154 Mabsadd L
.60476 .23635 1.46946 -2.02254 Mabsadd L
.60476 .23635 .91448 -0.29713 Mabsadd L
.60476 .23635 2.37764 .77254 Mabsadd L
.60476 .23635 .56518 .7779 Mabsadd L
.60476 .23635 0 2.5 Mabsadd L closepath F
.60794 .23604 0 2.5 Mabsadd m
.60794 .23604 -0.56518 .7779 Mabsadd L
.60794 .23604 -2.37764 .77254 Mabsadd L
.60794 .23604 -0.91448 -0.29713 Mabsadd L
.60794 .23604 -1.46946 -2.02254 Mabsadd L
.60794 .23604 0 -0.96154 Mabsadd L
.60794 .23604 1.46946 -2.02254 Mabsadd L
.60794 .23604 .91448 -0.29713 Mabsadd L
.60794 .23604 2.37764 .77254 Mabsadd L
.60794 .23604 .56518 .7779 Mabsadd L
.60794 .23604 0 2.5 Mabsadd L closepath F
.61111 .23574 0 2.5 Mabsadd m
.61111 .23574 -0.56518 .7779 Mabsadd L
.61111 .23574 -2.37764 .77254 Mabsadd L
.61111 .23574 -0.91448 -0.29713 Mabsadd L
.61111 .23574 -1.46946 -2.02254 Mabsadd L
.61111 .23574 0 -0.96154 Mabsadd L
.61111 .23574 1.46946 -2.02254 Mabsadd L
.61111 .23574 .91448 -0.29713 Mabsadd L
.61111 .23574 2.37764 .77254 Mabsadd L
.61111 .23574 .56518 .7779 Mabsadd L
.61111 .23574 0 2.5 Mabsadd L closepath F
.61429 .23543 0 2.5 Mabsadd m
.61429 .23543 -0.56518 .7779 Mabsadd L
.61429 .23543 -2.37764 .77254 Mabsadd L
.61429 .23543 -0.91448 -0.29713 Mabsadd L
.61429 .23543 -1.46946 -2.02254 Mabsadd L
.61429 .23543 0 -0.96154 Mabsadd L
.61429 .23543 1.46946 -2.02254 Mabsadd L
.61429 .23543 .91448 -0.29713 Mabsadd L
.61429 .23543 2.37764 .77254 Mabsadd L
.61429 .23543 .56518 .7779 Mabsadd L
.61429 .23543 0 2.5 Mabsadd L closepath F
.61746 .23514 0 2.5 Mabsadd m
.61746 .23514 -0.56518 .7779 Mabsadd L
.61746 .23514 -2.37764 .77254 Mabsadd L
.61746 .23514 -0.91448 -0.29713 Mabsadd L
.61746 .23514 -1.46946 -2.02254 Mabsadd L
.61746 .23514 0 -0.96154 Mabsadd L
.61746 .23514 1.46946 -2.02254 Mabsadd L
.61746 .23514 .91448 -0.29713 Mabsadd L
.61746 .23514 2.37764 .77254 Mabsadd L
.61746 .23514 .56518 .7779 Mabsadd L
.61746 .23514 0 2.5 Mabsadd L closepath F
.62063 .23484 0 2.5 Mabsadd m
.62063 .23484 -0.56518 .7779 Mabsadd L
.62063 .23484 -2.37764 .77254 Mabsadd L
.62063 .23484 -0.91448 -0.29713 Mabsadd L
.62063 .23484 -1.46946 -2.02254 Mabsadd L
.62063 .23484 0 -0.96154 Mabsadd L
.62063 .23484 1.46946 -2.02254 Mabsadd L
.62063 .23484 .91448 -0.29713 Mabsadd L
.62063 .23484 2.37764 .77254 Mabsadd L
.62063 .23484 .56518 .7779 Mabsadd L
.62063 .23484 0 2.5 Mabsadd L closepath F
.62381 .23455 0 2.5 Mabsadd m
.62381 .23455 -0.56518 .7779 Mabsadd L
.62381 .23455 -2.37764 .77254 Mabsadd L
.62381 .23455 -0.91448 -0.29713 Mabsadd L
.62381 .23455 -1.46946 -2.02254 Mabsadd L
.62381 .23455 0 -0.96154 Mabsadd L
.62381 .23455 1.46946 -2.02254 Mabsadd L
.62381 .23455 .91448 -0.29713 Mabsadd L
.62381 .23455 2.37764 .77254 Mabsadd L
.62381 .23455 .56518 .7779 Mabsadd L
.62381 .23455 0 2.5 Mabsadd L closepath F
.62698 .23426 0 2.5 Mabsadd m
.62698 .23426 -0.56518 .7779 Mabsadd L
.62698 .23426 -2.37764 .77254 Mabsadd L
.62698 .23426 -0.91448 -0.29713 Mabsadd L
.62698 .23426 -1.46946 -2.02254 Mabsadd L
.62698 .23426 0 -0.96154 Mabsadd L
.62698 .23426 1.46946 -2.02254 Mabsadd L
.62698 .23426 .91448 -0.29713 Mabsadd L
.62698 .23426 2.37764 .77254 Mabsadd L
.62698 .23426 .56518 .7779 Mabsadd L
.62698 .23426 0 2.5 Mabsadd L closepath F
.63016 .23398 0 2.5 Mabsadd m
.63016 .23398 -0.56518 .7779 Mabsadd L
.63016 .23398 -2.37764 .77254 Mabsadd L
.63016 .23398 -0.91448 -0.29713 Mabsadd L
.63016 .23398 -1.46946 -2.02254 Mabsadd L
.63016 .23398 0 -0.96154 Mabsadd L
.63016 .23398 1.46946 -2.02254 Mabsadd L
.63016 .23398 .91448 -0.29713 Mabsadd L
.63016 .23398 2.37764 .77254 Mabsadd L
.63016 .23398 .56518 .7779 Mabsadd L
.63016 .23398 0 2.5 Mabsadd L closepath F
.63333 .23369 0 2.5 Mabsadd m
.63333 .23369 -0.56518 .7779 Mabsadd L
.63333 .23369 -2.37764 .77254 Mabsadd L
.63333 .23369 -0.91448 -0.29713 Mabsadd L
.63333 .23369 -1.46946 -2.02254 Mabsadd L
.63333 .23369 0 -0.96154 Mabsadd L
.63333 .23369 1.46946 -2.02254 Mabsadd L
.63333 .23369 .91448 -0.29713 Mabsadd L
.63333 .23369 2.37764 .77254 Mabsadd L
.63333 .23369 .56518 .7779 Mabsadd L
.63333 .23369 0 2.5 Mabsadd L closepath F
.63651 .23341 0 2.5 Mabsadd m
.63651 .23341 -0.56518 .7779 Mabsadd L
.63651 .23341 -2.37764 .77254 Mabsadd L
.63651 .23341 -0.91448 -0.29713 Mabsadd L
.63651 .23341 -1.46946 -2.02254 Mabsadd L
.63651 .23341 0 -0.96154 Mabsadd L
.63651 .23341 1.46946 -2.02254 Mabsadd L
.63651 .23341 .91448 -0.29713 Mabsadd L
.63651 .23341 2.37764 .77254 Mabsadd L
.63651 .23341 .56518 .7779 Mabsadd L
.63651 .23341 0 2.5 Mabsadd L closepath F
.63968 .23314 0 2.5 Mabsadd m
.63968 .23314 -0.56518 .7779 Mabsadd L
.63968 .23314 -2.37764 .77254 Mabsadd L
.63968 .23314 -0.91448 -0.29713 Mabsadd L
.63968 .23314 -1.46946 -2.02254 Mabsadd L
.63968 .23314 0 -0.96154 Mabsadd L
.63968 .23314 1.46946 -2.02254 Mabsadd L
.63968 .23314 .91448 -0.29713 Mabsadd L
.63968 .23314 2.37764 .77254 Mabsadd L
.63968 .23314 .56518 .7779 Mabsadd L
.63968 .23314 0 2.5 Mabsadd L closepath F
.64286 .23286 0 2.5 Mabsadd m
.64286 .23286 -0.56518 .7779 Mabsadd L
.64286 .23286 -2.37764 .77254 Mabsadd L
.64286 .23286 -0.91448 -0.29713 Mabsadd L
.64286 .23286 -1.46946 -2.02254 Mabsadd L
.64286 .23286 0 -0.96154 Mabsadd L
.64286 .23286 1.46946 -2.02254 Mabsadd L
.64286 .23286 .91448 -0.29713 Mabsadd L
.64286 .23286 2.37764 .77254 Mabsadd L
.64286 .23286 .56518 .7779 Mabsadd L
.64286 .23286 0 2.5 Mabsadd L closepath F
.64603 .23259 0 2.5 Mabsadd m
.64603 .23259 -0.56518 .7779 Mabsadd L
.64603 .23259 -2.37764 .77254 Mabsadd L
.64603 .23259 -0.91448 -0.29713 Mabsadd L
.64603 .23259 -1.46946 -2.02254 Mabsadd L
.64603 .23259 0 -0.96154 Mabsadd L
.64603 .23259 1.46946 -2.02254 Mabsadd L
.64603 .23259 .91448 -0.29713 Mabsadd L
.64603 .23259 2.37764 .77254 Mabsadd L
.64603 .23259 .56518 .7779 Mabsadd L
.64603 .23259 0 2.5 Mabsadd L closepath F
.64921 .23232 0 2.5 Mabsadd m
.64921 .23232 -0.56518 .7779 Mabsadd L
.64921 .23232 -2.37764 .77254 Mabsadd L
.64921 .23232 -0.91448 -0.29713 Mabsadd L
.64921 .23232 -1.46946 -2.02254 Mabsadd L
.64921 .23232 0 -0.96154 Mabsadd L
.64921 .23232 1.46946 -2.02254 Mabsadd L
.64921 .23232 .91448 -0.29713 Mabsadd L
.64921 .23232 2.37764 .77254 Mabsadd L
.64921 .23232 .56518 .7779 Mabsadd L
.64921 .23232 0 2.5 Mabsadd L closepath F
.65238 .23205 0 2.5 Mabsadd m
.65238 .23205 -0.56518 .7779 Mabsadd L
.65238 .23205 -2.37764 .77254 Mabsadd L
.65238 .23205 -0.91448 -0.29713 Mabsadd L
.65238 .23205 -1.46946 -2.02254 Mabsadd L
.65238 .23205 0 -0.96154 Mabsadd L
.65238 .23205 1.46946 -2.02254 Mabsadd L
.65238 .23205 .91448 -0.29713 Mabsadd L
.65238 .23205 2.37764 .77254 Mabsadd L
.65238 .23205 .56518 .7779 Mabsadd L
.65238 .23205 0 2.5 Mabsadd L closepath F
.65556 .23179 0 2.5 Mabsadd m
.65556 .23179 -0.56518 .7779 Mabsadd L
.65556 .23179 -2.37764 .77254 Mabsadd L
.65556 .23179 -0.91448 -0.29713 Mabsadd L
.65556 .23179 -1.46946 -2.02254 Mabsadd L
.65556 .23179 0 -0.96154 Mabsadd L
.65556 .23179 1.46946 -2.02254 Mabsadd L
.65556 .23179 .91448 -0.29713 Mabsadd L
.65556 .23179 2.37764 .77254 Mabsadd L
.65556 .23179 .56518 .7779 Mabsadd L
.65556 .23179 0 2.5 Mabsadd L closepath F
.65873 .23153 0 2.5 Mabsadd m
.65873 .23153 -0.56518 .7779 Mabsadd L
.65873 .23153 -2.37764 .77254 Mabsadd L
.65873 .23153 -0.91448 -0.29713 Mabsadd L
.65873 .23153 -1.46946 -2.02254 Mabsadd L
.65873 .23153 0 -0.96154 Mabsadd L
.65873 .23153 1.46946 -2.02254 Mabsadd L
.65873 .23153 .91448 -0.29713 Mabsadd L
.65873 .23153 2.37764 .77254 Mabsadd L
.65873 .23153 .56518 .7779 Mabsadd L
.65873 .23153 0 2.5 Mabsadd L closepath F
.6619 .23127 0 2.5 Mabsadd m
.6619 .23127 -0.56518 .7779 Mabsadd L
.6619 .23127 -2.37764 .77254 Mabsadd L
.6619 .23127 -0.91448 -0.29713 Mabsadd L
.6619 .23127 -1.46946 -2.02254 Mabsadd L
.6619 .23127 0 -0.96154 Mabsadd L
.6619 .23127 1.46946 -2.02254 Mabsadd L
.6619 .23127 .91448 -0.29713 Mabsadd L
.6619 .23127 2.37764 .77254 Mabsadd L
.6619 .23127 .56518 .7779 Mabsadd L
.6619 .23127 0 2.5 Mabsadd L closepath F
.66508 .23102 0 2.5 Mabsadd m
.66508 .23102 -0.56518 .7779 Mabsadd L
.66508 .23102 -2.37764 .77254 Mabsadd L
.66508 .23102 -0.91448 -0.29713 Mabsadd L
.66508 .23102 -1.46946 -2.02254 Mabsadd L
.66508 .23102 0 -0.96154 Mabsadd L
.66508 .23102 1.46946 -2.02254 Mabsadd L
.66508 .23102 .91448 -0.29713 Mabsadd L
.66508 .23102 2.37764 .77254 Mabsadd L
.66508 .23102 .56518 .7779 Mabsadd L
.66508 .23102 0 2.5 Mabsadd L closepath F
.66825 .23076 0 2.5 Mabsadd m
.66825 .23076 -0.56518 .7779 Mabsadd L
.66825 .23076 -2.37764 .77254 Mabsadd L
.66825 .23076 -0.91448 -0.29713 Mabsadd L
.66825 .23076 -1.46946 -2.02254 Mabsadd L
.66825 .23076 0 -0.96154 Mabsadd L
.66825 .23076 1.46946 -2.02254 Mabsadd L
.66825 .23076 .91448 -0.29713 Mabsadd L
.66825 .23076 2.37764 .77254 Mabsadd L
.66825 .23076 .56518 .7779 Mabsadd L
.66825 .23076 0 2.5 Mabsadd L closepath F
.67143 .23051 0 2.5 Mabsadd m
.67143 .23051 -0.56518 .7779 Mabsadd L
.67143 .23051 -2.37764 .77254 Mabsadd L
.67143 .23051 -0.91448 -0.29713 Mabsadd L
.67143 .23051 -1.46946 -2.02254 Mabsadd L
.67143 .23051 0 -0.96154 Mabsadd L
.67143 .23051 1.46946 -2.02254 Mabsadd L
.67143 .23051 .91448 -0.29713 Mabsadd L
.67143 .23051 2.37764 .77254 Mabsadd L
.67143 .23051 .56518 .7779 Mabsadd L
.67143 .23051 0 2.5 Mabsadd L closepath F
.6746 .23026 0 2.5 Mabsadd m
.6746 .23026 -0.56518 .7779 Mabsadd L
.6746 .23026 -2.37764 .77254 Mabsadd L
.6746 .23026 -0.91448 -0.29713 Mabsadd L
.6746 .23026 -1.46946 -2.02254 Mabsadd L
.6746 .23026 0 -0.96154 Mabsadd L
.6746 .23026 1.46946 -2.02254 Mabsadd L
.6746 .23026 .91448 -0.29713 Mabsadd L
.6746 .23026 2.37764 .77254 Mabsadd L
.6746 .23026 .56518 .7779 Mabsadd L
.6746 .23026 0 2.5 Mabsadd L closepath F
.67778 .23002 0 2.5 Mabsadd m
.67778 .23002 -0.56518 .7779 Mabsadd L
.67778 .23002 -2.37764 .77254 Mabsadd L
.67778 .23002 -0.91448 -0.29713 Mabsadd L
.67778 .23002 -1.46946 -2.02254 Mabsadd L
.67778 .23002 0 -0.96154 Mabsadd L
.67778 .23002 1.46946 -2.02254 Mabsadd L
.67778 .23002 .91448 -0.29713 Mabsadd L
.67778 .23002 2.37764 .77254 Mabsadd L
.67778 .23002 .56518 .7779 Mabsadd L
.67778 .23002 0 2.5 Mabsadd L closepath F
.68095 .22977 0 2.5 Mabsadd m
.68095 .22977 -0.56518 .7779 Mabsadd L
.68095 .22977 -2.37764 .77254 Mabsadd L
.68095 .22977 -0.91448 -0.29713 Mabsadd L
.68095 .22977 -1.46946 -2.02254 Mabsadd L
.68095 .22977 0 -0.96154 Mabsadd L
.68095 .22977 1.46946 -2.02254 Mabsadd L
.68095 .22977 .91448 -0.29713 Mabsadd L
.68095 .22977 2.37764 .77254 Mabsadd L
.68095 .22977 .56518 .7779 Mabsadd L
.68095 .22977 0 2.5 Mabsadd L closepath F
.68413 .22953 0 2.5 Mabsadd m
.68413 .22953 -0.56518 .7779 Mabsadd L
.68413 .22953 -2.37764 .77254 Mabsadd L
.68413 .22953 -0.91448 -0.29713 Mabsadd L
.68413 .22953 -1.46946 -2.02254 Mabsadd L
.68413 .22953 0 -0.96154 Mabsadd L
.68413 .22953 1.46946 -2.02254 Mabsadd L
.68413 .22953 .91448 -0.29713 Mabsadd L
.68413 .22953 2.37764 .77254 Mabsadd L
.68413 .22953 .56518 .7779 Mabsadd L
.68413 .22953 0 2.5 Mabsadd L closepath F
.6873 .2293 0 2.5 Mabsadd m
.6873 .2293 -0.56518 .7779 Mabsadd L
.6873 .2293 -2.37764 .77254 Mabsadd L
.6873 .2293 -0.91448 -0.29713 Mabsadd L
.6873 .2293 -1.46946 -2.02254 Mabsadd L
.6873 .2293 0 -0.96154 Mabsadd L
.6873 .2293 1.46946 -2.02254 Mabsadd L
.6873 .2293 .91448 -0.29713 Mabsadd L
.6873 .2293 2.37764 .77254 Mabsadd L
.6873 .2293 .56518 .7779 Mabsadd L
.6873 .2293 0 2.5 Mabsadd L closepath F
.69048 .22906 0 2.5 Mabsadd m
.69048 .22906 -0.56518 .7779 Mabsadd L
.69048 .22906 -2.37764 .77254 Mabsadd L
.69048 .22906 -0.91448 -0.29713 Mabsadd L
.69048 .22906 -1.46946 -2.02254 Mabsadd L
.69048 .22906 0 -0.96154 Mabsadd L
.69048 .22906 1.46946 -2.02254 Mabsadd L
.69048 .22906 .91448 -0.29713 Mabsadd L
.69048 .22906 2.37764 .77254 Mabsadd L
.69048 .22906 .56518 .7779 Mabsadd L
.69048 .22906 0 2.5 Mabsadd L closepath F
.69365 .22883 0 2.5 Mabsadd m
.69365 .22883 -0.56518 .7779 Mabsadd L
.69365 .22883 -2.37764 .77254 Mabsadd L
.69365 .22883 -0.91448 -0.29713 Mabsadd L
.69365 .22883 -1.46946 -2.02254 Mabsadd L
.69365 .22883 0 -0.96154 Mabsadd L
.69365 .22883 1.46946 -2.02254 Mabsadd L
.69365 .22883 .91448 -0.29713 Mabsadd L
.69365 .22883 2.37764 .77254 Mabsadd L
.69365 .22883 .56518 .7779 Mabsadd L
.69365 .22883 0 2.5 Mabsadd L closepath F
.69683 .22859 0 2.5 Mabsadd m
.69683 .22859 -0.56518 .7779 Mabsadd L
.69683 .22859 -2.37764 .77254 Mabsadd L
.69683 .22859 -0.91448 -0.29713 Mabsadd L
.69683 .22859 -1.46946 -2.02254 Mabsadd L
.69683 .22859 0 -0.96154 Mabsadd L
.69683 .22859 1.46946 -2.02254 Mabsadd L
.69683 .22859 .91448 -0.29713 Mabsadd L
.69683 .22859 2.37764 .77254 Mabsadd L
.69683 .22859 .56518 .7779 Mabsadd L
.69683 .22859 0 2.5 Mabsadd L closepath F
.7 .22836 0 2.5 Mabsadd m
.7 .22836 -0.56518 .7779 Mabsadd L
.7 .22836 -2.37764 .77254 Mabsadd L
.7 .22836 -0.91448 -0.29713 Mabsadd L
.7 .22836 -1.46946 -2.02254 Mabsadd L
.7 .22836 0 -0.96154 Mabsadd L
.7 .22836 1.46946 -2.02254 Mabsadd L
.7 .22836 .91448 -0.29713 Mabsadd L
.7 .22836 2.37764 .77254 Mabsadd L
.7 .22836 .56518 .7779 Mabsadd L
.7 .22836 0 2.5 Mabsadd L closepath F
.70317 .22814 0 2.5 Mabsadd m
.70317 .22814 -0.56518 .7779 Mabsadd L
.70317 .22814 -2.37764 .77254 Mabsadd L
.70317 .22814 -0.91448 -0.29713 Mabsadd L
.70317 .22814 -1.46946 -2.02254 Mabsadd L
.70317 .22814 0 -0.96154 Mabsadd L
.70317 .22814 1.46946 -2.02254 Mabsadd L
.70317 .22814 .91448 -0.29713 Mabsadd L
.70317 .22814 2.37764 .77254 Mabsadd L
.70317 .22814 .56518 .7779 Mabsadd L
.70317 .22814 0 2.5 Mabsadd L closepath F
.70635 .22791 0 2.5 Mabsadd m
.70635 .22791 -0.56518 .7779 Mabsadd L
.70635 .22791 -2.37764 .77254 Mabsadd L
.70635 .22791 -0.91448 -0.29713 Mabsadd L
.70635 .22791 -1.46946 -2.02254 Mabsadd L
.70635 .22791 0 -0.96154 Mabsadd L
.70635 .22791 1.46946 -2.02254 Mabsadd L
.70635 .22791 .91448 -0.29713 Mabsadd L
.70635 .22791 2.37764 .77254 Mabsadd L
.70635 .22791 .56518 .7779 Mabsadd L
.70635 .22791 0 2.5 Mabsadd L closepath F
.70952 .22769 0 2.5 Mabsadd m
.70952 .22769 -0.56518 .7779 Mabsadd L
.70952 .22769 -2.37764 .77254 Mabsadd L
.70952 .22769 -0.91448 -0.29713 Mabsadd L
.70952 .22769 -1.46946 -2.02254 Mabsadd L
.70952 .22769 0 -0.96154 Mabsadd L
.70952 .22769 1.46946 -2.02254 Mabsadd L
.70952 .22769 .91448 -0.29713 Mabsadd L
.70952 .22769 2.37764 .77254 Mabsadd L
.70952 .22769 .56518 .7779 Mabsadd L
.70952 .22769 0 2.5 Mabsadd L closepath F
.7127 .22747 0 2.5 Mabsadd m
.7127 .22747 -0.56518 .7779 Mabsadd L
.7127 .22747 -2.37764 .77254 Mabsadd L
.7127 .22747 -0.91448 -0.29713 Mabsadd L
.7127 .22747 -1.46946 -2.02254 Mabsadd L
.7127 .22747 0 -0.96154 Mabsadd L
.7127 .22747 1.46946 -2.02254 Mabsadd L
.7127 .22747 .91448 -0.29713 Mabsadd L
.7127 .22747 2.37764 .77254 Mabsadd L
.7127 .22747 .56518 .7779 Mabsadd L
.7127 .22747 0 2.5 Mabsadd L closepath F
.71587 .22725 0 2.5 Mabsadd m
.71587 .22725 -0.56518 .7779 Mabsadd L
.71587 .22725 -2.37764 .77254 Mabsadd L
.71587 .22725 -0.91448 -0.29713 Mabsadd L
.71587 .22725 -1.46946 -2.02254 Mabsadd L
.71587 .22725 0 -0.96154 Mabsadd L
.71587 .22725 1.46946 -2.02254 Mabsadd L
.71587 .22725 .91448 -0.29713 Mabsadd L
.71587 .22725 2.37764 .77254 Mabsadd L
.71587 .22725 .56518 .7779 Mabsadd L
.71587 .22725 0 2.5 Mabsadd L closepath F
.71905 .22704 0 2.5 Mabsadd m
.71905 .22704 -0.56518 .7779 Mabsadd L
.71905 .22704 -2.37764 .77254 Mabsadd L
.71905 .22704 -0.91448 -0.29713 Mabsadd L
.71905 .22704 -1.46946 -2.02254 Mabsadd L
.71905 .22704 0 -0.96154 Mabsadd L
.71905 .22704 1.46946 -2.02254 Mabsadd L
.71905 .22704 .91448 -0.29713 Mabsadd L
.71905 .22704 2.37764 .77254 Mabsadd L
.71905 .22704 .56518 .7779 Mabsadd L
.71905 .22704 0 2.5 Mabsadd L closepath F
.72222 .22682 0 2.5 Mabsadd m
.72222 .22682 -0.56518 .7779 Mabsadd L
.72222 .22682 -2.37764 .77254 Mabsadd L
.72222 .22682 -0.91448 -0.29713 Mabsadd L
.72222 .22682 -1.46946 -2.02254 Mabsadd L
.72222 .22682 0 -0.96154 Mabsadd L
.72222 .22682 1.46946 -2.02254 Mabsadd L
.72222 .22682 .91448 -0.29713 Mabsadd L
.72222 .22682 2.37764 .77254 Mabsadd L
.72222 .22682 .56518 .7779 Mabsadd L
.72222 .22682 0 2.5 Mabsadd L closepath F
.7254 .22661 0 2.5 Mabsadd m
.7254 .22661 -0.56518 .7779 Mabsadd L
.7254 .22661 -2.37764 .77254 Mabsadd L
.7254 .22661 -0.91448 -0.29713 Mabsadd L
.7254 .22661 -1.46946 -2.02254 Mabsadd L
.7254 .22661 0 -0.96154 Mabsadd L
.7254 .22661 1.46946 -2.02254 Mabsadd L
.7254 .22661 .91448 -0.29713 Mabsadd L
.7254 .22661 2.37764 .77254 Mabsadd L
.7254 .22661 .56518 .7779 Mabsadd L
.7254 .22661 0 2.5 Mabsadd L closepath F
.72857 .2264 0 2.5 Mabsadd m
.72857 .2264 -0.56518 .7779 Mabsadd L
.72857 .2264 -2.37764 .77254 Mabsadd L
.72857 .2264 -0.91448 -0.29713 Mabsadd L
.72857 .2264 -1.46946 -2.02254 Mabsadd L
.72857 .2264 0 -0.96154 Mabsadd L
.72857 .2264 1.46946 -2.02254 Mabsadd L
.72857 .2264 .91448 -0.29713 Mabsadd L
.72857 .2264 2.37764 .77254 Mabsadd L
.72857 .2264 .56518 .7779 Mabsadd L
.72857 .2264 0 2.5 Mabsadd L closepath F
.73175 .2262 0 2.5 Mabsadd m
.73175 .2262 -0.56518 .7779 Mabsadd L
.73175 .2262 -2.37764 .77254 Mabsadd L
.73175 .2262 -0.91448 -0.29713 Mabsadd L
.73175 .2262 -1.46946 -2.02254 Mabsadd L
.73175 .2262 0 -0.96154 Mabsadd L
.73175 .2262 1.46946 -2.02254 Mabsadd L
.73175 .2262 .91448 -0.29713 Mabsadd L
.73175 .2262 2.37764 .77254 Mabsadd L
.73175 .2262 .56518 .7779 Mabsadd L
.73175 .2262 0 2.5 Mabsadd L closepath F
.73492 .22599 0 2.5 Mabsadd m
.73492 .22599 -0.56518 .7779 Mabsadd L
.73492 .22599 -2.37764 .77254 Mabsadd L
.73492 .22599 -0.91448 -0.29713 Mabsadd L
.73492 .22599 -1.46946 -2.02254 Mabsadd L
.73492 .22599 0 -0.96154 Mabsadd L
.73492 .22599 1.46946 -2.02254 Mabsadd L
.73492 .22599 .91448 -0.29713 Mabsadd L
.73492 .22599 2.37764 .77254 Mabsadd L
.73492 .22599 .56518 .7779 Mabsadd L
.73492 .22599 0 2.5 Mabsadd L closepath F
.7381 .22579 0 2.5 Mabsadd m
.7381 .22579 -0.56518 .7779 Mabsadd L
.7381 .22579 -2.37764 .77254 Mabsadd L
.7381 .22579 -0.91448 -0.29713 Mabsadd L
.7381 .22579 -1.46946 -2.02254 Mabsadd L
.7381 .22579 0 -0.96154 Mabsadd L
.7381 .22579 1.46946 -2.02254 Mabsadd L
.7381 .22579 .91448 -0.29713 Mabsadd L
.7381 .22579 2.37764 .77254 Mabsadd L
.7381 .22579 .56518 .7779 Mabsadd L
.7381 .22579 0 2.5 Mabsadd L closepath F
.74127 .22559 0 2.5 Mabsadd m
.74127 .22559 -0.56518 .7779 Mabsadd L
.74127 .22559 -2.37764 .77254 Mabsadd L
.74127 .22559 -0.91448 -0.29713 Mabsadd L
.74127 .22559 -1.46946 -2.02254 Mabsadd L
.74127 .22559 0 -0.96154 Mabsadd L
.74127 .22559 1.46946 -2.02254 Mabsadd L
.74127 .22559 .91448 -0.29713 Mabsadd L
.74127 .22559 2.37764 .77254 Mabsadd L
.74127 .22559 .56518 .7779 Mabsadd L
.74127 .22559 0 2.5 Mabsadd L closepath F
.74444 .22539 0 2.5 Mabsadd m
.74444 .22539 -0.56518 .7779 Mabsadd L
.74444 .22539 -2.37764 .77254 Mabsadd L
.74444 .22539 -0.91448 -0.29713 Mabsadd L
.74444 .22539 -1.46946 -2.02254 Mabsadd L
.74444 .22539 0 -0.96154 Mabsadd L
.74444 .22539 1.46946 -2.02254 Mabsadd L
.74444 .22539 .91448 -0.29713 Mabsadd L
.74444 .22539 2.37764 .77254 Mabsadd L
.74444 .22539 .56518 .7779 Mabsadd L
.74444 .22539 0 2.5 Mabsadd L closepath F
.74762 .22519 0 2.5 Mabsadd m
.74762 .22519 -0.56518 .7779 Mabsadd L
.74762 .22519 -2.37764 .77254 Mabsadd L
.74762 .22519 -0.91448 -0.29713 Mabsadd L
.74762 .22519 -1.46946 -2.02254 Mabsadd L
.74762 .22519 0 -0.96154 Mabsadd L
.74762 .22519 1.46946 -2.02254 Mabsadd L
.74762 .22519 .91448 -0.29713 Mabsadd L
.74762 .22519 2.37764 .77254 Mabsadd L
.74762 .22519 .56518 .7779 Mabsadd L
.74762 .22519 0 2.5 Mabsadd L closepath F
.75079 .225 0 2.5 Mabsadd m
.75079 .225 -0.56518 .7779 Mabsadd L
.75079 .225 -2.37764 .77254 Mabsadd L
.75079 .225 -0.91448 -0.29713 Mabsadd L
.75079 .225 -1.46946 -2.02254 Mabsadd L
.75079 .225 0 -0.96154 Mabsadd L
.75079 .225 1.46946 -2.02254 Mabsadd L
.75079 .225 .91448 -0.29713 Mabsadd L
.75079 .225 2.37764 .77254 Mabsadd L
.75079 .225 .56518 .7779 Mabsadd L
.75079 .225 0 2.5 Mabsadd L closepath F
.75397 .2248 0 2.5 Mabsadd m
.75397 .2248 -0.56518 .7779 Mabsadd L
.75397 .2248 -2.37764 .77254 Mabsadd L
.75397 .2248 -0.91448 -0.29713 Mabsadd L
.75397 .2248 -1.46946 -2.02254 Mabsadd L
.75397 .2248 0 -0.96154 Mabsadd L
.75397 .2248 1.46946 -2.02254 Mabsadd L
.75397 .2248 .91448 -0.29713 Mabsadd L
.75397 .2248 2.37764 .77254 Mabsadd L
.75397 .2248 .56518 .7779 Mabsadd L
.75397 .2248 0 2.5 Mabsadd L closepath F
.75714 .22461 0 2.5 Mabsadd m
.75714 .22461 -0.56518 .7779 Mabsadd L
.75714 .22461 -2.37764 .77254 Mabsadd L
.75714 .22461 -0.91448 -0.29713 Mabsadd L
.75714 .22461 -1.46946 -2.02254 Mabsadd L
.75714 .22461 0 -0.96154 Mabsadd L
.75714 .22461 1.46946 -2.02254 Mabsadd L
.75714 .22461 .91448 -0.29713 Mabsadd L
.75714 .22461 2.37764 .77254 Mabsadd L
.75714 .22461 .56518 .7779 Mabsadd L
.75714 .22461 0 2.5 Mabsadd L closepath F
.76032 .22442 0 2.5 Mabsadd m
.76032 .22442 -0.56518 .7779 Mabsadd L
.76032 .22442 -2.37764 .77254 Mabsadd L
.76032 .22442 -0.91448 -0.29713 Mabsadd L
.76032 .22442 -1.46946 -2.02254 Mabsadd L
.76032 .22442 0 -0.96154 Mabsadd L
.76032 .22442 1.46946 -2.02254 Mabsadd L
.76032 .22442 .91448 -0.29713 Mabsadd L
.76032 .22442 2.37764 .77254 Mabsadd L
.76032 .22442 .56518 .7779 Mabsadd L
.76032 .22442 0 2.5 Mabsadd L closepath F
.76349 .22424 0 2.5 Mabsadd m
.76349 .22424 -0.56518 .7779 Mabsadd L
.76349 .22424 -2.37764 .77254 Mabsadd L
.76349 .22424 -0.91448 -0.29713 Mabsadd L
.76349 .22424 -1.46946 -2.02254 Mabsadd L
.76349 .22424 0 -0.96154 Mabsadd L
.76349 .22424 1.46946 -2.02254 Mabsadd L
.76349 .22424 .91448 -0.29713 Mabsadd L
.76349 .22424 2.37764 .77254 Mabsadd L
.76349 .22424 .56518 .7779 Mabsadd L
.76349 .22424 0 2.5 Mabsadd L closepath F
.76667 .22405 0 2.5 Mabsadd m
.76667 .22405 -0.56518 .7779 Mabsadd L
.76667 .22405 -2.37764 .77254 Mabsadd L
.76667 .22405 -0.91448 -0.29713 Mabsadd L
.76667 .22405 -1.46946 -2.02254 Mabsadd L
.76667 .22405 0 -0.96154 Mabsadd L
.76667 .22405 1.46946 -2.02254 Mabsadd L
.76667 .22405 .91448 -0.29713 Mabsadd L
.76667 .22405 2.37764 .77254 Mabsadd L
.76667 .22405 .56518 .7779 Mabsadd L
.76667 .22405 0 2.5 Mabsadd L closepath F
.76984 .22387 0 2.5 Mabsadd m
.76984 .22387 -0.56518 .7779 Mabsadd L
.76984 .22387 -2.37764 .77254 Mabsadd L
.76984 .22387 -0.91448 -0.29713 Mabsadd L
.76984 .22387 -1.46946 -2.02254 Mabsadd L
.76984 .22387 0 -0.96154 Mabsadd L
.76984 .22387 1.46946 -2.02254 Mabsadd L
.76984 .22387 .91448 -0.29713 Mabsadd L
.76984 .22387 2.37764 .77254 Mabsadd L
.76984 .22387 .56518 .7779 Mabsadd L
.76984 .22387 0 2.5 Mabsadd L closepath F
.77302 .22368 0 2.5 Mabsadd m
.77302 .22368 -0.56518 .7779 Mabsadd L
.77302 .22368 -2.37764 .77254 Mabsadd L
.77302 .22368 -0.91448 -0.29713 Mabsadd L
.77302 .22368 -1.46946 -2.02254 Mabsadd L
.77302 .22368 0 -0.96154 Mabsadd L
.77302 .22368 1.46946 -2.02254 Mabsadd L
.77302 .22368 .91448 -0.29713 Mabsadd L
.77302 .22368 2.37764 .77254 Mabsadd L
.77302 .22368 .56518 .7779 Mabsadd L
.77302 .22368 0 2.5 Mabsadd L closepath F
.77619 .2235 0 2.5 Mabsadd m
.77619 .2235 -0.56518 .7779 Mabsadd L
.77619 .2235 -2.37764 .77254 Mabsadd L
.77619 .2235 -0.91448 -0.29713 Mabsadd L
.77619 .2235 -1.46946 -2.02254 Mabsadd L
.77619 .2235 0 -0.96154 Mabsadd L
.77619 .2235 1.46946 -2.02254 Mabsadd L
.77619 .2235 .91448 -0.29713 Mabsadd L
.77619 .2235 2.37764 .77254 Mabsadd L
.77619 .2235 .56518 .7779 Mabsadd L
.77619 .2235 0 2.5 Mabsadd L closepath F
.77937 .22333 0 2.5 Mabsadd m
.77937 .22333 -0.56518 .7779 Mabsadd L
.77937 .22333 -2.37764 .77254 Mabsadd L
.77937 .22333 -0.91448 -0.29713 Mabsadd L
.77937 .22333 -1.46946 -2.02254 Mabsadd L
.77937 .22333 0 -0.96154 Mabsadd L
.77937 .22333 1.46946 -2.02254 Mabsadd L
.77937 .22333 .91448 -0.29713 Mabsadd L
.77937 .22333 2.37764 .77254 Mabsadd L
.77937 .22333 .56518 .7779 Mabsadd L
.77937 .22333 0 2.5 Mabsadd L closepath F
.78254 .22315 0 2.5 Mabsadd m
.78254 .22315 -0.56518 .7779 Mabsadd L
.78254 .22315 -2.37764 .77254 Mabsadd L
.78254 .22315 -0.91448 -0.29713 Mabsadd L
.78254 .22315 -1.46946 -2.02254 Mabsadd L
.78254 .22315 0 -0.96154 Mabsadd L
.78254 .22315 1.46946 -2.02254 Mabsadd L
.78254 .22315 .91448 -0.29713 Mabsadd L
.78254 .22315 2.37764 .77254 Mabsadd L
.78254 .22315 .56518 .7779 Mabsadd L
.78254 .22315 0 2.5 Mabsadd L closepath F
.78571 .22297 0 2.5 Mabsadd m
.78571 .22297 -0.56518 .7779 Mabsadd L
.78571 .22297 -2.37764 .77254 Mabsadd L
.78571 .22297 -0.91448 -0.29713 Mabsadd L
.78571 .22297 -1.46946 -2.02254 Mabsadd L
.78571 .22297 0 -0.96154 Mabsadd L
.78571 .22297 1.46946 -2.02254 Mabsadd L
.78571 .22297 .91448 -0.29713 Mabsadd L
.78571 .22297 2.37764 .77254 Mabsadd L
.78571 .22297 .56518 .7779 Mabsadd L
.78571 .22297 0 2.5 Mabsadd L closepath F
.78889 .2228 0 2.5 Mabsadd m
.78889 .2228 -0.56518 .7779 Mabsadd L
.78889 .2228 -2.37764 .77254 Mabsadd L
.78889 .2228 -0.91448 -0.29713 Mabsadd L
.78889 .2228 -1.46946 -2.02254 Mabsadd L
.78889 .2228 0 -0.96154 Mabsadd L
.78889 .2228 1.46946 -2.02254 Mabsadd L
.78889 .2228 .91448 -0.29713 Mabsadd L
.78889 .2228 2.37764 .77254 Mabsadd L
.78889 .2228 .56518 .7779 Mabsadd L
.78889 .2228 0 2.5 Mabsadd L closepath F
.79206 .22263 0 2.5 Mabsadd m
.79206 .22263 -0.56518 .7779 Mabsadd L
.79206 .22263 -2.37764 .77254 Mabsadd L
.79206 .22263 -0.91448 -0.29713 Mabsadd L
.79206 .22263 -1.46946 -2.02254 Mabsadd L
.79206 .22263 0 -0.96154 Mabsadd L
.79206 .22263 1.46946 -2.02254 Mabsadd L
.79206 .22263 .91448 -0.29713 Mabsadd L
.79206 .22263 2.37764 .77254 Mabsadd L
.79206 .22263 .56518 .7779 Mabsadd L
.79206 .22263 0 2.5 Mabsadd L closepath F
.79524 .22246 0 2.5 Mabsadd m
.79524 .22246 -0.56518 .7779 Mabsadd L
.79524 .22246 -2.37764 .77254 Mabsadd L
.79524 .22246 -0.91448 -0.29713 Mabsadd L
.79524 .22246 -1.46946 -2.02254 Mabsadd L
.79524 .22246 0 -0.96154 Mabsadd L
.79524 .22246 1.46946 -2.02254 Mabsadd L
.79524 .22246 .91448 -0.29713 Mabsadd L
.79524 .22246 2.37764 .77254 Mabsadd L
.79524 .22246 .56518 .7779 Mabsadd L
.79524 .22246 0 2.5 Mabsadd L closepath F
.79841 .22229 0 2.5 Mabsadd m
.79841 .22229 -0.56518 .7779 Mabsadd L
.79841 .22229 -2.37764 .77254 Mabsadd L
.79841 .22229 -0.91448 -0.29713 Mabsadd L
.79841 .22229 -1.46946 -2.02254 Mabsadd L
.79841 .22229 0 -0.96154 Mabsadd L
.79841 .22229 1.46946 -2.02254 Mabsadd L
.79841 .22229 .91448 -0.29713 Mabsadd L
.79841 .22229 2.37764 .77254 Mabsadd L
.79841 .22229 .56518 .7779 Mabsadd L
.79841 .22229 0 2.5 Mabsadd L closepath F
.80159 .22213 0 2.5 Mabsadd m
.80159 .22213 -0.56518 .7779 Mabsadd L
.80159 .22213 -2.37764 .77254 Mabsadd L
.80159 .22213 -0.91448 -0.29713 Mabsadd L
.80159 .22213 -1.46946 -2.02254 Mabsadd L
.80159 .22213 0 -0.96154 Mabsadd L
.80159 .22213 1.46946 -2.02254 Mabsadd L
.80159 .22213 .91448 -0.29713 Mabsadd L
.80159 .22213 2.37764 .77254 Mabsadd L
.80159 .22213 .56518 .7779 Mabsadd L
.80159 .22213 0 2.5 Mabsadd L closepath F
.80476 .22196 0 2.5 Mabsadd m
.80476 .22196 -0.56518 .7779 Mabsadd L
.80476 .22196 -2.37764 .77254 Mabsadd L
.80476 .22196 -0.91448 -0.29713 Mabsadd L
.80476 .22196 -1.46946 -2.02254 Mabsadd L
.80476 .22196 0 -0.96154 Mabsadd L
.80476 .22196 1.46946 -2.02254 Mabsadd L
.80476 .22196 .91448 -0.29713 Mabsadd L
.80476 .22196 2.37764 .77254 Mabsadd L
.80476 .22196 .56518 .7779 Mabsadd L
.80476 .22196 0 2.5 Mabsadd L closepath F
.80794 .2218 0 2.5 Mabsadd m
.80794 .2218 -0.56518 .7779 Mabsadd L
.80794 .2218 -2.37764 .77254 Mabsadd L
.80794 .2218 -0.91448 -0.29713 Mabsadd L
.80794 .2218 -1.46946 -2.02254 Mabsadd L
.80794 .2218 0 -0.96154 Mabsadd L
.80794 .2218 1.46946 -2.02254 Mabsadd L
.80794 .2218 .91448 -0.29713 Mabsadd L
.80794 .2218 2.37764 .77254 Mabsadd L
.80794 .2218 .56518 .7779 Mabsadd L
.80794 .2218 0 2.5 Mabsadd L closepath F
.81111 .22164 0 2.5 Mabsadd m
.81111 .22164 -0.56518 .7779 Mabsadd L
.81111 .22164 -2.37764 .77254 Mabsadd L
.81111 .22164 -0.91448 -0.29713 Mabsadd L
.81111 .22164 -1.46946 -2.02254 Mabsadd L
.81111 .22164 0 -0.96154 Mabsadd L
.81111 .22164 1.46946 -2.02254 Mabsadd L
.81111 .22164 .91448 -0.29713 Mabsadd L
.81111 .22164 2.37764 .77254 Mabsadd L
.81111 .22164 .56518 .7779 Mabsadd L
.81111 .22164 0 2.5 Mabsadd L closepath F
.81429 .22148 0 2.5 Mabsadd m
.81429 .22148 -0.56518 .7779 Mabsadd L
.81429 .22148 -2.37764 .77254 Mabsadd L
.81429 .22148 -0.91448 -0.29713 Mabsadd L
.81429 .22148 -1.46946 -2.02254 Mabsadd L
.81429 .22148 0 -0.96154 Mabsadd L
.81429 .22148 1.46946 -2.02254 Mabsadd L
.81429 .22148 .91448 -0.29713 Mabsadd L
.81429 .22148 2.37764 .77254 Mabsadd L
.81429 .22148 .56518 .7779 Mabsadd L
.81429 .22148 0 2.5 Mabsadd L closepath F
.81746 .22132 0 2.5 Mabsadd m
.81746 .22132 -0.56518 .7779 Mabsadd L
.81746 .22132 -2.37764 .77254 Mabsadd L
.81746 .22132 -0.91448 -0.29713 Mabsadd L
.81746 .22132 -1.46946 -2.02254 Mabsadd L
.81746 .22132 0 -0.96154 Mabsadd L
.81746 .22132 1.46946 -2.02254 Mabsadd L
.81746 .22132 .91448 -0.29713 Mabsadd L
.81746 .22132 2.37764 .77254 Mabsadd L
.81746 .22132 .56518 .7779 Mabsadd L
.81746 .22132 0 2.5 Mabsadd L closepath F
.82063 .22117 0 2.5 Mabsadd m
.82063 .22117 -0.56518 .7779 Mabsadd L
.82063 .22117 -2.37764 .77254 Mabsadd L
.82063 .22117 -0.91448 -0.29713 Mabsadd L
.82063 .22117 -1.46946 -2.02254 Mabsadd L
.82063 .22117 0 -0.96154 Mabsadd L
.82063 .22117 1.46946 -2.02254 Mabsadd L
.82063 .22117 .91448 -0.29713 Mabsadd L
.82063 .22117 2.37764 .77254 Mabsadd L
.82063 .22117 .56518 .7779 Mabsadd L
.82063 .22117 0 2.5 Mabsadd L closepath F
.82381 .22101 0 2.5 Mabsadd m
.82381 .22101 -0.56518 .7779 Mabsadd L
.82381 .22101 -2.37764 .77254 Mabsadd L
.82381 .22101 -0.91448 -0.29713 Mabsadd L
.82381 .22101 -1.46946 -2.02254 Mabsadd L
.82381 .22101 0 -0.96154 Mabsadd L
.82381 .22101 1.46946 -2.02254 Mabsadd L
.82381 .22101 .91448 -0.29713 Mabsadd L
.82381 .22101 2.37764 .77254 Mabsadd L
.82381 .22101 .56518 .7779 Mabsadd L
.82381 .22101 0 2.5 Mabsadd L closepath F
.82698 .22086 0 2.5 Mabsadd m
.82698 .22086 -0.56518 .7779 Mabsadd L
.82698 .22086 -2.37764 .77254 Mabsadd L
.82698 .22086 -0.91448 -0.29713 Mabsadd L
.82698 .22086 -1.46946 -2.02254 Mabsadd L
.82698 .22086 0 -0.96154 Mabsadd L
.82698 .22086 1.46946 -2.02254 Mabsadd L
.82698 .22086 .91448 -0.29713 Mabsadd L
.82698 .22086 2.37764 .77254 Mabsadd L
.82698 .22086 .56518 .7779 Mabsadd L
.82698 .22086 0 2.5 Mabsadd L closepath F
.83016 .22071 0 2.5 Mabsadd m
.83016 .22071 -0.56518 .7779 Mabsadd L
.83016 .22071 -2.37764 .77254 Mabsadd L
.83016 .22071 -0.91448 -0.29713 Mabsadd L
.83016 .22071 -1.46946 -2.02254 Mabsadd L
.83016 .22071 0 -0.96154 Mabsadd L
.83016 .22071 1.46946 -2.02254 Mabsadd L
.83016 .22071 .91448 -0.29713 Mabsadd L
.83016 .22071 2.37764 .77254 Mabsadd L
.83016 .22071 .56518 .7779 Mabsadd L
.83016 .22071 0 2.5 Mabsadd L closepath F
.83333 .22056 0 2.5 Mabsadd m
.83333 .22056 -0.56518 .7779 Mabsadd L
.83333 .22056 -2.37764 .77254 Mabsadd L
.83333 .22056 -0.91448 -0.29713 Mabsadd L
.83333 .22056 -1.46946 -2.02254 Mabsadd L
.83333 .22056 0 -0.96154 Mabsadd L
.83333 .22056 1.46946 -2.02254 Mabsadd L
.83333 .22056 .91448 -0.29713 Mabsadd L
.83333 .22056 2.37764 .77254 Mabsadd L
.83333 .22056 .56518 .7779 Mabsadd L
.83333 .22056 0 2.5 Mabsadd L closepath F
.83651 .22041 0 2.5 Mabsadd m
.83651 .22041 -0.56518 .7779 Mabsadd L
.83651 .22041 -2.37764 .77254 Mabsadd L
.83651 .22041 -0.91448 -0.29713 Mabsadd L
.83651 .22041 -1.46946 -2.02254 Mabsadd L
.83651 .22041 0 -0.96154 Mabsadd L
.83651 .22041 1.46946 -2.02254 Mabsadd L
.83651 .22041 .91448 -0.29713 Mabsadd L
.83651 .22041 2.37764 .77254 Mabsadd L
.83651 .22041 .56518 .7779 Mabsadd L
.83651 .22041 0 2.5 Mabsadd L closepath F
.83968 .22026 0 2.5 Mabsadd m
.83968 .22026 -0.56518 .7779 Mabsadd L
.83968 .22026 -2.37764 .77254 Mabsadd L
.83968 .22026 -0.91448 -0.29713 Mabsadd L
.83968 .22026 -1.46946 -2.02254 Mabsadd L
.83968 .22026 0 -0.96154 Mabsadd L
.83968 .22026 1.46946 -2.02254 Mabsadd L
.83968 .22026 .91448 -0.29713 Mabsadd L
.83968 .22026 2.37764 .77254 Mabsadd L
.83968 .22026 .56518 .7779 Mabsadd L
.83968 .22026 0 2.5 Mabsadd L closepath F
.84286 .22011 0 2.5 Mabsadd m
.84286 .22011 -0.56518 .7779 Mabsadd L
.84286 .22011 -2.37764 .77254 Mabsadd L
.84286 .22011 -0.91448 -0.29713 Mabsadd L
.84286 .22011 -1.46946 -2.02254 Mabsadd L
.84286 .22011 0 -0.96154 Mabsadd L
.84286 .22011 1.46946 -2.02254 Mabsadd L
.84286 .22011 .91448 -0.29713 Mabsadd L
.84286 .22011 2.37764 .77254 Mabsadd L
.84286 .22011 .56518 .7779 Mabsadd L
.84286 .22011 0 2.5 Mabsadd L closepath F
.84603 .21997 0 2.5 Mabsadd m
.84603 .21997 -0.56518 .7779 Mabsadd L
.84603 .21997 -2.37764 .77254 Mabsadd L
.84603 .21997 -0.91448 -0.29713 Mabsadd L
.84603 .21997 -1.46946 -2.02254 Mabsadd L
.84603 .21997 0 -0.96154 Mabsadd L
.84603 .21997 1.46946 -2.02254 Mabsadd L
.84603 .21997 .91448 -0.29713 Mabsadd L
.84603 .21997 2.37764 .77254 Mabsadd L
.84603 .21997 .56518 .7779 Mabsadd L
.84603 .21997 0 2.5 Mabsadd L closepath F
.84921 .21983 0 2.5 Mabsadd m
.84921 .21983 -0.56518 .7779 Mabsadd L
.84921 .21983 -2.37764 .77254 Mabsadd L
.84921 .21983 -0.91448 -0.29713 Mabsadd L
.84921 .21983 -1.46946 -2.02254 Mabsadd L
.84921 .21983 0 -0.96154 Mabsadd L
.84921 .21983 1.46946 -2.02254 Mabsadd L
.84921 .21983 .91448 -0.29713 Mabsadd L
.84921 .21983 2.37764 .77254 Mabsadd L
.84921 .21983 .56518 .7779 Mabsadd L
.84921 .21983 0 2.5 Mabsadd L closepath F
.85238 .21969 0 2.5 Mabsadd m
.85238 .21969 -0.56518 .7779 Mabsadd L
.85238 .21969 -2.37764 .77254 Mabsadd L
.85238 .21969 -0.91448 -0.29713 Mabsadd L
.85238 .21969 -1.46946 -2.02254 Mabsadd L
.85238 .21969 0 -0.96154 Mabsadd L
.85238 .21969 1.46946 -2.02254 Mabsadd L
.85238 .21969 .91448 -0.29713 Mabsadd L
.85238 .21969 2.37764 .77254 Mabsadd L
.85238 .21969 .56518 .7779 Mabsadd L
.85238 .21969 0 2.5 Mabsadd L closepath F
.85556 .21955 0 2.5 Mabsadd m
.85556 .21955 -0.56518 .7779 Mabsadd L
.85556 .21955 -2.37764 .77254 Mabsadd L
.85556 .21955 -0.91448 -0.29713 Mabsadd L
.85556 .21955 -1.46946 -2.02254 Mabsadd L
.85556 .21955 0 -0.96154 Mabsadd L
.85556 .21955 1.46946 -2.02254 Mabsadd L
.85556 .21955 .91448 -0.29713 Mabsadd L
.85556 .21955 2.37764 .77254 Mabsadd L
.85556 .21955 .56518 .7779 Mabsadd L
.85556 .21955 0 2.5 Mabsadd L closepath F
.85873 .21941 0 2.5 Mabsadd m
.85873 .21941 -0.56518 .7779 Mabsadd L
.85873 .21941 -2.37764 .77254 Mabsadd L
.85873 .21941 -0.91448 -0.29713 Mabsadd L
.85873 .21941 -1.46946 -2.02254 Mabsadd L
.85873 .21941 0 -0.96154 Mabsadd L
.85873 .21941 1.46946 -2.02254 Mabsadd L
.85873 .21941 .91448 -0.29713 Mabsadd L
.85873 .21941 2.37764 .77254 Mabsadd L
.85873 .21941 .56518 .7779 Mabsadd L
.85873 .21941 0 2.5 Mabsadd L closepath F
.8619 .21927 0 2.5 Mabsadd m
.8619 .21927 -0.56518 .7779 Mabsadd L
.8619 .21927 -2.37764 .77254 Mabsadd L
.8619 .21927 -0.91448 -0.29713 Mabsadd L
.8619 .21927 -1.46946 -2.02254 Mabsadd L
.8619 .21927 0 -0.96154 Mabsadd L
.8619 .21927 1.46946 -2.02254 Mabsadd L
.8619 .21927 .91448 -0.29713 Mabsadd L
.8619 .21927 2.37764 .77254 Mabsadd L
.8619 .21927 .56518 .7779 Mabsadd L
.8619 .21927 0 2.5 Mabsadd L closepath F
.86508 .21913 0 2.5 Mabsadd m
.86508 .21913 -0.56518 .7779 Mabsadd L
.86508 .21913 -2.37764 .77254 Mabsadd L
.86508 .21913 -0.91448 -0.29713 Mabsadd L
.86508 .21913 -1.46946 -2.02254 Mabsadd L
.86508 .21913 0 -0.96154 Mabsadd L
.86508 .21913 1.46946 -2.02254 Mabsadd L
.86508 .21913 .91448 -0.29713 Mabsadd L
.86508 .21913 2.37764 .77254 Mabsadd L
.86508 .21913 .56518 .7779 Mabsadd L
.86508 .21913 0 2.5 Mabsadd L closepath F
.86825 .219 0 2.5 Mabsadd m
.86825 .219 -0.56518 .7779 Mabsadd L
.86825 .219 -2.37764 .77254 Mabsadd L
.86825 .219 -0.91448 -0.29713 Mabsadd L
.86825 .219 -1.46946 -2.02254 Mabsadd L
.86825 .219 0 -0.96154 Mabsadd L
.86825 .219 1.46946 -2.02254 Mabsadd L
.86825 .219 .91448 -0.29713 Mabsadd L
.86825 .219 2.37764 .77254 Mabsadd L
.86825 .219 .56518 .7779 Mabsadd L
.86825 .219 0 2.5 Mabsadd L closepath F
.87143 .21887 0 2.5 Mabsadd m
.87143 .21887 -0.56518 .7779 Mabsadd L
.87143 .21887 -2.37764 .77254 Mabsadd L
.87143 .21887 -0.91448 -0.29713 Mabsadd L
.87143 .21887 -1.46946 -2.02254 Mabsadd L
.87143 .21887 0 -0.96154 Mabsadd L
.87143 .21887 1.46946 -2.02254 Mabsadd L
.87143 .21887 .91448 -0.29713 Mabsadd L
.87143 .21887 2.37764 .77254 Mabsadd L
.87143 .21887 .56518 .7779 Mabsadd L
.87143 .21887 0 2.5 Mabsadd L closepath F
.8746 .21873 0 2.5 Mabsadd m
.8746 .21873 -0.56518 .7779 Mabsadd L
.8746 .21873 -2.37764 .77254 Mabsadd L
.8746 .21873 -0.91448 -0.29713 Mabsadd L
.8746 .21873 -1.46946 -2.02254 Mabsadd L
.8746 .21873 0 -0.96154 Mabsadd L
.8746 .21873 1.46946 -2.02254 Mabsadd L
.8746 .21873 .91448 -0.29713 Mabsadd L
.8746 .21873 2.37764 .77254 Mabsadd L
.8746 .21873 .56518 .7779 Mabsadd L
.8746 .21873 0 2.5 Mabsadd L closepath F
.87778 .2186 0 2.5 Mabsadd m
.87778 .2186 -0.56518 .7779 Mabsadd L
.87778 .2186 -2.37764 .77254 Mabsadd L
.87778 .2186 -0.91448 -0.29713 Mabsadd L
.87778 .2186 -1.46946 -2.02254 Mabsadd L
.87778 .2186 0 -0.96154 Mabsadd L
.87778 .2186 1.46946 -2.02254 Mabsadd L
.87778 .2186 .91448 -0.29713 Mabsadd L
.87778 .2186 2.37764 .77254 Mabsadd L
.87778 .2186 .56518 .7779 Mabsadd L
.87778 .2186 0 2.5 Mabsadd L closepath F
.88095 .21847 0 2.5 Mabsadd m
.88095 .21847 -0.56518 .7779 Mabsadd L
.88095 .21847 -2.37764 .77254 Mabsadd L
.88095 .21847 -0.91448 -0.29713 Mabsadd L
.88095 .21847 -1.46946 -2.02254 Mabsadd L
.88095 .21847 0 -0.96154 Mabsadd L
.88095 .21847 1.46946 -2.02254 Mabsadd L
.88095 .21847 .91448 -0.29713 Mabsadd L
.88095 .21847 2.37764 .77254 Mabsadd L
.88095 .21847 .56518 .7779 Mabsadd L
.88095 .21847 0 2.5 Mabsadd L closepath F
.88413 .21835 0 2.5 Mabsadd m
.88413 .21835 -0.56518 .7779 Mabsadd L
.88413 .21835 -2.37764 .77254 Mabsadd L
.88413 .21835 -0.91448 -0.29713 Mabsadd L
.88413 .21835 -1.46946 -2.02254 Mabsadd L
.88413 .21835 0 -0.96154 Mabsadd L
.88413 .21835 1.46946 -2.02254 Mabsadd L
.88413 .21835 .91448 -0.29713 Mabsadd L
.88413 .21835 2.37764 .77254 Mabsadd L
.88413 .21835 .56518 .7779 Mabsadd L
.88413 .21835 0 2.5 Mabsadd L closepath F
.8873 .21822 0 2.5 Mabsadd m
.8873 .21822 -0.56518 .7779 Mabsadd L
.8873 .21822 -2.37764 .77254 Mabsadd L
.8873 .21822 -0.91448 -0.29713 Mabsadd L
.8873 .21822 -1.46946 -2.02254 Mabsadd L
.8873 .21822 0 -0.96154 Mabsadd L
.8873 .21822 1.46946 -2.02254 Mabsadd L
.8873 .21822 .91448 -0.29713 Mabsadd L
.8873 .21822 2.37764 .77254 Mabsadd L
.8873 .21822 .56518 .7779 Mabsadd L
.8873 .21822 0 2.5 Mabsadd L closepath F
.89048 .21809 0 2.5 Mabsadd m
.89048 .21809 -0.56518 .7779 Mabsadd L
.89048 .21809 -2.37764 .77254 Mabsadd L
.89048 .21809 -0.91448 -0.29713 Mabsadd L
.89048 .21809 -1.46946 -2.02254 Mabsadd L
.89048 .21809 0 -0.96154 Mabsadd L
.89048 .21809 1.46946 -2.02254 Mabsadd L
.89048 .21809 .91448 -0.29713 Mabsadd L
.89048 .21809 2.37764 .77254 Mabsadd L
.89048 .21809 .56518 .7779 Mabsadd L
.89048 .21809 0 2.5 Mabsadd L closepath F
.89365 .21797 0 2.5 Mabsadd m
.89365 .21797 -0.56518 .7779 Mabsadd L
.89365 .21797 -2.37764 .77254 Mabsadd L
.89365 .21797 -0.91448 -0.29713 Mabsadd L
.89365 .21797 -1.46946 -2.02254 Mabsadd L
.89365 .21797 0 -0.96154 Mabsadd L
.89365 .21797 1.46946 -2.02254 Mabsadd L
.89365 .21797 .91448 -0.29713 Mabsadd L
.89365 .21797 2.37764 .77254 Mabsadd L
.89365 .21797 .56518 .7779 Mabsadd L
.89365 .21797 0 2.5 Mabsadd L closepath F
.89683 .21785 0 2.5 Mabsadd m
.89683 .21785 -0.56518 .7779 Mabsadd L
.89683 .21785 -2.37764 .77254 Mabsadd L
.89683 .21785 -0.91448 -0.29713 Mabsadd L
.89683 .21785 -1.46946 -2.02254 Mabsadd L
.89683 .21785 0 -0.96154 Mabsadd L
.89683 .21785 1.46946 -2.02254 Mabsadd L
.89683 .21785 .91448 -0.29713 Mabsadd L
.89683 .21785 2.37764 .77254 Mabsadd L
.89683 .21785 .56518 .7779 Mabsadd L
.89683 .21785 0 2.5 Mabsadd L closepath F
.9 .21773 0 2.5 Mabsadd m
.9 .21773 -0.56518 .7779 Mabsadd L
.9 .21773 -2.37764 .77254 Mabsadd L
.9 .21773 -0.91448 -0.29713 Mabsadd L
.9 .21773 -1.46946 -2.02254 Mabsadd L
.9 .21773 0 -0.96154 Mabsadd L
.9 .21773 1.46946 -2.02254 Mabsadd L
.9 .21773 .91448 -0.29713 Mabsadd L
.9 .21773 2.37764 .77254 Mabsadd L
.9 .21773 .56518 .7779 Mabsadd L
.9 .21773 0 2.5 Mabsadd L closepath F
.90317 .21761 0 2.5 Mabsadd m
.90317 .21761 -0.56518 .7779 Mabsadd L
.90317 .21761 -2.37764 .77254 Mabsadd L
.90317 .21761 -0.91448 -0.29713 Mabsadd L
.90317 .21761 -1.46946 -2.02254 Mabsadd L
.90317 .21761 0 -0.96154 Mabsadd L
.90317 .21761 1.46946 -2.02254 Mabsadd L
.90317 .21761 .91448 -0.29713 Mabsadd L
.90317 .21761 2.37764 .77254 Mabsadd L
.90317 .21761 .56518 .7779 Mabsadd L
.90317 .21761 0 2.5 Mabsadd L closepath F
.90635 .21749 0 2.5 Mabsadd m
.90635 .21749 -0.56518 .7779 Mabsadd L
.90635 .21749 -2.37764 .77254 Mabsadd L
.90635 .21749 -0.91448 -0.29713 Mabsadd L
.90635 .21749 -1.46946 -2.02254 Mabsadd L
.90635 .21749 0 -0.96154 Mabsadd L
.90635 .21749 1.46946 -2.02254 Mabsadd L
.90635 .21749 .91448 -0.29713 Mabsadd L
.90635 .21749 2.37764 .77254 Mabsadd L
.90635 .21749 .56518 .7779 Mabsadd L
.90635 .21749 0 2.5 Mabsadd L closepath F
.90952 .21737 0 2.5 Mabsadd m
.90952 .21737 -0.56518 .7779 Mabsadd L
.90952 .21737 -2.37764 .77254 Mabsadd L
.90952 .21737 -0.91448 -0.29713 Mabsadd L
.90952 .21737 -1.46946 -2.02254 Mabsadd L
.90952 .21737 0 -0.96154 Mabsadd L
.90952 .21737 1.46946 -2.02254 Mabsadd L
.90952 .21737 .91448 -0.29713 Mabsadd L
.90952 .21737 2.37764 .77254 Mabsadd L
.90952 .21737 .56518 .7779 Mabsadd L
.90952 .21737 0 2.5 Mabsadd L closepath F
.9127 .21725 0 2.5 Mabsadd m
.9127 .21725 -0.56518 .7779 Mabsadd L
.9127 .21725 -2.37764 .77254 Mabsadd L
.9127 .21725 -0.91448 -0.29713 Mabsadd L
.9127 .21725 -1.46946 -2.02254 Mabsadd L
.9127 .21725 0 -0.96154 Mabsadd L
.9127 .21725 1.46946 -2.02254 Mabsadd L
.9127 .21725 .91448 -0.29713 Mabsadd L
.9127 .21725 2.37764 .77254 Mabsadd L
.9127 .21725 .56518 .7779 Mabsadd L
.9127 .21725 0 2.5 Mabsadd L closepath F
.91587 .21714 0 2.5 Mabsadd m
.91587 .21714 -0.56518 .7779 Mabsadd L
.91587 .21714 -2.37764 .77254 Mabsadd L
.91587 .21714 -0.91448 -0.29713 Mabsadd L
.91587 .21714 -1.46946 -2.02254 Mabsadd L
.91587 .21714 0 -0.96154 Mabsadd L
.91587 .21714 1.46946 -2.02254 Mabsadd L
.91587 .21714 .91448 -0.29713 Mabsadd L
.91587 .21714 2.37764 .77254 Mabsadd L
.91587 .21714 .56518 .7779 Mabsadd L
.91587 .21714 0 2.5 Mabsadd L closepath F
.91905 .21702 0 2.5 Mabsadd m
.91905 .21702 -0.56518 .7779 Mabsadd L
.91905 .21702 -2.37764 .77254 Mabsadd L
.91905 .21702 -0.91448 -0.29713 Mabsadd L
.91905 .21702 -1.46946 -2.02254 Mabsadd L
.91905 .21702 0 -0.96154 Mabsadd L
.91905 .21702 1.46946 -2.02254 Mabsadd L
.91905 .21702 .91448 -0.29713 Mabsadd L
.91905 .21702 2.37764 .77254 Mabsadd L
.91905 .21702 .56518 .7779 Mabsadd L
.91905 .21702 0 2.5 Mabsadd L closepath F
.92222 .21691 0 2.5 Mabsadd m
.92222 .21691 -0.56518 .7779 Mabsadd L
.92222 .21691 -2.37764 .77254 Mabsadd L
.92222 .21691 -0.91448 -0.29713 Mabsadd L
.92222 .21691 -1.46946 -2.02254 Mabsadd L
.92222 .21691 0 -0.96154 Mabsadd L
.92222 .21691 1.46946 -2.02254 Mabsadd L
.92222 .21691 .91448 -0.29713 Mabsadd L
.92222 .21691 2.37764 .77254 Mabsadd L
.92222 .21691 .56518 .7779 Mabsadd L
.92222 .21691 0 2.5 Mabsadd L closepath F
.9254 .2168 0 2.5 Mabsadd m
.9254 .2168 -0.56518 .7779 Mabsadd L
.9254 .2168 -2.37764 .77254 Mabsadd L
.9254 .2168 -0.91448 -0.29713 Mabsadd L
.9254 .2168 -1.46946 -2.02254 Mabsadd L
.9254 .2168 0 -0.96154 Mabsadd L
.9254 .2168 1.46946 -2.02254 Mabsadd L
.9254 .2168 .91448 -0.29713 Mabsadd L
.9254 .2168 2.37764 .77254 Mabsadd L
.9254 .2168 .56518 .7779 Mabsadd L
.9254 .2168 0 2.5 Mabsadd L closepath F
.92857 .21668 0 2.5 Mabsadd m
.92857 .21668 -0.56518 .7779 Mabsadd L
.92857 .21668 -2.37764 .77254 Mabsadd L
.92857 .21668 -0.91448 -0.29713 Mabsadd L
.92857 .21668 -1.46946 -2.02254 Mabsadd L
.92857 .21668 0 -0.96154 Mabsadd L
.92857 .21668 1.46946 -2.02254 Mabsadd L
.92857 .21668 .91448 -0.29713 Mabsadd L
.92857 .21668 2.37764 .77254 Mabsadd L
.92857 .21668 .56518 .7779 Mabsadd L
.92857 .21668 0 2.5 Mabsadd L closepath F
.93175 .21657 0 2.5 Mabsadd m
.93175 .21657 -0.56518 .7779 Mabsadd L
.93175 .21657 -2.37764 .77254 Mabsadd L
.93175 .21657 -0.91448 -0.29713 Mabsadd L
.93175 .21657 -1.46946 -2.02254 Mabsadd L
.93175 .21657 0 -0.96154 Mabsadd L
.93175 .21657 1.46946 -2.02254 Mabsadd L
.93175 .21657 .91448 -0.29713 Mabsadd L
.93175 .21657 2.37764 .77254 Mabsadd L
.93175 .21657 .56518 .7779 Mabsadd L
.93175 .21657 0 2.5 Mabsadd L closepath F
.93492 .21647 0 2.5 Mabsadd m
.93492 .21647 -0.56518 .7779 Mabsadd L
.93492 .21647 -2.37764 .77254 Mabsadd L
.93492 .21647 -0.91448 -0.29713 Mabsadd L
.93492 .21647 -1.46946 -2.02254 Mabsadd L
.93492 .21647 0 -0.96154 Mabsadd L
.93492 .21647 1.46946 -2.02254 Mabsadd L
.93492 .21647 .91448 -0.29713 Mabsadd L
.93492 .21647 2.37764 .77254 Mabsadd L
.93492 .21647 .56518 .7779 Mabsadd L
.93492 .21647 0 2.5 Mabsadd L closepath F
.9381 .21636 0 2.5 Mabsadd m
.9381 .21636 -0.56518 .7779 Mabsadd L
.9381 .21636 -2.37764 .77254 Mabsadd L
.9381 .21636 -0.91448 -0.29713 Mabsadd L
.9381 .21636 -1.46946 -2.02254 Mabsadd L
.9381 .21636 0 -0.96154 Mabsadd L
.9381 .21636 1.46946 -2.02254 Mabsadd L
.9381 .21636 .91448 -0.29713 Mabsadd L
.9381 .21636 2.37764 .77254 Mabsadd L
.9381 .21636 .56518 .7779 Mabsadd L
.9381 .21636 0 2.5 Mabsadd L closepath F
.94127 .21625 0 2.5 Mabsadd m
.94127 .21625 -0.56518 .7779 Mabsadd L
.94127 .21625 -2.37764 .77254 Mabsadd L
.94127 .21625 -0.91448 -0.29713 Mabsadd L
.94127 .21625 -1.46946 -2.02254 Mabsadd L
.94127 .21625 0 -0.96154 Mabsadd L
.94127 .21625 1.46946 -2.02254 Mabsadd L
.94127 .21625 .91448 -0.29713 Mabsadd L
.94127 .21625 2.37764 .77254 Mabsadd L
.94127 .21625 .56518 .7779 Mabsadd L
.94127 .21625 0 2.5 Mabsadd L closepath F
.94444 .21615 0 2.5 Mabsadd m
.94444 .21615 -0.56518 .7779 Mabsadd L
.94444 .21615 -2.37764 .77254 Mabsadd L
.94444 .21615 -0.91448 -0.29713 Mabsadd L
.94444 .21615 -1.46946 -2.02254 Mabsadd L
.94444 .21615 0 -0.96154 Mabsadd L
.94444 .21615 1.46946 -2.02254 Mabsadd L
.94444 .21615 .91448 -0.29713 Mabsadd L
.94444 .21615 2.37764 .77254 Mabsadd L
.94444 .21615 .56518 .7779 Mabsadd L
.94444 .21615 0 2.5 Mabsadd L closepath F
.94762 .21604 0 2.5 Mabsadd m
.94762 .21604 -0.56518 .7779 Mabsadd L
.94762 .21604 -2.37764 .77254 Mabsadd L
.94762 .21604 -0.91448 -0.29713 Mabsadd L
.94762 .21604 -1.46946 -2.02254 Mabsadd L
.94762 .21604 0 -0.96154 Mabsadd L
.94762 .21604 1.46946 -2.02254 Mabsadd L
.94762 .21604 .91448 -0.29713 Mabsadd L
.94762 .21604 2.37764 .77254 Mabsadd L
.94762 .21604 .56518 .7779 Mabsadd L
.94762 .21604 0 2.5 Mabsadd L closepath F
.95079 .21594 0 2.5 Mabsadd m
.95079 .21594 -0.56518 .7779 Mabsadd L
.95079 .21594 -2.37764 .77254 Mabsadd L
.95079 .21594 -0.91448 -0.29713 Mabsadd L
.95079 .21594 -1.46946 -2.02254 Mabsadd L
.95079 .21594 0 -0.96154 Mabsadd L
.95079 .21594 1.46946 -2.02254 Mabsadd L
.95079 .21594 .91448 -0.29713 Mabsadd L
.95079 .21594 2.37764 .77254 Mabsadd L
.95079 .21594 .56518 .7779 Mabsadd L
.95079 .21594 0 2.5 Mabsadd L closepath F
.95397 .21584 0 2.5 Mabsadd m
.95397 .21584 -0.56518 .7779 Mabsadd L
.95397 .21584 -2.37764 .77254 Mabsadd L
.95397 .21584 -0.91448 -0.29713 Mabsadd L
.95397 .21584 -1.46946 -2.02254 Mabsadd L
.95397 .21584 0 -0.96154 Mabsadd L
.95397 .21584 1.46946 -2.02254 Mabsadd L
.95397 .21584 .91448 -0.29713 Mabsadd L
.95397 .21584 2.37764 .77254 Mabsadd L
.95397 .21584 .56518 .7779 Mabsadd L
.95397 .21584 0 2.5 Mabsadd L closepath F
.95714 .21573 0 2.5 Mabsadd m
.95714 .21573 -0.56518 .7779 Mabsadd L
.95714 .21573 -2.37764 .77254 Mabsadd L
.95714 .21573 -0.91448 -0.29713 Mabsadd L
.95714 .21573 -1.46946 -2.02254 Mabsadd L
.95714 .21573 0 -0.96154 Mabsadd L
.95714 .21573 1.46946 -2.02254 Mabsadd L
.95714 .21573 .91448 -0.29713 Mabsadd L
.95714 .21573 2.37764 .77254 Mabsadd L
.95714 .21573 .56518 .7779 Mabsadd L
.95714 .21573 0 2.5 Mabsadd L closepath F
.96032 .21563 0 2.5 Mabsadd m
.96032 .21563 -0.56518 .7779 Mabsadd L
.96032 .21563 -2.37764 .77254 Mabsadd L
.96032 .21563 -0.91448 -0.29713 Mabsadd L
.96032 .21563 -1.46946 -2.02254 Mabsadd L
.96032 .21563 0 -0.96154 Mabsadd L
.96032 .21563 1.46946 -2.02254 Mabsadd L
.96032 .21563 .91448 -0.29713 Mabsadd L
.96032 .21563 2.37764 .77254 Mabsadd L
.96032 .21563 .56518 .7779 Mabsadd L
.96032 .21563 0 2.5 Mabsadd L closepath F
.96349 .21553 0 2.5 Mabsadd m
.96349 .21553 -0.56518 .7779 Mabsadd L
.96349 .21553 -2.37764 .77254 Mabsadd L
.96349 .21553 -0.91448 -0.29713 Mabsadd L
.96349 .21553 -1.46946 -2.02254 Mabsadd L
.96349 .21553 0 -0.96154 Mabsadd L
.96349 .21553 1.46946 -2.02254 Mabsadd L
.96349 .21553 .91448 -0.29713 Mabsadd L
.96349 .21553 2.37764 .77254 Mabsadd L
.96349 .21553 .56518 .7779 Mabsadd L
.96349 .21553 0 2.5 Mabsadd L closepath F
.96667 .21544 0 2.5 Mabsadd m
.96667 .21544 -0.56518 .7779 Mabsadd L
.96667 .21544 -2.37764 .77254 Mabsadd L
.96667 .21544 -0.91448 -0.29713 Mabsadd L
.96667 .21544 -1.46946 -2.02254 Mabsadd L
.96667 .21544 0 -0.96154 Mabsadd L
.96667 .21544 1.46946 -2.02254 Mabsadd L
.96667 .21544 .91448 -0.29713 Mabsadd L
.96667 .21544 2.37764 .77254 Mabsadd L
.96667 .21544 .56518 .7779 Mabsadd L
.96667 .21544 0 2.5 Mabsadd L closepath F
.96984 .21534 0 2.5 Mabsadd m
.96984 .21534 -0.56518 .7779 Mabsadd L
.96984 .21534 -2.37764 .77254 Mabsadd L
.96984 .21534 -0.91448 -0.29713 Mabsadd L
.96984 .21534 -1.46946 -2.02254 Mabsadd L
.96984 .21534 0 -0.96154 Mabsadd L
.96984 .21534 1.46946 -2.02254 Mabsadd L
.96984 .21534 .91448 -0.29713 Mabsadd L
.96984 .21534 2.37764 .77254 Mabsadd L
.96984 .21534 .56518 .7779 Mabsadd L
.96984 .21534 0 2.5 Mabsadd L closepath F
.97302 .21524 0 2.5 Mabsadd m
.97302 .21524 -0.56518 .7779 Mabsadd L
.97302 .21524 -2.37764 .77254 Mabsadd L
.97302 .21524 -0.91448 -0.29713 Mabsadd L
.97302 .21524 -1.46946 -2.02254 Mabsadd L
.97302 .21524 0 -0.96154 Mabsadd L
.97302 .21524 1.46946 -2.02254 Mabsadd L
.97302 .21524 .91448 -0.29713 Mabsadd L
.97302 .21524 2.37764 .77254 Mabsadd L
.97302 .21524 .56518 .7779 Mabsadd L
.97302 .21524 0 2.5 Mabsadd L closepath F
.97619 .21515 0 2.5 Mabsadd m
.97619 .21515 -0.56518 .7779 Mabsadd L
.97619 .21515 -2.37764 .77254 Mabsadd L
.97619 .21515 -0.91448 -0.29713 Mabsadd L
.97619 .21515 -1.46946 -2.02254 Mabsadd L
.97619 .21515 0 -0.96154 Mabsadd L
.97619 .21515 1.46946 -2.02254 Mabsadd L
.97619 .21515 .91448 -0.29713 Mabsadd L
.97619 .21515 2.37764 .77254 Mabsadd L
.97619 .21515 .56518 .7779 Mabsadd L
.97619 .21515 0 2.5 Mabsadd L closepath F
.0075 w
.02698 .58763 m
.03016 .58381 L
.03333 .58003 L
.03651 .57628 L
.03968 .57258 L
.04286 .56891 L
.04603 .56528 L
.04921 .56168 L
.05238 .55812 L
.05556 .5546 L
.05873 .55111 L
.0619 .54765 L
.06508 .54423 L
.06825 .54085 L
.07143 .5375 L
.0746 .53418 L
.07778 .53089 L
.08095 .52764 L
.08413 .52442 L
.0873 .52123 L
.09048 .51808 L
.09365 .51495 L
.09683 .51186 L
.1 .5088 L
.10317 .50577 L
.10635 .50277 L
.10952 .4998 L
.1127 .49686 L
.11587 .49394 L
.11905 .49106 L
.12222 .48821 L
.1254 .48538 L
.12857 .48259 L
.13175 .47982 L
.13492 .47707 L
.1381 .47436 L
.14127 .47167 L
.14444 .46901 L
.14762 .46638 L
.15079 .46377 L
.15397 .46119 L
.15714 .45864 L
.16032 .45611 L
.16349 .4536 L
.16667 .45113 L
.16984 .44867 L
.17302 .44624 L
.17619 .44384 L
.17937 .44145 L
.18254 .4391 L
Mistroke
.18571 .43676 L
.18889 .43445 L
.19206 .43216 L
.19524 .4299 L
.19841 .42766 L
.20159 .42544 L
.20476 .42324 L
.20794 .42106 L
.21111 .41891 L
.21429 .41678 L
.21746 .41467 L
.22063 .41258 L
.22381 .41051 L
.22698 .40846 L
.23016 .40643 L
.23333 .40442 L
.23651 .40244 L
.23968 .40047 L
.24286 .39852 L
.24603 .39659 L
.24921 .39468 L
.25238 .39279 L
.25556 .39092 L
.25873 .38907 L
.2619 .38724 L
.26508 .38542 L
.26825 .38362 L
.27143 .38185 L
.2746 .38008 L
.27778 .37834 L
.28095 .37661 L
.28413 .3749 L
.2873 .37321 L
.29048 .37154 L
.29365 .36988 L
.29683 .36824 L
.3 .36661 L
.30317 .365 L
.30635 .36341 L
.30952 .36183 L
.3127 .36027 L
.31587 .35872 L
.31905 .35719 L
.32222 .35568 L
.3254 .35418 L
.32857 .35269 L
.33175 .35122 L
.33492 .34977 L
.3381 .34833 L
.34127 .3469 L
Mistroke
.34444 .34549 L
.34762 .34409 L
.35079 .34271 L
.35397 .34134 L
.35714 .33998 L
.36032 .33864 L
.36349 .33731 L
.36667 .33599 L
.36984 .33469 L
.37302 .3334 L
.37619 .33212 L
.37937 .33086 L
.38254 .3296 L
.38571 .32837 L
.38889 .32714 L
.39206 .32592 L
.39524 .32472 L
.39841 .32353 L
.40159 .32235 L
.40476 .32119 L
.40794 .32003 L
.41111 .31889 L
.41429 .31776 L
.41746 .31664 L
.42063 .31553 L
.42381 .31443 L
.42698 .31334 L
.43016 .31226 L
.43333 .3112 L
.43651 .31014 L
.43968 .3091 L
.44286 .30806 L
.44603 .30704 L
.44921 .30603 L
.45238 .30502 L
.45556 .30403 L
.45873 .30305 L
.4619 .30207 L
.46508 .30111 L
.46825 .30015 L
.47143 .29921 L
.4746 .29827 L
.47778 .29735 L
.48095 .29643 L
.48413 .29552 L
.4873 .29463 L
.49048 .29374 L
.49365 .29286 L
.49683 .29198 L
.5 .29112 L
Mistroke
.50317 .29027 L
.50635 .28942 L
.50952 .28858 L
.5127 .28775 L
.51587 .28693 L
.51905 .28612 L
.52222 .28532 L
.5254 .28452 L
.52857 .28373 L
.53175 .28295 L
.53492 .28218 L
.5381 .28141 L
.54127 .28066 L
.54444 .27991 L
.54762 .27917 L
.55079 .27843 L
.55397 .2777 L
.55714 .27698 L
.56032 .27627 L
.56349 .27556 L
.56667 .27487 L
.56984 .27417 L
.57302 .27349 L
.57619 .27281 L
.57937 .27214 L
.58254 .27147 L
.58571 .27082 L
.58889 .27017 L
.59206 .26952 L
.59524 .26888 L
.59841 .26825 L
.60159 .26762 L
.60476 .26701 L
.60794 .26639 L
.61111 .26579 L
.61429 .26518 L
.61746 .26459 L
.62063 .264 L
.62381 .26342 L
.62698 .26284 L
.63016 .26227 L
.63333 .2617 L
.63651 .26114 L
.63968 .26059 L
.64286 .26004 L
.64603 .2595 L
.64921 .25896 L
.65238 .25842 L
.65556 .2579 L
.65873 .25737 L
Mistroke
.6619 .25686 L
.66508 .25635 L
.66825 .25584 L
.67143 .25534 L
.6746 .25484 L
.67778 .25435 L
.68095 .25386 L
.68413 .25338 L
.6873 .2529 L
.69048 .25243 L
.69365 .25196 L
.69683 .2515 L
.7 .25104 L
.70317 .25059 L
.70635 .25014 L
.70952 .2497 L
.7127 .24926 L
.71587 .24882 L
.71905 .24839 L
.72222 .24796 L
.7254 .24754 L
.72857 .24712 L
.73175 .24671 L
.73492 .2463 L
.7381 .24589 L
.74127 .24549 L
.74444 .24509 L
.74762 .2447 L
.75079 .24431 L
.75397 .24392 L
.75714 .24354 L
.76032 .24316 L
.76349 .24278 L
.76667 .24241 L
.76984 .24205 L
.77302 .24168 L
.77619 .24132 L
.77937 .24097 L
.78254 .24061 L
.78571 .24026 L
.78889 .23992 L
.79206 .23958 L
.79524 .23924 L
.79841 .2389 L
.80159 .23857 L
.80476 .23824 L
.80794 .23792 L
.81111 .23759 L
.81429 .23727 L
.81746 .23696 L
Mistroke
.82063 .23665 L
.82381 .23634 L
.82698 .23603 L
.83016 .23573 L
.83333 .23543 L
.83651 .23513 L
.83968 .23483 L
.84286 .23454 L
.84603 .23425 L
.84921 .23397 L
.85238 .23368 L
.85556 .2334 L
.85873 .23313 L
.8619 .23285 L
.86508 .23258 L
.86825 .23231 L
.87143 .23205 L
.8746 .23178 L
.87778 .23152 L
.88095 .23126 L
.88413 .23101 L
.8873 .23075 L
.89048 .2305 L
.89365 .23026 L
.89683 .23001 L
.9 .22977 L
.90317 .22953 L
.90635 .22929 L
.90952 .22905 L
.9127 .22882 L
.91587 .22859 L
.91905 .22836 L
.92222 .22813 L
.9254 .22791 L
.92857 .22768 L
.93175 .22746 L
.93492 .22725 L
.9381 .22703 L
.94127 .22682 L
.94444 .22661 L
.94762 .2264 L
.95079 .22619 L
.95397 .22598 L
.95714 .22578 L
.96032 .22558 L
.96349 .22538 L
.96667 .22518 L
.96984 .22499 L
.97302 .2248 L
.97619 .22461 L
Mistroke
Mfstroke
.0001 w
.02698 .58763 -2.5 2.5 Mabsadd m
.02698 .58763 2.5 2.5 Mabsadd L
.02698 .58763 2.5 -2.5 Mabsadd L
.02698 .58763 -2.5 -2.5 Mabsadd L
.02698 .58763 -2.5 2.5 Mabsadd L closepath F
.03016 .58381 -2.5 2.5 Mabsadd m
.03016 .58381 2.5 2.5 Mabsadd L
.03016 .58381 2.5 -2.5 Mabsadd L
.03016 .58381 -2.5 -2.5 Mabsadd L
.03016 .58381 -2.5 2.5 Mabsadd L closepath F
.03333 .58003 -2.5 2.5 Mabsadd m
.03333 .58003 2.5 2.5 Mabsadd L
.03333 .58003 2.5 -2.5 Mabsadd L
.03333 .58003 -2.5 -2.5 Mabsadd L
.03333 .58003 -2.5 2.5 Mabsadd L closepath F
.03651 .57628 -2.5 2.5 Mabsadd m
.03651 .57628 2.5 2.5 Mabsadd L
.03651 .57628 2.5 -2.5 Mabsadd L
.03651 .57628 -2.5 -2.5 Mabsadd L
.03651 .57628 -2.5 2.5 Mabsadd L closepath F
.03968 .57258 -2.5 2.5 Mabsadd m
.03968 .57258 2.5 2.5 Mabsadd L
.03968 .57258 2.5 -2.5 Mabsadd L
.03968 .57258 -2.5 -2.5 Mabsadd L
.03968 .57258 -2.5 2.5 Mabsadd L closepath F
.04286 .56891 -2.5 2.5 Mabsadd m
.04286 .56891 2.5 2.5 Mabsadd L
.04286 .56891 2.5 -2.5 Mabsadd L
.04286 .56891 -2.5 -2.5 Mabsadd L
.04286 .56891 -2.5 2.5 Mabsadd L closepath F
.04603 .56528 -2.5 2.5 Mabsadd m
.04603 .56528 2.5 2.5 Mabsadd L
.04603 .56528 2.5 -2.5 Mabsadd L
.04603 .56528 -2.5 -2.5 Mabsadd L
.04603 .56528 -2.5 2.5 Mabsadd L closepath F
.04921 .56168 -2.5 2.5 Mabsadd m
.04921 .56168 2.5 2.5 Mabsadd L
.04921 .56168 2.5 -2.5 Mabsadd L
.04921 .56168 -2.5 -2.5 Mabsadd L
.04921 .56168 -2.5 2.5 Mabsadd L closepath F
.05238 .55812 -2.5 2.5 Mabsadd m
.05238 .55812 2.5 2.5 Mabsadd L
.05238 .55812 2.5 -2.5 Mabsadd L
.05238 .55812 -2.5 -2.5 Mabsadd L
.05238 .55812 -2.5 2.5 Mabsadd L closepath F
.05556 .5546 -2.5 2.5 Mabsadd m
.05556 .5546 2.5 2.5 Mabsadd L
.05556 .5546 2.5 -2.5 Mabsadd L
.05556 .5546 -2.5 -2.5 Mabsadd L
.05556 .5546 -2.5 2.5 Mabsadd L closepath F
.05873 .55111 -2.5 2.5 Mabsadd m
.05873 .55111 2.5 2.5 Mabsadd L
.05873 .55111 2.5 -2.5 Mabsadd L
.05873 .55111 -2.5 -2.5 Mabsadd L
.05873 .55111 -2.5 2.5 Mabsadd L closepath F
.0619 .54765 -2.5 2.5 Mabsadd m
.0619 .54765 2.5 2.5 Mabsadd L
.0619 .54765 2.5 -2.5 Mabsadd L
.0619 .54765 -2.5 -2.5 Mabsadd L
.0619 .54765 -2.5 2.5 Mabsadd L closepath F
.06508 .54423 -2.5 2.5 Mabsadd m
.06508 .54423 2.5 2.5 Mabsadd L
.06508 .54423 2.5 -2.5 Mabsadd L
.06508 .54423 -2.5 -2.5 Mabsadd L
.06508 .54423 -2.5 2.5 Mabsadd L closepath F
.06825 .54085 -2.5 2.5 Mabsadd m
.06825 .54085 2.5 2.5 Mabsadd L
.06825 .54085 2.5 -2.5 Mabsadd L
.06825 .54085 -2.5 -2.5 Mabsadd L
.06825 .54085 -2.5 2.5 Mabsadd L closepath F
.07143 .5375 -2.5 2.5 Mabsadd m
.07143 .5375 2.5 2.5 Mabsadd L
.07143 .5375 2.5 -2.5 Mabsadd L
.07143 .5375 -2.5 -2.5 Mabsadd L
.07143 .5375 -2.5 2.5 Mabsadd L closepath F
.0746 .53418 -2.5 2.5 Mabsadd m
.0746 .53418 2.5 2.5 Mabsadd L
.0746 .53418 2.5 -2.5 Mabsadd L
.0746 .53418 -2.5 -2.5 Mabsadd L
.0746 .53418 -2.5 2.5 Mabsadd L closepath F
.07778 .53089 -2.5 2.5 Mabsadd m
.07778 .53089 2.5 2.5 Mabsadd L
.07778 .53089 2.5 -2.5 Mabsadd L
.07778 .53089 -2.5 -2.5 Mabsadd L
.07778 .53089 -2.5 2.5 Mabsadd L closepath F
.08095 .52764 -2.5 2.5 Mabsadd m
.08095 .52764 2.5 2.5 Mabsadd L
.08095 .52764 2.5 -2.5 Mabsadd L
.08095 .52764 -2.5 -2.5 Mabsadd L
.08095 .52764 -2.5 2.5 Mabsadd L closepath F
.08413 .52442 -2.5 2.5 Mabsadd m
.08413 .52442 2.5 2.5 Mabsadd L
.08413 .52442 2.5 -2.5 Mabsadd L
.08413 .52442 -2.5 -2.5 Mabsadd L
.08413 .52442 -2.5 2.5 Mabsadd L closepath F
.0873 .52123 -2.5 2.5 Mabsadd m
.0873 .52123 2.5 2.5 Mabsadd L
.0873 .52123 2.5 -2.5 Mabsadd L
.0873 .52123 -2.5 -2.5 Mabsadd L
.0873 .52123 -2.5 2.5 Mabsadd L closepath F
.09048 .51808 -2.5 2.5 Mabsadd m
.09048 .51808 2.5 2.5 Mabsadd L
.09048 .51808 2.5 -2.5 Mabsadd L
.09048 .51808 -2.5 -2.5 Mabsadd L
.09048 .51808 -2.5 2.5 Mabsadd L closepath F
.09365 .51495 -2.5 2.5 Mabsadd m
.09365 .51495 2.5 2.5 Mabsadd L
.09365 .51495 2.5 -2.5 Mabsadd L
.09365 .51495 -2.5 -2.5 Mabsadd L
.09365 .51495 -2.5 2.5 Mabsadd L closepath F
.09683 .51186 -2.5 2.5 Mabsadd m
.09683 .51186 2.5 2.5 Mabsadd L
.09683 .51186 2.5 -2.5 Mabsadd L
.09683 .51186 -2.5 -2.5 Mabsadd L
.09683 .51186 -2.5 2.5 Mabsadd L closepath F
.1 .5088 -2.5 2.5 Mabsadd m
.1 .5088 2.5 2.5 Mabsadd L
.1 .5088 2.5 -2.5 Mabsadd L
.1 .5088 -2.5 -2.5 Mabsadd L
.1 .5088 -2.5 2.5 Mabsadd L closepath F
.10317 .50577 -2.5 2.5 Mabsadd m
.10317 .50577 2.5 2.5 Mabsadd L
.10317 .50577 2.5 -2.5 Mabsadd L
.10317 .50577 -2.5 -2.5 Mabsadd L
.10317 .50577 -2.5 2.5 Mabsadd L closepath F
.10635 .50277 -2.5 2.5 Mabsadd m
.10635 .50277 2.5 2.5 Mabsadd L
.10635 .50277 2.5 -2.5 Mabsadd L
.10635 .50277 -2.5 -2.5 Mabsadd L
.10635 .50277 -2.5 2.5 Mabsadd L closepath F
.10952 .4998 -2.5 2.5 Mabsadd m
.10952 .4998 2.5 2.5 Mabsadd L
.10952 .4998 2.5 -2.5 Mabsadd L
.10952 .4998 -2.5 -2.5 Mabsadd L
.10952 .4998 -2.5 2.5 Mabsadd L closepath F
.1127 .49686 -2.5 2.5 Mabsadd m
.1127 .49686 2.5 2.5 Mabsadd L
.1127 .49686 2.5 -2.5 Mabsadd L
.1127 .49686 -2.5 -2.5 Mabsadd L
.1127 .49686 -2.5 2.5 Mabsadd L closepath F
.11587 .49394 -2.5 2.5 Mabsadd m
.11587 .49394 2.5 2.5 Mabsadd L
.11587 .49394 2.5 -2.5 Mabsadd L
.11587 .49394 -2.5 -2.5 Mabsadd L
.11587 .49394 -2.5 2.5 Mabsadd L closepath F
.11905 .49106 -2.5 2.5 Mabsadd m
.11905 .49106 2.5 2.5 Mabsadd L
.11905 .49106 2.5 -2.5 Mabsadd L
.11905 .49106 -2.5 -2.5 Mabsadd L
.11905 .49106 -2.5 2.5 Mabsadd L closepath F
.12222 .48821 -2.5 2.5 Mabsadd m
.12222 .48821 2.5 2.5 Mabsadd L
.12222 .48821 2.5 -2.5 Mabsadd L
.12222 .48821 -2.5 -2.5 Mabsadd L
.12222 .48821 -2.5 2.5 Mabsadd L closepath F
.1254 .48538 -2.5 2.5 Mabsadd m
.1254 .48538 2.5 2.5 Mabsadd L
.1254 .48538 2.5 -2.5 Mabsadd L
.1254 .48538 -2.5 -2.5 Mabsadd L
.1254 .48538 -2.5 2.5 Mabsadd L closepath F
.12857 .48259 -2.5 2.5 Mabsadd m
.12857 .48259 2.5 2.5 Mabsadd L
.12857 .48259 2.5 -2.5 Mabsadd L
.12857 .48259 -2.5 -2.5 Mabsadd L
.12857 .48259 -2.5 2.5 Mabsadd L closepath F
.13175 .47982 -2.5 2.5 Mabsadd m
.13175 .47982 2.5 2.5 Mabsadd L
.13175 .47982 2.5 -2.5 Mabsadd L
.13175 .47982 -2.5 -2.5 Mabsadd L
.13175 .47982 -2.5 2.5 Mabsadd L closepath F
.13492 .47707 -2.5 2.5 Mabsadd m
.13492 .47707 2.5 2.5 Mabsadd L
.13492 .47707 2.5 -2.5 Mabsadd L
.13492 .47707 -2.5 -2.5 Mabsadd L
.13492 .47707 -2.5 2.5 Mabsadd L closepath F
.1381 .47436 -2.5 2.5 Mabsadd m
.1381 .47436 2.5 2.5 Mabsadd L
.1381 .47436 2.5 -2.5 Mabsadd L
.1381 .47436 -2.5 -2.5 Mabsadd L
.1381 .47436 -2.5 2.5 Mabsadd L closepath F
.14127 .47167 -2.5 2.5 Mabsadd m
.14127 .47167 2.5 2.5 Mabsadd L
.14127 .47167 2.5 -2.5 Mabsadd L
.14127 .47167 -2.5 -2.5 Mabsadd L
.14127 .47167 -2.5 2.5 Mabsadd L closepath F
.14444 .46901 -2.5 2.5 Mabsadd m
.14444 .46901 2.5 2.5 Mabsadd L
.14444 .46901 2.5 -2.5 Mabsadd L
.14444 .46901 -2.5 -2.5 Mabsadd L
.14444 .46901 -2.5 2.5 Mabsadd L closepath F
.14762 .46638 -2.5 2.5 Mabsadd m
.14762 .46638 2.5 2.5 Mabsadd L
.14762 .46638 2.5 -2.5 Mabsadd L
.14762 .46638 -2.5 -2.5 Mabsadd L
.14762 .46638 -2.5 2.5 Mabsadd L closepath F
.15079 .46377 -2.5 2.5 Mabsadd m
.15079 .46377 2.5 2.5 Mabsadd L
.15079 .46377 2.5 -2.5 Mabsadd L
.15079 .46377 -2.5 -2.5 Mabsadd L
.15079 .46377 -2.5 2.5 Mabsadd L closepath F
.15397 .46119 -2.5 2.5 Mabsadd m
.15397 .46119 2.5 2.5 Mabsadd L
.15397 .46119 2.5 -2.5 Mabsadd L
.15397 .46119 -2.5 -2.5 Mabsadd L
.15397 .46119 -2.5 2.5 Mabsadd L closepath F
.15714 .45864 -2.5 2.5 Mabsadd m
.15714 .45864 2.5 2.5 Mabsadd L
.15714 .45864 2.5 -2.5 Mabsadd L
.15714 .45864 -2.5 -2.5 Mabsadd L
.15714 .45864 -2.5 2.5 Mabsadd L closepath F
.16032 .45611 -2.5 2.5 Mabsadd m
.16032 .45611 2.5 2.5 Mabsadd L
.16032 .45611 2.5 -2.5 Mabsadd L
.16032 .45611 -2.5 -2.5 Mabsadd L
.16032 .45611 -2.5 2.5 Mabsadd L closepath F
.16349 .4536 -2.5 2.5 Mabsadd m
.16349 .4536 2.5 2.5 Mabsadd L
.16349 .4536 2.5 -2.5 Mabsadd L
.16349 .4536 -2.5 -2.5 Mabsadd L
.16349 .4536 -2.5 2.5 Mabsadd L closepath F
.16667 .45113 -2.5 2.5 Mabsadd m
.16667 .45113 2.5 2.5 Mabsadd L
.16667 .45113 2.5 -2.5 Mabsadd L
.16667 .45113 -2.5 -2.5 Mabsadd L
.16667 .45113 -2.5 2.5 Mabsadd L closepath F
.16984 .44867 -2.5 2.5 Mabsadd m
.16984 .44867 2.5 2.5 Mabsadd L
.16984 .44867 2.5 -2.5 Mabsadd L
.16984 .44867 -2.5 -2.5 Mabsadd L
.16984 .44867 -2.5 2.5 Mabsadd L closepath F
.17302 .44624 -2.5 2.5 Mabsadd m
.17302 .44624 2.5 2.5 Mabsadd L
.17302 .44624 2.5 -2.5 Mabsadd L
.17302 .44624 -2.5 -2.5 Mabsadd L
.17302 .44624 -2.5 2.5 Mabsadd L closepath F
.17619 .44384 -2.5 2.5 Mabsadd m
.17619 .44384 2.5 2.5 Mabsadd L
.17619 .44384 2.5 -2.5 Mabsadd L
.17619 .44384 -2.5 -2.5 Mabsadd L
.17619 .44384 -2.5 2.5 Mabsadd L closepath F
.17937 .44145 -2.5 2.5 Mabsadd m
.17937 .44145 2.5 2.5 Mabsadd L
.17937 .44145 2.5 -2.5 Mabsadd L
.17937 .44145 -2.5 -2.5 Mabsadd L
.17937 .44145 -2.5 2.5 Mabsadd L closepath F
.18254 .4391 -2.5 2.5 Mabsadd m
.18254 .4391 2.5 2.5 Mabsadd L
.18254 .4391 2.5 -2.5 Mabsadd L
.18254 .4391 -2.5 -2.5 Mabsadd L
.18254 .4391 -2.5 2.5 Mabsadd L closepath F
.18571 .43676 -2.5 2.5 Mabsadd m
.18571 .43676 2.5 2.5 Mabsadd L
.18571 .43676 2.5 -2.5 Mabsadd L
.18571 .43676 -2.5 -2.5 Mabsadd L
.18571 .43676 -2.5 2.5 Mabsadd L closepath F
.18889 .43445 -2.5 2.5 Mabsadd m
.18889 .43445 2.5 2.5 Mabsadd L
.18889 .43445 2.5 -2.5 Mabsadd L
.18889 .43445 -2.5 -2.5 Mabsadd L
.18889 .43445 -2.5 2.5 Mabsadd L closepath F
.19206 .43216 -2.5 2.5 Mabsadd m
.19206 .43216 2.5 2.5 Mabsadd L
.19206 .43216 2.5 -2.5 Mabsadd L
.19206 .43216 -2.5 -2.5 Mabsadd L
.19206 .43216 -2.5 2.5 Mabsadd L closepath F
.19524 .4299 -2.5 2.5 Mabsadd m
.19524 .4299 2.5 2.5 Mabsadd L
.19524 .4299 2.5 -2.5 Mabsadd L
.19524 .4299 -2.5 -2.5 Mabsadd L
.19524 .4299 -2.5 2.5 Mabsadd L closepath F
.19841 .42766 -2.5 2.5 Mabsadd m
.19841 .42766 2.5 2.5 Mabsadd L
.19841 .42766 2.5 -2.5 Mabsadd L
.19841 .42766 -2.5 -2.5 Mabsadd L
.19841 .42766 -2.5 2.5 Mabsadd L closepath F
.20159 .42544 -2.5 2.5 Mabsadd m
.20159 .42544 2.5 2.5 Mabsadd L
.20159 .42544 2.5 -2.5 Mabsadd L
.20159 .42544 -2.5 -2.5 Mabsadd L
.20159 .42544 -2.5 2.5 Mabsadd L closepath F
.20476 .42324 -2.5 2.5 Mabsadd m
.20476 .42324 2.5 2.5 Mabsadd L
.20476 .42324 2.5 -2.5 Mabsadd L
.20476 .42324 -2.5 -2.5 Mabsadd L
.20476 .42324 -2.5 2.5 Mabsadd L closepath F
.20794 .42106 -2.5 2.5 Mabsadd m
.20794 .42106 2.5 2.5 Mabsadd L
.20794 .42106 2.5 -2.5 Mabsadd L
.20794 .42106 -2.5 -2.5 Mabsadd L
.20794 .42106 -2.5 2.5 Mabsadd L closepath F
.21111 .41891 -2.5 2.5 Mabsadd m
.21111 .41891 2.5 2.5 Mabsadd L
.21111 .41891 2.5 -2.5 Mabsadd L
.21111 .41891 -2.5 -2.5 Mabsadd L
.21111 .41891 -2.5 2.5 Mabsadd L closepath F
.21429 .41678 -2.5 2.5 Mabsadd m
.21429 .41678 2.5 2.5 Mabsadd L
.21429 .41678 2.5 -2.5 Mabsadd L
.21429 .41678 -2.5 -2.5 Mabsadd L
.21429 .41678 -2.5 2.5 Mabsadd L closepath F
.21746 .41467 -2.5 2.5 Mabsadd m
.21746 .41467 2.5 2.5 Mabsadd L
.21746 .41467 2.5 -2.5 Mabsadd L
.21746 .41467 -2.5 -2.5 Mabsadd L
.21746 .41467 -2.5 2.5 Mabsadd L closepath F
.22063 .41258 -2.5 2.5 Mabsadd m
.22063 .41258 2.5 2.5 Mabsadd L
.22063 .41258 2.5 -2.5 Mabsadd L
.22063 .41258 -2.5 -2.5 Mabsadd L
.22063 .41258 -2.5 2.5 Mabsadd L closepath F
.22381 .41051 -2.5 2.5 Mabsadd m
.22381 .41051 2.5 2.5 Mabsadd L
.22381 .41051 2.5 -2.5 Mabsadd L
.22381 .41051 -2.5 -2.5 Mabsadd L
.22381 .41051 -2.5 2.5 Mabsadd L closepath F
.22698 .40846 -2.5 2.5 Mabsadd m
.22698 .40846 2.5 2.5 Mabsadd L
.22698 .40846 2.5 -2.5 Mabsadd L
.22698 .40846 -2.5 -2.5 Mabsadd L
.22698 .40846 -2.5 2.5 Mabsadd L closepath F
.23016 .40643 -2.5 2.5 Mabsadd m
.23016 .40643 2.5 2.5 Mabsadd L
.23016 .40643 2.5 -2.5 Mabsadd L
.23016 .40643 -2.5 -2.5 Mabsadd L
.23016 .40643 -2.5 2.5 Mabsadd L closepath F
.23333 .40442 -2.5 2.5 Mabsadd m
.23333 .40442 2.5 2.5 Mabsadd L
.23333 .40442 2.5 -2.5 Mabsadd L
.23333 .40442 -2.5 -2.5 Mabsadd L
.23333 .40442 -2.5 2.5 Mabsadd L closepath F
.23651 .40244 -2.5 2.5 Mabsadd m
.23651 .40244 2.5 2.5 Mabsadd L
.23651 .40244 2.5 -2.5 Mabsadd L
.23651 .40244 -2.5 -2.5 Mabsadd L
.23651 .40244 -2.5 2.5 Mabsadd L closepath F
.23968 .40047 -2.5 2.5 Mabsadd m
.23968 .40047 2.5 2.5 Mabsadd L
.23968 .40047 2.5 -2.5 Mabsadd L
.23968 .40047 -2.5 -2.5 Mabsadd L
.23968 .40047 -2.5 2.5 Mabsadd L closepath F
.24286 .39852 -2.5 2.5 Mabsadd m
.24286 .39852 2.5 2.5 Mabsadd L
.24286 .39852 2.5 -2.5 Mabsadd L
.24286 .39852 -2.5 -2.5 Mabsadd L
.24286 .39852 -2.5 2.5 Mabsadd L closepath F
.24603 .39659 -2.5 2.5 Mabsadd m
.24603 .39659 2.5 2.5 Mabsadd L
.24603 .39659 2.5 -2.5 Mabsadd L
.24603 .39659 -2.5 -2.5 Mabsadd L
.24603 .39659 -2.5 2.5 Mabsadd L closepath F
.24921 .39468 -2.5 2.5 Mabsadd m
.24921 .39468 2.5 2.5 Mabsadd L
.24921 .39468 2.5 -2.5 Mabsadd L
.24921 .39468 -2.5 -2.5 Mabsadd L
.24921 .39468 -2.5 2.5 Mabsadd L closepath F
.25238 .39279 -2.5 2.5 Mabsadd m
.25238 .39279 2.5 2.5 Mabsadd L
.25238 .39279 2.5 -2.5 Mabsadd L
.25238 .39279 -2.5 -2.5 Mabsadd L
.25238 .39279 -2.5 2.5 Mabsadd L closepath F
.25556 .39092 -2.5 2.5 Mabsadd m
.25556 .39092 2.5 2.5 Mabsadd L
.25556 .39092 2.5 -2.5 Mabsadd L
.25556 .39092 -2.5 -2.5 Mabsadd L
.25556 .39092 -2.5 2.5 Mabsadd L closepath F
.25873 .38907 -2.5 2.5 Mabsadd m
.25873 .38907 2.5 2.5 Mabsadd L
.25873 .38907 2.5 -2.5 Mabsadd L
.25873 .38907 -2.5 -2.5 Mabsadd L
.25873 .38907 -2.5 2.5 Mabsadd L closepath F
.2619 .38724 -2.5 2.5 Mabsadd m
.2619 .38724 2.5 2.5 Mabsadd L
.2619 .38724 2.5 -2.5 Mabsadd L
.2619 .38724 -2.5 -2.5 Mabsadd L
.2619 .38724 -2.5 2.5 Mabsadd L closepath F
.26508 .38542 -2.5 2.5 Mabsadd m
.26508 .38542 2.5 2.5 Mabsadd L
.26508 .38542 2.5 -2.5 Mabsadd L
.26508 .38542 -2.5 -2.5 Mabsadd L
.26508 .38542 -2.5 2.5 Mabsadd L closepath F
.26825 .38362 -2.5 2.5 Mabsadd m
.26825 .38362 2.5 2.5 Mabsadd L
.26825 .38362 2.5 -2.5 Mabsadd L
.26825 .38362 -2.5 -2.5 Mabsadd L
.26825 .38362 -2.5 2.5 Mabsadd L closepath F
.27143 .38185 -2.5 2.5 Mabsadd m
.27143 .38185 2.5 2.5 Mabsadd L
.27143 .38185 2.5 -2.5 Mabsadd L
.27143 .38185 -2.5 -2.5 Mabsadd L
.27143 .38185 -2.5 2.5 Mabsadd L closepath F
.2746 .38008 -2.5 2.5 Mabsadd m
.2746 .38008 2.5 2.5 Mabsadd L
.2746 .38008 2.5 -2.5 Mabsadd L
.2746 .38008 -2.5 -2.5 Mabsadd L
.2746 .38008 -2.5 2.5 Mabsadd L closepath F
.27778 .37834 -2.5 2.5 Mabsadd m
.27778 .37834 2.5 2.5 Mabsadd L
.27778 .37834 2.5 -2.5 Mabsadd L
.27778 .37834 -2.5 -2.5 Mabsadd L
.27778 .37834 -2.5 2.5 Mabsadd L closepath F
.28095 .37661 -2.5 2.5 Mabsadd m
.28095 .37661 2.5 2.5 Mabsadd L
.28095 .37661 2.5 -2.5 Mabsadd L
.28095 .37661 -2.5 -2.5 Mabsadd L
.28095 .37661 -2.5 2.5 Mabsadd L closepath F
.28413 .3749 -2.5 2.5 Mabsadd m
.28413 .3749 2.5 2.5 Mabsadd L
.28413 .3749 2.5 -2.5 Mabsadd L
.28413 .3749 -2.5 -2.5 Mabsadd L
.28413 .3749 -2.5 2.5 Mabsadd L closepath F
.2873 .37321 -2.5 2.5 Mabsadd m
.2873 .37321 2.5 2.5 Mabsadd L
.2873 .37321 2.5 -2.5 Mabsadd L
.2873 .37321 -2.5 -2.5 Mabsadd L
.2873 .37321 -2.5 2.5 Mabsadd L closepath F
.29048 .37154 -2.5 2.5 Mabsadd m
.29048 .37154 2.5 2.5 Mabsadd L
.29048 .37154 2.5 -2.5 Mabsadd L
.29048 .37154 -2.5 -2.5 Mabsadd L
.29048 .37154 -2.5 2.5 Mabsadd L closepath F
.29365 .36988 -2.5 2.5 Mabsadd m
.29365 .36988 2.5 2.5 Mabsadd L
.29365 .36988 2.5 -2.5 Mabsadd L
.29365 .36988 -2.5 -2.5 Mabsadd L
.29365 .36988 -2.5 2.5 Mabsadd L closepath F
.29683 .36824 -2.5 2.5 Mabsadd m
.29683 .36824 2.5 2.5 Mabsadd L
.29683 .36824 2.5 -2.5 Mabsadd L
.29683 .36824 -2.5 -2.5 Mabsadd L
.29683 .36824 -2.5 2.5 Mabsadd L closepath F
.3 .36661 -2.5 2.5 Mabsadd m
.3 .36661 2.5 2.5 Mabsadd L
.3 .36661 2.5 -2.5 Mabsadd L
.3 .36661 -2.5 -2.5 Mabsadd L
.3 .36661 -2.5 2.5 Mabsadd L closepath F
.30317 .365 -2.5 2.5 Mabsadd m
.30317 .365 2.5 2.5 Mabsadd L
.30317 .365 2.5 -2.5 Mabsadd L
.30317 .365 -2.5 -2.5 Mabsadd L
.30317 .365 -2.5 2.5 Mabsadd L closepath F
.30635 .36341 -2.5 2.5 Mabsadd m
.30635 .36341 2.5 2.5 Mabsadd L
.30635 .36341 2.5 -2.5 Mabsadd L
.30635 .36341 -2.5 -2.5 Mabsadd L
.30635 .36341 -2.5 2.5 Mabsadd L closepath F
.30952 .36183 -2.5 2.5 Mabsadd m
.30952 .36183 2.5 2.5 Mabsadd L
.30952 .36183 2.5 -2.5 Mabsadd L
.30952 .36183 -2.5 -2.5 Mabsadd L
.30952 .36183 -2.5 2.5 Mabsadd L closepath F
.3127 .36027 -2.5 2.5 Mabsadd m
.3127 .36027 2.5 2.5 Mabsadd L
.3127 .36027 2.5 -2.5 Mabsadd L
.3127 .36027 -2.5 -2.5 Mabsadd L
.3127 .36027 -2.5 2.5 Mabsadd L closepath F
.31587 .35872 -2.5 2.5 Mabsadd m
.31587 .35872 2.5 2.5 Mabsadd L
.31587 .35872 2.5 -2.5 Mabsadd L
.31587 .35872 -2.5 -2.5 Mabsadd L
.31587 .35872 -2.5 2.5 Mabsadd L closepath F
.31905 .35719 -2.5 2.5 Mabsadd m
.31905 .35719 2.5 2.5 Mabsadd L
.31905 .35719 2.5 -2.5 Mabsadd L
.31905 .35719 -2.5 -2.5 Mabsadd L
.31905 .35719 -2.5 2.5 Mabsadd L closepath F
.32222 .35568 -2.5 2.5 Mabsadd m
.32222 .35568 2.5 2.5 Mabsadd L
.32222 .35568 2.5 -2.5 Mabsadd L
.32222 .35568 -2.5 -2.5 Mabsadd L
.32222 .35568 -2.5 2.5 Mabsadd L closepath F
.3254 .35418 -2.5 2.5 Mabsadd m
.3254 .35418 2.5 2.5 Mabsadd L
.3254 .35418 2.5 -2.5 Mabsadd L
.3254 .35418 -2.5 -2.5 Mabsadd L
.3254 .35418 -2.5 2.5 Mabsadd L closepath F
.32857 .35269 -2.5 2.5 Mabsadd m
.32857 .35269 2.5 2.5 Mabsadd L
.32857 .35269 2.5 -2.5 Mabsadd L
.32857 .35269 -2.5 -2.5 Mabsadd L
.32857 .35269 -2.5 2.5 Mabsadd L closepath F
.33175 .35122 -2.5 2.5 Mabsadd m
.33175 .35122 2.5 2.5 Mabsadd L
.33175 .35122 2.5 -2.5 Mabsadd L
.33175 .35122 -2.5 -2.5 Mabsadd L
.33175 .35122 -2.5 2.5 Mabsadd L closepath F
.33492 .34977 -2.5 2.5 Mabsadd m
.33492 .34977 2.5 2.5 Mabsadd L
.33492 .34977 2.5 -2.5 Mabsadd L
.33492 .34977 -2.5 -2.5 Mabsadd L
.33492 .34977 -2.5 2.5 Mabsadd L closepath F
.3381 .34833 -2.5 2.5 Mabsadd m
.3381 .34833 2.5 2.5 Mabsadd L
.3381 .34833 2.5 -2.5 Mabsadd L
.3381 .34833 -2.5 -2.5 Mabsadd L
.3381 .34833 -2.5 2.5 Mabsadd L closepath F
.34127 .3469 -2.5 2.5 Mabsadd m
.34127 .3469 2.5 2.5 Mabsadd L
.34127 .3469 2.5 -2.5 Mabsadd L
.34127 .3469 -2.5 -2.5 Mabsadd L
.34127 .3469 -2.5 2.5 Mabsadd L closepath F
.34444 .34549 -2.5 2.5 Mabsadd m
.34444 .34549 2.5 2.5 Mabsadd L
.34444 .34549 2.5 -2.5 Mabsadd L
.34444 .34549 -2.5 -2.5 Mabsadd L
.34444 .34549 -2.5 2.5 Mabsadd L closepath F
.34762 .34409 -2.5 2.5 Mabsadd m
.34762 .34409 2.5 2.5 Mabsadd L
.34762 .34409 2.5 -2.5 Mabsadd L
.34762 .34409 -2.5 -2.5 Mabsadd L
.34762 .34409 -2.5 2.5 Mabsadd L closepath F
.35079 .34271 -2.5 2.5 Mabsadd m
.35079 .34271 2.5 2.5 Mabsadd L
.35079 .34271 2.5 -2.5 Mabsadd L
.35079 .34271 -2.5 -2.5 Mabsadd L
.35079 .34271 -2.5 2.5 Mabsadd L closepath F
.35397 .34134 -2.5 2.5 Mabsadd m
.35397 .34134 2.5 2.5 Mabsadd L
.35397 .34134 2.5 -2.5 Mabsadd L
.35397 .34134 -2.5 -2.5 Mabsadd L
.35397 .34134 -2.5 2.5 Mabsadd L closepath F
.35714 .33998 -2.5 2.5 Mabsadd m
.35714 .33998 2.5 2.5 Mabsadd L
.35714 .33998 2.5 -2.5 Mabsadd L
.35714 .33998 -2.5 -2.5 Mabsadd L
.35714 .33998 -2.5 2.5 Mabsadd L closepath F
.36032 .33864 -2.5 2.5 Mabsadd m
.36032 .33864 2.5 2.5 Mabsadd L
.36032 .33864 2.5 -2.5 Mabsadd L
.36032 .33864 -2.5 -2.5 Mabsadd L
.36032 .33864 -2.5 2.5 Mabsadd L closepath F
.36349 .33731 -2.5 2.5 Mabsadd m
.36349 .33731 2.5 2.5 Mabsadd L
.36349 .33731 2.5 -2.5 Mabsadd L
.36349 .33731 -2.5 -2.5 Mabsadd L
.36349 .33731 -2.5 2.5 Mabsadd L closepath F
.36667 .33599 -2.5 2.5 Mabsadd m
.36667 .33599 2.5 2.5 Mabsadd L
.36667 .33599 2.5 -2.5 Mabsadd L
.36667 .33599 -2.5 -2.5 Mabsadd L
.36667 .33599 -2.5 2.5 Mabsadd L closepath F
.36984 .33469 -2.5 2.5 Mabsadd m
.36984 .33469 2.5 2.5 Mabsadd L
.36984 .33469 2.5 -2.5 Mabsadd L
.36984 .33469 -2.5 -2.5 Mabsadd L
.36984 .33469 -2.5 2.5 Mabsadd L closepath F
.37302 .3334 -2.5 2.5 Mabsadd m
.37302 .3334 2.5 2.5 Mabsadd L
.37302 .3334 2.5 -2.5 Mabsadd L
.37302 .3334 -2.5 -2.5 Mabsadd L
.37302 .3334 -2.5 2.5 Mabsadd L closepath F
.37619 .33212 -2.5 2.5 Mabsadd m
.37619 .33212 2.5 2.5 Mabsadd L
.37619 .33212 2.5 -2.5 Mabsadd L
.37619 .33212 -2.5 -2.5 Mabsadd L
.37619 .33212 -2.5 2.5 Mabsadd L closepath F
.37937 .33086 -2.5 2.5 Mabsadd m
.37937 .33086 2.5 2.5 Mabsadd L
.37937 .33086 2.5 -2.5 Mabsadd L
.37937 .33086 -2.5 -2.5 Mabsadd L
.37937 .33086 -2.5 2.5 Mabsadd L closepath F
.38254 .3296 -2.5 2.5 Mabsadd m
.38254 .3296 2.5 2.5 Mabsadd L
.38254 .3296 2.5 -2.5 Mabsadd L
.38254 .3296 -2.5 -2.5 Mabsadd L
.38254 .3296 -2.5 2.5 Mabsadd L closepath F
.38571 .32837 -2.5 2.5 Mabsadd m
.38571 .32837 2.5 2.5 Mabsadd L
.38571 .32837 2.5 -2.5 Mabsadd L
.38571 .32837 -2.5 -2.5 Mabsadd L
.38571 .32837 -2.5 2.5 Mabsadd L closepath F
.38889 .32714 -2.5 2.5 Mabsadd m
.38889 .32714 2.5 2.5 Mabsadd L
.38889 .32714 2.5 -2.5 Mabsadd L
.38889 .32714 -2.5 -2.5 Mabsadd L
.38889 .32714 -2.5 2.5 Mabsadd L closepath F
.39206 .32592 -2.5 2.5 Mabsadd m
.39206 .32592 2.5 2.5 Mabsadd L
.39206 .32592 2.5 -2.5 Mabsadd L
.39206 .32592 -2.5 -2.5 Mabsadd L
.39206 .32592 -2.5 2.5 Mabsadd L closepath F
.39524 .32472 -2.5 2.5 Mabsadd m
.39524 .32472 2.5 2.5 Mabsadd L
.39524 .32472 2.5 -2.5 Mabsadd L
.39524 .32472 -2.5 -2.5 Mabsadd L
.39524 .32472 -2.5 2.5 Mabsadd L closepath F
.39841 .32353 -2.5 2.5 Mabsadd m
.39841 .32353 2.5 2.5 Mabsadd L
.39841 .32353 2.5 -2.5 Mabsadd L
.39841 .32353 -2.5 -2.5 Mabsadd L
.39841 .32353 -2.5 2.5 Mabsadd L closepath F
.40159 .32235 -2.5 2.5 Mabsadd m
.40159 .32235 2.5 2.5 Mabsadd L
.40159 .32235 2.5 -2.5 Mabsadd L
.40159 .32235 -2.5 -2.5 Mabsadd L
.40159 .32235 -2.5 2.5 Mabsadd L closepath F
.40476 .32119 -2.5 2.5 Mabsadd m
.40476 .32119 2.5 2.5 Mabsadd L
.40476 .32119 2.5 -2.5 Mabsadd L
.40476 .32119 -2.5 -2.5 Mabsadd L
.40476 .32119 -2.5 2.5 Mabsadd L closepath F
.40794 .32003 -2.5 2.5 Mabsadd m
.40794 .32003 2.5 2.5 Mabsadd L
.40794 .32003 2.5 -2.5 Mabsadd L
.40794 .32003 -2.5 -2.5 Mabsadd L
.40794 .32003 -2.5 2.5 Mabsadd L closepath F
.41111 .31889 -2.5 2.5 Mabsadd m
.41111 .31889 2.5 2.5 Mabsadd L
.41111 .31889 2.5 -2.5 Mabsadd L
.41111 .31889 -2.5 -2.5 Mabsadd L
.41111 .31889 -2.5 2.5 Mabsadd L closepath F
.41429 .31776 -2.5 2.5 Mabsadd m
.41429 .31776 2.5 2.5 Mabsadd L
.41429 .31776 2.5 -2.5 Mabsadd L
.41429 .31776 -2.5 -2.5 Mabsadd L
.41429 .31776 -2.5 2.5 Mabsadd L closepath F
.41746 .31664 -2.5 2.5 Mabsadd m
.41746 .31664 2.5 2.5 Mabsadd L
.41746 .31664 2.5 -2.5 Mabsadd L
.41746 .31664 -2.5 -2.5 Mabsadd L
.41746 .31664 -2.5 2.5 Mabsadd L closepath F
.42063 .31553 -2.5 2.5 Mabsadd m
.42063 .31553 2.5 2.5 Mabsadd L
.42063 .31553 2.5 -2.5 Mabsadd L
.42063 .31553 -2.5 -2.5 Mabsadd L
.42063 .31553 -2.5 2.5 Mabsadd L closepath F
.42381 .31443 -2.5 2.5 Mabsadd m
.42381 .31443 2.5 2.5 Mabsadd L
.42381 .31443 2.5 -2.5 Mabsadd L
.42381 .31443 -2.5 -2.5 Mabsadd L
.42381 .31443 -2.5 2.5 Mabsadd L closepath F
.42698 .31334 -2.5 2.5 Mabsadd m
.42698 .31334 2.5 2.5 Mabsadd L
.42698 .31334 2.5 -2.5 Mabsadd L
.42698 .31334 -2.5 -2.5 Mabsadd L
.42698 .31334 -2.5 2.5 Mabsadd L closepath F
.43016 .31226 -2.5 2.5 Mabsadd m
.43016 .31226 2.5 2.5 Mabsadd L
.43016 .31226 2.5 -2.5 Mabsadd L
.43016 .31226 -2.5 -2.5 Mabsadd L
.43016 .31226 -2.5 2.5 Mabsadd L closepath F
.43333 .3112 -2.5 2.5 Mabsadd m
.43333 .3112 2.5 2.5 Mabsadd L
.43333 .3112 2.5 -2.5 Mabsadd L
.43333 .3112 -2.5 -2.5 Mabsadd L
.43333 .3112 -2.5 2.5 Mabsadd L closepath F
.43651 .31014 -2.5 2.5 Mabsadd m
.43651 .31014 2.5 2.5 Mabsadd L
.43651 .31014 2.5 -2.5 Mabsadd L
.43651 .31014 -2.5 -2.5 Mabsadd L
.43651 .31014 -2.5 2.5 Mabsadd L closepath F
.43968 .3091 -2.5 2.5 Mabsadd m
.43968 .3091 2.5 2.5 Mabsadd L
.43968 .3091 2.5 -2.5 Mabsadd L
.43968 .3091 -2.5 -2.5 Mabsadd L
.43968 .3091 -2.5 2.5 Mabsadd L closepath F
.44286 .30806 -2.5 2.5 Mabsadd m
.44286 .30806 2.5 2.5 Mabsadd L
.44286 .30806 2.5 -2.5 Mabsadd L
.44286 .30806 -2.5 -2.5 Mabsadd L
.44286 .30806 -2.5 2.5 Mabsadd L closepath F
.44603 .30704 -2.5 2.5 Mabsadd m
.44603 .30704 2.5 2.5 Mabsadd L
.44603 .30704 2.5 -2.5 Mabsadd L
.44603 .30704 -2.5 -2.5 Mabsadd L
.44603 .30704 -2.5 2.5 Mabsadd L closepath F
.44921 .30603 -2.5 2.5 Mabsadd m
.44921 .30603 2.5 2.5 Mabsadd L
.44921 .30603 2.5 -2.5 Mabsadd L
.44921 .30603 -2.5 -2.5 Mabsadd L
.44921 .30603 -2.5 2.5 Mabsadd L closepath F
.45238 .30502 -2.5 2.5 Mabsadd m
.45238 .30502 2.5 2.5 Mabsadd L
.45238 .30502 2.5 -2.5 Mabsadd L
.45238 .30502 -2.5 -2.5 Mabsadd L
.45238 .30502 -2.5 2.5 Mabsadd L closepath F
.45556 .30403 -2.5 2.5 Mabsadd m
.45556 .30403 2.5 2.5 Mabsadd L
.45556 .30403 2.5 -2.5 Mabsadd L
.45556 .30403 -2.5 -2.5 Mabsadd L
.45556 .30403 -2.5 2.5 Mabsadd L closepath F
.45873 .30305 -2.5 2.5 Mabsadd m
.45873 .30305 2.5 2.5 Mabsadd L
.45873 .30305 2.5 -2.5 Mabsadd L
.45873 .30305 -2.5 -2.5 Mabsadd L
.45873 .30305 -2.5 2.5 Mabsadd L closepath F
.4619 .30207 -2.5 2.5 Mabsadd m
.4619 .30207 2.5 2.5 Mabsadd L
.4619 .30207 2.5 -2.5 Mabsadd L
.4619 .30207 -2.5 -2.5 Mabsadd L
.4619 .30207 -2.5 2.5 Mabsadd L closepath F
.46508 .30111 -2.5 2.5 Mabsadd m
.46508 .30111 2.5 2.5 Mabsadd L
.46508 .30111 2.5 -2.5 Mabsadd L
.46508 .30111 -2.5 -2.5 Mabsadd L
.46508 .30111 -2.5 2.5 Mabsadd L closepath F
.46825 .30015 -2.5 2.5 Mabsadd m
.46825 .30015 2.5 2.5 Mabsadd L
.46825 .30015 2.5 -2.5 Mabsadd L
.46825 .30015 -2.5 -2.5 Mabsadd L
.46825 .30015 -2.5 2.5 Mabsadd L closepath F
.47143 .29921 -2.5 2.5 Mabsadd m
.47143 .29921 2.5 2.5 Mabsadd L
.47143 .29921 2.5 -2.5 Mabsadd L
.47143 .29921 -2.5 -2.5 Mabsadd L
.47143 .29921 -2.5 2.5 Mabsadd L closepath F
.4746 .29827 -2.5 2.5 Mabsadd m
.4746 .29827 2.5 2.5 Mabsadd L
.4746 .29827 2.5 -2.5 Mabsadd L
.4746 .29827 -2.5 -2.5 Mabsadd L
.4746 .29827 -2.5 2.5 Mabsadd L closepath F
.47778 .29735 -2.5 2.5 Mabsadd m
.47778 .29735 2.5 2.5 Mabsadd L
.47778 .29735 2.5 -2.5 Mabsadd L
.47778 .29735 -2.5 -2.5 Mabsadd L
.47778 .29735 -2.5 2.5 Mabsadd L closepath F
.48095 .29643 -2.5 2.5 Mabsadd m
.48095 .29643 2.5 2.5 Mabsadd L
.48095 .29643 2.5 -2.5 Mabsadd L
.48095 .29643 -2.5 -2.5 Mabsadd L
.48095 .29643 -2.5 2.5 Mabsadd L closepath F
.48413 .29552 -2.5 2.5 Mabsadd m
.48413 .29552 2.5 2.5 Mabsadd L
.48413 .29552 2.5 -2.5 Mabsadd L
.48413 .29552 -2.5 -2.5 Mabsadd L
.48413 .29552 -2.5 2.5 Mabsadd L closepath F
.4873 .29463 -2.5 2.5 Mabsadd m
.4873 .29463 2.5 2.5 Mabsadd L
.4873 .29463 2.5 -2.5 Mabsadd L
.4873 .29463 -2.5 -2.5 Mabsadd L
.4873 .29463 -2.5 2.5 Mabsadd L closepath F
.49048 .29374 -2.5 2.5 Mabsadd m
.49048 .29374 2.5 2.5 Mabsadd L
.49048 .29374 2.5 -2.5 Mabsadd L
.49048 .29374 -2.5 -2.5 Mabsadd L
.49048 .29374 -2.5 2.5 Mabsadd L closepath F
.49365 .29286 -2.5 2.5 Mabsadd m
.49365 .29286 2.5 2.5 Mabsadd L
.49365 .29286 2.5 -2.5 Mabsadd L
.49365 .29286 -2.5 -2.5 Mabsadd L
.49365 .29286 -2.5 2.5 Mabsadd L closepath F
.49683 .29198 -2.5 2.5 Mabsadd m
.49683 .29198 2.5 2.5 Mabsadd L
.49683 .29198 2.5 -2.5 Mabsadd L
.49683 .29198 -2.5 -2.5 Mabsadd L
.49683 .29198 -2.5 2.5 Mabsadd L closepath F
.5 .29112 -2.5 2.5 Mabsadd m
.5 .29112 2.5 2.5 Mabsadd L
.5 .29112 2.5 -2.5 Mabsadd L
.5 .29112 -2.5 -2.5 Mabsadd L
.5 .29112 -2.5 2.5 Mabsadd L closepath F
.50317 .29027 -2.5 2.5 Mabsadd m
.50317 .29027 2.5 2.5 Mabsadd L
.50317 .29027 2.5 -2.5 Mabsadd L
.50317 .29027 -2.5 -2.5 Mabsadd L
.50317 .29027 -2.5 2.5 Mabsadd L closepath F
.50635 .28942 -2.5 2.5 Mabsadd m
.50635 .28942 2.5 2.5 Mabsadd L
.50635 .28942 2.5 -2.5 Mabsadd L
.50635 .28942 -2.5 -2.5 Mabsadd L
.50635 .28942 -2.5 2.5 Mabsadd L closepath F
.50952 .28858 -2.5 2.5 Mabsadd m
.50952 .28858 2.5 2.5 Mabsadd L
.50952 .28858 2.5 -2.5 Mabsadd L
.50952 .28858 -2.5 -2.5 Mabsadd L
.50952 .28858 -2.5 2.5 Mabsadd L closepath F
.5127 .28775 -2.5 2.5 Mabsadd m
.5127 .28775 2.5 2.5 Mabsadd L
.5127 .28775 2.5 -2.5 Mabsadd L
.5127 .28775 -2.5 -2.5 Mabsadd L
.5127 .28775 -2.5 2.5 Mabsadd L closepath F
.51587 .28693 -2.5 2.5 Mabsadd m
.51587 .28693 2.5 2.5 Mabsadd L
.51587 .28693 2.5 -2.5 Mabsadd L
.51587 .28693 -2.5 -2.5 Mabsadd L
.51587 .28693 -2.5 2.5 Mabsadd L closepath F
.51905 .28612 -2.5 2.5 Mabsadd m
.51905 .28612 2.5 2.5 Mabsadd L
.51905 .28612 2.5 -2.5 Mabsadd L
.51905 .28612 -2.5 -2.5 Mabsadd L
.51905 .28612 -2.5 2.5 Mabsadd L closepath F
.52222 .28532 -2.5 2.5 Mabsadd m
.52222 .28532 2.5 2.5 Mabsadd L
.52222 .28532 2.5 -2.5 Mabsadd L
.52222 .28532 -2.5 -2.5 Mabsadd L
.52222 .28532 -2.5 2.5 Mabsadd L closepath F
.5254 .28452 -2.5 2.5 Mabsadd m
.5254 .28452 2.5 2.5 Mabsadd L
.5254 .28452 2.5 -2.5 Mabsadd L
.5254 .28452 -2.5 -2.5 Mabsadd L
.5254 .28452 -2.5 2.5 Mabsadd L closepath F
.52857 .28373 -2.5 2.5 Mabsadd m
.52857 .28373 2.5 2.5 Mabsadd L
.52857 .28373 2.5 -2.5 Mabsadd L
.52857 .28373 -2.5 -2.5 Mabsadd L
.52857 .28373 -2.5 2.5 Mabsadd L closepath F
.53175 .28295 -2.5 2.5 Mabsadd m
.53175 .28295 2.5 2.5 Mabsadd L
.53175 .28295 2.5 -2.5 Mabsadd L
.53175 .28295 -2.5 -2.5 Mabsadd L
.53175 .28295 -2.5 2.5 Mabsadd L closepath F
.53492 .28218 -2.5 2.5 Mabsadd m
.53492 .28218 2.5 2.5 Mabsadd L
.53492 .28218 2.5 -2.5 Mabsadd L
.53492 .28218 -2.5 -2.5 Mabsadd L
.53492 .28218 -2.5 2.5 Mabsadd L closepath F
.5381 .28141 -2.5 2.5 Mabsadd m
.5381 .28141 2.5 2.5 Mabsadd L
.5381 .28141 2.5 -2.5 Mabsadd L
.5381 .28141 -2.5 -2.5 Mabsadd L
.5381 .28141 -2.5 2.5 Mabsadd L closepath F
.54127 .28066 -2.5 2.5 Mabsadd m
.54127 .28066 2.5 2.5 Mabsadd L
.54127 .28066 2.5 -2.5 Mabsadd L
.54127 .28066 -2.5 -2.5 Mabsadd L
.54127 .28066 -2.5 2.5 Mabsadd L closepath F
.54444 .27991 -2.5 2.5 Mabsadd m
.54444 .27991 2.5 2.5 Mabsadd L
.54444 .27991 2.5 -2.5 Mabsadd L
.54444 .27991 -2.5 -2.5 Mabsadd L
.54444 .27991 -2.5 2.5 Mabsadd L closepath F
.54762 .27917 -2.5 2.5 Mabsadd m
.54762 .27917 2.5 2.5 Mabsadd L
.54762 .27917 2.5 -2.5 Mabsadd L
.54762 .27917 -2.5 -2.5 Mabsadd L
.54762 .27917 -2.5 2.5 Mabsadd L closepath F
.55079 .27843 -2.5 2.5 Mabsadd m
.55079 .27843 2.5 2.5 Mabsadd L
.55079 .27843 2.5 -2.5 Mabsadd L
.55079 .27843 -2.5 -2.5 Mabsadd L
.55079 .27843 -2.5 2.5 Mabsadd L closepath F
.55397 .2777 -2.5 2.5 Mabsadd m
.55397 .2777 2.5 2.5 Mabsadd L
.55397 .2777 2.5 -2.5 Mabsadd L
.55397 .2777 -2.5 -2.5 Mabsadd L
.55397 .2777 -2.5 2.5 Mabsadd L closepath F
.55714 .27698 -2.5 2.5 Mabsadd m
.55714 .27698 2.5 2.5 Mabsadd L
.55714 .27698 2.5 -2.5 Mabsadd L
.55714 .27698 -2.5 -2.5 Mabsadd L
.55714 .27698 -2.5 2.5 Mabsadd L closepath F
.56032 .27627 -2.5 2.5 Mabsadd m
.56032 .27627 2.5 2.5 Mabsadd L
.56032 .27627 2.5 -2.5 Mabsadd L
.56032 .27627 -2.5 -2.5 Mabsadd L
.56032 .27627 -2.5 2.5 Mabsadd L closepath F
.56349 .27556 -2.5 2.5 Mabsadd m
.56349 .27556 2.5 2.5 Mabsadd L
.56349 .27556 2.5 -2.5 Mabsadd L
.56349 .27556 -2.5 -2.5 Mabsadd L
.56349 .27556 -2.5 2.5 Mabsadd L closepath F
.56667 .27487 -2.5 2.5 Mabsadd m
.56667 .27487 2.5 2.5 Mabsadd L
.56667 .27487 2.5 -2.5 Mabsadd L
.56667 .27487 -2.5 -2.5 Mabsadd L
.56667 .27487 -2.5 2.5 Mabsadd L closepath F
.56984 .27417 -2.5 2.5 Mabsadd m
.56984 .27417 2.5 2.5 Mabsadd L
.56984 .27417 2.5 -2.5 Mabsadd L
.56984 .27417 -2.5 -2.5 Mabsadd L
.56984 .27417 -2.5 2.5 Mabsadd L closepath F
.57302 .27349 -2.5 2.5 Mabsadd m
.57302 .27349 2.5 2.5 Mabsadd L
.57302 .27349 2.5 -2.5 Mabsadd L
.57302 .27349 -2.5 -2.5 Mabsadd L
.57302 .27349 -2.5 2.5 Mabsadd L closepath F
.57619 .27281 -2.5 2.5 Mabsadd m
.57619 .27281 2.5 2.5 Mabsadd L
.57619 .27281 2.5 -2.5 Mabsadd L
.57619 .27281 -2.5 -2.5 Mabsadd L
.57619 .27281 -2.5 2.5 Mabsadd L closepath F
.57937 .27214 -2.5 2.5 Mabsadd m
.57937 .27214 2.5 2.5 Mabsadd L
.57937 .27214 2.5 -2.5 Mabsadd L
.57937 .27214 -2.5 -2.5 Mabsadd L
.57937 .27214 -2.5 2.5 Mabsadd L closepath F
.58254 .27147 -2.5 2.5 Mabsadd m
.58254 .27147 2.5 2.5 Mabsadd L
.58254 .27147 2.5 -2.5 Mabsadd L
.58254 .27147 -2.5 -2.5 Mabsadd L
.58254 .27147 -2.5 2.5 Mabsadd L closepath F
.58571 .27082 -2.5 2.5 Mabsadd m
.58571 .27082 2.5 2.5 Mabsadd L
.58571 .27082 2.5 -2.5 Mabsadd L
.58571 .27082 -2.5 -2.5 Mabsadd L
.58571 .27082 -2.5 2.5 Mabsadd L closepath F
.58889 .27017 -2.5 2.5 Mabsadd m
.58889 .27017 2.5 2.5 Mabsadd L
.58889 .27017 2.5 -2.5 Mabsadd L
.58889 .27017 -2.5 -2.5 Mabsadd L
.58889 .27017 -2.5 2.5 Mabsadd L closepath F
.59206 .26952 -2.5 2.5 Mabsadd m
.59206 .26952 2.5 2.5 Mabsadd L
.59206 .26952 2.5 -2.5 Mabsadd L
.59206 .26952 -2.5 -2.5 Mabsadd L
.59206 .26952 -2.5 2.5 Mabsadd L closepath F
.59524 .26888 -2.5 2.5 Mabsadd m
.59524 .26888 2.5 2.5 Mabsadd L
.59524 .26888 2.5 -2.5 Mabsadd L
.59524 .26888 -2.5 -2.5 Mabsadd L
.59524 .26888 -2.5 2.5 Mabsadd L closepath F
.59841 .26825 -2.5 2.5 Mabsadd m
.59841 .26825 2.5 2.5 Mabsadd L
.59841 .26825 2.5 -2.5 Mabsadd L
.59841 .26825 -2.5 -2.5 Mabsadd L
.59841 .26825 -2.5 2.5 Mabsadd L closepath F
.60159 .26762 -2.5 2.5 Mabsadd m
.60159 .26762 2.5 2.5 Mabsadd L
.60159 .26762 2.5 -2.5 Mabsadd L
.60159 .26762 -2.5 -2.5 Mabsadd L
.60159 .26762 -2.5 2.5 Mabsadd L closepath F
.60476 .26701 -2.5 2.5 Mabsadd m
.60476 .26701 2.5 2.5 Mabsadd L
.60476 .26701 2.5 -2.5 Mabsadd L
.60476 .26701 -2.5 -2.5 Mabsadd L
.60476 .26701 -2.5 2.5 Mabsadd L closepath F
.60794 .26639 -2.5 2.5 Mabsadd m
.60794 .26639 2.5 2.5 Mabsadd L
.60794 .26639 2.5 -2.5 Mabsadd L
.60794 .26639 -2.5 -2.5 Mabsadd L
.60794 .26639 -2.5 2.5 Mabsadd L closepath F
.61111 .26579 -2.5 2.5 Mabsadd m
.61111 .26579 2.5 2.5 Mabsadd L
.61111 .26579 2.5 -2.5 Mabsadd L
.61111 .26579 -2.5 -2.5 Mabsadd L
.61111 .26579 -2.5 2.5 Mabsadd L closepath F
.61429 .26518 -2.5 2.5 Mabsadd m
.61429 .26518 2.5 2.5 Mabsadd L
.61429 .26518 2.5 -2.5 Mabsadd L
.61429 .26518 -2.5 -2.5 Mabsadd L
.61429 .26518 -2.5 2.5 Mabsadd L closepath F
.61746 .26459 -2.5 2.5 Mabsadd m
.61746 .26459 2.5 2.5 Mabsadd L
.61746 .26459 2.5 -2.5 Mabsadd L
.61746 .26459 -2.5 -2.5 Mabsadd L
.61746 .26459 -2.5 2.5 Mabsadd L closepath F
.62063 .264 -2.5 2.5 Mabsadd m
.62063 .264 2.5 2.5 Mabsadd L
.62063 .264 2.5 -2.5 Mabsadd L
.62063 .264 -2.5 -2.5 Mabsadd L
.62063 .264 -2.5 2.5 Mabsadd L closepath F
.62381 .26342 -2.5 2.5 Mabsadd m
.62381 .26342 2.5 2.5 Mabsadd L
.62381 .26342 2.5 -2.5 Mabsadd L
.62381 .26342 -2.5 -2.5 Mabsadd L
.62381 .26342 -2.5 2.5 Mabsadd L closepath F
.62698 .26284 -2.5 2.5 Mabsadd m
.62698 .26284 2.5 2.5 Mabsadd L
.62698 .26284 2.5 -2.5 Mabsadd L
.62698 .26284 -2.5 -2.5 Mabsadd L
.62698 .26284 -2.5 2.5 Mabsadd L closepath F
.63016 .26227 -2.5 2.5 Mabsadd m
.63016 .26227 2.5 2.5 Mabsadd L
.63016 .26227 2.5 -2.5 Mabsadd L
.63016 .26227 -2.5 -2.5 Mabsadd L
.63016 .26227 -2.5 2.5 Mabsadd L closepath F
.63333 .2617 -2.5 2.5 Mabsadd m
.63333 .2617 2.5 2.5 Mabsadd L
.63333 .2617 2.5 -2.5 Mabsadd L
.63333 .2617 -2.5 -2.5 Mabsadd L
.63333 .2617 -2.5 2.5 Mabsadd L closepath F
.63651 .26114 -2.5 2.5 Mabsadd m
.63651 .26114 2.5 2.5 Mabsadd L
.63651 .26114 2.5 -2.5 Mabsadd L
.63651 .26114 -2.5 -2.5 Mabsadd L
.63651 .26114 -2.5 2.5 Mabsadd L closepath F
.63968 .26059 -2.5 2.5 Mabsadd m
.63968 .26059 2.5 2.5 Mabsadd L
.63968 .26059 2.5 -2.5 Mabsadd L
.63968 .26059 -2.5 -2.5 Mabsadd L
.63968 .26059 -2.5 2.5 Mabsadd L closepath F
.64286 .26004 -2.5 2.5 Mabsadd m
.64286 .26004 2.5 2.5 Mabsadd L
.64286 .26004 2.5 -2.5 Mabsadd L
.64286 .26004 -2.5 -2.5 Mabsadd L
.64286 .26004 -2.5 2.5 Mabsadd L closepath F
.64603 .2595 -2.5 2.5 Mabsadd m
.64603 .2595 2.5 2.5 Mabsadd L
.64603 .2595 2.5 -2.5 Mabsadd L
.64603 .2595 -2.5 -2.5 Mabsadd L
.64603 .2595 -2.5 2.5 Mabsadd L closepath F
.64921 .25896 -2.5 2.5 Mabsadd m
.64921 .25896 2.5 2.5 Mabsadd L
.64921 .25896 2.5 -2.5 Mabsadd L
.64921 .25896 -2.5 -2.5 Mabsadd L
.64921 .25896 -2.5 2.5 Mabsadd L closepath F
.65238 .25842 -2.5 2.5 Mabsadd m
.65238 .25842 2.5 2.5 Mabsadd L
.65238 .25842 2.5 -2.5 Mabsadd L
.65238 .25842 -2.5 -2.5 Mabsadd L
.65238 .25842 -2.5 2.5 Mabsadd L closepath F
.65556 .2579 -2.5 2.5 Mabsadd m
.65556 .2579 2.5 2.5 Mabsadd L
.65556 .2579 2.5 -2.5 Mabsadd L
.65556 .2579 -2.5 -2.5 Mabsadd L
.65556 .2579 -2.5 2.5 Mabsadd L closepath F
.65873 .25737 -2.5 2.5 Mabsadd m
.65873 .25737 2.5 2.5 Mabsadd L
.65873 .25737 2.5 -2.5 Mabsadd L
.65873 .25737 -2.5 -2.5 Mabsadd L
.65873 .25737 -2.5 2.5 Mabsadd L closepath F
.6619 .25686 -2.5 2.5 Mabsadd m
.6619 .25686 2.5 2.5 Mabsadd L
.6619 .25686 2.5 -2.5 Mabsadd L
.6619 .25686 -2.5 -2.5 Mabsadd L
.6619 .25686 -2.5 2.5 Mabsadd L closepath F
.66508 .25635 -2.5 2.5 Mabsadd m
.66508 .25635 2.5 2.5 Mabsadd L
.66508 .25635 2.5 -2.5 Mabsadd L
.66508 .25635 -2.5 -2.5 Mabsadd L
.66508 .25635 -2.5 2.5 Mabsadd L closepath F
.66825 .25584 -2.5 2.5 Mabsadd m
.66825 .25584 2.5 2.5 Mabsadd L
.66825 .25584 2.5 -2.5 Mabsadd L
.66825 .25584 -2.5 -2.5 Mabsadd L
.66825 .25584 -2.5 2.5 Mabsadd L closepath F
.67143 .25534 -2.5 2.5 Mabsadd m
.67143 .25534 2.5 2.5 Mabsadd L
.67143 .25534 2.5 -2.5 Mabsadd L
.67143 .25534 -2.5 -2.5 Mabsadd L
.67143 .25534 -2.5 2.5 Mabsadd L closepath F
.6746 .25484 -2.5 2.5 Mabsadd m
.6746 .25484 2.5 2.5 Mabsadd L
.6746 .25484 2.5 -2.5 Mabsadd L
.6746 .25484 -2.5 -2.5 Mabsadd L
.6746 .25484 -2.5 2.5 Mabsadd L closepath F
.67778 .25435 -2.5 2.5 Mabsadd m
.67778 .25435 2.5 2.5 Mabsadd L
.67778 .25435 2.5 -2.5 Mabsadd L
.67778 .25435 -2.5 -2.5 Mabsadd L
.67778 .25435 -2.5 2.5 Mabsadd L closepath F
.68095 .25386 -2.5 2.5 Mabsadd m
.68095 .25386 2.5 2.5 Mabsadd L
.68095 .25386 2.5 -2.5 Mabsadd L
.68095 .25386 -2.5 -2.5 Mabsadd L
.68095 .25386 -2.5 2.5 Mabsadd L closepath F
.68413 .25338 -2.5 2.5 Mabsadd m
.68413 .25338 2.5 2.5 Mabsadd L
.68413 .25338 2.5 -2.5 Mabsadd L
.68413 .25338 -2.5 -2.5 Mabsadd L
.68413 .25338 -2.5 2.5 Mabsadd L closepath F
.6873 .2529 -2.5 2.5 Mabsadd m
.6873 .2529 2.5 2.5 Mabsadd L
.6873 .2529 2.5 -2.5 Mabsadd L
.6873 .2529 -2.5 -2.5 Mabsadd L
.6873 .2529 -2.5 2.5 Mabsadd L closepath F
.69048 .25243 -2.5 2.5 Mabsadd m
.69048 .25243 2.5 2.5 Mabsadd L
.69048 .25243 2.5 -2.5 Mabsadd L
.69048 .25243 -2.5 -2.5 Mabsadd L
.69048 .25243 -2.5 2.5 Mabsadd L closepath F
.69365 .25196 -2.5 2.5 Mabsadd m
.69365 .25196 2.5 2.5 Mabsadd L
.69365 .25196 2.5 -2.5 Mabsadd L
.69365 .25196 -2.5 -2.5 Mabsadd L
.69365 .25196 -2.5 2.5 Mabsadd L closepath F
.69683 .2515 -2.5 2.5 Mabsadd m
.69683 .2515 2.5 2.5 Mabsadd L
.69683 .2515 2.5 -2.5 Mabsadd L
.69683 .2515 -2.5 -2.5 Mabsadd L
.69683 .2515 -2.5 2.5 Mabsadd L closepath F
.7 .25104 -2.5 2.5 Mabsadd m
.7 .25104 2.5 2.5 Mabsadd L
.7 .25104 2.5 -2.5 Mabsadd L
.7 .25104 -2.5 -2.5 Mabsadd L
.7 .25104 -2.5 2.5 Mabsadd L closepath F
.70317 .25059 -2.5 2.5 Mabsadd m
.70317 .25059 2.5 2.5 Mabsadd L
.70317 .25059 2.5 -2.5 Mabsadd L
.70317 .25059 -2.5 -2.5 Mabsadd L
.70317 .25059 -2.5 2.5 Mabsadd L closepath F
.70635 .25014 -2.5 2.5 Mabsadd m
.70635 .25014 2.5 2.5 Mabsadd L
.70635 .25014 2.5 -2.5 Mabsadd L
.70635 .25014 -2.5 -2.5 Mabsadd L
.70635 .25014 -2.5 2.5 Mabsadd L closepath F
.70952 .2497 -2.5 2.5 Mabsadd m
.70952 .2497 2.5 2.5 Mabsadd L
.70952 .2497 2.5 -2.5 Mabsadd L
.70952 .2497 -2.5 -2.5 Mabsadd L
.70952 .2497 -2.5 2.5 Mabsadd L closepath F
.7127 .24926 -2.5 2.5 Mabsadd m
.7127 .24926 2.5 2.5 Mabsadd L
.7127 .24926 2.5 -2.5 Mabsadd L
.7127 .24926 -2.5 -2.5 Mabsadd L
.7127 .24926 -2.5 2.5 Mabsadd L closepath F
.71587 .24882 -2.5 2.5 Mabsadd m
.71587 .24882 2.5 2.5 Mabsadd L
.71587 .24882 2.5 -2.5 Mabsadd L
.71587 .24882 -2.5 -2.5 Mabsadd L
.71587 .24882 -2.5 2.5 Mabsadd L closepath F
.71905 .24839 -2.5 2.5 Mabsadd m
.71905 .24839 2.5 2.5 Mabsadd L
.71905 .24839 2.5 -2.5 Mabsadd L
.71905 .24839 -2.5 -2.5 Mabsadd L
.71905 .24839 -2.5 2.5 Mabsadd L closepath F
.72222 .24796 -2.5 2.5 Mabsadd m
.72222 .24796 2.5 2.5 Mabsadd L
.72222 .24796 2.5 -2.5 Mabsadd L
.72222 .24796 -2.5 -2.5 Mabsadd L
.72222 .24796 -2.5 2.5 Mabsadd L closepath F
.7254 .24754 -2.5 2.5 Mabsadd m
.7254 .24754 2.5 2.5 Mabsadd L
.7254 .24754 2.5 -2.5 Mabsadd L
.7254 .24754 -2.5 -2.5 Mabsadd L
.7254 .24754 -2.5 2.5 Mabsadd L closepath F
.72857 .24712 -2.5 2.5 Mabsadd m
.72857 .24712 2.5 2.5 Mabsadd L
.72857 .24712 2.5 -2.5 Mabsadd L
.72857 .24712 -2.5 -2.5 Mabsadd L
.72857 .24712 -2.5 2.5 Mabsadd L closepath F
.73175 .24671 -2.5 2.5 Mabsadd m
.73175 .24671 2.5 2.5 Mabsadd L
.73175 .24671 2.5 -2.5 Mabsadd L
.73175 .24671 -2.5 -2.5 Mabsadd L
.73175 .24671 -2.5 2.5 Mabsadd L closepath F
.73492 .2463 -2.5 2.5 Mabsadd m
.73492 .2463 2.5 2.5 Mabsadd L
.73492 .2463 2.5 -2.5 Mabsadd L
.73492 .2463 -2.5 -2.5 Mabsadd L
.73492 .2463 -2.5 2.5 Mabsadd L closepath F
.7381 .24589 -2.5 2.5 Mabsadd m
.7381 .24589 2.5 2.5 Mabsadd L
.7381 .24589 2.5 -2.5 Mabsadd L
.7381 .24589 -2.5 -2.5 Mabsadd L
.7381 .24589 -2.5 2.5 Mabsadd L closepath F
.74127 .24549 -2.5 2.5 Mabsadd m
.74127 .24549 2.5 2.5 Mabsadd L
.74127 .24549 2.5 -2.5 Mabsadd L
.74127 .24549 -2.5 -2.5 Mabsadd L
.74127 .24549 -2.5 2.5 Mabsadd L closepath F
.74444 .24509 -2.5 2.5 Mabsadd m
.74444 .24509 2.5 2.5 Mabsadd L
.74444 .24509 2.5 -2.5 Mabsadd L
.74444 .24509 -2.5 -2.5 Mabsadd L
.74444 .24509 -2.5 2.5 Mabsadd L closepath F
.74762 .2447 -2.5 2.5 Mabsadd m
.74762 .2447 2.5 2.5 Mabsadd L
.74762 .2447 2.5 -2.5 Mabsadd L
.74762 .2447 -2.5 -2.5 Mabsadd L
.74762 .2447 -2.5 2.5 Mabsadd L closepath F
.75079 .24431 -2.5 2.5 Mabsadd m
.75079 .24431 2.5 2.5 Mabsadd L
.75079 .24431 2.5 -2.5 Mabsadd L
.75079 .24431 -2.5 -2.5 Mabsadd L
.75079 .24431 -2.5 2.5 Mabsadd L closepath F
.75397 .24392 -2.5 2.5 Mabsadd m
.75397 .24392 2.5 2.5 Mabsadd L
.75397 .24392 2.5 -2.5 Mabsadd L
.75397 .24392 -2.5 -2.5 Mabsadd L
.75397 .24392 -2.5 2.5 Mabsadd L closepath F
.75714 .24354 -2.5 2.5 Mabsadd m
.75714 .24354 2.5 2.5 Mabsadd L
.75714 .24354 2.5 -2.5 Mabsadd L
.75714 .24354 -2.5 -2.5 Mabsadd L
.75714 .24354 -2.5 2.5 Mabsadd L closepath F
.76032 .24316 -2.5 2.5 Mabsadd m
.76032 .24316 2.5 2.5 Mabsadd L
.76032 .24316 2.5 -2.5 Mabsadd L
.76032 .24316 -2.5 -2.5 Mabsadd L
.76032 .24316 -2.5 2.5 Mabsadd L closepath F
.76349 .24278 -2.5 2.5 Mabsadd m
.76349 .24278 2.5 2.5 Mabsadd L
.76349 .24278 2.5 -2.5 Mabsadd L
.76349 .24278 -2.5 -2.5 Mabsadd L
.76349 .24278 -2.5 2.5 Mabsadd L closepath F
.76667 .24241 -2.5 2.5 Mabsadd m
.76667 .24241 2.5 2.5 Mabsadd L
.76667 .24241 2.5 -2.5 Mabsadd L
.76667 .24241 -2.5 -2.5 Mabsadd L
.76667 .24241 -2.5 2.5 Mabsadd L closepath F
.76984 .24205 -2.5 2.5 Mabsadd m
.76984 .24205 2.5 2.5 Mabsadd L
.76984 .24205 2.5 -2.5 Mabsadd L
.76984 .24205 -2.5 -2.5 Mabsadd L
.76984 .24205 -2.5 2.5 Mabsadd L closepath F
.77302 .24168 -2.5 2.5 Mabsadd m
.77302 .24168 2.5 2.5 Mabsadd L
.77302 .24168 2.5 -2.5 Mabsadd L
.77302 .24168 -2.5 -2.5 Mabsadd L
.77302 .24168 -2.5 2.5 Mabsadd L closepath F
.77619 .24132 -2.5 2.5 Mabsadd m
.77619 .24132 2.5 2.5 Mabsadd L
.77619 .24132 2.5 -2.5 Mabsadd L
.77619 .24132 -2.5 -2.5 Mabsadd L
.77619 .24132 -2.5 2.5 Mabsadd L closepath F
.77937 .24097 -2.5 2.5 Mabsadd m
.77937 .24097 2.5 2.5 Mabsadd L
.77937 .24097 2.5 -2.5 Mabsadd L
.77937 .24097 -2.5 -2.5 Mabsadd L
.77937 .24097 -2.5 2.5 Mabsadd L closepath F
.78254 .24061 -2.5 2.5 Mabsadd m
.78254 .24061 2.5 2.5 Mabsadd L
.78254 .24061 2.5 -2.5 Mabsadd L
.78254 .24061 -2.5 -2.5 Mabsadd L
.78254 .24061 -2.5 2.5 Mabsadd L closepath F
.78571 .24026 -2.5 2.5 Mabsadd m
.78571 .24026 2.5 2.5 Mabsadd L
.78571 .24026 2.5 -2.5 Mabsadd L
.78571 .24026 -2.5 -2.5 Mabsadd L
.78571 .24026 -2.5 2.5 Mabsadd L closepath F
.78889 .23992 -2.5 2.5 Mabsadd m
.78889 .23992 2.5 2.5 Mabsadd L
.78889 .23992 2.5 -2.5 Mabsadd L
.78889 .23992 -2.5 -2.5 Mabsadd L
.78889 .23992 -2.5 2.5 Mabsadd L closepath F
.79206 .23958 -2.5 2.5 Mabsadd m
.79206 .23958 2.5 2.5 Mabsadd L
.79206 .23958 2.5 -2.5 Mabsadd L
.79206 .23958 -2.5 -2.5 Mabsadd L
.79206 .23958 -2.5 2.5 Mabsadd L closepath F
.79524 .23924 -2.5 2.5 Mabsadd m
.79524 .23924 2.5 2.5 Mabsadd L
.79524 .23924 2.5 -2.5 Mabsadd L
.79524 .23924 -2.5 -2.5 Mabsadd L
.79524 .23924 -2.5 2.5 Mabsadd L closepath F
.79841 .2389 -2.5 2.5 Mabsadd m
.79841 .2389 2.5 2.5 Mabsadd L
.79841 .2389 2.5 -2.5 Mabsadd L
.79841 .2389 -2.5 -2.5 Mabsadd L
.79841 .2389 -2.5 2.5 Mabsadd L closepath F
.80159 .23857 -2.5 2.5 Mabsadd m
.80159 .23857 2.5 2.5 Mabsadd L
.80159 .23857 2.5 -2.5 Mabsadd L
.80159 .23857 -2.5 -2.5 Mabsadd L
.80159 .23857 -2.5 2.5 Mabsadd L closepath F
.80476 .23824 -2.5 2.5 Mabsadd m
.80476 .23824 2.5 2.5 Mabsadd L
.80476 .23824 2.5 -2.5 Mabsadd L
.80476 .23824 -2.5 -2.5 Mabsadd L
.80476 .23824 -2.5 2.5 Mabsadd L closepath F
.80794 .23792 -2.5 2.5 Mabsadd m
.80794 .23792 2.5 2.5 Mabsadd L
.80794 .23792 2.5 -2.5 Mabsadd L
.80794 .23792 -2.5 -2.5 Mabsadd L
.80794 .23792 -2.5 2.5 Mabsadd L closepath F
.81111 .23759 -2.5 2.5 Mabsadd m
.81111 .23759 2.5 2.5 Mabsadd L
.81111 .23759 2.5 -2.5 Mabsadd L
.81111 .23759 -2.5 -2.5 Mabsadd L
.81111 .23759 -2.5 2.5 Mabsadd L closepath F
.81429 .23727 -2.5 2.5 Mabsadd m
.81429 .23727 2.5 2.5 Mabsadd L
.81429 .23727 2.5 -2.5 Mabsadd L
.81429 .23727 -2.5 -2.5 Mabsadd L
.81429 .23727 -2.5 2.5 Mabsadd L closepath F
.81746 .23696 -2.5 2.5 Mabsadd m
.81746 .23696 2.5 2.5 Mabsadd L
.81746 .23696 2.5 -2.5 Mabsadd L
.81746 .23696 -2.5 -2.5 Mabsadd L
.81746 .23696 -2.5 2.5 Mabsadd L closepath F
.82063 .23665 -2.5 2.5 Mabsadd m
.82063 .23665 2.5 2.5 Mabsadd L
.82063 .23665 2.5 -2.5 Mabsadd L
.82063 .23665 -2.5 -2.5 Mabsadd L
.82063 .23665 -2.5 2.5 Mabsadd L closepath F
.82381 .23634 -2.5 2.5 Mabsadd m
.82381 .23634 2.5 2.5 Mabsadd L
.82381 .23634 2.5 -2.5 Mabsadd L
.82381 .23634 -2.5 -2.5 Mabsadd L
.82381 .23634 -2.5 2.5 Mabsadd L closepath F
.82698 .23603 -2.5 2.5 Mabsadd m
.82698 .23603 2.5 2.5 Mabsadd L
.82698 .23603 2.5 -2.5 Mabsadd L
.82698 .23603 -2.5 -2.5 Mabsadd L
.82698 .23603 -2.5 2.5 Mabsadd L closepath F
.83016 .23573 -2.5 2.5 Mabsadd m
.83016 .23573 2.5 2.5 Mabsadd L
.83016 .23573 2.5 -2.5 Mabsadd L
.83016 .23573 -2.5 -2.5 Mabsadd L
.83016 .23573 -2.5 2.5 Mabsadd L closepath F
.83333 .23543 -2.5 2.5 Mabsadd m
.83333 .23543 2.5 2.5 Mabsadd L
.83333 .23543 2.5 -2.5 Mabsadd L
.83333 .23543 -2.5 -2.5 Mabsadd L
.83333 .23543 -2.5 2.5 Mabsadd L closepath F
.83651 .23513 -2.5 2.5 Mabsadd m
.83651 .23513 2.5 2.5 Mabsadd L
.83651 .23513 2.5 -2.5 Mabsadd L
.83651 .23513 -2.5 -2.5 Mabsadd L
.83651 .23513 -2.5 2.5 Mabsadd L closepath F
.83968 .23483 -2.5 2.5 Mabsadd m
.83968 .23483 2.5 2.5 Mabsadd L
.83968 .23483 2.5 -2.5 Mabsadd L
.83968 .23483 -2.5 -2.5 Mabsadd L
.83968 .23483 -2.5 2.5 Mabsadd L closepath F
.84286 .23454 -2.5 2.5 Mabsadd m
.84286 .23454 2.5 2.5 Mabsadd L
.84286 .23454 2.5 -2.5 Mabsadd L
.84286 .23454 -2.5 -2.5 Mabsadd L
.84286 .23454 -2.5 2.5 Mabsadd L closepath F
.84603 .23425 -2.5 2.5 Mabsadd m
.84603 .23425 2.5 2.5 Mabsadd L
.84603 .23425 2.5 -2.5 Mabsadd L
.84603 .23425 -2.5 -2.5 Mabsadd L
.84603 .23425 -2.5 2.5 Mabsadd L closepath F
.84921 .23397 -2.5 2.5 Mabsadd m
.84921 .23397 2.5 2.5 Mabsadd L
.84921 .23397 2.5 -2.5 Mabsadd L
.84921 .23397 -2.5 -2.5 Mabsadd L
.84921 .23397 -2.5 2.5 Mabsadd L closepath F
.85238 .23368 -2.5 2.5 Mabsadd m
.85238 .23368 2.5 2.5 Mabsadd L
.85238 .23368 2.5 -2.5 Mabsadd L
.85238 .23368 -2.5 -2.5 Mabsadd L
.85238 .23368 -2.5 2.5 Mabsadd L closepath F
.85556 .2334 -2.5 2.5 Mabsadd m
.85556 .2334 2.5 2.5 Mabsadd L
.85556 .2334 2.5 -2.5 Mabsadd L
.85556 .2334 -2.5 -2.5 Mabsadd L
.85556 .2334 -2.5 2.5 Mabsadd L closepath F
.85873 .23313 -2.5 2.5 Mabsadd m
.85873 .23313 2.5 2.5 Mabsadd L
.85873 .23313 2.5 -2.5 Mabsadd L
.85873 .23313 -2.5 -2.5 Mabsadd L
.85873 .23313 -2.5 2.5 Mabsadd L closepath F
.8619 .23285 -2.5 2.5 Mabsadd m
.8619 .23285 2.5 2.5 Mabsadd L
.8619 .23285 2.5 -2.5 Mabsadd L
.8619 .23285 -2.5 -2.5 Mabsadd L
.8619 .23285 -2.5 2.5 Mabsadd L closepath F
.86508 .23258 -2.5 2.5 Mabsadd m
.86508 .23258 2.5 2.5 Mabsadd L
.86508 .23258 2.5 -2.5 Mabsadd L
.86508 .23258 -2.5 -2.5 Mabsadd L
.86508 .23258 -2.5 2.5 Mabsadd L closepath F
.86825 .23231 -2.5 2.5 Mabsadd m
.86825 .23231 2.5 2.5 Mabsadd L
.86825 .23231 2.5 -2.5 Mabsadd L
.86825 .23231 -2.5 -2.5 Mabsadd L
.86825 .23231 -2.5 2.5 Mabsadd L closepath F
.87143 .23205 -2.5 2.5 Mabsadd m
.87143 .23205 2.5 2.5 Mabsadd L
.87143 .23205 2.5 -2.5 Mabsadd L
.87143 .23205 -2.5 -2.5 Mabsadd L
.87143 .23205 -2.5 2.5 Mabsadd L closepath F
.8746 .23178 -2.5 2.5 Mabsadd m
.8746 .23178 2.5 2.5 Mabsadd L
.8746 .23178 2.5 -2.5 Mabsadd L
.8746 .23178 -2.5 -2.5 Mabsadd L
.8746 .23178 -2.5 2.5 Mabsadd L closepath F
.87778 .23152 -2.5 2.5 Mabsadd m
.87778 .23152 2.5 2.5 Mabsadd L
.87778 .23152 2.5 -2.5 Mabsadd L
.87778 .23152 -2.5 -2.5 Mabsadd L
.87778 .23152 -2.5 2.5 Mabsadd L closepath F
.88095 .23126 -2.5 2.5 Mabsadd m
.88095 .23126 2.5 2.5 Mabsadd L
.88095 .23126 2.5 -2.5 Mabsadd L
.88095 .23126 -2.5 -2.5 Mabsadd L
.88095 .23126 -2.5 2.5 Mabsadd L closepath F
.88413 .23101 -2.5 2.5 Mabsadd m
.88413 .23101 2.5 2.5 Mabsadd L
.88413 .23101 2.5 -2.5 Mabsadd L
.88413 .23101 -2.5 -2.5 Mabsadd L
.88413 .23101 -2.5 2.5 Mabsadd L closepath F
.8873 .23075 -2.5 2.5 Mabsadd m
.8873 .23075 2.5 2.5 Mabsadd L
.8873 .23075 2.5 -2.5 Mabsadd L
.8873 .23075 -2.5 -2.5 Mabsadd L
.8873 .23075 -2.5 2.5 Mabsadd L closepath F
.89048 .2305 -2.5 2.5 Mabsadd m
.89048 .2305 2.5 2.5 Mabsadd L
.89048 .2305 2.5 -2.5 Mabsadd L
.89048 .2305 -2.5 -2.5 Mabsadd L
.89048 .2305 -2.5 2.5 Mabsadd L closepath F
.89365 .23026 -2.5 2.5 Mabsadd m
.89365 .23026 2.5 2.5 Mabsadd L
.89365 .23026 2.5 -2.5 Mabsadd L
.89365 .23026 -2.5 -2.5 Mabsadd L
.89365 .23026 -2.5 2.5 Mabsadd L closepath F
.89683 .23001 -2.5 2.5 Mabsadd m
.89683 .23001 2.5 2.5 Mabsadd L
.89683 .23001 2.5 -2.5 Mabsadd L
.89683 .23001 -2.5 -2.5 Mabsadd L
.89683 .23001 -2.5 2.5 Mabsadd L closepath F
.9 .22977 -2.5 2.5 Mabsadd m
.9 .22977 2.5 2.5 Mabsadd L
.9 .22977 2.5 -2.5 Mabsadd L
.9 .22977 -2.5 -2.5 Mabsadd L
.9 .22977 -2.5 2.5 Mabsadd L closepath F
.90317 .22953 -2.5 2.5 Mabsadd m
.90317 .22953 2.5 2.5 Mabsadd L
.90317 .22953 2.5 -2.5 Mabsadd L
.90317 .22953 -2.5 -2.5 Mabsadd L
.90317 .22953 -2.5 2.5 Mabsadd L closepath F
.90635 .22929 -2.5 2.5 Mabsadd m
.90635 .22929 2.5 2.5 Mabsadd L
.90635 .22929 2.5 -2.5 Mabsadd L
.90635 .22929 -2.5 -2.5 Mabsadd L
.90635 .22929 -2.5 2.5 Mabsadd L closepath F
.90952 .22905 -2.5 2.5 Mabsadd m
.90952 .22905 2.5 2.5 Mabsadd L
.90952 .22905 2.5 -2.5 Mabsadd L
.90952 .22905 -2.5 -2.5 Mabsadd L
.90952 .22905 -2.5 2.5 Mabsadd L closepath F
.9127 .22882 -2.5 2.5 Mabsadd m
.9127 .22882 2.5 2.5 Mabsadd L
.9127 .22882 2.5 -2.5 Mabsadd L
.9127 .22882 -2.5 -2.5 Mabsadd L
.9127 .22882 -2.5 2.5 Mabsadd L closepath F
.91587 .22859 -2.5 2.5 Mabsadd m
.91587 .22859 2.5 2.5 Mabsadd L
.91587 .22859 2.5 -2.5 Mabsadd L
.91587 .22859 -2.5 -2.5 Mabsadd L
.91587 .22859 -2.5 2.5 Mabsadd L closepath F
.91905 .22836 -2.5 2.5 Mabsadd m
.91905 .22836 2.5 2.5 Mabsadd L
.91905 .22836 2.5 -2.5 Mabsadd L
.91905 .22836 -2.5 -2.5 Mabsadd L
.91905 .22836 -2.5 2.5 Mabsadd L closepath F
.92222 .22813 -2.5 2.5 Mabsadd m
.92222 .22813 2.5 2.5 Mabsadd L
.92222 .22813 2.5 -2.5 Mabsadd L
.92222 .22813 -2.5 -2.5 Mabsadd L
.92222 .22813 -2.5 2.5 Mabsadd L closepath F
.9254 .22791 -2.5 2.5 Mabsadd m
.9254 .22791 2.5 2.5 Mabsadd L
.9254 .22791 2.5 -2.5 Mabsadd L
.9254 .22791 -2.5 -2.5 Mabsadd L
.9254 .22791 -2.5 2.5 Mabsadd L closepath F
.92857 .22768 -2.5 2.5 Mabsadd m
.92857 .22768 2.5 2.5 Mabsadd L
.92857 .22768 2.5 -2.5 Mabsadd L
.92857 .22768 -2.5 -2.5 Mabsadd L
.92857 .22768 -2.5 2.5 Mabsadd L closepath F
.93175 .22746 -2.5 2.5 Mabsadd m
.93175 .22746 2.5 2.5 Mabsadd L
.93175 .22746 2.5 -2.5 Mabsadd L
.93175 .22746 -2.5 -2.5 Mabsadd L
.93175 .22746 -2.5 2.5 Mabsadd L closepath F
.93492 .22725 -2.5 2.5 Mabsadd m
.93492 .22725 2.5 2.5 Mabsadd L
.93492 .22725 2.5 -2.5 Mabsadd L
.93492 .22725 -2.5 -2.5 Mabsadd L
.93492 .22725 -2.5 2.5 Mabsadd L closepath F
.9381 .22703 -2.5 2.5 Mabsadd m
.9381 .22703 2.5 2.5 Mabsadd L
.9381 .22703 2.5 -2.5 Mabsadd L
.9381 .22703 -2.5 -2.5 Mabsadd L
.9381 .22703 -2.5 2.5 Mabsadd L closepath F
.94127 .22682 -2.5 2.5 Mabsadd m
.94127 .22682 2.5 2.5 Mabsadd L
.94127 .22682 2.5 -2.5 Mabsadd L
.94127 .22682 -2.5 -2.5 Mabsadd L
.94127 .22682 -2.5 2.5 Mabsadd L closepath F
.94444 .22661 -2.5 2.5 Mabsadd m
.94444 .22661 2.5 2.5 Mabsadd L
.94444 .22661 2.5 -2.5 Mabsadd L
.94444 .22661 -2.5 -2.5 Mabsadd L
.94444 .22661 -2.5 2.5 Mabsadd L closepath F
.94762 .2264 -2.5 2.5 Mabsadd m
.94762 .2264 2.5 2.5 Mabsadd L
.94762 .2264 2.5 -2.5 Mabsadd L
.94762 .2264 -2.5 -2.5 Mabsadd L
.94762 .2264 -2.5 2.5 Mabsadd L closepath F
.95079 .22619 -2.5 2.5 Mabsadd m
.95079 .22619 2.5 2.5 Mabsadd L
.95079 .22619 2.5 -2.5 Mabsadd L
.95079 .22619 -2.5 -2.5 Mabsadd L
.95079 .22619 -2.5 2.5 Mabsadd L closepath F
.95397 .22598 -2.5 2.5 Mabsadd m
.95397 .22598 2.5 2.5 Mabsadd L
.95397 .22598 2.5 -2.5 Mabsadd L
.95397 .22598 -2.5 -2.5 Mabsadd L
.95397 .22598 -2.5 2.5 Mabsadd L closepath F
.95714 .22578 -2.5 2.5 Mabsadd m
.95714 .22578 2.5 2.5 Mabsadd L
.95714 .22578 2.5 -2.5 Mabsadd L
.95714 .22578 -2.5 -2.5 Mabsadd L
.95714 .22578 -2.5 2.5 Mabsadd L closepath F
.96032 .22558 -2.5 2.5 Mabsadd m
.96032 .22558 2.5 2.5 Mabsadd L
.96032 .22558 2.5 -2.5 Mabsadd L
.96032 .22558 -2.5 -2.5 Mabsadd L
.96032 .22558 -2.5 2.5 Mabsadd L closepath F
.96349 .22538 -2.5 2.5 Mabsadd m
.96349 .22538 2.5 2.5 Mabsadd L
.96349 .22538 2.5 -2.5 Mabsadd L
.96349 .22538 -2.5 -2.5 Mabsadd L
.96349 .22538 -2.5 2.5 Mabsadd L closepath F
.96667 .22518 -2.5 2.5 Mabsadd m
.96667 .22518 2.5 2.5 Mabsadd L
.96667 .22518 2.5 -2.5 Mabsadd L
.96667 .22518 -2.5 -2.5 Mabsadd L
.96667 .22518 -2.5 2.5 Mabsadd L closepath F
.96984 .22499 -2.5 2.5 Mabsadd m
.96984 .22499 2.5 2.5 Mabsadd L
.96984 .22499 2.5 -2.5 Mabsadd L
.96984 .22499 -2.5 -2.5 Mabsadd L
.96984 .22499 -2.5 2.5 Mabsadd L closepath F
.97302 .2248 -2.5 2.5 Mabsadd m
.97302 .2248 2.5 2.5 Mabsadd L
.97302 .2248 2.5 -2.5 Mabsadd L
.97302 .2248 -2.5 -2.5 Mabsadd L
.97302 .2248 -2.5 2.5 Mabsadd L closepath F
.97619 .22461 -2.5 2.5 Mabsadd m
.97619 .22461 2.5 2.5 Mabsadd L
.97619 .22461 2.5 -2.5 Mabsadd L
.97619 .22461 -2.5 -2.5 Mabsadd L
.97619 .22461 -2.5 2.5 Mabsadd L closepath F
.0075 w
.13087 .61803 m
.13175 .61688 L
.13492 .61277 L
.1381 .6087 L
.14127 .60467 L
.14444 .60068 L
.14762 .59673 L
.15079 .59282 L
.15397 .58895 L
.15714 .58511 L
.16032 .58132 L
.16349 .57756 L
.16667 .57385 L
.16984 .57016 L
.17302 .56652 L
.17619 .56291 L
.17937 .55934 L
.18254 .5558 L
.18571 .5523 L
.18889 .54883 L
.19206 .5454 L
.19524 .54201 L
.19841 .53864 L
.20159 .53531 L
.20476 .53202 L
.20794 .52875 L
.21111 .52552 L
.21429 .52232 L
.21746 .51916 L
.22063 .51602 L
.22381 .51292 L
.22698 .50985 L
.23016 .50681 L
.23333 .50379 L
.23651 .50081 L
.23968 .49786 L
.24286 .49494 L
.24603 .49205 L
.24921 .48918 L
.25238 .48635 L
.25556 .48354 L
.25873 .48076 L
.2619 .47801 L
.26508 .47529 L
.26825 .47259 L
.27143 .46992 L
.2746 .46728 L
.27778 .46467 L
.28095 .46208 L
.28413 .45951 L
Mistroke
.2873 .45697 L
.29048 .45446 L
.29365 .45197 L
.29683 .44951 L
.3 .44707 L
.30317 .44466 L
.30635 .44227 L
.30952 .4399 L
.3127 .43756 L
.31587 .43524 L
.31905 .43295 L
.32222 .43067 L
.3254 .42842 L
.32857 .4262 L
.33175 .42399 L
.33492 .42181 L
.3381 .41965 L
.34127 .41751 L
.34444 .41539 L
.34762 .41329 L
.35079 .41122 L
.35397 .40916 L
.35714 .40713 L
.36032 .40511 L
.36349 .40312 L
.36667 .40114 L
.36984 .39919 L
.37302 .39725 L
.37619 .39534 L
.37937 .39344 L
.38254 .39156 L
.38571 .38971 L
.38889 .38787 L
.39206 .38604 L
.39524 .38424 L
.39841 .38245 L
.40159 .38069 L
.40476 .37894 L
.40794 .3772 L
.41111 .37549 L
.41429 .37379 L
.41746 .37211 L
.42063 .37045 L
.42381 .3688 L
.42698 .36717 L
.43016 .36555 L
.43333 .36395 L
.43651 .36237 L
.43968 .3608 L
.44286 .35925 L
Mistroke
.44603 .35772 L
.44921 .3562 L
.45238 .35469 L
.45556 .3532 L
.45873 .35173 L
.4619 .35027 L
.46508 .34882 L
.46825 .34739 L
.47143 .34597 L
.4746 .34457 L
.47778 .34318 L
.48095 .34181 L
.48413 .34044 L
.4873 .3391 L
.49048 .33776 L
.49365 .33644 L
.49683 .33513 L
.5 .33384 L
.50317 .33256 L
.50635 .33129 L
.50952 .33003 L
.5127 .32879 L
.51587 .32756 L
.51905 .32634 L
.52222 .32513 L
.5254 .32394 L
.52857 .32276 L
.53175 .32159 L
.53492 .32043 L
.5381 .31928 L
.54127 .31814 L
.54444 .31702 L
.54762 .31591 L
.55079 .3148 L
.55397 .31371 L
.55714 .31263 L
.56032 .31156 L
.56349 .3105 L
.56667 .30946 L
.56984 .30842 L
.57302 .30739 L
.57619 .30637 L
.57937 .30537 L
.58254 .30437 L
.58571 .30338 L
.58889 .30241 L
.59206 .30144 L
.59524 .30048 L
.59841 .29953 L
.60159 .29859 L
Mistroke
.60476 .29767 L
.60794 .29675 L
.61111 .29584 L
.61429 .29493 L
.61746 .29404 L
.62063 .29316 L
.62381 .29228 L
.62698 .29142 L
.63016 .29056 L
.63333 .28971 L
.63651 .28887 L
.63968 .28804 L
.64286 .28722 L
.64603 .2864 L
.64921 .28559 L
.65238 .28479 L
.65556 .284 L
.65873 .28322 L
.6619 .28244 L
.66508 .28168 L
.66825 .28092 L
.67143 .28016 L
.6746 .27942 L
.67778 .27868 L
.68095 .27795 L
.68413 .27723 L
.6873 .27651 L
.69048 .27581 L
.69365 .2751 L
.69683 .27441 L
.7 .27372 L
.70317 .27304 L
.70635 .27237 L
.70952 .2717 L
.7127 .27104 L
.71587 .27039 L
.71905 .26974 L
.72222 .2691 L
.7254 .26847 L
.72857 .26784 L
.73175 .26722 L
.73492 .2666 L
.7381 .26599 L
.74127 .26539 L
.74444 .26479 L
.74762 .2642 L
.75079 .26362 L
.75397 .26304 L
.75714 .26246 L
.76032 .2619 L
Mistroke
.76349 .26133 L
.76667 .26078 L
.76984 .26023 L
.77302 .25968 L
.77619 .25914 L
.77937 .25861 L
.78254 .25808 L
.78571 .25755 L
.78889 .25703 L
.79206 .25652 L
.79524 .25601 L
.79841 .25551 L
.80159 .25501 L
.80476 .25452 L
.80794 .25403 L
.81111 .25355 L
.81429 .25307 L
.81746 .25259 L
.82063 .25212 L
.82381 .25166 L
.82698 .2512 L
.83016 .25075 L
.83333 .2503 L
.83651 .24985 L
.83968 .24941 L
.84286 .24897 L
.84603 .24854 L
.84921 .24811 L
.85238 .24768 L
.85556 .24726 L
.85873 .24685 L
.8619 .24644 L
.86508 .24603 L
.86825 .24563 L
.87143 .24523 L
.8746 .24483 L
.87778 .24444 L
.88095 .24405 L
.88413 .24367 L
.8873 .24329 L
.89048 .24291 L
.89365 .24254 L
.89683 .24217 L
.9 .24181 L
.90317 .24145 L
.90635 .24109 L
.90952 .24073 L
.9127 .24038 L
.91587 .24004 L
.91905 .23969 L
Mistroke
.92222 .23935 L
.9254 .23902 L
.92857 .23868 L
.93175 .23835 L
.93492 .23803 L
.9381 .2377 L
.94127 .23738 L
.94444 .23707 L
.94762 .23675 L
.95079 .23644 L
.95397 .23613 L
.95714 .23583 L
.96032 .23553 L
.96349 .23523 L
.96667 .23493 L
.96984 .23464 L
.97302 .23435 L
.97619 .23407 L
Mfstroke
.0001 w
.02698 .7786 0 2.5 Mabsadd m
.02698 .7786 -2.165 -1.25 Mabsadd L
.02698 .7786 2.165 -1.25 Mabsadd L
.02698 .7786 0 2.5 Mabsadd L closepath F
.03016 .77287 0 2.5 Mabsadd m
.03016 .77287 -2.165 -1.25 Mabsadd L
.03016 .77287 2.165 -1.25 Mabsadd L
.03016 .77287 0 2.5 Mabsadd L closepath F
.03333 .7672 0 2.5 Mabsadd m
.03333 .7672 -2.165 -1.25 Mabsadd L
.03333 .7672 2.165 -1.25 Mabsadd L
.03333 .7672 0 2.5 Mabsadd L closepath F
.03651 .76158 0 2.5 Mabsadd m
.03651 .76158 -2.165 -1.25 Mabsadd L
.03651 .76158 2.165 -1.25 Mabsadd L
.03651 .76158 0 2.5 Mabsadd L closepath F
.03968 .75602 0 2.5 Mabsadd m
.03968 .75602 -2.165 -1.25 Mabsadd L
.03968 .75602 2.165 -1.25 Mabsadd L
.03968 .75602 0 2.5 Mabsadd L closepath F
.04286 .75052 0 2.5 Mabsadd m
.04286 .75052 -2.165 -1.25 Mabsadd L
.04286 .75052 2.165 -1.25 Mabsadd L
.04286 .75052 0 2.5 Mabsadd L closepath F
.04603 .74507 0 2.5 Mabsadd m
.04603 .74507 -2.165 -1.25 Mabsadd L
.04603 .74507 2.165 -1.25 Mabsadd L
.04603 .74507 0 2.5 Mabsadd L closepath F
.04921 .73968 0 2.5 Mabsadd m
.04921 .73968 -2.165 -1.25 Mabsadd L
.04921 .73968 2.165 -1.25 Mabsadd L
.04921 .73968 0 2.5 Mabsadd L closepath F
.05238 .73434 0 2.5 Mabsadd m
.05238 .73434 -2.165 -1.25 Mabsadd L
.05238 .73434 2.165 -1.25 Mabsadd L
.05238 .73434 0 2.5 Mabsadd L closepath F
.05556 .72905 0 2.5 Mabsadd m
.05556 .72905 -2.165 -1.25 Mabsadd L
.05556 .72905 2.165 -1.25 Mabsadd L
.05556 .72905 0 2.5 Mabsadd L closepath F
.05873 .72382 0 2.5 Mabsadd m
.05873 .72382 -2.165 -1.25 Mabsadd L
.05873 .72382 2.165 -1.25 Mabsadd L
.05873 .72382 0 2.5 Mabsadd L closepath F
.0619 .71864 0 2.5 Mabsadd m
.0619 .71864 -2.165 -1.25 Mabsadd L
.0619 .71864 2.165 -1.25 Mabsadd L
.0619 .71864 0 2.5 Mabsadd L closepath F
.06508 .71351 0 2.5 Mabsadd m
.06508 .71351 -2.165 -1.25 Mabsadd L
.06508 .71351 2.165 -1.25 Mabsadd L
.06508 .71351 0 2.5 Mabsadd L closepath F
.06825 .70843 0 2.5 Mabsadd m
.06825 .70843 -2.165 -1.25 Mabsadd L
.06825 .70843 2.165 -1.25 Mabsadd L
.06825 .70843 0 2.5 Mabsadd L closepath F
.07143 .7034 0 2.5 Mabsadd m
.07143 .7034 -2.165 -1.25 Mabsadd L
.07143 .7034 2.165 -1.25 Mabsadd L
.07143 .7034 0 2.5 Mabsadd L closepath F
.0746 .69842 0 2.5 Mabsadd m
.0746 .69842 -2.165 -1.25 Mabsadd L
.0746 .69842 2.165 -1.25 Mabsadd L
.0746 .69842 0 2.5 Mabsadd L closepath F
.07778 .6935 0 2.5 Mabsadd m
.07778 .6935 -2.165 -1.25 Mabsadd L
.07778 .6935 2.165 -1.25 Mabsadd L
.07778 .6935 0 2.5 Mabsadd L closepath F
.08095 .68862 0 2.5 Mabsadd m
.08095 .68862 -2.165 -1.25 Mabsadd L
.08095 .68862 2.165 -1.25 Mabsadd L
.08095 .68862 0 2.5 Mabsadd L closepath F
.08413 .68379 0 2.5 Mabsadd m
.08413 .68379 -2.165 -1.25 Mabsadd L
.08413 .68379 2.165 -1.25 Mabsadd L
.08413 .68379 0 2.5 Mabsadd L closepath F
.0873 .67901 0 2.5 Mabsadd m
.0873 .67901 -2.165 -1.25 Mabsadd L
.0873 .67901 2.165 -1.25 Mabsadd L
.0873 .67901 0 2.5 Mabsadd L closepath F
.09048 .67427 0 2.5 Mabsadd m
.09048 .67427 -2.165 -1.25 Mabsadd L
.09048 .67427 2.165 -1.25 Mabsadd L
.09048 .67427 0 2.5 Mabsadd L closepath F
.09365 .66959 0 2.5 Mabsadd m
.09365 .66959 -2.165 -1.25 Mabsadd L
.09365 .66959 2.165 -1.25 Mabsadd L
.09365 .66959 0 2.5 Mabsadd L closepath F
.09683 .66495 0 2.5 Mabsadd m
.09683 .66495 -2.165 -1.25 Mabsadd L
.09683 .66495 2.165 -1.25 Mabsadd L
.09683 .66495 0 2.5 Mabsadd L closepath F
.1 .66036 0 2.5 Mabsadd m
.1 .66036 -2.165 -1.25 Mabsadd L
.1 .66036 2.165 -1.25 Mabsadd L
.1 .66036 0 2.5 Mabsadd L closepath F
.10317 .65581 0 2.5 Mabsadd m
.10317 .65581 -2.165 -1.25 Mabsadd L
.10317 .65581 2.165 -1.25 Mabsadd L
.10317 .65581 0 2.5 Mabsadd L closepath F
.10635 .65131 0 2.5 Mabsadd m
.10635 .65131 -2.165 -1.25 Mabsadd L
.10635 .65131 2.165 -1.25 Mabsadd L
.10635 .65131 0 2.5 Mabsadd L closepath F
.10952 .64685 0 2.5 Mabsadd m
.10952 .64685 -2.165 -1.25 Mabsadd L
.10952 .64685 2.165 -1.25 Mabsadd L
.10952 .64685 0 2.5 Mabsadd L closepath F
.1127 .64244 0 2.5 Mabsadd m
.1127 .64244 -2.165 -1.25 Mabsadd L
.1127 .64244 2.165 -1.25 Mabsadd L
.1127 .64244 0 2.5 Mabsadd L closepath F
.11587 .63807 0 2.5 Mabsadd m
.11587 .63807 -2.165 -1.25 Mabsadd L
.11587 .63807 2.165 -1.25 Mabsadd L
.11587 .63807 0 2.5 Mabsadd L closepath F
.11905 .63375 0 2.5 Mabsadd m
.11905 .63375 -2.165 -1.25 Mabsadd L
.11905 .63375 2.165 -1.25 Mabsadd L
.11905 .63375 0 2.5 Mabsadd L closepath F
.12222 .62947 0 2.5 Mabsadd m
.12222 .62947 -2.165 -1.25 Mabsadd L
.12222 .62947 2.165 -1.25 Mabsadd L
.12222 .62947 0 2.5 Mabsadd L closepath F
.1254 .62523 0 2.5 Mabsadd m
.1254 .62523 -2.165 -1.25 Mabsadd L
.1254 .62523 2.165 -1.25 Mabsadd L
.1254 .62523 0 2.5 Mabsadd L closepath F
.12857 .62104 0 2.5 Mabsadd m
.12857 .62104 -2.165 -1.25 Mabsadd L
.12857 .62104 2.165 -1.25 Mabsadd L
.12857 .62104 0 2.5 Mabsadd L closepath F
.13175 .61688 0 2.5 Mabsadd m
.13175 .61688 -2.165 -1.25 Mabsadd L
.13175 .61688 2.165 -1.25 Mabsadd L
.13175 .61688 0 2.5 Mabsadd L closepath F
.13492 .61277 0 2.5 Mabsadd m
.13492 .61277 -2.165 -1.25 Mabsadd L
.13492 .61277 2.165 -1.25 Mabsadd L
.13492 .61277 0 2.5 Mabsadd L closepath F
.1381 .6087 0 2.5 Mabsadd m
.1381 .6087 -2.165 -1.25 Mabsadd L
.1381 .6087 2.165 -1.25 Mabsadd L
.1381 .6087 0 2.5 Mabsadd L closepath F
.14127 .60467 0 2.5 Mabsadd m
.14127 .60467 -2.165 -1.25 Mabsadd L
.14127 .60467 2.165 -1.25 Mabsadd L
.14127 .60467 0 2.5 Mabsadd L closepath F
.14444 .60068 0 2.5 Mabsadd m
.14444 .60068 -2.165 -1.25 Mabsadd L
.14444 .60068 2.165 -1.25 Mabsadd L
.14444 .60068 0 2.5 Mabsadd L closepath F
.14762 .59673 0 2.5 Mabsadd m
.14762 .59673 -2.165 -1.25 Mabsadd L
.14762 .59673 2.165 -1.25 Mabsadd L
.14762 .59673 0 2.5 Mabsadd L closepath F
.15079 .59282 0 2.5 Mabsadd m
.15079 .59282 -2.165 -1.25 Mabsadd L
.15079 .59282 2.165 -1.25 Mabsadd L
.15079 .59282 0 2.5 Mabsadd L closepath F
.15397 .58895 0 2.5 Mabsadd m
.15397 .58895 -2.165 -1.25 Mabsadd L
.15397 .58895 2.165 -1.25 Mabsadd L
.15397 .58895 0 2.5 Mabsadd L closepath F
.15714 .58511 0 2.5 Mabsadd m
.15714 .58511 -2.165 -1.25 Mabsadd L
.15714 .58511 2.165 -1.25 Mabsadd L
.15714 .58511 0 2.5 Mabsadd L closepath F
.16032 .58132 0 2.5 Mabsadd m
.16032 .58132 -2.165 -1.25 Mabsadd L
.16032 .58132 2.165 -1.25 Mabsadd L
.16032 .58132 0 2.5 Mabsadd L closepath F
.16349 .57756 0 2.5 Mabsadd m
.16349 .57756 -2.165 -1.25 Mabsadd L
.16349 .57756 2.165 -1.25 Mabsadd L
.16349 .57756 0 2.5 Mabsadd L closepath F
.16667 .57385 0 2.5 Mabsadd m
.16667 .57385 -2.165 -1.25 Mabsadd L
.16667 .57385 2.165 -1.25 Mabsadd L
.16667 .57385 0 2.5 Mabsadd L closepath F
.16984 .57016 0 2.5 Mabsadd m
.16984 .57016 -2.165 -1.25 Mabsadd L
.16984 .57016 2.165 -1.25 Mabsadd L
.16984 .57016 0 2.5 Mabsadd L closepath F
.17302 .56652 0 2.5 Mabsadd m
.17302 .56652 -2.165 -1.25 Mabsadd L
.17302 .56652 2.165 -1.25 Mabsadd L
.17302 .56652 0 2.5 Mabsadd L closepath F
.17619 .56291 0 2.5 Mabsadd m
.17619 .56291 -2.165 -1.25 Mabsadd L
.17619 .56291 2.165 -1.25 Mabsadd L
.17619 .56291 0 2.5 Mabsadd L closepath F
.17937 .55934 0 2.5 Mabsadd m
.17937 .55934 -2.165 -1.25 Mabsadd L
.17937 .55934 2.165 -1.25 Mabsadd L
.17937 .55934 0 2.5 Mabsadd L closepath F
.18254 .5558 0 2.5 Mabsadd m
.18254 .5558 -2.165 -1.25 Mabsadd L
.18254 .5558 2.165 -1.25 Mabsadd L
.18254 .5558 0 2.5 Mabsadd L closepath F
.18571 .5523 0 2.5 Mabsadd m
.18571 .5523 -2.165 -1.25 Mabsadd L
.18571 .5523 2.165 -1.25 Mabsadd L
.18571 .5523 0 2.5 Mabsadd L closepath F
.18889 .54883 0 2.5 Mabsadd m
.18889 .54883 -2.165 -1.25 Mabsadd L
.18889 .54883 2.165 -1.25 Mabsadd L
.18889 .54883 0 2.5 Mabsadd L closepath F
.19206 .5454 0 2.5 Mabsadd m
.19206 .5454 -2.165 -1.25 Mabsadd L
.19206 .5454 2.165 -1.25 Mabsadd L
.19206 .5454 0 2.5 Mabsadd L closepath F
.19524 .54201 0 2.5 Mabsadd m
.19524 .54201 -2.165 -1.25 Mabsadd L
.19524 .54201 2.165 -1.25 Mabsadd L
.19524 .54201 0 2.5 Mabsadd L closepath F
.19841 .53864 0 2.5 Mabsadd m
.19841 .53864 -2.165 -1.25 Mabsadd L
.19841 .53864 2.165 -1.25 Mabsadd L
.19841 .53864 0 2.5 Mabsadd L closepath F
.20159 .53531 0 2.5 Mabsadd m
.20159 .53531 -2.165 -1.25 Mabsadd L
.20159 .53531 2.165 -1.25 Mabsadd L
.20159 .53531 0 2.5 Mabsadd L closepath F
.20476 .53202 0 2.5 Mabsadd m
.20476 .53202 -2.165 -1.25 Mabsadd L
.20476 .53202 2.165 -1.25 Mabsadd L
.20476 .53202 0 2.5 Mabsadd L closepath F
.20794 .52875 0 2.5 Mabsadd m
.20794 .52875 -2.165 -1.25 Mabsadd L
.20794 .52875 2.165 -1.25 Mabsadd L
.20794 .52875 0 2.5 Mabsadd L closepath F
.21111 .52552 0 2.5 Mabsadd m
.21111 .52552 -2.165 -1.25 Mabsadd L
.21111 .52552 2.165 -1.25 Mabsadd L
.21111 .52552 0 2.5 Mabsadd L closepath F
.21429 .52232 0 2.5 Mabsadd m
.21429 .52232 -2.165 -1.25 Mabsadd L
.21429 .52232 2.165 -1.25 Mabsadd L
.21429 .52232 0 2.5 Mabsadd L closepath F
.21746 .51916 0 2.5 Mabsadd m
.21746 .51916 -2.165 -1.25 Mabsadd L
.21746 .51916 2.165 -1.25 Mabsadd L
.21746 .51916 0 2.5 Mabsadd L closepath F
.22063 .51602 0 2.5 Mabsadd m
.22063 .51602 -2.165 -1.25 Mabsadd L
.22063 .51602 2.165 -1.25 Mabsadd L
.22063 .51602 0 2.5 Mabsadd L closepath F
.22381 .51292 0 2.5 Mabsadd m
.22381 .51292 -2.165 -1.25 Mabsadd L
.22381 .51292 2.165 -1.25 Mabsadd L
.22381 .51292 0 2.5 Mabsadd L closepath F
.22698 .50985 0 2.5 Mabsadd m
.22698 .50985 -2.165 -1.25 Mabsadd L
.22698 .50985 2.165 -1.25 Mabsadd L
.22698 .50985 0 2.5 Mabsadd L closepath F
.23016 .50681 0 2.5 Mabsadd m
.23016 .50681 -2.165 -1.25 Mabsadd L
.23016 .50681 2.165 -1.25 Mabsadd L
.23016 .50681 0 2.5 Mabsadd L closepath F
.23333 .50379 0 2.5 Mabsadd m
.23333 .50379 -2.165 -1.25 Mabsadd L
.23333 .50379 2.165 -1.25 Mabsadd L
.23333 .50379 0 2.5 Mabsadd L closepath F
.23651 .50081 0 2.5 Mabsadd m
.23651 .50081 -2.165 -1.25 Mabsadd L
.23651 .50081 2.165 -1.25 Mabsadd L
.23651 .50081 0 2.5 Mabsadd L closepath F
.23968 .49786 0 2.5 Mabsadd m
.23968 .49786 -2.165 -1.25 Mabsadd L
.23968 .49786 2.165 -1.25 Mabsadd L
.23968 .49786 0 2.5 Mabsadd L closepath F
.24286 .49494 0 2.5 Mabsadd m
.24286 .49494 -2.165 -1.25 Mabsadd L
.24286 .49494 2.165 -1.25 Mabsadd L
.24286 .49494 0 2.5 Mabsadd L closepath F
.24603 .49205 0 2.5 Mabsadd m
.24603 .49205 -2.165 -1.25 Mabsadd L
.24603 .49205 2.165 -1.25 Mabsadd L
.24603 .49205 0 2.5 Mabsadd L closepath F
.24921 .48918 0 2.5 Mabsadd m
.24921 .48918 -2.165 -1.25 Mabsadd L
.24921 .48918 2.165 -1.25 Mabsadd L
.24921 .48918 0 2.5 Mabsadd L closepath F
.25238 .48635 0 2.5 Mabsadd m
.25238 .48635 -2.165 -1.25 Mabsadd L
.25238 .48635 2.165 -1.25 Mabsadd L
.25238 .48635 0 2.5 Mabsadd L closepath F
.25556 .48354 0 2.5 Mabsadd m
.25556 .48354 -2.165 -1.25 Mabsadd L
.25556 .48354 2.165 -1.25 Mabsadd L
.25556 .48354 0 2.5 Mabsadd L closepath F
.25873 .48076 0 2.5 Mabsadd m
.25873 .48076 -2.165 -1.25 Mabsadd L
.25873 .48076 2.165 -1.25 Mabsadd L
.25873 .48076 0 2.5 Mabsadd L closepath F
.2619 .47801 0 2.5 Mabsadd m
.2619 .47801 -2.165 -1.25 Mabsadd L
.2619 .47801 2.165 -1.25 Mabsadd L
.2619 .47801 0 2.5 Mabsadd L closepath F
.26508 .47529 0 2.5 Mabsadd m
.26508 .47529 -2.165 -1.25 Mabsadd L
.26508 .47529 2.165 -1.25 Mabsadd L
.26508 .47529 0 2.5 Mabsadd L closepath F
.26825 .47259 0 2.5 Mabsadd m
.26825 .47259 -2.165 -1.25 Mabsadd L
.26825 .47259 2.165 -1.25 Mabsadd L
.26825 .47259 0 2.5 Mabsadd L closepath F
.27143 .46992 0 2.5 Mabsadd m
.27143 .46992 -2.165 -1.25 Mabsadd L
.27143 .46992 2.165 -1.25 Mabsadd L
.27143 .46992 0 2.5 Mabsadd L closepath F
.2746 .46728 0 2.5 Mabsadd m
.2746 .46728 -2.165 -1.25 Mabsadd L
.2746 .46728 2.165 -1.25 Mabsadd L
.2746 .46728 0 2.5 Mabsadd L closepath F
.27778 .46467 0 2.5 Mabsadd m
.27778 .46467 -2.165 -1.25 Mabsadd L
.27778 .46467 2.165 -1.25 Mabsadd L
.27778 .46467 0 2.5 Mabsadd L closepath F
.28095 .46208 0 2.5 Mabsadd m
.28095 .46208 -2.165 -1.25 Mabsadd L
.28095 .46208 2.165 -1.25 Mabsadd L
.28095 .46208 0 2.5 Mabsadd L closepath F
.28413 .45951 0 2.5 Mabsadd m
.28413 .45951 -2.165 -1.25 Mabsadd L
.28413 .45951 2.165 -1.25 Mabsadd L
.28413 .45951 0 2.5 Mabsadd L closepath F
.2873 .45697 0 2.5 Mabsadd m
.2873 .45697 -2.165 -1.25 Mabsadd L
.2873 .45697 2.165 -1.25 Mabsadd L
.2873 .45697 0 2.5 Mabsadd L closepath F
.29048 .45446 0 2.5 Mabsadd m
.29048 .45446 -2.165 -1.25 Mabsadd L
.29048 .45446 2.165 -1.25 Mabsadd L
.29048 .45446 0 2.5 Mabsadd L closepath F
.29365 .45197 0 2.5 Mabsadd m
.29365 .45197 -2.165 -1.25 Mabsadd L
.29365 .45197 2.165 -1.25 Mabsadd L
.29365 .45197 0 2.5 Mabsadd L closepath F
.29683 .44951 0 2.5 Mabsadd m
.29683 .44951 -2.165 -1.25 Mabsadd L
.29683 .44951 2.165 -1.25 Mabsadd L
.29683 .44951 0 2.5 Mabsadd L closepath F
.3 .44707 0 2.5 Mabsadd m
.3 .44707 -2.165 -1.25 Mabsadd L
.3 .44707 2.165 -1.25 Mabsadd L
.3 .44707 0 2.5 Mabsadd L closepath F
.30317 .44466 0 2.5 Mabsadd m
.30317 .44466 -2.165 -1.25 Mabsadd L
.30317 .44466 2.165 -1.25 Mabsadd L
.30317 .44466 0 2.5 Mabsadd L closepath F
.30635 .44227 0 2.5 Mabsadd m
.30635 .44227 -2.165 -1.25 Mabsadd L
.30635 .44227 2.165 -1.25 Mabsadd L
.30635 .44227 0 2.5 Mabsadd L closepath F
.30952 .4399 0 2.5 Mabsadd m
.30952 .4399 -2.165 -1.25 Mabsadd L
.30952 .4399 2.165 -1.25 Mabsadd L
.30952 .4399 0 2.5 Mabsadd L closepath F
.3127 .43756 0 2.5 Mabsadd m
.3127 .43756 -2.165 -1.25 Mabsadd L
.3127 .43756 2.165 -1.25 Mabsadd L
.3127 .43756 0 2.5 Mabsadd L closepath F
.31587 .43524 0 2.5 Mabsadd m
.31587 .43524 -2.165 -1.25 Mabsadd L
.31587 .43524 2.165 -1.25 Mabsadd L
.31587 .43524 0 2.5 Mabsadd L closepath F
.31905 .43295 0 2.5 Mabsadd m
.31905 .43295 -2.165 -1.25 Mabsadd L
.31905 .43295 2.165 -1.25 Mabsadd L
.31905 .43295 0 2.5 Mabsadd L closepath F
.32222 .43067 0 2.5 Mabsadd m
.32222 .43067 -2.165 -1.25 Mabsadd L
.32222 .43067 2.165 -1.25 Mabsadd L
.32222 .43067 0 2.5 Mabsadd L closepath F
.3254 .42842 0 2.5 Mabsadd m
.3254 .42842 -2.165 -1.25 Mabsadd L
.3254 .42842 2.165 -1.25 Mabsadd L
.3254 .42842 0 2.5 Mabsadd L closepath F
.32857 .4262 0 2.5 Mabsadd m
.32857 .4262 -2.165 -1.25 Mabsadd L
.32857 .4262 2.165 -1.25 Mabsadd L
.32857 .4262 0 2.5 Mabsadd L closepath F
.33175 .42399 0 2.5 Mabsadd m
.33175 .42399 -2.165 -1.25 Mabsadd L
.33175 .42399 2.165 -1.25 Mabsadd L
.33175 .42399 0 2.5 Mabsadd L closepath F
.33492 .42181 0 2.5 Mabsadd m
.33492 .42181 -2.165 -1.25 Mabsadd L
.33492 .42181 2.165 -1.25 Mabsadd L
.33492 .42181 0 2.5 Mabsadd L closepath F
.3381 .41965 0 2.5 Mabsadd m
.3381 .41965 -2.165 -1.25 Mabsadd L
.3381 .41965 2.165 -1.25 Mabsadd L
.3381 .41965 0 2.5 Mabsadd L closepath F
.34127 .41751 0 2.5 Mabsadd m
.34127 .41751 -2.165 -1.25 Mabsadd L
.34127 .41751 2.165 -1.25 Mabsadd L
.34127 .41751 0 2.5 Mabsadd L closepath F
.34444 .41539 0 2.5 Mabsadd m
.34444 .41539 -2.165 -1.25 Mabsadd L
.34444 .41539 2.165 -1.25 Mabsadd L
.34444 .41539 0 2.5 Mabsadd L closepath F
.34762 .41329 0 2.5 Mabsadd m
.34762 .41329 -2.165 -1.25 Mabsadd L
.34762 .41329 2.165 -1.25 Mabsadd L
.34762 .41329 0 2.5 Mabsadd L closepath F
.35079 .41122 0 2.5 Mabsadd m
.35079 .41122 -2.165 -1.25 Mabsadd L
.35079 .41122 2.165 -1.25 Mabsadd L
.35079 .41122 0 2.5 Mabsadd L closepath F
.35397 .40916 0 2.5 Mabsadd m
.35397 .40916 -2.165 -1.25 Mabsadd L
.35397 .40916 2.165 -1.25 Mabsadd L
.35397 .40916 0 2.5 Mabsadd L closepath F
.35714 .40713 0 2.5 Mabsadd m
.35714 .40713 -2.165 -1.25 Mabsadd L
.35714 .40713 2.165 -1.25 Mabsadd L
.35714 .40713 0 2.5 Mabsadd L closepath F
.36032 .40511 0 2.5 Mabsadd m
.36032 .40511 -2.165 -1.25 Mabsadd L
.36032 .40511 2.165 -1.25 Mabsadd L
.36032 .40511 0 2.5 Mabsadd L closepath F
.36349 .40312 0 2.5 Mabsadd m
.36349 .40312 -2.165 -1.25 Mabsadd L
.36349 .40312 2.165 -1.25 Mabsadd L
.36349 .40312 0 2.5 Mabsadd L closepath F
.36667 .40114 0 2.5 Mabsadd m
.36667 .40114 -2.165 -1.25 Mabsadd L
.36667 .40114 2.165 -1.25 Mabsadd L
.36667 .40114 0 2.5 Mabsadd L closepath F
.36984 .39919 0 2.5 Mabsadd m
.36984 .39919 -2.165 -1.25 Mabsadd L
.36984 .39919 2.165 -1.25 Mabsadd L
.36984 .39919 0 2.5 Mabsadd L closepath F
.37302 .39725 0 2.5 Mabsadd m
.37302 .39725 -2.165 -1.25 Mabsadd L
.37302 .39725 2.165 -1.25 Mabsadd L
.37302 .39725 0 2.5 Mabsadd L closepath F
.37619 .39534 0 2.5 Mabsadd m
.37619 .39534 -2.165 -1.25 Mabsadd L
.37619 .39534 2.165 -1.25 Mabsadd L
.37619 .39534 0 2.5 Mabsadd L closepath F
.37937 .39344 0 2.5 Mabsadd m
.37937 .39344 -2.165 -1.25 Mabsadd L
.37937 .39344 2.165 -1.25 Mabsadd L
.37937 .39344 0 2.5 Mabsadd L closepath F
.38254 .39156 0 2.5 Mabsadd m
.38254 .39156 -2.165 -1.25 Mabsadd L
.38254 .39156 2.165 -1.25 Mabsadd L
.38254 .39156 0 2.5 Mabsadd L closepath F
.38571 .38971 0 2.5 Mabsadd m
.38571 .38971 -2.165 -1.25 Mabsadd L
.38571 .38971 2.165 -1.25 Mabsadd L
.38571 .38971 0 2.5 Mabsadd L closepath F
.38889 .38787 0 2.5 Mabsadd m
.38889 .38787 -2.165 -1.25 Mabsadd L
.38889 .38787 2.165 -1.25 Mabsadd L
.38889 .38787 0 2.5 Mabsadd L closepath F
.39206 .38604 0 2.5 Mabsadd m
.39206 .38604 -2.165 -1.25 Mabsadd L
.39206 .38604 2.165 -1.25 Mabsadd L
.39206 .38604 0 2.5 Mabsadd L closepath F
.39524 .38424 0 2.5 Mabsadd m
.39524 .38424 -2.165 -1.25 Mabsadd L
.39524 .38424 2.165 -1.25 Mabsadd L
.39524 .38424 0 2.5 Mabsadd L closepath F
.39841 .38245 0 2.5 Mabsadd m
.39841 .38245 -2.165 -1.25 Mabsadd L
.39841 .38245 2.165 -1.25 Mabsadd L
.39841 .38245 0 2.5 Mabsadd L closepath F
.40159 .38069 0 2.5 Mabsadd m
.40159 .38069 -2.165 -1.25 Mabsadd L
.40159 .38069 2.165 -1.25 Mabsadd L
.40159 .38069 0 2.5 Mabsadd L closepath F
.40476 .37894 0 2.5 Mabsadd m
.40476 .37894 -2.165 -1.25 Mabsadd L
.40476 .37894 2.165 -1.25 Mabsadd L
.40476 .37894 0 2.5 Mabsadd L closepath F
.40794 .3772 0 2.5 Mabsadd m
.40794 .3772 -2.165 -1.25 Mabsadd L
.40794 .3772 2.165 -1.25 Mabsadd L
.40794 .3772 0 2.5 Mabsadd L closepath F
.41111 .37549 0 2.5 Mabsadd m
.41111 .37549 -2.165 -1.25 Mabsadd L
.41111 .37549 2.165 -1.25 Mabsadd L
.41111 .37549 0 2.5 Mabsadd L closepath F
.41429 .37379 0 2.5 Mabsadd m
.41429 .37379 -2.165 -1.25 Mabsadd L
.41429 .37379 2.165 -1.25 Mabsadd L
.41429 .37379 0 2.5 Mabsadd L closepath F
.41746 .37211 0 2.5 Mabsadd m
.41746 .37211 -2.165 -1.25 Mabsadd L
.41746 .37211 2.165 -1.25 Mabsadd L
.41746 .37211 0 2.5 Mabsadd L closepath F
.42063 .37045 0 2.5 Mabsadd m
.42063 .37045 -2.165 -1.25 Mabsadd L
.42063 .37045 2.165 -1.25 Mabsadd L
.42063 .37045 0 2.5 Mabsadd L closepath F
.42381 .3688 0 2.5 Mabsadd m
.42381 .3688 -2.165 -1.25 Mabsadd L
.42381 .3688 2.165 -1.25 Mabsadd L
.42381 .3688 0 2.5 Mabsadd L closepath F
.42698 .36717 0 2.5 Mabsadd m
.42698 .36717 -2.165 -1.25 Mabsadd L
.42698 .36717 2.165 -1.25 Mabsadd L
.42698 .36717 0 2.5 Mabsadd L closepath F
.43016 .36555 0 2.5 Mabsadd m
.43016 .36555 -2.165 -1.25 Mabsadd L
.43016 .36555 2.165 -1.25 Mabsadd L
.43016 .36555 0 2.5 Mabsadd L closepath F
.43333 .36395 0 2.5 Mabsadd m
.43333 .36395 -2.165 -1.25 Mabsadd L
.43333 .36395 2.165 -1.25 Mabsadd L
.43333 .36395 0 2.5 Mabsadd L closepath F
.43651 .36237 0 2.5 Mabsadd m
.43651 .36237 -2.165 -1.25 Mabsadd L
.43651 .36237 2.165 -1.25 Mabsadd L
.43651 .36237 0 2.5 Mabsadd L closepath F
.43968 .3608 0 2.5 Mabsadd m
.43968 .3608 -2.165 -1.25 Mabsadd L
.43968 .3608 2.165 -1.25 Mabsadd L
.43968 .3608 0 2.5 Mabsadd L closepath F
.44286 .35925 0 2.5 Mabsadd m
.44286 .35925 -2.165 -1.25 Mabsadd L
.44286 .35925 2.165 -1.25 Mabsadd L
.44286 .35925 0 2.5 Mabsadd L closepath F
.44603 .35772 0 2.5 Mabsadd m
.44603 .35772 -2.165 -1.25 Mabsadd L
.44603 .35772 2.165 -1.25 Mabsadd L
.44603 .35772 0 2.5 Mabsadd L closepath F
.44921 .3562 0 2.5 Mabsadd m
.44921 .3562 -2.165 -1.25 Mabsadd L
.44921 .3562 2.165 -1.25 Mabsadd L
.44921 .3562 0 2.5 Mabsadd L closepath F
.45238 .35469 0 2.5 Mabsadd m
.45238 .35469 -2.165 -1.25 Mabsadd L
.45238 .35469 2.165 -1.25 Mabsadd L
.45238 .35469 0 2.5 Mabsadd L closepath F
.45556 .3532 0 2.5 Mabsadd m
.45556 .3532 -2.165 -1.25 Mabsadd L
.45556 .3532 2.165 -1.25 Mabsadd L
.45556 .3532 0 2.5 Mabsadd L closepath F
.45873 .35173 0 2.5 Mabsadd m
.45873 .35173 -2.165 -1.25 Mabsadd L
.45873 .35173 2.165 -1.25 Mabsadd L
.45873 .35173 0 2.5 Mabsadd L closepath F
.4619 .35027 0 2.5 Mabsadd m
.4619 .35027 -2.165 -1.25 Mabsadd L
.4619 .35027 2.165 -1.25 Mabsadd L
.4619 .35027 0 2.5 Mabsadd L closepath F
.46508 .34882 0 2.5 Mabsadd m
.46508 .34882 -2.165 -1.25 Mabsadd L
.46508 .34882 2.165 -1.25 Mabsadd L
.46508 .34882 0 2.5 Mabsadd L closepath F
.46825 .34739 0 2.5 Mabsadd m
.46825 .34739 -2.165 -1.25 Mabsadd L
.46825 .34739 2.165 -1.25 Mabsadd L
.46825 .34739 0 2.5 Mabsadd L closepath F
.47143 .34597 0 2.5 Mabsadd m
.47143 .34597 -2.165 -1.25 Mabsadd L
.47143 .34597 2.165 -1.25 Mabsadd L
.47143 .34597 0 2.5 Mabsadd L closepath F
.4746 .34457 0 2.5 Mabsadd m
.4746 .34457 -2.165 -1.25 Mabsadd L
.4746 .34457 2.165 -1.25 Mabsadd L
.4746 .34457 0 2.5 Mabsadd L closepath F
.47778 .34318 0 2.5 Mabsadd m
.47778 .34318 -2.165 -1.25 Mabsadd L
.47778 .34318 2.165 -1.25 Mabsadd L
.47778 .34318 0 2.5 Mabsadd L closepath F
.48095 .34181 0 2.5 Mabsadd m
.48095 .34181 -2.165 -1.25 Mabsadd L
.48095 .34181 2.165 -1.25 Mabsadd L
.48095 .34181 0 2.5 Mabsadd L closepath F
.48413 .34044 0 2.5 Mabsadd m
.48413 .34044 -2.165 -1.25 Mabsadd L
.48413 .34044 2.165 -1.25 Mabsadd L
.48413 .34044 0 2.5 Mabsadd L closepath F
.4873 .3391 0 2.5 Mabsadd m
.4873 .3391 -2.165 -1.25 Mabsadd L
.4873 .3391 2.165 -1.25 Mabsadd L
.4873 .3391 0 2.5 Mabsadd L closepath F
.49048 .33776 0 2.5 Mabsadd m
.49048 .33776 -2.165 -1.25 Mabsadd L
.49048 .33776 2.165 -1.25 Mabsadd L
.49048 .33776 0 2.5 Mabsadd L closepath F
.49365 .33644 0 2.5 Mabsadd m
.49365 .33644 -2.165 -1.25 Mabsadd L
.49365 .33644 2.165 -1.25 Mabsadd L
.49365 .33644 0 2.5 Mabsadd L closepath F
.49683 .33513 0 2.5 Mabsadd m
.49683 .33513 -2.165 -1.25 Mabsadd L
.49683 .33513 2.165 -1.25 Mabsadd L
.49683 .33513 0 2.5 Mabsadd L closepath F
.5 .33384 0 2.5 Mabsadd m
.5 .33384 -2.165 -1.25 Mabsadd L
.5 .33384 2.165 -1.25 Mabsadd L
.5 .33384 0 2.5 Mabsadd L closepath F
.50317 .33256 0 2.5 Mabsadd m
.50317 .33256 -2.165 -1.25 Mabsadd L
.50317 .33256 2.165 -1.25 Mabsadd L
.50317 .33256 0 2.5 Mabsadd L closepath F
.50635 .33129 0 2.5 Mabsadd m
.50635 .33129 -2.165 -1.25 Mabsadd L
.50635 .33129 2.165 -1.25 Mabsadd L
.50635 .33129 0 2.5 Mabsadd L closepath F
.50952 .33003 0 2.5 Mabsadd m
.50952 .33003 -2.165 -1.25 Mabsadd L
.50952 .33003 2.165 -1.25 Mabsadd L
.50952 .33003 0 2.5 Mabsadd L closepath F
.5127 .32879 0 2.5 Mabsadd m
.5127 .32879 -2.165 -1.25 Mabsadd L
.5127 .32879 2.165 -1.25 Mabsadd L
.5127 .32879 0 2.5 Mabsadd L closepath F
.51587 .32756 0 2.5 Mabsadd m
.51587 .32756 -2.165 -1.25 Mabsadd L
.51587 .32756 2.165 -1.25 Mabsadd L
.51587 .32756 0 2.5 Mabsadd L closepath F
.51905 .32634 0 2.5 Mabsadd m
.51905 .32634 -2.165 -1.25 Mabsadd L
.51905 .32634 2.165 -1.25 Mabsadd L
.51905 .32634 0 2.5 Mabsadd L closepath F
.52222 .32513 0 2.5 Mabsadd m
.52222 .32513 -2.165 -1.25 Mabsadd L
.52222 .32513 2.165 -1.25 Mabsadd L
.52222 .32513 0 2.5 Mabsadd L closepath F
.5254 .32394 0 2.5 Mabsadd m
.5254 .32394 -2.165 -1.25 Mabsadd L
.5254 .32394 2.165 -1.25 Mabsadd L
.5254 .32394 0 2.5 Mabsadd L closepath F
.52857 .32276 0 2.5 Mabsadd m
.52857 .32276 -2.165 -1.25 Mabsadd L
.52857 .32276 2.165 -1.25 Mabsadd L
.52857 .32276 0 2.5 Mabsadd L closepath F
.53175 .32159 0 2.5 Mabsadd m
.53175 .32159 -2.165 -1.25 Mabsadd L
.53175 .32159 2.165 -1.25 Mabsadd L
.53175 .32159 0 2.5 Mabsadd L closepath F
.53492 .32043 0 2.5 Mabsadd m
.53492 .32043 -2.165 -1.25 Mabsadd L
.53492 .32043 2.165 -1.25 Mabsadd L
.53492 .32043 0 2.5 Mabsadd L closepath F
.5381 .31928 0 2.5 Mabsadd m
.5381 .31928 -2.165 -1.25 Mabsadd L
.5381 .31928 2.165 -1.25 Mabsadd L
.5381 .31928 0 2.5 Mabsadd L closepath F
.54127 .31814 0 2.5 Mabsadd m
.54127 .31814 -2.165 -1.25 Mabsadd L
.54127 .31814 2.165 -1.25 Mabsadd L
.54127 .31814 0 2.5 Mabsadd L closepath F
.54444 .31702 0 2.5 Mabsadd m
.54444 .31702 -2.165 -1.25 Mabsadd L
.54444 .31702 2.165 -1.25 Mabsadd L
.54444 .31702 0 2.5 Mabsadd L closepath F
.54762 .31591 0 2.5 Mabsadd m
.54762 .31591 -2.165 -1.25 Mabsadd L
.54762 .31591 2.165 -1.25 Mabsadd L
.54762 .31591 0 2.5 Mabsadd L closepath F
.55079 .3148 0 2.5 Mabsadd m
.55079 .3148 -2.165 -1.25 Mabsadd L
.55079 .3148 2.165 -1.25 Mabsadd L
.55079 .3148 0 2.5 Mabsadd L closepath F
.55397 .31371 0 2.5 Mabsadd m
.55397 .31371 -2.165 -1.25 Mabsadd L
.55397 .31371 2.165 -1.25 Mabsadd L
.55397 .31371 0 2.5 Mabsadd L closepath F
.55714 .31263 0 2.5 Mabsadd m
.55714 .31263 -2.165 -1.25 Mabsadd L
.55714 .31263 2.165 -1.25 Mabsadd L
.55714 .31263 0 2.5 Mabsadd L closepath F
.56032 .31156 0 2.5 Mabsadd m
.56032 .31156 -2.165 -1.25 Mabsadd L
.56032 .31156 2.165 -1.25 Mabsadd L
.56032 .31156 0 2.5 Mabsadd L closepath F
.56349 .3105 0 2.5 Mabsadd m
.56349 .3105 -2.165 -1.25 Mabsadd L
.56349 .3105 2.165 -1.25 Mabsadd L
.56349 .3105 0 2.5 Mabsadd L closepath F
.56667 .30946 0 2.5 Mabsadd m
.56667 .30946 -2.165 -1.25 Mabsadd L
.56667 .30946 2.165 -1.25 Mabsadd L
.56667 .30946 0 2.5 Mabsadd L closepath F
.56984 .30842 0 2.5 Mabsadd m
.56984 .30842 -2.165 -1.25 Mabsadd L
.56984 .30842 2.165 -1.25 Mabsadd L
.56984 .30842 0 2.5 Mabsadd L closepath F
.57302 .30739 0 2.5 Mabsadd m
.57302 .30739 -2.165 -1.25 Mabsadd L
.57302 .30739 2.165 -1.25 Mabsadd L
.57302 .30739 0 2.5 Mabsadd L closepath F
.57619 .30637 0 2.5 Mabsadd m
.57619 .30637 -2.165 -1.25 Mabsadd L
.57619 .30637 2.165 -1.25 Mabsadd L
.57619 .30637 0 2.5 Mabsadd L closepath F
.57937 .30537 0 2.5 Mabsadd m
.57937 .30537 -2.165 -1.25 Mabsadd L
.57937 .30537 2.165 -1.25 Mabsadd L
.57937 .30537 0 2.5 Mabsadd L closepath F
.58254 .30437 0 2.5 Mabsadd m
.58254 .30437 -2.165 -1.25 Mabsadd L
.58254 .30437 2.165 -1.25 Mabsadd L
.58254 .30437 0 2.5 Mabsadd L closepath F
.58571 .30338 0 2.5 Mabsadd m
.58571 .30338 -2.165 -1.25 Mabsadd L
.58571 .30338 2.165 -1.25 Mabsadd L
.58571 .30338 0 2.5 Mabsadd L closepath F
.58889 .30241 0 2.5 Mabsadd m
.58889 .30241 -2.165 -1.25 Mabsadd L
.58889 .30241 2.165 -1.25 Mabsadd L
.58889 .30241 0 2.5 Mabsadd L closepath F
.59206 .30144 0 2.5 Mabsadd m
.59206 .30144 -2.165 -1.25 Mabsadd L
.59206 .30144 2.165 -1.25 Mabsadd L
.59206 .30144 0 2.5 Mabsadd L closepath F
.59524 .30048 0 2.5 Mabsadd m
.59524 .30048 -2.165 -1.25 Mabsadd L
.59524 .30048 2.165 -1.25 Mabsadd L
.59524 .30048 0 2.5 Mabsadd L closepath F
.59841 .29953 0 2.5 Mabsadd m
.59841 .29953 -2.165 -1.25 Mabsadd L
.59841 .29953 2.165 -1.25 Mabsadd L
.59841 .29953 0 2.5 Mabsadd L closepath F
.60159 .29859 0 2.5 Mabsadd m
.60159 .29859 -2.165 -1.25 Mabsadd L
.60159 .29859 2.165 -1.25 Mabsadd L
.60159 .29859 0 2.5 Mabsadd L closepath F
.60476 .29767 0 2.5 Mabsadd m
.60476 .29767 -2.165 -1.25 Mabsadd L
.60476 .29767 2.165 -1.25 Mabsadd L
.60476 .29767 0 2.5 Mabsadd L closepath F
.60794 .29675 0 2.5 Mabsadd m
.60794 .29675 -2.165 -1.25 Mabsadd L
.60794 .29675 2.165 -1.25 Mabsadd L
.60794 .29675 0 2.5 Mabsadd L closepath F
.61111 .29584 0 2.5 Mabsadd m
.61111 .29584 -2.165 -1.25 Mabsadd L
.61111 .29584 2.165 -1.25 Mabsadd L
.61111 .29584 0 2.5 Mabsadd L closepath F
.61429 .29493 0 2.5 Mabsadd m
.61429 .29493 -2.165 -1.25 Mabsadd L
.61429 .29493 2.165 -1.25 Mabsadd L
.61429 .29493 0 2.5 Mabsadd L closepath F
.61746 .29404 0 2.5 Mabsadd m
.61746 .29404 -2.165 -1.25 Mabsadd L
.61746 .29404 2.165 -1.25 Mabsadd L
.61746 .29404 0 2.5 Mabsadd L closepath F
.62063 .29316 0 2.5 Mabsadd m
.62063 .29316 -2.165 -1.25 Mabsadd L
.62063 .29316 2.165 -1.25 Mabsadd L
.62063 .29316 0 2.5 Mabsadd L closepath F
.62381 .29228 0 2.5 Mabsadd m
.62381 .29228 -2.165 -1.25 Mabsadd L
.62381 .29228 2.165 -1.25 Mabsadd L
.62381 .29228 0 2.5 Mabsadd L closepath F
.62698 .29142 0 2.5 Mabsadd m
.62698 .29142 -2.165 -1.25 Mabsadd L
.62698 .29142 2.165 -1.25 Mabsadd L
.62698 .29142 0 2.5 Mabsadd L closepath F
.63016 .29056 0 2.5 Mabsadd m
.63016 .29056 -2.165 -1.25 Mabsadd L
.63016 .29056 2.165 -1.25 Mabsadd L
.63016 .29056 0 2.5 Mabsadd L closepath F
.63333 .28971 0 2.5 Mabsadd m
.63333 .28971 -2.165 -1.25 Mabsadd L
.63333 .28971 2.165 -1.25 Mabsadd L
.63333 .28971 0 2.5 Mabsadd L closepath F
.63651 .28887 0 2.5 Mabsadd m
.63651 .28887 -2.165 -1.25 Mabsadd L
.63651 .28887 2.165 -1.25 Mabsadd L
.63651 .28887 0 2.5 Mabsadd L closepath F
.63968 .28804 0 2.5 Mabsadd m
.63968 .28804 -2.165 -1.25 Mabsadd L
.63968 .28804 2.165 -1.25 Mabsadd L
.63968 .28804 0 2.5 Mabsadd L closepath F
.64286 .28722 0 2.5 Mabsadd m
.64286 .28722 -2.165 -1.25 Mabsadd L
.64286 .28722 2.165 -1.25 Mabsadd L
.64286 .28722 0 2.5 Mabsadd L closepath F
.64603 .2864 0 2.5 Mabsadd m
.64603 .2864 -2.165 -1.25 Mabsadd L
.64603 .2864 2.165 -1.25 Mabsadd L
.64603 .2864 0 2.5 Mabsadd L closepath F
.64921 .28559 0 2.5 Mabsadd m
.64921 .28559 -2.165 -1.25 Mabsadd L
.64921 .28559 2.165 -1.25 Mabsadd L
.64921 .28559 0 2.5 Mabsadd L closepath F
.65238 .28479 0 2.5 Mabsadd m
.65238 .28479 -2.165 -1.25 Mabsadd L
.65238 .28479 2.165 -1.25 Mabsadd L
.65238 .28479 0 2.5 Mabsadd L closepath F
.65556 .284 0 2.5 Mabsadd m
.65556 .284 -2.165 -1.25 Mabsadd L
.65556 .284 2.165 -1.25 Mabsadd L
.65556 .284 0 2.5 Mabsadd L closepath F
.65873 .28322 0 2.5 Mabsadd m
.65873 .28322 -2.165 -1.25 Mabsadd L
.65873 .28322 2.165 -1.25 Mabsadd L
.65873 .28322 0 2.5 Mabsadd L closepath F
.6619 .28244 0 2.5 Mabsadd m
.6619 .28244 -2.165 -1.25 Mabsadd L
.6619 .28244 2.165 -1.25 Mabsadd L
.6619 .28244 0 2.5 Mabsadd L closepath F
.66508 .28168 0 2.5 Mabsadd m
.66508 .28168 -2.165 -1.25 Mabsadd L
.66508 .28168 2.165 -1.25 Mabsadd L
.66508 .28168 0 2.5 Mabsadd L closepath F
.66825 .28092 0 2.5 Mabsadd m
.66825 .28092 -2.165 -1.25 Mabsadd L
.66825 .28092 2.165 -1.25 Mabsadd L
.66825 .28092 0 2.5 Mabsadd L closepath F
.67143 .28016 0 2.5 Mabsadd m
.67143 .28016 -2.165 -1.25 Mabsadd L
.67143 .28016 2.165 -1.25 Mabsadd L
.67143 .28016 0 2.5 Mabsadd L closepath F
.6746 .27942 0 2.5 Mabsadd m
.6746 .27942 -2.165 -1.25 Mabsadd L
.6746 .27942 2.165 -1.25 Mabsadd L
.6746 .27942 0 2.5 Mabsadd L closepath F
.67778 .27868 0 2.5 Mabsadd m
.67778 .27868 -2.165 -1.25 Mabsadd L
.67778 .27868 2.165 -1.25 Mabsadd L
.67778 .27868 0 2.5 Mabsadd L closepath F
.68095 .27795 0 2.5 Mabsadd m
.68095 .27795 -2.165 -1.25 Mabsadd L
.68095 .27795 2.165 -1.25 Mabsadd L
.68095 .27795 0 2.5 Mabsadd L closepath F
.68413 .27723 0 2.5 Mabsadd m
.68413 .27723 -2.165 -1.25 Mabsadd L
.68413 .27723 2.165 -1.25 Mabsadd L
.68413 .27723 0 2.5 Mabsadd L closepath F
.6873 .27651 0 2.5 Mabsadd m
.6873 .27651 -2.165 -1.25 Mabsadd L
.6873 .27651 2.165 -1.25 Mabsadd L
.6873 .27651 0 2.5 Mabsadd L closepath F
.69048 .27581 0 2.5 Mabsadd m
.69048 .27581 -2.165 -1.25 Mabsadd L
.69048 .27581 2.165 -1.25 Mabsadd L
.69048 .27581 0 2.5 Mabsadd L closepath F
.69365 .2751 0 2.5 Mabsadd m
.69365 .2751 -2.165 -1.25 Mabsadd L
.69365 .2751 2.165 -1.25 Mabsadd L
.69365 .2751 0 2.5 Mabsadd L closepath F
.69683 .27441 0 2.5 Mabsadd m
.69683 .27441 -2.165 -1.25 Mabsadd L
.69683 .27441 2.165 -1.25 Mabsadd L
.69683 .27441 0 2.5 Mabsadd L closepath F
.7 .27372 0 2.5 Mabsadd m
.7 .27372 -2.165 -1.25 Mabsadd L
.7 .27372 2.165 -1.25 Mabsadd L
.7 .27372 0 2.5 Mabsadd L closepath F
.70317 .27304 0 2.5 Mabsadd m
.70317 .27304 -2.165 -1.25 Mabsadd L
.70317 .27304 2.165 -1.25 Mabsadd L
.70317 .27304 0 2.5 Mabsadd L closepath F
.70635 .27237 0 2.5 Mabsadd m
.70635 .27237 -2.165 -1.25 Mabsadd L
.70635 .27237 2.165 -1.25 Mabsadd L
.70635 .27237 0 2.5 Mabsadd L closepath F
.70952 .2717 0 2.5 Mabsadd m
.70952 .2717 -2.165 -1.25 Mabsadd L
.70952 .2717 2.165 -1.25 Mabsadd L
.70952 .2717 0 2.5 Mabsadd L closepath F
.7127 .27104 0 2.5 Mabsadd m
.7127 .27104 -2.165 -1.25 Mabsadd L
.7127 .27104 2.165 -1.25 Mabsadd L
.7127 .27104 0 2.5 Mabsadd L closepath F
.71587 .27039 0 2.5 Mabsadd m
.71587 .27039 -2.165 -1.25 Mabsadd L
.71587 .27039 2.165 -1.25 Mabsadd L
.71587 .27039 0 2.5 Mabsadd L closepath F
.71905 .26974 0 2.5 Mabsadd m
.71905 .26974 -2.165 -1.25 Mabsadd L
.71905 .26974 2.165 -1.25 Mabsadd L
.71905 .26974 0 2.5 Mabsadd L closepath F
.72222 .2691 0 2.5 Mabsadd m
.72222 .2691 -2.165 -1.25 Mabsadd L
.72222 .2691 2.165 -1.25 Mabsadd L
.72222 .2691 0 2.5 Mabsadd L closepath F
.7254 .26847 0 2.5 Mabsadd m
.7254 .26847 -2.165 -1.25 Mabsadd L
.7254 .26847 2.165 -1.25 Mabsadd L
.7254 .26847 0 2.5 Mabsadd L closepath F
.72857 .26784 0 2.5 Mabsadd m
.72857 .26784 -2.165 -1.25 Mabsadd L
.72857 .26784 2.165 -1.25 Mabsadd L
.72857 .26784 0 2.5 Mabsadd L closepath F
.73175 .26722 0 2.5 Mabsadd m
.73175 .26722 -2.165 -1.25 Mabsadd L
.73175 .26722 2.165 -1.25 Mabsadd L
.73175 .26722 0 2.5 Mabsadd L closepath F
.73492 .2666 0 2.5 Mabsadd m
.73492 .2666 -2.165 -1.25 Mabsadd L
.73492 .2666 2.165 -1.25 Mabsadd L
.73492 .2666 0 2.5 Mabsadd L closepath F
.7381 .26599 0 2.5 Mabsadd m
.7381 .26599 -2.165 -1.25 Mabsadd L
.7381 .26599 2.165 -1.25 Mabsadd L
.7381 .26599 0 2.5 Mabsadd L closepath F
.74127 .26539 0 2.5 Mabsadd m
.74127 .26539 -2.165 -1.25 Mabsadd L
.74127 .26539 2.165 -1.25 Mabsadd L
.74127 .26539 0 2.5 Mabsadd L closepath F
.74444 .26479 0 2.5 Mabsadd m
.74444 .26479 -2.165 -1.25 Mabsadd L
.74444 .26479 2.165 -1.25 Mabsadd L
.74444 .26479 0 2.5 Mabsadd L closepath F
.74762 .2642 0 2.5 Mabsadd m
.74762 .2642 -2.165 -1.25 Mabsadd L
.74762 .2642 2.165 -1.25 Mabsadd L
.74762 .2642 0 2.5 Mabsadd L closepath F
.75079 .26362 0 2.5 Mabsadd m
.75079 .26362 -2.165 -1.25 Mabsadd L
.75079 .26362 2.165 -1.25 Mabsadd L
.75079 .26362 0 2.5 Mabsadd L closepath F
.75397 .26304 0 2.5 Mabsadd m
.75397 .26304 -2.165 -1.25 Mabsadd L
.75397 .26304 2.165 -1.25 Mabsadd L
.75397 .26304 0 2.5 Mabsadd L closepath F
.75714 .26246 0 2.5 Mabsadd m
.75714 .26246 -2.165 -1.25 Mabsadd L
.75714 .26246 2.165 -1.25 Mabsadd L
.75714 .26246 0 2.5 Mabsadd L closepath F
.76032 .2619 0 2.5 Mabsadd m
.76032 .2619 -2.165 -1.25 Mabsadd L
.76032 .2619 2.165 -1.25 Mabsadd L
.76032 .2619 0 2.5 Mabsadd L closepath F
.76349 .26133 0 2.5 Mabsadd m
.76349 .26133 -2.165 -1.25 Mabsadd L
.76349 .26133 2.165 -1.25 Mabsadd L
.76349 .26133 0 2.5 Mabsadd L closepath F
.76667 .26078 0 2.5 Mabsadd m
.76667 .26078 -2.165 -1.25 Mabsadd L
.76667 .26078 2.165 -1.25 Mabsadd L
.76667 .26078 0 2.5 Mabsadd L closepath F
.76984 .26023 0 2.5 Mabsadd m
.76984 .26023 -2.165 -1.25 Mabsadd L
.76984 .26023 2.165 -1.25 Mabsadd L
.76984 .26023 0 2.5 Mabsadd L closepath F
.77302 .25968 0 2.5 Mabsadd m
.77302 .25968 -2.165 -1.25 Mabsadd L
.77302 .25968 2.165 -1.25 Mabsadd L
.77302 .25968 0 2.5 Mabsadd L closepath F
.77619 .25914 0 2.5 Mabsadd m
.77619 .25914 -2.165 -1.25 Mabsadd L
.77619 .25914 2.165 -1.25 Mabsadd L
.77619 .25914 0 2.5 Mabsadd L closepath F
.77937 .25861 0 2.5 Mabsadd m
.77937 .25861 -2.165 -1.25 Mabsadd L
.77937 .25861 2.165 -1.25 Mabsadd L
.77937 .25861 0 2.5 Mabsadd L closepath F
.78254 .25808 0 2.5 Mabsadd m
.78254 .25808 -2.165 -1.25 Mabsadd L
.78254 .25808 2.165 -1.25 Mabsadd L
.78254 .25808 0 2.5 Mabsadd L closepath F
.78571 .25755 0 2.5 Mabsadd m
.78571 .25755 -2.165 -1.25 Mabsadd L
.78571 .25755 2.165 -1.25 Mabsadd L
.78571 .25755 0 2.5 Mabsadd L closepath F
.78889 .25703 0 2.5 Mabsadd m
.78889 .25703 -2.165 -1.25 Mabsadd L
.78889 .25703 2.165 -1.25 Mabsadd L
.78889 .25703 0 2.5 Mabsadd L closepath F
.79206 .25652 0 2.5 Mabsadd m
.79206 .25652 -2.165 -1.25 Mabsadd L
.79206 .25652 2.165 -1.25 Mabsadd L
.79206 .25652 0 2.5 Mabsadd L closepath F
.79524 .25601 0 2.5 Mabsadd m
.79524 .25601 -2.165 -1.25 Mabsadd L
.79524 .25601 2.165 -1.25 Mabsadd L
.79524 .25601 0 2.5 Mabsadd L closepath F
.79841 .25551 0 2.5 Mabsadd m
.79841 .25551 -2.165 -1.25 Mabsadd L
.79841 .25551 2.165 -1.25 Mabsadd L
.79841 .25551 0 2.5 Mabsadd L closepath F
.80159 .25501 0 2.5 Mabsadd m
.80159 .25501 -2.165 -1.25 Mabsadd L
.80159 .25501 2.165 -1.25 Mabsadd L
.80159 .25501 0 2.5 Mabsadd L closepath F
.80476 .25452 0 2.5 Mabsadd m
.80476 .25452 -2.165 -1.25 Mabsadd L
.80476 .25452 2.165 -1.25 Mabsadd L
.80476 .25452 0 2.5 Mabsadd L closepath F
.80794 .25403 0 2.5 Mabsadd m
.80794 .25403 -2.165 -1.25 Mabsadd L
.80794 .25403 2.165 -1.25 Mabsadd L
.80794 .25403 0 2.5 Mabsadd L closepath F
.81111 .25355 0 2.5 Mabsadd m
.81111 .25355 -2.165 -1.25 Mabsadd L
.81111 .25355 2.165 -1.25 Mabsadd L
.81111 .25355 0 2.5 Mabsadd L closepath F
.81429 .25307 0 2.5 Mabsadd m
.81429 .25307 -2.165 -1.25 Mabsadd L
.81429 .25307 2.165 -1.25 Mabsadd L
.81429 .25307 0 2.5 Mabsadd L closepath F
.81746 .25259 0 2.5 Mabsadd m
.81746 .25259 -2.165 -1.25 Mabsadd L
.81746 .25259 2.165 -1.25 Mabsadd L
.81746 .25259 0 2.5 Mabsadd L closepath F
.82063 .25212 0 2.5 Mabsadd m
.82063 .25212 -2.165 -1.25 Mabsadd L
.82063 .25212 2.165 -1.25 Mabsadd L
.82063 .25212 0 2.5 Mabsadd L closepath F
.82381 .25166 0 2.5 Mabsadd m
.82381 .25166 -2.165 -1.25 Mabsadd L
.82381 .25166 2.165 -1.25 Mabsadd L
.82381 .25166 0 2.5 Mabsadd L closepath F
.82698 .2512 0 2.5 Mabsadd m
.82698 .2512 -2.165 -1.25 Mabsadd L
.82698 .2512 2.165 -1.25 Mabsadd L
.82698 .2512 0 2.5 Mabsadd L closepath F
.83016 .25075 0 2.5 Mabsadd m
.83016 .25075 -2.165 -1.25 Mabsadd L
.83016 .25075 2.165 -1.25 Mabsadd L
.83016 .25075 0 2.5 Mabsadd L closepath F
.83333 .2503 0 2.5 Mabsadd m
.83333 .2503 -2.165 -1.25 Mabsadd L
.83333 .2503 2.165 -1.25 Mabsadd L
.83333 .2503 0 2.5 Mabsadd L closepath F
.83651 .24985 0 2.5 Mabsadd m
.83651 .24985 -2.165 -1.25 Mabsadd L
.83651 .24985 2.165 -1.25 Mabsadd L
.83651 .24985 0 2.5 Mabsadd L closepath F
.83968 .24941 0 2.5 Mabsadd m
.83968 .24941 -2.165 -1.25 Mabsadd L
.83968 .24941 2.165 -1.25 Mabsadd L
.83968 .24941 0 2.5 Mabsadd L closepath F
.84286 .24897 0 2.5 Mabsadd m
.84286 .24897 -2.165 -1.25 Mabsadd L
.84286 .24897 2.165 -1.25 Mabsadd L
.84286 .24897 0 2.5 Mabsadd L closepath F
.84603 .24854 0 2.5 Mabsadd m
.84603 .24854 -2.165 -1.25 Mabsadd L
.84603 .24854 2.165 -1.25 Mabsadd L
.84603 .24854 0 2.5 Mabsadd L closepath F
.84921 .24811 0 2.5 Mabsadd m
.84921 .24811 -2.165 -1.25 Mabsadd L
.84921 .24811 2.165 -1.25 Mabsadd L
.84921 .24811 0 2.5 Mabsadd L closepath F
.85238 .24768 0 2.5 Mabsadd m
.85238 .24768 -2.165 -1.25 Mabsadd L
.85238 .24768 2.165 -1.25 Mabsadd L
.85238 .24768 0 2.5 Mabsadd L closepath F
.85556 .24726 0 2.5 Mabsadd m
.85556 .24726 -2.165 -1.25 Mabsadd L
.85556 .24726 2.165 -1.25 Mabsadd L
.85556 .24726 0 2.5 Mabsadd L closepath F
.85873 .24685 0 2.5 Mabsadd m
.85873 .24685 -2.165 -1.25 Mabsadd L
.85873 .24685 2.165 -1.25 Mabsadd L
.85873 .24685 0 2.5 Mabsadd L closepath F
.8619 .24644 0 2.5 Mabsadd m
.8619 .24644 -2.165 -1.25 Mabsadd L
.8619 .24644 2.165 -1.25 Mabsadd L
.8619 .24644 0 2.5 Mabsadd L closepath F
.86508 .24603 0 2.5 Mabsadd m
.86508 .24603 -2.165 -1.25 Mabsadd L
.86508 .24603 2.165 -1.25 Mabsadd L
.86508 .24603 0 2.5 Mabsadd L closepath F
.86825 .24563 0 2.5 Mabsadd m
.86825 .24563 -2.165 -1.25 Mabsadd L
.86825 .24563 2.165 -1.25 Mabsadd L
.86825 .24563 0 2.5 Mabsadd L closepath F
.87143 .24523 0 2.5 Mabsadd m
.87143 .24523 -2.165 -1.25 Mabsadd L
.87143 .24523 2.165 -1.25 Mabsadd L
.87143 .24523 0 2.5 Mabsadd L closepath F
.8746 .24483 0 2.5 Mabsadd m
.8746 .24483 -2.165 -1.25 Mabsadd L
.8746 .24483 2.165 -1.25 Mabsadd L
.8746 .24483 0 2.5 Mabsadd L closepath F
.87778 .24444 0 2.5 Mabsadd m
.87778 .24444 -2.165 -1.25 Mabsadd L
.87778 .24444 2.165 -1.25 Mabsadd L
.87778 .24444 0 2.5 Mabsadd L closepath F
.88095 .24405 0 2.5 Mabsadd m
.88095 .24405 -2.165 -1.25 Mabsadd L
.88095 .24405 2.165 -1.25 Mabsadd L
.88095 .24405 0 2.5 Mabsadd L closepath F
.88413 .24367 0 2.5 Mabsadd m
.88413 .24367 -2.165 -1.25 Mabsadd L
.88413 .24367 2.165 -1.25 Mabsadd L
.88413 .24367 0 2.5 Mabsadd L closepath F
.8873 .24329 0 2.5 Mabsadd m
.8873 .24329 -2.165 -1.25 Mabsadd L
.8873 .24329 2.165 -1.25 Mabsadd L
.8873 .24329 0 2.5 Mabsadd L closepath F
.89048 .24291 0 2.5 Mabsadd m
.89048 .24291 -2.165 -1.25 Mabsadd L
.89048 .24291 2.165 -1.25 Mabsadd L
.89048 .24291 0 2.5 Mabsadd L closepath F
.89365 .24254 0 2.5 Mabsadd m
.89365 .24254 -2.165 -1.25 Mabsadd L
.89365 .24254 2.165 -1.25 Mabsadd L
.89365 .24254 0 2.5 Mabsadd L closepath F
.89683 .24217 0 2.5 Mabsadd m
.89683 .24217 -2.165 -1.25 Mabsadd L
.89683 .24217 2.165 -1.25 Mabsadd L
.89683 .24217 0 2.5 Mabsadd L closepath F
.9 .24181 0 2.5 Mabsadd m
.9 .24181 -2.165 -1.25 Mabsadd L
.9 .24181 2.165 -1.25 Mabsadd L
.9 .24181 0 2.5 Mabsadd L closepath F
.90317 .24145 0 2.5 Mabsadd m
.90317 .24145 -2.165 -1.25 Mabsadd L
.90317 .24145 2.165 -1.25 Mabsadd L
.90317 .24145 0 2.5 Mabsadd L closepath F
.90635 .24109 0 2.5 Mabsadd m
.90635 .24109 -2.165 -1.25 Mabsadd L
.90635 .24109 2.165 -1.25 Mabsadd L
.90635 .24109 0 2.5 Mabsadd L closepath F
.90952 .24073 0 2.5 Mabsadd m
.90952 .24073 -2.165 -1.25 Mabsadd L
.90952 .24073 2.165 -1.25 Mabsadd L
.90952 .24073 0 2.5 Mabsadd L closepath F
.9127 .24038 0 2.5 Mabsadd m
.9127 .24038 -2.165 -1.25 Mabsadd L
.9127 .24038 2.165 -1.25 Mabsadd L
.9127 .24038 0 2.5 Mabsadd L closepath F
.91587 .24004 0 2.5 Mabsadd m
.91587 .24004 -2.165 -1.25 Mabsadd L
.91587 .24004 2.165 -1.25 Mabsadd L
.91587 .24004 0 2.5 Mabsadd L closepath F
.91905 .23969 0 2.5 Mabsadd m
.91905 .23969 -2.165 -1.25 Mabsadd L
.91905 .23969 2.165 -1.25 Mabsadd L
.91905 .23969 0 2.5 Mabsadd L closepath F
.92222 .23935 0 2.5 Mabsadd m
.92222 .23935 -2.165 -1.25 Mabsadd L
.92222 .23935 2.165 -1.25 Mabsadd L
.92222 .23935 0 2.5 Mabsadd L closepath F
.9254 .23902 0 2.5 Mabsadd m
.9254 .23902 -2.165 -1.25 Mabsadd L
.9254 .23902 2.165 -1.25 Mabsadd L
.9254 .23902 0 2.5 Mabsadd L closepath F
.92857 .23868 0 2.5 Mabsadd m
.92857 .23868 -2.165 -1.25 Mabsadd L
.92857 .23868 2.165 -1.25 Mabsadd L
.92857 .23868 0 2.5 Mabsadd L closepath F
.93175 .23835 0 2.5 Mabsadd m
.93175 .23835 -2.165 -1.25 Mabsadd L
.93175 .23835 2.165 -1.25 Mabsadd L
.93175 .23835 0 2.5 Mabsadd L closepath F
.93492 .23803 0 2.5 Mabsadd m
.93492 .23803 -2.165 -1.25 Mabsadd L
.93492 .23803 2.165 -1.25 Mabsadd L
.93492 .23803 0 2.5 Mabsadd L closepath F
.9381 .2377 0 2.5 Mabsadd m
.9381 .2377 -2.165 -1.25 Mabsadd L
.9381 .2377 2.165 -1.25 Mabsadd L
.9381 .2377 0 2.5 Mabsadd L closepath F
.94127 .23738 0 2.5 Mabsadd m
.94127 .23738 -2.165 -1.25 Mabsadd L
.94127 .23738 2.165 -1.25 Mabsadd L
.94127 .23738 0 2.5 Mabsadd L closepath F
.94444 .23707 0 2.5 Mabsadd m
.94444 .23707 -2.165 -1.25 Mabsadd L
.94444 .23707 2.165 -1.25 Mabsadd L
.94444 .23707 0 2.5 Mabsadd L closepath F
.94762 .23675 0 2.5 Mabsadd m
.94762 .23675 -2.165 -1.25 Mabsadd L
.94762 .23675 2.165 -1.25 Mabsadd L
.94762 .23675 0 2.5 Mabsadd L closepath F
.95079 .23644 0 2.5 Mabsadd m
.95079 .23644 -2.165 -1.25 Mabsadd L
.95079 .23644 2.165 -1.25 Mabsadd L
.95079 .23644 0 2.5 Mabsadd L closepath F
.95397 .23613 0 2.5 Mabsadd m
.95397 .23613 -2.165 -1.25 Mabsadd L
.95397 .23613 2.165 -1.25 Mabsadd L
.95397 .23613 0 2.5 Mabsadd L closepath F
.95714 .23583 0 2.5 Mabsadd m
.95714 .23583 -2.165 -1.25 Mabsadd L
.95714 .23583 2.165 -1.25 Mabsadd L
.95714 .23583 0 2.5 Mabsadd L closepath F
.96032 .23553 0 2.5 Mabsadd m
.96032 .23553 -2.165 -1.25 Mabsadd L
.96032 .23553 2.165 -1.25 Mabsadd L
.96032 .23553 0 2.5 Mabsadd L closepath F
.96349 .23523 0 2.5 Mabsadd m
.96349 .23523 -2.165 -1.25 Mabsadd L
.96349 .23523 2.165 -1.25 Mabsadd L
.96349 .23523 0 2.5 Mabsadd L closepath F
.96667 .23493 0 2.5 Mabsadd m
.96667 .23493 -2.165 -1.25 Mabsadd L
.96667 .23493 2.165 -1.25 Mabsadd L
.96667 .23493 0 2.5 Mabsadd L closepath F
.96984 .23464 0 2.5 Mabsadd m
.96984 .23464 -2.165 -1.25 Mabsadd L
.96984 .23464 2.165 -1.25 Mabsadd L
.96984 .23464 0 2.5 Mabsadd L closepath F
.97302 .23435 0 2.5 Mabsadd m
.97302 .23435 -2.165 -1.25 Mabsadd L
.97302 .23435 2.165 -1.25 Mabsadd L
.97302 .23435 0 2.5 Mabsadd L closepath F
.97619 .23407 0 2.5 Mabsadd m
.97619 .23407 -2.165 -1.25 Mabsadd L
.97619 .23407 2.165 -1.25 Mabsadd L
.97619 .23407 0 2.5 Mabsadd L closepath F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 355.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900001Hb000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oo
oo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX0
0?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z000hoookJPGo0000oooonf[ooookJPGooo]Z
000hoookJPGo0000oooonf[ooookJPGooo]Z000hoookJPGo0000oooonf[ooookJPGooo]Z000hoook
JPGo0000oooonf[ooookJPGooo]Z000hoookJPGo0000oooonf[ooookJPGooo]Z000KoookJPGo001o
1?oonfX3o`00O`?ooo]Z1Ol007l9oookJPGo0000oooonf[ooookJPGooo]Z000JoookJPOo001o0ooo
nfX3o`00O`;ooo]Z1ol007l8oookJPGo0000oooonf[ooookJPGooo]Z000JoookJP?o001o00Cooo]Z
o`00Ool007oo001o0ooonfX3o`00O`03oookJ_l007oo001o00;o001o00Cooo]Zo`00Ool007oo001o
2?oonfX5o`000?oooo]ZoooonfX5oookJP003OoonfX:o`00O`;ooo]Z0ol007l3oookJP?o001o1_oo
nfX3o`00O`?ooo]Z0ol007l7oookJPGo0000oooonf[ooookJPGooo]Z000=oookJP[o001o0_oonfX3
o`00O`?ooo]Z0ol007l<oookJP?o001o1ooonfX6o`000?oooo]ZoooonfX4oookJP006OoonfX3o`00
O`?ooo]Z0ol007l<oookJP?o001o1ooonfX8o`000?oooo]ZoooonfX2oookJP006OoonfX3o`00O`?o
oo]Z0ol007l7oookJP;o001o0_oonfX4o`00O`Oooo]Z2_l0003ooookJ_oooo]Z000IoookJP?o001o
0ooonfX3o`00O`Oooo]Z1ol007l8oookJP_o0000oooonf[noookJP006OoonfX3o`00O`?ooo]Z0ol0
07l7oookJPKo001o2OoonfX=o`000?oooo]Zo?oonfX001Wooo]Z0ol007l3oookJP?o001o1ooonfX2
o`00O`gooo]Z3ol0003ooookJ_[ooo]Z000JoookJP?o001o00Cooo]Zo`00Ool007oo001o2?oonfX2
o`00O`gooo]Z1Ol00002oookJP03o`000?oonf[o000000Ko0000oooonf[ioookJP006_oonfX7o`00
O`Wooo]Z1ol007l7oookJPGo00001OoonfX8o`000?oooo]ZmooonfX001_ooo]Z1Ol007l:oookJPOo
001o1ooonfX5o`0000Oooo]Z2?l0003ooookJ_Gooo]Z000hoookJPGo00002OoonfX7o`000?oooo]Z
m?oonfX003Sooo]Z1Ol0000:oookJP[o0000oooonf[`oookJP00>?oonfX5o`0000cooo]Z2Ol0003o
oookJ^oooo]Z000hoookJPGo00003_oonfX9o`000?oooo]ZkOoonfX003Sooo]Z1Ol0000?oookJP[o
0000oooonf[[oookJP00>?oonfX5o`00017ooo]Z2Ol0003ooookJ^[ooo]Z000hoookJPGo00004ooo
nfX9o`000?oooo]Zj?oonfX003Sooo]Z1Ol0000DoookJP[o0000oooonf[VoookJP00>?oonfX5o`00
01Kooo]Z2ol0003ooookJ^?ooo]Z000hoookJPGo00006?oonfX;o`000?oooo]ZhOoonfX003Sooo]Z
1Ol0000KoookJPWo0000oooonf[PoookJP00>?oonfX5o`0001gooo]Z2Ol0003ooookJ]kooo]Z000h
oookJPGo00007_oonfX;o`000?oooo]ZfooonfX003Sooo]Z1Ol0000PoookJP_o0000oooonf[Ioook
JP00>?oonfX5o`0002;ooo]Z2ol0003ooookJ]Oooo]Z000hoookJPGo00009OoonfX9o`000?oooo]Z
e_oonfX003Sooo]Z1Ol0000WoookJP_o0000oooonf[BoookJP00>?oonfX5o`0002Sooo]Z2ol0003o
oookJ]7ooo]Z000hoookJPGo0000:_oonfX00ol0003ooo]Zo`000008o`000?oooo]ZcooonfX003So
oo]Z1Ol0000]oookJP_o0000oooonf[<oookJP00>?oonfX5o`0002oooo]Z2ol0003ooookJ/[ooo]Z
000hoookJPGo0000<_oonfX;o`000?oooo]ZaooonfX003Sooo]Z1Ol0000doookJP_o0000oooonf[5
oookJP00>?oonfX5o`0003Kooo]Z3?l0003ooookJ/;ooo]Z000hoookJPGo0000=ooonfX00ol0003o
oo]Zo`00000:o`000?oooo]Z`?oonfX003Sooo]Z1Ol0000koookJPco0000oooonfZmoookJP00>?oo
nfX5o`0003cooo]Z00?o0000oookJ_l000002_l0003ooookJ[_ooo]Z000hoookJPGo0000@?oonfX<
o`000?oooo]Z^?oonfX003Sooo]Z1Ol00011oookJP03o`000?oonf[o000000[o0000oooonfZfoook
JP00>?oonfX5o`0004Gooo]Z3?l0003ooookJ[?ooo]Z000hoookJPGo0000A_oonfX00ol0003ooo]Z
o`00000:o`000?oooo]Z/OoonfX003Sooo]Z1Ol0001:oookJPco0000oooonfZ^oookJP00>?oonfX5
o`0004_ooo]Z00?o0000oookJ_l000003?l0003ooookJZ[ooo]Z000hoookJPGo0000D?oonfX;o`00
0?oooo]ZZOoonfX003Sooo]Z1Ol0001BoookJPgo0000oooonfZUoookJP00>?oonfX5o`0005Gooo]Z
3Ol0003ooookJZ;ooo]Z000hoookJPGo0000EooonfX00ol0003ooo]Zo`00000;o`000?oooo]ZWooo
nfX003Sooo]Z1Ol0001JoookJPoo0000oooonfZKoookJP004OoonfX5o`00O`Cooo]Z0ol007l00ooo
nf[o001oo`00O`07o`00O`?ooo]Z1Ol007l9oookJPGo0000G?oonfX00ol0003ooo]Zo`00000;o`00
0?oooo]ZV_oonfX0013ooo]Z1ol007l3oookJP?o001o00?ooo]Zo`00Ool007l01ol007l2oookJPOo
001o2?oonfX5o`0005oooo]Z00?o0000oookJ_l000003?l0003ooookJYKooo]Z000@oookJP?o001o
00Cooo]Zo`00Ool007oo001o0ooonfX3o`00O`03oookJ_l007oo001o00;o001o1_oonfX4o`00O`04
oookJ_l007oo001oo`00O`Sooo]Z1Ol0001ToookJPgo0000oooonfZCoookJP000ooonfX:o`00O`;o
oo]Z0ol007l3oookJP?o001o1ooonfX4o`00O`Gooo]Z0ol007l3oookJP?o001o1ooonfX5o`0006Ko
oo]Z00?o0000oookJ_l000002ol0003ooookJY3ooo]Z0003oookJP[o001o0_oonfX3o`00O`?ooo]Z
0ol007l8oookJPGo001o2OoonfX3o`00O`Oooo]Z1_l0001XoookJPoo0000oooonfZ<oookJP003ooo
nfX3o`00O`?ooo]Z0ol007l:oookJPCo001o2?oonfX3o`00O`Oooo]Z1Ol0001[oookJP03o`000?oo
nf[o000000go0000oooonfZ9oookJP003ooonfX3o`00O`?ooo]Z0ol007l;oookJP?o001o0ooonfX2
o`00O`;ooo]Z1?l007l7oookJPGo0000K_oonfX00ol0003ooo]Zo`00000=o`000?oooo]ZQ_oonfX0
00oooo]Z0ol007l3oookJP?o001o3?oonfX3o`00O`;ooo]Z1ol007l8oookJPGo0000LooonfX@o`00
0?oooo]ZPOoonfX000oooo]Z0ol007l3oookJP?o001o1_oonfX3o`00O`?ooo]Z0ol007l2oookJPKo
001o2OoonfX5o`0007Gooo]Z00?o0000oookJ_l000003ol0003ooookJWgooo]Z000?oookJP?o001o
0ooonfX3o`00O`Kooo]Z0ol007l3oookJP?o001o0_oonfX2o`00O`gooo]Z1Ol0001hoookJP03o`00
0?oonf[o000000oo0000oooonfYjoookJP004?oonfX3o`00O`04oookJ_l007oo001oo`00O`Oooo]Z
1?l007l2oookJP?o001o0_oonfX2o`00O`gooo]Z1Ol0001moookJP03o`000?oonf[o000000go0000
oooonfYgoookJP004?oonfX7o`00O`Sooo]Z1ol007l4oookJPOo001o1ooonfX5o`0008;ooo]Z4?l0
003ooookJW;ooo]Z000AoookJPGo001o2_oonfX5o`00O`Gooo]Z1ol007l7oookJPGo0000Q?oonfX0
0ol0003ooo]Zo`00000?o`000?oooo]ZK_oonfX003Sooo]Z1Ol00027oookJP03o`000?oonf[o0000
017o0000oooonfYYoookJP00>?oonfX5o`0008cooo]Z00?o0000oookJ_l000003ol0003ooookJVKo
oo]Z000hoookJPGo0000TOoonfXBo`000?oooo]ZHOoonfX003Sooo]Z1Ol0002CoookJP03o`000?oo
nf[o0000013o0000oooonfYNoookJP00>?oonfX5o`0009Kooo]Z00Co0000oookJ_l0003ooo]Z4Ol0
003ooookJUWooo]Z000hoookJPGo0000VooonfX00ol0003ooo]Zo`00000Bo`000?oooo]ZE?oonfX0
03Sooo]Z1Ol0002PoookJP03o`000?oonf[o000001;o0000oooonfY?oookJP00>?oonfX5o`000:?o
oo]Z00Co0000oookJ_l0003ooo]Z4ol0003ooookJT[ooo]Z000hoookJPGo0000Z?oonfX01?l0003o
oo]Zo`000?oonfXCo`000?oooo]ZAOoonfX003Sooo]Z1Ol0002]oookJP04o`000?oonf[o0000oook
JQ?o0000oooonfY0oookJP00>?oonfX5o`000;;ooo]Z00?o0000oookJ_l000005_l0003ooookJSWo
oo]Z000hoookJPGo0000]_oonfX2o`000003oookJ_l0003o000001Go0000oooonfXdoookJP00>?oo
nfX5o`000;_ooo]Z0_l000000ooonf[o0000oookJP0Eo`000?oooo]Z;ooonfX003Sooo]Z1Ol00031
oookJP04o`000?oonf[o0000oookJQKo0000oooonfXYoookJP00>?oonfX5o`000<Kooo]Z00Co0000
oookJ_l0003ooo]Z6?l0003ooookJR;ooo]Z000hoookJPGo0000booonfX01?l0003ooo]Zo`000?oo
nfXJo`000?oooo]Z6ooonfX003Sooo]Z1Ol0003BoookJP03o`000?oonf[o000001[o0000oooonfXE
oookJP00>?oonfX5o`000=Oooo]Z00Go0000oookJ_l0003o0000oookJP0Jo`000?oooo]Z3_oonfX0
03Sooo]Z1Ol0003NoookJP;o000000?ooo]Zo`000?oonfX06ol0003ooookJPKooo]Z000hoookJPGo
0000i?oonfX01?l0003ooo]Zo`000?oonfXOo`000?cooo]Z000hoookJPGo0000jooonfX01Ol0003o
oo]Zo`000?l0003ooo]Z01go0000m_oonfX003Sooo]Z1Ol00018oookJPGo001o1OoonfX5o`00Od7o
oo]Z0ol007l5oookJPGo001o1OoonfX5o`00Ocgooo]Z0ol007l3oookJP;o000000?o001oo`000?l0
07l08?l0000ToookJPWo001o0ooonfX5o`00O`Gooo]Z1Ol007lhoookJPWo001o0ooonfX5o`00O`Go
oo]Z1Ol007ljoookJPGo001o1OoonfX5o`00O`Gooo]Z1Ol007l7oookJP00>?oonfX5o`0004Oooo]Z
1ol007l3oookJPOo001o@?oonfX3o`00O`Cooo]Z1ol007l3oookJPOo001o??oonfX3o`00O`Cooo]Z
1ol007l01Ol0003ooo]Zo`000?l0003o001o027o00006ooonfX9o`00O`;ooo]Z1ol007l3oookJPOo
001o=ooonfX9o`00O`;ooo]Z1ol007l3oookJPOo001o>?oonfX7o`00O`?ooo]Z1ol007l3oookJPOo
001o1_oonfX003Sooo]Z1Ol00016oookJPCo001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00O`04
oookJ_l007oo001oo`00Od3ooo]Z0ol007l4oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3
o`00O`04oookJ_l007oo001oo`00Occooo]Z0ol007l3oookJPCo001o00Cooo]Zo`00Ool007oo001o
0ooonfX3o`00O`06oookJ_l0003o0000o`00Ool0003ooo]Z9?l0000AoookJPCo001o1ooonfX3o`00
O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007lgoookJPCo001o1_oo
nfX4o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007lgoookJP?o
001o0ooonfX3o`00O`;ooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o00Cooo]Zo`00
Ool007oo001o1_oonfX003Sooo]Z1Ol00016oookJP?o001o0ooonfX3o`00O`04oookJ_l007oo001o
o`00O`?ooo]Z0ol007looookJP?o001o0ooonfX3o`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool0
07l3oookJP?o001o>ooonfX3o`00O`?ooo]Z0ol007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o
0ooonfX3o`00O`Cooo]Z00Oo0000oookJ_l0003o0000oookJ_l0003ooo]Z02Co00002?oonfX4o`00
O`Gooo]Z0ol007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00OcOooo]Z1?l007l5
oookJP?o001o0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007lfoookJP?o001o0ooo
nfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o
001o1OoonfX003Sooo]Z1Ol0001<oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00Ocoo
oo]Z0ol007l3oookJP?o001o0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007lkoook
JP?o001o2OoonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l<oookJP04o`000?oonf[o
0000oookJP;o000000?ooo]Zo`000?l000009Ol00003o`00O`?ooo]Z0ol007l3oookJP?o001o00Co
oo]Zo`00Ool007oo001o0ooonfX3o`00OcSooo]Z1Ol007l9oookJP?o001o00Cooo]Zo`00Ool007oo
001o0ooonfX3o`00Occooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o00Cooo]Zo`00
Ool007oo001o0ooonfX3o`00O`Gooo]Z000hoookJPGo0000C?oonfX3o`00O`04oookJ_l007oo001o
o`00O`?ooo]Z0ol007looookJP?o001o0ooonfX3o`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool0
07l3oookJP?o001o>ooonfX3o`00O`Wooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o
5OoonfX2o`000003oookJ_l0003ooo]Z00;o000000?ooo]Zo`000?l000009ol00003o`00O`04oook
J_l007oo001oo`00O`?ooo]Z0ol007ljoookJPCo001o2?oonfX3o`00O`04oookJ_l007oo001oo`00
O`?ooo]Z0ol007lloookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00O`04oookJ_l007oo
001oo`00O`?ooo]Z0ol007l5oookJP00>?oonfX5o`0004Oooo]Z0_l007l2oookJPCo001o00Cooo]Z
o`00Ool007oo001o0ooonfX3o`00Ocoooo]Z0ol007l3oookJP?o001o0ooonfX3o`00O`04oookJ_l0
07oo001oo`00O`?ooo]Z0ol007lkoookJP?o001o1?oonfX2o`00O`;ooo]Z1?l007l01?oonf[o001o
o`00Ool007l3oookJP?o001o7ooonfX2o`000003oookJ_l0003ooo]Z00;o000000?ooo]Zo`000?l0
0000:Ol000000ol007oooo]ZoookJP0ioookJP?o001o0ooonfX2o`00O`;ooo]Z1?l007l01?oonf[o
001oo`00Ool007l3oookJP?o001o>_oonfX4o`00O`;ooo]Z0ol007l3oookJP?o001o00Cooo]Zo`00
Ool007oo001o0ooonfX3o`00O`Gooo]Z000hoookJPGo0000AooonfX7o`00O`;ooo]Z0ol007l3oook
JP?o001o?ooonfX3o`00O`?ooo]Z0ol007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3
o`00Oc_ooo]Z0ol007l4oookJPOo001o0_oonfX3o`00O`?ooo]Z0ol007lYoookJP;o000000?ooo]Z
o`000?oonfX00_l000000ooonf[o0000o`00000/o`00033ooo]Z0ol007l2oookJPOo001o0_oonfX3
o`00O`?ooo]Z0ol007ljoookJP?o001o0ooonfX3o`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool0
07l3oookJP?o001o1OoonfX003Sooo]Z1Ol00017oookJPKo001o0ooonfX3o`00O`?ooo]Z0ol007lo
oookJP?o001o0ooonfX3o`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o>ooo
nfX3o`00O`Cooo]Z1_l007l3oookJP?o001o0ooonfX3o`00Oc?ooo]Z0_l000000ooonf[o0000o`00
O`02o`000003oookJ_l0003o001o037o00006ooonfX3o`00O`?ooo]Z0ol007l2oookJPKo001o0ooo
nfX3o`00O`?ooo]Z0ol007lloookJP;o001o0_oonfX3o`00O`?ooo]Z0ol007l01?oonf[o001oo`00
Ool007l3oookJP?o001o1OoonfX003Sooo]Z1Ol00017oookJP;o001o1ooonfX3o`00O`?ooo]Z0ol0
07lloookJPKo001o0ooonfX3o`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o
>?oonfX6o`00O`Cooo]Z0_l007l7oookJP?o001o0ooonfX3o`00OcKooo]Z0ol007l3oookJP;o001o
00Co0000oookJ_l0003o001o0_l000000ooonf[o0000o`00O`0ho`0000[ooo]Z0ol007l3oookJP?o
001o0_oonfX2o`00O`Oooo]Z0ol007l3oookJP?o001o=_oonfX3o`00O`?ooo]Z0ol007l01?oonf[o
001oo`00Ool007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00O`Gooo]Z000hoook
JPGo0000AooonfX2o`00O`Sooo]Z0ol007l01?oonf[o001oo`00Ool007lmoookJPKo001o1?oonfX3
o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007lioookJPKo001o
1?oonfX2o`00O`Sooo]Z0ol007l01?oonf[o001oo`00Ool007lgoookJPCo001o0_oonfX3o`00O`;o
oo]Z0ol007l01?oonf[o001oo`00Ool007l2oookJP07o`000?l007oo0000o`000?oonf[o0000o`00
O`02o`000003oookJ_l0003ooo]Z03_o000000?o001ooookJ_oonfX00_l007l8oookJP?o001o00Co
oo]Zo`00Ool007oo001o=ooonfX3o`00O`?ooo]Z0ol007l2oookJP?o001o00Cooo]Zo`00Ool007oo
001o0ooonfX3o`00O`04oookJ_l007oo001oo`00O`Kooo]Z000hoookJPGo0000B?oonfX7o`00O`;o
oo]Z1ol007looookJPCo001o1?oonfX7o`00O`?ooo]Z1ol007lkoookJPCo001o1OoonfX7o`00O`;o
oo]Z1ol007lhoookJPOo001o0ooonfX7o`00O`?ooo]Z1ol007l5oookJP04o`000?oonf[o0000oook
JP;o000000?ooo]Zo`000?oonfX00_l000000ooonf[o0000oookJP10o`0003Sooo]Z1ol007l3oook
JPOo001o0ooonfX7o`00O`Kooo]Z000hoookJPGo0000B?oonfX7o`00O`?ooo]Z1Ol007m1oookJP?o
001o1OoonfX5o`00O`Gooo]Z1Ol007lmoookJP?o001o1OoonfX7o`00O`?ooo]Z1Ol007ljoookJPGo
001o1OoonfX5o`00O`Gooo]Z1Ol007lEoookJP04o`000?oonf[o0000oookJP;o000000?ooo]Zo`00
0?oonfX00_l000000ooonf[o0000oookJP18o`0002;ooo]Z1Ol007l5oookJPGo001o1OoonfX5o`00
O`Oooo]Z000hoookJPGo0000oooonfYkoookJP03o`000?oonf[o000000;ooo]Z00Co0000oookJ_l0
003ooo]Z0_l000000ooonf[o0000oookJP1Do`0002Oooo]Z000hoookJPGo0000oooonfZ<oookJP06
o`000?oonf[ooo]Zo`000?oonf[o00000_oonfX01?l0003ooo]Zo`000?oonfX2o`000003oookJ_l0
003ooo]Z05Ko00004OoonfX003Sooo]Z1Ol0003ooookJZ3ooo]Z00Ko0000oookJ_oonf[o0000oook
J_l00002oookJP04o`000?oonf[o0000oookJP;o000000?ooo]Zo`000?oonfX00_l000000ooonf[o
0000o`00000mo`00017ooo]Z000hoookJPGo0000oooonfZgoookJP03o`000?oonf[o000000;ooo]Z
00?o0000oookJ_l000000_oonfX01?l0003ooo]Zo`000?oonfX2o`000003oookJ_l0003ooo]Z00;o
000000?ooo]Zo`000?l000009?l0000AoookJP00>?oonfX5o`000?oooo]Zd?oonfX00ol0003ooo]Z
o`000002oookJP03o`000?oonf[o000000;ooo]Z00Co0000oookJ_l0003ooo]Z0_l000000ooonf[o
0000oookJP02o`000003oookJ_l0003ooo]Z00_o00004OoonfX002cooo]Zool0003oo`0001?o0000
0ooonfX002cooo]Zool0003oo`0001?o00000ooonfX002cooo]Zool0003oo`0001?o00000ooonfX0
02cooo]Zool0003oo`0001?o00000ooonfX002cooo]Zool0003oo`0001?o00000ooonfX003Sooo]Z
1Ol0001@oookJP03o`000?oonf[ooo]Z053ooo]Z00?o0000oookJ_oonfX0DOoonfX00ol0003ooo]Z
oookJP1@oookJP03o`000?oonf[ooo]Z053ooo]Z00?o0000oookJ_oonfX0D?oonfX00ol0003ooo]Z
oookJP0@oookJP00>?oonfX5o`000?oooo]Zi?oonfX?o`00017ooo]Z000hoookJPGo0000oooonf[8
oookJR_o00004OoonfX003Sooo]Z1Ol0003ooookJZoooo]Z00?o0000oookJ_l00000@_l0000@oook
JP00>?oonfX5o`000?oooo]ZVooonfY;o`000003oookJ_l0003ooo]Z00;o000000?ooo]Zo`000?oo
nfX00_l000000ooonf[o0000oookJP0AoookJP00>?oonfX5o`000?oooo]ZQooonfX00ol0003ooo]Z
o`000010o`000006oookJ_l0003o0000oookJ_l0003ooo]Z0_l000001?oonf[o0000oookJ_l00004
oookJP03o`000?oonf[ooo]Z00;ooo]Z00?o0000oookJ_oonfX00_oonfX00ol0003ooo]ZoookJP02
oookJP03o`000?oonf[ooo]Z00;ooo]Z00Co0000oookJ_oonf[o00004_oonfX003Sooo]Z1Ol0003o
oookJWKooo]Z00?o0000oookJ_l00000>ol000000ooonf[o0000oookJP02o`000004oookJ_l0003o
oo]Zo`0000Cooo]Z00?o0000oookJ_oonfX00_oonfX00ol0003ooo]ZoookJP02oookJP03o`000?oo
nf[ooo]Z00;ooo]Z00?o0000oookJ_oonfX00_oonfX00ol0003ooo]ZoookJP0:oookJQ;o00004?oo
nfX003Sooo]Z1Ol0003ooookJVOooo]Z=_l000001_oonf[o0000o`000?oonf[o0000oookJP;o0000
0ooonfX00ol0003ooo]ZoookJP02oookJP03o`000?oonf[ooo]Z00;ooo]Z00?o0000oookJ_oonfX0
0_oonfX00ol0003ooo]ZoookJP02oookJP03o`000?oonf[ooo]Z01Cooo]Z8Ol0000@oookJP00>?oo
nfX5o`000?oooo]ZF_oonfXbo`000003oookJ_l0003ooo]Z00;o00000ooonfX00ol0003ooo]Zoook
JP02oookJP03o`000?oonf[ooo]Z00;ooo]Z00?o0000oookJ_oonfX00_oonfX00ol0003ooo]Zoook
JP0OoookJRoo00004?oonfX003Sooo]Z1Ol0003ooookJTgooo]Z;Ol000000ooonf[o0000o`000002
o`000004oookJ_l0003ooo]Zo`0000;ooo]Z00?o0000oookJ_l000000_oonfX00ol0003ooo]Zoook
JP02oookJP03o`000?oonf[ooo]Z02Kooo]Z??l0000@oookJP00>?oonfX5o`000?oooo]Z@OoonfXZ
o`000003oookJ_l0003o000000;o000000Cooo]Zo`000?oonf[o00000_oonfX00ol0003ooo]Zo`00
0002oookJP03o`000?oonf[o0000033ooo]ZA_l0000@oookJP00>?oonfX5o`000?oooo]Z=OoonfXW
o`000003oookJ_l0003o000000;o000000Cooo]Zo`000?oonf[o00000_oonfX00ol0003ooo]Zo`00
0002oookJP03o`000?oonf[o000003?ooo]Z@ol00008oookJPKo00004OoonfX003Sooo]Z1Ol0003o
oookJR_ooo]Z9ol000001?oonf[o0000oookJ_l00002oookJP03o`000?oonf[o000000;ooo]Z00?o
0000oookJ_l00000>?oonfXno`0000_ooo]Z4ol0000@oookJP00>?oonfX5o`000?oooo]Z8OoonfXR
o`000004oookJ_l0003o0000o`0000;ooo]Z00?o0000oookJ_l000000_oonfX00ol0003ooo]Zo`00
0002oookJP03o`000?oonf[ooo]Z03Sooo]Z>ol0000>oookJQgo00004?oonfX003Sooo]Z1Ol0003o
oookJQOooo]Z8_l000001?oonf[o0000o`000?l00002oookJP03o`000?oonf[o000000;ooo]Z00?o
0000oookJ_l00000?ooonfXeo`0001Cooo]Z9?l0000AoookJP00>?oonfX5o`000?oooo]Z3ooonfXP
o`000004oookJ_l0003ooo]Zo`0000;ooo]Z00?o0000oookJ_l000000_oonfX00ol0003ooo]Zo`00
0011oookJS?o00005?oonfXRo`000006oookJ_l0003o0000oookJ_l0003ooo]Z0_l000000ooonf[o
0000o`00000BoookJP00>?oonfX5o`000?oooo]Z1ooonfXNo`000004oookJ_l0003ooo]Zo`0000;o
oo]Z00?o0000oookJ_l000000_oonfX00ol0003ooo]ZoookJP12oookJS7o00005_oonfXQo`000006
oookJ_l0003o0000oookJ_l0003ooo]Z0_l000000ooonf[o0000oookJP0LoookJP00>?oonfX5o`00
0?gooo]Z7Ol000001?oonf[o0000oookJ_l00002oookJP03o`000?oonf[o000000;ooo]Z00?o0000
oookJ_oonfX0A?oonfX_o`0001[ooo]Z8?l000000ooonf[o0000oookJP02o`000003oookJ_l0003o
oo]Z02Kooo]Z000hoookJPGo0000mooonfXIo`000004oookJ_l0003o0000o`0000;ooo]Z00?o0000
oookJ_l000000_oonfX00ol0003ooo]ZoookJP17oookJRco00006ooonfXOo`000003oookJ_l0003o
oo]Z00;o000000Cooo]Zo`000?oonf[o0000;ooonfX003Sooo]Z1Ol0003^oookJQgo000000Cooo]Z
o`000?oonf[o00000_oonfX00ol0003ooo]Zo`000019oookJR_o00007_oonfXKo`000003oookJ_l0
003ooo]Z00;o000000Cooo]Zo`000?oonf[o0000>OoonfX003Sooo]Z1Ol0003XoookJQWo000000Co
oo]Zo`000?oonf[o00000_oonfX00ol0003ooo]Zo`00001<oookJR[o00007ooonfXJo`000006oook
J_l0003o0000oookJ_l0003ooo]Z0_l00012oookJP00>?oonfX5o`000>7ooo]Z6?l000001ooonf[o
0000oookJ_oonf[o0000oookJ_l000000_oonfX00ol0003ooo]ZoookJP1;oookJRSo00008?oonfXJ
o`000003oookJ_l0003ooo]Z00;o000000?ooo]Zo`000?oonfX0BOoonfX003Sooo]Z1Ol0003Joook
JQSo000000Cooo]Zo`000?oonf[o00000_oonfX00ol0003ooo]Zo`00001@oookJRCo00008ooonfXH
o`000007oookJ_l0003o0000oookJ_l0003ooo]Zo`00001BoookJP00>?oonfX5o`000=Gooo]Z5Ol0
00001ooonf[o0000oookJ_oonf[o0000oookJ_l000000_oonfX00ol0003ooo]ZoookJP1>oookJRGo
00008_oonfXHo`000003oookJ_l0003ooo]Z00;o000000?ooo]Zo`000?oonfX0F?oonfX003Sooo]Z
1Ol0003?oookJQCo000000Cooo]Zo`000?oonf[o00000_oonfX00ol0003ooo]Zo`00001BoookJR;o
00009?oonfXJo`000003oookJ_l0003ooo]Z00;o0000H?oonfX003Sooo]Z1Ol0003:oookJQCo0000
00Cooo]Zo`000?oonf[o00000_oonfX00ol0003ooo]ZoookJP1BoookJR7o00009OoonfXGo`000007
oookJ_l0003o0000oookJ_l0003ooo]Zo`00001VoookJP00>?oonfX5o`000<?ooo]Z5_l000001?oo
nf[o0000oookJ_l0001GoookJQoo00009ooonfXEo`000003oookJ_l0003ooo]Z00;o000000?ooo]Z
o`000?oonfX0K?oonfX003Sooo]Z1Ol0002noookJQ?o000000Oooo]Zo`000?oonf[ooo]Zo`000?oo
nf[o000005Oooo]Z7ol0000VoookJQKo000000?ooo]Zo`000?oonfX00_l0001doookJP00>?oonfX5
o`000;Wooo]Z4ol000001ooonf[o0000oookJ_oonf[o0000oookJ_l00000EOoonfXPo`0002Oooo]Z
5_l000001?oonf[o0000oookJ_l0001joookJP00>?oonfX5o`000;Cooo]Z4ol000001Ooonf[o0000
oookJ_oonf[o000005Oooo]Z7_l0000YoookJQ?o000000Oooo]Zo`000?l0003ooo]Zo`000?oonf[o
000007oooo]Z000hoookJPGo0000[ooonfXAo`000004oookJ_l0003ooo]Zo`0000;ooo]Z00?o0000
oookJ_oonfX0EooonfXLo`0002Wooo]Z4ol000001Ooonf[o0000o`000?oonf[o000008Kooo]Z000h
oookJPGo0000Z_oonfXAo`000004oookJ_l0003ooo]Zo`0000;ooo]Z00?o0000oookJ_oonfX0Eooo
nfXLo`0002Wooo]Z4ol000001Ooonf[o0000o`000?oonf[o000008_ooo]Z000hoookJPGo0000YOoo
nfXAo`000004oookJ_l0003ooo]Zo`0000;ooo]Z00?o0000oookJ_oonfX0EooonfXLo`0002[ooo]Z
4_l000001Ooonf[o0000o`000?oonf[o0000093ooo]Z000hoookJPGo0000X_oonfX?o`000004oook
J_l0003ooo]Zo`0005cooo]Z6_l0000/oookJQ;o000000Gooo]Zo`000?l0003ooo]Zo`00002Eoook
JP00>?oonfX5o`0009gooo]Z4Ol000001Ooonf[o0000oookJ_oonf[o000005[ooo]Z6Ol0000/oook
JQ;o000000Gooo]Zo`000?l0003ooo]Zo`00002JoookJP00>?oonfX5o`0009Sooo]Z00?o0000oook
J_l000003_l000001Ooonf[o0000oookJ_oonf[o000005[ooo]Z6ol0000/oookJQ3o000000Gooo]Z
o`000?l0003ooo]Zo`00002OoookJP00>?oonfX5o`0009Gooo]Z3ol000001Ooonf[o0000oookJ_oo
nf[o000005cooo]Z6Ol0000/oookJQ3o000000Gooo]Zo`000?l0003ooo]Zo`00002ToookJP00>?oo
nfX5o`00097ooo]Z3_l000001Ooonf[o0000oookJ_oonf[o000005cooo]Z6Ol0000^oookJQ7o0000
00?ooo]Zo`000?oonfX0Z?oonfX003Sooo]Z1Ol0002<oookJQ3o0000HOoonfXGo`0002oooo]Z4?l0
00001?oonf[o0000oookJ_l0002/oookJP00>?oonfX5o`0008Wooo]Z3_l00004oookJP03o`000?oo
nf[ooo]Z05_ooo]Z6?l0000]oookJQ3o000000Cooo]Zo`000?oonf[o0000/OoonfX003Sooo]Z1Ol0
0026oookJPgo00000ooonfX00ol0003ooo]ZoookJP1KoookJQSo0000;ooonfX@o`000003oookJ_l0
003o00000;Gooo]Z000hoookJPGo0000POoonfX>o`0000;ooo]Z00?o0000oookJ_oonfX0GOoonfXG
o`00033ooo]Z3_l000000ooonf[o0000o`00002joookJP00>?oonfX5o`0007gooo]Z3_l000000ooo
nf[o0000oookJP1PoookJQGo0000<OoonfX=o`000005oookJ_l0003o0000oookJ_l00000_OoonfX0
03Sooo]Z1Ol0001joookJPko0000H_oonfXFo`0002oooo]Z4?l000000ooonf[o0000oookJP31oook
JP004OoonfX5o`00O`Cooo]Z0ol007l00ooonf[o001oo`00O`07o`00O`?ooo]Z1Ol007l9oookJPGo
0000MooonfX<o`0000Cooo]Z00?o0000oookJ_oonfX0GOoonfXFo`0002oooo]Z4?l000000ooonf[o
0000oookJP34oookJP004?oonfX7o`00O`?ooo]Z0ol007l00ooonf[o001oo`00O`07o`00O`;ooo]Z
1ol007l8oookJPGo0000LooonfX=o`0000;ooo]Z00?o0000oookJ_oonfX0GooonfXDo`00037ooo]Z
3_l000000ooonf[o0000o`000039oookJP004?oonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z
0ol007l00ooonf[o001oo`00O`02o`00O`Kooo]Z1?l007l01?oonf[o001oo`00Ool007l8oookJPGo
0000L?oonfX<o`000003oookJ_l0003ooo]Z067ooo]Z5?l0000aoookJPgo000000Gooo]Zo`000?l0
003ooo]Zo`00003<oookJP003ooonfX3o`00O`?ooo]Z0ol007l7oookJPCo001o1OoonfX3o`00O`?o
oo]Z0ol007l7oookJPGo0000KOoonfX<o`0006Cooo]Z5?l0000aoookJPko000000?ooo]Zo`000?oo
nfX0d?oonfX000oooo]Z0ol007l3oookJP?o001o2?oonfX5o`00O`Wooo]Z0ol007l7oookJPKo0000
J?oonfX=o`0000;ooo]Z00?o0000oookJ_oonfX0GooonfXDo`00037ooo]Z3_l000000ooonf[o0000
oookJP3CoookJP003ooonfX3o`00O`?ooo]Z0ol007l:oookJPCo001o2?oonfX3o`00O`Oooo]Z1Ol0
001VoookJPco000000?ooo]Zo`000?oonfX0HOoonfXDo`0003?ooo]Z2ol000000ooonf[o0000o`00
003HoookJP003ooonfX3o`00O`?ooo]Z0ol007l;oookJP?o001o0ooonfX2o`00O`;ooo]Z1?l007l7
oookJPGo0000HooonfX<o`0006Cooo]Z5?l0000coookJPco000000?ooo]Zo`000?oonfX0f_oonfX0
00oooo]Z0ol007l3oookJP?o001o3?oonfX3o`00O`;ooo]Z1ol007l8oookJPGo0000HOoonfX;o`00
00;ooo]Z00?o0000oookJ_oonfX0H?oonfXCo`0003;ooo]Z3Ol000000ooonf[o0000oookJP3Moook
JP003ooonfX3o`00O`?ooo]Z0ol007l6oookJP?o001o0ooonfX3o`00O`;ooo]Z1_l007l9oookJPGo
0000G_oonfX:o`000003oookJ_l0003ooo]Z06?ooo]Z4_l0000coookJPko0000h_oonfX000oooo]Z
0ol007l3oookJP?o001o1_oonfX3o`00O`?ooo]Z0ol007l2oookJP;o001o3OoonfX5o`0005[ooo]Z
2ol0001VoookJQ;o0000<ooonfX>o`000>Gooo]Z000@oookJP?o001o00Cooo]Zo`00Ool007oo001o
1ooonfX4o`00O`;ooo]Z0ol007l2oookJP;o001o3OoonfX5o`0005Oooo]Z3?l000000ooonf[o0000
oookJP1QoookJQ?o0000=?oonfX;o`000003oookJ_l0003o00000>Oooo]Z000@oookJPOo001o2?oo
nfX7o`00O`Cooo]Z1ol007l7oookJPGo0000EOoonfX;o`0006Kooo]Z4?l0000eoookJPco000000?o
oo]Zo`000?oonfX0jOoonfX0017ooo]Z1Ol007l:oookJPGo001o1OoonfX7o`00O`Oooo]Z1Ol0001B
oookJP_o00000_oonfX00ol0003ooo]ZoookJP1PoookJQ?o0000<_oonfX=o`000003oookJ_l0003o
oo]Z0>cooo]Z000hoookJPGo0000CooonfX:o`000003oookJ_l0003ooo]Z06?ooo]Z4_l0000eoook
JPco0000lOoonfX003Sooo]Z1Ol0001=oookJP[o0000I_oonfXAo`0003Cooo]Z3Ol0003doookJP00
>?oonfX5o`0004[ooo]Z2_l000000ooonf[o0000oookJP1SoookJQ7o0000=?oonfX;o`000003oook
J_l0003o00000?Kooo]Z000hoookJPGo0000B?oonfX9o`0006Oooo]Z4Ol0000doookJP_o000000?o
oo]Zo`000?oonfX0n?oonfX003Sooo]Z1Ol00015oookJP[o000000?ooo]Zo`000?oonfX0HooonfXA
o`0003Cooo]Z2ol000000ooonf[o0000oookJP3koookJP00>?oonfX5o`00047ooo]Z00?o0000oook
J_l000002?l0001WoookJPoo0000=_oonfX;o`000003oookJ_l0003ooo]Z0?gooo]Z000hoookJPGo
0000@?oonfX:o`000003oookJ_l0003ooo]Z06?ooo]Z4Ol0000doookJP_o000000?ooo]Zo`000?oo
nfX0oooonfX1oookJP00>?oonfX5o`0003kooo]Z2Ol0001WoookJPoo0000=_oonfX;o`000003oook
J_l0003ooo]Z0?oooo]Z0ooonfX003Sooo]Z1Ol0000koookJP[o000000?ooo]Zo`000?oonfX0Hooo
nfXAo`0003Cooo]Z2ol000000ooonf[o0000oookJP3ooookJPKooo]Z000hoookJPGo0000>OoonfX9
o`0006Oooo]Z3ol0000foookJP_o000000?ooo]Zo`000?oonfX0oooonfX8oookJP00>?oonfX5o`00
03Kooo]Z2_l000000ooonf[o0000oookJP1UoookJPoo0000=_oonfX9o`000003oookJ_l0003ooo]Z
0?oooo]Z2ooonfX003Sooo]Z1Ol0000doookJPWo0000IooonfX?o`0003Kooo]Z2ol000000ooonf[o
0000oookJP3ooookJPgooo]Z000hoookJPGo0000<_oonfX9o`000003oookJ_l0003ooo]Z06Gooo]Z
3ol0000foookJPWo000000?ooo]Zo`000?oonfX0oooonfX@oookJP00>?oonfX5o`0002oooo]Z2Ol0
00000ooonf[o0000oookJP1ToookJPoo0000=_oonfX;o`000003oookJ_l0003ooo]Z0?oooo]Z4_oo
nfX003Sooo]Z1Ol0000]oookJPWo000000?ooo]Zo`000?oonfX0IOoonfX?o`0003Kooo]Z2Ol00000
0ooonf[o0000oookJP3ooookJQGooo]Z000hoookJPGo0000;?oonfX9o`0006Oooo]Z3ol0000foook
JP_o0000oooonfXHoookJP00>?oonfX5o`0002Sooo]Z2Ol000000ooonf[o0000oookJP1VoookJPko
0000=ooonfX8o`000003oookJ_l0003o00000?oooo]Z6_oonfX003Sooo]Z1Ol0000WoookJPWo0000
IooonfX?o`0003Kooo]Z2ol0003ooookJQgooo]Z000hoookJPGo00009OoonfX9o`000003oookJ_l0
003ooo]Z06Cooo]Z3_l0000goookJP_o0000oooonfXOoookJP00>?oonfX5o`0002;ooo]Z2Ol0001Y
oookJPgo0000>?oonfX9o`000003oookJ_l0003ooo]Z0?oooo]Z7ooonfX003Sooo]Z1Ol0000Poook
JPWo000000?ooo]Zo`000?oonfX0I_oonfX=o`0003Sooo]Z2Ol0003ooookJRCooo]Z000hoookJPGo
00007_oonfX9o`000003oookJ_l0003ooo]Z06Gooo]Z3ol0000foookJPWo000000?ooo]Zo`000?oo
nfX0oooonfXToookJP00>?oonfX5o`0001gooo]Z1ol000000ooonf[o0000oookJP1VoookJPgo0000
>?oonfX9o`000003oookJ_l0003ooo]Z0?oooo]Z9_oonfX003Sooo]Z1Ol0000KoookJPOo000000?o
oo]Zo`000?oonfX0I_oonfX>o`0003Oooo]Z2_l0003ooookJR[ooo]Z000hoookJPGo00006?oonfX9
o`0006Wooo]Z3Ol0000hoookJPWo0000oooonfX/oookJP00>?oonfX5o`0001Kooo]Z2Ol000000ooo
nf[o0000oookJP1VoookJPgo0000>?oonfX9o`000?oooo]Z;_oonfX003Sooo]Z1Ol0000DoookJPWo
0000JOoonfX<o`0003Sooo]Z2Ol000000ooonf[o0000oookJP3ooookJRkooo]Z000hoookJPGo0000
4ooonfX7o`000003oookJ_l0003ooo]Z06Kooo]Z3Ol0000hoookJPWo000000?ooo]Zo`000?oonfX0
oooonfX`oookJP00>?oonfX5o`00017ooo]Z1ol000000ooonf[o0000oookJP1VoookJPko0000=ooo
nfX:o`000?oooo]Z=?oonfX003Sooo]Z1Ol0000?oookJPSo0000JOoonfX=o`0003Sooo]Z2Ol0003o
oookJSKooo]Z000hoookJPGo00003_oonfX7o`000003oookJ_l0003ooo]Z06Kooo]Z3Ol0000hoook
JPWo0000oooonfXhoookJP00>?oonfX5o`0000cooo]Z1ol000000ooonf[o0000oookJP1VoookJPko
0000=ooonfX8o`000003oookJ_l0003ooo]Z0?oooo]Z>?oonfX003Sooo]Z1Ol0000:oookJPSo0000
JOoonfX;o`0003[ooo]Z2Ol0003ooookJS_ooo]Z000hoookJPGo00001ooonfX9o`0006Wooo]Z3?l0
000ioookJPWo0000oooonfXmoookJP00>?oonfX5o`0000Gooo]Z2Ol0001YoookJPco0000>OoonfX8
o`000003oookJ_l0003ooo]Z0?oooo]Z?OoonfX003Sooo]Z1Ol00004oookJPWo0000JOoonfX;o`00
03Wooo]Z2?l0003ooookJT;ooo]Z000hoookJPGo00000_oonfX7o`000003oookJ_l0003ooo]Z06So
oo]Z3?l0000ioookJPSo0000oooonfY3oookJP006ooonfX5o`00O`Cooo]Z0ol007l3oookJPGo001o
2OoonfX=o`0006[ooo]Z3?l0000ioookJPSo0000oooonfY5oookJP006_oonfX7o`00O`?ooo]Z0ol0
07l2oookJPOo001o2?oonfX;o`000003oookJ_l0003ooo]Z06Sooo]Z2ol0000ioookJPSo0000oooo
nfY7oookJP006_oonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l00ooonf[o001oo`00
O`02o`00O`04oookJ_l007oo001oo`00O`Sooo]Z2Ol000000ooonf[o0000oookJP1XoookJPco0000
>OoonfX8o`000?oooo]ZB?oonfX001Wooo]Z0ol007l3oookJP?o001o1_oonfX3o`00O`?ooo]Z0ol0
07l7oookJPSo0000J_oonfX<o`0003Wooo]Z2?l0003ooookJT[ooo]Z000IoookJP?o001o0ooonfX3
o`00O`cooo]Z0ol007l7oookJPKo000000?ooo]Zo`000?oonfX0J?oonfX;o`0003Wooo]Z2?l0003o
oookJTcooo]Z000IoookJP?o001o0ooonfX3o`00O`cooo]Z0ol007l7oookJPKo0000JOoonfX<o`00
03Wooo]Z2?l0003ooookJTgooo]Z000IoookJP?o001o0ooonfX3o`00O`Oooo]Z0_l007l2oookJPCo
001o1ooonfX5o`0006Sooo]Z3?l0000ioookJPSo0000oooonfY?oookJP006OoonfX3o`00O`?ooo]Z
0ol007l7oookJPOo001o2?oonfX5o`0006Oooo]Z2ol0000joookJPOo0000oooonfYAoookJP006Ooo
nfX3o`00O`?ooo]Z0ol007l7oookJPKo001o2OoonfX5o`0006Gooo]Z3?l0000ioookJPSo0000oooo
nfYBoookJP006OoonfX3o`00O`?ooo]Z0ol007l7oookJP;o001o3OoonfX5o`0006?ooo]Z3?l0000i
oookJPSo0000oooonfYDoookJP006_oonfX3o`00O`04oookJ_l007oo001oo`00O`Sooo]Z0_l007l=
oookJPGo0000H_oonfX;o`0003[ooo]Z1ol0003ooookJUKooo]Z000JoookJPOo001o2OoonfX7o`00
O`Oooo]Z1Ol0001PoookJPco0000>OoonfX8o`000?oooo]ZEooonfX001_ooo]Z1Ol007l:oookJPOo
001o1ooonfX5o`0005kooo]Z3?l0000ioookJPSo0000oooonfYIoookJP00>?oonfX5o`0005kooo]Z
2_l0000joookJPOo0000oooonfYKoookJP00>?oonfX5o`0005gooo]Z2_l0000joookJPOo0000oooo
nfYLoookJP00>?oonfX5o`0005_ooo]Z2_l0000koookJPKo000000?ooo]Zo`000?oonfX0oooonfYK
oookJP00>?oonfX5o`0005Wooo]Z2_l0000koookJPSo0000oooonfYNoookJP00>?oonfX5o`0005So
oo]Z2_l0000joookJPSo0000oooonfYPoookJP00>?oonfX5o`0005Kooo]Z3?l0000ioookJPSo0000
oooonfYQoookJP00>?oonfX5o`0005Cooo]Z3?l0000joookJPOo0000oooonfYSoookJP00>?oonfX5
o`0005?ooo]Z2ol0000joookJPSo0000oooonfYToookJP00>?oonfX5o`0005?ooo]Z2_l0000joook
JPOo0000oooonfYVoookJP00>?oonfX5o`00057ooo]Z2_l0000koookJPKo0000oooonfYXoookJP00
>?oonfX5o`0004oooo]Z2_l0000koookJPOo0000oooonfYYoookJP00>?oonfX5o`0004kooo]Z2_l0
000koookJPKo000000?ooo]Zo`000?oonfX0oooonfYXoookJP00>?oonfX5o`0004cooo]Z2_l0000k
oookJPSo0000oooonfY[oookJP00>?oonfX5o`0004cooo]Z2_l0000joookJPOo0000oooonfY]oook
JP00>?oonfX5o`0004[ooo]Z2_l0000koookJPOo0000oooonfY^oookJP00>?oonfX5o`0004Wooo]Z
2_l0000joookJPOo0000oooonfY`oookJP00>?oonfX5o`0004Oooo]Z2_l0000koookJPSo0000oooo
nfY`oookJP00>?oonfX5o`0004Gooo]Z2_l0000loookJPOo0000oooonfYboookJP00>?oonfX5o`00
04Gooo]Z2_l0000koookJPOo0000oooonfYcoookJP00>?oonfX5o`0004Cooo]Z2_l0000joookJPOo
0000oooonfYeoookJP00>?oonfX5o`0004;ooo]Z2_l0000koookJPKo0000oooonfYgoookJP00>?oo
nfX5o`00043ooo]Z2_l0000loookJPOo0000oooonfYgoookJP00>?oonfX5o`00043ooo]Z2Ol0000l
oookJPOo0000oooonfYhoookJP00>?oonfX5o`0003oooo]Z2_l0000joookJPOo0000oooonfYjoook
JP00>?oonfX5o`0003gooo]Z2_l0000koookJPKo0000oooonfYloookJP00>?oonfX5o`0003_ooo]Z
2_l0000loookJPKo0000oooonfYmoookJP00>?oonfX5o`0003_ooo]Z2Ol0000loookJPOo0000oooo
nfYmoookJP00>?oonfX5o`0003[ooo]Z2_l0000joookJPOo0000oooonfYooookJP00>?oonfX5o`00
03Sooo]Z2_l0000koookJPKo0000oooonfZ1oookJP00>?oonfX5o`0003Sooo]Z2?l0000loookJPOo
0000oooonfZ1oookJP00>?oonfX5o`0003Kooo]Z2Ol0000loookJPOo0000oooonfZ2oookJP00>?oo
nfX5o`0003Gooo]Z2_l0000joookJPOo0000oooonfZ4oookJP00>?oonfX5o`0003?ooo]Z2_l0000k
oookJPOo0000oooonfZ5oookJP00>?oonfX5o`0003?ooo]Z2?l0000loookJPOo0000oooonfZ6oook
JP00>?oonfX5o`00037ooo]Z2_l0000koookJPOo0000oooonfZ7oookJP00>?oonfX5o`00033ooo]Z
2_l0000koookJPKo0000oooonfZ9oookJP00>?oonfX5o`00033ooo]Z2?l0000loookJPKo0000oooo
nfZ:oookJP00>?oonfX5o`0002kooo]Z2?l0000moookJPKo0000oooonfZ;oookJP004OoonfX5o`00
O`Cooo]Z0ol007l3oookJP?o001o1ooonfX5o`00O`Wooo]Z1Ol0000/oookJP[o0000??oonfX6o`00
0?oooo]ZS?oonfX0013ooo]Z1ol007l3oookJP?o001o0ooonfX3o`00O`Kooo]Z1ol007l8oookJPGo
0000;?oonfX9o`0003cooo]Z1Ol0003ooookJXkooo]Z000@oookJP?o001o00Cooo]Zo`00Ool007oo
001o0ooonfX3o`00O`?ooo]Z0ol007l5oookJPCo001o00Cooo]Zo`00Ool007oo001o2?oonfX5o`00
02_ooo]Z2?l0000loookJPOo0000oooonfZ>oookJP003ooonfX3o`00O`?ooo]Z0ol007l9oookJP;o
001o1OoonfX3o`00O`?ooo]Z0ol007l7oookJPGo0000:OoonfX:o`0003_ooo]Z1_l0003ooookJY3o
oo]Z000?oookJP?o001o0ooonfX3o`00O`Wooo]Z0ol007l:oookJP?o001o1ooonfX6o`0002Sooo]Z
2?l0000loookJPKo0000oooonfZAoookJP003ooonfX3o`00O`?ooo]Z0ol007l9oookJP?o001o2_oo
nfX3o`00O`Oooo]Z1Ol0000WoookJPWo0000??oonfX7o`000?oooo]ZTOoonfX000oooo]Z0ol007l3
oookJP?o001o2_oonfX2o`00O`Gooo]Z0_l007l2oookJPCo001o1ooonfX5o`0002Kooo]Z2_l0000l
oookJPGo0000oooonfZCoookJP003ooonfX3o`00O`?ooo]Z0ol007l:oookJP?o001o1?oonfX7o`00
O`Sooo]Z1Ol0000VoookJPSo0000?OoonfX5o`000?oooo]ZU?oonfX000oooo]Z0ol007l3oookJP?o
001o2ooonfX2o`00O`Cooo]Z1_l007l9oookJPGo00009?oonfX8o`0003gooo]Z1_l0003ooookJYGo
oo]Z000?oookJP?o001o0ooonfX3o`00O`cooo]Z0_l007l3oookJP;o001o3OoonfX5o`0002Cooo]Z
2?l0000loookJPKo0000oooonfZFoookJP004?oonfX3o`00O`04oookJ_l007oo001oo`00O`gooo]Z
0_l007l3oookJP;o001o3OoonfX5o`0002;ooo]Z2Ol0000loookJPKo0000oooonfZGoookJP004?oo
nfX7o`00O`Oooo]Z2Ol007l3oookJPOo001o1ooonfX5o`00027ooo]Z2?l0000loookJPOo0000oooo
nfZHoookJP004OoonfX5o`00O`Sooo]Z2Ol007l3oookJPOo001o1ooonfX5o`00027ooo]Z2?l0000l
oookJPKo0000oooonfZIoookJP00>?oonfX5o`0001oooo]Z2?l0000moookJPKo0000oooonfZJoook
JP00>?oonfX5o`0001oooo]Z2?l0000loookJPKo0000oooonfZKoookJP00>?oonfX5o`0001gooo]Z
2Ol0000loookJPGo0000oooonfZMoookJP00>?oonfX5o`0001cooo]Z2?l0000loookJPOo0000oooo
nfZMoookJP00>?oonfX5o`0001cooo]Z2?l0000loookJPKo0000oooonfZNoookJP00>?oonfX5o`00
01[ooo]Z2?l0000moookJPKo0000oooonfZOoookJP00>?oonfX5o`0001[ooo]Z2?l0000loookJPKo
0000oooonfZPoookJP00>?oonfX5o`0001Sooo]Z2Ol0000loookJPGo0000oooonfZRoookJP00>?oo
nfX5o`0001Oooo]Z2?l0000loookJPOo0000oooonfZRoookJP00>?oonfX5o`0001Oooo]Z2?l0000l
oookJPKo0000oooonfZSoookJP00>?oonfX5o`0001Gooo]Z2?l0000moookJPKo0000oooonfZToook
JP00>?oonfX5o`0001Gooo]Z2?l0000loookJPKo0000oooonfZUoookJP00>?oonfX5o`0001?ooo]Z
2Ol0000loookJPGo0000oooonfZWoookJP00>?oonfX5o`0001;ooo]Z2?l0000noookJPGo0000oooo
nfZWoookJP00>?oonfX5o`0001;ooo]Z2?l0000moookJPGo0000oooonfZXoookJP00>?oonfX5o`00
013ooo]Z2?l0000moookJPKo0000oooonfZYoookJP00>?oonfX5o`00013ooo]Z2?l0000loookJPKo
0000oooonfZZoookJP00>?oonfX5o`0000kooo]Z2Ol0000loookJPKo0000oooonfZ[oookJP00>?oo
nfX5o`0000kooo]Z1ol0000noookJPGo0000oooonfZ/oookJP00>?oonfX5o`0000gooo]Z2?l0000l
oookJPKo0000oooonfZ]oookJP00>?oonfX5o`0000gooo]Z1_l0000noookJPGo0000oooonfZ^oook
JP00>?oonfX5o`0000_ooo]Z2?l0000moookJPGo0000oooonfZ_oookJP00>?oonfX5o`0000_ooo]Z
1ol0000moookJPKo0000oooonfZ_oookJP00>?oonfX5o`0000Wooo]Z2Ol0000loookJPGo0000oooo
nfZaoookJP00>?oonfX5o`0000Sooo]Z2?l0000loookJPKo0000oooonfZboookJP00>?oonfX5o`00
00Sooo]Z2?l0000moookJPGo0000oooonfZboookJP00>?oonfX5o`0000Kooo]Z2?l0000moookJPKo
0000oooonfZcoookJP00>?oonfX5o`0000Kooo]Z2?l0000loookJPKo0000oooonfZdoookJP00>?oo
nfX5o`0000Cooo]Z2Ol0000loookJPKo0000oooonfZeoookJP00>?oonfX5o`0000Cooo]Z1ol0000n
oookJPGo0000oooonfZfoookJP00>?oonfX5o`0000?ooo]Z2?l0000loookJPKo0000oooonfZgoook
JP00>?oonfX5o`0000?ooo]Z1_l0000noookJPGo0000oooonfZhoookJP00>?oonfX5o`000003oook
J_l0003o000000Ko0000?OoonfX5o`000?oooo]Z^OoonfX003Sooo]Z1Ol000000ooonf[o0000o`00
0005o`0003gooo]Z1_l0003ooookJ[Wooo]Z000hoookJPgo0000??oonfX5o`000?oooo]Z^ooonfX0
03Sooo]Z2ol0000noookJPGo0000oooonfZkoookJP00>?oonfX;o`0003cooo]Z1_l0003ooookJ[co
oo]Z000hoookJPWo0000?_oonfX5o`000?oooo]Z_OoonfX002cooo]Z0ol007l9oookJPWo0000?Ooo
nfX5o`000?oooo]Z__oonfX002cooo]Z0ol007l9oookJPSo0000?OoonfX6o`000?oooo]Z__oonfX0
02cooo]Z0ol007l9oookJPSo0000??oonfX5o`000?oooo]Z`?oonfX002cooo]Z0ol007l9oookJPKo
0000?_oonfX5o`000?oooo]Z`?oonfX002cooo]Z0ol007l9oookJPKo0000??oonfX6o`000?oooo]Z
`OoonfX002cooo]Z0ol007l9oookJPGo0000?OoonfX5o`000?oooo]Z`_oonfX002cooo]Z0ol007l9
oookJPGo0000??oonfX5o`000?oooo]Z`ooonfX002cooo]Z0ol007l9oookJPGo0000>ooonfX6o`00
0?oooo]Z`ooonfX002cooo]Z0ol007l9oookJPGo0000>_oonfX5o`000?oooo]ZaOoonfX002Wooo]Z
1_l007l9oookJPGo0000>_oonfX5o`000?oooo]ZaOoonfX002Wooo]Z1_l007l9oookJPGo0000>?oo
nfX6o`000?oooo]Za_oonfX002_ooo]Z1?l007l9oookJPGo0000>OoonfX4o`000?oooo]ZaooonfX0
02cooo]Z0ol007l9oookJPGo0000=ooonfX6o`000?oooo]ZaooonfX003Sooo]Z1Ol0000goookJPGo
0000oooonf[8oookJP00>?oonfX5o`0003Gooo]Z1_l0003ooookJ/Wooo]Z000hoookJPGo0000=_oo
nfX4o`000?oooo]Zb_oonfX003Sooo]Z1Ol0000doookJPGo0000oooonf[;oookJP00>?oonfX5o`00
03Cooo]Z1Ol0003ooookJ/_ooo]Z000hoookJPGo0000oooonf[ooookJPGooo]Z000hoookJPGo0000
oooonf[ooookJPGooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooook
JT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003o
oookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z
@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00001
\
\>"],
  ImageRangeCache->{{{0, 575}, {354.938, 0}} -> {-35.1325, -0.610893, \
0.600599, 0.00494211}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell["Background- Forward Differencing", "Subtitle"],

Cell[TextData[{
  "Create a function to return a list of values by forward differencing with \
a function (these examples were modified from those found in ``Computer \
Science with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "'' by Roman E. Maeder, Cambridge University Press, (2000).)"
}], "Text",
  CellTags->"mmtag:19:Roman_Maeder__Computer_Science_with_Mathematica"],

Cell[TextData[{
  "The ",
  StyleBox["Module",
    FontWeight->"Bold"],
  " function makes the variables inside local variables. "
}], "Subsubsection"],

Cell[BoxData[
    \(ForwardDifferenceListV1[AFunction_\ , \ InitialValue_\ , \ delta_, \ 
        ListLength_Integer]\  := \[IndentingNewLine]Module[{TheResultList\  = \
\ {InitialValue}, TheValue = InitialValue}, \[IndentingNewLine]Do[
          TheValue\  = \ TheValue\  + \ delta\ AFunction[TheValue]; \ 
          AppendTo[TheResultList, TheValue], {ListLength}]; 
        TheResultList]\)], "Input",
  CellTags->"mmtag:19:Module[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(exampleFunction[x_]\  := \ 0.1\ x\)], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(exampleFunction\\)\\\" is similar to \
existing symbol \\\"\\!\\(ExampleFunction\\)\\\". \\!\\(\\*ButtonBox[\\\"More\
\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"]
}, Open  ]],

Cell[BoxData[
    \(\(result\  = \ 
        ForwardDifferenceListV1[exampleFunction, \ 1, \ 0.01, \ 
          500];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(result // Short\)], "Input"],

Cell[BoxData[
    TagBox[\({1, 1.001`, 1.002001`, \[LeftSkeleton]496\[RightSkeleton], 
        1.6466627536593788`, 1.648309416413038`}\),
      Short]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListPlot[result, PlotJoined \[Rule] True]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00190096 -0.893191 0.907906 [
[.21391 .00222 -17 -20 ]
[.21391 .00222 17 0 ]
[.404 .00222 -17 -20 ]
[.404 .00222 17 0 ]
[.5941 .00222 -17 -20 ]
[.5941 .00222 17 0 ]
[.78419 .00222 -17 -20 ]
[.78419 .00222 17 0 ]
[.97429 .00222 -17 -20 ]
[.97429 .00222 17 0 ]
[.01131 .10551 -29 -10 ]
[.01131 .10551 0 10 ]
[.01131 .1963 -29 -10 ]
[.01131 .1963 0 10 ]
[.01131 .28709 -29 -10 ]
[.01131 .28709 0 10 ]
[.01131 .37788 -29 -10 ]
[.01131 .37788 0 10 ]
[.01131 .46867 -29 -10 ]
[.01131 .46867 0 10 ]
[.01131 .55946 -29 -10 ]
[.01131 .55946 0 10 ]
[ -0.005 -0.005 0 0 ]
[ 1.005 .62303 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21391 .01472 m
.21391 .02097 L
s
gsave
.21391 .00222 -78 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(100) show
1.000 setlinewidth
grestore
.404 .01472 m
.404 .02097 L
s
gsave
.404 .00222 -78 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(200) show
1.000 setlinewidth
grestore
.5941 .01472 m
.5941 .02097 L
s
gsave
.5941 .00222 -78 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(300) show
1.000 setlinewidth
grestore
.78419 .01472 m
.78419 .02097 L
s
gsave
.78419 .00222 -78 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(400) show
1.000 setlinewidth
grestore
.97429 .01472 m
.97429 .02097 L
s
gsave
.97429 .00222 -78 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(500) show
1.000 setlinewidth
grestore
.125 Mabswid
.06183 .01472 m
.06183 .01847 L
s
.09985 .01472 m
.09985 .01847 L
s
.13787 .01472 m
.13787 .01847 L
s
.17589 .01472 m
.17589 .01847 L
s
.25192 .01472 m
.25192 .01847 L
s
.28994 .01472 m
.28994 .01847 L
s
.32796 .01472 m
.32796 .01847 L
s
.36598 .01472 m
.36598 .01847 L
s
.44202 .01472 m
.44202 .01847 L
s
.48004 .01472 m
.48004 .01847 L
s
.51806 .01472 m
.51806 .01847 L
s
.55608 .01472 m
.55608 .01847 L
s
.63212 .01472 m
.63212 .01847 L
s
.67014 .01472 m
.67014 .01847 L
s
.70816 .01472 m
.70816 .01847 L
s
.74617 .01472 m
.74617 .01847 L
s
.82221 .01472 m
.82221 .01847 L
s
.86023 .01472 m
.86023 .01847 L
s
.89825 .01472 m
.89825 .01847 L
s
.93627 .01472 m
.93627 .01847 L
s
.01 w
0 .01472 m
1 .01472 L
s
.25 Mabswid
.02381 .10551 m
.03006 .10551 L
s
gsave
.01131 .10551 -90 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1.1) show
1.000 setlinewidth
grestore
.02381 .1963 m
.03006 .1963 L
s
gsave
.01131 .1963 -90 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1.2) show
1.000 setlinewidth
grestore
.02381 .28709 m
.03006 .28709 L
s
gsave
.01131 .28709 -90 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1.3) show
1.000 setlinewidth
grestore
.02381 .37788 m
.03006 .37788 L
s
gsave
.01131 .37788 -90 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1.4) show
1.000 setlinewidth
grestore
.02381 .46867 m
.03006 .46867 L
s
gsave
.01131 .46867 -90 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1.5) show
1.000 setlinewidth
grestore
.02381 .55946 m
.03006 .55946 L
s
gsave
.01131 .55946 -90 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1.6) show
1.000 setlinewidth
grestore
.125 Mabswid
.02381 .03287 m
.02756 .03287 L
s
.02381 .05103 m
.02756 .05103 L
s
.02381 .06919 m
.02756 .06919 L
s
.02381 .08735 m
.02756 .08735 L
s
.02381 .12366 m
.02756 .12366 L
s
.02381 .14182 m
.02756 .14182 L
s
.02381 .15998 m
.02756 .15998 L
s
.02381 .17814 m
.02756 .17814 L
s
.02381 .21445 m
.02756 .21445 L
s
.02381 .23261 m
.02756 .23261 L
s
.02381 .25077 m
.02756 .25077 L
s
.02381 .26893 m
.02756 .26893 L
s
.02381 .30524 m
.02756 .30524 L
s
.02381 .3234 m
.02756 .3234 L
s
.02381 .34156 m
.02756 .34156 L
s
.02381 .35972 m
.02756 .35972 L
s
.02381 .39604 m
.02756 .39604 L
s
.02381 .41419 m
.02756 .41419 L
s
.02381 .43235 m
.02756 .43235 L
s
.02381 .45051 m
.02756 .45051 L
s
.02381 .48683 m
.02756 .48683 L
s
.02381 .50498 m
.02756 .50498 L
s
.02381 .52314 m
.02756 .52314 L
s
.02381 .5413 m
.02756 .5413 L
s
.02381 .57762 m
.02756 .57762 L
s
.02381 .59577 m
.02756 .59577 L
s
.02381 .61393 m
.02756 .61393 L
s
.01 w
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02571 .01472 m
.02761 .01562 L
.02951 .01653 L
.03141 .01744 L
.03331 .01835 L
.03522 .01926 L
.03712 .02018 L
.03902 .02109 L
.04092 .022 L
.04282 .02292 L
.04472 .02384 L
.04662 .02475 L
.04852 .02567 L
.05042 .02659 L
.05232 .02751 L
.05422 .02843 L
.05613 .02935 L
.05803 .03027 L
.05993 .0312 L
.06183 .03212 L
.06373 .03305 L
.06563 .03397 L
.06753 .0349 L
.06943 .03583 L
.07133 .03676 L
.07323 .03769 L
.07514 .03862 L
.07704 .03955 L
.07894 .04048 L
.08084 .04142 L
.08274 .04235 L
.08464 .04329 L
.08654 .04422 L
.08844 .04516 L
.09034 .0461 L
.09224 .04704 L
.09415 .04798 L
.09605 .04892 L
.09795 .04986 L
.09985 .0508 L
.10175 .05175 L
.10365 .05269 L
.10555 .05364 L
.10745 .05459 L
.10935 .05553 L
.11125 .05648 L
.11315 .05743 L
.11506 .05838 L
.11696 .05933 L
.11886 .06029 L
Mistroke
.12076 .06124 L
.12266 .0622 L
.12456 .06315 L
.12646 .06411 L
.12836 .06506 L
.13026 .06602 L
.13216 .06698 L
.13407 .06794 L
.13597 .0689 L
.13787 .06986 L
.13977 .07083 L
.14167 .07179 L
.14357 .07276 L
.14547 .07372 L
.14737 .07469 L
.14927 .07566 L
.15117 .07663 L
.15307 .0776 L
.15498 .07857 L
.15688 .07954 L
.15878 .08051 L
.16068 .08149 L
.16258 .08246 L
.16448 .08344 L
.16638 .08441 L
.16828 .08539 L
.17018 .08637 L
.17208 .08735 L
.17399 .08833 L
.17589 .08931 L
.17779 .09029 L
.17969 .09128 L
.18159 .09226 L
.18349 .09325 L
.18539 .09423 L
.18729 .09522 L
.18919 .09621 L
.19109 .0972 L
.19299 .09819 L
.1949 .09918 L
.1968 .10017 L
.1987 .10117 L
.2006 .10216 L
.2025 .10315 L
.2044 .10415 L
.2063 .10515 L
.2082 .10615 L
.2101 .10715 L
.212 .10815 L
.21391 .10915 L
Mistroke
.21581 .11015 L
.21771 .11115 L
.21961 .11216 L
.22151 .11316 L
.22341 .11417 L
.22531 .11518 L
.22721 .11619 L
.22911 .11719 L
.23101 .11821 L
.23292 .11922 L
.23482 .12023 L
.23672 .12124 L
.23862 .12226 L
.24052 .12327 L
.24242 .12429 L
.24432 .12531 L
.24622 .12632 L
.24812 .12734 L
.25002 .12836 L
.25192 .12939 L
.25383 .13041 L
.25573 .13143 L
.25763 .13246 L
.25953 .13348 L
.26143 .13451 L
.26333 .13554 L
.26523 .13657 L
.26713 .1376 L
.26903 .13863 L
.27093 .13966 L
.27284 .14069 L
.27474 .14172 L
.27664 .14276 L
.27854 .1438 L
.28044 .14483 L
.28234 .14587 L
.28424 .14691 L
.28614 .14795 L
.28804 .14899 L
.28994 .15003 L
.29184 .15108 L
.29375 .15212 L
.29565 .15317 L
.29755 .15421 L
.29945 .15526 L
.30135 .15631 L
.30325 .15736 L
.30515 .15841 L
.30705 .15946 L
.30895 .16051 L
Mistroke
.31085 .16157 L
.31276 .16262 L
.31466 .16368 L
.31656 .16473 L
.31846 .16579 L
.32036 .16685 L
.32226 .16791 L
.32416 .16897 L
.32606 .17003 L
.32796 .1711 L
.32986 .17216 L
.33177 .17323 L
.33367 .17429 L
.33557 .17536 L
.33747 .17643 L
.33937 .1775 L
.34127 .17857 L
.34317 .17964 L
.34507 .18071 L
.34697 .18179 L
.34887 .18286 L
.35077 .18394 L
.35268 .18502 L
.35458 .18609 L
.35648 .18717 L
.35838 .18825 L
.36028 .18934 L
.36218 .19042 L
.36408 .1915 L
.36598 .19259 L
.36788 .19367 L
.36978 .19476 L
.37169 .19585 L
.37359 .19694 L
.37549 .19803 L
.37739 .19912 L
.37929 .20021 L
.38119 .2013 L
.38309 .2024 L
.38499 .20349 L
.38689 .20459 L
.38879 .20569 L
.39069 .20679 L
.3926 .20789 L
.3945 .20899 L
.3964 .21009 L
.3983 .21119 L
.4002 .2123 L
.4021 .2134 L
.404 .21451 L
Mistroke
.4059 .21562 L
.4078 .21673 L
.4097 .21784 L
.41161 .21895 L
.41351 .22006 L
.41541 .22117 L
.41731 .22229 L
.41921 .2234 L
.42111 .22452 L
.42301 .22564 L
.42491 .22676 L
.42681 .22788 L
.42871 .229 L
.43061 .23012 L
.43252 .23124 L
.43442 .23237 L
.43632 .23349 L
.43822 .23462 L
.44012 .23575 L
.44202 .23688 L
.44392 .23801 L
.44582 .23914 L
.44772 .24027 L
.44962 .2414 L
.45153 .24254 L
.45343 .24367 L
.45533 .24481 L
.45723 .24595 L
.45913 .24709 L
.46103 .24823 L
.46293 .24937 L
.46483 .25051 L
.46673 .25165 L
.46863 .2528 L
.47054 .25395 L
.47244 .25509 L
.47434 .25624 L
.47624 .25739 L
.47814 .25854 L
.48004 .25969 L
.48194 .26085 L
.48384 .262 L
.48574 .26315 L
.48764 .26431 L
.48954 .26547 L
.49145 .26663 L
.49335 .26779 L
.49525 .26895 L
.49715 .27011 L
.49905 .27127 L
Mistroke
.50095 .27244 L
.50285 .2736 L
.50475 .27477 L
.50665 .27594 L
.50855 .27711 L
.51046 .27828 L
.51236 .27945 L
.51426 .28062 L
.51616 .2818 L
.51806 .28297 L
.51996 .28415 L
.52186 .28532 L
.52376 .2865 L
.52566 .28768 L
.52756 .28886 L
.52946 .29005 L
.53137 .29123 L
.53327 .29241 L
.53517 .2936 L
.53707 .29479 L
.53897 .29597 L
.54087 .29716 L
.54277 .29835 L
.54467 .29954 L
.54657 .30074 L
.54847 .30193 L
.55038 .30313 L
.55228 .30432 L
.55418 .30552 L
.55608 .30672 L
.55798 .30792 L
.55988 .30912 L
.56178 .31032 L
.56368 .31153 L
.56558 .31273 L
.56748 .31394 L
.56939 .31514 L
.57129 .31635 L
.57319 .31756 L
.57509 .31877 L
.57699 .31998 L
.57889 .3212 L
.58079 .32241 L
.58269 .32363 L
.58459 .32484 L
.58649 .32606 L
.58839 .32728 L
.5903 .3285 L
.5922 .32972 L
.5941 .33095 L
Mistroke
.596 .33217 L
.5979 .3334 L
.5998 .33462 L
.6017 .33585 L
.6036 .33708 L
.6055 .33831 L
.6074 .33954 L
.60931 .34077 L
.61121 .34201 L
.61311 .34324 L
.61501 .34448 L
.61691 .34572 L
.61881 .34696 L
.62071 .3482 L
.62261 .34944 L
.62451 .35068 L
.62641 .35192 L
.62831 .35317 L
.63022 .35442 L
.63212 .35566 L
.63402 .35691 L
.63592 .35816 L
.63782 .35941 L
.63972 .36067 L
.64162 .36192 L
.64352 .36317 L
.64542 .36443 L
.64732 .36569 L
.64923 .36695 L
.65113 .36821 L
.65303 .36947 L
.65493 .37073 L
.65683 .372 L
.65873 .37326 L
.66063 .37453 L
.66253 .37579 L
.66443 .37706 L
.66633 .37833 L
.66823 .37961 L
.67014 .38088 L
.67204 .38215 L
.67394 .38343 L
.67584 .3847 L
.67774 .38598 L
.67964 .38726 L
.68154 .38854 L
.68344 .38982 L
.68534 .39111 L
.68724 .39239 L
.68915 .39368 L
Mistroke
.69105 .39496 L
.69295 .39625 L
.69485 .39754 L
.69675 .39883 L
.69865 .40012 L
.70055 .40142 L
.70245 .40271 L
.70435 .40401 L
.70625 .4053 L
.70816 .4066 L
.71006 .4079 L
.71196 .4092 L
.71386 .41051 L
.71576 .41181 L
.71766 .41312 L
.71956 .41442 L
.72146 .41573 L
.72336 .41704 L
.72526 .41835 L
.72716 .41966 L
.72907 .42097 L
.73097 .42229 L
.73287 .4236 L
.73477 .42492 L
.73667 .42624 L
.73857 .42756 L
.74047 .42888 L
.74237 .4302 L
.74427 .43152 L
.74617 .43285 L
.74808 .43417 L
.74998 .4355 L
.75188 .43683 L
.75378 .43816 L
.75568 .43949 L
.75758 .44082 L
.75948 .44216 L
.76138 .44349 L
.76328 .44483 L
.76518 .44617 L
.76708 .44751 L
.76899 .44885 L
.77089 .45019 L
.77279 .45153 L
.77469 .45288 L
.77659 .45422 L
.77849 .45557 L
.78039 .45692 L
.78229 .45827 L
.78419 .45962 L
Mistroke
.78609 .46097 L
.788 .46233 L
.7899 .46368 L
.7918 .46504 L
.7937 .4664 L
.7956 .46776 L
.7975 .46912 L
.7994 .47048 L
.8013 .47185 L
.8032 .47321 L
.8051 .47458 L
.80701 .47595 L
.80891 .47731 L
.81081 .47869 L
.81271 .48006 L
.81461 .48143 L
.81651 .4828 L
.81841 .48418 L
.82031 .48556 L
.82221 .48694 L
.82411 .48832 L
.82601 .4897 L
.82792 .49108 L
.82982 .49247 L
.83172 .49385 L
.83362 .49524 L
.83552 .49663 L
.83742 .49802 L
.83932 .49941 L
.84122 .5008 L
.84312 .50219 L
.84502 .50359 L
.84693 .50499 L
.84883 .50638 L
.85073 .50778 L
.85263 .50919 L
.85453 .51059 L
.85643 .51199 L
.85833 .5134 L
.86023 .5148 L
.86213 .51621 L
.86403 .51762 L
.86593 .51903 L
.86784 .52044 L
.86974 .52186 L
.87164 .52327 L
.87354 .52469 L
.87544 .52611 L
.87734 .52753 L
.87924 .52895 L
Mistroke
.88114 .53037 L
.88304 .53179 L
.88494 .53322 L
.88685 .53464 L
.88875 .53607 L
.89065 .5375 L
.89255 .53893 L
.89445 .54036 L
.89635 .5418 L
.89825 .54323 L
.90015 .54467 L
.90205 .54611 L
.90395 .54755 L
.90585 .54899 L
.90776 .55043 L
.90966 .55187 L
.91156 .55332 L
.91346 .55476 L
.91536 .55621 L
.91726 .55766 L
.91916 .55911 L
.92106 .56056 L
.92296 .56202 L
.92486 .56347 L
.92677 .56493 L
.92867 .56639 L
.93057 .56785 L
.93247 .56931 L
.93437 .57077 L
.93627 .57224 L
.93817 .5737 L
.94007 .57517 L
.94197 .57664 L
.94387 .57811 L
.94578 .57958 L
.94768 .58105 L
.94958 .58252 L
.95148 .584 L
.95338 .58548 L
.95528 .58696 L
.95718 .58844 L
.95908 .58992 L
.96098 .5914 L
.96288 .59289 L
.96478 .59437 L
.96669 .59586 L
.96859 .59735 L
.97049 .59884 L
.97239 .60033 L
.97429 .60182 L
Mistroke
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 355.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900001Hb000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00Q?oonfX3o`00O`Gooo]Z1Ol007l5oook
JPGo001oBooonfX9o`00O`?ooo]Z1Ol007l5oookJPGo001oC_oonfX5o`00O`Gooo]Z1Ol007l5oook
JPGo001oD?oonfX3o`00O`Cooo]Z1Ol007l5oookJPGo001oC_oonfX5o`00O`Gooo]Z1Ol007l5oook
JPGo001o2ooonfX008Cooo]Z0ol007l4oookJPOo001o0ooonfX7o`00Od[ooo]Z2Ol007l2oookJPOo
001o0ooonfX7o`00Odcooo]Z1ol007l3oookJPOo001o0ooonfX7o`00Odoooo]Z0ol007l3oookJPOo
001o0ooonfX7o`00Odcooo]Z1ol007l3oookJPOo001o0ooonfX7o`00O`[ooo]Z0024oookJP?o001o
1?oonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007m:oook
JPCo001o1ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool0
07m;oookJP?o001o0ooonfX3o`00O`;ooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o
00Cooo]Zo`00Ool007oo001oCooonfX3o`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007l3oook
JP?o001o00Cooo]Zo`00Ool007oo001oBooonfX4o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol0
07l01?oonf[o001oo`00Ool007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o2_oonfX008Cooo]Z
0ol007l3oookJP?o001o0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007m:oookJPCo
001o1OoonfX3o`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001oB_oonfX3o`00
O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooo
nfX3o`00OdWooo]Z2Ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o00Cooo]Zo`00Ool007oo
001o0ooonfX3o`00Od[ooo]Z0ol007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00
O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l9oookJP00Q?oonfX3o`00O`?ooo]Z0ol007l3oook
JP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00Od_ooo]Z1Ol007l3oookJP?o001o0ooonfX3
o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007m@oookJP?o001o00Cooo]Zo`00Ool007oo001o
0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007m9oookJPWo001o00Cooo]Zo`00Ool0
07oo001o0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007m@oookJP?o001o00Cooo]Z
o`00Ool007oo001o0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l9oookJP00Q?oo
nfX3o`00O`?ooo]Z0ol007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00Odgooo]Z
1?l007l2oookJP?o001o0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007m@oookJP?o
001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007m9
oookJP;o001o0ooonfX3o`00O`;ooo]Z0ol007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooo
nfX3o`00Oe3ooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o00Cooo]Zo`00Ool007oo
001o0ooonfX3o`00O`Wooo]Z0024oookJP?o001o0ooonfX3o`00O`?ooo]Z0ol007l01?oonf[o001o
o`00Ool007l3oookJP?o001oC_oonfX3o`00O`;ooo]Z0ol007l3oookJP?o001o00Cooo]Zo`00Ool0
07oo001o0ooonfX3o`00Odkooo]Z1?l007l2oookJP?o001o0ooonfX3o`00O`04oookJ_l007oo001o
o`00O`?ooo]Z0ol007m:oookJP;o001o0_oonfX3o`00O`;ooo]Z0ol007l3oookJP?o001o00Cooo]Z
o`00Ool007oo001o0ooonfX3o`00Od_ooo]Z0_l007l2oookJPCo001o00Cooo]Zo`00Ool007oo001o
0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l9oookJP00Q?oonfX3o`00O`?ooo]Z
0ol007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00Odoooo]Z0ol007l01?oonf[o
001oo`00Ool007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00Odkooo]Z0ol007l3
oookJP?o001o0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007m:oookJP?o001o00Co
oo]Zo`00Ool007oo001o0_oonfX3o`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o
001oBooonfX7o`00O`;ooo]Z0ol007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00
O`Wooo]Z0024oookJP?o001o0ooonfX3o`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007l3oook
JP?o001oBOoonfX3o`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001o00Cooo]Z
o`00Ool007oo001o0ooonfX3o`00Oe3ooo]Z0_l007l2oookJP?o001o0ooonfX3o`00O`04oookJ_l0
07oo001oo`00O`?ooo]Z0ol007m;oookJP;o001o00Cooo]Zo`00Ool007oo001o0_oonfX3o`00O`?o
oo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001oBooonfX6o`00O`?ooo]Z0ol007l3oook
JP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00O`Wooo]Z0021oookJPKo001o0ooonfX3o`00
O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007l3oookJP?o001oBOoonfX3o`00O`?ooo]Z0ol007l0
1?oonf[o001oo`00Ool007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00Od[ooo]Z
0ol007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooonfX3o`00O`04oookJ_l007oo001oo`00
O`?ooo]Z0ol007m<oookJPGo001o0_oonfX3o`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool007l3
oookJP?o001oBooonfX2o`00O`Oooo]Z0ol007l3oookJP?o001o00Cooo]Zo`00Ool007oo001o0ooo
nfX3o`00O`Wooo]Z000VoookJPGo0000E_oonfX6o`00O`Cooo]Z0ol007l01?oonf[o001oo`00Ool0
07l3oookJP?o001o00Cooo]Zo`00Ool007oo001oB_oonfX4o`00O`;ooo]Z0ol007l2oookJP?o001o
00Cooo]Zo`00Ool007oo001o0ooonfX3o`00O`04oookJ_l007oo001oo`00Od_ooo]Z0ol007l3oook
JP?o001o0_oonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l01?oonf[o001oo`00Ool0
07m=oookJPGo001o0ooonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l01?oonf[o001o
o`00Ool007m<oookJP;o001o2?oonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l01?oo
nf[o001oo`00Ool007l:oookJP009_oonfX5o`0005Sooo]Z1?l007l4oookJPOo001o0ooonfX7o`00
Od_ooo]Z1ol007l3oookJPOo001o0ooonfX7o`00Odcooo]Z1ol007l3oookJPOo001o0ooonfX7o`00
Odkooo]Z1?l007l3oookJPOo001o0ooonfX7o`00Odgooo]Z1ol007l2oookJPOo001o0ooonfX7o`00
O`[ooo]Z000VoookJPGo0000FOoonfX3o`00O`Gooo]Z1Ol007l5oookJPGo001oCOoonfX5o`00O`Go
oo]Z1Ol007l5oookJPGo001oC_oonfX5o`00O`Gooo]Z1Ol007l5oookJPGo001oD?oonfX3o`00O`Co
oo]Z1Ol007l5oookJPGo001oC_oonfX7o`00O`?ooo]Z1Ol007l5oookJPGo001o2ooonfX002Kooo]Z
1Ol0003ooookJ_oooo]Z5ooonfX002Kooo]Z1Ol0003ooookJ_oooo]Z5ooonfX002Kooo]Z1Ol0003o
oookJ_oooo]Z5ooonfX002Kooo]Z1Ol0003ooookJ_oooo]Z5ooonfX002Kooo]Z1Ol0003ooookJ_oo
oo]Z5ooonfX001Wooo]Zool0003oo`0002?o00001_oonfX001Wooo]Zool0003oo`0002?o00001_oo
nfX001Wooo]Zool0003oo`0002?o00001_oonfX001Wooo]Zool0003oo`0002?o00001_oonfX001Wo
oo]Zool0003oo`0002?o00001_oonfX002Kooo]Z1Ol00003oookJP;o0000GooonfX00ol0003ooo]Z
oookJP1SoookJP03o`000?oonf[ooo]Z06Cooo]Z00?o0000oookJ_oonfX0HooonfX00ol0003ooo]Z
oookJP1ToookJP03o`000?oonf[ooo]Z01Cooo]Z000VoookJPGo00001OoonfX2o`0005gooo]Z00?o
0000oookJ_oonfX0HooonfX00ol0003ooo]ZoookJP1ToookJP03o`000?oonf[ooo]Z06?ooo]Z00?o
0000oookJ_oonfX0I?oonfX00ol0003ooo]ZoookJP0DoookJP009_oonfX5o`0000Oooo]Z0_l0003o
oookJ_oooo]Z3_oonfX002Kooo]Z1Ol00009oookJP;o0000oooonf[ooookJPcooo]Z000VoookJPGo
00002ooonfX2o`000?oooo]ZoooonfX:oookJP009_oonfX5o`0000gooo]Z0_l0003ooookJ_oooo]Z
2?oonfX002Kooo]Z1Ol0000?oookJP;o0000oooonf[ooookJPKooo]Z000VoookJPGo00004OoonfX3
o`000?oooo]ZoooonfX3oookJP009_oonfX5o`0001Cooo]Z0_l0003ooookJ_oooo]Z0OoonfX002Ko
oo]Z1Ol0000FoookJP;o0000oooonf[noookJP009_oonfX5o`0001Sooo]Z0_l0003ooookJ_cooo]Z
000VoookJPGo00006_oonfX2o`000?oooo]Zn_oonfX002Kooo]Z1Ol0000LoookJP;o0000oooonf[h
oookJP009_oonfX5o`0001kooo]Z0_l0003ooookJ_Kooo]Z000VoookJPGo00008?oonfX2o`000?oo
oo]Zm?oonfX002Kooo]Z1Ol0000RoookJP;o0000oooonf[boookJP009_oonfX5o`0002Cooo]Z0_l0
003ooookJ_3ooo]Z000VoookJPGo00009_oonfX2o`000?oooo]Zk_oonfX002Kooo]Z1Ol0000Xoook
JP;o0000oooonf[/oookJP009_oonfX5o`0002[ooo]Z0_l0003ooookJ^[ooo]Z000VoookJPGo0000
;?oonfX2o`000?oooo]Zj?oonfX002Kooo]Z1Ol0000^oookJP;o0000oooonf[VoookJP009_oonfX5
o`00033ooo]Z0_l0003ooookJ^Cooo]Z000VoookJPGo0000<_oonfX2o`000?oooo]Zh_oonfX002Ko
oo]Z1Ol0000doookJP;o0000oooonf[PoookJP009_oonfX5o`0003Kooo]Z00?o0000oookJ_oonfX0
oooonf[MoookJP009_oonfX5o`0003Oooo]Z0_l0003ooookJ]gooo]Z000VoookJPGo0000>OoonfX3
o`000?oooo]Zf_oonfX002Kooo]Z1Ol0000loookJP;o0000oooonf[HoookJP009_oonfX5o`0003ko
oo]Z0_l0003ooookJ]Kooo]Z000VoookJPGo0000@?oonfX2o`000?oooo]Ze?oonfX002Kooo]Z1Ol0
0012oookJP;o0000oooonf[BoookJP009_oonfX5o`0004Cooo]Z0_l0003ooookJ]3ooo]Z000Voook
JPGo0000A_oonfX2o`000?oooo]Zc_oonfX002Kooo]Z1Ol00018oookJP;o0000oooonf[<oookJP00
9_oonfX5o`0004[ooo]Z0_l0003ooookJ/[ooo]Z000VoookJPGo0000C?oonfX2o`000?oooo]Zb?oo
nfX002Kooo]Z1Ol0001>oookJP03o`000?oonf[ooo]Z0?oooo]ZaOoonfX002Kooo]Z1Ol0001?oook
JP;o0000oooonf[5oookJP009_oonfX5o`00057ooo]Z0_l0003ooookJ/?ooo]Z000VoookJPGo0000
DooonfX2o`000?oooo]Z`OoonfX002Kooo]Z1Ol0001EoookJP;o0000oooonfZooookJP002_oonfX3
o`00O`Cooo]Z0ol007l5oookJP?o001o2_oonfX5o`0005Oooo]Z0_l0003ooookJ[gooo]Z000:oook
JP?o001o1?oonfX3o`00O`Gooo]Z0ol007l:oookJPGo0000FOoonfX2o`000?oooo]Z^ooonfX000[o
oo]Z0ol007l4oookJP?o001o1OoonfX3o`00O`[ooo]Z1Ol0001KoookJP;o0000oooonfZioookJP00
2_oonfX3o`00O`cooo]Z0ol007l:oookJPGo0000GOoonfX00ol0003ooo]ZoookJP3ooookJ[Kooo]Z
000:oookJP?o001o3?oonfX3o`00O`[ooo]Z1_l0001MoookJP;o0000oooonfZfoookJP002_oonfX3
o`00O`cooo]Z0ol007l:oookJPGo0000H?oonfX3o`000?oooo]Z/ooonfX000[ooo]Z0ol007l<oook
JP?o001o2_oonfX5o`0006?ooo]Z0_l0003ooookJ[7ooo]Z000:oookJP?o001o3?oonfX3o`00O`[o
oo]Z1Ol0001UoookJP;o0000oooonfZ_oookJP002_oonfX3o`00O`cooo]Z0ol007l:oookJPGo0000
IooonfX2o`000?oooo]Z[OoonfX000Oooo]Z1_l007l9oookJPKo001o2_oonfX5o`0006Wooo]Z00?o
0000oookJ_oonfX0oooonfZZoookJP001ooonfX6o`00O`Wooo]Z1_l007l:oookJPGo0000J_oonfX2
o`000?oooo]ZZ_oonfX000Wooo]Z1?l007l;oookJPCo001o2_oonfX5o`0006cooo]Z0_l0003ooook
JZSooo]Z000:oookJP?o001o3?oonfX3o`00O`[ooo]Z1Ol0001^oookJP;o0000oooonfZVoookJP00
9_oonfX5o`00073ooo]Z0_l0003ooookJZCooo]Z000VoookJPGo0000L_oonfX2o`000?oooo]ZX_oo
nfX002Kooo]Z1Ol0001doookJP03o`000?oonf[ooo]Z0?oooo]ZWooonfX002Kooo]Z1Ol0001eoook
JP;o0000oooonfZOoookJP009_oonfX5o`0007Oooo]Z0_l0003ooookJYgooo]Z000VoookJPGo0000
NOoonfX2o`000?oooo]ZVooonfX002Kooo]Z1Ol0001koookJP;o0000oooonfZIoookJP009_oonfX5
o`0007gooo]Z0_l0003ooookJYOooo]Z000VoookJPGo0000OooonfX00ol0003ooo]ZoookJP3ooook
JYCooo]Z000VoookJPGo0000P?oonfX2o`000?oooo]ZU?oonfX002Kooo]Z1Ol00022oookJP;o0000
oooonfZBoookJP009_oonfX5o`0008Cooo]Z0_l0003ooookJY3ooo]Z000VoookJPGo0000Q_oonfX0
0ol0003ooo]ZoookJP3ooookJXgooo]Z000VoookJPGo0000QooonfX2o`000?oooo]ZSOoonfX002Ko
oo]Z1Ol00029oookJP?o0000oooonfZ:oookJP009_oonfX5o`0008cooo]Z0_l0003ooookJXSooo]Z
000VoookJPGo0000S_oonfX2o`000?oooo]ZQ_oonfX002Kooo]Z1Ol0002@oookJP03o`000?oonf[o
oo]Z0?oooo]ZPooonfX002Kooo]Z1Ol0002AoookJP;o0000oooonfZ3oookJP009_oonfX5o`0009?o
oo]Z0_l0003ooookJX7ooo]Z000VoookJPGo0000UOoonfX2o`000?oooo]ZOooonfX002Kooo]Z1Ol0
002GoookJP03o`000?oonf[ooo]Z0?oooo]ZO?oonfX002Kooo]Z1Ol0002HoookJP;o0000oooonfYl
oookJP009_oonfX5o`0009[ooo]Z0_l0003ooookJW[ooo]Z000VoookJPGo0000W?oonfX2o`000?oo
oo]ZN?oonfX002Kooo]Z1Ol0002NoookJP03o`000?oonf[ooo]Z0?oooo]ZMOoonfX002Kooo]Z1Ol0
002OoookJP;o0000oooonfYeoookJP009_oonfX5o`000:7ooo]Z0_l0003ooookJW?ooo]Z000Voook
JPGo0000XooonfX2o`000?oooo]ZLOoonfX002Kooo]Z1Ol0002UoookJP03o`000?oonf[ooo]Z0?oo
oo]ZK_oonfX002Kooo]Z1Ol0002VoookJP;o0000oooonfY^oookJP009_oonfX5o`000:Sooo]Z0_l0
003ooookJVcooo]Z000VoookJPGo0000Z_oonfX2o`000?oooo]ZJ_oonfX002Kooo]Z1Ol0002/oook
JP03o`000?oonf[ooo]Z0?oooo]ZIooonfX002Kooo]Z1Ol0002]oookJP;o0000oooonfYWoookJP00
9_oonfX5o`000:oooo]Z0_l0003ooookJVGooo]Z000:oookJP?o001o1?oonfX3o`00O`03oookJ_l0
07oo001o00Oo001o2?oonfX5o`000;7ooo]Z0_l0003ooookJV?ooo]Z000:oookJP?o001o1?oonfX3
o`00O`03oookJ_l007oo001o00Oo001o2?oonfX5o`000;?ooo]Z0_l0003ooookJV7ooo]Z000:oook
JP?o001o1?oonfX3o`00O`03oookJ_l007oo001o00;o001o3OoonfX5o`000;Gooo]Z0_l0003ooook
JUoooo]Z000:oookJP?o001o2OoonfX4o`00O`cooo]Z1Ol0002goookJP;o0000oooonfYMoookJP00
2_oonfX3o`00O`[ooo]Z1Ol007l:oookJPKo0000^?oonfX00ol0003ooo]ZoookJP3ooookJU[ooo]Z
000:oookJP?o001o3?oonfX4o`00O`Wooo]Z1Ol0002joookJP;o0000oooonfYJoookJP002_oonfX3
o`00O`gooo]Z0ol007l9oookJPGo0000_?oonfX2o`000?oooo]ZF?oonfX000[ooo]Z0ol007l>oook
JP?o001o2?oonfX5o`000;kooo]Z00?o0000oookJ_oonfX0oooonfYEoookJP002_oonfX3o`00O`So
oo]Z0ol007l3oookJP?o001o2?oonfX5o`000;oooo]Z0_l0003ooookJUGooo]Z0007oookJPKo001o
2?oonfX3o`00O`?ooo]Z0ol007l8oookJPGo0000`OoonfX2o`000?oooo]ZDooonfX000Oooo]Z1_l0
07l8oookJPCo001o0_oonfX3o`00O`Sooo]Z1Ol00033oookJP03o`000?oonf[ooo]Z0?oooo]ZD?oo
nfX000Wooo]Z1?l007l9oookJPOo001o2OoonfX5o`000<Cooo]Z0_l0003ooookJU3ooo]Z000:oook
JP?o001o2_oonfX5o`00O`[ooo]Z1Ol00036oookJP;o0000oooonfY>oookJP009_oonfX5o`000<So
oo]Z0_l0003ooookJTcooo]Z000VoookJPGo0000b_oonfX00ol0003ooo]ZoookJP3ooookJTWooo]Z
000VoookJPGo0000booonfX2o`000?oooo]ZBOoonfX002Kooo]Z1Ol0003=oookJP;o0000oooonfY7
oookJP009_oonfX5o`000<oooo]Z00?o0000oookJ_oonfX0oooonfY4oookJP009_oonfX5o`000=3o
oo]Z0_l0003ooookJTCooo]Z000VoookJPGo0000d_oonfX2o`000?oooo]Z@_oonfX002Kooo]Z1Ol0
003DoookJP03o`000?oonf[ooo]Z0?oooo]Z?ooonfX002Kooo]Z1Ol0003EoookJP;o0000oooonfXo
oookJP009_oonfX5o`000=Oooo]Z00?o0000oookJ_oonfX0oooonfXloookJP009_oonfX5o`000=So
oo]Z0ol0003ooookJS_ooo]Z000VoookJPGo0000fooonfX2o`000?oooo]Z>OoonfX002Kooo]Z1Ol0
003MoookJP03o`000?oonf[ooo]Z0?oooo]Z=_oonfX002Kooo]Z1Ol0003NoookJP;o0000oooonfXf
oookJP009_oonfX5o`000>3ooo]Z0_l0003ooookJSCooo]Z000VoookJPGo0000h_oonfX00ol0003o
oo]ZoookJP3ooookJS7ooo]Z000VoookJPGo0000hooonfX2o`000?oooo]Z<OoonfX002Kooo]Z1Ol0
003UoookJP;o0000oooonfX_oookJP009_oonfX5o`000>Oooo]Z00?o0000oookJ_oonfX0oooonfX/
oookJP009_oonfX5o`000>Sooo]Z0_l0003ooookJRcooo]Z000VoookJPGo0000j_oonfX00ol0003o
oo]ZoookJP3ooookJRWooo]Z000VoookJPGo0000jooonfX2o`000?oooo]Z:OoonfX002Kooo]Z1Ol0
003]oookJP;o0000oooonfXWoookJP009_oonfX5o`000>oooo]Z00?o0000oookJ_oonfX0oooonfXT
oookJP009_oonfX5o`000?3ooo]Z0_l0003ooookJRCooo]Z000VoookJPGo0000l_oonfX2o`000?oo
oo]Z8_oonfX002Kooo]Z1Ol0003doookJP03o`000?oonf[ooo]Z0?oooo]Z7ooonfX002Kooo]Z1Ol0
003eoookJP;o0000oooonfXOoookJP009_oonfX5o`000?Oooo]Z00?o0000oookJ_oonfX0oooonfXL
oookJP009_oonfX5o`000?Sooo]Z0_l0003ooookJQcooo]Z000VoookJPGo0000n_oonfX2o`000?oo
oo]Z6_oonfX002Kooo]Z1Ol0003loookJP03o`000?oonf[ooo]Z0?oooo]Z5ooonfX002Kooo]Z1Ol0
003moookJP;o0000oooonfXGoookJP009_oonfX5o`000?oooo]Z00?o0000oookJ_oonfX0oooonfXD
oookJP009_oonfX5o`000?oooo]Z0OoonfX2o`000?oooo]Z5?oonfX002Kooo]Z1Ol0003ooookJP?o
oo]Z0ol0003ooookJQ7ooo]Z000:oookJP?o001o1?oonfX3o`00O`?ooo]Z1Ol007l:oookJPGo0000
oooonfX6oookJP03o`000?oonf[ooo]Z0?oooo]Z3_oonfX000[ooo]Z0ol007l4oookJP?o001o0_oo
nfX7o`00O`Wooo]Z1Ol0003ooookJPOooo]Z0_l0003ooookJPkooo]Z000:oookJP?o001o1?oonfX3
o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l8oookJPGo0000oooonfX9oookJP03o`000?oo
nf[ooo]Z0?oooo]Z2ooonfX000[ooo]Z0ol007l8oookJP?o001o0ooonfX3o`00O`Sooo]Z1Ol0003o
oookJP[ooo]Z0_l0003ooookJP_ooo]Z000:oookJP?o001o3_oonfX3o`00O`Sooo]Z1_l0003ooook
JP_ooo]Z00?o0000oookJ_oonfX0oooonfX8oookJP002_oonfX3o`00O`kooo]Z0ol007l8oookJPGo
0000oooonfX=oookJP;o0000oooonfX8oookJP002_oonfX3o`00O`cooo]Z1?l007l9oookJPGo0000
oooonfX?oookJP;o0000oooonfX6oookJP002_oonfX3o`00O`cooo]Z0ol007l:oookJPGo0000oooo
nfXAoookJP03o`000?oonf[ooo]Z0?oooo]Z0ooonfX000[ooo]Z0ol007l>oookJP;o001o2OoonfX5
o`000?oooo]Z4_oonfX2o`000?oooo]Z0ooonfX000Oooo]Z1_l007l8oookJP?o001o0ooonfX3o`00
O`Sooo]Z1Ol0003ooookJQCooo]Z00?o0000oookJ_oonfX0oooonfX000Oooo]Z1_l007l8oookJP?o
001o0ooonfX3o`00O`Sooo]Z1Ol0003ooookJQGooo]Z0_l0003ooookJP002OoonfX4o`00O`Wooo]Z
1ol007l9oookJPGo0000oooonfXGoookJP03o`000?oonf[ooo]Z0?cooo]Z000:oookJP?o001o2_oo
nfX5o`00O`[ooo]Z1Ol0003ooookJQSooo]Z0_l0003loookJP009_oonfX5o`000?oooo]Z6_oonfX0
0ol0003ooo]ZoookJP3ioookJP009_oonfX5o`000?oooo]Z6ooonfX2o`000?Wooo]Z000VoookJPGo
0000oooonfXMoookJP;o0000mooonfX002Kooo]Z1Ol0003ooookJQoooo]Z00?o0000oookJ_oonfX0
m?oonfX002Kooo]Z1Ol0003ooookJR3ooo]Z0_l0003doookJP009_oonfX5o`000?oooo]Z8_oonfX0
0ol0003ooo]ZoookJP3aoookJP009_oonfX5o`000?oooo]Z8ooonfX2o`000?7ooo]Z000VoookJPGo
0000oooonfXUoookJP03o`000?oonf[ooo]Z0>kooo]Z000VoookJPGo0000oooonfXVoookJP;o0000
k_oonfX002Kooo]Z1Ol0003ooookJRSooo]Z00?o0000oookJ_oonfX0jooonfX002Kooo]Z1Ol0003o
oookJRWooo]Z0_l0003[oookJP009_oonfX5o`000?oooo]Z:ooonfX2o`000>Wooo]Z000VoookJPGo
0000oooonfX]oookJP;o0000iooonfX002Kooo]Z1Ol0003ooookJRoooo]Z00?o0000oookJ_oonfX0
i?oonfX002Kooo]Z1Ol0003ooookJS3ooo]Z0_l0003ToookJP009_oonfX5o`000?oooo]Z<_oonfX0
0ol0003ooo]ZoookJP3QoookJP009_oonfX5o`000?oooo]Z<ooonfX2o`000>7ooo]Z000VoookJPGo
0000oooonfXeoookJP03o`000?oonf[ooo]Z0=kooo]Z000VoookJPGo0000oooonfXfoookJP;o0000
g_oonfX002Kooo]Z1Ol0003ooookJSSooo]Z00?o0000oookJ_oonfX0fooonfX002Kooo]Z1Ol0003o
oookJSWooo]Z0_l0003KoookJP009_oonfX5o`000?oooo]Z>ooonfX00ol0003ooo]ZoookJP3Hoook
JP009_oonfX5o`000?oooo]Z??oonfX2o`000=Sooo]Z000VoookJPGo0000oooonfXnoookJP03o`00
0?oonf[ooo]Z0=Gooo]Z000VoookJPGo0000oooonfXooookJP;o0000eOoonfX002Kooo]Z1Ol0003o
oookJT7ooo]Z00?o0000oookJ_oonfX0d_oonfX002Kooo]Z1Ol0003ooookJT;ooo]Z0_l0003Boook
JP009_oonfX5o`000?oooo]ZA?oonfX00ol0003ooo]ZoookJP3?oookJP009_oonfX5o`000?oooo]Z
AOoonfX2o`000<oooo]Z000VoookJPGo0000oooonfY7oookJP03o`000?oonf[ooo]Z0<cooo]Z000V
oookJPGo0000oooonfY8oookJP;o0000c?oonfX002Kooo]Z1Ol0003ooookJT[ooo]Z00?o0000oook
J_oonfX0bOoonfX002Kooo]Z1Ol0003ooookJT_ooo]Z0_l00039oookJP009_oonfX5o`000?oooo]Z
COoonfX00ol0003ooo]ZoookJP36oookJP009_oonfX5o`000?oooo]ZC_oonfX2o`000<Kooo]Z000V
oookJPGo0000oooonfY@oookJP03o`000?oonf[ooo]Z0<?ooo]Z000:oookJP?o001o1?oonfX3o`00
O`Kooo]Z0ol007l9oookJPGo0000oooonfYAoookJP;o0000`ooonfX000[ooo]Z0ol007l4oookJP?o
001o1_oonfX3o`00O`Wooo]Z1Ol0003ooookJU?ooo]Z0_l00031oookJP002_oonfX3o`00O`Cooo]Z
0ol007l6oookJP?o001o2OoonfX5o`000?oooo]ZEOoonfX2o`000;oooo]Z000:oookJP?o001o2?oo
nfX9o`00O`Sooo]Z1Ol0003ooookJUOooo]Z00?o0000oookJ_oonfX0_?oonfX000[ooo]Z0ol007l8
oookJPWo001o2?oonfX6o`000?oooo]ZEooonfX2o`000;cooo]Z000:oookJP?o001o2?oonfX2o`00
O`?ooo]Z0ol007l9oookJPGo0000oooonfYJoookJP03o`000?oonf[ooo]Z0;Wooo]Z000:oookJP?o
001o2OoonfX2o`00O`;ooo]Z0ol007l9oookJPGo0000oooonfYKoookJP03o`000?oonf[ooo]Z0;So
oo]Z000:oookJP?o001o2OoonfX3o`00O`04oookJ_l007oo001oo`00O`Wooo]Z1Ol0003ooookJUco
oo]Z0_l0002hoookJP002_oonfX3o`00O`[ooo]Z0_l007l01?oonf[o001oo`00Ool007l9oookJPGo
0000oooonfYNoookJP03o`000?oonf[ooo]Z0;Gooo]Z0007oookJPKo001o2ooonfX5o`00O`Wooo]Z
1Ol0003ooookJUoooo]Z0_l0002eoookJP001ooonfX6o`00O`_ooo]Z1Ol007l9oookJPGo0000oooo
nfYQoookJP03o`000?oonf[ooo]Z0;;ooo]Z0009oookJPCo001o3?oonfX4o`00O`Wooo]Z1Ol0003o
oookJV;ooo]Z0_l0002boookJP002_oonfX3o`00O`gooo]Z0ol007l9oookJPGo0000oooonfYToook
JP03o`000?oonf[ooo]Z0:oooo]Z000VoookJPGo0000oooonfYUoookJP;o0000[ooonfX002Kooo]Z
1Ol0003ooookJVOooo]Z00?o0000oookJ_oonfX0[?oonfX002Kooo]Z1Ol0003ooookJVSooo]Z00?o
0000oookJ_oonfX0ZooonfX002Kooo]Z1Ol0003ooookJVWooo]Z0_l0002[oookJP009_oonfX5o`00
0?oooo]ZJooonfX00ol0003ooo]ZoookJP2XoookJP009_oonfX5o`000?oooo]ZK?oonfX2o`000:So
oo]Z000VoookJPGo0000oooonfY^oookJP03o`000?oonf[ooo]Z0:Gooo]Z000VoookJPGo0000oooo
nfY_oookJP;o0000YOoonfX002Kooo]Z1Ol0003ooookJW7ooo]Z00?o0000oookJ_oonfX0X_oonfX0
02Kooo]Z1Ol0003ooookJW;ooo]Z00?o0000oookJ_oonfX0XOoonfX002Kooo]Z1Ol0003ooookJW?o
oo]Z0_l0002QoookJP009_oonfX5o`000?oooo]ZMOoonfX00ol0003ooo]ZoookJP2NoookJP009_oo
nfX5o`000?oooo]ZM_oonfX2o`0009kooo]Z000VoookJPGo0000oooonfYhoookJP03o`000?oonf[o
oo]Z09_ooo]Z000VoookJPGo0000oooonfYioookJP;o0000VooonfX002Kooo]Z1Ol0003ooookJW_o
oo]Z0_l0002IoookJP009_oonfX5o`000?oooo]ZOOoonfX00ol0003ooo]ZoookJP2FoookJP009_oo
nfX5o`000?oooo]ZO_oonfX2o`0009Kooo]Z000VoookJPGo0000oooonfZ0oookJP03o`000?oonf[o
oo]Z09?ooo]Z000VoookJPGo0000oooonfZ1oookJP;o0000TooonfX002Kooo]Z1Ol0003ooookJX?o
oo]Z00?o0000oookJ_oonfX0T?oonfX002Kooo]Z1Ol0003ooookJXCooo]Z00?o0000oookJ_oonfX0
SooonfX002Kooo]Z1Ol0003ooookJXGooo]Z0_l0002?oookJP009_oonfX5o`000?oooo]ZQooonfX0
0ol0003ooo]ZoookJP2<oookJP009_oonfX5o`000?oooo]ZR?oonfX2o`0008cooo]Z000VoookJPGo
0000oooonfZ:oookJP03o`000?oonf[ooo]Z08Wooo]Z000VoookJPGo0000oooonfZ;oookJP03o`00
0?oonf[ooo]Z08Sooo]Z000VoookJPGo0000oooonfZ<oookJP;o0000R?oonfX002Kooo]Z1Ol0003o
oookJXkooo]Z00?o0000oookJ_oonfX0QOoonfX002Kooo]Z1Ol0003ooookJXoooo]Z00?o0000oook
J_oonfX0Q?oonfX002Kooo]Z1Ol0003ooookJY3ooo]Z0_l00024oookJP009_oonfX5o`000?oooo]Z
T_oonfX00ol0003ooo]ZoookJP21oookJP009_oonfX5o`000?oooo]ZTooonfX2o`00087ooo]Z000V
oookJPGo0000oooonfZEoookJP03o`000?oonf[ooo]Z07kooo]Z000VoookJPGo0000oooonfZFoook
JP03o`000?oonf[ooo]Z07gooo]Z000VoookJPGo0000oooonfZGoookJP;o0000OOoonfX000[ooo]Z
0ol007l4oookJP?o001o0ooonfX5o`00O`[ooo]Z1Ol0003ooookJYWooo]Z00?o0000oookJ_oonfX0
N_oonfX000[ooo]Z0ol007l4oookJP?o001o0_oonfX7o`00O`Wooo]Z1Ol0003ooookJY[ooo]Z00?o
0000oookJ_oonfX0NOoonfX000[ooo]Z0ol007l4oookJP?o001o00?ooo]Zo`00Ool007l00_l007l0
1?oonf[o001oo`00Ool007l9oookJPGo0000oooonfZKoookJP;o0000NOoonfX000[ooo]Z0ol007l8
oookJP?o001o0ooonfX3o`00O`Sooo]Z1Ol0003ooookJYgooo]Z00?o0000oookJ_oonfX0M_oonfX0
00[ooo]Z0ol007l>oookJP?o001o2?oonfX6o`000?oooo]ZWOoonfX2o`0007Kooo]Z000:oookJP?o
001o3_oonfX3o`00O`Sooo]Z1Ol0003ooookJZ3ooo]Z00?o0000oookJ_oonfX0LooonfX000[ooo]Z
0ol007l9oookJP;o001o0_oonfX4o`00O`Sooo]Z1Ol0003ooookJZ7ooo]Z00?o0000oookJ_oonfX0
L_oonfX000[ooo]Z0ol007l9oookJPOo001o2OoonfX5o`000?oooo]ZX_oonfX3o`00077ooo]Z000:
oookJP?o001o2OoonfX6o`00O`[ooo]Z1Ol0003ooookJZGooo]Z00?o0000oookJ_oonfX0K_oonfX0
00Oooo]Z1_l007l9oookJP;o001o3_oonfX5o`000?oooo]ZY_oonfX00ol0003ooo]ZoookJP1]oook
JP001ooonfX6o`00O`Wooo]Z0_l007l>oookJPGo0000oooonfZWoookJP;o0000KOoonfX000Wooo]Z
1?l007l:oookJPOo001o2?oonfX5o`000?oooo]ZZOoonfX00ol0003ooo]ZoookJP1ZoookJP002_oo
nfX3o`00O`[ooo]Z1ol007l8oookJPGo0000oooonfZZoookJP03o`000?oonf[ooo]Z06Wooo]Z000V
oookJPGo0000oooonfZ[oookJP;o0000JOoonfX002Kooo]Z1Ol0003ooookJZgooo]Z00?o0000oook
J_oonfX0I_oonfX002Kooo]Z1Ol0003ooookJZkooo]Z00?o0000oookJ_oonfX0IOoonfX002Kooo]Z
1Ol0003ooookJZoooo]Z0_l0001UoookJP009_oonfX5o`000?oooo]Z/OoonfX00ol0003ooo]Zoook
JP1RoookJP009_oonfX5o`000?oooo]Z/_oonfX00ol0003ooo]ZoookJP1QoookJP009_oonfX5o`00
0?oooo]Z/ooonfX2o`00067ooo]Z000VoookJPGo0000oooonfZeoookJP03o`000?oonf[ooo]Z05ko
oo]Z000VoookJPGo0000oooonfZfoookJP03o`000?oonf[ooo]Z05gooo]Z000VoookJPGo0000oooo
nfZgoookJP;o0000GOoonfX002Kooo]Z1Ol0003ooookJ[Wooo]Z00?o0000oookJ_oonfX0F_oonfX0
02Kooo]Z1Ol0003ooookJ[[ooo]Z00?o0000oookJ_oonfX0FOoonfX002Kooo]Z1Ol0003ooookJ[_o
oo]Z0_l0001IoookJP009_oonfX5o`000?oooo]Z_OoonfX00ol0003ooo]ZoookJP1FoookJP009_oo
nfX5o`000?oooo]Z__oonfX00ol0003ooo]ZoookJP1EoookJP009_oonfX5o`000?oooo]Z_ooonfX2
o`0005Gooo]Z000VoookJPGo0000oooonf[1oookJP03o`000?oonf[ooo]Z05;ooo]Z000VoookJPGo
0000oooonf[2oookJP03o`000?oonf[ooo]Z057ooo]Z000VoookJPGo0000oooonf[3oookJP;o0000
DOoonfX002Kooo]Z1Ol0003ooookJ/Gooo]Z00?o0000oookJ_oonfX0C_oonfX002Kooo]Z1Ol0003o
oookJ/Kooo]Z00?o0000oookJ_oonfX0COoonfX002Kooo]Z1Ol0003ooookJ/Oooo]Z0_l0001=oook
JP009_oonfX5o`000?oooo]ZbOoonfX00ol0003ooo]ZoookJP1:oookJP009_oonfX5o`000?oooo]Z
b_oonfX00ol0003ooo]ZoookJP19oookJP009_oonfX5o`000?oooo]ZbooonfX2o`0004Wooo]Z000V
oookJPGo0000oooonf[=oookJP;o0000AooonfX002Kooo]Z1Ol0003ooookJ/oooo]Z00?o0000oook
J_oonfX0A?oonfX002Kooo]Z1Ol0003ooookJ]3ooo]Z00?o0000oookJ_oonfX0@ooonfX002Kooo]Z
1Ol0003ooookJ]7ooo]Z0_l00013oookJP009_oonfX5o`000?oooo]ZdooonfX00ol0003ooo]Zoook
JP10oookJP009_oonfX5o`000?oooo]Ze?oonfX00ol0003ooo]ZoookJP0ooookJP009_oonfX5o`00
0?oooo]ZeOoonfX2o`0003oooo]Z000VoookJPGo0000oooonf[GoookJP03o`000?oonf[ooo]Z03co
oo]Z000VoookJPGo0000oooonf[HoookJP03o`000?oonf[ooo]Z03_ooo]Z000VoookJPGo0000oooo
nf[IoookJP03o`000?oonf[ooo]Z03[ooo]Z000VoookJPGo0000oooonf[JoookJP;o0000>_oonfX0
00[ooo]Z0ol007l4oookJP?o001o0ooonfX5o`00O`[ooo]Z1Ol0003ooookJ]cooo]Z00?o0000oook
J_oonfX0=ooonfX000[ooo]Z0ol007l4oookJP?o001o0_oonfX7o`00O`Wooo]Z1Ol0003ooookJ]go
oo]Z00?o0000oookJ_oonfX0=_oonfX000[ooo]Z0ol007l4oookJP?o001o0_oonfX3o`00O`;ooo]Z
0ol007l8oookJPGo0000oooonf[NoookJP;o0000=_oonfX000[ooo]Z0ol007l8oookJP?o001o0ooo
nfX3o`00O`Sooo]Z1Ol0003ooookJ^3ooo]Z00?o0000oookJ_oonfX0<ooonfX000[ooo]Z0ol007l8
oookJP?o001o0ooonfX3o`00O`Sooo]Z1_l0003ooookJ^3ooo]Z00?o0000oookJ_oonfX0<_oonfX0
00[ooo]Z0ol007l8oookJPCo001o0_oonfX3o`00O`Sooo]Z1Ol0003ooookJ^;ooo]Z00?o0000oook
J_oonfX0<OoonfX000[ooo]Z0ol007l8oookJPSo001o2OoonfX5o`000?oooo]ZhooonfX2o`00037o
oo]Z000:oookJP?o001o2?oonfX3o`00O`04oookJ_l007oo001oo`00O`[ooo]Z1Ol0003ooookJ^Go
oo]Z00?o0000oookJ_oonfX0;_oonfX000[ooo]Z0ol007l8oookJP?o001o3_oonfX5o`000?oooo]Z
i_oonfX00ol0003ooo]ZoookJP0]oookJP001ooonfX6o`00O`Sooo]Z0ol007l>oookJPGo0000oooo
nf[WoookJP03o`000?oonf[ooo]Z02cooo]Z0007oookJPKo001o2OoonfX3o`00O`;ooo]Z0ol007l8
oookJPGo0000oooonf[XoookJP;o0000;?oonfX000Wooo]Z1?l007l9oookJPOo001o2OoonfX5o`00
0?oooo]Zj_oonfX00ol0003ooo]ZoookJP0YoookJP002_oonfX3o`00O`_ooo]Z1?l007l:oookJPGo
0000oooonf[[oookJP03o`000?oonf[ooo]Z02Sooo]Z000VoookJPGo0000oooonf[/oookJP;o0000
:?oonfX002Kooo]Z1Ol0003ooookJ^kooo]Z00?o0000oookJ_oonfX09OoonfX002Kooo]Z1Ol0003o
oookJ^oooo]Z00?o0000oookJ_oonfX09?oonfX002Kooo]Z1Ol0003ooookJ_3ooo]Z00?o0000oook
J_oonfX08ooonfX002Kooo]Z1Ol0003ooookJ_7ooo]Z0_l0000SoookJP009_oonfX5o`000?oooo]Z
looonfX2o`00027ooo]Z000VoookJPGo0000oooonf[eoookJP03o`000?oonf[ooo]Z01kooo]Z000V
oookJPGo0000oooonf[foookJP03o`000?oonf[ooo]Z01gooo]Z000VoookJPGo0000oooonf[goook
JP;o00007OoonfX002Kooo]Z1Ol0003ooookJ_Wooo]Z00?o0000oookJ_oonfX06_oonfX002Kooo]Z
1Ol0003ooookJ_[ooo]Z00?o0000oookJ_oonfX06OoonfX002Kooo]Z1Ol0003ooookJ__ooo]Z00?o
0000oookJ_oonfX06?oonfX002Kooo]Z1Ol0003ooookJ_cooo]Z0_l0000HoookJP009_oonfX5o`00
0?oooo]Zo_oonfX00ol0003ooo]ZoookJP0EoookJP009_oonfX5o`000?oooo]ZoooonfX00ol0003o
oo]ZoookJP0DoookJP009_oonfX5o`000?oooo]ZoooonfX1oookJP03o`000?oonf[ooo]Z01?ooo]Z
000VoookJPGo0000oooonf[ooookJQOooo]Z000VoookJPGo0000oooonf[ooookJQOooo]Z000Voook
JPGo0000oooonf[ooookJQOooo]Z000VoookJPGo0000oooonf[ooookJQOooo]Z000VoookJPGo0000
oooonf[ooookJQOooo]Z000VoookJPGo0000oooonf[ooookJQOooo]Z000VoookJPGo0000oooonf[o
oookJQOooo]Z000VoookJPGo0000oooonf[ooookJQOooo]Z000VoookJPGo0000oooonf[ooookJQOo
oo]Z000VoookJPGo0000oooonf[ooookJQOooo]Z0000\
\>"],
  ImageRangeCache->{{{0, 575}, {354.938, 0}} -> {-39.4643, 0.945403, \
0.975049, 0.00204154}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Write another version of this forward difference function that returns a \
list of values\nand the \"x\" value for subsequent use in ListPlot, this one \
will take ",
  Cell[BoxData[
      \(TraditionalForm\`x\_o\)]],
  " and y(",
  Cell[BoxData[
      \(TraditionalForm\`x\_o\)]],
  ") as an argument in a list"
}], "Text"],

Cell[BoxData[
    \(Clear[ForwardDifferenceListV2]\)], "Input"],

Cell[BoxData[
    \(ForwardDifferenceListV2[AFunction_\ , x0_\ , \ fx0_\ , \ delta_, \ 
        Xlast_]\  := \[IndentingNewLine]Module[{TheResultList\  = \ {{x0, 
                fx0}}, TheValue = fx0, 
          CurrentX\ \  = \ x0}, \[IndentingNewLine]While[
          CurrentX\  < \ Xlast, \[IndentingNewLine]CurrentX\  = 
            CurrentX\  + \ delta; \[IndentingNewLine]\ 
          TheValue = \ TheValue\  + \ delta\ AFunction[TheValue]; \ 
          AppendTo[
            TheResultList, {CurrentX, 
              TheValue}]]; \[IndentingNewLine]TheResultList]\)], "Input"],

Cell[BoxData[
    \(\(result\  = \ 
        ForwardDifferenceListV2[exampleFunction, 0, 1, \ 0.01, 
          4];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(result // Short\)], "Input"],

Cell[BoxData[
    TagBox[\({{0, 
          1}, \[LeftSkeleton]399\[RightSkeleton], {3.9999999999999587`, 
          1.4915265612574076`}}\),
      Short]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListPlot[result]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.238095 -1.18279 1.1975 [
[.2619 .00222 -7 -20 ]
[.2619 .00222 7 0 ]
[.5 .00222 -7 -20 ]
[.5 .00222 7 0 ]
[.7381 .00222 -7 -20 ]
[.7381 .00222 7 0 ]
[.97619 .00222 -7 -20 ]
[.97619 .00222 7 0 ]
[.01131 .13447 -29 -10 ]
[.01131 .13447 0 10 ]
[.01131 .25422 -29 -10 ]
[.01131 .25422 0 10 ]
[.01131 .37397 -29 -10 ]
[.01131 .37397 0 10 ]
[.01131 .49372 -29 -10 ]
[.01131 .49372 0 10 ]
[.01131 .61347 -29 -10 ]
[.01131 .61347 0 10 ]
[ -0.005 -0.005 0 0 ]
[ 1.005 .62303 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
gsave
.2619 .00222 -68 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.5 .01472 m
.5 .02097 L
s
gsave
.5 .00222 -68 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.7381 .01472 m
.7381 .02097 L
s
gsave
.7381 .00222 -68 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(3) show
1.000 setlinewidth
grestore
.97619 .01472 m
.97619 .02097 L
s
gsave
.97619 .00222 -68 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(4) show
1.000 setlinewidth
grestore
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.01 w
0 .01472 m
1 .01472 L
s
.25 Mabswid
.02381 .13447 m
.03006 .13447 L
s
gsave
.01131 .13447 -90 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1.1) show
1.000 setlinewidth
grestore
.02381 .25422 m
.03006 .25422 L
s
gsave
.01131 .25422 -90 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1.2) show
1.000 setlinewidth
grestore
.02381 .37397 m
.03006 .37397 L
s
gsave
.01131 .37397 -90 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1.3) show
1.000 setlinewidth
grestore
.02381 .49372 m
.03006 .49372 L
s
gsave
.01131 .49372 -90 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1.4) show
1.000 setlinewidth
grestore
.02381 .61347 m
.03006 .61347 L
s
gsave
.01131 .61347 -90 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1.5) show
1.000 setlinewidth
grestore
.125 Mabswid
.02381 .03867 m
.02756 .03867 L
s
.02381 .06262 m
.02756 .06262 L
s
.02381 .08657 m
.02756 .08657 L
s
.02381 .11052 m
.02756 .11052 L
s
.02381 .15842 m
.02756 .15842 L
s
.02381 .18237 m
.02756 .18237 L
s
.02381 .20632 m
.02756 .20632 L
s
.02381 .23027 m
.02756 .23027 L
s
.02381 .27817 m
.02756 .27817 L
s
.02381 .30212 m
.02756 .30212 L
s
.02381 .32607 m
.02756 .32607 L
s
.02381 .35002 m
.02756 .35002 L
s
.02381 .39792 m
.02756 .39792 L
s
.02381 .42187 m
.02756 .42187 L
s
.02381 .44582 m
.02756 .44582 L
s
.02381 .46977 m
.02756 .46977 L
s
.02381 .51767 m
.02756 .51767 L
s
.02381 .54162 m
.02756 .54162 L
s
.02381 .56557 m
.02756 .56557 L
s
.02381 .58952 m
.02756 .58952 L
s
.01 w
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02381 .01472 Mdot
.02619 .01591 Mdot
.02857 .01711 Mdot
.03095 .01831 Mdot
.03333 .01951 Mdot
.03571 .02071 Mdot
.0381 .02192 Mdot
.04048 .02312 Mdot
.04286 .02433 Mdot
.04524 .02554 Mdot
.04762 .02674 Mdot
.05 .02795 Mdot
.05238 .02916 Mdot
.05476 .03038 Mdot
.05714 .03159 Mdot
.05952 .0328 Mdot
.0619 .03402 Mdot
.06429 .03524 Mdot
.06667 .03645 Mdot
.06905 .03767 Mdot
.07143 .03889 Mdot
.07381 .04012 Mdot
.07619 .04134 Mdot
.07857 .04256 Mdot
.08095 .04379 Mdot
.08333 .04501 Mdot
.08571 .04624 Mdot
.0881 .04747 Mdot
.09048 .0487 Mdot
.09286 .04993 Mdot
.09524 .05117 Mdot
.09762 .0524 Mdot
.1 .05364 Mdot
.10238 .05487 Mdot
.10476 .05611 Mdot
.10714 .05735 Mdot
.10952 .05859 Mdot
.1119 .05983 Mdot
.11429 .06107 Mdot
.11667 .06232 Mdot
.11905 .06356 Mdot
.12143 .06481 Mdot
.12381 .06606 Mdot
.12619 .0673 Mdot
.12857 .06855 Mdot
.13095 .06981 Mdot
.13333 .07106 Mdot
.13571 .07231 Mdot
.1381 .07357 Mdot
.14048 .07482 Mdot
.14286 .07608 Mdot
.14524 .07734 Mdot
.14762 .0786 Mdot
.15 .07986 Mdot
.15238 .08112 Mdot
.15476 .08239 Mdot
.15714 .08365 Mdot
.15952 .08492 Mdot
.1619 .08619 Mdot
.16429 .08746 Mdot
.16667 .08873 Mdot
.16905 .09 Mdot
.17143 .09127 Mdot
.17381 .09254 Mdot
.17619 .09382 Mdot
.17857 .0951 Mdot
.18095 .09637 Mdot
.18333 .09765 Mdot
.18571 .09893 Mdot
.1881 .10022 Mdot
.19048 .1015 Mdot
.19286 .10278 Mdot
.19524 .10407 Mdot
.19762 .10536 Mdot
.2 .10664 Mdot
.20238 .10793 Mdot
.20476 .10922 Mdot
.20714 .11052 Mdot
.20952 .11181 Mdot
.2119 .1131 Mdot
.21429 .1144 Mdot
.21667 .1157 Mdot
.21905 .117 Mdot
.22143 .1183 Mdot
.22381 .1196 Mdot
.22619 .1209 Mdot
.22857 .1222 Mdot
.23095 .12351 Mdot
.23333 .12481 Mdot
.23571 .12612 Mdot
.2381 .12743 Mdot
.24048 .12874 Mdot
.24286 .13005 Mdot
.24524 .13136 Mdot
.24762 .13268 Mdot
.25 .13399 Mdot
.25238 .13531 Mdot
.25476 .13663 Mdot
.25714 .13795 Mdot
.25952 .13927 Mdot
.2619 .14059 Mdot
.26429 .14191 Mdot
.26667 .14324 Mdot
.26905 .14457 Mdot
.27143 .14589 Mdot
.27381 .14722 Mdot
.27619 .14855 Mdot
.27857 .14988 Mdot
.28095 .15122 Mdot
.28333 .15255 Mdot
.28571 .15388 Mdot
.2881 .15522 Mdot
.29048 .15656 Mdot
.29286 .1579 Mdot
.29524 .15924 Mdot
.29762 .16058 Mdot
.3 .16192 Mdot
.30238 .16327 Mdot
.30476 .16462 Mdot
.30714 .16596 Mdot
.30952 .16731 Mdot
.3119 .16866 Mdot
.31429 .17001 Mdot
.31667 .17137 Mdot
.31905 .17272 Mdot
.32143 .17408 Mdot
.32381 .17543 Mdot
.32619 .17679 Mdot
.32857 .17815 Mdot
.33095 .17951 Mdot
.33333 .18087 Mdot
.33571 .18224 Mdot
.3381 .1836 Mdot
.34048 .18497 Mdot
.34286 .18634 Mdot
.34524 .18771 Mdot
.34762 .18908 Mdot
.35 .19045 Mdot
.35238 .19182 Mdot
.35476 .1932 Mdot
.35714 .19457 Mdot
.35952 .19595 Mdot
.3619 .19733 Mdot
.36429 .19871 Mdot
.36667 .20009 Mdot
.36905 .20147 Mdot
.37143 .20286 Mdot
.37381 .20424 Mdot
.37619 .20563 Mdot
.37857 .20702 Mdot
.38095 .20841 Mdot
.38333 .2098 Mdot
.38571 .21119 Mdot
.3881 .21259 Mdot
.39048 .21398 Mdot
.39286 .21538 Mdot
.39524 .21678 Mdot
.39762 .21818 Mdot
.4 .21958 Mdot
.40238 .22098 Mdot
.40476 .22238 Mdot
.40714 .22379 Mdot
.40952 .22519 Mdot
.4119 .2266 Mdot
.41429 .22801 Mdot
.41667 .22942 Mdot
.41905 .23083 Mdot
.42143 .23225 Mdot
.42381 .23366 Mdot
.42619 .23508 Mdot
.42857 .2365 Mdot
.43095 .23792 Mdot
.43333 .23934 Mdot
.43571 .24076 Mdot
.4381 .24218 Mdot
.44048 .24361 Mdot
.44286 .24503 Mdot
.44524 .24646 Mdot
.44762 .24789 Mdot
.45 .24932 Mdot
.45238 .25075 Mdot
.45476 .25219 Mdot
.45714 .25362 Mdot
.45952 .25506 Mdot
.4619 .2565 Mdot
.46429 .25794 Mdot
.46667 .25938 Mdot
.46905 .26082 Mdot
.47143 .26226 Mdot
.47381 .26371 Mdot
.47619 .26515 Mdot
.47857 .2666 Mdot
.48095 .26805 Mdot
.48333 .2695 Mdot
.48571 .27095 Mdot
.4881 .27241 Mdot
.49048 .27386 Mdot
.49286 .27532 Mdot
.49524 .27678 Mdot
.49762 .27824 Mdot
.5 .2797 Mdot
.50238 .28116 Mdot
.50476 .28263 Mdot
.50714 .28409 Mdot
.50952 .28556 Mdot
.5119 .28703 Mdot
.51429 .2885 Mdot
.51667 .28997 Mdot
.51905 .29144 Mdot
.52143 .29291 Mdot
.52381 .29439 Mdot
.52619 .29587 Mdot
.52857 .29735 Mdot
.53095 .29883 Mdot
.53333 .30031 Mdot
.53571 .30179 Mdot
.5381 .30328 Mdot
.54048 .30476 Mdot
.54286 .30625 Mdot
.54524 .30774 Mdot
.54762 .30923 Mdot
.55 .31072 Mdot
.55238 .31221 Mdot
.55476 .31371 Mdot
.55714 .31521 Mdot
.55952 .3167 Mdot
.5619 .3182 Mdot
.56429 .3197 Mdot
.56667 .32121 Mdot
.56905 .32271 Mdot
.57143 .32422 Mdot
.57381 .32572 Mdot
.57619 .32723 Mdot
.57857 .32874 Mdot
.58095 .33025 Mdot
.58333 .33177 Mdot
.58571 .33328 Mdot
.5881 .3348 Mdot
.59048 .33631 Mdot
.59286 .33783 Mdot
.59524 .33935 Mdot
.59762 .34088 Mdot
.6 .3424 Mdot
.60238 .34392 Mdot
.60476 .34545 Mdot
.60714 .34698 Mdot
.60952 .34851 Mdot
.6119 .35004 Mdot
.61429 .35157 Mdot
.61667 .35311 Mdot
.61905 .35464 Mdot
.62143 .35618 Mdot
.62381 .35772 Mdot
.62619 .35926 Mdot
.62857 .3608 Mdot
.63095 .36235 Mdot
.63333 .36389 Mdot
.63571 .36544 Mdot
.6381 .36699 Mdot
.64048 .36854 Mdot
.64286 .37009 Mdot
.64524 .37164 Mdot
.64762 .37319 Mdot
.65 .37475 Mdot
.65238 .37631 Mdot
.65476 .37787 Mdot
.65714 .37943 Mdot
.65952 .38099 Mdot
.6619 .38255 Mdot
.66429 .38412 Mdot
.66667 .38569 Mdot
.66905 .38725 Mdot
.67143 .38882 Mdot
.67381 .3904 Mdot
.67619 .39197 Mdot
.67857 .39354 Mdot
.68095 .39512 Mdot
.68333 .3967 Mdot
.68571 .39828 Mdot
.6881 .39986 Mdot
.69048 .40144 Mdot
.69286 .40303 Mdot
.69524 .40461 Mdot
.69762 .4062 Mdot
.7 .40779 Mdot
.70238 .40938 Mdot
.70476 .41097 Mdot
.70714 .41256 Mdot
.70952 .41416 Mdot
.7119 .41576 Mdot
.71429 .41736 Mdot
.71667 .41896 Mdot
.71905 .42056 Mdot
.72143 .42216 Mdot
.72381 .42377 Mdot
.72619 .42537 Mdot
.72857 .42698 Mdot
.73095 .42859 Mdot
.73333 .4302 Mdot
.73571 .43181 Mdot
.7381 .43343 Mdot
.74048 .43505 Mdot
.74286 .43666 Mdot
.74524 .43828 Mdot
.74762 .4399 Mdot
.75 .44153 Mdot
.75238 .44315 Mdot
.75476 .44478 Mdot
.75714 .4464 Mdot
.75952 .44803 Mdot
.7619 .44966 Mdot
.76429 .4513 Mdot
.76667 .45293 Mdot
.76905 .45457 Mdot
.77143 .4562 Mdot
.77381 .45784 Mdot
.77619 .45948 Mdot
.77857 .46113 Mdot
.78095 .46277 Mdot
.78333 .46442 Mdot
.78571 .46606 Mdot
.7881 .46771 Mdot
.79048 .46936 Mdot
.79286 .47101 Mdot
.79524 .47267 Mdot
.79762 .47432 Mdot
.8 .47598 Mdot
.80238 .47764 Mdot
.80476 .4793 Mdot
.80714 .48096 Mdot
.80952 .48263 Mdot
.8119 .48429 Mdot
.81429 .48596 Mdot
.81667 .48763 Mdot
.81905 .4893 Mdot
.82143 .49097 Mdot
.82381 .49264 Mdot
.82619 .49432 Mdot
.82857 .496 Mdot
.83095 .49767 Mdot
.83333 .49935 Mdot
.83571 .50104 Mdot
.8381 .50272 Mdot
.84048 .50441 Mdot
.84286 .50609 Mdot
.84524 .50778 Mdot
.84762 .50947 Mdot
.85 .51117 Mdot
.85238 .51286 Mdot
.85476 .51455 Mdot
.85714 .51625 Mdot
.85952 .51795 Mdot
.8619 .51965 Mdot
.86429 .52135 Mdot
.86667 .52306 Mdot
.86905 .52476 Mdot
.87143 .52647 Mdot
.87381 .52818 Mdot
.87619 .52989 Mdot
.87857 .5316 Mdot
.88095 .53332 Mdot
.88333 .53504 Mdot
.88571 .53675 Mdot
.8881 .53847 Mdot
.89048 .54019 Mdot
.89286 .54192 Mdot
.89524 .54364 Mdot
.89762 .54537 Mdot
.9 .5471 Mdot
.90238 .54883 Mdot
.90476 .55056 Mdot
.90714 .55229 Mdot
.90952 .55403 Mdot
.9119 .55576 Mdot
.91429 .5575 Mdot
.91667 .55924 Mdot
.91905 .56098 Mdot
.92143 .56273 Mdot
.92381 .56447 Mdot
.92619 .56622 Mdot
.92857 .56797 Mdot
.93095 .56972 Mdot
.93333 .57147 Mdot
.93571 .57323 Mdot
.9381 .57498 Mdot
.94048 .57674 Mdot
.94286 .5785 Mdot
.94524 .58026 Mdot
.94762 .58202 Mdot
.95 .58379 Mdot
.95238 .58556 Mdot
.95476 .58732 Mdot
.95714 .58909 Mdot
.95952 .59087 Mdot
.9619 .59264 Mdot
.96429 .59442 Mdot
.96667 .59619 Mdot
.96905 .59797 Mdot
.97143 .59975 Mdot
.97381 .60153 Mdot
.97619 .60332 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 355.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900001Hb000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00Z_oonfX3o`00OgOooo]Z2Ol007mhoook
JPGo001oO?oonfX3o`00OaOooo]Z002ZoookJP?o001oMooonfX9o`00OgOooo]Z1ol007mkoookJP?o
001o5ooonfX00:[ooo]Z0ol007mgoookJPCo001oNooonfX3o`00O`?ooo]Z0ol007mjoookJP?o001o
5ooonfX00:[ooo]Z0ol007mhoookJPCo001oN_oonfX3o`00O`?ooo]Z0ol007meoookJPWo001o5_oo
nfX00:[ooo]Z0ol007mioookJPGo001oO_oonfX3o`00OgGooo]Z2Ol007lFoookJP00Z_oonfX3o`00
Og_ooo]Z1?l007mmoookJP?o001oMOoonfX2o`00O`?ooo]Z0ol007lGoookJP00Z_oonfX3o`00Ogco
oo]Z0ol007mkoookJPCo001oMooonfX2o`00O`;ooo]Z0ol007lGoookJP00Z_oonfX3o`00Oggooo]Z
0ol007mjoookJP?o001oN?oonfX3o`00O`04oookJ_l007oo001oo`00OaOooo]Z002ZoookJP?o001o
MooonfX3o`00O`?ooo]Z0ol007mloookJP;o001oN?oonfX2o`00O`04oookJ_l007oo001oo`00OaOo
oo]Z002WoookJPKo001oMooonfX3o`00O`?ooo]Z0ol007mfoookJP?o001o0ooonfX3o`00OgSooo]Z
1Ol007lGoookJP00:_oonfX5o`0007Sooo]Z1_l007mgoookJPCo001o0_oonfX3o`00OgKooo]Z0ol0
07l3oookJP?o001oN?oonfX5o`00OaOooo]Z000ZoookJPGo0000N_oonfX4o`00OgSooo]Z1ol007mh
oookJPOo001oN_oonfX4o`00OaOooo]Z000ZoookJPGo0000NooonfX3o`00OgWooo]Z1Ol007mjoook
JPGo001oO?oonfX3o`00OaOooo]Z000ZoookJPGo0000oooonf[ooookJQ?ooo]Z000ZoookJPGo0000
oooonf[ooookJQ?ooo]Z000ZoookJPGo0000oooonf[ooookJQ?ooo]Z000ZoookJPGo0000oooonf[o
oookJQ?ooo]Z000ZoookJPGo0000oooonf[ooookJQ?ooo]Z000MoookJ_oo0000ool0000Ko`0000[o
oo]Z000MoookJ_oo0000ool0000Ko`0000[ooo]Z000MoookJ_oo0000ool0000Ko`0000[ooo]Z000M
oookJ_oo0000ool0000Ko`0000[ooo]Z000MoookJ_oo0000ool0000Ko`0000[ooo]Z000ZoookJPco
0000MOoonfX00ol0003ooo]ZoookJP1koookJP03o`000?oonf[ooo]Z07cooo]Z00?o0000oookJ_oo
nfX0NooonfX00ol0003ooo]ZoookJP0GoookJP00:_oonfX>o`0007?ooo]Z00?o0000oookJ_oonfX0
NooonfX00ol0003ooo]ZoookJP1loookJP03o`000?oonf[ooo]Z07_ooo]Z00?o0000oookJ_oonfX0
5ooonfX002[ooo]Z1Ol00003oookJPSo0000oooonf[ooookJPSooo]Z000ZoookJPGo00001?oonfX8
o`000?oooo]ZoooonfX7oookJP00:_oonfX5o`0000Oooo]Z2?l0003ooookJ_oooo]Z1?oonfX002[o
oo]Z1Ol00008oookJPWo0000oooonf[ooookJP;ooo]Z000ZoookJPGo00002_oonfX9o`000?oooo]Z
oooonfX002[ooo]Z1Ol0000<oookJPWo0000oooonf[moookJP00:_oonfX5o`0000kooo]Z2?l0003o
oookJ_cooo]Z000ZoookJPGo00004OoonfX8o`000?oooo]ZnOoonfX002[ooo]Z1Ol0000BoookJPSo
0000oooonf[hoookJP00:_oonfX5o`0001Cooo]Z2Ol0003ooookJ_Gooo]Z000ZoookJPGo00005_oo
nfX8o`000?oooo]Zm?oonfX002[ooo]Z1Ol0000HoookJPWo0000oooonf[aoookJP00:_oonfX5o`00
01[ooo]Z2?l0003ooookJ_3ooo]Z000ZoookJPGo00007?oonfX8o`000?oooo]Zk_oonfX002[ooo]Z
1Ol0000MoookJPWo0000oooonf[/oookJP00:_oonfX5o`00023ooo]Z2?l0003ooookJ^[ooo]Z000Z
oookJPGo00008OoonfX:o`000?oooo]ZiooonfX002[ooo]Z1Ol0000ToookJPSo0000oooonf[Voook
JP00:_oonfX5o`0002Gooo]Z2_l0003ooookJ^?ooo]Z000ZoookJPGo00009ooonfX9o`000?oooo]Z
h_oonfX002[ooo]Z1Ol0000ZoookJPSo0000oooonf[PoookJP00:_oonfX5o`0002_ooo]Z2Ol0003o
oookJ]kooo]Z000ZoookJPGo0000;_oonfX8o`000?oooo]Zg?oonfX002[ooo]Z1Ol0000_oookJPSo
0000oooonf[KoookJP00:_oonfX5o`0003;ooo]Z2?l0003ooookJ]Sooo]Z000ZoookJPGo0000<ooo
nfX8o`000?oooo]ZeooonfX002[ooo]Z1Ol0000eoookJPWo0000oooonf[DoookJP00:_oonfX5o`00
03Oooo]Z2?l0003ooookJ]?ooo]Z000ZoookJPGo0000>OoonfX8o`000?oooo]ZdOoonfX002[ooo]Z
1Ol0000joookJPWo0000oooonf[?oookJP00:_oonfX5o`0003gooo]Z2?l0003ooookJ/gooo]Z000Z
oookJPGo0000?_oonfX9o`000?oooo]ZbooonfX002[ooo]Z1Ol00011oookJPSo0000oooonf[9oook
JP00:_oonfX5o`0004;ooo]Z2?l0003ooookJ/Sooo]Z000ZoookJPGo0000AOoonfX7o`000?oooo]Z
a_oonfX002[ooo]Z1Ol00016oookJPSo0000oooonf[4oookJP00:_oonfX5o`0004Sooo]Z1ol0003o
oookJ/?ooo]Z000ZoookJPGo0000B_oonfX8o`000?oooo]Z`?oonfX002[ooo]Z1Ol0001;oookJPSo
0000oooonfZooookJP00:_oonfX5o`0004gooo]Z2Ol0003ooookJ[cooo]Z000ZoookJPGo0000Cooo
nfX8o`000?oooo]Z^ooonfX002[ooo]Z1Ol0001AoookJPWo0000oooonfZhoookJP00:_oonfX5o`00
05;ooo]Z2Ol0003ooookJ[Oooo]Z000ZoookJPGo0000EOoonfX8o`000?oooo]Z]OoonfX002[ooo]Z
1Ol0001FoookJPWo0000oooonfZcoookJP00:_oonfX5o`0005Wooo]Z2?l0003ooookJ[7ooo]Z000Z
oookJPGo0000F_oonfX8o`000?oooo]Z/?oonfX002[ooo]Z1Ol0001MoookJPOo0000oooonfZ^oook
JP00:_oonfX5o`0005kooo]Z2?l0003ooookJZcooo]Z000ZoookJPGo0000H?oonfX7o`000?oooo]Z
ZooonfX002[ooo]Z1Ol0001RoookJPSo0000oooonfZXoookJP00:_oonfX5o`0006?ooo]Z2?l0003o
oookJZOooo]Z000ZoookJPGo0000IOoonfX9o`000?oooo]ZY?oonfX002[ooo]Z1Ol0001WoookJPSo
0000oooonfZSoookJP00:_oonfX5o`0006Wooo]Z2Ol0003ooookJZ3ooo]Z000>oookJP?o001o1?oo
nfX3o`00O`Gooo]Z0ol007l:oookJPGo0000JooonfX8o`000?oooo]ZWooonfX000kooo]Z0ol007l4
oookJP?o001o1OoonfX3o`00O`[ooo]Z1Ol0001]oookJPOo0000oooonfZNoookJP003_oonfX3o`00
O`Cooo]Z0ol007l5oookJP?o001o2_oonfX5o`0006kooo]Z2Ol0003ooookJY_ooo]Z000>oookJP?o
001o3?oonfX3o`00O`[ooo]Z1Ol0001aoookJPOo0000oooonfZJoookJP003_oonfX3o`00O`cooo]Z
0ol007l:oookJPKo0000LOoonfX8o`000?oooo]ZV?oonfX000kooo]Z0ol007l<oookJP?o001o2_oo
nfX5o`0007?ooo]Z2Ol0003ooookJYKooo]Z000>oookJP?o001o3?oonfX3o`00O`[ooo]Z1Ol0001f
oookJPSo0000oooonfZDoookJP003_oonfX3o`00O`cooo]Z0ol007l:oookJPGo0000MooonfX9o`00
0?oooo]ZT_oonfX000kooo]Z0ol007l<oookJP?o001o2_oonfX5o`0007[ooo]Z1ol0003ooookJY7o
oo]Z000;oookJPKo001o2OoonfX6o`00O`[ooo]Z1Ol0001koookJPSo0000oooonfZ?oookJP002ooo
nfX6o`00O`Wooo]Z1_l007l:oookJPGo0000O_oonfX7o`000?oooo]ZSOoonfX000gooo]Z1?l007l;
oookJPCo001o2_oonfX5o`0007oooo]Z2?l0003ooookJX_ooo]Z000>oookJP?o001o3?oonfX3o`00
O`[ooo]Z1Ol00020oookJPSo0000oooonfZ:oookJP00:_oonfX5o`0008?ooo]Z1ol0003ooookJXSo
oo]Z000ZoookJPGo0000Q?oonfX8o`000?oooo]ZQ_oonfX002[ooo]Z1Ol00026oookJPOo0000oooo
nfZ5oookJP00:_oonfX5o`0008Sooo]Z2?l0003ooookJX;ooo]Z000ZoookJPGo0000ROoonfX8o`00
0?oooo]ZPOoonfX002[ooo]Z1Ol0002;oookJPOo0000oooonfZ0oookJP00:_oonfX5o`0008gooo]Z
2?l0003ooookJWgooo]Z000ZoookJPGo0000SooonfX7o`000?oooo]ZO?oonfX002[ooo]Z1Ol0002@
oookJPWo0000oooonfYioookJP00:_oonfX5o`0009;ooo]Z2?l0003ooookJWSooo]Z000ZoookJPGo
0000U?oonfX7o`000?oooo]ZMooonfX002[ooo]Z1Ol0002FoookJPSo0000oooonfYdoookJP00:_oo
nfX5o`0009Sooo]Z1ol0003ooookJW?ooo]Z000ZoookJPGo0000VOoonfX9o`000?oooo]ZL?oonfX0
02[ooo]Z1Ol0002KoookJPSo0000oooonfY_oookJP00:_oonfX5o`0009gooo]Z1ol0003ooookJVko
oo]Z000ZoookJPGo0000W_oonfX9o`000?oooo]ZJooonfX002[ooo]Z1Ol0002QoookJPOo0000oooo
nfYZoookJP00:_oonfX5o`000:;ooo]Z1ol0003ooookJVWooo]Z000ZoookJPGo0000XooonfX9o`00
0?oooo]ZI_oonfX002[ooo]Z1Ol0002VoookJPOo0000oooonfYUoookJP00:_oonfX5o`000:Oooo]Z
2Ol0003ooookJV;ooo]Z000ZoookJPGo0000ZOoonfX8o`000?oooo]ZHOoonfX002[ooo]Z1Ol0002[
oookJPOo0000oooonfYPoookJP00:_oonfX5o`000:cooo]Z2Ol0003ooookJUgooo]Z000ZoookJPGo
0000[ooonfX7o`000?oooo]ZG?oonfX002[ooo]Z1Ol0002`oookJPOo0000oooonfYKoookJP00:_oo
nfX5o`000;7ooo]Z2Ol0003ooookJUSooo]Z000ZoookJPGo0000]?oonfX7o`000?oooo]ZEooonfX0
02[ooo]Z1Ol0002eoookJPOo0000oooonfYFoookJP00:_oonfX5o`000;Kooo]Z2Ol0003ooookJU?o
oo]Z000ZoookJPGo0000^OoonfX7o`000?oooo]ZD_oonfX002[ooo]Z1Ol0002joookJPOo0000oooo
nfYAoookJP00:_oonfX5o`000;cooo]Z2?l0003ooookJTkooo]Z000ZoookJPGo0000__oonfX7o`00
0?oooo]ZCOoonfX002[ooo]Z1Ol0002ooookJPWo0000oooonfY:oookJP00:_oonfX5o`000<7ooo]Z
2?l0003ooookJTWooo]Z000ZoookJPGo0000`ooonfX7o`000?oooo]ZB?oonfX002[ooo]Z1Ol00034
oookJPWo0000oooonfY5oookJP00:_oonfX5o`000<Oooo]Z1ol0003ooookJTCooo]Z000ZoookJPGo
0000b?oonfX7o`000?oooo]Z@ooonfX002[ooo]Z1Ol00039oookJPWo0000oooonfY0oookJP00:_oo
nfX5o`000<cooo]Z1ol0003ooookJSoooo]Z000ZoookJPGo0000cOoonfX7o`000?oooo]Z?_oonfX0
02[ooo]Z1Ol0003?oookJPSo0000oooonfXkoookJP00:_oonfX5o`000=7ooo]Z1ol0003ooookJS[o
oo]Z000ZoookJPGo0000d_oonfX7o`000?oooo]Z>OoonfX002[ooo]Z1Ol0003DoookJPOo0000oooo
nfXgoookJP00:_oonfX5o`000=Kooo]Z1ol0003ooookJSGooo]Z000ZoookJPGo0000eooonfX7o`00
0?oooo]Z=?oonfX002[ooo]Z1Ol0003IoookJPOo0000oooonfXboookJP003_oonfX3o`00O`Cooo]Z
0ol007l00ooonf[o001oo`00O`07o`00O`Sooo]Z1Ol0003JoookJPSo0000oooonfX`oookJP003_oo
nfX3o`00O`Cooo]Z0ol007l00ooonf[o001oo`00O`07o`00O`Sooo]Z1Ol0003LoookJPOo0000oooo
nfX_oookJP003_oonfX3o`00O`Cooo]Z0ol007l00ooonf[o001oo`00O`02o`00O`gooo]Z1Ol0003N
oookJPOo0000oooonfX]oookJP003_oonfX3o`00O`Wooo]Z1?l007l<oookJPGo0000gooonfX8o`00
0?oooo]Z:ooonfX000kooo]Z0ol007l:oookJPGo001o2_oonfX6o`000>3ooo]Z2?l0003ooookJRWo
oo]Z000>oookJP?o001o3?oonfX4o`00O`Wooo]Z1Ol0003SoookJPOo0000oooonfXXoookJP003_oo
nfX3o`00O`gooo]Z0ol007l9oookJPGo0000i?oonfX8o`000?oooo]Z9_oonfX000kooo]Z0ol007l>
oookJP?o001o2?oonfX5o`000>Oooo]Z1ol0003ooookJRCooo]Z000>oookJP?o001o2?oonfX3o`00
O`?ooo]Z0ol007l8oookJPGo0000j?oonfX7o`000?oooo]Z8ooonfX000_ooo]Z1_l007l8oookJP?o
001o0ooonfX3o`00O`Sooo]Z1Ol0003YoookJPSo0000oooonfXQoookJP002ooonfX6o`00O`Sooo]Z
1?l007l2oookJP?o001o2?oonfX5o`000>cooo]Z1ol0003ooookJQoooo]Z000=oookJPCo001o2Ooo
nfX7o`00O`Wooo]Z1Ol0003]oookJPOo0000oooonfXNoookJP003_oonfX3o`00O`[ooo]Z1Ol007l:
oookJPGo0000k_oonfX7o`000?oooo]Z7OoonfX002[ooo]Z1Ol0003aoookJPOo0000oooonfXJoook
JP00:_oonfX5o`000?;ooo]Z1ol0003ooookJQWooo]Z000ZoookJPGo0000looonfX7o`000?oooo]Z
6?oonfX002[ooo]Z1Ol0003doookJPWo0000oooonfXEoookJP00:_oonfX5o`000?Oooo]Z1ol0003o
oookJQCooo]Z000ZoookJPGo0000n?oonfX7o`000?oooo]Z4ooonfX002[ooo]Z1Ol0003joookJPOo
0000oooonfXAoookJP00:_oonfX5o`000?cooo]Z1ol0003ooookJPoooo]Z000ZoookJPGo0000oOoo
nfX7o`000?oooo]Z3_oonfX002[ooo]Z1Ol0003ooookJPOo0000oooonfX<oookJP00:_oonfX5o`00
0?oooo]Z0OoonfX7o`000?oooo]Z2ooonfX002[ooo]Z1Ol0003ooookJP?ooo]Z1ol0003ooookJPWo
oo]Z000ZoookJPGo0000oooonfX5oookJPOo0000oooonfX7oookJP00:_oonfX5o`000?oooo]Z1_oo
nfX7o`000?oooo]Z1_oonfX002[ooo]Z1Ol0003ooookJPOooo]Z2Ol0003ooookJP?ooo]Z000Zoook
JPGo0000oooonfX:oookJPOo0000oooonfX2oookJP00:_oonfX5o`000?oooo]Z2ooonfX7o`000?oo
oo]Z0OoonfX002[ooo]Z1Ol0003ooookJPcooo]Z1ol0003ooookJP00:_oonfX5o`000?oooo]Z3ooo
nfX7o`000?cooo]Z000ZoookJPGo0000oooonfX@oookJPOo0000nooonfX002[ooo]Z1Ol0003ooook
JQ7ooo]Z1ol0003joookJP00:_oonfX5o`000?oooo]Z4ooonfX7o`000?Sooo]Z000ZoookJPGo0000
oooonfXEoookJPOo0000m_oonfX002[ooo]Z1Ol0003ooookJQKooo]Z1ol0003eoookJP00:_oonfX5
o`000?oooo]Z6?oonfX7o`000??ooo]Z000ZoookJPGo0000oooonfXIoookJPOo0000l_oonfX002[o
oo]Z1Ol0003ooookJQ_ooo]Z2?l0003_oookJP00:_oonfX5o`000?oooo]Z7OoonfX7o`000>kooo]Z
000ZoookJPGo0000oooonfXNoookJPOo0000kOoonfX002[ooo]Z1Ol0003ooookJQoooo]Z1ol0003/
oookJP00:_oonfX5o`000?oooo]Z8_oonfX7o`000>Wooo]Z000ZoookJPGo0000oooonfXSoookJPOo
0000j?oonfX002[ooo]Z1Ol0003ooookJRCooo]Z1ol0003WoookJP00:_oonfX5o`000?oooo]Z9_oo
nfX7o`000>Gooo]Z000ZoookJPGo0000oooonfXXoookJPOo0000hooonfX002[ooo]Z1Ol0003ooook
JRWooo]Z1ol0003RoookJP00:_oonfX5o`000?oooo]Z:ooonfX7o`000>3ooo]Z000ZoookJPGo0000
oooonfX/oookJPOo0000gooonfX002[ooo]Z1Ol0003ooookJRkooo]Z1ol0003MoookJP00:_oonfX5
o`000?oooo]Z<?oonfX7o`000=_ooo]Z000ZoookJPGo0000oooonfXaoookJPOo0000f_oonfX002[o
oo]Z1Ol0003ooookJS;ooo]Z1ol0003IoookJP00:_oonfX5o`000?oooo]Z=OoonfX6o`000=Oooo]Z
000ZoookJPGo0000oooonfXfoookJPOo0000eOoonfX002[ooo]Z1Ol0003ooookJSOooo]Z1ol0003D
oookJP00:_oonfX5o`000?oooo]Z>OoonfX7o`000=;ooo]Z000ZoookJPGo0000oooonfXjoookJPOo
0000dOoonfX002[ooo]Z1Ol0003ooookJScooo]Z1ol0003?oookJP00:_oonfX5o`000?oooo]Z?_oo
nfX7o`000<gooo]Z000ZoookJPGo0000oooonfXooookJPOo0000c?oonfX000kooo]Z0ol007l4oook
JP?o001o0ooonfX5o`00O`[ooo]Z1Ol0003ooookJT3ooo]Z1ol0003;oookJP003_oonfX3o`00O`Co
oo]Z0ol007l2oookJPOo001o2OoonfX5o`000?oooo]Z@ooonfX5o`000<[ooo]Z000>oookJP?o001o
1?oonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l8oookJPGo0000oooonfY4oookJPOo
0000aooonfX000kooo]Z0ol007l8oookJP?o001o0ooonfX3o`00O`Sooo]Z1Ol0003ooookJTGooo]Z
1ol00036oookJP003_oonfX3o`00O`kooo]Z0ol007l8oookJPKo0000oooonfY5oookJPSo0000a?oo
nfX000kooo]Z0ol007l>oookJP?o001o2?oonfX5o`000?oooo]ZB?oonfX7o`000<?ooo]Z000>oook
JP?o001o3?oonfX4o`00O`Wooo]Z1Ol0003ooookJT[ooo]Z1_l00032oookJP003_oonfX3o`00O`co
oo]Z0ol007l:oookJPGo0000oooonfY<oookJPOo0000_ooonfX000kooo]Z0ol007l>oookJP;o001o
2OoonfX5o`000?oooo]ZCOoonfX7o`000;kooo]Z000;oookJPKo001o2?oonfX3o`00O`?ooo]Z0ol0
07l8oookJPGo0000oooonfY>oookJPOo0000_OoonfX000_ooo]Z1_l007l8oookJP?o001o0ooonfX3
o`00O`Sooo]Z1Ol0003ooookJToooo]Z1ol0002loookJP003OoonfX4o`00O`Wooo]Z1ol007l9oook
JPGo0000oooonfYBoookJPKo0000^_oonfX000kooo]Z0ol007l:oookJPGo001o2_oonfX5o`000?oo
oo]ZDooonfX7o`000;Sooo]Z000ZoookJPGo0000oooonfYDoookJPOo0000]ooonfX002[ooo]Z1Ol0
003ooookJUKooo]Z1ol0002eoookJP00:_oonfX5o`000?oooo]ZEooonfX7o`000;Cooo]Z000Zoook
JPGo0000oooonfYIoookJPKo0000/ooonfX002[ooo]Z1Ol0003ooookJU_ooo]Z1ol0002`oookJP00
:_oonfX5o`000?oooo]ZG?oonfX7o`000:oooo]Z000ZoookJPGo0000oooonfYMoookJPOo0000[_oo
nfX002[ooo]Z1Ol0003ooookJUoooo]Z1ol0002/oookJP00:_oonfX5o`000?oooo]ZHOoonfX6o`00
0:_ooo]Z000ZoookJPGo0000oooonfYRoookJPOo0000ZOoonfX002[ooo]Z1Ol0003ooookJVCooo]Z
1ol0002WoookJP00:_oonfX5o`000?oooo]ZIOoonfX7o`000:Kooo]Z000ZoookJPGo0000oooonfYV
oookJPOo0000YOoonfX002[ooo]Z1Ol0003ooookJVWooo]Z1Ol0002ToookJP00:_oonfX5o`000?oo
oo]ZJ_oonfX6o`000:;ooo]Z000ZoookJPGo0000oooonfY[oookJPOo0000X?oonfX002[ooo]Z1Ol0
003ooookJVcooo]Z2?l0002NoookJP00:_oonfX5o`000?oooo]ZK_oonfX7o`0009gooo]Z000Zoook
JPGo0000oooonfY_oookJPOo0000W?oonfX002[ooo]Z1Ol0003ooookJW;ooo]Z1Ol0002KoookJP00
:_oonfX5o`000?oooo]ZLooonfX6o`0009Wooo]Z000ZoookJPGo0000oooonfYdoookJPOo0000Uooo
nfX002[ooo]Z1Ol0003ooookJWGooo]Z1ol0002FoookJP00:_oonfX5o`000?oooo]ZMooonfX7o`00
09Cooo]Z000ZoookJPGo0000oooonfYhoookJPOo0000TooonfX002[ooo]Z1Ol0003ooookJW[ooo]Z
1_l0002BoookJP00:_oonfX5o`000?oooo]ZO?oonfX5o`00097ooo]Z000ZoookJPGo0000oooonfYm
oookJPOo0000S_oonfX002[ooo]Z1Ol0003ooookJWkooo]Z1ol0002=oookJP00:_oonfX5o`000?oo
oo]ZOooonfX8o`0008_ooo]Z000ZoookJPGo0000oooonfZ1oookJPOo0000R_oonfX002[ooo]Z1Ol0
003ooookJX?ooo]Z1_l00029oookJP00:_oonfX5o`000?oooo]ZQOoonfX5o`0008Sooo]Z000Zoook
JPGo0000oooonfZ6oookJPKo0000Q_oonfX002[ooo]Z1Ol0003ooookJXOooo]Z1ol00024oookJP00
:_oonfX5o`000?oooo]ZR?oonfX7o`0008?ooo]Z000ZoookJPGo0000oooonfZ:oookJPOo0000POoo
nfX002[ooo]Z1Ol0003ooookJX_ooo]Z1ol00020oookJP00:_oonfX5o`000?oooo]ZSOoonfX6o`00
07oooo]Z000ZoookJPGo0000oooonfZ?oookJPGo0000O_oonfX002[ooo]Z1Ol0003ooookJY3ooo]Z
1_l0001loookJP00:_oonfX5o`000?oooo]ZTOoonfX7o`0007[ooo]Z000ZoookJPGo0000oooonfZB
oookJPOo0000NOoonfX002[ooo]Z1Ol0003ooookJYCooo]Z1ol0001goookJP00:_oonfX5o`000?oo
oo]ZUOoonfX7o`0007Kooo]Z000ZoookJPGo0000oooonfZGoookJPKo0000MOoonfX002[ooo]Z1Ol0
003ooookJYWooo]Z1_l0001coookJP00:_oonfX5o`000?oooo]ZV_oonfX6o`0007;ooo]Z000Zoook
JPGo0000oooonfZKoookJPOo0000L?oonfX002[ooo]Z1Ol0003ooookJYgooo]Z1ol0001^oookJP00
:_oonfX5o`000?oooo]ZW_oonfX7o`0006gooo]Z000>oookJP?o001o1?oonfX3o`00O`Kooo]Z0ol0
07l9oookJPGo0000oooonfZOoookJPOo0000K?oonfX000kooo]Z0ol007l4oookJP?o001o1_oonfX3
o`00O`Wooo]Z1Ol0003ooookJZ;ooo]Z1Ol0001[oookJP003_oonfX3o`00O`Cooo]Z0ol007l6oook
JP?o001o2OoonfX5o`000?oooo]ZXooonfX6o`0006Wooo]Z000>oookJP?o001o2?oonfX9o`00O`So
oo]Z1Ol0003ooookJZCooo]Z1_l0001XoookJP003_oonfX3o`00O`Sooo]Z2Ol007l8oookJPKo0000
oooonfZToookJPKo0000IooonfX000kooo]Z0ol007l8oookJP;o001o0ooonfX3o`00O`Wooo]Z1Ol0
003ooookJZOooo]Z1ol0001ToookJP003_oonfX3o`00O`Wooo]Z0_l007l2oookJP?o001o2OoonfX5
o`000?oooo]ZZ?oonfX7o`0006?ooo]Z000>oookJP?o001o2OoonfX3o`00O`04oookJ_l007oo001o
o`00O`Wooo]Z1Ol0003ooookJZWooo]Z1ol0001RoookJP003_oonfX3o`00O`[ooo]Z0_l007l01?oo
nf[o001oo`00Ool007l9oookJPGo0000oooonfZZoookJPSo0000H?oonfX000_ooo]Z1_l007l;oook
JPGo001o2OoonfX5o`000?oooo]Z[OoonfX6o`0005oooo]Z000;oookJPKo001o2ooonfX5o`00O`Wo
oo]Z1Ol0003ooookJZkooo]Z1_l0001NoookJP003OoonfX4o`00O`cooo]Z1?l007l9oookJPGo0000
oooonfZ`oookJPGo0000GOoonfX000kooo]Z0ol007l=oookJP?o001o2OoonfX5o`000?oooo]Z/Ooo
nfX6o`0005_ooo]Z000ZoookJPGo0000oooonfZboookJPKo0000F_oonfX002[ooo]Z1Ol0003ooook
J[?ooo]Z1ol0001HoookJP00:_oonfX5o`000?oooo]Z]OoonfX7o`0005Kooo]Z000ZoookJPGo0000
oooonfZfoookJPOo0000EOoonfX002[ooo]Z1Ol0003ooookJ[Oooo]Z1ol0001DoookJP00:_oonfX5
o`000?oooo]Z^_oonfX5o`0005?ooo]Z000ZoookJPGo0000oooonfZkoookJPKo0000DOoonfX002[o
oo]Z1Ol0003ooookJ[cooo]Z1_l0001@oookJP00:_oonfX5o`000?oooo]Z_OoonfX6o`0004oooo]Z
000ZoookJPGo0000oooonfZooookJPKo0000COoonfX002[ooo]Z1Ol0003ooookJ/3ooo]Z1_l0001<
oookJP00:_oonfX5o`000?oooo]Z`OoonfX7o`0004[ooo]Z000ZoookJPGo0000oooonf[3oookJPOo
0000B?oonfX002[ooo]Z1Ol0003ooookJ/Cooo]Z1ol00017oookJP00:_oonfX5o`000?oooo]ZaOoo
nfX7o`0004Kooo]Z000ZoookJPGo0000oooonf[8oookJPGo0000AOoonfX002[ooo]Z1Ol0003ooook
J/Wooo]Z1_l00013oookJP00:_oonfX5o`000?oooo]Zb_oonfX6o`0004;ooo]Z000ZoookJPGo0000
oooonf[;oookJPKo0000@OoonfX002[ooo]Z1Ol0003ooookJ/gooo]Z1Ol00010oookJP00:_oonfX5
o`000?oooo]Zc_oonfX6o`0003kooo]Z000ZoookJPGo0000oooonf[?oookJPKo0000?OoonfX002[o
oo]Z1Ol0003ooookJ]3ooo]Z2?l0000joookJP00:_oonfX5o`000?oooo]Zd_oonfX7o`0003Wooo]Z
000ZoookJPGo0000oooonf[CoookJPOo0000>?oonfX002[ooo]Z1Ol0003ooookJ]Cooo]Z1ol0000g
oookJP00:_oonfX5o`000?oooo]ZeooonfX6o`0003Gooo]Z000ZoookJPGo0000oooonf[HoookJPKo
0000=?oonfX002[ooo]Z1Ol0003ooookJ]Wooo]Z1_l0000coookJP00:_oonfX5o`000?oooo]Zfooo
nfX5o`0003;ooo]Z000ZoookJPGo0000oooonf[LoookJPKo0000<?oonfX002[ooo]Z1Ol0003ooook
J]gooo]Z1_l0000_oookJP00:_oonfX5o`000?oooo]Zg_oonfX6o`0002kooo]Z000ZoookJPGo0000
oooonf[PoookJPGo0000;OoonfX002[ooo]Z1Ol0003ooookJ^7ooo]Z1_l0000[oookJP00:_oonfX5
o`000?oooo]Zh_oonfX7o`0002Wooo]Z000ZoookJPGo0000oooonf[SoookJPOo0000:?oonfX002[o
oo]Z1Ol0003ooookJ^Gooo]Z1ol0000VoookJP00:_oonfX5o`000?oooo]Zi_oonfX7o`0002Gooo]Z
000ZoookJPGo0000oooonf[XoookJPKo00009?oonfX002[ooo]Z1Ol0003ooookJ^[ooo]Z1_l0000R
oookJP00:_oonfX5o`000?oooo]ZjooonfX6o`00027ooo]Z000ZoookJPGo0000oooonf[/oookJPKo
00008?oonfX002[ooo]Z1Ol0003ooookJ^kooo]Z1Ol0000OoookJP00:_oonfX5o`000?oooo]Zkooo
nfX6o`0001gooo]Z000ZoookJPGo0000oooonf[`oookJPKo00007?oonfX002[ooo]Z1Ol0003ooook
J_7ooo]Z1_l0000KoookJP00:_oonfX5o`000?oooo]ZlooonfX5o`0001[ooo]Z000ZoookJPGo0000
oooonf[doookJPKo00006?oonfX002[ooo]Z1Ol0003ooookJ_Gooo]Z1_l0000GoookJP003_oonfX3
o`00O`Cooo]Z0ol007l3oookJPGo001o2_oonfX5o`000?oooo]Zm_oonfX5o`0001Oooo]Z000>oook
JP?o001o1?oonfX3o`00O`;ooo]Z1ol007l9oookJPGo0000oooonf[hoookJP;o00006?oonfX000ko
oo]Z0ol007l4oookJP?o001o00?ooo]Zo`00Ool007l00_l007l01?oonf[o001oo`00Ool007l9oook
JPGo0000oooonf[ooookJQ?ooo]Z000>oookJP?o001o2?oonfX3o`00O`?ooo]Z0ol007l8oookJPGo
0000oooonf[ooookJQ?ooo]Z000>oookJP?o001o3_oonfX3o`00O`Sooo]Z1_l0003ooookJ_oooo]Z
4_oonfX000kooo]Z0ol007l>oookJP?o001o2?oonfX5o`000?oooo]ZoooonfXCoookJP003_oonfX3
o`00O`Wooo]Z0_l007l2oookJPCo001o2?oonfX5o`000?oooo]ZoooonfXCoookJP003_oonfX3o`00
O`Wooo]Z1ol007l9oookJPGo0000oooonf[ooookJQ?ooo]Z000>oookJP?o001o2OoonfX6o`00O`[o
oo]Z1Ol0003ooookJ_oooo]Z4ooonfX000_ooo]Z1_l007l9oookJP;o001o3_oonfX5o`000?oooo]Z
oooonfXCoookJP002ooonfX6o`00O`Wooo]Z0_l007oooookJ_oooo]Z9_oonfX000gooo]Z1?l007l:
oookJPOo001ooooonf[ooookJR3ooo]Z000>oookJP?o001o2_oonfX7o`00Oooooo]ZoooonfXPoook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00001\
\>"],
  ImageRangeCache->{{{0, 575}, {354.938, 0}} -> {-0.3518, 0.958149, \
0.00790084, 0.0015709}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell["Background-Repeated Operations on a Function", "Subtitle"],

Cell[TextData[{
  "Because each iteration is the same, the iteration can be considered a \
functional operation, for the case considered above,\n{",
  Cell[BoxData[
      \(TraditionalForm\`x\_\(i + 1\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y\_\(i + 1\)\)]],
  "} = {",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  "+ \[Delta], ",
  Cell[BoxData[
      \(TraditionalForm\`y\_i\)]],
  "+ \[Delta] f(",
  Cell[BoxData[
      \(TraditionalForm\`y\_i\)]],
  ")}.  Therefore a \"Incrementing Operator\" can be obtained that updates \
the values:"
}], "Text",
  CellTags->"mmtag:19:increment_operator"],

Cell[BoxData[
    \(StepOnce[{x_, y_}, \ AFunction_, \ delta_]\  := \ {x + \ delta, \ 
        y\  + \ delta\ AFunction[y]}\)], "Input"],

Cell[TextData[{
  "Then, the trajectory should be obtained from:\n    \
{{xo,yo},StepOnce[{xo,yo}], StepOnce[StepOnce[{xo,yo}]], \[TripleDot]\
\[TripleDot]\[TripleDot]}\n    This is what the built-in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  StyleBox["NestList",
    FontWeight->"Bold"],
  "[function, initialvalue,depth] does:"
}], "Text"],

Cell[BoxData[
    \(OurStepOnce[{x_\ , \ y_}]\  := \ 
      StepOnce[{x, y}, exampleFunction, \ 0.01]\)], "Input"],

Cell[BoxData[
    \(\(result\  = \ NestList[OurStepOnce, {0, 1}, 400];\)\)], "Input",
  CellTags->"mmtag:19:NestList[]"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListPlot[result]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.238095 -1.18279 1.1975 [
[.2619 .00222 -7 -20 ]
[.2619 .00222 7 0 ]
[.5 .00222 -7 -20 ]
[.5 .00222 7 0 ]
[.7381 .00222 -7 -20 ]
[.7381 .00222 7 0 ]
[.97619 .00222 -7 -20 ]
[.97619 .00222 7 0 ]
[.01131 .13447 -29 -10 ]
[.01131 .13447 0 10 ]
[.01131 .25422 -29 -10 ]
[.01131 .25422 0 10 ]
[.01131 .37397 -29 -10 ]
[.01131 .37397 0 10 ]
[.01131 .49372 -29 -10 ]
[.01131 .49372 0 10 ]
[.01131 .61347 -29 -10 ]
[.01131 .61347 0 10 ]
[ -0.005 -0.005 0 0 ]
[ 1.005 .62303 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
gsave
.2619 .00222 -68 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.5 .01472 m
.5 .02097 L
s
gsave
.5 .00222 -68 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.7381 .01472 m
.7381 .02097 L
s
gsave
.7381 .00222 -68 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(3) show
1.000 setlinewidth
grestore
.97619 .01472 m
.97619 .02097 L
s
gsave
.97619 .00222 -68 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(4) show
1.000 setlinewidth
grestore
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.01 w
0 .01472 m
1 .01472 L
s
.25 Mabswid
.02381 .13447 m
.03006 .13447 L
s
gsave
.01131 .13447 -90 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1.1) show
1.000 setlinewidth
grestore
.02381 .25422 m
.03006 .25422 L
s
gsave
.01131 .25422 -90 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1.2) show
1.000 setlinewidth
grestore
.02381 .37397 m
.03006 .37397 L
s
gsave
.01131 .37397 -90 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1.3) show
1.000 setlinewidth
grestore
.02381 .49372 m
.03006 .49372 L
s
gsave
.01131 .49372 -90 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1.4) show
1.000 setlinewidth
grestore
.02381 .61347 m
.03006 .61347 L
s
gsave
.01131 .61347 -90 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1.5) show
1.000 setlinewidth
grestore
.125 Mabswid
.02381 .03867 m
.02756 .03867 L
s
.02381 .06262 m
.02756 .06262 L
s
.02381 .08657 m
.02756 .08657 L
s
.02381 .11052 m
.02756 .11052 L
s
.02381 .15842 m
.02756 .15842 L
s
.02381 .18237 m
.02756 .18237 L
s
.02381 .20632 m
.02756 .20632 L
s
.02381 .23027 m
.02756 .23027 L
s
.02381 .27817 m
.02756 .27817 L
s
.02381 .30212 m
.02756 .30212 L
s
.02381 .32607 m
.02756 .32607 L
s
.02381 .35002 m
.02756 .35002 L
s
.02381 .39792 m
.02756 .39792 L
s
.02381 .42187 m
.02756 .42187 L
s
.02381 .44582 m
.02756 .44582 L
s
.02381 .46977 m
.02756 .46977 L
s
.02381 .51767 m
.02756 .51767 L
s
.02381 .54162 m
.02756 .54162 L
s
.02381 .56557 m
.02756 .56557 L
s
.02381 .58952 m
.02756 .58952 L
s
.01 w
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02381 .01472 Mdot
.02619 .01591 Mdot
.02857 .01711 Mdot
.03095 .01831 Mdot
.03333 .01951 Mdot
.03571 .02071 Mdot
.0381 .02192 Mdot
.04048 .02312 Mdot
.04286 .02433 Mdot
.04524 .02554 Mdot
.04762 .02674 Mdot
.05 .02795 Mdot
.05238 .02916 Mdot
.05476 .03038 Mdot
.05714 .03159 Mdot
.05952 .0328 Mdot
.0619 .03402 Mdot
.06429 .03524 Mdot
.06667 .03645 Mdot
.06905 .03767 Mdot
.07143 .03889 Mdot
.07381 .04012 Mdot
.07619 .04134 Mdot
.07857 .04256 Mdot
.08095 .04379 Mdot
.08333 .04501 Mdot
.08571 .04624 Mdot
.0881 .04747 Mdot
.09048 .0487 Mdot
.09286 .04993 Mdot
.09524 .05117 Mdot
.09762 .0524 Mdot
.1 .05364 Mdot
.10238 .05487 Mdot
.10476 .05611 Mdot
.10714 .05735 Mdot
.10952 .05859 Mdot
.1119 .05983 Mdot
.11429 .06107 Mdot
.11667 .06232 Mdot
.11905 .06356 Mdot
.12143 .06481 Mdot
.12381 .06606 Mdot
.12619 .0673 Mdot
.12857 .06855 Mdot
.13095 .06981 Mdot
.13333 .07106 Mdot
.13571 .07231 Mdot
.1381 .07357 Mdot
.14048 .07482 Mdot
.14286 .07608 Mdot
.14524 .07734 Mdot
.14762 .0786 Mdot
.15 .07986 Mdot
.15238 .08112 Mdot
.15476 .08239 Mdot
.15714 .08365 Mdot
.15952 .08492 Mdot
.1619 .08619 Mdot
.16429 .08746 Mdot
.16667 .08873 Mdot
.16905 .09 Mdot
.17143 .09127 Mdot
.17381 .09254 Mdot
.17619 .09382 Mdot
.17857 .0951 Mdot
.18095 .09637 Mdot
.18333 .09765 Mdot
.18571 .09893 Mdot
.1881 .10022 Mdot
.19048 .1015 Mdot
.19286 .10278 Mdot
.19524 .10407 Mdot
.19762 .10536 Mdot
.2 .10664 Mdot
.20238 .10793 Mdot
.20476 .10922 Mdot
.20714 .11052 Mdot
.20952 .11181 Mdot
.2119 .1131 Mdot
.21429 .1144 Mdot
.21667 .1157 Mdot
.21905 .117 Mdot
.22143 .1183 Mdot
.22381 .1196 Mdot
.22619 .1209 Mdot
.22857 .1222 Mdot
.23095 .12351 Mdot
.23333 .12481 Mdot
.23571 .12612 Mdot
.2381 .12743 Mdot
.24048 .12874 Mdot
.24286 .13005 Mdot
.24524 .13136 Mdot
.24762 .13268 Mdot
.25 .13399 Mdot
.25238 .13531 Mdot
.25476 .13663 Mdot
.25714 .13795 Mdot
.25952 .13927 Mdot
.2619 .14059 Mdot
.26429 .14191 Mdot
.26667 .14324 Mdot
.26905 .14457 Mdot
.27143 .14589 Mdot
.27381 .14722 Mdot
.27619 .14855 Mdot
.27857 .14988 Mdot
.28095 .15122 Mdot
.28333 .15255 Mdot
.28571 .15388 Mdot
.2881 .15522 Mdot
.29048 .15656 Mdot
.29286 .1579 Mdot
.29524 .15924 Mdot
.29762 .16058 Mdot
.3 .16192 Mdot
.30238 .16327 Mdot
.30476 .16462 Mdot
.30714 .16596 Mdot
.30952 .16731 Mdot
.3119 .16866 Mdot
.31429 .17001 Mdot
.31667 .17137 Mdot
.31905 .17272 Mdot
.32143 .17408 Mdot
.32381 .17543 Mdot
.32619 .17679 Mdot
.32857 .17815 Mdot
.33095 .17951 Mdot
.33333 .18087 Mdot
.33571 .18224 Mdot
.3381 .1836 Mdot
.34048 .18497 Mdot
.34286 .18634 Mdot
.34524 .18771 Mdot
.34762 .18908 Mdot
.35 .19045 Mdot
.35238 .19182 Mdot
.35476 .1932 Mdot
.35714 .19457 Mdot
.35952 .19595 Mdot
.3619 .19733 Mdot
.36429 .19871 Mdot
.36667 .20009 Mdot
.36905 .20147 Mdot
.37143 .20286 Mdot
.37381 .20424 Mdot
.37619 .20563 Mdot
.37857 .20702 Mdot
.38095 .20841 Mdot
.38333 .2098 Mdot
.38571 .21119 Mdot
.3881 .21259 Mdot
.39048 .21398 Mdot
.39286 .21538 Mdot
.39524 .21678 Mdot
.39762 .21818 Mdot
.4 .21958 Mdot
.40238 .22098 Mdot
.40476 .22238 Mdot
.40714 .22379 Mdot
.40952 .22519 Mdot
.4119 .2266 Mdot
.41429 .22801 Mdot
.41667 .22942 Mdot
.41905 .23083 Mdot
.42143 .23225 Mdot
.42381 .23366 Mdot
.42619 .23508 Mdot
.42857 .2365 Mdot
.43095 .23792 Mdot
.43333 .23934 Mdot
.43571 .24076 Mdot
.4381 .24218 Mdot
.44048 .24361 Mdot
.44286 .24503 Mdot
.44524 .24646 Mdot
.44762 .24789 Mdot
.45 .24932 Mdot
.45238 .25075 Mdot
.45476 .25219 Mdot
.45714 .25362 Mdot
.45952 .25506 Mdot
.4619 .2565 Mdot
.46429 .25794 Mdot
.46667 .25938 Mdot
.46905 .26082 Mdot
.47143 .26226 Mdot
.47381 .26371 Mdot
.47619 .26515 Mdot
.47857 .2666 Mdot
.48095 .26805 Mdot
.48333 .2695 Mdot
.48571 .27095 Mdot
.4881 .27241 Mdot
.49048 .27386 Mdot
.49286 .27532 Mdot
.49524 .27678 Mdot
.49762 .27824 Mdot
.5 .2797 Mdot
.50238 .28116 Mdot
.50476 .28263 Mdot
.50714 .28409 Mdot
.50952 .28556 Mdot
.5119 .28703 Mdot
.51429 .2885 Mdot
.51667 .28997 Mdot
.51905 .29144 Mdot
.52143 .29291 Mdot
.52381 .29439 Mdot
.52619 .29587 Mdot
.52857 .29735 Mdot
.53095 .29883 Mdot
.53333 .30031 Mdot
.53571 .30179 Mdot
.5381 .30328 Mdot
.54048 .30476 Mdot
.54286 .30625 Mdot
.54524 .30774 Mdot
.54762 .30923 Mdot
.55 .31072 Mdot
.55238 .31221 Mdot
.55476 .31371 Mdot
.55714 .31521 Mdot
.55952 .3167 Mdot
.5619 .3182 Mdot
.56429 .3197 Mdot
.56667 .32121 Mdot
.56905 .32271 Mdot
.57143 .32422 Mdot
.57381 .32572 Mdot
.57619 .32723 Mdot
.57857 .32874 Mdot
.58095 .33025 Mdot
.58333 .33177 Mdot
.58571 .33328 Mdot
.5881 .3348 Mdot
.59048 .33631 Mdot
.59286 .33783 Mdot
.59524 .33935 Mdot
.59762 .34088 Mdot
.6 .3424 Mdot
.60238 .34392 Mdot
.60476 .34545 Mdot
.60714 .34698 Mdot
.60952 .34851 Mdot
.6119 .35004 Mdot
.61429 .35157 Mdot
.61667 .35311 Mdot
.61905 .35464 Mdot
.62143 .35618 Mdot
.62381 .35772 Mdot
.62619 .35926 Mdot
.62857 .3608 Mdot
.63095 .36235 Mdot
.63333 .36389 Mdot
.63571 .36544 Mdot
.6381 .36699 Mdot
.64048 .36854 Mdot
.64286 .37009 Mdot
.64524 .37164 Mdot
.64762 .37319 Mdot
.65 .37475 Mdot
.65238 .37631 Mdot
.65476 .37787 Mdot
.65714 .37943 Mdot
.65952 .38099 Mdot
.6619 .38255 Mdot
.66429 .38412 Mdot
.66667 .38569 Mdot
.66905 .38725 Mdot
.67143 .38882 Mdot
.67381 .3904 Mdot
.67619 .39197 Mdot
.67857 .39354 Mdot
.68095 .39512 Mdot
.68333 .3967 Mdot
.68571 .39828 Mdot
.6881 .39986 Mdot
.69048 .40144 Mdot
.69286 .40303 Mdot
.69524 .40461 Mdot
.69762 .4062 Mdot
.7 .40779 Mdot
.70238 .40938 Mdot
.70476 .41097 Mdot
.70714 .41256 Mdot
.70952 .41416 Mdot
.7119 .41576 Mdot
.71429 .41736 Mdot
.71667 .41896 Mdot
.71905 .42056 Mdot
.72143 .42216 Mdot
.72381 .42377 Mdot
.72619 .42537 Mdot
.72857 .42698 Mdot
.73095 .42859 Mdot
.73333 .4302 Mdot
.73571 .43181 Mdot
.7381 .43343 Mdot
.74048 .43505 Mdot
.74286 .43666 Mdot
.74524 .43828 Mdot
.74762 .4399 Mdot
.75 .44153 Mdot
.75238 .44315 Mdot
.75476 .44478 Mdot
.75714 .4464 Mdot
.75952 .44803 Mdot
.7619 .44966 Mdot
.76429 .4513 Mdot
.76667 .45293 Mdot
.76905 .45457 Mdot
.77143 .4562 Mdot
.77381 .45784 Mdot
.77619 .45948 Mdot
.77857 .46113 Mdot
.78095 .46277 Mdot
.78333 .46442 Mdot
.78571 .46606 Mdot
.7881 .46771 Mdot
.79048 .46936 Mdot
.79286 .47101 Mdot
.79524 .47267 Mdot
.79762 .47432 Mdot
.8 .47598 Mdot
.80238 .47764 Mdot
.80476 .4793 Mdot
.80714 .48096 Mdot
.80952 .48263 Mdot
.8119 .48429 Mdot
.81429 .48596 Mdot
.81667 .48763 Mdot
.81905 .4893 Mdot
.82143 .49097 Mdot
.82381 .49264 Mdot
.82619 .49432 Mdot
.82857 .496 Mdot
.83095 .49767 Mdot
.83333 .49935 Mdot
.83571 .50104 Mdot
.8381 .50272 Mdot
.84048 .50441 Mdot
.84286 .50609 Mdot
.84524 .50778 Mdot
.84762 .50947 Mdot
.85 .51117 Mdot
.85238 .51286 Mdot
.85476 .51455 Mdot
.85714 .51625 Mdot
.85952 .51795 Mdot
.8619 .51965 Mdot
.86429 .52135 Mdot
.86667 .52306 Mdot
.86905 .52476 Mdot
.87143 .52647 Mdot
.87381 .52818 Mdot
.87619 .52989 Mdot
.87857 .5316 Mdot
.88095 .53332 Mdot
.88333 .53504 Mdot
.88571 .53675 Mdot
.8881 .53847 Mdot
.89048 .54019 Mdot
.89286 .54192 Mdot
.89524 .54364 Mdot
.89762 .54537 Mdot
.9 .5471 Mdot
.90238 .54883 Mdot
.90476 .55056 Mdot
.90714 .55229 Mdot
.90952 .55403 Mdot
.9119 .55576 Mdot
.91429 .5575 Mdot
.91667 .55924 Mdot
.91905 .56098 Mdot
.92143 .56273 Mdot
.92381 .56447 Mdot
.92619 .56622 Mdot
.92857 .56797 Mdot
.93095 .56972 Mdot
.93333 .57147 Mdot
.93571 .57323 Mdot
.9381 .57498 Mdot
.94048 .57674 Mdot
.94286 .5785 Mdot
.94524 .58026 Mdot
.94762 .58202 Mdot
.95 .58379 Mdot
.95238 .58556 Mdot
.95476 .58732 Mdot
.95714 .58909 Mdot
.95952 .59087 Mdot
.9619 .59264 Mdot
.96429 .59442 Mdot
.96667 .59619 Mdot
.96905 .59797 Mdot
.97143 .59975 Mdot
.97381 .60153 Mdot
.97619 .60332 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 355.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900001Hb000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00Z_oonfX3o`00OgOooo]Z2Ol007mhoook
JPGo001oO?oonfX3o`00OaOooo]Z002ZoookJP?o001oMooonfX9o`00OgOooo]Z1ol007mkoookJP?o
001o5ooonfX00:[ooo]Z0ol007mgoookJPCo001oNooonfX3o`00O`?ooo]Z0ol007mjoookJP?o001o
5ooonfX00:[ooo]Z0ol007mhoookJPCo001oN_oonfX3o`00O`?ooo]Z0ol007meoookJPWo001o5_oo
nfX00:[ooo]Z0ol007mioookJPGo001oO_oonfX3o`00OgGooo]Z2Ol007lFoookJP00Z_oonfX3o`00
Og_ooo]Z1?l007mmoookJP?o001oMOoonfX2o`00O`?ooo]Z0ol007lGoookJP00Z_oonfX3o`00Ogco
oo]Z0ol007mkoookJPCo001oMooonfX2o`00O`;ooo]Z0ol007lGoookJP00Z_oonfX3o`00Oggooo]Z
0ol007mjoookJP?o001oN?oonfX3o`00O`04oookJ_l007oo001oo`00OaOooo]Z002ZoookJP?o001o
MooonfX3o`00O`?ooo]Z0ol007mloookJP;o001oN?oonfX2o`00O`04oookJ_l007oo001oo`00OaOo
oo]Z002WoookJPKo001oMooonfX3o`00O`?ooo]Z0ol007mfoookJP?o001o0ooonfX3o`00OgSooo]Z
1Ol007lGoookJP00:_oonfX5o`0007Sooo]Z1_l007mgoookJPCo001o0_oonfX3o`00OgKooo]Z0ol0
07l3oookJP?o001oN?oonfX5o`00OaOooo]Z000ZoookJPGo0000N_oonfX4o`00OgSooo]Z1ol007mh
oookJPOo001oN_oonfX4o`00OaOooo]Z000ZoookJPGo0000NooonfX3o`00OgWooo]Z1Ol007mjoook
JPGo001oO?oonfX3o`00OaOooo]Z000ZoookJPGo0000oooonf[ooookJQ?ooo]Z000ZoookJPGo0000
oooonf[ooookJQ?ooo]Z000ZoookJPGo0000oooonf[ooookJQ?ooo]Z000ZoookJPGo0000oooonf[o
oookJQ?ooo]Z000ZoookJPGo0000oooonf[ooookJQ?ooo]Z000MoookJ_oo0000ool0000Ko`0000[o
oo]Z000MoookJ_oo0000ool0000Ko`0000[ooo]Z000MoookJ_oo0000ool0000Ko`0000[ooo]Z000M
oookJ_oo0000ool0000Ko`0000[ooo]Z000MoookJ_oo0000ool0000Ko`0000[ooo]Z000ZoookJPco
0000MOoonfX00ol0003ooo]ZoookJP1koookJP03o`000?oonf[ooo]Z07cooo]Z00?o0000oookJ_oo
nfX0NooonfX00ol0003ooo]ZoookJP0GoookJP00:_oonfX>o`0007?ooo]Z00?o0000oookJ_oonfX0
NooonfX00ol0003ooo]ZoookJP1loookJP03o`000?oonf[ooo]Z07_ooo]Z00?o0000oookJ_oonfX0
5ooonfX002[ooo]Z1Ol00003oookJPSo0000oooonf[ooookJPSooo]Z000ZoookJPGo00001?oonfX8
o`000?oooo]ZoooonfX7oookJP00:_oonfX5o`0000Oooo]Z2?l0003ooookJ_oooo]Z1?oonfX002[o
oo]Z1Ol00008oookJPWo0000oooonf[ooookJP;ooo]Z000ZoookJPGo00002_oonfX9o`000?oooo]Z
oooonfX002[ooo]Z1Ol0000<oookJPWo0000oooonf[moookJP00:_oonfX5o`0000kooo]Z2?l0003o
oookJ_cooo]Z000ZoookJPGo00004OoonfX8o`000?oooo]ZnOoonfX002[ooo]Z1Ol0000BoookJPSo
0000oooonf[hoookJP00:_oonfX5o`0001Cooo]Z2Ol0003ooookJ_Gooo]Z000ZoookJPGo00005_oo
nfX8o`000?oooo]Zm?oonfX002[ooo]Z1Ol0000HoookJPWo0000oooonf[aoookJP00:_oonfX5o`00
01[ooo]Z2?l0003ooookJ_3ooo]Z000ZoookJPGo00007?oonfX8o`000?oooo]Zk_oonfX002[ooo]Z
1Ol0000MoookJPWo0000oooonf[/oookJP00:_oonfX5o`00023ooo]Z2?l0003ooookJ^[ooo]Z000Z
oookJPGo00008OoonfX:o`000?oooo]ZiooonfX002[ooo]Z1Ol0000ToookJPSo0000oooonf[Voook
JP00:_oonfX5o`0002Gooo]Z2_l0003ooookJ^?ooo]Z000ZoookJPGo00009ooonfX9o`000?oooo]Z
h_oonfX002[ooo]Z1Ol0000ZoookJPSo0000oooonf[PoookJP00:_oonfX5o`0002_ooo]Z2Ol0003o
oookJ]kooo]Z000ZoookJPGo0000;_oonfX8o`000?oooo]Zg?oonfX002[ooo]Z1Ol0000_oookJPSo
0000oooonf[KoookJP00:_oonfX5o`0003;ooo]Z2?l0003ooookJ]Sooo]Z000ZoookJPGo0000<ooo
nfX8o`000?oooo]ZeooonfX002[ooo]Z1Ol0000eoookJPWo0000oooonf[DoookJP00:_oonfX5o`00
03Oooo]Z2?l0003ooookJ]?ooo]Z000ZoookJPGo0000>OoonfX8o`000?oooo]ZdOoonfX002[ooo]Z
1Ol0000joookJPWo0000oooonf[?oookJP00:_oonfX5o`0003gooo]Z2?l0003ooookJ/gooo]Z000Z
oookJPGo0000?_oonfX9o`000?oooo]ZbooonfX002[ooo]Z1Ol00011oookJPSo0000oooonf[9oook
JP00:_oonfX5o`0004;ooo]Z2?l0003ooookJ/Sooo]Z000ZoookJPGo0000AOoonfX7o`000?oooo]Z
a_oonfX002[ooo]Z1Ol00016oookJPSo0000oooonf[4oookJP00:_oonfX5o`0004Sooo]Z1ol0003o
oookJ/?ooo]Z000ZoookJPGo0000B_oonfX8o`000?oooo]Z`?oonfX002[ooo]Z1Ol0001;oookJPSo
0000oooonfZooookJP00:_oonfX5o`0004gooo]Z2Ol0003ooookJ[cooo]Z000ZoookJPGo0000Cooo
nfX8o`000?oooo]Z^ooonfX002[ooo]Z1Ol0001AoookJPWo0000oooonfZhoookJP00:_oonfX5o`00
05;ooo]Z2Ol0003ooookJ[Oooo]Z000ZoookJPGo0000EOoonfX8o`000?oooo]Z]OoonfX002[ooo]Z
1Ol0001FoookJPWo0000oooonfZcoookJP00:_oonfX5o`0005Wooo]Z2?l0003ooookJ[7ooo]Z000Z
oookJPGo0000F_oonfX8o`000?oooo]Z/?oonfX002[ooo]Z1Ol0001MoookJPOo0000oooonfZ^oook
JP00:_oonfX5o`0005kooo]Z2?l0003ooookJZcooo]Z000ZoookJPGo0000H?oonfX7o`000?oooo]Z
ZooonfX002[ooo]Z1Ol0001RoookJPSo0000oooonfZXoookJP00:_oonfX5o`0006?ooo]Z2?l0003o
oookJZOooo]Z000ZoookJPGo0000IOoonfX9o`000?oooo]ZY?oonfX002[ooo]Z1Ol0001WoookJPSo
0000oooonfZSoookJP00:_oonfX5o`0006Wooo]Z2Ol0003ooookJZ3ooo]Z000>oookJP?o001o1?oo
nfX3o`00O`Gooo]Z0ol007l:oookJPGo0000JooonfX8o`000?oooo]ZWooonfX000kooo]Z0ol007l4
oookJP?o001o1OoonfX3o`00O`[ooo]Z1Ol0001]oookJPOo0000oooonfZNoookJP003_oonfX3o`00
O`Cooo]Z0ol007l5oookJP?o001o2_oonfX5o`0006kooo]Z2Ol0003ooookJY_ooo]Z000>oookJP?o
001o3?oonfX3o`00O`[ooo]Z1Ol0001aoookJPOo0000oooonfZJoookJP003_oonfX3o`00O`cooo]Z
0ol007l:oookJPKo0000LOoonfX8o`000?oooo]ZV?oonfX000kooo]Z0ol007l<oookJP?o001o2_oo
nfX5o`0007?ooo]Z2Ol0003ooookJYKooo]Z000>oookJP?o001o3?oonfX3o`00O`[ooo]Z1Ol0001f
oookJPSo0000oooonfZDoookJP003_oonfX3o`00O`cooo]Z0ol007l:oookJPGo0000MooonfX9o`00
0?oooo]ZT_oonfX000kooo]Z0ol007l<oookJP?o001o2_oonfX5o`0007[ooo]Z1ol0003ooookJY7o
oo]Z000;oookJPKo001o2OoonfX6o`00O`[ooo]Z1Ol0001koookJPSo0000oooonfZ?oookJP002ooo
nfX6o`00O`Wooo]Z1_l007l:oookJPGo0000O_oonfX7o`000?oooo]ZSOoonfX000gooo]Z1?l007l;
oookJPCo001o2_oonfX5o`0007oooo]Z2?l0003ooookJX_ooo]Z000>oookJP?o001o3?oonfX3o`00
O`[ooo]Z1Ol00020oookJPSo0000oooonfZ:oookJP00:_oonfX5o`0008?ooo]Z1ol0003ooookJXSo
oo]Z000ZoookJPGo0000Q?oonfX8o`000?oooo]ZQ_oonfX002[ooo]Z1Ol00026oookJPOo0000oooo
nfZ5oookJP00:_oonfX5o`0008Sooo]Z2?l0003ooookJX;ooo]Z000ZoookJPGo0000ROoonfX8o`00
0?oooo]ZPOoonfX002[ooo]Z1Ol0002;oookJPOo0000oooonfZ0oookJP00:_oonfX5o`0008gooo]Z
2?l0003ooookJWgooo]Z000ZoookJPGo0000SooonfX7o`000?oooo]ZO?oonfX002[ooo]Z1Ol0002@
oookJPWo0000oooonfYioookJP00:_oonfX5o`0009;ooo]Z2?l0003ooookJWSooo]Z000ZoookJPGo
0000U?oonfX7o`000?oooo]ZMooonfX002[ooo]Z1Ol0002FoookJPSo0000oooonfYdoookJP00:_oo
nfX5o`0009Sooo]Z1ol0003ooookJW?ooo]Z000ZoookJPGo0000VOoonfX9o`000?oooo]ZL?oonfX0
02[ooo]Z1Ol0002KoookJPSo0000oooonfY_oookJP00:_oonfX5o`0009gooo]Z1ol0003ooookJVko
oo]Z000ZoookJPGo0000W_oonfX9o`000?oooo]ZJooonfX002[ooo]Z1Ol0002QoookJPOo0000oooo
nfYZoookJP00:_oonfX5o`000:;ooo]Z1ol0003ooookJVWooo]Z000ZoookJPGo0000XooonfX9o`00
0?oooo]ZI_oonfX002[ooo]Z1Ol0002VoookJPOo0000oooonfYUoookJP00:_oonfX5o`000:Oooo]Z
2Ol0003ooookJV;ooo]Z000ZoookJPGo0000ZOoonfX8o`000?oooo]ZHOoonfX002[ooo]Z1Ol0002[
oookJPOo0000oooonfYPoookJP00:_oonfX5o`000:cooo]Z2Ol0003ooookJUgooo]Z000ZoookJPGo
0000[ooonfX7o`000?oooo]ZG?oonfX002[ooo]Z1Ol0002`oookJPOo0000oooonfYKoookJP00:_oo
nfX5o`000;7ooo]Z2Ol0003ooookJUSooo]Z000ZoookJPGo0000]?oonfX7o`000?oooo]ZEooonfX0
02[ooo]Z1Ol0002eoookJPOo0000oooonfYFoookJP00:_oonfX5o`000;Kooo]Z2Ol0003ooookJU?o
oo]Z000ZoookJPGo0000^OoonfX7o`000?oooo]ZD_oonfX002[ooo]Z1Ol0002joookJPOo0000oooo
nfYAoookJP00:_oonfX5o`000;cooo]Z2?l0003ooookJTkooo]Z000ZoookJPGo0000__oonfX7o`00
0?oooo]ZCOoonfX002[ooo]Z1Ol0002ooookJPWo0000oooonfY:oookJP00:_oonfX5o`000<7ooo]Z
2?l0003ooookJTWooo]Z000ZoookJPGo0000`ooonfX7o`000?oooo]ZB?oonfX002[ooo]Z1Ol00034
oookJPWo0000oooonfY5oookJP00:_oonfX5o`000<Oooo]Z1ol0003ooookJTCooo]Z000ZoookJPGo
0000b?oonfX7o`000?oooo]Z@ooonfX002[ooo]Z1Ol00039oookJPWo0000oooonfY0oookJP00:_oo
nfX5o`000<cooo]Z1ol0003ooookJSoooo]Z000ZoookJPGo0000cOoonfX7o`000?oooo]Z?_oonfX0
02[ooo]Z1Ol0003?oookJPSo0000oooonfXkoookJP00:_oonfX5o`000=7ooo]Z1ol0003ooookJS[o
oo]Z000ZoookJPGo0000d_oonfX7o`000?oooo]Z>OoonfX002[ooo]Z1Ol0003DoookJPOo0000oooo
nfXgoookJP00:_oonfX5o`000=Kooo]Z1ol0003ooookJSGooo]Z000ZoookJPGo0000eooonfX7o`00
0?oooo]Z=?oonfX002[ooo]Z1Ol0003IoookJPOo0000oooonfXboookJP003_oonfX3o`00O`Cooo]Z
0ol007l00ooonf[o001oo`00O`07o`00O`Sooo]Z1Ol0003JoookJPSo0000oooonfX`oookJP003_oo
nfX3o`00O`Cooo]Z0ol007l00ooonf[o001oo`00O`07o`00O`Sooo]Z1Ol0003LoookJPOo0000oooo
nfX_oookJP003_oonfX3o`00O`Cooo]Z0ol007l00ooonf[o001oo`00O`02o`00O`gooo]Z1Ol0003N
oookJPOo0000oooonfX]oookJP003_oonfX3o`00O`Wooo]Z1?l007l<oookJPGo0000gooonfX8o`00
0?oooo]Z:ooonfX000kooo]Z0ol007l:oookJPGo001o2_oonfX6o`000>3ooo]Z2?l0003ooookJRWo
oo]Z000>oookJP?o001o3?oonfX4o`00O`Wooo]Z1Ol0003SoookJPOo0000oooonfXXoookJP003_oo
nfX3o`00O`gooo]Z0ol007l9oookJPGo0000i?oonfX8o`000?oooo]Z9_oonfX000kooo]Z0ol007l>
oookJP?o001o2?oonfX5o`000>Oooo]Z1ol0003ooookJRCooo]Z000>oookJP?o001o2?oonfX3o`00
O`?ooo]Z0ol007l8oookJPGo0000j?oonfX7o`000?oooo]Z8ooonfX000_ooo]Z1_l007l8oookJP?o
001o0ooonfX3o`00O`Sooo]Z1Ol0003YoookJPSo0000oooonfXQoookJP002ooonfX6o`00O`Sooo]Z
1?l007l2oookJP?o001o2?oonfX5o`000>cooo]Z1ol0003ooookJQoooo]Z000=oookJPCo001o2Ooo
nfX7o`00O`Wooo]Z1Ol0003]oookJPOo0000oooonfXNoookJP003_oonfX3o`00O`[ooo]Z1Ol007l:
oookJPGo0000k_oonfX7o`000?oooo]Z7OoonfX002[ooo]Z1Ol0003aoookJPOo0000oooonfXJoook
JP00:_oonfX5o`000?;ooo]Z1ol0003ooookJQWooo]Z000ZoookJPGo0000looonfX7o`000?oooo]Z
6?oonfX002[ooo]Z1Ol0003doookJPWo0000oooonfXEoookJP00:_oonfX5o`000?Oooo]Z1ol0003o
oookJQCooo]Z000ZoookJPGo0000n?oonfX7o`000?oooo]Z4ooonfX002[ooo]Z1Ol0003joookJPOo
0000oooonfXAoookJP00:_oonfX5o`000?cooo]Z1ol0003ooookJPoooo]Z000ZoookJPGo0000oOoo
nfX7o`000?oooo]Z3_oonfX002[ooo]Z1Ol0003ooookJPOo0000oooonfX<oookJP00:_oonfX5o`00
0?oooo]Z0OoonfX7o`000?oooo]Z2ooonfX002[ooo]Z1Ol0003ooookJP?ooo]Z1ol0003ooookJPWo
oo]Z000ZoookJPGo0000oooonfX5oookJPOo0000oooonfX7oookJP00:_oonfX5o`000?oooo]Z1_oo
nfX7o`000?oooo]Z1_oonfX002[ooo]Z1Ol0003ooookJPOooo]Z2Ol0003ooookJP?ooo]Z000Zoook
JPGo0000oooonfX:oookJPOo0000oooonfX2oookJP00:_oonfX5o`000?oooo]Z2ooonfX7o`000?oo
oo]Z0OoonfX002[ooo]Z1Ol0003ooookJPcooo]Z1ol0003ooookJP00:_oonfX5o`000?oooo]Z3ooo
nfX7o`000?cooo]Z000ZoookJPGo0000oooonfX@oookJPOo0000nooonfX002[ooo]Z1Ol0003ooook
JQ7ooo]Z1ol0003joookJP00:_oonfX5o`000?oooo]Z4ooonfX7o`000?Sooo]Z000ZoookJPGo0000
oooonfXEoookJPOo0000m_oonfX002[ooo]Z1Ol0003ooookJQKooo]Z1ol0003eoookJP00:_oonfX5
o`000?oooo]Z6?oonfX7o`000??ooo]Z000ZoookJPGo0000oooonfXIoookJPOo0000l_oonfX002[o
oo]Z1Ol0003ooookJQ_ooo]Z2?l0003_oookJP00:_oonfX5o`000?oooo]Z7OoonfX7o`000>kooo]Z
000ZoookJPGo0000oooonfXNoookJPOo0000kOoonfX002[ooo]Z1Ol0003ooookJQoooo]Z1ol0003/
oookJP00:_oonfX5o`000?oooo]Z8_oonfX7o`000>Wooo]Z000ZoookJPGo0000oooonfXSoookJPOo
0000j?oonfX002[ooo]Z1Ol0003ooookJRCooo]Z1ol0003WoookJP00:_oonfX5o`000?oooo]Z9_oo
nfX7o`000>Gooo]Z000ZoookJPGo0000oooonfXXoookJPOo0000hooonfX002[ooo]Z1Ol0003ooook
JRWooo]Z1ol0003RoookJP00:_oonfX5o`000?oooo]Z:ooonfX7o`000>3ooo]Z000ZoookJPGo0000
oooonfX/oookJPOo0000gooonfX002[ooo]Z1Ol0003ooookJRkooo]Z1ol0003MoookJP00:_oonfX5
o`000?oooo]Z<?oonfX7o`000=_ooo]Z000ZoookJPGo0000oooonfXaoookJPOo0000f_oonfX002[o
oo]Z1Ol0003ooookJS;ooo]Z1ol0003IoookJP00:_oonfX5o`000?oooo]Z=OoonfX6o`000=Oooo]Z
000ZoookJPGo0000oooonfXfoookJPOo0000eOoonfX002[ooo]Z1Ol0003ooookJSOooo]Z1ol0003D
oookJP00:_oonfX5o`000?oooo]Z>OoonfX7o`000=;ooo]Z000ZoookJPGo0000oooonfXjoookJPOo
0000dOoonfX002[ooo]Z1Ol0003ooookJScooo]Z1ol0003?oookJP00:_oonfX5o`000?oooo]Z?_oo
nfX7o`000<gooo]Z000ZoookJPGo0000oooonfXooookJPOo0000c?oonfX000kooo]Z0ol007l4oook
JP?o001o0ooonfX5o`00O`[ooo]Z1Ol0003ooookJT3ooo]Z1ol0003;oookJP003_oonfX3o`00O`Co
oo]Z0ol007l2oookJPOo001o2OoonfX5o`000?oooo]Z@ooonfX5o`000<[ooo]Z000>oookJP?o001o
1?oonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l8oookJPGo0000oooonfY4oookJPOo
0000aooonfX000kooo]Z0ol007l8oookJP?o001o0ooonfX3o`00O`Sooo]Z1Ol0003ooookJTGooo]Z
1ol00036oookJP003_oonfX3o`00O`kooo]Z0ol007l8oookJPKo0000oooonfY5oookJPSo0000a?oo
nfX000kooo]Z0ol007l>oookJP?o001o2?oonfX5o`000?oooo]ZB?oonfX7o`000<?ooo]Z000>oook
JP?o001o3?oonfX4o`00O`Wooo]Z1Ol0003ooookJT[ooo]Z1_l00032oookJP003_oonfX3o`00O`co
oo]Z0ol007l:oookJPGo0000oooonfY<oookJPOo0000_ooonfX000kooo]Z0ol007l>oookJP;o001o
2OoonfX5o`000?oooo]ZCOoonfX7o`000;kooo]Z000;oookJPKo001o2?oonfX3o`00O`?ooo]Z0ol0
07l8oookJPGo0000oooonfY>oookJPOo0000_OoonfX000_ooo]Z1_l007l8oookJP?o001o0ooonfX3
o`00O`Sooo]Z1Ol0003ooookJToooo]Z1ol0002loookJP003OoonfX4o`00O`Wooo]Z1ol007l9oook
JPGo0000oooonfYBoookJPKo0000^_oonfX000kooo]Z0ol007l:oookJPGo001o2_oonfX5o`000?oo
oo]ZDooonfX7o`000;Sooo]Z000ZoookJPGo0000oooonfYDoookJPOo0000]ooonfX002[ooo]Z1Ol0
003ooookJUKooo]Z1ol0002eoookJP00:_oonfX5o`000?oooo]ZEooonfX7o`000;Cooo]Z000Zoook
JPGo0000oooonfYIoookJPKo0000/ooonfX002[ooo]Z1Ol0003ooookJU_ooo]Z1ol0002`oookJP00
:_oonfX5o`000?oooo]ZG?oonfX7o`000:oooo]Z000ZoookJPGo0000oooonfYMoookJPOo0000[_oo
nfX002[ooo]Z1Ol0003ooookJUoooo]Z1ol0002/oookJP00:_oonfX5o`000?oooo]ZHOoonfX6o`00
0:_ooo]Z000ZoookJPGo0000oooonfYRoookJPOo0000ZOoonfX002[ooo]Z1Ol0003ooookJVCooo]Z
1ol0002WoookJP00:_oonfX5o`000?oooo]ZIOoonfX7o`000:Kooo]Z000ZoookJPGo0000oooonfYV
oookJPOo0000YOoonfX002[ooo]Z1Ol0003ooookJVWooo]Z1Ol0002ToookJP00:_oonfX5o`000?oo
oo]ZJ_oonfX6o`000:;ooo]Z000ZoookJPGo0000oooonfY[oookJPOo0000X?oonfX002[ooo]Z1Ol0
003ooookJVcooo]Z2?l0002NoookJP00:_oonfX5o`000?oooo]ZK_oonfX7o`0009gooo]Z000Zoook
JPGo0000oooonfY_oookJPOo0000W?oonfX002[ooo]Z1Ol0003ooookJW;ooo]Z1Ol0002KoookJP00
:_oonfX5o`000?oooo]ZLooonfX6o`0009Wooo]Z000ZoookJPGo0000oooonfYdoookJPOo0000Uooo
nfX002[ooo]Z1Ol0003ooookJWGooo]Z1ol0002FoookJP00:_oonfX5o`000?oooo]ZMooonfX7o`00
09Cooo]Z000ZoookJPGo0000oooonfYhoookJPOo0000TooonfX002[ooo]Z1Ol0003ooookJW[ooo]Z
1_l0002BoookJP00:_oonfX5o`000?oooo]ZO?oonfX5o`00097ooo]Z000ZoookJPGo0000oooonfYm
oookJPOo0000S_oonfX002[ooo]Z1Ol0003ooookJWkooo]Z1ol0002=oookJP00:_oonfX5o`000?oo
oo]ZOooonfX8o`0008_ooo]Z000ZoookJPGo0000oooonfZ1oookJPOo0000R_oonfX002[ooo]Z1Ol0
003ooookJX?ooo]Z1_l00029oookJP00:_oonfX5o`000?oooo]ZQOoonfX5o`0008Sooo]Z000Zoook
JPGo0000oooonfZ6oookJPKo0000Q_oonfX002[ooo]Z1Ol0003ooookJXOooo]Z1ol00024oookJP00
:_oonfX5o`000?oooo]ZR?oonfX7o`0008?ooo]Z000ZoookJPGo0000oooonfZ:oookJPOo0000POoo
nfX002[ooo]Z1Ol0003ooookJX_ooo]Z1ol00020oookJP00:_oonfX5o`000?oooo]ZSOoonfX6o`00
07oooo]Z000ZoookJPGo0000oooonfZ?oookJPGo0000O_oonfX002[ooo]Z1Ol0003ooookJY3ooo]Z
1_l0001loookJP00:_oonfX5o`000?oooo]ZTOoonfX7o`0007[ooo]Z000ZoookJPGo0000oooonfZB
oookJPOo0000NOoonfX002[ooo]Z1Ol0003ooookJYCooo]Z1ol0001goookJP00:_oonfX5o`000?oo
oo]ZUOoonfX7o`0007Kooo]Z000ZoookJPGo0000oooonfZGoookJPKo0000MOoonfX002[ooo]Z1Ol0
003ooookJYWooo]Z1_l0001coookJP00:_oonfX5o`000?oooo]ZV_oonfX6o`0007;ooo]Z000Zoook
JPGo0000oooonfZKoookJPOo0000L?oonfX002[ooo]Z1Ol0003ooookJYgooo]Z1ol0001^oookJP00
:_oonfX5o`000?oooo]ZW_oonfX7o`0006gooo]Z000>oookJP?o001o1?oonfX3o`00O`Kooo]Z0ol0
07l9oookJPGo0000oooonfZOoookJPOo0000K?oonfX000kooo]Z0ol007l4oookJP?o001o1_oonfX3
o`00O`Wooo]Z1Ol0003ooookJZ;ooo]Z1Ol0001[oookJP003_oonfX3o`00O`Cooo]Z0ol007l6oook
JP?o001o2OoonfX5o`000?oooo]ZXooonfX6o`0006Wooo]Z000>oookJP?o001o2?oonfX9o`00O`So
oo]Z1Ol0003ooookJZCooo]Z1_l0001XoookJP003_oonfX3o`00O`Sooo]Z2Ol007l8oookJPKo0000
oooonfZToookJPKo0000IooonfX000kooo]Z0ol007l8oookJP;o001o0ooonfX3o`00O`Wooo]Z1Ol0
003ooookJZOooo]Z1ol0001ToookJP003_oonfX3o`00O`Wooo]Z0_l007l2oookJP?o001o2OoonfX5
o`000?oooo]ZZ?oonfX7o`0006?ooo]Z000>oookJP?o001o2OoonfX3o`00O`04oookJ_l007oo001o
o`00O`Wooo]Z1Ol0003ooookJZWooo]Z1ol0001RoookJP003_oonfX3o`00O`[ooo]Z0_l007l01?oo
nf[o001oo`00Ool007l9oookJPGo0000oooonfZZoookJPSo0000H?oonfX000_ooo]Z1_l007l;oook
JPGo001o2OoonfX5o`000?oooo]Z[OoonfX6o`0005oooo]Z000;oookJPKo001o2ooonfX5o`00O`Wo
oo]Z1Ol0003ooookJZkooo]Z1_l0001NoookJP003OoonfX4o`00O`cooo]Z1?l007l9oookJPGo0000
oooonfZ`oookJPGo0000GOoonfX000kooo]Z0ol007l=oookJP?o001o2OoonfX5o`000?oooo]Z/Ooo
nfX6o`0005_ooo]Z000ZoookJPGo0000oooonfZboookJPKo0000F_oonfX002[ooo]Z1Ol0003ooook
J[?ooo]Z1ol0001HoookJP00:_oonfX5o`000?oooo]Z]OoonfX7o`0005Kooo]Z000ZoookJPGo0000
oooonfZfoookJPOo0000EOoonfX002[ooo]Z1Ol0003ooookJ[Oooo]Z1ol0001DoookJP00:_oonfX5
o`000?oooo]Z^_oonfX5o`0005?ooo]Z000ZoookJPGo0000oooonfZkoookJPKo0000DOoonfX002[o
oo]Z1Ol0003ooookJ[cooo]Z1_l0001@oookJP00:_oonfX5o`000?oooo]Z_OoonfX6o`0004oooo]Z
000ZoookJPGo0000oooonfZooookJPKo0000COoonfX002[ooo]Z1Ol0003ooookJ/3ooo]Z1_l0001<
oookJP00:_oonfX5o`000?oooo]Z`OoonfX7o`0004[ooo]Z000ZoookJPGo0000oooonf[3oookJPOo
0000B?oonfX002[ooo]Z1Ol0003ooookJ/Cooo]Z1ol00017oookJP00:_oonfX5o`000?oooo]ZaOoo
nfX7o`0004Kooo]Z000ZoookJPGo0000oooonf[8oookJPGo0000AOoonfX002[ooo]Z1Ol0003ooook
J/Wooo]Z1_l00013oookJP00:_oonfX5o`000?oooo]Zb_oonfX6o`0004;ooo]Z000ZoookJPGo0000
oooonf[;oookJPKo0000@OoonfX002[ooo]Z1Ol0003ooookJ/gooo]Z1Ol00010oookJP00:_oonfX5
o`000?oooo]Zc_oonfX6o`0003kooo]Z000ZoookJPGo0000oooonf[?oookJPKo0000?OoonfX002[o
oo]Z1Ol0003ooookJ]3ooo]Z2?l0000joookJP00:_oonfX5o`000?oooo]Zd_oonfX7o`0003Wooo]Z
000ZoookJPGo0000oooonf[CoookJPOo0000>?oonfX002[ooo]Z1Ol0003ooookJ]Cooo]Z1ol0000g
oookJP00:_oonfX5o`000?oooo]ZeooonfX6o`0003Gooo]Z000ZoookJPGo0000oooonf[HoookJPKo
0000=?oonfX002[ooo]Z1Ol0003ooookJ]Wooo]Z1_l0000coookJP00:_oonfX5o`000?oooo]Zfooo
nfX5o`0003;ooo]Z000ZoookJPGo0000oooonf[LoookJPKo0000<?oonfX002[ooo]Z1Ol0003ooook
J]gooo]Z1_l0000_oookJP00:_oonfX5o`000?oooo]Zg_oonfX6o`0002kooo]Z000ZoookJPGo0000
oooonf[PoookJPGo0000;OoonfX002[ooo]Z1Ol0003ooookJ^7ooo]Z1_l0000[oookJP00:_oonfX5
o`000?oooo]Zh_oonfX7o`0002Wooo]Z000ZoookJPGo0000oooonf[SoookJPOo0000:?oonfX002[o
oo]Z1Ol0003ooookJ^Gooo]Z1ol0000VoookJP00:_oonfX5o`000?oooo]Zi_oonfX7o`0002Gooo]Z
000ZoookJPGo0000oooonf[XoookJPKo00009?oonfX002[ooo]Z1Ol0003ooookJ^[ooo]Z1_l0000R
oookJP00:_oonfX5o`000?oooo]ZjooonfX6o`00027ooo]Z000ZoookJPGo0000oooonf[/oookJPKo
00008?oonfX002[ooo]Z1Ol0003ooookJ^kooo]Z1Ol0000OoookJP00:_oonfX5o`000?oooo]Zkooo
nfX6o`0001gooo]Z000ZoookJPGo0000oooonf[`oookJPKo00007?oonfX002[ooo]Z1Ol0003ooook
J_7ooo]Z1_l0000KoookJP00:_oonfX5o`000?oooo]ZlooonfX5o`0001[ooo]Z000ZoookJPGo0000
oooonf[doookJPKo00006?oonfX002[ooo]Z1Ol0003ooookJ_Gooo]Z1_l0000GoookJP003_oonfX3
o`00O`Cooo]Z0ol007l3oookJPGo001o2_oonfX5o`000?oooo]Zm_oonfX5o`0001Oooo]Z000>oook
JP?o001o1?oonfX3o`00O`;ooo]Z1ol007l9oookJPGo0000oooonf[hoookJP;o00006?oonfX000ko
oo]Z0ol007l4oookJP?o001o00?ooo]Zo`00Ool007l00_l007l01?oonf[o001oo`00Ool007l9oook
JPGo0000oooonf[ooookJQ?ooo]Z000>oookJP?o001o2?oonfX3o`00O`?ooo]Z0ol007l8oookJPGo
0000oooonf[ooookJQ?ooo]Z000>oookJP?o001o3_oonfX3o`00O`Sooo]Z1_l0003ooookJ_oooo]Z
4_oonfX000kooo]Z0ol007l>oookJP?o001o2?oonfX5o`000?oooo]ZoooonfXCoookJP003_oonfX3
o`00O`Wooo]Z0_l007l2oookJPCo001o2?oonfX5o`000?oooo]ZoooonfXCoookJP003_oonfX3o`00
O`Wooo]Z1ol007l9oookJPGo0000oooonf[ooookJQ?ooo]Z000>oookJP?o001o2OoonfX6o`00O`[o
oo]Z1Ol0003ooookJ_oooo]Z4ooonfX000_ooo]Z1_l007l9oookJP;o001o3_oonfX5o`000?oooo]Z
oooonfXCoookJP002ooonfX6o`00O`Wooo]Z0_l007oooookJ_oooo]Z9_oonfX000gooo]Z1?l007l:
oookJPOo001ooooonf[ooookJR3ooo]Z000>oookJP?o001o2_oonfX7o`00Oooooo]ZoooonfXPoook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00001\
\>"],
  ImageRangeCache->{{{0, 575}, {354.938, 0}} -> {-0.3518, 0.958149, \
0.00790084, 0.0015709}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Using a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " trick of a ``pure function'' one can eliminate the intervening function \
(OurStepOnce) definition:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListPlot[
      NestList[StepOnce[#, exampleFunction, 0.01] &, {0, 1}, 400]]\)], "Input",\

  CellTags->"mmtag:19:pure_function"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.238095 -1.18279 1.1975 [
[.2619 .00222 -7 -20 ]
[.2619 .00222 7 0 ]
[.5 .00222 -7 -20 ]
[.5 .00222 7 0 ]
[.7381 .00222 -7 -20 ]
[.7381 .00222 7 0 ]
[.97619 .00222 -7 -20 ]
[.97619 .00222 7 0 ]
[.01131 .13447 -29 -10 ]
[.01131 .13447 0 10 ]
[.01131 .25422 -29 -10 ]
[.01131 .25422 0 10 ]
[.01131 .37397 -29 -10 ]
[.01131 .37397 0 10 ]
[.01131 .49372 -29 -10 ]
[.01131 .49372 0 10 ]
[.01131 .61347 -29 -10 ]
[.01131 .61347 0 10 ]
[ -0.005 -0.005 0 0 ]
[ 1.005 .62303 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
gsave
.2619 .00222 -68 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.5 .01472 m
.5 .02097 L
s
gsave
.5 .00222 -68 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.7381 .01472 m
.7381 .02097 L
s
gsave
.7381 .00222 -68 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(3) show
1.000 setlinewidth
grestore
.97619 .01472 m
.97619 .02097 L
s
gsave
.97619 .00222 -68 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(4) show
1.000 setlinewidth
grestore
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.01 w
0 .01472 m
1 .01472 L
s
.25 Mabswid
.02381 .13447 m
.03006 .13447 L
s
gsave
.01131 .13447 -90 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1.1) show
1.000 setlinewidth
grestore
.02381 .25422 m
.03006 .25422 L
s
gsave
.01131 .25422 -90 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1.2) show
1.000 setlinewidth
grestore
.02381 .37397 m
.03006 .37397 L
s
gsave
.01131 .37397 -90 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1.3) show
1.000 setlinewidth
grestore
.02381 .49372 m
.03006 .49372 L
s
gsave
.01131 .49372 -90 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1.4) show
1.000 setlinewidth
grestore
.02381 .61347 m
.03006 .61347 L
s
gsave
.01131 .61347 -90 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1.5) show
1.000 setlinewidth
grestore
.125 Mabswid
.02381 .03867 m
.02756 .03867 L
s
.02381 .06262 m
.02756 .06262 L
s
.02381 .08657 m
.02756 .08657 L
s
.02381 .11052 m
.02756 .11052 L
s
.02381 .15842 m
.02756 .15842 L
s
.02381 .18237 m
.02756 .18237 L
s
.02381 .20632 m
.02756 .20632 L
s
.02381 .23027 m
.02756 .23027 L
s
.02381 .27817 m
.02756 .27817 L
s
.02381 .30212 m
.02756 .30212 L
s
.02381 .32607 m
.02756 .32607 L
s
.02381 .35002 m
.02756 .35002 L
s
.02381 .39792 m
.02756 .39792 L
s
.02381 .42187 m
.02756 .42187 L
s
.02381 .44582 m
.02756 .44582 L
s
.02381 .46977 m
.02756 .46977 L
s
.02381 .51767 m
.02756 .51767 L
s
.02381 .54162 m
.02756 .54162 L
s
.02381 .56557 m
.02756 .56557 L
s
.02381 .58952 m
.02756 .58952 L
s
.01 w
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02381 .01472 Mdot
.02619 .01591 Mdot
.02857 .01711 Mdot
.03095 .01831 Mdot
.03333 .01951 Mdot
.03571 .02071 Mdot
.0381 .02192 Mdot
.04048 .02312 Mdot
.04286 .02433 Mdot
.04524 .02554 Mdot
.04762 .02674 Mdot
.05 .02795 Mdot
.05238 .02916 Mdot
.05476 .03038 Mdot
.05714 .03159 Mdot
.05952 .0328 Mdot
.0619 .03402 Mdot
.06429 .03524 Mdot
.06667 .03645 Mdot
.06905 .03767 Mdot
.07143 .03889 Mdot
.07381 .04012 Mdot
.07619 .04134 Mdot
.07857 .04256 Mdot
.08095 .04379 Mdot
.08333 .04501 Mdot
.08571 .04624 Mdot
.0881 .04747 Mdot
.09048 .0487 Mdot
.09286 .04993 Mdot
.09524 .05117 Mdot
.09762 .0524 Mdot
.1 .05364 Mdot
.10238 .05487 Mdot
.10476 .05611 Mdot
.10714 .05735 Mdot
.10952 .05859 Mdot
.1119 .05983 Mdot
.11429 .06107 Mdot
.11667 .06232 Mdot
.11905 .06356 Mdot
.12143 .06481 Mdot
.12381 .06606 Mdot
.12619 .0673 Mdot
.12857 .06855 Mdot
.13095 .06981 Mdot
.13333 .07106 Mdot
.13571 .07231 Mdot
.1381 .07357 Mdot
.14048 .07482 Mdot
.14286 .07608 Mdot
.14524 .07734 Mdot
.14762 .0786 Mdot
.15 .07986 Mdot
.15238 .08112 Mdot
.15476 .08239 Mdot
.15714 .08365 Mdot
.15952 .08492 Mdot
.1619 .08619 Mdot
.16429 .08746 Mdot
.16667 .08873 Mdot
.16905 .09 Mdot
.17143 .09127 Mdot
.17381 .09254 Mdot
.17619 .09382 Mdot
.17857 .0951 Mdot
.18095 .09637 Mdot
.18333 .09765 Mdot
.18571 .09893 Mdot
.1881 .10022 Mdot
.19048 .1015 Mdot
.19286 .10278 Mdot
.19524 .10407 Mdot
.19762 .10536 Mdot
.2 .10664 Mdot
.20238 .10793 Mdot
.20476 .10922 Mdot
.20714 .11052 Mdot
.20952 .11181 Mdot
.2119 .1131 Mdot
.21429 .1144 Mdot
.21667 .1157 Mdot
.21905 .117 Mdot
.22143 .1183 Mdot
.22381 .1196 Mdot
.22619 .1209 Mdot
.22857 .1222 Mdot
.23095 .12351 Mdot
.23333 .12481 Mdot
.23571 .12612 Mdot
.2381 .12743 Mdot
.24048 .12874 Mdot
.24286 .13005 Mdot
.24524 .13136 Mdot
.24762 .13268 Mdot
.25 .13399 Mdot
.25238 .13531 Mdot
.25476 .13663 Mdot
.25714 .13795 Mdot
.25952 .13927 Mdot
.2619 .14059 Mdot
.26429 .14191 Mdot
.26667 .14324 Mdot
.26905 .14457 Mdot
.27143 .14589 Mdot
.27381 .14722 Mdot
.27619 .14855 Mdot
.27857 .14988 Mdot
.28095 .15122 Mdot
.28333 .15255 Mdot
.28571 .15388 Mdot
.2881 .15522 Mdot
.29048 .15656 Mdot
.29286 .1579 Mdot
.29524 .15924 Mdot
.29762 .16058 Mdot
.3 .16192 Mdot
.30238 .16327 Mdot
.30476 .16462 Mdot
.30714 .16596 Mdot
.30952 .16731 Mdot
.3119 .16866 Mdot
.31429 .17001 Mdot
.31667 .17137 Mdot
.31905 .17272 Mdot
.32143 .17408 Mdot
.32381 .17543 Mdot
.32619 .17679 Mdot
.32857 .17815 Mdot
.33095 .17951 Mdot
.33333 .18087 Mdot
.33571 .18224 Mdot
.3381 .1836 Mdot
.34048 .18497 Mdot
.34286 .18634 Mdot
.34524 .18771 Mdot
.34762 .18908 Mdot
.35 .19045 Mdot
.35238 .19182 Mdot
.35476 .1932 Mdot
.35714 .19457 Mdot
.35952 .19595 Mdot
.3619 .19733 Mdot
.36429 .19871 Mdot
.36667 .20009 Mdot
.36905 .20147 Mdot
.37143 .20286 Mdot
.37381 .20424 Mdot
.37619 .20563 Mdot
.37857 .20702 Mdot
.38095 .20841 Mdot
.38333 .2098 Mdot
.38571 .21119 Mdot
.3881 .21259 Mdot
.39048 .21398 Mdot
.39286 .21538 Mdot
.39524 .21678 Mdot
.39762 .21818 Mdot
.4 .21958 Mdot
.40238 .22098 Mdot
.40476 .22238 Mdot
.40714 .22379 Mdot
.40952 .22519 Mdot
.4119 .2266 Mdot
.41429 .22801 Mdot
.41667 .22942 Mdot
.41905 .23083 Mdot
.42143 .23225 Mdot
.42381 .23366 Mdot
.42619 .23508 Mdot
.42857 .2365 Mdot
.43095 .23792 Mdot
.43333 .23934 Mdot
.43571 .24076 Mdot
.4381 .24218 Mdot
.44048 .24361 Mdot
.44286 .24503 Mdot
.44524 .24646 Mdot
.44762 .24789 Mdot
.45 .24932 Mdot
.45238 .25075 Mdot
.45476 .25219 Mdot
.45714 .25362 Mdot
.45952 .25506 Mdot
.4619 .2565 Mdot
.46429 .25794 Mdot
.46667 .25938 Mdot
.46905 .26082 Mdot
.47143 .26226 Mdot
.47381 .26371 Mdot
.47619 .26515 Mdot
.47857 .2666 Mdot
.48095 .26805 Mdot
.48333 .2695 Mdot
.48571 .27095 Mdot
.4881 .27241 Mdot
.49048 .27386 Mdot
.49286 .27532 Mdot
.49524 .27678 Mdot
.49762 .27824 Mdot
.5 .2797 Mdot
.50238 .28116 Mdot
.50476 .28263 Mdot
.50714 .28409 Mdot
.50952 .28556 Mdot
.5119 .28703 Mdot
.51429 .2885 Mdot
.51667 .28997 Mdot
.51905 .29144 Mdot
.52143 .29291 Mdot
.52381 .29439 Mdot
.52619 .29587 Mdot
.52857 .29735 Mdot
.53095 .29883 Mdot
.53333 .30031 Mdot
.53571 .30179 Mdot
.5381 .30328 Mdot
.54048 .30476 Mdot
.54286 .30625 Mdot
.54524 .30774 Mdot
.54762 .30923 Mdot
.55 .31072 Mdot
.55238 .31221 Mdot
.55476 .31371 Mdot
.55714 .31521 Mdot
.55952 .3167 Mdot
.5619 .3182 Mdot
.56429 .3197 Mdot
.56667 .32121 Mdot
.56905 .32271 Mdot
.57143 .32422 Mdot
.57381 .32572 Mdot
.57619 .32723 Mdot
.57857 .32874 Mdot
.58095 .33025 Mdot
.58333 .33177 Mdot
.58571 .33328 Mdot
.5881 .3348 Mdot
.59048 .33631 Mdot
.59286 .33783 Mdot
.59524 .33935 Mdot
.59762 .34088 Mdot
.6 .3424 Mdot
.60238 .34392 Mdot
.60476 .34545 Mdot
.60714 .34698 Mdot
.60952 .34851 Mdot
.6119 .35004 Mdot
.61429 .35157 Mdot
.61667 .35311 Mdot
.61905 .35464 Mdot
.62143 .35618 Mdot
.62381 .35772 Mdot
.62619 .35926 Mdot
.62857 .3608 Mdot
.63095 .36235 Mdot
.63333 .36389 Mdot
.63571 .36544 Mdot
.6381 .36699 Mdot
.64048 .36854 Mdot
.64286 .37009 Mdot
.64524 .37164 Mdot
.64762 .37319 Mdot
.65 .37475 Mdot
.65238 .37631 Mdot
.65476 .37787 Mdot
.65714 .37943 Mdot
.65952 .38099 Mdot
.6619 .38255 Mdot
.66429 .38412 Mdot
.66667 .38569 Mdot
.66905 .38725 Mdot
.67143 .38882 Mdot
.67381 .3904 Mdot
.67619 .39197 Mdot
.67857 .39354 Mdot
.68095 .39512 Mdot
.68333 .3967 Mdot
.68571 .39828 Mdot
.6881 .39986 Mdot
.69048 .40144 Mdot
.69286 .40303 Mdot
.69524 .40461 Mdot
.69762 .4062 Mdot
.7 .40779 Mdot
.70238 .40938 Mdot
.70476 .41097 Mdot
.70714 .41256 Mdot
.70952 .41416 Mdot
.7119 .41576 Mdot
.71429 .41736 Mdot
.71667 .41896 Mdot
.71905 .42056 Mdot
.72143 .42216 Mdot
.72381 .42377 Mdot
.72619 .42537 Mdot
.72857 .42698 Mdot
.73095 .42859 Mdot
.73333 .4302 Mdot
.73571 .43181 Mdot
.7381 .43343 Mdot
.74048 .43505 Mdot
.74286 .43666 Mdot
.74524 .43828 Mdot
.74762 .4399 Mdot
.75 .44153 Mdot
.75238 .44315 Mdot
.75476 .44478 Mdot
.75714 .4464 Mdot
.75952 .44803 Mdot
.7619 .44966 Mdot
.76429 .4513 Mdot
.76667 .45293 Mdot
.76905 .45457 Mdot
.77143 .4562 Mdot
.77381 .45784 Mdot
.77619 .45948 Mdot
.77857 .46113 Mdot
.78095 .46277 Mdot
.78333 .46442 Mdot
.78571 .46606 Mdot
.7881 .46771 Mdot
.79048 .46936 Mdot
.79286 .47101 Mdot
.79524 .47267 Mdot
.79762 .47432 Mdot
.8 .47598 Mdot
.80238 .47764 Mdot
.80476 .4793 Mdot
.80714 .48096 Mdot
.80952 .48263 Mdot
.8119 .48429 Mdot
.81429 .48596 Mdot
.81667 .48763 Mdot
.81905 .4893 Mdot
.82143 .49097 Mdot
.82381 .49264 Mdot
.82619 .49432 Mdot
.82857 .496 Mdot
.83095 .49767 Mdot
.83333 .49935 Mdot
.83571 .50104 Mdot
.8381 .50272 Mdot
.84048 .50441 Mdot
.84286 .50609 Mdot
.84524 .50778 Mdot
.84762 .50947 Mdot
.85 .51117 Mdot
.85238 .51286 Mdot
.85476 .51455 Mdot
.85714 .51625 Mdot
.85952 .51795 Mdot
.8619 .51965 Mdot
.86429 .52135 Mdot
.86667 .52306 Mdot
.86905 .52476 Mdot
.87143 .52647 Mdot
.87381 .52818 Mdot
.87619 .52989 Mdot
.87857 .5316 Mdot
.88095 .53332 Mdot
.88333 .53504 Mdot
.88571 .53675 Mdot
.8881 .53847 Mdot
.89048 .54019 Mdot
.89286 .54192 Mdot
.89524 .54364 Mdot
.89762 .54537 Mdot
.9 .5471 Mdot
.90238 .54883 Mdot
.90476 .55056 Mdot
.90714 .55229 Mdot
.90952 .55403 Mdot
.9119 .55576 Mdot
.91429 .5575 Mdot
.91667 .55924 Mdot
.91905 .56098 Mdot
.92143 .56273 Mdot
.92381 .56447 Mdot
.92619 .56622 Mdot
.92857 .56797 Mdot
.93095 .56972 Mdot
.93333 .57147 Mdot
.93571 .57323 Mdot
.9381 .57498 Mdot
.94048 .57674 Mdot
.94286 .5785 Mdot
.94524 .58026 Mdot
.94762 .58202 Mdot
.95 .58379 Mdot
.95238 .58556 Mdot
.95476 .58732 Mdot
.95714 .58909 Mdot
.95952 .59087 Mdot
.9619 .59264 Mdot
.96429 .59442 Mdot
.96667 .59619 Mdot
.96905 .59797 Mdot
.97143 .59975 Mdot
.97381 .60153 Mdot
.97619 .60332 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{576, 355.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000900001Hb000`400?l00000o`00003ooooonf[o
oookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00oooonf[ooookJT;ooo]Z
003ooookJ_oooo]Z@_oonfX00?oooo]ZoooonfY2oookJP00Z_oonfX3o`00OgOooo]Z2Ol007mhoook
JPGo001oO?oonfX3o`00OaOooo]Z002ZoookJP?o001oMooonfX9o`00OgOooo]Z1ol007mkoookJP?o
001o5ooonfX00:[ooo]Z0ol007mgoookJPCo001oNooonfX3o`00O`?ooo]Z0ol007mjoookJP?o001o
5ooonfX00:[ooo]Z0ol007mhoookJPCo001oN_oonfX3o`00O`?ooo]Z0ol007meoookJPWo001o5_oo
nfX00:[ooo]Z0ol007mioookJPGo001oO_oonfX3o`00OgGooo]Z2Ol007lFoookJP00Z_oonfX3o`00
Og_ooo]Z1?l007mmoookJP?o001oMOoonfX2o`00O`?ooo]Z0ol007lGoookJP00Z_oonfX3o`00Ogco
oo]Z0ol007mkoookJPCo001oMooonfX2o`00O`;ooo]Z0ol007lGoookJP00Z_oonfX3o`00Oggooo]Z
0ol007mjoookJP?o001oN?oonfX3o`00O`04oookJ_l007oo001oo`00OaOooo]Z002ZoookJP?o001o
MooonfX3o`00O`?ooo]Z0ol007mloookJP;o001oN?oonfX2o`00O`04oookJ_l007oo001oo`00OaOo
oo]Z002WoookJPKo001oMooonfX3o`00O`?ooo]Z0ol007mfoookJP?o001o0ooonfX3o`00OgSooo]Z
1Ol007lGoookJP00:_oonfX5o`0007Sooo]Z1_l007mgoookJPCo001o0_oonfX3o`00OgKooo]Z0ol0
07l3oookJP?o001oN?oonfX5o`00OaOooo]Z000ZoookJPGo0000N_oonfX4o`00OgSooo]Z1ol007mh
oookJPOo001oN_oonfX4o`00OaOooo]Z000ZoookJPGo0000NooonfX3o`00OgWooo]Z1Ol007mjoook
JPGo001oO?oonfX3o`00OaOooo]Z000ZoookJPGo0000oooonf[ooookJQ?ooo]Z000ZoookJPGo0000
oooonf[ooookJQ?ooo]Z000ZoookJPGo0000oooonf[ooookJQ?ooo]Z000ZoookJPGo0000oooonf[o
oookJQ?ooo]Z000ZoookJPGo0000oooonf[ooookJQ?ooo]Z000MoookJ_oo0000ool0000Ko`0000[o
oo]Z000MoookJ_oo0000ool0000Ko`0000[ooo]Z000MoookJ_oo0000ool0000Ko`0000[ooo]Z000M
oookJ_oo0000ool0000Ko`0000[ooo]Z000MoookJ_oo0000ool0000Ko`0000[ooo]Z000ZoookJPco
0000MOoonfX00ol0003ooo]ZoookJP1koookJP03o`000?oonf[ooo]Z07cooo]Z00?o0000oookJ_oo
nfX0NooonfX00ol0003ooo]ZoookJP0GoookJP00:_oonfX>o`0007?ooo]Z00?o0000oookJ_oonfX0
NooonfX00ol0003ooo]ZoookJP1loookJP03o`000?oonf[ooo]Z07_ooo]Z00?o0000oookJ_oonfX0
5ooonfX002[ooo]Z1Ol00003oookJPSo0000oooonf[ooookJPSooo]Z000ZoookJPGo00001?oonfX8
o`000?oooo]ZoooonfX7oookJP00:_oonfX5o`0000Oooo]Z2?l0003ooookJ_oooo]Z1?oonfX002[o
oo]Z1Ol00008oookJPWo0000oooonf[ooookJP;ooo]Z000ZoookJPGo00002_oonfX9o`000?oooo]Z
oooonfX002[ooo]Z1Ol0000<oookJPWo0000oooonf[moookJP00:_oonfX5o`0000kooo]Z2?l0003o
oookJ_cooo]Z000ZoookJPGo00004OoonfX8o`000?oooo]ZnOoonfX002[ooo]Z1Ol0000BoookJPSo
0000oooonf[hoookJP00:_oonfX5o`0001Cooo]Z2Ol0003ooookJ_Gooo]Z000ZoookJPGo00005_oo
nfX8o`000?oooo]Zm?oonfX002[ooo]Z1Ol0000HoookJPWo0000oooonf[aoookJP00:_oonfX5o`00
01[ooo]Z2?l0003ooookJ_3ooo]Z000ZoookJPGo00007?oonfX8o`000?oooo]Zk_oonfX002[ooo]Z
1Ol0000MoookJPWo0000oooonf[/oookJP00:_oonfX5o`00023ooo]Z2?l0003ooookJ^[ooo]Z000Z
oookJPGo00008OoonfX:o`000?oooo]ZiooonfX002[ooo]Z1Ol0000ToookJPSo0000oooonf[Voook
JP00:_oonfX5o`0002Gooo]Z2_l0003ooookJ^?ooo]Z000ZoookJPGo00009ooonfX9o`000?oooo]Z
h_oonfX002[ooo]Z1Ol0000ZoookJPSo0000oooonf[PoookJP00:_oonfX5o`0002_ooo]Z2Ol0003o
oookJ]kooo]Z000ZoookJPGo0000;_oonfX8o`000?oooo]Zg?oonfX002[ooo]Z1Ol0000_oookJPSo
0000oooonf[KoookJP00:_oonfX5o`0003;ooo]Z2?l0003ooookJ]Sooo]Z000ZoookJPGo0000<ooo
nfX8o`000?oooo]ZeooonfX002[ooo]Z1Ol0000eoookJPWo0000oooonf[DoookJP00:_oonfX5o`00
03Oooo]Z2?l0003ooookJ]?ooo]Z000ZoookJPGo0000>OoonfX8o`000?oooo]ZdOoonfX002[ooo]Z
1Ol0000joookJPWo0000oooonf[?oookJP00:_oonfX5o`0003gooo]Z2?l0003ooookJ/gooo]Z000Z
oookJPGo0000?_oonfX9o`000?oooo]ZbooonfX002[ooo]Z1Ol00011oookJPSo0000oooonf[9oook
JP00:_oonfX5o`0004;ooo]Z2?l0003ooookJ/Sooo]Z000ZoookJPGo0000AOoonfX7o`000?oooo]Z
a_oonfX002[ooo]Z1Ol00016oookJPSo0000oooonf[4oookJP00:_oonfX5o`0004Sooo]Z1ol0003o
oookJ/?ooo]Z000ZoookJPGo0000B_oonfX8o`000?oooo]Z`?oonfX002[ooo]Z1Ol0001;oookJPSo
0000oooonfZooookJP00:_oonfX5o`0004gooo]Z2Ol0003ooookJ[cooo]Z000ZoookJPGo0000Cooo
nfX8o`000?oooo]Z^ooonfX002[ooo]Z1Ol0001AoookJPWo0000oooonfZhoookJP00:_oonfX5o`00
05;ooo]Z2Ol0003ooookJ[Oooo]Z000ZoookJPGo0000EOoonfX8o`000?oooo]Z]OoonfX002[ooo]Z
1Ol0001FoookJPWo0000oooonfZcoookJP00:_oonfX5o`0005Wooo]Z2?l0003ooookJ[7ooo]Z000Z
oookJPGo0000F_oonfX8o`000?oooo]Z/?oonfX002[ooo]Z1Ol0001MoookJPOo0000oooonfZ^oook
JP00:_oonfX5o`0005kooo]Z2?l0003ooookJZcooo]Z000ZoookJPGo0000H?oonfX7o`000?oooo]Z
ZooonfX002[ooo]Z1Ol0001RoookJPSo0000oooonfZXoookJP00:_oonfX5o`0006?ooo]Z2?l0003o
oookJZOooo]Z000ZoookJPGo0000IOoonfX9o`000?oooo]ZY?oonfX002[ooo]Z1Ol0001WoookJPSo
0000oooonfZSoookJP00:_oonfX5o`0006Wooo]Z2Ol0003ooookJZ3ooo]Z000>oookJP?o001o1?oo
nfX3o`00O`Gooo]Z0ol007l:oookJPGo0000JooonfX8o`000?oooo]ZWooonfX000kooo]Z0ol007l4
oookJP?o001o1OoonfX3o`00O`[ooo]Z1Ol0001]oookJPOo0000oooonfZNoookJP003_oonfX3o`00
O`Cooo]Z0ol007l5oookJP?o001o2_oonfX5o`0006kooo]Z2Ol0003ooookJY_ooo]Z000>oookJP?o
001o3?oonfX3o`00O`[ooo]Z1Ol0001aoookJPOo0000oooonfZJoookJP003_oonfX3o`00O`cooo]Z
0ol007l:oookJPKo0000LOoonfX8o`000?oooo]ZV?oonfX000kooo]Z0ol007l<oookJP?o001o2_oo
nfX5o`0007?ooo]Z2Ol0003ooookJYKooo]Z000>oookJP?o001o3?oonfX3o`00O`[ooo]Z1Ol0001f
oookJPSo0000oooonfZDoookJP003_oonfX3o`00O`cooo]Z0ol007l:oookJPGo0000MooonfX9o`00
0?oooo]ZT_oonfX000kooo]Z0ol007l<oookJP?o001o2_oonfX5o`0007[ooo]Z1ol0003ooookJY7o
oo]Z000;oookJPKo001o2OoonfX6o`00O`[ooo]Z1Ol0001koookJPSo0000oooonfZ?oookJP002ooo
nfX6o`00O`Wooo]Z1_l007l:oookJPGo0000O_oonfX7o`000?oooo]ZSOoonfX000gooo]Z1?l007l;
oookJPCo001o2_oonfX5o`0007oooo]Z2?l0003ooookJX_ooo]Z000>oookJP?o001o3?oonfX3o`00
O`[ooo]Z1Ol00020oookJPSo0000oooonfZ:oookJP00:_oonfX5o`0008?ooo]Z1ol0003ooookJXSo
oo]Z000ZoookJPGo0000Q?oonfX8o`000?oooo]ZQ_oonfX002[ooo]Z1Ol00026oookJPOo0000oooo
nfZ5oookJP00:_oonfX5o`0008Sooo]Z2?l0003ooookJX;ooo]Z000ZoookJPGo0000ROoonfX8o`00
0?oooo]ZPOoonfX002[ooo]Z1Ol0002;oookJPOo0000oooonfZ0oookJP00:_oonfX5o`0008gooo]Z
2?l0003ooookJWgooo]Z000ZoookJPGo0000SooonfX7o`000?oooo]ZO?oonfX002[ooo]Z1Ol0002@
oookJPWo0000oooonfYioookJP00:_oonfX5o`0009;ooo]Z2?l0003ooookJWSooo]Z000ZoookJPGo
0000U?oonfX7o`000?oooo]ZMooonfX002[ooo]Z1Ol0002FoookJPSo0000oooonfYdoookJP00:_oo
nfX5o`0009Sooo]Z1ol0003ooookJW?ooo]Z000ZoookJPGo0000VOoonfX9o`000?oooo]ZL?oonfX0
02[ooo]Z1Ol0002KoookJPSo0000oooonfY_oookJP00:_oonfX5o`0009gooo]Z1ol0003ooookJVko
oo]Z000ZoookJPGo0000W_oonfX9o`000?oooo]ZJooonfX002[ooo]Z1Ol0002QoookJPOo0000oooo
nfYZoookJP00:_oonfX5o`000:;ooo]Z1ol0003ooookJVWooo]Z000ZoookJPGo0000XooonfX9o`00
0?oooo]ZI_oonfX002[ooo]Z1Ol0002VoookJPOo0000oooonfYUoookJP00:_oonfX5o`000:Oooo]Z
2Ol0003ooookJV;ooo]Z000ZoookJPGo0000ZOoonfX8o`000?oooo]ZHOoonfX002[ooo]Z1Ol0002[
oookJPOo0000oooonfYPoookJP00:_oonfX5o`000:cooo]Z2Ol0003ooookJUgooo]Z000ZoookJPGo
0000[ooonfX7o`000?oooo]ZG?oonfX002[ooo]Z1Ol0002`oookJPOo0000oooonfYKoookJP00:_oo
nfX5o`000;7ooo]Z2Ol0003ooookJUSooo]Z000ZoookJPGo0000]?oonfX7o`000?oooo]ZEooonfX0
02[ooo]Z1Ol0002eoookJPOo0000oooonfYFoookJP00:_oonfX5o`000;Kooo]Z2Ol0003ooookJU?o
oo]Z000ZoookJPGo0000^OoonfX7o`000?oooo]ZD_oonfX002[ooo]Z1Ol0002joookJPOo0000oooo
nfYAoookJP00:_oonfX5o`000;cooo]Z2?l0003ooookJTkooo]Z000ZoookJPGo0000__oonfX7o`00
0?oooo]ZCOoonfX002[ooo]Z1Ol0002ooookJPWo0000oooonfY:oookJP00:_oonfX5o`000<7ooo]Z
2?l0003ooookJTWooo]Z000ZoookJPGo0000`ooonfX7o`000?oooo]ZB?oonfX002[ooo]Z1Ol00034
oookJPWo0000oooonfY5oookJP00:_oonfX5o`000<Oooo]Z1ol0003ooookJTCooo]Z000ZoookJPGo
0000b?oonfX7o`000?oooo]Z@ooonfX002[ooo]Z1Ol00039oookJPWo0000oooonfY0oookJP00:_oo
nfX5o`000<cooo]Z1ol0003ooookJSoooo]Z000ZoookJPGo0000cOoonfX7o`000?oooo]Z?_oonfX0
02[ooo]Z1Ol0003?oookJPSo0000oooonfXkoookJP00:_oonfX5o`000=7ooo]Z1ol0003ooookJS[o
oo]Z000ZoookJPGo0000d_oonfX7o`000?oooo]Z>OoonfX002[ooo]Z1Ol0003DoookJPOo0000oooo
nfXgoookJP00:_oonfX5o`000=Kooo]Z1ol0003ooookJSGooo]Z000ZoookJPGo0000eooonfX7o`00
0?oooo]Z=?oonfX002[ooo]Z1Ol0003IoookJPOo0000oooonfXboookJP003_oonfX3o`00O`Cooo]Z
0ol007l00ooonf[o001oo`00O`07o`00O`Sooo]Z1Ol0003JoookJPSo0000oooonfX`oookJP003_oo
nfX3o`00O`Cooo]Z0ol007l00ooonf[o001oo`00O`07o`00O`Sooo]Z1Ol0003LoookJPOo0000oooo
nfX_oookJP003_oonfX3o`00O`Cooo]Z0ol007l00ooonf[o001oo`00O`02o`00O`gooo]Z1Ol0003N
oookJPOo0000oooonfX]oookJP003_oonfX3o`00O`Wooo]Z1?l007l<oookJPGo0000gooonfX8o`00
0?oooo]Z:ooonfX000kooo]Z0ol007l:oookJPGo001o2_oonfX6o`000>3ooo]Z2?l0003ooookJRWo
oo]Z000>oookJP?o001o3?oonfX4o`00O`Wooo]Z1Ol0003SoookJPOo0000oooonfXXoookJP003_oo
nfX3o`00O`gooo]Z0ol007l9oookJPGo0000i?oonfX8o`000?oooo]Z9_oonfX000kooo]Z0ol007l>
oookJP?o001o2?oonfX5o`000>Oooo]Z1ol0003ooookJRCooo]Z000>oookJP?o001o2?oonfX3o`00
O`?ooo]Z0ol007l8oookJPGo0000j?oonfX7o`000?oooo]Z8ooonfX000_ooo]Z1_l007l8oookJP?o
001o0ooonfX3o`00O`Sooo]Z1Ol0003YoookJPSo0000oooonfXQoookJP002ooonfX6o`00O`Sooo]Z
1?l007l2oookJP?o001o2?oonfX5o`000>cooo]Z1ol0003ooookJQoooo]Z000=oookJPCo001o2Ooo
nfX7o`00O`Wooo]Z1Ol0003]oookJPOo0000oooonfXNoookJP003_oonfX3o`00O`[ooo]Z1Ol007l:
oookJPGo0000k_oonfX7o`000?oooo]Z7OoonfX002[ooo]Z1Ol0003aoookJPOo0000oooonfXJoook
JP00:_oonfX5o`000?;ooo]Z1ol0003ooookJQWooo]Z000ZoookJPGo0000looonfX7o`000?oooo]Z
6?oonfX002[ooo]Z1Ol0003doookJPWo0000oooonfXEoookJP00:_oonfX5o`000?Oooo]Z1ol0003o
oookJQCooo]Z000ZoookJPGo0000n?oonfX7o`000?oooo]Z4ooonfX002[ooo]Z1Ol0003joookJPOo
0000oooonfXAoookJP00:_oonfX5o`000?cooo]Z1ol0003ooookJPoooo]Z000ZoookJPGo0000oOoo
nfX7o`000?oooo]Z3_oonfX002[ooo]Z1Ol0003ooookJPOo0000oooonfX<oookJP00:_oonfX5o`00
0?oooo]Z0OoonfX7o`000?oooo]Z2ooonfX002[ooo]Z1Ol0003ooookJP?ooo]Z1ol0003ooookJPWo
oo]Z000ZoookJPGo0000oooonfX5oookJPOo0000oooonfX7oookJP00:_oonfX5o`000?oooo]Z1_oo
nfX7o`000?oooo]Z1_oonfX002[ooo]Z1Ol0003ooookJPOooo]Z2Ol0003ooookJP?ooo]Z000Zoook
JPGo0000oooonfX:oookJPOo0000oooonfX2oookJP00:_oonfX5o`000?oooo]Z2ooonfX7o`000?oo
oo]Z0OoonfX002[ooo]Z1Ol0003ooookJPcooo]Z1ol0003ooookJP00:_oonfX5o`000?oooo]Z3ooo
nfX7o`000?cooo]Z000ZoookJPGo0000oooonfX@oookJPOo0000nooonfX002[ooo]Z1Ol0003ooook
JQ7ooo]Z1ol0003joookJP00:_oonfX5o`000?oooo]Z4ooonfX7o`000?Sooo]Z000ZoookJPGo0000
oooonfXEoookJPOo0000m_oonfX002[ooo]Z1Ol0003ooookJQKooo]Z1ol0003eoookJP00:_oonfX5
o`000?oooo]Z6?oonfX7o`000??ooo]Z000ZoookJPGo0000oooonfXIoookJPOo0000l_oonfX002[o
oo]Z1Ol0003ooookJQ_ooo]Z2?l0003_oookJP00:_oonfX5o`000?oooo]Z7OoonfX7o`000>kooo]Z
000ZoookJPGo0000oooonfXNoookJPOo0000kOoonfX002[ooo]Z1Ol0003ooookJQoooo]Z1ol0003/
oookJP00:_oonfX5o`000?oooo]Z8_oonfX7o`000>Wooo]Z000ZoookJPGo0000oooonfXSoookJPOo
0000j?oonfX002[ooo]Z1Ol0003ooookJRCooo]Z1ol0003WoookJP00:_oonfX5o`000?oooo]Z9_oo
nfX7o`000>Gooo]Z000ZoookJPGo0000oooonfXXoookJPOo0000hooonfX002[ooo]Z1Ol0003ooook
JRWooo]Z1ol0003RoookJP00:_oonfX5o`000?oooo]Z:ooonfX7o`000>3ooo]Z000ZoookJPGo0000
oooonfX/oookJPOo0000gooonfX002[ooo]Z1Ol0003ooookJRkooo]Z1ol0003MoookJP00:_oonfX5
o`000?oooo]Z<?oonfX7o`000=_ooo]Z000ZoookJPGo0000oooonfXaoookJPOo0000f_oonfX002[o
oo]Z1Ol0003ooookJS;ooo]Z1ol0003IoookJP00:_oonfX5o`000?oooo]Z=OoonfX6o`000=Oooo]Z
000ZoookJPGo0000oooonfXfoookJPOo0000eOoonfX002[ooo]Z1Ol0003ooookJSOooo]Z1ol0003D
oookJP00:_oonfX5o`000?oooo]Z>OoonfX7o`000=;ooo]Z000ZoookJPGo0000oooonfXjoookJPOo
0000dOoonfX002[ooo]Z1Ol0003ooookJScooo]Z1ol0003?oookJP00:_oonfX5o`000?oooo]Z?_oo
nfX7o`000<gooo]Z000ZoookJPGo0000oooonfXooookJPOo0000c?oonfX000kooo]Z0ol007l4oook
JP?o001o0ooonfX5o`00O`[ooo]Z1Ol0003ooookJT3ooo]Z1ol0003;oookJP003_oonfX3o`00O`Co
oo]Z0ol007l2oookJPOo001o2OoonfX5o`000?oooo]Z@ooonfX5o`000<[ooo]Z000>oookJP?o001o
1?oonfX3o`00O`04oookJ_l007oo001oo`00O`?ooo]Z0ol007l8oookJPGo0000oooonfY4oookJPOo
0000aooonfX000kooo]Z0ol007l8oookJP?o001o0ooonfX3o`00O`Sooo]Z1Ol0003ooookJTGooo]Z
1ol00036oookJP003_oonfX3o`00O`kooo]Z0ol007l8oookJPKo0000oooonfY5oookJPSo0000a?oo
nfX000kooo]Z0ol007l>oookJP?o001o2?oonfX5o`000?oooo]ZB?oonfX7o`000<?ooo]Z000>oook
JP?o001o3?oonfX4o`00O`Wooo]Z1Ol0003ooookJT[ooo]Z1_l00032oookJP003_oonfX3o`00O`co
oo]Z0ol007l:oookJPGo0000oooonfY<oookJPOo0000_ooonfX000kooo]Z0ol007l>oookJP;o001o
2OoonfX5o`000?oooo]ZCOoonfX7o`000;kooo]Z000;oookJPKo001o2?oonfX3o`00O`?ooo]Z0ol0
07l8oookJPGo0000oooonfY>oookJPOo0000_OoonfX000_ooo]Z1_l007l8oookJP?o001o0ooonfX3
o`00O`Sooo]Z1Ol0003ooookJToooo]Z1ol0002loookJP003OoonfX4o`00O`Wooo]Z1ol007l9oook
JPGo0000oooonfYBoookJPKo0000^_oonfX000kooo]Z0ol007l:oookJPGo001o2_oonfX5o`000?oo
oo]ZDooonfX7o`000;Sooo]Z000ZoookJPGo0000oooonfYDoookJPOo0000]ooonfX002[ooo]Z1Ol0
003ooookJUKooo]Z1ol0002eoookJP00:_oonfX5o`000?oooo]ZEooonfX7o`000;Cooo]Z000Zoook
JPGo0000oooonfYIoookJPKo0000/ooonfX002[ooo]Z1Ol0003ooookJU_ooo]Z1ol0002`oookJP00
:_oonfX5o`000?oooo]ZG?oonfX7o`000:oooo]Z000ZoookJPGo0000oooonfYMoookJPOo0000[_oo
nfX002[ooo]Z1Ol0003ooookJUoooo]Z1ol0002/oookJP00:_oonfX5o`000?oooo]ZHOoonfX6o`00
0:_ooo]Z000ZoookJPGo0000oooonfYRoookJPOo0000ZOoonfX002[ooo]Z1Ol0003ooookJVCooo]Z
1ol0002WoookJP00:_oonfX5o`000?oooo]ZIOoonfX7o`000:Kooo]Z000ZoookJPGo0000oooonfYV
oookJPOo0000YOoonfX002[ooo]Z1Ol0003ooookJVWooo]Z1Ol0002ToookJP00:_oonfX5o`000?oo
oo]ZJ_oonfX6o`000:;ooo]Z000ZoookJPGo0000oooonfY[oookJPOo0000X?oonfX002[ooo]Z1Ol0
003ooookJVcooo]Z2?l0002NoookJP00:_oonfX5o`000?oooo]ZK_oonfX7o`0009gooo]Z000Zoook
JPGo0000oooonfY_oookJPOo0000W?oonfX002[ooo]Z1Ol0003ooookJW;ooo]Z1Ol0002KoookJP00
:_oonfX5o`000?oooo]ZLooonfX6o`0009Wooo]Z000ZoookJPGo0000oooonfYdoookJPOo0000Uooo
nfX002[ooo]Z1Ol0003ooookJWGooo]Z1ol0002FoookJP00:_oonfX5o`000?oooo]ZMooonfX7o`00
09Cooo]Z000ZoookJPGo0000oooonfYhoookJPOo0000TooonfX002[ooo]Z1Ol0003ooookJW[ooo]Z
1_l0002BoookJP00:_oonfX5o`000?oooo]ZO?oonfX5o`00097ooo]Z000ZoookJPGo0000oooonfYm
oookJPOo0000S_oonfX002[ooo]Z1Ol0003ooookJWkooo]Z1ol0002=oookJP00:_oonfX5o`000?oo
oo]ZOooonfX8o`0008_ooo]Z000ZoookJPGo0000oooonfZ1oookJPOo0000R_oonfX002[ooo]Z1Ol0
003ooookJX?ooo]Z1_l00029oookJP00:_oonfX5o`000?oooo]ZQOoonfX5o`0008Sooo]Z000Zoook
JPGo0000oooonfZ6oookJPKo0000Q_oonfX002[ooo]Z1Ol0003ooookJXOooo]Z1ol00024oookJP00
:_oonfX5o`000?oooo]ZR?oonfX7o`0008?ooo]Z000ZoookJPGo0000oooonfZ:oookJPOo0000POoo
nfX002[ooo]Z1Ol0003ooookJX_ooo]Z1ol00020oookJP00:_oonfX5o`000?oooo]ZSOoonfX6o`00
07oooo]Z000ZoookJPGo0000oooonfZ?oookJPGo0000O_oonfX002[ooo]Z1Ol0003ooookJY3ooo]Z
1_l0001loookJP00:_oonfX5o`000?oooo]ZTOoonfX7o`0007[ooo]Z000ZoookJPGo0000oooonfZB
oookJPOo0000NOoonfX002[ooo]Z1Ol0003ooookJYCooo]Z1ol0001goookJP00:_oonfX5o`000?oo
oo]ZUOoonfX7o`0007Kooo]Z000ZoookJPGo0000oooonfZGoookJPKo0000MOoonfX002[ooo]Z1Ol0
003ooookJYWooo]Z1_l0001coookJP00:_oonfX5o`000?oooo]ZV_oonfX6o`0007;ooo]Z000Zoook
JPGo0000oooonfZKoookJPOo0000L?oonfX002[ooo]Z1Ol0003ooookJYgooo]Z1ol0001^oookJP00
:_oonfX5o`000?oooo]ZW_oonfX7o`0006gooo]Z000>oookJP?o001o1?oonfX3o`00O`Kooo]Z0ol0
07l9oookJPGo0000oooonfZOoookJPOo0000K?oonfX000kooo]Z0ol007l4oookJP?o001o1_oonfX3
o`00O`Wooo]Z1Ol0003ooookJZ;ooo]Z1Ol0001[oookJP003_oonfX3o`00O`Cooo]Z0ol007l6oook
JP?o001o2OoonfX5o`000?oooo]ZXooonfX6o`0006Wooo]Z000>oookJP?o001o2?oonfX9o`00O`So
oo]Z1Ol0003ooookJZCooo]Z1_l0001XoookJP003_oonfX3o`00O`Sooo]Z2Ol007l8oookJPKo0000
oooonfZToookJPKo0000IooonfX000kooo]Z0ol007l8oookJP;o001o0ooonfX3o`00O`Wooo]Z1Ol0
003ooookJZOooo]Z1ol0001ToookJP003_oonfX3o`00O`Wooo]Z0_l007l2oookJP?o001o2OoonfX5
o`000?oooo]ZZ?oonfX7o`0006?ooo]Z000>oookJP?o001o2OoonfX3o`00O`04oookJ_l007oo001o
o`00O`Wooo]Z1Ol0003ooookJZWooo]Z1ol0001RoookJP003_oonfX3o`00O`[ooo]Z0_l007l01?oo
nf[o001oo`00Ool007l9oookJPGo0000oooonfZZoookJPSo0000H?oonfX000_ooo]Z1_l007l;oook
JPGo001o2OoonfX5o`000?oooo]Z[OoonfX6o`0005oooo]Z000;oookJPKo001o2ooonfX5o`00O`Wo
oo]Z1Ol0003ooookJZkooo]Z1_l0001NoookJP003OoonfX4o`00O`cooo]Z1?l007l9oookJPGo0000
oooonfZ`oookJPGo0000GOoonfX000kooo]Z0ol007l=oookJP?o001o2OoonfX5o`000?oooo]Z/Ooo
nfX6o`0005_ooo]Z000ZoookJPGo0000oooonfZboookJPKo0000F_oonfX002[ooo]Z1Ol0003ooook
J[?ooo]Z1ol0001HoookJP00:_oonfX5o`000?oooo]Z]OoonfX7o`0005Kooo]Z000ZoookJPGo0000
oooonfZfoookJPOo0000EOoonfX002[ooo]Z1Ol0003ooookJ[Oooo]Z1ol0001DoookJP00:_oonfX5
o`000?oooo]Z^_oonfX5o`0005?ooo]Z000ZoookJPGo0000oooonfZkoookJPKo0000DOoonfX002[o
oo]Z1Ol0003ooookJ[cooo]Z1_l0001@oookJP00:_oonfX5o`000?oooo]Z_OoonfX6o`0004oooo]Z
000ZoookJPGo0000oooonfZooookJPKo0000COoonfX002[ooo]Z1Ol0003ooookJ/3ooo]Z1_l0001<
oookJP00:_oonfX5o`000?oooo]Z`OoonfX7o`0004[ooo]Z000ZoookJPGo0000oooonf[3oookJPOo
0000B?oonfX002[ooo]Z1Ol0003ooookJ/Cooo]Z1ol00017oookJP00:_oonfX5o`000?oooo]ZaOoo
nfX7o`0004Kooo]Z000ZoookJPGo0000oooonf[8oookJPGo0000AOoonfX002[ooo]Z1Ol0003ooook
J/Wooo]Z1_l00013oookJP00:_oonfX5o`000?oooo]Zb_oonfX6o`0004;ooo]Z000ZoookJPGo0000
oooonf[;oookJPKo0000@OoonfX002[ooo]Z1Ol0003ooookJ/gooo]Z1Ol00010oookJP00:_oonfX5
o`000?oooo]Zc_oonfX6o`0003kooo]Z000ZoookJPGo0000oooonf[?oookJPKo0000?OoonfX002[o
oo]Z1Ol0003ooookJ]3ooo]Z2?l0000joookJP00:_oonfX5o`000?oooo]Zd_oonfX7o`0003Wooo]Z
000ZoookJPGo0000oooonf[CoookJPOo0000>?oonfX002[ooo]Z1Ol0003ooookJ]Cooo]Z1ol0000g
oookJP00:_oonfX5o`000?oooo]ZeooonfX6o`0003Gooo]Z000ZoookJPGo0000oooonf[HoookJPKo
0000=?oonfX002[ooo]Z1Ol0003ooookJ]Wooo]Z1_l0000coookJP00:_oonfX5o`000?oooo]Zfooo
nfX5o`0003;ooo]Z000ZoookJPGo0000oooonf[LoookJPKo0000<?oonfX002[ooo]Z1Ol0003ooook
J]gooo]Z1_l0000_oookJP00:_oonfX5o`000?oooo]Zg_oonfX6o`0002kooo]Z000ZoookJPGo0000
oooonf[PoookJPGo0000;OoonfX002[ooo]Z1Ol0003ooookJ^7ooo]Z1_l0000[oookJP00:_oonfX5
o`000?oooo]Zh_oonfX7o`0002Wooo]Z000ZoookJPGo0000oooonf[SoookJPOo0000:?oonfX002[o
oo]Z1Ol0003ooookJ^Gooo]Z1ol0000VoookJP00:_oonfX5o`000?oooo]Zi_oonfX7o`0002Gooo]Z
000ZoookJPGo0000oooonf[XoookJPKo00009?oonfX002[ooo]Z1Ol0003ooookJ^[ooo]Z1_l0000R
oookJP00:_oonfX5o`000?oooo]ZjooonfX6o`00027ooo]Z000ZoookJPGo0000oooonf[/oookJPKo
00008?oonfX002[ooo]Z1Ol0003ooookJ^kooo]Z1Ol0000OoookJP00:_oonfX5o`000?oooo]Zkooo
nfX6o`0001gooo]Z000ZoookJPGo0000oooonf[`oookJPKo00007?oonfX002[ooo]Z1Ol0003ooook
J_7ooo]Z1_l0000KoookJP00:_oonfX5o`000?oooo]ZlooonfX5o`0001[ooo]Z000ZoookJPGo0000
oooonf[doookJPKo00006?oonfX002[ooo]Z1Ol0003ooookJ_Gooo]Z1_l0000GoookJP003_oonfX3
o`00O`Cooo]Z0ol007l3oookJPGo001o2_oonfX5o`000?oooo]Zm_oonfX5o`0001Oooo]Z000>oook
JP?o001o1?oonfX3o`00O`;ooo]Z1ol007l9oookJPGo0000oooonf[hoookJP;o00006?oonfX000ko
oo]Z0ol007l4oookJP?o001o00?ooo]Zo`00Ool007l00_l007l01?oonf[o001oo`00Ool007l9oook
JPGo0000oooonf[ooookJQ?ooo]Z000>oookJP?o001o2?oonfX3o`00O`?ooo]Z0ol007l8oookJPGo
0000oooonf[ooookJQ?ooo]Z000>oookJP?o001o3_oonfX3o`00O`Sooo]Z1_l0003ooookJ_oooo]Z
4_oonfX000kooo]Z0ol007l>oookJP?o001o2?oonfX5o`000?oooo]ZoooonfXCoookJP003_oonfX3
o`00O`Wooo]Z0_l007l2oookJPCo001o2?oonfX5o`000?oooo]ZoooonfXCoookJP003_oonfX3o`00
O`Wooo]Z1ol007l9oookJPGo0000oooonf[ooookJQ?ooo]Z000>oookJP?o001o2OoonfX6o`00O`[o
oo]Z1Ol0003ooookJ_oooo]Z4ooonfX000_ooo]Z1_l007l9oookJP;o001o3_oonfX5o`000?oooo]Z
oooonfXCoookJP002ooonfX6o`00O`Wooo]Z0_l007oooookJ_oooo]Z9_oonfX000gooo]Z1?l007l:
oookJPOo001ooooonf[ooookJR3ooo]Z000>oookJP?o001o2_oonfX7o`00Oooooo]ZoooonfXPoook
JP00oooonf[ooookJT;ooo]Z003ooookJ_oooo]Z@_oonfX00001\
\>"],
  ImageRangeCache->{{{0, 575}, {354.938, 0}} -> {-0.3518, 0.958149, \
0.00790084, 0.0015709}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[{
    \(\(DisplayLater\  = \ 
        DisplayFunction \[Rule] Identity;\)\), "\[IndentingNewLine]", 
    \(\(DisplayNow\  = \ 
        DisplayFunction \[Rule] $DisplayFunction;\)\)}], "Input",
  CellTags->"mmtag:19:DisplayNow_DisplayLater__example"],

Cell[BoxData[
    \(\(lp[i_]\  := 
        ListPlot[NestList[StepOnce[#, exampleFunction, 0.01] &, {0, i}, 400], 
          DisplayLater];\)\)], "Input"],

Cell["\<\
This will plot a family of related curves, each for a different \
starting value of the iterated function:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[Table[lp[i], {i, \(-4\), 4,  .5}], DisplayNow]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.238095 0.309017 0.049329 [
[.2619 .29652 -7 -20 ]
[.2619 .29652 7 0 ]
[.5 .29652 -7 -20 ]
[.5 .29652 7 0 ]
[.7381 .29652 -7 -20 ]
[.7381 .29652 7 0 ]
[.97619 .29652 -7 -20 ]
[.97619 .29652 7 0 ]
[.01131 .01304 -26.9375 -10 ]
[.01131 .01304 0 10 ]
[.01131 .1117 -26.9375 -10 ]
[.01131 .1117 0 10 ]
[.01131 .21036 -26.9375 -10 ]
[.01131 .21036 0 10 ]
[.01131 .40767 -14 -10 ]
[.01131 .40767 0 10 ]
[.01131 .50633 -14 -10 ]
[.01131 .50633 0 10 ]
[.01131 .60499 -14 -10 ]
[.01131 .60499 0 10 ]
[ -0.005 -0.005 0 0 ]
[ 1.005 .62303 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .30902 m
.2619 .31527 L
s
gsave
.2619 .29652 -68 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.5 .30902 m
.5 .31527 L
s
gsave
.5 .29652 -68 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.7381 .30902 m
.7381 .31527 L
s
gsave
.7381 .29652 -68 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(3) show
1.000 setlinewidth
grestore
.97619 .30902 m
.97619 .31527 L
s
gsave
.97619 .29652 -68 -24 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(4) show
1.000 setlinewidth
grestore
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.01 w
0 .30902 m
1 .30902 L
s
.25 Mabswid
.02381 .01304 m
.03006 .01304 L
s
gsave
.01131 .01304 -87.9375 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Mathematica1-Bold
%%IncludeFont: Mathematica1-Bold
/Mathematica1-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(-) show
75.938 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(6) show
1.000 setlinewidth
grestore
.02381 .1117 m
.03006 .1117 L
s
gsave
.01131 .1117 -87.9375 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Mathematica1-Bold
%%IncludeFont: Mathematica1-Bold
/Mathematica1-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(-) show
75.938 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(4) show
1.000 setlinewidth
grestore
.02381 .21036 m
.03006 .21036 L
s
gsave
.01131 .21036 -87.9375 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Mathematica1-Bold
%%IncludeFont: Mathematica1-Bold
/Mathematica1-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(-) show
75.938 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.02381 .40767 m
.03006 .40767 L
s
gsave
.01131 .40767 -75 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.02381 .50633 m
.03006 .50633 L
s
gsave
.01131 .50633 -75 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(4) show
1.000 setlinewidth
grestore
.02381 .60499 m
.03006 .60499 L
s
gsave
.01131 .60499 -75 -14 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 28 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 19.000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 18.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.500 setrgbcolor
(6) show
1.000 setlinewidth
grestore
.125 Mabswid
.02381 .03771 m
.02756 .03771 L
s
.02381 .06237 m
.02756 .06237 L
s
.02381 .08704 m
.02756 .08704 L
s
.02381 .13637 m
.02756 .13637 L
s
.02381 .16103 m
.02756 .16103 L
s
.02381 .18569 m
.02756 .18569 L
s
.02381 .23502 m
.02756 .23502 L
s
.02381 .25969 m
.02756 .25969 L
s
.02381 .28435 m
.02756 .28435 L
s
.02381 .33368 m
.02756 .33368 L
s
.02381 .35835 m
.02756 .35835 L
s
.02381 .38301 m
.02756 .38301 L
s
.02381 .43234 m
.02756 .43234 L
s
.02381 .457 m
.02756 .457 L
s
.02381 .48167 m
.02756 .48167 L
s
.02381 .531 m
.02756 .531 L
s
.02381 .55566 m
.02756 .55566 L
s
.02381 .58033 m
.02756 .58033 L
s
.01 w
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02381 .1117 Mdot
.02619 .1115 Mdot
.02857 .11131 Mdot
.03095 .11111 Mdot
.03333 .11091 Mdot
.03571 .11071 Mdot
.0381 .11051 Mdot
.04048 .11032 Mdot
.04286 .11012 Mdot
.04524 .10992 Mdot
.04762 .10972 Mdot
.05 .10952 Mdot
.05238 .10932 Mdot
.05476 .10912 Mdot
.05714 .10892 Mdot
.05952 .10872 Mdot
.0619 .10852 Mdot
.06429 .10832 Mdot
.06667 .10812 Mdot
.06905 .10792 Mdot
.07143 .10772 Mdot
.07381 .10752 Mdot
.07619 .10731 Mdot
.07857 .10711 Mdot
.08095 .10691 Mdot
.08333 .10671 Mdot
.08571 .10651 Mdot
.0881 .1063 Mdot
.09048 .1061 Mdot
.09286 .1059 Mdot
.09524 .10569 Mdot
.09762 .10549 Mdot
.1 .10529 Mdot
.10238 .10508 Mdot
.10476 .10488 Mdot
.10714 .10468 Mdot
.10952 .10447 Mdot
.1119 .10427 Mdot
.11429 .10406 Mdot
.11667 .10386 Mdot
.11905 .10365 Mdot
.12143 .10345 Mdot
.12381 .10324 Mdot
.12619 .10304 Mdot
.12857 .10283 Mdot
.13095 .10262 Mdot
.13333 .10242 Mdot
.13571 .10221 Mdot
.1381 .102 Mdot
.14048 .1018 Mdot
.14286 .10159 Mdot
.14524 .10138 Mdot
.14762 .10117 Mdot
.15 .10097 Mdot
.15238 .10076 Mdot
.15476 .10055 Mdot
.15714 .10034 Mdot
.15952 .10013 Mdot
.1619 .09992 Mdot
.16429 .09972 Mdot
.16667 .09951 Mdot
.16905 .0993 Mdot
.17143 .09909 Mdot
.17381 .09888 Mdot
.17619 .09867 Mdot
.17857 .09846 Mdot
.18095 .09825 Mdot
.18333 .09804 Mdot
.18571 .09782 Mdot
.1881 .09761 Mdot
.19048 .0974 Mdot
.19286 .09719 Mdot
.19524 .09698 Mdot
.19762 .09677 Mdot
.2 .09655 Mdot
.20238 .09634 Mdot
.20476 .09613 Mdot
.20714 .09592 Mdot
.20952 .0957 Mdot
.2119 .09549 Mdot
.21429 .09528 Mdot
.21667 .09506 Mdot
.21905 .09485 Mdot
.22143 .09463 Mdot
.22381 .09442 Mdot
.22619 .0942 Mdot
.22857 .09399 Mdot
.23095 .09378 Mdot
.23333 .09356 Mdot
.23571 .09334 Mdot
.2381 .09313 Mdot
.24048 .09291 Mdot
.24286 .0927 Mdot
.24524 .09248 Mdot
.24762 .09226 Mdot
.25 .09205 Mdot
.25238 .09183 Mdot
.25476 .09161 Mdot
.25714 .0914 Mdot
.25952 .09118 Mdot
.2619 .09096 Mdot
.26429 .09074 Mdot
.26667 .09052 Mdot
.26905 .09031 Mdot
.27143 .09009 Mdot
.27381 .08987 Mdot
.27619 .08965 Mdot
.27857 .08943 Mdot
.28095 .08921 Mdot
.28333 .08899 Mdot
.28571 .08877 Mdot
.2881 .08855 Mdot
.29048 .08833 Mdot
.29286 .08811 Mdot
.29524 .08789 Mdot
.29762 .08767 Mdot
.3 .08744 Mdot
.30238 .08722 Mdot
.30476 .087 Mdot
.30714 .08678 Mdot
.30952 .08656 Mdot
.3119 .08633 Mdot
.31429 .08611 Mdot
.31667 .08589 Mdot
.31905 .08567 Mdot
.32143 .08544 Mdot
.32381 .08522 Mdot
.32619 .085 Mdot
.32857 .08477 Mdot
.33095 .08455 Mdot
.33333 .08432 Mdot
.33571 .0841 Mdot
.3381 .08387 Mdot
.34048 .08365 Mdot
.34286 .08342 Mdot
.34524 .0832 Mdot
.34762 .08297 Mdot
.35 .08275 Mdot
.35238 .08252 Mdot
.35476 .08229 Mdot
.35714 .08207 Mdot
.35952 .08184 Mdot
.3619 .08161 Mdot
.36429 .08138 Mdot
.36667 .08116 Mdot
.36905 .08093 Mdot
.37143 .0807 Mdot
.37381 .08047 Mdot
.37619 .08024 Mdot
.37857 .08001 Mdot
.38095 .07979 Mdot
.38333 .07956 Mdot
.38571 .07933 Mdot
.3881 .0791 Mdot
.39048 .07887 Mdot
.39286 .07864 Mdot
.39524 .07841 Mdot
.39762 .07818 Mdot
.4 .07795 Mdot
.40238 .07771 Mdot
.40476 .07748 Mdot
.40714 .07725 Mdot
.40952 .07702 Mdot
.4119 .07679 Mdot
.41429 .07656 Mdot
.41667 .07632 Mdot
.41905 .07609 Mdot
.42143 .07586 Mdot
.42381 .07562 Mdot
.42619 .07539 Mdot
.42857 .07516 Mdot
.43095 .07492 Mdot
.43333 .07469 Mdot
.43571 .07446 Mdot
.4381 .07422 Mdot
.44048 .07399 Mdot
.44286 .07375 Mdot
.44524 .07352 Mdot
.44762 .07328 Mdot
.45 .07304 Mdot
.45238 .07281 Mdot
.45476 .07257 Mdot
.45714 .07234 Mdot
.45952 .0721 Mdot
.4619 .07186 Mdot
.46429 .07162 Mdot
.46667 .07139 Mdot
.46905 .07115 Mdot
.47143 .07091 Mdot
.47381 .07067 Mdot
.47619 .07044 Mdot
.47857 .0702 Mdot
.48095 .06996 Mdot
.48333 .06972 Mdot
.48571 .06948 Mdot
.4881 .06924 Mdot
.49048 .069 Mdot
.49286 .06876 Mdot
.49524 .06852 Mdot
.49762 .06828 Mdot
.5 .06804 Mdot
.50238 .0678 Mdot
.50476 .06756 Mdot
.50714 .06732 Mdot
.50952 .06707 Mdot
.5119 .06683 Mdot
.51429 .06659 Mdot
.51667 .06635 Mdot
.51905 .0661 Mdot
.52143 .06586 Mdot
.52381 .06562 Mdot
.52619 .06537 Mdot
.52857 .06513 Mdot
.53095 .06489 Mdot
.53333 .06464 Mdot
.53571 .0644 Mdot
.5381 .06415 Mdot
.54048 .06391 Mdot
.54286 .06366 Mdot
.54524 .06342 Mdot
.54762 .06317 Mdot
.55 .06293 Mdot
.55238 .06268 Mdot
.55476 .06244 Mdot
.55714 .06219 Mdot
.55952 .06194 Mdot
.5619 .06169 Mdot
.56429 .06145 Mdot
.56667 .0612 Mdot
.56905 .06095 Mdot
.57143 .0607 Mdot
.57381 .06046 Mdot
.57619 .06021 Mdot
.57857 .05996 Mdot
.58095 .05971 Mdot
.58333 .05946 Mdot
.58571 .05921 Mdot
.5881 .05896 Mdot
.59048 .05871 Mdot
.59286 .05846 Mdot
.59524 .05821 Mdot
.59762 .05796 Mdot
.6 .05771 Mdot
.60238 .05746 Mdot
.60476 .0572 Mdot
.60714 .05695 Mdot
.60952 .0567 Mdot
.6119 .05645 Mdot
.61429 .0562 Mdot
.61667 .05594 Mdot
.61905 .05569 Mdot
.62143 .05544 Mdot
.62381 .05518 Mdot
.62619 .05493 Mdot
.62857 .05468 Mdot
.63095 .05442 Mdot
.63333 .05417 Mdot
.63571 .05391 Mdot
.6381 .05366 Mdot
.64048 .0534 Mdot
.64286 .05315 Mdot
.64524 .05289 Mdot
.64762 .05263 Mdot
.65 .05238 Mdot
.65238 .05212 Mdot
.65476 .05186 Mdot
.65714 .05161 Mdot
.65952 .05135 Mdot
.6619 .05109 Mdot
.66429 .05083 Mdot
.66667 .05058 Mdot
.66905 .05032 Mdot
.67143 .05006 Mdot
.67381 .0498 Mdot
.67619 .04954 Mdot
.67857 .04928 Mdot
.68095 .04902 Mdot
.68333 .04876 Mdot
.68571 .0485 Mdot
.6881 .04824 Mdot
.69048 .04798 Mdot
.69286 .04772 Mdot
.69524 .04746 Mdot
.69762 .0472 Mdot
.7 .04693 Mdot
.70238 .04667 Mdot
.70476 .04641 Mdot
.70714 .04615 Mdot
.70952 .04588 Mdot
.7119 .04562 Mdot
.71429 .04536 Mdot
.71667 .04509 Mdot
.71905 .04483 Mdot
.72143 .04457 Mdot
.72381 .0443 Mdot
.72619 .04404 Mdot
.72857 .04377 Mdot
.73095 .04351 Mdot
.73333 .04324 Mdot
.73571 .04297 Mdot
.7381 .04271 Mdot
.74048 .04244 Mdot
.74286 .04218 Mdot
.74524 .04191 Mdot
.74762 .04164 Mdot
.75 .04137 Mdot
.75238 .04111 Mdot
.75476 .04084 Mdot
.75714 .04057 Mdot
.75952 .0403 Mdot
.7619 .04003 Mdot
.76429 .03976 Mdot
.76667 .03949 Mdot
.76905 .03923 Mdot
.77143 .03896 Mdot
.77381 .03869 Mdot
.77619 .03842 Mdot
.77857 .03814 Mdot
.78095 .03787 Mdot
.78333 .0376 Mdot
.78571 .03733 Mdot
.7881 .03706 Mdot
.79048 .03679 Mdot
.79286 .03652 Mdot
.79524 .03624 Mdot
.79762 .03597 Mdot
.8 .0357 Mdot
.80238 .03542 Mdot
.80476 .03515 Mdot
.80714 .03488 Mdot
.80952 .0346 Mdot
.8119 .03433 Mdot
.81429 .03405 Mdot
.81667 .03378 Mdot
.81905 .0335 Mdot
.82143 .03323 Mdot
.82381 .03295 Mdot
.82619 .03268 Mdot
.82857 .0324 Mdot
.83095 .03212 Mdot
.83333 .03185 Mdot
.83571 .03157 Mdot
.8381 .03129 Mdot
.84048 .03101 Mdot
.84286 .03074 Mdot
.84524 .03046 Mdot
.84762 .03018 Mdot
.85 .0299 Mdot
.85238 .02962 Mdot
.85476 .02934 Mdot
.85714 .02906 Mdot
.85952 .02878 Mdot
.8619 .0285 Mdot
.86429 .02822 Mdot
.86667 .02794 Mdot
.86905 .02766 Mdot
.87143 .02738 Mdot
.87381 .0271 Mdot
.87619 .02681 Mdot
.87857 .02653 Mdot
.88095 .02625 Mdot
.88333 .02597 Mdot
.88571 .02568 Mdot
.8881 .0254 Mdot
.89048 .02512 Mdot
.89286 .02483 Mdot
.89524 .02455 Mdot
.89762 .02426 Mdot
.9 .02398 Mdot
.90238 .02369 Mdot
.90476 .02341 Mdot
.90714 .02312 Mdot
.90952 .02284 Mdot
.9119 .02255 Mdot
.91429 .02226 Mdot
.91667 .02198 Mdot
.91905 .02169 Mdot
.92143 .0214 Mdot
.92381 .02112 Mdot
.92619 .02083 Mdot
.92857 .02054 Mdot
.93095 .02025 Mdot
.93333 .01996 Mdot
.93571 .01967 Mdot
.9381 .01938 Mdot
.94048 .01909 Mdot
.94286 .0188 Mdot
.94524 .01851 Mdot
.94762 .01822 Mdot
.95 .01793 Mdot
.95238 .01764 Mdot
.95476 .01735 Mdot
.95714 .01706 Mdot
.95952 .01677 Mdot
.9619 .01647 Mdot
.96429 .01618 Mdot
.96667 .01589 Mdot
.96905 .0156 Mdot
.97143 .0153 Mdot
.97381 .01501 Mdot
.97619 .01472 Mdot
.02381 .13637 Mdot
.02619 .13619 Mdot
.02857 .13602 Mdot
.03095 .13585 Mdot
.03333 .13567 Mdot
.03571 .1355 Mdot
.0381 .13533 Mdot
.04048 .13515 Mdot
.04286 .13498 Mdot
.04524 .13481 Mdot
.04762 .13463 Mdot
.05 .13446 Mdot
.05238 .13428 Mdot
.05476 .13411 Mdot
.05714 .13393 Mdot
.05952 .13376 Mdot
.0619 .13358 Mdot
.06429 .13341 Mdot
.06667 .13323 Mdot
.06905 .13306 Mdot
.07143 .13288 Mdot
.07381 .1327 Mdot
.07619 .13253 Mdot
.07857 .13235 Mdot
.08095 .13217 Mdot
.08333 .132 Mdot
.08571 .13182 Mdot
.0881 .13164 Mdot
.09048 .13147 Mdot
.09286 .13129 Mdot
.09524 .13111 Mdot
.09762 .13093 Mdot
.1 .13075 Mdot
.10238 .13058 Mdot
.10476 .1304 Mdot
.10714 .13022 Mdot
.10952 .13004 Mdot
.1119 .12986 Mdot
.11429 .12968 Mdot
.11667 .1295 Mdot
.11905 .12932 Mdot
.12143 .12914 Mdot
.12381 .12896 Mdot
.12619 .12878 Mdot
.12857 .1286 Mdot
.13095 .12842 Mdot
.13333 .12824 Mdot
.13571 .12806 Mdot
.1381 .12788 Mdot
.14048 .1277 Mdot
.14286 .12752 Mdot
.14524 .12734 Mdot
.14762 .12715 Mdot
.15 .12697 Mdot
.15238 .12679 Mdot
.15476 .12661 Mdot
.15714 .12643 Mdot
.15952 .12624 Mdot
.1619 .12606 Mdot
.16429 .12588 Mdot
.16667 .12569 Mdot
.16905 .12551 Mdot
.17143 .12533 Mdot
.17381 .12514 Mdot
.17619 .12496 Mdot
.17857 .12478 Mdot
.18095 .12459 Mdot
.18333 .12441 Mdot
.18571 .12422 Mdot
.1881 .12404 Mdot
.19048 .12385 Mdot
.19286 .12367 Mdot
.19524 .12348 Mdot
.19762 .1233 Mdot
.2 .12311 Mdot
.20238 .12293 Mdot
.20476 .12274 Mdot
.20714 .12255 Mdot
.20952 .12237 Mdot
.2119 .12218 Mdot
.21429 .12199 Mdot
.21667 .12181 Mdot
.21905 .12162 Mdot
.22143 .12143 Mdot
.22381 .12124 Mdot
.22619 .12106 Mdot
.22857 .12087 Mdot
.23095 .12068 Mdot
.23333 .12049 Mdot
.23571 .1203 Mdot
.2381 .12011 Mdot
.24048 .11993 Mdot
.24286 .11974 Mdot
.24524 .11955 Mdot
.24762 .11936 Mdot
.25 .11917 Mdot
.25238 .11898 Mdot
.25476 .11879 Mdot
.25714 .1186 Mdot
.25952 .11841 Mdot
.2619 .11822 Mdot
.26429 .11803 Mdot
.26667 .11784 Mdot
.26905 .11764 Mdot
.27143 .11745 Mdot
.27381 .11726 Mdot
.27619 .11707 Mdot
.27857 .11688 Mdot
.28095 .11669 Mdot
.28333 .11649 Mdot
.28571 .1163 Mdot
.2881 .11611 Mdot
.29048 .11591 Mdot
.29286 .11572 Mdot
.29524 .11553 Mdot
.29762 .11534 Mdot
.3 .11514 Mdot
.30238 .11495 Mdot
.30476 .11475 Mdot
.30714 .11456 Mdot
.30952 .11436 Mdot
.3119 .11417 Mdot
.31429 .11398 Mdot
.31667 .11378 Mdot
.31905 .11358 Mdot
.32143 .11339 Mdot
.32381 .11319 Mdot
.32619 .113 Mdot
.32857 .1128 Mdot
.33095 .11261 Mdot
.33333 .11241 Mdot
.33571 .11221 Mdot
.3381 .11202 Mdot
.34048 .11182 Mdot
.34286 .11162 Mdot
.34524 .11142 Mdot
.34762 .11123 Mdot
.35 .11103 Mdot
.35238 .11083 Mdot
.35476 .11063 Mdot
.35714 .11043 Mdot
.35952 .11024 Mdot
.3619 .11004 Mdot
.36429 .10984 Mdot
.36667 .10964 Mdot
.36905 .10944 Mdot
.37143 .10924 Mdot
.37381 .10904 Mdot
.37619 .10884 Mdot
.37857 .10864 Mdot
.38095 .10844 Mdot
.38333 .10824 Mdot
.38571 .10804 Mdot
.3881 .10784 Mdot
.39048 .10764 Mdot
.39286 .10743 Mdot
.39524 .10723 Mdot
.39762 .10703 Mdot
.4 .10683 Mdot
.40238 .10663 Mdot
.40476 .10642 Mdot
.40714 .10622 Mdot
.40952 .10602 Mdot
.4119 .10582 Mdot
.41429 .10561 Mdot
.41667 .10541 Mdot
.41905 .10521 Mdot
.42143 .105 Mdot
.42381 .1048 Mdot
.42619 .10459 Mdot
.42857 .10439 Mdot
.43095 .10419 Mdot
.43333 .10398 Mdot
.43571 .10378 Mdot
.4381 .10357 Mdot
.44048 .10336 Mdot
.44286 .10316 Mdot
.44524 .10295 Mdot
.44762 .10275 Mdot
.45 .10254 Mdot
.45238 .10233 Mdot
.45476 .10213 Mdot
.45714 .10192 Mdot
.45952 .10171 Mdot
.4619 .10151 Mdot
.46429 .1013 Mdot
.46667 .10109 Mdot
.46905 .10088 Mdot
.47143 .10068 Mdot
.47381 .10047 Mdot
.47619 .10026 Mdot
.47857 .10005 Mdot
.48095 .09984 Mdot
.48333 .09963 Mdot
.48571 .09942 Mdot
.4881 .09921 Mdot
.49048 .099 Mdot
.49286 .09879 Mdot
.49524 .09858 Mdot
.49762 .09837 Mdot
.5 .09816 Mdot
.50238 .09795 Mdot
.50476 .09774 Mdot
.50714 .09753 Mdot
.50952 .09732 Mdot
.5119 .0971 Mdot
.51429 .09689 Mdot
.51667 .09668 Mdot
.51905 .09647 Mdot
.52143 .09626 Mdot
.52381 .09604 Mdot
.52619 .09583 Mdot
.52857 .09562 Mdot
.53095 .0954 Mdot
.53333 .09519 Mdot
.53571 .09498 Mdot
.5381 .09476 Mdot
.54048 .09455 Mdot
.54286 .09433 Mdot
.54524 .09412 Mdot
.54762 .0939 Mdot
.55 .09369 Mdot
.55238 .09347 Mdot
.55476 .09326 Mdot
.55714 .09304 Mdot
.55952 .09283 Mdot
.5619 .09261 Mdot
.56429 .09239 Mdot
.56667 .09218 Mdot
.56905 .09196 Mdot
.57143 .09174 Mdot
.57381 .09153 Mdot
.57619 .09131 Mdot
.57857 .09109 Mdot
.58095 .09087 Mdot
.58333 .09065 Mdot
.58571 .09044 Mdot
.5881 .09022 Mdot
.59048 .09 Mdot
.59286 .08978 Mdot
.59524 .08956 Mdot
.59762 .08934 Mdot
.6 .08912 Mdot
.60238 .0889 Mdot
.60476 .08868 Mdot
.60714 .08846 Mdot
.60952 .08824 Mdot
.6119 .08802 Mdot
.61429 .0878 Mdot
.61667 .08758 Mdot
.61905 .08736 Mdot
.62143 .08713 Mdot
.62381 .08691 Mdot
.62619 .08669 Mdot
.62857 .08647 Mdot
.63095 .08625 Mdot
.63333 .08602 Mdot
.63571 .0858 Mdot
.6381 .08558 Mdot
.64048 .08535 Mdot
.64286 .08513 Mdot
.64524 .08491 Mdot
.64762 .08468 Mdot
.65 .08446 Mdot
.65238 .08423 Mdot
.65476 .08401 Mdot
.65714 .08378 Mdot
.65952 .08356 Mdot
.6619 .08333 Mdot
.66429 .08311 Mdot
.66667 .08288 Mdot
.66905 .08265 Mdot
.67143 .08243 Mdot
.67381 .0822 Mdot
.67619 .08197 Mdot
.67857 .08175 Mdot
.68095 .08152 Mdot
.68333 .08129 Mdot
.68571 .08106 Mdot
.6881 .08084 Mdot
.69048 .08061 Mdot
.69286 .08038 Mdot
.69524 .08015 Mdot
.69762 .07992 Mdot
.7 .07969 Mdot
.70238 .07946 Mdot
.70476 .07923 Mdot
.70714 .07901 Mdot
.70952 .07878 Mdot
.7119 .07854 Mdot
.71429 .07831 Mdot
.71667 .07808 Mdot
.71905 .07785 Mdot
.72143 .07762 Mdot
.72381 .07739 Mdot
.72619 .07716 Mdot
.72857 .07693 Mdot
.73095 .07669 Mdot
.73333 .07646 Mdot
.73571 .07623 Mdot
.7381 .076 Mdot
.74048 .07576 Mdot
.74286 .07553 Mdot
.74524 .0753 Mdot
.74762 .07506 Mdot
.75 .07483 Mdot
.75238 .0746 Mdot
.75476 .07436 Mdot
.75714 .07413 Mdot
.75952 .07389 Mdot
.7619 .07366 Mdot
.76429 .07342 Mdot
.76667 .07319 Mdot
.76905 .07295 Mdot
.77143 .07271 Mdot
.77381 .07248 Mdot
.77619 .07224 Mdot
.77857 .072 Mdot
.78095 .07177 Mdot
.78333 .07153 Mdot
.78571 .07129 Mdot
.7881 .07105 Mdot
.79048 .07082 Mdot
.79286 .07058 Mdot
.79524 .07034 Mdot
.79762 .0701 Mdot
.8 .06986 Mdot
.80238 .06962 Mdot
.80476 .06938 Mdot
.80714 .06914 Mdot
.80952 .0689 Mdot
.8119 .06866 Mdot
.81429 .06842 Mdot
.81667 .06818 Mdot
.81905 .06794 Mdot
.82143 .0677 Mdot
.82381 .06746 Mdot
.82619 .06722 Mdot
.82857 .06698 Mdot
.83095 .06673 Mdot
.83333 .06649 Mdot
.83571 .06625 Mdot
.8381 .06601 Mdot
.84048 .06576 Mdot
.84286 .06552 Mdot
.84524 .06528 Mdot
.84762 .06503 Mdot
.85 .06479 Mdot
.85238 .06455 Mdot
.85476 .0643 Mdot
.85714 .06406 Mdot
.85952 .06381 Mdot
.8619 .06357 Mdot
.86429 .06332 Mdot
.86667 .06307 Mdot
.86905 .06283 Mdot
.87143 .06258 Mdot
.87381 .06234 Mdot
.87619 .06209 Mdot
.87857 .06184 Mdot
.88095 .0616 Mdot
.88333 .06135 Mdot
.88571 .0611 Mdot
.8881 .06085 Mdot
.89048 .0606 Mdot
.89286 .06036 Mdot
.89524 .06011 Mdot
.89762 .05986 Mdot
.9 .05961 Mdot
.90238 .05936 Mdot
.90476 .05911 Mdot
.90714 .05886 Mdot
.90952 .05861 Mdot
.9119 .05836 Mdot
.91429 .05811 Mdot
.91667 .05786 Mdot
.91905 .05761 Mdot
.92143 .05736 Mdot
.92381 .0571 Mdot
.92619 .05685 Mdot
.92857 .0566 Mdot
.93095 .05635 Mdot
.93333 .05609 Mdot
.93571 .05584 Mdot
.9381 .05559 Mdot
.94048 .05533 Mdot
.94286 .05508 Mdot
.94524 .05483 Mdot
.94762 .05457 Mdot
.95 .05432 Mdot
.95238 .05406 Mdot
.95476 .05381 Mdot
.95714 .05355 Mdot
.95952 .0533 Mdot
.9619 .05304 Mdot
.96429 .05279 Mdot
.96667 .05253 Mdot
.96905 .05227 Mdot
.97143 .05202 Mdot
.97381 .05176 Mdot
.97619 .0515 Mdot
.02381 .16103 Mdot
.02619 .16088 Mdot
.02857 .16073 Mdot
.03095 .16059 Mdot
.03333 .16044 Mdot
.03571 .16029 Mdot
.0381 .16014 Mdot
.04048 .15999 Mdot
.04286 .15984 Mdot
.04524 .15969 Mdot
.04762 .15954 Mdot
.05 .15939 Mdot
.05238 .15924 Mdot
.05476 .15909 Mdot
.05714 .15894 Mdot
.05952 .15879 Mdot
.0619 .15864 Mdot
.06429 .15849 Mdot
.06667 .15834 Mdot
.06905 .15819 Mdot
.07143 .15804 Mdot
.07381 .15789 Mdot
.07619 .15774 Mdot
.07857 .15759 Mdot
.08095 .15744 Mdot
.08333 .15729 Mdot
.08571 .15713 Mdot
.0881 .15698 Mdot
.09048 .15683 Mdot
.09286 .15668 Mdot
.09524 .15653 Mdot
.09762 .15637 Mdot
.1 .15622 Mdot
.10238 .15607 Mdot
.10476 .15591 Mdot
.10714 .15576 Mdot
.10952 .15561 Mdot
.1119 .15545 Mdot
.11429 .1553 Mdot
.11667 .15515 Mdot
.11905 .15499 Mdot
.12143 .15484 Mdot
.12381 .15469 Mdot
.12619 .15453 Mdot
.12857 .15438 Mdot
.13095 .15422 Mdot
.13333 .15407 Mdot
.13571 .15391 Mdot
.1381 .15376 Mdot
.14048 .1536 Mdot
.14286 .15345 Mdot
.14524 .15329 Mdot
.14762 .15314 Mdot
.15 .15298 Mdot
.15238 .15282 Mdot
.15476 .15267 Mdot
.15714 .15251 Mdot
.15952 .15235 Mdot
.1619 .1522 Mdot
.16429 .15204 Mdot
.16667 .15188 Mdot
.16905 .15173 Mdot
.17143 .15157 Mdot
.17381 .15141 Mdot
.17619 .15125 Mdot
.17857 .1511 Mdot
.18095 .15094 Mdot
.18333 .15078 Mdot
.18571 .15062 Mdot
.1881 .15046 Mdot
.19048 .15031 Mdot
.19286 .15015 Mdot
.19524 .14999 Mdot
.19762 .14983 Mdot
.2 .14967 Mdot
.20238 .14951 Mdot
.20476 .14935 Mdot
.20714 .14919 Mdot
.20952 .14903 Mdot
.2119 .14887 Mdot
.21429 .14871 Mdot
.21667 .14855 Mdot
.21905 .14839 Mdot
.22143 .14823 Mdot
.22381 .14807 Mdot
.22619 .14791 Mdot
.22857 .14775 Mdot
.23095 .14759 Mdot
.23333 .14742 Mdot
.23571 .14726 Mdot
.2381 .1471 Mdot
.24048 .14694 Mdot
.24286 .14678 Mdot
.24524 .14661 Mdot
.24762 .14645 Mdot
.25 .14629 Mdot
.25238 .14613 Mdot
.25476 .14596 Mdot
.25714 .1458 Mdot
.25952 .14564 Mdot
.2619 .14547 Mdot
.26429 .14531 Mdot
.26667 .14515 Mdot
.26905 .14498 Mdot
.27143 .14482 Mdot
.27381 .14465 Mdot
.27619 .14449 Mdot
.27857 .14433 Mdot
.28095 .14416 Mdot
.28333 .144 Mdot
.28571 .14383 Mdot
.2881 .14367 Mdot
.29048 .1435 Mdot
.29286 .14334 Mdot
.29524 .14317 Mdot
.29762 .143 Mdot
.3 .14284 Mdot
.30238 .14267 Mdot
.30476 .14251 Mdot
.30714 .14234 Mdot
.30952 .14217 Mdot
.3119 .14201 Mdot
.31429 .14184 Mdot
.31667 .14167 Mdot
.31905 .1415 Mdot
.32143 .14134 Mdot
.32381 .14117 Mdot
.32619 .141 Mdot
.32857 .14083 Mdot
.33095 .14066 Mdot
.33333 .1405 Mdot
.33571 .14033 Mdot
.3381 .14016 Mdot
.34048 .13999 Mdot
.34286 .13982 Mdot
.34524 .13965 Mdot
.34762 .13948 Mdot
.35 .13931 Mdot
.35238 .13914 Mdot
.35476 .13897 Mdot
.35714 .1388 Mdot
.35952 .13863 Mdot
.3619 .13846 Mdot
.36429 .13829 Mdot
.36667 .13812 Mdot
.36905 .13795 Mdot
.37143 .13778 Mdot
.37381 .13761 Mdot
.37619 .13744 Mdot
.37857 .13727 Mdot
.38095 .13709 Mdot
.38333 .13692 Mdot
.38571 .13675 Mdot
.3881 .13658 Mdot
.39048 .1364 Mdot
.39286 .13623 Mdot
.39524 .13606 Mdot
.39762 .13589 Mdot
.4 .13571 Mdot
.40238 .13554 Mdot
.40476 .13537 Mdot
.40714 .13519 Mdot
.40952 .13502 Mdot
.4119 .13485 Mdot
.41429 .13467 Mdot
.41667 .1345 Mdot
.41905 .13432 Mdot
.42143 .13415 Mdot
.42381 .13397 Mdot
.42619 .1338 Mdot
.42857 .13362 Mdot
.43095 .13345 Mdot
.43333 .13327 Mdot
.43571 .1331 Mdot
.4381 .13292 Mdot
.44048 .13274 Mdot
.44286 .13257 Mdot
.44524 .13239 Mdot
.44762 .13221 Mdot
.45 .13204 Mdot
.45238 .13186 Mdot
.45476 .13168 Mdot
.45714 .13151 Mdot
.45952 .13133 Mdot
.4619 .13115 Mdot
.46429 .13097 Mdot
.46667 .13079 Mdot
.46905 .13062 Mdot
.47143 .13044 Mdot
.47381 .13026 Mdot
.47619 .13008 Mdot
.47857 .1299 Mdot
.48095 .12972 Mdot
.48333 .12954 Mdot
.48571 .12936 Mdot
.4881 .12918 Mdot
.49048 .129 Mdot
.49286 .12882 Mdot
.49524 .12864 Mdot
.49762 .12846 Mdot
.5 .12828 Mdot
.50238 .1281 Mdot
.50476 .12792 Mdot
.50714 .12774 Mdot
.50952 .12756 Mdot
.5119 .12738 Mdot
.51429 .1272 Mdot
.51667 .12701 Mdot
.51905 .12683 Mdot
.52143 .12665 Mdot
.52381 .12647 Mdot
.52619 .12629 Mdot
.52857 .1261 Mdot
.53095 .12592 Mdot
.53333 .12574 Mdot
.53571 .12555 Mdot
.5381 .12537 Mdot
.54048 .12519 Mdot
.54286 .125 Mdot
.54524 .12482 Mdot
.54762 .12463 Mdot
.55 .12445 Mdot
.55238 .12427 Mdot
.55476 .12408 Mdot
.55714 .1239 Mdot
.55952 .12371 Mdot
.5619 .12353 Mdot
.56429 .12334 Mdot
.56667 .12315 Mdot
.56905 .12297 Mdot
.57143 .12278 Mdot
.57381 .1226 Mdot
.57619 .12241 Mdot
.57857 .12222 Mdot
.58095 .12204 Mdot
.58333 .12185 Mdot
.58571 .12166 Mdot
.5881 .12147 Mdot
.59048 .12129 Mdot
.59286 .1211 Mdot
.59524 .12091 Mdot
.59762 .12072 Mdot
.6 .12053 Mdot
.60238 .12035 Mdot
.60476 .12016 Mdot
.60714 .11997 Mdot
.60952 .11978 Mdot
.6119 .11959 Mdot
.61429 .1194 Mdot
.61667 .11921 Mdot
.61905 .11902 Mdot
.62143 .11883 Mdot
.62381 .11864 Mdot
.62619 .11845 Mdot
.62857 .11826 Mdot
.63095 .11807 Mdot
.63333 .11788 Mdot
.63571 .11769 Mdot
.6381 .1175 Mdot
.64048 .1173 Mdot
.64286 .11711 Mdot
.64524 .11692 Mdot
.64762 .11673 Mdot
.65 .11654 Mdot
.65238 .11634 Mdot
.65476 .11615 Mdot
.65714 .11596 Mdot
.65952 .11577 Mdot
.6619 .11557 Mdot
.66429 .11538 Mdot
.66667 .11519 Mdot
.66905 .11499 Mdot
.67143 .1148 Mdot
.67381 .1146 Mdot
.67619 .11441 Mdot
.67857 .11421 Mdot
.68095 .11402 Mdot
.68333 .11382 Mdot
.68571 .11363 Mdot
.6881 .11343 Mdot
.69048 .11324 Mdot
.69286 .11304 Mdot
.69524 .11285 Mdot
.69762 .11265 Mdot
.7 .11245 Mdot
.70238 .11226 Mdot
.70476 .11206 Mdot
.70714 .11186 Mdot
.70952 .11167 Mdot
.7119 .11147 Mdot
.71429 .11127 Mdot
.71667 .11107 Mdot
.71905 .11088 Mdot
.72143 .11068 Mdot
.72381 .11048 Mdot
.72619 .11028 Mdot
.72857 .11008 Mdot
.73095 .10988 Mdot
.73333 .10968 Mdot
.73571 .10949 Mdot
.7381 .10929 Mdot
.74048 .10909 Mdot
.74286 .10889 Mdot
.74524 .10869 Mdot
.74762 .10849 Mdot
.75 .10828 Mdot
.75238 .10808 Mdot
.75476 .10788 Mdot
.75714 .10768 Mdot
.75952 .10748 Mdot
.7619 .10728 Mdot
.76429 .10708 Mdot
.76667 .10688 Mdot
.76905 .10667 Mdot
.77143 .10647 Mdot
.77381 .10627 Mdot
.77619 .10607 Mdot
.77857 .10586 Mdot
.78095 .10566 Mdot
.78333 .10546 Mdot
.78571 .10525 Mdot
.7881 .10505 Mdot
.79048 .10484 Mdot
.79286 .10464 Mdot
.79524 .10444 Mdot
.79762 .10423 Mdot
.8 .10403 Mdot
.80238 .10382 Mdot
.80476 .10362 Mdot
.80714 .10341 Mdot
.80952 .10321 Mdot
.8119 .103 Mdot
.81429 .10279 Mdot
.81667 .10259 Mdot
.81905 .10238 Mdot
.82143 .10217 Mdot
.82381 .10197 Mdot
.82619 .10176 Mdot
.82857 .10155 Mdot
.83095 .10135 Mdot
.83333 .10114 Mdot
.83571 .10093 Mdot
.8381 .10072 Mdot
.84048 .10051 Mdot
.84286 .10031 Mdot
.84524 .1001 Mdot
.84762 .09989 Mdot
.85 .09968 Mdot
.85238 .09947 Mdot
.85476 .09926 Mdot
.85714 .09905 Mdot
.85952 .09884 Mdot
.8619 .09863 Mdot
.86429 .09842 Mdot
.86667 .09821 Mdot
.86905 .098 Mdot
.87143 .09779 Mdot
.87381 .09758 Mdot
.87619 .09736 Mdot
.87857 .09715 Mdot
.88095 .09694 Mdot
.88333 .09673 Mdot
.88571 .09652 Mdot
.8881 .0963 Mdot
.89048 .09609 Mdot
.89286 .09588 Mdot
.89524 .09567 Mdot
.89762 .09545 Mdot
.9 .09524 Mdot
.90238 .09502 Mdot
.90476 .09481 Mdot
.90714 .0946 Mdot
.90952 .09438 Mdot
.9119 .09417 Mdot
.91429 .09395 Mdot
.91667 .09374 Mdot
.91905 .09352 Mdot
.92143 .09331 Mdot
.92381 .09309 Mdot
.92619 .09288 Mdot
.92857 .09266 Mdot
.93095 .09244 Mdot
.93333 .09223 Mdot
.93571 .09201 Mdot
.9381 .09179 Mdot
.94048 .09158 Mdot
.94286 .09136 Mdot
.94524 .09114 Mdot
.94762 .09092 Mdot
.95 .0907 Mdot
.95238 .09049 Mdot
.95476 .09027 Mdot
.95714 .09005 Mdot
.95952 .08983 Mdot
.9619 .08961 Mdot
.96429 .08939 Mdot
.96667 .08917 Mdot
.96905 .08895 Mdot
.97143 .08873 Mdot
.97381 .08851 Mdot
.97619 .08829 Mdot
.02381 .18569 Mdot
.02619 .18557 Mdot
.02857 .18545 Mdot
.03095 .18532 Mdot
.03333 .1852 Mdot
.03571 .18508 Mdot
.0381 .18495 Mdot
.04048 .18483 Mdot
.04286 .1847 Mdot
.04524 .18458 Mdot
.04762 .18446 Mdot
.05 .18433 Mdot
.05238 .18421 Mdot
.05476 .18408 Mdot
.05714 .18396 Mdot
.05952 .18383 Mdot
.0619 .18371 Mdot
.06429 .18358 Mdot
.06667 .18346 Mdot
.06905 .18333 Mdot
.07143 .1832 Mdot
.07381 .18308 Mdot
.07619 .18295 Mdot
.07857 .18283 Mdot
.08095 .1827 Mdot
.08333 .18257 Mdot
.08571 .18245 Mdot
.0881 .18232 Mdot
.09048 .18219 Mdot
.09286 .18207 Mdot
.09524 .18194 Mdot
.09762 .18181 Mdot
.1 .18169 Mdot
.10238 .18156 Mdot
.10476 .18143 Mdot
.10714 .1813 Mdot
.10952 .18118 Mdot
.1119 .18105 Mdot
.11429 .18092 Mdot
.11667 .18079 Mdot
.11905 .18066 Mdot
.12143 .18054 Mdot
.12381 .18041 Mdot
.12619 .18028 Mdot
.12857 .18015 Mdot
.13095 .18002 Mdot
.13333 .17989 Mdot
.13571 .17976 Mdot
.1381 .17963 Mdot
.14048 .1795 Mdot
.14286 .17937 Mdot
.14524 .17925 Mdot
.14762 .17912 Mdot
.15 .17899 Mdot
.15238 .17886 Mdot
.15476 .17873 Mdot
.15714 .1786 Mdot
.15952 .17846 Mdot
.1619 .17833 Mdot
.16429 .1782 Mdot
.16667 .17807 Mdot
.16905 .17794 Mdot
.17143 .17781 Mdot
.17381 .17768 Mdot
.17619 .17755 Mdot
.17857 .17742 Mdot
.18095 .17729 Mdot
.18333 .17715 Mdot
.18571 .17702 Mdot
.1881 .17689 Mdot
.19048 .17676 Mdot
.19286 .17663 Mdot
.19524 .17649 Mdot
.19762 .17636 Mdot
.2 .17623 Mdot
.20238 .17609 Mdot
.20476 .17596 Mdot
.20714 .17583 Mdot
.20952 .1757 Mdot
.2119 .17556 Mdot
.21429 .17543 Mdot
.21667 .1753 Mdot
.21905 .17516 Mdot
.22143 .17503 Mdot
.22381 .17489 Mdot
.22619 .17476 Mdot
.22857 .17463 Mdot
.23095 .17449 Mdot
.23333 .17436 Mdot
.23571 .17422 Mdot
.2381 .17409 Mdot
.24048 .17395 Mdot
.24286 .17382 Mdot
.24524 .17368 Mdot
.24762 .17355 Mdot
.25 .17341 Mdot
.25238 .17328 Mdot
.25476 .17314 Mdot
.25714 .173 Mdot
.25952 .17287 Mdot
.2619 .17273 Mdot
.26429 .1726 Mdot
.26667 .17246 Mdot
.26905 .17232 Mdot
.27143 .17219 Mdot
.27381 .17205 Mdot
.27619 .17191 Mdot
.27857 .17177 Mdot
.28095 .17164 Mdot
.28333 .1715 Mdot
.28571 .17136 Mdot
.2881 .17122 Mdot
.29048 .17109 Mdot
.29286 .17095 Mdot
.29524 .17081 Mdot
.29762 .17067 Mdot
.3 .17053 Mdot
.30238 .1704 Mdot
.30476 .17026 Mdot
.30714 .17012 Mdot
.30952 .16998 Mdot
.3119 .16984 Mdot
.31429 .1697 Mdot
.31667 .16956 Mdot
.31905 .16942 Mdot
.32143 .16928 Mdot
.32381 .16914 Mdot
.32619 .169 Mdot
.32857 .16886 Mdot
.33095 .16872 Mdot
.33333 .16858 Mdot
.33571 .16844 Mdot
.3381 .1683 Mdot
.34048 .16816 Mdot
.34286 .16802 Mdot
.34524 .16788 Mdot
.34762 .16774 Mdot
.35 .1676 Mdot
.35238 .16746 Mdot
.35476 .16731 Mdot
.35714 .16717 Mdot
.35952 .16703 Mdot
.3619 .16689 Mdot
.36429 .16675 Mdot
.36667 .1666 Mdot
.36905 .16646 Mdot
.37143 .16632 Mdot
.37381 .16618 Mdot
.37619 .16603 Mdot
.37857 .16589 Mdot
.38095 .16575 Mdot
.38333 .1656 Mdot
.38571 .16546 Mdot
.3881 .16532 Mdot
.39048 .16517 Mdot
.39286 .16503 Mdot
.39524 .16489 Mdot
.39762 .16474 Mdot
.4 .1646 Mdot
.40238 .16445 Mdot
.40476 .16431 Mdot
.40714 .16416 Mdot
.40952 .16402 Mdot
.4119 .16387 Mdot
.41429 .16373 Mdot
.41667 .16358 Mdot
.41905 .16344 Mdot
.42143 .16329 Mdot
.42381 .16315 Mdot
.42619 .163 Mdot
.42857 .16285 Mdot
.43095 .16271 Mdot
.43333 .16256 Mdot
.43571 .16242 Mdot
.4381 .16227 Mdot
.44048 .16212 Mdot
.44286 .16198 Mdot
.44524 .16183 Mdot
.44762 .16168 Mdot
.45 .16153 Mdot
.45238 .16139 Mdot
.45476 .16124 Mdot
.45714 .16109 Mdot
.45952 .16094 Mdot
.4619 .1608 Mdot
.46429 .16065 Mdot
.46667 .1605 Mdot
.46905 .16035 Mdot
.47143 .1602 Mdot
.47381 .16005 Mdot
.47619 .1599 Mdot
.47857 .15975 Mdot
.48095 .15961 Mdot
.48333 .15946 Mdot
.48571 .15931 Mdot
.4881 .15916 Mdot
.49048 .15901 Mdot
.49286 .15886 Mdot
.49524 .15871 Mdot
.49762 .15856 Mdot
.5 .15841 Mdot
.50238 .15826 Mdot
.50476 .1581 Mdot
.50714 .15795 Mdot
.50952 .1578 Mdot
.5119 .15765 Mdot
.51429 .1575 Mdot
.51667 .15735 Mdot
.51905 .1572 Mdot
.52143 .15704 Mdot
.52381 .15689 Mdot
.52619 .15674 Mdot
.52857 .15659 Mdot
.53095 .15644 Mdot
.53333 .15628 Mdot
.53571 .15613 Mdot
.5381 .15598 Mdot
.54048 .15582 Mdot
.54286 .15567 Mdot
.54524 .15552 Mdot
.54762 .15536 Mdot
.55 .15521 Mdot
.55238 .15506 Mdot
.55476 .1549 Mdot
.55714 .15475 Mdot
.55952 .15459 Mdot
.5619 .15444 Mdot
.56429 .15429 Mdot
.56667 .15413 Mdot
.56905 .15398 Mdot
.57143 .15382 Mdot
.57381 .15367 Mdot
.57619 .15351 Mdot
.57857 .15336 Mdot
.58095 .1532 Mdot
.58333 .15304 Mdot
.58571 .15289 Mdot
.5881 .15273 Mdot
.59048 .15258 Mdot
.59286 .15242 Mdot
.59524 .15226 Mdot
.59762 .15211 Mdot
.6 .15195 Mdot
.60238 .15179 Mdot
.60476 .15163 Mdot
.60714 .15148 Mdot
.60952 .15132 Mdot
.6119 .15116 Mdot
.61429 .151 Mdot
.61667 .15085 Mdot
.61905 .15069 Mdot
.62143 .15053 Mdot
.62381 .15037 Mdot
.62619 .15021 Mdot
.62857 .15005 Mdot
.63095 .14989 Mdot
.63333 .14974 Mdot
.63571 .14958 Mdot
.6381 .14942 Mdot
.64048 .14926 Mdot
.64286 .1491 Mdot
.64524 .14894 Mdot
.64762 .14878 Mdot
.65 .14862 Mdot
.65238 .14846 Mdot
.65476 .1483 Mdot
.65714 .14814 Mdot
.65952 .14797 Mdot
.6619 .14781 Mdot
.66429 .14765 Mdot
.66667 .14749 Mdot
.66905 .14733 Mdot
.67143 .14717 Mdot
.67381 .14701 Mdot
.67619 .14684 Mdot
.67857 .14668 Mdot
.68095 .14652 Mdot
.68333 .14636 Mdot
.68571 .14619 Mdot
.6881 .14603 Mdot
.69048 .14587 Mdot
.69286 .14571 Mdot
.69524 .14554 Mdot
.69762 .14538 Mdot
.7 .14521 Mdot
.70238 .14505 Mdot
.70476 .14489 Mdot
.70714 .14472 Mdot
.70952 .14456 Mdot
.7119 .14439 Mdot
.71429 .14423 Mdot
.71667 .14406 Mdot
.71905 .1439 Mdot
.72143 .14373 Mdot
.72381 .14357 Mdot
.72619 .1434 Mdot
.72857 .14324 Mdot
.73095 .14307 Mdot
.73333 .14291 Mdot
.73571 .14274 Mdot
.7381 .14257 Mdot
.74048 .14241 Mdot
.74286 .14224 Mdot
.74524 .14207 Mdot
.74762 .14191 Mdot
.75 .14174 Mdot
.75238 .14157 Mdot
.75476 .14141 Mdot
.75714 .14124 Mdot
.75952 .14107 Mdot
.7619 .1409 Mdot
.76429 .14073 Mdot
.76667 .14057 Mdot
.76905 .1404 Mdot
.77143 .14023 Mdot
.77381 .14006 Mdot
.77619 .13989 Mdot
.77857 .13972 Mdot
.78095 .13955 Mdot
.78333 .13938 Mdot
.78571 .13921 Mdot
.7881 .13904 Mdot
.79048 .13887 Mdot
.79286 .1387 Mdot
.79524 .13853 Mdot
.79762 .13836 Mdot
.8 .13819 Mdot
.80238 .13802 Mdot
.80476 .13785 Mdot
.80714 .13768 Mdot
.80952 .13751 Mdot
.8119 .13734 Mdot
.81429 .13716 Mdot
.81667 .13699 Mdot
.81905 .13682 Mdot
.82143 .13665 Mdot
.82381 .13648 Mdot
.82619 .1363 Mdot
.82857 .13613 Mdot
.83095 .13596 Mdot
.83333 .13578 Mdot
.83571 .13561 Mdot
.8381 .13544 Mdot
.84048 .13526 Mdot
.84286 .13509 Mdot
.84524 .13492 Mdot
.84762 .13474 Mdot
.85 .13457 Mdot
.85238 .13439 Mdot
.85476 .13422 Mdot
.85714 .13404 Mdot
.85952 .13387 Mdot
.8619 .13369 Mdot
.86429 .13352 Mdot
.86667 .13334 Mdot
.86905 .13317 Mdot
.87143 .13299 Mdot
.87381 .13282 Mdot
.87619 .13264 Mdot
.87857 .13246 Mdot
.88095 .13229 Mdot
.88333 .13211 Mdot
.88571 .13193 Mdot
.8881 .13176 Mdot
.89048 .13158 Mdot
.89286 .1314 Mdot
.89524 .13122 Mdot
.89762 .13105 Mdot
.9 .13087 Mdot
.90238 .13069 Mdot
.90476 .13051 Mdot
.90714 .13033 Mdot
.90952 .13015 Mdot
.9119 .12998 Mdot
.91429 .1298 Mdot
.91667 .12962 Mdot
.91905 .12944 Mdot
.92143 .12926 Mdot
.92381 .12908 Mdot
.92619 .1289 Mdot
.92857 .12872 Mdot
.93095 .12854 Mdot
.93333 .12836 Mdot
.93571 .12818 Mdot
.9381 .128 Mdot
.94048 .12782 Mdot
.94286 .12763 Mdot
.94524 .12745 Mdot
.94762 .12727 Mdot
.95 .12709 Mdot
.95238 .12691 Mdot
.95476 .12673 Mdot
.95714 .12654 Mdot
.95952 .12636 Mdot
.9619 .12618 Mdot
.96429 .126 Mdot
.96667 .12581 Mdot
.96905 .12563 Mdot
.97143 .12545 Mdot
.97381 .12526 Mdot
.97619 .12508 Mdot
.02381 .21036 Mdot
.02619 .21026 Mdot
.02857 .21016 Mdot
.03095 .21006 Mdot
.03333 .20996 Mdot
.03571 .20986 Mdot
.0381 .20977 Mdot
.04048 .20967 Mdot
.04286 .20957 Mdot
.04524 .20947 Mdot
.04762 .20937 Mdot
.05 .20927 Mdot
.05238 .20917 Mdot
.05476 .20907 Mdot
.05714 .20897 Mdot
.05952 .20887 Mdot
.0619 .20877 Mdot
.06429 .20867 Mdot
.06667 .20857 Mdot
.06905 .20847 Mdot
.07143 .20837 Mdot
.07381 .20827 Mdot
.07619 .20817 Mdot
.07857 .20806 Mdot
.08095 .20796 Mdot
.08333 .20786 Mdot
.08571 .20776 Mdot
.0881 .20766 Mdot
.09048 .20756 Mdot
.09286 .20746 Mdot
.09524 .20736 Mdot
.09762 .20725 Mdot
.1 .20715 Mdot
.10238 .20705 Mdot
.10476 .20695 Mdot
.10714 .20685 Mdot
.10952 .20674 Mdot
.1119 .20664 Mdot
.11429 .20654 Mdot
.11667 .20644 Mdot
.11905 .20633 Mdot
.12143 .20623 Mdot
.12381 .20613 Mdot
.12619 .20603 Mdot
.12857 .20592 Mdot
.13095 .20582 Mdot
.13333 .20572 Mdot
.13571 .20561 Mdot
.1381 .20551 Mdot
.14048 .20541 Mdot
.14286 .2053 Mdot
.14524 .2052 Mdot
.14762 .2051 Mdot
.15 .20499 Mdot
.15238 .20489 Mdot
.15476 .20478 Mdot
.15714 .20468 Mdot
.15952 .20458 Mdot
.1619 .20447 Mdot
.16429 .20437 Mdot
.16667 .20426 Mdot
.16905 .20416 Mdot
.17143 .20405 Mdot
.17381 .20395 Mdot
.17619 .20384 Mdot
.17857 .20374 Mdot
.18095 .20363 Mdot
.18333 .20353 Mdot
.18571 .20342 Mdot
.1881 .20331 Mdot
.19048 .20321 Mdot
.19286 .2031 Mdot
.19524 .203 Mdot
.19762 .20289 Mdot
.2 .20279 Mdot
.20238 .20268 Mdot
.20476 .20257 Mdot
.20714 .20247 Mdot
.20952 .20236 Mdot
.2119 .20225 Mdot
.21429 .20215 Mdot
.21667 .20204 Mdot
.21905 .20193 Mdot
.22143 .20183 Mdot
.22381 .20172 Mdot
.22619 .20161 Mdot
.22857 .2015 Mdot
.23095 .2014 Mdot
.23333 .20129 Mdot
.23571 .20118 Mdot
.2381 .20107 Mdot
.24048 .20096 Mdot
.24286 .20086 Mdot
.24524 .20075 Mdot
.24762 .20064 Mdot
.25 .20053 Mdot
.25238 .20042 Mdot
.25476 .20031 Mdot
.25714 .20021 Mdot
.25952 .2001 Mdot
.2619 .19999 Mdot
.26429 .19988 Mdot
.26667 .19977 Mdot
.26905 .19966 Mdot
.27143 .19955 Mdot
.27381 .19944 Mdot
.27619 .19933 Mdot
.27857 .19922 Mdot
.28095 .19911 Mdot
.28333 .199 Mdot
.28571 .19889 Mdot
.2881 .19878 Mdot
.29048 .19867 Mdot
.29286 .19856 Mdot
.29524 .19845 Mdot
.29762 .19834 Mdot
.3 .19823 Mdot
.30238 .19812 Mdot
.30476 .19801 Mdot
.30714 .1979 Mdot
.30952 .19779 Mdot
.3119 .19768 Mdot
.31429 .19756 Mdot
.31667 .19745 Mdot
.31905 .19734 Mdot
.32143 .19723 Mdot
.32381 .19712 Mdot
.32619 .19701 Mdot
.32857 .19689 Mdot
.33095 .19678 Mdot
.33333 .19667 Mdot
.33571 .19656 Mdot
.3381 .19645 Mdot
.34048 .19633 Mdot
.34286 .19622 Mdot
.34524 .19611 Mdot
.34762 .19599 Mdot
.35 .19588 Mdot
.35238 .19577 Mdot
.35476 .19565 Mdot
.35714 .19554 Mdot
.35952 .19543 Mdot
.3619 .19531 Mdot
.36429 .1952 Mdot
.36667 .19509 Mdot
.36905 .19497 Mdot
.37143 .19486 Mdot
.37381 .19474 Mdot
.37619 .19463 Mdot
.37857 .19452 Mdot
.38095 .1944 Mdot
.38333 .19429 Mdot
.38571 .19417 Mdot
.3881 .19406 Mdot
.39048 .19394 Mdot
.39286 .19383 Mdot
.39524 .19371 Mdot
.39762 .1936 Mdot
.4 .19348 Mdot
.40238 .19337 Mdot
.40476 .19325 Mdot
.40714 .19313 Mdot
.40952 .19302 Mdot
.4119 .1929 Mdot
.41429 .19279 Mdot
.41667 .19267 Mdot
.41905 .19255 Mdot
.42143 .19244 Mdot
.42381 .19232 Mdot
.42619 .1922 Mdot
.42857 .19209 Mdot
.43095 .19197 Mdot
.43333 .19185 Mdot
.43571 .19174 Mdot
.4381 .19162 Mdot
.44048 .1915 Mdot
.44286 .19138 Mdot
.44524 .19127 Mdot
.44762 .19115 Mdot
.45 .19103 Mdot
.45238 .19091 Mdot
.45476 .19079 Mdot
.45714 .19068 Mdot
.45952 .19056 Mdot
.4619 .19044 Mdot
.46429 .19032 Mdot
.46667 .1902 Mdot
.46905 .19008 Mdot
.47143 .18996 Mdot
.47381 .18985 Mdot
.47619 .18973 Mdot
.47857 .18961 Mdot
.48095 .18949 Mdot
.48333 .18937 Mdot
.48571 .18925 Mdot
.4881 .18913 Mdot
.49048 .18901 Mdot
.49286 .18889 Mdot
.49524 .18877 Mdot
.49762 .18865 Mdot
.5 .18853 Mdot
.50238 .18841 Mdot
.50476 .18829 Mdot
.50714 .18817 Mdot
.50952 .18805 Mdot
.5119 .18792 Mdot
.51429 .1878 Mdot
.51667 .18768 Mdot
.51905 .18756 Mdot
.52143 .18744 Mdot
.52381 .18732 Mdot
.52619 .1872 Mdot
.52857 .18707 Mdot
.53095 .18695 Mdot
.53333 .18683 Mdot
.53571 .18671 Mdot
.5381 .18659 Mdot
.54048 .18646 Mdot
.54286 .18634 Mdot
.54524 .18622 Mdot
.54762 .1861 Mdot
.55 .18597 Mdot
.55238 .18585 Mdot
.55476 .18573 Mdot
.55714 .1856 Mdot
.55952 .18548 Mdot
.5619 .18536 Mdot
.56429 .18523 Mdot
.56667 .18511 Mdot
.56905 .18498 Mdot
.57143 .18486 Mdot
.57381 .18474 Mdot
.57619 .18461 Mdot
.57857 .18449 Mdot
.58095 .18436 Mdot
.58333 .18424 Mdot
.58571 .18411 Mdot
.5881 .18399 Mdot
.59048 .18386 Mdot
.59286 .18374 Mdot
.59524 .18361 Mdot
.59762 .18349 Mdot
.6 .18336 Mdot
.60238 .18324 Mdot
.60476 .18311 Mdot
.60714 .18298 Mdot
.60952 .18286 Mdot
.6119 .18273 Mdot
.61429 .18261 Mdot
.61667 .18248 Mdot
.61905 .18235 Mdot
.62143 .18223 Mdot
.62381 .1821 Mdot
.62619 .18197 Mdot
.62857 .18185 Mdot
.63095 .18172 Mdot
.63333 .18159 Mdot
.63571 .18146 Mdot
.6381 .18134 Mdot
.64048 .18121 Mdot
.64286 .18108 Mdot
.64524 .18095 Mdot
.64762 .18083 Mdot
.65 .1807 Mdot
.65238 .18057 Mdot
.65476 .18044 Mdot
.65714 .18031 Mdot
.65952 .18018 Mdot
.6619 .18005 Mdot
.66429 .17993 Mdot
.66667 .1798 Mdot
.66905 .17967 Mdot
.67143 .17954 Mdot
.67381 .17941 Mdot
.67619 .17928 Mdot
.67857 .17915 Mdot
.68095 .17902 Mdot
.68333 .17889 Mdot
.68571 .17876 Mdot
.6881 .17863 Mdot
.69048 .1785 Mdot
.69286 .17837 Mdot
.69524 .17824 Mdot
.69762 .17811 Mdot
.7 .17798 Mdot
.70238 .17784 Mdot
.70476 .17771 Mdot
.70714 .17758 Mdot
.70952 .17745 Mdot
.7119 .17732 Mdot
.71429 .17719 Mdot
.71667 .17706 Mdot
.71905 .17692 Mdot
.72143 .17679 Mdot
.72381 .17666 Mdot
.72619 .17653 Mdot
.72857 .17639 Mdot
.73095 .17626 Mdot
.73333 .17613 Mdot
.73571 .176 Mdot
.7381 .17586 Mdot
.74048 .17573 Mdot
.74286 .1756 Mdot
.74524 .17546 Mdot
.74762 .17533 Mdot
.75 .1752 Mdot
.75238 .17506 Mdot
.75476 .17493 Mdot
.75714 .17479 Mdot
.75952 .17466 Mdot
.7619 .17453 Mdot
.76429 .17439 Mdot
.76667 .17426 Mdot
.76905 .17412 Mdot
.77143 .17399 Mdot
.77381 .17385 Mdot
.77619 .17372 Mdot
.77857 .17358 Mdot
.78095 .17345 Mdot
.78333 .17331 Mdot
.78571 .17317 Mdot
.7881 .17304 Mdot
.79048 .1729 Mdot
.79286 .17277 Mdot
.79524 .17263 Mdot
.79762 .17249 Mdot
.8 .17236 Mdot
.80238 .17222 Mdot
.80476 .17208 Mdot
.80714 .17195 Mdot
.80952 .17181 Mdot
.8119 .17167 Mdot
.81429 .17154 Mdot
.81667 .1714 Mdot
.81905 .17126 Mdot
.82143 .17112 Mdot
.82381 .17098 Mdot
.82619 .17085 Mdot
.82857 .17071 Mdot
.83095 .17057 Mdot
.83333 .17043 Mdot
.83571 .17029 Mdot
.8381 .17015 Mdot
.84048 .17002 Mdot
.84286 .16988 Mdot
.84524 .16974 Mdot
.84762 .1696 Mdot
.85 .16946 Mdot
.85238 .16932 Mdot
.85476 .16918 Mdot
.85714 .16904 Mdot
.85952 .1689 Mdot
.8619 .16876 Mdot
.86429 .16862 Mdot
.86667 .16848 Mdot
.86905 .16834 Mdot
.87143 .1682 Mdot
.87381 .16806 Mdot
.87619 .16792 Mdot
.87857 .16777 Mdot
.88095 .16763 Mdot
.88333 .16749 Mdot
.88571 .16735 Mdot
.8881 .16721 Mdot
.89048 .16707 Mdot
.89286 .16692 Mdot
.89524 .16678 Mdot
.89762 .16664 Mdot
.9 .1665 Mdot
.90238 .16636 Mdot
.90476 .16621 Mdot
.90714 .16607 Mdot
.90952 .16593 Mdot
.9119 .16578 Mdot
.91429 .16564 Mdot
.91667 .1655 Mdot
.91905 .16535 Mdot
.92143 .16521 Mdot
.92381 .16507 Mdot
.92619 .16492 Mdot
.92857 .16478 Mdot
.93095 .16463 Mdot
.93333 .16449 Mdot
.93571 .16435 Mdot
.9381 .1642 Mdot
.94048 .16406 Mdot
.94286 .16391 Mdot
.94524 .16377 Mdot
.94762 .16362 Mdot
.95 .16348 Mdot
.95238 .16333 Mdot
.95476 .16318 Mdot
.95714 .16304 Mdot
.95952 .16289 Mdot
.9619 .16275 Mdot
.96429 .1626 Mdot
.96667 .16245 Mdot
.96905 .16231 Mdot
.97143 .16216 Mdot
.97381 .16201 Mdot
.97619 .16187 Mdot
.02381 .23502 Mdot
.02619 .23495 Mdot
.02857 .23488 Mdot
.03095 .2348 Mdot
.03333 .23473 Mdot
.03571 .23465 Mdot
.0381 .23458 Mdot
.04048 .2345 Mdot
.04286 .23443 Mdot
.04524 .23435 Mdot
.04762 .23428 Mdot
.05 .23421 Mdot
.05238 .23413 Mdot
.05476 .23406 Mdot
.05714 .23398 Mdot
.05952 .23391 Mdot
.0619 .23383 Mdot
.06429 .23376 Mdot
.06667 .23368 Mdot
.06905 .2336 Mdot
.07143 .23353 Mdot
.07381 .23345 Mdot
.07619 .23338 Mdot
.07857 .2333 Mdot
.08095 .23323 Mdot
.08333 .23315 Mdot
.08571 .23308 Mdot
.0881 .233 Mdot
.09048 .23292 Mdot
.09286 .23285 Mdot
.09524 .23277 Mdot
.09762 .23269 Mdot
.1 .23262 Mdot
.10238 .23254 Mdot
.10476 .23247 Mdot
.10714 .23239 Mdot
.10952 .23231 Mdot
.1119 .23224 Mdot
.11429 .23216 Mdot
.11667 .23208 Mdot
.11905 .23201 Mdot
.12143 .23193 Mdot
.12381 .23185 Mdot
.12619 .23177 Mdot
.12857 .2317 Mdot
.13095 .23162 Mdot
.13333 .23154 Mdot
.13571 .23146 Mdot
.1381 .23139 Mdot
.14048 .23131 Mdot
.14286 .23123 Mdot
.14524 .23115 Mdot
.14762 .23108 Mdot
.15 .231 Mdot
.15238 .23092 Mdot
.15476 .23084 Mdot
.15714 .23076 Mdot
.15952 .23069 Mdot
.1619 .23061 Mdot
.16429 .23053 Mdot
.16667 .23045 Mdot
.16905 .23037 Mdot
.17143 .23029 Mdot
.17381 .23021 Mdot
.17619 .23014 Mdot
.17857 .23006 Mdot
.18095 .22998 Mdot
.18333 .2299 Mdot
.18571 .22982 Mdot
.1881 .22974 Mdot
.19048 .22966 Mdot
.19286 .22958 Mdot
.19524 .2295 Mdot
.19762 .22942 Mdot
.2 .22934 Mdot
.20238 .22926 Mdot
.20476 .22918 Mdot
.20714 .2291 Mdot
.20952 .22902 Mdot
.2119 .22894 Mdot
.21429 .22886 Mdot
.21667 .22878 Mdot
.21905 .2287 Mdot
.22143 .22862 Mdot
.22381 .22854 Mdot
.22619 .22846 Mdot
.22857 .22838 Mdot
.23095 .2283 Mdot
.23333 .22822 Mdot
.23571 .22814 Mdot
.2381 .22806 Mdot
.24048 .22798 Mdot
.24286 .2279 Mdot
.24524 .22782 Mdot
.24762 .22773 Mdot
.25 .22765 Mdot
.25238 .22757 Mdot
.25476 .22749 Mdot
.25714 .22741 Mdot
.25952 .22733 Mdot
.2619 .22725 Mdot
.26429 .22716 Mdot
.26667 .22708 Mdot
.26905 .227 Mdot
.27143 .22692 Mdot
.27381 .22684 Mdot
.27619 .22675 Mdot
.27857 .22667 Mdot
.28095 .22659 Mdot
.28333 .22651 Mdot
.28571 .22642 Mdot
.2881 .22634 Mdot
.29048 .22626 Mdot
.29286 .22618 Mdot
.29524 .22609 Mdot
.29762 .22601 Mdot
.3 .22593 Mdot
.30238 .22584 Mdot
.30476 .22576 Mdot
.30714 .22568 Mdot
.30952 .22559 Mdot
.3119 .22551 Mdot
.31429 .22543 Mdot
.31667 .22534 Mdot
.31905 .22526 Mdot
.32143 .22518 Mdot
.32381 .22509 Mdot
.32619 .22501 Mdot
.32857 .22492 Mdot
.33095 .22484 Mdot
.33333 .22476 Mdot
.33571 .22467 Mdot
.3381 .22459 Mdot
.34048 .2245 Mdot
.34286 .22442 Mdot
.34524 .22433 Mdot
.34762 .22425 Mdot
.35 .22417 Mdot
.35238 .22408 Mdot
.35476 .224 Mdot
.35714 .22391 Mdot
.35952 .22383 Mdot
.3619 .22374 Mdot
.36429 .22365 Mdot
.36667 .22357 Mdot
.36905 .22348 Mdot
.37143 .2234 Mdot
.37381 .22331 Mdot
.37619 .22323 Mdot
.37857 .22314 Mdot
.38095 .22306 Mdot
.38333 .22297 Mdot
.38571 .22288 Mdot
.3881 .2228 Mdot
.39048 .22271 Mdot
.39286 .22262 Mdot
.39524 .22254 Mdot
.39762 .22245 Mdot
.4 .22237 Mdot
.40238 .22228 Mdot
.40476 .22219 Mdot
.40714 .2221 Mdot
.40952 .22202 Mdot
.4119 .22193 Mdot
.41429 .22184 Mdot
.41667 .22176 Mdot
.41905 .22167 Mdot
.42143 .22158 Mdot
.42381 .22149 Mdot
.42619 .22141 Mdot
.42857 .22132 Mdot
.43095 .22123 Mdot
.43333 .22114 Mdot
.43571 .22106 Mdot
.4381 .22097 Mdot
.44048 .22088 Mdot
.44286 .22079 Mdot
.44524 .2207 Mdot
.44762 .22062 Mdot
.45 .22053 Mdot
.45238 .22044 Mdot
.45476 .22035 Mdot
.45714 .22026 Mdot
.45952 .22017 Mdot
.4619 .22008 Mdot
.46429 .21999 Mdot
.46667 .21991 Mdot
.46905 .21982 Mdot
.47143 .21973 Mdot
.47381 .21964 Mdot
.47619 .21955 Mdot
.47857 .21946 Mdot
.48095 .21937 Mdot
.48333 .21928 Mdot
.48571 .21919 Mdot
.4881 .2191 Mdot
.49048 .21901 Mdot
.49286 .21892 Mdot
.49524 .21883 Mdot
.49762 .21874 Mdot
.5 .21865 Mdot
.50238 .21856 Mdot
.50476 .21847 Mdot
.50714 .21838 Mdot
.50952 .21829 Mdot
.5119 .2182 Mdot
.51429 .21811 Mdot
.51667 .21802 Mdot
.51905 .21792 Mdot
.52143 .21783 Mdot
.52381 .21774 Mdot
.52619 .21765 Mdot
.52857 .21756 Mdot
.53095 .21747 Mdot
.53333 .21738 Mdot
.53571 .21729 Mdot
.5381 .21719 Mdot
.54048 .2171 Mdot
.54286 .21701 Mdot
.54524 .21692 Mdot
.54762 .21683 Mdot
.55 .21673 Mdot
.55238 .21664 Mdot
.55476 .21655 Mdot
.55714 .21646 Mdot
.55952 .21636 Mdot
.5619 .21627 Mdot
.56429 .21618 Mdot
.56667 .21609 Mdot
.56905 .21599 Mdot
.57143 .2159 Mdot
.57381 .21581 Mdot
.57619 .21571 Mdot
.57857 .21562 Mdot
.58095 .21553 Mdot
.58333 .21543 Mdot
.58571 .21534 Mdot
.5881 .21525 Mdot
.59048 .21515 Mdot
.59286 .21506 Mdot
.59524 .21496 Mdot
.59762 .21487 Mdot
.6 .21478 Mdot
.60238 .21468 Mdot
.60476 .21459 Mdot
.60714 .21449 Mdot
.60952 .2144 Mdot
.6119 .2143 Mdot
.61429 .21421 Mdot
.61667 .21411 Mdot
.61905 .21402 Mdot
.62143 .21392 Mdot
.62381 .21383 Mdot
.62619 .21373 Mdot
.62857 .21364 Mdot
.63095 .21354 Mdot
.63333 .21345 Mdot
.63571 .21335 Mdot
.6381 .21326 Mdot
.64048 .21316 Mdot
.64286 .21307 Mdot
.64524 .21297 Mdot
.64762 .21287 Mdot
.65 .21278 Mdot
.65238 .21268 Mdot
.65476 .21258 Mdot
.65714 .21249 Mdot
.65952 .21239 Mdot
.6619 .21229 Mdot
.66429 .2122 Mdot
.66667 .2121 Mdot
.66905 .212 Mdot
.67143 .21191 Mdot
.67381 .21181 Mdot
.67619 .21171 Mdot
.67857 .21162 Mdot
.68095 .21152 Mdot
.68333 .21142 Mdot
.68571 .21132 Mdot
.6881 .21123 Mdot
.69048 .21113 Mdot
.69286 .21103 Mdot
.69524 .21093 Mdot
.69762 .21083 Mdot
.7 .21074 Mdot
.70238 .21064 Mdot
.70476 .21054 Mdot
.70714 .21044 Mdot
.70952 .21034 Mdot
.7119 .21024 Mdot
.71429 .21014 Mdot
.71667 .21005 Mdot
.71905 .20995 Mdot
.72143 .20985 Mdot
.72381 .20975 Mdot
.72619 .20965 Mdot
.72857 .20955 Mdot
.73095 .20945 Mdot
.73333 .20935 Mdot
.73571 .20925 Mdot
.7381 .20915 Mdot
.74048 .20905 Mdot
.74286 .20895 Mdot
.74524 .20885 Mdot
.74762 .20875 Mdot
.75 .20865 Mdot
.75238 .20855 Mdot
.75476 .20845 Mdot
.75714 .20835 Mdot
.75952 .20825 Mdot
.7619 .20815 Mdot
.76429 .20805 Mdot
.76667 .20795 Mdot
.76905 .20785 Mdot
.77143 .20774 Mdot
.77381 .20764 Mdot
.77619 .20754 Mdot
.77857 .20744 Mdot
.78095 .20734 Mdot
.78333 .20724 Mdot
.78571 .20713 Mdot
.7881 .20703 Mdot
.79048 .20693 Mdot
.79286 .20683 Mdot
.79524 .20673 Mdot
.79762 .20662 Mdot
.8 .20652 Mdot
.80238 .20642 Mdot
.80476 .20632 Mdot
.80714 .20621 Mdot
.80952 .20611 Mdot
.8119 .20601 Mdot
.81429 .20591 Mdot
.81667 .2058 Mdot
.81905 .2057 Mdot
.82143 .2056 Mdot
.82381 .20549 Mdot
.82619 .20539 Mdot
.82857 .20529 Mdot
.83095 .20518 Mdot
.83333 .20508 Mdot
.83571 .20497 Mdot
.8381 .20487 Mdot
.84048 .20477 Mdot
.84286 .20466 Mdot
.84524 .20456 Mdot
.84762 .20445 Mdot
.85 .20435 Mdot
.85238 .20424 Mdot
.85476 .20414 Mdot
.85714 .20403 Mdot
.85952 .20393 Mdot
.8619 .20382 Mdot
.86429 .20372 Mdot
.86667 .20361 Mdot
.86905 .20351 Mdot
.87143 .2034 Mdot
.87381 .2033 Mdot
.87619 .20319 Mdot
.87857 .20308 Mdot
.88095 .20298 Mdot
.88333 .20287 Mdot
.88571 .20277 Mdot
.8881 .20266 Mdot
.89048 .20255 Mdot
.89286 .20245 Mdot
.89524 .20234 Mdot
.89762 .20223 Mdot
.9 .20213 Mdot
.90238 .20202 Mdot
.90476 .20191 Mdot
.90714 .20181 Mdot
.90952 .2017 Mdot
.9119 .20159 Mdot
.91429 .20148 Mdot
.91667 .20138 Mdot
.91905 .20127 Mdot
.92143 .20116 Mdot
.92381 .20105 Mdot
.92619 .20095 Mdot
.92857 .20084 Mdot
.93095 .20073 Mdot
.93333 .20062 Mdot
.93571 .20051 Mdot
.9381 .2004 Mdot
.94048 .2003 Mdot
.94286 .20019 Mdot
.94524 .20008 Mdot
.94762 .19997 Mdot
.95 .19986 Mdot
.95238 .19975 Mdot
.95476 .19964 Mdot
.95714 .19953 Mdot
.95952 .19942 Mdot
.9619 .19931 Mdot
.96429 .1992 Mdot
.96667 .19909 Mdot
.96905 .19898 Mdot
.97143 .19887 Mdot
.97381 .19876 Mdot
.97619 .19865 Mdot
.02381 .25969 Mdot
.02619 .25964 Mdot
.02857 .25959 Mdot
.03095 .25954 Mdot
.03333 .25949 Mdot
.03571 .25944 Mdot
.0381 .25939 Mdot
.04048 .25934 Mdot
.04286 .25929 Mdot
.04524 .25924 Mdot
.04762 .25919 Mdot
.05 .25914 Mdot
.05238 .25909 Mdot
.05476 .25904 Mdot
.05714 .25899 Mdot
.05952 .25894 Mdot
.0619 .25889 Mdot
.06429 .25884 Mdot
.06667 .25879 Mdot
.06905 .25874 Mdot
.07143 .25869 Mdot
.07381 .25864 Mdot
.07619 .25859 Mdot
.07857 .25854 Mdot
.08095 .25849 Mdot
.08333 .25844 Mdot
.08571 .25839 Mdot
.0881 .25834 Mdot
.09048 .25829 Mdot
.09286 .25824 Mdot
.09524 .25819 Mdot
.09762 .25814 Mdot
.1 .25808 Mdot
.10238 .25803 Mdot
.10476 .25798 Mdot
.10714 .25793 Mdot
.10952 .25788 Mdot
.1119 .25783 Mdot
.11429 .25778 Mdot
.11667 .25773 Mdot
.11905 .25768 Mdot
.12143 .25762 Mdot
.12381 .25757 Mdot
.12619 .25752 Mdot
.12857 .25747 Mdot
.13095 .25742 Mdot
.13333 .25737 Mdot
.13571 .25732 Mdot
.1381 .25726 Mdot
.14048 .25721 Mdot
.14286 .25716 Mdot
.14524 .25711 Mdot
.14762 .25706 Mdot
.15 .257 Mdot
.15238 .25695 Mdot
.15476 .2569 Mdot
.15714 .25685 Mdot
.15952 .2568 Mdot
.1619 .25674 Mdot
.16429 .25669 Mdot
.16667 .25664 Mdot
.16905 .25659 Mdot
.17143 .25653 Mdot
.17381 .25648 Mdot
.17619 .25643 Mdot
.17857 .25638 Mdot
.18095 .25632 Mdot
.18333 .25627 Mdot
.18571 .25622 Mdot
.1881 .25617 Mdot
.19048 .25611 Mdot
.19286 .25606 Mdot
.19524 .25601 Mdot
.19762 .25595 Mdot
.2 .2559 Mdot
.20238 .25585 Mdot
.20476 .25579 Mdot
.20714 .25574 Mdot
.20952 .25569 Mdot
.2119 .25564 Mdot
.21429 .25558 Mdot
.21667 .25553 Mdot
.21905 .25547 Mdot
.22143 .25542 Mdot
.22381 .25537 Mdot
.22619 .25531 Mdot
.22857 .25526 Mdot
.23095 .25521 Mdot
.23333 .25515 Mdot
.23571 .2551 Mdot
.2381 .25504 Mdot
.24048 .25499 Mdot
.24286 .25494 Mdot
.24524 .25488 Mdot
.24762 .25483 Mdot
.25 .25477 Mdot
.25238 .25472 Mdot
.25476 .25467 Mdot
.25714 .25461 Mdot
.25952 .25456 Mdot
.2619 .2545 Mdot
.26429 .25445 Mdot
.26667 .25439 Mdot
.26905 .25434 Mdot
.27143 .25428 Mdot
.27381 .25423 Mdot
.27619 .25417 Mdot
.27857 .25412 Mdot
.28095 .25407 Mdot
.28333 .25401 Mdot
.28571 .25396 Mdot
.2881 .2539 Mdot
.29048 .25384 Mdot
.29286 .25379 Mdot
.29524 .25373 Mdot
.29762 .25368 Mdot
.3 .25362 Mdot
.30238 .25357 Mdot
.30476 .25351 Mdot
.30714 .25346 Mdot
.30952 .2534 Mdot
.3119 .25335 Mdot
.31429 .25329 Mdot
.31667 .25324 Mdot
.31905 .25318 Mdot
.32143 .25312 Mdot
.32381 .25307 Mdot
.32619 .25301 Mdot
.32857 .25296 Mdot
.33095 .2529 Mdot
.33333 .25284 Mdot
.33571 .25279 Mdot
.3381 .25273 Mdot
.34048 .25267 Mdot
.34286 .25262 Mdot
.34524 .25256 Mdot
.34762 .25251 Mdot
.35 .25245 Mdot
.35238 .25239 Mdot
.35476 .25234 Mdot
.35714 .25228 Mdot
.35952 .25222 Mdot
.3619 .25217 Mdot
.36429 .25211 Mdot
.36667 .25205 Mdot
.36905 .25199 Mdot
.37143 .25194 Mdot
.37381 .25188 Mdot
.37619 .25182 Mdot
.37857 .25177 Mdot
.38095 .25171 Mdot
.38333 .25165 Mdot
.38571 .25159 Mdot
.3881 .25154 Mdot
.39048 .25148 Mdot
.39286 .25142 Mdot
.39524 .25136 Mdot
.39762 .25131 Mdot
.4 .25125 Mdot
.40238 .25119 Mdot
.40476 .25113 Mdot
.40714 .25108 Mdot
.40952 .25102 Mdot
.4119 .25096 Mdot
.41429 .2509 Mdot
.41667 .25084 Mdot
.41905 .25079 Mdot
.42143 .25073 Mdot
.42381 .25067 Mdot
.42619 .25061 Mdot
.42857 .25055 Mdot
.43095 .25049 Mdot
.43333 .25044 Mdot
.43571 .25038 Mdot
.4381 .25032 Mdot
.44048 .25026 Mdot
.44286 .2502 Mdot
.44524 .25014 Mdot
.44762 .25008 Mdot
.45 .25002 Mdot
.45238 .24996 Mdot
.45476 .24991 Mdot
.45714 .24985 Mdot
.45952 .24979 Mdot
.4619 .24973 Mdot
.46429 .24967 Mdot
.46667 .24961 Mdot
.46905 .24955 Mdot
.47143 .24949 Mdot
.47381 .24943 Mdot
.47619 .24937 Mdot
.47857 .24931 Mdot
.48095 .24925 Mdot
.48333 .24919 Mdot
.48571 .24913 Mdot
.4881 .24907 Mdot
.49048 .24901 Mdot
.49286 .24895 Mdot
.49524 .24889 Mdot
.49762 .24883 Mdot
.5 .24877 Mdot
.50238 .24871 Mdot
.50476 .24865 Mdot
.50714 .24859 Mdot
.50952 .24853 Mdot
.5119 .24847 Mdot
.51429 .24841 Mdot
.51667 .24835 Mdot
.51905 .24829 Mdot
.52143 .24823 Mdot
.52381 .24817 Mdot
.52619 .24811 Mdot
.52857 .24805 Mdot
.53095 .24798 Mdot
.53333 .24792 Mdot
.53571 .24786 Mdot
.5381 .2478 Mdot
.54048 .24774 Mdot
.54286 .24768 Mdot
.54524 .24762 Mdot
.54762 .24756 Mdot
.55 .24749 Mdot
.55238 .24743 Mdot
.55476 .24737 Mdot
.55714 .24731 Mdot
.55952 .24725 Mdot
.5619 .24719 Mdot
.56429 .24712 Mdot
.56667 .24706 Mdot
.56905 .247 Mdot
.57143 .24694 Mdot
.57381 .24688 Mdot
.57619 .24681 Mdot
.57857 .24675 Mdot
.58095 .24669 Mdot
.58333 .24663 Mdot
.58571 .24657 Mdot
.5881 .2465 Mdot
.59048 .24644 Mdot
.59286 .24638 Mdot
.59524 .24632 Mdot
.59762 .24625 Mdot
.6 .24619 Mdot
.60238 .24613 Mdot
.60476 .24606 Mdot
.60714 .246 Mdot
.60952 .24594 Mdot
.6119 .24587 Mdot
.61429 .24581 Mdot
.61667 .24575 Mdot
.61905 .24569 Mdot
.62143 .24562 Mdot
.62381 .24556 Mdot
.62619 .2455 Mdot
.62857 .24543 Mdot
.63095 .24537 Mdot
.63333 .2453 Mdot
.63571 .24524 Mdot
.6381 .24518 Mdot
.64048 .24511 Mdot
.64286 .24505 Mdot
.64524 .24499 Mdot
.64762 .24492 Mdot
.65 .24486 Mdot
.65238 .24479 Mdot
.65476 .24473 Mdot
.65714 .24466 Mdot
.65952 .2446 Mdot
.6619 .24454 Mdot
.66429 .24447 Mdot
.66667 .24441 Mdot
.66905 .24434 Mdot
.67143 .24428 Mdot
.67381 .24421 Mdot
.67619 .24415 Mdot
.67857 .24408 Mdot
.68095 .24402 Mdot
.68333 .24395 Mdot
.68571 .24389 Mdot
.6881 .24382 Mdot
.69048 .24376 Mdot
.69286 .24369 Mdot
.69524 .24363 Mdot
.69762 .24356 Mdot
.7 .2435 Mdot
.70238 .24343 Mdot
.70476 .24336 Mdot
.70714 .2433 Mdot
.70952 .24323 Mdot
.7119 .24317 Mdot
.71429 .2431 Mdot
.71667 .24304 Mdot
.71905 .24297 Mdot
.72143 .2429 Mdot
.72381 .24284 Mdot
.72619 .24277 Mdot
.72857 .24271 Mdot
.73095 .24264 Mdot
.73333 .24257 Mdot
.73571 .24251 Mdot
.7381 .24244 Mdot
.74048 .24237 Mdot
.74286 .24231 Mdot
.74524 .24224 Mdot
.74762 .24217 Mdot
.75 .24211 Mdot
.75238 .24204 Mdot
.75476 .24197 Mdot
.75714 .24191 Mdot
.75952 .24184 Mdot
.7619 .24177 Mdot
.76429 .2417 Mdot
.76667 .24164 Mdot
.76905 .24157 Mdot
.77143 .2415 Mdot
.77381 .24143 Mdot
.77619 .24137 Mdot
.77857 .2413 Mdot
.78095 .24123 Mdot
.78333 .24116 Mdot
.78571 .2411 Mdot
.7881 .24103 Mdot
.79048 .24096 Mdot
.79286 .24089 Mdot
.79524 .24082 Mdot
.79762 .24076 Mdot
.8 .24069 Mdot
.80238 .24062 Mdot
.80476 .24055 Mdot
.80714 .24048 Mdot
.80952 .24041 Mdot
.8119 .24034 Mdot
.81429 .24028 Mdot
.81667 .24021 Mdot
.81905 .24014 Mdot
.82143 .24007 Mdot
.82381 .24 Mdot
.82619 .23993 Mdot
.82857 .23986 Mdot
.83095 .23979 Mdot
.83333 .23972 Mdot
.83571 .23965 Mdot
.8381 .23959 Mdot
.84048 .23952 Mdot
.84286 .23945 Mdot
.84524 .23938 Mdot
.84762 .23931 Mdot
.85 .23924 Mdot
.85238 .23917 Mdot
.85476 .2391 Mdot
.85714 .23903 Mdot
.85952 .23896 Mdot
.8619 .23889 Mdot
.86429 .23882 Mdot
.86667 .23875 Mdot
.86905 .23868 Mdot
.87143 .23861 Mdot
.87381 .23854 Mdot
.87619 .23847 Mdot
.87857 .2384 Mdot
.88095 .23833 Mdot
.88333 .23825 Mdot
.88571 .23818 Mdot
.8881 .23811 Mdot
.89048 .23804 Mdot
.89286 .23797 Mdot
.89524 .2379 Mdot
.89762 .23783 Mdot
.9 .23776 Mdot
.90238 .23769 Mdot
.90476 .23761 Mdot
.90714 .23754 Mdot
.90952 .23747 Mdot
.9119 .2374 Mdot
.91429 .23733 Mdot
.91667 .23726 Mdot
.91905 .23719 Mdot
.92143 .23711 Mdot
.92381 .23704 Mdot
.92619 .23697 Mdot
.92857 .2369 Mdot
.93095 .23683 Mdot
.93333 .23675 Mdot
.93571 .23668 Mdot
.9381 .23661 Mdot
.94048 .23654 Mdot
.94286 .23646 Mdot
.94524 .23639 Mdot
.94762 .23632 Mdot
.95 .23625 Mdot
.95238 .23617 Mdot
.95476 .2361 Mdot
.95714 .23603 Mdot
.95952 .23595 Mdot
.9619 .23588 Mdot
.96429 .23581 Mdot
.96667 .23574 Mdot
.96905 .23566 Mdot
.97143 .23559 Mdot
.97381 .23552 Mdot
.97619 .23544 Mdot
.02381 .28435 Mdot
.02619 .28433 Mdot
.02857 .2843 Mdot
.03095 .28428 Mdot
.03333 .28425 Mdot
.03571 .28423 Mdot
.0381 .2842 Mdot
.04048 .28418 Mdot
.04286 .28415 Mdot
.04524 .28413 Mdot
.04762 .2841 Mdot
.05 .28408 Mdot
.05238 .28405 Mdot
.05476 .28403 Mdot
.05714 .284 Mdot
.05952 .28398 Mdot
.0619 .28395 Mdot
.06429 .28393 Mdot
.06667 .2839 Mdot
.06905 .28388 Mdot
.07143 .28385 Mdot
.07381 .28383 Mdot
.07619 .2838 Mdot
.07857 .28378 Mdot
.08095 .28375 Mdot
.08333 .28373 Mdot
.08571 .2837 Mdot
.0881 .28368 Mdot
.09048 .28365 Mdot
.09286 .28363 Mdot
.09524 .2836 Mdot
.09762 .28358 Mdot
.1 .28355 Mdot
.10238 .28353 Mdot
.10476 .2835 Mdot
.10714 .28347 Mdot
.10952 .28345 Mdot
.1119 .28342 Mdot
.11429 .2834 Mdot
.11667 .28337 Mdot
.11905 .28335 Mdot
.12143 .28332 Mdot
.12381 .2833 Mdot
.12619 .28327 Mdot
.12857 .28324 Mdot
.13095 .28322 Mdot
.13333 .28319 Mdot
.13571 .28317 Mdot
.1381 .28314 Mdot
.14048 .28311 Mdot
.14286 .28309 Mdot
.14524 .28306 Mdot
.14762 .28304 Mdot
.15 .28301 Mdot
.15238 .28298 Mdot
.15476 .28296 Mdot
.15714 .28293 Mdot
.15952 .28291 Mdot
.1619 .28288 Mdot
.16429 .28285 Mdot
.16667 .28283 Mdot
.16905 .2828 Mdot
.17143 .28278 Mdot
.17381 .28275 Mdot
.17619 .28272 Mdot
.17857 .2827 Mdot
.18095 .28267 Mdot
.18333 .28264 Mdot
.18571 .28262 Mdot
.1881 .28259 Mdot
.19048 .28257 Mdot
.19286 .28254 Mdot
.19524 .28251 Mdot
.19762 .28249 Mdot
.2 .28246 Mdot
.20238 .28243 Mdot
.20476 .28241 Mdot
.20714 .28238 Mdot
.20952 .28235 Mdot
.2119 .28233 Mdot
.21429 .2823 Mdot
.21667 .28227 Mdot
.21905 .28225 Mdot
.22143 .28222 Mdot
.22381 .28219 Mdot
.22619 .28217 Mdot
.22857 .28214 Mdot
.23095 .28211 Mdot
.23333 .28208 Mdot
.23571 .28206 Mdot
.2381 .28203 Mdot
.24048 .282 Mdot
.24286 .28198 Mdot
.24524 .28195 Mdot
.24762 .28192 Mdot
.25 .2819 Mdot
.25238 .28187 Mdot
.25476 .28184 Mdot
.25714 .28181 Mdot
.25952 .28179 Mdot
.2619 .28176 Mdot
.26429 .28173 Mdot
.26667 .28171 Mdot
.26905 .28168 Mdot
.27143 .28165 Mdot
.27381 .28162 Mdot
.27619 .2816 Mdot
.27857 .28157 Mdot
.28095 .28154 Mdot
.28333 .28151 Mdot
.28571 .28149 Mdot
.2881 .28146 Mdot
.29048 .28143 Mdot
.29286 .2814 Mdot
.29524 .28138 Mdot
.29762 .28135 Mdot
.3 .28132 Mdot
.30238 .28129 Mdot
.30476 .28127 Mdot
.30714 .28124 Mdot
.30952 .28121 Mdot
.3119 .28118 Mdot
.31429 .28115 Mdot
.31667 .28113 Mdot
.31905 .2811 Mdot
.32143 .28107 Mdot
.32381 .28104 Mdot
.32619 .28101 Mdot
.32857 .28099 Mdot
.33095 .28096 Mdot
.33333 .28093 Mdot
.33571 .2809 Mdot
.3381 .28087 Mdot
.34048 .28085 Mdot
.34286 .28082 Mdot
.34524 .28079 Mdot
.34762 .28076 Mdot
.35 .28073 Mdot
.35238 .2807 Mdot
.35476 .28068 Mdot
.35714 .28065 Mdot
.35952 .28062 Mdot
.3619 .28059 Mdot
.36429 .28056 Mdot
.36667 .28053 Mdot
.36905 .28051 Mdot
.37143 .28048 Mdot
.37381 .28045 Mdot
.37619 .28042 Mdot
.37857 .28039 Mdot
.38095 .28036 Mdot
.38333 .28033 Mdot
.38571 .28031 Mdot
.3881 .28028 Mdot
.39048 .28025 Mdot
.39286 .28022 Mdot
.39524 .28019 Mdot
.39762 .28016 Mdot
.4 .28013 Mdot
.40238 .2801 Mdot
.40476 .28008 Mdot
.40714 .28005 Mdot
.40952 .28002 Mdot
.4119 .27999 Mdot
.41429 .27996 Mdot
.41667 .27993 Mdot
.41905 .2799 Mdot
.42143 .27987 Mdot
.42381 .27984 Mdot
.42619 .27981 Mdot
.42857 .27978 Mdot
.43095 .27976 Mdot
.43333 .27973 Mdot
.43571 .2797 Mdot
.4381 .27967 Mdot
.44048 .27964 Mdot
.44286 .27961 Mdot
.44524 .27958 Mdot
.44762 .27955 Mdot
.45 .27952 Mdot
.45238 .27949 Mdot
.45476 .27946 Mdot
.45714 .27943 Mdot
.45952 .2794 Mdot
.4619 .27937 Mdot
.46429 .27934 Mdot
.46667 .27931 Mdot
.46905 .27928 Mdot
.47143 .27925 Mdot
.47381 .27922 Mdot
.47619 .27919 Mdot
.47857 .27916 Mdot
.48095 .27913 Mdot
.48333 .2791 Mdot
.48571 .27907 Mdot
.4881 .27904 Mdot
.49048 .27901 Mdot
.49286 .27898 Mdot
.49524 .27895 Mdot
.49762 .27892 Mdot
.5 .27889 Mdot
.50238 .27886 Mdot
.50476 .27883 Mdot
.50714 .2788 Mdot
.50952 .27877 Mdot
.5119 .27874 Mdot
.51429 .27871 Mdot
.51667 .27868 Mdot
.51905 .27865 Mdot
.52143 .27862 Mdot
.52381 .27859 Mdot
.52619 .27856 Mdot
.52857 .27853 Mdot
.53095 .2785 Mdot
.53333 .27847 Mdot
.53571 .27844 Mdot
.5381 .27841 Mdot
.54048 .27838 Mdot
.54286 .27835 Mdot
.54524 .27832 Mdot
.54762 .27829 Mdot
.55 .27826 Mdot
.55238 .27823 Mdot
.55476 .27819 Mdot
.55714 .27816 Mdot
.55952 .27813 Mdot
.5619 .2781 Mdot
.56429 .27807 Mdot
.56667 .27804 Mdot
.56905 .27801 Mdot
.57143 .27798 Mdot
.57381 .27795 Mdot
.57619 .27792 Mdot
.57857 .27788 Mdot
.58095 .27785 Mdot
.58333 .27782 Mdot
.58571 .27779 Mdot
.5881 .27776 Mdot
.59048 .27773 Mdot
.59286 .2777 Mdot
.59524 .27767 Mdot
.59762 .27763 Mdot
.6 .2776 Mdot
.60238 .27757 Mdot
.60476 .27754 Mdot
.60714 .27751 Mdot
.60952 .27748 Mdot
.6119 .27745 Mdot
.61429 .27741 Mdot
.61667 .27738 Mdot
.61905 .27735 Mdot
.62143 .27732 Mdot
.62381 .27729 Mdot
.62619 .27726 Mdot
.62857 .27722 Mdot
.63095 .27719 Mdot
.63333 .27716 Mdot
.63571 .27713 Mdot
.6381 .2771 Mdot
.64048 .27706 Mdot
.64286 .27703 Mdot
.64524 .277 Mdot
.64762 .27697 Mdot
.65 .27694 Mdot
.65238 .2769 Mdot
.65476 .27687 Mdot
.65714 .27684 Mdot
.65952 .27681 Mdot
.6619 .27678 Mdot
.66429 .27674 Mdot
.66667 .27671 Mdot
.66905 .27668 Mdot
.67143 .27665 Mdot
.67381 .27661 Mdot
.67619 .27658 Mdot
.67857 .27655 Mdot
.68095 .27652 Mdot
.68333 .27648 Mdot
.68571 .27645 Mdot
.6881 .27642 Mdot
.69048 .27639 Mdot
.69286 .27635 Mdot
.69524 .27632 Mdot
.69762 .27629 Mdot
.7 .27626 Mdot
.70238 .27622 Mdot
.70476 .27619 Mdot
.70714 .27616 Mdot
.70952 .27613 Mdot
.7119 .27609 Mdot
.71429 .27606 Mdot
.71667 .27603 Mdot
.71905 .27599 Mdot
.72143 .27596 Mdot
.72381 .27593 Mdot
.72619 .27589 Mdot
.72857 .27586 Mdot
.73095 .27583 Mdot
.73333 .27579 Mdot
.73571 .27576 Mdot
.7381 .27573 Mdot
.74048 .2757 Mdot
.74286 .27566 Mdot
.74524 .27563 Mdot
.74762 .2756 Mdot
.75 .27556 Mdot
.75238 .27553 Mdot
.75476 .27549 Mdot
.75714 .27546 Mdot
.75952 .27543 Mdot
.7619 .27539 Mdot
.76429 .27536 Mdot
.76667 .27533 Mdot
.76905 .27529 Mdot
.77143 .27526 Mdot
.77381 .27523 Mdot
.77619 .27519 Mdot
.77857 .27516 Mdot
.78095 .27512 Mdot
.78333 .27509 Mdot
.78571 .27506 Mdot
.7881 .27502 Mdot
.79048 .27499 Mdot
.79286 .27495 Mdot
.79524 .27492 Mdot
.79762 .27489 Mdot
.8 .27485 Mdot
.80238 .27482 Mdot
.80476 .27478 Mdot
.80714 .27475 Mdot
.80952 .27472 Mdot
.8119 .27468 Mdot
.81429 .27465 Mdot
.81667 .27461 Mdot
.81905 .27458 Mdot
.82143 .27454 Mdot
.82381 .27451 Mdot
.82619 .27447 Mdot
.82857 .27444 Mdot
.83095 .27441 Mdot
.83333 .27437 Mdot
.83571 .27434 Mdot
.8381 .2743 Mdot
.84048 .27427 Mdot
.84286 .27423 Mdot
.84524 .2742 Mdot
.84762 .27416 Mdot
.85 .27413 Mdot
.85238 .27409 Mdot
.85476 .27406 Mdot
.85714 .27402 Mdot
.85952 .27399 Mdot
.8619 .27395 Mdot
.86429 .27392 Mdot
.86667 .27388 Mdot
.86905 .27385 Mdot
.87143 .27381 Mdot
.87381 .27378 Mdot
.87619 .27374 Mdot
.87857 .27371 Mdot
.88095 .27367 Mdot
.88333 .27364 Mdot
.88571 .2736 Mdot
.8881 .27356 Mdot
.89048 .27353 Mdot
.89286 .27349 Mdot
.89524 .27346 Mdot
.89762 .27342 Mdot
.9 .27339 Mdot
.90238 .27335 Mdot
.90476 .27332 Mdot
.90714 .27328 Mdot
.90952 .27324 Mdot
.9119 .27321 Mdot
.91429 .27317 Mdot
.91667 .27314 Mdot
.91905 .2731 Mdot
.92143 .27307 Mdot
.92381 .27303 Mdot
.92619 .27299 Mdot
.92857 .27296 Mdot
.93095 .27292 Mdot
.93333 .27289 Mdot
.93571 .27285 Mdot
.9381 .27281 Mdot
.94048 .27278 Mdot
.94286 .27274 Mdot
.94524 .2727 Mdot
.94762 .27267 Mdot
.95 .27263 Mdot
.95238 .2726 Mdot
.95476 .27256 Mdot
.95714 .27252 Mdot
.95952 .27249 Mdot
.9619 .27245 Mdot
.96429 .27241 Mdot
.96667 .27238 Mdot
.96905 .27234 Mdot
.97143 .2723 Mdot
.97381 .27227 Mdot
.97619 .27223 Mdot
.02381 .30902 Mdot
.02619 .30902 Mdot
.02857 .30902 Mdot
.03095 .30902 Mdot
.03333 .30902 Mdot
.03571 .30902 Mdot
.0381 .30902 Mdot
.04048 .30902 Mdot
.04286 .30902 Mdot
.04524 .30902 Mdot
.04762 .30902 Mdot
.05 .30902 Mdot
.05238 .30902 Mdot
.05476 .30902 Mdot
.05714 .30902 Mdot
.05952 .30902 Mdot
.0619 .30902 Mdot
.06429 .30902 Mdot
.06667 .30902 Mdot
.06905 .30902 Mdot
.07143 .30902 Mdot
.07381 .30902 Mdot
.07619 .30902 Mdot
.07857 .30902 Mdot
.08095 .30902 Mdot
.08333 .30902 Mdot
.08571 .30902 Mdot
.0881 .30902 Mdot
.09048 .30902 Mdot
.09286 .30902 Mdot
.09524 .30902 Mdot
.09762 .30902 Mdot
.1 .30902 Mdot
.10238 .30902 Mdot
.10476 .30902 Mdot
.10714 .30902 Mdot
.10952 .30902 Mdot
.1119 .30902 Mdot
.11429 .30902 Mdot
.11667 .30902 Mdot
.11905 .30902 Mdot
.12143 .30902 Mdot
.12381 .30902 Mdot
.12619 .30902 Mdot
.12857 .30902 Mdot
.13095 .30902 Mdot
.13333 .30902 Mdot
.13571 .30902 Mdot
.1381 .30902 Mdot
.14048 .30902 Mdot
.14286 .30902 Mdot
.14524 .30902 Mdot
.14762 .30902 Mdot
.15 .30902 Mdot
.15238 .30902 Mdot
.15476 .30902 Mdot
.15714 .30902 Mdot
.15952 .30902 Mdot
.1619 .30902 Mdot
.16429 .30902 Mdot
.16667 .30902 Mdot
.16905 .30902 Mdot
.17143 .30902 Mdot
.17381 .30902 Mdot
.17619 .30902 Mdot
.17857 .30902 Mdot
.18095 .30902 Mdot
.18333 .30902 Mdot
.18571 .30902 Mdot
.1881 .30902 Mdot
.19048 .30902 Mdot
.19286 .30902 Mdot
.19524 .30902 Mdot
.19762 .30902 Mdot
.2 .30902 Mdot
.20238 .30902 Mdot
.20476 .30902 Mdot
.20714 .30902 Mdot
.20952 .30902 Mdot
.2119 .30902 Mdot
.21429 .30902 Mdot
.21667 .30902 Mdot
.21905 .30902 Mdot
.22143 .30902 Mdot
.22381 .30902 Mdot
.22619 .30902 Mdot
.22857 .30902 Mdot
.23095 .30902 Mdot
.23333 .30902 Mdot
.23571 .30902 Mdot
.2381 .30902 Mdot
.24048 .30902 Mdot
.24286 .30902 Mdot
.24524 .30902 Mdot
.24762 .30902 Mdot
.25 .30902 Mdot
.25238 .30902 Mdot
.25476 .30902 Mdot
.25714 .30902 Mdot
.25952 .30902 Mdot
.2619 .30902 Mdot
.26429 .30902 Mdot
.26667 .30902 Mdot
.26905 .30902 Mdot
.27143 .30902 Mdot
.27381 .30902 Mdot
.27619 .30902 Mdot
.27857 .30902 Mdot
.28095 .30902 Mdot
.28333 .30902 Mdot
.28571 .30902 Mdot
.2881 .30902 Mdot
.29048 .30902 Mdot
.29286 .30902 Mdot
.29524 .30902 Mdot
.29762 .30902 Mdot
.3 .30902 Mdot
.30238 .30902 Mdot
.30476 .30902 Mdot
.30714 .30902 Mdot
.30952 .30902 Mdot
.3119 .30902 Mdot
.31429 .30902 Mdot
.31667 .30902 Mdot
.31905 .30902 Mdot
.32143 .30902 Mdot
.32381 .30902 Mdot
.32619 .30902 Mdot
.32857 .30902 Mdot
.33095 .30902 Mdot
.33333 .30902 Mdot
.33571 .30902 Mdot
.3381 .30902 Mdot
.34048 .30902 Mdot
.34286 .30902 Mdot
.34524 .30902 Mdot
.34762 .30902 Mdot
.35 .30902 Mdot
.35238 .30902 Mdot
.35476 .30902 Mdot
.35714 .30902 Mdot
.35952 .30902 Mdot
.3619 .30902 Mdot
.36429 .30902 Mdot
.36667 .30902 Mdot
.36905 .30902 Mdot
.37143 .30902 Mdot
.37381 .30902 Mdot
.37619 .30902 Mdot
.37857 .30902 Mdot
.38095 .30902 Mdot
.38333 .30902 Mdot
.38571 .30902 Mdot
.3881 .30902 Mdot
.39048 .30902 Mdot
.39286 .30902 Mdot
.39524 .30902 Mdot
.39762 .30902 Mdot
.4 .30902 Mdot
.40238 .30902 Mdot
.40476 .30902 Mdot
.40714 .30902 Mdot
.40952 .30902 Mdot
.4119 .30902 Mdot
.41429 .30902 Mdot
.41667 .30902 Mdot
.41905 .30902 Mdot
.42143 .30902 Mdot
.42381 .30902 Mdot
.42619 .30902 Mdot
.42857 .30902 Mdot
.43095 .30902 Mdot
.43333 .30902 Mdot
.43571 .30902 Mdot
.4381 .30902 Mdot
.44048 .30902 Mdot
.44286 .30902 Mdot
.44524 .30902 Mdot
.44762 .30902 Mdot
.45 .30902 Mdot
.45238 .30902 Mdot
.45476 .30902 Mdot
.45714 .30902 Mdot
.45952 .30902 Mdot
.4619 .30902 Mdot
.46429 .30902 Mdot
.46667 .30902 Mdot
.46905 .30902 Mdot
.47143 .30902 Mdot
.47381 .30902 Mdot
.47619 .30902 Mdot
.47857 .30902 Mdot
.48095 .30902 Mdot
.48333 .30902 Mdot
.48571 .30902 Mdot
.4881 .30902 Mdot
.49048 .30902 Mdot
.49286 .30902 Mdot
.49524 .30902 Mdot
.49762 .30902 Mdot
.5 .30902 Mdot
.50238 .30902 Mdot
.50476 .30902 Mdot
.50714 .30902 Mdot
.50952 .30902 Mdot
.5119 .30902 Mdot
.51429 .30902 Mdot
.51667 .30902 Mdot
.51905 .30902 Mdot
.52143 .30902 Mdot
.52381 .30902 Mdot
.52619 .30902 Mdot
.52857 .30902 Mdot
.53095 .30902 Mdot
.53333 .30902 Mdot
.53571 .30902 Mdot
.5381 .30902 Mdot
.54048 .30902 Mdot
.54286 .30902 Mdot
.54524 .30902 Mdot
.54762 .30902 Mdot
.55 .30902 Mdot
.55238 .30902 Mdot
.55476 .30902 Mdot
.55714 .30902 Mdot
.55952 .30902 Mdot
.5619 .30902 Mdot
.56429 .30902 Mdot
.56667 .30902 Mdot
.56905 .30902 Mdot
.57143 .30902 Mdot
.57381 .30902 Mdot
.57619 .30902 Mdot
.57857 .30902 Mdot
.58095 .30902 Mdot
.58333 .30902 Mdot
.58571 .30902 Mdot
.5881 .30902 Mdot
.59048 .30902 Mdot
.59286 .30902 Mdot
.59524 .30902 Mdot
.59762 .30902 Mdot
.6 .30902 Mdot
.60238 .30902 Mdot
.60476 .30902 Mdot
.60714 .30902 Mdot
.60952 .30902 Mdot
.6119 .30902 Mdot
.61429 .30902 Mdot
.61667 .30902 Mdot
.61905 .30902 Mdot
.62143 .30902 Mdot
.62381 .30902 Mdot
.62619 .30902 Mdot
.62857 .30902 Mdot
.63095 .30902 Mdot
.63333 .30902 Mdot
.63571 .30902 Mdot
.6381 .30902 Mdot
.64048 .30902 Mdot
.64286 .30902 Mdot
.64524 .30902 Mdot
.64762 .30902 Mdot
.65 .30902 Mdot
.65238 .30902 Mdot
.65476 .30902 Mdot
.65714 .30902 Mdot
.65952 .30902 Mdot
.6619 .30902 Mdot
.66429 .30902 Mdot
.66667 .30902 Mdot
.66905 .30902 Mdot
.67143 .30902 Mdot
.67381 .30902 Mdot
.67619 .30902 Mdot
.67857 .30902 Mdot
.68095 .30902 Mdot
.68333 .30902 Mdot
.68571 .30902 Mdot
.6881 .30902 Mdot
.69048 .30902 Mdot
.69286 .30902 Mdot
.69524 .30902 Mdot
.69762 .30902 Mdot
.7 .30902 Mdot
.70238 .30902 Mdot
.70476 .30902 Mdot
.70714 .30902 Mdot
.70952 .30902 Mdot
.7119 .30902 Mdot
.71429 .30902 Mdot
.71667 .30902 Mdot
.71905 .30902 Mdot
.72143 .30902 Mdot
.72381 .30902 Mdot
.72619 .30902 Mdot
.72857 .30902 Mdot
.73095 .30902 Mdot
.73333 .30902 Mdot
.73571 .30902 Mdot
.7381 .30902 Mdot
.74048 .30902 Mdot
.74286 .30902 Mdot
.74524 .30902 Mdot
.74762 .30902 Mdot
.75 .30902 Mdot
.75238 .30902 Mdot
.75476 .30902 Mdot
.75714 .30902 Mdot
.75952 .30902 Mdot
.7619 .30902 Mdot
.76429 .30902 Mdot
.76667 .30902 Mdot
.76905 .30902 Mdot
.77143 .30902 Mdot
.77381 .30902 Mdot
.77619 .30902 Mdot
.77857 .30902 Mdot
.78095 .30902 Mdot
.78333 .30902 Mdot
.78571 .30902 Mdot
.7881 .30902 Mdot
.79048 .30902 Mdot
.79286 .30902 Mdot
.79524 .30902 Mdot
.79762 .30902 Mdot
.8 .30902 Mdot
.80238 .30902 Mdot
.80476 .30902 Mdot
.80714 .30902 Mdot
.80952 .30902 Mdot
.8119 .30902 Mdot
.81429 .30902 Mdot
.81667 .30902 Mdot
.81905 .30902 Mdot
.82143 .30902 Mdot
.82381 .30902 Mdot
.82619 .30902 Mdot
.82857 .30902 Mdot
.83095 .30902 Mdot
.83333 .30902 Mdot
.83571 .30902 Mdot
.8381 .30902 Mdot
.84048 .30902 Mdot
.84286 .30902 Mdot
.84524 .30902 Mdot
.84762 .30902 Mdot
.85 .30902 Mdot
.85238 .30902 Mdot
.85476 .30902 Mdot
.85714 .30902 Mdot
.85952 .30902 Mdot
.8619 .30902 Mdot
.86429 .30902 Mdot
.86667 .30902 Mdot
.86905 .30902 Mdot
.87143 .30902 Mdot
.87381 .30902 Mdot
.87619 .30902 Mdot
.87857 .30902 Mdot
.88095 .30902 Mdot
.88333 .30902 Mdot
.88571 .30902 Mdot
.8881 .30902 Mdot
.89048 .30902 Mdot
.89286 .30902 Mdot
.89524 .30902 Mdot
.89762 .30902 Mdot
.9 .30902 Mdot
.90238 .30902 Mdot
.90476 .30902 Mdot
.90714 .30902 Mdot
.90952 .30902 Mdot
.9119 .30902 Mdot
.91429 .30902 Mdot
.91667 .30902 Mdot
.91905 .30902 Mdot
.92143 .30902 Mdot
.92381 .30902 Mdot
.92619 .30902 Mdot
.92857 .30902 Mdot
.93095 .30902 Mdot
.93333 .30902 Mdot
.93571 .30902 Mdot
.9381 .30902 Mdot
.94048 .30902 Mdot
.94286 .30902 Mdot
.94524 .30902 Mdot
.94762 .30902 Mdot
.95 .30902 Mdot
.95238 .30902 Mdot
.95476 .30902 Mdot
.95714 .30902 Mdot
.95952 .30902 Mdot
.9619 .30902 Mdot
.96429 .30902 Mdot
.96667 .30902 Mdot
.96905 .30902 Mdot
.97143 .30902 Mdot
.97381 .30902 Mdot
.97619 .30902 Mdot
.02381 .33368 Mdot
.02619 .33371 Mdot
.02857 .33373 Mdot
.03095 .33376 Mdot
.03333 .33378 Mdot
.03571 .33381 Mdot
.0381 .33383 Mdot
.04048 .33385 Mdot
.04286 .33388 Mdot
.04524 .3339 Mdot
.04762 .33393 Mdot
.05 .33395 Mdot
.05238 .33398 Mdot
.05476 .334 Mdot
.05714 .33403 Mdot
.05952 .33405 Mdot
.0619 .33408 Mdot
.06429 .3341 Mdot
.06667 .33413 Mdot
.06905 .33415 Mdot
.07143 .33418 Mdot
.07381 .3342 Mdot
.07619 .33423 Mdot
.07857 .33426 Mdot
.08095 .33428 Mdot
.08333 .33431 Mdot
.08571 .33433 Mdot
.0881 .33436 Mdot
.09048 .33438 Mdot
.09286 .33441 Mdot
.09524 .33443 Mdot
.09762 .33446 Mdot
.1 .33448 Mdot
.10238 .33451 Mdot
.10476 .33453 Mdot
.10714 .33456 Mdot
.10952 .33459 Mdot
.1119 .33461 Mdot
.11429 .33464 Mdot
.11667 .33466 Mdot
.11905 .33469 Mdot
.12143 .33471 Mdot
.12381 .33474 Mdot
.12619 .33476 Mdot
.12857 .33479 Mdot
.13095 .33482 Mdot
.13333 .33484 Mdot
.13571 .33487 Mdot
.1381 .33489 Mdot
.14048 .33492 Mdot
.14286 .33495 Mdot
.14524 .33497 Mdot
.14762 .335 Mdot
.15 .33502 Mdot
.15238 .33505 Mdot
.15476 .33508 Mdot
.15714 .3351 Mdot
.15952 .33513 Mdot
.1619 .33515 Mdot
.16429 .33518 Mdot
.16667 .33521 Mdot
.16905 .33523 Mdot
.17143 .33526 Mdot
.17381 .33528 Mdot
.17619 .33531 Mdot
.17857 .33534 Mdot
.18095 .33536 Mdot
.18333 .33539 Mdot
.18571 .33542 Mdot
.1881 .33544 Mdot
.19048 .33547 Mdot
.19286 .3355 Mdot
.19524 .33552 Mdot
.19762 .33555 Mdot
.2 .33557 Mdot
.20238 .3356 Mdot
.20476 .33563 Mdot
.20714 .33565 Mdot
.20952 .33568 Mdot
.2119 .33571 Mdot
.21429 .33573 Mdot
.21667 .33576 Mdot
.21905 .33579 Mdot
.22143 .33581 Mdot
.22381 .33584 Mdot
.22619 .33587 Mdot
.22857 .3359 Mdot
.23095 .33592 Mdot
.23333 .33595 Mdot
.23571 .33598 Mdot
.2381 .336 Mdot
.24048 .33603 Mdot
.24286 .33606 Mdot
.24524 .33608 Mdot
.24762 .33611 Mdot
.25 .33614 Mdot
.25238 .33617 Mdot
.25476 .33619 Mdot
.25714 .33622 Mdot
.25952 .33625 Mdot
.2619 .33627 Mdot
.26429 .3363 Mdot
.26667 .33633 Mdot
.26905 .33636 Mdot
.27143 .33638 Mdot
.27381 .33641 Mdot
.27619 .33644 Mdot
.27857 .33647 Mdot
.28095 .33649 Mdot
.28333 .33652 Mdot
.28571 .33655 Mdot
.2881 .33658 Mdot
.29048 .3366 Mdot
.29286 .33663 Mdot
.29524 .33666 Mdot
.29762 .33669 Mdot
.3 .33671 Mdot
.30238 .33674 Mdot
.30476 .33677 Mdot
.30714 .3368 Mdot
.30952 .33682 Mdot
.3119 .33685 Mdot
.31429 .33688 Mdot
.31667 .33691 Mdot
.31905 .33694 Mdot
.32143 .33696 Mdot
.32381 .33699 Mdot
.32619 .33702 Mdot
.32857 .33705 Mdot
.33095 .33708 Mdot
.33333 .3371 Mdot
.33571 .33713 Mdot
.3381 .33716 Mdot
.34048 .33719 Mdot
.34286 .33722 Mdot
.34524 .33724 Mdot
.34762 .33727 Mdot
.35 .3373 Mdot
.35238 .33733 Mdot
.35476 .33736 Mdot
.35714 .33739 Mdot
.35952 .33741 Mdot
.3619 .33744 Mdot
.36429 .33747 Mdot
.36667 .3375 Mdot
.36905 .33753 Mdot
.37143 .33756 Mdot
.37381 .33759 Mdot
.37619 .33761 Mdot
.37857 .33764 Mdot
.38095 .33767 Mdot
.38333 .3377 Mdot
.38571 .33773 Mdot
.3881 .33776 Mdot
.39048 .33779 Mdot
.39286 .33781 Mdot
.39524 .33784 Mdot
.39762 .33787 Mdot
.4 .3379 Mdot
.40238 .33793 Mdot
.40476 .33796 Mdot
.40714 .33799 Mdot
.40952 .33802 Mdot
.4119 .33805 Mdot
.41429 .33807 Mdot
.41667 .3381 Mdot
.41905 .33813 Mdot
.42143 .33816 Mdot
.42381 .33819 Mdot
.42619 .33822 Mdot
.42857 .33825 Mdot
.43095 .33828 Mdot
.43333 .33831 Mdot
.43571 .33834 Mdot
.4381 .33837 Mdot
.44048 .3384 Mdot
.44286 .33843 Mdot
.44524 .33845 Mdot
.44762 .33848 Mdot
.45 .33851 Mdot
.45238 .33854 Mdot
.45476 .33857 Mdot
.45714 .3386 Mdot
.45952 .33863 Mdot
.4619 .33866 Mdot
.46429 .33869 Mdot
.46667 .33872 Mdot
.46905 .33875 Mdot
.47143 .33878 Mdot
.47381 .33881 Mdot
.47619 .33884 Mdot
.47857 .33887 Mdot
.48095 .3389 Mdot
.48333 .33893 Mdot
.48571 .33896 Mdot
.4881 .33899 Mdot
.49048 .33902 Mdot
.49286 .33905 Mdot
.49524 .33908 Mdot
.49762 .33911 Mdot
.5 .33914 Mdot
.50238 .33917 Mdot
.50476 .3392 Mdot
.50714 .33923 Mdot
.50952 .33926 Mdot
.5119 .33929 Mdot
.51429 .33932 Mdot
.51667 .33935 Mdot
.51905 .33938 Mdot
.52143 .33941 Mdot
.52381 .33944 Mdot
.52619 .33947 Mdot
.52857 .3395 Mdot
.53095 .33953 Mdot
.53333 .33956 Mdot
.53571 .33959 Mdot
.5381 .33962 Mdot
.54048 .33966 Mdot
.54286 .33969 Mdot
.54524 .33972 Mdot
.54762 .33975 Mdot
.55 .33978 Mdot
.55238 .33981 Mdot
.55476 .33984 Mdot
.55714 .33987 Mdot
.55952 .3399 Mdot
.5619 .33993 Mdot
.56429 .33996 Mdot
.56667 .33999 Mdot
.56905 .34003 Mdot
.57143 .34006 Mdot
.57381 .34009 Mdot
.57619 .34012 Mdot
.57857 .34015 Mdot
.58095 .34018 Mdot
.58333 .34021 Mdot
.58571 .34024 Mdot
.5881 .34027 Mdot
.59048 .34031 Mdot
.59286 .34034 Mdot
.59524 .34037 Mdot
.59762 .3404 Mdot
.6 .34043 Mdot
.60238 .34046 Mdot
.60476 .34049 Mdot
.60714 .34053 Mdot
.60952 .34056 Mdot
.6119 .34059 Mdot
.61429 .34062 Mdot
.61667 .34065 Mdot
.61905 .34068 Mdot
.62143 .34071 Mdot
.62381 .34075 Mdot
.62619 .34078 Mdot
.62857 .34081 Mdot
.63095 .34084 Mdot
.63333 .34087 Mdot
.63571 .34091 Mdot
.6381 .34094 Mdot
.64048 .34097 Mdot
.64286 .341 Mdot
.64524 .34103 Mdot
.64762 .34106 Mdot
.65 .3411 Mdot
.65238 .34113 Mdot
.65476 .34116 Mdot
.65714 .34119 Mdot
.65952 .34123 Mdot
.6619 .34126 Mdot
.66429 .34129 Mdot
.66667 .34132 Mdot
.66905 .34135 Mdot
.67143 .34139 Mdot
.67381 .34142 Mdot
.67619 .34145 Mdot
.67857 .34148 Mdot
.68095 .34152 Mdot
.68333 .34155 Mdot
.68571 .34158 Mdot
.6881 .34161 Mdot
.69048 .34165 Mdot
.69286 .34168 Mdot
.69524 .34171 Mdot
.69762 .34174 Mdot
.7 .34178 Mdot
.70238 .34181 Mdot
.70476 .34184 Mdot
.70714 .34188 Mdot
.70952 .34191 Mdot
.7119 .34194 Mdot
.71429 .34197 Mdot
.71667 .34201 Mdot
.71905 .34204 Mdot
.72143 .34207 Mdot
.72381 .34211 Mdot
.72619 .34214 Mdot
.72857 .34217 Mdot
.73095 .34221 Mdot
.73333 .34224 Mdot
.73571 .34227 Mdot
.7381 .34231 Mdot
.74048 .34234 Mdot
.74286 .34237 Mdot
.74524 .34241 Mdot
.74762 .34244 Mdot
.75 .34247 Mdot
.75238 .34251 Mdot
.75476 .34254 Mdot
.75714 .34257 Mdot
.75952 .34261 Mdot
.7619 .34264 Mdot
.76429 .34267 Mdot
.76667 .34271 Mdot
.76905 .34274 Mdot
.77143 .34277 Mdot
.77381 .34281 Mdot
.77619 .34284 Mdot
.77857 .34288 Mdot
.78095 .34291 Mdot
.78333 .34294 Mdot
.78571 .34298 Mdot
.7881 .34301 Mdot
.79048 .34305 Mdot
.79286 .34308 Mdot
.79524 .34311 Mdot
.79762 .34315 Mdot
.8 .34318 Mdot
.80238 .34322 Mdot
.80476 .34325 Mdot
.80714 .34328 Mdot
.80952 .34332 Mdot
.8119 .34335 Mdot
.81429 .34339 Mdot
.81667 .34342 Mdot
.81905 .34346 Mdot
.82143 .34349 Mdot
.82381 .34353 Mdot
.82619 .34356 Mdot
.82857 .34359 Mdot
.83095 .34363 Mdot
.83333 .34366 Mdot
.83571 .3437 Mdot
.8381 .34373 Mdot
.84048 .34377 Mdot
.84286 .3438 Mdot
.84524 .34384 Mdot
.84762 .34387 Mdot
.85 .34391 Mdot
.85238 .34394 Mdot
.85476 .34398 Mdot
.85714 .34401 Mdot
.85952 .34405 Mdot
.8619 .34408 Mdot
.86429 .34412 Mdot
.86667 .34415 Mdot
.86905 .34419 Mdot
.87143 .34422 Mdot
.87381 .34426 Mdot
.87619 .34429 Mdot
.87857 .34433 Mdot
.88095 .34436 Mdot
.88333 .3444 Mdot
.88571 .34443 Mdot
.8881 .34447 Mdot
.89048 .3445 Mdot
.89286 .34454 Mdot
.89524 .34458 Mdot
.89762 .34461 Mdot
.9 .34465 Mdot
.90238 .34468 Mdot
.90476 .34472 Mdot
.90714 .34475 Mdot
.90952 .34479 Mdot
.9119 .34483 Mdot
.91429 .34486 Mdot
.91667 .3449 Mdot
.91905 .34493 Mdot
.92143 .34497 Mdot
.92381 .345 Mdot
.92619 .34504 Mdot
.92857 .34508 Mdot
.93095 .34511 Mdot
.93333 .34515 Mdot
.93571 .34518 Mdot
.9381 .34522 Mdot
.94048 .34526 Mdot
.94286 .34529 Mdot
.94524 .34533 Mdot
.94762 .34537 Mdot
.95 .3454 Mdot
.95238 .34544 Mdot
.95476 .34548 Mdot
.95714 .34551 Mdot
.95952 .34555 Mdot
.9619 .34558 Mdot
.96429 .34562 Mdot
.96667 .34566 Mdot
.96905 .34569 Mdot
.97143 .34573 Mdot
.97381 .34577 Mdot
.97619 .3458 Mdot
.02381 .35835 Mdot
.02619 .3584 Mdot
.02857 .35844 Mdot
.03095 .35849 Mdot
.03333 .35854 Mdot
.03571 .35859 Mdot
.0381 .35864 Mdot
.04048 .35869 Mdot
.04286 .35874 Mdot
.04524 .35879 Mdot
.04762 .35884 Mdot
.05 .35889 Mdot
.05238 .35894 Mdot
.05476 .35899 Mdot
.05714 .35904 Mdot
.05952 .35909 Mdot
.0619 .35914 Mdot
.06429 .35919 Mdot
.06667 .35924 Mdot
.06905 .35929 Mdot
.07143 .35934 Mdot
.07381 .35939 Mdot
.07619 .35944 Mdot
.07857 .35949 Mdot
.08095 .35954 Mdot
.08333 .35959 Mdot
.08571 .35964 Mdot
.0881 .3597 Mdot
.09048 .35975 Mdot
.09286 .3598 Mdot
.09524 .35985 Mdot
.09762 .3599 Mdot
.1 .35995 Mdot
.10238 .36 Mdot
.10476 .36005 Mdot
.10714 .3601 Mdot
.10952 .36015 Mdot
.1119 .3602 Mdot
.11429 .36026 Mdot
.11667 .36031 Mdot
.11905 .36036 Mdot
.12143 .36041 Mdot
.12381 .36046 Mdot
.12619 .36051 Mdot
.12857 .36056 Mdot
.13095 .36062 Mdot
.13333 .36067 Mdot
.13571 .36072 Mdot
.1381 .36077 Mdot
.14048 .36082 Mdot
.14286 .36087 Mdot
.14524 .36093 Mdot
.14762 .36098 Mdot
.15 .36103 Mdot
.15238 .36108 Mdot
.15476 .36113 Mdot
.15714 .36119 Mdot
.15952 .36124 Mdot
.1619 .36129 Mdot
.16429 .36134 Mdot
.16667 .36139 Mdot
.16905 .36145 Mdot
.17143 .3615 Mdot
.17381 .36155 Mdot
.17619 .3616 Mdot
.17857 .36166 Mdot
.18095 .36171 Mdot
.18333 .36176 Mdot
.18571 .36182 Mdot
.1881 .36187 Mdot
.19048 .36192 Mdot
.19286 .36197 Mdot
.19524 .36203 Mdot
.19762 .36208 Mdot
.2 .36213 Mdot
.20238 .36219 Mdot
.20476 .36224 Mdot
.20714 .36229 Mdot
.20952 .36235 Mdot
.2119 .3624 Mdot
.21429 .36245 Mdot
.21667 .36251 Mdot
.21905 .36256 Mdot
.22143 .36261 Mdot
.22381 .36267 Mdot
.22619 .36272 Mdot
.22857 .36277 Mdot
.23095 .36283 Mdot
.23333 .36288 Mdot
.23571 .36294 Mdot
.2381 .36299 Mdot
.24048 .36304 Mdot
.24286 .3631 Mdot
.24524 .36315 Mdot
.24762 .36321 Mdot
.25 .36326 Mdot
.25238 .36331 Mdot
.25476 .36337 Mdot
.25714 .36342 Mdot
.25952 .36348 Mdot
.2619 .36353 Mdot
.26429 .36359 Mdot
.26667 .36364 Mdot
.26905 .36369 Mdot
.27143 .36375 Mdot
.27381 .3638 Mdot
.27619 .36386 Mdot
.27857 .36391 Mdot
.28095 .36397 Mdot
.28333 .36402 Mdot
.28571 .36408 Mdot
.2881 .36413 Mdot
.29048 .36419 Mdot
.29286 .36424 Mdot
.29524 .3643 Mdot
.29762 .36435 Mdot
.3 .36441 Mdot
.30238 .36447 Mdot
.30476 .36452 Mdot
.30714 .36458 Mdot
.30952 .36463 Mdot
.3119 .36469 Mdot
.31429 .36474 Mdot
.31667 .3648 Mdot
.31905 .36485 Mdot
.32143 .36491 Mdot
.32381 .36497 Mdot
.32619 .36502 Mdot
.32857 .36508 Mdot
.33095 .36513 Mdot
.33333 .36519 Mdot
.33571 .36525 Mdot
.3381 .3653 Mdot
.34048 .36536 Mdot
.34286 .36542 Mdot
.34524 .36547 Mdot
.34762 .36553 Mdot
.35 .36558 Mdot
.35238 .36564 Mdot
.35476 .3657 Mdot
.35714 .36575 Mdot
.35952 .36581 Mdot
.3619 .36587 Mdot
.36429 .36593 Mdot
.36667 .36598 Mdot
.36905 .36604 Mdot
.37143 .3661 Mdot
.37381 .36615 Mdot
.37619 .36621 Mdot
.37857 .36627 Mdot
.38095 .36632 Mdot
.38333 .36638 Mdot
.38571 .36644 Mdot
.3881 .3665 Mdot
.39048 .36655 Mdot
.39286 .36661 Mdot
.39524 .36667 Mdot
.39762 .36673 Mdot
.4 .36678 Mdot
.40238 .36684 Mdot
.40476 .3669 Mdot
.40714 .36696 Mdot
.40952 .36702 Mdot
.4119 .36707 Mdot
.41429 .36713 Mdot
.41667 .36719 Mdot
.41905 .36725 Mdot
.42143 .36731 Mdot
.42381 .36737 Mdot
.42619 .36742 Mdot
.42857 .36748 Mdot
.43095 .36754 Mdot
.43333 .3676 Mdot
.43571 .36766 Mdot
.4381 .36772 Mdot
.44048 .36777 Mdot
.44286 .36783 Mdot
.44524 .36789 Mdot
.44762 .36795 Mdot
.45 .36801 Mdot
.45238 .36807 Mdot
.45476 .36813 Mdot
.45714 .36819 Mdot
.45952 .36825 Mdot
.4619 .36831 Mdot
.46429 .36837 Mdot
.46667 .36842 Mdot
.46905 .36848 Mdot
.47143 .36854 Mdot
.47381 .3686 Mdot
.47619 .36866 Mdot
.47857 .36872 Mdot
.48095 .36878 Mdot
.48333 .36884 Mdot
.48571 .3689 Mdot
.4881 .36896 Mdot
.49048 .36902 Mdot
.49286 .36908 Mdot
.49524 .36914 Mdot
.49762 .3692 Mdot
.5 .36926 Mdot
.50238 .36932 Mdot
.50476 .36938 Mdot
.50714 .36944 Mdot
.50952 .3695 Mdot
.5119 .36956 Mdot
.51429 .36962 Mdot
.51667 .36968 Mdot
.51905 .36975 Mdot
.52143 .36981 Mdot
.52381 .36987 Mdot
.52619 .36993 Mdot
.52857 .36999 Mdot
.53095 .37005 Mdot
.53333 .37011 Mdot
.53571 .37017 Mdot
.5381 .37023 Mdot
.54048 .37029 Mdot
.54286 .37036 Mdot
.54524 .37042 Mdot
.54762 .37048 Mdot
.55 .37054 Mdot
.55238 .3706 Mdot
.55476 .37066 Mdot
.55714 .37072 Mdot
.55952 .37079 Mdot
.5619 .37085 Mdot
.56429 .37091 Mdot
.56667 .37097 Mdot
.56905 .37103 Mdot
.57143 .3711 Mdot
.57381 .37116 Mdot
.57619 .37122 Mdot
.57857 .37128 Mdot
.58095 .37134 Mdot
.58333 .37141 Mdot
.58571 .37147 Mdot
.5881 .37153 Mdot
.59048 .37159 Mdot
.59286 .37166 Mdot
.59524 .37172 Mdot
.59762 .37178 Mdot
.6 .37184 Mdot
.60238 .37191 Mdot
.60476 .37197 Mdot
.60714 .37203 Mdot
.60952 .3721 Mdot
.6119 .37216 Mdot
.61429 .37222 Mdot
.61667 .37229 Mdot
.61905 .37235 Mdot
.62143 .37241 Mdot
.62381 .37248 Mdot
.62619 .37254 Mdot
.62857 .3726 Mdot
.63095 .37267 Mdot
.63333 .37273 Mdot
.63571 .37279 Mdot
.6381 .37286 Mdot
.64048 .37292 Mdot
.64286 .37298 Mdot
.64524 .37305 Mdot
.64762 .37311 Mdot
.65 .37318 Mdot
.65238 .37324 Mdot
.65476 .37331 Mdot
.65714 .37337 Mdot
.65952 .37343 Mdot
.6619 .3735 Mdot
.66429 .37356 Mdot
.66667 .37363 Mdot
.66905 .37369 Mdot
.67143 .37376 Mdot
.67381 .37382 Mdot
.67619 .37389 Mdot
.67857 .37395 Mdot
.68095 .37402 Mdot
.68333 .37408 Mdot
.68571 .37415 Mdot
.6881 .37421 Mdot
.69048 .37428 Mdot
.69286 .37434 Mdot
.69524 .37441 Mdot
.69762 .37447 Mdot
.7 .37454 Mdot
.70238 .3746 Mdot
.70476 .37467 Mdot
.70714 .37473 Mdot
.70952 .3748 Mdot
.7119 .37487 Mdot
.71429 .37493 Mdot
.71667 .375 Mdot
.71905 .37506 Mdot
.72143 .37513 Mdot
.72381 .3752 Mdot
.72619 .37526 Mdot
.72857 .37533 Mdot
.73095 .37539 Mdot
.73333 .37546 Mdot
.73571 .37553 Mdot
.7381 .37559 Mdot
.74048 .37566 Mdot
.74286 .37573 Mdot
.74524 .37579 Mdot
.74762 .37586 Mdot
.75 .37593 Mdot
.75238 .37599 Mdot
.75476 .37606 Mdot
.75714 .37613 Mdot
.75952 .3762 Mdot
.7619 .37626 Mdot
.76429 .37633 Mdot
.76667 .3764 Mdot
.76905 .37646 Mdot
.77143 .37653 Mdot
.77381 .3766 Mdot
.77619 .37667 Mdot
.77857 .37674 Mdot
.78095 .3768 Mdot
.78333 .37687 Mdot
.78571 .37694 Mdot
.7881 .37701 Mdot
.79048 .37707 Mdot
.79286 .37714 Mdot
.79524 .37721 Mdot
.79762 .37728 Mdot
.8 .37735 Mdot
.80238 .37742 Mdot
.80476 .37748 Mdot
.80714 .37755 Mdot
.80952 .37762 Mdot
.8119 .37769 Mdot
.81429 .37776 Mdot
.81667 .37783 Mdot
.81905 .3779 Mdot
.82143 .37796 Mdot
.82381 .37803 Mdot
.82619 .3781 Mdot
.82857 .37817 Mdot
.83095 .37824 Mdot
.83333 .37831 Mdot
.83571 .37838 Mdot
.8381 .37845 Mdot
.84048 .37852 Mdot
.84286 .37859 Mdot
.84524 .37866 Mdot
.84762 .37873 Mdot
.85 .3788 Mdot
.85238 .37887 Mdot
.85476 .37894 Mdot
.85714 .37901 Mdot
.85952 .37908 Mdot
.8619 .37915 Mdot
.86429 .37922 Mdot
.86667 .37929 Mdot
.86905 .37936 Mdot
.87143 .37943 Mdot
.87381 .3795 Mdot
.87619 .37957 Mdot
.87857 .37964 Mdot
.88095 .37971 Mdot
.88333 .37978 Mdot
.88571 .37985 Mdot
.8881 .37992 Mdot
.89048 .37999 Mdot
.89286 .38006 Mdot
.89524 .38013 Mdot
.89762 .38021 Mdot
.9 .38028 Mdot
.90238 .38035 Mdot
.90476 .38042 Mdot
.90714 .38049 Mdot
.90952 .38056 Mdot
.9119 .38063 Mdot
.91429 .38071 Mdot
.91667 .38078 Mdot
.91905 .38085 Mdot
.92143 .38092 Mdot
.92381 .38099 Mdot
.92619 .38106 Mdot
.92857 .38114 Mdot
.93095 .38121 Mdot
.93333 .38128 Mdot
.93571 .38135 Mdot
.9381 .38143 Mdot
.94048 .3815 Mdot
.94286 .38157 Mdot
.94524 .38164 Mdot
.94762 .38172 Mdot
.95 .38179 Mdot
.95238 .38186 Mdot
.95476 .38193 Mdot
.95714 .38201 Mdot
.95952 .38208 Mdot
.9619 .38215 Mdot
.96429 .38223 Mdot
.96667 .3823 Mdot
.96905 .38237 Mdot
.97143 .38245 Mdot
.97381 .38252 Mdot
.97619 .38259 Mdot
.02381 .38301 Mdot
.02619 .38308 Mdot
.02857 .38316 Mdot
.03095 .38323 Mdot
.03333 .38331 Mdot
.03571 .38338 Mdot
.0381 .38346 Mdot
.04048 .38353 Mdot
.04286 .3836 Mdot
.04524 .38368 Mdot
.04762 .38375 Mdot
.05 .38383 Mdot
.05238 .3839 Mdot
.05476 .38398 Mdot
.05714 .38405 Mdot
.05952 .38413 Mdot
.0619 .3842 Mdot
.06429 .38428 Mdot
.06667 .38435 Mdot
.06905 .38443 Mdot
.07143 .3845 Mdot
.07381 .38458 Mdot
.07619 .38466 Mdot
.07857 .38473 Mdot
.08095 .38481 Mdot
.08333 .38488 Mdot
.08571 .38496 Mdot
.0881 .38503 Mdot
.09048 .38511 Mdot
.09286 .38519 Mdot
.09524 .38526 Mdot
.09762 .38534 Mdot
.1 .38542 Mdot
.10238 .38549 Mdot
.10476 .38557 Mdot
.10714 .38564 Mdot
.10952 .38572 Mdot
.1119 .3858 Mdot
.11429 .38587 Mdot
.11667 .38595 Mdot
.11905 .38603 Mdot
.12143 .38611 Mdot
.12381 .38618 Mdot
.12619 .38626 Mdot
.12857 .38634 Mdot
.13095 .38641 Mdot
.13333 .38649 Mdot
.13571 .38657 Mdot
.1381 .38665 Mdot
.14048 .38672 Mdot
.14286 .3868 Mdot
.14524 .38688 Mdot
.14762 .38696 Mdot
.15 .38704 Mdot
.15238 .38711 Mdot
.15476 .38719 Mdot
.15714 .38727 Mdot
.15952 .38735 Mdot
.1619 .38743 Mdot
.16429 .38751 Mdot
.16667 .38758 Mdot
.16905 .38766 Mdot
.17143 .38774 Mdot
.17381 .38782 Mdot
.17619 .3879 Mdot
.17857 .38798 Mdot
.18095 .38806 Mdot
.18333 .38814 Mdot
.18571 .38821 Mdot
.1881 .38829 Mdot
.19048 .38837 Mdot
.19286 .38845 Mdot
.19524 .38853 Mdot
.19762 .38861 Mdot
.2 .38869 Mdot
.20238 .38877 Mdot
.20476 .38885 Mdot
.20714 .38893 Mdot
.20952 .38901 Mdot
.2119 .38909 Mdot
.21429 .38917 Mdot
.21667 .38925 Mdot
.21905 .38933 Mdot
.22143 .38941 Mdot
.22381 .38949 Mdot
.22619 .38957 Mdot
.22857 .38965 Mdot
.23095 .38973 Mdot
.23333 .38981 Mdot
.23571 .38989 Mdot
.2381 .38998 Mdot
.24048 .39006 Mdot
.24286 .39014 Mdot
.24524 .39022 Mdot
.24762 .3903 Mdot
.25 .39038 Mdot
.25238 .39046 Mdot
.25476 .39054 Mdot
.25714 .39063 Mdot
.25952 .39071 Mdot
.2619 .39079 Mdot
.26429 .39087 Mdot
.26667 .39095 Mdot
.26905 .39103 Mdot
.27143 .39112 Mdot
.27381 .3912 Mdot
.27619 .39128 Mdot
.27857 .39136 Mdot
.28095 .39144 Mdot
.28333 .39153 Mdot
.28571 .39161 Mdot
.2881 .39169 Mdot
.29048 .39178 Mdot
.29286 .39186 Mdot
.29524 .39194 Mdot
.29762 .39202 Mdot
.3 .39211 Mdot
.30238 .39219 Mdot
.30476 .39227 Mdot
.30714 .39236 Mdot
.30952 .39244 Mdot
.3119 .39252 Mdot
.31429 .39261 Mdot
.31667 .39269 Mdot
.31905 .39277 Mdot
.32143 .39286 Mdot
.32381 .39294 Mdot
.32619 .39303 Mdot
.32857 .39311 Mdot
.33095 .39319 Mdot
.33333 .39328 Mdot
.33571 .39336 Mdot
.3381 .39345 Mdot
.34048 .39353 Mdot
.34286 .39361 Mdot
.34524 .3937 Mdot
.34762 .39378 Mdot
.35 .39387 Mdot
.35238 .39395 Mdot
.35476 .39404 Mdot
.35714 .39412 Mdot
.35952 .39421 Mdot
.3619 .39429 Mdot
.36429 .39438 Mdot
.36667 .39446 Mdot
.36905 .39455 Mdot
.37143 .39464 Mdot
.37381 .39472 Mdot
.37619 .39481 Mdot
.37857 .39489 Mdot
.38095 .39498 Mdot
.38333 .39506 Mdot
.38571 .39515 Mdot
.3881 .39524 Mdot
.39048 .39532 Mdot
.39286 .39541 Mdot
.39524 .3955 Mdot
.39762 .39558 Mdot
.4 .39567 Mdot
.40238 .39576 Mdot
.40476 .39584 Mdot
.40714 .39593 Mdot
.40952 .39602 Mdot
.4119 .3961 Mdot
.41429 .39619 Mdot
.41667 .39628 Mdot
.41905 .39636 Mdot
.42143 .39645 Mdot
.42381 .39654 Mdot
.42619 .39663 Mdot
.42857 .39671 Mdot
.43095 .3968 Mdot
.43333 .39689 Mdot
.43571 .39698 Mdot
.4381 .39707 Mdot
.44048 .39715 Mdot
.44286 .39724 Mdot
.44524 .39733 Mdot
.44762 .39742 Mdot
.45 .39751 Mdot
.45238 .3976 Mdot
.45476 .39768 Mdot
.45714 .39777 Mdot
.45952 .39786 Mdot
.4619 .39795 Mdot
.46429 .39804 Mdot
.46667 .39813 Mdot
.46905 .39822 Mdot
.47143 .39831 Mdot
.47381 .3984 Mdot
.47619 .39849 Mdot
.47857 .39857 Mdot
.48095 .39866 Mdot
.48333 .39875 Mdot
.48571 .39884 Mdot
.4881 .39893 Mdot
.49048 .39902 Mdot
.49286 .39911 Mdot
.49524 .3992 Mdot
.49762 .39929 Mdot
.5 .39938 Mdot
.50238 .39947 Mdot
.50476 .39956 Mdot
.50714 .39966 Mdot
.50952 .39975 Mdot
.5119 .39984 Mdot
.51429 .39993 Mdot
.51667 .40002 Mdot
.51905 .40011 Mdot
.52143 .4002 Mdot
.52381 .40029 Mdot
.52619 .40038 Mdot
.52857 .40047 Mdot
.53095 .40057 Mdot
.53333 .40066 Mdot
.53571 .40075 Mdot
.5381 .40084 Mdot
.54048 .40093 Mdot
.54286 .40102 Mdot
.54524 .40112 Mdot
.54762 .40121 Mdot
.55 .4013 Mdot
.55238 .40139 Mdot
.55476 .40149 Mdot
.55714 .40158 Mdot
.55952 .40167 Mdot
.5619 .40176 Mdot
.56429 .40186 Mdot
.56667 .40195 Mdot
.56905 .40204 Mdot
.57143 .40213 Mdot
.57381 .40223 Mdot
.57619 .40232 Mdot
.57857 .40241 Mdot
.58095 .40251 Mdot
.58333 .4026 Mdot
.58571 .40269 Mdot
.5881 .40279 Mdot
.59048 .40288 Mdot
.59286 .40298 Mdot
.59524 .40307 Mdot
.59762 .40316 Mdot
.6 .40326 Mdot
.60238 .40335 Mdot
.60476 .40345 Mdot
.60714 .40354 Mdot
.60952 .40364 Mdot
.6119 .40373 Mdot
.61429 .40382 Mdot
.61667 .40392 Mdot
.61905 .40401 Mdot
.62143 .40411 Mdot
.62381 .4042 Mdot
.62619 .4043 Mdot
.62857 .4044 Mdot
.63095 .40449 Mdot
.63333 .40459 Mdot
.63571 .40468 Mdot
.6381 .40478 Mdot
.64048 .40487 Mdot
.64286 .40497 Mdot
.64524 .40506 Mdot
.64762 .40516 Mdot
.65 .40526 Mdot
.65238 .40535 Mdot
.65476 .40545 Mdot
.65714 .40555 Mdot
.65952 .40564 Mdot
.6619 .40574 Mdot
.66429 .40584 Mdot
.66667 .40593 Mdot
.66905 .40603 Mdot
.67143 .40613 Mdot
.67381 .40622 Mdot
.67619 .40632 Mdot
.67857 .40642 Mdot
.68095 .40652 Mdot
.68333 .40661 Mdot
.68571 .40671 Mdot
.6881 .40681 Mdot
.69048 .40691 Mdot
.69286 .407 Mdot
.69524 .4071 Mdot
.69762 .4072 Mdot
.7 .4073 Mdot
.70238 .4074 Mdot
.70476 .4075 Mdot
.70714 .40759 Mdot
.70952 .40769 Mdot
.7119 .40779 Mdot
.71429 .40789 Mdot
.71667 .40799 Mdot
.71905 .40809 Mdot
.72143 .40819 Mdot
.72381 .40829 Mdot
.72619 .40838 Mdot
.72857 .40848 Mdot
.73095 .40858 Mdot
.73333 .40868 Mdot
.73571 .40878 Mdot
.7381 .40888 Mdot
.74048 .40898 Mdot
.74286 .40908 Mdot
.74524 .40918 Mdot
.74762 .40928 Mdot
.75 .40938 Mdot
.75238 .40948 Mdot
.75476 .40958 Mdot
.75714 .40968 Mdot
.75952 .40979 Mdot
.7619 .40989 Mdot
.76429 .40999 Mdot
.76667 .41009 Mdot
.76905 .41019 Mdot
.77143 .41029 Mdot
.77381 .41039 Mdot
.77619 .41049 Mdot
.77857 .41059 Mdot
.78095 .4107 Mdot
.78333 .4108 Mdot
.78571 .4109 Mdot
.7881 .411 Mdot
.79048 .4111 Mdot
.79286 .41121 Mdot
.79524 .41131 Mdot
.79762 .41141 Mdot
.8 .41151 Mdot
.80238 .41161 Mdot
.80476 .41172 Mdot
.80714 .41182 Mdot
.80952 .41192 Mdot
.8119 .41203 Mdot
.81429 .41213 Mdot
.81667 .41223 Mdot
.81905 .41233 Mdot
.82143 .41244 Mdot
.82381 .41254 Mdot
.82619 .41265 Mdot
.82857 .41275 Mdot
.83095 .41285 Mdot
.83333 .41296 Mdot
.83571 .41306 Mdot
.8381 .41316 Mdot
.84048 .41327 Mdot
.84286 .41337 Mdot
.84524 .41348 Mdot
.84762 .41358 Mdot
.85 .41369 Mdot
.85238 .41379 Mdot
.85476 .4139 Mdot
.85714 .414 Mdot
.85952 .41411 Mdot
.8619 .41421 Mdot
.86429 .41432 Mdot
.86667 .41442 Mdot
.86905 .41453 Mdot
.87143 .41463 Mdot
.87381 .41474 Mdot
.87619 .41484 Mdot
.87857 .41495 Mdot
.88095 .41505 Mdot
.88333 .41516 Mdot
.88571 .41527 Mdot
.8881 .41537 Mdot
.89048 .41548 Mdot
.89286 .41559 Mdot
.89524 .41569 Mdot
.89762 .4158 Mdot
.9 .41591 Mdot
.90238 .41601 Mdot
.90476 .41612 Mdot
.90714 .41623 Mdot
.90952 .41633 Mdot
.9119 .41644 Mdot
.91429 .41655 Mdot
.91667 .41666 Mdot
.91905 .41676 Mdot
.92143 .41687 Mdot
.92381 .41698 Mdot
.92619 .41709 Mdot
.92857 .4172 Mdot
.93095 .4173 Mdot
.93333 .41741 Mdot
.93571 .41752 Mdot
.9381 .41763 Mdot
.94048 .41774 Mdot
.94286 .41785 Mdot
.94524 .41796 Mdot
.94762 .41806 Mdot
.95 .41817 Mdot
.95238 .41828 Mdot
.95476 .41839 Mdot
.95714 .4185 Mdot
.95952 .41861 Mdot
.9619 .41872 Mdot
.96429 .41883 Mdot
.96667 .41894 Mdot
.96905 .41905 Mdot
.97143 .41916 Mdot
.97381 .41927 Mdot
.97619 .41938 Mdot
.02381 .40767 Mdot
.02619 .40777 Mdot
.02857 .40787 Mdot
.03095 .40797 Mdot
.03333 .40807 Mdot
.03571 .40817 Mdot
.0381 .40827 Mdot
.04048 .40837 Mdot
.04286 .40847 Mdot
.04524 .40857 Mdot
.04762 .40867 Mdot
.05 .40877 Mdot
.05238 .40887 Mdot
.05476 .40897 Mdot
.05714 .40907 Mdot
.05952 .40917 Mdot
.0619 .40927 Mdot
.06429 .40937 Mdot
.06667 .40947 Mdot
.06905 .40957 Mdot
.07143 .40967 Mdot
.07381 .40977 Mdot
.07619 .40987 Mdot
.07857 .40997 Mdot
.08095 .41007 Mdot
.08333 .41017 Mdot
.08571 .41027 Mdot
.0881 .41037 Mdot
.09048 .41047 Mdot
.09286 .41058 Mdot
.09524 .41068 Mdot
.09762 .41078 Mdot
.1 .41088 Mdot
.10238 .41098 Mdot
.10476 .41109 Mdot
.10714 .41119 Mdot
.10952 .41129 Mdot
.1119 .41139 Mdot
.11429 .41149 Mdot
.11667 .4116 Mdot
.11905 .4117 Mdot
.12143 .4118 Mdot
.12381 .4119 Mdot
.12619 .41201 Mdot
.12857 .41211 Mdot
.13095 .41221 Mdot
.13333 .41232 Mdot
.13571 .41242 Mdot
.1381 .41252 Mdot
.14048 .41263 Mdot
.14286 .41273 Mdot
.14524 .41283 Mdot
.14762 .41294 Mdot
.15 .41304 Mdot
.15238 .41315 Mdot
.15476 .41325 Mdot
.15714 .41335 Mdot
.15952 .41346 Mdot
.1619 .41356 Mdot
.16429 .41367 Mdot
.16667 .41377 Mdot
.16905 .41388 Mdot
.17143 .41398 Mdot
.17381 .41409 Mdot
.17619 .41419 Mdot
.17857 .4143 Mdot
.18095 .4144 Mdot
.18333 .41451 Mdot
.18571 .41461 Mdot
.1881 .41472 Mdot
.19048 .41482 Mdot
.19286 .41493 Mdot
.19524 .41504 Mdot
.19762 .41514 Mdot
.2 .41525 Mdot
.20238 .41535 Mdot
.20476 .41546 Mdot
.20714 .41557 Mdot
.20952 .41567 Mdot
.2119 .41578 Mdot
.21429 .41589 Mdot
.21667 .41599 Mdot
.21905 .4161 Mdot
.22143 .41621 Mdot
.22381 .41632 Mdot
.22619 .41642 Mdot
.22857 .41653 Mdot
.23095 .41664 Mdot
.23333 .41675 Mdot
.23571 .41685 Mdot
.2381 .41696 Mdot
.24048 .41707 Mdot
.24286 .41718 Mdot
.24524 .41729 Mdot
.24762 .41739 Mdot
.25 .4175 Mdot
.25238 .41761 Mdot
.25476 .41772 Mdot
.25714 .41783 Mdot
.25952 .41794 Mdot
.2619 .41805 Mdot
.26429 .41815 Mdot
.26667 .41826 Mdot
.26905 .41837 Mdot
.27143 .41848 Mdot
.27381 .41859 Mdot
.27619 .4187 Mdot
.27857 .41881 Mdot
.28095 .41892 Mdot
.28333 .41903 Mdot
.28571 .41914 Mdot
.2881 .41925 Mdot
.29048 .41936 Mdot
.29286 .41947 Mdot
.29524 .41958 Mdot
.29762 .41969 Mdot
.3 .4198 Mdot
.30238 .41991 Mdot
.30476 .42002 Mdot
.30714 .42014 Mdot
.30952 .42025 Mdot
.3119 .42036 Mdot
.31429 .42047 Mdot
.31667 .42058 Mdot
.31905 .42069 Mdot
.32143 .4208 Mdot
.32381 .42092 Mdot
.32619 .42103 Mdot
.32857 .42114 Mdot
.33095 .42125 Mdot
.33333 .42136 Mdot
.33571 .42148 Mdot
.3381 .42159 Mdot
.34048 .4217 Mdot
.34286 .42181 Mdot
.34524 .42193 Mdot
.34762 .42204 Mdot
.35 .42215 Mdot
.35238 .42227 Mdot
.35476 .42238 Mdot
.35714 .42249 Mdot
.35952 .42261 Mdot
.3619 .42272 Mdot
.36429 .42283 Mdot
.36667 .42295 Mdot
.36905 .42306 Mdot
.37143 .42318 Mdot
.37381 .42329 Mdot
.37619 .4234 Mdot
.37857 .42352 Mdot
.38095 .42363 Mdot
.38333 .42375 Mdot
.38571 .42386 Mdot
.3881 .42398 Mdot
.39048 .42409 Mdot
.39286 .42421 Mdot
.39524 .42432 Mdot
.39762 .42444 Mdot
.4 .42455 Mdot
.40238 .42467 Mdot
.40476 .42478 Mdot
.40714 .4249 Mdot
.40952 .42502 Mdot
.4119 .42513 Mdot
.41429 .42525 Mdot
.41667 .42536 Mdot
.41905 .42548 Mdot
.42143 .4256 Mdot
.42381 .42571 Mdot
.42619 .42583 Mdot
.42857 .42595 Mdot
.43095 .42606 Mdot
.43333 .42618 Mdot
.43571 .4263 Mdot
.4381 .42642 Mdot
.44048 .42653 Mdot
.44286 .42665 Mdot
.44524 .42677 Mdot
.44762 .42689 Mdot
.45 .427 Mdot
.45238 .42712 Mdot
.45476 .42724 Mdot
.45714 .42736 Mdot
.45952 .42748 Mdot
.4619 .42759 Mdot
.46429 .42771 Mdot
.46667 .42783 Mdot
.46905 .42795 Mdot
.47143 .42807 Mdot
.47381 .42819 Mdot
.47619 .42831 Mdot
.47857 .42843 Mdot
.48095 .42855 Mdot
.48333 .42867 Mdot
.48571 .42879 Mdot
.4881 .42891 Mdot
.49048 .42903 Mdot
.49286 .42915 Mdot
.49524 .42927 Mdot
.49762 .42939 Mdot
.5 .42951 Mdot
.50238 .42963 Mdot
.50476 .42975 Mdot
.50714 .42987 Mdot
.50952 .42999 Mdot
.5119 .43011 Mdot
.51429 .43023 Mdot
.51667 .43035 Mdot
.51905 .43047 Mdot
.52143 .43059 Mdot
.52381 .43072 Mdot
.52619 .43084 Mdot
.52857 .43096 Mdot
.53095 .43108 Mdot
.53333 .4312 Mdot
.53571 .43133 Mdot
.5381 .43145 Mdot
.54048 .43157 Mdot
.54286 .43169 Mdot
.54524 .43182 Mdot
.54762 .43194 Mdot
.55 .43206 Mdot
.55238 .43218 Mdot
.55476 .43231 Mdot
.55714 .43243 Mdot
.55952 .43255 Mdot
.5619 .43268 Mdot
.56429 .4328 Mdot
.56667 .43293 Mdot
.56905 .43305 Mdot
.57143 .43317 Mdot
.57381 .4333 Mdot
.57619 .43342 Mdot
.57857 .43355 Mdot
.58095 .43367 Mdot
.58333 .4338 Mdot
.58571 .43392 Mdot
.5881 .43405 Mdot
.59048 .43417 Mdot
.59286 .4343 Mdot
.59524 .43442 Mdot
.59762 .43455 Mdot
.6 .43467 Mdot
.60238 .4348 Mdot
.60476 .43492 Mdot
.60714 .43505 Mdot
.60952 .43518 Mdot
.6119 .4353 Mdot
.61429 .43543 Mdot
.61667 .43555 Mdot
.61905 .43568 Mdot
.62143 .43581 Mdot
.62381 .43593 Mdot
.62619 .43606 Mdot
.62857 .43619 Mdot
.63095 .43632 Mdot
.63333 .43644 Mdot
.63571 .43657 Mdot
.6381 .4367 Mdot
.64048 .43683 Mdot
.64286 .43695 Mdot
.64524 .43708 Mdot
.64762 .43721 Mdot
.65 .43734 Mdot
.65238 .43747 Mdot
.65476 .43759 Mdot
.65714 .43772 Mdot
.65952 .43785 Mdot
.6619 .43798 Mdot
.66429 .43811 Mdot
.66667 .43824 Mdot
.66905 .43837 Mdot
.67143 .4385 Mdot
.67381 .43863 Mdot
.67619 .43876 Mdot
.67857 .43889 Mdot
.68095 .43902 Mdot
.68333 .43915 Mdot
.68571 .43928 Mdot
.6881 .43941 Mdot
.69048 .43954 Mdot
.69286 .43967 Mdot
.69524 .4398 Mdot
.69762 .43993 Mdot
.7 .44006 Mdot
.70238 .44019 Mdot
.70476 .44032 Mdot
.70714 .44045 Mdot
.70952 .44058 Mdot
.7119 .44072 Mdot
.71429 .44085 Mdot
.71667 .44098 Mdot
.71905 .44111 Mdot
.72143 .44124 Mdot
.72381 .44138 Mdot
.72619 .44151 Mdot
.72857 .44164 Mdot
.73095 .44177 Mdot
.73333 .44191 Mdot
.73571 .44204 Mdot
.7381 .44217 Mdot
.74048 .4423 Mdot
.74286 .44244 Mdot
.74524 .44257 Mdot
.74762 .4427 Mdot
.75 .44284 Mdot
.75238 .44297 Mdot
.75476 .44311 Mdot
.75714 .44324 Mdot
.75952 .44337 Mdot
.7619 .44351 Mdot
.76429 .44364 Mdot
.76667 .44378 Mdot
.76905 .44391 Mdot
.77143 .44405 Mdot
.77381 .44418 Mdot
.77619 .44432 Mdot
.77857 .44445 Mdot
.78095 .44459 Mdot
.78333 .44472 Mdot
.78571 .44486 Mdot
.7881 .445 Mdot
.79048 .44513 Mdot
.79286 .44527 Mdot
.79524 .4454 Mdot
.79762 .44554 Mdot
.8 .44568 Mdot
.80238 .44581 Mdot
.80476 .44595 Mdot
.80714 .44609 Mdot
.80952 .44622 Mdot
.8119 .44636 Mdot
.81429 .4465 Mdot
.81667 .44664 Mdot
.81905 .44677 Mdot
.82143 .44691 Mdot
.82381 .44705 Mdot
.82619 .44719 Mdot
.82857 .44733 Mdot
.83095 .44746 Mdot
.83333 .4476 Mdot
.83571 .44774 Mdot
.8381 .44788 Mdot
.84048 .44802 Mdot
.84286 .44816 Mdot
.84524 .4483 Mdot
.84762 .44844 Mdot
.85 .44858 Mdot
.85238 .44872 Mdot
.85476 .44885 Mdot
.85714 .44899 Mdot
.85952 .44913 Mdot
.8619 .44927 Mdot
.86429 .44942 Mdot
.86667 .44956 Mdot
.86905 .4497 Mdot
.87143 .44984 Mdot
.87381 .44998 Mdot
.87619 .45012 Mdot
.87857 .45026 Mdot
.88095 .4504 Mdot
.88333 .45054 Mdot
.88571 .45068 Mdot
.8881 .45083 Mdot
.89048 .45097 Mdot
.89286 .45111 Mdot
.89524 .45125 Mdot
.89762 .45139 Mdot
.9 .45154 Mdot
.90238 .45168 Mdot
.90476 .45182 Mdot
.90714 .45196 Mdot
.90952 .45211 Mdot
.9119 .45225 Mdot
.91429 .45239 Mdot
.91667 .45254 Mdot
.91905 .45268 Mdot
.92143 .45282 Mdot
.92381 .45297 Mdot
.92619 .45311 Mdot
.92857 .45326 Mdot
.93095 .4534 Mdot
.93333 .45354 Mdot
.93571 .45369 Mdot
.9381 .45383 Mdot
.94048 .45398 Mdot
.94286 .45412 Mdot
.94524 .45427 Mdot
.94762 .45441 Mdot
.95 .45456 Mdot
.95238 .4547 Mdot
.95476 .45485 Mdot
.95714 .455 Mdot
.95952 .45514 Mdot
.9619 .45529 Mdot
.96429 .45543 Mdot
.96667 .45558 Mdot
.96905 .45573 Mdot
.97143 .45587 Mdot
.97381 .45602 Mdot
.97619 .45617 Mdot
.02381 .43234 Mdot
.02619 .43246 Mdot
.02857 .43259 Mdot
.03095 .43271 Mdot
.03333 .43283 Mdot
.03571 .43296 Mdot
.0381 .43308 Mdot
.04048 .43321 Mdot
.04286 .43333 Mdot
.04524 .43345 Mdot
.04762 .43358 Mdot
.05 .4337 Mdot
.05238 .43383 Mdot
.05476 .43395 Mdot
.05714 .43408 Mdot
.05952 .4342 Mdot
.0619 .43433 Mdot
.06429 .43445 Mdot
.06667 .43458 Mdot
.06905 .4347 Mdot
.07143 .43483 Mdot
.07381 .43496 Mdot
.07619 .43508 Mdot
.07857 .43521 Mdot
.08095 .43533 Mdot
.08333 .43546 Mdot
.08571 .43559 Mdot
.0881 .43571 Mdot
.09048 .43584 Mdot
.09286 .43597 Mdot
.09524 .43609 Mdot
.09762 .43622 Mdot
.1 .43635 Mdot
.10238 .43647 Mdot
.10476 .4366 Mdot
.10714 .43673 Mdot
.10952 .43686 Mdot
.1119 .43699 Mdot
.11429 .43711 Mdot
.11667 .43724 Mdot
.11905 .43737 Mdot
.12143 .4375 Mdot
.12381 .43763 Mdot
.12619 .43776 Mdot
.12857 .43788 Mdot
.13095 .43801 Mdot
.13333 .43814 Mdot
.13571 .43827 Mdot
.1381 .4384 Mdot
.14048 .43853 Mdot
.14286 .43866 Mdot
.14524 .43879 Mdot
.14762 .43892 Mdot
.15 .43905 Mdot
.15238 .43918 Mdot
.15476 .43931 Mdot
.15714 .43944 Mdot
.15952 .43957 Mdot
.1619 .4397 Mdot
.16429 .43983 Mdot
.16667 .43996 Mdot
.16905 .44009 Mdot
.17143 .44022 Mdot
.17381 .44035 Mdot
.17619 .44049 Mdot
.17857 .44062 Mdot
.18095 .44075 Mdot
.18333 .44088 Mdot
.18571 .44101 Mdot
.1881 .44114 Mdot
.19048 .44128 Mdot
.19286 .44141 Mdot
.19524 .44154 Mdot
.19762 .44167 Mdot
.2 .44181 Mdot
.20238 .44194 Mdot
.20476 .44207 Mdot
.20714 .44221 Mdot
.20952 .44234 Mdot
.2119 .44247 Mdot
.21429 .44261 Mdot
.21667 .44274 Mdot
.21905 .44287 Mdot
.22143 .44301 Mdot
.22381 .44314 Mdot
.22619 .44327 Mdot
.22857 .44341 Mdot
.23095 .44354 Mdot
.23333 .44368 Mdot
.23571 .44381 Mdot
.2381 .44395 Mdot
.24048 .44408 Mdot
.24286 .44422 Mdot
.24524 .44435 Mdot
.24762 .44449 Mdot
.25 .44462 Mdot
.25238 .44476 Mdot
.25476 .44489 Mdot
.25714 .44503 Mdot
.25952 .44517 Mdot
.2619 .4453 Mdot
.26429 .44544 Mdot
.26667 .44558 Mdot
.26905 .44571 Mdot
.27143 .44585 Mdot
.27381 .44599 Mdot
.27619 .44612 Mdot
.27857 .44626 Mdot
.28095 .4464 Mdot
.28333 .44653 Mdot
.28571 .44667 Mdot
.2881 .44681 Mdot
.29048 .44695 Mdot
.29286 .44708 Mdot
.29524 .44722 Mdot
.29762 .44736 Mdot
.3 .4475 Mdot
.30238 .44764 Mdot
.30476 .44778 Mdot
.30714 .44792 Mdot
.30952 .44805 Mdot
.3119 .44819 Mdot
.31429 .44833 Mdot
.31667 .44847 Mdot
.31905 .44861 Mdot
.32143 .44875 Mdot
.32381 .44889 Mdot
.32619 .44903 Mdot
.32857 .44917 Mdot
.33095 .44931 Mdot
.33333 .44945 Mdot
.33571 .44959 Mdot
.3381 .44973 Mdot
.34048 .44987 Mdot
.34286 .45001 Mdot
.34524 .45015 Mdot
.34762 .4503 Mdot
.35 .45044 Mdot
.35238 .45058 Mdot
.35476 .45072 Mdot
.35714 .45086 Mdot
.35952 .451 Mdot
.3619 .45115 Mdot
.36429 .45129 Mdot
.36667 .45143 Mdot
.36905 .45157 Mdot
.37143 .45171 Mdot
.37381 .45186 Mdot
.37619 .452 Mdot
.37857 .45214 Mdot
.38095 .45229 Mdot
.38333 .45243 Mdot
.38571 .45257 Mdot
.3881 .45272 Mdot
.39048 .45286 Mdot
.39286 .453 Mdot
.39524 .45315 Mdot
.39762 .45329 Mdot
.4 .45344 Mdot
.40238 .45358 Mdot
.40476 .45373 Mdot
.40714 .45387 Mdot
.40952 .45402 Mdot
.4119 .45416 Mdot
.41429 .45431 Mdot
.41667 .45445 Mdot
.41905 .4546 Mdot
.42143 .45474 Mdot
.42381 .45489 Mdot
.42619 .45503 Mdot
.42857 .45518 Mdot
.43095 .45533 Mdot
.43333 .45547 Mdot
.43571 .45562 Mdot
.4381 .45576 Mdot
.44048 .45591 Mdot
.44286 .45606 Mdot
.44524 .45621 Mdot
.44762 .45635 Mdot
.45 .4565 Mdot
.45238 .45665 Mdot
.45476 .4568 Mdot
.45714 .45694 Mdot
.45952 .45709 Mdot
.4619 .45724 Mdot
.46429 .45739 Mdot
.46667 .45754 Mdot
.46905 .45768 Mdot
.47143 .45783 Mdot
.47381 .45798 Mdot
.47619 .45813 Mdot
.47857 .45828 Mdot
.48095 .45843 Mdot
.48333 .45858 Mdot
.48571 .45873 Mdot
.4881 .45888 Mdot
.49048 .45903 Mdot
.49286 .45918 Mdot
.49524 .45933 Mdot
.49762 .45948 Mdot
.5 .45963 Mdot
.50238 .45978 Mdot
.50476 .45993 Mdot
.50714 .46008 Mdot
.5