/*
 * Decompiled with CFR 0.152.
 */
public class Go2D {
    public static final int NONE = 0;
    public static final int IMAGE = 1;
    public static final int SELECTION = 2;
    public static final int FEEDBACK = 4;
    public static final int BOUND_BOX = 8;
    public static final int RENDER_MODE = 16;
    public static final int NORMAL = 32;
    public static final int AUTO_NORMAL = 64;
    public static final int BACKGROUND = 128;
    public static final int COLOR = 256;
    public static final int NAME = 512;
    public static final int LIGHT_0 = 1024;
    public static final int LIGHT_1 = 2048;
    public static final int LIGHT_2 = 4096;
    public static final int LIGHT_3 = 8192;
    public static final int LIGHT = 15360;
    public static final int MATRIX_MODE = 16384;
    public static final int MATRIX = 32768;
    public static final int MODELVIEW = 65536;
    public static final int PROJECTION = 131072;
    public static final int CULL = 262144;
    public static final int FLAT_SHADE = 524288;
    public static final int FLAGS = 786432;
    public static final int CONTEXT = 1015696;
    public static final int LINE = 2000000000;
    public static final int TRIANGLE = 2000000001;
    public static final int POSITIONAL = 2000000002;
    public static final int DIRECTIONAL = 2000000003;
    public static final int COLOR_GRADIENT = 2000000004;
    static final int LIGHT_NUM = 4;
    static final int[] lightNum = new int[]{1024, 2048, 4096, 8192};
    int width;
    int height;
    int matrixMode;
    boolean matrixDirty;
    GoMat2D modelview;
    GoMat2D modelviewInverse;
    GoMat2D matrix;
    GoStack2D stack;
    GoSelectionList2D selectionList;
    GoBoundBox2D boundBox;
    int renderMode;
    int flags;
    GoColor2D background;
    GoColor2D color;
    int name;
    GoMat2D currentMatrix;

    public Go2D() {
        this.init(0, 0);
    }

    public Go2D(int n, int n2) {
        this.init(n, n2);
    }

    public void size(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public void renderMode(int n) {
        this.renderMode = n;
    }

    public GoSelection2D selection() {
        GoSelection2D goSelection2D = this.selectionList.head.next;
        if (goSelection2D == this.selectionList.head) {
            return null;
        }
        return goSelection2D;
    }

    public GoBoundBox2D boundBox() {
        return this.boundBox;
    }

    public void clear(int n) {
        if ((n & 2) > 0) {
            this.selectionList.clear();
        }
        if ((n & 8) > 0) {
            this.boundBox.clear();
        }
    }

    public void enable(int n) {
        this.flags |= n;
    }

    public void disable(int n) {
        this.flags &= ~n;
    }

    public void background(GoColor2D goColor2D) {
        this.background(goColor2D.r, goColor2D.g, goColor2D.b);
    }

    public void background(double d, double d2, double d3) {
        this.background.r = d;
        this.background.g = d2;
        this.background.b = d3;
    }

    public void color(GoColor2D goColor2D) {
        this.color(goColor2D.r, goColor2D.g, goColor2D.b);
    }

    public void color(double d, double d2, double d3) {
        this.color.r = d;
        this.color.g = d2;
        this.color.b = d3;
    }

    public void name(int n) {
        this.name = n;
    }

    public void matrixMode(int n) {
        this.matrixMode = n;
        switch (n) {
            case 65536: {
                this.currentMatrix = this.modelview;
                return;
            }
        }
    }

    public void load(GoMatrix2D goMatrix2D) {
        this.currentMatrix.load(goMatrix2D);
    }

    public void multiply(GoMatrix2D goMatrix2D) {
        this.currentMatrix.multiply(goMatrix2D);
    }

    public void identity() {
        this.currentMatrix.identity();
    }

    public void inverse() {
        this.currentMatrix.inverse();
    }

    public void translate(double d, double d2) {
        this.currentMatrix.translate(d, d2);
    }

    public void scale(double d, double d2) {
        this.currentMatrix.scale(d, d2);
    }

    public void rotate(double d) {
        this.currentMatrix.rotate(d);
    }

    public void select(double d, double d2, double d3, double d4) {
        this.currentMatrix.select(d, d2, d3, d4);
    }

    public double transformX(double d, double d2) {
        return this.currentMatrix.transformX(d, d2);
    }

    public double transformY(double d, double d2) {
        return this.currentMatrix.transformY(d, d2);
    }

    public void transformPt(MkTuple2d mkTuple2d, MkTuple2d mkTuple2d2) {
        this.currentMatrix.transformPt(mkTuple2d, mkTuple2d2);
    }

    public void push(int n) {
        if ((n & 0x10) > 0) {
            this.stack.pushRenderMode();
        }
        if ((n & 0xC0000) > 0) {
            this.stack.pushFlags();
        }
        if ((n & 0x80) > 0) {
            this.stack.pushBackground();
        }
        if ((n & 0x100) > 0) {
            this.stack.pushColor();
        }
        if ((n & 0x200) > 0) {
            this.stack.pushName();
        }
        if ((n & 0x4000) > 0) {
            this.stack.pushMatrixMode();
        }
        if ((n & 0x8000) > 0 && this.matrixMode == 65536) {
            this.stack.pushModelview();
        }
        if ((n & 0x10000) > 0) {
            this.stack.pushModelview();
        }
    }

    public void pop(int n) {
        if ((n & 0x10) > 0) {
            this.stack.popRenderMode();
        }
        if ((n & 0xC0000) > 0) {
            this.stack.popFlags();
        }
        if ((n & 0x80) > 0) {
            this.stack.popBackground();
        }
        if ((n & 0x100) > 0) {
            this.stack.popColor();
        }
        if ((n & 0x200) > 0) {
            this.stack.popName();
        }
        if ((n & 0x4000) > 0) {
            this.stack.popMatrixMode();
            this.matrixMode(this.matrixMode);
        }
        if ((n & 0x8000) > 0 && this.matrixMode == 65536) {
            this.stack.popModelview();
        }
        if ((n & 0x10000) > 0) {
            this.stack.popModelview();
        }
    }

    public int getRenderMode() {
        return this.renderMode;
    }

    public int getFlags() {
        return this.flags;
    }

    public void getBackground(GoColor2D goColor2D) {
        goColor2D.r = this.background.r;
        goColor2D.g = this.background.g;
        goColor2D.b = this.background.b;
    }

    public void getColor(GoColor2D goColor2D) {
        goColor2D.r = this.color.r;
        goColor2D.g = this.color.g;
        goColor2D.b = this.color.b;
    }

    public int getName() {
        return this.name;
    }

    public int getMatrixMode() {
        return this.matrixMode;
    }

    public void getMatrix(GoMatrix2D goMatrix2D) {
        if (this.matrixMode == 65536) {
            this.modelview.getMatrix(goMatrix2D);
        }
    }

    public void getModelview(GoMatrix2D goMatrix2D) {
        this.modelview.getMatrix(goMatrix2D);
    }

    void init(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.modelview = new GoMat2D(this);
        this.modelviewInverse = new GoMat2D(this);
        this.matrix = new GoMat2D(this);
        this.stack = new GoStack2D(this);
        this.background = new GoColor2D(0.5, 0.5, 0.5);
        this.color = new GoColor2D();
        this.boundBox = new GoBoundBox2D();
        this.selectionList = new GoSelectionList2D(this);
        this.renderMode(1);
        this.flags = 0;
        this.matrixMode(65536);
        this.identity();
        this.color(1.0, 1.0, 1.0);
        this.name(0);
        this.disable(786432);
        this.matrixDirty = true;
    }

    void updateMatrices() {
        this.modelview.matrixInverse(this.modelviewInverse.m);
        this.matrixDirty = false;
    }

    static void warning(String string) {
        System.err.print("\nWARNING: " + string + "\n");
    }

    public static boolean isValidDouble(double d) {
        return !Double.isNaN(d) && !Double.isInfinite(d);
    }

    public static boolean isValidVertex(double d, double d2, double d3) {
        return !Double.isNaN(d) && !Double.isInfinite(d) && !Double.isNaN(d2) && !Double.isInfinite(d2) && !Double.isNaN(d3) && !Double.isInfinite(d3);
    }
}

