/*
 * Decompiled with CFR 0.152.
 */
class GoMat2D {
    Go2D go2D;
    static final int SIZE = 9;
    double[] m = new double[9];
    private GoMatrix2D r = new GoMatrix2D();
    private double[] tmp = new double[9];
    private double[][] wtmp = new double[4][8];

    GoMat2D(Go2D go2D) {
        this.go2D = go2D;
    }

    void load(GoMatrix2D goMatrix2D) {
        double[] dArray = goMatrix2D.m;
        this.m[0] = dArray[0];
        this.m[3] = dArray[3];
        this.m[6] = dArray[6];
        this.m[1] = dArray[1];
        this.m[4] = dArray[4];
        this.m[7] = dArray[7];
        this.m[2] = dArray[2];
        this.m[5] = dArray[5];
        this.m[8] = dArray[8];
        this.go2D.matrixDirty = true;
    }

    void multiply(GoMatrix2D goMatrix2D) {
        this.mult(goMatrix2D.m, this.m);
        this.go2D.matrixDirty = true;
    }

    void identity() {
        this.m[0] = 1.0;
        this.m[3] = 0.0;
        this.m[6] = 0.0;
        this.m[1] = 0.0;
        this.m[4] = 1.0;
        this.m[7] = 0.0;
        this.m[2] = 0.0;
        this.m[5] = 0.0;
        this.m[8] = 1.0;
        this.go2D.matrixDirty = true;
    }

    void translate(double d, double d2) {
        double[] dArray = this.r.m;
        dArray[0] = 1.0;
        dArray[3] = 0.0;
        dArray[6] = d;
        dArray[1] = 0.0;
        dArray[4] = 1.0;
        dArray[7] = d2;
        dArray[2] = 0.0;
        dArray[5] = 0.0;
        dArray[8] = 1.0;
        this.multiply(this.r);
    }

    void scale(double d, double d2) {
        double[] dArray = this.r.m;
        dArray[0] = d;
        dArray[3] = 0.0;
        dArray[6] = 0.0;
        dArray[1] = 0.0;
        dArray[4] = d2;
        dArray[7] = 0.0;
        dArray[2] = 0.0;
        dArray[5] = 0.0;
        dArray[8] = 1.0;
        this.multiply(this.r);
    }

    void rotate(double d) {
        double[] dArray = this.r.m;
        d = d * Math.PI / 180.0;
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        dArray[0] = d2;
        dArray[3] = -d3;
        dArray[6] = 0.0;
        dArray[1] = d3;
        dArray[4] = d2;
        dArray[7] = 0.0;
        dArray[2] = 0.0;
        dArray[5] = 0.0;
        dArray[8] = 1.0;
        this.multiply(this.r);
    }

    void inverse() {
        this.matrixInverse(this.m);
        this.go2D.matrixDirty = true;
    }

    void select(double d, double d2, double d3, double d4) {
        double d5 = this.go2D.width;
        double d6 = this.go2D.height;
        double d7 = d5 / d3;
        double d8 = d6 / d4;
        double d9 = (d5 - 2.0 * d) / d3;
        double d10 = (d6 - 2.0 * d2) / d4;
        double[] dArray = this.r.m;
        dArray[0] = d7;
        dArray[4] = 0.0;
        dArray[8] = 0.0;
        dArray[12] = d9;
        dArray[1] = 0.0;
        dArray[5] = d8;
        dArray[9] = 0.0;
        dArray[13] = d10;
        dArray[2] = 0.0;
        dArray[6] = 0.0;
        dArray[10] = 1.0;
        dArray[14] = 0.0;
        dArray[3] = 0.0;
        dArray[7] = 0.0;
        dArray[11] = 0.0;
        dArray[15] = 1.0;
        this.multiply(this.r);
    }

    void getMatrix(GoMatrix2D goMatrix2D) {
        double[] dArray = goMatrix2D.m;
        dArray[0] = this.m[0];
        dArray[3] = this.m[3];
        dArray[6] = this.m[6];
        dArray[1] = this.m[1];
        dArray[4] = this.m[4];
        dArray[7] = this.m[7];
        dArray[2] = this.m[2];
        dArray[5] = this.m[5];
        dArray[8] = this.m[8];
    }

    void copy(GoMat2D goMat2D) {
        int n = 0;
        while (n < 9) {
            this.m[n] = goMat2D.m[n];
            ++n;
        }
    }

    void mult(double[] dArray, double[] dArray2) {
        this.tmp[0] = this.m[0] * dArray[0] + this.m[3] * dArray[1] + this.m[6] * dArray[2];
        this.tmp[1] = this.m[1] * dArray[0] + this.m[4] * dArray[1] + this.m[7] * dArray[2];
        this.tmp[2] = this.m[2] * dArray[0] + this.m[5] * dArray[1] + this.m[8] * dArray[2];
        this.tmp[3] = this.m[0] * dArray[3] + this.m[3] * dArray[4] + this.m[6] * dArray[5];
        this.tmp[4] = this.m[1] * dArray[3] + this.m[4] * dArray[4] + this.m[7] * dArray[5];
        this.tmp[5] = this.m[2] * dArray[3] + this.m[5] * dArray[4] + this.m[8] * dArray[5];
        this.tmp[6] = this.m[0] * dArray[6] + this.m[3] * dArray[7] + this.m[6] * dArray[8];
        this.tmp[7] = this.m[1] * dArray[6] + this.m[4] * dArray[7] + this.m[7] * dArray[8];
        this.tmp[8] = this.m[2] * dArray[6] + this.m[5] * dArray[7] + this.m[8] * dArray[8];
        int n = 0;
        while (n < 9) {
            dArray2[n] = this.tmp[n];
            ++n;
        }
    }

    public double transformX(double d, double d2) {
        return this.m[0] * d + this.m[3] * d2 + this.m[6];
    }

    public double transformY(double d, double d2) {
        return this.m[1] * d + this.m[4] * d2 + this.m[7];
    }

    public void transformPt(MkTuple2d mkTuple2d, MkTuple2d mkTuple2d2) {
        mkTuple2d2.x = this.m[0] * mkTuple2d.x + this.m[3] * mkTuple2d.y + this.m[6];
        mkTuple2d2.y = this.m[1] * mkTuple2d.x + this.m[4] * mkTuple2d.y + this.m[7];
    }

    void matrixInverse(double[] dArray) {
        if (!this.invert_matrix(dArray)) {
            dArray[0] = 1.0;
            dArray[4] = 0.0;
            dArray[8] = 0.0;
            dArray[12] = 0.0;
            dArray[1] = 0.0;
            dArray[5] = 1.0;
            dArray[9] = 0.0;
            dArray[13] = 0.0;
            dArray[2] = 0.0;
            dArray[6] = 0.0;
            dArray[10] = 1.0;
            dArray[14] = 0.0;
            dArray[3] = 0.0;
            dArray[7] = 0.0;
            dArray[11] = 0.0;
            dArray[15] = 1.0;
        }
    }

    boolean invert_matrix(double[] dArray) {
        double[] dArray2;
        double d = this.m[0];
        double d2 = this.m[1];
        double d3 = this.m[2];
        double d4 = this.m[3];
        double d5 = this.m[4];
        double d6 = this.m[5];
        double d7 = this.m[6];
        double d8 = this.m[7];
        double d9 = this.m[8];
        double d10 = this.m[9];
        double d11 = this.m[10];
        double d12 = this.m[11];
        double d13 = this.m[12];
        double d14 = this.m[13];
        double d15 = this.m[14];
        double d16 = this.m[15];
        double[] dArray3 = this.wtmp[0];
        double[] dArray4 = this.wtmp[1];
        double[] dArray5 = this.wtmp[2];
        double[] dArray6 = this.wtmp[3];
        dArray3[0] = d;
        dArray3[1] = d2;
        dArray3[2] = d3;
        dArray3[3] = d4;
        dArray3[4] = 1.0;
        dArray3[7] = 0.0;
        dArray3[6] = 0.0;
        dArray3[5] = 0.0;
        dArray4[0] = d5;
        dArray4[1] = d6;
        dArray4[2] = d7;
        dArray4[3] = d8;
        dArray4[5] = 1.0;
        dArray4[7] = 0.0;
        dArray4[6] = 0.0;
        dArray4[4] = 0.0;
        dArray5[0] = d9;
        dArray5[1] = d10;
        dArray5[2] = d11;
        dArray5[3] = d12;
        dArray5[6] = 1.0;
        dArray5[7] = 0.0;
        dArray5[5] = 0.0;
        dArray5[4] = 0.0;
        dArray6[0] = d13;
        dArray6[1] = d14;
        dArray6[2] = d15;
        dArray6[3] = d16;
        dArray6[7] = 1.0;
        dArray6[6] = 0.0;
        dArray6[5] = 0.0;
        dArray6[4] = 0.0;
        if (Math.abs(dArray6[0]) > Math.abs(dArray5[0])) {
            dArray2 = dArray6;
            dArray6 = dArray5;
            dArray5 = dArray2;
        }
        if (Math.abs(dArray5[0]) > Math.abs(dArray4[0])) {
            dArray2 = dArray5;
            dArray5 = dArray4;
            dArray4 = dArray2;
        }
        if (Math.abs(dArray4[0]) > Math.abs(dArray3[0])) {
            dArray2 = dArray4;
            dArray4 = dArray3;
            dArray3 = dArray2;
        }
        if (dArray3[0] == 0.0) {
            return false;
        }
        double d17 = dArray4[0] / dArray3[0];
        double d18 = dArray5[0] / dArray3[0];
        double d19 = dArray6[0] / dArray3[0];
        double d20 = dArray3[1];
        dArray4[1] = dArray4[1] - d17 * d20;
        dArray5[1] = dArray5[1] - d18 * d20;
        dArray6[1] = dArray6[1] - d19 * d20;
        d20 = dArray3[2];
        dArray4[2] = dArray4[2] - d17 * d20;
        dArray5[2] = dArray5[2] - d18 * d20;
        dArray6[2] = dArray6[2] - d19 * d20;
        d20 = dArray3[3];
        dArray4[3] = dArray4[3] - d17 * d20;
        dArray5[3] = dArray5[3] - d18 * d20;
        dArray6[3] = dArray6[3] - d19 * d20;
        d20 = dArray3[4];
        if (d20 != 0.0) {
            dArray4[4] = dArray4[4] - d17 * d20;
            dArray5[4] = dArray5[4] - d18 * d20;
            dArray6[4] = dArray6[4] - d19 * d20;
        }
        if ((d20 = dArray3[5]) != 0.0) {
            dArray4[5] = dArray4[5] - d17 * d20;
            dArray5[5] = dArray5[5] - d18 * d20;
            dArray6[5] = dArray6[5] - d19 * d20;
        }
        if ((d20 = dArray3[6]) != 0.0) {
            dArray4[6] = dArray4[6] - d17 * d20;
            dArray5[6] = dArray5[6] - d18 * d20;
            dArray6[6] = dArray6[6] - d19 * d20;
        }
        if ((d20 = dArray3[7]) != 0.0) {
            dArray4[7] = dArray4[7] - d17 * d20;
            dArray5[7] = dArray5[7] - d18 * d20;
            dArray6[7] = dArray6[7] - d19 * d20;
        }
        if (Math.abs(dArray6[1]) > Math.abs(dArray5[1])) {
            dArray2 = dArray6;
            dArray6 = dArray5;
            dArray5 = dArray2;
        }
        if (Math.abs(dArray5[1]) > Math.abs(dArray4[1])) {
            dArray2 = dArray5;
            dArray5 = dArray4;
            dArray4 = dArray2;
        }
        if (dArray4[1] == 0.0) {
            return false;
        }
        d18 = dArray5[1] / dArray4[1];
        d19 = dArray6[1] / dArray4[1];
        dArray5[2] = dArray5[2] - d18 * dArray4[2];
        dArray6[2] = dArray6[2] - d19 * dArray4[2];
        dArray5[3] = dArray5[3] - d18 * dArray4[3];
        dArray6[3] = dArray6[3] - d19 * dArray4[3];
        d20 = dArray4[4];
        if (d20 != 0.0) {
            dArray5[4] = dArray5[4] - d18 * d20;
            dArray6[4] = dArray6[4] - d19 * d20;
        }
        if ((d20 = dArray4[5]) != 0.0) {
            dArray5[5] = dArray5[5] - d18 * d20;
            dArray6[5] = dArray6[5] - d19 * d20;
        }
        if ((d20 = dArray4[6]) != 0.0) {
            dArray5[6] = dArray5[6] - d18 * d20;
            dArray6[6] = dArray6[6] - d19 * d20;
        }
        if ((d20 = dArray4[7]) != 0.0) {
            dArray5[7] = dArray5[7] - d18 * d20;
            dArray6[7] = dArray6[7] - d19 * d20;
        }
        if (Math.abs(dArray6[2]) > Math.abs(dArray5[2])) {
            dArray2 = dArray6;
            dArray6 = dArray5;
            dArray5 = dArray2;
        }
        if (dArray5[2] == 0.0) {
            return false;
        }
        d19 = dArray6[2] / dArray5[2];
        dArray6[3] = dArray6[3] - d19 * dArray5[3];
        dArray6[4] = dArray6[4] - d19 * dArray5[4];
        dArray6[5] = dArray6[5] - d19 * dArray5[5];
        dArray6[6] = dArray6[6] - d19 * dArray5[6];
        dArray6[7] = dArray6[7] - d19 * dArray5[7];
        if (dArray6[3] == 0.0) {
            return false;
        }
        d20 = 1.0 / dArray6[3];
        dArray6[4] = dArray6[4] * d20;
        dArray6[5] = dArray6[5] * d20;
        dArray6[6] = dArray6[6] * d20;
        dArray6[7] = dArray6[7] * d20;
        d18 = dArray5[3];
        d20 = 1.0 / dArray5[2];
        dArray5[4] = d20 * (dArray5[4] - dArray6[4] * d18);
        dArray5[5] = d20 * (dArray5[5] - dArray6[5] * d18);
        dArray5[6] = d20 * (dArray5[6] - dArray6[6] * d18);
        dArray5[7] = d20 * (dArray5[7] - dArray6[7] * d18);
        d17 = dArray4[3];
        dArray4[4] = dArray4[4] - dArray6[4] * d17;
        dArray4[5] = dArray4[5] - dArray6[5] * d17;
        dArray4[6] = dArray4[6] - dArray6[6] * d17;
        dArray4[7] = dArray4[7] - dArray6[7] * d17;
        double d21 = dArray3[3];
        dArray3[4] = dArray3[4] - dArray6[4] * d21;
        dArray3[5] = dArray3[5] - dArray6[5] * d21;
        dArray3[6] = dArray3[6] - dArray6[6] * d21;
        dArray3[7] = dArray3[7] - dArray6[7] * d21;
        d17 = dArray4[2];
        d20 = 1.0 / dArray4[1];
        dArray4[4] = d20 * (dArray4[4] - dArray5[4] * d17);
        dArray4[5] = d20 * (dArray4[5] - dArray5[5] * d17);
        dArray4[6] = d20 * (dArray4[6] - dArray5[6] * d17);
        dArray4[7] = d20 * (dArray4[7] - dArray5[7] * d17);
        d21 = dArray3[2];
        dArray3[4] = dArray3[4] - dArray5[4] * d21;
        dArray3[5] = dArray3[5] - dArray5[5] * d21;
        dArray3[6] = dArray3[6] - dArray5[6] * d21;
        dArray3[7] = dArray3[7] - dArray5[7] * d21;
        d21 = dArray3[1];
        d20 = 1.0 / dArray3[0];
        dArray3[4] = d20 * (dArray3[4] - dArray4[4] * d21);
        dArray3[5] = d20 * (dArray3[5] - dArray4[5] * d21);
        dArray3[6] = d20 * (dArray3[6] - dArray4[6] * d21);
        dArray3[7] = d20 * (dArray3[7] - dArray4[7] * d21);
        dArray[0] = dArray3[4];
        dArray[1] = dArray3[5];
        dArray[2] = dArray3[6];
        dArray[3] = dArray3[7];
        dArray[4] = dArray4[4];
        dArray[5] = dArray4[5];
        dArray[6] = dArray4[6];
        dArray[7] = dArray4[7];
        dArray[8] = dArray5[4];
        dArray[9] = dArray5[5];
        dArray[10] = dArray5[6];
        dArray[11] = dArray5[7];
        dArray[12] = dArray6[4];
        dArray[13] = dArray6[5];
        dArray[14] = dArray6[6];
        dArray[15] = dArray6[7];
        return true;
    }
}

