/*
 * Decompiled with CFR 0.152.
 */
class GoStack2D {
    Go2D go2D;
    static final int RENDERMODE_STACK_SIZE = 25;
    static final int FLAGS_STACK_SIZE = 25;
    static final int BACKGROUND_STACK_SIZE = 25;
    static final int COLOR_STACK_SIZE = 25;
    static final int NAME_STACK_SIZE = 25;
    static final int MODELVIEW_STACK_SIZE = 25;
    static final int MATRIXMODE_STACK_SIZE = 25;
    int[] renderModeStack = new int[25];
    int renderModeStackVal;
    int[] matrixModeStack = new int[25];
    int matrixModeStackVal;
    int[] flagsStack = new int[25];
    int flagsStackVal;
    GoColor2D[] backgroundStack = new GoColor2D[25];
    int backgroundStackVal;
    GoColor2D[] colorStack = new GoColor2D[25];
    int colorStackVal;
    GoMat2D[] modelviewStack = new GoMat2D[25];
    int modelviewStackVal;
    int[] nameStack = new int[25];
    int nameStackVal;

    GoStack2D(Go2D go2D) {
        this.go2D = go2D;
        this.renderModeStackVal = -1;
        this.matrixModeStackVal = -1;
        this.flagsStackVal = -1;
        this.backgroundStackVal = -1;
        int n = 0;
        while (n < 25) {
            this.backgroundStack[n] = new GoColor2D();
            ++n;
        }
        this.colorStackVal = -1;
        int n2 = 0;
        while (n2 < 25) {
            this.colorStack[n2] = new GoColor2D();
            ++n2;
        }
        this.modelviewStackVal = -1;
        int n3 = 0;
        while (n3 < 25) {
            this.modelviewStack[n3] = new GoMat2D(go2D);
            ++n3;
        }
        this.nameStackVal = -1;
    }

    void pushRenderMode() {
        ++this.renderModeStackVal;
        if (this.renderModeStackVal == 25) {
            this.stackPushWarning(16);
            this.renderModeStackVal = 24;
        }
        this.renderModeStack[this.renderModeStackVal] = this.go2D.renderMode;
    }

    void popRenderMode() {
        if (this.renderModeStackVal < 0) {
            this.stackPopWarning(16);
            this.renderModeStackVal = 0;
        }
        this.go2D.renderMode = this.renderModeStack[this.renderModeStackVal];
        --this.renderModeStackVal;
    }

    void pushFlags() {
        ++this.flagsStackVal;
        if (this.flagsStackVal == 25) {
            this.stackPushWarning(786432);
            this.flagsStackVal = 24;
        }
        this.flagsStack[this.flagsStackVal] = this.go2D.flags;
    }

    void popFlags() {
        if (this.flagsStackVal < 0) {
            this.stackPopWarning(786432);
            this.flagsStackVal = 0;
        }
        this.go2D.flags = this.flagsStack[this.flagsStackVal];
        --this.flagsStackVal;
    }

    void pushBackground() {
        ++this.backgroundStackVal;
        if (this.backgroundStackVal == 25) {
            this.stackPushWarning(128);
            this.backgroundStackVal = 24;
        }
        this.backgroundStack[this.backgroundStackVal].r = this.go2D.background.r;
        this.backgroundStack[this.backgroundStackVal].g = this.go2D.background.g;
        this.backgroundStack[this.backgroundStackVal].b = this.go2D.background.b;
    }

    void popBackground() {
        if (this.backgroundStackVal < 0) {
            this.stackPopWarning(128);
            this.backgroundStackVal = 0;
        }
        this.go2D.background.r = this.backgroundStack[this.backgroundStackVal].r;
        this.go2D.background.g = this.backgroundStack[this.backgroundStackVal].g;
        this.go2D.background.b = this.backgroundStack[this.backgroundStackVal].b;
        --this.backgroundStackVal;
    }

    void pushColor() {
        ++this.colorStackVal;
        if (this.colorStackVal == 25) {
            this.stackPushWarning(256);
            this.colorStackVal = 24;
        }
        this.colorStack[this.colorStackVal].r = this.go2D.color.r;
        this.colorStack[this.colorStackVal].g = this.go2D.color.g;
        this.colorStack[this.colorStackVal].b = this.go2D.color.b;
    }

    void popColor() {
        if (this.colorStackVal < 0) {
            this.stackPopWarning(256);
            this.colorStackVal = 0;
        }
        this.go2D.color.r = this.colorStack[this.colorStackVal].r;
        this.go2D.color.g = this.colorStack[this.colorStackVal].g;
        this.go2D.color.b = this.colorStack[this.colorStackVal].b;
        --this.colorStackVal;
    }

    void pushModelview() {
        ++this.modelviewStackVal;
        if (this.modelviewStackVal == 25) {
            this.stackPushWarning(65536);
            this.modelviewStackVal = 24;
        }
        double[] dArray = this.go2D.modelview.m;
        double[] dArray2 = this.modelviewStack[this.modelviewStackVal].m;
        dArray2[0] = dArray[0];
        dArray2[3] = dArray[3];
        dArray2[6] = dArray[6];
        dArray2[1] = dArray[1];
        dArray2[4] = dArray[4];
        dArray2[7] = dArray[7];
        dArray2[2] = dArray[2];
        dArray2[5] = dArray[5];
        dArray2[8] = dArray[8];
    }

    void popModelview() {
        if (this.modelviewStackVal < 0) {
            this.stackPopWarning(65536);
            this.modelviewStackVal = 0;
        }
        double[] dArray = this.modelviewStack[this.modelviewStackVal].m;
        double[] dArray2 = this.go2D.modelview.m;
        dArray2[0] = dArray[0];
        dArray2[3] = dArray[3];
        dArray2[6] = dArray[6];
        dArray2[1] = dArray[1];
        dArray2[4] = dArray[4];
        dArray2[7] = dArray[7];
        dArray2[2] = dArray[2];
        dArray2[5] = dArray[5];
        dArray2[8] = dArray[8];
        --this.modelviewStackVal;
        this.go2D.matrixDirty = true;
    }

    void pushMatrixMode() {
        ++this.matrixModeStackVal;
        if (this.matrixModeStackVal == 25) {
            this.stackPushWarning(16384);
            this.matrixModeStackVal = 24;
        }
        this.matrixModeStack[this.matrixModeStackVal] = this.go2D.matrixMode;
    }

    void popMatrixMode() {
        if (this.matrixModeStackVal < 0) {
            this.stackPopWarning(16384);
            this.matrixModeStackVal = 0;
        }
        this.go2D.matrixMode = this.matrixModeStack[this.matrixModeStackVal];
        --this.matrixModeStackVal;
    }

    void pushName() {
        ++this.nameStackVal;
        if (this.nameStackVal == 25) {
            this.stackPushWarning(512);
            this.nameStackVal = 24;
        }
        this.nameStack[this.nameStackVal] = this.go2D.name;
    }

    void popName() {
        if (this.nameStackVal < 0) {
            this.stackPopWarning(512);
            this.nameStackVal = 0;
        }
        this.go2D.name = this.nameStack[this.nameStackVal];
        --this.nameStackVal;
    }

    private void stackPushWarning(int n) {
        switch (n) {
            case 16: {
                Go2D.warning("Render mode stack exhausted on push!");
                return;
            }
            case 786432: {
                Go2D.warning("Flags stack exhausted on push!");
                return;
            }
            case 16384: {
                Go2D.warning("Matrix mode stack exhausted on push!");
                return;
            }
            case 65536: {
                Go2D.warning("Modelview stack exhausted on push!");
                return;
            }
            case 128: {
                Go2D.warning("Background stack exhausted on push!");
                return;
            }
            case 256: {
                Go2D.warning("Color stack exhausted on push!");
                return;
            }
            case 512: {
                Go2D.warning("Name stack exhausted on push!");
                return;
            }
        }
    }

    private void stackPopWarning(int n) {
        switch (n) {
            case 16: {
                Go2D.warning("Render mode stack exhausted on pop!");
                return;
            }
            case 786432: {
                Go2D.warning("Flags stack exhausted on pop!");
                return;
            }
            case 16384: {
                Go2D.warning("Matrix mode stack exhausted on pop!");
                return;
            }
            case 65536: {
                Go2D.warning("Modelview stack exhausted on pop!");
                return;
            }
            case 128: {
                Go2D.warning("Background stack exhausted on pop!");
                return;
            }
            case 256: {
                Go2D.warning("Color stack exhausted on pop!");
                return;
            }
            case 512: {
                Go2D.warning("Name stack exhausted on pop!");
                return;
            }
        }
    }
}

