/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class MkContourGenerator {
    private static final boolean DEBUG = false;
    private static final String kCancelMsg = "Method MkContourGenerator.getContours() canceled by user.";
    private static final String kInconsistantArrMsg = "Inconsistant array sizes.";
    private static final String kArrSizeMsg = "Data arrays must have more than one row or column.";
    private static final String kNegLogDataMsg = "Function data must be > 0 for logarithmic intervals.";
    private static final int kBufSize = 1000;
    private static final int kMinNumPoints = 3;
    private Vector pathList = new Vector();
    private boolean cCalculated = false;
    private double[][] xArray;
    private double[][] yArray;
    private double[][] funcArray;
    private double[] xArr1D;
    private double[] yArr1D;
    private MkContourAttrib[] cAttr;
    private float fracComplete;
    private boolean isCanceled = false;
    private double[] pathbufxt;
    private double[] pathbufyt;
    private int[] pathbufia;
    private int lnstrt;
    private int ignext;
    private int icont;
    private double cont;
    private int iss;
    private int iee;
    private int jss;
    private int jee;
    private int ima;
    private int iae;
    private int ibeg;
    private int jbeg;
    private int gi;
    private int gj;
    private double fij;
    private int idir;
    private int np;
    private double wx;
    private double wy;

    public MkContourGenerator(double[][] dArray, double[][] dArray2, double[][] dArray3, MkContourAttrib[] mkContourAttribArray) {
        if (dArray2.length != dArray.length || dArray2.length != dArray3.length) {
            throw new IllegalArgumentException(kInconsistantArrMsg);
        }
        if (dArray2[0].length != dArray[0].length || dArray2[0].length != dArray3[0].length) {
            throw new IllegalArgumentException(kInconsistantArrMsg);
        }
        if (dArray.length <= 1 || dArray[0].length <= 1) {
            throw new IllegalArgumentException(kArrSizeMsg);
        }
        this.cAttr = mkContourAttribArray;
        this.xArray = dArray;
        this.yArray = dArray2;
        this.funcArray = dArray3;
    }

    public MkContourGenerator(double[] dArray, double[] dArray2, double[][] dArray3, MkContourAttrib[] mkContourAttribArray) {
        if (dArray2.length != dArray3.length || dArray.length != dArray3[0].length) {
            throw new IllegalArgumentException(kInconsistantArrMsg);
        }
        if (dArray.length <= 1) {
            throw new IllegalArgumentException(kArrSizeMsg);
        }
        this.cAttr = mkContourAttribArray;
        this.xArr1D = dArray;
        this.yArr1D = dArray2;
        this.funcArray = dArray3;
    }

    public MkContourGenerator(double[][] dArray, double[][] dArray2, double[][] dArray3, int n, boolean bl) {
        if (dArray2.length != dArray.length || dArray2.length != dArray3.length) {
            throw new IllegalArgumentException(kInconsistantArrMsg);
        }
        if (dArray2[0].length != dArray[0].length || dArray2[0].length != dArray3[0].length) {
            throw new IllegalArgumentException(kInconsistantArrMsg);
        }
        if (dArray.length <= 1 || dArray[0].length <= 1) {
            throw new IllegalArgumentException(kArrSizeMsg);
        }
        this.xArray = dArray;
        this.yArray = dArray2;
        this.funcArray = dArray3;
        if (bl) {
            this.findLogIntervals(n);
            return;
        }
        this.findLinearIntervals(n);
    }

    public MkContourGenerator(double[] dArray, double[] dArray2, double[][] dArray3, int n, boolean bl) {
        if (dArray2.length != dArray3.length || dArray.length != dArray3[0].length) {
            throw new IllegalArgumentException(kInconsistantArrMsg);
        }
        if (dArray.length <= 1) {
            throw new IllegalArgumentException(kArrSizeMsg);
        }
        this.xArr1D = dArray;
        this.yArr1D = dArray2;
        this.funcArray = dArray3;
        if (bl) {
            this.findLogIntervals(n);
            return;
        }
        this.findLinearIntervals(n);
    }

    public MkContourPath[] getContours() throws InterruptedException {
        if (!this.cCalculated) {
            this.isCanceled = false;
            this.pathList.removeAllElements();
            this.computeContours();
            this.cAttr = null;
            this.funcArray = null;
            this.yArray = null;
            this.xArray = null;
            this.yArr1D = null;
            this.xArr1D = null;
            this.cCalculated = true;
            this.fracComplete = 1.0f;
        }
        int n = this.pathList.size();
        MkContourPath[] mkContourPathArray = new MkContourPath[n];
        int n2 = 0;
        while (n2 < n) {
            mkContourPathArray[n2] = (MkContourPath)this.pathList.elementAt(n2);
            ++n2;
        }
        return mkContourPathArray;
    }

    public boolean done() {
        return this.cCalculated;
    }

    public void cancel() {
        this.isCanceled = true;
    }

    public float getProgress() {
        return this.fracComplete;
    }

    private void findLinearIntervals(int n) {
        double d = Double.MAX_VALUE;
        double d2 = -d;
        int n2 = this.funcArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.funcArray[n3].length;
            int n5 = 0;
            while (n5 < n4) {
                double d3 = this.funcArray[n3][n5];
                if (!MkMath.isUndefinedDouble(d3)) {
                    d = Math.min(d, d3);
                    d2 = Math.max(d2, d3);
                }
                ++n5;
            }
            ++n3;
        }
        this.cAttr = new MkContourAttrib[n];
        double d4 = (d2 - d) / (double)(n + 1);
        int n6 = 0;
        while (n6 < n) {
            this.cAttr[n6] = new MkContourAttrib(d + (double)(n6 + 1) * d4);
            ++n6;
        }
    }

    private void findLogIntervals(int n) {
        double d;
        double d2 = Double.MAX_VALUE;
        double d3 = -d2;
        int n2 = this.funcArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.funcArray[n3].length;
            int n5 = 0;
            while (n5 < n4) {
                d = this.funcArray[n3][n5];
                if (!MkMath.isUndefinedDouble(d)) {
                    d2 = Math.min(d2, d);
                    d3 = Math.max(d3, d);
                }
                ++n5;
            }
            ++n3;
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException(kNegLogDataMsg);
        }
        this.cAttr = new MkContourAttrib[n];
        double d4 = Math.log(d2);
        d = (Math.log(d3) - d4) / (double)(n + 1);
        int n6 = 0;
        while (n6 < n) {
            this.cAttr[n6] = new MkContourAttrib(Math.exp(d4 + (double)(n6 + 1) * d));
            ++n6;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void computeContours() throws InterruptedException {
        var1_1 = this.cAttr.length;
        var2_2 = 0;
        var3_3 = 0;
        if (this.xArray != null) {
            var3_3 = this.xArray.length;
            var2_2 = this.xArray[0].length;
        } else {
            var2_2 = this.xArr1D.length;
            var3_3 = this.yArr1D.length;
        }
        this.pathbufxt = new double[1000];
        this.pathbufyt = new double[1000];
        this.pathbufia = new int[3000];
        this.lnstrt = 1;
        this.ignext = 0;
        this.icont = 0;
        while (this.icont < var1_1) {
            if (this.isCanceled) {
                throw new InterruptedException("Method MkContourGenerator.getContours() canceled by user.");
            }
            this.cont = this.cAttr[this.icont].getLevel();
            this.iss = 1;
            this.iee = var2_2;
            this.jss = 1;
            this.jee = var3_3;
            var4_4 = false;
            do {
                this.FlagContourPassings();
                var5_5 = false;
                block16: do {
                    if (!var5_5) {
                        this.ima = 1;
                        this.ibeg = this.iss - 1;
                        this.jbeg = this.jss;
                    }
                    do {
                        if (var5_5) ** GOTO lbl100
                        var6_6 = 0;
                        var7_7 = 0;
                        block18: while (true) {
                            switch (this.ima) {
                                case 1: {
                                    ++this.ibeg;
                                    if (this.ibeg == this.iee) {
                                        this.ima = 2;
                                    }
                                    ** GOTO lbl58
                                }
                                case 2: {
                                    ++this.jbeg;
                                    if (this.jbeg == this.jee) {
                                        this.ima = 3;
                                    }
                                    ** GOTO lbl58
                                }
                                case 3: {
                                    --this.ibeg;
                                    if (this.ibeg == this.iss) {
                                        this.ima = 4;
                                    }
                                    ** GOTO lbl58
                                }
                                case 4: {
                                    --this.jbeg;
                                    if (this.jbeg == this.jss) {
                                        this.ima = 5;
                                    }
                                }
lbl58:
                                // 7 sources

                                default: {
                                    if (this.funcArray[this.jbeg - 1][this.ibeg - 1] <= this.cont) {
                                        var6_6 = 1;
                                        var7_7 = 0;
                                        continue block18;
                                    }
                                    if (var6_6 != 1) continue block18;
                                    var7_7 = 1;
                                    if (var7_7 == 0) continue block18;
                                    this.gi = this.ibeg;
                                    this.gj = this.jbeg;
                                    this.fij = this.funcArray[this.jbeg - 1][this.ibeg - 1];
                                    switch (this.ima) {
                                        case 1: {
                                            this.Routine_L21();
                                            break;
                                        }
                                        case 2: {
                                            if (this.gj != this.jss) {
                                                if (this.Routine_L31()) break;
                                                this.Routine_L21();
                                                break;
                                            }
                                            this.Routine_L21();
                                            break;
                                        }
                                        case 3: {
                                            if (this.gi != this.iee) {
                                                if (this.Routine_L41()) break;
                                                this.Routine_L21();
                                                break;
                                            }
                                            if (this.Routine_L31()) break;
                                            this.Routine_L21();
                                            break;
                                        }
                                        case 4: {
                                            if (this.gj != this.jee) {
                                                if (this.Routine_L51()) break;
                                                this.Routine_L21();
                                                break;
                                            }
                                            if (this.Routine_L41()) break;
                                            this.Routine_L21();
                                            break;
                                        }
                                        case 5: {
                                            if (this.Routine_L51()) break;
                                            this.Routine_L21();
                                            break;
                                        }
                                    }
lbl100:
                                    // 16 sources

                                    var5_5 = false;
                                    this.lnstrt = 1;
                                    this.ignext = 0;
                                    this.accumContour(this.np, this.icont, this.pathbufxt, this.pathbufyt, this.cAttr[this.icont]);
                                }
                                case 5: 
                            }
                            break;
                        }
                    } while (this.ima != 5);
                    if (this.iae == 0) continue;
                    var6_6 = this.iae;
                    var7_7 = 1;
                    while (var7_7 <= var6_6) {
                        if (this.pathbufia[var7_7 - 1] != 0) {
                            this.gi = this.pathbufia[var7_7 - 1] / 1000;
                            this.gj = this.pathbufia[var7_7 - 1] - this.gi * 1000;
                            this.fij = this.funcArray[this.gj - 1][this.gi - 1];
                            this.pathbufia[var7_7 - 1] = 0;
                            this.Routine_L21();
                            var5_5 = true;
                            continue block16;
                        }
                        ++var7_7;
                    }
                } while (var5_5);
                var4_4 = false;
                if (this.iee == var2_2) {
                    if (this.jee == var3_3) continue;
                    this.jss = this.jee;
                    this.jee = var3_3;
                    var4_4 = true;
                    continue;
                }
                this.iss = this.iee;
                this.iee = var2_2;
                var4_4 = true;
            } while (var4_4);
            this.fracComplete = (float)(this.icont + 1) / (float)var1_1;
            ++this.icont;
        }
        this.pathbufxt = null;
        this.pathbufyt = null;
        this.pathbufia = null;
    }

    private void FlagContourPassings() {
        this.iae = 0;
        int n = this.jee - 1;
        int n2 = this.jss + 1;
        while (n2 <= n) {
            boolean bl = false;
            int n3 = this.iae;
            int n4 = this.iee;
            int n5 = this.iss;
            while (n5 <= n4) {
                if (this.funcArray[n2 - 1][n5 - 1] <= this.cont) {
                    bl = true;
                } else if (bl) {
                    ++this.iae;
                    this.pathbufia[this.iae - 1] = n5 * 1000 + n2;
                    bl = false;
                    if (this.iae == 3000) {
                        if (n2 > this.jss + 1) {
                            this.iae = n3;
                            this.jee = n2;
                            return;
                        }
                        this.jee = Math.min(n2 + 1, this.jee);
                        this.iee = n5;
                        return;
                    }
                }
                ++n5;
            }
            ++n2;
        }
    }

    private void Routine_L21() {
        do {
            --this.gi;
            if (this.gi < this.iss) {
                return;
            }
            this.idir = 1;
            if (this.funcArray[this.gj - 1][this.gi - 1] <= this.cont) {
                if (this.iae != 0) {
                    int n = this.gi * 1000 + this.gj + 1000;
                    int n2 = this.iae;
                    int n3 = 1;
                    while (n3 <= n2) {
                        if (this.pathbufia[n3 - 1] == n) {
                            this.pathbufia[n3 - 1] = 0;
                            break;
                        }
                        ++n3;
                    }
                }
                this.doInterpolation();
                return;
            }
            this.fij = this.funcArray[this.gj - 1][this.gi - 1];
        } while (!this.Routine_L31());
    }

    private boolean Routine_L31() {
        --this.gj;
        if (this.gj < this.jss) {
            return true;
        }
        this.idir = 2;
        if (this.funcArray[this.gj - 1][this.gi - 1] <= this.cont) {
            this.doInterpolation();
            return true;
        }
        this.fij = this.funcArray[this.gj - 1][this.gi - 1];
        return this.Routine_L41();
    }

    private boolean Routine_L41() {
        ++this.gi;
        if (this.gi > this.iee) {
            return true;
        }
        this.idir = 3;
        if (this.funcArray[this.gj - 1][this.gi - 1] <= this.cont) {
            this.doInterpolation();
            return true;
        }
        this.fij = this.funcArray[this.gj - 1][this.gi - 1];
        return this.Routine_L51();
    }

    private boolean Routine_L51() {
        ++this.gj;
        this.idir = 4;
        if (this.gj > this.jee) {
            return true;
        }
        if (this.funcArray[this.gj - 1][this.gi - 1] <= this.cont) {
            this.doInterpolation();
            return true;
        }
        this.fij = this.funcArray[this.gj - 1][this.gi - 1];
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private void doInterpolation() {
        block28: {
            var1_1 = this.funcArray[this.gj - 1][this.gi - 1];
            var3_2 = (this.cont - var1_1) / (this.fij - var1_1);
            if (MkMath.isUndefinedDouble(var3_2)) {
                var3_2 = Double.MIN_VALUE;
            }
            if (var3_2 == 0.0) {
                ++this.ignext;
            }
            var5_3 = 0.0;
            var7_4 = 0.0;
            var9_5 = 0.0;
            var11_6 = 0.0;
            if (this.xArray == null) break block28;
            var9_5 = this.xArray[this.gj - 1][this.gi - 1];
            var11_6 = this.yArray[this.gj - 1][this.gi - 1];
            switch (this.idir) {
                case 1: {
                    var5_3 = var9_5 + var3_2 * (this.xArray[this.gj - 1][this.gi + 1 - 1] - var9_5);
                    var7_4 = var11_6 + var3_2 * (this.yArray[this.gj - 1][this.gi + 1 - 1] - var11_6);
                    ** GOTO lbl52
                }
                case 2: {
                    var5_3 = var9_5 + var3_2 * (this.xArray[this.gj + 1 - 1][this.gi - 1] - var9_5);
                    var7_4 = var11_6 + var3_2 * (this.yArray[this.gj + 1 - 1][this.gi - 1] - var11_6);
                    ** GOTO lbl52
                }
                case 3: {
                    var5_3 = var9_5 + var3_2 * (this.xArray[this.gj - 1][this.gi - 1 - 1] - var9_5);
                    var7_4 = var11_6 + var3_2 * (this.yArray[this.gj - 1][this.gi - 1 - 1] - var11_6);
                    ** GOTO lbl52
                }
                case 4: {
                    var5_3 = var9_5 + var3_2 * (this.xArray[this.gj - 1 - 1][this.gi - 1] - var9_5);
                    var7_4 = var11_6 + var3_2 * (this.yArray[this.gj - 1 - 1][this.gi - 1] - var11_6);
                    ** GOTO lbl52
                }
                default: {
                    ** if (this.lnstrt != 1) goto lbl-1000
                }
            }
        }
        var9_5 = this.xArr1D[this.gi - 1];
        var11_6 = this.yArr1D[this.gj - 1];
        switch (this.idir) {
            case 1: {
                var5_3 = var9_5 + var3_2 * (this.xArr1D[this.gi + 1 - 1] - var9_5);
                var7_4 = var11_6;
                break;
            }
            case 2: {
                var5_3 = var9_5;
                var7_4 = var11_6 + var3_2 * (this.yArr1D[this.gj + 1 - 1] - var11_6);
                break;
            }
            case 3: {
                var5_3 = var9_5 + var3_2 * (this.xArr1D[this.gi - 1 - 1] - var9_5);
                var7_4 = var11_6;
                break;
            }
            case 4: {
                var5_3 = var9_5;
                var7_4 = var11_6 + var3_2 * (this.yArr1D[this.gj - 1 - 1] - var11_6);
            }
        }
lbl52:
        // 9 sources

        if (this.lnstrt == 1) lbl-1000:
        // 2 sources

        {
            this.np = 1;
            this.pathbufxt[this.np - 1] = var5_3;
            this.pathbufyt[this.np - 1] = var7_4;
            this.wx = var5_3;
            this.wy = var7_4;
            this.lnstrt = 0;
        } else lbl-1000:
        // 2 sources

        {
            var13_7 = false;
            if (this.ignext == 2) {
                if (var5_3 == this.pathbufxt[this.np - 1] && var7_4 == this.pathbufyt[this.np - 1]) {
                    this.ignext = 0;
                    var13_7 = true;
                } else {
                    this.ignext = 1;
                }
            }
            if (!var13_7) {
                ++this.np;
                this.pathbufxt[this.np - 1] = var5_3;
                this.pathbufyt[this.np - 1] = var7_4;
                if (this.np == 1000) {
                    this.accumContour(this.np, this.icont, this.pathbufxt, this.pathbufyt, this.cAttr[this.icont]);
                    this.pathbufxt[0] = this.pathbufxt[this.np - 1];
                    this.pathbufyt[0] = this.pathbufyt[this.np - 1];
                    this.np = 1;
                }
                if (var5_3 == this.wx && var7_4 == this.wy) {
                    return;
                }
            }
        }
        switch (this.idir) {
            case 1: {
                ++this.gi;
                if (this.Routine_L51()) break;
                this.Routine_L21();
                return;
            }
            case 2: {
                ++this.gj;
                this.Routine_L21();
                return;
            }
            case 3: {
                --this.gi;
                if (this.Routine_L31()) break;
                this.Routine_L21();
                return;
            }
            case 4: {
                --this.gj;
                if (this.Routine_L41()) break;
                this.Routine_L21();
                return;
            }
        }
    }

    private void accumContour(int n, int n2, double[] dArray, double[] dArray2, MkContourAttrib mkContourAttrib) {
        if (n < 3) {
            return;
        }
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        System.arraycopy(dArray, 0, dArray3, 0, n);
        System.arraycopy(dArray2, 0, dArray4, 0, n);
        MkContourPath mkContourPath = new MkContourPath(mkContourAttrib, n2, dArray3, dArray4);
        this.pathList.addElement(mkContourPath);
    }
}

