/*
 * Decompiled with CFR 0.152.
 */
import go.Go;
import go.GoColor;
import go.GoLineLoop;
import go.GoLines;
import go.GoVertex;

public class MkGeomAxes3D {
    static final int NONE = 0;
    static final int NORMAL = 1;
    static final int BOXED = 2;
    static final double FACTOR = 0.4;
    GoLineLoop top = new GoLineLoop(4);
    GoLines remainingEdges = new GoLines(4);
    GoLines remainingEdgesDarkColor = new GoLines(6);
    MkGeomAxis3D xAxis = new MkGeomAxis3D(0);
    MkGeomAxis3D yAxis = new MkGeomAxis3D(1);
    MkGeomAxis3D zAxis = new MkGeomAxis3D(2);
    int axesType = 1;
    double xMin;
    double xMax;
    double yMin;
    double yMax;
    double zMin;
    double zMax;
    double posX;
    double posY;
    double posZ;
    GoColor color;
    GoColor colorDarker;

    public void setColor(GoColor goColor) {
        this.color = goColor;
        this.colorDarker = new GoColor(0.4 * goColor.r, 0.4 * goColor.g, 0.4 * goColor.b);
    }

    public void setRGB(double d, double d2, double d3) {
        this.color.r = d;
        this.color.g = d2;
        this.color.b = d3;
        this.colorDarker.r = 0.4 * d;
        this.colorDarker.g = 0.4 * d2;
        this.colorDarker.b = 0.4 * d3;
    }

    public void calculatePoints(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        this.xMin = d;
        this.xMax = d2;
        this.yMin = d3;
        this.yMax = d4;
        this.zMin = d5;
        this.zMax = d6;
        this.posX = 0.0;
        this.posY = 0.0;
        this.posZ = 0.0;
        if (d > 0.0 || d2 < 0.0) {
            this.posX = d;
        }
        if (d3 > 0.0 || d4 < 0.0) {
            this.posY = d3;
        }
        if (d5 > 0.0 || d6 < 0.0) {
            this.posZ = d5;
        }
        this.top.xyz(0, d, d3, d6);
        this.top.xyz(1, d2, d3, d6);
        this.top.xyz(2, d2, d4, d6);
        this.top.xyz(3, d, d4, d6);
        this.remainingEdges.xyz(0, d2, d4, d5);
        this.remainingEdges.xyz(1, d2, d4, d6);
        this.remainingEdges.xyz(2, d, d4, d5);
        this.remainingEdges.xyz(3, d, d4, d6);
        this.remainingEdgesDarkColor.xyz(0, d, d3, d5);
        this.remainingEdgesDarkColor.xyz(1, d, d3, d6);
        this.remainingEdgesDarkColor.xyz(2, d, d3, d5);
        this.remainingEdgesDarkColor.xyz(3, d2, d3, d5);
        this.remainingEdgesDarkColor.xyz(4, d, d3, d5);
        this.remainingEdgesDarkColor.xyz(5, d, d4, d5);
        this.xAxis.calculatePoints(d, d2, d10);
        this.yAxis.calculatePoints(d3, d4, d10);
        this.zAxis.calculatePoints(d5, d6, d10);
        switch (this.axesType) {
            case 1: {
                this.xAxis.isNormal = true;
                this.yAxis.isNormal = true;
                this.zAxis.isNormal = true;
                this.xAxis.position(this.posY, this.posZ, d7, d8, d9);
                this.yAxis.position(this.posX, this.posZ, d7, d8, d9);
                this.zAxis.position(this.posX, this.posY, d7, d8, d9);
                this.xAxis.calculateHead(d7, d8, d9, d10);
                this.yAxis.calculateHead(d7, d8, d9, d10);
                this.zAxis.calculateHead(d7, d8, d9, d10);
                return;
            }
            case 2: {
                this.xAxis.isNormal = false;
                this.yAxis.isNormal = false;
                this.zAxis.isNormal = false;
                this.xAxis.position(d4, d5, d7, d8, d9);
                this.yAxis.position(d2, d5, d7, d8, d9);
                this.zAxis.position(d2, d3, d7, d8, d9);
                return;
            }
        }
    }

    public void setType(int n) {
        this.axesType = n;
    }

    public void setTicksVisi(boolean bl) {
        this.xAxis.showTicks = bl;
        this.yAxis.showTicks = bl;
        this.zAxis.showTicks = bl;
    }

    public void render(Go go, double d, double d2, double d3, boolean bl) {
        go.color(this.color.r, this.color.g, this.color.b);
        switch (this.axesType) {
            case 1: {
                this.xAxis.render(go, d, d2, d3, bl);
                this.yAxis.render(go, d, d2, d3, bl);
                this.zAxis.render(go, d, d2, d3, bl);
                return;
            }
            case 2: {
                this.xAxis.render(go, d, d2, d3, bl);
                this.yAxis.render(go, d, d2, d3, bl);
                this.zAxis.render(go, d, d2, d3, bl);
                go.render((GoVertex)this.top);
                go.render((GoVertex)this.remainingEdges);
                go.color(this.colorDarker.r, this.colorDarker.g, this.colorDarker.b);
                go.render((GoVertex)this.remainingEdgesDarkColor);
                return;
            }
        }
    }
}

