/*
 * Decompiled with CFR 0.152.
 */
import go.Go;
import go.GoLines;
import go.GoTriangleFan;
import go.GoTriangleStrip;
import go.GoVertex;
import goText.GoFont;
import goText.GoHershey;
import goText.GoText;

public class MkGeomAxis3D {
    static final int X_AXIS = 0;
    static final int Y_AXIS = 1;
    static final int Z_AXIS = 2;
    GoLines axis;
    GoTriangleFan axisHead;
    GoTriangleStrip axisHeadBase;
    GoLines[] ticks;
    GoText axisLabel;
    GoText[] tickLabels;
    GoFont aFont = new GoHershey("times.t");
    double[] tickValues;
    double textOffset;
    double tickRadius;
    double tickInc;
    double tickMin;
    double t;
    double mantissa;
    int exponent;
    int tickDiv;
    int i;
    int axisType;
    double scaleAxisLabel;
    double scaleTickLabel;
    double axisMin;
    double axisMax;
    boolean isNormal = true;
    boolean showTicks = false;

    public MkGeomAxis3D(int n) {
        this.axisType = n;
        this.tickDiv = 11;
        this.axis = new GoLines(2);
        this.ticks = new GoLines[this.tickDiv + 2];
        this.tickLabels = new GoText[this.tickDiv + 1];
        this.tickValues = new double[this.tickDiv + 1];
        this.axisHead = new GoTriangleFan(6, 0);
        this.axisHeadBase = new GoTriangleStrip(4, 0);
        String string = "0";
        switch (n) {
            case 0: {
                string = "x";
                break;
            }
            case 1: {
                string = "y";
                break;
            }
            case 2: {
                string = "z";
                break;
            }
        }
        this.axisLabel = new GoText(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 4, this.aFont, string);
        this.i = 0;
        while (this.i <= this.tickDiv) {
            this.ticks[this.i] = new GoLines(2);
            this.tickLabels[this.i] = new GoText(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 4, this.aFont, string);
            ++this.i;
        }
    }

    public void calculatePoints(double d, double d2, double d3) {
        this.tickRadius = d3 / 50.0;
        this.textOffset = d3 / 20.0;
        this.axisMin = d;
        this.axisMax = d2;
        this.scaleAxisLabel = this.textOffset / 1.5;
        this.scaleTickLabel = this.textOffset / 1.8;
        this.mantissa = MkMath.getMantissa(d2 - d);
        this.exponent = MkMath.getExponent(d2 - d);
        if (this.mantissa >= 1.0 && this.mantissa <= 2.0) {
            this.tickInc = 2.0 * Math.pow(10.0, this.exponent - 1);
        } else if (this.mantissa > 2.0 && this.mantissa <= 5.0) {
            this.tickInc = 5.0 * Math.pow(10.0, this.exponent - 1);
        } else if (this.mantissa > 5.0 && this.mantissa < 10.0) {
            this.tickInc = Math.pow(10.0, this.exponent);
        }
        int n = MkMath.numFracDigits(this.tickInc);
        MkMath.numIntDigits(this.tickInc);
        this.tickMin = this.tickInc * Math.ceil(MkMath.roundTo(d, n) / this.tickInc);
        this.tickDiv = (int)((MkMath.roundTo(d2, n) - this.tickMin) / this.tickInc);
        MkScientificFormat mkScientificFormat = new MkScientificFormat();
        this.i = 0;
        this.t = this.tickMin;
        while (this.i <= this.tickDiv) {
            this.tickValues[this.i] = this.t;
            ++this.i;
            this.t += this.tickInc;
        }
        this.axisLabel.scale(this.scaleAxisLabel, this.scaleAxisLabel);
        this.i = 0;
        while (this.i <= this.tickDiv) {
            this.tickLabels[this.i].scale(this.scaleTickLabel, this.scaleTickLabel);
            this.tickLabels[this.i].text(mkScientificFormat.format(MkMath.roundTo(this.tickValues[this.i], n)));
            ++this.i;
        }
    }

    public void calculateHead(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        double d8 = d4 / 25.0;
        double d9 = d4 / 75.0;
        double d10 = this.axis.x(1);
        double d11 = this.axis.y(1);
        double d12 = this.axis.z(1);
        double d13 = Math.sqrt(d * d * d10 * d10 + d2 * d2 * d11 * d11 + d3 * d3 * d12 * d12);
        double d14 = d * d10 / d13;
        double d15 = d2 * d11 / d13;
        double d16 = d3 * d12 / d13;
        if (d14 != 0.0 && d15 != 0.0) {
            d7 = -d15;
            d6 = d14;
            d5 = 0.0;
            d13 = Math.sqrt(d7 * d7 + d6 * d6 + d5 * d5);
            d7 /= d13;
            d6 /= d13;
        } else if (d15 == 0.0) {
            d7 = 0.0;
            d6 = 1.0;
            d5 = 0.0;
        } else {
            d7 = 1.0;
            d6 = 0.0;
            d5 = 0.0;
        }
        double d17 = d15 * d5 - d16 * d6;
        double d18 = d16 * d7 - d14 * d5;
        double d19 = d14 * d6 - d15 * d7;
        d13 = Math.sqrt(d17 * d17 + d18 * d18 + d19 * d19);
        d17 /= d13;
        d18 /= d13;
        d19 /= d13;
        double d20 = d * d10 - d8 * d14;
        double d21 = d2 * d11 - d8 * d15;
        double d22 = d3 * d12 - d8 * d16;
        this.axisHead.xyz(0, d * d10, d2 * d11, d3 * d12);
        this.axisHead.xyz(1, (d7 *= d9) + d20, (d6 *= d9) + d21, (d5 *= d9) + d22);
        this.axisHead.xyz(2, (d17 *= d9) + d20, (d18 *= d9) + d21, (d19 *= d9) + d22);
        this.axisHead.xyz(3, -d7 + d20, -d6 + d21, -d5 + d22);
        this.axisHead.xyz(4, -d17 + d20, -d18 + d21, -d19 + d22);
        this.axisHead.xyz(5, d7 + d20, d6 + d21, d5 + d22);
        this.axisHeadBase.xyz(0, d7 + d20, d6 + d21, d5 + d22);
        this.axisHeadBase.xyz(1, -d17 + d20, -d18 + d21, -d19 + d22);
        this.axisHeadBase.xyz(2, d17 + d20, d18 + d21, d19 + d22);
        this.axisHeadBase.xyz(3, -d7 + d20, -d6 + d21, -d5 + d22);
    }

    public void position(double d, double d2, double d3, double d4, double d5) {
        double d6;
        double d7;
        if (this.isNormal) {
            d7 = this.textOffset;
            d6 = this.axisMax;
        } else {
            d7 = -this.textOffset;
            d6 = (this.axisMax + this.axisMin) / 2.0;
        }
        switch (this.axisType) {
            case 0: {
                this.axis.xyz(0, this.axisMin, d, d2);
                this.axis.xyz(1, this.axisMax, d, d2);
                if (this.isNormal) {
                    this.axisLabel.position(d3 * d6 + d7, d4 * d, d5 * d2);
                } else {
                    this.axisLabel.position(d3 * d6, d4 * d - 2.0 * d7, d5 * d2);
                }
                this.i = 0;
                while (this.i <= this.tickDiv) {
                    this.ticks[this.i].xyz(0, d3 * this.tickValues[this.i], d4 * d - this.tickRadius, d5 * d2);
                    this.ticks[this.i].xyz(1, d3 * this.tickValues[this.i], d4 * d + this.tickRadius, d5 * d2);
                    this.tickLabels[this.i].position(d3 * this.tickValues[this.i], d4 * d - d7, d5 * d2);
                    ++this.i;
                }
                return;
            }
            case 1: {
                this.axis.xyz(0, d, this.axisMin, d2);
                this.axis.xyz(1, d, this.axisMax, d2);
                if (this.isNormal) {
                    this.axisLabel.position(d3 * d, d4 * d6 + d7, d5 * d2);
                } else {
                    this.axisLabel.position(d3 * d - 2.0 * d7, d4 * d6, d5 * d2);
                }
                this.i = 0;
                while (this.i <= this.tickDiv) {
                    this.ticks[this.i].xyz(0, d3 * d - this.tickRadius, d4 * this.tickValues[this.i], d5 * d2);
                    this.ticks[this.i].xyz(1, d3 * d + this.tickRadius, d4 * this.tickValues[this.i], d5 * d2);
                    this.tickLabels[this.i].position(d3 * d - d7, d4 * this.tickValues[this.i], d5 * d2);
                    ++this.i;
                }
                return;
            }
            case 2: {
                d7 = this.textOffset;
                this.axis.xyz(0, d, d2, this.axisMin);
                this.axis.xyz(1, d, d2, this.axisMax);
                if (this.isNormal) {
                    this.axisLabel.position(d3 * d, d4 * d2, d5 * d6 + d7);
                } else {
                    this.axisLabel.position(d3 * d, d4 * d2 - 2.0 * d7, d5 * d6);
                }
                this.i = 0;
                while (this.i <= this.tickDiv) {
                    this.ticks[this.i].xyz(0, d3 * d, d4 * d2 - this.tickRadius, d5 * this.tickValues[this.i]);
                    this.ticks[this.i].xyz(1, d3 * d, d4 * d2 + this.tickRadius, d5 * this.tickValues[this.i]);
                    this.tickLabels[this.i].position(d3 * d, d4 * d2 - d7, d5 * this.tickValues[this.i]);
                    ++this.i;
                }
                return;
            }
        }
    }

    public void render(Go go, double d, double d2, double d3, boolean bl) {
        go.render((GoVertex)this.axis);
        if (!bl) {
            go.push(32768);
            go.scale(1.0 / d, 1.0 / d2, 1.0 / d3);
            this.axisLabel.render(go);
            go.render((GoVertex)this.axisHead);
            go.render((GoVertex)this.axisHeadBase);
            if (this.showTicks) {
                this.i = 0;
                while (this.i <= this.tickDiv) {
                    go.render((GoVertex)this.ticks[this.i]);
                    this.tickLabels[this.i].render(go);
                    ++this.i;
                }
            }
            go.pop(32768);
            return;
        }
        this.axisLabel.render(go);
        go.render((GoVertex)this.axisHead);
        go.render((GoVertex)this.axisHeadBase);
        if (this.showTicks) {
            this.i = 0;
            while (this.i <= this.tickDiv) {
                go.render((GoVertex)this.ticks[this.i]);
                this.tickLabels[this.i].render(go);
                ++this.i;
            }
        }
    }
}

