/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.Vector;
import org.nfunk.jep.IllegalExpressionException;
import org.nfunk.jep.JEP;

public class MkGeomCurve2D {
    String ft = "t";
    String gt = "t";
    String fx = "x";
    String fxRec = "1/x";
    double tMin;
    double tMax;
    double tInc;
    double t;
    double xMin;
    double xMax;
    double xInc;
    int tDiv;
    int i;
    int xDiv;
    double[] x;
    double[] y;
    double[] dy;
    double[] ddy;
    public double[] xRec = new double[1000];
    public double[] yRec = new double[1000];
    int numPts;
    int[] regions;
    Color color = Color.black;
    public int lastVisPt;
    String label = "";
    boolean showLab = false;
    static final int LABEL_OFFSET = 50;
    boolean[] definedPts;
    public Vector bracketStart = new Vector();
    public Vector roots = new Vector();
    public boolean hasDiscontinuities = false;
    public boolean discont = false;

    public MkGeomCurve2D() {
    }

    public MkGeomCurve2D(int n) {
        this.numPts = n;
        this.x = new double[this.numPts];
        this.y = new double[this.numPts];
        this.dy = new double[this.numPts];
        this.ddy = new double[this.numPts];
        this.definedPts = new boolean[this.numPts];
        this.regions = new int[this.numPts];
        this.lastVisPt = this.numPts - 1;
    }

    public void setCurve(String string, double d, double d2, int n, MkRenderer2D mkRenderer2D) throws IllegalExpressionException {
        this.fx = string;
        this.xMin = d;
        this.xMax = d2;
        this.xDiv = n;
        this.xInc = (d2 - d) / (double)n;
        this.numPts = n + 1;
        this.x = new double[this.numPts];
        this.y = new double[this.numPts];
        this.dy = new double[this.numPts];
        this.ddy = new double[this.numPts];
        this.definedPts = new boolean[this.numPts];
        this.regions = new int[this.numPts];
        this.lastVisPt = this.numPts - 1;
        this.calculatePoints(mkRenderer2D.parser1);
    }

    public void setCurve(String string, String string2, double d, double d2, int n, MkRenderer2D mkRenderer2D) throws IllegalExpressionException {
        this.ft = string;
        this.gt = string2;
        this.tMin = d;
        this.tMax = d2;
        this.tDiv = n;
        this.tInc = (d2 - d) / (double)n;
        this.numPts = this.xDiv + 1;
        this.x = new double[this.numPts];
        this.y = new double[this.numPts];
        this.dy = new double[this.numPts];
        this.ddy = new double[this.numPts];
        this.definedPts = new boolean[this.numPts];
        this.regions = new int[this.numPts];
        this.lastVisPt = this.numPts - 1;
        this.calculatePoints(mkRenderer2D.parser1, mkRenderer2D.parser2);
    }

    public void setCurve(int n) {
        this.numPts = n;
        this.x = new double[this.numPts];
        this.y = new double[this.numPts];
        this.dy = new double[this.numPts];
        this.ddy = new double[this.numPts];
        this.definedPts = new boolean[this.numPts];
        this.regions = new int[this.numPts];
        this.lastVisPt = this.numPts - 1;
        this.calculateRegions();
    }

    public void setCurve(double[] dArray, double[] dArray2) {
        this.numPts = dArray.length;
        this.x = new double[this.numPts];
        this.y = new double[this.numPts];
        this.dy = new double[this.numPts];
        this.ddy = new double[this.numPts];
        this.definedPts = new boolean[this.numPts];
        this.regions = new int[this.numPts];
        System.arraycopy(dArray, 0, this.x, 0, this.numPts);
        System.arraycopy(dArray2, 0, this.y, 0, this.numPts);
        this.lastVisPt = this.numPts - 1;
        this.calculateRegions();
    }

    public void setCurve(double[] dArray, double[] dArray2, int n) {
        this.numPts = n + 1;
        this.x = new double[this.numPts];
        this.y = new double[this.numPts];
        this.dy = new double[this.numPts];
        this.ddy = new double[this.numPts];
        this.regions = new int[this.numPts];
        this.definedPts = new boolean[this.numPts];
        System.arraycopy(dArray, 0, this.x, 0, this.numPts);
        System.arraycopy(dArray2, 0, this.y, 0, this.numPts);
        this.lastVisPt = n;
        this.calculateRegions();
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void showLabel(boolean bl) {
        this.showLab = bl;
    }

    public void setLastVisPt(int n) {
        this.lastVisPt = n;
    }

    public double getf(JEP jEP, double d) {
        jEP.addVariable("x", d);
        return jEP.getValue();
    }

    public void calculatePoints(JEP jEP) throws IllegalExpressionException {
        jEP.addVariable("x", 0.0);
        jEP.parseExpression(this.fx);
        this.i = 0;
        double d = this.xMin;
        while (this.i < this.numPts) {
            this.x[this.i] = d;
            this.y[this.i] = this.getf(jEP, d);
            ++this.i;
            d += this.xInc;
        }
        if (this.discont) {
            this.calculatePointsReciprocal(jEP);
            this.calculateRegionsBis();
            return;
        }
        this.calculateRegions();
    }

    public void calculatePoints(JEP jEP, JEP jEP2) throws IllegalExpressionException {
        jEP.addVariable("t", 0.0);
        jEP2.addVariable("t", 0.0);
        jEP.parseExpression(this.ft);
        jEP2.parseExpression(this.gt);
        this.i = 0;
        this.t = this.tMin;
        while (this.i < this.numPts) {
            jEP.addVariable("t", this.t);
            jEP2.addVariable("t", this.t);
            this.x[this.i] = jEP.getValue();
            this.y[this.i] = jEP2.getValue();
            ++this.i;
            this.t += this.tInc;
        }
        this.calculateRegions();
    }

    public void calculateRegions() {
        double d = this.getCurveBound();
        int n = 1;
        this.i = 0;
        while (this.i < this.numPts) {
            if (MkMath.isUndefinedDouble(this.y[this.i])) {
                this.regions[this.i] = 0;
                n = -n;
            } else {
                this.regions[this.i] = Math.abs(this.y[this.i]) > d ? 0 : n;
            }
            ++this.i;
        }
    }

    public void calculateRegionsBis() {
        double d = this.getCurveBound();
        int n = 1;
        boolean bl = false;
        if (this.hasDiscontinuities) {
            int n2 = 0;
            double d2 = (Double)this.roots.elementAt(n2);
            this.i = 0;
            while (this.i < this.numPts) {
                if (this.x[this.i] < d2 || bl) {
                    this.regions[this.i] = Math.abs(this.y[this.i]) > d ? 0 : n;
                } else {
                    if (++n2 < this.roots.size()) {
                        d2 = (Double)this.roots.elementAt(n2);
                    } else {
                        bl = true;
                    }
                    n = -n;
                    this.regions[this.i] = Math.abs(this.y[this.i]) > d ? 0 : n;
                }
                ++this.i;
            }
            return;
        }
        this.i = 0;
        while (this.i < this.numPts) {
            if (MkMath.isUndefinedDouble(this.y[this.i])) {
                this.regions[this.i] = 0;
                n = -n;
            } else {
                this.regions[this.i] = n;
            }
            ++this.i;
        }
    }

    double getCurveBound() {
        double[] dArray = new double[this.numPts];
        System.arraycopy(this.y, 0, dArray, 0, this.numPts);
        this.i = 0;
        while (this.i < this.numPts) {
            dArray[this.i] = Math.abs(dArray[this.i]);
            ++this.i;
        }
        int n = (int)Math.round(0.9 * (double)this.numPts);
        Sort.quickSelect(dArray, n);
        double d = dArray[n - 1];
        double d2 = Math.abs(10.0 * d);
        return d2;
    }

    public void calculatePointsReciprocal(JEP jEP) throws IllegalExpressionException {
        this.hasDiscontinuities = false;
        this.bracketStart.removeAllElements();
        this.fxRec = "1/(" + this.fx + ")";
        jEP.addVariable("x", 0.0);
        jEP.parseExpression(this.fxRec);
        this.xInc = (this.xMax - this.xMin) / 1000.0;
        this.i = 0;
        double d = this.xMin;
        while (this.i < 1000) {
            this.xRec[this.i] = d;
            this.yRec[this.i] = this.getfRec(jEP, d);
            ++this.i;
            d += this.xInc;
        }
        this.i = 0;
        while (this.i < 999) {
            if (!MkMath.isUndefinedDouble(this.yRec[this.i]) && !MkMath.isUndefinedDouble(this.yRec[this.i + 1]) && this.yRec[this.i] * this.yRec[this.i + 1] <= 0.0) {
                this.bracketStart.addElement(new Integer(this.i));
            }
            ++this.i;
        }
        this.roots.removeAllElements();
        this.i = 0;
        while (this.i < this.bracketStart.size()) {
            int n = (Integer)this.bracketStart.elementAt(this.i);
            double d2 = this.bisectionRootFinder(this.xRec[n], this.xRec[n + 1], 100, jEP);
            double d3 = this.getfRec(jEP, d2);
            if (!MkMath.isUndefinedDouble(d3) && Math.abs(d3) < 1.0) {
                this.roots.addElement(new Double(d2));
            }
            ++this.i;
        }
        if (this.roots.size() != 0) {
            this.hasDiscontinuities = true;
        }
    }

    public double getfRec(JEP jEP, double d) {
        jEP.addVariable("x", d);
        return jEP.getValue();
    }

    public double bisectionRootFinder(double d, double d2, int n, JEP jEP) throws IllegalExpressionException {
        jEP.addVariable("x", 0.0);
        jEP.parseExpression(this.fxRec);
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = this.getfRec(jEP, d);
        double d7 = this.getfRec(jEP, d2);
        double d8 = 0.0;
        boolean bl = false;
        if (d6 == 0.0 && d7 != 0.0) {
            return d;
        }
        if (d7 == 0.0 && d6 != 0.0) {
            return d2;
        }
        if (d6 == 0.0 && d7 == 0.0) {
            return d;
        }
        if (d6 < 0.0) {
            d3 = d;
            d4 = d2;
        } else if (d6 > 0.0) {
            d3 = d2;
            d4 = d;
        }
        int n2 = 0;
        bl = false;
        while (n2 < n && !bl) {
            d5 = 0.5 * (d3 + d4);
            d8 = this.getfRec(jEP, d5);
            if (d8 < 0.0) {
                d3 = d5;
            } else if (d8 > 0.0) {
                d4 = d5;
            } else {
                bl = true;
            }
            ++n2;
        }
        return d5;
    }

    public void render(MkRenderer2D mkRenderer2D) {
        mkRenderer2D.setColor(this.color);
        this.i = 0;
        long l = (long)mkRenderer2D.ulx() + (long)mkRenderer2D.go2D.transformX(this.x[this.i], this.y[this.i]);
        long l2 = (long)mkRenderer2D.lry() - (long)mkRenderer2D.go2D.transformY(this.x[this.i], this.y[this.i]);
        ++this.i;
        while (this.i <= this.lastVisPt) {
            long l3 = (long)mkRenderer2D.ulx() + (long)mkRenderer2D.go2D.transformX(this.x[this.i], this.y[this.i]);
            long l4 = (long)mkRenderer2D.lry() - (long)mkRenderer2D.go2D.transformY(this.x[this.i], this.y[this.i]);
            if (this.regions[this.i - 1] == this.regions[this.i] && this.regions[this.i] != 0) {
                mkRenderer2D.drawLine(l, l2, l3, l4);
            }
            l = l3;
            l2 = l4;
            ++this.i;
        }
        if (this.showLab) {
            mkRenderer2D.drawText(this.label, l - 50L, l2);
        }
    }

    void putInRange(MkRenderer2D mkRenderer2D) {
        this.i = 0;
        while (this.i < this.numPts) {
            mkRenderer2D.addXToBoundbox(this.x[this.i]);
            if (this.regions[this.i] != 0) {
                mkRenderer2D.addYToBoundbox(this.y[this.i]);
            }
            ++this.i;
        }
    }
}

