/*
 * Decompiled with CFR 0.152.
 */
import go.Go;
import go.GoColor;
import go.GoLines;
import go.GoMatrix;
import go.GoVertex;

public class MkGeomLine3D {
    MkTuple3d ptA;
    MkTuple3d ptB;
    GoLines line = new GoLines(2, 0);
    GoColor color;

    public MkGeomLine3D() {
        this.ptA = new MkTuple3d();
        this.ptB = new MkTuple3d();
    }

    public MkGeomLine3D(double d, double d2, double d3, double d4, double d5, double d6) {
        this.ptA = new MkTuple3d(d, d2, d3);
        this.ptB = new MkTuple3d(d4, d5, d6);
    }

    public void setXYZ(double d, double d2, double d3, double d4, double d5, double d6) {
        this.ptA.setXYZ(d, d2, d3);
        this.ptB.setXYZ(d4, d5, d6);
    }

    public void calculatePoints() {
        this.line.xyz(0, this.ptA.x, this.ptA.y, this.ptA.z);
        this.line.xyz(1, this.ptB.x, this.ptB.y, this.ptB.z);
    }

    public void calculatePoints(GoMatrix goMatrix) {
        double[] dArray = goMatrix.m;
        this.line.xyz(0, this.ptA.x, this.ptA.y, this.ptA.z);
        this.line.xyz(1, this.ptB.x, this.ptB.y, this.ptB.z);
        MkMath.transformPoint(dArray, (GoVertex)this.line);
    }

    public void render(Go go) {
        go.color(this.color.r, this.color.g, this.color.b);
        go.render((GoVertex)this.line);
    }

    void putInRange(MkRenderer3D mkRenderer3D) {
        mkRenderer3D.go.renderMode(8);
        this.render(mkRenderer3D.go);
    }

    public void setColor(GoColor goColor) {
        this.color = goColor;
    }

    public void setRGB(double d, double d2, double d3) {
        this.color.r = d;
        this.color.g = d2;
        this.color.b = d3;
    }
}

