/*
 * Decompiled with CFR 0.152.
 */
import go.Go;
import go.GoColor;
import go.GoLines;
import go.GoMatrix;
import go.GoVertex;
import org.nfunk.jep.IllegalExpressionException;
import org.nfunk.jep.JEP;

public class MkGeomPoint3D
extends MkTuple3d {
    MkGeomSurface3D sphere = new MkGeomSurface3D("u*sin(v)*cos(w)", "u*sin(v)*sin(w)", "u*cos(v)", 0);
    MkGeomText3D label = new MkGeomText3D("");
    boolean showLabel = true;
    GoLines line = new GoLines(2);

    public MkGeomPoint3D() {
        this.sphere.setZShading(false);
    }

    public MkGeomPoint3D(double d, double d2, double d3) {
        super(d, d2, d3);
        this.sphere.setZShading(false);
    }

    public double distanceToPoint(MkGeomPoint3D mkGeomPoint3D) {
        double d = this.x - mkGeomPoint3D.x;
        double d2 = this.y - mkGeomPoint3D.y;
        double d3 = this.z - mkGeomPoint3D.z;
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    public void setColor(GoColor goColor) {
        this.sphere.color = goColor;
    }

    public void setRGB(double d, double d2, double d3) {
        this.sphere.color.r = d;
        this.sphere.color.g = d2;
        this.sphere.color.b = d3;
    }

    public void calculatePoints(JEP jEP, JEP jEP2, JEP jEP3, double d, double d2, double d3, double d4) throws IllegalExpressionException {
        double d5 = d4 / 100.0;
        this.sphere.setParamVW(0.0, Math.PI, 10, 0.0, Math.PI * 2, 10);
        this.sphere.setConstantConstraint(d5);
        this.sphere.calculatePoints(jEP, jEP2, jEP3);
        int n = 0;
        while (n < 10) {
            int n2 = this.sphere.surface[n].vertexNumber();
            int n3 = 0;
            while (n3 < n2) {
                double d6 = this.sphere.surface[n].x(n3) + d * this.x;
                double d7 = this.sphere.surface[n].y(n3) + d2 * this.y;
                double d8 = this.sphere.surface[n].z(n3) + d3 * this.z;
                this.sphere.surface[n].xyz(n3, d6, d7, d8);
                ++n3;
            }
            ++n;
        }
        this.label.setXYZ(this.x + 2.0 * d5, this.y + 2.0 * d5, this.z + 2.0 * d5);
        this.label.calculatePoints(d, d2, d3, d4);
    }

    public void calculatePoints(JEP jEP, JEP jEP2, JEP jEP3, GoMatrix goMatrix, double d) throws IllegalExpressionException {
        double[] dArray = goMatrix.m;
        double d2 = d / 100.0;
        this.sphere.setParamVW(0.0, Math.PI, 10, 0.0, Math.PI * 2, 10);
        this.sphere.setConstantConstraint(d2);
        this.sphere.calculatePoints(jEP, jEP2, jEP3);
        int n = 0;
        while (n < 10) {
            int n2 = this.sphere.surface[n].vertexNumber();
            int n3 = 0;
            while (n3 < n2) {
                double d3 = this.sphere.surface[n].x(n3) + this.x;
                double d4 = this.sphere.surface[n].y(n3) + this.y;
                double d5 = this.sphere.surface[n].z(n3) + this.z;
                this.sphere.surface[n].xyz(n3, d3, d4, d5);
                ++n3;
            }
            MkMath.transformPoint(dArray, this.sphere.surface[n]);
            ++n;
        }
    }

    public void setLabel(String string) {
        this.label.setText(string);
    }

    public void render(Go go) {
        this.line.xyz(0, this.x, this.y, this.z);
        this.line.xyz(1, this.x, this.y, this.z);
        go.render((GoVertex)this.line);
    }

    public void render(Go go, double d, double d2, double d3, boolean bl) {
        if (!bl) {
            go.push(32768);
            go.scale(1.0 / d, 1.0 / d2, 1.0 / d3);
            this.sphere.render(go);
            go.pop(32768);
        } else {
            this.sphere.render(go);
        }
        if (this.showLabel) {
            this.label.render(go, d, d2, d3, bl);
        }
    }
}

