/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import org.nfunk.jep.IllegalExpressionException;
import org.nfunk.jep.JEP;

public class MkGeomSlice2D {
    String ft = "t";
    String gt = "t";
    String fx = "x";
    double tMin;
    double tMax;
    double tInc;
    double t;
    double xMin;
    double xMax;
    double xInc;
    int tDiv;
    int i;
    int xDiv;
    double[] x;
    double[] y;
    int numPts;
    Color color = Color.black;
    public int lastVisPt;
    String label = "";
    boolean showLab = false;
    static final int LABEL_OFFSET = 50;

    public MkGeomSlice2D() {
    }

    public MkGeomSlice2D(int n) {
        this.numPts = n;
        this.x = new double[this.numPts];
        this.y = new double[this.numPts];
        this.lastVisPt = this.numPts - 1;
    }

    public void setSlice(String string, double d, double d2, int n, MkRenderer2D mkRenderer2D) throws IllegalExpressionException {
        this.fx = string;
        this.xMin = d;
        this.xMax = d2;
        this.xDiv = n;
        this.xInc = (d2 - d) / (double)n;
        this.numPts = n + 1;
        this.x = new double[this.numPts];
        this.y = new double[this.numPts];
        this.lastVisPt = this.numPts - 1;
        this.calculatePoints(mkRenderer2D.parser1);
    }

    public void setSlice(String string, String string2, double d, double d2, int n, MkRenderer2D mkRenderer2D) throws IllegalExpressionException {
        this.ft = string;
        this.gt = string2;
        this.tMin = d;
        this.tMax = d2;
        this.tDiv = n;
        this.tInc = (d2 - d) / (double)n;
        this.numPts = this.xDiv + 1;
        this.x = new double[this.numPts];
        this.y = new double[this.numPts];
        this.lastVisPt = this.numPts - 1;
        this.calculatePoints(mkRenderer2D.parser1, mkRenderer2D.parser2);
    }

    public void setSlice(int n) {
        this.numPts = n;
        this.x = new double[this.numPts];
        this.y = new double[this.numPts];
        this.lastVisPt = this.numPts - 1;
    }

    public void setSlice(double[] dArray, double[] dArray2) {
        this.numPts = dArray.length;
        this.x = new double[this.numPts];
        this.y = new double[this.numPts];
        System.arraycopy(dArray, 0, this.x, 0, this.numPts);
        System.arraycopy(dArray2, 0, this.y, 0, this.numPts);
        this.lastVisPt = this.numPts - 1;
    }

    public void setSlice(double[] dArray, double[] dArray2, int n) {
        this.numPts = n + 1;
        this.x = new double[this.numPts];
        this.y = new double[this.numPts];
        System.arraycopy(dArray, 0, this.x, 0, this.numPts);
        System.arraycopy(dArray2, 0, this.y, 0, this.numPts);
        this.lastVisPt = n;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void showLabel(boolean bl) {
        this.showLab = bl;
    }

    public void setLastVisPt(int n) {
        this.lastVisPt = n;
    }

    public void calculatePoints(JEP jEP) throws IllegalExpressionException {
        jEP.addVariable("x", 0.0);
        jEP.parseExpression(this.fx);
        this.i = 0;
        double d = this.xMin;
        while (this.i < this.numPts) {
            jEP.addVariable("x", d);
            this.x[this.i] = d;
            this.y[this.i] = jEP.getValue();
            ++this.i;
            d += this.xInc;
        }
    }

    public void calculatePoints(JEP jEP, JEP jEP2) throws IllegalExpressionException {
        jEP.addVariable("t", 0.0);
        jEP2.addVariable("t", 0.0);
        jEP.parseExpression(this.ft);
        jEP2.parseExpression(this.gt);
        this.i = 0;
        this.t = this.tMin;
        while (this.i < this.numPts) {
            jEP.addVariable("t", this.t);
            jEP2.addVariable("t", this.t);
            this.x[this.i] = jEP.getValue();
            this.y[this.i] = jEP2.getValue();
            ++this.i;
            this.t += this.tInc;
        }
    }

    public void render(MkRenderer2D mkRenderer2D) {
        long l;
        long l2;
        mkRenderer2D.setColor(this.color);
        this.i = 0;
        long l3 = (long)mkRenderer2D.ulx() + (long)mkRenderer2D.go2D.transformX(this.x[this.i], this.y[this.i]);
        long l4 = (long)mkRenderer2D.lry() - (long)mkRenderer2D.go2D.transformY(this.x[this.i], this.y[this.i]);
        ++this.i;
        while (this.i <= this.lastVisPt) {
            l2 = (long)mkRenderer2D.ulx() + (long)mkRenderer2D.go2D.transformX(this.x[this.i], this.y[this.i]);
            l = (long)mkRenderer2D.lry() - (long)mkRenderer2D.go2D.transformY(this.x[this.i], this.y[this.i]);
            mkRenderer2D.drawLine(l3, l4, l2, l);
            l3 = l2;
            l4 = l;
            ++this.i;
        }
        if (this.showLab) {
            mkRenderer2D.drawText(this.label, l3 - 50L, l4);
        }
        l3 = (long)mkRenderer2D.ulx() + (long)mkRenderer2D.go2D.transformX(this.x[0], 0.0);
        l4 = (long)mkRenderer2D.lry() - (long)mkRenderer2D.go2D.transformY(this.x[0], 0.0);
        l2 = (long)mkRenderer2D.ulx() + (long)mkRenderer2D.go2D.transformX(this.x[0], this.y[0]);
        l = (long)mkRenderer2D.lry() - (long)mkRenderer2D.go2D.transformY(this.x[0], this.y[0]);
        mkRenderer2D.drawLine(l3, l4, l2, l);
        l3 = (long)mkRenderer2D.ulx() + (long)mkRenderer2D.go2D.transformX(this.x[this.lastVisPt], 0.0);
        l4 = (long)mkRenderer2D.lry() - (long)mkRenderer2D.go2D.transformY(this.x[this.lastVisPt], 0.0);
        l2 = (long)mkRenderer2D.ulx() + (long)mkRenderer2D.go2D.transformX(this.x[this.lastVisPt], this.y[this.lastVisPt]);
        l = (long)mkRenderer2D.lry() - (long)mkRenderer2D.go2D.transformY(this.x[this.lastVisPt], this.y[this.lastVisPt]);
        mkRenderer2D.drawLine(l3, l4, l2, l);
        l3 = (long)mkRenderer2D.ulx() + (long)mkRenderer2D.go2D.transformX(this.x[0], 0.0);
        l4 = (long)mkRenderer2D.lry() - (long)mkRenderer2D.go2D.transformY(this.x[0], 0.0);
        l2 = (long)mkRenderer2D.ulx() + (long)mkRenderer2D.go2D.transformX(this.x[this.lastVisPt], 0.0);
        l = (long)mkRenderer2D.lry() - (long)mkRenderer2D.go2D.transformY(this.x[this.lastVisPt], 0.0);
        mkRenderer2D.drawLine(l3, l4, l2, l);
    }

    void putInRange(MkRenderer2D mkRenderer2D) {
        this.i = 0;
        while (this.i < this.numPts) {
            mkRenderer2D.addXToBoundbox(this.x[this.i]);
            mkRenderer2D.addYToBoundbox(this.y[this.i]);
            ++this.i;
        }
    }
}

