/*
 * Decompiled with CFR 0.152.
 */
import go.Go;
import go.GoColor;
import go.GoLineStrip;
import go.GoLines;
import go.GoVertex;
import org.nfunk.jep.IllegalExpressionException;
import org.nfunk.jep.JEP;

class MkGeomSliceZDirection3D {
    static final int PARALLEL_OX = 0;
    static final int PARALLEL_OY = 1;
    static final int DIRECTIONAL = 2;
    int sliceType;
    MkTuple3d ptA = new MkTuple3d();
    MkTuple3d ptB = new MkTuple3d();
    GoLines lineA = new GoLines(2, 0);
    GoLines lineB = new GoLines(2, 0);
    GoLines lineAB = new GoLines(2, 0);
    GoLineStrip curve;
    double[] xVal;
    double[] yVal;
    double[] zVal;
    double[] sVal;
    GoColor color;
    JEP parser1;
    String fxy;
    double xMin;
    double xMax;
    double xInc;
    double yMin;
    double yMax;
    double yInc;
    double sMin;
    double sMax;
    double sInc;
    double cosTheta;
    double sinTheta;
    int varDiv;

    public MkGeomSliceZDirection3D() {
    }

    public MkGeomSliceZDirection3D(int n) {
        this.sliceType = n;
    }

    public void setType(int n) {
        this.sliceType = n;
    }

    public void setFunction(String string) {
        this.fxy = string;
    }

    public void setDirection(double d, double d2) {
        this.cosTheta = d;
        this.sinTheta = d2;
    }

    public void setDivisions(int n) {
        this.varDiv = n;
        this.curve = null;
        this.xVal = null;
        this.yVal = null;
        this.zVal = null;
        this.sVal = null;
        this.curve = new GoLineStrip(n + 1, 0);
        this.xVal = new double[n + 1];
        this.yVal = new double[n + 1];
        this.zVal = new double[n + 1];
        this.sVal = new double[n + 1];
    }

    public void setVarBounds(double d, double d2) {
        if (this.sliceType == 0) {
            this.xMin = d;
            this.xMax = d2;
            this.xInc = (d2 - d) / (double)this.varDiv;
            return;
        }
        if (this.sliceType == 1) {
            this.yMin = d;
            this.yMax = d2;
            this.yInc = (d2 - d) / (double)this.varDiv;
            return;
        }
        this.sMin = d;
        this.sMax = d2;
        this.sInc = (d2 - d) / (double)this.varDiv;
    }

    public void initializeParser(JEP jEP) throws IllegalExpressionException {
        this.parser1 = jEP;
        jEP.addVariable("x", 0.0);
        jEP.addVariable("y", 0.0);
        jEP.parseExpression(this.fxy);
    }

    double getZ(double d, double d2) {
        this.parser1.addVariable("x", d);
        this.parser1.addVariable("y", d2);
        return this.parser1.getValue();
    }

    public void calculatePoints(double d, double d2, double d3) {
        int n = this.yVal.length;
        if (this.sliceType == 0) {
            double d4 = d2;
            int n2 = 0;
            double d5 = this.xMin;
            while (n2 <= this.varDiv) {
                double d6 = this.getZ(d5, d4);
                this.xVal[n2] = d5;
                this.yVal[n2] = d4;
                this.zVal[n2] = d6;
                this.curve.xyz(n2, d5, d4, d6);
                d5 += this.xInc;
                ++n2;
            }
            this.ptA.setXYZ(this.xVal[0], d2, d3);
            this.ptB.setXYZ(this.xVal[this.varDiv], d2, d3);
        } else if (this.sliceType == 1) {
            double d7 = d;
            int n3 = 0;
            double d8 = this.yMin;
            while (n3 <= this.varDiv) {
                double d9 = this.getZ(d7, d8);
                this.xVal[n3] = d7;
                this.yVal[n3] = d8;
                this.zVal[n3] = d9;
                this.curve.xyz(n3, d7, d8, d9);
                d8 += this.yInc;
                ++n3;
            }
            this.ptA.setXYZ(d, this.yVal[0], d3);
            this.ptB.setXYZ(d, this.yVal[this.varDiv], d3);
        } else {
            int n4 = 0;
            double d10 = this.sMin;
            while (n4 <= this.varDiv) {
                double d11 = d + d10 * this.cosTheta;
                double d12 = d2 + d10 * this.sinTheta;
                double d13 = this.getZ(d11, d12);
                this.xVal[n4] = d11;
                this.yVal[n4] = d12;
                this.sVal[n4] = d10;
                this.zVal[n4] = d13;
                this.curve.xyz(n4, d11, d12, d13);
                d10 += this.sInc;
                ++n4;
            }
            this.ptA.setXYZ(this.xVal[0], this.yVal[0], d3);
            this.ptB.setXYZ(this.xVal[this.varDiv], this.yVal[this.varDiv], d3);
        }
        this.lineA.xyz(0, this.ptA.x, this.ptA.y, this.ptA.z);
        this.lineA.xyz(1, this.ptA.x, this.ptA.y, this.getZ(this.ptA.x, this.ptA.y));
        this.lineB.xyz(0, this.ptB.x, this.ptB.y, this.ptB.z);
        this.lineB.xyz(1, this.ptB.x, this.ptB.y, this.getZ(this.ptB.x, this.ptB.y));
        this.lineAB.xyz(0, this.ptA.x, this.ptA.y, this.ptB.z);
        this.lineAB.xyz(1, this.ptB.x, this.ptB.y, this.ptB.z);
    }

    public void setColor(GoColor goColor) {
        this.color = goColor;
    }

    public void render(Go go) {
        go.color(this.color.r, this.color.g, this.color.b);
        go.render((GoVertex)this.lineA);
        go.render((GoVertex)this.lineB);
        go.render((GoVertex)this.lineAB);
        go.render((GoVertex)this.curve);
    }
}

