/*
 * Decompiled with CFR 0.152.
 */
import go.Go;
import go.GoBoundBox;
import go.GoColor;
import go.GoTriangleStrip;
import go.GoVertex;
import org.nfunk.jep.IllegalExpressionException;
import org.nfunk.jep.JEP;
import org.nfunk.jep.type.Complex;

public class MkGeomSurface3D {
    static final int U_CONSTRAINED = 0;
    static final int V_CONSTRAINED = 1;
    static final int W_CONSTRAINED = 2;
    static final int XY = 3;
    static final int XY_COMPLEX_REAL = 4;
    static final int XY_COMPLEX_IMAGINARY = 5;
    static final int XY_ARRAY = 6;
    GoVertex[] surface;
    GoBoundBox boundBox = new GoBoundBox();
    int constrainedVar;
    int constraint;
    double constantConstraint;
    boolean constraintIsConstant = true;
    int i;
    int j;
    int count;
    int nbTriangleStrip;
    double uMin;
    double uMax;
    double uInc;
    double vMin;
    double vMax;
    double vInc;
    double wMin;
    double wMax;
    double wInc;
    double u;
    double v;
    double w;
    double xMin;
    double xMax;
    double yMin;
    double yMax;
    double xInc;
    double yInc;
    int xDiv;
    int yDiv;
    double x;
    double y;
    double z;
    double x1;
    double y1;
    double z1;
    double x2;
    double y2;
    double z2;
    Complex fz;
    Complex fz1;
    int uDiv;
    int vDiv;
    int wDiv;
    String fuvw = "u";
    String guvw = "v";
    String huvw = "w";
    String fxy;
    GoColor color;
    boolean zShading = true;

    public MkGeomSurface3D(String string, String string2, String string3, int n) {
        this.fuvw = string;
        this.guvw = string2;
        this.huvw = string3;
        this.constrainedVar = n;
    }

    public MkGeomSurface3D() {
    }

    public void setSurface(String string, String string2, String string3, int n) {
        this.fuvw = string;
        this.guvw = string2;
        this.huvw = string3;
        this.constrainedVar = n;
    }

    public void setZShading(boolean bl) {
        this.zShading = bl;
    }

    public void setSurfaceXY(String string, int n) {
        this.fxy = string;
        this.constrainedVar = n;
    }

    public void setSurfaceArray(int n) {
        this.constrainedVar = n;
    }

    public void setSurfaceXYComplexReal(String string, int n) {
        this.fxy = string;
        this.constrainedVar = n;
    }

    public void setSurfaceXYComplexImaginary(String string, int n) {
        this.fxy = string;
        this.constrainedVar = n;
    }

    public void setParamXY(double d, double d2, int n, double d3, double d4, int n2) {
        this.xMin = d;
        this.xMax = d2;
        this.xDiv = n;
        this.xInc = (d2 - d) / (double)n;
        this.yMin = d3;
        this.yMax = d4;
        this.yDiv = n2;
        this.yInc = (d4 - d3) / (double)n2;
        this.nbTriangleStrip = n;
        this.surface = new GoVertex[this.nbTriangleStrip];
    }

    public void calculatePointsArray(double[] dArray, double[] dArray2, double[][] dArray3) {
        int n = dArray.length;
        int n2 = dArray2.length;
        this.nbTriangleStrip = n - 1;
        this.surface = new GoVertex[this.nbTriangleStrip];
        this.i = 0;
        while (this.i < n - 1) {
            this.surface[this.i] = this.zShading ? new GoTriangleStrip(n2 * 2, 2000000004) : new GoTriangleStrip(n2 * 2, 0);
            this.j = 0;
            while (this.j < n2) {
                this.x1 = dArray[this.i];
                this.y1 = dArray2[this.j];
                this.z1 = dArray3[this.i][this.j];
                this.x2 = dArray[this.i + 1];
                this.y2 = dArray2[this.j];
                this.z2 = dArray3[this.i + 1][this.j];
                this.surface[this.i].xyz(2 * this.j, this.x1, this.y1, this.z1);
                this.surface[this.i].xyz(2 * this.j + 1, this.x2, this.y2, this.z2);
                ++this.j;
            }
            ++this.i;
        }
    }

    public void calculatePointsXY(JEP jEP) throws IllegalExpressionException {
        jEP.addComplex();
        this.w = this.constantConstraint;
        jEP.addVariable("x", 0.0);
        jEP.addVariable("y", 0.0);
        jEP.parseExpression(this.fxy);
        this.i = 0;
        this.x = this.xMin;
        this.count = 0;
        while (this.i < this.xDiv) {
            this.surface[this.count] = this.zShading ? new GoTriangleStrip(this.yDiv * 2 + 2, 2000000004) : new GoTriangleStrip(this.yDiv * 2 + 2, 0);
            this.j = 0;
            this.y = this.yMin;
            while (this.j <= this.yDiv) {
                jEP.addVariable("x", this.x);
                jEP.addVariable("y", this.y);
                this.z = jEP.getValue();
                this.x1 = this.x + this.xInc;
                this.y1 = this.y;
                jEP.addVariable("x", this.x1);
                jEP.addVariable("y", this.y1);
                this.z1 = jEP.getValue();
                this.surface[this.count].xyz(2 * this.j, this.x, this.y, this.z);
                this.surface[this.count].xyz(2 * this.j + 1, this.x1, this.y1, this.z1);
                ++this.j;
                this.y += this.yInc;
            }
            ++this.i;
            this.x += this.xInc;
            ++this.count;
        }
    }

    public void calculatePointsXYComplexReal(JEP jEP) throws IllegalExpressionException {
        jEP.addComplex();
        this.w = this.constantConstraint;
        jEP.addComplexVariable("z", 0.0, 0.0);
        jEP.parseExpression(this.fxy);
        this.i = 0;
        this.x = this.xMin;
        this.count = 0;
        while (this.i < this.xDiv) {
            this.surface[this.count] = this.zShading ? new GoTriangleStrip(this.yDiv * 2 + 2, 2000000004) : new GoTriangleStrip(this.yDiv * 2 + 2, 0);
            this.j = 0;
            this.y = this.yMin;
            while (this.j <= this.yDiv) {
                jEP.addComplexVariable("z", this.x, this.y);
                this.fz = jEP.getComplexValue();
                this.z = this.fz.re();
                this.x1 = this.x + this.xInc;
                this.y1 = this.y;
                jEP.addComplexVariable("z", this.x1, this.y1);
                this.fz1 = jEP.getComplexValue();
                this.z1 = this.fz1.re();
                this.surface[this.count].xyz(2 * this.j, this.x, this.y, this.z);
                this.surface[this.count].xyz(2 * this.j + 1, this.x1, this.y1, this.z1);
                ++this.j;
                this.y += this.yInc;
            }
            ++this.i;
            this.x += this.xInc;
            ++this.count;
        }
    }

    public void calculatePointsXYComplexImaginary(JEP jEP) throws IllegalExpressionException {
        jEP.addComplex();
        this.w = this.constantConstraint;
        jEP.addComplexVariable("z", 0.0, 0.0);
        jEP.parseExpression(this.fxy);
        this.i = 0;
        this.x = this.xMin;
        this.count = 0;
        while (this.i < this.xDiv) {
            this.surface[this.count] = this.zShading ? new GoTriangleStrip(this.yDiv * 2 + 2, 2000000004) : new GoTriangleStrip(this.yDiv * 2 + 2, 0);
            this.j = 0;
            this.y = this.yMin;
            while (this.j <= this.yDiv) {
                jEP.addComplexVariable("z", this.x, this.y);
                this.fz = jEP.getComplexValue();
                this.z = this.fz.im();
                this.x1 = this.x + this.xInc;
                this.y1 = this.y;
                jEP.addComplexVariable("z", this.x1, this.y1);
                this.fz1 = jEP.getComplexValue();
                this.z1 = this.fz1.im();
                this.surface[this.count].xyz(2 * this.j, this.x, this.y, this.z);
                this.surface[this.count].xyz(2 * this.j + 1, this.x1, this.y1, this.z1);
                ++this.j;
                this.y += this.yInc;
            }
            ++this.i;
            this.x += this.xInc;
            ++this.count;
        }
    }

    public void setParamVW(double d, double d2, int n, double d3, double d4, int n2) {
        this.vMin = d;
        this.vMax = d2;
        this.vDiv = n;
        this.vInc = (d2 - d) / (double)n;
        this.wMin = d3;
        this.wMax = d4;
        this.wDiv = n2;
        this.wInc = (d4 - d3) / (double)n2;
        this.nbTriangleStrip = n;
        this.surface = new GoVertex[this.nbTriangleStrip];
    }

    public void setParamUW(double d, double d2, int n, double d3, double d4, int n2) {
        this.uMin = d;
        this.uMax = d2;
        this.uDiv = n;
        this.uInc = (d2 - d) / (double)n;
        this.wMin = d3;
        this.wMax = d4;
        this.wDiv = n2;
        this.wInc = (d4 - d3) / (double)n2;
        this.nbTriangleStrip = n;
        this.surface = new GoVertex[this.nbTriangleStrip];
    }

    public void setParamUV(double d, double d2, int n, double d3, double d4, int n2) {
        this.uMin = d;
        this.uMax = d2;
        this.uDiv = n;
        this.uInc = (d2 - d) / (double)n;
        this.vMin = d3;
        this.vMax = d4;
        this.vDiv = n2;
        this.vInc = (d4 - d3) / (double)n2;
        this.nbTriangleStrip = n;
        this.surface = new GoVertex[this.nbTriangleStrip];
    }

    public void setConstantConstraint(double d) {
        this.constraintIsConstant = true;
        this.constantConstraint = d;
    }

    public void calculatePoints(JEP jEP, JEP jEP2, JEP jEP3) throws IllegalExpressionException {
        switch (this.constrainedVar) {
            case 0: {
                this.calculatePointsUconstrained(jEP, jEP2, jEP3);
                return;
            }
            case 1: {
                this.calculatePointsVconstrained(jEP, jEP2, jEP3);
                return;
            }
            case 2: {
                this.calculatePointsWconstrained(jEP, jEP2, jEP3);
                return;
            }
            case 3: {
                this.calculatePointsXY(jEP);
                return;
            }
            case 4: {
                this.calculatePointsXYComplexReal(jEP);
                return;
            }
            case 5: {
                this.calculatePointsXYComplexImaginary(jEP);
                return;
            }
        }
    }

    public void calculatePointsUconstrained(JEP jEP, JEP jEP2, JEP jEP3) throws IllegalExpressionException {
        this.u = this.constantConstraint;
        jEP.addVariable("u", this.u);
        jEP.addVariable("v", 0.0);
        jEP.addVariable("w", 0.0);
        jEP2.addVariable("u", this.u);
        jEP2.addVariable("v", 0.0);
        jEP2.addVariable("w", 0.0);
        jEP3.addVariable("u", this.u);
        jEP3.addVariable("v", 0.0);
        jEP3.addVariable("w", 0.0);
        jEP.parseExpression(this.fuvw);
        jEP2.parseExpression(this.guvw);
        jEP3.parseExpression(this.huvw);
        this.i = 0;
        this.v = this.vMin;
        this.count = 0;
        while (this.i < this.vDiv) {
            this.surface[this.count] = this.zShading ? new GoTriangleStrip(this.wDiv * 2 + 2, 2000000004) : new GoTriangleStrip(this.wDiv * 2 + 2, 0);
            this.j = 0;
            this.w = this.wMin;
            while (this.j <= this.wDiv) {
                if (!this.constraintIsConstant) {
                    this.u = 1.0;
                }
                jEP.addVariable("v", this.v);
                jEP.addVariable("w", this.w);
                jEP2.addVariable("v", this.v);
                jEP2.addVariable("w", this.w);
                jEP3.addVariable("v", this.v);
                jEP3.addVariable("w", this.w);
                this.x = jEP.getValue();
                this.y = jEP2.getValue();
                this.z = jEP3.getValue();
                if (!this.constraintIsConstant) {
                    this.u = 1.0;
                }
                jEP.addVariable("v", this.v + this.vInc);
                jEP2.addVariable("v", this.v + this.vInc);
                jEP3.addVariable("v", this.v + this.vInc);
                this.x1 = jEP.getValue();
                this.y1 = jEP2.getValue();
                this.z1 = jEP3.getValue();
                this.surface[this.count].xyz(2 * this.j, this.x, this.y, this.z);
                this.surface[this.count].xyz(2 * this.j + 1, this.x1, this.y1, this.z1);
                ++this.j;
                this.w += this.wInc;
            }
            ++this.i;
            this.v += this.vInc;
            ++this.count;
        }
    }

    public void calculatePointsVconstrained(JEP jEP, JEP jEP2, JEP jEP3) throws IllegalExpressionException {
        this.v = this.constantConstraint;
        jEP.addVariable("u", 0.0);
        jEP.addVariable("v", this.v);
        jEP.addVariable("w", 0.0);
        jEP2.addVariable("u", 0.0);
        jEP2.addVariable("v", this.v);
        jEP2.addVariable("w", 0.0);
        jEP3.addVariable("u", 0.0);
        jEP3.addVariable("v", this.v);
        jEP3.addVariable("w", 0.0);
        jEP.parseExpression(this.fuvw);
        jEP2.parseExpression(this.guvw);
        jEP3.parseExpression(this.huvw);
        this.i = 0;
        this.u = this.uMin;
        this.count = 0;
        while (this.i < this.uDiv) {
            this.surface[this.count] = this.zShading ? new GoTriangleStrip(this.wDiv * 2 + 2, 2000000004) : new GoTriangleStrip(this.wDiv * 2 + 2, 0);
            this.j = 0;
            this.w = this.wMin;
            while (this.j <= this.wDiv) {
                if (!this.constraintIsConstant) {
                    this.v = 1.0;
                }
                jEP.addVariable("u", this.u);
                jEP.addVariable("w", this.w);
                jEP2.addVariable("u", this.u);
                jEP2.addVariable("w", this.w);
                jEP3.addVariable("u", this.u);
                jEP3.addVariable("w", this.w);
                this.x = jEP.getValue();
                this.y = jEP2.getValue();
                this.z = jEP3.getValue();
                if (!this.constraintIsConstant) {
                    this.v = 1.0;
                }
                jEP.addVariable("u", this.u + this.uInc);
                jEP2.addVariable("u", this.u + this.uInc);
                jEP3.addVariable("u", this.u + this.uInc);
                this.x1 = jEP.getValue();
                this.y1 = jEP2.getValue();
                this.z1 = jEP3.getValue();
                this.surface[this.count].xyz(2 * this.j, this.x, this.y, this.z);
                this.surface[this.count].xyz(2 * this.j + 1, this.x1, this.y1, this.z1);
                ++this.j;
                this.w += this.wInc;
            }
            ++this.i;
            this.u += this.uInc;
            ++this.count;
        }
    }

    public void calculatePointsWconstrained(JEP jEP, JEP jEP2, JEP jEP3) throws IllegalExpressionException {
        this.w = this.constantConstraint;
        jEP.addVariable("u", 0.0);
        jEP.addVariable("v", 0.0);
        jEP.addVariable("w", 0.0);
        jEP2.addVariable("u", 0.0);
        jEP2.addVariable("v", 0.0);
        jEP2.addVariable("w", 0.0);
        jEP3.addVariable("u", 0.0);
        jEP3.addVariable("v", 0.0);
        jEP3.addVariable("w", 0.0);
        jEP.parseExpression(this.fuvw);
        jEP2.parseExpression(this.guvw);
        jEP3.parseExpression(this.huvw);
        this.i = 0;
        this.u = this.uMin;
        this.count = 0;
        while (this.i < this.uDiv) {
            this.surface[this.count] = this.zShading ? new GoTriangleStrip(this.vDiv * 2 + 2, 2000000004) : new GoTriangleStrip(this.vDiv * 2 + 2, 0);
            this.j = 0;
            this.v = this.vMin;
            while (this.j <= this.vDiv) {
                if (!this.constraintIsConstant) {
                    this.w = 1.0;
                }
                jEP.addVariable("u", this.u);
                jEP.addVariable("v", this.v);
                jEP2.addVariable("u", this.u);
                jEP2.addVariable("v", this.v);
                jEP3.addVariable("u", this.u);
                jEP3.addVariable("v", this.v);
                this.x = jEP.getValue();
                this.y = jEP2.getValue();
                this.z = jEP3.getValue();
                if (!this.constraintIsConstant) {
                    this.w = 1.0;
                }
                jEP.addVariable("u", this.u + this.uInc);
                jEP2.addVariable("u", this.u + this.uInc);
                jEP3.addVariable("u", this.u + this.uInc);
                this.x1 = jEP.getValue();
                this.y1 = jEP2.getValue();
                this.z1 = jEP3.getValue();
                this.surface[this.count].xyz(2 * this.j, this.x, this.y, this.z);
                this.surface[this.count].xyz(2 * this.j + 1, this.x1, this.y1, this.z1);
                ++this.j;
                this.v += this.vInc;
            }
            ++this.i;
            this.u += this.uInc;
            ++this.count;
        }
    }

    public void setColor(GoColor goColor) {
        this.color = goColor;
    }

    public void setRGB(double d, double d2, double d3) {
        this.color.r = d;
        this.color.g = d2;
        this.color.b = d3;
    }

    public void setBoundBox() {
        this.boundBox.clear();
        this.i = 0;
        while (this.i < this.nbTriangleStrip) {
            if (this.surface[this.i].localBoundBox.xMin < this.boundBox.xMin) {
                this.boundBox.xMin = this.surface[this.i].localBoundBox.xMin;
            }
            if (this.surface[this.i].localBoundBox.yMin < this.boundBox.yMin) {
                this.boundBox.yMin = this.surface[this.i].localBoundBox.yMin;
            }
            if (this.surface[this.i].localBoundBox.zMin < this.boundBox.zMin) {
                this.boundBox.zMin = this.surface[this.i].localBoundBox.zMin;
            }
            if (this.surface[this.i].localBoundBox.xMax > this.boundBox.xMax) {
                this.boundBox.xMax = this.surface[this.i].localBoundBox.xMax;
            }
            if (this.surface[this.i].localBoundBox.yMax > this.boundBox.yMax) {
                this.boundBox.yMax = this.surface[this.i].localBoundBox.yMax;
            }
            if (this.surface[this.i].localBoundBox.zMax > this.boundBox.zMax) {
                this.boundBox.zMax = this.surface[this.i].localBoundBox.zMax;
            }
            ++this.i;
        }
        this.i = 0;
        while (this.i < this.nbTriangleStrip) {
            this.surface[this.i].setColoringBounds(this.boundBox.xMin, this.boundBox.xMax, this.boundBox.yMin, this.boundBox.yMax, this.boundBox.zMin, this.boundBox.zMax);
            ++this.i;
        }
    }

    public void render(Go go) {
        go.color(this.color.r, this.color.g, this.color.b);
        this.i = 0;
        while (this.i < this.nbTriangleStrip) {
            go.render(this.surface[this.i]);
            ++this.i;
        }
    }
}

