/*
 * Decompiled with CFR 0.152.
 */
import go.Go;
import go.GoColor;
import go.GoLines;
import go.GoMatrix;
import go.GoTriangleFan;
import go.GoTriangleStrip;
import go.GoVertex;

public class MkGeomVector3D
extends MkTuple3d {
    GoLines vectorLine = new GoLines(2);
    GoTriangleFan vectorHead = new GoTriangleFan(6, 0);
    GoTriangleStrip vectorHeadBase = new GoTriangleStrip(4, 0);
    GoColor color;
    MkGeomText3D label = new MkGeomText3D("");
    boolean showLab = true;

    public MkGeomVector3D() {
    }

    public MkGeomVector3D(double d, double d2, double d3) {
        super(d, d2, d3);
    }

    public MkGeomVector3D(double d, double d2, double d3, double d4, double d5, double d6) {
        super(d4 - d, d5 - d2, d6 - d3);
    }

    public MkGeomVector3D(MkGeomPoint3D mkGeomPoint3D, MkGeomPoint3D mkGeomPoint3D2) {
        super(mkGeomPoint3D2.x - mkGeomPoint3D.x, mkGeomPoint3D2.y - mkGeomPoint3D.y, mkGeomPoint3D2.z - mkGeomPoint3D.z);
    }

    public double magnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double magnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public void normalize(MkGeomVector3D mkGeomVector3D) {
        this.set(mkGeomVector3D);
        this.normalize();
    }

    public void normalize() {
        double d = this.magnitude();
        if (d != 0.0) {
            this.x /= d;
            this.y /= d;
            this.z /= d;
        }
    }

    public double dot(MkGeomVector3D mkGeomVector3D) {
        return this.x * mkGeomVector3D.x + this.y * mkGeomVector3D.y + this.z * mkGeomVector3D.z;
    }

    public void cross(MkGeomVector3D mkGeomVector3D, MkGeomVector3D mkGeomVector3D2) {
        this.setXYZ(mkGeomVector3D.y * mkGeomVector3D2.z - mkGeomVector3D.z * mkGeomVector3D2.y, mkGeomVector3D.z * mkGeomVector3D2.x - mkGeomVector3D.x * mkGeomVector3D2.z, mkGeomVector3D.x * mkGeomVector3D2.y - mkGeomVector3D.y * mkGeomVector3D2.x);
    }

    public void cross(MkGeomVector3D mkGeomVector3D) {
        this.setXYZ(this.y * mkGeomVector3D.z - this.z * mkGeomVector3D.y, this.z * mkGeomVector3D.x - this.x * mkGeomVector3D.z, this.x * mkGeomVector3D.y - this.y * mkGeomVector3D.x);
    }

    public void projection(MkGeomVector3D mkGeomVector3D, MkGeomVector3D mkGeomVector3D2) {
        this.normalize(mkGeomVector3D2);
        this.scale(this.dot(mkGeomVector3D));
    }

    public void showLabel(boolean bl) {
        this.showLab = bl;
    }

    public void calculatePoints() {
        this.vectorLine.xyz(0, 0.0, 0.0, 0.0);
        this.vectorLine.xyz(1, this.x, this.y, this.z);
    }

    public void calculatePoints(GoMatrix goMatrix) {
        double[] dArray = goMatrix.m;
        this.vectorLine.xyz(0, 0.0, 0.0, 0.0);
        this.vectorLine.xyz(1, this.x, this.y, this.z);
        MkMath.transformPoint(dArray, (GoVertex)this.vectorLine);
    }

    public void calculateHead(GoMatrix goMatrix, double d) {
        double d2;
        double d3;
        double d4;
        double[] dArray = goMatrix.m;
        double d5 = d / 25.0;
        double d6 = d / 75.0;
        double d7 = this.magnitude();
        double d8 = this.x / d7;
        double d9 = this.y / d7;
        double d10 = this.z / d7;
        if (d8 != 0.0 && d9 != 0.0) {
            d4 = -d9;
            d3 = d8;
            d2 = 0.0;
            d7 = Math.sqrt(d4 * d4 + d3 * d3 + d2 * d2);
            d4 /= d7;
            d3 /= d7;
        } else if (d9 == 0.0) {
            d4 = 0.0;
            d3 = 1.0;
            d2 = 0.0;
        } else {
            d4 = 1.0;
            d3 = 0.0;
            d2 = 0.0;
        }
        double d11 = d9 * d2 - d10 * d3;
        double d12 = d10 * d4 - d8 * d2;
        double d13 = d8 * d3 - d9 * d4;
        d7 = Math.sqrt(d11 * d11 + d12 * d12 + d13 * d13);
        d11 /= d7;
        d12 /= d7;
        d13 /= d7;
        double d14 = this.x - d5 * d8;
        double d15 = this.y - d5 * d9;
        double d16 = this.z - d5 * d10;
        this.vectorHead.xyz(0, this.x, this.y, this.z);
        this.vectorHead.xyz(1, (d4 *= d6) + d14, (d3 *= d6) + d15, (d2 *= d6) + d16);
        this.vectorHead.xyz(2, (d11 *= d6) + d14, (d12 *= d6) + d15, (d13 *= d6) + d16);
        this.vectorHead.xyz(3, -d4 + d14, -d3 + d15, -d2 + d16);
        this.vectorHead.xyz(4, -d11 + d14, -d12 + d15, -d13 + d16);
        this.vectorHead.xyz(5, d4 + d14, d3 + d15, d2 + d16);
        this.vectorHeadBase.xyz(0, d4 + d14, d3 + d15, d2 + d16);
        this.vectorHeadBase.xyz(1, -d11 + d14, -d12 + d15, -d13 + d16);
        this.vectorHeadBase.xyz(2, d11 + d14, d12 + d15, d13 + d16);
        this.vectorHeadBase.xyz(3, -d4 + d14, -d3 + d15, -d2 + d16);
        MkMath.transformPoint(dArray, (GoVertex)this.vectorHead);
        MkMath.transformPoint(dArray, (GoVertex)this.vectorHeadBase);
    }

    public void calculateHead(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        double d8 = d4 / 25.0;
        double d9 = d4 / 75.0;
        double d10 = Math.sqrt(d * d * this.x * this.x + d2 * d2 * this.y * this.y + d3 * d3 * this.z * this.z);
        double d11 = d * this.x / d10;
        double d12 = d2 * this.y / d10;
        double d13 = d3 * this.z / d10;
        if (d11 != 0.0 && d12 != 0.0) {
            d7 = -d12;
            d6 = d11;
            d5 = 0.0;
            d10 = Math.sqrt(d7 * d7 + d6 * d6 + d5 * d5);
            d7 /= d10;
            d6 /= d10;
        } else if (d12 == 0.0) {
            d7 = 0.0;
            d6 = 1.0;
            d5 = 0.0;
        } else {
            d7 = 1.0;
            d6 = 0.0;
            d5 = 0.0;
        }
        double d14 = d12 * d5 - d13 * d6;
        double d15 = d13 * d7 - d11 * d5;
        double d16 = d11 * d6 - d12 * d7;
        d10 = Math.sqrt(d14 * d14 + d15 * d15 + d16 * d16);
        d14 /= d10;
        d15 /= d10;
        d16 /= d10;
        double d17 = d * this.x - d8 * d11;
        double d18 = d2 * this.y - d8 * d12;
        double d19 = d3 * this.z - d8 * d13;
        this.vectorHead.xyz(0, d * this.x, d2 * this.y, d3 * this.z);
        this.vectorHead.xyz(1, (d7 *= d9) + d17, (d6 *= d9) + d18, (d5 *= d9) + d19);
        this.vectorHead.xyz(2, (d14 *= d9) + d17, (d15 *= d9) + d18, (d16 *= d9) + d19);
        this.vectorHead.xyz(3, -d7 + d17, -d6 + d18, -d5 + d19);
        this.vectorHead.xyz(4, -d14 + d17, -d15 + d18, -d16 + d19);
        this.vectorHead.xyz(5, d7 + d17, d6 + d18, d5 + d19);
        this.vectorHeadBase.xyz(0, d7 + d17, d6 + d18, d5 + d19);
        this.vectorHeadBase.xyz(1, -d14 + d17, -d15 + d18, -d16 + d19);
        this.vectorHeadBase.xyz(2, d14 + d17, d15 + d18, d16 + d19);
        this.vectorHeadBase.xyz(3, -d7 + d17, -d6 + d18, -d5 + d19);
        this.label.setXYZ(this.x / 2.0, this.y / 2.0, this.z / 2.0);
        this.label.calculatePoints(d, d2, d3, d4);
    }

    public void calculateHead(GoMatrix goMatrix, double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        double[] dArray = goMatrix.m;
        double d8 = d4 / 25.0;
        double d9 = d4 / 75.0;
        double d10 = Math.sqrt(d * d * this.x * this.x + d2 * d2 * this.y * this.y + d3 * d3 * this.z * this.z);
        double d11 = d * this.x / d10;
        double d12 = d2 * this.y / d10;
        double d13 = d3 * this.z / d10;
        if (d11 != 0.0 && d12 != 0.0) {
            d7 = -d12;
            d6 = d11;
            d5 = 0.0;
            d10 = Math.sqrt(d7 * d7 + d6 * d6 + d5 * d5);
            d7 /= d10;
            d6 /= d10;
        } else if (d12 == 0.0) {
            d7 = 0.0;
            d6 = 1.0;
            d5 = 0.0;
        } else {
            d7 = 1.0;
            d6 = 0.0;
            d5 = 0.0;
        }
        double d14 = d12 * d5 - d13 * d6;
        double d15 = d13 * d7 - d11 * d5;
        double d16 = d11 * d6 - d12 * d7;
        d10 = Math.sqrt(d14 * d14 + d15 * d15 + d16 * d16);
        d14 /= d10;
        d15 /= d10;
        d16 /= d10;
        double d17 = d * this.x - d8 * d11;
        double d18 = d2 * this.y - d8 * d12;
        double d19 = d3 * this.z - d8 * d13;
        this.vectorHead.xyz(0, d * this.x, d2 * this.y, d3 * this.z);
        this.vectorHead.xyz(1, (d7 *= d9) + d17, (d6 *= d9) + d18, (d5 *= d9) + d19);
        this.vectorHead.xyz(2, (d14 *= d9) + d17, (d15 *= d9) + d18, (d16 *= d9) + d19);
        this.vectorHead.xyz(3, -d7 + d17, -d6 + d18, -d5 + d19);
        this.vectorHead.xyz(4, -d14 + d17, -d15 + d18, -d16 + d19);
        this.vectorHead.xyz(5, d7 + d17, d6 + d18, d5 + d19);
        this.vectorHeadBase.xyz(0, d7 + d17, d6 + d18, d5 + d19);
        this.vectorHeadBase.xyz(1, -d14 + d17, -d15 + d18, -d16 + d19);
        this.vectorHeadBase.xyz(2, d14 + d17, d15 + d18, d16 + d19);
        this.vectorHeadBase.xyz(3, -d7 + d17, -d6 + d18, -d5 + d19);
        this.label.setXYZ(this.x / 2.0, this.y / 2.0, this.z / 2.0);
        this.label.calculatePoints(d, d2, d3, d4);
        MkMath.transformPoint(dArray, (GoVertex)this.vectorHead);
        MkMath.transformPoint(dArray, (GoVertex)this.vectorHeadBase);
    }

    public void setColor(GoColor goColor) {
        this.color = goColor;
    }

    public void setRGB(double d, double d2, double d3) {
        this.color.r = d;
        this.color.g = d2;
        this.color.b = d3;
    }

    public void setLabel(String string) {
        this.label.setText(string);
    }

    public void render(Go go) {
        go.color(this.color.r, this.color.g, this.color.b);
        go.render((GoVertex)this.vectorLine);
    }

    public void renderBis(Go go, double d, double d2, double d3, boolean bl) {
        go.color(this.color.r, this.color.g, this.color.b);
        if (!bl) {
            go.push(32768);
            go.scale(1.0 / d, 1.0 / d2, 1.0 / d3);
            go.render((GoVertex)this.vectorHead);
            go.render((GoVertex)this.vectorHeadBase);
            go.pop(32768);
        } else {
            go.render((GoVertex)this.vectorHead);
            go.render((GoVertex)this.vectorHeadBase);
        }
        if (this.showLab) {
            this.label.render(go, d, d2, d3, bl);
        }
    }
}

