/*
 * Decompiled with CFR 0.152.
 */
import go.GoVertex;
import java.text.NumberFormat;
import org.nfunk.jep.IllegalExpressionException;

public class MkMath {
    static final double LOG10SCALE = 1.0 / Math.log(10.0);

    public static final double radToDeg(double d) {
        return d * 180.0 / Math.PI;
    }

    public static final double degToRad(double d) {
        return d * Math.PI / 180.0;
    }

    public static void transformPoint(double[] dArray, GoVertex goVertex) {
        int n = goVertex.vertexNumber();
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[3] * goVertex.x(n2) + dArray[7] * goVertex.y(n2) + dArray[11] * goVertex.z(n2) + dArray[15];
            double d2 = (dArray[0] * goVertex.x(n2) + dArray[4] * goVertex.y(n2) + dArray[8] * goVertex.z(n2) + dArray[12]) / d;
            double d3 = (dArray[1] * goVertex.x(n2) + dArray[5] * goVertex.y(n2) + dArray[9] * goVertex.z(n2) + dArray[13]) / d;
            double d4 = (dArray[2] * goVertex.x(n2) + dArray[6] * goVertex.y(n2) + dArray[10] * goVertex.z(n2) + dArray[14]) / d;
            goVertex.xyz(n2, d2, d3, d4);
            ++n2;
        }
    }

    public static double getMantissa(double d) {
        if (d > 0.0) {
            int n = (int)Math.floor(Math.log(d) * LOG10SCALE);
            d /= Math.pow(10.0, n);
        } else if (d < 0.0) {
            int n = (int)Math.floor(Math.log(-d) * LOG10SCALE);
            d /= Math.pow(10.0, n);
        }
        return d;
    }

    public static int getExponent(double d) {
        int n = 0;
        if (d > 0.0) {
            n = (int)Math.floor(Math.log(d) * LOG10SCALE);
        } else if (d < 0.0) {
            n = (int)Math.floor(Math.log(-d) * LOG10SCALE);
        }
        return n;
    }

    public static String formatScientific(double d, NumberFormat numberFormat) {
        double d2 = d;
        int n = 0;
        String string = "0";
        if (d != 0.0) {
            while (Math.abs(d2) < 1.0) {
                d2 *= 10.0;
                --n;
            }
            while (Math.abs(d2) >= 10.0) {
                d2 /= 10.0;
                ++n;
            }
        }
        string = String.valueOf(numberFormat.format(d2)) + "e" + Integer.toString(n);
        return string;
    }

    public static double roundTo(double d, int n) {
        int n2 = 0;
        while (n2 < n) {
            d *= 10.0;
            ++n2;
        }
        d = Math.round(d);
        n2 = 0;
        while (n2 < n) {
            d /= 10.0;
            ++n2;
        }
        return d;
    }

    public static int numFracDigits(double d) {
        int n = 0;
        while (n <= 15 && d != Math.floor(d)) {
            d *= 10.0;
            ++n;
        }
        return n;
    }

    public static int numIntDigits(double d) {
        int n = 0;
        while (n <= 15 && (double)((int)d) != 0.0) {
            d /= 10.0;
            ++n;
        }
        return n;
    }

    public static boolean isUndefinedDouble(double d) {
        return Double.isNaN(d) || Double.isInfinite(d);
    }

    public static void checkValidityOfDouble(double d, String string) throws IllegalExpressionException {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw new IllegalExpressionException(string);
        }
    }
}

