/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Vector;
import org.nfunk.jep.JEP;

class MkRenderer2D
extends GoInterface2D {
    JEP parser1;
    JEP parser2;
    JEP parser3;
    public static final Color cyan = new Color(0, 255, 255);
    public static final Color yellow = new Color(255, 255, 0);
    public static final Color green = new Color(0, 255, 0);
    public static final Color tomato = new Color(255, 99, 71);
    public static final Color cornflowerBlue = new Color(100, 149, 237);
    public static final Color orange = new Color(255, 165, 0);
    public static final Color lightGray = new Color(192, 192, 192);
    private int radius = 3;
    private int diameter = 6;
    private int radius_new = 2;
    private int diameter_new = 4;
    Cursor normalCursor;
    Cursor selectCursor;
    Vector selectableShapes = new Vector(10);
    private int[] fiveXPoints = new int[5];
    private int[] fiveYPoints = new int[5];
    MkScientificFormat sf = new MkScientificFormat();
    public Vector hGridPixels = new Vector();
    public Vector vGridPixels = new Vector();
    public boolean hGridVisible = true;
    public boolean vGridVisible = true;
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    protected static final transient double PADDING = 0.05;
    protected boolean xRangeGiven = false;
    protected boolean yRangeGiven = false;
    private double xBottom = Double.MAX_VALUE;
    private double xTop = -1.7976931348623157E308;
    private double yBottom = Double.MAX_VALUE;
    private double yTop = -1.7976931348623157E308;
    protected boolean xAxisIsLog = false;
    protected boolean yAxisIsLog = false;
    protected static final double LOG10_SCALE = 1.0 / Math.log(10.0);
    protected boolean gridIsVisible = true;
    protected int topPadding = 10;
    protected int bottomPadding = 5;
    protected int rightPadding = 10;
    protected int leftPadding = 10;
    private int ulx = 1;
    private int uly = 1;
    private int lrx = 100;
    private int lry = 100;
    protected double xScale = 1.0;
    protected double yScale = 1.0;
    protected Color backgroundColor;
    protected Color gridColor;
    protected Color ticksColor;
    boolean graphIsEmpty = false;
    private double xTickMin;
    private double xTickMax;
    private double yTickMin;
    private double yTickMax;
    private int xExp;
    private int yExp;
    private double xTickScale;
    private double yTickScale;
    private Font labelFont;
    private Font superscriptFont;
    private Font titleFont;
    private FontMetrics labelFontMetrics;
    private FontMetrics superscriptFontMetrics;
    private FontMetrics titleFontMetrics;
    private transient NumberFormat numberFormat;
    private int gridCurJuke;
    private double gridBase;
    private String xLabel;
    private String yLabel;
    private String title;
    private Vector legendStrings = new Vector();
    private Vector legendDatasets = new Vector();
    private Vector xTicks;
    private Vector xTickLabels;
    private Vector yTicks;
    private Vector yTickLabels;
    public boolean zoomEnabled = true;
    public boolean dragEnabled = false;
    public boolean titleErased = false;
    NumberFormat dnf;
    boolean hasSelectableShapes = false;

    MkRenderer2D() {
        this.measureFonts();
        this.backgroundColor = Color.black;
        this.gridColor = Color.darkGray;
        this.ticksColor = Color.lightGray;
        this.parser1 = new JEP();
        this.parser2 = new JEP();
        this.parser3 = new JEP();
        this.parser1.addStandardFunctions();
        this.parser1.addStandardConstants();
        this.parser2.addStandardFunctions();
        this.parser2.addStandardConstants();
        this.parser3.addStandardFunctions();
        this.parser3.addStandardConstants();
        this.normalCursor = new Cursor(0);
        this.selectCursor = new Cursor(12);
    }

    public void modelview() {
        this.go2D.matrixMode(65536);
        this.go2D.identity();
        this.go2D.scale(this.xScale, this.yScale);
        this.go2D.translate(-this.xMin, -this.yMin);
    }

    public void resized(int n, int n2) {
        this.modelview();
    }

    public double xMin() {
        return this.xMin;
    }

    public double xMax() {
        return this.xMax;
    }

    public double yMin() {
        return this.yMin;
    }

    public double yMax() {
        return this.yMax;
    }

    public double xBottom() {
        return this.xBottom;
    }

    public double xTop() {
        return this.xTop;
    }

    public double yBottom() {
        return this.yBottom;
    }

    public double yTop() {
        return this.yTop;
    }

    public double xScale() {
        return this.xScale;
    }

    public double yScale() {
        return this.yScale;
    }

    public int ulx() {
        return this.ulx;
    }

    public int lry() {
        return this.lry;
    }

    public void setBoundbox(double d, double d2, double d3, double d4) {
        this.xBottom = d;
        this.xTop = d2;
        this.yBottom = d3;
        this.yTop = d4;
    }

    public void addPointToBoundbox(double d, double d2) {
        if (d < this.xBottom) {
            this.xBottom = d;
        }
        if (d > this.xTop) {
            this.xTop = d;
        }
        if (d2 < this.yBottom) {
            this.yBottom = d2;
        }
        if (d2 > this.yTop) {
            this.yTop = d2;
        }
    }

    public void addXToBoundbox(double d) {
        if (d < this.xBottom) {
            this.xBottom = d;
        }
        if (d > this.xTop) {
            this.xTop = d;
        }
    }

    public void addYToBoundbox(double d) {
        if (d < this.yBottom) {
            this.yBottom = d;
        }
        if (d > this.yTop) {
            this.yTop = d;
        }
    }

    public synchronized void clear() {
        this.xBottom = Double.MAX_VALUE;
        this.xTop = -1.7976931348623157E308;
        this.yBottom = Double.MAX_VALUE;
        this.yTop = -1.7976931348623157E308;
        this.yMax = 0.0;
        this.yMin = 0.0;
        this.xMax = 0.0;
        this.xMin = 0.0;
        this.xRangeGiven = false;
        this.yRangeGiven = false;
        this.xAxisIsLog = false;
        this.yAxisIsLog = false;
        this.gridIsVisible = true;
        this.xLabel = null;
        this.yLabel = null;
        this.title = null;
        this.legendStrings = new Vector();
        this.legendDatasets = new Vector();
        this.xTicks = null;
        this.xTickLabels = null;
        this.yTicks = null;
        this.yTickLabels = null;
        this.graphIsEmpty = false;
    }

    synchronized void drawAxes() {
        int n;
        int n2;
        int n3;
        Object object;
        int n4;
        Object object2;
        int n5;
        Object object3;
        this.hGridPixels.removeAllElements();
        this.vGridPixels.removeAllElements();
        Rectangle rectangle = this.getBounds();
        this.imageGC.setPaintMode();
        this.imageGC.setClip(0, 0, rectangle.width, rectangle.height);
        this.imageGC.clearRect(0, 0, rectangle.width, rectangle.height);
        if (!this.xRangeGiven) {
            if (this.xBottom > this.xTop) {
                this._setXRange(0.0, 0.0);
            } else {
                this._setXRange(this.xBottom, this.xTop);
            }
        }
        if (!this.yRangeGiven) {
            if (this.yBottom > this.yTop) {
                this._setYRange(0.0, 0.0);
            } else {
                this._setYRange(this.yBottom, this.yTop);
            }
        }
        int n6 = 0;
        int n7 = this.titleFontMetrics.getHeight();
        if (this.title == null) {
            this.title = "";
        }
        if (this.title != null || this.yExp != 0) {
            n6 = n7 + this.topPadding;
        }
        this.imageGC.setFont(this.labelFont);
        int n8 = this.labelFontMetrics.getHeight();
        int n9 = n8 / 2;
        int n10 = rectangle.height - 5;
        int n11 = rectangle.width - this.rightPadding;
        if (this.xAxisIsLog) {
            this.xExp = (int)Math.floor(this.xTickMin);
        }
        if (this.xExp != 0 && this.xTicks == null) {
            this.imageGC.setColor(this.ticksColor);
            String string = Integer.toString(this.xExp);
            n11 -= this.superscriptFontMetrics.stringWidth(string);
            this.imageGC.setFont(this.superscriptFont);
            if (!this.xAxisIsLog) {
                this.imageGC.drawString(string, n11, n10 - n9);
                this.imageGC.setFont(this.labelFont);
                this.imageGC.drawString("x10", n11 -= this.labelFontMetrics.stringWidth("x10"), n10);
            }
            this.bottomPadding = 3 * n8 / 2 + 5;
        }
        if (this.xLabel != null && this.bottomPadding < n8 + 5) {
            this.bottomPadding = 5;
        }
        this.uly = n6 + 5;
        this.lry = rectangle.height - n8 - this.bottomPadding - 3;
        int n12 = this.lry - this.uly;
        this.yScale = (double)n12 / (this.yMax - this.yMin);
        this.yTickScale = (double)n12 / (this.yTickMax - this.yTickMin);
        int n13 = 2 + n12 / (n8 + 10);
        double d = this.roundUp((this.yTickMax - this.yTickMin) / (double)n13);
        double d2 = d * Math.ceil(this.yTickMin / d);
        int n14 = 0;
        String[] stringArray = new String[n13];
        int[] nArray = new int[n13];
        int n15 = 0;
        if (this.yTicks == null) {
            object3 = null;
            if (this.yAxisIsLog) {
                object3 = this.gridInit(d2, d, true, null);
            }
            n5 = this.numFracDigits(d);
            double d3 = d2;
            if (this.yAxisIsLog) {
                d3 = this.gridStep((Vector)object3, d2, d, this.yAxisIsLog);
            }
            double d4 = d3;
            while (d4 <= this.yTickMax) {
                if (n15 < n13) {
                    object2 = this.yAxisIsLog ? this.formatLogNum(d4, n5) : this.formatNum(d4, n5);
                    stringArray[n15] = object2;
                    n4 = this.labelFontMetrics.stringWidth((String)object2);
                    nArray[n15++] = n4;
                    if (n4 > n14) {
                        n14 = n4;
                    }
                    d4 = this.gridStep((Vector)object3, d4, d, this.yAxisIsLog);
                    continue;
                }
                break;
            }
        } else {
            object3 = this.yTickLabels.elements();
            while (object3.hasMoreElements()) {
                String string = (String)object3.nextElement();
                int n16 = this.labelFontMetrics.stringWidth(string);
                if (n16 <= n14) continue;
                n14 = n16;
            }
        }
        this.ulx = n14 + this.leftPadding;
        int n17 = this.drawLegend(this.imageGC, rectangle.width - this.rightPadding, this.uly);
        this.lrx = rectangle.width - n17 - this.rightPadding;
        n5 = this.lrx - this.ulx;
        this.xScale = (double)n5 / (this.xMax - this.xMin);
        this.xTickScale = (double)n5 / (this.xTickMax - this.xTickMin);
        this.imageGC.setColor(this.backgroundColor);
        this.imageGC.fillRect(this.ulx, this.uly, n5, n12);
        this.imageGC.setColor(this.ticksColor);
        this.imageGC.drawRect(this.ulx, this.uly, n5, n12);
        int n18 = 5;
        int n19 = this.ulx + n18;
        int n20 = this.lrx - n18;
        if (this.yTicks == null) {
            object = null;
            double d5 = d2;
            if (this.yAxisIsLog) {
                object = this.gridInit(d2, d, true, null);
                d5 = this.gridStep((Vector)object, d2, d, this.yAxisIsLog);
                n13 = n15;
            }
            n15 = 0;
            boolean bl = this.yAxisIsLog;
            double d6 = d5;
            while (d6 <= this.yTickMax) {
                if (n15 >= n13) break;
                n3 = this.lry - (int)((d6 - this.yTickMin) * this.yTickScale);
                int n21 = 0;
                if (n15 > 0 && !this.yAxisIsLog) {
                    n21 = n9;
                }
                this.imageGC.drawLine(this.ulx, n3, n19, n3);
                this.imageGC.drawLine(this.lrx, n3, n20, n3);
                if (this.gridIsVisible && n3 != this.uly && n3 != this.lry) {
                    this.imageGC.setColor(this.gridColor);
                    this.hGridPixels.addElement(new MkPixelPoint(0, n3));
                    this.imageGC.setColor(this.ticksColor);
                }
                if (this.yAxisIsLog && stringArray[n15].indexOf(101) != -1) {
                    bl = false;
                }
                this.imageGC.drawString(stringArray[n15], this.ulx - nArray[n15++] - 4, n3 + n21);
                d6 = this.gridStep((Vector)object, d6, d, this.yAxisIsLog);
            }
            if (this.yAxisIsLog) {
                Vector vector = this.gridInit(d2, d, false, (Vector)object);
                if (vector.size() > 0) {
                    double d7 = d > 1.0 ? 1.0 : d;
                    double d8 = this.gridStep(vector, d2, d7, this.yAxisIsLog);
                    while (d8 <= this.yTickMax) {
                        n2 = this.lry - (int)((d8 - this.yTickMin) * this.yTickScale);
                        if (this.gridIsVisible && n2 != this.uly && n2 != this.lry) {
                            this.imageGC.setColor(this.gridColor);
                            this.imageGC.drawLine(this.ulx + 1, n2, this.lrx - 1, n2);
                            this.imageGC.setColor(this.ticksColor);
                        }
                        d8 = this.gridStep(vector, d8, d7, this.yAxisIsLog);
                    }
                }
                this.yExp = bl ? (int)Math.floor(d5) : 0;
            }
            if (this.yExp != 0) {
                this.imageGC.setColor(this.ticksColor);
                this.imageGC.drawString("x10", 2, n6);
                this.imageGC.setFont(this.superscriptFont);
                this.imageGC.drawString(Integer.toString(this.yExp), this.labelFontMetrics.stringWidth("x10") + 2, n6 - n9);
                this.imageGC.setFont(this.labelFont);
            }
        } else {
            object = this.yTicks.elements();
            object2 = this.yTickLabels.elements();
            while (object2.hasMoreElements()) {
                String string = (String)object2.nextElement();
                double d9 = (Double)object.nextElement();
                if (d9 > this.yMax || d9 < this.yMin) continue;
                n = this.lry - (int)((d9 - this.yMin) * this.yScale);
                n3 = 0;
                if (d9 < (double)(this.lry - n8)) {
                    n3 = n9;
                }
                this.imageGC.drawLine(this.ulx, n, n19, n);
                this.imageGC.drawLine(this.lrx, n, n20, n);
                if (this.gridIsVisible && n != this.uly && n != this.lry) {
                    this.imageGC.setColor(this.gridColor);
                    this.imageGC.drawLine(n19, n, n20, n);
                    this.imageGC.setColor(this.ticksColor);
                }
                this.imageGC.drawString(string, this.ulx - this.labelFontMetrics.stringWidth(string) - 3, n + n3);
            }
        }
        int n22 = this.uly + n18;
        int n23 = this.lry - n18;
        if (this.xTicks == null) {
            n4 = 10;
            double d10 = 0.0;
            n = 0;
            n3 = this.labelFontMetrics.stringWidth("8");
            if (this.xAxisIsLog) {
                n4 = 2 + n5 / (n3 * 6 + 10);
            } else {
                int n24 = 0;
                while (n24++ <= 10) {
                    int n25;
                    int n26;
                    d10 = this.roundUp((this.xTickMax - this.xTickMin) / (double)n4);
                    n = this.numFracDigits(d10);
                    int n27 = this.numIntDigits(this.xTickMax);
                    if (n27 < (n26 = this.numIntDigits(this.xTickMin))) {
                        n27 = n26;
                    }
                    if ((n4 = 2 + n5 / ((n25 = n3 * (n + 2 + n27)) + 10)) - (n2 = n4) <= 1 || n2 - n4 <= 1) break;
                }
            }
            d10 = this.roundUp((this.xTickMax - this.xTickMin) / (double)n4);
            n = this.numFracDigits(d10);
            double d11 = d10 * Math.ceil(this.xTickMin / d10);
            Vector vector = null;
            double d12 = d11;
            if (this.xAxisIsLog) {
                vector = this.gridInit(d11, d10, true, null);
                d12 = this.gridRoundUp(vector, d11);
            }
            boolean bl = this.xAxisIsLog;
            double d13 = d12;
            while (d13 <= this.xTickMax) {
                String string;
                if (this.xAxisIsLog) {
                    string = this.formatLogNum(d13, n);
                    if (string.indexOf(101) != -1) {
                        bl = false;
                    }
                } else {
                    string = this.formatNum(d13, n);
                }
                n19 = this.ulx + (int)((d13 - this.xTickMin) * this.xTickScale);
                this.imageGC.drawLine(n19, this.uly, n19, n22);
                this.imageGC.drawLine(n19, this.lry, n19, n23);
                if (this.gridIsVisible && n19 != this.ulx && n19 != this.lrx) {
                    this.vGridPixels.addElement(new MkPixelPoint(n19, 0));
                    this.imageGC.setColor(this.ticksColor);
                }
                int n28 = n19 - this.labelFontMetrics.stringWidth(string) / 2;
                this.imageGC.drawString(string, n28, this.lry + 3 + n8);
                d13 = this.gridStep(vector, d13, d10, this.xAxisIsLog);
            }
            if (this.xAxisIsLog) {
                double d14 = d10 > 1.0 ? 1.0 : d10;
                d12 = d14 * Math.ceil(this.xTickMin / d14);
                Vector vector2 = this.gridInit(d12, d14, false, vector);
                if (vector2.size() > 0) {
                    double d15 = this.gridStep(vector2, d12, d14, this.xAxisIsLog);
                    while (d15 <= this.xTickMax) {
                        n19 = this.ulx + (int)((d15 - this.xTickMin) * this.xTickScale);
                        if (this.gridIsVisible && n19 != this.ulx && n19 != this.lrx) {
                            this.imageGC.setColor(this.gridColor);
                            this.imageGC.drawLine(n19, this.uly + 1, n19, this.lry - 1);
                            this.imageGC.setColor(this.ticksColor);
                        }
                        d15 = this.gridStep(vector2, d15, d14, this.xAxisIsLog);
                    }
                }
                if (bl) {
                    this.imageGC.setColor(this.ticksColor);
                    this.xExp = (int)Math.floor(d12);
                    this.imageGC.setFont(this.superscriptFont);
                    this.imageGC.drawString(Integer.toString(this.xExp), n11, n10 - n9);
                    this.imageGC.setFont(this.labelFont);
                    this.imageGC.drawString("x10", n11 -= this.labelFontMetrics.stringWidth("x10"), n10);
                } else {
                    this.xExp = 0;
                }
            }
        } else {
            Enumeration enumeration = this.xTicks.elements();
            Enumeration enumeration2 = this.xTickLabels.elements();
            while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration2.nextElement();
                double d16 = (Double)enumeration.nextElement();
                if (d16 > this.xMax || d16 < this.xMin) continue;
                n19 = this.ulx + (int)((d16 - this.xMin) * this.xScale);
                this.imageGC.drawLine(n19, this.uly, n19, n22);
                this.imageGC.drawLine(n19, this.lry, n19, n23);
                if (this.gridIsVisible && n19 != this.ulx && n19 != this.lrx) {
                    this.imageGC.setColor(this.gridColor);
                    this.imageGC.drawLine(n19, n22, n19, n23);
                    this.imageGC.setColor(this.ticksColor);
                }
                int n29 = n19 - this.labelFontMetrics.stringWidth(string) / 2;
                this.imageGC.drawString(string, n29, this.lry + 3 + n8);
            }
            if (this.hGridVisible) {
                this.drawHGrid();
            }
            if (this.vGridVisible) {
                this.drawVGrid();
            }
        }
        this.imageGC.setColor(this.ticksColor);
        if (this.title != null) {
            this.imageGC.setFont(this.titleFont);
            int n30 = this.ulx + (n5 - this.titleFontMetrics.stringWidth(this.title)) / 2;
            this.imageGC.drawString(this.title, n30, n6);
        }
        this.imageGC.setFont(this.labelFont);
        int n31 = this.labelFontMetrics.getHeight();
        if (this.xLabel != null) {
            int n32 = this.lrx + n31 / 2;
            int n33 = this.lry + n31 / 4;
            this.imageGC.drawString(this.xLabel, n32, n33);
        }
        if (this.yLabel != null) {
            int n34 = this.ulx - this.labelFontMetrics.stringWidth(this.yLabel) / 2;
            int n35 = this.uly - n31 / 2;
            this.imageGC.drawString(this.yLabel, n34, n35);
        }
        this.imageGC.setClip(this.ulx + 1, this.uly + 1, this.lrx - this.ulx - 1, this.lry - this.uly - 1);
        this.modelview();
    }

    private void _setXRange(double d, double d2) {
        if (d > d2) {
            d = -1.0;
            d2 = 1.0;
        } else if (d == d2) {
            d -= 1.0;
            d2 += 1.0;
        }
        this.xMin = d - (d2 - d) * 0.05;
        this.xMax = d2 + (d2 - d) * 0.05;
        double d3 = Math.max(Math.abs(this.xMin), Math.abs(this.xMax));
        this.xExp = (int)Math.floor(Math.log(d3) * LOG10_SCALE);
        if (this.xExp > 1 || this.xExp < -1) {
            double d4 = 1.0 / Math.pow(10.0, this.xExp);
            this.xTickMin = this.xMin * d4;
            this.xTickMax = this.xMax * d4;
            return;
        }
        this.xTickMin = this.xMin;
        this.xTickMax = this.xMax;
        this.xExp = 0;
    }

    private String formatLogNum(double d, int n) {
        int n2 = (int)d;
        String string = n2 >= 0 && n2 < 10 ? "0" + n2 : (n2 < 0 && n2 > -10 ? "-0" + -n2 : Integer.toString(n2));
        string = d >= 0.0 ? (d - (double)((int)d) < 0.001 ? "1e" + string : this.formatNum(Math.pow(10.0, d - (double)((int)d)), n)) : (-d - (double)((int)(-d)) < 0.001 ? "1e" + string : this.formatNum(Math.pow(10.0, d - (double)((int)d)) * 10.0, n));
        return string;
    }

    private String formatNum(double d, int n) {
        if (this.numberFormat == null) {
            this.numberFormat = NumberFormat.getInstance();
        }
        this.numberFormat.setMinimumFractionDigits(n);
        this.numberFormat.setMaximumFractionDigits(n);
        return this.numberFormat.format(d);
    }

    private Vector gridInit(double d, double d2, boolean bl, Vector vector) {
        double d3;
        Vector<Double> vector2 = new Vector<Double>(10);
        double d4 = Math.pow(10.0, d2);
        int n = 1;
        if (bl) {
            if (d4 <= 3.5) {
                n = d4 > 2.0 ? 2 : (d4 > 1.26 ? 5 : (d4 > 1.125 ? 10 : (int)Math.rint(1.0 / d2)));
            }
        } else {
            n = d4 > 10.0 ? 1 : (d4 > 3.0 ? 2 : (d4 > 2.0 ? 5 : (d4 > 1.125 ? 10 : 100)));
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            d3 = (double)n3 / (double)n * 10.0;
            double d5 = LOG10_SCALE * Math.log(d3);
            if (d5 == Double.NEGATIVE_INFINITY) {
                d5 = 0.0;
            }
            if (vector != null && n2 < vector.size()) {
                while (n2 < vector.size() && (Double)vector.elementAt(n2) < d5) {
                    ++n2;
                }
                if (n2 < vector.size()) {
                    if (Math.abs((Double)vector.elementAt(n2) - d5) > 1.0E-5) {
                        vector2.addElement(new Double(d5));
                    }
                } else {
                    vector2.addElement(new Double(d5));
                }
            } else {
                vector2.addElement(new Double(d5));
            }
            ++n3;
        }
        this.gridCurJuke = 0;
        if (d == -0.0) {
            d = 0.0;
        }
        this.gridBase = Math.floor(d);
        d3 = d - this.gridBase;
        this.gridCurJuke = -1;
        while (this.gridCurJuke + 1 < vector2.size() && d3 >= (Double)vector2.elementAt(this.gridCurJuke + 1)) {
            ++this.gridCurJuke;
        }
        return vector2;
    }

    private double gridRoundUp(Vector vector, double d) {
        double d2 = d - Math.floor(d);
        int n = 0;
        while (n < vector.size() && d2 >= (Double)vector.elementAt(n)) {
            ++n;
        }
        if (n >= vector.size()) {
            return d;
        }
        return Math.floor(d) + (Double)vector.elementAt(n);
    }

    private double gridStep(Vector vector, double d, double d2, boolean bl) {
        if (bl) {
            if (++this.gridCurJuke >= vector.size()) {
                this.gridCurJuke = 0;
                this.gridBase += Math.ceil(d2);
            }
            if (this.gridCurJuke >= vector.size()) {
                return d + d2;
            }
            return this.gridBase + (Double)vector.elementAt(this.gridCurJuke);
        }
        return d + d2;
    }

    private void measureFonts() {
        if (this.labelFont == null) {
            this.labelFont = new Font("Helvetica", 0, 12);
        }
        if (this.superscriptFont == null) {
            this.superscriptFont = new Font("Helvetica", 0, 9);
        }
        if (this.titleFont == null) {
            this.titleFont = new Font("Helvetica", 1, 14);
        }
        this.labelFontMetrics = this.getFontMetrics(this.labelFont);
        this.superscriptFontMetrics = this.getFontMetrics(this.superscriptFont);
        this.titleFontMetrics = this.getFontMetrics(this.titleFont);
    }

    private int numFracDigits(double d) {
        int n = 0;
        while (n <= 15 && d != Math.floor(d)) {
            d *= 10.0;
            ++n;
        }
        return n;
    }

    private int numIntDigits(double d) {
        int n = 0;
        while (n <= 15 && (double)((int)d) != 0.0) {
            d /= 10.0;
            ++n;
        }
        return n;
    }

    private double roundUp(double d) {
        int n;
        if ((d *= Math.pow(10.0, -(n = (int)Math.floor(Math.log(d) * LOG10_SCALE)))) > 5.0) {
            d = 10.0;
        } else if (d > 2.0) {
            d = 5.0;
        } else if (d > 1.0) {
            d = 2.0;
        }
        return d *= Math.pow(10.0, n);
    }

    private void _setYRange(double d, double d2) {
        if (d > d2) {
            d = -1.0;
            d2 = 1.0;
        } else if (d == d2) {
            d -= 0.1;
            d2 += 0.1;
        }
        this.yMin = d - (d2 - d) * 0.05;
        this.yMax = d2 + (d2 - d) * 0.05;
        double d3 = Math.max(Math.abs(this.yMin), Math.abs(this.yMax));
        this.yExp = (int)Math.floor(Math.log(d3) * LOG10_SCALE);
        if (this.yExp > 1 || this.yExp < -1) {
            double d4 = 1.0 / Math.pow(10.0, this.yExp);
            this.yTickMin = this.yMin * d4;
            this.yTickMax = this.yMax * d4;
            return;
        }
        this.yTickMin = this.yMin;
        this.yTickMax = this.yMax;
        this.yExp = 0;
    }

    private int drawLegend(Graphics graphics, int n, int n2) {
        this.imageGC.setFont(this.labelFont);
        int n3 = this.labelFontMetrics.getHeight();
        Enumeration enumeration = this.legendStrings.elements();
        Enumeration enumeration2 = this.legendDatasets.elements();
        int n4 = n2 + n3;
        int n5 = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n6 = (Integer)enumeration2.nextElement();
            if (n6 < 0) continue;
            this.imageGC.setColor(this.ticksColor);
            int n7 = this.labelFontMetrics.stringWidth(string);
            if (n7 > n5) {
                n5 = n7;
            }
            this.imageGC.drawString(string, n - 15 - n7, n4);
            n4 += n3;
        }
        return 22 + n5;
    }

    public void setXRange(double d, double d2) {
        this.xRangeGiven = true;
        this._setXRange(d, d2);
    }

    public void setYRange(double d, double d2) {
        this.yRangeGiven = true;
        this._setYRange(d, d2);
    }

    public void setXLabel(String string) {
        this.xLabel = string;
    }

    public void setYLabel(String string) {
        this.yLabel = string;
    }

    public void drawHGrid() {
        int n = 5;
        int n2 = this.ulx + n;
        int n3 = this.lrx - n;
        this.imageGC.setColor(this.gridColor);
        int n4 = 0;
        while (n4 < this.hGridPixels.size()) {
            MkPixelPoint mkPixelPoint = (MkPixelPoint)this.hGridPixels.elementAt(n4);
            this.imageGC.drawLine(n2, mkPixelPoint.y, n3, mkPixelPoint.y);
            ++n4;
        }
    }

    public void drawVGrid() {
        int n = 5;
        int n2 = this.uly + n;
        int n3 = this.lry - n;
        this.imageGC.setColor(this.gridColor);
        int n4 = 0;
        while (n4 < this.vGridPixels.size()) {
            MkPixelPoint mkPixelPoint = (MkPixelPoint)this.vGridPixels.elementAt(n4);
            this.imageGC.drawLine(mkPixelPoint.x, n2, mkPixelPoint.x, n3);
            ++n4;
        }
    }

    public void drawEmptyPlot() {
        this.clear();
        this.graphIsEmpty = true;
        this._setXRange(-1.0, 1.0);
        this._setYRange(-1.0, 1.0);
        this.drawAxes();
        this.swap();
    }

    public void setHGridVisi(boolean bl) {
        this.hGridVisible = bl;
    }

    public void setVGridVisi(boolean bl) {
        this.vGridVisible = this.hGridVisible;
    }

    public void drawThinLine(long l, long l2, long l3, long l4) {
        this.imageGC.drawLine((int)l, (int)l2, (int)l3, (int)l4);
    }

    public void drawLine(long l, long l2, long l3, long l4) {
        this.imageGC.drawLine((int)l, (int)l2, (int)l3, (int)l4);
    }

    public int getPixelIncrement(double d) {
        if (d > 0.0) {
            return 1;
        }
        if (d < 0.0) {
            return -1;
        }
        return 0;
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.imageGC.drawPolygon(nArray, nArray2, n);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.imageGC.fillPolygon(nArray, nArray2, n);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.imageGC.fillRect(n, n2, n3 + 1, n4 + 1);
    }

    public void drawPoint(long l, long l2, int n) {
        int n2 = (int)l;
        int n3 = (int)l2;
        switch (n) {
            case 0: {
                this.imageGC.fillRect(n2 - 6, n3 - 6, 6, 6);
                return;
            }
            case 1: {
                this.imageGC.fillOval(n2 - 1, n3 - 1, 3, 3);
                return;
            }
            case 2: {
                this.imageGC.fillOval(n2 - this.radius, n3 - this.radius, this.diameter, this.diameter);
                return;
            }
            case 3: {
                this.imageGC.fillOval(n2 - this.radius_new, n3 - this.radius_new, this.diameter_new, this.diameter_new);
                return;
            }
        }
    }

    public void drawText(String string, long l, long l2) {
        int n = (int)l;
        int n2 = (int)l2;
        this.imageGC.drawString(string, n, n2);
    }

    public void drawArc(long l, long l2, long l3, long l4, long l5, long l6) {
        this.imageGC.drawArc((int)l, (int)l2, (int)l3, (int)l4, (int)l5, (int)l6);
    }

    public void fillPolygon(Polygon polygon) {
        this.imageGC.fillPolygon(polygon);
    }

    public void setColor(Color color) {
        this.imageGC.setColor(color);
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    public void setTicksColor(Color color) {
        this.ticksColor = color;
    }

    public void selectShape(int n, int n2) {
    }

    public void moveSelectedShape(double d, double d2) {
    }

    public void deSelectShape(double d, double d2) {
    }

    public void mousePressedNew(int n, int n2) {
        if (this.hasSelectableShapes && n < this.lrx && n > this.ulx && n2 < this.lry && n2 > this.uly) {
            this.selectShape(n, n2);
        }
    }

    public void mouseReleasedNew(int n, int n2) {
        if (this.hasSelectableShapes && n < this.lrx && n > this.ulx && n2 < this.lry && n2 > this.uly) {
            double d = n - this.ulx();
            double d2 = this.lry() - n2;
            d /= this.xScale();
            d2 /= this.yScale();
            this.deSelectShape(d += this.xMin(), d2 += this.yMin());
        }
    }

    public void mouseDraggedNew(int n, int n2) {
        if (this.hasSelectableShapes && n < this.lrx && n > this.ulx && n2 < this.lry && n2 > this.uly) {
            double d = n - this.ulx();
            double d2 = this.lry() - n2;
            d /= this.xScale();
            d2 /= this.yScale();
            this.moveSelectedShape(d += this.xMin(), d2 += this.yMin());
        }
    }

    public void mouseMovedNew(int n, int n2) {
        if (this.hasSelectableShapes) {
            boolean bl = false;
            int n3 = 0;
            while (n3 < this.selectableShapes.size()) {
                Object e = this.selectableShapes.elementAt(n3);
                if (e instanceof MkGeomPoint2D && ((MkGeomPoint2D)e).isVisible == 1 && ((MkGeomPoint2D)e).rect != null && ((MkGeomPoint2D)e).rect.contains(n, n2)) {
                    if (this.getCursor().getType() != 12) {
                        this.setCursor(this.selectCursor);
                    }
                    bl = true;
                }
                if (e instanceof MkGeomVector2D && ((MkGeomVector2D)e).isVisible == 1 && ((MkGeomVector2D)e).head != null && ((MkGeomVector2D)e).head.contains(n, n2)) {
                    if (this.getCursor().getType() != 12) {
                        this.setCursor(this.selectCursor);
                    }
                    bl = true;
                }
                if (e instanceof MkNewGeomPolygon2D && ((MkNewGeomPolygon2D)e).isVisible == 1 && ((MkNewGeomPolygon2D)e).pol != null && ((MkNewGeomPolygon2D)e).pol.contains(n, n2)) {
                    if (this.getCursor().getType() != 12) {
                        this.setCursor(this.selectCursor);
                    }
                    bl = true;
                }
                if (e instanceof MkNewGeomLine2D && ((MkNewGeomLine2D)e).isVisible == 1 && ((MkNewGeomLine2D)e).pol != null && ((MkNewGeomLine2D)e).pol.contains(n, n2)) {
                    if (this.getCursor().getType() != 12) {
                        this.setCursor(this.selectCursor);
                    }
                    bl = true;
                }
                if (e instanceof MkRenderer2D && n < this.lrx && n > this.ulx && n2 < this.lry && n2 > this.uly) {
                    if (this.getCursor().getType() != 12) {
                        this.setCursor(this.selectCursor);
                    }
                    bl = true;
                }
                ++n3;
            }
            if (!bl && this.getCursor().getType() != 0) {
                this.setCursor(this.normalCursor);
            }
        }
    }
}

